(function($) {

    // -- default settings
    var settings = {
        chartTitle: 'Testing',
        renderTo: 'body',
        width: 800,
        height: 900,
        url: null,
        zoom: true,
        layoutAlign: 'left',
        loadingText: "creating topology...",
        min_zoom: 0.2,
        max_zoom: 2,
		
        default_zoom: 1,
        gravity: 0,
        charge: function(d, i) {
            return i ? 0 : -2000;
        },
        enableFitLayout: true,
        linkDistance: 3,
        initialX: null,
        initialY: null,
        zoomObj: d3.behavior.zoom(),
        collideLayout: false,
        draggable: true,
		pageURL:null,
		newWindow:false,
        margin: {
            top: -8,
            right: -8,
            bottom: -8,
            left: -8
        }
    };
    var data, loading, connectedNodes, timer, mousedownsearch = false,
        segmentName1, oldSgt, newSgt, segmentName, movementX, movementY, HX, HY, LX, LY,
        hideScrollbar = true,
        translateZ, scaleZ, svgScale = {},
        svg, body = d3.select("body"),
        toolTip, header, slider_tooltip, duration = 500,
        force, font12px = 12,
        font11px = 11,
        font9px = 9,
        font10px = 10,
		scale,layout={},
		//SVG ELEMENTS
		groupNodes, serverIcons, start_text, start_text_stroke,componentDisplay_name,componentDisplay_name_stroke, component_name_topo, component_name_topo_stroke, patch, start_text_stroke, transition_msg_stroke, transition_msg, path,t_path, component_value, dd_icon,state_indicator,component_ux_icons,groupedtextUp,groupedtextDown,transition_msg_call,line_transition_icongrp,serverIconsColor,defaultLineValue=1,hoverLineValue=3,stateiconWidth = 16,stateiconHeight = 16,updatePosition,grp_in_link,marker,component_value_time_stroke,component_value_percent_stroke,component_value_time,component_value_percent,componentDisplay_name_stroke;

    // -- rendering data 
    $.fn.renderDiagram = function(options) {
        var options = $.extend({}, settings, options);

        // -- Force layout object
        force = d3.layout.force();
        d3.json("#", function(error, graph) {

            //DATAS FALLIN 
            var graph = options.url;
            xScale = d3.scale.linear().domain([0, options.width]);
            yScale = d3.scale.linear().domain([0, options.height]);
            var tip, i = 0,timeout;

            //checking for error
            if (typeof graph != 'object' || graph == null || graph == "undefine") {
                d3.select(options.renderTo).text('MAY BE ERROR IN YOUR DATA');
            }

            this.nodes = graph.nodes;
            this.links = graph.links;
			
			console.log('-->NODES',this.nodes);
			console.log('-->links',this.links);
            // -- Forming the force layout
			options.linkDistance = (options.width + options.height) / this.nodes.length;
            var k = Math.sqrt(this.nodes.length / (options.width * options.height));

            force
            .nodes(this.nodes)
            .links(this.links)
            .gravity(100 * k)
            .charge(-10 / k)
			 .linkStrength(function (d) {
					return k / this.nodes.length;
			})
            .linkDistance(options.linkDistance)
            .size([options.width, options.height])
            .start();

            // -- finding the max and min of nodes in data
            HX = d3.max(this.nodes, function(d) {
                return d.x;
            });
            HY = d3.max(this.nodes, function(d) {
                return d.y;
            });
            LX = d3.min(this.nodes, function(d) {
                return d.x;
            });
            LY = d3.min(this.nodes, function(d) {
                return d.y;
            });

            if (options.layoutAlign == 'center') {
                movementX = (options.width - HX) / 2;
                movementY = (options.height - HY) / 2;

            } else if (options.layoutAlign == 'left') {
                movementX = 0;
                movementY = 0;
            } else {
                movementX = 0;
                movementY = 0;
            }


            //word ellipsis function
			function wordTruncate( str, max, sep ) {
				max = max || 10;
				var len = str.length;
				if(len > max){
					sep = sep || "...";
					var seplen = sep.length;
					if(seplen > max) { return str.substr(len - max) }

					var n = -0.5 * (max - len - seplen);
					var center = len/2;
					return str.substr(0, center - n) + sep + str.substr(len - center + n);
				}
				return str;
			}

            //plonk function
            function plonk(selection, state) {
				plonktimer;
                var duration,randomDuration,minopacity,maxopacity;
                switch (state) {
                    case "SLOW":
                        duration = 800;
						minopacity = 1;
						maxopacity =0.6;
						randomDuration = (Math.random() + 2) * duration;
                        break;
                    case "NORMAL":
                        duration = 5000;
						minopacity = 0.8;
						maxopacity =1;
						randomDuration = (Math.random() + 2) * duration;
                        break;
                    case "ERROR":
                        duration = 50;
						minopacity = 0.1;
						maxopacity =1;
						randomDuration = (Math.random() + 2) * duration;
                        break;
                    case "STALLED":
                        duration = 4000;
						minopacity = 0.3;
						maxopacity =1;
						randomDuration = (Math.random() + 2) * duration;
                        break;
                    default:
                        duration = 9000;
						randomDuration = (Math.random() + 2) * duration;

                }
				  selection.transition()
				  .duration(duration)
				  .tween("style:opacity", function() {
					var i = d3.interpolateString(maxopacity, minopacity);
					return function(t) { selection.style("opacity", i(t)); };
				  })
				  .transition()
				  .tween("style:opacity", function() {
					var i = d3.interpolateString(minopacity, maxopacity);
					return function(t) { selection.style("opacity", i(t)); };
				  });
                
				var plonktimer = setTimeout(function() { plonk(selection, state); }, randomDuration);
                delete plonktimer;
            }

            // -- Force drag event
            var drag = force.drag().on("drag", dragged).on("dragstart", dragStart).on("dragend", dragEnd);
            var selectedItem, selectedItemX, selectedItemY;

            function dragStart(d,evt) {
                d3.event.sourceEvent.stopPropagation();
                //d3.select(this).classed("fixed", d.fixed = true);
                if (d3.select(".tooltip")) {
                    d3.select(".tooltip").remove();
                }
                d3.select(this).style('cursor', 'move');
				
				
            }

            function dragged(d) {
                if (d3.select(".toolTip")) {
                    toolTip.style("display","none");
                }
				this.parentNode.appendChild(this);

                selectedItem = d3.transform(d3.select(this).attr("transform"));
                var bbox = d3.select(this).node().getBBox(),
                    bbox_width = bbox.width * options.zoomObj.scale(),
                    bbox_height = bbox.height * options.zoomObj.scale();


                force.drag().origin(function() {
                    t = selectedItem.translate;
                    return {
                        x: t[0],
                        y: t[1]
                    };
                }).on("drag.force", function() {
                    d3.select(this).attr("transform", "translate(" + d3.event.dx + "," + d3.event.dy + ")");
                });
				 				
                if (d3.event.sourceEvent.pageX <= bbox_width/2 || d3.event.sourceEvent.pageX >= options.width - bbox_width || d3.event.sourceEvent.pageY <= bbox_height + 80 || d3.event.sourceEvent.pageY >= options.height + 80 - bbox_height) {
					
                    force.stop();
                } else {
					 
                    d.px += d3.event.dx;
                    d.py += d3.event.dy;
                    d.x += d3.event.dx;
                    d.y += d3.event.dy;
                    force.resume();
                }
                force.tick();
            }

            function dragEnd(d) {
                d3.select(this).style('cursor', 'pointer');
                force.tick();
                force.resume();
            }
            grp_the_link = d3.select('.pitch').selectAll('g.g_node').data(graph.links).enter();

             grp_in_link =    grp_the_link.append("svg:g");
                
                
			//grp_the_link.exit().remove();

			//grp_the_link = grp_the_link.enter();
			t_path = grp_in_link.attr("class", "tlinks")
				.append("svg:line")
                .attr("stroke-linecap", "round")
                .style("stroke-width", function(d) {
                    return defaultLineValue;
                }).attr("class",function(d){return "tlink"});
			
            path = grp_in_link.attr("class", "glinks")
				.append("svg:line")
                .attr("stroke-linecap", "round")
                .style("stroke-width", function(d) {
                    return defaultLineValue;
                }).attr("class",function(d){return "link"});

			
		


           /*path.filter(function(d) {
                return d.arrow == true;
            }).attr("marker-end", function(d) {
				
                return "url(#default)"
            });*/
			t_path.filter(function(d) {
                return d.arrow == true;
            }).attr("marker-end", function(d) {
                return "url(#default)"
            });
			
		
            
			
			line_transition_icongrp = grp_in_link.filter(function(d){
						return d.drillDownLink
				})
                .append('svg:g')
				//.attr("data-qtip",function(d){return "EXPERIENCE: "+d.lineExperience})
                .attr("class", function(d) {
                    return "state_uxgrp";
                }).on('click',function(d){
					
					if(d.drillDownLink){
						str = d.drillDownLink;
						var guidnode = str.substring(0,str.indexOf(","));
						var url = str.substring(str.indexOf(",")+1);
						window.parent.baseStackTrace(url,guidnode,'topologyBuildWindow')
					}
				});
			
            line_transition_icon =     line_transition_icongrp
                .append('svg:image')
				.attr('height',stateiconWidth)
				.attr('width', stateiconHeight)
                .attr("class", function(d) {
                    return "state_ux_"+d.lineExperience+" state_ux";
					
                })
                .attr("xlink:href", function(d) {
					
                    switch (d.lineExperience) {
                        case "SLOW":
                            return "/final/images/AcknowledgementOptions/state_LOW.svg";
                            break;
                        case "NORMAL":
                            return "/final/images/AcknowledgementOptions/state_GOOD.svg";
                            break;
                        case "ERROR":
                            return "/final/images/AcknowledgementOptions/state_HIGH.svg";
                            break;
                        case "STALLED":
							return "/final/images/AcknowledgementOptions/state_INTERMEDIATE.svg";
                            break;
                        default:
                            return null


                    }
                }).attr("x", function(d) {
                    return - stateiconWidth-5;
                })
                .attr("y", function(d) {
                    return 12;
                });
			transition_msg_stroke = line_transition_icongrp
                .append("text").attr('class', 'transition_msg_stroke transition_msg_stroke text_stroke font11px')
                .attr('text-anchor', 'start')
                .style("font-size", font11px + "px")
                .text(function(d) {
                    if (d.lineCall) return d.lineCall;
                });

		transition_msg = line_transition_icongrp
                .append("text").attr('class', 'transition_msg font11px')
                .style("font-size", font11px + "px")
                .attr('text-anchor', 'start')
                .text(function(d){if(d.lineCall) return d.lineCall});


		transition_msg_call_stroke = line_transition_icongrp
                .append("text").attr('class', 'transition_msg_call_stroke text_stroke font11px')
                .style("font-size", font11px + "px")
                .attr('text-anchor', 'start')
                .attr('dy', '1.2em');
               //.text(function(d){if(d.lineValue) return d.lineValue});
		
				transition_msg_call_stroke.append('tspan').text(function(d){return d.lineTime});
				transition_msg_call_stroke.append('tspan').text(function(d){return d.linePercent});
            
			
		
		transition_msg_call = line_transition_icongrp
                .append("text").attr('class', 'transition_msg_call font11px')
                .style("font-size", font11px + "px")
                .attr('text-anchor', 'start')
                .attr('dy', '1.2em');
                transition_msg_call.append('tspan').text(function(d){return d.lineTime});
				transition_msg_call.append('tspan').text(function(d){return d.linePercent}); // --COn

            // -- draggable
            if (options.draggable) {
                groupNodes = d3.select('.pitch')
                    .selectAll('g.g_node')
                    .data(this.nodes);

                    groupNodes.enter()
                    .append('g')
					.attr('id',function(d,i){ return "btmnode_"+i;})
					.attr('class',function(d){if(d.compName == "User"){ return "User"}})
                    .classed('g_node', true).attr("transform", function(d) {
                         return "translate(" + d.x + "," + d.y + ")";
                    }).call(drag);


            } else {

                groupNodes = d3.select('.pitch')
                    .selectAll('g.g_node')
                    .data(this.nodes);

                     groupNodes.enter()
                    .append('g')
					.attr('id',function(d,i){ return "btmnode_"+i;})
					
                    .classed('g_node', true).attr("transform", function(d) {
                        return "translate(" + d.x + "," + d.y + ")";
                    });
 
            }

            patch = groupNodes
                .append("circle")
                .attr("class", "patch")
                .attr("r", function(d) {
                    return 14;
                })
                .attr("cx", function(d) {
                    return 0;
                })
                .attr("cy", function(d) {
                    return 0;
                })
                .attr("x", function(d) {
                    return -8;
                })
                .attr("y", function(d) {
                    return -8;
                });

			//-- CONT
			groupedtextUp = groupNodes.filter(function(d){
					return d.nodeTime != 'None' || d.nodePercent != 'None' || d == 'undefined' || d == null;
				}).append("svg:g").attr("class","textgrpon").attr("transform", function(d) {
                         return "translate(" + 0 + "," + -31 + ")";
                    });
						 
			groupedtextDown = groupNodes.append("svg:g").attr("class","textgrpondown").attr("transform", function(d) {
                         return "translate(" + 0 + "," + 41 + ")";
             });
				

            component_value_stroke = groupedtextUp
                .append('svg:text')
                .style("font-size", font11px + "px")
                .attr('class', 'component_value_stroke text_stroke font11px')
                .attr('text-anchor', 'middle');
                
			
			component_value_time_stroke = component_value_stroke.append('svg:tspan')
				.text(function(d) {
                    if (d.nodeTime) {
                        return d.nodeTime
                    }
                });
			component_value_percent_stroke = component_value_stroke.append('svg:tspan')
				.text(function(d) {
                    if (d.nodePercent) {
                        return d.nodePercent;
                    }
                });
            component_value = groupedtextUp
                .append('text')
                .style("font-size", font11px + "px")
                .attr('class', 'component_value font11px')
                .attr('text-anchor', 'middle');
			
			component_value_time= 	component_value.append('svg:tspan')
				.text(function(d) {
                    if (d.nodeTime) {
                        return d.nodeTime
                    }
                });
			component_value_percent=component_value.append('svg:tspan')
				.text(function(d) {
                    if (d.nodePercent) {
                        return d.nodePercent;
                    }
                });
			component_isAsync_stroke = groupedtextUp.filter(function(d){ return d.isAsync == true})
                .append('svg:text')
                .style("font-size", font11px + "px")
                .attr('class', 'font9px component_isAsync_stroke text_stroke font11px')
                .attr('text-anchor', 'middle')
                .text(function(d) {
                    if (d.isAsync == true) {
                        return "[Async]"
                    } else {
                        return ""
                    }
                });

            component_isAsync = groupedtextUp.filter(function(d){ return d.isAsync == true})
                .append('svg:text')
                .attr('class', 'component_isAsync font11px')
                .style("font-size", font11px + "px")
                .attr('text-anchor', 'middle')
                .text(function(d) {
                    if (d.isAsync == true) {
                        return "[Async]"
                    } else {
                        return ""
                    }
                });
				
//-- component_ux_icons

			component_ux_icons = groupedtextUp
				.filter(function(d){
					return d.nodeExperience != 'None' || d.nodeExperience == 'undefined' || d.nodeExperience == null;
				})
                .append('svg:image')
				.attr('height',stateiconHeight)
				.attr('width', stateiconWidth)
                .attr("class", function(d) {
                    return "state_ux_"+d.nodeExperience+" state_ux";
					
                })
                .attr("xlink:href", function(d) {
                    switch (d.nodeExperience) {
                        case "SLOW":
                            return "/final/images/AcknowledgementOptions/state_LOW.svg";
                            break;
                        case "NORMAL":
                            return "/final/images/AcknowledgementOptions/state_GOOD.svg";
                            break;
                        case "ERROR":
                            return "/final/images/AcknowledgementOptions/state_HIGH.svg";
                            break;
                        case "STALLED":
							return "/final/images/AcknowledgementOptions/state_INTERMEDIATE.svg";
                            break;
                        default:
                            return null


                    }
                });
			
            
			
			component_nodeText_stroke = groupedtextUp.filter(function(d){return d.nodeText !="None"})
                .append('svg:text')
                .attr('class', 'component_nodeText text_stroke font11px')
                .style("font-size", font11px + "px")
                .attr('text-anchor', 'middle')
                .text(function(d) {
						  return d.nodeText
                });
			 component_nodeText = groupedtextUp.filter(function(d){return d.nodeText != "None"})
                .append('svg:text')
                .attr('class', 'component_nodeText font11px')
                .style("font-size", font11px + "px")
                .attr('text-anchor', 'middle')
                .text(function(d) {
							return d.nodeText;		
						  
                });
			
            

			serverIconsColor = groupNodes.filter(function(d){ return d.nodeExperience != 'None'})
                .append('svg:image')
                .attr('class', 'serverimgColor')
                .attr('height', 48)
                .attr('width', 48)
                .attr("xlink:href", function(d) {
				
					str = d.nodeExperience;
                    return "/final/images/component_icons/AcknowledgementOptions/"+d.serverType+"_"+str.toUpperCase()+".svg"
                })
                .attr("x", function(d) {
                    return -24;
                })
                .attr("y", function(d) {
                    return -24;
                });

            serverIcons = groupNodes
                .append('svg:image')
                .attr('class',function(d){ return  'serverimg'+d.nodeExperience})
                .attr('height', 48)
                .attr('width', 48)
                .attr("xlink:href", function(d) {
                    return "/final/images/component_icons/AcknowledgementOptions/" + d.serverType + ".svg"
                })
                .attr("x", function(d) {
                    return -24;
                })
                .attr("y", function(d) {
                    return -24;
                });
			
			componentDisplay_name_stroke = groupedtextDown
			.filter(function(d){return d.displayName != "None"})
			.append("text").text(function(d){
				return d.displayName
			}).attr('class', 'componentDisplay_name_stroke text_stroke font11px').attr('text-anchor', 'middle');

			componentDisplay_name = groupedtextDown
			.filter(function(d){return d.displayName != "None"})
			.append("text").text(function(d){
				return d.displayName
			}).attr('class', 'componentDisplay_name font11px').attr('text-anchor', 'middle');
			

            component_name_topo_stroke = groupedtextDown.append("text").each(function(d) {
                    var arr = d.compName.split("#$#");
                    if (arr != undefined) {
                        for (i = 0; i < arr.length; i++) {
							Cnumber =  arr[0].length;
								d3.select(this).append("tspan")
                                .text(function(d,t){
									if(i==1){
										
										return wordTruncate(arr[1],Cnumber);
									}else if( i ==2)
									{		
											
											return wordTruncate(arr[2],Cnumber);
											
									}else{
										return arr[0]
									}
									
								})
                                .attr("dy", i ? "1.2em" : 0)
                                .attr("x", 0)
                                .attr("text-anchor", "middle")
                                .attr("class", "tspan" + i);
							
                        }
                    }
                })
				//.text(function(d){return d.compName;/*wordTruncate(d.compName,20)*/ })
				 .attr('text-anchor', 'middle')
				.attr("class", "component_name_topo_stroke text_stroke font10px");

			

            component_name_topo = groupedtextDown.append("text").each(function(d) {
                    var arr = d.compName.split("#$#");
                    if (arr != undefined) {
                        for (i = 0; i < arr.length; i++) {
							Cnumber =  arr[0].length;
                            d3.select(this).append("tspan")
                                .text(function(d,t){
									if(i==1){
										d3.select(this).attr('data-qtip',arr[1]);
										return wordTruncate(arr[1],Cnumber);

									}else if(i==2)
									{		d3.select(this).attr('data-qtip',arr[2]);
											return wordTruncate(arr[2],Cnumber);
									}else{d3.select(this).attr('data-qtip',arr[0]);
										return arr[0]
									}
									
								})
                                .attr("dy", i ? "1.2em" : 0)
                                .attr("x", 0)
                                .attr("text-anchor", "middle")
                                .attr("class", "tspan" + i);

                        }
                    }
                })
				//.text(function(d){return d.compName;/*wordTruncate(d.compName,20)*/ })
				 .attr('text-anchor', 'middle')
				.attr("class", "component_name_topo font10px");
			
            
			
			start_text = groupNodes.filter(function(d){return d.isStartJvm == true}).append('svg:image')
							.attr("class", "start_img")
						    .attr("x", function(d) { return -22;})
							.attr("y", function(d) { return 16;})
						    .attr('height',34)
							.attr('width', 48)
							.attr("xlink:href", function(d) {
								return "/final/images/AcknowledgementOptions/start.svg";
							});
            

			var widthArry = [];
			var widthArry1 = [];
			var widthArry2 =[];
			component_value_time_stroke.each(function(){
						
						widthArry.push(d3.select(this).node().getBBox());


					});
			groupNodes.each(function(){
						
						widthArry1.push(d3.select(this).node().getBBox());

					});
			line_transition_icongrp.each(function(){
					widthArry2.push(d3.select(this).node().getBBox());
			});


			groupNodes.exit().remove();

			//-- updating position 
			updatePosition = function(){
					
				
				
				groupedtextDown.attr("transform", function(d) {
						if(d.isStartJvm == true){
							return "translate(" + 0 + "," + 55 + ")";
						}else{
							return "translate(" + 0 + "," + 35 + ")";
						}
                        
                });

				groupedtextUp.attr("transform", function(d) {
						if(d.isAsync == true){
							return "translate(" + 0 + "," + -28 + ")";
						}else{
							return "translate(" + 0 + "," + -18 + ")";
						}
                        
                });
				componentDisplay_name.attr("x", function(d) {
                    return 0;
                }).attr("y", function(d) {
                    return 0 / options.zoomObj.scale() ;
                });
				componentDisplay_name_stroke.attr("x", function(d) {
                    return 0;
                }).attr("y", function(d) {
                    return 0 / options.zoomObj.scale() ;
                });
				component_name_topo_stroke.attr("x", function(d) {
                    return 0;
                }).attr("y", function(d) {
                    if(d.compName == "User"){
						return 0/ options.zoomObj.scale() ;
					}else{
						return 13/ options.zoomObj.scale() ;
					}
                });
				component_name_topo.attr("x", function(d) {
                    return 0;
                }).attr("y", function(d) {
					if(d.compName == "User"){
						return 0/ options.zoomObj.scale() ;
					}else{
						return 13/ options.zoomObj.scale() ;
					}
                    
                });

				component_nodeText.attr("x", function(d) {
                    return 0;
                }).attr("y", function(d) {
                    return -31 / options.zoomObj.scale() ;
                });
				component_nodeText_stroke.attr("x", function(d) {
                    return 0;
                }).attr("y", function(d) {
                    return -31 / options.zoomObj.scale() ;
                });
				component_value_stroke.attr("x", function(d) {
                    return 0;
                }).attr("y", function(d) {
                    return -15 / options.zoomObj.scale() ;
                });
				component_value.attr("x", function(d) {
                    return 0;
                }).attr("y", function(d) {
                    return -15 / options.zoomObj.scale() ;
                });
				component_isAsync_stroke.attr("x", function(d) {
                    return 0;
                }).attr("y", function(d) {
                    return -2 / options.zoomObj.scale() ;
                });
				component_isAsync.attr("x", function(d) {
                    return 0;
                }).attr("y", function(d) {
                    return -2 / options.zoomObj.scale() ;
                });
				component_ux_icons.attr("x", function(d,i) {
					
                    return (widthArry[i].x - stateiconWidth) / options.zoomObj.scale();
                }).attr("y", function(d) {
                    return -27 / options.zoomObj.scale() ;
                });

				path.attr("x1", function(d) { return d.source.x; })
				.attr("y1", function(d) { return d.source.y; })
				.attr("x2", function(d) { return d.target.x; })
				.attr("y2", function(d) { return d.target.y; });

				t_path.attr("x1", function(d,i) { return d.source.x; })
				.attr("y1", function(d,i) { return d.source.y; })
				.attr("x2", function(d,i) { return d.target.x + (d.source.x/2 - d.target.x/2) / 2 ; })
				.attr("y2", function(d,i) { return d.target.y + (d.source.y/2 - d.target.y/2) / 2 ; });
				
				
				line_transition_icongrp.attr("transform", function(d,i) {
                    return "translate(" + parseInt(d.source.x - (widthArry2[i].width/ options.zoomObj.scale() / 2)  + (d.target.x - d.source.x) / 2) + "," + parseInt(d.source.y - (widthArry2[i].height/ 2)  + (d.target.y - d.source.y) / 2) + ")";
                });


				
				line_transition_icon.attr("x", function(d) {
                    return 1 / options.zoomObj.scale();
                })
                .attr("y", function(d) {
                    return 11 / options.zoomObj.scale();
                });
				transition_msg_call_stroke.attr("x", function(d) {
                    return 20/ options.zoomObj.scale() ;
                })
                .attr("y", function(d) {
                    return 10 / options.zoomObj.scale();
                });
				transition_msg_call.attr("x", function(d) {
                    return 18/ options.zoomObj.scale() ;
                })
                .attr("y", function(d) {
                    return 10 / options.zoomObj.scale();
                });
				transition_msg.attr("x", function(d,i) {
                    return  20/ options.zoomObj.scale();
                })
                .attr("y", function(d) {
                    return 10 / options.zoomObj.scale();
                });
				transition_msg_stroke.attr("x", function(d,i) {
                    return  20/ options.zoomObj.scale();
                })
                .attr("y", function(d) {
                    return 10 / options.zoomObj.scale();
                });

                groupNodes.attr("transform", function(d) {
                    return "translate(" + d.x   + "," + d.y + ")";
                });
				
				
				/*component_ux_icons.attr("x", function(d,i) { 
					return  parseInt((widthArry[i].x / options.zoomObj.scale()) - d3.select(this).node().getBBox().width);
					
				}).attr("y", function(d,i) { 
					 if (d.isAsync == true) {
						 var currentVal = -60;
                        if(options.zoomObj.scale() > 1.2){
							currentVal = parseInt(widthArry[i].y)-(options.zoomObj.scale() * - 1.5);
						}
						return currentVal;

                    } else {
						
						var currentVal = -45;
						if(options.zoomObj.scale() > 1.2){
							currentVal = parseInt(widthArry[i].y)-(options.zoomObj.scale() * - 1.5);
						}
                        return currentVal;
                    }
					
					
					})*/


			
			}

            // -- Tick function
            force.on("tick", function(e) {
				 if (options.collideLayout) {
                    groupNodes.each(collide(0.4));
                }
                path.each(function() {
                    this.parentNode.insertBefore(this, this);
                }); //IE 
				updatePosition();
				
				
            });
		
			
			
			//Todo
			
			 layout.graphBounds = function() {
                var x = Number.POSITIVE_INFINITY,
                    X = Number.NEGATIVE_INFINITY,
                    y = Number.POSITIVE_INFINITY,
                    Y = Number.NEGATIVE_INFINITY;
                item = d3.selectAll(".g_node").node().getBBox();
				groupNodes.each(function(v) {
					//alert(this.getBBox());
					x = Math.min(x, v.x - this.getBBox().width * options.zoomObj.scale());
                    X = Math.max(X, v.x + this.getBBox().width * options.zoomObj.scale());
                    y = Math.min(y, v.y - this.getBBox().height * options.zoomObj.scale());
                    Y = Math.max(Y, v.y + this.getBBox().height * options.zoomObj.scale());
				});

               /* d3.select('.pitch').selectAll(".g_node").each(function(v) {
                    x = Math.min(x, v.x - item.width * options.zoomObj.scale());
                    X = Math.max(X, v.x + item.width * options.zoomObj.scale());
                    y = Math.min(y, v.y - item.height * options.zoomObj.scale());
                    Y = Math.max(Y, v.y + item.height * options.zoomObj.scale());
                });*/
                return {
                    x: x,
                    X: X,
                    y: y,
                    Y: Y                                                                                                                                                                                                                                           
                };
            }
			
			
			//-- default loading positions as circle
             this.nodes.forEach(function(d, i) {
				force.stop();
				var ch = options.height  - options.margin.bottom + options.margin.top,cw=options.width - options.margin.left + options.margin.right ,b = layout.graphBounds(),
				nodes = [], 
				//NEARLY TRICK :(
				radius = force.nodes().length * ( 48 /2) *options.zoomObj.scale(),
				angle,x,y,i,translateX,translateY,w,h,scale,svg=d3.select('.svgparentTag');

				force.nodes().forEach(function(d,i){
					//alert(i)
					w = b.X - b.x,
                    h = b.Y - b.y,
                    scale = Math.min(cw / w, ch / h),
                    translateX = (-b.x  * scale + (cw / scale - w) * scale / 2),
                    translateY = (-b.y * scale + (ch / scale - h) * scale / 2);
					angle = (i / (force.nodes().length-force.nodes().length/2)) * Math.PI;
					
					x = -(radius + options.width/force.nodes().length) * Math.cos(angle);
					y = (radius + options.height/force.nodes().length) * Math.sin(angle);

					nodes.push({'id': i, 'x': x, 'y': y});
					
				//});

				
				//force.nodes().forEach(function(d,i){
					
					
					d.px = nodes[i].x ;
					d.py = nodes[i].y ;
					d.x  = nodes[i].x;
					d.y  = nodes[i].y;
				
				});
				if(i == 0){
					
					options.zoomObj.translate([options.width/2, options.height/2]).scale(options.default_zoom).event(svg);
						
					//$("#fit").click();
				}else{
					options.zoomObj.translate([translateX, translateY]).scale(scale).event(svg);
				};
				
				force.start();
				force.tick();
				//$("#fit").click()
              
                d.fixed = true;
				
               
				
                
            });
			
			layout.circularLayoutFn = function(){
				force.stop();
				var nodes = [], 
				radius = force.nodes().length * 48 *options.zoomObj.scale(),
				angle,x,y,i;
				
				force.nodes().forEach(function(d,i){
					
					
					angle = (i / (force.nodes().length-force.nodes().length/2)) * Math.PI;
					x = - radius * Math.cos(angle) ;
					y = radius * Math.sin(angle) ;

					min_angleX = Math.max(x);
					max_angleX = Math.min(x);
					min_angleY = Math.max(y);
					max_angleY = Math.min(y);

					random_angleX =Math.floor((Math.random() * max_angleX )+ min_angleX);
					random_angleY =Math.floor((Math.random() * max_angleY) + min_angleY);

					nodes.push({'id': i, 'x': x, 'y': y});
					d.px = nodes[i].x ;
					d.py = nodes[i].y ;
					d.x  = nodes[i].x;
					d.y  = nodes[i].y;

				});


				
				force.start();
				force.tick();
				$("#fit").click();
			
			}
           /* dd_icon
                .on("mouseenter", function(d) {
                    if (d.drillDownLink != "undefined" && d.drillDownLink != null) {
                        // -- fade and show the icon
                        parentNode = d3.select(this).node().parentNode;
                        d3.select(parentNode).select('.serverimg').style("opacity", "0.3");
                        d3.select(this).style("opacity", "0.9");
                        delete parentNode;

                    }
                }).on("mousemove", function(d) {


                }).on("mouseleave", function(d) {
                    if (d.drillDownLink != "undefined" && d.drillDownLink != null) {
                        // -- fade and show the icon
                        parentNode = d3.select(this).node().parentNode;
                        d3.select(parentNode).select('.serverimg').style("opacity", "1");
                        d3.select(this).style("opacity", "0.3");
                        delete parentNode;

                    }
                });*/

				/*serverIcons
                .on("mouseenter", function(d) {

						
                    if (d.drillDownLink != "undefined" && d.drillDownLink != null) {
                        // -- fade and show the icon
                        parentNode = d3.select(this).node().parentNode;
                        d3.select(this).style("opacity", "0.5");
                        d3.select(parentNode).select('.ddicon_img').style("opacity", "0.9");
                        delete parentNode;
						   
								}

                }).on("mousemove", function(d) {


                }).on("mouseleave", function(d) {
					//toolTip.transition().duration(500).style("opacity", 0);  
                    if (d.drillDownLink != "undefined" && d.drillDownLink != null) {
                        // -- fade and show the icon
                        parentNode = d3.select(this).node().parentNode;
                        d3.select(this).style("opacity", "1");
                        d3.select(parentNode).select('.ddicon_img').style("opacity", "0.5");
                        delete parentNode;
						
                    }
                });*/
			
			
			groupNodes.each(function(d,i){
				
				if(d.compName == "User"){
					
					d3.select(this).on('click',function(){
						if (d3.event.defaultPrevented) return;
						var offset = $('.tooltipx').offset();
							var position = $('.tooltipx').position();
							var tWidth = $('.tooltipx').width();
							var tHeight = $('.tooltipx').height();

							var left = event.pageX -  offset.left - tWidth-30;
							var top = event.pageY -  offset.top - tHeight -30;
							if(event.pageX <=tWidth + 80){
								left = event.pageX -  offset.left + 30;
								
							}
							if(event.pageY <= tHeight + 80){
								top = event.pageY -  offset.top + 30;
							}
							console.log(graph.userTooltip);
							var arrkey=[];
							var arrval= [];
							for (keys in graph.userTooltip)
							{
								arrkey.push(keys);
								arrval.push(graph.userTooltip[keys]);
							}

							 var color;
							 switch (arrval[2]) {

								case "Slow":
									color=  "#ccc100";
									break;
								case "Healthy":
									color= "#0c9a12";
									break;
								case "Error":
									color= "#cd0f0f";
									break;
								case "Stalled":
									color= "#fa9d1c";
									break;
								default:
									color=null


							}
							//graph.userTooltip.nodeDatas
							toolTip.style("display","block");
							titleHTML = "<div class='x-tool' style='text-align:right; margin: 0px;position:absolute;right:10px;top:5px'><img id='tooltoolEl' src='data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==' class='x-tool-close' role='presentation'></div><div style='text-transform: uppercase;'>"+graph.userTooltip.title+"</div><div style='float:left;margin-right:18px;text-transform: uppercase;'>"+arrkey[2]+"&nbsp;:&nbsp;<span  style='vertical-align:super;border-radius:5px;background:"+color+";font-size:0px;padding:5px;'  class="+color+">&nbsp;</span>&nbsp;"+arrval[2]+"</div><div style='float:right;text-transform: uppercase;'>"+arrkey[1]+"&nbsp;:&nbsp;"+arrval[1]+"</div><div style='clear:both'></div>";
							toolTip.html("<div class='tooltiptitle'>"+titleHTML+"</div><div  style='margin:0px 10px 10px 10px'><table class='btmuserdata'><thead></thead><tbody></tbody></table></div>");
							
							/*d3.select('.data').selectAll('.datatable').data(graph.userTooltip.nodeDatas).enter().append('div').text(function(d){
									return d.compName
							});*/

							d3.select('#tooltoolEl').on('click',function(){toolTip.style("display","none")});
							createTableHead = d3.select('.btmuserdata thead').selectAll('tr');
							createTableHead
							.append('tr')
							.data(function(d,i){return d3.keys(graph.userTooltip.nodeDatas[i])})
							.enter()
							.append('th')
							.text(function(d,i){return d});

							createTablebody = d3.select('.btmuserdata tbody').selectAll('tr')
							.data(function(d,i){return graph.userTooltip.nodeDatas })
							.enter()
							.append('tr');
							
							var dollar = createTablebody.selectAll('td').data(function(d){return d3.values(d)}).enter().append("td").append('div').html(function(d,i){
								
								if(i == 3){
									str = d;
									var guidnode = str.substring(0,str.indexOf(","));
									var url = str.substring(str.indexOf(",")+1);
									//window.parent.baseStackTrace(url,guidnode,'topologyBuildWindow')
									return '<img data='+d+' data-qtip="Drilldown into Business Transaction Topology" data-qclass="yellowTip" src="/final/images/clear.png" class="iconDiagnosis" style="cursor:pointer">';

								}else{
									return d
								}
								
							});
							
							
							$('.tooltipx').css({"top":top+"px","left":left+"px"});
							$('.tooltipx').css({"top":""+"px","left":""+"px"});
							$(".tooltipx .tinput").focus();
					});
				}else{
					d3.select(this).on('click',function(){
					if (d3.event.defaultPrevented) return;
					if(d.drillDownLink){
							str = d.drillDownLink;
							var guidnode = str.substring(0,str.indexOf(","));
							var url = str.substring(str.indexOf(",")+1);
							window.parent.baseStackTrace(url,guidnode,'topologyBuildWindow');
							}else{
								return false;
							}
					});
				}
					
			});
			//table ddicons click
			$('body').on('click','.iconDiagnosis',function(d,i){
				str = $(this).attr('data');
				var guidnode = str.substring(0,str.indexOf(","));
				var url = str.substring(str.indexOf(",")+1);
				window.parent.baseStackTrace(url,guidnode,'topologyBuildWindow')
				
			});
			
			groupNodes.on("mouseenter", function(d){

				/*toolTip.style("display","none");
				$('.tooltipx').css({"top":"","left":""});
							if(d.compName || d.state || d.isManaged || d.CompTooltip){
							var borderColor,
							health, healthHtml,startContent;
							switch (d.state) {
								case "SLOW":
									borderColor ="#fe7d00";
									health="SLOW";
									break;
								case "NORMAL":
									borderColor= "#289b1f";
									health="NORMAL";
									break;
								case "ERROR":
									borderColor = "#c80018";
									health="ERROR";
									break;
								case "STALLED":
									health="STALLED";
									borderColor= "#9a40ff";
									break;
								default:
									health="";
									borderColor= "#000000"

							}
							
							if(d.state == "None"){
								healthHtml ="";
							
							}else{
								healthHtml ="<div>Health:</div><div><span class='healthSatate' style='background:"+borderColor+"'>&nbsp;</span><span style='padding-left:3px;'>"+health+"</span></div>";
								
							}

							if(d.isStartJvm == false){
								
								startContent ="";
							}else{
								
								startContent ="<div style='font-size:10px;color:#6caa00;text-transform: uppercase'>Business transaction starts here</div>";

							}
							var offset = $('.tooltipx').offset();
							var position = $('.tooltipx').position();
							var tWidth = $('.tooltipx').width();
							var tHeight = $('.tooltipx').height();

							var left = event.pageX -  offset.left - tWidth-30;
							var top = event.pageY -  offset.top - tHeight -30;
							if(event.pageX <=tWidth + 80){
								left = event.pageX -  offset.left + 30;
								
							}
							if(event.pageY <= tHeight + 80){

								top = event.pageY -  offset.top + 30;
							}
							toolTip.style("display","block");
							//toolTip.html("<div style='text-align:left;'>"+startContent+"<div> "+d.compName+"</div>"+healthHtml+"<div>"+d.isManaged+"</div><div>");
							toolTip.html("<div class='tooltiptitle'><div class='tfl'><div>Component:</div><div>"+d.compName+"</div>"+startContent+"</div><div class='tfr'>"+healthHtml+"</div></div><div class='tooltipcontent'><div style='text-transform: uppercase'>"+d.CompTooltip+"</div><div>")


							$('.tooltipx').css({"top":top+"px","left":left+"px"});

							//toolTip.style("top",top+"px").style("left",left+"px");
							delete top, left, offset, position,tWidth,tHeight;
							
							}*/
							
							

							animateFn = function(){

									path.attr("stroke-dasharray",function(l){ 
												if (d === l.source || d === l.target ){
													return 6 + " " + 6
													}
											})

											.attr("stroke-dashoffset", function(l){
													if (d === l.source || d === l.target ){
														return 50
													}
											})
											.style("stroke-width",function(l){
												if (d === l.source || d === l.target ){
												
													return hoverLineValue
												}
											})
											.transition()
											.duration(1000)
											.ease("linear")
											.attr("stroke-dashoffset", 0).each("end", animateFn);
								}
								animateFn();
								
								

							//d3.select(this).select('.patch').attr("filter", "url(#blurp)").style('fill','#009cff');

				})
				.on("mousemove", function(d){
				
				})
				.on("mouseleave", function(d){
					if(d.compName || d.nodeExperience ||  d.isManaged || d.CompTooltip){
						//toolTip.style("display","none");
						//$('.tooltipx').css({"top":"","left":""});
					}
					path.attr("stroke-dasharray",function(l){ 
												if (d === l.source || d === l.target ){
													return 0 + " " + 0
													}
											})
											.attr("stroke-dashoffset", function(l){
													if (d === l.source || d === l.target ){
													
														return 0
													}
											})
											.style("stroke-width",function(l){
												if (d === l.source || d === l.target ){
												
													return defaultLineValue
												}
											}).interrupt().transition();
				});
				
				/*dd_icon.on("click", function(d) {
					//alert('click');
                    str = d.drillDownLink;
						var url = str.substring(0,str.indexOf(","));
						var guidnode = str.substring(str.indexOf(",")+1);
                        window.parent.baseStackTrace(url,guidnode,'topologyBuildWindow')

                });*/
			
					/*groupNodes.on("click", function(d) {
							if (d3.event.defaultPrevented) return;
							if(d.drillDownLink){
							str = d.drillDownLink;
							var guidnode = str.substring(0,str.indexOf(","));
							var url = str.substring(str.indexOf(",")+1);
							window.parent.baseStackTrace(url,guidnode,'topologyBuildWindow');
							}else{
								return false;
							}

					});*/
			
			path.on('mouseover',function() {
				d3.select(this)
				  .transition()
				  .duration(100)
				  .style("stroke-width","2px")
				})
			  .on('mouseout',function () {
				d3.select(this)
				  .transition()
				  .duration(100)
				  .style('stroke-width',"1px")
			  });
            // -- collide FUNCTION
            var padding = 150,
                radius = 2,
                that = this;

            function collide(alpha) {
                var quadtree = d3.geom.quadtree(that.nodes);

                return function(d) {
                    var rb = 2 * radius + padding,
                        nx1 = d.x - rb,
                        nx2 = d.x + rb,
                        ny1 = d.y - rb,
                        ny2 = d.y + rb;
                    quadtree.visit(function(quad, x1, y1, x2, y2) {
                        if (quad.point && (quad.point !== d)) {
                            var x = d.x - quad.point.x,
                                y = d.y - quad.point.y,
                                l = Math.sqrt(x * x + y * y);
                            if (l < rb) {
                                l = (l - rb) / l * alpha;
                                d.x -= x *= l;
                                d.y -= y *= l;
                                quad.point.x += x;
                                quad.point.y += y;
                            }
                        }
                        return x1 > nx2 || x2 < nx1 || y1 > ny2 || y2 < ny1;
                    });
                };
            }

        });

    }

    $.fn.reusableSVG = function() {

      
       // -- glow while drag 
        var defs = d3.select('svg.svgparentTag').append("defs");
        var filter = defs.append("filter")
            .attr("id", "drop-shadow")
            .attr("height", "130%");
        filter.append("feGaussianBlur")
            .attr("in", "SourceAlpha")
            .attr("fill", "red")
            .attr("stdDeviation", 2)
            .attr("result", "blur");
        filter.append("feOffset")
            .attr("in", "blur")
            .attr("dx", 0)
            .attr("dy", 0)
            .attr("result", "offsetBlur");
        var feMerge = filter.append("feMerge");
        feMerge.append("feMergeNode").attr("in", "offsetBlur");
        feMerge.append("feMergeNode").attr("in", "SourceGraphic");
        //Reuseable arrow

		defs.append("filter").attr("id","blurp").attr("x","-20").attr("y","-40").attr("width","60").attr("height","60").
		append("feGaussianBlur").attr("in","SourceGraphic").attr("stdDeviation","20");



       marker =  d3.select('svg.svgparentTag')
            .selectAll("marker")
            .data([{
                "name": "default",
                "color": "#909090"
            },{
                "name": "undefined",
                "color": "#909090"
            },{
                "name": "null",
                "color": "#909090"
            },{
                "name": "NORMAL",
                "color": "#289b1f"
            },{
                "name": "SLOW",
                "color": "#cbc024"
            },{
                "name": "ERROR",
                "color": "#c80018"
            },{
                "name": "STALLED",
                "color": "#f69a2d"
            }])
            .enter().append("svg:marker")
            .attr("id", function(d) {
                return d.name
            })
            .attr("fill", function(d) {
                return d.color;
            })
            .attr("viewBox", "0 -5 10 10")
            .attr("markerWidth", 12)
			.attr("markerHeight", 12)
            .attr("refX", function(d){return 0})
            .attr("refY", 0)
            .attr("orient", "auto")
            .append("svg:path").attr('d', function(d){ return d.path })
            .attr("d", "M0,-5L10,0L0,5");

        var STALLED = d3.select('svg.svgparentTag').append("svg:defs")
            .append("svg:linearGradient")
            .attr("id", "STALLED")
            .attr("x1", "0%")
            .attr("y1", "0%")
            .attr("x2", "100%")
            .attr("y2", "100%");

        STALLED.append("svg:stop")
            .attr("offset", "50%")
            .attr("stop-color", "#fe7d00")
            .attr("stop-opacity", 1);

        STALLED.append("svg:stop")
            .attr("offset", "50%")
            .attr("stop-color", "#f32b2b")
            .attr("stop-opacity", 1);

		var zindex = d3.select('svg.svgparentTag')
					.append("svg:circle")
					.attr('id','zindex')
					.attr('fill','none')
					.attr('cy','0')
					.attr('cx','0')
					.attr('r','90');
			
		var use = d3.select('svg.svgparentTag')
				  .append("svg:use")
					.attr('id','usezindex');
					
				
			
    }

    $.fn.renderSvg = function(options) {

        var options = $.extend({}, settings, options);
		

        var dom = d3.select(options.renderTo);

		toolTip = d3.select("body")
		.append("div")
		.attr('class','tooltipx')
		.style("position", "absolute")
		.style("z-index", "10")
		.style("diaplay", "none");
		
        this.renderDiagram(options);
        svg = d3.select(options.renderTo)
			.style("position", "relative")
			.attr("width", options.width + options.margin.left + options.margin.right)
            .attr("height", options.height + options.margin.top + options.margin.bottom)
            .append('svg')
            .attr("viewBox", "0 0 " + options.width + " " + options.height)
            .attr("preserveAspectRatio", "xMinYMin")
            .attr('class', 'svgparentTag')
            .attr("width", options.width + options.margin.left + options.margin.right)
            .attr("height", options.height + options.margin.top + options.margin.bottom)
            .append("g")
            .attr('class', 'pitch')
            .attr("transform", "translate(" + options.margin.left + "," + options.margin.top + ")");

			//resize();

			d3.select(window).on("resize", resize);
			function resize() {
					location.reload(true);
			  }


        // -- pre Loading text 
        loading = svg.append("text").attr({
            x: options.width / 2,
            y: options.height / 2
        }).text(options.loadingText);


        if (options.zoom) {
            d3.select(options.renderTo).select('svg').remove();
            if (options.initialX == null || options.initialY == null) {
                options.initialX = options.width / 2;
                options.initialY = options.height / 2;
            }
            var xz = d3.scale.linear()
                .domain([-options.width / 2, options.width / 2])
                .range([0, options.width]);

            var yz = d3.scale.linear()
                .domain([-options.height / 2, options.height / 2])
                .range([options.height, 0]);
			

            var hideText = function(value, scale) {
				defaultLineValue = 1
                if (value > scale) {
                    d3.selectAll('text').transition().style("opacity", 0);
					d3.selectAll('.state_ux').transition().style("opacity", 0);
					d3.selectAll('.serverimgNORMAL, .serverimgERROR, .serverimgSLOW, .serverimgSTALLED').transition().style("opacity", 0);
					d3.selectAll('.serverimgColor').transition().style("opacity", 1);
					
					path.attr("class",function(d){return "link "+d.lineExperience});
					defaultLineValue = 3;
					/* path.filter(function(d) {
								return d.arrow == true;
							}).attr("marker-end", function(d) {
					
								return "url(#"+d.lineExperience+")"
							}).style("stroke-width", function(d) {

								return defaultLineValue;
						});*/
					path.filter(function(d) {
								return d.arrow == true;
							});
					
					t_path.filter(function(d) {
								return d.arrow == true;
							}).attr("marker-end", function(d) {
					
								return "url(#"+d.lineExperience+")"
							}).style("stroke-width", function(d) {
										
								console.log(d.lineExperience)
								switch(d.lineExperience){
									
									case "NORMAL":
										defaultLineValue = 1.2;
									break;
									case "SLOW":
										defaultLineValue = 1.5;	
									break;
									case "STALLED":
										defaultLineValue = 2;
									break;
									case "ERROR":
										defaultLineValue = 2.5;
									break;
									default:
										defaultLineValue = 1;
								}
								return defaultLineValue;
						});
					
					
                } else {
                    d3.selectAll('text').transition().style("opacity", 1);
					d3.selectAll('.state_ux').transition().style("opacity", 1);
					d3.selectAll('.serverimgNORMAL, .serverimgERROR, .serverimgSLOW, .serverimgSTALLED').transition().style("opacity", 1);
					d3.selectAll('.serverimgColor').transition().style("opacity", 0);
					path.attr("class",function(d){return "link "});

					/*path.filter(function(d) {
								return d.arrow == true;
							}).attr("marker-end", function(d) {
					
								return "url(#default)"
							}).style("stroke-width", function(d) {
								return defaultLineValue;
						});*/
					path.filter(function(d) {
								return d.arrow == true;
							}).style("stroke-width", function(d) {
								return defaultLineValue;
						});

					t_path.filter(function(d) {
								return d.arrow == true;
							}).attr("marker-end", function(d) {
					
								return "url(#default)"
							}).style("stroke-width", function(d) {
								return defaultLineValue;
						});
                }

            }
            $(document).mousedown(function() {
                d3.select('.svgparentTag').style("cursor", "url('/final/images/closedhand.cur'),default");
            });
            $(document).mouseup(function() {
                d3.select('.svgparentTag').style("cursor", "url('/final/images/openhand.cur'),default");
            });

            // -- Zoom function 
			
            var zoomFn = function() {
                cal_font9px = (font9px / d3.event.scale);
                cal_font10px = (font10px / d3.event.scale);
                cal_font11px = (font11px / d3.event.scale);
                cal_font12px = (font12px / d3.event.scale);
              
				adj_stateiconHeight = (stateiconHeight/d3.event.scale)- 0.21;
				adj_stateiconWidth = (stateiconWidth/d3.event.scale)- 0.21;
				updatePosition();
				svg.selectAll('.state_ux').attr({"width":adj_stateiconHeight,"height":adj_stateiconWidth});
                svg.selectAll('.font9px').style("font-size", cal_font9px + "px");
                svg.selectAll('.font10px').style("font-size", cal_font10px + "px");
                svg.selectAll('.font11px').style("font-size", cal_font11px + "px");
                svg.selectAll('.font12px').style("font-size", cal_font12px + "px");
                scale = d3.event.scale,
				translation = d3.event.translate;
				translation = [d3.event.translate[0],d3.event.translate[1]];
				svg.attr("transform", "translate(" + translation + ")" +" scale(" + scale + ")");
				//console.log(d3.select('g.pitch')[0][0].getBBox());
				// limit translation to thresholds


				/*var bbox = d3.select('g.pitch')[0][0].getBBox(),
                        translation = d3.event.translate,
                        scale = d3.event.scale,
                        canvasWidth = bbox.width * scale,
                        canvasHeight = bbox.height * scale,
                        canvasAspect = canvasWidth / canvasHeight,
                        screenAspect = options.width / options.height,
                        xPrime = translation[0],
                        yPrime = translation[1],
                        left = -bbox.x * scale,
                        right = -bbox.x * scale,
                        top = -bbox.y * scale,
                        bottom = -bbox.y * scale;
						options.width > canvasWidth && options.height > canvasHeight ? (right += -(canvasWidth - options.width), 
						bottom += -(canvasHeight - options.height), 
						xPrime = Math.min(right, Math.max(left, xPrime)), 
						yPrime = Math.min(bottom, Math.max(top, yPrime))) : canvasAspect > screenAspect ? canvasHeight > options.height ? (right += -(canvasWidth - options.width), 
						bottom += -(canvasHeight - options.height), 
						xPrime = Math.max(right, Math.min(left, xPrime)), 
						yPrime = Math.max(bottom, Math.min(top, yPrime))) : (right += -(canvasWidth - options.width), bottom += options.height - canvasHeight, 
						xPrime = Math.max(right, Math.min(left, xPrime)), 
						yPrime = Math.max(top, Math.min(bottom, yPrime))) : canvasWidth > options.width ? (right += -(canvasWidth - options.width), 
						bottom += -(canvasHeight - options.height), 
						xPrime = Math.max(right, Math.min(left, xPrime)), 
						yPrime = Math.max(bottom, Math.min(top, yPrime))) : (right += options.width - canvasWidth, bottom += -(canvasHeight - options.height), 
						xPrime = Math.max(left, Math.min(right, xPrime)), 
						yPrime = Math.max(bottom, Math.min(top, yPrime))), 
						translation[0] = xPrime, translation[1] = yPrime, 
						zoom.scale(scale).translate(translation), 
						svg.attr("transform", "translate(" + xPrime + ", " + yPrime + ") scale(" + scale + ")");
						force.tick();*/


				
				
				$(".slider").slider("value", scale);
				hideText(.600,scale);
				if (d3.select(".toolTip")) {
                    toolTip.style("display","none");
                }

            };

            var zoomStartFn = function() {
                if (slider_tooltip) {
                    slider_tooltip.text(Math.round(zoom.scale() * 100) + '%');
                    slider_tooltip.show().delay(5000).fadeOut('slow');

                }
            }


           /* if (zoomFn) {
                if (localStorage.getItem('svgScale') === null) {
                    translateZ = options.initialX + "," + options.initialY;
                    scaleZ = options.default_zoom;
                } else {
                    translateZ = JSON.parse(localStorage.getItem('svgScale')).transform;
                    scaleZ = JSON.parse(localStorage.getItem('svgScale')).scale;
                    options.zoomObj.translate(translateZ).scale(scaleZ);
                }
            }*/
			/*var projection = d3.geo.mercator()
				.rotate([options.width,0])
				.scale(options.default_zoom)           // we'll scale up to match viewport shortly.
				.translate([options.width/2, options.height/2]);

				console.log('projection',projection);
			function mercatorBounds(projection, maxlat) {
				var yaw = projection.rotate()[0],
					xymax = projection([-options.min_zoom, -options.max_zoom]),
					xymin = projection([-options.min_zoom, options.max_zoom]);
				console.log([xymin,xymax]);
				return [xymin,xymax];
			}
			var b = mercatorBounds(projection, options.width),
			s = options.width/(b[1][0]-b[0][0]),
			scaleExtent = [s, 10*s];
			projection.scale(scaleExtent[0]);
			console.log(projection.scale());*/

            var zoom = options.zoomObj
                .x(xz)
                .y(yz)
                .scaleExtent([options.min_zoom, options.max_zoom])
                .translate([options.initialX, options.initialY])
                .center([options.width / 2, options.height / 2])
                .scale(options.default_zoom)
                .on("zoom", zoomFn).on("zoomstart", zoomStartFn)
                .size([options.width / 2, options.height / 2]);


			/*window.addEventListener('resize', resize); 
			function resize() {
				alert('window resize');
				options.width = $(window).width();
				options.height = $(window).height() - 80;
				location.reload(true);
				//force.size([options.width, options.height]).resume();
				console.log(Ext.getCmp('topologyBuildWindow'));
			}*/
            var svg = d3.select(options.renderTo)
				.style("position", "relative")
				.attr("width", options.width + options.margin.left + options.margin.right)
				.attr("height", options.height + options.margin.top + options.margin.bottom)
                .append('svg')
                .attr("viewBox", "0 0 " + options.width + " " + options.height)
                .attr("preserveAspectRatio", "xMidYMid meet")
                .attr('class', 'svgparentTag')
                .attr("width", options.width + options.margin.left + options.margin.right)
                .attr("height", options.height + options.margin.top + options.margin.bottom)
                .call(zoom).on("dblclick.zoom", null)
                .append("g")
                .attr("width", options.width + options.margin.left + options.margin.right)
                .attr("height", options.height + options.margin.top + options.margin.bottom)
                .attr('class', 'pitch')
                 .attr("transform", "translate(" + options.initialX + "," + options.initialY + ")scale("+options.default_zoom+")")
                .on("dblclick.zoom", null).on("click.zoom", null);

            var rect = svg.append("rect")
                .attr("class", 'zoomrect')
                .attr("width", (options.width + options.margin.left + options.margin.right) * zoom.scale())
                .attr("height", (options.height + options.margin.top + options.margin.bottom) * zoom.scale())
                .attr("transform", "translate(" + [-1 * (options.zoomObj.scale() * options.initialX), -1 * (options.zoomObj.scale() * options.initialY)] + ")" + " scale(" + options.zoomObj.scale() + ")")
                .style("fill", "none")
                .style("pointer-events", "all");

            function interpolateZoom(translate, scale) {
                var self = this;
                return d3.transition().duration(duration).tween("zoom", function() {
                    var iTranslate = d3.interpolate(zoom.translate(), translate),
                        iScale = d3.interpolate(zoom.scale(), scale);
                    return function(t) {
							zoom
                            .scale(iScale(t))
                            .translate(iTranslate(t))
                            .event(svg);
                    };
                });
            }

            // -- zoom buttons [+][-] method
            function zoomClick() {
                var clicked = d3.event.target,
                    direction = 1,
                    factor = 0.2,
                    target_zoom = ((options.max_zoom - options.min_zoom) / 100),
                    center = [options.width / 2, options.height / 2],
                    extent = zoom.scaleExtent([options.min_zoom, options.max_zoom]),
                    translate = zoom.translate(),
                    translate0 = [],
                    l = [],
                    view = {
                        x: translate[0],
                        y: translate[1],
                        k: zoom.scale()
                    };

                d3.event.preventDefault();
                direction = (this.id === 'zoom_in') ? 1 : -1;
                target_zoom = zoom.scale() * (1 + factor * direction);

                if (target_zoom < extent[0] || target_zoom > extent[1]) {
                    return false;
                }

                translate0 = [(center[0] - view.x) / view.k, (center[1] - view.y) / view.k];
                view.k = target_zoom;
                l = [translate0[0] * view.k + view.x, translate0[1] * view.k + view.y];

                view.x += center[0] - l[0];
                view.y += center[1] - l[1];
                //console.log(view.k);
                if (view.k <= options.min_zoom || view.k >= options.max_zoom) {
                    $(".slider").slider("value", view.k);
                    return false
                } else {

                    interpolateZoom([view.x, view.y], view.k);
                }


            }


            // -- slider function
            function slideFn(value) {
                var scale = zoom.scale();
                var extent = zoom.scaleExtent();
                var newScale = value;
                if (extent[0] <= newScale && newScale <= extent[1]) {

                    var t = zoom.translate();
                    var c = [options.width/2, options.height/2];
					
					zoom.scale(newScale)
                    .translate([c[0] + (t[0] - c[0]) / scale * newScale, c[1] + (t[1] - c[1]) / scale * newScale])
                    .event(svg);

                }
            };
            // -- reusableSVG function call 
            this.reusableSVG();

            

            function zoomToFit() {
                var b = layout.graphBounds();
                var w = b.X - b.x,
                    h = b.Y - b.y;
                var cw = $(window).width() + options.margin.left + options.margin.right,
                    ch = $(window).height() + options.margin.top + options.margin.bottom;
                var s = Math.min(cw / w, ch / h);
                var tx = (-b.x * s + (cw / s - w) * s / 2),
                    ty = (-b.y * s + (ch / s - h) * s / 2);


                if (options.layoutAlign == 'center' && options.enableFitLayout) {
                    //alert("center+auto");
                    var cw = options.width,
                     ch = options.height;
                    s = Math.min(cw / w, ch / h);
                    tx = (-b.x  * s + (cw / s - w) * s / 2),
                        ty = (-b.y * s + (ch / s - h) * s / 2);


                } else if (options.layoutAlign == 'left' && options.enableFitLayout) {
                    //alert('left+auto');
                    cw = options.width + options.margin.left + options.margin.right,
                        ch = options.height + options.margin.top + options.margin.bottom;
                    s = Math.min(cw / w, ch / h);
                    tx = (-b.x * s + (cw / s - w) * s / 2),
                        ty = (-b.y - movementY * s + (ch / s - h) * s / 2);

                    //tx = tx - HX - LX ;

                } else if (options.layoutAlign == 'left' && options.enableFitLayout == false) {
                    //alert('left+manual');
                    cw = $(window).width() + options.margin.left + options.margin.right,
                        ch = $(window).height() + options.margin.top + options.margin.bottom;
                    s = Math.min(cw / w, ch / h);
                    tx = (-b.x * s + (cw / s - w) * s / 2),
                        ty = (-b.y - movementY * s + (ch / s - h) * s / 2);


                }

                interpolateZoom([parseInt(tx), parseInt(ty)], s);
                $(".slider").slider("value", options.zoomObj.scale());
                hideText(0.500, s);

                delete tx, ty, s, cw, ch;
            }
            var slider = dom.append('div').attr('class', 'slider btmslider');
            var slider_buttons = dom.append('div').attr('class', 'slider_buttons').style('left','14px').style('top','35px');
            var zoomslider_in = slider_buttons.append('button').attr("data-qtip","ZoomIn").attr('id', 'zoom_in').attr('class', 'button_zoom zoomInbt zoomtop');
            var zoomslider_out = slider_buttons.append('button').attr("data-qtip","ZoomOut").attr('id', 'zoom_out').attr('class', 'button_zoom zoomOutbt zoombottom');
			var legend = dom.append('div').attr('class','legendplacement');


            $(options.renderTo).append('<div class="ui-widget searchbox" style="width:95px;top:80px"><div style="float:left">Layout: </div><div class="iconSearchBig toposearch" title="Search" style="display:none"><div id="searchcom" style="display:none;position:absolute;left:-50px"><div class="searchstroke"><input id="search"><button title="Search" type="button"  id="searchnode">&nbsp;</button></div></div></div><button id="fit" class="iconAutofit" data-qtip="Auto Fit" style="margin-left:5px;">&nbsp;</button><button id="circular" class="circleLayout" data-qtip="Circular Layout" style="margin-left:5px;cursor:pointer">&nbsp;</button><button id="random" class="randomlayout" title="Random" style="margin-left:5px;display:none">&nbsp;</button></div>');

            // -- Zoom in and zoom out
            d3.selectAll('button.button_zoom').on('click', zoomClick);

            $('body').on('click','.toposearch',function() {
                $("#searchcom").animate({
                    left: "-145px",
                }, 100, function() {
                    $('#search').focus();

                }).show();
            });
            $('#search').blur(function() {
                if (mousedownsearch) {
                    mousedownsearch = false;
                } else {
                    $("#searchcom").animate({
                        left: "-50px",
                    }, 100).hide();
                }
            });

            $('body').on('click','#fit',function() {
                zoomToFit();
            });

			$('body').on('click','#circular',function(){
					layout.circularLayoutFn();
			});

            slider_tooltip = $('<span id="tooltip" class="slider_tooltip" />').css({
                position: 'absolute',
                top: -5,
                left: 20
            }).hide();

            $(".slider").slider({
                animate: "slow",
                orientation: "vertical",
                min: options.min_zoom,
                max: options.max_zoom,
                value: options.default_zoom,
                step: ((options.max_zoom - options.min_zoom) / 100),
                slide: function(event, ui) {

                    slider_tooltip.text(Math.round(ui.value * 100) + '%');
                    slideFn(ui.value);

                }
            }).find(".ui-slider-handle").append(slider_tooltip).hover(function() {
                slider_tooltip.text(Math.round(options.zoomObj.scale() * 100) + '%');
                slider_tooltip.fadeIn('fast');
            }, function() {
                slider_tooltip.delay(5000).fadeOut('slow');
            });

        } else {

            console.log('false');
        }

    };


}(jQuery));