Ext.define('DemoScenarios.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Viewport','DemoGridView','PartnerGridView'],
	store:['PartnerStore','DemoStore'],
	refs : [
		{selector:'viewport', ref:'viewport'},
		{selector:'DemoGridView', ref:'DemoGridView'},
		{selector:'PartnerGridView', ref:'PartnerGridView'}
	],

	init:function(){
		thisController = this;
		this.control({
			'viewport panel[id="viewportpanel"]':
			{
				'afterrender': this.afterMainRender
			},
			'DemoGridView':
			{
				'itemclick': this.onClickData
			},
			'PartnerGridView':
			{
				'itemclick': this.onClickData
			},
			'DemoGridView button[id="ExpandDemo"]':
			{
				'click': this.expandCollapseDemo
			},
			'PartnerGridView button[id="ExpandPartner"]':
			{
				'click': this.expandCollapsePartner
			},
		});
	},

	afterMainRender : function()
	{
		if (username != null && (username.toLowerCase() == 'egpartner' || username.toLowerCase() == 'egpartner_de'))
		{
			Ext.getCmp('rightPane').add({xtype:'PartnerGridView'});
		}
		else if (username != null && username.toLowerCase() == 'egdemo')
		{
			Ext.getCmp('rightPane').add({xtype:'DemoGridView'});
		}
	},
	
	expandCollapseDemo : function(btn)
	{
		var obj = Ext.getCmp('ExpandDemo');
		if(btn.pressed)
		{
			obj.currentStatus = "expanded";
			obj.update('<div style="cursor:pointer;text-decoration:underline;float:right;font-size:9px;padding:2px" id="exx">Collapse All</div>');
			Ext.getCmp('DemoGridView').expandAll();
		}
		else
		{
			obj.update('<div style="cursor:pointer;text-decoration:underline;float:right;font-size:9px;padding:2px" id="exx">Expand All</div>');
			obj.currentStatus = "collapse";
			Ext.getCmp('DemoGridView').collapseAll();
		}
	},

	expandAllRow: function(rowIdx) {
		var obj = "";
		if (username != null && (username.toLowerCase() == 'egpartner' || username.toLowerCase() == 'egpartner_de'))
		{
			obj = Ext.getCmp('PartnerGridView');
		}
		else if (username != null && username.toLowerCase() == 'egdemo')
		{
			obj = Ext.getCmp('DemoGridView');
		}
			var view = obj.view;
			rowNode = view.getNode(rowIdx);
			row = Ext.get(rowNode);
			nextBd = Ext.get(row).down(obj.rowBodyTrSelector);
			record = view.getRecord(rowNode);
		
		if(row.hasCls(obj.rowCollapsedCls)) 
		{
			row.removeCls(obj.rowCollapsedCls);
			nextBd.removeCls(obj.rowBodyHiddenCls);
			view.refreshSize();
			view.fireEvent('expandbody', rowNode, record, nextBd.dom);
		}
	},

	expandCollapsePartner : function(btn)
	{
		var obj = Ext.getCmp('ExpandPartner');
		if (btn.pressed)
		{
			obj.currentStatus = "expanded";
			obj.update('<div style="cursor:pointer;text-decoration:underline;float:right;font-size:9px;padding:2px" id="exx">Collapse All</div>');
			Ext.getCmp('PartnerGridView').expandAll();
		}
		else
		{
			obj.update('<div style="cursor:pointer;text-decoration:underline;float:right;font-size:9px;padding:2px" id="exx">Expand All</div>');
			obj.currentStatus = "collapse";
			Ext.getCmp('PartnerGridView').collapseAll();
		}
	},

	onClickData  : function(me, record, item, index, e, eOpts)
	{
		var uname = record.get('userName');
		var demoUser = "egpartner";
		if (Ext.isEmpty(uname))
		{
			return;
		}
		else
		{
			if (username != null && username.toLowerCase() == 'egpartner_de')
			{
				demoUser = "egpartner_de";
				uname = uname+"_de";
			}
			else if (username != null && username.toLowerCase() == 'egdemo')
			{
				demoUser = "egdemo";
				Ext.Ajax.request({
					url:"/final/scripts/DemoScenarios/data/EgDemoJson.jsp?uname="+encodeURIComponent(uname),
					method:'POST',
					scope:this,
					async:false,
					success:function(response)
					{
						if(response.status == 200 && !Ext.isEmpty(response.responseText))
						{
							var jsonText = response.responseText;
							var publicJson = Ext.decode(jsonText);
							upass = publicJson['upass'];
						}
					},
					failure : function(response)
					{
						console.log(response.responseText);
					}
				});
			}

			url = "http://demo.eginnovations.com/final/servlet/com.egurkha.EgLoginServlet?uname="+encodeURIComponent(uname)+"&upass="+encodeURIComponent(upass)+"&accessKey="+encodeURIComponent(accessKey)+'&demoUser='+encodeURIComponent(demoUser);

			var ver = navigator.appVersion;
			ver = ver.toLowerCase();
			if (ver.indexOf("chrome/") > 0 )
			{
				var h=600 
				if (window.screen)
				{
					h = window.screen.availHeight;
				}
				popupWindow = window.open("/final/demo","MyWindow","addressbar=yes,directories=0,toolbar=no,menubar=no,location=yes,status=no,statusbar=no,self,left=0,top=0,resizable=yes,screenX=0,screenY=0,width=1012,height="+(h-65));
			}
			else
			{
				var h=600;
				if (window.screen)
				{
					h = window.screen.availHeight;
				}
				popupWindow = window.open("/final/demo","MyWindow","addressbar=yes,directories=0,toolbar=no,menubar=no,location=yes,status=no,statusbar=no,self,width=1012,height=709,left=0,top=0,resizable=yes,screenX=0,screenY=0");
			}
			if(popupWindow!=null)
			{
				popupWindow.focus();
			}
			else
			{
				alert("Cannot open the login window. Your browser might have denied opening a popup window.");
			}
		}
	}
});



