Ext.define('DemoScenarios.store.PartnerStore', {
extend: 'Ext.data.TreeStore',
alias: 'widgets.PartnerStore',
	fields: ['text','userName','desc','capabilities'],
	root: {
		expanded: true,
		children: [
			{
				text: 'Citrix XenApp Monitoring',
				iconCls : 'iconGroup',
				hasPageLink: false,
				expanded: false,
				children: [
					{
						leaf: true,
						text: 'Citrix XenApp 7.x on VMware vSphere',
						userName: 'egxd7',
						iconCls : 'iconMonitorInterface',
						id: 'egxd7',
						capabilities : '<ul><li>End-to-End Citrix XenApp 7.x Monitoring</li><li>Correlating Application and VMware Virtualization Performance</li><li>Citrix Cloud Monitoring</li><li>Monitoring All Aspects of Citrix User Experience (Logon Simulation, Real User Logon Breakdown, App Launch, Screen Refresh)</li></ul>',
						desc: 'XenApp 7.x, VMware vSphere, Citrix Logon Simulator, Citrix Cloud, NetScaler MAS and HDX Insight, AWS, Azure, EMC SAN'
					},
					{
						leaf: true,
						text: 'Citrix XenApp 6.5 on Citrix XenServer',
						userName: 'egxeneurope',
						iconCls : 'iconMonitorInterface',
						id: 'egxeneurope',
						capabilities : '<ul><li>End-to-End Citrix XenApp 6.5 Monitoring</li><li>Correlating Application and XenServer Virtualization Performance</li></ul>',
						desc: 'XenApp 6.5, XenServer'
					},
					{
						leaf: true,
						text: 'Citrix XenApp 6.5 on Physical Servers',
						userName: 'egeurope',
						iconCls : 'iconMonitorInterface',
						id: 'egeurope',
						capabilities : '<ul><li>Correlating XenApp Performance Monitoring and Configuration Change Tracking</li></ul>',
						desc: 'XenApp 6.5, Oracle'
					}
				]
			},
			{
				text: 'Citrix XenDesktop Monitoring',
				iconCls : 'iconGroup',
				hasPageLink: false,
				expanded: false,
				children: [
					{
						leaf: true,
						text: 'Citrix XenDesktop on VMware vSphere',
						userName: 'egvdieurope',
						iconCls : 'iconMonitorInterface',
						id: 'egvdieurope',
						capabilities : '<ul><li>End-to-End Citrix XenDesktop 7.x Monitoring</li><li>Correlating Desktop and VMware Virtualization Performance</li><li>Monitoring All Aspects of Citrix User Experience (Logon Simulation, Real User Logon Breakdown, App Launch, Screen Refresh)</li><li>Inside View of Desktops Showing Performance Issues</li></ul>',
						desc: 'XenDesktop 7.x, VMware vSphere, NetScaler MAS, NetScaler VPX'
					},
					{
						leaf: true,
						text: 'Citrix XenDesktop on Citrix XenServer',
						userName: 'egcitrixvdi',
						iconCls : 'iconMonitorInterface',
						id: 'egcitrixvdi',
						capabilities : '<ul><li>End-to-End Citrix XenDesktop 7.x Monitoring</li><li>Correlating Desktop and XenServer Virtualization Performance</li><li>Monitoring All Aspects of Citrix User Experience (Logon Simulation, Real User Logon Breakdown, App Launch, Screen Refresh)</li><li>Inside View of Desktops Showing Performance Issues</li></ul>',
						desc: 'XenDesktop 7.x, XenServer'
					},
					{
						leaf: true,
						text: 'Citrix XenDesktop on Nutanix AHV',
						userName: 'egnutanixvdi',
						iconCls : 'iconMonitorInterface',
						id: 'egnutanixvdi',
						capabilities : '<ul><li>XenDesktop Monitoring on Nutanix Acropolis</li><li>Inside View of Desktops Showing Performance Issues</li></ul>',
						desc: 'XenDesktop 7.x, Nutanix Acropolis, Citrix Logon Simulator'
					}
				]
			},
			{
				text: 'Application Performance Monitoring (APM)',
				iconCls : 'iconGroup',
				hasPageLink: false,
				expanded: false,
				children: [
					{
						leaf: true,
						text: 'Real User Monitoring',
						userName: 'egrum',
						iconCls : 'iconMonitorInterface',
						id: 'egrum',
						capabilities : '<ul><li>Real User Monitoring</li><li>Page Load Time High Due to Server-Side Issues</li><li>JavaScript Errors</li><li>Heavy Traffic and Page Views</li></ul>',
						desc: '3 Websites configured with RUM'
					},
					{
						leaf: true,
						text: 'Java Transaction Tracing with Application Issues',
						userName: 'egapmcode',
						iconCls : 'iconMonitorInterface',
						id: 'egapmcode',
						capabilities : '<ul><li>Java APM (Root Cause in Application Code)</li><li>Real User Monitoring</li><li>Distributed, Multi-Tier Java Business Transaction Tracing</li><li>Identifying Code-Level Errors and Slowness</li><li>Identifying Slowness is Inefficient Query</li></ul>',
						desc: 'Oracle WebLogic, Oracle Database, F5 Load Balancer, IIS, SQL Server, Tuxedo, RUM, EMC SAN'
					},
					{
						leaf: true,
						text: 'Java Transaction Tracing with Infrastructure Issues',
						userName: 'egapminfra',
						iconCls : 'iconMonitorInterface',
						id: 'egapminfra',
						capabilities : '<ul><li>Java APM (Root Cause in Infrastructure)</li><li>Distributed, Multi-Tier Java Business Transaction Tracing</li><li>Showing All Database Queries to be Slow</li><li>Identifying Virtualization Issue Causing Application Slowness</li></ul>',
						desc: 'Oracle WebLogic, Oracle Database, F5 Load Balancer, IIS, SQL Server, Tuxedo, RUM, EMC SAN'
					},
					{
						leaf: true,
						text: 'JVM Monitoring',
						userName: 'egcloud',
						iconCls : 'iconMonitorInterface',
						id: 'egcloud',
						capabilities : '<ul><li>JVM Monitoring</li><li>Highlighting High CPU Threads and Thread Blocking Issues</li><li>Identifying Code-Level Issues Using JVM Monitoring</li><li>Memory Monitoring</li><li>Correlating Java Performance with AWS Cloud</li></ul>',
						desc: 'Java/JVM, Microsoft RDS, SQL Server, AWS'
					},
					{
						leaf: true,
						text: 'Microsoft .NET Transaction Tracing',
						userName: 'egdotnetapm',
						iconCls : 'iconMonitorInterface',
						id: 'egdotnetapm',
						capabilities : '<ul><li>.NET APM</li><li>Real User Monitoring</li><li>Distributed .NET Business Transaction Tracing</li><li>Identifying Code-Level Errors</li><li>IIS Monitoring</li></ul>',
						desc: 'IIS, SQL Server, AD, RUM, Oracle, Tomcat'
					}
				]
			},
			{
				text: 'Unified Monitoring',
				iconCls : 'iconGroup',
				hasPageLink: false,
				expanded: false,
				children: [
					{
						leaf: true,
						text: 'Inside/Outside View of VMware VMs',
						userName: 'egvjava',
						iconCls : 'iconMonitorInterface',
						id: 'egvjava',
						capabilities : '<ul><li>VMware vSphere Monitoring</li><li>Inside View of VM Showing Performance Issues (Uses VM Agent)</li><li>Correlating Application and Virtualization Monitoring</li></ul>',
						desc: 'Java/JVM, VMware vSphere, IIS, SQL Server, AD, EMC SAN, Fibre Channel Switch'
					},
					{
						leaf: true,
						text: 'Database Monitoring',
						userName: 'egoracle',
						iconCls : 'iconMonitorInterface',
						id: 'egoracle',
						capabilities : '<ul><li>In-Depth Database Monitoring Pinpointing Query-Level Issues</li><li>DBA View (Uses Full Agent)</li></ul>',
						desc: 'SQL Server, Oracle, EMC SAN'
					},
					{
						leaf: true,
						text: 'Nutanix Acropolis Monitoring',
						userName: 'egnutanix',
						iconCls : 'iconMonitorInterface',
						id: 'egnutanix',
						capabilities : '<ul><li>Nutanix Acropolis Monitoring</li><li>Inside View of VM Showing Performance Issues</li><li>Correlating Application and Virtualization Monitoring</li></ul>',
						desc: 'Java/JVM, Nutanix Acropolis, Nutanix Prism, IIS, SQL Server, AD'
					},
					{
						leaf: true,
						text: 'Oracle VM Server Monitoring',
						userName: 'egovm',
						iconCls : 'iconMonitorInterface',
						id: 'egovm',
						capabilities : '<ul><li>Oracle VM Server Monitoring</li><li>Inside View of VM Showing Performance Issues</li><li>Correlating Application and Virtualization Monitoring</li></ul>',
						desc: 'Java/JVM, Oracle VM Server, IIS, SQL Server'
					},
					{
						leaf: true,
						text: 'Multi-Tier Java Application Monitoring',
						userName: 'egjavasql',
						iconCls : 'iconMonitorInterface',
						id: 'egjavasql',
						capabilities : '<ul><li>Troubleshooting Multi-tier Java Application</li><li>Identifying Slowness in the Database</li><li>Correlating Application and Database Performance</li><li>Showing In-Depth SQL Query-Level Visibility</li></ul>',
						desc: 'Java, SQL Server, IIS, AD, Hyper-V, VDI'
					},
					{
						leaf: true,
						text: 'Web Application on VMware vSphere',
						userName: 'egvmeurope',
						iconCls : 'iconMonitorInterface',
						id: 'egvmeurope',
						capabilities : '<ul><li>Correlating Web Application Performance with VMware Virtualization</li></ul>',
						desc: 'IIS, Microsoft Middleware, SQL Server, VMware vSphere'
					},
					{
						leaf: true,
						text: 'Single-Pane-of-Glass Visibility of IT Infrastructure',
						userName: 'egunivision',
						iconCls : 'iconMonitorInterface',
						id: 'egunivision',
						capabilities : '<ul><li>Infrastructure Component Deep-Dive Visibility</li><li>(No topology, No Code-Level Visibility)</li></ul>',
						desc: 'AWS, Azure, Cisco Router, Citrix XenApp, XenServer, EMC SAN, Citrix Logon Simulator, Java, Linux, Exchange, IIS, SQL Server, Database, VMware vSphere, Windows Server, Hyper-V'
					}
				]
			},
			{
				text: 'Enterprise Application Monitoring',
				iconCls : 'iconGroup',
				hasPageLink: false,
				expanded: false,
				children: [
					{
						leaf: true,
						text: 'SAP Monitoring',
						userName: 'egsap',
						iconCls : 'iconMonitorInterface',
						id: 'egsap',
						capabilities : '<ul><li>In-Depth SAP ABAP Monitoring</li><li>Correlated Visibility Between SAP, Database and Virtualization Performance</li></ul>',
						desc: 'SAP ABAP, SAP Java Stack, Microsoft Hyper-V, IIS, SQL Server, Oracle'
					},
					{
						leaf: true,
						text: 'SharePoint Monitoring',
						userName: 'egsharepoint',
						iconCls : 'iconMonitorInterface',
						id: 'egsharepoint',
						capabilities : '<ul><li>In-Depth SharePoint Monitoring</li><li>SharePoint User Experience with Real User Monitoring</li><li>SharePoint Service Topology</li><li>Correlated Visibility of SharePoint with SQL Server</li></ul>',
						desc: 'SharePoint, IIS, SQL Server, Azure, Hyper-V, RUM, EMC SAN, F5 Load Balancer'
					},
					{
						leaf: true,
						text: 'Exchange Monitoring',
						userName: 'egxchg',
						iconCls : 'iconMonitorInterface',
						id: 'egxchg',
						capabilities : '<ul><li>In-Depth Microsoft Exchange Monitoring</li><li>Correlation Between Exchange and Virtualization Performance</li></ul>',
						desc: 'Exchange Logon Simulator, Exchange 2016, IIS, SQL Server, VMware vSphere'
					}
				]
			},
			{
				text: 'VMware Horizon Monitoring',
				iconCls : 'iconGroup',
				hasPageLink: false,
				expanded: false,
				children: [
					{
						leaf: true,
						text: 'VMware Horizon on VMware vSphere',
						userName: 'egvmview',
						iconCls : 'iconMonitorInterface',
						id: 'egvmview',
						capabilities : '<ul><li>End-to-End VMware Horizon VDI Monitoring</li><li>Correlating Desktop and VMware Virtualization Performance</li><li>Monitoring All Aspects of Horizon User Experience (Logon Simulation, Real User Logon Breakdown, App Launch, PCoIP, Blast)</li><li>Inside View of Desktops Showing Performance Issues</li></ul>',
						desc: 'VMware Horizon, VMware vSphere, EMC SAN, Horizon Logon Simulator'
					}
				]
			},
			{
				text: 'Cloud Monitoring (Apps/Desktops/Infra)',
				iconCls : 'iconGroup',
				hasPageLink: false,
				expanded: false,
				children: [
					{
						leaf: true,
						text: 'Office 365 Monitoring',
						userName: 'ego365',
						iconCls : 'iconMonitorInterface',
						id: 'ego365',
						capabilities : '<ul><li>In-Depth Monitoring of Microsoft Office 365, SharePoint Online, Exchange Online</li><li>Microsoft Exchange Logon Simulator (for Exchange Online)</li></ul>',
						desc: 'Office 365, Exchange Online, SharePoint Online, Exchange Logon Simulator, RUM, Network Device'
					},
					{
						leaf: true,
						text: 'Cloud Desktop Monitoring (DaaS)',
						userName: 'egclouddesktop',
						iconCls : 'iconMonitorInterface',
						id: 'egclouddesktop',
						capabilities : '<ul><li>Inside View of Cloud Desktop (Uses VM Agent)</li><li>Monitoring Virtual Desktops (PCoIP sessions) Hosted on Amazon WorkSpaces</li><li>Amazon WorkSpaces Logon Simulator</li></ul>',
						desc: 'Cloud Desktop, Amazon WorkSpaces Logon Simulator'
					},
					{
						leaf: true,
						text: 'Public Cloud Monitoring (AWS and Azure)',
						userName: 'egcloud',
						iconCls : 'iconMonitorInterface',
						id: 'egcloud1',
						capabilities : '<ul><li>Monitoring cloud-hosted AWS and Azure infrastructure and critical services</li><li>Monitoring applications running on the Public Cloud</li><li>Synthetic user experience monitoring for applications hosted on the cloud</li></ul>',
						desc: 'AWS, Azure, Java Application, SQL Server, IIS, AD, Emulated Client'
					}
				]
			},
			{
				text: 'Citrix XenMobile and ShareFile Monitoring',
				iconCls : 'iconGroup',
				hasPageLink: false,
				expanded: false,
				children: [
					{
						leaf: true,
						text: 'Citrix XenMobile and Sharefile',
						userName: 'egxenmobile',
						iconCls : 'iconMonitorInterface',
						id: 'egxenmobile',
						capabilities : '<ul><li>Performance Monitoring for XenMobile and ShareFile</li></ul>',
						desc: 'XenApp 7.x, XenMobile, ShareFile, NetScaler MAS, NetScaler VPX, Microsoft App-V, VMware vSphere'
					}
				]
			}
		]
	}
});



