Ext.define('DemoScenarios.view.PartnerGridView', {
	extend: 'utilities.TreeScrollPanel',
	alias : 'widget.PartnerGridView',
	id: 'PartnerGridView',

	requires: [
		'DemoScenarios.store.PartnerStore',
		'Ext.ux.RowExpander'
	],
	ui:'newGraphPanel treeview',
	autoScroll:true,
	scroll: false,
	title: 'eG Enterprise Demo Scenarios',
	rootVisible: false,
	//cls : 'treePanelDesign',
	layout:'auto',
	frame:false,
	border: false,
	useArrows: true,
	store:'PartnerStore',
	flex: 1,
	hideHeaders: true,
	rowBodyTrSelector: '.x-grid-rowbody-tr',
	rowBodyHiddenCls: 'x-grid-row-body-hidden',
	rowCollapsedCls: 'x-grid-row-collapsed',
	tools : [
		{
			xtype: 'container',
			margin: '0 1px 0 1px',
			items: [{
				xtype: 'button',
				width:'100%',
				id: 'ExpandPartner',
				enableToggle : true,
				currentStatus : 'collapsed',
				scope: this,
				html:'<div style="cursor:pointer;text-decoration:underline;float:right;font-size:9px;padding:2px" id="exx">Expand All</div>',
				style: {
					background: 'none',
					border: '0px'
				}
			}]
		}
	],
	plugins: [{
		ptype : 'rowexpander',
		getHeaderConfig: function() {
			var me = this,
				toggleRow = Ext.Function.bind(me.toggleRow, me),
				selectRowOnExpand = me.selectRowOnExpand;

			return {
				id: this.getHeaderId(),
				width: 24,
				sortable: false,
				resizable: false,
				draggable: false,
				hideable: false,
				menuDisabled: true,
				expanded: true,
				cls: Ext.baseCSSPrefix + 'grid-header-special',
				renderer: function(value, metadata,record, rowIdx, colIdx) {
					if (!Ext.isEmpty(record.get('userName')))
					{
						//metadata.tdCls = Ext.baseCSSPrefix + 'grid-cell-special';
						//return '<div style="display:none;" class="' + Ext.baseCSSPrefix + 'grid-row-expander">&#160;</div>';
					}
					else
					{
						//metadata.tdCls = Ext.baseCSSPrefix + 'grid-cell-special';
						//return '<div>&#160;</div>';
					}
				},
				processEvent: function(type, view, cell, recordIndex, cellIndex, e) {
					if (type == "mousedown" && e.getTarget('.x-grid-row-expander')) {
						var row = e.getTarget('.x-grid-row');
						toggleRow(row);
						return selectRowOnExpand;
					}
				}
			};
		},
		rowBodyTpl : [
			'{[this.getRowBodyView(values)]}',
			{
				getRowBodyView : function(values)
				{
					Ext.suspendLayouts();

					var tmpStr = "";
					if (!Ext.isEmpty(values.userName))
					{
						tmpStr = "<table cellpadding='10' border='0' cellspacing='0' style='width:98%'>";
						tmpStr = tmpStr + '<tr valign="top"><td width=50%><div>'+"<div style='word-break:break-all;padding:0px 2px 0px 0px;font-weight: normal;margin-left:10px'>Use Cases: </div>"+values.capabilities+'</div></td><td width=50%><div style="word-break:break-all;padding:0px 2px 0px 0px;font-weight: normal;margin-left:10px;">'+"Components: "+'</div><ul><li>'+values.desc+'</ul></li></div></td></tr>';
						tmpStr = tmpStr + "</table>";
					}
					return '<div style="padding-left: 2em;">'+tmpStr+'</div>';

					Ext.resumeLayouts(true);

				}
			}
		]
	}],
	columns: [
		{
			xtype: 'treecolumn',
			text : 'Domain',
			flex : 2,
			dataIndex : 'text',
			renderer:function(value)
			{
				return '<span style="font-family:LucidaGrandeBold;">'+value+'</span>';
			}
		},
		{
			text: 'User',
			flex: 2,
			sortable: true,
			dataIndex: 'userName',
			renderer:function(value)
			{
				if (username != null && username.toLowerCase() == 'egpartner_de')
				{
					if (!Ext.isEmpty(value))
					{
						value = value+'_de';
					}
				}
				return '<span style="font-family:LucidaGrandeBold;" class="user">'+value+'</span>';
			}
		}
	],

	viewConfig: {
		animate:false,
		listeners: 
		{
			afteritemcollapse: function(node, index, item, eOpts)
			{
				if (Ext.isIE == true) {
				  Ext.fly(item).removeCls('x-grid-tree-node-expanded');
				  
				}
			},
			afteritemexpand: function(node, index, item, eOpts)
			{
				if (Ext.isIE == true) {
					Ext.fly(item).addCls('x-grid-tree-node-expanded');
				}

				var endPos = index + node.childNodes.length;
				for (var i = index ;i<=endPos;i++ )
				{
					thisController.expandAllRow(i);
				}
			}
		}
	}
});



