Ext.define('egindex.controller.indexController',{
	extend:'Ext.app.Controller',
	refs:[
		{selector:'quicklinkprofile',ref:'quicklinkprofile'},
		{selector:'quicklinkmenuitem', ref:'quicklinkmenuitem'},
		{selector:'logotabset', ref:'logotabset'},
		{selector:'switchuserprofile', ref:'switchuserprofile'}
		],
	init:function(){
		setInterval("execute()",searchRefFrequency);
		appCnt=this;
		this.control({
			'button[id="EditBtn"]':
			{
				'click': this.editfn
			},
			'button[id="SubmitBtn"]':
			{
				'click': this.userprofilesave
			},
			'quicklinkmenuitem combo[id="reportType"]':
			{
				'change': this.comboLoad
			},
			'logotabset trigger[name="egsearches"]':
			{
				'keyup': this.searchfn,
				'afterrender': this.refreshfunction
			},
			'logotabset ':
			{
				'afterrender': this.logotabsetfunction
			},
			'button[id="UserSubmitBtn"]':
			{
				'click': this.goToSwitchProfileUrl
			},
			'tabset':
			{
				'afterrender': this.tabsetfunction
			},
			'logotabset trigger[name="egcommonsearch"]':
			{
				'keyup': this.commonSearchfn,
			}
		});


	},
	tabsetfunction: function()
	{
		if(isAlarmViewer == 'true' )
		{
			Ext.getCmp('monitorIconIndexMenuId').hide();
		}
	},
	logotabsetfunction: function()
	{
		if(isNewBrowWin == 'yes' && isNewBrowWin !=null)
		{
			Ext.getCmp('signout').hide();
			Ext.getCmp('monitortbseparatorId').hide();
		}
	},	
	refreshfunction: function()
	{
		if(displayTab!=null && displayTab!=undefined && displayTab!='monitor')
			return;

		if (isConfigGlobalSearch!=null && isConfigGlobalSearch=='true')
		{
			isConfigGlobalSearch = 'false';
			return;
		}		
		if(searchType.toLowerCase()=="user" || searchType.toLowerCase()=="vm")
		{
			if (this.checkSpecialCharacter(searchValue)) 
			{
				Ext.Msg.show({
					title: 'Search',
					msg: 'Special Characters are not allowed',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return;
			}
		}
		if(searchType.toLowerCase()=="segment" || searchType.toLowerCase()=="zone" || searchType.toLowerCase()=="server" || searchType.toLowerCase()=="service")
		{            
			var splChar = "`~!@#$%^&()+={}[]|\;\"'<>,?/";
			for (var i = 0; i < searchValue.length; i++) {
				check_char = splChar.indexOf(searchValue.charAt(i))				
				if (check_char >= 0) {
					Ext.Msg.show({
						title: 'Search',
						msg: 'Special Characters are not allowed',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return;					
				}
			}			
		}	

		if(searchType!=null && searchType != ""  && searchType!="undefined" && searchValue!=null && searchValue != ""  && searchValue!="undefined")
		{
			searchValue = searchValue.trim();
			Ext.getCmp('searchCombo').setValue(searchType);
			Ext.getCmp('egsearches').setValue(searchValue);
			
			if(searchType.toLowerCase()=="user" || searchType.toLowerCase()=="vm")
			{
				searchValue = this.replaceSpecialCharacter(searchValue,"'","|quots|");
				searchValue = this.replaceSpecialCharacter(searchValue,"#","|hash|");
				var inputvalue = searchType +" "+searchValue;
				this.loadUsersdata(inputvalue);
			}
			else if(searchType.toLowerCase()=="segment")
			{
				this.loadsegmentsdata(searchValue);
			}
			else if(searchType.toLowerCase()=="zone")
			{
				this.loadzonesdata(searchValue);
			}
			else if(searchType.toLowerCase()=="server")
			{
				this.loadserversdata(searchValue);
			}
			else if(searchType.toLowerCase()=="service")
			{
				this.loadservicesdata(searchValue);
			}
		}

	},
	removeglobalsessionvalue: function()
	{
		isWindowClosable = true;
		closeNotificationWindow('mangerNotificationWindow'); // close notification window if visible

		var genParams='removesession=yes&searchType='+searchType+'&searchValue='+searchValue;
        Ext.Ajax.request({
						url:'/final/servlet/com.eg.EgSearchController',
						method:'POST',
                        params:genParams,
						scope:this,
                        async:false,
						success:function(response)
						{

						   if(response.status == 200 && !Ext.isEmpty(response.responseText))
						   {

						   }
                        },

							failure : function(response){

          				       //Ext.Msg.alert('Failed!','Sorry! Problem occured111 ');
       			}

                     });


},
userprofilesave:function(btn)
{
	var regExp1=/^(\+\d\d)?[0-9]+$/g;
	var reg3 = /(((([\+]?([0-9]){4,15})|([\_\#]?([a-zA-Z0-9]+[\ \_\.\-\&\#]?)*[a-zA-Z0-9])+)\@[a-zA-Z0-9][\w\.-]*[a-zA-Z0-9]\.[a-zA-Z][a-zA-Z\.]*[a-zA-Z])|((\+\d\d)?[0-9]+))/g
	var checkToStr='';
	var checkCcStr='';
	var checkBccStr='';
	var criticalval1;
	var sub = true;
	var mailtoval=Ext.getCmp('mailTo').getValue();
	if(mailtoval!=null && mailtoval!="undefined")
	{
			checkToStr =mailtoval ;
	}
	var mailccval=Ext.getCmp('mailCC').getValue();
	if(mailccval!=null && mailccval!="undefined")
	{
			checkCcStr=mailccval ;
	}
	var mailbccval=Ext.getCmp('mailBCC').getValue();
	if(mailbccval!=null && mailbccval!="undefined")
	{
			checkBccStr=mailbccval;
	}

	var customScript = Ext.getCmp('Cmd').getValue();
	var checkScptStr = '';
	if (!Ext.isEmpty(customScript) && customScript != "undefined") 
	{
		checkScptStr = customScript;
	}

	var toMailResult=validateEmail(mailtoval);
	var ccMailResult=validateEmail(mailccval);
	var bccMailResult=validateEmail(mailbccval);
	var toMobResult=mailtoval.match(regExp1);
	var ccMobResult=mailccval.match(regExp1);
	var bccMobResult=mailbccval.match(regExp1);
	var toResult=mailtoval.match(reg3);
	var ccResult=mailccval.match(reg3);
	var bccResult=mailbccval.match(reg3);
	if((checkToStr != "") && (toMailResult==false && toMobResult == null) && (toResult != mailtoval))
	{
			var mailtomod=Ext.Msg.show({title:alertlbl,modal:false,msg:validMailandMobileNo,buttons: Ext.Msg.OK,icon: Ext.Msg.WARNING});
			mailtomod.alignTo(Ext.get('configModUserProfile'),'c-c');
			Ext.getCmp('mailTo').focus();
			//sub = false;
			return;
	}
	if ((checkCcStr != "") && (ccMailResult==null || ccMailResult==false) && ccMobResult == null && (ccResult!=mailccval))
	{
			var mailccmod=Ext.Msg.show({title:alertlbl,modal:false,msg:validMobileNumber,buttons: Ext.Msg.OK,icon: Ext.Msg.WARNING});
			mailccmod.alignTo(Ext.get('configModUserProfile'), 'c-c');
			Ext.getCmp('mailCC').focus();
			//sub = false;
			return;
	}
	if ((checkBccStr != "") && (bccMailResult==null || bccMailResult==false) && bccMobResult == null && bccResult !=mailbccval)
	{
			var mailbccmod=Ext.Msg.show({title:alertlbl,modal:false,msg:validEmailId,buttons: Ext.Msg.OK,icon: Ext.Msg.WARNING});
			mailbccmod.alignTo(Ext.get('configModUserProfile'), 'c-c');
			Ext.getCmp('mailBCC').focus();
			//sub = false;
			return;
	}
    if(!validateSingleByte(mailtoval))
	{
			var mailovalmod=Ext.Msg.show({title:alertlbl,modal:false,msg:toNotAllowed,buttons: Ext.Msg.OK,icon: Ext.Msg.WARNING});
			mailovalmod.alignTo(Ext.get('configModUserProfile'), 'c-c');
			Ext.getCmp('mailTo').focus();
			//sub = false;
			return;
	}
    if((checkCcStr != "") && !validateSingleByte(mailccval))
	{
			var mailccvalmod=Ext.Msg.show({title:alertlbl,modal:false,msg:ccNotAllowed,buttons: Ext.Msg.OK,icon: Ext.Msg.WARNING});
			mailccvalmod.alignTo(Ext.get('configModUserProfile'), 'c-c');
			Ext.getCmp('mailCC').focus();
			//sub = false;
			return;
	}
    if((checkBccStr != "") && !validateSingleByte(mailbccval))
	{
			var mailbccvalmod=Ext.Msg.show({title:alertlbl,modal:false,msg:bccNotAllowed,buttons: Ext.Msg.OK,icon: Ext.Msg.WARNING});
			mailbccvalmod.alignTo(Ext.get('configModUserProfile'), 'c-c');
			Ext.getCmp('mailBCC').focus();
			//sub = false;
			return;
	}
	if (!checkspecial(checkScptStr, "@*+=[]|;\"\'<>?`")) 
	{
		Ext.getCmp('Cmd').focus();
		sub = false;
		return;
	}

	if (!sub || checkScptStr != "")
	{
		if (Ext.getCmp('critical').pressed == false && Ext.getCmp('major').pressed == false && Ext.getCmp('minor').pressed == false) 
		{
			var msgbox1 =Ext.Msg.show({title:'Alert',modal:false,msg:"Please choose the type of alarms",buttons: Ext.Msg.OK,icon: Ext.Msg.WARNING});
			msgbox1.alignTo(Ext.get('configModUserProfile'), 'c-c');
			sub = false;
			return;
		}
	}
	var criticalval=Ext.getCmp('critical').pressed;
	if (criticalval ==true)
	criticalval="H";
	else
	criticalval="null";
	var majorval=Ext.getCmp('major').pressed;
	if (majorval ==true)
	majorval="I";
	else
	majorval="null";
	var minorval=Ext.getCmp('minor').pressed;
	if (minorval ==true)
	minorval="L";
	else
	minorval="null";
	//if(!sub || checkToStr != "")
	//{
       //if(Ext.getCmp('critical').pressed== false && Ext.getCmp('major').pressed == false && Ext.getCmp('minor').pressed == false)
	   //{
			//var msgbox1 =Ext.Msg.show({title:'Alert',modal:false,msg:"Please choose the type of alarms",buttons: Ext.Msg.OK,icon: Ext.Msg.WARNING});
			//msgbox1.alignTo(Ext.get('configModUserProfile'), 'c-c');
			//sub = false;
			//return;
       //}
	//}
	
	if(sub)
	{
		if((checkToStr =="" && checkToStr.length==0 ) && (checkCcStr != "" && checkCcStr.length>0))
		{
			var msgbox2 =Ext.Msg.show({title:'Alert',modal:false,msg:"Please enter valid To mail id and/or mobile number",buttons: Ext.Msg.OK,icon: Ext.Msg.WARNING});
			msgbox2.alignTo(Ext.get('configModUserProfile'), 'c-c');
			Ext.getCmp('mailTo').focus();
			sub = false;
			return;
		}
		if((checkToStr =="" && checkToStr.length==0 ) && (checkBccStr != "" && checkBccStr.length>0))
		{
			var msgbox3 =Ext.Msg.show({title:'Alert',modal:false,msg:"Please enter valid To mail id and/or mobile number",buttons: Ext.Msg.OK,icon: Ext.Msg.WARNING});
			msgbox3.alignTo(Ext.get('configModUserProfile'), 'c-c');
			Ext.getCmp('mailTo').focus();
			sub = false;
			return;
		}
		if((Ext.getCmp('minor').pressed) || (Ext.getCmp('critical').pressed)|| (Ext.getCmp('major').pressed))
		{
			if((checkToStr =="" && checkToStr.length==0) && (!Ext.isEmpty(enableCommand) && enableCommand.toLowerCase() == 'no'))
			{
				var msgbox4 =Ext.Msg.show({title:'Alert',modal:false,msg:"Please enter valid To mail id and/or mobile number",buttons: Ext.Msg.OK,icon: Ext.Msg.WARNING});
				msgbox4.alignTo(Ext.get('configModUserProfile'), 'c-c');
				Ext.getCmp('mailTo').focus();
				sub = false;
				return;
			}
		}
		if ((!Ext.isEmpty(Ext.getCmp('critical')) && Ext.getCmp('critical').pressed) || (!Ext.isEmpty(Ext.getCmp('major')) && Ext.getCmp('major').pressed) || (!Ext.isEmpty(Ext.getCmp('minor')) && Ext.getCmp('minor').pressed)) 
		{
			var orStr = " or ";
			var sep="'";
			var msgStr = "Please enter either"+sep+"To Mail ID/Mobile No"+sep+orStr+sep+"Command"+sep +".";
			if (!Ext.isEmpty(enableCommand) && enableCommand.toLowerCase() == 'no')
			{
				msgStr = "Please enter valid To mail id and/or mobile number";
			}
			if ((checkToStr == "" && checkToStr.length == 0) && (checkScptStr == "" && checkScptStr.length == 0)) {
				var msgbox5 =Ext.Msg.show({title:'Alert',modal:false,msg:msgStr,buttons: Ext.Msg.OK,icon: Ext.Msg.WARNING});
				msgbox5.alignTo(Ext.get('configModUserProfile'), 'c-c');
				Ext.getCmp('mailTo').focus();
				sub = false;
				return;
			}
		}
	}
 	var homepageval=Ext.getCmp('reportType2').getValue();
	if(isAlarmViewerUser=='true'){
			if(homepageval!='Current Alarms'){
				var msgbox5 =Ext.Msg.show({
					title: 'Alert',
					modal:false,
					msg: "You can set only Current Alarm page as home page",
	                buttons: Ext.Msg.OK,
		            icon: Ext.Msg.WARNING
				});
				msgbox5.alignTo(Ext.get('configModUserProfile'), 'c-c');
			    Ext.getCmp('reportType2').focus();
				return;
			}
		}
			var $_high = tempJsonData.hiddenParams["$_high"];
			var $_medium = tempJsonData.hiddenParams["$_medium"];
			var $_low = tempJsonData.hiddenParams["$_low"];
			var $_tomailid = tempJsonData.hiddenParams["$_tomailid"];
			var $_ccmailid = tempJsonData.hiddenParams["$_ccmailid"];
			var $_bccmailid = tempJsonData.hiddenParams["$_bccmailid"];
			var $_monitorHomePage = tempJsonData.hiddenParams["$_monitorHomePage"];
		if (!Ext.isEmpty(enableCommand) && enableCommand.toLowerCase() == 'yes')
		{
			var customScr =  Ext.getCmp('Cmd');
			if (customScr.isVisible() && !Ext.isEmpty(checkScptStr) && checkScptStr.length > 0)
			{
				var scptBuff = '';
				var stoken = checkScptStr.split(",");
				var script = "cmd:";
				for (var i=0;i<stoken.length; i++)
				{
					var scpttemp = stoken[i];

					scptBuff += script+scpttemp;
					if (stoken.length!=(i+1))
						scptBuff +=',';
				}
				customesc = scptBuff;
			}
		}
		var monitorHomeOptRadioGrpObj=Ext.getCmp('monitorHomeOpt');
		
		var monitorHomeOpt = '';
		if(!Ext.isEmpty(monitorHomeOptRadioGrpObj))
		{
			var monitorHomeOptObj = monitorHomeOptRadioGrpObj.getChecked();
			monitorHomeOpt=monitorHomeOptObj[0].inputValue;
		}
		var reloadManager=false;
		if(monitorHomeOpt!=null && monitorHomeOpt=='dynamic')
		{
			var previousSelectedOption=Ext.getCmp('reportType2').previousSelectedOption;
		
			if(homepageval!=null && homepageval!=previousSelectedOption)
			{
				reloadManager=true;
			}
		}
		else 
		{
			if(homepageval!=null && homepageval!=$_monitorHomePage)
			{
				reloadManager=true;
			}
		}
		Ext.Ajax.request({
			 url:"/final/scripts/EgIndexApp/data/EguserprofileQuickViewp.jsp?tomailid="+encodeURIComponent(mailtoval)+"&ccmailid="+encodeURIComponent(mailccval)+"&bccmailid="+encodeURIComponent(mailbccval)+"&high="+encodeURIComponent(criticalval)+"&medium="+encodeURIComponent(majorval)+"&low="+encodeURIComponent(minorval)+"&monitorHomePage="+encodeURIComponent(homepageval)+"&cmdescvalues="+encodeURIComponent(customesc)+"&entrypageval="+encodeURIComponent(entrypage)+"&$_low=" +encodeURIComponent($_low)+"&$_high=" + $_high +"&$_medium=" + $_medium+"&$_monitorHomePage= Monitor Home Page$" + $_monitorHomePage+"&$_tomailid= Mail ID / Mobile No To$" + encodeURIComponent($_tomailid)+"&$_ccmailid=Mail ID / Mobile No  Cc$" + encodeURIComponent($_ccmailid)+"&$_bccmailid=Mail ID / Mobile No  Bcc$" +encodeURIComponent($_bccmailid)+'&monitorHomePageOption='+monitorHomeOpt, 
			 method:'POST',
			 scope:this,
			 success:function(response)
			 {
				var jsonText = response.responseText;			
				var publicJson = Ext.decode(jsonText);								
				var resultalert=Ext.Msg.show({
					title:publicJson['Title'],
					modal:false,
					msg:publicJson['Msg'],
					buttons: Ext.Msg.OK,
					icon: "iconInformation",
					fn: function (buttonId) {
						if (buttonId == "ok") {
							
							if(reloadManager)
							{
								//window.location.reload();
								window.parent.location.href ='/final/egIndex.jsp?entry=monitor&displayTab=all&uname=&integritycheckviolated=false';
							}
							else
							{
								refreshEgIndexPage("userprofile_monitor_homepage");								
							}
						}
					}
				});	
				resultalert.alignTo(Ext.get('configModUserProfile'), 'c-c');
			 }
		});
 },

 editfn:function(btn)
{	
    var g = Ext.dom.Query.select(".iconUserIndex");
	var e = Ext.fly(g[0]);	
	Ext.get('userprofile').removeCls("selected_navigation");
	userproclicked=false;
	Ext.getCmp('configModUserProfile').destroy();
    document.getElementById('main').src="/final/admin/userProfile.jsp";

 },
replaceSpecialCharacter: function(name,src,target)
{
	var value='';
	var searchValue='';	
	for (var i = 0; i < name.length; i++) 
	{
		value = name.charAt(i);
		if(value==src)
		{
			value=value.replace(src,target);			
			searchValue+=value;
		}
		else
		{			
			searchValue+=value;
			continue;
		}
	}
	return searchValue;
},
checkSpecialCharacter: function (name) 
{
        var splChar = "%&+\"";

        for (var i = 0; i < name.length; i++) {
            check_char = splChar.indexOf(name.charAt(i))
            //Returns value 1 if the special character listed in splChar is found
            if (check_char >= 0) {
                return true;
            }
        }
        return false;
},
refreshSearch:function(val){
	if(val == null || val == undefined)
		val = Ext.getCmp("searchTrigger").getValue();
	if (Ext.isEmpty(val) || val == null || val == undefined){
		Ext.Msg.show({title:searchLbl,msg:validSearchPrefix+"  '*'",buttons: Ext.Msg.OK,icon: Ext.Msg.WARNING});
		return;
	}
	val = val.trim()
	var genParams='searchValue='+val+'&fromCommonSearch=yes';
	Ext.Ajax.request({
		url:'/final/servlet/com.eg.EgSearchController',
		method:'POST',
		params:genParams,
		scope:this,
		async:false,
		success:function(response)
		{
			if(response.status == 200 && !Ext.isEmpty(response.responseText))
			{
				var jsonData=Ext.decode(response.responseText);
				jsonData = jsonData.SearchData;
				var searchWin = Ext.getCmp("commonSearchWin");
				if(!Ext.isEmpty(searchWin) && searchWin != null){
					var itemsArray = new Array();

					if(Ext.isEmpty(jsonData) || jsonData == null || jsonData == undefined){
						searchWin.removeAll();
						//searchWin.removeDocked(Ext.getCmp("commonSearchWin").getDockedItems());
						var nodataDockedItemsArray = this.createNodataDockedItems();
						if (itemsArray=="" || itemsArray==null || itemsArray=="undefined" )
						{
							if (Ext.getCmp("timelineLabel"))
									Ext.getCmp("timelineLabel").update("");

							itemsArray.push({
								xtype:'container',
								margin:'100 0 0 0',
								html:'<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="f14-normal iconInformation" style="margin:0px auto"></div><div style="text-align:center">Search string is not found in components,services,segments,zones or users.</div></div></div>'
							});
							searchWin.add(itemsArray);
							searchWin.setSize(500,300);
						}
					}
					else{
							if (Ext.getCmp("timelineLabel"))
									Ext.getCmp("timelineLabel").update("showing results for last 24 hours");
							
						searchWin.removeAll();
						var itemsArray = this.createItemsArray(jsonData,val);
						searchWin.add(itemsArray);
						searchWin.setSize(635,535);
						searchWin.doLayout();
					}
					Ext.getCmp("searchTrigger").setValue(val);
					Ext.getCmp('searchTrigger').focus(true,10);
				}
			}
		},
		failure : function(response){
		}
	});
},
commonSearchfn:function(obj,e){
	var searchval = '';
	if(( e != undefined && e.type == 'keyup' && e.getKey()==e.ENTER )  || ( e == undefined ))
	{
		searchval=obj.getValue();
		searchval = searchval.trim();
		if (Ext.isEmpty(searchval) || searchval == null || searchval == undefined){
			Ext.Msg.show({title:searchLbl,msg:validSearchPrefix+"  '*'",buttons: Ext.Msg.OK,icon: Ext.Msg.WARNING});
			return;
		}
		var genParams='searchValue='+searchval+'&fromCommonSearch=yes';
        Ext.Ajax.request({
			url:'/final/servlet/com.eg.EgSearchController',
			method:'POST',
			params:genParams,
			scope:this,
			async:false,
			success:function(response)
			{
				if(response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonData=Ext.decode(response.responseText);
					var isLink = jsonData.isLink;
					if(isLink == 'true'){
						jsonData = jsonData.SearchData;
						var mainIframe = document.getElementById("main");
						mainIframe.src = jsonData;
					}
					else{
						jsonData = jsonData.SearchData;
						this.loadSearchWindow(jsonData,searchval);
						Ext.getCmp("searchTrigger").setValue(searchval);
						Ext.getCmp('searchTrigger').focus(true,10);
					}
				}
			},
			failure : function(response){
			}
		});
	}
},
createInnerItemsArray:function(data,showState){
	var innerItemsArray = new Array();
	if(showState){
		for ( var i = 0; i < data.length; i++) {
			innerItemsArray.push({
				columnWidth:0.20,
				xtype:'container',
				padding:'0 10 0 10',
				html:'<div style="margin:auto"><a href="javascript:void(0)"> <div onclick="loadLinkURL(\''+data[i].href+'\')" onmouseover="javascript:void(0)"><div class="'+data[i].cssClass+'"><div class="state_'+data[i].state+' searchStatePos" ></div></div><div class="crl"></div><div class="f11-normal labelAlignCenter searchLabelElipsis" data-qtip="'+data[i].displayName+'">'+data[i].displayName+'</div></div></a></div>'
			});
		}
	}
	else{
		for ( var i = 0; i < data.length; i++) {
			innerItemsArray.push({
				columnWidth:0.20,
				xtype:'container',
				padding:'0 10 0 10',
				html:'<div><a href="javascript:void(0)"> <div onclick="loadLinkURL(\''+data[i].href+'\')" onmouseover="javascript:void(0)"><div class="'+data[i].image+'"></div><div class="crl"></div><div class="f11-normal labelAlignCenter searchLabelElipsis" data-qtip="'+data[i].name+'">'+data[i].name+'</div></div></a></div>'
			});
		}
	}
	return innerItemsArray;
},
createItemsArray:function(jsonData,searchval){
	var itemsArray = new Array();
	var innerItemsArray = new Array();
	var data = jsonData.User;
	var showMore = true;
	if(!Ext.isEmpty(jsonData.User_ShowMore) && jsonData.User_ShowMore != null && jsonData.User_ShowMore != undefined)
		showMore = false;

	if(!Ext.isEmpty(data) && data != null){
		var me=this;
		innerItemsArray = this.createInnerItemsArray(data);
		itemsArray.push({
			xtype:'panel',
			margin:'7 0 0 0',
			layout:'column',
			cls:'indexSearchPopup',
			padding:0,
			dockedItems:[{
				xtype: 'toolbar',
				dock: 'top',
				items: [{
					xtype:'label',
					height:15,
					cls:'f12-bold',
					margin:'0 0 0 10',
					text: 'USERS'
				},
				'->',
				{
					xtype:'label',
					height:15,
					cls:'f10-bold mouse',
					text: 'Show More',
					hidden:showMore,
					listeners:{
						afterrender:function(){
							//var me=this;
							this.el.on('click',function(){
								//var mainIframe = document.getElementById("main");
								//mainIframe.src="./servlet/com.eg.EgSearchController?searchuser=user%20se&eg_tbound=Fixed"
								var searchType = '';
								var searchValue = searchval;
								if(searchval.indexOf(" ") > 0){
									searchType = searchval.substring(0,searchval.indexOf(" "));
									searchValue = searchval.substring(searchval.indexOf(" ")+1);
								}
								var inputvalue = "user "+searchValue;
								me.loadUsersdata(inputvalue);
								Ext.getCmp('commonSearchWin').close();
								Ext.getCmp("egcommonsearch").setValue("");
								Ext.getCmp('egcommonsearch').focus(true,10);
						   });
						}
					}
				}]
			}],
			//items:Ext.util.Format.ellipsis(innerItemsArray, 20)
			items:innerItemsArray
		});
	}
	data = jsonData.VMDesktop;
	showMore = true;
	if(!Ext.isEmpty(jsonData.VMDesktop_ShowMore) && jsonData.VMDesktop_ShowMore != null && jsonData.VMDesktop_ShowMore != undefined)
		showMore = false;
	if(data != null && !Ext.isEmpty(data)){
		var me=this;
		innerItemsArray = this.createInnerItemsArray(data);
		itemsArray.push({
			xtype:'panel',
			margin:'7 0 0 0',
			layout:'column',
			cls:'indexSearchPopup',
			padding:0,
			dockedItems:[{
				xtype: 'toolbar',
				dock: 'top',
				items: [{
						xtype:'label',
						height:15,
						cls:'f12-bold',
						margin:'0 0 0 10',
						text: 'VM/DESKTOPS'
				},'->',
				{
					xtype:'label',
					height:15,
					cls:'f10-bold mouse',
					text: 'Show More',
					hidden:showMore,
					listeners:{
						afterrender:function(){
							//var me=this;
							this.el.on('click',function(){
								//var mainIframe = document.getElementById("main");
								//mainIframe.src="/final/servlet/com.eg.EgSearchController?searchuser=user%20se&eg_tbound=Fixed"
								var searchType = '';
								var searchValue = searchval;
								if(searchval.indexOf(" ") > 0){
									searchType = searchval.substring(0,searchval.indexOf(" "));
									searchValue = searchval.substring(searchval.indexOf(" ")+1);
								}
								var inputvalue = "vm "+searchValue;
								me.loadUsersdata(inputvalue);
								Ext.getCmp('commonSearchWin').close();
								Ext.getCmp("egcommonsearch").setValue("");
								Ext.getCmp('egcommonsearch').focus(true,10);
						   });
						}
					}
				}]
			}],
			items:innerItemsArray
		});
	}
	innerItemsArray = new Array();
	data = jsonData.Zones;
	showMore = true;
	if(!Ext.isEmpty(jsonData.Zones_ShowMore) && jsonData.Zones_ShowMore != null && jsonData.Zones_ShowMore != undefined)
		showMore = false;
	if(data != null && !Ext.isEmpty(data)){
		var me=this;
		innerItemsArray = this.createInnerItemsArray(data,true);
		itemsArray.push({
			xtype:'panel',
			margin:'7 0 0 0',
			layout:'column',
			cls:'indexSearchPopup',
			padding:0,
			dockedItems:[{
				xtype: 'toolbar',
				dock: 'top',
				items: [{
					xtype:'label',
					height:15,
					cls:'f12-bold',
					margin:'0 0 0 10',
					text: 'ZONE'
				},'->',
				{
					xtype:'label',
					height:15,
					cls:'f10-bold mouse',
					text: 'Show More',
					hidden:showMore,
					listeners:{
						afterrender:function(){
							this.el.on('click',function(){
								me.loadzonesdata(searchval);
								Ext.getCmp('commonSearchWin').close();
								Ext.getCmp("egcommonsearch").setValue("");
								Ext.getCmp('egcommonsearch').focus(true,10);
						   });
						}
					}
				}]
			}],
			items:innerItemsArray
		});
	}
	innerItemsArray = new Array();
	data = jsonData.Services;
	showMore = true;
	if(!Ext.isEmpty(jsonData.Services_ShowMore) && jsonData.Services_ShowMore != null && jsonData.Services_ShowMore != undefined)
		showMore = false;
	if(data != null && !Ext.isEmpty(data)){
		var me=this;
		innerItemsArray = this.createInnerItemsArray(data,true);
		itemsArray.push({
			xtype:'panel',
			margin:'7 0 0 0',
			layout:'column',
			cls:'indexSearchPopup',
			padding:0,
			dockedItems:[{
				xtype: 'toolbar',
				dock: 'top',
				items: [{
					xtype:'label',
					height:15,
					cls:'f12-bold',
					margin:'0 0 0 10',
					text: 'SERVICE'
				},'->',
				{
					xtype:'label',
					height:15,
					cls:'f10-bold mouse',
					text: 'Show More',
					hidden:showMore,
					listeners:{
						afterrender:function(){
							this.el.on('click',function(){
								me.loadservicesdata(searchval);
								Ext.getCmp('commonSearchWin').close();
								Ext.getCmp("egcommonsearch").setValue("");
								Ext.getCmp('egcommonsearch').focus(true,10);
						   });
						}
					}
				}]
			}],
			items:innerItemsArray
		});
	}
	innerItemsArray = new Array();
	data = jsonData.Segments;
	showMore = true;
	if(!Ext.isEmpty(jsonData.Segments_ShowMore) && jsonData.Segments_ShowMore != null && jsonData.Segments_ShowMore != undefined)
		showMore = false;
	if(data != null && !Ext.isEmpty(data)){
		var me=this;
		innerItemsArray = this.createInnerItemsArray(data,true);
		itemsArray.push({
			xtype:'panel',
			margin:'7 0 0 0',
			layout:'column',
			cls:'indexSearchPopup',
			padding:0,
			dockedItems:[{
				xtype: 'toolbar',
				dock: 'top',
				items: [{
					xtype:'label',
					height:15,
					cls:'f12-bold',
					margin:'0 0 0 10',
					text: 'SEGMENT'
				},'->',
				{
					xtype:'label',
					height:15,
					cls:'f10-bold mouse',
					text: 'Show More',
					hidden:showMore,
					listeners:{
						afterrender:function(){
							this.el.on('click',function(){
								me.loadsegmentsdata(searchval);
								Ext.getCmp('commonSearchWin').close();
								Ext.getCmp("egcommonsearch").setValue("");
								Ext.getCmp('egcommonsearch').focus(true,10);
						   });
						}
					}
				}]
			}],
			items:innerItemsArray
		});
	}
	innerItemsArray = new Array();
	data = jsonData.Components;
	showMore = true;
	if(!Ext.isEmpty(jsonData.Components_ShowMore) && jsonData.Components_ShowMore != null && jsonData.Components_ShowMore != undefined)
		showMore = false;
	if(data != null && !Ext.isEmpty(data)){
		var me=this;
		innerItemsArray = this.createInnerItemsArray(data,true);
		itemsArray.push({
			xtype:'panel',
			margin:'7 0 0 0',
			layout:'column',
			cls:'indexSearchPopup',
			padding:0,
			dockedItems:[{
				xtype: 'toolbar',
				dock: 'top',
				items: [{
					xtype:'label',
					height:15,
					cls:'f12-bold',
					margin:'0 0 0 10',
					text: 'COMPONENTS'
				},'->',
				{
					xtype:'label',
					height:15,
					cls:'f10-bold mouse',
					text: 'Show More',
					hidden:showMore,
					listeners:{
						afterrender:function(){
							this.el.on('click',function(){
								me.loadserversdata(searchval);
								Ext.getCmp('commonSearchWin').close();
								Ext.getCmp("egcommonsearch").setValue("");
								Ext.getCmp('egcommonsearch').focus(true,10);
						   });
						}
					}
				}]
			}],
			items:innerItemsArray
		});
	}
	return itemsArray;
},
createNodataDockedItems:function(){

	var itemsArrayNodata = new Array();
	var me=this;

	if (itemsArrayNodata!="" || itemsArrayNodata!=null || itemsArrayNodata!="undefined" )
	{
		//alert("data available");
		//itemsArray.removeDocked(me.createDockedItems());
	itemsArrayNodata.push({
		xtype:'toolbar',
		cls:'searchPopupHeadBorder',
		layout:'hbox',
		//style:{'border':'1px solid red'},
		margin:'5 10 5 10',
		items:[{  // Let's put an empty grid in just to illustrate fit layout
				xtype:'trigger',
				ui: 'SearchCombo inputSearchIcon',
				width:300,
				id:'searchTrigger',
				listeners:{
					afterrender:function(cmp){
						this.el.on('keyup',function(e){
							if( e != undefined && e.getKey()==e.ENTER ){
								me.refreshSearch();
							}
						});
					}
				}
			},
			'->',
			{
				xtype:'button',
				cls:'iconClose',
				width:16,
				//floatable:true,
				margin:'0 0 0 0',
				//id:'commonSearchWinClose',
				style:{'border':'none'},
				//dock:'top',
				handler: function () { 
						this.up('window').close(); 
						Ext.getCmp("egcommonsearch").setValue("");
						Ext.getCmp('egcommonsearch').focus(true,10);
					}
			}]
	});
		return itemsArrayNodata;
		
	}
	itemsArrayNodata.doLayout();
},
createDockedItems:function(){

	var itemsArray = new Array();
	var me=this;
	if (itemsArray!="" || itemsArray!=null || itemsArray!="undefined" )
	{
	itemsArray.push({
		xtype:'toolbar',
		cls:'searchPopupHeadBorder',
		layout:'hbox',
		//style:{'border':'1px solid red'},
		margin:'5 10 5 10',
		items:[{  // Let's put an empty grid in just to illustrate fit layout
				xtype:'trigger',
				ui: 'SearchCombo inputSearchIcon',
				width:300,
				id:'searchTrigger',
				listeners:{
					afterrender:function(cmp){
						this.el.on('keyup',function(e){
							if( e != undefined && e.getKey()==e.ENTER ){
								me.refreshSearch();
							}
						});
					}
				}
			},
			'->',
			{
				xtype:'container',
				cls:'f10-normal',
				padding:'0 0 0 0',
				//hidden:false,
				id:'timelineLabel',
				html:'showing results for last 24 hours'
				
			},
			{
				xtype:'button',
				cls:'iconClose',
				width:16,
				//floatable:true,
				margin:'0 0 0 0',
				//id:'commonSearchWinClose',
				style:{'border':'none'},
				//dock:'top',
				handler: function () { 
						this.up('window').close(); 
						Ext.getCmp("egcommonsearch").setValue("");
						Ext.getCmp('egcommonsearch').focus(true,10);
					}
			}]
	});
		return itemsArray;
	}
},
loadSearchWindow:function(jsonData,searchval){
	var searchWin = '';
	var searchBoxPos=Ext.getCmp("egcommonsearch").getPosition();
	if(Ext.isEmpty(jsonData) || jsonData == null){
			var nodataDockedItemsArray = this.createNodataDockedItems();
			var me = this;
			searchWin=Ext.create('Ext.window.Window', {
				hideHeader:true,
				header:false,
				height: 300,
				width: 500,
				shadow: 'drop',
				shadowOffset: 10,
				bodyPadding:'0 14 14 14',
				//closable:true,
				resizable:false,
				//iconCls:'iconClose',
				ui:'searchPopup',
				id:'commonSearchWin',
				autoScroll:true,
				dockedItems:nodataDockedItemsArray,
				listeners:{
					show : function(win) {
						Ext.create('Ext.util.KeyNav', win.getEl(), {
						  "esc" : function(e){
							win.hide();
						  },
						  scope: win
						});
                  }
				},
				items: [{
						xtype:'container',
						margin:'100 0 0 0',
						html:'<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="f14-normal iconInformation" style="margin:0px auto"></div><div style="text-align:center">Search string is not found in components,services,segments,zones or users.</div></div></div>'
				}]

			}).showAt(searchBoxPos);
			//searchWin.alignTo(Ext.getBody(), "tr-tr", [-250, 15]);
			return searchWin;

			if (Ext.getCmp('timelineLabel'))
				Ext.getCmp('timelineLabel').hide();
	}
	else{
		var itemsArray = this.createItemsArray(jsonData,searchval);
		var dockedItemsArray = this.createDockedItems();
		searchWin=Ext.create('Ext.window.Window', {
			hideHeader:true,
			header:false,
			height: 535,
			width: 635,
			shadow: 'drop',
			shadowOffset: 10,
			bodyPadding:'0 14 12 22',
			//closable:true,
			resizable:false,
			layout:'anchor',
			//iconCls:'iconClose',
			ui:'searchPopup',
			id:'commonSearchWin',
			autoScroll:true,
			dockedItems:dockedItemsArray,
			listeners:{
				show : function(win) {
					Ext.create('Ext.util.KeyNav', win.getEl(), {
					  "esc" : function(e){
						win.hide();
					  },
					  scope: win
					});
			  }
			},
			items:itemsArray
		}).showAt(searchBoxPos);
		
		if (Ext.getCmp('timelineLabel'))
				Ext.getCmp('timelineLabel').show();
		//searchWin.alignTo(Ext.getBody(), "tr-tr", [-250, 15]);
		return searchWin;
	}
	
	
},
searchfn:function(obj,e)
{
	var inputvalue = '',searchval = '';
	var searchType = Ext.getCmp('searchCombo').getValue();	
	if( searchType!=null && searchType!=undefined && !Ext.isEmpty(searchType) && (( e != undefined && e.type == 'keyup' && e.getKey()==e.ENTER )  || ( e == undefined )) )
	{
		if (isConfigGlobalSearch!=null && isConfigGlobalSearch=='true')
		{
			isConfigGlobalSearch = 'false';
			return;
		}
		searchval=obj.getValue();
		searchval = searchval.trim();
		if(searchType.toLowerCase()=="user" || searchType.toLowerCase()=="vm")
		{
			if (this.checkSpecialCharacter(searchval)) 
			{
				Ext.Msg.show({
					title: 'Search',
					msg: 'Special Characters are not allowed',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return;
			}
		}
		if(searchType.toLowerCase()=="segment" || searchType.toLowerCase()=="zone" || searchType.toLowerCase()=="server" || searchType.toLowerCase()=="service")
		{            
			var splChar = "`~!@#$%^&()+={}[]|\;\"'<>,?/";
			for (var i = 0; i < searchval.length; i++) {
				check_char = splChar.indexOf(searchval.charAt(i))				
				if (check_char >= 0) {
					Ext.Msg.show({
						title: 'Search',
						msg: 'Special Characters are not allowed',
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return;					
				}
			}			
		}		
		if(searchval!='' && searchval!=null && searchval!=undefined)
		{
			if(searchType.toLowerCase()=="user" || searchType.toLowerCase()=="vm")
			{
				searchval = this.replaceSpecialCharacter(searchval,"'","|quots|");
				searchval = this.replaceSpecialCharacter(searchval,"#","|hash|");
				
				searchval = parent.filterEncode(searchval);
				searchval = encodeURIComponent(searchval);
				inputvalue = searchType+" "+searchval;				
				this.loadUsersdata(inputvalue);
			}
			else if(searchType.toLowerCase()=="segment")
			{
				this.loadsegmentsdata(searchval);
			}
			else if(searchType.toLowerCase()=="zone")
			{
				this.loadzonesdata(searchval);
			}
			else if(searchType.toLowerCase()=="server")
			{
				this.loadserversdata(searchval);
			}
			else if(searchType.toLowerCase()=="service")
			{
				this.loadservicesdata(searchval);
			}
		}
		else
		{
			Ext.Msg.show({title:searchLbl,msg:validSearchPrefix+"  '*'",buttons: Ext.Msg.OK,icon: Ext.Msg.WARNING});
		}
	}
	// Showing and hidding the trigger field
	if(!Ext.isEmpty(obj.getValue())){
		Ext.fly(obj.triggerEl.elements[0].dom).setStyle("background-image","url('/final/images/Light/search_trigger_close.png')");
		Ext.fly(obj.triggerEl.elements[0].dom).set({
						"data-qtip": "Clear",
						"data-qclass":"light_theme_yellowTip"
		});
		return false;
	}else{
		Ext.fly(obj.triggerEl.elements[0].dom).setStyle('background-image','none');
		Ext.fly(obj.triggerEl.elements[0].dom).set({
						"data-qtip": "",
						"data-qclass":""
		});
		return false;
	}
 },
loadUsersdata:function(searchvalue)
{	 
    var genParams='',splitsearchval='';
    searchvalues=searchvalue;
	splitsearchval=searchvalue.split(" ");
	if(splitsearchval[0].toLowerCase()=="vm")
	{
	       genParams='searchuser='+searchvalue+'&state=any&eg_tbound=Fixed';
		   searchvalues="vm "+searchvalue;
	 }
	 if(splitsearchval[0].toLowerCase()=="user")
	 {
	       genParams='searchuser='+searchvalue+'&eg_tbound=Fixed';
		   searchvalues="user "+searchvalue;
	 }
	 genParams+='&fromSearch='+splitsearchval[0]+'&entry=monitor&fromPage=GlobalSearch';
	 this.searchTabChange(genParams);
	var parantSearchval=null;
	if(opener!=null && opener!=undefined)
	{
		parantSearchval = opener.window.parent.Ext.getCmp('egsearches');
	}
	else if(window.parent!=null && window.parent!=undefined)
	{
		parantSearchval = window.parent.Ext.getCmp('egsearches');
	}
	if(!Ext.isEmpty(parantSearchval) && parantSearchval!=null && parantSearchval!='undefined')
	{
		if(opener!=null && opener!=undefined)
		{
			opener.window.parent.Ext.getCmp('searchCombo').setValue(splitsearchval[0]);
			opener.window.parent.Ext.getCmp('egsearches').setValue(splitsearchval[1]);
			opener.window.parent.searchvalues=searchvalues;
		}
	}
},
loadsegmentsdata:function(searchvalue)
{
	var searchType = '';
	if(searchvalue.indexOf(" ") > 0){
		searchType = searchvalue.substring(0,searchvalue.indexOf(" "));
		searchvalue = searchvalue.substring(searchvalue.indexOf(" ")+1);
	}
	globalsearch=true;
	segmentSearchval=searchvalue;
	var segmentUrl = '';
	if (searchvalue=="*")
	{
	    segmentUrl='monCmd=segmentList&from=MainDashboard&action=globalsearchallsegment&treeOpen='+segmenttreeOpenval+'&entry=monitor&fromPage=GlobalSearch';
		segmentSearchval="segment "+searchvalue;
	}
	else
    {
	   segmentUrl='monCmd=segmentList&from=segmentList&action=globalsearch&searchString='+encodeURIComponent(segmentSearchval)+'&treeOpen='+segmenttreeOpenval+'&entry=monitor&fromPage=GlobalSearch';
	   segmentSearchval="segment "+searchvalue;
	}
	segmentUrl +='&fromSearch=segment';
	this.searchTabChange(segmentUrl);
	var parantSearchval=null;
	if(opener!=null && opener!=undefined)
	{
		parantSearchval = opener.window.parent.Ext.getCmp('egsearches');
	}
	else if(window.parent!=null && window.parent!=undefined)
	{
		parantSearchval = window.parent.Ext.getCmp('egsearches');
	}
	if(!Ext.isEmpty(parantSearchval) && parantSearchval!=null && parantSearchval!='undefined')
	{
		if(opener!=null && opener!=undefined)
		{
			opener.window.parent.Ext.getCmp('searchCombo').setValue("segment");
			opener.window.parent.Ext.getCmp('egsearches').setValue(searchvalue);
			opener.window.parent.segmentSearchval=segmentSearchval;
		}
	}
},
loadzonesdata:function(searchvalue)
{
	var searchType = '';
	if(searchvalue.indexOf(" ") > 0){
		searchType = searchvalue.substring(0,searchvalue.indexOf(" "));
		searchvalue = searchvalue.substring(searchvalue.indexOf(" ")+1);
	}
	globalsearch=true;
	zoneSearchval=searchvalue;
	var zoneUrl = '';
	if (searchvalue=="*")
	{
	    zoneUrl='monCmd=zoneList&from=MainDashboard&action=globalsearchallzone&treeOpen='+zonetreeOpenval+'&entry=monitor&fromPage=GlobalSearch';
		zoneSearchval="zone "+searchvalue;
	}
	else
    {
	   zoneUrl='monCmd=zoneList&from=zoneList&action=globalsearch&searchString='+encodeURIComponent(zoneSearchval)+'&treeOpen='+zonetreeOpenval+'&entry=monitor&fromPage=GlobalSearch';
	   zoneSearchval="zone "+searchvalue;
	}
	zoneUrl+='&fromSearch=zone';
	this.searchTabChange(zoneUrl);
	var parantSearchval=null;
	if(opener!=null && opener!=undefined)
	{
		parantSearchval = opener.window.parent.Ext.getCmp('egsearches');
	}
	else if(window.parent!=null && window.parent!=undefined)
	{
		parantSearchval = window.parent.Ext.getCmp('egsearches');
	}
	if(!Ext.isEmpty(parantSearchval) && parantSearchval!=null && parantSearchval!='undefined')
	{
		if(opener!=null && opener!=undefined)
		{
			opener.window.parent.Ext.getCmp('searchCombo').setValue("zone");
			opener.window.parent.Ext.getCmp('egsearches').setValue(searchvalue);
			opener.window.parent.zoneSearchval=zoneSearchval;
		}
	}
},
loadserversdata:function(searchvalue)
{
	globalsearch=true;
	serverSearchval=searchvalue;
	servertypeval='';
	var searchType = '';
	if(searchvalue.indexOf(" ") > 0){
		searchType = searchvalue.substring(0,searchvalue.indexOf(" "));
		searchvalue = searchvalue.substring(searchvalue.indexOf(" ")+1);
	}

	if(!Ext.isEmpty(searchType) && searchType != null && searchType.toLowerCase() == 'component')
		serverSearchval = searchvalue;
	else{
		servertypeval = searchvalue;
		serverSearchval='';
	}
	
	var serverListURL = '';
	if (searchvalue=="*")
	{
		serverListURL='monCmd=componentList&from=TreeMenu&action=globalsearchallcomponent&searchIndComps=checked&treeOpen='+serverstreeOpenval+'&entry=monitor&fromPage=GlobalSearch';
		serverSearchval="server "+searchvalue;
	}
	else
    {
	      serverListURL='monCmd=componentList&from=componentList&action=search&searchStateString=All States&searchNameString='+encodeURIComponent(serverSearchval)+'&selTypeString=AllServers&searchTypeString='+servertypeval+'&searchIndComps=on&treeOpen='+serverstreeOpenval+'&entry=monitor&fromPage=GlobalSearch';

	      serverSearchval="server "+searchvalue;
	}
	serverListURL+='&fromSearch=server';
	this.searchTabChange(serverListURL);
	var parantSearchval=null;
	if(opener!=null && opener!=undefined)
	{
		parantSearchval = opener.window.parent.Ext.getCmp('egsearches');
	}
	else if(window.parent!=null && window.parent!=undefined)
	{
		parantSearchval = window.parent.Ext.getCmp('egsearches');
	}
	if(!Ext.isEmpty(parantSearchval) && parantSearchval!=null && parantSearchval!='undefined')
	{
		if(opener!=null && opener!=undefined)
		{
			opener.window.parent.Ext.getCmp('searchCombo').setValue("server");
			opener.window.parent.Ext.getCmp('egsearches').setValue(searchvalue);
			opener.window.parent.serverSearchval=serverSearchval;
		}
	}
},
loadservicesdata:function(searchvalue)
{
	var searchType = '';
	if(searchvalue.indexOf(" ") > 0){
		searchType = searchvalue.substring(0,searchvalue.indexOf(" "));
		searchvalue = searchvalue.substring(searchvalue.indexOf(" ")+1);
	}
	globalsearch=true;
	serviceSearchval=searchvalue;
	var serviceUrl = '';
	if (searchvalue=="*")
	{
	    serviceUrl='monCmd=serviceList&from=MainDashboard&action=globalsearchallservice&treeOpen='+servicetreeOpenval+'&entry=monitor&fromPage=GlobalSearch';
		serviceSearchval="service "+searchvalue;
	}
	else
    {
	   serviceUrl='monCmd=serviceList&from=serviceList&action=globalsearch&searchString='+encodeURIComponent(serviceSearchval)+'&treeOpen='+servicetreeOpenval+'&entry=monitor&fromPage=GlobalSearch';
	   serviceSearchval="service "+searchvalue;
	}
	serviceUrl+='&fromSearch=service';
	this.searchTabChange(serviceUrl);
	var parantSearchval=null;
	if(opener!=null && opener!=undefined)
	{
		parantSearchval = opener.window.parent.Ext.getCmp('egsearches');
	}
	else if(window.parent!=null && window.parent!=undefined)
	{
		parantSearchval = window.parent.Ext.getCmp('egsearches');
	}
	if(!Ext.isEmpty(parantSearchval) && parantSearchval!=null && parantSearchval!='undefined')
	{
		if(opener!=null && opener!=undefined)
		{
			opener.window.parent.Ext.getCmp('searchCombo').setValue("service");
			opener.window.parent.Ext.getCmp('egsearches').setValue(searchvalue);
			opener.window.parent.serviceSearchval=serviceSearchval;
		}
	}
	
	

},
searchTabChange: function(url)
{
	lastTabQueryString=url;
	Ext.Ajax.request({
		url : '/final/scripts/EgIndexApp/data/egIndexJson.jsp',
		method : 'POST',
		params : url,
		//async : false,
		success : function(response)
		{
			var jsonText=response.responseText;
			var jsonData=Ext.decode(jsonText);
			isShowAlarmsInLightBox=jsonData['isShowAlarmsInLightBox'];
			homepage=jsonData['homepage'];
			smartHomePage=jsonData['smartHomePage'];
			url=jsonData['url'];		
			adminPressed=eval(jsonData['adminPressed']);
			monitorPressed=jsonData['monitorPressed'];
			reporterPressed=jsonData['reporterPressed'];
			configPressed=jsonData['configPressed'];
			slaPressed=jsonData['slaPressed'];
			isUsersLimitCrossed=jsonData['isUsersLimitCrossed'];
			alertUserAbtUserCert=jsonData['alertUserAbtUserCert'];
			userExpiryMsg=jsonData['userExpiryMsg'];
			isLicenseEnabled=jsonData['isLicenseEnabled'];
			isLicenceValid=jsonData['isLicenceValid'];
			var previousSkin=jsonData['previousSkin'];
			var currentSkin=jsonData['currentSkin'];
			logoImageName = jsonData['LogoImageName'];
			moduleName=jsonData['moduleName'];
			egTheme=jsonData['egTheme'];
			selectedTabTheme=jsonData['selectedTabTheme'];
			hideAlarmPopup=jsonData['hideAlarmPopup'];
			//HomePageURL=homepage;
			Ext.getCmp('help').helpUrl=jsonData['helpURL'];
			//document.getElementById("hidHomePageURL").value=homepage;
			//$("a[id='monitor_homepage_anch']").attr('href',HomePageURL);

			$('link[href="'+previousSkin+'"]').attr('href',currentSkin);
			$('img[id="logoImg"]').attr('src',logoImageName);
			isDisableMydashboardPopout=jsonData['isDisableMydashboardPopout'];
			var mainIframe = document.getElementById("main");
			//document.getElementById("hidHomePageURL").value=homepage;
			if(monitorPressed!=null && (monitorPressed==true || monitorPressed=="true"))
			{
				isAdminModule = false;
				isMonitorModule=true;
				isConfigModule=false;
				isRepModule=false;
				isSlaModule=false;
				selectedTabModule='monitor';
				adminPressed=false;
				monitorPressed=true;
				reporterPressed=false;
				configPressed=false;
				slaPressed=false;
				var isRepTabObj = Ext.getCmp('reporter');
				if(isRepTabObj!=null && !isRepTabObj.isHidden())
				{
					Ext.getCmp('reporterNewWindowBtn').show();
				}
				var isConfigTabObj = Ext.getCmp('config');
				if(isConfigTabObj!=null && !isConfigTabObj.isHidden())
				{
					Ext.getCmp('configNewWindowBtn').show();
				}
				var isSlaTabObj = Ext.getCmp('sla');
				if(isSlaTabObj!=null && !isSlaTabObj.isHidden())
				{
					Ext.getCmp('slaNewWindowBtn').show();
				}
				if(isAlarmViewerUser=='false'){
				Ext.getCmp('monitorIconIndexMenuId').show();
				}
				Ext.getCmp('adminIndexMenuIcon').hide();
				Ext.getCmp('reporterIndexMenuIcon').hide();
				Ext.getCmp('configIndexMenuIcon').hide();
				Ext.getCmp('slaIndexMenuIcon').hide();
				var meTabSetView=Ext.getCmp('tabset');
				meTabSetView.getComponent('adminTabContainer').removeCls('indexButtonBgPressed');
				meTabSetView.getComponent('reporterTabContainer').removeCls('indexButtonBgPressed');
				meTabSetView.getComponent('configTabContainer').removeCls('indexButtonBgPressed');
				meTabSetView.getComponent('slaTabContainer').removeCls('indexButtonBgPressed');
				meTabSetView.getComponent('monitorTabContainer').fireEvent('afterrender', meTabSetView.getComponent('monitorTabContainer'));
			}
			if (mainIframe != null )
			{				
				mainIframe.src = homepage;	
			}
			refreshInProgress=false;
		}
	});
},

hitUrl:function(url){
	   	window.location.href = url;
	},
comboLoad : function()
{
	 var modulename= Ext.getCmp('reportType').getValue();
	 Ext.Ajax.request({
	 url:'/final/scripts/EgIndexApp/data/EgQuickMenuItems.jsp?moduleName='+modulename+'&newwindow='+newwin,
	 method:'POST',
	 scope:this,
	 success:function(response)
	 {
		var jsonText = response.responseText;
		var publicJson = Ext.decode(jsonText);
		if (Ext.isObject(Ext.getCmp('config_errorpan')))
		{
			Ext.getCmp('config_errorpan').hide();
		}
		if (Ext.isObject(Ext.getCmp('enabledLinkContainer')))
		{
			Ext.getCmp('enabledLinkContainer').update(publicJson['enabledList']);
		}
		Ext.select('.jspHorizontalBar').setStyle({'display':'none'});
	 }
	});
},
	goToSwitchProfileUrl : function()
	{
		var userId = Ext.getCmp('enabledUserContainer').getValue();
		var hiddenUserId = Ext.getCmp('hiddenUserId').getValue();
		if (userId == '-1')
		{
			Ext.Msg.show({
				title: 'Switch Profile',
				msg: 'Please choose a user id to switch',
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		Ext.Ajax.request({
			url : "/final/servlet/com.egurkha.EgSwitchUserServlet?uname="+encodeURIComponent(userId)+"&accessKey="+encodeURIComponent("eGm0n1t0r")+'&demoUser='+encodeURIComponent(hiddenUserId)+"&reqFrom="+encodeURIComponent(reqFrom),
			method : 'POST',
			scope:this,
			timeout: 120000,
			success : function(response)
			{
				var v = response.responseText;
				var myarr = v.split(":");
				if(myarr[0]=="Error")
				{
					var errorText = myarr[1];
					if (errorText != null && errorText.indexOf("The user is not authorized to switch") != -1)
					{
						var alertmsgbox = Ext.Msg.show({
							title: 'Switch Profile',
							msg: errorText,
							buttons: Ext.MessageBox.OK,
							icon: Ext.MessageBox.WARNING
						});
						alertmsgbox.alignTo(Ext.get('enabledUserContainer'), 'c-c');
						return false;
					}
				}
				else
				{
					window.location.href ="/final"+v;
				}
			},
			failure : function(response)
			{
				console.log("failure");
			}
		});
	}
});

function trim(d)
{
	d = d.toString();
	var b = /[^\s].*[^\s]/;
	var a = d.match(b);
	return a;
}
function validateEmail(a)
{
	//var d = /([a-zA-Z0-9]+[\ \_\.\-\&]?)*[a-zA-Z0-9]\@[a-zA-Z0-9][\w\.-]*[a-zA-Z0-9]\.[a-zA-Z][a-zA-Z\.]*[a-zA-Z]/g;
	var d = /(([\+]?([0-9]){4,15})|([\_\#]?([a-zA-Z0-9]+[\ \_\.\-\&\#]?)*[a-zA-Z0-9])+)\@[a-zA-Z0-9][\w\.-]*[a-zA-Z0-9]\.[a-zA-Z][a-zA-Z\.]*[a-zA-Z]/g;
	/* 
	* d - defines the following
	*
	* ([\+]?([0-9]){4,15})
	*			- for email id as phone number (if starts with '+'(plus) symbol then 
	*				it should allow only numerals {min:4 and max:15 digits} as mail id [Eg:+6598331234@sms-gw1.sgpoolz.com.sg])
	*
	* ([\_\#]?([a-zA-Z0-9]+[\ \_\.\-\&\#]?)*[a-zA-Z0-9])
	*			- for email id with zero or one occurence of the symbols '#' (hash) or '_' (underscore) 
	*				as prefix [Eg: _Happy.days1234@eginnovations.com]
	*
	* @[a-zA-Z0-9][\w\.-]*[a-zA-Z0-9]\.[a-zA-Z][a-zA-Z\.]*[a-zA-Z]
	*			- for domain id [Ref: @eginnovations.com]
	*
	*/
	if(a != "")
	{
	a = trim(a) + "";
	var b = a.match(d);
	if (b == null || b != a)
	{
		return false;
	}
	return true;
	}
}
function loadLinkURL(url){
	var mainIframe = document.getElementById("main");
	isAdminModule = false;
	isMonitorModule=true;
	isConfigModule=false;
	isRepModule=false;
	isSlaModule=false;
	selectedTabModule='monitor';
	adminPressed=false;
	monitorPressed=true;
	reporterPressed=false;
	configPressed=false;
	slaPressed=false;
	var isRepTabObj = Ext.getCmp('reporter');
	if(isRepTabObj!=null && !isRepTabObj.isHidden())
	{
		Ext.getCmp('reporterNewWindowBtn').show();
	}
	var isConfigTabObj = Ext.getCmp('config');
	if(isConfigTabObj!=null && !isConfigTabObj.isHidden())
	{
		Ext.getCmp('configNewWindowBtn').show();
	}
	var isSlaTabObj = Ext.getCmp('sla');
	if(isSlaTabObj!=null && !isSlaTabObj.isHidden())
	{
		Ext.getCmp('slaNewWindowBtn').show();
	}
	if(isAlarmViewerUser=='false'){
	Ext.getCmp('monitorIconIndexMenuId').show();
	}
	Ext.getCmp('adminIndexMenuIcon').hide();
	Ext.getCmp('reporterIndexMenuIcon').hide();
	Ext.getCmp('configIndexMenuIcon').hide();
	Ext.getCmp('slaIndexMenuIcon').hide();
	var meTabSetView=Ext.getCmp('tabset');
	meTabSetView.getComponent('adminTabContainer').removeCls('indexButtonBgPressed');
	meTabSetView.getComponent('reporterTabContainer').removeCls('indexButtonBgPressed');
	meTabSetView.getComponent('configTabContainer').removeCls('indexButtonBgPressed');
	meTabSetView.getComponent('slaTabContainer').removeCls('indexButtonBgPressed');
	meTabSetView.getComponent('monitorTabContainer').fireEvent('afterrender', meTabSetView.getComponent('monitorTabContainer'));
	if(mainIframe != null){
		mainIframe.src = url;
	}
	Ext.getCmp('commonSearchWin').close();
	Ext.getCmp("egcommonsearch").setValue("");
	Ext.getCmp('egcommonsearch').focus(true,10);
}



