var timeoutSearch ="";
Ext.define('triggerComobo',{
	extend:'Ext.form.field.ComboBox',
	alias:'widget.triggercomobo',
	initComponent:function(){
		var me = this;
		me.callParent();
	},
	createPicker: function() {
        var me = this,
            picker,
            pickerCfg = Ext.apply({
                xtype: 'boundlist',
                pickerField: me,
				alignTo: function(element, position, offsets) {
		this.setPagePosition(this.el.getAlignToXY(element.el || element, "tl-bl?", [0, 0]));
        return this;
    },
                selModel: {
                    mode: me.multiSelect ? 'SIMPLE' : 'SINGLE'
                },
                floating: true,
                hidden: true,
                store: me.store,
                displayField: me.displayField,
                focusOnToFront: false,
                pageSize: me.pageSize,
                tpl: me.tpl
            }, me.listConfig, me.defaultListConfig);
        picker = me.picker = Ext.widget(pickerCfg);
        if (me.pageSize) {
            picker.pagingToolbar.on('beforechange', me.onPageChange, me);
        }
        me.mon(picker, {
            itemclick: me.onItemClick,
            refresh: me.onListRefresh,
            scope: me
        });
        me.mon(picker.getSelectionModel(), {
            beforeselect: me.onBeforeSelect,
            beforedeselect: me.onBeforeDeselect,
            selectionchange: me.onListSelectionChange,
            scope: me
        });
        return picker;
    }
});
Ext.define('egindex.view.LogoTabset',{
	extend:'Ext.panel.Panel',
	alias:'widget.logotabset',
	requires:[
		'egindex.view.Tabset',
		'egindex.view.QuicklinkProfile',
		'egindex.view.QuicklinkMenuItem',
		'egindex.view.QuickAlarm',
		'egindex.view.SwitchUserProfileCombo',
		'egindex.view.UtilityReport'
		//'egindex.view.SearchPopupResults'
	],
	height:38,
	id:'logotabset',
	bodyPadding:'0',
		bodyStyle:'overflow:visible',
	style:{'overflow':'visible'},
	border: false,
	frame:false,
	layout:{
		type:'hbox',
		align:'center',
		pack:'start'
	},
	items:[
		{	
			xtype:'container',
			width:650,
			layout:{
					type:'hbox',
					pack:'start'
			},
			items:[
				{
						xtype:'container',
						html:'<img id="logoImg" src="'+logoImageName+'?_dc='+new Date()+'" border="0" />',
						margin:0,
						padding:'2 12 2 12',
						height:38,
						frame:false,
						width:129,
						style:{'border':'0px solid red'}
				},{
						xtype:'tabset',
						margin:0,
						height:38,
						bodyStyle:'overflow:visible',
						frame:false,
						bodyPadding:'0',
						//width:576,//sla
						layout:{
							type:'hbox',
							align:'left',
							pack:'start'
						}
				}	
			]
		},
		
		{
			xtype:'container',
			flex:1,
			margin:'6 0 0 0',
			layout:{
				type:'hbox',
				align:'middle',
				pack:'center'
			},
			
			items:[{
				xtype: 'trigger',
				flex:1,
				minWidth:50,
				maxWidth:500,
				//trigger1Cls: 'x-form-clear-trigger',
				//style:{'border-bottom':'1px solid #9f9f9f'},
				ui:'eg-newsearch-combo inputSearchIcon',
				id:'egcommonsearch',
				name:'egcommonsearch',
				emptyText: searchLbl,
				enableKeyEvents : true,
				onTrigger1Click : function() {
					this.reset();
				}
				
			}]
		}
		,{
		xtype:'container',
		border:true,
		layout:{
			type:'hbox',
			align:'center',
			pack:'end'
		},
		width:240,
		//flex:1,
		margin:'7 0 0 0',
		items:[
			{
				xtype:'container',
				border:true,				
				margin:'1 8 0 0',
				parentContainer:false,
				width:230,
				style:{'overflow':'hidden !important'},
				id:'searchcontainer',
				//hidden:true,
				style:{'display':'none'},
				layout:{type:'table'},
				items:[
				{
					xtype:'triggercomobo',
					ui:'eg-new-combo inputSearchIcon',
					id:'searchCombo',
					name:'searchCombo',
					width:115,
					defaultListConfig: {
						loadingHeight: 70,
						minWidth: 110,
						maxHeight: 300,
						shadow: 'sides'
					},
					hidden: hideSearch,
					editable:false,
					value:selectedSearchCombo.toLowerCase(),
					store:Ext.create('Ext.data.Store', {
						fields: ['value', 'name'],
						data : userSearchCombo,
						/*data : [
							{"value":"segment", "name":"Segment"},
							{"value":"server", "name":"Components"},
							{"value":"service", "name":"Service"},
							{"value":"user", "name":"User"},
							{"value":"vm", "name":"VM/Desktop"},							
							{"value":"zone", "name":"Zone"}							
						]*/
					}),
					displayField: 'name',
					valueField: 'value',
					listeners: {
						change: function(){
							if(!Ext.isEmpty(Ext.getCmp('egsearches')) && Ext.getCmp('egsearches')!=null && Ext.getCmp('egsearches')!=undefined)
								Ext.getCmp('egsearches').setValue('');
								Ext.apply(Ext.getCmp('searchcontainer'),{parentContainer :  false });
								Ext.getCmp('egsearches').focus(true,10);
								this.fireEvent('blur',this);
						},
						expand:function(){
							Ext.apply(Ext.getCmp('searchcontainer'),{parentContainer :  false });
							clearTimeout( timeoutSearch );
							//Ext.getCmp('egsearches').focus(true,5);
						},
						collapse:function(){
							Ext.apply(Ext.getCmp('searchcontainer'),{parentContainer :  false });
							clearTimeout( timeoutSearch );
							Ext.getCmp('egsearches').focus(true,10);
						},
						focus:function(){
							//Ext.getCmp('egsearches').focus(true,5);
							clearTimeout( timeoutSearch );
							Ext.apply(Ext.getCmp('searchcontainer'),{parentContainer :  false });
						},
						blur:function(){
							//Ext.getCmp('egsearches').focus(true,5);
							clearTimeout( timeoutSearch );
							Ext.apply(Ext.getCmp('searchcontainer'),{parentContainer :  false });
						}
					}
				},	
				{
				xtype: 'tbseparator',
				cls:'topnavigation_seperator for_switch',
				margin:'-6px 0 0 -2',
				},
				{
						xtype: 'trigger',
						labelAlign: 'top',
						width:115,
						flex:1,
						id:'egsearches',
						hideTrigger:false,
						name:'egsearches',
						enableKeyEvents : true,
						emptyText:searchLbl,
						ui:'eg-new-combo-search',
						padding:'0 8 0 0',
						hideTrigger:false,
						hidden: hideSearch,
						//hidden:true,
						listeners:{
							specialkey:function(field, e){
								if (e.getKey() ==  e.ESC) {
										this.fireEvent('blur',this);
									}
							},
							focus:function(cmp){
								Ext.apply(Ext.getCmp('searchcontainer'),{parentContainer :  false });
								clearTimeout( timeoutSearch );
								Ext.getCmp('searchCombo').fireEvent('blur',Ext.getCmp('searchCombo'));
								Ext.getCmp('searchcontainer').el.stopAnimation( );
								if(Ext.getCmp('searchcontainer').parentContainer == false ){
									Ext.getCmp('searchcontainer').show();
								}
							},
							blur:function(cmp){
								//Ext.getCmp('searchcontainer').fireEvent('closeThis');
								Ext.apply(Ext.getCmp('searchcontainer'),{parentContainer :  true });
								if(Ext.getCmp('searchcontainer').parentContainer == true ){
									timeoutSearch = Ext.defer(function(){
										cmp.onTriggerClick(cmp);
										Ext.getCmp('searchcontainer').el.setStyle({'display':'none'});
										Ext.getCmp('iconsContainer').show();
										Ext.getCmp('iconsContainer').doComponentLayout();
										if (!Ext.isEmpty(cmp.triggerEl))
										{
											Ext.fly(cmp.triggerEl.elements[0].dom).setStyle('background-image','none');
										}
									},250)
									Ext.apply(Ext.getCmp('searchcontainer'),{parentContainer :  false });
								}
								cmp.setValue("");
								Ext.getCmp('searchcontainer').el.stopAnimation( );
							},
							closeSearch:function(cmp){
								var me = this;
								cmp.onTriggerClick(cmp);
								Ext.getCmp('searchcontainer').el.setStyle({'display':'none'});
								Ext.getCmp('iconsContainer').show();
								Ext.getCmp('iconsContainer').doComponentLayout();
								Ext.getCmp('searchcontainer').el.stopAnimation( );
							},
							afterrender:function(cmp){
								Ext.fly(cmp.triggerEl.elements[0].dom).setStyle('background-image','none');
							}
						},
						onTriggerClick: function(cmp)
						{
							//appCnt.searchfn(Ext.getCmp('egsearches'));
							Ext.getCmp("egsearches").setValue("");
							Ext.getCmp('egsearches').focus(true,10);
						}
					}
				]
				
			},
			{
				xtype:'container',  // This container is empty but it holdes the POPUP while render so dont remove
				id:'renderHereToolTip',
				cls:'for_switch',
				hidden: hiddenUserProfile
			},
			//other icons 
			{
			xtype:'container',
			border:true,
			padding:'0 8 0 0',
			id:'iconsContainer',
			layout:{type:'table',align:'stretch'},
			//layout:{type:'hbox'},
			items:[
			/*{
			xtype:'container',
			margin:'4 0 0 0',
			html:'<a href="javascript:void(0)" class="indexTopLink" data-qtip="'+searchLbl+'" data-qclass="new_yellowTip"><div  class="topnavigation_search"  style="float:left"></div></a>',
			id:'eg-searches',
			hidden: hideSearch,
			doAnimation:function(){
				Ext.getCmp('searchcontainer').el.slideIn('l', { duration:85,
					listeners:{
						afteranimate:function(){
							clearTimeout( timeoutSearch );
							Ext.getCmp('egsearches').focus(true,86);
							Ext.getCmp('searchcontainer').el.stopAnimation( );
						}
					} 
				});
				//Ext.getCmp('egsearches').focus(true,210);
				Ext.getCmp('iconsContainer').hide();
				Ext.getCmp('iconsContainer').doComponentLayout();
				//corner case
				if($('#configModUserProfile').is (':visible') || $('#configModQuickLink').is (':visible')  || $('#mangerNotificationWindow').is (':visible') || $('#configModQuickAlarm').is (':visible') )
				{
					$('#configModUserProfile ').hide();
					$('#configModQuickLink ').hide();
					$('#mangerNotificationWindow ').hide();
					$('#configModQuickAlarm ').hide();
				}
			},
			listeners: {
				afterrender: function (panel) {
					panel.mon(panel.el, 'click', this.doAnimation);
				}
			},
			bodyPadding:'0',
			frame:false
			},
			{
				xtype: 'tbseparator',
				cls:'topnavigation_seperator',
				margin:'5 3 0 3',
				//hidden: hideQuickLink
				hidden: hideSearch
			},*/
			{
			xtype:'container',
			margin:'4 0 0 0',
			cls:'for_switch',
			id:'userprofile',
			listeners: {
				afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
						target: this.id,
						id:'userprofile_tooltip',
						cls: 'new_yellowTip',
						//trackMouse: hideInSuperManager,
						html: 'User'
					});
				}
			},
			bodyPadding:'0',
			frame:false
			},{
				xtype: 'tbseparator',
				cls:'topnavigation_seperator for_switch',
				margin:'5 3 0 3'
			},{
			xtype:'container',
			margin:'4 0 0 0',
			padding:'0',
			id:'quicklinks',
			cls:'for_switch',
			hidden: hideQuickLink,
			listeners: {
				afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
						target: this.id,
						id:'quicklinks_tooltip',
						cls: 'new_yellowTip',
						//trackMouse: true,
						html: 'Quick Links'
					});
				}
			},
			bodyPadding:'0',
			frame:false
			},{
				xtype: 'tbseparator',
				cls:'topnavigation_seperator for_switch',
				margin:'5 3 0 3',
				hidden: hideQuickLink
			},
			{
				xtype:'container',
				margin:'4 0 0 0',
				id:'notifications',
				//hidden:true,
				cls:'for_switch',
				hidden: hideInAv_SuperManager,
				bodyPadding:'0',
				frame:false
			},
			{
				xtype: 'tbseparator',
				cls:'topnavigation_seperator for_switch',
				margin:'5 3 0 3',
				hidden: hideInAv_SuperManager
			},
			{
				xtype:'container',
				margin:'4 0 0 0',
				id:'quickalarms',
				//hidden:true,
				cls:'for_switch',
				style:{'position':'relative'},
				hidden: hideQuickAlert,
				items:[{ xtype:'box',id:'quickalarms_pop',style:{'position':'absolute','top':'20px','left':'8px;'}}],
				bodyPadding:'0',
				frame:false
			},
			{
				xtype: 'tbseparator',
				cls:'topnavigation_seperator for_switch',
				margin:'5 3 0 3',
				//hidden: hideInAv_SuperManager
				hidden: hideQuickAlert
			},
			{
			xtype:'container',
			margin:'4 0 0 0',
			html:'<a href="javascript:void(0)" class="indexTopLink"><div  class="topnavigation_downloadagents"  style="float:left"></div></a>',
			padding:'0',
			id:'downloadagent',
			cls:'for_switch',
			hidden: hideDownloadAgent,
			listeners: {
				afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
						target: this.id,
						id:'downloadagent_tooltip',
						cls: 'new_yellowTip',
						html: downloadAgentMsg
					});
				}
			},
			bodyPadding:'0',
			frame:false
			},{
				xtype: 'tbseparator',
				cls:'topnavigation_seperator for_switch',
				margin:'5 3 0 3',
				hidden: hideDownloadAgent
			},{
					xtype:'container',
					html:'<a href="javascript:void(0)" class="indexTopLink"><div  class="topnavigation_userswitch"  style="float:left"></div></a>',
					margin:'4 0 0 0',
					id:'switchUser',
					cls:'for_switch',
					hidden : hideSwitchUser,
				listeners: {
					afterrender: function () {
						Ext.create('Ext.tip.ToolTip', {
							target: this.id,
							id:'switchUser_tooltip',
							cls: 'new_yellowTip',
							trackMouse: true,
								html: switchProfileMsg
						});
					}
					},
					bodyPadding:'0',
					frame:false
			},
			//userswitch_combo
			{
			xtype:'switchuserprofilecombo',
			width:310,
			margin:'0 3 0 3',
			cls:'x-hidden'
			//hidden:true
			},
			{
				xtype: 'tbseparator',
				cls:'topnavigation_seperator ',
				margin:'5 3 0 3',
				hidden: hideInAv_SuperManager,
				hidden : hideSwitchUser,
			},
			{
				xtype:'container',
				margin:'4 0 0 0',
				cls:'for_switch',
				id:'utilities',
				style:{'position':'relative'},
				items:[{ xtype:'box',id:'utilities_popup',style:{'position':'absolute','top':'20px','left':'8px;'}}],
				hidden: hideManagerUtilities,
				bodyPadding:'0',
				frame:false
			},{
				xtype: 'tbseparator',
					cls:'topnavigation_seperator for_switch',
					margin:'5 3 0 3',
				hidden: hideManagerUtilities,
			},{
			xtype:'container',
					html:'<a href="javascript:void(0)" class="indexTopLink"><div class="topnavigation_egHelp" style="float:left"></div></a>',
			id:'help',
					cls:'for_switch',
			helpUrl : null,
					margin:'4 0 0 0',
					//hidden:true,
					bodyPadding:'0',
					frame:false
					},{
						xtype: 'tbseparator',
						id:'monitortbseparatorId',
						cls:'topnavigation_seperator for_switch',
						margin:'5 3 0 3'
					},
				{
				xtype:'container',
					html:'<a href="javascript:void(0)" class="indexTopLink" ><div class="topnavigation_logout" style="float:left"></div></a>',
					margin:'4 0 0 0',
					id:'signout',
			listeners: {
				afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
						target: this.id,
						id:'signout_tooltip',
						cls: 'new_yellowTip',
						trackMouse: true,
						html: 'Signout'
					});
				}
			},
			bodyPadding:'0',
			frame:false
			},{
				xtype: 'tbseparator',
				cls:'topnavigation_seperator',
				hidden : switchback,
				margin:'5 3 0 3'
			},{
			xtype:'container',
			html:'<a href="javascript:void(0)" class="indexTopLink" ><div class="topnavigation_userswitchback" style="float:left"></div></a>',
			id:'switchBack',
			hidden : switchback,
			listeners: {
				afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
						target: this.id,
						id:'switchBack_tooltip',
						cls: 'new_yellowTip',
						trackMouse: true,
						html: 'Switch Back'
					});
				}
			},
			margin:'4 7 0 0',
			bodyPadding:'0',
			frame:false
		}]
	},{
			xtype:'container',
			bodyPadding:'0',
			frame:false,
			cls:'tabsetRightBorder',
			width:2
		}
				]
			}
			],
	loadLogoTabSetComponents : function(json){
			var dispUserName = json.userprofile_name;
			if (dispUserName != null && dispUserName.indexOf("samlsso/") != -1)
			{
				dispUserName = dispUserName.substring(dispUserName.indexOf('/')+1);
				dispUserName = dispUserName + ' (SAML)';
			}
			appLogoTabSet = this;
			if (!Ext.isEmpty(orgName))
			{
				Ext.getCmp('userprofile_tooltip').update(userTooltipMsg+" '"+dispUserName+"' & "+userTooltipMsg1+" '"+orgName+"'");
			}
			else
			{
				Ext.getCmp('userprofile_tooltip').update(userTooltipMsg+" '"+dispUserName+"'");
			}
			var iframes = Ext.getCmp('body');
			var up_html = '<div id="updatehere"></div><a href="javascript:void(0)" class="indexTopLink"><div  id="uprofile" class="topnavigation_user" style="float:left;position:relative"></div></a>'
			Ext.getCmp('userprofile').update(up_html);

			var un_html = '<a href="javascript:void(0)" class="indexTopLink" data-qtip="'+managerNotifyMsg+'"  data-qclass="new_yellowTip"><div  class="topnavigation_notifications" style="float:left;position:relative"></div></a>'
			Ext.getCmp('notifications').update(un_html);

			Ext.get('userprofile').on('click',function(event){
				closemenu();
				userproclicked=true;
				Ext.get('userprofile').addCls("selected_navigation");

				var me = this;
				var quickuserprofilePopupObj = Ext.getCmp('configModUserProfile');
				if(Ext.isEmpty(quickuserprofilePopupObj) || quickuserprofilePopupObj=='null' || quickuserprofilePopupObj=='undefined')
				{

				var tooltip = Ext.create('Ext.tip.ToolTip',{
					target: 'uprofile',
					constrainPosition : false,
					renderTo:Ext.getBody(),
//					height:405,
					anchor: 'top',
					anchorToTarget: true,
					anchorOffset:Ext.get('userprofile').getY() + (140 - 25),
					width:290,
					margin:'5 0 0 0',
					ui:'themes',
					layout:'fit',
					doClose:function(){
						Ext.get('userprofile').removeCls("selected_navigation");
						this.fireEvent('close', this);
						this[this.closeAction]();
					},
					autoHide:false,
					closable: true,
					listeners: {
						show:function(tooltip){
							var timeout;
							var comboProblem2 = false;
							tooltip.getEl().on('mouseout', function(evt){
								timeout = window.setTimeout(function(){
									if(comboProblem2 == false){ 
										Ext.isIE ? evt.returnValue = false : evt.preventDefault()											
										tooltip.hide();
										Ext.get('userprofile').removeCls("selected_navigation");
									}
								}, 900);
							});
							var quickLinkCombo = Ext.getCmp('reportType2');
							quickLinkCombo.on('expand',function(kl){
								comboProblem2 = true;
							});

							quickLinkCombo.on('collapse',function(){
								comboProblem2 = false;
							});

							tooltip.getEl().on('mouseover', function(){
								window.clearTimeout(timeout);
							});

							tooltip.on('mouseout', function(){
								timeout = window.setTimeout(function(){
									tooltip.hide();
									Ext.get('userprofile').removeCls("selected_navigation");
								}, 900);
							});
						},

						hide: function () {
							userproclicked=false;
							Ext.get('userprofile').removeCls("selected_navigation");
							this.destroy();
						}
					},
					title : userProfTitle,
					id:'configModUserProfile', //This ID is used in CSS to set the positions of POPUP
					items:[
						{
							xtype:'container',
							cls:'round-container',
							items:[
								{
									xtype:'quicklinkprofile',
									parent: me
								}
							]
						}],
						dockedItems:[
								{
									xtype: 'container',
									dock: 'bottom',
									ui:'dummy',
									margin:'8px 0px 0px 0px',
									items: [{
										border: false,
										padding:'0px 0px 0px 90px',
										buttons: [{
											text: submitLbl,
											width:'40px',
											id:'SubmitBtn',
											cls: 'quickMenuWhiteButton',
										},'->',{
											xtype:'container',
											style:{'border':'0px solid red','margin':'4px -4px 0px 0px !important',},
											padding:0,
											items:[{
												xtype:'button',
												text: editProfLbl,
												id:'EditBtn',
												padding:0,
												cls:'quickMenuTextButton',
												style:{'background':'transparent !important','border':'0px'}
											}]
										}]
									}]
								}]

				}).showAt([Ext.get(event.target).getX() - 148,Ext.get(event.target).getY() + 28]) ;
				}
			});

			if(!Ext.isEmpty(Ext.get('notifications'))){
			Ext.get('notifications').on('click',function(event){
				closemenu();
				managernofclicked=true;
				Ext.get('notifications').addCls("selected_navigation");
				var me = this;
				isWindowClosable = false;
				var mangerNotificationWindow = Ext.getCmp('mangerNotificationWindow');
				if(Ext.isEmpty(mangerNotificationWindow) || mangerNotificationWindow =='null' || mangerNotificationWindow == undefined)
				{
					showNotificationDialogBox(true,true);
				}
			});
			}
			if (!Ext.isEmpty(clicked) && clicked == "true")
			{
				showQuickLinkPopUp();
			}
			if(!Ext.isEmpty(Ext.getCmp('quicklinks_tooltip'))){
			Ext.getCmp('quicklinks_tooltip').update(json.quiclmenu_text);
			var qm_html = '<a href="javascript:void(0)" class="indexTopLink" ><div id="quicklinkpopup" class="topnavigation_qlinks" style="float:left"></div></a>';
			Ext.getCmp('quicklinks').update(qm_html);

			Ext.get('quicklinks').on('click',function(event){
				closemenu();
				quicklinkclicked=true;
				clicked = 'true';
				Ext.get('quicklinks').addCls("selected_navigation");
				var me = this;
				var quickLinkPopupObj = Ext.getCmp('configModQuickLink');
				if(Ext.isEmpty(quickLinkPopupObj) || quickLinkPopupObj=='null' || quickLinkPopupObj=='undefined')
				{

					var configModQuickLinkVar  = Ext.create('Ext.tip.ToolTip',{
					target: 'quicklinks',
					anchor:'top',
					constrainPosition : false,
					//renderTo:'renderHereToolTip',
					renderTo:Ext.getBody(),
					height:400,
					width:320,
					anchor: 'top',
					anchorOffset:(320 /2)-  Ext.get('quicklinks').getY(),
					ui:'themes',
					margin:'5 0 0 0',
					layout:'fit',
					doClose:function(){
						Ext.get('quicklinks').removeCls("selected_navigation");
						this.fireEvent('close', this);
						this[this.closeAction]();
					},
					autoHide:false,
					closable: true,
					listeners: {
						show:function(tooltip){
							var timeout;
							var comboProblem = false;
							tooltip.getEl().on('mouseout', function(evt){
								timeout = window.setTimeout(function(){
									if(comboProblem == false){
										Ext.isIE ? evt.returnValue = false : evt.preventDefault() 										
										tooltip.hide();
										Ext.get('quicklinks').removeCls("selected_navigation");
									}
								}, 500);
							});

							var quickLinkMenuCombo = Ext.getCmp('reportType');
							quickLinkMenuCombo.on('expand',function(){
								comboProblem = true;
							});

							quickLinkMenuCombo.on('collapse',function(){
								comboProblem = false;
							});

							tooltip.getEl().on('mouseover', function(){
								window.clearTimeout(timeout);
							});

							tooltip.on('mouseout', function(){
								timeout = window.setTimeout(function(){
									tooltip.hide();
									Ext.get('quicklinks').removeCls("selected_navigation");
								}, 500);
							});
						},
						hide: function () {
							quicklinkclicked=false;
							clicked = 'false';
							Ext.get('quicklinks').removeCls("selected_navigation");
							this.destroy();
						}
					},
					title :'QUICK LINKS',
					id:'configModQuickLink', //This ID is used in CSS to set the positions of POPUP
					items:[
						{
							xtype:'container',
							cls:'round-container',
							items:[
								{
									xtype:'quicklinkmenuitem',
									parent: me
								}
							]
						}
					]
				}).showAt([Ext.get(event.target).getX() - 152,Ext.get(event.target).getY() + 28]) ;


				}

			});
			}

			if(!Ext.isEmpty(Ext.get('utilities'))) {
			//Ext.getCmp('utilities_tooltip').update(json.utilities_text);
			var utilities_html = '<a href="javascript:void(0)" class="indexTopLink" data-qtip="'+json.utilities_text+'" data-qclass="new_yellowTip"><div id="util" class="topnavigation_utilities" style="float:left"></div></a>';
			var  utilitiesBtnObj=Ext.getCmp('utilities');
			utilitiesBtnObj.update(utilities_html);
			Ext.get("utilities").on("click", function (e) {
					closemenu();
					utilityclicked=true;
					Ext.get('utilities').addCls("selected_navigation");
					var tooltip = Ext.create('Ext.tip.ToolTip',{
					target: 'utilities',

					constrainPosition : false,
					//renderTo:'renderHereToolTip',
					renderTo:'utilities_popup',
					anchor: 'top',
					anchorOffset:73,
					//anchorOffset:offset.left,
					bodyPadding:0,
					padding:0,
					width:160,
					cls:'whitethemestip',
					ui:'whitethemes',
					margin:'5 0 0 0',
					layout:'fit',
					listeners: {
						show:function(tooltip){
							var timeout;
							tooltip.getEl().on('mouseout', function(evt){
								timeout = window.setTimeout(function(){
									Ext.isIE ? evt.returnValue = false : evt.preventDefault() 
									tooltip.hide();
									Ext.get('utilities').removeCls("selected_navigation");
								}, 500);
							});

							tooltip.getEl().on('mouseover', function(){
								window.clearTimeout(timeout);
							});

							tooltip.on('mouseout', function(){
								timeout = window.setTimeout(function(){
									tooltip.hide();
									Ext.get('utilities').removeCls("selected_navigation");
								}, 500);
							});
						},
						hide: function () {
							utilityclicked=false;
							Ext.get('utilities').removeCls("selected_navigation");
							this.destroy();
						}
					},
					doClose:function(){
						Ext.get('utilities').removeCls("selected_navigation");
						this.fireEvent('close', this);
						this[this.closeAction]();
					},
					autoHide:false,
					title : utilitiesTitle,
					id:'utilconfig', //This ID is used in CSS to set the positions of POPUP
					items:[{
							xtype:'component',
							cls:'round-container helpmenu',
							html:'<ul class="updatemenu"><li id="checkforupdates"><img style="vertical-align:middle;margin-right: 5px;" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="checkupdate"><span class="normal">'+checkforUpdateTitle+'</span></li><li id="reportissue"><img  style="vertical-align:middle;margin-right: 5px;" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="reportissues"><span class="normal">'+reportIncidentTitle+'</span></li><li id="suggestfeature"><img  style="vertical-align:middle;margin-right: 5px;" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="feature-like"><span class="normal">'+suggestaFeatureTitle+'</span></li><li id="helpcenter"><img  style="vertical-align:middle;margin-right: 5px;" src="data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==" class="helpcenter"><span class="normal">'+helpCenterTitle+'</span></li></ul>'
						}]

				}).show() ;
				Ext.get('checkforupdates').on('click',function(event){
					var g = Ext.dom.Query.select(".iconUserIndex");
					var e = Ext.fly(g[0]);	
					Ext.get('checkforupdates').removeCls("selected_navigation");
					utilityclicked=false;
					document.getElementById('main').src="/final/admin/CheckForUpdates.jsp?appType=checkforupdates";
				});
			
				Ext.get('reportissue').on('click',function(event){
					getReportIssue("issue");
				});
				Ext.get('suggestfeature').on('click',function(event){
					getReportIssue("feature");
				});
				Ext.get('helpcenter').on('click',function(event){
					Ext.get('checkforupdates').removeCls("selected_navigation");
					utilityclicked=false;
					document.getElementById('main').src="/final/admin/CheckForUpdates.jsp?appType=helpcenter";
				});		
			});
			}
			if(!Ext.isEmpty(Ext.get('downloadagent'))){
				Ext.get('downloadagent').on('click',function(event){
					var mainIFrameObj = document.getElementById('main');
					mainIFrameObj.src = "/final/admin/EgDownloadAgentPack.jsp";
				});
			}
			if(!Ext.isEmpty(Ext.get('help'))){
				//Ext.getCmp('help_tooltip').update(json.help_text);
			var help_html = '<a href="javascript:void(0)" class="indexTopLink" id="help" data-qtip="'+json.help_text+'" data-qclass="new_yellowTip"><div class="topnavigation_egHelp" style="float:left"></div></a>';
			var  helpBtnObj=Ext.getCmp('help');
			helpBtnObj.update(help_html);
			helpBtnObj.helpUrl=json.help_url;

		        Ext.get("help").on("click", function () {
		                var k = helpBtnObj.helpUrl;
		                var j = "";
		                var l = "";
		                if (!Ext.isEmpty(k)) {
		                    if (k.indexOf("?") > -1) {
		                        j = k.substring(0, k.indexOf("?"));
		                        l = k.substring(k.indexOf("?") + 1);
		                    } else {
		                        j = k;
		                    }
		                }
						if (Ext.getBody().getViewSize().width < 1100)
						{
							var cwidth1=Ext.getBody().getViewSize().width-64; 
							var leftPosition = 25;
							var left = (Ext.getBody().getViewSize().width/2)-(cwidth1/2);						    
						}
						else
						{
							var cwidth1=Ext.getBody().getViewSize().width-154;
							var leftPosition = 78;
							var left = (Ext.getBody().getViewSize().width/2)-(cwidth1/2);
						}
						var cwidth2=(cwidth1/2);						
						var cheight=Ext.getBody().getViewSize().height-240;
						var top = (Ext.getBody().getViewSize().height/2)-(cheight/2);
						var helpwin=window.open("/final/eghelp/EgHelpApp.jsp?forwardPage=" + j + "&params=" + l ,+ "HelpWindow", "toolbar=no,location=no,status=no,menubar=no,width="+cwidth1+",height="+(cheight+20)+",left="+left+",top="+top+",screenx="+left+",screeny="+top+",resizable=yes");
						helpwin.focus();
		             /* var helpwin=   Ext.widget("window", {
		                        title: 'Help - ' +moduleName,
		                        resizable: false,
		                        width: 1000,
								listeners: {
									show: function(win) {
									if (this.modal) {

										var dom = Ext.dom.Query.select('.x-mask');
										var el = Ext.fly(dom[0]);
										el.addCls('windowModal');
									}
									},
									 hide:  function(win) {
									if (this.modal) {
										var dom = Ext.dom.Query.select('.x-mask');
										var el = Ext.fly(dom[0]);
										el.removeCls('windowModal');
									}
									},
									afterrender: function () {
										Ext.EventManager.onWindowResize(function () {
											var me = this;
											me.center();
										}, this);
									}
								},
		                        frame: false,
		                        constrain: true,
								draggable:true,
		                        height: 550,
								cls:'helpwindow',
								modal:true,
								ghost:true,
		                        scroll: false,
		                        autoScroll: false,
		                        border: false,
		                        layout: "fit",
		                        padding: "0 0 0 0",
		                        margin: "0 10 0 0",
		                        html: '<iframe width="100%" height="100%" scrolling="no" frameborder="0" src="/final/eghelp/EgHelpApp.jsp?forwardPage=' + j + "&params=" + l + '"></iframe>'
		                    }).show();
							helpwin.center();*/


			});
			}
			if(!Ext.isEmpty(Ext.get('quickalarms')) ){
				//Ext.getCmp('quickalarms_tooltip').update(json.alarm_text);
				var al_html = '<a href="javascript:void(0)" class="indexTopLink" data-qtip="'+json.alarm_text+'" data-qclass="new_yellowTip"><div class="topnavigation_alarms" id="quickalarmspopup" style="float:left" ></div></a><span id="quickalarmspopup_holder"><span>';
			Ext.getCmp('quickalarms').update(al_html);

			Ext.get('quickalarms').on('click',function(event){
				closemenu();
				quickalarmclicked=true;
				var me = this;
				Ext.get('quickalarms').addCls("selected_navigation");
				var quickAlarmPopupObj = Ext.getCmp('configModQuickAlarm');
					
					//if(Ext.isEmpty(quickAlarmPopupObj) )
					//{
					Ext.create('Ext.tip.ToolTip',{
					target: 'quickalarms',
					height:505,
					width:450,
					maxWidth:550,
					constrainPosition : false,
					//renderTo:'renderHereToolTip',
					renderTo:'quickalarms_pop',
					anchor:'top',
					anchorOffset: 364,
					constrainPosition : false,
					ui:'themes',
					doClose:function(){
						Ext.get('quickalarms').removeCls("selected_navigation");
						Ext.destroy(this);
						this.fireEvent('close', this);
						this[this.closeAction]();
					},
					layout:'fit',
					autoHide:false,
					autoShow:false,
					listeners: {
						show:function(tooltip){
							var timeout;
							tooltip.getEl().on('mouseout', function(evt){
								timeout = window.setTimeout(function(){
									Ext.isIE ? evt.returnValue = false : evt.preventDefault() 
									tooltip.hide();
									Ext.get('quickalarms').removeCls("selected_navigation");
								}, 500);
							});

							tooltip.getEl().on('mouseover', function(){
								window.clearTimeout(timeout);
							});

							tooltip.on('mouseout', function(){
								timeout = window.setTimeout(function(){
									tooltip.hide();
									Ext.get('quickalarms').removeCls("selected_navigation");
								}, 500);
							});
						},
						hide: function () {
							//utilityclicked=false;
							Ext.get('quickalarms').removeCls("selected_navigation");
							this.destroy();
						}
					},
					//style:{'border':'2px solid #ffcc00', 'width':'400px'},
					closable: true,
					title : 'QUICK ALERTS',
					id:'configModQuickAlarm',  //This ID is used in CSS to set the positions of POPUP
					name:'configModQuickAlarm',
					items:[
						{
							xtype:'panel',
							scroll:false,
							autoScroll:false,
							layout:{
								type:'vbox',
								align:'stretch'
							},
							cls:'round-container',
								//style:{'margin':'5px 0px 0px 0px'},
							items:[
								{
									xtype:'quickalarm',
									parent: me
									//cls:'indexQuickLinksFont'
								}
							]
						}
					]
				}).show();
					//}
				});
				}
			if(!Ext.isEmpty(Ext.get('switchUser'))){
				Ext.get('switchUser').on('click',function(event){
					closemenu();
					Ext.get('switchUser').addCls("selected_navigation");
					var me = this;
					isWindowClosable = false;
					var switchUserWindow = Ext.getCmp('switchUserWindow');
					if(Ext.isEmpty(switchUserWindow) || switchUserWindow =='null' || switchUserWindow == undefined)
					{
						showSwitchUserBox();
					}
			});
			}

			Ext.getCmp('signout_tooltip').update(json.signout_text);
			var si_html = '<a href="javascript:void(0)" id="close" class="indexTopLink" ><div class="topnavigation_logout" style="float:left"></div></a>';
			Ext.getCmp('signout').update(si_html);

			//Ext.getCmp('switchBack_tooltip').update("switch back");
			var si_html = '<a href="javascript:void(0)" id="switch" class="indexTopLink" ><div class="topnavigation_userswitchback" style="float:left"></div></a>';
			Ext.getCmp('switchBack').update(si_html);
			if(isNewBrowWin==null || isNewBrowWin=='null' || isNewBrowWin == 'no')
			{
				Ext.get('close').on('click',function(){
					
					var user = json.userprofile_name;
					var mainIFrameObj = document.getElementById('main');
					mainIFrameObj.src = "/final/admin/EgLogoutA.jsp?userid="+isAdminModule+"&fromPage=proceedingSignout&cache="+new Date().getTime();
				});
			}
			if(!Ext.isEmpty(Ext.get('switchBack'))){
				Ext.get('switchBack').on('click',function(){
					Ext.Ajax.request({
						url:'/final/scripts/EgIndexApp/data/EgSwitchUsersJson.jsp',
						method:'post',
						scope:this,
						success:function(response)
						{
							Ext.Ajax.request({
								url : "/final/servlet/com.egurkha.EgSwitchUserServlet?uname="+encodeURIComponent(demoUser)+"&accessKey="+encodeURIComponent("eGm0n1t0r")+"&switchBack=true&reqFrom="+encodeURIComponent(reqFrom),
								method : 'POST',
								scope:this,
								timeout: 120000,
								success : function(response)
								{
									var v = response.responseText;
									window.location.href ="/final"+v;
								},
								failure : function(response)
								{
									console.log("failure");
								}
							});
						}
					});
				});
			}

			if (this.hasNotificationAlerts())
			{
				if (hasNotificationWindow == "yes")
				{
					showNotificationDialogBox(false,false);
				}
			}
			setTimeout('closeNotificationWindow("mangerNotificationWindow")',15000);
		},
		hasNotificationAlerts : function()
		{
			managerWarnings = "";
			var showActivityWindow = false;
			if (hasAllComponentAccess == true && isUsersLimitCrossed != "true" && (alertUserAbtUserCert == true || alertUserAbtUserCert == "true"))
			{
				showActivityWindow = true;
				managerWarnings = managerWarnings + "<div class='commonErrorMsgText managerNotificationOuterView'><div class='managerNotificationInnerView'><div class='iconInformation' style='float:left;width:35px;margin:5px;'></div><div class='msgContainer'>"+messageOne+"</div><div style='clear:both'></div></div></div>";
			}

			if (hasAllComponentAccess == true && (isUsersLimitCrossed == true || isUsersLimitCrossed == "true"))
			{
				showActivityWindow = true;
				managerWarnings = managerWarnings + "<div class='commonErrorMsgText managerNotificationOuterView'><div class='managerNotificationInnerView'><div class='iconInformation' style='float:left;width:35px;margin:5px;'></div><div class='msgContainer'>"+messageTwo+"</div><div style='clear:both'></div></div></div>";
			}

			if(isUserExpired != "")
			{
				showActivityWindow = true;
				managerWarnings = managerWarnings + "<div class='commonErrorMsgText managerNotificationOuterView'><div class='managerNotificationInnerView'><div class='iconInformation' style='float:left;width:35px;margin:5px;'></div><div class='msgContainer'>"+isUserExpired+"</div><div style='clear:both'></div></div></div>";
			}

			if(hasAllComponentAccess == true && isLicenceValid != undefined && isLicenceValid != null && isLicenceValid != "")
			{
				if(isLicenseEnabled == "True")
				{
					if (isMonitorModule == true || isMonitorModule == "true" ||
						isConfigModule == true || isConfigModule == "true" ||
						isRepModule == "true" || isRepModule == true)
					{
						showActivityWindow = true;
						managerWarnings = managerWarnings + "<div class='commonErrorMsgText managerNotificationOuterView'><div class='managerNotificationInnerView'><div class='iconInformation' style='float:left;width:35px;margin:5px;'></div><div class='msgContainer'>"+isLicenceValid+"</div><div style='clear:both'></div></div></div>";
					}
				}

				if(isAdminModule == true || isAdminModule == "true")
				{
					showActivityWindow = true;
					managerWarnings = managerWarnings + "<div class='commonErrorMsgText managerNotificationOuterView'><div class='managerNotificationInnerView'><div class='iconInformation' style='float:left;width:35px;margin:5px;'></div><div class='msgContainer'>"+isLicenceValid+"</div><div style='clear:both'></div></div></div>";
				}
			}

			if(isAdminModule == true || isAdminModule == "true")
			{
				var tmpStr = initializeAdminDashboardAlerts();
				if (tmpStr.length > 0)
				{
					showActivityWindow = true;
				}
			}
			return showActivityWindow;
		}
});

function showSwitchUserBox()
{
	Ext.get('switchUser').addCls("selected_navigation");
	var switchUserPopupObj = Ext.getCmp('enabledUserContainer');
	if(!Ext.isEmpty(switchUserPopupObj))
	{
				//switchUserPopupObj.show();
				switchUserPopupObj.removeCls('x-hidden');
				switchUserPopupObj.el.slideIn('r', { duration:200 });
				Ext.Function.defer(function(){
				switchUserPopupObj.expand();
				},500);
				$( ".for_switch" ).each(function( index ) {
					Ext.fly( this ).hide()
				});
				Ext.getCmp('iconsContainer').doComponentLayout();
	}
}
function showQuickLinkPopUp()
{
	clicked = 'true';
	var me = this;
	Ext.get('quicklinks').addCls("selected_navigation");
	var quickLinkPopupObj = Ext.getCmp('configModQuickLink');
	if(Ext.isEmpty(quickLinkPopupObj) || quickLinkPopupObj=='null' || quickLinkPopupObj=='undefined')
	{
		Ext.create('Ext.tip.ToolTip',{
		target: 'quicklinks',
		anchor:'top',
		constrainPosition : false,
		renderTo:'renderHereToolTip',
		height:400,
		width:320,
		 anchor: 'top',
		anchorOffset:213,
		ui:'themes',
		layout:'fit',
		autoHide:false,
		doClose:function(){
			Ext.get('quicklinks').removeCls("selected_navigation");
			this.fireEvent('close', this);
			this[this.closeAction]();
		},
		closable: true,
		listeners: {
			show:function(tooltip){
				var timeout;
				tooltip.getEl().on('mouseout', function(evt){
					timeout = window.setTimeout(function(){
						Ext.isIE ? evt.returnValue = false : evt.preventDefault()
						tooltip.hide();
						Ext.get('quicklinks').removeCls("selected_navigation");
					}, 500);
				});

				tooltip.getEl().on('mouseover', function(){
					window.clearTimeout(timeout);
				});

				tooltip.on('mouseout', function(){
					timeout = window.setTimeout(function(){
						tooltip.hide();
						Ext.get('quicklinks').removeCls("selected_navigation");
					}, 500);
				});
			},
			hide: function () {
				clicked = 'false';
				Ext.get('quicklinks').removeCls("selected_navigation");
				quicklinkclicked=false;
				this.destroy();
			}
		},
		title :'QUICK LINKS',
		id:'configModQuickLink', //This ID is used in CSS to set the positions of POPUP
		items:[
			{
				xtype:'container',
				cls:'round-container',
				items:[
					{
						xtype:'quicklinkmenuitem',
						parent: me
					}
				]
			}
		]
	}).show();
	}
}

function showNotificationDialogBox(doExecute,validateManagerAlerts)
{
	var mangerNotificationWindow = Ext.getCmp('mangerNotificationWindow');
	Ext.get('notifications').addCls("selected_navigation");
	if(Ext.isEmpty(mangerNotificationWindow) || mangerNotificationWindow =='null' || mangerNotificationWindow == undefined)
	{
		Ext.create('Ext.tip.ToolTip',{
			target: 'notifications',
			requires : ["utilities.CommonPanel"],
			constrainPosition : false,
			renderTo:Ext.getBody(),
			anchorOffset:203,
			anchor:'top',
			bodyPadding : 0,
			height:400,
			width:450,
			margin:'5 0 0 0',
			ui:'themes',
			layout:'fit',
			autoHide:false,
			doClose:function(){
				Ext.get('notifications').removeCls("selected_navigation");
				this.fireEvent('close', this);
				this[this.closeAction]();
			},
			closable: true,
			//closeAction : 'destroy',
			title : 'MANAGER NOTIFICATION',
			id:'mangerNotificationWindow',
			listeners :  {
				show:function(tooltip){
					var timeout;
					tooltip.getEl().on('mouseout', function(evt){
						timeout = window.setTimeout(function(){
							Ext.isIE ? evt.returnValue = false : evt.preventDefault() 
							tooltip.hide();
							Ext.get('notifications').removeCls("selected_navigation");
						}, 500);
					});

					tooltip.getEl().on('mouseover', function(){
						window.clearTimeout(timeout);
					});

					tooltip.on('mouseout', function(){
						timeout = window.setTimeout(function(){
							tooltip.hide();
							Ext.get('notifications').removeCls("selected_navigation");
						}, 500);
					});
				},

				hide: function () {
				managernofclicked=false;
				Ext.get('notifications').removeCls("selected_navigation");
				this.destroy();
			},
				click: {
					element: 'el', //bind to the underlying el property on the panel
					fn: function(){ isWindowClosable = false; }
				},
				'afterrender' : function()
				{
					if (validateManagerAlerts == true)
					{
						appLogoTabSet.hasNotificationAlerts();
					}
					if (doExecute && (isAdminModule == true || isAdminModule == 'true'))
					{
						initializeAdminDashboardAlerts();
					}
				}
			},
			items:[
				{
  					xtype:'panel',
					id : 'userWarningMessages',
					autoScroll : true,
					cls:'round-container msgBody',
					margin:'0px 0px 0px 0px',
					border : false,
					html : "<table border='0' height='281px' width='100%'><tr><td align=center vlaign=top><div class='iconInformation' style='margin:5px'></div><div>No recent notifications found.</div></td></tr></table>"
				}
			]
		}).showAt([Ext.get('notifications').getX() - 215 ,Ext.get('notifications').getY() + 28]);
	}

	if (isAdminModule == true || isAdminModule == 'true')
	{
		if (managerWarnings.length > 0 || adminAlertConfig.length > 0 || adminWarnings.length > 0)
		{
			Ext.getCmp('userWarningMessages').update(managerWarnings + adminAlertConfig + adminWarnings);
			showAutoDiscoveryManagerState();
		}
	}
	else
	{
		if (managerWarnings.length > 0)
		{
			Ext.getCmp('userWarningMessages').update(managerWarnings);
		}
	}
	Ext.getCmp('userWarningMessages').doLayout();
}


function showAutoDiscoveryManagerState()
{
	var mangerNotificationWindow = Ext.getCmp('mangerNotificationWindow');
	if(mangerNotificationWindow == null || mangerNotificationWindow == undefined)
	{
		return;
	}
	Ext.Ajax.request({
		url : '/final/scripts/EgIndexApp/data/EgNotificationManagerJson.jsp?doAction=1',
		method : 'POST',
		async : false,
		success : function(response)
		{
			jsonDataArchive = Ext.decode(response.responseText);
			if (jsonDataArchive.isDiscRunning == true)
			{
				isAutoDiscRunning = true;
				Ext.getCmp('userWarningMessages').update(managerWarnings + adminAlertConfig + adminWarnings + "<div id='discoveryError' class='commonErrorMsgText managerNotificationOuterView'><div class='managerNotificationInnerView'><div class='iconInformation' style='float: left;width:35px;margin:5px'></div><div class='msgContainer'>Manager discovery is in progress. Components will be auto managed once discovery is complete.</div><div style='clear:both'></div></div></div>");
				setTimeout('showAutoDiscoveryManagerState()',5000);
			}
			else
			{
				var tmpError = jsonDataArchive.errorMessage;
				if (tmpError != undefined && tmpError.length > 0)
				{
					var errorStr = "<div id='discoveryError' class='commonErrorMsgText managerNotificationOuterView'><div class='managerNotificationInnerView'><div class='iconInformation' style='float: left;width:35px;margin:5px'></div><div class='msgContainer'>The operation auto-manage during discovery has failed.<br><b>Reason : </b>"+tmpError.substring(tmpError.indexOf("::")+2)+".<br><b>Discovery last ran at : </b>"+jsonDataArchive.discoveryLastRun+"</div><div style='clear:both'></div></div></div>";
					Ext.getCmp('userWarningMessages').update(managerWarnings + adminAlertConfig + adminWarnings + errorStr);
				}
				else
				{
					if (isAutoDiscRunning == true)
					{
						var messageStr =  "<div id='discoveryError' class='commonErrorMsgText managerNotificationOuterView'><div class='managerNotificationInnerView'><div class='iconInformation' style='float: left;width:35px;margin:5px'></div><div class='msgContainer'>Manager discovery has finished and the discovered components have been auto managed successfully.</div><div style='clear:both'></div></div></div>";
						Ext.getCmp('userWarningMessages').update(managerWarnings + adminAlertConfig + adminWarnings + messageStr);
					}
				}
				isAutoDiscRunning = false;
			}
		},
		failure : function()
		{
		}
	});
}

function initializeAdminDashboardAlerts()
{
	var managerAlertsFound = false;
	var adminAlerts = "";
	Ext.Ajax.request({
		url : '/final/admin/EgAdminHome/data/EgDashboardAlertsJson.jsp',
		method : 'POST',
		async : false,
		success: function(response)
		{
			var agentsInfo = Ext.decode(response.responseText);
			if (agentsInfo.isAgentAlertEnabled == true && agentsInfo.hasNotRunningAgentsList == true)
			{
				var val = parseInt(agentsInfo.NotRunningAgentsList);
				var text = "";
				if (val > 1)
				{
					text = agentsInfo.NotRunningAgentsList +" "+ agentsInfo.agentsAreNotRunning ;
				}
				else
				{
					text = agentsInfo.NotRunningAgentsList +" "+ agentsInfo.agentsIsNotRunning ;
				}

				adminAlerts =  adminAlerts + "<div errorType='etype1' class='commonErrorMsgText managerNotificationOuterView'><div class='managerNotificationInnerView'><div class='iconInformation' style='float:left;width:35px;margin:5px;'></div><div class='msgContainer'>"+text+"&nbsp;<a class='eg_monlink manager_notification' href='/final/admin/EgViewManagerNotificationDetails.jsp?type=1' onclick='javascript:destroyNotificationWindow()' target='main'><span class='font_bold11 commonErrorMsgText' style='text-decoration:underline'>"+agentsInfo.clickHere+" "+"</span></a>"+agentsInfo.knowMore+"</div><div style='clear:both'></div></div></div>";
				managerAlertsFound = true;
			}

			if (agentsInfo.isAgentAlertEnabled == true && agentsInfo.hasNotInstalledAgentsList == true)
			{
				var val = parseInt(agentsInfo.NotInstalledAgentsList);
				var text = "";
				if (val > 1)
				{
					text = agentsInfo.NotInstalledAgentsList +" "+agentsInfo.agentsAreNotInstalled;
				}
				else
				{
					text = agentsInfo.NotInstalledAgentsList +" "+agentsInfo.agentsIsNotInstalled;
				}

				adminAlerts =  adminAlerts + "<div errorType='etype1' class='commonErrorMsgText managerNotificationOuterView'><div class='managerNotificationInnerView'><div class='iconInformation' style='float:left;width:35px;margin:5px;'></div><div class='msgContainer'>"+text+"&nbsp;<a class='eg_monlink manager_notification' href='/final/admin/EgViewManagerNotificationDetails.jsp?type=6' onclick='javascript:destroyNotificationWindow()' target='main'><span class='font_bold11 commonErrorMsgText' style='text-decoration:underline'>"+agentsInfo.clickHere+" "+"</span></a>"+agentsInfo.knowMore+"</div><div style='clear:both'></div></div></div>";
				managerAlertsFound = true;
			}

			if (hasAllComponentAccess == true && agentsInfo.isDiscoveredCompsPopupEnabled && agentsInfo.hasDiscoveredComponents == true)
			{
				var val = parseInt(agentsInfo.count);
				var text = "";
				if (val > 1)
				{
					text = agentsInfo.count +" "+agentsInfo.componentsHaveDiscovered;
				}
				else
				{
					text = agentsInfo.count +" "+agentsInfo.componentsHasDiscovered;
				}
				adminAlerts =  adminAlerts + "<div errorType='etype2' class='commonErrorMsgText managerNotificationOuterView'><div class='managerNotificationInnerView'><div class='iconInformation' style='float: left;width:35px;margin:5px'></div><div class='msgContainer'>"+text+"&nbsp;<a class='eg_monlink manager_notification' onclick='javascript:destroyNotificationWindow()'  href='/final/admin/EgViewManagerNotificationDetails.jsp?type=2' target='main'><span class='font_bold11 commonErrorMsgText' style='text-decoration:underline'>"+agentsInfo.clickHere+" "+"</span></a> "+agentsInfo.knowMore+"</div><div style='clear:both'></div></div></div>";
				managerAlertsFound = true;
			}

			if (hasAllComponentAccess == true && agentsInfo.UIAlertForUnconfiguredAgents == true && agentsInfo.isUnconfiguredAgentsDetected == true)
			{
				var val = parseInt(agentsInfo.UnconfiguredAgentsCount);
				var text = "";
				if (val > 1)
				{
					text = agentsInfo.UnconfiguredAgentsCount +" "+agentsInfo.agentsHaveInstalled;
				}
				else
				{
					text = agentsInfo.UnconfiguredAgentsCount +" "+agentsInfo.agentsHasInstalled;
				}

				//if (windowobj.managerWarnings != null && windowobj.managerWarnings.indexOf('etype3') == -1)
				{
					adminAlerts =  adminAlerts + "<div errorType='etype3' class='commonErrorMsgText managerNotificationOuterView'><div class='managerNotificationInnerView'><div class='iconInformation' style='float: left;width:35px;margin:5px'></div><div class='msgContainer'>"+text+"&nbsp;<a class='eg_monlink manager_notification' href='/final/admin/EgViewManagerNotificationDetails.jsp?type=3' onclick='javascript:destroyNotificationWindow()' target='main'><span class='font_bold11 commonErrorMsgText' style='text-decoration:underline'>"+agentsInfo.clickHere+" "+"</span></a> "+agentsInfo.knowMore+"</div><div style='clear:both'></div></div></div>";
				}
				managerAlertsFound = true;
			}
			if (agentsInfo.hasManagedComponents == true && agentsInfo.hasUnConfiguredComponents == true &&
				agentsInfo.hasTestConfigAccess == true)
			{
				var val = parseInt(agentsInfo.UnconfiguredComponentCount);
				var label = "";
				if (val > 1)
				{
					label = agentsInfo.UnconfiguredComponentCount +" "+agentsInfo.managecomponentsHaveConfigured;
				}
				else
				{
					label = agentsInfo.UnconfiguredComponentCount +" "+agentsInfo.managecomponentsHasConfigured; 
				}
				if (reqFrom!=null && reqFrom=='clsTrial')
				{
					adminAlerts =  adminAlerts + "<div errorType='etype3' class='commonErrorMsgText managerNotificationOuterView'><div class='managerNotificationInnerView'><div class='iconInformation' style='float: left;width:35px;margin:5px'></div><div class='msgContainer'>"+label+"&nbsp;<br><a class='eg_monlink manager_notification' href='/final/portal/LogonSimulator.jsp?from=login&tab=configure' onclick='javascript:destroyNotificationWindow()'  target='main'><span class='font_bold11 commonErrorMsgText' style='text-decoration:underline'>"+agentsInfo.clickHere+" "+"</span></a> "+agentsInfo.knowMore+"</div><div style='clear:both'></div></div></div>";
				}
				else
				{
					adminAlerts =  adminAlerts + "<div errorType='etype3' class='commonErrorMsgText managerNotificationOuterView'><div class='managerNotificationInnerView'><div class='iconInformation' style='float: left;width:35px;margin:5px'></div><div class='msgContainer'>"+label+"&nbsp;<br><a class='eg_monlink manager_notification' href='/final/admin/EgUnconfiguredTestsSummary.jsp?fromPage=limitedCompAccess&showBackButton=true' onclick='javascript:destroyNotificationWindow()'  target='main'><span class='font_bold11 commonErrorMsgText' style='text-decoration:underline'>"+agentsInfo.clickHere+" "+"</span></a> "+agentsInfo.knowMore+"</div><div style='clear:both'></div></div></div>";
				}
			}
			if (agentsInfo.loginAuthentication == false)
			{
				var msg = agentsInfo.autoLoginEnabled;
				adminAlerts =  adminAlerts + "<div errorType='etype3' class='commonErrorMsgText managerNotificationOuterView'><div class='managerNotificationInnerView'><div class='iconInformation' style='float: left;width:35px;margin:5px'></div><div class='msgContainer'>"+msg+"&nbsp;<br><a class='eg_monlink manager_notification' href='/final/admin/EgManagerSettingsTree.jsp?fromPage=home' onclick='javascript:destroyNotificationWindow()'  target='main'><span class='font_bold11 commonErrorMsgText' style='text-decoration:underline'>"+agentsInfo.clickHere+" "+"</span></a>"+agentsInfo.forceUserLogin+"</div><div style='clear:both'></div></div></div>";
			}
			if (agentsInfo.isUpgradeTestsAvailable == true && agentsInfo.UIAlertForUpgradeTests == true)
			{
				var text = agentsInfo.testFoundForUpgrade;
				adminAlerts =  adminAlerts + "<div errorType='etype1' class='commonErrorMsgText managerNotificationOuterView'><div class='managerNotificationInnerView'><div class='iconInformation' style='float:left;width:35px;margin:5px;'></div><div class='msgContainer'>"+text+"&nbsp;<a class='eg_monlink manager_notification' href='/final/admin/EgUpgradeEnableDeleteTests.jsp?type=1' onclick='javascript:destroyNotificationWindow()' target='main'><span class='font_bold11 commonErrorMsgText' style='text-decoration:underline;'>"+agentsInfo.clickHere+" "+"</span></a> "+agentsInfo.knowMore+"</div><div style='clear:both'></div></div></div>";
				managerAlertsFound = true;
			}
		},
		failure : function()
		{
		}
	});
	adminAlertConfig = adminAlerts;
	return adminAlertConfig;
}

function closeMessage()
{
	Ext.Ajax.request({
		url : '/final/scripts/EgIndexApp/data/EgNotificationManagerJson.jsp?doAction=2',
		method : 'POST',
		success : function(response)
		{
			Ext.getCmp('userWarningMessages').update(managerWarnings + adminAlertConfig + adminWarnings);
			if (managerWarnings.length == 0 && adminAlertConfig.length == 0 && adminWarnings.length == 0)
			{
				Ext.getCmp("userWarningMessages").update("<table border='0' height='281px' width='100%'><tr><td align=center vlaign=top><div class='iconInformation' style='margin:5px'></div><div>No recent notifications found.</div></td></tr></table>");
			}
		}
	});
}
function closemenu()
{
	if(userproclicked)
	{
		Ext.getCmp('configModUserProfile').close();
		clicked = 'false';
		userproclicked=false;
	}
	else if(managernofclicked)
	{
		Ext.getCmp('mangerNotificationWindow').close();
		managernofclicked=false;
	}
	else if(quickalarmclicked)
	{
		if(!Ext.isEmpty(Ext.getCmp('configModQuickAlarm'))){
		Ext.getCmp('configModQuickAlarm').close();
		quickalarmclicked=false;
		}
	}
	else if(quicklinkclicked)
	{
		Ext.getCmp('configModQuickLink').close();
		quicklinkclicked=false;
	}
}

function closeNotificationWindow(activityWindow)
{
	var windowObj = Ext.getCmp(activityWindow);
	if (windowObj != null && windowObj != undefined)
	{
		if (isWindowClosable == true)
		{
			windowObj.destroy();
			Ext.get('notifications').removeCls("selected_navigation");
		}
	}
}

/*
function toolTipHideInMouseOut()
{
	if( Ext.getCmp('configModUserProfile').on('mouseout'));
	{
		alert('dfdfdfd');
		Ext.getCmp('configModUserProfile').hide();
	}
}
*/
// JavaScript Document




