var publicAlarmJson;
Ext.define("egindex.view.QuickAlarm", {
    extend: "Ext.form.Panel",
    alias: "widget.quickalarm",
    requires: ["utilities.ScrollCombo", "utilities.CommonPanel"],
    margin:0,
    padding:0,
	bodyPadding:0,
    border: false,
    frame: false,
	scroll:false,
	overflowX:'hidden',
	bodyStyle:{'overflow-X':'hidden'},
	autoScroll:true,
    listeners: {
        "boxready": function () {
            this.loadQuickAlrmViews();
        }
    },
    items: [

	/*{
        xtype: "container",
        id: "qucikAlamHeader",
        name: "qucikAlamHeader",
        margin: "6",
		height:20
    }, {
        xtype: "splitter",
        height: 2,
        cls: "separator",
        margin: "0",
        padding: 0,
        draggable: false,
        style: {
            "cursor": "default"
        }
    },*/ {
        xtype: "commonPanel",
        height: 400,
		//width:396,
        margin:0,
		id: 'alarmsPanel',
        bodyPadding: 0,
		scroll:false,
		autoScroll:true,
		padding:0,
		layout: {
			type: "column",
			align: "stretch"
		},
        frame: false,
        cls: "dummyCls",
        bodyStyle: {
            "background": "none"
        },
        items: [{
            xtype: "container",
            id: "CritcalAlertsContainer",
			cls:"alarm_containerborder",
            name: "CritcalAlertsContainer"
        }, {
            xtype: "container",
			cls:"alarm_containerborder",
            margin:'10 0 0 0',
            id: "MajorAlertsContainer",
            name: "MajorAlertsContainer"
        }, {
            xtype: "container",
			cls:"alarm_containerborder",
            id: "MinorAlertsContainer",
			 margin:'10 0 0 0',
            name: "MinorAlertsContainer"
        }, {
            xtype: "container",
            id: "emptyContainer",
			height:400,
            name: "emptyContainer",
            hidden: true
        }]
    }],
	dockedItems:[{
		xtype:'toolbar',
		dock:'bottom',
		margin:'4 0 0 0',
		padding:0,
		items:[{
			xtype: "container",
			id: "totalCount",
			name: "totalCount",
			frame: false,
			border: false
		}]
	}],
    loadQuickAlrmViews: function () {
        var a = new Ext.LoadMask(Ext.get('alarmsPanel'), {
            msg: "Loading .."
        });
        a.show();
        var b = this;
        Ext.Ajax.request({
            url: "/final/scripts/EgIndexApp/data/EgalarmQuickView.jsp",
            method: "post",
            scope: this,
            success: function (c) {
                a.hide();
                var e = c.responseText;
                var d = Ext.decode(e);
                publicAlarmJson = d;
                Ext.getCmp("configModQuickAlarm").setTitle(d["qAlmHeader"]);
                var f = d["dataAvailable"];
                Ext.getCmp("totalCount").update(d["totalUpdateValue"]);
                if (f == "true") {
                    Ext.getCmp("CritcalAlertsContainer").update(d["CriticalAlerts"]);
                    Ext.getCmp("MajorAlertsContainer").update(d["MajorAlerts"]);
                    Ext.getCmp("MinorAlertsContainer").update(d["MinorAlerts"]);
                } else {
                    Ext.getCmp("CritcalAlertsContainer").hide();
                    Ext.getCmp("MajorAlertsContainer").hide();
                    Ext.getCmp("MinorAlertsContainer").hide();
                    var g = Ext.getCmp("emptyContainer");
                    g.update(d["alarmEmpty"]);
                    g.show();
                }
                Ext.get("maxAlarmView").on("click", function () {
                    window.open(publicAlarmJson["currentAlmLink"], "CurrentAlarms", "toolbar=no,menubar=no,location=no,status=no,width=990,height=400,left=10,top=10,screenx=0,screeny=0,resizable=yes,scrollbars=1,scrollbars=yes");
		    quickalarmclicked=false;
                    Ext.getCmp("configModQuickAlarm").destroy();
                   // Ext.select("#QuickAlarmsArrowShowHide").hide();
                });
				if(Ext.get("QuickAlrmRefresh")!=null)
				{
					Ext.get("QuickAlrmRefresh").on("click", function () {
						b.loadQuickAlrmViews();
					});
				}
                d = null;
            }
        });

		/*
        Ext.get("configModQuickAlarm").on("click", function () {
            Ext.getCmp("configModQuickAlarm").destroy();
            Ext.select("#QuickAlarmsArrowShowHide").hide();
        }, null, {
            delegate: "#closeQuickAlarm"
        });
		*/
    }
});