var jsonData;
Ext.define('egindex.view.SwitchUserProfileCombo', {
extend: 'Ext.form.field.Picker',
alias: 'widget.switchuserprofilecombo',
ui: 'eg-new-combo inputUserswitchIcon',
editable: false,
margin:0,
padding:0,
// hideTrigger: true,
id:'enabledUserContainer',
initComponent: function() {
	this.callParent();
},
listeners: {
	focus: function (fld, e, opts) {
		//fld.expand();
	}
},
value: '',
applyValues: function () {
	var me = this,
		form = me.picker,
		vals = form.getForm().getValues();
	// set the value of the editable field        
	if(me.boundSelection[0]['selection'] != -1){
		me.setValue(me.boundSelection[0]['selection']);
		Ext.getCmp('UserSubmitBtn').enable();
	}else{
		me.setValue(jsonData['RootNodeText']);
		Ext.getCmp('UserSubmitBtn').disable();
	}
	me.fireEvent('blur');
	me.collapse();
},
boundSelection:[],
collapseIf: Ext.Function.createInterceptor(Ext.form.field.Picker.prototype.collapseIf, function (e) {

	var boundList = Ext.get(e.target).up('.x-boundlist'),
		cmp;
	cmp = boundList && Ext.getCmp(boundList.id);
	if(Ext.isEmpty(cmp)){
	if (cmp && this.picker.down('#' + cmp.pickerField.id)){
		return false;
	}
	}
}),
 onCollapse: function(){
	var me = this;
	$( ".for_switch" ).each(function( index ) {
		Ext.fly( this ).show()
	});
	me.addCls('x-hidden');
	Ext.get('switchUser').removeCls("selected_navigation");
	Ext.getCmp('iconsContainer').doComponentLayout();
},
mimicBlur: Ext.Function.createInterceptor(Ext.form.field.Picker.prototype.collapseIf, function (e) {
		
	var boundList = Ext.get(e.target).up('.x-boundlist'),
		cmp;
	cmp = boundList && Ext.getCmp(boundList.id);
	if(Ext.isEmpty(cmp)){
	if (cmp && this.picker.down('#' + cmp.pickerField.id)){
		return false;
	}}
}),

createPicker: function () {
	var me = this,
		format = Ext.String.format;
	return Ext.create('Ext.form.Panel', {
		pickerField: me,
		ui:'pickerui',
		ownerCt: me.ownerCt,
		renderTo: document.body,
		floating: true,
		bodyPadding: 0,
		items: [
		{
			xtype: 'hiddenfield',
			id: 'hiddenUserId',
			name: 'hiddenUserId'
		},
		{
			xype:'container',
			cls:'multisearchlist',
			width: 410,
			items: [
				{
					xtype: 'trigger',
					name:'searchbox',
					id:'searchbox',
					trigger1Cls: 'x-form-clear-trigger',
					trigger2Cls: 'x-form-search-trigger', 
					cls: 'whitedropdown_search',
					emptyText:searchLbl,
					width: 277,
					onTrigger1Click: function() {
						this.reset();
					},
					onTrigger2Click: function() {
						egTitleSearch();
					},
					listeners :
					{
						change : function(obj)
						{
							egTitleSearch();
						},
						specialkey: function(field, e){
							// e.HOME, e.END, e.PAGE_UP, e.PAGE_DOWN,
							// e.TAB, e.ESC, arrow keys: e.LEFT, e.RIGHT, e.UP, e.DOWN
							if (e.getKey() == e.ENTER) {
								egTitleSearch();
							}
						}
					},
					getTriggerMarkup: function() {
						var me = this,
						i = 0,
						hideTrigger = (me.readOnly || me.hideTrigger),
						triggerCls,
						triggerBaseCls = me.triggerBaseCls,
						triggerConfigs = [],
						unselectableCls = Ext.dom.Element.unselectableCls,
						style = 'width:' + me.triggerWidth-20 + 'px;' + (hideTrigger ? 'display:none;' : ''),
						cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
						// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
						// single triggerCls config. Should rethink this, perhaps something more structured like a list of
						// trigger config objects that hold cls, handler, etc.
						// triggerCls is a synonym for trigger1Cls, so copy it.
						if (!me.trigger1Cls) {
							me.trigger1Cls = me.triggerCls;
						}
						// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+me.id+'_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : 'MyTrigger_'+me.id+'_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					},
					disabled: false
				}
			]
		},
		{
			xtype: 'treepanel',
			id:'boundlist',
			height:200,
			name: 'preselect',
			bodyStyle:{
				'border':'1px solid #d7d7d7 !important'
			},
			emptyText: '<table width="100%"><tr><td align="center" valign="middle"><div class="iconInformation" style="margin:25% auto 0% auto"></div>No users found</td></tr></table>',
			listeners:{
				itemclick:function( bl, record, item, index, e, eOpts ){
					 me.boundSelection.length = 0;
					 me.boundSelection.push({"selection":record.data.id});
					 if(record.data.id != -1){
						me.setValue(me.boundSelection[0]['selection']);
						Ext.getCmp('UserSubmitBtn').enable();
					}else{
						me.setValue(jsonData['RootNodeText']);
						Ext.getCmp('UserSubmitBtn').disable();
					}
				}
			},
			clearFilter: function() {
				var view = this.getView();
				if (this.getRootNode())
				{
					this.getRootNode().cascadeBy(function(tree, view){
						var uiNode = view.getNodeByRecord(this);

						if(uiNode) {
							Ext.get(uiNode).setDisplayed('table-row');
						}
					}, null, [this, view]);

					//No data found message removal
					var elemNoData = Ext.getElementById('noDataFound');
					if (elemNoData)
					{
						elemNoData.style.display = "none";
					}
				}
			},
			filterBy: function(text, by) {
				this.clearFilter();

				var view = this.getView(),
					me = this,
					nodesAndParents = [];

				// Find the nodes which match the search term, expand them.
				// Then add them and their parents to nodesAndParents.
				if (this.getRootNode())
				{
					this.getRootNode().cascadeBy(function(tree, view){
						var currNode = this;
						if(currNode && currNode.data[by] && currNode.data[by].toString().toLowerCase().indexOf(text.toLowerCase()) > -1) {
							me.expandPath(currNode.getPath());

							while(currNode.parentNode) {
								nodesAndParents.push(currNode.id);
								currNode = currNode.parentNode;
							}
						}
					}, null, [me, view]);

					// Hide all of the nodes which aren't in nodesAndParents
					this.getRootNode().cascadeBy(function(tree, view){
						var uiNode = view.getNodeByRecord(this);
						if(uiNode && !Ext.Array.contains(nodesAndParents, this.id) && this.data.id != -1) {
							Ext.get(uiNode).setDisplayed('none');
						}
					}, null, [me, view]);

					//No data found message show
					if(Ext.isEmpty(nodesAndParents))
					{
						this.getRootNode().cascadeBy(function(tree, view){
							var uiNode = view.getNodeByRecord(this);
							if(this.data.id == -1) {
								Ext.get(uiNode).setDisplayed('none');
							}
						}, null, [me, view]);

						var elemNoData = Ext.getElementById('noDataFound');
						if (elemNoData == null || elemNoData === undefined)
						{
							Ext.DomHelper.append(Ext.get(view.id), {
								tag: 'div',
								style:{'width':'100%','textAlign':'center','display': 'table'}, 
								cls: 'new-div-cls', 
								id: 'noDataFound',
								html:LoadSearchAlert
							});
						}
						else
						{
							elemNoData.style.display = "table";
						}
					}
				}
			},
			useArrows: false,
			autoShow: true,
			autoScroll: true,
			store: Ext.create('Ext.data.TreeStore', {
				sorters: [{
					property: 'text',
					direction: 'ASC' 
				}]
			}),
			rootVisible: true
		}],
		dockedItems: [{
			xtype: 'toolbar',
			dock: 'bottom',
			ui:'footer',
			padding:'5 0 5 0',
			items: [
				'->', {
				xtype: 'button',
				name: 'submit',
				cls:'button20',
				text: switchLbl,
				id:'UserSubmitBtn',
				
			},'->' ]
		}],
		listeners: {
			
			afterrender: function (panel, opts) {
				switchUserTabClick(panel,opts,me);
			},
			show: function (panel, opts) {
				switchUserTabClick(panel,opts,me);
			}
		}
	})
}
});

function switchUserTabClick(panel, opts, me)
{
	panel.getEl().on('mouseleave',function(){
		me.onCollapse();
		me.fireEvent('blur');
		me.collapse();
	});
	
	var initLdgMask = new Ext.LoadMask(panel,{msg : "Loading .."});
	initLdgMask.show();
	Ext.Ajax.request({
		url:'/final/scripts/EgIndexApp/data/EgSwitchUsersJson.jsp',
		method:'post',
		scope:this,
		success:function(response)
		{
			initLdgMask.hide();
			var jsonText = response.responseText;
			jsonData = Ext.decode(jsonText);
			if (Ext.isObject(Ext.getCmp('boundlist')))
			{
				var availableUsers = jsonData['exportDataArr'];
				var unameObj = Ext.getCmp('boundlist');
				
				if (!Ext.isEmpty(availableUsers))
				{
					var rootData = {
						text: jsonData['RootNodeText'],
						id: '-1',
						name: '-1',
						expanded: true,
						children: jsonData['exportDataArr']
					};
					unameObj.getStore().setRootNode(rootData);

					me.setValue(jsonData['RootNodeText']);
					Ext.getCmp('hiddenUserId').setValue(jsonData['currentUser']);
				}
				else
				{
					unameObj.getStore().removeAll();
				}
				
				if (me.getValue() === jsonData['RootNodeText'])
				{
					Ext.getCmp('UserSubmitBtn').disable();
				}
				else if (!Ext.isEmpty(availableUsers))
				{
					Ext.getCmp('UserSubmitBtn').enable();
				}
				else
				{
					Ext.getCmp('UserSubmitBtn').disable();
				}
			}
		},
		failure:function(response)
		{
		}
	});
}

function egTitleSearch()
{
	var obj = Ext.getCmp("boundlist");
	var egTitleSearchStr = Ext.getCmp('searchbox').getValue();
	var firstId = 'MyTrigger_searchbox_0';
	var secondId = 'MyTrigger_searchbox_1';

	if (egTitleSearchStr == "" || egTitleSearchStr .length == 0)
	{
		Ext.get(firstId).setStyle('display','none');
		Ext.get(secondId).setStyle('display','block');
	}
	else
	{
		Ext.get(secondId).setStyle('display','none');
		Ext.get(firstId).setStyle('display','block');
	}
	if(egTitleSearchStr==null || egTitleSearchStr=="")
	{
		Ext.getCmp('boundlist').filterBy(egTitleSearchStr, 'text');
		//No data found message removal
		var elemNoData = Ext.getElementById('noDataFound');
		if (elemNoData)
		{
			elemNoData.style.display = "none";
		}
		Ext.getCmp('enabledUserContainer').setValue(jsonData['RootNodeText']);
	}
	else
	{
		Ext.getCmp('boundlist').filterBy(egTitleSearchStr, 'text');
		Ext.getCmp('enabledUserContainer').setValue(jsonData['RootNodeText']);
	}
	Ext.getCmp('UserSubmitBtn').disable();
}



