Ext.define('egindex.view.UtilityReport',{
	extend:'Ext.form.Panel',
	alias:'widget.utilityreport',
	requires:['utilities.ScrollCombo'],
	margin:10,
	height:430,
	id:'utilreport',
	listeners:{
		'boxready':function(){
			this.loadReportData();
		}
	},
	defaults:{
		labelSeparator:"",
		margin:'0 0 10 0',
		labelWidth:140
	},
	items:[
			{
				xtype: 'textfield',
				id: 'reportTitle',
				name: 'reportTitle',
				width:730,
				fieldLabel: subjectLbl,
				cls:'textbox'
			},
			{
				xtype: 'textfield',
				id: 'requester',
				name: 'requester',
				width:350,
				fieldLabel: requesterLbl,
				cls:'textbox'
			},
			{
				xtype: 'textfield',
				id: 'CC',
				name: 'CC',
				fieldLabel : CCLbl,
				labelWidth:50,
				margin:'-30 0 10 390',
				width:340,
				emptyText:CCLbl,
				cls:'textbox',
			},
			{
				xtype : 'combo',
				id:'region',
				name : 'region',
				width:350,
				fieldLabel : regionLbl,
				editable : false,
				cls : 'dropdown',
				displayField : 'Type',
				valueField : 'Value',
				queryMode : 'local',
				store : new Ext.data.Store({
					fields : ['Type', 'Value'],
					data : []
				}),
			},
			{
				xtype : 'combo',
				id:'reportType',
				name : 'reportType',
				width:350,
				fieldLabel : ticketTypeLbl,
				editable : false,
				cls : 'dropdown',
				displayField : 'Type',
				valueField : 'Value',
				queryMode : 'local',
				store : new Ext.data.Store({
					fields : ['Type', 'Value'],
					data : []
				}),
			},
			{
				region: 'center',
				xtype: 'textareafield',
				id: 'reportDescription',
				name: 'reportDescription',
				fieldStyle: 'font-family: Courier New; font-size: 12px;',
				height:250,
				width:730,
				style: { border: '0' },
				fieldLabel :descriptionLbl,
				listeners:{
					boxready:function(){
						Ext.defer(function(){ 
							var editorHeight=210;
							if(isReportFeature){
								editorHeight=240;
							}
							var editorSkin = "/final/scripts/tinymce/skins/lightgray";
							var skinType = "lightgray";
							if(selectedTabTheme == "Dark"){
								editorSkin = "/final/scripts/tinymce/skins/darkgray";
								skinType = "darkgray";
							}
							else{
								editorSkin = "/final/scripts/tinymce/skins/lightgray";
								skinType = "lightgray";
							}
							tinymce.init({
								selector: '#reportDescription-inputEl',
								height: editorHeight,
								menubar: false,
								plugins: [
									'advlist autolink lists link charmap preview fullscreen',
									'insertdatetime media table contextmenu paste textcolor'
								],
								theme: "modern",
								skin_url: editorSkin,
								skin: skinType,
								toolbar: "bold italic underline strikethrough | alignleft aligncenter alignright alignjustify |  bullist numlist outdent indent | table insertdatetime link unlink | insertselect styleselect formatselect fontselect fontsizeselect | forecolor backcolor preview fullscreen",
								paste_data_images: true,
								statusbar: false,
								menubar: false,
								toolbar_items_size: 'small'								
							});
						},500);
					},
				},
			},
			{
				xtype: 'fileuploadfield',
				width:350,
				cls: 'fileupload',
				fieldLabel: attachmentLbl,
				buttonText: browseLbl,
				margin:'0 0 10 0',
				width:350,
				name : 'FILE_0',
				id : 'FILE_0',
				listeners:{
					change:function(cmp,value,eOpts ){
						var fileName = value.substring(value.lastIndexOf("\\")+1);
						Ext.getCmp('FILE_0').setRawValue(fileName);
						
					},
				},
			}
	],
	
	loadReportData : function()
	{
		var action ="";
		if(isReportFeature){
			action="reportfeature";
			Ext.getCmp("reportType").hide();
		}
		else{
			action="reportissue";
			Ext.getCmp("reportType").show();
		}
		var reportLoadMask = new Ext.LoadMask(Ext.getCmp('reportwin'), {
			maskCls :'windowModal',
			msg: loadingMsg+"..."
		});
		reportLoadMask.show();
		Ext.Ajax.request({
			url : '/final/scripts/EgIndexApp/data/ReportIssueJson.jsp',
			method:'post',
			params: {
				action: action,
			},
			scope:this,
			success : function(response)
			{
				if(response.responseText!=null){
					var reportJsonData = Ext.decode(response.responseText);
					if (!Ext.isEmpty(reportJsonData))
					{
						var ErrMsgsJson =reportJsonData['ErrMsgsJson'];
						if(Ext.isEmpty(ErrMsgsJson))
						{
							Ext.destroy(reportLoadMask);
							delete reportLoadMask;
							Ext.getCmp("requester").setValue(reportJsonData['requester']);
							Ext.getCmp("region").getStore().loadRawData(reportJsonData['region']);
							Ext.getCmp("region").setValue("Choose a region");

							if(!isReportFeature){
								Ext.getCmp("reportType").getStore().loadRawData(reportJsonData['reportType']);
								Ext.getCmp("reportType").setValue("Choose a ticket type");
							}
						}
						else{
							Ext.defer(function(){
								var msg = Ext.MessageBox.show({
									title : reportTitle,
									modal:true,
									width:420,
									msg : ErrMsgsJson,
									buttons : Ext.MessageBox.OK,
									maskCls :'windowModal',
									icon: 'iconExclamation',
									fn: function() {
										Ext.destroy(thisForm);
										Ext.destroy(reportWindow);
										delete reportWindow;
										delete thisForm;
									}
								});
								Ext.WindowManager.bringToFront(msg);
							},1000);
						}
					}
					
				}			
			},
			failure : function() {
				//console.log("Error occured while accessing the check for updates service");
			}
		});
	}
});
