// JavaScript Document
var originalShow = Ext.window.MessageBox.prototype.show;

Ext.override(Ext.window.MessageBox,{
	minWidth : 300,
	show: function(cfg) {
		if (cfg != undefined && cfg.msg != undefined)
		{
			cfg.msg = Ext.String.trim(cfg.msg);
			var lastChar = cfg.msg.charAt(cfg.msg.length-1);
			if (lastChar  !=  '.'  &&  lastChar  !=  '?' && lastChar  !=  '!')
			{
				cfg.msg = cfg.msg + ".";
			}
		}
		if (cfg != undefined && cfg.msg != undefined && !cfg.hasOwnProperty("width"))
		{
			var tmpWidth = cfg.msg.length * 7;
			Ext.applyIf(cfg,{width : tmpWidth});
		}
		return originalShow.apply(this, arguments);
	},
	alert: function(cfg, msg, fn, scope) {
		if (Ext.isString(cfg)) {
			if (msg != undefined)
			{
				msg = Ext.String.trim(msg);
				var lastChar = msg.charAt(msg.length-1);
				if (lastChar  !=  '.'  &&  lastChar  !=  '?' && lastChar  !=  '!')
				{
					msg = msg + ".";
				}
			}
			cfg = {
				title : cfg,
				msg : msg ,
				buttons: this.OK,
				icon : 'iconExclamation',
				fn: fn,
				scope : scope,
				minWidth: this.minWidth
			};
		}
		return this.show(cfg);
	},
	confirm: function(cfg, msg, fn, scope) {
		if (Ext.isString(cfg)) {
			if (msg != undefined)
			{
				msg = Ext.String.trim(msg);
				var lastChar = msg.charAt(msg.length-1);
				if (lastChar  !=  '?')
				{
					msg = msg + "?";
				}
			}
			cfg = {
				title: cfg,
				icon: 'iconConfirmation',
				msg: msg,
				buttons: this.YESNO,
				callback: fn,
				scope: scope
			};
		}
		return this.show(cfg);
	}
});

Ext.Loader.setConfig({
 	enabled:true,
	disableCaching:false
});
Ext.Loader.setPath('utilities', '/final/scripts/utilities');
Ext.Loader.setPath('Ext.ux', '/final/scripts/ux');
Ext.Loader.setPath('util', '/final/scripts/utilities');

Ext.application({
		name:'login',
		requires:['login.view.Main'],
		controllers: ['login.controller.Login'],
		appFolder:'/final/scripts/LoginApp',
		launch:function(){
			
				Ext.create('Ext.container.Viewport',{
						layout:'fit',
						items:[
							{
								xtype:'main'
							}
						]
					});
			}
		
	});

