Ext.define('login.view.TwoFALoginPage', {
	extend: 'Ext.form.Panel',
	alias: 'widget.twofaloginpage',
	id:'twofaloginpage',
	frame: false,
	border : false,
	bodyPadding:0,
	layout:'anchor',
	align:'center',
	height:'auto',

	requires: [
		'login.view.FormErrorState'
	],

	defaults: {
		labelAlign: 'top',
		allowBlank: false,
		anchor:'100%',
		msgTarget: 'none',
		invalidCls: ''//unset the invalidCls so individual fields do not get styled as invalid
	},

	items: [
		{
			xtype:'container',
			align:'center',
			margin:'13px 10px 12px 15px',
			html:'<div id="loginHeader"><div class="loginKey"></div><div class="loginText">2-Step Verification</div></div><div style="margin:10px 10px 10px 0px;float:left;cursor:pointer;display:none;" class="iconTooltipHelp" id="loginHelpTip"></div>'
		},
		{
			xtype:'container',
			layout: {
				type: 'hbox',
				pack: 'center'
			},
			id: 'resendCode',
			hidden: true,
			cls: 'formOuter',
			margin: 10,
			padding: 10,
			items: [
				{
					xtype: 'label',
					align: 'center',
					html: '<div style="float:left;color:#787878">Haven\'t received the code yet?&nbsp;</div><div id="resend_otp_div" style="cursor:pointer;text-decoration:underline;font-size:12px;float:right;">Resend code</div>'
				}
			]
		},
		{
			xtype: 'panel',
			layout: {
				type: 'vbox',
				pack: 'center',
				align: 'stretch'
			},
			cls: 'loginpanelInner',
			margin: 10,
			items: [
				{
					xtype: 'container',
					layout: {
						type: 'vbox',
						pack: 'start',
						align: 'stretch'
					},
					flex: 1,
					margin: 10,
					items: [
						{
							xtype: 'label',
							id:'mailIdLabel',
							html: '<span style="font-size:12px;font-weight:bold;color:#787878">Enter a verification code</span><br><br>A mail with a verfication code was just sent to *********',
							width: 300
						},
						{
							xtype : 'textfield',
							name : 'otp',
							id :'otp',
							inputType: 'password',
							emptyText: 'Enter the 6-digit code',
							width: 300,
							labelSeparator: '',
							margin: '15 0 0 0',
							enableKeyEvents : true
						},
						{
							xtype: 'formErrorState',
							id:'errorState',
							anchor:'100%',
							margin:'15 0 0 0',
							hidden: true
						}
					]
				},
				{
					xtype:'container',
					layout: {
						type: 'hbox',
						pack: 'end'
					},
					margin: '20 10 10 10',
					items: [
						{
							xtype : 'button',
							action : 'submit',
							id :'twofa_submit',
							height: 26,
							text: 'Done',
							cls:'buttonBig'
						}
					]
				}
			]
		}
	]
});



