Ext.tip.QuickTipManager.init();
(function($) {
	//---adding bg to text 
    function createSVGTextBg(element,color) {
			  var svgNS = "http://www.w3.org/2000/svg"
			  ,bounds = element.getBBox()
			  ,elemBG = document.createElementNS(svgNS, "rect")
			  ,style = getComputedStyle(element)
			  ,paddingRight = parseInt(style["padding-right"])
			  ,paddingTop = parseInt(style["padding-top"])
			  ,paddingLeft = parseInt(style["padding-left"])
			  ,paddingBottom = parseInt(style["padding-bottom"]);
			 elemBG.setAttribute("x", bounds.x - parseInt(style["padding-left"]))
			  elemBG.setAttribute("y", bounds.y - parseInt(style["padding-top"]))
			  elemBG.setAttribute("width", bounds.width + paddingLeft + paddingRight)
			  elemBG.setAttribute("height", bounds.height + paddingTop + paddingBottom)
			  elemBG.setAttribute("fill",color)
			  elemBG.setAttribute("class","textbg")
			  if (element.hasAttribute("transform")) {
				elemBG.setAttribute("transform", element.getAttribute("transform"))
			  }
			  element.parentNode.insertBefore(elemBG, element)
	}
    // -- default settings
    var settings = {
        renderTo: 'body',
        width: 800,
        height: 900,
        url: null,
        zoom: true,
		segmentName:null,
		//layoutAlign: Ext.isEmpty(window.parent.isTvMode) ? 'left' : 'center',
		layoutAlign: 'center',
		fromPage:null,
        loadingText: "creating topology...",
		min_zoom:0.2,
		max_zoom:2,
		default_zoom:1,
		gravity:0,
		charge:function(d, i) { return i ? 0 : -2000; },
		segmentStateCls:null, 
		enableFitLayout:true,
		linkDistance:3,
		initialX:null,
		initialY:null,
		zoomObj:d3.behavior.zoom(),
		collideLayout:false,
        draggable: true,
        margin: {
            top: -8,
            right: -8,
            bottom: -8,
            left: -8
        }
    };
    var data, loading, connectedNodes, timer, mousedownsearch = false,segmentName1,oldSgt,newSgt,segmentName,movementX,movementY,HX,HY,LX,LY,
	hideScrollbar = true,translateZ,scaleZ,svgScale = {},svg,body = d3.select("body"),toolTip,slider_tooltip;



    // -- rendering data 
    $.fn.renderDiagram = function(options) {

        var options = $.extend({}, settings, options);

		options.linkDistance = (options.width + options.height) /2;
        // -- Force layout object
        var force = d3.layout.force().gravity(options.gravity).charge(options.charge).linkDistance(options.linkDistance).size([options.width, options.height]);
		segmentName = options.segmentName;
		
        d3.json('#', function(error, graph) {
			
			var  graph = options.data;
			
            var xScale = d3.scale.linear().domain([0, options.width]);
            var yScale = d3.scale.linear().domain([0, options.height]);
            var tip, i = 0, timeout;

            // -- data popup
            if (error) {
                //d3.select(options.renderTo).text('MAY BE ERROR IN YOUR DATA');
            }

            // -- removing the loader
            //loading.remove();
            this.nodes = graph.rootJson.nodes;
            this.links = graph.rootJson.links;
			
            var Nodes = this.nodes;
            var Links = this.links;
            /************text bg ************/
            var color  = graph.rootJson.paper.skin == "Dark" ? "#434343" :"#ffffff";
            var textbg = d3.select('svg.svgparentTag').append("defs").append("filter").attr("id", "textBg")
            .attr('x',0).attr('y',0).attr('height',1.1).attr('width',1);
            textbg.append('feFlood').attr('flood-color',color);
            textbg.append('feComposite').attr('in','SourceGraphic');
            /********************************/

            // -- Forming the force layout
			var k = Math.sqrt(Nodes.length / (options.width * options.height));
            force.nodes(this.nodes).links(this.links).gravity(100 * k).charge(-10 / k).linkDistance(options.linkDistance).size([options.width, options.height]).start();
            var HX = d3.max(this.nodes, function(d) {
                return d.x;
            });
            var HY = d3.max(this.nodes, function(d) {
                return d.y;
            });
	     LX = d3.min(this.nodes, function(d) {
                return d.x;
            });
            LY = d3.min(this.nodes, function(d) {
                return d.y;
            });
            //var movement = options.width /3;
			var movement;
			if(options.layoutAlign == 'center'){
				movementX = (options.width - HX) / 2;
				movementY =(options.height - HY)/2;
			
				
			}else if(options.layoutAlign == 'left'){
				
				movementX = 0;
				movementY = 0;
			}else{
				movementX = 0;
				movementY = 0;
			}
            

            // ---------- Find link//
            var edges = [];
            var toggle = 0;

            // Create an array logging what is connected to what
            var linkedByIndex = {};
            for (i = 0; i < this.nodes.length; i++) {
                linkedByIndex[i + "," + i] = 1;
            };
            this.links.forEach(function(d) {
                linkedByIndex[d.source.index + "," + d.target.index] = 1;
            });
            // This function looks up whether a pair are neighbours
            function neighboring(a, b) {
                return linkedByIndex[a.index + "," + b.index];
            }
            connectedNodes = function() {
                clearTimeout(timer);
                if (d3.event.defaultPrevented) return;
                if (toggle == 0) {
                    // Reduce the opacity of all but the neighbouring nodes
                    d = d3.select(this).node().__data__;
                    groupNodes.style("opacity", function(o) {
                        return neighboring(d, o) | neighboring(o, d) ? 1 : 0.1;
                    });
                    path.style("opacity", function(o) {
                        return d.index == o.source.index | d.index == o.target.index ? 1 : 0.1;
                    });
                    // Reduce the opacity
                    toggle = 1;
                } else {
                    //Put them back to opacity=1
                    groupNodes.style("opacity", 1);
                    path.style("opacity", 1);
                    toggle = 0;
                }
            }

            // ---------- search node//
            var optArray = [];
            for (var i = 0; i < this.nodes.length - 1; i++) {

                optArray.push(this.nodes[i].cName, this.nodes[i].x, this.nodes[i].y);
            }
            optArray = optArray.sort();
            $(function() {
                $("#search").autocomplete({
					//disabled: true,
                    source: optArray,
					
                });
            });
			
            function searchNode() {
                //find the node
                var selectedVal = document.getElementById('search').value;
                var node = d3.select('svg.svgparentTag').selectAll(".g_node");
                if (selectedVal == null || selectedVal == "" || selectedVal == 'undefined') {
                    return;
					//node.style("stroke", "white").style("stroke-width", "1");
					
                } else {
                    var getX;
                    var getY;
                    var selected = node.filter(function(d, i) {
						
                        if (selectedVal != null && selectedVal == d.cName) {
							//d3.select('.highlitenode').remove();
							d3.select(this).append("circle").attr("class","highlitenode").attr("r", 25).style({"stroke":"#000000","stroke-width":"1px","fill":"none"}).transition().duration(5000).remove();
                            getX = d.x;
                            getY = d.y;
                        }
                        return d.cName != selectedVal && d.px && d.py;

                    });

					 d3.select('svg.svgparentTag').select('.pitch').transition() .duration(2000)
					.call(options.zoomObj.scale(1.8).translate([(-parseInt(getX)*1.8 + options.width/2), (-parseInt(getY)*1.8 + options.height/2)]).event);
					
					 $('html,body').animate({ scrollTop: $('.svgparentTag').offset().top - ( $(window).height() - $('.svgparentTag').outerHeight(true) ) / 2  }, 200);
					//options.zoomObj.scale(1.8).event(d3.select('svg.svgparentTag').select('.pitch'));

					
					
                    selected.style("opacity", "0");
					
                    var link = d3.select('svg.svgparentTag').selectAll(".link")
                    link.style("opacity", "0");
                    d3.selectAll(".g_node, .link, .changeColor").transition()
                        .duration(2000)
                        .style("opacity", 1);
                }
            }
            //$('#searchnode').live('click', function(e) {
			$('body').on('click','#searchnode',function(){
                e.stopImmediatePropagation();

                searchNode();
                $('#search').focus();
            });
			$("#search").keyup(function(event){
				if(event.keyCode == 13){
					$('#searchnode').click();
				
					
    
				}
			});

            $("#searchnode").mousedown(function() {
                mousedownsearch = true;
            });
            //Force drag event
            function dragStart(d) {
                d3.event.sourceEvent.stopPropagation();
                d3.select(this).classed("fixed", d.fixed = true);
				d3.select(this).classed("dragging", true);
                

                if (options.draggable) {
					d3.select(this).style('cursor','move');
 
                }

            }
			function dragged(d){
				
				d3.select(this).classed("dragging", true);
			}
            function dragEnd(d) {
				try
				{
					moveEnd(d); //user defind method
				} catch(e){
					//console.log(e);
				}
                if (options.draggable) {
                   d3.select(this).style('cursor','pointer');
                }

            }

            var path = d3.select('.pitch').append("svg:g").selectAll("path.marker")
                .data(force.links())
                .enter()
                .append("svg:path")
                .attr("class", "link")
				.attr("stroke-dasharray","0")
				.attr("stroke-linecap", "round")
                .style("stroke-width", function(d) {
                    return 1;
                })
                .attr("transform", function(d) {
                    return "translate(" + movementX + "," + movementY + ")";
                });

            path.filter(function(d) {
                return d.arrow == true;
            }).attr("marker-mid", function(d) {
                return "url(#BLUE)"
            })

            // -- draggable
            if (options.draggable) {
                var drag = force
					.drag()
					.on("dragstart", dragStart)
					.on("dragend", dragEnd);

                var groupNodes = d3.select('.pitch')
                    .selectAll('g.g_node')
                    .data(this.nodes)
                    .enter()
                    .append('g')
                    .classed('g_node', true).attr("transform", function(d) {
                        return "translate(" + movementX + "," + movementY + ")";
                    }).call(drag);

            } else {

                var groupNodes = d3.select('.pitch')
                    .selectAll('g.g_node')
                    .data(this.nodes)
                    .enter()
                    .append('g')
                    .classed('g_node', true).attr("transform", function(d) {
                        return "translate(" + movementX + "," + movementY + ")";
                    });

            }
			var patchx = groupNodes.append('svg:circle')
						.attr('class', 'node_patch_x')
						.attr('r', 20)
						.attr('fill',function(){
							var color  = graph.rootJson.paper.skin == "Dark" ? "#434343" :"#ffffff"; //default	
							return color;

						})
						.attr("transform", function(d) {
							return "translate(" + (movementX+5) + "," +( movementY-5) + ")";
						});
			var patch = groupNodes.append('svg:circle')
						.attr('class', 'node_patch')
						.attr('r', 30)
						.attr('fill',function(){
							var color  = graph.rootJson.paper.skin == "Dark" ? "#434343" :"#ffffff"; //default	
							return color;

						})
						.attr('stroke',function(){
							var color  = graph.rootJson.paper.skin == "Dark" ? "#434343" :"#ffffff"; //default
							return color;	
						})
						.attr("transform", function(d) {
							return "translate(" + (movementX+5) + "," +( movementY-5) + ")";
						}).style('display','none').style("opacity", 0);
			var patch2 = groupNodes.append('svg:circle')
						.attr('class', 'node_patch')
						.attr('r', 25)
						.attr('fill',function(){
							var color  = graph.rootJson.paper.skin == "Dark" ? "#434343" :"#ffffff"; //default	
							return color;

						})
						.attr('stroke',function(){
							var color  = graph.rootJson.paper.skin == "Dark" ? "#434343" :"#ffffff"; //default
							return color;	
						})
						.attr("transform", function(d) {
							return "translate(" + (movementX+5) + "," +( movementY-5) + ")";
						}).style('display','none').style("opacity", 0);
            var serverIcons = groupNodes
                .append('svg:image')
                .attr('class', 'serverimg')
                .attr('height', 48)
                .attr('width', 48)
                .attr("xlink:href", function(d) {
                    return d.cImage_url
                }).attr("transform", function(d) {
                    return "translate(" + (movementX - 20) + "," +( movementY -30) + ")";
                }); //Here you move the nodes;
            var clickedOnce = false;

            serverIcons.filter(function(d) {

                return d.linktoLayermodel;
            }).on('click', function(d) {
                if (d3.event.defaultPrevented) return;
                if (timer) clearTimeout(timer);
                timer = setTimeout(function() {
                    window.parent.location = d.linktoLayermodel;
                }, 250);

                //alert('d.linktoLayermodel');
            });
			var tip = d3.select('body')
				.append('div')
				.attr('class', 'tip')
				.attr('trackMouse', 'true')
				.html('Click to manage')
				.style('padding', '5px')
				.style('position', 'absolute')
				.style( 'color', '#fff')
				.style('border-bottom', '1px dotted black')
				.style('pointer-events','none')
				.style("background", "black")
				.style("visibility", "hidden")
				.on('mouseover', function(d, i) {
					tip.transition().duration(0);
				})
				.on('mouseout', function(d, i) {
					tip.style('display', 'none');
					tip.hide;
				});

			serverIcons.on('mouseover',function(d,i){
				if(d.status == "NEW")
				{
					var pX = d3.event.pageX;
					var pY = d3.event.pageY;
					tip.transition().duration(0);
					tip.style('top', pY - 20 + 'px');
					tip.style('left', pX + 'px');
					tip.style('display', 'block');
					tip.style("visibility", "visible")
				}
			});
			serverIcons.on('mouseout',function(d,i){
				tip.style("visibility", "hidden")
			});
			var DELAY = 500,clicks = 0,click_timer = null;	
			serverIcons.on('click',function(d){
				var that= d;
				var pX = d3.event.pageX;
				var pY = d3.event.pageY;
				clicks++;
				click_timer = setTimeout(function(){
					if(clicks ===1)
					{
						//showExtMenu(that,pX +5,pY+5)
					}
					else if(clicks ===2){
					}
				clearTimeout(click_timer);
				clicks =0;
				},DELAY);
			});
            serverIcons.on('dblclick', connectedNodes);
			
            /*groupNodes.append("title").text(function(d) {
                return d.cName;
            });*/
            var groupText = groupNodes.append('g')
				.attr('class','groupText')
				.attr("transform", function (d) {
					return "translate(0,4)";
				});  
         /* var textStroke = groupText.append("text").each(function (d) {
					var arr = d.cName.split(" ");
					var comType = "";
					if(d.cType != undefined)
					{
						comType += d.cType;
					}
					var typeArr = comType.split("\n");
					if(typeArr.length > 1)
					{
					if (arr != undefined) {
						for (i = 0; i < arr.length; i++) {
							d3.select(this).append("tspan")
								.text(arr[i])
								.attr("dy", i ? "1.2em" : 18)
								.attr("x", 0)
								.attr("text-anchor", "middle")
								.attr("class", "tspan" + i);
						}
					}
					}
					else
					{
							if (arr != undefined) {
							for (i = 0; i < arr.length; i++) {
							d3.select(this).append("tspan")
								.text(arr[i])
								.attr("dy", i ? "1.2em" : 7)
								.attr("x", 0)
								.attr("text-anchor", "middle")
								.attr("class", "tspan" + i);
							}
						}
					}
        /*if (arr != undefined) {
            for (i = 0; i < arr.length; i++) {
                d3.select(this).append("tspan")
                    .text(arr[i])
                    .attr("dy", i ? "1.2em" : 0)
                    .attr("x", 0)
                    .attr("text-anchor", "middle")
                    .attr("class", "tspan" + i);
            }
        }*/
    //}).attr("dy","0.35em").attr("class", "componentname_stroke").attr("transform", function(d) {
           //     return "translate(" + movement + "," + 43 + ")";
          //  }).style('filter', 'url(#textBg)');*/
			//Here you move the nodes;
	var texts = groupText.append("text").attr("class", "componentname").each(function (d) {
       var compName = d.cName.split(" ");
				var compType = "";
				if(d.cType != undefined)
				{
					compType += d.cType;
				}
				var typeArr = compType.split("\n");
				if(typeArr.length > 1)
				{
					if (compName != undefined) {
						for (i = 0; i < compName.length; i++) {
							d3.select(this).append("tspan")
								.text(compName[i])
								.attr("dy", i ? "1.2em" : 18)
								.attr("x", 0)
								.attr("text-anchor", "middle")
								.attr("class", "tspan" + i);
						}
					}
				}
				else
				{
					if (compName != undefined) {
						for (i = 0; i < compName.length; i++) {
						d3.select(this).append("tspan")
							.text(compName[i])
							  .attr("dy", i ? "1.2em" : 0)
							.attr("x", 0)
							.attr("text-anchor", "middle")
							.text(function(d) {
								//return d.cType;
								return textTrim(d.cName, 20);
							})
							.attr('data-qtip',function(d,i){
								return d.cName;
							})
							.attr("class", "tspan" + i);
						}
					}
				}
        /*if (arr != undefined) {
            for (i = 0; i < arr.length; i++) {
                d3.select(this).append("tspan")
                    .text(arr[i])
                    .attr("dy", i ? "1.2em" : 0)
                    .attr("x", 0)
                    .attr("text-anchor", "middle")
                    .attr("class", "tspan" + i);
            }
        }*/
    }).attr("transform", function(d) {
                return "translate(" + movementX + "," + (movementY + 46) + ")";
            })//.style('filter', 'url(#textBg)');
           
			var userTextStroke = groupText.filter(function(d) {
                return d.cName === 'User'
            }).attr('class', 'userNode').style('display','none');

            var userText = texts.filter(function(d) {
                return d.cName === 'User'
            }).attr('class', 'userNode').style('display','none')//.style('filter', 'url(#textBg)');

			
			/*var componentTypeStroke = groupNodes.append("text").attr("class", "componenttype_stroke").attr("text-anchor", "middle").each(function(d) {
				var compType = "";
				if(d.cType != undefined)
				{
					compType += d.cType;
				}
				var compTypeArr = compType.split("\n");
				for(var k=0; k<compTypeArr.length; k++)
				{
					d3.select(this).append("tspan")
					.text(compTypeArr[k])
					.attr("dy", k ? "1.2em" : 4)
					.attr("x", 0)
					.attr("text-anchor", "middle")
				}
		}).attr("transform", function(d) {
                return "translate(" + movementX + "," + (movementY +30) + ")";
            });*/
		function textTrim(string, maxLength) {
				if (!string) return string;
				if (maxLength < 1) return string;
				if (string.length <= maxLength) return string;
				if (maxLength == 1) return string.substring(0,1) + '...';

				var midpoint = Math.ceil(string.length / 2);
				var toremove = string.length - maxLength;
				var lstrip = Math.ceil(toremove/2);
				var rstrip = toremove - lstrip;
				return string.substring(0, midpoint-lstrip) + '...' 
				+ string.substring(midpoint+rstrip);
			}

		var componentType = groupText.append("text")
			.attr("class", "componenttype")
			.attr("text-anchor", "middle")
			.text(function(d) {
                //return d.cType;
				/*var onloadSliderValue = $(".slider").slider("value");
				if (0.500 > onloadSliderValue) 
				{
                    d3.selectAll('text').transition().style("opacity", 0);
					Ext.defer(function(){
						d3.selectAll('.textbg').transition().style("opacity", 0);
					},200)
                } 
				else 
				{
					if(onloadSliderValue > 1.5)
					{
						//d3.selectAll('.componenttype').style('font-family','Roboto-Regular')
						//d3.selectAll('.componenttype').style('font-weight','100')
						//d3.selectAll('.componenttype').style('text-shadow','0px 0px 0px')
						//d3.selectAll('.componentname').style('font-family','Roboto-Regular')
						//d3.selectAll('.componentname').style('font-weight','100')
						//d3.selectAll('.componenttype').style('font-size','10')
						//d3.selectAll('.componentname').style('font-size','9')
					}
					else
					{
						//d3.selectAll('.componenttype').style('font-family','Roboto-Regular')
						//d3.selectAll('.componenttype').style('font-weight','100')
						//d3.selectAll('.componenttype').style('text-shadow','0px 0px 0px')
						//d3.selectAll('.componentname').style('font-family','Roboto-Regular')
						//d3.selectAll('.componentname').style('font-weight','100')
						//d3.selectAll('.componenttype').style('font-size','11')
						//d3.selectAll('.componentname').style('font-size','10')
					}
                    d3.selectAll('text').transition().style("opacity", 1);
					Ext.defer(function(){
						d3.selectAll('.textbg').transition().style("opacity", 1);
					},200)
                }*/
                return textTrim(d.cType, 18);
            })
			.attr('data-qtip',function(d,i){
					return d.cType;
			})
			.attr("transform", function(d) {
                return "translate(" + movementX + "," + (movementY + 33) + ")";
            }).style('filter', '.textBg').attr('data-qtip',function(d,i){
					return d.cType;
			});

		/*	var componentTypeStroke = groupNodes.append("text").attr("class", "componenttype_stroke").attr("text-anchor", "middle").text(function(d) {
                return d.cType;
            }).attr("transform", function(d) {
                return "translate(" + movement + "," + 30 + ")";
            });
			var componentType = groupNodes.append("text").attr("class", "componenttype").attr("text-anchor", "middle").text(function(d) {
                return d.cType;
            }).attr("transform", function(d) {
                return "translate(" + movement + "," + 30 + ")";
            });*/



            var stateImages = groupNodes.append("image")
                .attr("class", "stateIcon")
                .attr("xlink:href", function(d) {
                    return d.cStateImage_url
                })
                .attr("width", 16).attr("height", 16).attr("transform", function(d) {
                    return "translate(" + (movementX + 20) + "," + -5 + ")";
                });

				var RECENTcon = groupNodes.filter(function(d){
						return d.RECENT != null || d.RECENT == "undefined";
					}).append("image")
					.attr("class", "MANAGEDIcon")
					.attr("xlink:href", function(d) {
						return d.RECENT
					})
					.attr("width", 16).attr("height", 16).attr("transform", function(d) {
						
                    return "translate(" + (movementX + 16) + "," + (movementY -2)+ ")";
					});
				var UNMANAGEDIcon = groupNodes.filter(function(d){
						return d.UNMANAGE != null || d.UNMANAGE == "undefined";
					}).append("image")
					.attr("class", "UNMANAGEDIcon")
					.attr("xlink:href", function(d) {
						return d.UNMANAGE
					})
					.attr("width", 16).attr("height", 16).attr("transform", function(d) {
						return "translate(" + (movementX - 25) + "," + (movementY - 5) + ")"; //unmanaged
					});
				

				var NEWIcon =  groupNodes.filter(function(d){
						return d.NEW != null || d.NEW == "undefined";
					}).append("image")
					.attr("class", "NEWIcon")
					.attr("xlink:href", function(d) {
						return d.NEW
					})
					.attr("width", 16).attr("height", 16).attr("transform", function(d) {
							 return "translate(" + (movementX - 15) + "," + (movementY - 35) + ")"; //New
					});
				var MANAGEIcon =  groupNodes.filter(function(d){
						return d.MANAGE != null || d.NEW == "undefined";
					}).append("image")
					.attr("class", "MANAGEIcon")
					.attr("xlink:href", function(d) {
						return d.MANAGE
					})
					.attr("width", 16).attr("height", 16).attr("transform", function(d) {
							 return "translate(" + (movementX - 15) + "," + (movementY - 35) + ")"; //MANAGE
					});
			// -- Tick function
			//animate();
			
            force.on("tick", function(e) {
				if(options.collideLayout){
                groupNodes.each(collide(0.4));
				
				}

			groupNodes.on('mouseover', function(d) {
					
					path.style({'stroke-width': function(l) {
						if (d === l.source || d === l.target){
							return 1.5;
						}
						else{
							return 1;
						}
					},'stroke':function(l){
					if (d === l.source || d === l.target){
                            return "#909090";
						}
						else{
							return "#909090";
						}
					}}).attr('class',function(l){
					if (d === l.source || d === l.target){
							return "changeColor";
						}
						else{
							return "defalutArrow";
						}
					},true).style("stroke-dasharray", function(l){
						if (d === l.source || d === l.target){
							return ("3, 3");
						}
						else{
							return ("0, 0");
						}
						
					});

					 d3.selectAll('.changeColor').filter(function(d) {
                            return d.arrow == true;
                        }).attr("marker-mid", "url(#BLACK)");
					
					d3.select(this).selectAll('.node_patch').each(function(d,i){
						if(i ==0){
							d3.select(this).transition().duration(300).attr('fill',function(){
								var color  = graph.rootJson.paper.skin == "Dark" ? "#474c4f" :"#e7f6fd"; //default	
								return color;
							}).style('display','block').style("opacity", 1);
						}else{
							d3.select(this).transition().duration(300).attr('fill',function(){
								var color  = graph.rootJson.paper.skin == "Dark" ? "#4e575c" :"#d1edf8"; //default	
								return color;
							}).style('display','block').style("opacity", 1);
						}
					});
					
				}).on('mouseout', function(d) {
					//d3.select(this).select('.patch').attr("filter", null).style({'fill-opacity':'0.9','fill':null});
					//d3.select(".tooltip").remove();
					path.style('stroke-width', 1).style('stroke', '#909090').style("stroke-dasharray", function(l){
						if (d === l.source || d === l.target){
							return ("0, 0");
						}
						else{
							return ("0, 0");
						}
						
					});
					 d3.selectAll('.changeColor').filter(function(d) {
                            return d.arrow == true;
						}).style({"marker-mid":"url(#BLACK)"});
						
						d3.select(this).selectAll('.node_patch').transition().duration(300)
						.attr('fill',function(){
							var color  = graph.rootJson.paper.skin == "Dark" ? "#434343" :"#ffffff"; //default	
							return color;
	
						}).style('display','none').style("opacity", 0);	
				});

                path.each(function() {
                    this.parentNode.insertBefore(this, this);
                }); //IE 

                groupNodes.attr("transform", function(d) {
                    //Here i create a node radius so it doesnt go offscreen
                    var nodeRadius = 60;
                    //here I do checks to see if it goes offscreen
                  /*  if (d.x <= nodeRadius - movement) { //have to take movement away as you have moved the nodes/links previously
                        d.x = nodeRadius - movement;
                    }
                    if (d.y <= nodeRadius) {
                        d.y = nodeRadius;
                    }
                    if (d.x > options.width - nodeRadius - movement) {
                        d.x = options.width - nodeRadius - movement;
                    }
                    if (d.y > options.height - nodeRadius) {
                        d.y = options.height - nodeRadius;
                    }*/

                    return "translate(" + d.x + "," + d.y + ")";

                }).attr('data-qtip',function(d,i){
					//return d.cType+"</br>"+d.cName;
					if(d.cType != undefined && d.cType != null && d.cName != undefined && d.cType != null && d.cType != 'user')
						return d.cType+"</br>"+d.cName;
			});

               
				path.attr("d", function(d) {
    var dx = d.target.x - d.source.x,
        dy = d.target.y - d.source.y,
        dr = Math.sqrt(dx * dx + dy * dy)/4,
        mLx = d.source.x + dx/2,
        mLy = d.source.y + dy/2,
        mAx = d.source.x + dx,
        mAy = d.source.y + dy;
          if (d.source.x === d.target.x) {
			//dr = Math.sqrt(dx * dx + dy * dy) / 1.8;
					var sweep = 1;
                        if (d.source.y > d.target.y) {
                            sweep = 0;
                        }
						
                        return "M" +
                            d.source.x + "," + d.source.y +
                            "A" + dr + "," + dr +
                            " 0, 0" + sweep + " " +
                            d.target.x + "," + d.target.y;
    
      }
	   return [
          "M",d.source.x,d.source.y,
           "L",mLx,mLy,
           "L",d.target.x,d.target.y
           
          ].join(" ");
    
  });
                userText.style({
                    'display': 'none'
                });
			
            });

				// Adding background to the text
				var componentnametext = document.querySelectorAll(".componentname");
				var componenttypetext = document.querySelectorAll(".componenttype");
				var color  = graph.rootJson.paper.skin == "Dark" ? "#434343" :"#ffffff";
				for (var i = 0; i < componenttypetext.length; i++) {
						createSVGTextBg(componenttypetext[i],color);
				}
				  for (var i = 0; i < componentnametext.length; i++) {
					 createSVGTextBg(componentnametext[i],color);
				}


				var padding = 150, // separation between circles
				radius=2,
				that = this;
				function collide(alpha) {
				  var quadtree = d3.geom.quadtree(that.nodes);
				 
				  return function(d) {
					var rb = 2*radius + padding,
						nx1 = d.x - rb,
						nx2 = d.x + rb,
						ny1 = d.y - rb,
						ny2 = d.y + rb;
					quadtree.visit(function(quad, x1, y1, x2, y2) {
					  if (quad.point && (quad.point !== d)) {
						var x = d.x - quad.point.x,
							y = d.y - quad.point.y,
							l = Math.sqrt(x * x + y * y);
						  if (l < rb) {
						  l = (l - rb) / l * alpha;
						  d.x -= x *= l;
						  d.y -= y *= l;
						  quad.point.x += x;
						  quad.point.y += y;
						}
					  }
					  return x1 > nx2 || x2 < nx1 || y1 > ny2 || y2 < ny1;
					});
				  };
				}
				/*var timer = setTimeout(function(){
			  $( ".loaderTopo" ).remove();
			}, 3000);
			delete timer;*/
        });

    }

    $.fn.reusableSVG = function() {

        // -- glow while drag 
        var defs = d3.select('svg.svgparentTag').append("defs");
        defs.append("filter")
		.attr("id","blur_patch")
		.attr("x","-20")
		.attr("y","-40")
		.attr("width","60")
		.attr("height","60")
		.append("feGaussianBlur")
		.attr("in","SourceGraphic")
		.attr("stdDeviation","15").append("feOffset")
		.attr("dx","2").attr("dy","2").append("feComponentTransfer").append("feFuncA")
		.attr("type","linear").attr("slope","0.2")
		.append("feMerge").append("feMergeNode").attr("in","SourceGraphic")
		.attr("type","linear").attr("slope","0.2");
        //Reuseable arrow

        d3.select('svg.svgparentTag')
            .selectAll("marker")
            .data([{
                "name": "BLACK",
                "color": "#908e8f"
            }, {
                "name": "BLUE",
                "color": "#908e8f"
            }])
            .enter().append("svg:marker")
            .attr("id", function(d) {
                return d.name
            })
            .attr("fill", function(d) {
                return d.color;
            })
            .attr("viewBox", "0 -5 10 10")
            .attr("markerWidth", 6)
            .attr('markerUnits','userSpaceOnUse')
            .attr("refX", 0)
            .attr("refY", 0)
            .attr("markerHeight", 6)
            .attr("orient", "auto")
            .append("svg:path")
            .attr("d", "M0,-5L10,0L0,5");
    }

    $.fn.renderSvg = function(options) {

        var options = $.extend({}, settings, options);
        var dom = d3.select(options.renderTo);
        this.renderDiagram(options);
		var width = options.width + options.margin.left + options.margin.right;
		var height = options.height + options.margin.top + options.margin.bottom;
		if(width < 0)
			width = options.width;
		if(height < 0)
			height = options.height;
        var svg = d3.select(options.renderTo)
			.append('svg')
			.attr("viewBox", "0 0 " + options.width + " " + options.height)
            .attr("preserveAspectRatio", "xMinYMin")
            .attr('class', 'svgparentTag')
            .attr("width",width)
            .attr("height",height) .append("g").attr('class', 'pitch')
            .attr("transform", "translate(" + options.margin.left + "," + options.margin.top + ")");

         //   var container =  svg.append("g").attr('class', 'pitch');


        // -- glow while drag 
        this.reusableSVG();

        // -- pre Loading text 
        loading = svg.append("text").attr({
            x: options.width / 2,
            y: options.height / 2
        }).text(options.loadingText);



        if (options.zoom) {


            d3.select(options.renderTo).select('svg').remove();

			var xz = d3.scale.linear()
				.domain([-options.width / 2, options.width / 2])
				.range([0, options.width]);

			var yz = d3.scale.linear()
				.domain([-options.height / 2, options.height / 2])
				.range([options.height, 0]);


            var translateZ, scaleZ,svgScale = {};

			var hideText = function(value,scale){
				if (value > scale) {
                    d3.selectAll('text').transition().style("opacity", 0);
					Ext.defer(function(){
						d3.selectAll('.textbg').transition().style("opacity", 0);
					},200)
                } else {
					if(scale > 1.5)
					{
						//d3.selectAll('.componenttype').style('font-family','Roboto-Regular')
						//d3.selectAll('.componenttype').style('font-weight','100')
						//d3.selectAll('.componenttype').style('text-shadow','0px 0px 0px')
						//d3.selectAll('.componentname').style('font-family','Roboto-Regular')
						//d3.selectAll('.componentname').style('font-weight','100')
						//d3.selectAll('.componenttype').style('font-size','10')
						//d3.selectAll('.componentname').style('font-size','9')
					}
					else
					{
						//d3.selectAll('.componenttype').style('font-family','Roboto-Regular')
						//d3.selectAll('.componenttype').style('font-weight','100')
						//d3.selectAll('.componenttype').style('text-shadow','0px 0px 0px')
						//d3.selectAll('.componentname').style('font-family','Roboto-Regular')
						//d3.selectAll('.componentname').style('font-weight','100')
						//d3.selectAll('.componenttype').style('font-size','11')
						//d3.selectAll('.componentname').style('font-size','10')
					}
                    d3.selectAll('text').transition().style("opacity", 1);
					Ext.defer(function(){
						d3.selectAll('.textbg').transition().style("opacity", 1);
					},200)
                }
			}
			$(document).mousedown(function(){
				   d3.select('.pitch').style("cursor", "url('/final/images/hand_drag.cur'),default");
				});
				$(document).mouseup(function(){
					d3.select('.pitch').style("cursor", "url('/final/images/hand_move.cur'),default");
				});

    
            // -- zoom function
            var zoomFn = function() {
			translateZ = options.margin.left + "," + options.margin.top;
			scaleZ = d3.event.scale;
              svg.attr("transform", "translate("+d3.event.translate+ ") scale("+d3.event.scale +")");
                $(".slider").slider("value",d3.event.scale);
				//hideText(0.500,d3.event.scale);
		
			int_X = d3.event.translate[0];
			int_Y = d3.event.translate[1];
            };
			if(zoomFn){

			/*	if (localStorage.getItem('svgScale') === null) { */

						translateZ = options.margin.left + "," + options.margin.top;
						scaleZ = options.default_zoom;		
				/*}
				else{
					translateZ = JSON.parse(localStorage.getItem('svgScale')).transform;
					scaleZ = JSON.parse(localStorage.getItem( 'svgScale' )).scale;
			}
			*/
			}
			var zoomStartFn = function(){
				if(slider_tooltip){
				slider_tooltip.text(Math.round(scaleZ*100) + '%');
				slider_tooltip.show().delay(5000).fadeOut('slow');
					 
				}
			}
			var zoom = options.zoomObj
               // .x(xz)
                //.y(yz)
                .scaleExtent([options.min_zoom, options.max_zoom])
                .translate([options.initialX, options.initialY])
                //.center([options.width / 2, options.height / 2])
				.scale(scaleZ)
                .on("zoom", zoomFn)
				.on("zoomstart",zoomStartFn)
				//.on("zoomend",zoomEndFn)
                .size([options.width/2, options.height/2]);

			var width = options.width + options.margin.left + options.margin.right;
			var height = options.height + options.margin.top + options.margin.bottom;
			if(width < 0)
				width = options.width;
			if(height < 0)
				height = options.height;
            var svg = d3.select(options.renderTo)
                .append('svg')
                .attr("viewBox", "0 0 " + options.width + " " + options.height)
                .attr("preserveAspectRatio", "xMidYMid meet")
                .attr('class', 'svgparentTag')
                .attr("width",width)
				.attr("height", height)
                .call(zoom).on("dblclick.zoom", null).append("g")
                .attr('class', 'pitch').attr("transform", "translate(" + options.initialX + "," + options.initialY  + ")scale(" + scaleZ + ")");
                
                var rect = svg.append("rect")
				.attr("width", options.width)
				.attr("height", options.height)
				.style("fill", "none")
                .style("pointer-events", "all");
                
            
                //.attr("transform", "translate(" + options.margin.left + "," + options.margin.top + ")scale("+options.default_zoom+")")
                
                


                
            // -- glow while drag 
            this.reusableSVG();



          

			function interpolateZoom (translate, scale) {
				var self = this;
				return d3.transition().duration(500).tween("zoom", function () {
					var iTranslate = d3.interpolate(zoom.translate(), translate),
						iScale = d3.interpolate(zoom.scale(), scale);

					
					return function (t) {
						 zoom
						.scale(iScale(t))
						.translate(iTranslate(t))
						.event(svg);

						
					};
				});
			}
			function zoomClick() {
				var clicked = d3.event.target,
					direction = 1,
					factor = 0.2,
					target_zoom = ((options.max_zoom - options.min_zoom) / 100),
					center = [options.width / 2, options.height / 2],
					extent = zoom.scaleExtent([options.min_zoom,options.max_zoom]),
					translate = zoom.translate(),
					translate0 = [],
					l = [],
					view = {x: translate[0], y: translate[1], k: zoom.scale()};

				d3.event.preventDefault();
				direction = (this.id === 'zoom_in') ? 1 : -1;
				target_zoom = zoom.scale() * (1 + factor * direction);

				if (target_zoom < extent[0] || target_zoom > extent[1]) { return false; }

				translate0 = [(center[0] - view.x) / view.k, (center[1] - view.y) / view.k];
				view.k = target_zoom;
				l = [translate0[0] * view.k + view.x, translate0[1] * view.k + view.y];

				view.x += center[0] - l[0];
				view.y += center[1] - l[1];
						
				if(view.k <= options.min_zoom  || view.k >= options.max_zoom ){
					$(".slider").slider("value",view.k);
					return false
				}else{
						
				interpolateZoom([view.x, view.y], view.k);	
					}
				
				
			}
			
			
				// -- slider function
				function slideFn(value) {
					var scale = zoom.scale();
					var extent = zoom.scaleExtent();
					var newScale =  value;
					if (extent[0] <= newScale && newScale <= extent[1]) {
						
					  var t = zoom.translate();
					  var c = [options.width / 2, options.height / 2];
					  //localStorage.setItem('svgScale',JSON.stringify(newScale));
					  zoom
						.scale(newScale)
						.translate(
						  [c[0] + (t[0] - c[0]) / scale * newScale, 
						   c[1] + (t[1] - c[1]) / scale * newScale])
						.event(svg);
					}
				  };

			
                               
					function graphBounds() {
						var x = Number.POSITIVE_INFINITY,
						X = Number.NEGATIVE_INFINITY,
						y = Number.POSITIVE_INFINITY,
						Y = Number.NEGATIVE_INFINITY;
						//	item = d3.select(".g_node").node().getBBox();
						d3.select('.pitch').selectAll(".g_node").each(function(v) {
							getX = v.x - movementX;
							getY = v.y - movementY;
							//console.log(d3.select(this).node().getBBox())
							var	item = d3.select(this).node().getBBox();
							x = Math.min(x, (v.x + movementX) - 120 / 2);
							X = Math.max(X, (v.x + movementX) + 120 / 2);
							y = Math.min(y, (v.y + movementY) - 120 / 2);
							Y = Math.max(Y, (v.y + movementY) + 120 / 2);
						});
						return {
							x: x,
							X: X,
							y: y,
							Y: Y
						};
					}
			
			function zoomToFit() {
				var b = graphBounds();
				var w = b.X - b.x, 
				h = b.Y - b.y;
				/*var cw = $(window).width() + options.margin.left + options.margin.right, 
				ch = $(window).height() + options.margin.top + options.margin.bottom;
				var s = Math.min(cw / w , ch / h);
				var tx = (-b.x * s + (cw / s - w) * s / 2) ,
				ty = (-b.y * s + (ch / s - h) * s / 2);*/
				var cw = $(window).width() + options.margin.left + options.margin.right, 
				ch = $(window).height() + options.margin.top + options.margin.bottom,
				s = d3.min([Math.min(cw / w , ch / h),options.max_zoom]);
				tx = (-b.x - movementX * s + (cw / s - w) * s / 2) ,
				ty = (-b.y - movementY * s + (ch / s - h) * s / 2);				

				if(options.layoutAlign == 'center' && options.enableFitLayout){
					//alert("center+auto");
					var cw = ($(window).width() + options.margin.left + options.margin.right), 
					ch = $(window).height() + options.margin.top + options.margin.bottom;
					s = d3.min([Math.min(cw / w , ch / h),options.max_zoom]);
					tx = (-b.x * s + (cw / s - w) * s / 2) ,
					ty = (-b.y  * s + (ch / s - h) * s / 2);
					//console.log('scale',d3.min([s,options.max_zoom]));

				}else if(options.layoutAlign == 'left' && options.enableFitLayout){
					//alert('left+auto');
					cw = options.width + options.margin.left + options.margin.right, 
					ch = options.height + options.margin.top + options.margin.bottom;
					s = d3.min([Math.min(cw / w , ch / h),options.max_zoom]);
					tx = (-b.x * s + (cw / s - w) * s / 2),
					ty = (-b.y - movementY  * s + (ch / s - h) * s / 2);

					//tx = tx - HX - LX ;

				}else if(options.layoutAlign == 'left' && options.enableFitLayout == false){
					//alert('left+manual')
					cw = $(window).width() + options.margin.left + options.margin.right, 
					ch = $(window).height() + options.margin.top + options.margin.bottom;
					s = d3.min([Math.min(cw / w , ch / h),options.max_zoom]);
					tx = (-b.x * s + (cw / s - w) * s / 2),
					ty = (-b.y - movementY * s + (ch / s - h) * s / 2);
				}
				

				//d3.select('svg.svgparentTag').select('.pitch').transition().duration(2000).call(options.zoomObj.scale(s)
				//.translate([parseInt(tx),parseInt(ty)]).event);
				interpolateZoom([parseInt(tx), parseInt(ty)], s);
				$(".slider").slider("value",s);
				//hideText(1,s); // -- show text
				//-- checking for scroll in window
				/*if ($(document).height() > $(window).height()) {
				$('html,body').animate({scrollTop:0},200);
				}*/

				delete tx,ty,s,cw,ch;
			}
			
           var slider =  dom.append('div').attr('class', 'slider');
           var slider_buttons =  dom.append('div').attr('class', 'slider_buttons');
		   var zoomslider_in = slider_buttons.append('button').attr('id','zoom_in').attr('class','button_zoom zoomInbt zoomtop');
		  var zoomslider_out = slider_buttons.append('button').attr('id','zoom_out').attr('class','button_zoom zoomOutbt zoombottom');

			
            $(options.renderTo).append('<div class="ui-widget searchbox"><div class="toposearch" title="Search"><div id="searchcom" style="display:none;position:absolute;left:-50px"><input id="search"><button title="Search" type="button"  id="searchnode">&nbsp;</button></div></div><button id="fit" title="Fit">&nbsp;</button></div>');

          
			/*if(options.enableFitLayout){
			  $('#fit').show();
			}else{
			  $('#fit').hide();
			}*/
			$('#fit').hide();
			d3.selectAll('button.button_zoom').on('click', zoomClick);


            //$('.toposearch').live('click', function() {
			$('body').on('click','.toposearch',function(){
                $("#searchcom").animate({
                    left: "-145px",
                }, 100, function() {
                    $('#search').focus();
    
                }).show();
            });
            $('#search').blur(function() {
                if (mousedownsearch) {
                    mousedownsearch = false;
                } else {
                    $("#searchcom").animate({
                        left: "-50px",
                    }, 100).hide();
                }
            });

            //$('#fit').live('click', function() {
			$('body').on('click','#fit',function(){
                zoomToFit();
            });

            var slider_tooltip = $('<span id="tooltip" class="slider_tooltip" />').css({
                position: 'absolute',
                 top: -5,
                left: 20
            }).hide();
			
            $(".slider").slider({
                animate: "slow",
               // range: "min",
                orientation: "vertical",
                min: options.min_zoom,
                max: options.max_zoom,
                value: scaleZ,
                step: ((options.max_zoom - options.min_zoom) / 100),
                slide: function(event, ui) {
                   slider_tooltip.text(Math.round(ui.value*100) + '%');
                    slideFn(ui.value);


                }
            }).find(".ui-slider-handle").append(slider_tooltip).hover(function() {
                slider_tooltip.text(Math.round(scaleZ*100) + '%');
                slider_tooltip.fadeIn('fast');
            }, function() {
                slider_tooltip.fadeOut('fast');
            });


        } else {
            console.log('false')
        }
        $( window ).resize(function() {
		
			$('.ui-widget-content').css({'margin-top':$( window ).height() - 180,'margin-left':20});
			$('.slider_buttons').css({'margin-top':$( window ).height() - 190,'margin-left':20});
			
		  }).resize();
    };


}(jQuery));