Ext.tip.QuickTipManager.init();
(function($) {
//---adding bg to text 
    function createSVGTextBg(element,color) {
			  var svgNS = "http://www.w3.org/2000/svg"
			  ,bounds = element.getBBox()
			  ,elemBG = document.createElementNS(svgNS, "rect")
			  ,style = getComputedStyle(element)
			  ,paddingRight = parseInt(style["padding-right"])
			  ,paddingTop = parseInt(style["padding-top"])
			  ,paddingLeft = parseInt(style["padding-left"])
			  ,paddingBottom = parseInt(style["padding-bottom"]);
			 elemBG.setAttribute("x", bounds.x - parseInt(style["padding-left"]))
			  elemBG.setAttribute("y", bounds.y - parseInt(style["padding-top"]))
			  elemBG.setAttribute("width", bounds.width + paddingLeft + paddingRight)
			  elemBG.setAttribute("height", bounds.height + paddingTop + paddingBottom)
			  elemBG.setAttribute("fill",color)
			  elemBG.setAttribute("class","textbg")
			  if (element.hasAttribute("transform")) {
				elemBG.setAttribute("transform", element.getAttribute("transform"))
			  }
			  element.parentNode.insertBefore(elemBG, element)
	}
// -- default settings
var settings = {
	chartTitle: 'Testing',
	renderTo: 'body',
	width: 800,
	height: 900,
	url: null,
	zoom: true,
	segmentName: null,
	layoutAlign: 'center',
	fromPage: null,
	loadingText: "creating topology...",
	min_zoom: 0.2,
	max_zoom: 2,
	default_zoom: 1,
	gravity: 0,
	charge: function(d, i) { return i ? 0 : -2000; },
	segmentStateCls: null, 
	enableFitLayout: true,
	landingPage:'modify',
	linkDistance: 3,
	initialX: null,
	initialY: null,
	zoomObj: d3.behavior.zoom(),
	collideLayout: false,
	draggable: true,
	margin: {
			top: -8,
			right: -8,
			bottom: -8,
			left: -8
		},
	isMenuEnable:true,
	hideSlider:true
};
var data, loading, connectedNodes, timer, mousedownsearch = false,oldSgt,newSgt,segmentName,movementX,movementY,HX,HY,LX,LY,
hideScrollbar = true,translateZ,scaleZ,svgScale = {},svg,body = d3.select("body"),toolTip,header,slider_tooltip,duration = 500,force;


// -- rendering data 
$.fn.renderDiagram = function(options) {

	var options = $.extend({}, settings, options);
	options.linkDistance = (options.width + options.height) /2;

	// -- Force layout object
	force = d3.layout.force();

	// -- localStorage--start-----
	
	if(options.landingPage == 'modify') {
		
		segmentName = options.segmentName;
		window.localStorage.setItem("currentsgt", segmentName);
		newSgt = window.localStorage.getItem("currentsgt");

		if (window.localStorage.getItem("pervoiussgt")){
			oldSgt = window.localStorage.getItem("pervoiussgt");
		}

		if(oldSgt != newSgt) 
		{
			window.localStorage.setItem("pervoiussgt", segmentName);
			if(localStorage.getItem('svgScale')){
				window.localStorage.removeItem('svgScale');
			}
			
		}
	}
	// -- localStorage--end-----

	d3.json('#', function(error, graph) {
		
		var graph = options.data; //***here we are passing JSON data to graph
		xScale = d3.scale.linear().domain([0, options.width]);
		yScale = d3.scale.linear().domain([0, options.height]);
		var tip, i = 0, timeout;
		/**
		//this code is required when we use url in d3.json(urlLink, function(error, graph) {} 
		if (error) {
			//d3.select(options.renderTo).text('MAY BE ERROR IN YOUR DATA');
		} */

		this.nodes = graph.rootJson.nodes;
		this.links = graph.rootJson.links;
		
		var Nodes = this.nodes;
		var Links = this.links;

		/************text bg ************/
			var color  = graph.rootJson.paper.skin == "Dark" ? "#444444" :"#ffffff";
			var textbg = d3.select('svg.svgparentTag').append("defs").append("filter").attr("id", "textBg")
			.attr('x',0).attr('y',0).attr('height',1.1).attr('width',1);
			textbg.append('feFlood').attr('flood-color',color);
			textbg.append('feComposite').attr('in','SourceGraphic');
			/********************************/
		// -- Forming the force layout 
		var k = Math.sqrt(Nodes.length / (options.width * options.height));
		force.nodes(this.nodes).links(this.links).gravity(100 * k).charge(-10 / k).linkDistance(options.linkDistance).size([options.width, options.height]).start();

		HX = d3.max(this.nodes, function(d) {
			return d.x;
		});
		HY = d3.max(this.nodes, function(d) {
			return d.y;
		});
		LX = d3.min(this.nodes, function(d) {
			return d.x;
		});
		LY = d3.min(this.nodes, function(d) {
			return d.y;
		});

		//movement
		var movement = 0;
		
		if(options.layoutAlign == 'center'){
			movementX = (options.width - HX) / 2;
			movementY =(options.height - HY)/2;
		
			
		}else if(options.layoutAlign == 'left'){
			
			movementX = 0;
			movementY = 0;
		}else{
			movementX = 0;
			movementY = 0;
		}


		// --Find link 
		var edges = [];
		var toggle = 0;

		// -- Create an array logging what is connected to what
		var linkedByIndex = {};
		for (i = 0; i < this.nodes.length; i++) {
			linkedByIndex[i + "," + i] = 1;
		};
		this.links.forEach(function(d) {
			linkedByIndex[d.source.index + "," + d.target.index] = 1;
		});
		// -- This function looks up whether a pair are neighbours
		function neighboring(a, b) {
			return linkedByIndex[a.index + "," + b.index];
		}
		connectedNodes = function() {
			clearTimeout(timer);
			if (d3.event.defaultPrevented) return;
			if (toggle == 0) {
				//-- Reduce the opacity of all but the neighbouring nodes
				d = d3.select(this).node().__data__;
				groupNodes.style("opacity", function(o) {
					return neighboring(d, o) | neighboring(o, d) ? 1 : 0.1;
				});
				path.style("opacity", function(o) {
					return d.index == o.source.index | d.index == o.target.index ? 1 : 0.1;
				});
				//-- Reduce the opacity
				toggle = 1;
			} else {
				//--Put them back to opacity=1
				groupNodes.style("opacity", 1);
				path.style("opacity", 1);
				toggle = 0;
			}
		}

		// -- search node function
		var optArray = [];

		for(var i = 0; i < this.nodes.length; i++) {

			optArray.push(this.nodes[i].cName, this.nodes[i].x, this.nodes[i].y);
		}
		$('body').on('click','#searchnode',function(e) {
			e.stopImmediatePropagation();
			searchNode();
			$('#search').focus();
		});
		optArray = optArray.sort();
		function searchNode() {
			var selectedVal = $("#search").val(),getX,getY;
			if (selectedVal == null || selectedVal == "" || selectedVal == 'undefined') {
				
				Ext.Msg.show({
					title: 'Topology',
					msg: 'Please enter component name',
					icon: 'iconInformation',
					buttons: Ext.Msg.OK
				});
			return;
		}
			var node = d3.select('svg.svgparentTag').selectAll(".g_node");
			var result = [];
			optArray.filter(function(_item){
				return _item.toString().toLowerCase().indexOf(selectedVal) >-1;
			}).forEach(function(_item,i) {
				result.push( _item );
			});
			if(result.length === 0){
				//Ext.Msg.alert('Topology', 'No result found');
				Ext.Msg.show({
					title: 'Topology',
					msg: 'No data available for the current search!',
					icon: 'iconExclamation',
					buttons: Ext.Msg.OK
				});
			}
		   for (var t=0;t< result.length;t++ )
		   {
				
				if(result.length === 1){
				if (result[t] == null || result[t] == "" || result[t] == 'undefined') {
					return;
				}else{

					var selected = node.filter(function(d, i) {
					if (result[t] != null && result[t] == d.cName) {

						if(options.layoutAlign == 'center'){
							getX = d.x + movementX;
							getY = d.y + movementY;
							d3.select(this)
							.append("rect")
							.attr("class","highlitenode")
							.attr("rx", 5)
							.attr('ry',5)
							.attr('y',movementY-35)
							.attr('x',movementX-35)
							.attr('height',50)
							.attr('width',80)
							.style({"stroke":"#c8c8c8","stroke-width":"2px","fill":"none"})
							.transition()
							.duration(duration)
							.remove();
						
						}else{
							getX = d.x;
							getY = d.y;
							d3.select(this)
							.append("rect")
							.attr("class","highlitenode")
							.attr("rx", 5).attr('ry',5)
							.attr('y', movementY-35)
							.attr('x', movementX-35)
							.attr('height',50)
							.attr('width',80)
							.style({"stroke":"#c8c8c8","stroke-width":"2px","fill":"none"})
							.transition()
							.duration(5000)
							.remove();
						
						}
						
						
					}else{
						
					}
					return d.cName != result[t] && d.px && d.py;
					selected.style("opacity", "0");
				});

					d3.select('svg.svgparentTag')
					.select('.pitch')
					.transition()
					.duration(2000)
					.call(options.zoomObj.scale(1.5).translate([(-parseInt(getX + movementX)*1.5 + options.width/2), (-parseInt(getY + movementY)*1.5 + options.height/2)]).event);
			   }
		   }else{

					var selected = node.filter(function(d, i) {
						if (result[t] != null && result[t] == d.cName) {
							if(options.layoutAlign == 'center'){
								d3.select(this)
								.append("rect")
								.attr("class","highlitenode")
								.attr("rx",5)
								.attr('ry',5)
								.attr('y',movementY-35)
								.attr('x',movementX-35)
								.attr('height',50)
								.attr('width',80)
								.style({"stroke":"#c8c8c8","stroke-width":"2px","fill":"none"})
								.transition()
								.duration(5000)
								.remove();

							}else{
							
								d3.select(this)
								.append("rect")
								.attr("class","highlitenode")
								.attr("rx",5)
								.attr('ry',5)
								.attr('y',movementY-35)
								.attr('x',movementX-35)
								.attr('height',50)
								.attr('width',80)
								.style({"stroke":"#c8c8c8","stroke-width":"2px","fill":"none"})
								.transition()
								.duration(5000)
								.remove();
							
							}

							
							getX = d.x;
							getY = d.y;
						}
						return d.cName != result[t] && d.px && d.py;
						selected.style("opacity", "0");
				});
				
						 d3.select('svg.svgparentTag')
						.select('.pitch')
						.transition()
						.duration(2000)
						.call(options.zoomObj.scale(options.default_zoom)
						.translate([options.margin.left,options.margin.top]).event);
		   }
				
				 
				 
				 $('html,body').animate({ scrollTop: $('.svgparentTag').offset().top - ( $(window).height() - options.height ) / 2  }, 200);
				// $(document).animate({ scrollTop: $('.svgparentTag').offset().top - ( $(window).height() - options.height ) / 2  }, 200);


				var link = d3.select('svg.svgparentTag').selectAll(".link")
				link.style("opacity", "0");
				d3.selectAll(".g_node, .link, .changeColor").transition().duration(2000).style("opacity", 1);
			}
		}
		


   
		$(window).keyup(function(event){
			if(event.keyCode == 13){
				$('#searchnode').trigger('click');
				return false;
			}
		});

		$("#searchnode").mousedown(function() {
			mousedownsearch = true;
		});
		
		 var drag = force
				.drag()
				.on("drag", dragged)
				.on("dragstart", dragStart)
				.on("dragend", dragEnd);

		//Force drag event
		var selectedItem,selectedItemX,selectedItemY ;
		function dragStart(d) {

			d3.event.sourceEvent.stopPropagation();
			d3.select(this).classed("fixed", d.fixed = true);
			if(d3.select(".tooltip")){
				d3.select(".tooltip").remove();
			}
			d3.select(this).style('cursor','move');
			
			
		}
		function dragged(d){

			 if(d3.select(".tooltip")){
				d3.select(".tooltip").remove();
			}
			
			selectedItem = d3.transform(d3.select(this).attr("transform"));
			
			var bbox = d3.select(this).node().getBBox(),
			bbox_width = bbox.width * scaleZ - 10,
			bbox_height = bbox.height * scaleZ - 10;
			force.drag().origin(function() {
							t = selectedItem.translate;
							return {x: t[0], y: t[1]};
						}).on("drag.force", function() {
							d3.select(this).attr("transform", "translate(" + d3.event.dx  + "," + d3.event.dy  + ")");
						});
			if(d3.event.sourceEvent.pageX <= bbox_width || d3.event.sourceEvent.pageX >= options.width + options.margin.left + options.margin.right - bbox_width  || d3.event.sourceEvent.pageY <= bbox_height || d3.event.sourceEvent.pageY >= options.height + options.margin.top + options.margin.bottom - bbox_height){

				force.stop();
				
			}else{
					d.px += d3.event.dx;
					d.py += d3.event.dy;
					d.x += d3.event.dx;
					d.y += d3.event.dy;
					force.resume();
			}
			
					force.tick();
		}
		function dragEnd(d) {

			try
			{
				moveEnd(d); //user defind method in JSP files
			}
			catch (e)
			{
				//console.log(e);
			}
			d3.select(this).style('cursor','pointer');
			force.tick();
			force.resume();
			

		}
		

		var path = d3.select('.pitch').append("svg:g").selectAll("path.marker")
			.data(force.links())
			.enter()
			.append("svg:path")
			.attr("class", "link")
			.attr("stroke-dasharray","0")
			.attr("stroke-linecap", "round")
			.style("stroke-width", function(d) {
				return 1;
			})
			.attr("transform", function(d) {
				return "translate(" + movementX + "," + movementY + ")";
			});

		path.filter(function(d) {
			return d.arrow == true;
		}).attr("marker-mid", function(d) {
			return "url(#BLUE)"
		})

		// -- draggable
		if (options.draggable) {
		   

			var groupNodes = d3.select('.pitch')
				.selectAll('g.g_node')
				.data(this.nodes)
				.enter()
				.append('g')
				.classed('g_node', true).attr("transform", function(d) {
					return "translate(" + movementX + "," + movementY + ")";
				}).call(drag);
			
		} else {

			var groupNodes = d3.select('.pitch')
				.selectAll('g.g_node')
				.data(this.nodes)
				.enter()
				.append('g')
				.classed('g_node', true).attr("transform", function(d) {
					return "translate(" + movementX + "," + movementY + ")";
				});

		}
		
		var patchx = groupNodes.append('svg:circle')
						.attr('class', 'node_patch_x')
						.attr('r', 20)
						.attr('fill',function(){
							var color  = graph.rootJson.paper.skin == "Dark" ? "#434343" :"#ffffff"; //default	
							return color;

						})
						.attr("transform", function(d) {
							return "translate(" + (movementX+5) + "," +( movementY-5) + ")";
						});
			var patch = groupNodes.append('svg:circle')
						.attr('class', 'node_patch')
						.attr('r', 30)
						.attr('fill',function(){
							var color  = graph.rootJson.paper.skin == "Dark" ? "#434343" :"#ffffff"; //default	
							return color;

						})
						.attr('stroke',function(){
							var color  = graph.rootJson.paper.skin == "Dark" ? "#434343" :"#ffffff"; //default
							return color;	
						})
						.attr("transform", function(d) {
							return "translate(" + (movementX+5) + "," +( movementY-5) + ")";
						}).style('display','none').style("opacity", 0);
			var patch2 = groupNodes.append('svg:circle')
						.attr('class', 'node_patch')
						.attr('r', 25)
						.attr('fill',function(){
							var color  = graph.rootJson.paper.skin == "Dark" ? "#434343" :"#ffffff"; //default	
							return color;

						})
						.attr('stroke',function(){
							var color  = graph.rootJson.paper.skin == "Dark" ? "#434343" :"#ffffff"; //default
							return color;	
						})
						.attr("transform", function(d) {
							return "translate(" + (movementX+5) + "," +( movementY-5) + ")";
						}).style('display','none').style("opacity", 0);

		
		var serverIcons = groupNodes
			.append('svg:image')
			.attr('class', 'serverimg')
			.attr('height', 48)
			.attr('width', 48)
			.attr("xlink:href", function(d) {
				return d.cImage_url
			}).attr("transform", function(d) {
				return "translate(" + (movementX - 20) + "," +( movementY -30) + ")";
			}); //Here you move the nodes;
		var clickedOnce = false;
		//isMenuEnable
		var DELAY = 500,clicks = 0,click_timer = null;	
		serverIcons.on('click',function(d){
					var that= d;
					var pX = d3.event.pageX;
					var pY = d3.event.pageY;
					clicks++;
					click_timer = setTimeout(function(){
						if(clicks ===1){
							if( options.isMenuEnable == "true"){
								showExtMenu(that,pX +5,pY+5)
							}
						}else if(clicks ===2){
							
						}
					clearTimeout(click_timer);
					clicks =0;
					},DELAY);
					
					
				}).on('dblclick',connectedNodes);

		serverIcons.filter(function(d) {

			return d.linktoLayermodel;
		}).on('click', function(d) {
			if (d3.event.defaultPrevented) return;
			if (timer) clearTimeout(timer);
			timer = setTimeout(function() {
				
				window.parent.location = d.linktoLayermodel;
			}, 250);

		   
		});
		serverIcons.on('dblclick', connectedNodes);
		
		/*groupNodes.append("title").text(function(d) {
			return d.cName;
		});*/
	
	
		//Here you move the nodes;
var groupText = groupNodes.append('g').attr('class','groupText');	
var texts = groupText.append("text").attr("class", "componentname").each(function (d) {
	var compName = d.cName.split(" ");
	var compType = "";
	if(d.cType != undefined)
	{
		compType += d.cType;
	}
	var typeArr = compType.split("\n");
	if(typeArr.length > 1)
	{
		if (compName != undefined) {
			for (i = 0; i < compName.length; i++) {
				d3.select(this).append("tspan")
					//.text(compName[i])
					.text(function(d) {
						return textTrim(compName[i],20);
					})
					.attr("dy", i ? "1.2em" : 18)
					.attr("x", 0)
					.attr("text-anchor", "middle")
					.attr('data-qtip',function(d,i){
						return d.cName;
					})
					.attr("class", "tspan" + i);
			}
		}
	}
	else
	{
		if (compName != undefined) {
			for (i = 0; i < compName.length; i++) {
			d3.select(this).append("tspan")
				//.text(compName[i])
				.text(function(d) {
					return textTrim(compName[i],20);
				})
				.attr("dy", i ? "1.2em" : 7)
				.attr("x", 0)
				.attr("text-anchor", "middle")
				.attr('data-qtip',function(d,i){
					return d.cName;
				})
				.attr("class", "tspan" + i);
			}
		}
	}
	}).attr("transform", function(d) {
				return "translate(" + movementX + "," + (movementY + 40) + ")";
			});//.style('filter', 'url(#textBg)');
	   
		/*var userTextStroke = textStroke.filter(function(d) {
			return d.cName === 'User'
		}).attr('class', 'userNode').style('display','none');*/

		var userText = texts.filter(function(d) {
			return d.cName === 'User'
		}).attr('class', 'userNode').style('display','none');//.style('filter', 'url(#textBg)');

		/*var componentTypeStroke = groupNodes.append("text").attr("class", "componenttype_stroke").attr("text-anchor", "middle").each(function(d) {
				var compType = "";
				if(d.cType != undefined)
				{
					compType += d.cType;
				}
				var compTypeArr = compType.split("\n");
				for(var k=0; k<compTypeArr.length; k++)
				{
					d3.select(this).append("tspan")
					.text(compTypeArr[k])
					.attr("dy", k ? "1.2em" : 4)
					.attr("x", 0)
					.attr("text-anchor", "middle")
				}
			}).attr("transform", function(d) {
			return "translate(" + movementX + "," + (movementY +30) + ")";
		});*/

		function textTrim(string, maxLength) {
			if (!string) return string;
			if (maxLength < 1) return string;
			if (string.length <= maxLength) return string;
			if (maxLength == 1) return string.substring(0,1) + '...';

			var midpoint = Math.ceil(string.length / 2);
			var toremove = string.length - maxLength;
			var lstrip = Math.ceil(toremove/2);
			var rstrip = toremove - lstrip;
			return string.substring(0, midpoint-lstrip) + '...' 
			+ string.substring(midpoint+rstrip);
		}

		var componentType = groupNodes.append("text")
			.attr("class", "componenttype")
			.attr("text-anchor", "middle")
			.text(function(d) {
                //return d.cType;
				/*var onloadSliderValue = $(".slider").slider("value");
				if (0.500 > onloadSliderValue) 
				{
                    d3.selectAll('text').transition().style("opacity", 0);
					Ext.defer(function(){
						d3.selectAll('.textbg').transition().style("opacity", 0);
					},200)
                } 
				else 
				{
					if(onloadSliderValue > 1.5)
					{
						//d3.selectAll('.componenttype').style('font-family','Roboto-Regular')
						//d3.selectAll('.componenttype').style('font-weight','100')
						//d3.selectAll('.componenttype').style('text-shadow','0px 0px 0px')
						//d3.selectAll('.componentname').style('font-family','Roboto-Regular')
						//d3.selectAll('.componentname').style('font-weight','100')
						//d3.selectAll('.componenttype').style('font-size','10')
						//d3.selectAll('.componentname').style('font-size','9')
					}
					else
					{
						//d3.selectAll('.componenttype').style('font-family','Roboto-Regular')
						//d3.selectAll('.componenttype').style('font-weight','100')
						//d3.selectAll('.componenttype').style('text-shadow','0px 0px 0px')
						//d3.selectAll('.componentname').style('font-family','Roboto-Regular')
						//d3.selectAll('.componentname').style('font-weight','100')
						//d3.selectAll('.componenttype').style('font-size','11')
						//d3.selectAll('.componentname').style('font-size','10')
					}
                    d3.selectAll('text').transition().style("opacity", 1);
					Ext.defer(function(){
						d3.selectAll('.textbg').transition().style("opacity", 1);
					},200)
                }*/
                //return textTrim(d.cType, 18);
            })
			.each(function(d) {
				var compType = "";
				if(d.cType != undefined)
				{
					compType += d.cType;
				}
				var compTypeArr = compType.split("\n");
				for(var k=0; k<compTypeArr.length; k++)
				{
					d3.select(this).append("tspan")
					.text(function(d) {
						return textTrim(compTypeArr[k],18);
					})
					.attr("dy", k ? "1.2em" : 4)
					.attr("x", 0)
					.attr("text-anchor", "middle")
					.attr('data-qtip',function(d,i){
						return d.cType;
					})
				}
			}).attr("transform", function(d) {
			return "translate(" + movementX + "," + (movementY +30) + ")";
		});//.style('filter', 'url(#textBg)');;


	//labels R-Recent, D-Discovered and  U-Unmanage
	var stateImages = groupNodes.append("image")
		.attr("class", "stateIcon")
		.attr("xlink:href", function(d) {
			return d.cStateImage_url
		})
		.attr("width", 16).attr("height", 16).attr("transform", function(d) {
			return "translate(" + (movement + 20) + "," + -5 + ")";
		});

	var RECENTcon = groupNodes.filter(function(d){
			return d.RECENT != null || d.RECENT == "undefined";
		}).append("image")
		.attr("class", "MANAGEDIcon")
		.attr("xlink:href", function(d) {
			return d.RECENT
		})
		.attr("width", 16).attr("height", 16).attr("transform", function(d) {
			
			return "translate(" + (movementX + 15) + "," + (movementY -35) + ")";//recent

		});

	var UNMANAGEDIcon = groupNodes.filter(function(d){
			return d.UNMANAGE != null || d.UNMANAGE == "undefined";
		}).append("image")
		.attr("class", "UNMANAGEDIcon")
		.attr("xlink:href", function(d) {
			return d.UNMANAGE
		})
		.attr("width", 16).attr("height", 16).attr("transform", function(d) {
		  return "translate(" + (movementX - 25) + "," + (movementY -5) + ")"; //unmanaged
		});
	var NEWIcon =  groupNodes.filter(function(d){
			return d.NEW != null || d.NEW == "undefined";
		}).append("image")
		.attr("class", "NEWIcon")
		.attr("xlink:href", function(d) {
			return d.NEW
		})
		.attr("width", 16).attr("height", 16).attr("transform", function(d) {
			   return "translate(" + (movementX - 15) + "," + (movementY - 35)  + ")"; //New
		});

	//animate();
	//highlighting with rectangle box -------------
		var rect = groupNodes.filter(function(d){
			if( d.isHighlighted == true ){
						
							d3.select(this)
							.append("rect")
							.attr("class","highlitenode")
							.attr("rx", 5).attr('ry',5)
							.attr('y',movementY-35)
							.attr('x',movementX-35)
							.attr('height',60)
							.attr('width',90)
							.style({"stroke":"#150517","stroke-width":"2px","fill":"none"})
							.transition()
							.duration(5000)
							.remove();
			} 
		});
	//----------------------------
// -- Tick function
	force.on("tick", function(e) {
		if(options.collideLayout){
		groupNodes.each(collide(0.4));
		
		}

		groupNodes.on('mouseover', function(d) {
			
				path.style({'stroke-width': function(l) {
						if (d === l.source || d === l.target){
							return 1.5;
						}
						else{
							return 1;
						}
					},'stroke':function(l){
					if (d === l.source || d === l.target){
							return "#909090";
						}
						else{
							return "#909090";
						}
					}});
				path.attr('class',function(l){
				if (d === l.source || d === l.target){
						return "changeColor";
					}
					else{
						return "defalutArrow";
					}
				},true);

				 d3.selectAll('.changeColor').filter(function(d) {
						return d.arrow == true;
					}).attr("marker-mid", "url(#BLACK)");
				/*d3.select(this).select('.node_patch')
					.attr('fill',function(){
						var color  = graph.rootJson.paper.skin == "Dark" ? "#49565e" :"#e7f6fd"; //default	
						return color;
					});*/
			d3.select(this).selectAll('.node_patch').each(function(d,i){
						if(i ==0){
							d3.select(this).transition().duration(300).attr('fill',function(){
								var color  = graph.rootJson.paper.skin == "Dark" ? "#474c4f" :"#e7f6fd"; //default	
								return color;
							}).style('display','block').style("opacity", 1);
						}else{
							d3.select(this).transition().duration(300).attr('fill',function(){
								var color  = graph.rootJson.paper.skin == "Dark" ? "#4e575c" :"#d1edf8"; //default	
								return color;
							}).style('display','block').style("opacity", 1);
						}
					});
			}).on('mouseout', function() {
				//d3.select(this).select('.patch').attr("filter", null).style({'fill-opacity':'0.9','fill':null});
				d3.select(".tooltip").remove();
				path.style('stroke-width', 1);
				path.style('stroke', '#909090');
				 d3.selectAll('.changeColor').filter(function(d) {
						return d.arrow == true;
					}).attr("marker-mid", "url(#BLUE)");
					d3.select(this).selectAll('.node_patch').transition().duration(300)
						.attr('fill',function(){
							var color  = graph.rootJson.paper.skin == "Dark" ? "#434343" :"#ffffff"; //default	
							return color;
	
						}).style('display','none').style("opacity", 0);
					
			});
			
			path.each(function() {
				this.parentNode.insertBefore(this, this);
			}); //IE 
			
			groupNodes.attr("transform", function(d) {
				//Here i create a node radius so it doesnt go offscreen
				/*var nodeRadius = 60;

				//here I do checks to see if it goes offscreen
				if (d.x <= nodeRadius - movementX) { //have to take movement away as you have moved the nodes/links previously
					d.x = nodeRadius - movementX;
				}
				if (d.y <= nodeRadius) {
					d.y = nodeRadius;
				}
				if (d.x > options.width - nodeRadius - movementX) {
					d.x = options.width - nodeRadius - movementX;
				}
				if (d.y > options.height - nodeRadius) {
					d.y = options.height - nodeRadius;
				}*/
				return "translate(" + d.x + "," + d.y + ")";

			}).attr('data-qtip',function(d,i){
				//return d.cType+"</br>"+d.cName;
				if(d.cType != undefined && d.cType != null && d.cName != undefined && d.cType != null && d.cType != 'user')
					return d.cType+"</br>"+d.cName;
			});

		   
			path.attr("d", function(d) {
				var dx = d.target.x - d.source.x,
					dy = d.target.y - d.source.y,
					dr = Math.sqrt(dx * dx + dy * dy)/4,
					mLx = d.source.x + dx/2,
					mLy = d.source.y + dy/2,
					mAx = d.source.x + dx,
					mAy = d.source.y + dy;
					  if (d.source.x === d.target.x) {
						//dr = Math.sqrt(dx * dx + dy * dy) / 1.8;
								var sweep = 1;
									if (d.source.y > d.target.y) {
										sweep = 0;

									}

						  return "M" +
										d.source.x + "," + d.source.y +
										"A" + dr + "," + dr +
										" 0, 0" + sweep + " " +
										d.target.x + "," + d.target.y;
				
				  }
				   return [
					  "M",d.source.x,d.source.y,
					   "L",mLx,mLy,
					   "L",d.target.x,d.target.y
					   
					  ].join(" ");
				
			  });
			userText.style({
				'display': 'none'
			});
		//d3plus.textwrap().container(d3.select(".g_node")).draw();
		});
			
			var componentnametext = document.querySelectorAll(".componentname");
			var componenttypetext = document.querySelectorAll(".componenttype");
			var color  = graph.rootJson.paper.skin == "Dark" ? "#444444" :"#ffffff";
			for (var i = 0; i < componenttypetext.length; i++) {
					createSVGTextBg(componenttypetext[i],color);
			}
			  for (var i = 0; i < componentnametext.length; i++) {
				 createSVGTextBg(componentnametext[i],color);
			}

			var padding = 150, // separation between circles
			radius=2,
			that = this;
			function collide(alpha) {
			  var quadtree = d3.geom.quadtree(that.nodes);
			 
			  return function(d) {
				var rb = 2*radius + padding,
					nx1 = d.x - rb,
					nx2 = d.x + rb,
					ny1 = d.y - rb,
					ny2 = d.y + rb;
				quadtree.visit(function(quad, x1, y1, x2, y2) {
				  if (quad.point && (quad.point !== d)) {
					var x = d.x - quad.point.x,
						y = d.y - quad.point.y,
						l = Math.sqrt(x * x + y * y);
					  if (l < rb) {
					  l = (l - rb) / l * alpha;
					  d.x -= x *= l;
					  d.y -= y *= l;
					  quad.point.x += x;
					  quad.point.y += y;
					}
				  }
				  return x1 > nx2 || x2 < nx1 || y1 > ny2 || y2 < ny1;
				});
			  };
			}

	});

}

$.fn.reusableSVG = function() {

	// -- glow while drag

	var defs = d3.select('svg.svgparentTag').append("defs");
	defs.append("filter")
	.attr("id","blur_patch")
	.attr("x","-20")
	.attr("y","-40")
	.attr("width","60")
	.attr("height","60")
	.append("feGaussianBlur")
	.attr("in","SourceGraphic")
	.attr("stdDeviation","15").append("feOffset")
	.attr("dx","2").attr("dy","2").append("feComponentTransfer").append("feFuncA")
	.attr("type","linear").attr("slope","0.2")
	.append("feMerge").append("feMergeNode").attr("in","SourceGraphic")
	.attr("type","linear").attr("slope","0.2");

	



	d3.select('svg.svgparentTag')
            .selectAll("marker")
            .data([{
                "name": "BLACK",
                "color": "#908e8f"
            }, {
                "name": "BLUE",
                "color": "#908e8f"
            }])
            .enter().append("svg:marker")
            .attr("id", function(d) {
                return d.name
            })
            .attr("fill", function(d) {
                return d.color;
            })
            .attr("viewBox", "0 -5 10 10")
			.attr("markerWidth", 6)
			.attr('markerUnits','userSpaceOnUse')
            .attr("refX", 0)
            .attr("refY", 0)
            .attr("markerHeight", 6)
            .attr("orient", "auto")
            .append("svg:path")
            .attr("d", "M0,-5L10,0L0,5");
    }

$.fn.renderSvg = function(options) {

	var options = $.extend({}, settings, options);
	var dom = d3.select(options.renderTo);
	
	
	this.renderDiagram(options);
	//-- header
	if(options.fromPage != null){
		header = d3.select(options.renderTo).append("div").attr('class','header');
		header.html("<div class='Theader'><div>"+options.fromPage+":</div><div class='t_titlefont'><div style='float:left' class='"+options.segmentStateCls+"'></div><div class='t_titlefont' style='float:left;margin:3px'>"+options.segmentName+"</div><div style='clear:both'></div></div></div>");
	}
	svg = d3.select(options.renderTo)
		.append('svg')
		.attr("viewBox", "0 0 " + options.width + " " + options.height)
		.attr("preserveAspectRatio", "xMinYMin")
		.attr('class', 'svgparentTag')
		.attr("width", options.width + options.margin.left + options.margin.right)
		.attr("height", options.height + options.margin.top + options.margin.bottom)
		.append("g")
		.attr('class', 'pitch')
		.attr("transform", "translate(" + options.margin.left + "," + options.margin.top + ")");


	// -- glow while drag 
	this.reusableSVG();

	// -- pre Loading text 
	loading = svg.append("text").attr({
		x: options.width / 2,
		y: options.height / 2
	}).text(options.loadingText);



	if (options.zoom) {
		d3.select(options.renderTo).select('svg').remove();
	 
		 if(options.initialX == null || options.initialY == null){
			
			options.initialX =  options.width / 2;
			options.initialY =  options.height / 2;
			
		}
		var xz = d3.scale.linear()
			.domain([-options.width / 2, options.width / 2])
			.range([0, options.width]);

		var yz = d3.scale.linear()
			.domain([-options.height / 2, options.height / 2])
			.range([options.height, 0]);

		var hideText = function(value,scale){
			if (value > scale) {
				d3.selectAll('text').transition().style("opacity", 0);
				Ext.defer(function(){
					d3.selectAll('.textbg').transition().style("opacity", 0);
				},200)
			} else {
				if(scale > 1.5)
				{
					//d3.selectAll('.componenttype').style('font-family','Roboto-Regular')
					//d3.selectAll('.componenttype').style('font-weight','100')
					//d3.selectAll('.componenttype').style('text-shadow','0px 0px 0px')
					//d3.selectAll('.componentname').style('font-family','Roboto-Regular')
					//d3.selectAll('.componentname').style('font-weight','100')
					//d3.selectAll('.componenttype').style('font-size','10')
					//d3.selectAll('.componentname').style('font-size','9')
				}
				else
				{
					//d3.selectAll('.componenttype').style('font-family','Roboto-Regular')
					//d3.selectAll('.componenttype').style('font-weight','100')
					//d3.selectAll('.componenttype').style('text-shadow','0px 0px 0px')
					//d3.selectAll('.componentname').style('font-family','Roboto-Regular')
					//d3.selectAll('.componentname').style('font-weight','100')
					//d3.selectAll('.componenttype').style('font-size','11')
					//d3.selectAll('.componentname').style('font-size','10')
				}
				d3.selectAll('text').transition().style("opacity", 1);
				Ext.defer(function(){
					d3.selectAll('.textbg').transition().style("opacity", 1);
				},200)
			}
		}
	 
		$(document).mousedown(function(){
			   d3.select('.pitch').style("cursor", "url('/final/images/hand_drag.cur'),default");
			});
			$(document).mouseup(function(){
				d3.select('.pitch').style("cursor", "url('/final/images/hand_move.cur'),default");
			});

		// -- Zoom function 
		 var zoomFn = function() {
			translateZ = options.margin.left + "," + options.margin.top;
			scaleZ = d3.event.scale;
              svg.attr("transform", "translate("+d3.event.translate+ ") scale("+d3.event.scale +")");
                $(".slider").slider("value",d3.event.scale);
				//hideText(0.500,d3.event.scale);
		
			int_X = d3.event.translate[0];
			int_Y = d3.event.translate[1];
            };
		
		var zoomStartFn = function(){
			if(slider_tooltip){
			slider_tooltip.text(Math.round(scaleZ*100) + '%');
			slider_tooltip.show().delay(5000).fadeOut('slow');
				 
			}
		}

		
		if(zoomFn){
			
		 if (localStorage.getItem('svgScale') === null) {
				translateZ = options.initialX + "," + options.initialY;
				scaleZ = options.default_zoom;	
				
			}else{
				
				translateZ = JSON.parse(localStorage.getItem('svgScale')).transform;
				scaleZ = JSON.parse(localStorage.getItem( 'svgScale' )).scale;
				options.zoomObj.translate(translateZ).scale(scaleZ);
		}
		}

		var zoom = options.zoomObj
			//.x(xz)
			//.y(yz)
			.scaleExtent([options.min_zoom, options.max_zoom])
			.translate([options.initialX, options.initialY])
			//.center([options.width / 2, options.height / 2])
			.scale(scaleZ)
			.on("zoom", zoomFn).on("zoomstart",zoomStartFn)
			.size([options.width/2, options.height/2]);

	 
		var svg = d3.select(options.renderTo)
			.append('svg')
			.attr("viewBox", "0 0 " + options.width + " " + options.height)
			.attr("preserveAspectRatio", "xMidYMid meet")
			.attr('class', 'svgparentTag')
			.attr("width", options.width + options.margin.left + options.margin.right)
			.attr("height", options.height + options.margin.top + options.margin.bottom)
			.call(zoom).on("dblclick.zoom", null)
			.append("g")
			.attr("width", options.width + options.margin.left + options.margin.right)
			.attr("height", options.height + options.margin.top + options.margin.bottom)
			.attr('class', 'pitch')
			.attr("transform", "translate("+translateZ+")scale("+scaleZ+")")
			.on("dblclick.zoom", null).on("click.zoom", null);



		// -- glow while drag 
		this.reusableSVG();

		var rect = svg.append("rect")
			.attr("class",'zoomrect')
			.attr("width",  (options.width + options.margin.left + options.margin.right) *scaleZ)
			.attr("height", (options.height + options.margin.top + options.margin.bottom)*scaleZ)
			.attr("transform", "translate(" + [-1 * (scaleZ * options.initialX), -1 * (scaleZ * options.initialY)] + ")" + " scale(" + scaleZ + ")")
			.style("fill", "none")
			.style("pointer-events", "all");

		function interpolateZoom (translate, scale) {
			var self = this;
			return d3.transition().duration(duration).tween("zoom", function () {
				var iTranslate = d3.interpolate(zoom.translate(), translate),
					iScale = d3.interpolate(zoom.scale(), scale);

				
				return function (t) {
					 zoom
					.scale(iScale(t))
					.translate(iTranslate(t))
					.event(svg);

					
				};
			});
		}

		// -- zoom buttons [+][-] method
		function zoomClick() {
			var clicked = d3.event.target,
				direction = 1,
				factor = 0.2,
				target_zoom = ((options.max_zoom - options.min_zoom) / 100),
				center = [options.width / 2, options.height / 2],
				extent = zoom.scaleExtent([options.min_zoom,options.max_zoom]),
				translate = zoom.translate(),
				translate0 = [],
				l = [],
				view = {x: translate[0], y: translate[1], k: zoom.scale()};

			d3.event.preventDefault();
			direction = (this.id === 'zoom_in') ? 1 : -1;
			target_zoom = zoom.scale() * (1 + factor * direction);

			if (target_zoom < extent[0] || target_zoom > extent[1]) { return false; }

			translate0 = [(center[0] - view.x) / view.k, (center[1] - view.y) / view.k];
			view.k = target_zoom;
			l = [translate0[0] * view.k + view.x, translate0[1] * view.k + view.y];

			view.x += center[0] - l[0];
			view.y += center[1] - l[1];
				
			if(view.k <= options.min_zoom  || view.k >= options.max_zoom ){
				$(".slider").slider("value",view.k);
				return false
			}else{
					
					interpolateZoom([view.x, view.y], view.k);	
				}
			
			
		}
		
		
			// -- slider function
			function slideFn(value) {
				var scale = zoom.scale();
				var extent = zoom.scaleExtent();
				var newScale =  value;
				if (extent[0] <= newScale && newScale <= extent[1]) {
					
				  var t = zoom.translate();
				  var c = [options.width / 2, options.height / 2];
					zoom.scale(newScale)
					.translate([c[0] + (t[0] - c[0]) / scale * newScale,c[1] + (t[1] - c[1]) / scale * newScale])
					.event(svg);

				}
			  };

		function graphBounds() {
			var x = Number.POSITIVE_INFINITY,
			X = Number.NEGATIVE_INFINITY,
			y = Number.POSITIVE_INFINITY,
			Y = Number.NEGATIVE_INFINITY;
			//	item = d3.select(".g_node").node().getBBox();
			d3.select('.pitch').selectAll(".g_node").each(function(v) {
				getX = v.x - movementX;
				getY = v.y - movementY;
				//console.log(d3.select(this).node().getBBox())
				var	item = d3.select(this).node().getBBox();
				x = Math.min(x, (v.x + movementX) - 120 / 2);
				X = Math.max(X, (v.x + movementX) + 120 / 2);
				y = Math.min(y, (v.y + movementY) - 120 / 2);
				Y = Math.max(Y, (v.y + movementY) + 120 / 2);
			});
			return {
				x: x,
				X: X,
				y: y,
				Y: Y
			};
		}
		
		  function zoomToFit() {
			var b = graphBounds();
			var w = b.X - b.x, h = b.Y - b.y;
			var cw = $(window).width() + options.margin.left + options.margin.right, 
				ch = $(window).height() + options.margin.top + options.margin.bottom;
			var s = Math.min(cw / w , ch / h);
			var tx = (-b.x * s + (cw / s - w) * s / 2) ,
			ty = (-b.y * s + (ch / s - h) * s / 2);
				
			
			if(options.layoutAlign == 'center' && options.enableFitLayout){
				//alert("center+auto");
				/*var cw = $(window).width() + options.margin.left + options.margin.right, 
				ch = $(window).height() + options.margin.top + options.margin.bottom;
				s = Math.min(cw / w , ch / h);
				tx = (-b.x - movementX * s + (cw / s - w) * s / 2) ,
				ty = (-b.y - movementY * s + (ch / s - h) * s / 2);*/
				var cw = ($(window).width() + options.margin.left + options.margin.right), 
				ch = $(window).height() + options.margin.top + options.margin.bottom;
				s = d3.min([Math.min(cw / w , ch / h),options.max_zoom]);
				tx = (-b.x * s + (cw / s - w) * s / 2) ,
				ty = (-b.y  * s + (ch / s - h) * s / 2);
				

			}else if(options.layoutAlign == 'left' && options.enableFitLayout){
				//alert('left+auto');
				cw = options.width + options.margin.left + options.margin.right, 
				ch = options.height + options.margin.top + options.margin.bottom;
				s = Math.min(cw / w , ch / h);
				tx = (-b.x * s + (cw / s - w) * s / 2),
				ty = (-b.y - movementY  * s + (ch / s - h) * s / 2);
				
				//tx = tx - HX - LX ;
			   
			}else if(options.layoutAlign == 'left' && options.enableFitLayout == false){
				//alert('left+manual')
				cw = $(window).width() + options.margin.left + options.margin.right, 
				ch = $(window).height() + options.margin.top + options.margin.bottom;
				s = Math.min(cw / w , ch / h);
				tx = (-b.x * s + (cw / s - w) * s / 2),
				ty = (-b.y - movementY * s + (ch / s - h) * s / 2);
				
				
			}
			 
			//d3.select('svg.svgparentTag').select('.pitch').transition().duration(2000).call(options.zoomObj.scale(s)
			//.translate([parseInt(tx),parseInt(ty)]).event);
			interpolateZoom([parseInt(tx), parseInt(ty)], s);
			 $(".slider").slider("value",scaleZ);
			 //hideText(0.500,s); // -- show text
			 //-- checking for scroll in window
			 if ($(document).height() > $(window).height()) {
				 $('html,body').animate({scrollTop:0},200);
			}
			
			 delete tx,ty,s,cw,ch;
		}
	   var slider =  dom.append('div').attr('class', 'slider');
	   var slider_buttons =  dom.append('div').attr('class', 'slider_buttons');
	   var zoomslider_in = slider_buttons.append('button').attr('id','zoom_in').attr('class','button_zoom zoomInbt zoomtop');
	   var zoomslider_out = slider_buttons.append('button').attr('id','zoom_out').attr('class','button_zoom zoomOutbt zoombottom');

		
	$(options.renderTo).append('<div class="ui-widget searchbox"><div class="toposearch" title="Search"><div id="searchcom" style="display:none;position:absolute;left:-50px"><input id="search"><button title="Search" type="button"  id="searchnode">&nbsp;</button></div></div><button id="fit" title="Fit">&nbsp;</button></div>');
		// -- Zoom in and zoom out
		d3.selectAll('button.button_zoom').on('click', zoomClick);
		
		/*if(options.enableFitLayout){
		  $('#fit').show();
		}else{
		  $('#fit').hide();
		}*/
		$('#fit').hide();

		$('body').on('click','.toposearch',function() {
			$("#searchcom").animate({
				left: "-145px",
			}, 100, function() {
				$('#search').focus();

			}).show();
		});
		$('#search').blur(function() {
			if (mousedownsearch) {
				mousedownsearch = false;
			} else {
				$("#searchcom").animate({
					left: "-50px",
				}, 100).hide();
			}
		});
		
		$('body').on('click','#fit',function() {
			zoomToFit();
		});
		// -- checking for auto layout and fit the zoom
		if(options.enableFitLayout == true){
		 var timeout =  window.setTimeout(function(){$( "#fit" ).click()},500);
		 delete timeout;

		}
		
		slider_tooltip = $('<span id="tooltip" class="slider_tooltip" />').css({
			position: 'absolute',
			top: -5,
			left: 20
		}).hide();
		
		$(".slider").slider({
			animate: "slow",
		   // range: "min",
			orientation: "vertical",
			min: options.min_zoom,
			max: options.max_zoom,
			value: scaleZ,
			step: ((options.max_zoom - options.min_zoom) / 100),
			slide: function(event, ui) {
				
				slider_tooltip.text(Math.round(ui.value*100) + '%');
				slideFn(ui.value);
				
			}
		}).find(".ui-slider-handle").append(slider_tooltip).hover(function() {
			slider_tooltip.text(Math.round(scaleZ*100) + '%');
			slider_tooltip.fadeIn('fast');
		}, function() {
			slider_tooltip.delay(5000).fadeOut('slow');
		});

	if(options.hideSlider){
		$(".slider, .slider_buttons").hide();
	}else{
		$(".slider, .slider_buttons").show();
		}

} else {
	console.log('false')
}
	$( window ).resize(function() {
		
			$('.ui-widget-content').css({'margin-top':$( window ).height() - 180,'margin-left':20});
			$('.slider_buttons').css({'margin-top':$( window ).height() - 190,'margin-left':20});
			
		  }).resize();
};
}(jQuery));