//var isDbValidated=false;
var restartManagerMask;
var reqParams;
Ext.define('eGDBCreation.controller.DbCreationController', {
	extend:'Ext.app.Controller',
	requires : ['eGDBCreation.view.DbServerSettings','eGDBCreation.view.oracleView','eGDBCreation.view.resultPanel','eGDBCreation.view.ManagerConfiguration','eGDBCreation.view.FormItems'],
	refs:[
		{selector:'main',ref:'main'},
		{selector:'dbserversettings',ref:'dbserversettings'},
		{selector:'oracleview',ref:'oracleview'},
		{selector:'resultpanel',ref:'resultpanel'},
		{selector:'ManagerConfiguration',ref:'ManagerConfiguration'},
		{selector:'formitems',ref:'formitems'}
	],
	init:function(){
		appCnt = this;
		this.control({
				'main button[id=createDB]':{
					'click':this.submitForm
				},
				'main button[id=clearDB]':{
					'click':this.clearForm
				},
				'main button[id=validatecon]':{
					'click':this.validateConnection
				},
				'resultpanel button[id=res_button]':{
					'click':this.backForm
				},
				'resultpanel radio[name=addlicense]':{
					'change': this.licenceUploadChange
				},
				'resultpanel button[action=fileUploadAction]':{
					'click': this.licenseUpload
				},
				'main tabpanel[id=dbCreationTab]':{
					'tabchange':this.clearForm
				},
				'ManagerConfiguration radio[id="smtpauthenticationno"]': {
					'change' : this.radSmtpChange
				},
				'ManagerConfiguration radio[id="mailauthenticationno"]': {
					'change' : this.radMailSetChange
				},
				'ManagerConfiguration button[id="validateBtn"]': {
					'click': this.validationForMailServers
				},
				'ManagerConfiguration radio[name="mgrmdl"]': {
					'change': this.managerModelChange
				}
			});
	},

    submitForm : function(){
      // alert(Ext.getCmp('hidden_dbfield').getValue());
	   var dbType=Ext.getCmp('hidden_dbfield').getValue();
	   var thisForm;
	   if(dbType=='mssql'){
			thisForm = this.getDbserversettings().getForm();
	   }else{
			thisForm = this.getOracleview().getForm();
	   }
	   if(this.validate(thisForm)){
	   var queryStr = new Array();

			 if(dbType=='mssql'){
				 //var isNtlmv=thisForm.findField('ntlmv').getValue().ntlmv2;
				 var isSslEnabled=thisForm.findField('ssl_enab').getValue().ssl_enable;
				 var isNewDb=thisForm.findField('create_newdb').getValue().db_sel;
				 var useInstances=thisForm.findField('namedinstances').getValue.useinstance;
				 if(!Ext.isEmpty(thisForm.findField('instanceid'))){
						var instanceId=thisForm.findField('instanceid').getValue().trim();
				 }
				 var ip=thisForm.findField('ip').getValue();
				 var port=thisForm.findField('port').getValue();
				 var dbName=thisForm.findField('dbname').getValue();
				 var mdbUserName=thisForm.findField('mdbusername').getValue();
				 var mdbPassword=thisForm.findField('mdbpassword').getValue();

				 var domain;
				 var dbaUserName;
				 var mdbUserName;
				 /* if(!Ext.isEmpty(thisForm.findField('dbausername').getValue())){
					 var temp = thisForm.findField('dbausername').getValue();
	
					if(temp.indexOf('\\')>0){
						 var res=temp.split('\\');
						 domain = res[0];
						 dbaUserName=res[1];
					 }
					 else{
						dbaUserName = temp;
						domain = 'none';
					 }
				 }
				 else if(!Ext.isEmpty(thisForm.findField('mdbusername').getValue())){
					 var temp = thisForm.findField('mdbusername').getValue();
					
					 if(temp.indexOf('\\')>0){
						 var res=temp.split('\\');
						 domain = res[0];
						 //mdbUserName=res[1];
						 mdbUserName=temp;
					 }
					 else{
						mdbUserName = temp;
						domain = 'none';
					 }
				 }*/
				
				 ///*****SubmitForm***SSSS**////
				 if(!Ext.isEmpty(thisForm.findField('dbausername').getValue())){

					 var temp = thisForm.findField('dbausername').getValue();
					 dbaUserName = temp;					 
				 }
				 else if(!Ext.isEmpty(thisForm.findField('mdbusername').getValue())){
					 
					 var temp = thisForm.findField('mdbusername').getValue();
					 mdbUserName = temp;
				 }

				 ///*****SubmitForm***EEEE**////
				 if(!Ext.isEmpty(thisForm.findField('mdbpassword'))){
					 var mdbPassword=thisForm.findField('mdbpassword').getValue();
				 }
				 if(!Ext.isEmpty(thisForm.findField('dbapassword'))){
					 var dbaPassword=thisForm.findField('dbapassword').getValue();
				 }

				 //////********SubmitForm***SSSS************/////

					 var isUserWindowsAuthentic='false';
					 var isAdminUserWindowsAuthentic='false';

					if(!Ext.isEmpty(thisForm.findField('windowsAuthentic_enab_User')))
					{
						isUserWindowsAuthentic=Ext.getCmp('windowsAuthentic_enab_User').getValue().windowsAuthentic_enable;

					}

					if(!Ext.isEmpty(thisForm.findField('windowsAuthentic_enab_AdminUser')))
					{
						 isAdminUserWindowsAuthentic=Ext.getCmp('windowsAuthentic_enab_AdminUser').getValue().windowsAuthentic_enable_AdminUser;
					}

					 var isNtlmv='false';
					 var isDBUserWindowsAuthentic='false';
					 var isAdminWindowsAuthentic='false';

					if(isUserWindowsAuthentic=='true' || isAdminUserWindowsAuthentic=='true')
					{
						if(!Ext.isEmpty(thisForm.findField('ntlmv')))
						{
							isNtlmv=thisForm.findField('ntlmv').getValue().ntlmv2;
						}

						if(isUserWindowsAuthentic=='true')
						{
							isDBUserWindowsAuthentic='true';
							if(!Ext.isEmpty(thisForm.findField('user_Domain')))
							{
								 var userDomainName = thisForm.findField('user_Domain').getValue();
								 domain = userDomainName;

								 ///////-------------Split-Starts-------------///////////////
								 if(!Ext.isEmpty(domain) && domain.indexOf(".")>0)
								 {
									 var splitedDomain=domain.split('.');
									 domain = splitedDomain[0];
								 }		
								 ///////-------------Split-Ends-------------//////////////////

								 mdbUserName = domain+'\\'+mdbUserName;
							}
						}

						if(isAdminUserWindowsAuthentic=='true')
						{
							isAdminWindowsAuthentic='true';
							if(!Ext.isEmpty(thisForm.findField('admin_User_Domain')))
							{
								 var adminUserDomainName = thisForm.findField('admin_User_Domain').getValue();
								 domain = adminUserDomainName;

								 ///////-------------Split-Starts-------------///////////////
								 if(!Ext.isEmpty(domain) && domain.indexOf(".")>0)
								 {
									 var splitedDomain=domain.split('.');
									 domain = splitedDomain[0];
								 }		
								 ///////-------------Split-Ends-------------//////////////////
							}
						}						
					}
					else
					{
						domain = 'none';
					}

					//////*******SubmitForm***EEEE***********/////


				 queryStr['dbType']=dbType;
				 queryStr['ip']=ip;
				 queryStr['port']=port;
				 queryStr['instanceId']=instanceId;
				 queryStr['dbName']=dbName;
				 queryStr['mdbUserName']=mdbUserName;
				 queryStr['mdbPassword']=mdbPassword;
				 queryStr['dbaUserName']=dbaUserName;
				 queryStr['dbaPassword']=dbaPassword;
				 queryStr['isNtlmv']=isNtlmv;
				 queryStr['isSslEnabled']=isSslEnabled;
				 queryStr['isNewDb']=isNewDb;
				 queryStr['useInstances']=useInstances;
				 queryStr['domain']=domain;
				 ////
				 queryStr['isDBUserWindowsAuthentic']=isDBUserWindowsAuthentic;
				 queryStr['isAdminWindowsAuthentic']=isAdminWindowsAuthentic;

				 ////
				 queryStr['action']='createDB';
			 }else{
				 var ip=thisForm.findField('ipOra').getValue();
				 var port=thisForm.findField('portOra').getValue();
				 var instanceId=thisForm.findField('instanceidOra').getValue();
				 var mdbUserName=thisForm.findField('mdbusernameOra').getValue();
				 var mdbPassword=thisForm.findField('mdbpasswordOra').getValue();
				 var tempTabSpace=thisForm.findField('temporarytabspaceOra').getValue();
				 var defaultTabSpace=thisForm.findField('defaulttabspaceOra').getValue();
				 var isNewDb=thisForm.findField('create_newdbOra').getValue().db_selOra;

				 var domain;
				 var dbaUserName;
				 var mdbUserName;
				  if(!Ext.isEmpty(thisForm.findField('dbausernameOra').getValue())){
					 var temp = thisForm.findField('dbausernameOra').getValue();
					 if(temp.indexOf('/')>0){
						 var res=temp.split('/');
						 domain = res[0];
						 dbaUserName=res[1];
					 }
					 else if(temp.indexOf('\\')>0){
						 var res=temp.split('\\');
						 domain = res[0];
						 dbaUserName=res[1];
					 }
					 else{
						dbaUserName = temp;
						domain = 'none';
					 }
				 }
				 else if(!Ext.isEmpty(thisForm.findField('mdbusernameOra').getValue())){
					 var temp = thisForm.findField('mdbusernameOra').getValue();
					 if(temp.indexOf('/')>0){
						 var res=temp.split('/');
						 domain = res[0];
						 mdbUserName=res[1];
					 }
					 else if(temp.indexOf('\\')>0){
						 var res=temp.split('\\');
						 domain = res[0];
						 mdbUserName=res[1];
					 }
					 else{
						mdbUserName = temp;
						domain = 'none';
					 }
				 }
				 if(!Ext.isEmpty(thisForm.findField('mdbpasswordOra'))){
					 var mdbPassword=thisForm.findField('mdbpasswordOra').getValue();
				 }
				 if(!Ext.isEmpty(thisForm.findField('dbapasswordOra'))){
					 var dbaPassword=thisForm.findField('dbapasswordOra').getValue();
				 }
				 queryStr['dbType']=dbType;
				 queryStr['ip']=ip;
				 queryStr['port']=port;
				 queryStr['instanceId']=instanceId;
				 queryStr['mdbUserName']=mdbUserName;
				 queryStr['mdbPassword']=mdbPassword;
				 queryStr['tempTabSpace']=tempTabSpace;
				 queryStr['defaultTabSpace']=defaultTabSpace;
				 queryStr['dbaUserName']=dbaUserName;
				 queryStr['dbaPassword']=dbaPassword;
				 queryStr['domain']=domain;
				 queryStr['dbName']="";
				 queryStr['isNtlmv']="";
				 queryStr['isSslEnabled']="";
				 queryStr['isNewDb']=isNewDb;
				 queryStr['action']='createDB';
			}
			var qStr = Ext.urlEncode(queryStr);
			//if(isDbValidated){
				var dbCreationMask = new Ext.LoadMask(Ext.get(this.getMain().id), {
					cls :'windowModal',
					msg: "Database creation is in progress, please wait..."
				});
			 dbCreationMask.show();
			 if(dbType=='mssql'){
				 Ext.Ajax.request({
					url : '/final/servlet/com.eg.EgDbCreationController',
					method : 'POST',
					params : qStr,
					timeout : ajaxTimeOutFrequency,
					scope : this,
					success : function(response) {
						//isDbValidated=false;
						Ext.destroy(dbCreationMask);
						var jsonData=Ext.decode(response.responseText);
						var dbCreationStatus = jsonData['dbStatus'];
						if(dbCreationStatus!=null && dbCreationStatus=="dbCreated"){
							queryStr['dbStatus']=dbCreationStatus;
							this.userCreation(queryStr);
							Ext.getCmp('dbIconSuccess').show();
							Ext.getCmp('dbIconFailed').hide();
						}
						else{
							Ext.getCmp('dbIconSuccess').hide();
							Ext.getCmp('dbIconFailed').show();
							Ext.getCmp('mainContainer').hide();
							Ext.getCmp('resultContainer').show();
							Ext.get('usercreationresWrong').update('<div class="errorWhileInstallText">Error while creating the eG database.</div>');
							Ext.get('tabcreationresWrong').update('<div style="width:500px;text-align:center;margin-top: 0px;" class="dbfont_normal12">'+jsonData['eG Manager Configuration']+'</div>');
							Ext.getCmp('topResultHideWrong').show();
							Ext.getCmp('topResultHideRight').hide();
							Ext.getCmp('fileUploadForm').hide();
							Ext.getCmp('licenceMsg').hide();
							Ext.getCmp('fileUpladBotn').hide();
							Ext.getCmp('res_button').show();
							Ext.getCmp('upldLicence').hide();
						}
						
					},
					failure : function() {
						Ext.destroy(dbCreationMask);
						Ext.destroy(thisForm);
						alert("Database creation request timed out. please check "+mgrLogPath);
					}
				})
			 }
			else{
				Ext.destroy(dbCreationMask);
				this.userCreation(queryStr);
			}
		  /*}else{
              		var msg = Ext.MessageBox.show({
				title : 'Database creation',
				msg : '<div style="min-height:35px">Please validate the database server settings </br> before the DB creation</div>',
				modal:true,
				maskCls :'windowModal',
				buttons : Ext.MessageBox.OK,
				icon : Ext.MessageBox.WARNING
			});
			Ext.WindowManager.bringToFront(msg);
           	}*/
	   }
		Ext.destroy(thisForm);
	},
	userCreation : function(queryStr){
		var qStr = Ext.urlEncode(queryStr);
		var dbCreationMask = new Ext.LoadMask(Ext.get(this.getMain().id), {
					cls :'windowModal',
					msg: "Database user creation is in progress, please wait..."
				});
			 dbCreationMask.show();
			 Ext.Ajax.request({
				url : '/final/servlet/com.eg.EgDbCreationController',
				method : 'POST',
				params : qStr,
				timeout : ajaxTimeOutFrequency,
				scope : this,
				success : function(response) {
					Ext.destroy(dbCreationMask);
					var jsonData=Ext.decode(response.responseText);
					var dbCreationStatus = jsonData['dbStatus'];
					if(dbCreationStatus!=null && dbCreationStatus=="userCreated"){
						queryStr['dbStatus']=dbCreationStatus;
						this.TablesCreation(queryStr);
						Ext.getCmp('dbIconSuccess').show();
						Ext.getCmp('dbIconFailed').hide();
					}
					else{
						Ext.getCmp('dbIconSuccess').hide();
						Ext.getCmp('dbIconFailed').show();
						Ext.getCmp('mainContainer').hide();
						Ext.getCmp('resultContainer').show();
						Ext.get('usercreationresWrong').update('<div class="errorWhileInstallText">Error while creating the eG database user.</div>');
						Ext.get('tabcreationresWrong').update('<div style="width:500px;text-align:center;margin-top: 0px;" class="dbfont_normal12">'+jsonData['eG Manager Configuration']+'</div>');

						Ext.getCmp('topResultHideWrong').show();
						Ext.getCmp('topResultHideRight').hide();
						Ext.getCmp('fileUploadForm').hide();
						Ext.getCmp('licenceMsg').hide();
						Ext.getCmp('fileUpladBotn').hide();
						Ext.getCmp('res_button').show();
						Ext.getCmp('upldLicence').hide();
					}
				},
				failure : function() {
					Ext.destroy(dbCreationMask);
					alert("Database user creation request timed out. please check "+mgrLogPath);
				}
			})
	},
	TablesCreation : function(queryStr){
		var qStr = Ext.urlEncode(queryStr);
		var dbCreationMask = new Ext.LoadMask(Ext.get(this.getMain().id), {
			cls :'windowModal',
			msg: "Tables creation is in progress, please wait..."
		});
	    dbCreationMask.show();
		Ext.Ajax.request({
			url : '/final/servlet/com.eg.EgDbCreationController',
			method : 'POST',
			params : qStr,
			timeout : ajaxTimeOutFrequency,
			scope : this,
			success : function(response) {
				Ext.destroy(dbCreationMask);
				var jsonData=Ext.decode(response.responseText);
				var dbCreationStatus = jsonData['dbStatus'];

				if(dbCreationStatus!=null && dbCreationStatus=="tablesCreated"){
					queryStr['dbStatus']=dbCreationStatus;
					qStr = Ext.urlEncode(queryStr);
					this.setupConfigure(qStr);
					Ext.getCmp('dbIconSuccess').show();
					Ext.getCmp('dbIconFailed').hide();
				}
				else{
					Ext.getCmp('dbIconSuccess').hide();
					Ext.getCmp('dbIconFailed').show();
					Ext.getCmp('mainContainer').hide();
               				Ext.getCmp('resultContainer').show();
					Ext.get('usercreationresWrong').update('<div class="errorWhileInstallText">Error while creating the eG database user.</div>');
					Ext.get('tabcreationresWrong').update('<div style="width:500px;text-align:center;margin-top: 0px;" class="dbfont_normal12">'+jsonData['eG Manager Configuration']+'</div>');
					Ext.getCmp('topResultHideWrong').show();
					Ext.getCmp('topResultHideRight').hide();
					Ext.getCmp('fileUploadForm').hide();
					Ext.getCmp('licenceMsg').hide();
					Ext.getCmp('fileUpladBotn').hide();
					Ext.getCmp('res_button').show();
					Ext.getCmp('upldLicence').hide();
				}
			},
			failure : function() {
				Ext.destroy(dbCreationMask);
				alert("Database tables creation request timed out. please check "+mgrLogPath);
			}
		})
	},
	setupConfigure : function(qStr){
		var dbCreationMask = new Ext.LoadMask(Ext.get(this.getMain().id), {
			cls :'windowModal',
			msg: "Configuring tomcat is in progress, please wait..."
		});
		dbCreationMask.show();
		Ext.Ajax.request({
			url : '/final/servlet/com.eg.EgDbCreationController',
			method : 'POST',
			params : qStr,
			timeout : ajaxTimeOutFrequency,
			scope : this,
			success : function(response) {
				Ext.destroy(dbCreationMask);
				var jsonData=Ext.decode(response.responseText);
				Ext.getCmp('mainContainer').hide();		       
				if(jsonData['tablesCreated'].indexOf('dbIconTick') > -1 && jsonData['eG Manager Configuration'].indexOf('dbIconTick') > -1){
					if(!Ext.isEmpty(jsonData['isEvalEdition']) && jsonData['isEvalEdition'] == 'true'){
						Ext.Msg.show({
							title : 'DB Partition Confirmation',
							msg : "The Database Partitioning feature is available for an eG database configured on a Microsoft SQL server. Do you wish to enable this feature for the eG database? If yes, then please remember that henceforth, you should explicitly turn on this feature every time you upgrade the Microsoft SQL server that is hosting the eG database.",
							icon : 'iconConfirmation',
							buttons : Ext.Msg.YESNO,
							width : 800,
							height : 500,
							fn : function(buttonText) {
								if (buttonText == "no") {
									var dbType=Ext.getCmp('hidden_dbfield').getValue();
									Ext.Ajax.request({
										url : '/final/servlet/com.eg.EgDbCreationController?disablePartition=true',
										method : 'POST',
										timeout : ajaxTimeOutFrequency,
										scope : this,
										failure : function(response) {
											console.log('Timeout : Issue in updating partition flag');
										}
									});
								}
							}
						});
					}
					Ext.getCmp('mgrConfigContainer').show();
				}else{
					Ext.getCmp('resultContainer').show();
					Ext.getCmp('dbIconSuccess').hide();
					Ext.getCmp('dbIconFailed').show();
					Ext.get('usercreationresWrong').update('<div class="errorWhileInstallText">Error while creating the eG database tables.</div>');
					Ext.get('tabcreationresWrong').update('<div style="width:500px;text-align:center;margin-top: 0px;" class="dbfont_normal12">'+jsonData['eG Manager Configuration']+'</div>');
					Ext.getCmp('topResultHideWrong').show();
					Ext.getCmp('topResultHideRight').hide();
					Ext.getCmp('fileUploadForm').hide();
					Ext.getCmp('licenceMsg').hide();
					Ext.getCmp('fileUpladBotn').hide();
					Ext.getCmp('res_button').show();
					Ext.getCmp('upldLicence').hide();
				}
			},
			failure : function() {
				Ext.destroy(dbCreationMask);
				alert("Database tables creation request timed out. please check "+mgrLogPath);
			}
		})
	},
	backForm : function(){
		Ext.getCmp('resultContainer').hide();
        Ext.getCmp('mainContainer').show();
		//Ext.getCmp('createDB').setDisabled(true);
	},
	clearForm : function(){
		//Ext.getCmp('createDB').setDisabled(true);

		if(Ext.getCmp('hidden_dbfield').getValue()=='mssql'){
			var thisForm = this.getDbserversettings().getForm();
			thisForm.findField('ip').setValue();
			thisForm.findField('namedinstances').setValue({useinstance:'no'});
			thisForm.findField('port').setValue(1433);
			thisForm.findField('ntlmv').setValue({ntlmv2:'false'});
			thisForm.findField('ssl_enab').setValue({ssl_enable:'false'});
			thisForm.findField('create_newdb').setValue({db_sel:'yes'});
			if(!Ext.isEmpty(thisForm.findField('instanceid'))){
				thisForm.findField('instanceid').setValue();
			}
			thisForm.findField('dbname').setValue();
			thisForm.findField('mdbusername').setValue();
			thisForm.findField('mdbpassword').setValue();
			thisForm.findField('confmdbpassword').setValue();
			if(!Ext.isEmpty(thisForm.findField('dbausername'))){
				thisForm.findField('dbausername').setValue();
				thisForm.findField('dbapassword').setValue();
				thisForm.findField('confdbapassword').setValue();
			}
			//////
			if(!Ext.isEmpty(thisForm.findField('user_Domain'))){
				thisForm.findField('user_Domain').setValue();
			}

			if(!Ext.isEmpty(thisForm.findField('admin_User_Domain'))){
				thisForm.findField('admin_User_Domain').setValue();
			}
			/////
		}else{
			var thisForm = this.getOracleview().getForm();
			thisForm.findField('ipOra').setValue();
			thisForm.findField('portOra').setValue(1521);
			thisForm.findField('instanceidOra').setValue();
			thisForm.findField('mdbusernameOra').setValue();
			thisForm.findField('mdbpasswordOra').setValue();
			thisForm.findField('confmdbpasswordOra').setValue();
			thisForm.findField('temporarytabspaceOra').setValue('temp');
			thisForm.findField('defaulttabspaceOra').setValue('users');
			thisForm.findField('create_newdbOra').setValue({db_selOra:'yes'});
			thisForm.findField('dbausernameOra').setValue();
			thisForm.findField('dbapasswordOra').setValue();
			thisForm.findField('confdbapasswordOra').setValue();
		}
  },
  clearSelDbFields : function(){
      var thisForm = this.getDbserversettings().getForm();
		if(!Ext.isEmpty(thisForm.findField('instanceid'))){
		var instanceId=thisForm.findField('instanceid').setValue();
		}
		var dbName=thisForm.findField('dbname').setValue();
		var mdbUserName=thisForm.findField('mdbusername').setValue();
		var mdbPassword=thisForm.findField('mdbpassword').setValue();
		if(!Ext.isEmpty(thisForm.findField('temporarytabspace'))){
		 var tempTabSpace=thisForm.findField('temporarytabspace').setValue();
		 var defaultTabSpace=thisForm.findField('defaulttabspace').setValue();
		}
		if(!Ext.isEmpty(thisForm.findField('dbausername'))){
		 var dbaUserName=thisForm.findField('dbausername').setValue();
		 var dbaPassword=thisForm.findField('dbapassword').setValue();
		}
  },
  validate : function(thisForm){
        var msg;
		if(this.hostValidation() && this.portValidation()){
			if(Ext.getCmp('hidden_dbfield').getValue()=='mssql'){
				var dbName = thisForm.findField('dbname').getValue().trim();
				var mdbUser = thisForm.findField('mdbusername').getValue().trim();
				var mdbPwd=thisForm.findField('mdbpassword').getValue().trim();
				var mdbCpwd=thisForm.findField('confmdbpassword').getValue().trim();
				var dbaUser = thisForm.findField('dbausername').getValue().trim();
				var dbaPwd = thisForm.findField('dbapassword').getValue().trim();
				var dbaCpwd = thisForm.findField('confdbapassword').getValue().trim();
				var instance = thisForm.findField('instanceid').getValue().trim();
				var specialChar = "`~!@#$%^&()+={}[]|;<>,?'";
				var isNtlmvEnabled = thisForm.findField('ntlmv').getValue().ntlmv2;
				
				if(Ext.isEmpty(instance) && (Ext.getCmp('namedinstances').getValue().useinstance=='yes')){
					msg = "Please enter "+thisForm.findField('instanceid').getFieldLabel();
					thisForm.findField('instanceid').focus(false, 100);
				}
				else if(!Ext.isEmpty(instance) && (Ext.getCmp('namedinstances').getValue().useinstance=='yes') && !checkspecial(instance,"`~!@#$%^&*()+={}[]|\\;\"\'<>,?")){
					msg = "Please enter valid "+thisForm.findField('instanceid').getFieldLabel()+"; Special characters are not allowed.";
					thisForm.findField('instanceid').focus(false, 100);
				}
				else if(Ext.isEmpty(dbName)){
					msg = "Please enter "+Ext.getCmp('dbname').getFieldLabel();
					thisForm.findField('dbname').focus(false, 100);
				}
				else if(!Ext.isEmpty(dbName) && checkSqlDBName(dbName) != 'success' ){

					var blckChar = checkSqlDBName(dbName);
					if(blckChar.length > 2)
					{
						msg = "Special characters "+ blckChar + " are not allowed. Please enter valid "+Ext.getCmp('dbname').getFieldLabel();
					}
					else{
						msg = "Special character "+ blckChar + " is not allowed. Please enter valid "+Ext.getCmp('dbname').getFieldLabel();
					}
					//msg = "Please enter valid "+Ext.getCmp('dbname').getFieldLabel()+"; Special characters are not allowed.";
					thisForm.findField('dbname').focus(false, 100);
				}
				else if(!Ext.isEmpty(dbName) && dbName.length > 128){
					msg="Please enter valid "+Ext.getCmp('dbname').getFieldLabel()+". Maximum 128 characters are supported.";
					thisForm.findField('dbname').focus(false, 100);
				}
				else if(Ext.isEmpty(mdbUser)){
					msg = "Please enter eG database username";
					thisForm.findField('mdbusername').focus(false, 100);
				}
				else if(!Ext.isEmpty(mdbUser) && checkSqlUserName(mdbUser) != 'success'){

						var blckChar = checkSqlUserName(mdbUser);
						if(blckChar.length > 2)
						{
							msg = "Special characters "+ blckChar + " are not allowed. Please enter valid eG database username";
						}
						else{
							msg = "Special character "+ blckChar + " is not allowed. Please enter valid eG database username";
						}
					//msg="Please enter valid eG database username; Special characters are not allowed.";
					thisForm.findField('mdbusername').focus(false, 100);
				}
				else if(!Ext.isEmpty(mdbUser) && mdbUser.length >128){
					msg = "Please enter valid eG database username. Maximum 128 characters are supported.";
					thisForm.findField('mdbusername').focus(false, 100);
				}
				else if(Ext.isEmpty(mdbPwd)){
					msg = "Please enter eG database password";
					thisForm.findField('mdbpassword').focus(false, 100);
				}
				else if(!Ext.isEmpty(mdbPwd) && checkSqlPass(mdbPwd) != 'success'){

					var blckChar =  checkSqlPass(mdbPwd);
					if(blckChar.length > 2)
					{
						msg = "Special characters "+ blckChar + " are not allowed. Please enter valid eG database password";
					}
					else{
						msg = "Special character "+ blckChar + " is not allowed. Please enter valid eG database password";
					}
					//msg="Please enter valid eG database password; Special characters are not allowed.";
					thisForm.findField('mdbpassword').focus(false, 100);
				}
				else if(Ext.isEmpty(mdbCpwd)){
					msg = "Please re-type eG database password";
					thisForm.findField('confmdbpassword').focus(false, 100);
				}
				else if(!Ext.isEmpty(mdbCpwd) && checkSqlPass(mdbCpwd) != 'success'){

					var blckChar =  checkSqlPass(mdbCpwd);
					if(blckChar.length > 2)
					{
						msg = "Special characters "+ blckChar + " are not allowed. Please re-type valid eG database password";
					}
					else{
						msg = "Special character "+ blckChar + " is not allowed. Please re-type valid eG database password";
					}
					//msg="Please enter valid eG database password; Special characters are not allowed.";
					thisForm.findField('confmdbpassword').focus(false, 100);
				}
				else if(Ext.isEmpty(dbaUser) && (thisForm.findField('create_newdb').getValue().db_sel=='yes')){
					msg = "Please enter DBA username";
					thisForm.findField('dbausername').focus(false, 100);
				}
				else if(Ext.isEmpty(dbaPwd) && (thisForm.findField('create_newdb').getValue().db_sel=='yes')){
					msg = "Please enter DBA password";
					thisForm.findField('dbapassword').focus(false, 100);
				}
				else if(Ext.isEmpty(dbaCpwd) && (thisForm.findField('create_newdb').getValue().db_sel=='yes')){
					msg = "Please re-type DBA password";
					thisForm.findField('confdbapassword').focus(false, 100);
				}
				else if(!Ext.isEmpty(dbaUser) && checkSqlUserName(dbaUser) !=  'success'){

						var blckChar = checkSqlUserName(dbaUser);
						if(blckChar.length > 2)
						{
							msg = "Special characters "+ blckChar + " are not allowed. Please enter valid DBA username";
						}
						else{
							msg = "Special character "+ blckChar + " is not allowed. Please enter valid DBA username";
						}
					//msg = "Please enter valid DBA username; Special characters are not allowed.";
					thisForm.findField('dbausername').focus(false, 100);
				}
				else if(!Ext.isEmpty(dbaUser) && dbaUser.length >128){
					msg = "Please enter valid DBA username; Max 128 characters supported.";
					thisForm.findField('dbausername').focus(false, 100);
				}
				else if(!Ext.isEmpty(dbaPwd) && checkSqlPass(dbaPwd) != 'success'){

					var blckChar =  checkSqlPass(dbaPwd);
					if(blckChar.length > 2)
					{
						msg = "Special characters "+ blckChar + " are not allowed. Please enter valid DBA password";
					}
					else{
						msg = "Special character "+ blckChar + " is not allowed. Please enter valid DBA password";
					}
					thisForm.findField('dbapassword').focus(false, 100);
				}
				else if(!Ext.isEmpty(dbaCpwd) && checkSqlPass(dbaCpwd) != 'success'){

					var blckChar =  checkSqlPass(dbaCpwd);
					if(blckChar.length > 2)
					{
						msg = "Special characters "+ blckChar + " are not allowed. Please re-type valid DBA password";
					}
					else{
						msg = "Special character "+ blckChar + " is not allowed. Please re-type valid DBA password";
					}
					thisForm.findField('confdbapassword').focus(false, 100);
				}
				else if(mdbPwd != mdbCpwd){
					msg = "eG database password mismatch";
					thisForm.findField('confmdbpassword').focus(false, 100);
				}
				else if(dbaPwd != dbaCpwd){
					msg = "DBA password mismatch";
					thisForm.findField('confdbapassword').focus(false, 100);
				}
				else {
					if(!Ext.isEmpty(mdbUser)){
						if(mdbUser == "sa"){
						   msg = "Default user accounts are not allowed for eG database user";
						   thisForm.findField('mdbusername').focus(false, 100);
						}
					}
				}

				/////*****VVVVVV*****//////SSSS//////

				var isUserWindowsAuthentic='';
				var isAdminUserWindowsAuthentic='';
				
				var userDomainName = '';
				var adminUserDomainName = '';

				if(!Ext.isEmpty(thisForm.findField('windowsAuthentic_enab_User')))
				{
					isUserWindowsAuthentic=Ext.getCmp('windowsAuthentic_enab_User').getValue().windowsAuthentic_enable;

					if(isUserWindowsAuthentic=='true')
					{
						if(!Ext.isEmpty(thisForm.findField('user_Domain')))
						{
							 userDomainName = thisForm.findField('user_Domain').getValue();
							 if(Ext.isEmpty(userDomainName)){
								msg = "Please enter eG Database Domain Name";
								thisForm.findField('user_Domain').focus(false, 100);
							}
						}
					}
				}

				if(!Ext.isEmpty(thisForm.findField('windowsAuthentic_enab_AdminUser')))
				{
					isAdminUserWindowsAuthentic=Ext.getCmp('windowsAuthentic_enab_AdminUser').getValue().windowsAuthentic_enable_AdminUser;

					if(isAdminUserWindowsAuthentic=='true')
					{
						if(!Ext.isEmpty(thisForm.findField('admin_User_Domain')))
						{
							 adminUserDomainName = thisForm.findField('admin_User_Domain').getValue();
							 if(Ext.isEmpty(adminUserDomainName)){
								msg = "Please enter eG Database Domain Name";
								thisForm.findField('admin_User_Domain').focus(false, 100);
							}
						}
					}	
				}

				if(isUserWindowsAuthentic=='true' && isAdminUserWindowsAuthentic=='true')
				{
					if(userDomainName != adminUserDomainName){
						msg = "Domain name mismatch";
						thisForm.findField('admin_User_Domain').focus(false, 100);
					}
				}
				///////*****VVVVVV****///EEEE///////////


				if(!Ext.isEmpty(msg)){
					 var msg = Ext.MessageBox.show({
							title : 'Database creation',
							msg : '<div style="min-height:25px">' + msg + '</div>',
							modal:true,
							maskCls :'windowModal',
							buttons : Ext.MessageBox.OK,
							icon : Ext.MessageBox.WARNING
						});
				Ext.WindowManager.bringToFront(msg);
				return false;
			}
			return true;
		}else{
				var mdbUser = thisForm.findField('mdbusernameOra').getValue().trim();
				var mdbPwd = thisForm.findField('mdbpasswordOra').getValue().trim();
				var mdbCpwd = thisForm.findField('confmdbpasswordOra').getValue().trim();
				var dbaUser = thisForm.findField('dbausernameOra').getValue().trim();
				var dbaPwd = thisForm.findField('dbapasswordOra').getValue().trim();
				var dbaCpwd =thisForm.findField('confdbapasswordOra').getValue().trim();
				var instance = thisForm.findField('instanceidOra').getValue().trim();
				var tempTabSpace = thisForm.findField('temporarytabspaceOra').getValue().trim();
				var defaultTabSpace = thisForm.findField('defaulttabspaceOra').getValue().trim();
				var specialChar = "`~!@#$%^&*()+={}[]|;<>,?'";
				if(Ext.isEmpty(instance)){
					msg = "Please enter Oracle Database Instance name / Service name";
					thisForm.findField('instanceidOra').focus(false, 100);
				}
				else if(!Ext.isEmpty(instance) && !checkspecial(instance,specialChar+'\"\\')){
					msg = "Please enter valid oracle database instance name / service name. Special characters are not allowed.";
					thisForm.findField('instanceidOra').focus(false, 100);
				}
				else if(Ext.isEmpty(mdbUser)){
					msg="Please enter eG database username";
					thisForm.findField('mdbusernameOra').focus(false, 100);
				}
				else if(!Ext.isEmpty(mdbUser) && checkOracleUserName(mdbUser)  != 'success' ){
					
					var blckChar = checkOracleUserName(mdbUser) ;
					if(blckChar.length > 2)
					{
						msg = "Special characters "+ blckChar + " are not allowed. Please enter valid eG database username";
					}
					else{
						msg = "Special character "+ blckChar + " is not allowed. Please enter valid eG database username";
					}
					//msg="Please enter eG database username; Special characters are not allowed.";
					thisForm.findField('dbausernameOra').focus(false, 100);
				}
				else if(!Ext.isEmpty(mdbUser) && mdbUser.length > 30){
					msg = "Please enter valid eG database username. Maximum 30 characters are supported.";
					thisForm.findField('dbausernameOra').focus(false, 100);
				}
				else if(Ext.isEmpty(mdbPwd)){
					msg="Please enter eG database password";
					thisForm.findField('mdbpasswordOra').focus(false, 100);
				}
				else if(!Ext.isEmpty(mdbPwd) && checkOraclePass(mdbPwd) != 'success'){

					var blckChar =  checkOraclePass(mdbPwd);
					if(blckChar.length > 2)
					{
						msg = "Special characters "+ blckChar + " are not allowed. Please enter valid eG database password";
					}
					else{
						msg = "Special character "+ blckChar + " is not allowed. Please enter valid eG database password";
					}
					//msg="Please enter valid eG database password; Special characters are not allowed.";
					thisForm.findField('mdbpasswordOra').focus(false, 100);
				}
				else if(Ext.isEmpty(mdbCpwd)){
					msg="Please  re-type eG database password";
					thisForm.findField('confmdbpasswordOra').focus(false, 100);
				}
				else if(!Ext.isEmpty(mdbCpwd) && checkOraclePass(mdbCpwd) != 'success'){

					var blckChar =  checkOraclePass(mdbCpwd);
					if(blckChar.length > 2)
					{
						msg = "Special characters "+ blckChar + " are not allowed. Please re-type valid eG database password";
					}
					else{
						msg = "Special character "+ blckChar + " is not allowed. Please re-type valid eG database password";
					}
					//msg="Please enter valid eG database password; Special characters are not allowed.";
					thisForm.findField('confmdbpasswordOra').focus(false, 100);
				}
				else if(Ext.isEmpty(tempTabSpace)){
					msg="Please enter "+thisForm.findField('temporarytabspaceOra').getFieldLabel();
					thisForm.findField('temporarytabspaceOra').focus(false, 100);
				}
				else if(!Ext.isEmpty(tempTabSpace) && !checkspecial(tempTabSpace,specialChar+'\"\\')){
					msg="Please enter valid "+thisForm.findField('temporarytabspaceOra').getFieldLabel()+". Special characters are not allowed.";
					thisForm.findField('temporarytabspaceOra').focus(false, 100);
				}
				else if(Ext.isEmpty(defaultTabSpace)){
					msg="Please enter "+thisForm.findField('defaulttabspaceOra').getFieldLabel();
					thisForm.findField('defaulttabspaceOra').focus(false, 100);
				}
				else if(!Ext.isEmpty(defaultTabSpace) && !checkspecial(defaultTabSpace,specialChar+'\"\\')){
					msg="Please enter valid "+thisForm.findField('defaulttabspaceOra').getFieldLabel()+". Special characters are not allowed.";
					thisForm.findField('defaulttabspaceOra').focus(false, 100);
				}
				else if(Ext.isEmpty(dbaUser) && (thisForm.findField('create_newdbOra').getValue().db_selOra=='yes')){
					msg="Please enter DBA username";
					thisForm.findField('dbausernameOra').focus(false, 100);
				}
				else if(!Ext.isEmpty(dbaUser) && checkOracleUserName(dbaUser) != 'success' ){
				
					var blckChar = checkOracleUserName(dbaUser) ;
					if(blckChar.length > 2)
					{
						msg = "Special characters "+ blckChar + " are not allowed. Please enter valid DBA username";
					}
					else{
						msg = "Special character "+ blckChar + " is not allowed. Please enter valid DBA username";
					}
					//msg="Please enter DBA username; Special characters are not allowed.";
					thisForm.findField('dbausernameOra').focus(false, 100);
				}
				else if(!Ext.isEmpty(dbaUser) && dbaUser.length > 30){
					msg = "Please enter valid DBA username. Maximum 30 characters are supported.";
					thisForm.findField('dbausernameOra').focus(false, 100);
				}
				else if(Ext.isEmpty(dbaPwd) && (thisForm.findField('create_newdbOra').getValue().db_selOra=='yes')){
					msg="Please enter DBA password";
					thisForm.findField('dbapasswordOra').focus(false, 100);
				}
				else if(Ext.isEmpty(dbaCpwd) && (thisForm.findField('create_newdbOra').getValue().db_selOra=='yes')){
					msg="Please  re-type DBA password";
					thisForm.findField('confdbapasswordOra').focus(false, 100);
				}
				else if(!Ext.isEmpty(dbaPwd) && checkOraclePass(dbaPwd) != 'success'){

					var blckChar =  checkOraclePass(dbaPwd);
					if(blckChar.length > 2)
					{
						msg = "Special characters "+ blckChar + " are not allowed. Please enter valid DBA password";
					}
					else{
						msg = "Special character "+ blckChar + " is not allowed. Please enter valid DBA password";
					}
					thisForm.findField('dbapasswordOra').focus(false, 100);
				}
				else if(!Ext.isEmpty(dbaCpwd) && checkOraclePass(dbaCpwd) != 'success'){

					var blckChar =  checkOraclePass(dbaCpwd);
					if(blckChar.length > 2)
					{
						msg = "Special characters "+ blckChar + " are not allowed. Please re-type valid DBA password";
					}
					else{
						msg = "Special character "+ blckChar + " is not allowed. Please re-type valid DBA password";
					}
					thisForm.findField('confdbapasswordOra').focus(false, 100);
				}
				else if(mdbPwd != mdbCpwd){
					 msg="eG "+managerSmLabel+" database password mismatch";
					 thisForm.findField('confmdbpasswordOra').focus(false, 100);
				}
				else if(dbaPwd != dbaCpwd){
					 msg="DBA password mismatch";
					 thisForm.findField('confdbapasswordOra').focus(false, 100);
				}
				else {
					if(!Ext.isEmpty(mdbUser)){
						if(mdbUser=="system" || mdbUser == "sys"){
						   msg="Default user accounts are not allowed for eG database user";
						   thisForm.findField('mdbusernameOra').focus(false, 100);
						}
					}
				}
				if(!Ext.isEmpty(msg)){
					 var msg = Ext.MessageBox.show({
							title : 'Database creation',
							msg : '<div style="min-height:35px">' + msg + '</div>',
							modal:true,
							maskCls :'windowModal',
							buttons : Ext.MessageBox.OK,
							icon : Ext.MessageBox.WARNING
						});
				Ext.WindowManager.bringToFront(msg);
				return false;
			}
			return true;
		}
	 }else{return false;}
  },
  validateConnection : function(){
  	   var me =this;
       	   var dbType=Ext.getCmp('hidden_dbfield').getValue();
	   var thisForm;
	   if(dbType=='mssql'){
			thisForm = this.getDbserversettings().getForm();
	   }else{
			thisForm = this.getOracleview().getForm();
	   }
	   if(this.validate(thisForm)){
			 var queryStr = new Array();
			 if(dbType=='mssql'){
					 var newDb = Ext.getCmp('create_newdb').getValue().db_sel;
					 var dbName = thisForm.findField('dbname').getValue();
					
					 //var isNtlmv=thisForm.findField('ntlmv').getValue().ntlmv2;
					 var isSslEnabled=thisForm.findField('ssl_enab').getValue().ssl_enable;
					 var useInstances=thisForm.findField('namedinstances').getValue.useinstance;
					 if(!Ext.isEmpty(thisForm.findField('instanceid'))){
						var instanceId=thisForm.findField('instanceid').getValue();
					 }
					 var ip=thisForm.findField('ip').getValue();
					 var port=thisForm.findField('port').getValue();

					 var domain;
					 var dbaUserName;
					 var mdbUserName;

					 /*if(!Ext.isEmpty(thisForm.findField('dbausername').getValue())){
						 var temp = thisForm.findField('dbausername').getValue();

						if(temp.indexOf('\\')>0){
							 var res=temp.split('\\');
							 domain = res[0];
							 dbaUserName=res[1];
						 }
						 else{
							dbaUserName = temp;
							domain = 'none';
						 }
					 }
					 if(!Ext.isEmpty(thisForm.findField('mdbusername').getValue())){
						 var temp = thisForm.findField('mdbusername').getValue();
						
						 if(temp.indexOf('\\')>0){
							 var res=temp.split('\\');
							 domain = res[0];
							 //mdbUserName=res[1];
							 mdbUserName=temp;
						 }
						 else{
							mdbUserName = temp;
							domain = 'none';
						 }
					 }*/


					 /////****VALIDCL*****/SSSS///

					if(!Ext.isEmpty(thisForm.findField('dbausername').getValue())){
						var temp = thisForm.findField('dbausername').getValue();
						dbaUserName = temp;
					 }
					 if(!Ext.isEmpty(thisForm.findField('mdbusername').getValue())){
						 var temp = thisForm.findField('mdbusername').getValue();
						 mdbUserName = temp;
					 }


					 /////*****VALIDCL****/EEEE///
					 if(!Ext.isEmpty(thisForm.findField('mdbpassword'))){
						 var mdbPassword=thisForm.findField('mdbpassword').getValue();
					 }
					 if(!Ext.isEmpty(thisForm.findField('dbapassword'))){
						 var dbaPassword=thisForm.findField('dbapassword').getValue();
					 }

					//////********VALIDCL**********//SSSS///

					 var isUserWindowsAuthentic='false';
					 var isAdminUserWindowsAuthentic='false';

					if(!Ext.isEmpty(thisForm.findField('windowsAuthentic_enab_User')))
					{
						isUserWindowsAuthentic=Ext.getCmp('windowsAuthentic_enab_User').getValue().windowsAuthentic_enable;

					}

					if(!Ext.isEmpty(thisForm.findField('windowsAuthentic_enab_AdminUser')))
					{
						 isAdminUserWindowsAuthentic=Ext.getCmp('windowsAuthentic_enab_AdminUser').getValue().windowsAuthentic_enable_AdminUser;
					}

					 var isNtlmv='false';
					 var isDBUserWindowsAuthentic='false';
					 var isAdminWindowsAuthentic='false';

					if(isUserWindowsAuthentic=='true' || isAdminUserWindowsAuthentic=='true')
					{
						if(!Ext.isEmpty(thisForm.findField('ntlmv')))
						{
							isNtlmv=thisForm.findField('ntlmv').getValue().ntlmv2;
						}

						if(isUserWindowsAuthentic=='true')
						{
							isDBUserWindowsAuthentic='true';
							if(!Ext.isEmpty(thisForm.findField('user_Domain')))
							{
								 var userDomainName = thisForm.findField('user_Domain').getValue();
								 domain = userDomainName;
								 ///////-------------Split-Starts-------------///////////////
								 if(!Ext.isEmpty(domain) && domain.indexOf(".")>0)
								 {
									 var splitedDomain=domain.split('.');
									 domain = splitedDomain[0];
								 }		
								 ///////-------------Split-Ends-------------///////////////
								 mdbUserName = domain+'\\'+mdbUserName;
							}
						}

						if(isAdminUserWindowsAuthentic=='true')
						{
							isAdminWindowsAuthentic='true';
							if(!Ext.isEmpty(thisForm.findField('admin_User_Domain')))
							{
								 var adminUserDomainName = thisForm.findField('admin_User_Domain').getValue();
								 domain = adminUserDomainName;
								 ///////-------------Split-Starts-------------///////////////
								 if(!Ext.isEmpty(domain) && domain.indexOf(".")>0)
								 {
									 var splitedDomain=domain.split('.');
									 domain = splitedDomain[0];
								 }		
								 ///////-------------Split-Ends-------------///////////////
							}
						}						
					}
					else
					{
						domain = 'none';
					}

					//////*******VALIDCL***********//EEEE///

					 queryStr['dbType']=dbType;
					 queryStr['ip']=ip;
					 queryStr['port']=port;
					 queryStr['instanceId']=instanceId;
					 queryStr['dbaUserName']=dbaUserName;
					 queryStr['dbaPassword']=dbaPassword;
					 queryStr['mdbUserName']=mdbUserName;
					 queryStr['mdbPassword']=mdbPassword;
					 queryStr['isNtlmv']=isNtlmv;
					 queryStr['isSslEnabled']=isSslEnabled;
					 queryStr['domain']= domain;
					 queryStr['dbName']=dbName;
					 queryStr['isNewDb']=newDb;
					 ////
					 queryStr['isDBUserWindowsAuthentic']=isDBUserWindowsAuthentic;
					 queryStr['isAdminWindowsAuthentic']=isAdminWindowsAuthentic;

					 ////
					 queryStr['action']='validateDb';
			 }else{
					 var ip=thisForm.findField('ipOra').getValue();
					 var port=thisForm.findField('portOra').getValue();
					 var instanceId=thisForm.findField('instanceidOra').getValue();
					var isNewDb=thisForm.findField('create_newdbOra').getValue().db_selOra;
					 var domain;
					 var dbaUserName;
					 var mdbUserName;

					 if(!Ext.isEmpty(thisForm.findField('dbausernameOra').getValue())){
						 var temp = thisForm.findField('dbausernameOra').getValue();
						 if(temp.indexOf('/')>0){
							 var res=temp.split('/');
							 domain = res[0];
							 dbaUserName=res[1];
						 }
						 else if(temp.indexOf('\\')>0){
							 var res=temp.split('\\');
							 domain = res[0];
							 dbaUserName=res[1];
						 }
						 else{
							dbaUserName = temp;
							domain = 'none';
						 }
					 }
					 if(!Ext.isEmpty(thisForm.findField('mdbusernameOra').getValue())){
						 var temp = thisForm.findField('mdbusernameOra').getValue();
						 if(temp.indexOf('/')>0){
							 var res=temp.split('/');
							 domain = res[0];
							 mdbUserName=res[1];
						 }
						 else if(temp.indexOf('\\')>0){
							 var res=temp.split('\\');
							 domain = res[0];
							 mdbUserName=res[1];
						 }
						 else{
							mdbUserName = temp;
							domain = 'none';
						 }
					 }
					 if(!Ext.isEmpty(thisForm.findField('mdbpasswordOra'))){
						 var mdbPassword=thisForm.findField('mdbpasswordOra').getValue();
					 }
					 if(!Ext.isEmpty(thisForm.findField('dbapasswordOra'))){
						 var dbaPassword=thisForm.findField('dbapasswordOra').getValue();
					 }
					 queryStr['dbType']=dbType;
					 queryStr['ip']=ip;
					 queryStr['port']=port;
					 queryStr['instanceId']=instanceId;
					 queryStr['dbaUserName']=dbaUserName;
					 queryStr['dbaPassword']=dbaPassword;
					 queryStr['mdbUserName']=mdbUserName;
					 queryStr['mdbPassword']=mdbPassword;
					 queryStr['isNtlmv']=isNtlmv;
					 queryStr['isSslEnabled']=isSslEnabled;
					 queryStr['domain']= domain;
					  queryStr['isNewDb']=isNewDb;
					 queryStr['action']='validateDb';
			 }
			 var newUser=Ext.getCmp('create_newdbOra').getValue().db_selOra;
			 
			 var qStr = Ext.urlEncode(queryStr);
			 var dbValidationMask = new Ext.LoadMask(Ext.get(this.getMain().id), {
				cls:'windowModal',
				msg: "Validation in progress, please wait ..."
			 });
			 dbValidationMask.show();
			 Ext.Ajax.request({
				url : '/final/servlet/com.eg.EgDbCreationController',
				method : 'POST',
				params : qStr,
				timeout : 240000,
				scope : this,
				success : function(response) {
					Ext.destroy(dbValidationMask);
					var jsonData=Ext.decode(response.responseText);
					if(jsonData['msg']=='SQL settings have been validated successfully!' || jsonData['msg']=='Oracle settings have been validated successfully!'){
						//isDbValidated=true;
						//Ext.getCmp('createDB').setDisabled(false);
					}
					var msg='';
					if(jsonData['msg'].indexOf('eG Database username/password is incorrect or User does not Exists') > -1 ||
						jsonData['msg'].indexOf('eG Database User does not Exists') > -1){
						msg = Ext.MessageBox.show({
							title : 'Database creation',
							msg : '<div style="min-height:35px;">' + jsonData['msg'] + '</div>',
							buttonText: {yes: 'YES', no: 'NO'},
							fn: function(btn) {
								if (btn == 'yes') {
									if(dbType=='mssql'){
										Ext.getCmp('dba_container').show();
										Ext.getCmp('dbausername').focus(true);
									}
									else  {
										if(jsonData['msg'].indexOf('eG Database User does not Exists') > -1){
											//isDbValidated=true;
											me.submitForm();
										}
										Ext.getCmp('dba_container_oracle').show();
										Ext.getCmp('dbausernameOra').focus(true);
									}

								}  else {
									if(dbType=='mssql'){	
										Ext.getCmp('mdbusername').focus(true);
										if(newDb=='no'){
											Ext.getCmp('dba_container').hide();
											 Ext.getCmp('dbausername').setValue('');
											 Ext.getCmp('dbapassword').setValue('');
											 Ext.getCmp('confdbapassword').setValue('');
										}
									}
									else {
										
										if(newUser=='no'){
											Ext.getCmp('dba_container_oracle').hide();
											Ext.getCmp('dbausernameOra').setValue('');
											Ext.getCmp('dbapasswordOra').setValue('');
											Ext.getCmp('confdbapasswordOra').setValue('');
										}
										Ext.getCmp('mdbusernameOra').focus(true);
									}
								} 
								
							},
							maskCls :'windowModal',
							icon : Ext.MessageBox.INFO
						});
					}
					else if(jsonData['msg'].indexOf('Database does not exists') > -1 || jsonData['msg'].indexOf('unable to access database') > -1
						|| jsonData['msg'].indexOf('eG Database and user is already exists') >-1 || jsonData['msg'].indexOf('eG Database is already exists')>-1
						|| jsonData['msg'].indexOf('eG Database user is already exists')>-1 )
					{
						msg = Ext.MessageBox.show({
						title : 'Database creation',
						msg : '<div style="min-height:35px;">' + jsonData['msg'] + '</div>',
						buttonText: {yes: 'YES', no: 'NO'},
						maskCls :'windowModal',
						icon : Ext.MessageBox.INFO,
						fn: function(btn) {
							if (btn == 'yes') {
								if(dbType=='mssql'){
									if(!Ext.isEmpty(thisForm.findField('dbausername').getValue())){
										//isDbValidated=true;
										me.submitForm();
									}
									else{
										Ext.getCmp('dba_container').show();
										Ext.getCmp('dbausername').focus(true);
									}
								}
								else{
									//isDbValidated=true;
									me.submitForm();
								}
								
							}
							else {
								if(dbType=='mssql'){
									if(jsonData['msg'].indexOf('eG Database user is already exists')>-1 ){
										Ext.getCmp('mdbusername').focus(true);
									}else{
										Ext.getCmp('dbname').focus(true);
									}
								}
								else{
									Ext.getCmp('mdbusernameOra').focus(true);
								}
							}
						},
						});
					}
					else if(jsonData['msg'].indexOf('eG Database user is exists, but lacks in privileges, Do you want to grant and continue?') > -1){
						//var alertMsg='<div style="min-height:35px;">' + jsonData['msg'] + '<br>VIEW SERVER STATE<br>VIEW ANY DEFINITION</div>';
						var alertMsg='<div style="min-height:35px;">' + jsonData['msg'] + '</div>';
						msg = Ext.MessageBox.show({
							title : 'Database creation',
							msg : alertMsg,
							buttonText: {yes: 'YES', no: 'NO'},
							maskCls :'windowModal',
							icon : Ext.MessageBox.INFO,
							fn: function(btn) {
								if (btn == 'yes') {
									if(dbType=='mssql' && newDb=='no'){
										Ext.getCmp('dba_container').show();
										Ext.getCmp('dbausername').focus(true);
									}
								}
								else {
									if(dbType=='mssql' && newDb=='no'){
										Ext.getCmp('dba_container').hide();
										Ext.getCmp('mdbusername').focus(true);
									}
								}
							}  
						});
					} 
					else{	
						msg = Ext.MessageBox.show({
							title : 'Database creation',
							msg : '<div style="min-height:35px;">' + jsonData['msg'] + '</div>',
							buttons : Ext.MessageBox.OK,
							maskCls :'windowModal',
							icon : Ext.MessageBox.INFO
						});
					}
					Ext.WindowManager.bringToFront(msg);
					Ext.destroy(me);
					Ext.destroy(thisForm);
				},
				failure : function() {
					Ext.destroy(me);
					Ext.destroy(thisForm);
				}
			})
	   }
  },
  hostValidation : function(){
	  var IP;
	  if(Ext.getCmp('hidden_dbfield').getValue()=='mssql'){
			IP='ip';
	  }else{
			IP='ipOra';
	  }
		var ip=Ext.getCmp(IP).getValue();
		var hostIpObj = Ext.getCmp(IP).focus(false, 100);
		var hostnM=false;
		if(!Ext.isEmpty(ip)){
             if(ip.indexOf('.')==-1 || ip.indexOf(':')==-1){
                  hostNm = true;
			 }
	    }
		if(!Ext.isEmpty(ip)){

            if(!hostNm && !validateIpAddress(ip))
			{
			hostIpObj.focus(true);
			return false;
			}
			else if(hostNm && !validateHostField(ip))
			{
			hostIpObj.focus(true);
			return false;
			}
			else if(hostNm && !checkspace(ip))
			{
			hostIpObj.focus(true);
			return false;
			}
			else if(hostNm && !checkspecial(ip,"`~!@#$%^&*()+={}[]|\\;\"\'<>,?"))
			{
			hostIpObj.focus(true);
			return false;
			}
			return true;
		}else{
			hostIpObj.focus(true);
			var msg = Ext.MessageBox.show({
						title : 'Database creation',
						msg : '<div style="min-height:35px">Please enter the host name/ip address</div>',
						buttons : Ext.MessageBox.OK,
						maskCls :'windowModal',
						icon : Ext.MessageBox.INFO
					});
					Ext.WindowManager.bringToFront(msg);
			return false;
		}
  },
  portValidation : function(){
	  var PORT;
	  if(Ext.getCmp('hidden_dbfield').getValue()=='mssql'){
			PORT='port';
	  }else{
			PORT='portOra';
	  }
	  if(!Ext.isEmpty(Ext.getCmp(PORT).getValue())){
		  var portObj=Ext.getCmp(PORT);
		  var port=Ext.getCmp(PORT).getValue();

                var message;
				if(isNaN(port) && port!='none'){
					message='Port value Must be a number or "none"';
				}
				else if (!checknumber("+",port) && port != 'none')
				{
					message='Port number should be numerical or none';
				}
				else if (!checkfordecimal(port))
				{
					portObj.focus(true);
					return false;
				}
				else if (port == "0")
				{
					message='Only valid integers are allowed for port number';
				}
				else if (port > 99999)
				{
					message='Invalid port number';
				}
				else if (!checkspace(port))
				{
					portObj.focus(true);
					return false;
				}


         if(!Ext.isEmpty(message)){
			   Ext.getCmp(PORT).focus(false, 100);
			   var msg = Ext.MessageBox.show({
						title : 'Database creation',
						msg : '<div style="min-height:35px">'+message+'</div>',
						buttons : Ext.MessageBox.OK,
						maskCls :'windowModal',
						icon: 'iconExclamation'
					});
					Ext.WindowManager.bringToFront(msg);
			   return false;
		 }
         return true;

	  }else{
		  Ext.getCmp(PORT).focus(false, 100);
         var msg = Ext.MessageBox.show({
						title : 'Database creation',
						msg : '<div style="min-height:35px">Please enter port number</div>',
						buttons : Ext.MessageBox.OK,
						maskCls :'windowModal',
						icon: 'iconExclamation'
					});
					Ext.WindowManager.bringToFront(msg);
		 return false;
	  }
  },
  licenceUploadChange : function(){
      var radioBtn= Ext.getCmp('upldLicence').getValue().addlicense;
	  if(radioBtn=='yes'){
			Ext.getCmp('licenceMsg').hide();
			Ext.getCmp('fileUploadForm').show();
			Ext.getCmp('fileUpladBotn').show();
		 
	  }else if(radioBtn=='no'){
		Ext.getCmp('licenceMsg').show();
		Ext.getCmp('fileUploadForm').hide();
		Ext.getCmp('fileUpladBotn').hide();
		
	  }
  },
  licenseUpload : function (){

	//Ext.getCmp('fileUploadForm').setHeight(150); hidden by Jaiwin
	//Ext.getCmp('fileUploadForm').setAutoScroll(false); hidden by Jaiwin
       /************file upload starts here ***************/

	var meThis=this;
	var uploadlicenseObj = Ext.getCmp('FILE_0').getValue();
	var getFileName = uploadlicenseObj;
	if ( uploadlicenseObj != null && uploadlicenseObj != '' && uploadlicenseObj != undefined && uploadlicenseObj != 'undefined' )
	{
		var getFileName = String(uploadlicenseObj)+"";
		getFileName = getFileName.substring( getFileName.lastIndexOf('\\') + 1 );
		if ( getFileName.indexOf(".") > -1 || getFileName.indexOf('license') != 0)
		{
			Ext.Msg.show({
				title: 'Database creation',
				msg: 'Please upload valid license.',
				buttons: Ext.MessageBox.OK,
				maskCls :'windowModal',
				icon: 'iconExclamation'
			});
		}
		else {
			var licenseForm = Ext.getCmp('fileUploadForm').getForm();
			if (licenseForm.isValid())
			{
				licenseForm.submit(
				{
					url : "/final/DbLicenseUploadJson.jsp",
					scope:this,
					async : true,
					waitMsg : 'Upload is in progress, please wait...',
					method : 'POST',
					waitTitle:'eG License Upload',
					enctype : 'multipart/form-data',
					success: function (form, action)
					{
						var jsonText = action.response.responseText;
						jsonText = Ext.decode(jsonText);
						var alertTextSuccessMsg = jsonText['Success_Msg'];
						var ErrMsgsJson =jsonText['ErrMsgsJson'];
						if (!Ext.isEmpty(jsonText))
						{
							if(!Ext.isEmpty(ErrMsgsJson))
							{
								Ext.Msg.show({
								title: "Database creation",
								width:280,
								msg: ErrMsgsJson,
								icon: 'iconExclamation',
								buttons: Ext.Msg.OK
							});
							return;
							}
							else if(!Ext.isEmpty(alertTextSuccessMsg))
							{
								Ext.Msg.show({
									title: "Database creation",
									width:280,
									msg: alertTextSuccessMsg,
									buttons: Ext.Msg.OK,
									icon: 'iconInformation',
									fn: function() {
										Ext.getCmp('topResultHideRight').hide();
										Ext.getCmp('topResultHideWrong').hide();
										Ext.getCmp('reDirectMsg').show();
										Ext.getCmp('successCnt').show();
										Ext.getCmp('failureCnt1').hide();
										Ext.getCmp('failureCnt2').hide();
										Ext.getCmp('restartMgr').hide();
										Ext.getCmp('upldLicence').hide();
										Ext.getCmp('fileUploadForm').hide();
										Ext.getCmp('fileUpladBotn').hide();
										Ext.getCmp('topResHideRight').hide();
										
										restartManagerMask = new Ext.LoadMask(Ext.get('main'), {
											cls:'windowModal',
											msg: "eG "+managerSmLabel+" is restarting, please wait..."
										});
										restartManagerMask.show();
										Ext.Ajax.request({
											url : '/final/servlet/com.eg.TomcatRestart',
											method : 'POST',
											scope : this,
											success : function(response) {
												console.log("starting thread in success");
												meThis.restartManager();
											},
											failure : function() {
												console.log("starting thread in failure");
												meThis.restartManager();
											}
										});
									}
								});
							}
						 }
						Ext.destroy(uploadlicenseObj);
					},
					failure:function (form, action)
					{
						restartManagerMask.hide();
						Ext.getCmp('licenceMsg').show();
						Ext.getCmp('fileUploadForm').hide();
						//Ext.getCmp('reDirectMsg').show();
						Ext.getCmp('upldLicence').setValue({addlicense:'no'});
						alert('Oops! Error while importing License, please check error_log file for more details.');
						Ext.destroy(uploadlicenseObj);						
					}
				});
			}
		}
		
	}
	else
	{

		Ext.Msg.show({
			title: 'Database creation',
			msg: 'Please select licence',
			buttons: Ext.MessageBox.OK,
			maskCls :'windowModal',
			icon: 'iconExclamation'
		});
		//return;
	}
		  /************ file upload end *******************/
	},
	restartManager : function(){
		var taskRunCount=0;
		setTimeout(function(){
			task = {
				run: function(){
					Ext.Ajax.request({
						url : '/final/eGDatabaseCreation.jsp',
						method : 'POST',
						scope:this,
						autoAbort: true,
						success : function(response)
						{
							window.location.href = "/final/login";
						},
						failure : function() {
							console.log("please wait for few seconds...");
							if(++taskRunCount == mgrStartupIntervalCount){
								restartManagerMask.hide();
							}
						}
					});
				},
				interval: 20000,//20 seconds
				repeat : mgrStartupIntervalCount 
			};
			Ext.TaskManager.start(task);
			task = null;
			delete task;
		}, 120000);//Task going to be execute after 120 seconds
	},
	
	loadManagerConfigurations : function()
	{
		Ext.Ajax.request({
			url: '/final/scripts/eGDBCreation/data/EgManagerModelJson.jsp',
			method: 'POST',
			async: false,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
				{
					var jsonText = response.responseText;
					publicMailSettingsJson = Ext.decode( jsonText );
				}
			}
		});

		var eGMgrModel = publicMailSettingsJson['eGMgrModel'];
		if (!Ext.isEmpty(eGMgrModel) && eGMgrModel.toLowerCase() == "msp")
		{
			Ext.getCmp('mgrModelMsp').setValue(true);
		}
		else
		{
			Ext.getCmp('mgrModelEnterprise').setValue(true);
		}

		var EnableAuditlog = publicMailSettingsJson['EnableAuditlog']; 
		if (!Ext.isEmpty(EnableAuditlog) && (EnableAuditlog.toLowerCase() == "yes" || EnableAuditlog.toLowerCase() == "true"))
		{
			Ext.getCmp('yesEnableAuditlog').setValue(true);
		}
		else
		{
			Ext.getCmp('noEnableAuditlog').setValue(true);
		}

		Ext.getCmp('minLen').setValue(publicMailSettingsJson['pwdMinLength']);
		this.setPasswordComplexity(publicMailSettingsJson['pwdComplexity']);

		this.initializeFields();
		var strUser = publicMailSettingsJson['strUser'];
		if (strUser != null && !Ext.isEmpty(strUser) && strUser.length > 0)
		{
			Ext.getCmp('smtpauthenticationyes').setValue(true);
			Ext.getCmp('smtpuser').show();
			Ext.getCmp('smtppasssword').show();
			Ext.getCmp('smtpconfirmpasssword').show();

			Ext.getCmp('smtpuser').setValue(strUser);
			Ext.getCmp('smtppasssword').setValue(publicMailSettingsJson['strPwd']);
			Ext.getCmp('smtpconfirmpasssword').setValue(publicMailSettingsJson['strPwd']);
		}
		else
		{
			Ext.getCmp('smtpuser').hide();
			Ext.getCmp('smtppasssword').hide();
			Ext.getCmp('smtpconfirmpasssword').hide();
		}

		var mailReceiver = publicMailSettingsJson['mailReceiver'];
		if (mailReceiver != null && !Ext.isEmpty(mailReceiver) && mailReceiver.length > 0)
		{
			Ext.getCmp('mailauthenticationyes').setValue(true);
			Ext.getCmp('mailrcvId').show();
			Ext.getCmp('mailrcvpwd').show();
			Ext.getCmp('portforrcvmail').show();
			Ext.getCmp('protocolforrcvmail').show();
			Ext.getCmp('serverforrcvmail').show();

			Ext.getCmp('mailrcvId').setValue(mailReceiver);
			Ext.getCmp('mailrcvpwd').setValue(publicMailSettingsJson['mailReceiverPasswd']);
			Ext.getCmp('portforrcvmail').setValue(publicMailSettingsJson['mailRcvPort']);
			Ext.getCmp('protocolforrcvmail').setValue(publicMailSettingsJson['mailRcvProtocol']);
			Ext.getCmp('serverforrcvmail').setValue(publicMailSettingsJson['mailRcvServer']);
		}
		else
		{
			Ext.getCmp('mailrcvId').hide();
			Ext.getCmp('mailrcvpwd').hide();
			Ext.getCmp('portforrcvmail').hide();
			Ext.getCmp('protocolforrcvmail').hide();
			Ext.getCmp('serverforrcvmail').hide();
		}
		
		if (!Ext.isEmpty(publicMailSettingsJson['strHost']))
		{
			Ext.getCmp('smtpmailhost').setValue(publicMailSettingsJson['strHost']);
			Ext.getCmp('validateBtn').show();
		}
		else
		{
			Ext.getCmp('validateBtn').hide();
		}
		
		if (publicMailSettingsJson['strPort'] == "")
		{
			publicMailSettingsJson['strPort'] = 25;
		}
		Ext.getCmp('smtpmailport').setValue(publicMailSettingsJson['strPort']);
		Ext.getCmp('egadminmailId').setValue(publicMailSettingsJson['strSender']);
		Ext.getCmp('alternatemailid').setValue(publicMailSettingsJson['mailBuff']);

		Ext.getCmp('mailhomeurl').setValue(publicMailSettingsJson['mgrUrl']);
		Ext.getCmp('mailhomeurlfield').hide();
	},
	
	initializeFields : function() {
		var me = this;
		var executiveForm = this.getFormitems().getForm();
		var selectedProtocol = publicMailSettingsJson['strProtocol'];
		if (selectedProtocol != null && selectedProtocol.length > 0 && selectedProtocol != "")
		{
			me.setValueWithOptionInList(executiveForm, 'mailProtocol', publicMailSettingsJson['protocolArray'],selectedProtocol);
		}
		else
		{
			me.setValueWithOptionInList(executiveForm, 'mailProtocol', publicMailSettingsJson['protocolArray'],'SMTP');
		}
	},

	setValueWithOptionInList : function(form, fieldName, list, value) {
		Ext.getCmp(fieldName).getStore().loadRawData(list);
		Ext.getCmp(fieldName).suspendEvents(false);
		var valueAssigned = false;
		for(var listCounter = 0 ; listCounter < list.length ; listCounter++){
			if(list[listCounter].valueField == value && !Ext.isEmpty(value) && value != null){
				Ext.getCmp(fieldName).setValue(value);
				valueAssigned = true;
			}
		}
		
		if(!valueAssigned){
			Ext.getCmp(fieldName).setValue(list[0].valueField);
		}
		Ext.getCmp(fieldName).resumeEvents();
	},

	radSmtpChange: function() {
		var notSmtpAuthen = Ext.getCmp('smtpauthenticationno').getValue();
		if (notSmtpAuthen == true)
		{
			Ext.getCmp('smtpuser').hide();
			Ext.getCmp('smtppasssword').hide();
			Ext.getCmp('smtpconfirmpasssword').hide();
		}
		else
		{
			Ext.getCmp('smtpuser').show();
			Ext.getCmp('smtppasssword').show();
			Ext.getCmp('smtpconfirmpasssword').show();
		}
	},

	radMailSetChange: function() {
		var notmailRcvSettings = Ext.getCmp('mailauthenticationno').getValue();
		if (notmailRcvSettings == true)
		{
			Ext.getCmp('mailrcvId').hide();
			Ext.getCmp('mailrcvpwd').hide();
			Ext.getCmp('portforrcvmail').hide();
			Ext.getCmp('protocolforrcvmail').hide();
			Ext.getCmp('serverforrcvmail').hide();
		}
		else
		{
			Ext.getCmp('mailrcvId').show();
			Ext.getCmp('mailrcvpwd').show();
			Ext.getCmp('portforrcvmail').show();
			Ext.getCmp('protocolforrcvmail').show();
			Ext.getCmp('serverforrcvmail').show();
		}
	},

	validationForMailServers: function() {
		var callCheckUsr = this;
		if (getBtnId == 'validateBtn')
		{
			Validate = true;
		}
		else
		{
			Validate = false;
		}
		var mail_host = Ext.getCmp('smtpmailhost').getValue();
		var mail_port = Ext.getCmp('smtpmailport').getValue();
		var user = Ext.getCmp('smtpuser').getValue();
		var pwd = Ext.getCmp('smtppasssword').getValue();

		var mailsendersIds = Ext.getCmp('alternatemailid').getValue();
		var mailsender = Ext.getCmp('egadminmailId').getValue();
		var proceedFlag = true;
		var tempResult;

		if (mailsendersIds.length > 0)
		{
			var mailIDs = mailsendersIds.replace("\r","").split("\n");
			for (var i=0;i<mailIDs.length && mailIDs[i] !="";i++)
			{
				var tempString = trim(mailIDs[i]);
				tempResult = validateEmail(tempString);
				if(!validateSingleByte(mailIDs[i]))
				{
					Ext.Msg.show({
						title : PageTitle,
						msg : singleByte_mailIds,
						icon : 'iconExclamation',
						buttons:Ext.Msg.OK,
						fn : function(btn){
							Ext.getCmp('alternatemailid').focus(true);
						}
					});
					proceedFlag = false;
					return;
				}
				else if(tempResult == null || tempResult == undefined || tempResult == false )//if(tempResult == null || tempResult != tempString)
				{
					Ext.Msg.show({
						title : PageTitle,
						msg : alternate_mailId+'.',
						icon : 'iconExclamation',
						buttons : Ext.Msg.OK,
						fn : function(btn){
							Ext.getCmp('alternatemailid').focus(true);
						}
					});
					proceedFlag = false;
					break;
				}
			}
		}

		var numbers = "0123456789 ";
		var alpha = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
		var check_char = "";
		var check_num = "";
		var flag = "false";
		var mail_protocol = Ext.getCmp('mailProtocol').getValue();

		if(mail_host != "" && mail_host.length > 0)
		{
			for(var m=0; m< mail_host.length; m++)
			{
				check_char = alpha.indexOf(mail_host.charAt(m))
				check_num = numbers.indexOf(mail_host.charAt(m))
				//Returns value 1 if the character listed is found
				if(check_char >= 1)
				{
					flag = "true";
					break;
				}
				else if(check_num >= 1)
				{
					flag = "false";
					break;
				}
			}
		}
		if (!callCheckUsr.checkUserPwd())
		{
			return;
		}
		if(!callCheckUsr.receiverAuthentication())
		{
			return;
		}
		var mailSenderValue = Ext.getCmp('egadminmailId').getValue();
		var result = validateEmail(mailSenderValue);

		var validateMailHostVar = validateMailHostExtjs(mail_host);

		if (!checkblank(mail_host))
		{
			Ext.Msg.show(
			{
				title : PageTitle,
				msg : mailHost_Bnk+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('smtpmailhost').focus(true);
				}
			});
		}
		else if(checkspaceExtjs(mail_port) == '17')
		{
			Ext.Msg.show(
			{
				title : PageTitle,
				msg : _checkblank+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('smtpmailport').focus(true);
				}
			});
		}
		else if(!checkdots(mail_port))
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : mailPortDot+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('smtpmailport').focus(true);
				}
			});
		}
		else if(checkSpecialExtjs(mail_port,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/") == '7')
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : _checkspecial+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('smtpmailport').focus(true);
				}
			});
		}
		else if(!checknumber("+",mail_port))
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : validMailPort,
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('smtpmailport').focus(true);
				}
			});
		}
		else if(checkfordecimalExtjs(mail_port) == '18')
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : _checkfordecimal,
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('smtpmailport').focus(true);
				}
			});
		}
		else if(mail_port == "0")
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : validInt+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('smtpmailport').focus(true);
				}
			});
		}
		else if(mail_port > 99999)
		{
			Ext.Msg.show(
			{
				title : PageTitle,
				msg : invalidPrt+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('smtpmailport').focus(true);
				}
			});
		}
		else if(checkSpecialExtjs(mail_host,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/") == '7')
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : _checkspecial+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('smtpmailhost').focus(true);
				}
			});
		}
		else if(!validateSingleByte(mail_host))
		{
			Ext.Msg.show(
			{
				title : PageTitle,
				msg : mailHstDBL+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('smtpmailport').focus(true);
				}
			});
		}
		else if(!checkblank(mailsender))
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : mailRcv_valid+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('egadminmailId').focus(true);
				}
			});
		}
		else if(!validateSingleByte(mailsender))
		{
			Ext.Msg.show(
			{
				title : PageTitle,
				msg : mailIDDBL+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('egadminmailId').focus(true);
				}
			});
		}
		else if(result == null || result == undefined || result == false)
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : mailRcv_valid+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('egadminmailId').focus(true);
				}
			});
		}
		else if (mailsender.indexOf(',') != -1)
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : mail_valid+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('egadminmailId').focus(true);
				}
			});
		}
		else if(flag == "true")
		{
			if(checkspaceExtjs(mail_host) == '17')
			{
				Ext.Msg.show(
				{
					title : PageTitle,
					msg : _checkblank+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('smtpmailhost').focus(true);
					}
				});
			}
			else if(!checkdots(mail_host))
			{
				Ext.Msg.show(
				{
					title : PageTitle,
					msg : mailDot+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('smtpmailhost').focus(true);
					}
				});
			}
			else
			{
				if (proceedFlag)
				{
					if (!Validate)
					{
						return true;
					}
					else
					{
						callCheckUsr.validateMailSettings();
					}
				}
			}
		}
		else if(!checkdots(mail_host))
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : mailDot+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('smtpmailhost').focus(true);
				}
			});
		}
		else if(validateMailHostVar != "0")
		{
			if(validateMailHostVar == "19")
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : _validateMailHost+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('smtpmailhost').focus(true);
					}
				});
			}
			else if(validateMailHostVar == "10")
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : _checknum+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('smtpmailhost').focus(true);
					}
				});
			}
		}
		else if(checkspaceExtjs(mail_host) == "17")
		{
			Ext.Msg.show({
				title : PageTitle,
				msg : _checkblank+'.',
				icon : 'iconExclamation',
				buttons : Ext.Msg.OK,
				fn : function(btn){
					Ext.getCmp('smtpmailhost').focus(true);
				}
			});
		}
		else
		{
			if (proceedFlag)
			{
				if (!Validate)
				{
					return true;
				}
				else
				{
					callCheckUsr.validateMailSettings();
				}
			}
		}
	},

	managerModelChange : function()
	{
		var mgrModelEnterprise = Ext.getCmp('mgrModelEnterprise').getGroupValue();
		if (!Ext.isEmpty(mgrModelEnterprise) && mgrModelEnterprise.toLowerCase() == "msp")
		{
			Ext.getCmp('mailservsettingsfield').setTitle('<b>' + '<span style="color:red;">*</span> Mail Server Settings' +'</b>');
			Ext.getCmp('adminMailCont').setFieldLabel('<span style="color:red;">*</span> Mail ID for admin user');
		}
		else
		{
			Ext.getCmp('mailservsettingsfield').setTitle('<b>' + 'Mail Server Settings' +'</b>');
			Ext.getCmp('adminMailCont').setFieldLabel('Mail ID for admin user');
		}
	},

	validateMailSettings: function() { 
		var mail_host = Ext.getCmp('smtpmailhost').getValue();
		var mail_port = Ext.getCmp('smtpmailport').getValue();
		var mail_protocol = Ext.getCmp('mailProtocol').getValue();
		var user = Ext.getCmp('smtpuser').getValue();
		var pwd = Ext.getCmp('smtppasssword').getValue();
		var mailSenderValue = Ext.getCmp('egadminmailId').getValue();
		var mailrecvID = Ext.getCmp('mailrcvId').getValue();
		var MailReceiverPasswd = Ext.getCmp('mailrcvpwd').getValue();
		var MailRcvPort = Ext.getCmp('portforrcvmail').getValue();
		var MailRcvProtocol = Ext.getCmp('protocolforrcvmail').getValue();
		var MailRcvServer = Ext.getCmp('serverforrcvmail').getValue();

		var authenticate;
		var authenUser = Ext.getCmp('smtpauthenticationyes').getValue();
		if (authenUser == true)
		{
			authenticate = "true";
		}
		else
		{
			authenticate = "false";
		}

		var mailRecvSetting;
		var mailRecvSetter = Ext.getCmp('mailauthenticationyes').getValue();
		if (mailRecvSetter == true)
		{
			mailRecvSetting = "true";
		}
		else
		{
			mailRecvSetting = "false";
		}

		var urlPath = "/final/scripts/eGDBCreation/data/sendMailAlertJson.jsp?activeTabId=mailsmssettings";
		params="option=send&mailSenderHost="+mail_host+"&mailport="+mail_port+"&mailProtocol="+mail_protocol+"&mailSender="+mailSenderValue+"&authentication="+authenticate+"&mailUser="+encodeURIComponent(user,"UTF-8")+"&mailPassword="+encodeURIComponent(pwd,"UTF-8")+"&revSetConfig="+mailRecvSetting+"&receiverId="+mailrecvID+"&receiverPassword="+encodeURIComponent(MailReceiverPasswd,"UTF-8")+"&receiverPort="+MailRcvPort+"&mailRecverProtocol="+encodeURIComponent(MailRcvProtocol,"UTF-8")+"&receiverHost="+MailRcvServer+"&currentDate="+ new Date().getTime();
		this.loadAlertDiv(urlPath,params);
	},

	loadAlertDiv: function(urlPath,params) { 
		var me = this;
		var validationLoadingMsg2 = "<table width='100%' border='0' height='90px'><tr><td align=center valign=bottom><img src=/final/monitor/eg_images/indicator_medium.gif></td></tr><tr><td vlaign=top width='50%' style='text-align:center;font-size:12px'>"+validate+".</td></tr></table>";
		Ext.widget('window',{
			extend:'Ext.panel.Panel',
			title : validate,
			listeners : {
				afterrender : function()
				{
					me.validateMailCredentials(urlPath,params);
				}
			},
			closeAction: 'destory',
			id : 'validateVcenterServer',
			height: 140,
			align : 'center',
			width: 350,
			padding:'5 10 10 10',
			modal: true,
			//autoScroll : true,
			//scroll : true,
			doClose: function() {
				this.destroy();
			},
			items : [
				{
					id : 'resultContainerStr',
					border : false,
					height: 128,
					style:{'text-align':'center'},
					html:validationLoadingMsg2+'.',
				}
			]
		}).show();
	},

	validateMailCredentials: function(urlPath,params) { 
		var tmpData = '';
		Ext.Ajax.request({
			url : urlPath,
			params: params,
			method: 'POST',
			success: function(response)
			{
				var tmpText = response.responseText;
				var resultContainerStr = Ext.getCmp('resultContainerStr');
				resultContainerStr.update(tmpText);
			}
		});
	},

	checkUserPwd: function() {
		var smtpAuthenYes = Ext.getCmp('smtpauthenticationyes').getValue();
		if (smtpAuthenYes == true)
		{
			var user = Ext.getCmp('smtpuser').getValue();
			var pwd = Ext.getCmp('smtppasssword').getValue();
			var conf = Ext.getCmp('smtpconfirmpasssword').getValue();
			var auth_usr=true;
			var auth_pwd=true;
			var checkSpecialVar = checkSpecialExtjs(user,"*+=|:;\"\'<>\/[]?,");
			if(isDouble == "false")
			{
				auth_usr= validateSingleByte(user);
				auth_pwd= validateSingleByte(pwd);
			}
			if (user == "null")
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : userField+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('smtpuser').focus(true);
					}
				});
				return false;
			}
			else if (user=="")
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : userField_Blank+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
							Ext.getCmp('smtpuser').focus(true);
					}
				});
				return false;
			}
			else if(user!=null && checkSpecialVar == '7')
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : _checkspecial+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('smtpuser').focus(true);
					}
				});
				return false;
			}
			else if(user!=null && trim(user) == "")
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : Field_Blank+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('smtpuser').focus(true);
					}
				});
				return false;
			}
			else if(user!=null && user.indexOf("..") > -1)
			{
				Ext.Msg.alert(_checkdots);
				Ext.getCmp('smtpuser').focus(true);
				return false;
			}
			else if (user != null && user.indexOf("  ") > -1)
			{
				Ext.Msg.alert(_checkSpaces);
				Ext.getCmp('smtpuser').focus(true);
				return false;
			}
			else if(!auth_usr)
			{
				Ext.Msg.show(
				{
					title : PageTitle,
					msg : auth_userByte+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('smtpuser').focus(true);
					}
				});
				return false;
			}
			else if (pwd =="null")
			{
				Ext.Msg.show(
				{
					title : PageTitle,
					msg : passField+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('smtppasssword').focus(true);
					}
				});
				return false;
			}
			else if (pwd == "")
			{
				Ext.Msg.show(
				{
					title : PageTitle,
					msg : passField_Blank+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('smtppasssword').focus(true);
					}
				});
				return false;
			}
			else if (pwd != conf)
			{
				Ext.Msg.show(
				{
					title : PageTitle,
					msg : pass_Match+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('smtppasssword').focus(true);
					}
				});
				return false;
			}
			else if(!checkspecialnomess(pwd,"\'\"}~|"))
			{
				Ext.Msg.show(
				{
					title : PageTitle,
					msg : passNotBeUsed+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('smtppasssword').focus(true);
					}
				});
				return false;
			}
			else if(!auth_pwd)
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : passwordByte+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('smtppasssword').focus(true);
					}
				});
				return false;
			}
			return true;
		}
		else
		{
			return true;
		}
	},
	
	receiverAuthentication: function() {
		var revSetConfig = Ext.getCmp('mailauthenticationyes').getValue();
		if (revSetConfig == true)
		{
			var receiverId = Ext.getCmp('mailrcvId').getValue();
			var resultForRecId=validateEmail(receiverId);
			var recPort= Ext.getCmp('portforrcvmail').getValue(); 
			var recPwd= Ext.getCmp('mailrcvpwd').getValue();
			var MailRcvProtocol= Ext.getCmp('protocolforrcvmail').getValue();
			var serverForMail= Ext.getCmp('serverforrcvmail').getValue();

			if(!checkblank(receiverId))
			{
				Ext.Msg.show(
				{
					title : PageTitle,
					msg : mailRcv_Blank+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('mailrcvId').focus(true);
					}
				});
				return false;
			}
			else if(resultForRecId == null || resultForRecId == undefined || resultForRecId == false)
			{
				Ext.Msg.show(
				{
					title : PageTitle,
					msg : mailRcv_valid+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('mailrcvId').focus(true);
					}
				});
				return false;
			}
			else if (recPwd =="null")
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : mailRcvPass+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn :function(btn){
						Ext.getCmp('mailrcvpwd').focus(true);
					}
				});
				return false;
			}
			else if (recPwd == "")
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : RcvPass_Blank+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('mailrcvpwd').focus(true);
					}
				});
				return false;
			}
			else if(!checkspecialnomess(recPwd,"\'\"}~|"))
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : RcvChPass+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('mailrcvpwd').focus(true);
					}
				});
				return false;
			}
			else if(!validateSingleByte(recPwd))
			{
				Ext.Msg.show(
				{
					title : PageTitle,
					msg : RcvPassByte+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('mailrcvpwd').focus(true);
					}
				});
				return false;
			}
			else if(isNaN(recPort))
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : "' "+recPort+" '  " + notValidNo+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('portforrcvmail').focus(true);
					}
				});
				return false;
			}
			else if(isValid(recPort))
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : notValidPort+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('portforrcvmail').focus(true);
					}
				});
				return false;
			}
			else if(MailRcvProtocol=="")
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : mailRcvPrt+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('protocolforrcvmail').focus(true);
					}
				});
				return false;
			}
			else if(!validateSingleByte(MailRcvProtocol))
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : mailRcvPrtDBL+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('protocolforrcvmail').focus(true);
					}
				});
				return false;
			}
			else if(!checkblank(serverForMail))
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : mailSrv_bnk+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('serverforrcvmail').focus(true);
					}
				});
				return false;
			}
			else if(checkSpecialExtjs(serverForMail,"`~!@#$%^&*()+={}[]|\\:;\"\'<>,?\/") == '7')
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : _checkspecial+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('serverforrcvmail').focus(true);
					}
				});
				return false;
			}
			else if(!validateSingleByte(serverForMail))
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : mailDBL+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('serverforrcvmail').focus(true);
					}
				});
				return false;
			}
			else if(!checkdots(serverForMail))
			{
				Ext.Msg.show({
					title : PageTitle,
					msg : mailDot+'.',
					icon : 'iconExclamation',
					buttons : Ext.Msg.OK,
					fn : function(btn){
						Ext.getCmp('serverforrcvmail').focus(true);
					}
				});
				return false;
			}
			else
			{
				return true;
			}
		}
		else
		{
			return true;
		}
	},

	setPasswordComplexity : function(val)
	{
		var temp;
		if(val.indexOf(",") > -1)
		{
			temp = val.split(",");
			for(var k=0; k<temp.length; k++)
			{
				var tempVal = temp[k].toLowerCase();
				if(tempVal == "lc")
				{
					Ext.getCmp("lowercase").setValue(true);
				}
				else if(tempVal == "uc")
				{
					Ext.getCmp("uppercase").setValue(true);
				}
				else if(tempVal == "dg")
				{
					Ext.getCmp("number").setValue(true);
				}
				else if(tempVal == "sp")
				{
					Ext.getCmp("specialchar").setValue(true);
				}
			}
		}
		else
		{
			temp = val.toString().toLowerCase();
			if(temp == "uc")
			{
				Ext.getCmp("uppercase").setValue(true);
			}
			else if(temp == "dg")
			{
				Ext.getCmp("number").setValue(true);
			}
			else if(temp == "sp")
			{
				Ext.getCmp("specialchar").setValue(true);
			}
			else
			{
				Ext.getCmp("lowercase").setValue(true);
			}
		}
	},

	pwdComplexityCheck : function()
	{
		var pwdLengthObj = Ext.getCmp('minLen');
		var pwdMinLength = pwdLengthObj.getValue();
		var pwdCompLC = Ext.getCmp('lowercase').getValue();
		var pwdCompUC = Ext.getCmp('uppercase').getValue();
		var pwdCompDG = Ext.getCmp('number').getValue();
		var pwdCompSP = Ext.getCmp('specialchar').getValue();
		var pwdComplexityCount = 0;
		if (pwdCompLC)
		{
			pwdComplexityCount++;
		}
		if (pwdCompUC)
		{
			pwdComplexityCount++;
		}
		if (pwdCompDG)
		{
			pwdComplexityCount++;
		}
		if (pwdCompSP)
		{
			pwdComplexityCount++;
		}

		if(pwdMinLength < pwdComplexityCount)
		{
			return "false";
			//Ext.Msg.show({
				//title: pwdpolicyTitle,
				//msg: minLenAlert,
				//buttons: Ext.Msg.OK,
				//icon: 'iconExclamation',
				//fn : function(btn)
				//{
					//pwdLengthObj.focus();
				//}
			//});
		}
		else
		{
			return "true";
		}
	},
	
	checkpwdpolicy : function()
	{
		var pwdLength = Ext.getCmp('minLen').getValue();
		if (pwdLength == null)
		{
			return "1";
		}
		else if(pwdLength < 2)
		{
			return "2";
		}
		else if(pwdLength > 16)
		{
			return "3";
		}
		else
		{
			return "true"
		}
	},

	getPasswordComplexity : function()
	{
		var lower = Ext.getCmp('lowercase').getValue();
		var upper = Ext.getCmp('uppercase').getValue();
		var digit = Ext.getCmp('number').getValue();
		var special = Ext.getCmp('specialchar').getValue();
		var result = "";
		if(lower)
		{
			result += "LC";
		}
		if(upper)
		{
			result += "," + "UC";
		}
		if(digit)
		{
			result += "," + "DG";
		}
		if(special)
		{
			result += "," + "SP";
		}
		if(result.indexOf(",") == 0)
		{
			result = result.substring(1);
		}
		return result;
	},

	managerConfigurationUpdate : function()
	{
		// eG manager model

		var mgrConfigUpdateText = Ext.getCmp('mgrConfigUpdate').getText();

		if (!Ext.isEmpty(mgrConfigUpdateText) && mgrConfigUpdateText == 'Next')
		{
			var mgrModelEnterprise = Ext.getCmp('mgrModelEnterprise').getGroupValue();
			var issueuuidyes = "no";
			if (!Ext.isEmpty(mgrModelEnterprise) && mgrModelEnterprise.toLowerCase() == "msp")
			{
				issueuuidyes = "yes";
			}

			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();

			// configure admin mail id
			var regExp1=/^(\+\d\d)?[0-9]+$/g;
			var reg3 = /(((([\+]?([0-9]){4,15})|([\_\#]?([a-zA-Z0-9]+[\ \_\.\-\&\#]?)*[a-zA-Z0-9])+)\@[a-zA-Z0-9][\w\.-]*[a-zA-Z0-9]\.[a-zA-Z][a-zA-Z\.]*[a-zA-Z])|((\+\d\d)?[0-9]+))/g
			var checkToStr='';
			var sub = true;
			var mailtoval=Ext.getCmp('mailTo').getValue();
			if(mailtoval!=null && mailtoval!="undefined")
			{
					checkToStr =mailtoval ;
			}

			var toMailResult=validateEmail(mailtoval);
			var toMobResult=mailtoval.match(regExp1);
			var toResult=mailtoval.match(reg3);
			
			if (!Ext.isEmpty(mgrModelEnterprise) && mgrModelEnterprise.toLowerCase() == "msp")
			{
				if (Ext.isEmpty(checkToStr))
				{
					Ext.Msg.show({
						title:PageTitle,
						msg:'Please enter mail ID for admin',
						buttons: Ext.Msg.OK,
						icon: Ext.Msg.WARNING,
						fn: function(btn)
						{
							Ext.getCmp('mailTo').focus(true);
						}
					});
					myMask.hide();
					return;
				}
			}

			if((checkToStr != "") && (toMailResult==false && toMobResult == null) && (toResult != mailtoval))
			{
				Ext.Msg.show({
					title:PageTitle,
					msg:validMailandMobileNo,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING,
					fn : function(btn)
					{
						Ext.getCmp('mailTo').focus(true);
					}
				});
				myMask.hide();
				//sub = false;
				return;
			}
			if(!validateSingleByte(mailtoval))
			{
				Ext.Msg.show({
					title:PageTitle,
					msg:toNotAllowed,
					buttons: Ext.Msg.OK,
					icon: Ext.Msg.WARNING,
					fn : function(btn)
					{
						Ext.getCmp('mailTo').focus(true);
					}
				});
				myMask.hide();
				//sub = false;
				return;
			}

			if(sub)
			{
				if (!Ext.isEmpty(mgrModelEnterprise) && mgrModelEnterprise.toLowerCase() == "msp")
				{
					if(checkToStr =="" && checkToStr.length==0 )
					{
						Ext.Msg.show({
							title:PageTitle,
							msg:"Please enter valid To mail id and/or mobile number",
							buttons: Ext.Msg.OK,
							icon: Ext.Msg.WARNING,
							fn : function(btn)
							{
								Ext.getCmp('mailTo').focus(true);
							}
						});
						sub = false;
						myMask.hide();
						return;
					}
				}
			}

			//auditing
			var enableAuditingCurVal = Ext.getCmp('yesEnableAuditlog').getGroupValue();
			
			//password policy
			var pwdLengthObj = Ext.getCmp('minLen');
			var pwdLength = pwdLengthObj.getValue();
			var pwdComplexity = this.getPasswordComplexity();
			var validFlag = 'true';

			var pwdPolicyValidation = this.checkpwdpolicy();
			if (pwdPolicyValidation != "true")
			{
				if (pwdPolicyValidation == "1")
				{
					Ext.Msg.show({
						title: PageTitle,
						msg: noLenAlert,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn)
						{
							pwdLengthObj.focus();
						}
					});
				}
				else if(pwdPolicyValidation == "2")
				{
					Ext.Msg.show({
						title: PageTitle,
						msg: defMinLenAlert,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn)
						{
							pwdLengthObj.focus();
						}
					});
				}
				else if(pwdPolicyValidation == "3")
				{
					Ext.Msg.show({
						title: pwdpolicyTitle,
						msg: maxLenAlert,
						buttons: Ext.Msg.OK,
						icon: 'iconExclamation',
						fn : function(btn)
						{
							pwdLengthObj.focus();
						}
					});
				}
				Ext.getCmp('minLen').focus();
				myMask.hide();
				validFlag = 'false';
				return;
			}
			var pwdComplexityValidation = this.pwdComplexityCheck();
			if(pwdComplexityValidation != "true")
			{
				Ext.Msg.show({
					title: PageTitle,
					msg: minLenAlert,
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn)
					{
						pwdLengthObj.focus();
					}
				});
				myMask.hide();
				validFlag = 'false';
				return;
			}
			if (validFlag != 'true')
			{
				myMask.hide();
				return;
			}

			// mail server settings
			var authpassword = Ext.getCmp('smtppasssword').getValue();
			var MailReceiverPasswd = Ext.getCmp('mailrcvpwd').getValue();

			var mailhost = Ext.getCmp('smtpmailhost').getValue();
			var mailport = Ext.getCmp('smtpmailport').getValue();
			var mailprotocol = Ext.getCmp('mailProtocol').getValue();
			var mailsender = Ext.getCmp('egadminmailId').getValue();

			var mailsenders = Ext.getCmp('alternatemailid').getValue();
			var revSetConfig = '';
			var revSetConfigVal = Ext.getCmp('mailauthenticationyes').getValue();
			if (revSetConfigVal == true)
			{
				revSetConfig = "true";
			}
			else
			{
				revSetConfig = "false";
			}
			var MailReceiver = Ext.getCmp('mailrcvId').getValue();
			var MailReceiverPasswd = Ext.getCmp('mailrcvpwd').getValue();
			var MailRcvPort = Ext.getCmp('portforrcvmail').getValue();
			var MailRcvProtocol = Ext.getCmp('protocolforrcvmail').getValue();
			var MailRcvServer = Ext.getCmp('serverforrcvmail').getValue();

			var authenticate ="";
			var authenticateValue = Ext.getCmp('smtpauthenticationyes').getValue();
			if (authenticateValue == true)
			{
				authenticate = "true";
			}
			else
			{
				authenticate = "false";
			}
			var user = Ext.getCmp('smtpuser').getValue();

			var me = this;
			var checkValidation = true;

			if (!Ext.isEmpty(mailhost) || !Ext.isEmpty(mailsender))
			{
				checkValidation = me.validationForMailServers();
			}
			else
			{
				if (!Ext.isEmpty(mgrModelEnterprise) && mgrModelEnterprise.toLowerCase() == "msp")
				{
					checkValidation = me.validationForMailServers();
				}
			}
		
			if (checkValidation)
			{
				myMask.hide();
				reqParams = {
					'eGMgrModel' : mgrModelEnterprise,
					'issueUUID' : issueuuidyes,
					'tomailid' : mailtoval,
					'EnableAuditlog' : enableAuditingCurVal,
					'minLen' : pwdLength,
					'pwdComplexity' : pwdComplexity,
					'mailhost' : mailhost,
					'mailport' : mailport,
					'mailprotocol' : mailprotocol,
					'authpassword' : authpassword,
					'MailReceiverPasswd' : MailReceiverPasswd,
					'mailsenders' : mailsenders,
					'mailsender' : mailsender,
					'revSetConfig' : revSetConfig,
					'MailReceiver' : MailReceiver,
					'MailRcvPort' : MailRcvPort,
					'MailRcvProtocol' : MailRcvProtocol,
					'MailRcvServer' : MailRcvServer,
					'authenticate' : authenticate,
					'user' : user
				};
				Ext.getCmp('egmgrmodel').hide();
				Ext.getCmp('mailservsettingsfield').hide();
				Ext.getCmp('mailhomeurlfield').show();
				Ext.getCmp('mgrConfigUpdate').setText('Update');
			}
			else
			{
				myMask.hide();
				return;
			}
		}
		else
		{
			var mailHomeURL = Ext.getCmp('mailhomeurl').getValue();

			if(!checkblank(mailHomeURL))
			{
				Ext.Msg.show({
					title: PageTitle,
					msg: "Please enter the URL",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('mailhomeurl').focus(true);
					}
				});
				return false;
			}
			else if(!validateSingleUrl(mailHomeURL))
			{
				Ext.Msg.show({
					title: PageTitle,
					msg: "Please enter a valid URL",
					buttons: Ext.Msg.OK,
					icon: 'iconExclamation',
					fn : function(btn){
						Ext.getCmp('mailhomeurl').focus(true);
					}
				});
				return false;
			}
			var ajaxURl = '/final/scripts/eGDBCreation/data/EgManagerModelJsonp.jsp?mailHomeURL='+encodeURIComponent(mailHomeURL);

			var myMask = new Ext.LoadMask(Ext.getBody(), {msg: 'Updating...'});
			myMask.show();

			Ext.Ajax.request(
			{
				url : ajaxURl,
				method: 'POST',
				params : reqParams,
				success: function(response)
				{
					var jsonText = response.responseText;
					var publicJson = Ext.decode(jsonText);
					if (publicJson['success'] == "true")
					{
						myMask.hide();
						Ext.Msg.show({
							title: PageTitle,
							msg: 'Manager configuration has been updated successfully',
							buttons: Ext.Msg.OK,
							icon: 'iconInformation',
							fn: function(btn)
							{
								if (btn == 'ok')
								{
									Ext.getCmp('mgrConfigContainer').hide();
									Ext.getCmp('resultContainer').show();
									Ext.getCmp('dbIconSuccess').show();
									Ext.getCmp('dbIconFailed').hide();
									Ext.get('usercreationresRight').update('<div class="congratsText">Congrats! The eG '+managerSmLabel+' has been installed successfully!</div>');
									Ext.get('usercreationresRight').show();
									Ext.get('tabcreationresRight').update('<div style=" " class="dbfont_normal12">'+"eG database has been created <br><img src='/final/images/clear.png' style='padding:0px 5px; margin-top:5px; vertical-align:middle' class='dbIconTick'/>"+'</div>');
									Ext.get('trigcreationresRight').update('<div style=" " class="dbfont_normal12">'+"eG manager has been configured <br><img src='/final/images/clear.png' style='padding:0px 5px; margin-top:5px; vertical-align:middle' class='dbIconTick'/>"+'</div>');
									Ext.getCmp('topResultHideRight').show();
									Ext.getCmp('topResultHideWrong').hide();
									Ext.getCmp('fileUploadForm').show();
									Ext.getCmp('licenceMsg').hide();
									Ext.getCmp('fileUpladBotn').show();
									Ext.getCmp('res_button').hide();
									Ext.getCmp('upldLicence').show();
								}
							}
						});
					}
					else
					{
						Ext.Msg.show({
							title : PageTitle,
							msg : "Failure while updating manager configuration"+'.',
							icon : 'iconExclamation',
							buttons : Ext.Msg.OK
						});
						myMask.hide();
						return;
					}
				},
				failure : function()
				{
					myMask.hide();
					return;
				}
			});
		}
	}
});

function trim(d)
{
	d = d.toString();
	var b = /[^\s].*[^\s]/;
	var a = d.match(b);
	return a;
}

function validateEmail(a)
{
	//var d = /([a-zA-Z0-9]+[\ \_\.\-\&]?)*[a-zA-Z0-9]\@[a-zA-Z0-9][\w\.-]*[a-zA-Z0-9]\.[a-zA-Z][a-zA-Z\.]*[a-zA-Z]/g;
	var d = /(([\+]?([0-9]){4,15})|([\_\#]?([a-zA-Z0-9]+[\ \_\.\-\&\#]?)*[a-zA-Z0-9])+)\@[a-zA-Z0-9][\w\.-]*[a-zA-Z0-9]\.[a-zA-Z][a-zA-Z\.]*[a-zA-Z]/g;
	/* 
	* d - defines the following
	*
	* ([\+]?([0-9]){4,15})
	*			- for email id as phone number (if starts with '+'(plus) symbol then 
	*				it should allow only numerals {min:4 and max:15 digits} as mail id [Eg:+6598331234@sms-gw1.sgpoolz.com.sg])
	*
	* ([\_\#]?([a-zA-Z0-9]+[\ \_\.\-\&\#]?)*[a-zA-Z0-9])
	*			- for email id with zero or one occurence of the symbols '#' (hash) or '_' (underscore) 
	*				as prefix [Eg: _Happy.days1234@eginnovations.com]
	*
	* @[a-zA-Z0-9][\w\.-]*[a-zA-Z0-9]\.[a-zA-Z][a-zA-Z\.]*[a-zA-Z]
	*			- for domain id [Ref: @eginnovations.com]
	*
	*/
	if(a != "")
	{
	a = trim(a) + "";
	var b = a.match(d);
	if (b == null || b != a)
	{
		return false;
	}
	return true;
	}
}

function isValid(val) {
	if(val.length==0||val.indexOf('0')==0)
	{
		return "false";
	}
	if(parseInt(val)<=0)
	{
		return "false";
	}
}

function validateSingleUrl(paramValue)
{
	var toMatch = /^(http|ftp|https)\:(\\\\|\/\/)([A-Za-z0-9]+(\.)*[A-Za-z0-9]*)+/;

	if (toMatch.test(paramValue))
	{
		return true;
	}
	else
	{
		return false;
	}
}



