/*!
 * 
 *    jodit - Jodit is awesome and usefully wysiwyg editor with filebrowser
 *    Author: Chupurnov <chupurnov@gmail.com> (https://xdsoft.net/)
 *    Version: v3.1.95
 *    Url: https://xdsoft.net/jodit/
 *    License(s): GPL-2.0-or-later
 * 
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["Jodit"] = factory();
	else
		root["Jodit"] = factory();
})(typeof self !== 'undefined' ? self : this, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/build/";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 21);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var consts = __webpack_require__(2);
var Dom_1 = __webpack_require__(3);
var class2type = {};
var toString = class2type.toString;
var hasOwn = class2type.hasOwnProperty;
exports.isIE = function () {
    return navigator.userAgent.indexOf("MSIE") != -1 || /rv:11.0/i.test(navigator.userAgent);
};
var $$temp = 1;
/**
 * Find all elements by selector and return Array. If it did not find any element it return empty array
 *
 * @example
 * ```javascript
 * Jodit.modules.Helpres.$$('.someselector').forEach(function (elm) {
 *      elm.addEventListener('click', function () {
 *          alert(''Clicked');
 *      });
 * })
 * ```
 * @param selector CSS like selector
 * @param root
 *
 * @return {HTMLElement[]}
 */
exports.$$ = function (selector, root) {
    var result;
    if (/:scope/.test(selector) && exports.isIE() && !(typeof HTMLDocument !== 'undefined' && root instanceof HTMLDocument)) {
        var id = root.id, temp_id = id || '_selector_id_' + ("" + Math.random()).slice(2) + $$temp++;
        selector = selector.replace(/:scope/g, '#' + temp_id);
        !id && root.setAttribute('id', temp_id);
        result = root.parentNode.querySelectorAll(selector);
        if (!id) {
            root.removeAttribute('id');
        }
    }
    else {
        result = root.querySelectorAll(selector);
    }
    return [].slice.call(result);
};
exports.isWindow = function (obj) {
    return obj !== null && obj === obj.window;
};
exports.type = function (obj) {
    if (obj === null) {
        return 'null';
    }
    return typeof obj === "object" || typeof obj === "function" ? class2type[toString.call(obj)] || "object" : typeof obj;
};
exports.each = function (obj, callback) {
    var length, keys, i;
    if (Array.isArray(obj)) {
        length = obj.length;
        for (i = 0; i < length; i += 1) {
            if (callback.call(obj[i], i, obj[i]) === false) {
                return false;
            }
        }
    }
    else {
        keys = Object.keys(obj);
        for (i = 0; i < keys.length; i += 1) {
            if (callback.call(obj[keys[i]], keys[i], obj[keys[i]]) === false) {
                return false;
            }
        }
    }
    return obj;
};
exports.each(['Boolean', 'Number', 'String', 'Function', 'Array', 'Date', 'RegExp', 'Object', 'Error', 'Symbol', 'HTMLDocument', 'Window', 'HTMLElement', 'HTMLBodyElement', 'Text', 'DocumentFragment', 'DOMStringList'], function (i, name) {
    class2type["[object " + name + "]"] = name.toLowerCase();
});
exports.inArray = function (needle, haystack) { return (haystack.indexOf(needle) !== -1); };
exports.isPlainObject = function (obj) {
    if (typeof obj !== "object" || obj.nodeType || exports.isWindow(obj)) {
        return false;
    }
    return !(obj.constructor && !hasOwn.call(obj.constructor.prototype, "isPrototypeOf"));
};
exports.extend = function () {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    var options, name, src, copy, copyIsArray, clone, target = args[0] || {}, i = 1, j, length = args.length, keys, deep = false;
    if (typeof target === "boolean") {
        deep = target;
        target = args[i] || {};
        i += 1;
    }
    if (typeof target !== "object" && exports.type(target) === 'function') {
        target = {};
    }
    if (i === length) {
        target = this;
        i += 1;
    }
    for (i; i < length; i += 1) {
        options = args[i];
        if (options !== null && options !== undefined) {
            keys = Object.keys(options);
            for (j = 0; j < keys.length; j += 1) {
                name = keys[j];
                src = target[name];
                copy = options[name];
                if (target === copy) {
                    continue;
                }
                if (deep &&
                    copy && ((exports.isPlainObject(copy) && !(copy instanceof JoditObject)) ||
                    (Array.isArray(copy) && !(copy instanceof JoditArray)))) {
                    copyIsArray = Array.isArray(copy);
                    if (copyIsArray) {
                        copyIsArray = false;
                        clone = src && Array.isArray(src) ? src : [];
                    }
                    else {
                        clone = src && exports.isPlainObject(src) ? src : {};
                    }
                    target[name] = exports.extend(deep, clone, copy);
                }
                else if (copy !== undefined) {
                    target[name] = copy;
                }
            }
        }
    }
    return target;
};
/**
 * It clears the line of all auxiliary invisible characters , from the spaces and line breaks , tabs from the beginning and end of the line
 *
 * @param {string} value input string
 * @return {string}
 */
exports.trim = function (value) {
    return value
        .replace(consts.SPACE_REG_EXP_START, '')
        .replace(consts.SPACE_REG_EXP_END, '');
};
/**
 * Converts rgba text representation of color in hex
 * @param {string} color - string like rgba(red, green, blue, alpha) or rgb(red, green, blue)
 * @return {string | NaN} hex color view, NaN - for transparent color
 * @example
 * ```javascript
 * var p = document.createElement('p');
 * p.style.color = '#ffffff';
 * console.log(p.getAttribute('style')); // color: rgb(255, 255, 255);
 * console.log(colorTohex(p.style.color)); // #ffffff
 * ```
 */
exports.colorToHex = function (color) {
    if (color === 'rgba(0, 0, 0, 0)' || color === '') {
        return false;
    }
    if (!color) {
        return '#000000';
    }
    if (color.substr(0, 1) === '#') {
        return color;
    }
    var digits = /([\s\n\t\r]*?)rgb\((\d+), (\d+), (\d+)\)/.exec(color) || /([\s\n\t\r]*?)rgba\((\d+), (\d+), (\d+), ([\d.]+)\)/.exec(color), hex, red, green, blue, rgb;
    if (!digits) {
        return '#000000';
    }
    red = parseInt(digits[2], 10);
    green = parseInt(digits[3], 10);
    blue = parseInt(digits[4], 10);
    rgb = blue | (green << 8) | (red << 16);
    hex = rgb.toString(16).toUpperCase();
    while (hex.length < 6) {
        hex = '0' + hex;
    }
    return digits[1] + '#' + hex;
};
/**
 * Convert rgba and short HEX color to Full text color. #fff to #FFFFFF
 *
 * @method normalizeColor
 * @param {string} colorInput - string like rgba(red, green, blue, alpha) or rgb(red, green, blue) or #fff or #ffffff
 * @return {string|boolean} HEX color, false - for transparent color
 */
exports.normalizeColor = function (colorInput) {
    var newcolor = ['#'], i;
    var color = exports.colorToHex(colorInput);
    if (!color) {
        return false;
    }
    color = exports.trim(color.toUpperCase());
    color = color.substr(1);
    if (color.length === 3) {
        for (i = 0; i < 3; i += 1) {
            newcolor.push(color[i]);
            newcolor.push(color[i]);
        }
        return newcolor.join('');
    }
    if (color.length > 6) {
        color = color.substr(0, 6);
    }
    return '#' + color;
};
/**
 * Normalize value to CSS meters
 * @method normalizeSize
 * @param {string|int} value Input string
 * @return {string}
 */
exports.normalizeSize = function (value) {
    if ((/^[0-9]+$/).test(value.toString())) {
        return value + 'px';
    }
    return value.toString();
};
exports.getContentWidth = function (element, win) {
    var pi = function (value) { return (parseInt(value, 10)); }, style = win.getComputedStyle(element), width = element.offsetWidth, paddingLeft = pi(style.getPropertyValue('padding-left') || '0'), paddingRight = pi(style.getPropertyValue('padding-right') || '0');
    return width - paddingLeft - paddingRight;
};
/**
 * CTRL pressed
 *
 * @param  {KeyboardEvent} e Event
 * @return {boolean} true ctrl key was pressed
 */
exports.ctrlKey = function (e) {
    if (navigator.userAgent.indexOf("Mac OS X") !== -1) {
        if (e.metaKey && !e.altKey) {
            return true;
        }
    }
    else if (e.ctrlKey && !e.altKey) {
        return true;
    }
    return false;
};
var formatUrl = function (url) {
    if (window.location.protocol === 'file:' && /^\/\//.test(url)) {
        url = 'https:' + url;
    }
    return url;
};
exports.appendScript = function (url, callback, className, doc) {
    if (className === void 0) { className = ''; }
    var script = doc.createElement('script');
    script.className = className;
    script.type = 'text/javascript';
    script.charset = 'utf-8';
    if (callback !== undefined) {
        script.addEventListener("load", callback, false);
    }
    script.src = formatUrl(url);
    doc.body.appendChild(script);
};
/**
 * Create DOM element from HTML text
 *
 * @param {string|HTMLElement} html
 * @param {HTMLDocument} [doc=document]
 *
 * @return HTMLElement
 */
exports.dom = function (html, doc) {
    if (html instanceof doc.defaultView.HTMLElement) {
        return html;
    }
    var div = doc.createElement('div');
    div.innerHTML = html;
    var child = (div.firstChild !== div.lastChild || !div.firstChild) ? div : div.firstChild;
    child.parentNode && child.parentNode.removeChild(child);
    return child;
};
/**
 * @param {string} hex
 * @method hexToRgb
 */
exports.hexToRgb = function (hex) {
    var shorthandRegex = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
    hex = hex.replace(shorthandRegex, function (m, r, g, b) {
        return r + r + g + g + b + b;
    });
    var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
    return result ? {
        r: parseInt(result[1], 16),
        g: parseInt(result[2], 16),
        b: parseInt(result[3], 16)
    } : null;
};
/**
 * Clear HTML
 *
 * @method clear
 * @param {string} value input string
 * @param {boolean} [removeEmptyBlocks] if true remove empty blocks
 * @return {string}
 */
exports.clear = function (value, removeEmptyBlocks) {
    if (removeEmptyBlocks === void 0) { removeEmptyBlocks = false; }
    value = exports.trim(value)
        .replace(consts.INVISIBLE_SPACE_REG_EXP, '')
        .replace(/[\s]*class=""/g, '');
    if (removeEmptyBlocks) {
        value = value.replace(/<p[^>]*>[\s\n\r\t]*(&nbsp;|<br>|<br\/>)?[\s\n\r\t]*<\/p>[\n\r]*/g, '');
    }
    return value;
};
// /**
//  * Convert all `<,>,",'` characters to HTML entities
//  *
//  * @method htmlentities
//  * @param {string} text
//  * @return {string}
//  */
// export const htmlentities = (text: string): string => {
//     return text.replace(/</gi, "&lt;")
//         .replace(/>/gi, "&gt;")
//         .replace(/"/gi, "&quot;")
//         .replace(/'/gi, "&apos;");
// };
/**
 * Check if a string is a url
 *
 * @method isURL
 * @param {string} str
 * @return {boolean}
 */
exports.isURL = function (str) {
    var pattern = new RegExp('^(https?:\\/\\/)' + // protocol
        '((([a-z\\d]([a-z\\d-]*[a-z\\d])*)\\.?)+[a-z]{2,}|' + // domain name
        '((\\d{1,3}\\.){3}\\d{1,3}))' + // OR ip (v4) address
        '(\\:\\d+)?(\\/[-a-z\\d%_.~+]*)*' + // port and path
        '(\\?[;&a-z\\d%_.~+=-]*)?' + // query string
        '(\\#[-a-z\\d_]*)?$', 'i'); // fragment locator
    return pattern.test(str);
};
exports.pathNormalize = function (path) { return (path.replace(/([^:])[\\\/]+/g, '$1/')); };
exports.urlNormalize = function (url) { return (url.replace(/([^:])[\\\/]+/g, '$1/')); };
/**
 * Check if a string is html or not
 *
 * @method isHTML
 * @param {string} str
 * @return {boolean}
 */
exports.isHTML = function (str) { return ((/<([A-Za-z][A-Za-z0-9]*)\b[^>]*>(.*?)<\/\1>/m).test(str)); };
/**
 * Detect if string is HTML from MS Word or Excel
 *
 * @param {string} data
 * @return {boolean}
 */
exports.isHTMLFromWord = function (data) {
    return data.search(/<meta.*?Microsoft Excel\s[\d].*?>/) !== -1 ||
        data.search(/<meta.*?Microsoft Word\s[\d].*?>/) !== -1 ||
        (data.search(/style="[^"]*mso-/) !== -1 && data.search(/<font/) !== -1);
};
/**
 * Converts from human readable file size (kb,mb,gb,tb) to bytes
 *
 * @method humanSizeToBytes
 * @param {string|int} human readable file size. Example 1gb or 11.2mb
 * @return {int}
 */
exports.humanSizeToBytes = function (human) {
    if (/^[0-9.]+$/.test(human.toString())) {
        return parseFloat(human);
    }
    var format = human.substr(-2, 2).toUpperCase(), formats = ["KB", "MB", "GB", "TB"], number = parseFloat(human.substr(0, human.length - 2));
    return formats.indexOf(format) !== -1 ? number * Math.pow(1024, formats.indexOf(format) + 1) : parseInt(human, 10);
};
/**
 * Parse query string
 *
 */
exports.parseQuery = function (queryString) {
    var query = {}, a = queryString.substr(1).split('&'), i, keyvalue;
    for (i = 0; i < a.length; i += 1) {
        keyvalue = a[i].split('=');
        query[decodeURIComponent(keyvalue[0])] = decodeURIComponent(keyvalue[1] || '');
    }
    return query;
};
/**
 *  Javascript url pattern converter replace youtube/vimeo url in embed code.
 *
 * @param {string} url
 * @param {int} [width=400]
 * @param {int} [height=345]
 * return {string} embed code
 */
exports.convertMediaURLToVideoEmbed = function (url, width, height) {
    if (width === void 0) { width = 400; }
    if (height === void 0) { height = 345; }
    if (!exports.isURL(url)) {
        return url;
    }
    var parser = document.createElement('a'), pattern1 = /(?:http?s?:\/\/)?(?:www\.)?(?:vimeo\.com)\/?(.+)/g;
    parser.href = url;
    if (!width) {
        width = 400;
    }
    if (!height) {
        height = 345;
    }
    switch (parser.hostname) {
        case 'www.vimeo.com':
        case 'vimeo.com':
            return pattern1.test(url) ? url.replace(pattern1, '<iframe width="' + width + '" height="' + height + '" src="//player.vimeo.com/video/$1" frameborder="0" allowfullscreen></iframe>') : url;
        case 'youtube.com':
        case 'www.youtube.com':
        case 'youtu.be':
        case 'www.youtu.be':
            var query = parser.search ? exports.parseQuery(parser.search) : { v: parser.pathname.substr(1) };
            return query.v ? '<iframe width="' + width + '" height="' + height + '" src="//www.youtube.com/embed/' + query.v + '" frameborder="0" allowfullscreen></iframe>' : url;
    }
    return url;
};
/**
 * Module returns method that is used to determine the browser
 * @params {Object} parent main Jodit object
 * @example
 * ```javascript
 * console.log(editor.helper.browser('mse'));
 * console.log(editor.helper.browser('chrome'));
 * console.log($editor.helper.browser('opera'));
 * console.log(editor.helper.browser('firefox'));
 * console.log(editor.helper.browser('mse') && editor.helper.browser('version') > 10);
 * ```
 */
exports.browser = function (browser) {
    var ua = navigator.userAgent.toLowerCase(), match = ((/(firefox)[\s\/]([\w.]+)/.exec(ua) || /(chrome)[\s\/]([\w.]+)/.exec(ua) || /(webkit)[\s\/]([\w.]+)/.exec(ua) || /(opera)(?:.*version)[\s\/]([\w.]+)/.exec(ua) || /(msie)[\s]([\w.]+)/.exec(ua) || /(trident)\/([\w.]+)/.exec(ua) || ua.indexOf("compatible") < 0)) || [];
    if (browser === 'version') {
        return match[2];
    }
    if (browser === 'webkit') {
        return (match[1] === 'chrome' || match[1] === 'webkit');
    }
    if (browser === 'ff') {
        return (match[1] === 'firefox');
    }
    if (browser === 'msie') {
        return (match[1] === 'trident' || match[1] === 'msie');
    }
    return match[1] === browser;
};
/**
 * Calc relative offset by start editor field
 *
 * @method offset
 * @param {HTMLElement} elm
 * @param {Jodit} jodit
 * @param {Document} doc
 * @param {boolean} recurse
 * @return {{top: number, left: number}} returns an object containing the properties top and left.
 */
exports.offset = function (elm, jodit, doc, recurse) {
    if (recurse === void 0) { recurse = false; }
    var rect = elm.getBoundingClientRect(), body = doc.body, docElem = doc.documentElement, win = doc.defaultView || doc.parentWindow, scrollTop = win.pageYOffset || docElem.scrollTop || body.scrollTop, scrollLeft = win.pageXOffset || docElem.scrollLeft || body.scrollLeft, clientTop = docElem.clientTop || body.clientTop || 0, clientLeft = docElem.clientLeft || body.clientLeft || 0;
    var topValue, leftValue;
    if (!recurse && jodit && jodit.options && jodit.options.iframe && jodit.iframe) {
        var _a = exports.offset(jodit.iframe, jodit, jodit.ownerDocument, true), top_1 = _a.top, left = _a.left;
        topValue = rect.top + top_1;
        leftValue = rect.left + left;
    }
    else {
        topValue = rect.top + scrollTop - clientTop;
        leftValue = rect.left + scrollLeft - clientLeft;
    }
    return {
        top: Math.round(topValue),
        left: Math.round(leftValue),
        width: rect.width,
        height: rect.height
    };
};
/**
 *
 * @param key
 * @return {string}
 */
exports.camelCase = function (key) {
    return key.replace(/([-_])(.)/g, function (m, code, letter) {
        return letter.toUpperCase();
    });
};
/**
 *
 * @param key
 * @return {string}
 */
exports.fromCamelCase = function (key) {
    return key.replace(/([A-Z]+)/g, function (m, letter) {
        return '-' + letter.toLowerCase();
    });
};
/**
 * Convert special characters to HTML entities
 *
 * @method htmlspecialchars
 * @param {string} html
 * @return {string}
 */
exports.htmlspecialchars = function (html) {
    var tmp = document.createElement('div');
    tmp.innerText = html;
    return tmp.innerHTML;
};
/**
 * Debouncing enforces that a function not be called again until a certain amount of time has passed without it being called. As in "execute this function only if 100 milliseconds have passed without it being called."
 *
 * @method debounce
 * @param {function} fn
 * @param {int} timeout
 * @param {boolean} [invokeAsap] - execute fn on first call without timeout
 * @param {context} [ctx] Context
 * @return {function}
 * @example
 * ```javascript
 * var jodit = new Jodit('.editor');
 * Jodit.modules.Dom("input").on('keydown', jodit.helper.debounce(function() {
 *     // Do expensive things
 * }, 100));
 * ```
 */
exports.debounce = function (fn, timeout, invokeAsap, ctx) {
    if (arguments.length === 3 && typeof invokeAsap !== 'boolean') {
        ctx = invokeAsap;
        invokeAsap = false;
    }
    var timer = 0;
    return function () {
        var args = arguments;
        ctx = ctx || this;
        if ((invokeAsap && !timer) || !timeout) {
            fn.apply(ctx, args);
        }
        if (timeout) {
            clearTimeout(timer);
            timer = window.setTimeout(function () {
                if (!invokeAsap) {
                    fn.apply(ctx, args);
                }
                timer = 0;
            }, timeout);
        }
    };
};
/**
 * Throttling enforces a maximum number of times a function can be called over time. As in "execute this function at most once every 100 milliseconds."
 *
 * @method throttle
 * @param {function} fn
 * @param {int} timeout
 * @param {context} [ctx] Context
 * @return {function}
 * @example
 * ```javascript
 * var jodit = new Jodit('.editor');
 * jodit.events.on(document.body, 'scroll', jodit.helper.throttle(function() {
 *     // Do expensive things
 * }, 100));
 * ```
 */
exports.throttle = function (fn, timeout, ctx) {
    var timer = null, args, needInvoke, callee;
    return function () {
        args = arguments;
        needInvoke = true;
        ctx = ctx || this;
        if (!timeout) {
            fn.apply(ctx, args);
            return;
        }
        if (!timer) {
            callee = function () {
                if (needInvoke) {
                    fn.apply(ctx, args);
                    needInvoke = false;
                    timer = setTimeout(callee, timeout);
                }
                else {
                    timer = null;
                }
            };
            callee();
        }
    };
};
exports.normilizeCSSValue = function (key, value) {
    switch (key) {
        case "font-weight":
            return value === 'bold' ? 700 : value;
    }
    return value;
};
/**
 * Get the value of a computed style property for the first element in the set of matched elements or set one or more CSS properties for every matched element
 * @param {HTMLElement} element
 * @param {string|object} key An object of property-value pairs to set. A CSS property name.
 * @param {string|int} value A value to set for the property.
 * @param {boolean} onlyStyleMode Get value from style attribute, without calculating
 */
exports.css = function (element, key, value, onlyStyleMode) {
    if (onlyStyleMode === void 0) { onlyStyleMode = false; }
    var numberFieldsReg = /^left|top|bottom|right|width|min|max|height|margin|padding|font-size/i;
    if (exports.isPlainObject(key) || value !== undefined) {
        var setValue = function (elm, _key, _value) {
            if (_value !== undefined && _value !== null && numberFieldsReg.test(_key) && /^[\-+]?[0-9.]+$/.test(_value.toString())) {
                _value = parseInt(_value.toString(), 10) + 'px';
            }
            if (_value !== undefined && exports.css(elm, _key, void (0), true) !== exports.normilizeCSSValue(_key, _value)) {
                elm.style[_key] = _value;
            }
        };
        if (exports.isPlainObject(key)) {
            var keys = Object.keys(key), j = void 0;
            for (j = 0; j < keys.length; j += 1) {
                setValue(element, exports.camelCase(keys[j]), key[keys[j]]);
            }
        }
        else {
            setValue(element, exports.camelCase(key), value);
        }
        return '';
    }
    var key2 = exports.fromCamelCase(key), doc = element.ownerDocument, win = doc ? doc.defaultView || doc.parentWindow : false;
    var currentValue = element.style[key];
    var result = (currentValue !== undefined && currentValue !== '') ? currentValue : ((win && !onlyStyleMode) ? win.getComputedStyle(element).getPropertyValue(key2) : '');
    if (numberFieldsReg.test(key) && /^[\-+]?[0-9.]+px$/.test(result.toString())) {
        result = parseInt(result, 10);
    }
    return exports.normilizeCSSValue(key, result);
};
/**
 * Always return Array
 * @param a
 * @return {Array<any>}
 */
exports.asArray = function (a) { return (Array.isArray(a) ? a : [a]); };
exports.splitArray = function (a) { return (typeof a === 'string' ? a.split(/[,\s]+/) : a); };
exports.sprintf = function () {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    var regex = /%%|%(\d+\$)?([-+#0 ]*)(\*\d+\$|\*|\d+)?(\.(\*\d+\$|\*|\d+))?([scboxXuidfegEG])/g;
    var a = args, i = 0, format = a[i++];
    var pad = function (str, len, chr, leftJustify) {
        var padding = (str.length >= len) ? '' : Array(1 + len - str.length >>> 0).join(chr);
        return leftJustify ? str + padding : padding + str;
    };
    // justify()
    var justify = function (value, prefix, leftJustify, minWidth, zeroPad) {
        var diff = minWidth - value.length;
        if (diff > 0) {
            if (leftJustify || !zeroPad) {
                value = pad(value, minWidth, ' ', leftJustify);
            }
            else {
                value = value.slice(0, prefix.length) + pad('', diff, '0', true) + value.slice(prefix.length);
            }
        }
        return value;
    };
    var formatBaseX = function (value, base, prefix, leftJustify, minWidth, precision, zeroPad) {
        var number = value >>> 0;
        prefix = prefix && number && { '2': '0b', '8': '0', '16': '0x' }[base] || '';
        var newValue = prefix + pad(number.toString(base), precision || 0, '0', false);
        return justify(newValue, prefix, leftJustify, minWidth, zeroPad);
    };
    var formatString = function (value, leftJustify, minWidth, precision, zeroPad) {
        if (precision != null) {
            value = value.slice(0, precision);
        }
        return justify(value, '', leftJustify, minWidth, zeroPad);
    };
    var doFormat = function (substring, valueIndex, flags, minWidth, _, precision, type) {
        if (substring == '%%')
            return '%';
        var leftJustify = false, positivePrefix = '', zeroPad = false, prefixBaseX = false;
        for (var j = 0; flags && j < flags.length; j++)
            switch (flags.charAt(j)) {
                case ' ':
                    positivePrefix = ' ';
                    break;
                case '+':
                    positivePrefix = '+';
                    break;
                case '-':
                    leftJustify = true;
                    break;
                case '0':
                    zeroPad = true;
                    break;
                case '#':
                    prefixBaseX = true;
                    break;
            }
        if (!minWidth) {
            minWidth = 0;
        }
        else if (minWidth === '*') {
            minWidth = +a[i++];
        }
        else if (minWidth.toString().charAt(0) === '*') {
            minWidth = +a[minWidth.toString().slice(1, -1)];
        }
        else {
            minWidth = +minWidth;
        }
        // Note: undocumented perl feature:
        if (minWidth < 0) {
            minWidth = -minWidth;
            leftJustify = true;
        }
        if (!isFinite(minWidth)) {
            throw new Error('sprintf: (minimum-)width must be finite');
        }
        if (!precision) {
            precision = 'fFeE'.indexOf(type) > -1 ? 6 : (type == 'd') ? 0 : void (0);
        }
        else if (precision === '*') {
            precision = +a[i++];
        }
        else if (precision[0] === '*') {
            precision = +a[precision.slice(1, -1)];
        }
        else {
            precision = +precision;
        }
        // grab value using valueIndex if required?
        var value = valueIndex ? a[valueIndex.slice(0, -1)] : a[i++];
        switch (type) {
            case 's': return formatString(String(value), leftJustify, minWidth, precision, zeroPad);
            case 'c': return formatString(String.fromCharCode(+value), leftJustify, minWidth, precision, zeroPad);
            case 'b': return formatBaseX(value, 2, prefixBaseX, leftJustify, minWidth, precision, zeroPad);
            case 'o': return formatBaseX(value, 8, prefixBaseX, leftJustify, minWidth, precision, zeroPad);
            case 'x': return formatBaseX(value, 16, prefixBaseX, leftJustify, minWidth, precision, zeroPad);
            case 'X': return formatBaseX(value, 16, prefixBaseX, leftJustify, minWidth, precision, zeroPad).toUpperCase();
            case 'u': return formatBaseX(value, 10, prefixBaseX, leftJustify, minWidth, precision, zeroPad);
            case 'i':
            case 'd': {
                var number = parseInt(value.toString(), 10);
                var prefix = number < 0 ? '-' : positivePrefix;
                value = prefix + pad(String(Math.abs(number)), precision, '0', false);
                return justify(value, prefix, leftJustify, minWidth, zeroPad);
            }
            case 'e':
            case 'E':
            case 'f':
            case 'F':
            case 'g':
            case 'G': {
                var number = +value;
                var prefix = number < 0 ? '-' : positivePrefix;
                var method = ['toExponential', 'toFixed', 'toPrecision']['efg'.indexOf(type.toLowerCase())];
                var textTransform = ['toString', 'toUpperCase']['eEfFgG'.indexOf(type) % 2];
                value = prefix + Math.abs(number)[method](precision);
                return justify(value, prefix, leftJustify, minWidth, zeroPad)[textTransform]();
            }
            default: return substring;
        }
    };
    return format.replace(regex, doFormat);
};
exports.val = function (elm, selector, value) {
    var child = elm.querySelector(selector);
    if (!child) {
        return '';
    }
    if (value) {
        child.value = value;
    }
    return child.value;
};
exports.defaultLanguage = function (language) { return ((language === 'auto' || language === undefined) ?
    document.documentElement.lang ||
        (navigator.language && navigator.language.substr(0, 2)) ||
        (navigator.browserLanguage ? navigator.browserLanguage.substr(0, 2) : false) ||
        'en' :
    language); };
exports.normalizeNode = function (node) {
    if (!node) {
        return;
    }
    if (node.nodeType === Node.TEXT_NODE && node.nodeValue !== null && node.parentNode) {
        while (node.nextSibling && node.nextSibling.nodeType === Node.TEXT_NODE) {
            if (node.nextSibling.nodeValue !== null) {
                node.nodeValue += node.nextSibling.nodeValue;
            }
            node.nodeValue = node.nodeValue.replace(consts.INVISIBLE_SPACE_REG_EXP, '');
            node.parentNode.removeChild(node.nextSibling);
        }
    }
    else {
        exports.normalizeNode(node.firstChild);
    }
    exports.normalizeNode(node.nextSibling);
};
/**
 * The method automatically cleans up content from Microsoft Word and other HTML sources to ensure clean, compliant content that matches the look and feel of the site.
 */
exports.cleanFromWord = function (html) {
    if (html.indexOf('<html ') !== -1) {
        html = html.substring(html.indexOf('<html '), html.length);
        html = html.substring(0, html.lastIndexOf('</html>') + '</html>'.length);
    }
    var convertedString = '';
    try {
        var div = document.createElement('div');
        div.innerHTML = html;
        var marks_1 = [];
        if (div.firstChild) {
            Dom_1.Dom.all(div, function (node) {
                switch (node.nodeType) {
                    case Node.ELEMENT_NODE:
                        if (node.nodeName === 'FONT') {
                            Dom_1.Dom.unwrap(node);
                        }
                        else {
                            [].slice.call(node.attributes).forEach(function (attr) {
                                if (['src', 'href', 'rel', 'content'].indexOf(attr.name.toLowerCase()) === -1) {
                                    node.removeAttribute(attr.name);
                                }
                            });
                        }
                        break;
                    case Node.TEXT_NODE:
                        break;
                    default:
                        marks_1.push(node);
                }
            });
        }
        marks_1.forEach(function (node) { return node.parentNode && node.parentNode.removeChild(node); });
        convertedString = div.innerHTML;
    }
    catch (e) {
    }
    if (convertedString) {
        html = convertedString;
    }
    return html.replace(/<(\/)?(html|colgroup|col|o:p)[^>]*>/g, '').replace(/<!--[^>]*>/g, '');
};
exports.applyStyles = function (html) {
    if (html.indexOf('<html ') === -1) {
        return html;
    }
    html = html.substring(html.indexOf('<html '), html.length);
    html = html.substring(0, html.lastIndexOf('</html>') + '</html>'.length);
    var iframe = document.createElement('iframe');
    iframe.style.display = 'none';
    document.body.appendChild(iframe);
    var convertedString = '', collection = [], rules = [];
    try {
        var iframeDoc = iframe.contentDocument || (iframe.contentWindow ? iframe.contentWindow.document : null);
        if (iframeDoc) {
            iframeDoc.open();
            iframeDoc.write(html);
            iframeDoc.close();
            if (iframeDoc.styleSheets.length) {
                rules = iframeDoc.styleSheets[iframeDoc.styleSheets.length - 1].cssRules;
            }
            var _loop_1 = function (idx) {
                if (rules[idx].selectorText === '') {
                    return "continue";
                }
                collection = exports.$$(rules[idx].selectorText, iframeDoc.body);
                collection.forEach(function (elm) {
                    elm.style.cssText += rules[idx].style.cssText
                        .replace(/mso-[a-z\-]+:[\s]*[^;]+;/g, '')
                        .replace(/border[a-z\-]*:[\s]*[^;]+;/g, '');
                });
            };
            for (var idx = 0; idx < rules.length; idx += 1) {
                _loop_1(idx);
            }
            convertedString = iframeDoc.firstChild ? iframeDoc.body.innerHTML : '';
        }
    }
    catch (e) {
    }
    finally {
        iframe.parentNode && iframe.parentNode.removeChild(iframe);
    }
    if (convertedString) {
        html = convertedString;
    }
    return html.replace(/<(\/)?(html|colgroup|col|o:p)[^>]*>/g, '').replace(/<!--[^>]*>/g, '');
};
exports.inView = function (elm, root, doc) {
    var rect = elm.getBoundingClientRect(), top = rect.top, height = rect.height, el = elm;
    do {
        if (el && el.parentNode) {
            el = el.parentNode;
            rect = el.getBoundingClientRect();
            if ((top <= rect.bottom) === false) {
                return false;
            }
            // Check if the element is out of view due to a container scrolling
            if ((top + height) <= rect.top) {
                return false;
            }
        }
    } while (el && el != root && el.parentNode);
    // Check its within the document viewport
    return top <= doc.documentElement.clientHeight;
};
exports.scrollIntoView = function (elm, root, doc) {
    if (!exports.inView(elm, root, doc)) {
        if (root.clientHeight !== root.scrollHeight) {
            root.scrollTop = elm.offsetTop;
        }
        if (!exports.inView(elm, root, doc)) {
            elm.scrollIntoView();
        }
    }
};
exports.getXPathByElement = function (element, root) {
    if (!element || element.nodeType != 1) {
        return '';
    }
    if (!element.parentNode || root === element) {
        return '';
    }
    if (element.id) {
        return "//*[@id='" + element.id + "']";
    }
    var sames = [].filter.call(element.parentNode.childNodes, function (x) { return x.nodeName === element.nodeName; });
    return exports.getXPathByElement(element.parentNode, root) + '/' + element.nodeName.toLowerCase() + (sames.length > 1 ? '[' + ([].indexOf.call(sames, element) + 1) + ']' : '');
};
var dataBindKey = 'JoditDataBindkey';
exports.dataBind = function (elm, key, value) {
    var store = elm[dataBindKey];
    if (!store) {
        store = {};
        Object.defineProperty(elm, dataBindKey, {
            enumerable: false,
            configurable: true,
            value: store
        });
    }
    if (value === undefined) {
        return store[key];
    }
    store[key] = value;
};
exports.isLicense = function (license) { return typeof license === 'string' && license.length === 32 && /^[a-z0-9]+$/.test(license); };
exports.normalizeLicense = function (license, count) {
    if (count === void 0) { count = 8; }
    var parts = [];
    while (license.length) {
        parts.push(license.substr(0, count));
        license = license.substr(count);
    }
    parts[1] = parts[1].replace(/./g, '*');
    parts[2] = parts[2].replace(/./g, '*');
    return parts.join('-');
};
var JoditArray = /** @class */ (function () {
    function JoditArray(data) {
        var _this = this;
        this.length = 0;
        exports.extend(true, this, data);
        this.length = data.length;
        var proto = Array.prototype;
        ['map', 'forEach', 'reduce', 'push', 'pop', 'shift', 'unshift', 'slice', 'splice'].forEach(function (method) {
            _this[method] = proto[method];
        });
    }
    JoditArray.prototype.toString = function () {
        var out = [];
        for (var i = 0; i < this.length; i += 1) {
            out[i] = this[i];
        }
        return out.toString();
    };
    return JoditArray;
}());
exports.JoditArray = JoditArray;
var JoditObject = /** @class */ (function () {
    function JoditObject(data) {
        exports.extend(true, this, data);
    }
    return JoditObject;
}());
exports.JoditObject = JoditObject;
exports.getRange = function () {
    var range = window.getSelection().getRangeAt(0);
    return [range.startContainer, range.startOffset, range.endContainer, range.endOffset];
};
exports.innerWidth = function (element, win) {
    var computedStyle = win.getComputedStyle(element);
    var elementWidth = element.clientWidth; // width with padding
    elementWidth -= parseFloat(computedStyle.paddingLeft || '0') + parseFloat(computedStyle.paddingRight || '0');
    return elementWidth;
};


/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var consts = __webpack_require__(2);
var Helpers_1 = __webpack_require__(0);
var Jodit_1 = __webpack_require__(6);
var Widget_1 = __webpack_require__(10);
var TabsWidget = Widget_1.Widget.TabsWidget;
var FileSelectorWidget = Widget_1.Widget.FileSelectorWidget;
var ToolbarCollection_1 = __webpack_require__(5);
var Dom_1 = __webpack_require__(3);
/**
 * Default Editor's Configuration
 **/
var Config = /** @class */ (function () {
    function Config() {
        this.license = '';
        this.preset = 'custom';
        this.presets = {
            inline: {
                inline: true,
                toolbar: false,
                toolbarInline: true,
                popup: {
                    selection: [
                        'bold',
                        'underline',
                        'italic',
                        'ul',
                        'ol',
                        'outdent',
                        'indent', '\n',
                        'fontsize',
                        'brush',
                        'paragraph',
                        'link',
                        'align',
                        'cut',
                        'dots',
                    ]
                },
                showXPathInStatusbar: false,
                showCharsCounter: false,
                showWordsCounter: false,
                showPlaceholder: false
            }
        };
        this.ownerDocument = document;
        this.ownerWindow = window;
        /**
         * z-index For editor
         */
        this.zIndex = 0;
        /**
         * Change the read-only state of the editor
         * @type {boolean}
         */
        this.readonly = false;
        this.activeButtonsInReadOnly = ['source', 'fullsize', 'print', 'about', 'dots', 'selectall'];
        /**
         * For example, in Joomla, the top menu bar closes Jodit toolbar when scrolling. Therefore, it is necessary to move the toolbar Jodit by this amount [more](http://xdsoft.net/jodit/doc/#2.5.57)
         */
        // offsetTopForAssix: number = 0;
        /**
         * Size of icons in the toolbar (can be "small", "middle", "large")
         *
         * @example
         * ```javascript
         * var editor  = new  Jodit(".dark_editor", {
         *      toolbarButtonSize: "small"
         * });
         * ```
         */
        this.toolbarButtonSize = 'middle';
        /**
         * Inline editing mode
         *
         * @type {boolean}
         */
        this.inline = false;
        /**
         * Theme (can be "dark")
         * @example
         * ```javascript
         * var editor  = new  Jodit(".dark_editor", {
         *      theme: "dark"
         * });
         * ```
         */
        this.theme = 'default';
        /**
         * if set true then the current mode is saved in a cookie , and is restored after a reload of the page
         */
        this.saveModeInStorage = false;
        /**
         * if set true and height !== auto then after reload editor will be have latest height
         */
        this.saveHeightInStorage = false;
        /**
         * Options specifies whether the editor is to have its spelling and grammar checked or not
         * @see {@link http://www.w3schools.com/tags/att_global_spellcheck.asp}
         */
        this.spellcheck = true;
        /**
         * Class name that can be appended to the editor
         *
         * @see {@link Jodit.defaultOptions.iframeCSSLinks|iframeCSSLinks}
         * @see {@link Jodit.defaultOptions.iframeStyle|iframeStyle}
         *
         * @example
         * ```javascript
         * new Jodit('#editor', {
         *    editorCssClass: 'some_my_class'
         * });
         * ```
         * ```html
         * <style>
         * .some_my_class p{
         *    line-height: 16px;
         * }
         * </style>
         * ```
         */
        this.editorCssClass = false;
        /**
         * After all changes in editors for textarea will call change trigger
         *
         * @example
         *  ```javascript
         * var editor = new Jodit('#editor');
         * document.getElementById('editor').addEventListener('change', function () {
         *      console.log(this.value);
         * })
         * ```
         */
        this.triggerChangeEvent = true;
        /**
         * Editor's width
         *
         * @example
         * ```javascript
         * new Jodit('.editor', {
         *    width: '100%',
         * })
         * ```
         * @example
         * ```javascript
         * new Jodit('.editor', {
         *    width: 600, // equivalent for '600px'
         * })
         * ```
         * @example
         * ```javascript
         * new Jodit('.editor', {
         *    width: 'auto', // autosize
         * })
         * ```
         */
        this.width = 'auto';
        this.minWidth = '200px';
        this.maxWidth = '100%';
        /**
         * Editor's height
         *
         * @example
         * ```javascript
         * new Jodit('.editor', {
         *    height: '100%',
         * })
         * ```
         * @example
         * ```javascript
         * new Jodit('.editor', {
         *    height: 600, // equivalent for '600px'
         * })
         * ```
         * @example
         * ```javascript
         * new Jodit('.editor', {
         *    height: 'auto', // default - autosize
         * })
         * ```
         */
        this.height = 'auto';
        /**
         * Editor's min-height
         *
         * @example
         * ```javascript
         * new Jodit('.editor', {
         *    minHeight: '30%' //min-height: 30%
         * })
         * ```
         * @example
         * ```javascript
         * new Jodit('.editor', {
         *    minHeight: 200 //min-height: 200px
         * })
         * ```
         */
        this.minHeight = 200;
        /**
         * The writing direction of the language which is used to create editor content. Allowed values are: '' (an empty string) – Indicates that content direction will be the same as either the editor UI direction or the page element direction. 'ltr' – Indicates a Left-To-Right text direction (like in English). 'rtl' – Indicates a Right-To-Left text direction (like in Arabic).
         * @example
         * ```javascript
         * new Jodit('.editor', {
         *    direction: 'rtl'
         * })
         * ```
         */
        this.direction = '';
        /**
         * Language by default. if `auto` language set by document.documentElement.lang || (navigator.language && navigator.language.substr(0, 2)) || (navigator.browserLanguage && navigator.browserLanguage.substr(0, 2)) || 'en'
    
         * @example
         * ```html
         * <!-- include in you page lang file -->
         * <script src="jodit/lang/de.js"></script>
         * <script>
         * var editor = new Jodit('.editor', {
         *    language: 'de'
         * });
         * </script>
         * ```
         */
        this.language = 'auto';
        /**
         * if true all Lang.i18n(key) return `{key}`
         *
         * @example
         * ```html
         * <script>
         * var editor = new Jodit('.editor', {
         *    debugLanguage: true
         * });
         *
         * console.log(editor.i18n("Test")); // {Test}
         * </script>
         * ```
         */
        this.debugLanguage = false;
        /**
         * Collection of language pack data {en: {'Type something': 'Type something', ...}}
         *
         * @example
         * ```javascript
         * var editor = new Jodit('#editor', {
         *     language: 'ru',
         *     i18n: {
         *         ru: {
         *            'Type something': 'Начните что-либо вводить'
         *         }
         *     }
         * });
         * console.log(editor.i18n('Type something')) //Начните что-либо вводить
         * ```
         */
        this.i18n = 'en';
        /**
         * The tabindex global attribute is an integer indicating if the element can take input focus (is focusable), if it should participate to sequential keyboard navigation, and if so, at what position. It can take several values
         */
        this.tabIndex = -1;
        /**
         * Show toolbar
         */
        this.toolbar = true;
        /**
         * Show tooltip after mouse enter on the button
         */
        this.showTooltip = true;
        /**
         * Delay before show tooltip
         */
        this.showTooltipDelay = 500;
        /**
         * Instead of create custop tooltip - use native title tooltips
         * @type {boolean}
         */
        this.useNativeTooltip = false;
        // TODO
        // autosave: false, // false or url
        // autosaveCallback: false, // function
        // interval: 60, // seconds
        // TODO
        /**
         * Element that will be created when you press Enter
         */
        this.enter = consts.PARAGRAPH;
        /**
         * Jodit.MODE_WYSIWYG The HTML editor allows you to write like MSWord, Jodit.MODE_AREA syntax highlighting source editor
         * @example
         * ```javascript
         * var editor = new Jodit('#editor', {
         *     defaultMode: Jodit.MODE_SPLIT
         * });
         * console.log(editor.getRealMode())
         * ```
         */
        this.defaultMode = consts.MODE_WYSIWYG;
        /**
         * Use split mode
         *
         * @type {boolean}
         */
        this.useSplitMode = false;
        /**
         * The colors in HEX representation to select a color for the background and for the text in colorpicker
         * @example
         * ```javascript
         *  new Jodit('#editor', {
         *     colors: ['#ff0000', '#00ff00', '#0000ff']
         * })
         * ```
         */
        this.colors = {
            greyscale: ['#000000', '#434343', '#666666', '#999999', '#B7B7B7', '#CCCCCC', '#D9D9D9', '#EFEFEF', '#F3F3F3', '#FFFFFF'],
            palette: ['#980000', '#FF0000', '#FF9900', '#FFFF00', '#00F0F0', '#00FFFF', '#4A86E8', '#0000FF', '#9900FF', '#FF00FF'],
            full: [
                '#E6B8AF', '#F4CCCC', '#FCE5CD', '#FFF2CC', '#D9EAD3', '#D0E0E3', '#C9DAF8', '#CFE2F3', '#D9D2E9', '#EAD1DC',
                '#DD7E6B', '#EA9999', '#F9CB9C', '#FFE599', '#B6D7A8', '#A2C4C9', '#A4C2F4', '#9FC5E8', '#B4A7D6', '#D5A6BD',
                '#CC4125', '#E06666', '#F6B26B', '#FFD966', '#93C47D', '#76A5AF', '#6D9EEB', '#6FA8DC', '#8E7CC3', '#C27BA0',
                '#A61C00', '#CC0000', '#E69138', '#F1C232', '#6AA84F', '#45818E', '#3C78D8', '#3D85C6', '#674EA7', '#A64D79',
                '#85200C', '#990000', '#B45F06', '#BF9000', '#38761D', '#134F5C', '#1155CC', '#0B5394', '#351C75', '#733554',
                '#5B0F00', '#660000', '#783F04', '#7F6000', '#274E13', '#0C343D', '#1C4587', '#073763', '#20124D', '#4C1130'
            ]
        };
        /**
         * The default tab color picker
         * @example
         * ```javascript
         *  new Jodit('#editor2', {
         *     colorPickerDefaultTab: 'color'
         * })
         * ```
         */
        this.colorPickerDefaultTab = 'background';
        /**
         * Image size defaults to a larger image
         */
        this.imageDefaultWidth = 300;
        /**
         * Do not display these buttons that are on the list
         * @example
         * ```javascript
         * new Jodit('#editor2', {
         *     removeButtons: ['hr', 'source']
         * });
         * ```
         */
        this.removeButtons = [];
        /**
         * Do not init these plugins
         * @example
         * ```typescript
         * var editor = new Jodit('.editor', {
         *    disablePlugins: 'table,iframe'
         * });
         * //or
         * var editor = new Jodit('.editor', {
         *    disablePlugins: ['table', 'iframe']
         * });
         * ```
         */
        this.disablePlugins = [];
        /**
         * This buttons list will be added to option.buttons
         */
        this.extraButtons = [];
        /**
         * The width of the editor, accepted as the biggest. Used to the responsive version of the editor
         */
        this.sizeLG = 900;
        /**
         * The width of the editor, accepted as the medium. Used to the responsive version of the editor
         */
        this.sizeMD = 700;
        /**
         * The width of the editor, accepted as the small. Used to the responsive version of the editor
         */
        this.sizeSM = 400;
        /**
         * The list of buttons that appear in the editor's toolbar on large places (≥ options.sizeLG). Note - this is not the width of the device, the width of the editor
         * @example
         * ```javascript
         * new Jodit('#editor', {
         *     buttons: ['bold', 'italic', 'source'],
         *     buttonsMD: ['bold', 'italic'],
         *     buttonsXS: ['bold', 'fullsize'],
         * });
         * ```
         * @example
         * ```javascript
         * new Jodit('#editor2', {
         *     buttons: [{
         *         name: 'enty',
         *         icon: 'source',
         *         exec: function () {
         *             var dialog = new Jodit.modules.Dialog(this),
         *                 div = document.createElement('div'),
         *                 text = document.createElement('textarea');
         *             div.innerText = this.val();
         *             dialog.setTitle('Source code');
         *             dialog.setContent(text);
         *             dialog.setSize(400, 300);
         *             dom(text)
         *                 .css({
         *                     width: '100%',
         *                     height: '100%'
         *                 })
         *                 .val(div.innerHTML.replace(/<br>/g, '\n'));
         *             dialog.{@link module:Dialog~open|open}();
         *         }
         *     }]
         * });
         * ```
         * @example
         * ```javascript
         * new Jodit('#editor2', {
         *     buttons: Jodit.defaultOptions.buttons.concat([{
         *        name: 'listsss',
         *        iconURL: 'stuf/dummy.png',
         *        list: {
         *            h1: 'insert Header 1',
         *            h2: 'insert Header 2',
         *            clear: 'Empty editor',
         *        },
         *        exec: ({originalEvent, control, btn}) => {
         *             var key = control.args[0],
         *                value = control.args[1];
         *             if (key === 'clear') {
         *                 this.val('');
         *                 return;
         *             }
         *             this.selection.insertNode(Jodit.modules.Dom.create(key, ''));
         *             this.events.fire('errorMessage', 'Was inserted ' + value);
         *        },
         *        template: function (key, value) {
         *            return '<div>' + value + '</div>';
         *        }
         *  });
         *  ```
         */
        this.buttons = [
            'source', '|',
            'bold',
            'strikethrough',
            'underline',
            'italic', '|',
            'superscript',
            'subscript', '|',
            'ul',
            'ol', '|',
            'outdent', 'indent', '|',
            'font',
            'fontsize',
            'brush',
            'paragraph', '|',
            'image',
            'file',
            'video',
            'table',
            'link', '|',
            'align', 'undo', 'redo', '\n',
            'cut',
            'hr',
            'eraser',
            'copyformat', '|',
            'symbol',
            'fullsize',
            'selectall',
            'print',
            'about'
        ];
        /**
         * The list of buttons that appear in the editor's toolbar on medium places (≥ options.sizeMD).
         */
        this.buttonsMD = [
            'source', '|',
            'bold',
            'italic', '|',
            'ul',
            'ol', '|',
            'font',
            'fontsize',
            'brush',
            'paragraph', '|',
            'image',
            'table',
            'link', '|',
            'align', '|',
            'undo', 'redo', '|',
            'hr',
            'eraser',
            'copyformat',
            'fullsize',
            'dots'
        ];
        /**
         * The list of buttons that appear in the editor's toolbar on small places (≥ options.sizeSM).
         */
        this.buttonsSM = [
            'source', '|',
            'bold',
            'italic', '|',
            'ul',
            'ol', '|',
            'fontsize',
            'brush',
            'paragraph', '|',
            'image',
            'table',
            'link', '|',
            'align', '|',
            'undo', 'redo', '|',
            'eraser',
            'copyformat',
            'fullsize',
            'dots'
        ];
        /**
         * The list of buttons that appear in the editor's toolbar on extra small places (< options.sizeSM).
         */
        this.buttonsXS = [
            'bold',
            'image', '|',
            'brush',
            'paragraph', '|',
            'align', '|',
            'undo', 'redo', '|',
            'eraser',
            'dots'
        ];
        this.events = {};
        /**
         * Buttons in toolbat without SVG - only texts
         * @type {boolean}
         */
        this.textIcons = false;
    }
    return Config;
}());
exports.Config = Config;
exports.OptionsDefault = function (options) {
    var _this = this;
    var self = this;
    self.plainOptions = options;
    if (options !== undefined && typeof options === 'object') {
        var extendKey_1 = function (options, key) {
            if (key === 'preset') {
                if (Jodit_1.Jodit.defaultOptions.presets[options.preset] !== undefined) {
                    var preset = Jodit_1.Jodit.defaultOptions.presets[options.preset];
                    Object.keys(preset).forEach(extendKey_1.bind(_this, preset));
                }
            }
            if (typeof Jodit_1.Jodit.defaultOptions[key] === 'object' &&
                !Array.isArray(Jodit_1.Jodit.defaultOptions[key])) {
                self[key] = Helpers_1.extend(true, {}, Jodit_1.Jodit.defaultOptions[key], options[key]);
            }
            else {
                self[key] = options[key];
            }
        };
        Object.keys(options)
            .forEach(extendKey_1.bind(this, options));
    }
};
Config.prototype.controls = {
    print: {
        exec: function (editor) {
            var mywindow = window.open('', 'PRINT');
            if (mywindow) {
                if (editor.options.iframe) {
                    /**
                     * @event generateDocumentStructure.iframe
                     * @property {Document} doc Iframe document
                     */
                    editor.events.fire('generateDocumentStructure.iframe', mywindow.document);
                    mywindow.document.body.innerHTML = editor.getEditorValue();
                }
                else {
                    mywindow.document.write("<!doctype html><html><head><title></title></head><body>" + editor.getEditorValue() + "</body></html>");
                    mywindow.document.close();
                }
                mywindow.focus();
                mywindow.print();
                mywindow.close();
            }
        },
        mode: consts.MODE_SOURCE + consts.MODE_WYSIWYG
    },
    about: {
        exec: function (editor) {
            var dialog = editor.getInstance('Dialog');
            dialog.setTitle(editor.i18n('About Jodit'));
            dialog.setContent('<div class="jodit_about">\
                    <div>' +
                editor.i18n('Jodit Editor') + ' v.' + editor.getVersion() + ' ' +
                '</div>' +
                '<div>' +
                editor.i18n('License: %s', !Helpers_1.isLicense(editor.options.license) ? editor.i18n('GNU General Public License, version 2 or later') : Helpers_1.normalizeLicense(editor.options.license)) +
                '</div>' +
                '<div>' +
                '<a href="https://xdsoft.net/jodit/" target="_blank">http://xdsoft.net/jodit/</a>' +
                '</div>' +
                '<div>' +
                '<a href="https://xdsoft.net/jodit/doc/" target="_blank">' + editor.i18n('Jodit User\'s Guide') + '</a> ' +
                editor.i18n('contains detailed help for using') +
                '</div>' +
                // '<div>' +
                //     editor.i18n('For information about the license, please go to our website:') +
                // '</div>' +
                // '<div>' +
                //     '<a href="https://xdsoft.net/jodit/license.html" target="_blank">http://xdsoft.net/jodit/license.html</a>' +
                // '</div>' +
                // (isLicense(editor.options.license) ? '' :
                // '<div>' +
                //     '<a href="https://xdsoft.net/jodit/buy.html" target="_blank">' + editor.i18n('Buy full version') + '</a>' +
                // '</div>'
                //) +
                '<div>' +
                editor.i18n('Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.') +
                '</div>' +
                '</div>');
            dialog.open();
        },
        tooltip: 'About Jodit',
        mode: consts.MODE_SOURCE + consts.MODE_WYSIWYG
    },
    hr: {
        command: 'insertHorizontalRule',
        tags: ["hr"],
        tooltip: "Insert Horizontal Line"
    },
    image: {
        popup: function (editor, current, self, close) {
            var sourceImage = null;
            if (current && current.nodeType !== Node.TEXT_NODE && (current.tagName === 'IMG' || Helpers_1.$$('img', current).length)) {
                sourceImage = current.tagName === 'IMG' ? current : Helpers_1.$$('img', current)[0];
            }
            return FileSelectorWidget(editor, {
                filebrowser: function (data) {
                    if (data.files && data.files.length) {
                        var i = void 0;
                        for (i = 0; i < data.files.length; i += 1) {
                            editor.selection.insertImage(data.baseurl + data.files[i]);
                        }
                    }
                    close();
                },
                upload: function (data) {
                    var i;
                    if (data.files && data.files.length) {
                        for (i = 0; i < data.files.length; i += 1) {
                            editor.selection.insertImage(data.baseurl + data.files[i]);
                        }
                    }
                    close();
                },
                url: function (url, text) {
                    var image = sourceImage || Helpers_1.dom('<img src=""/>', editor.editorDocument);
                    image.setAttribute('src', url);
                    image.setAttribute('alt', text);
                    if (!sourceImage) {
                        editor.selection.insertImage(image);
                    }
                    close();
                }
            }, sourceImage, close);
        },
        tags: ["img"],
        tooltip: "Insert Image"
    },
    file: {
        popup: function (editor, current, self, close) {
            var insert = function (url, title) {
                if (title === void 0) { title = ''; }
                editor.selection.insertNode(Helpers_1.dom('<a href="' + url + '" title="' + title + '">' + (title || url) + '</a>', editor.editorDocument));
            };
            var sourceAnchor = null;
            if (current && (current.nodeName === 'A' || Dom_1.Dom.closest(current, 'A', editor.editor))) {
                sourceAnchor = current.nodeName === 'A' ? current : Dom_1.Dom.closest(current, 'A', editor.editor);
            }
            return FileSelectorWidget(editor, {
                filebrowser: function (data) {
                    if (data.files && data.files.length) {
                        var i = void 0;
                        for (i = 0; i < data.files.length; i += 1) {
                            insert(data.baseurl + data.files[i]);
                        }
                    }
                    close();
                },
                upload: function (data) {
                    var i;
                    if (data.files && data.files.length) {
                        for (i = 0; i < data.files.length; i += 1) {
                            insert(data.baseurl + data.files[i]);
                        }
                    }
                    close();
                },
                url: function (url, text) {
                    if (sourceAnchor) {
                        sourceAnchor.setAttribute('href', url);
                        sourceAnchor.setAttribute('title', text);
                    }
                    else {
                        insert(url, text);
                    }
                    close();
                }
            }, sourceAnchor, close, false);
        },
        tags: ["a"],
        tooltip: "Insert file"
    },
    video: {
        popup: function (editor, current, control, close) {
            var bylink = Helpers_1.dom("<form class=\"jodit_form\">\n                        <input required name=\"code\" placeholder=\"http://\" type=\"url\"/>\n                        <button type=\"submit\">" + editor.i18n('Insert') + "</button>\n                        </form>", editor.ownerDocument), bycode = Helpers_1.dom("<form class=\"jodit_form\">\n                        <textarea required name=\"code\" placeholder=\"" + editor.i18n('Embed code') + "\"></textarea>\n                        <button type=\"submit\">" + editor.i18n('Insert') + "</button>\n                        </form>", editor.ownerDocument), tab = {}, selinfo = editor.selection.save(), insertCode = function (code) {
                editor.selection.restore(selinfo);
                editor.selection.insertHTML(code);
                close();
            };
            if (editor.options.textIcons) {
                tab[editor.i18n('Link')] = bylink;
                tab[editor.i18n('Code')] = bycode;
            }
            else {
                tab[ToolbarCollection_1.ToolbarIcon.getIcon('link') + '&nbsp;' + editor.i18n('Link')] = bylink;
                tab[ToolbarCollection_1.ToolbarIcon.getIcon('source') + '&nbsp;' + editor.i18n('Code')] = bycode;
            }
            bycode.addEventListener('submit', function (event) {
                event.preventDefault();
                if (!Helpers_1.trim(Helpers_1.val(bycode, 'textarea[name=code]'))) {
                    bycode.querySelector('textarea[name=code]').focus();
                    bycode.querySelector('textarea[name=code]').classList.add('jodit_error');
                    return false;
                }
                insertCode(Helpers_1.val(bycode, 'textarea[name=code]'));
                return false;
            });
            bylink.addEventListener('submit', function (event) {
                event.preventDefault();
                if (!Helpers_1.isURL(Helpers_1.val(bylink, 'input[name=code]'))) {
                    bylink.querySelector('input[name=code]').focus();
                    bylink.querySelector('input[name=code]').classList.add('jodit_error');
                    return false;
                }
                insertCode(Helpers_1.convertMediaURLToVideoEmbed(Helpers_1.val(bylink, 'input[name=code]')));
                return false;
            });
            return TabsWidget(editor, tab);
        },
        tags: ["iframe"],
        tooltip: "Insert youtube/vimeo video"
    }
};


/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.INVISIBLE_SPACE = "\uFEFF";
exports.INVISIBLE_SPACE_REG_EXP = /[\uFEFF]/g;
exports.INVISIBLE_SPACE_REG_EXP_END = /[\uFEFF]+$/g;
exports.INVISIBLE_SPACE_REG_EXP_START = /^[\uFEFF]+/g;
exports.SPACE_REG_EXP = /[\s\n\t\r\uFEFF\u200b]+/g;
exports.SPACE_REG_EXP_START = /^[\s\n\t\r\uFEFF\u200b]+/g;
exports.SPACE_REG_EXP_END = /[\s\n\t\r\uFEFF\u200b]+$/g;
exports.IS_BLOCK = /^(PRE|DIV|P|LI|H[1-6]|BLOCKQUOTE|TD|TH|TABLE|BODY|HTML|FIGCAPTION|FIGURE)$/i;
exports.IS_INLINE = /^(STRONG|SPAN|I|EM|B|SUP|SUB)$/;
exports.KEY_BACKSPACE = 8;
exports.KEY_TAB = 9;
exports.KEY_ENTER = 13;
exports.KEY_ESC = 27;
exports.KEY_LEFT = 37;
exports.KEY_UP = 38;
exports.KEY_RIGHT = 39;
exports.KEY_DOWN = 40;
exports.KEY_DELETE = 46;
exports.KEY_F = 70;
exports.KEY_R = 82;
exports.KEY_H = 72;
exports.KEY_Y = 89;
exports.KEY_V = 86;
exports.KEY_Z = 90;
exports.KEY_F3 = 114;
// export const KEY_CTRL       = 17;
exports.NEARBY = 5;
exports.ACCURACY = 10;
// Jodit.keys = {
//     CTRL:       17,
//     TAB:        9,
//     ENTER:      13,
//     BACKSPACE:  8,
//     LEFT:       37,
//     TOP:        38,
//     RIGHT:      39,
//     BOTTOM:     40,
//     Z:          90,
//     Y:          89
// };
exports.BR = 'br';
exports.PARAGRAPH = 'P';
/**
 * @property {int} MODE_WYSIWYG=1 WYSIWYG editor mode
 */
exports.MODE_WYSIWYG = 1;
/**
 * @property {int} MODE_SOURCE=2 html editor mode
 */
exports.MODE_SOURCE = 2;
/**
 * @property {int} MODE_SPLIT=3  Source code editor and HTML editor both like {@link http://getuikit.com/docs/htmleditor.html|this}
 */
exports.MODE_SPLIT = 3;
/**
 * @property {string} TEXT_PLAIN='text/plain'  For IE11 it will be 'text'. Need for dataTransfer.setData
 */
exports.URL_LIST = navigator.userAgent.indexOf("MSIE") != -1 || /rv:11.0/i.test(navigator.userAgent) ? 'url' : 'text/uri-list';
exports.TEXT_PLAIN = navigator.userAgent.indexOf("MSIE") != -1 || /rv:11.0/i.test(navigator.userAgent) ? 'text' : 'text/plain';
exports.TEXT_HTML = navigator.userAgent.indexOf("MSIE") != -1 || /rv:11.0/i.test(navigator.userAgent) ? 'text' : 'text/html';
exports.MARKER_CLASS = 'jodit_selection_marker';
exports.EMULATE_DBLCLICK_TIMEOUT = 300;
exports.JODIT_SELECTED_CELL_MARKER = 'data-jodit-selected-cell';
exports.INSERT_AS_HTML = 'insert_as_html';
exports.INSERT_CLEAR_HTML = 'insert_clear_html';
exports.INSERT_AS_TEXT = 'insert_as_text';
exports.INSERT_ONLY_TEXT = 'insert_only_text';


/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var consts = __webpack_require__(2);
var Helpers_1 = __webpack_require__(0);
var Dom = /** @class */ (function () {
    function Dom() {
    }
    /**
     * Remove all connetn form element
     *
     * @param {Node} node
     */
    Dom.detach = function (node) {
        while (node.firstChild) {
            node.removeChild(node.firstChild);
        }
    };
    /**
     *
     * @param node
     */
    Dom.unwrap = function (node) {
        var parent = node.parentNode, el = node;
        if (parent) {
            while (el.firstChild) {
                parent.insertBefore(el.firstChild, el);
            }
            parent.removeChild(el);
        }
    };
    /**
     * It goes through all the internal elements of the node , causing a callback function
     *
     * @param  {HTMLElement} elm elements , the internal node is necessary to sort out
     * @param  {Function} callback It called for each item found
     * @example
     * ```javascript
     * Jodit.modules.Dom.each(parent.selection.current(), function (node) {
     *  if (node.nodeType === Node.TEXT_NODE) {
     *      node.nodeValue = node.nodeValue.replace(Jodit.INVISIBLE_SPACE_REG_EX, '') // remove all of the text element codes invisible character
     *  }
     * });
     * ```
     */
    Dom.each = function (elm, callback) {
        var node = elm.firstChild;
        if (node) {
            while (node) {
                if (callback.call(node, node) === false || Dom.each(node, callback) === false) {
                    return false;
                }
                node = Dom.next(node, function (node) { return (!!node); }, elm);
            }
        }
        return true;
    };
    /**
     * Create new element
     *
     * @method create
     * @param  {string} nodeName Can be `div`, `span` or `text`
     * @param  {string} content Content for new element
     * @param  {Document} doc
     * @return {HTMLElement|Text}
     * @example
     * ```javascript
     * var textnode = parent.node.create('text', 'Hello world');
     * var div = parent.node.create('div', '<img src="test.jpg">');
     * ```
     * @deprecated
     */
    Dom.create = function (nodeName, content, doc) {
        var newnode;
        nodeName = nodeName.toLowerCase();
        if (nodeName === 'text') {
            newnode = doc.createTextNode(typeof content === 'string' ? content : '');
        }
        else {
            newnode = doc.createElement(nodeName);
            if (content !== undefined) {
                newnode.innerHTML = content;
            }
        }
        return newnode;
    };
    /**
     * Replace one tag to another transfer content
     *
     * @param  {Node} elm The element that needs to be replaced by new
     * @param  {string} newTagName tag name for which will change `elm`
     * @param  {boolean} withAttributes=false If true move tag's attributes
     * @param  {boolean} notMoveContent=false false - Move content from elm to newTagName
     * @param  {Document} [doc=document]
     * @return {Node} Returns a new tag
     * @example
     * ```javascript
     * Jodit.modules.Dom.replace(parent.editor.getElementsByTagName('span')[0], 'p'); // Replace the first <span> element to the < p >
     * ```
     */
    Dom.replace = function (elm, newTagName, withAttributes, notMoveContent, doc) {
        if (withAttributes === void 0) { withAttributes = false; }
        if (notMoveContent === void 0) { notMoveContent = false; }
        var tag = typeof newTagName === 'string' ? doc.createElement(newTagName) : newTagName;
        if (!notMoveContent) {
            while (elm.firstChild) {
                tag.appendChild(elm.firstChild);
            }
        }
        if (withAttributes) {
            Helpers_1.each(elm.attributes, function (i, attr) {
                tag.setAttribute(attr.name, attr.nodeValue);
            });
        }
        if (elm.parentNode) {
            elm.parentNode.replaceChild(tag, elm);
        }
        return tag;
    };
    /**
     *  Check if element is table cell
     *
     * @param {Node} elm
     * @param {Window} win
     * @return {boolean}
     */
    Dom.isCell = function (elm, win) {
        return Dom.isNode(elm, win) && /^(td|th)$/i.test(elm.nodeName);
    };
    /**
     * Check is element is Image element
     *
     * @param {Node} elm
     * @param {Window} win
     * @return {boolean}
     */
    Dom.isImage = function (elm, win) {
        return Dom.isNode(elm, win) && /^(img|svg|picture|canvas)$/i.test(elm.nodeName);
    };
    /**
     * Check the `node` is a block element
     *
     * @param node
     * @return {boolean}
     */
    Dom.isBlock = function (node) {
        return (!!node && typeof node.nodeName === 'string' && consts.IS_BLOCK.test(node.nodeName));
    };
    Dom.isInlineBlock = function (node) {
        return !!node && node.nodeType === Node.ELEMENT_NODE && ['inline', 'inline-block'].indexOf(Helpers_1.css(node, 'display').toString()) !== -1;
    };
    /**
     * It's block and it can be split
     *
     */
    Dom.canSplitBlock = function (node, win) {
        return node && node instanceof win.HTMLElement &&
            this.isBlock(node) &&
            !/^(TD|TH|CAPTION|FORM)$/.test(node.nodeName) &&
            node.style !== void (0) && !/^(fixed|absolute)/i.test(node.style.position);
    };
    /**
     * Find previous node
     *
     * @param {Node} node
     * @param {function} condition
     * @param {Node} root
     * @param {boolean} [withChild=true]
     *
     * @return {boolean|Node|HTMLElement|HTMLTableCellElement} false if not found
     */
    Dom.prev = function (node, condition, root, withChild) {
        if (withChild === void 0) { withChild = true; }
        return Dom.find(node, condition, root, false, 'previousSibling', withChild ? 'lastChild' : false);
    };
    /**
     * Find next node what `condition(next) === true`
     *
     * @param {Node} node
     * @param {function} condition
     * @param {Node} root
     * @param {boolean} [withChild=true]
     * @return {boolean|Node|HTMLElement|HTMLTableCellElement}
     */
    Dom.next = function (node, condition, root, withChild) {
        if (withChild === void 0) { withChild = true; }
        return Dom.find(node, condition, root, undefined, undefined, withChild ? 'firstChild' : '');
    };
    /**
     * Find next/prev node what `condition(next) === true`
     *
     * @param {Node} node
     * @param {function} condition
     * @param {Node} root
     * @param {boolean} [recurse=false] check first argument
     * @param {string} [sibling=nextSibling] nextSibling or previousSibling
     * @param {string|boolean} [child=firstChild] firstChild or lastChild
     * @return {Node|Boolean}
     */
    Dom.find = function (node, condition, root, recurse, sibling, child) {
        if (recurse === void 0) { recurse = false; }
        if (sibling === void 0) { sibling = 'nextSibling'; }
        if (child === void 0) { child = 'firstChild'; }
        if (recurse && condition(node)) {
            return node;
        }
        var start = node, next;
        do {
            next = start[sibling];
            if (condition(next)) {
                return next ? next : false;
            }
            if (child && next && next[child]) {
                var nextOne = Dom.find(next[child], condition, next, true, sibling, child);
                if (nextOne) {
                    return nextOne;
                }
            }
            if (!next) {
                next = start.parentNode;
            }
            start = next;
        } while (start && start !== root);
        return false;
    };
    /**
     * Find next/prev node what `condition(next) === true`
     *
     * @param {Node} node
     * @param {function} condition
     * @param {Node} root
     * @param {string} [sibling=nextSibling] nextSibling or previousSibling
     * @param {string|boolean} [child=firstChild] firstChild or lastChild
     * @return {Node|Boolean}
     */
    Dom.findWithCurrent = function (node, condition, root, sibling, child) {
        if (sibling === void 0) { sibling = 'nextSibling'; }
        if (child === void 0) { child = 'firstChild'; }
        var next = node;
        do {
            if (condition(next)) {
                return next ? next : false;
            }
            if (child && next && next[child]) {
                var nextOne = Dom.findWithCurrent(next[child], condition, next, sibling, child);
                if (nextOne) {
                    return nextOne;
                }
            }
            while (next && !next[sibling] && next !== root) {
                next = next.parentNode;
            }
            if (next && next[sibling] && next !== root) {
                next = next[sibling];
            }
        } while (next && next !== root);
        return false;
    };
    /**
     * Checks whether the Node text and blank (in this case it may contain invisible auxiliary characters , it is also empty )
     *
     * @param  {Node} node The element of wood to be checked
     * @return {Boolean} true element is empty
     */
    Dom.isEmptyTextNode = function (node) {
        return node && node.nodeType === Node.TEXT_NODE && (!node.nodeValue || node.nodeValue.replace(consts.INVISIBLE_SPACE_REG_EXP, '').length === 0);
    };
    /**
     * Check if element is not empty
     *
     * @param {Node} node
     * @param {RegExp} condNoEmptyElement
     * @return {boolean}
     */
    Dom.isEmpty = function (node, condNoEmptyElement) {
        if (condNoEmptyElement === void 0) { condNoEmptyElement = /^(img|svg|canvas|input|textarea|form)$/; }
        if (!node) {
            return true;
        }
        if (node.nodeType === Node.TEXT_NODE) {
            return node.nodeValue === null || Helpers_1.trim(node.nodeValue).length === 0;
        }
        return !node.nodeName.toLowerCase().match(condNoEmptyElement) && Dom.each(node, function (elm) {
            if ((elm && elm.nodeType === Node.TEXT_NODE &&
                (elm.nodeValue !== null &&
                    Helpers_1.trim(elm.nodeValue).length !== 0)) ||
                (elm && elm.nodeType === Node.ELEMENT_NODE &&
                    elm.nodeName.toLowerCase().match(condNoEmptyElement))) {
                return false;
            }
        });
    };
    /**
     * Returns true if it is a DOM node
     */
    Dom.isNode = function (object, win) {
        if (typeof win === "object") {
            return object instanceof win.Node;
        }
        return typeof object === "object" && typeof object.nodeType === "number" && typeof object.nodeName === "string";
    };
    /**
     * It goes through all the elements in ascending order, and checks to see if they meet the predetermined condition
     *
     * @param {callback} node
     * @param {function} condition
     * @param {Node} root Root element
     * @return {boolean|Node|HTMLElement|HTMLTableCellElement|HTMLTableElement} Return false if condition not be true
     */
    Dom.up = function (node, condition, root) {
        var start = node;
        if (!node) {
            return false;
        }
        do {
            if (condition(start)) {
                return start;
            }
            if (start === root || !start.parentNode) {
                break;
            }
            start = start.parentNode;
        } while (start && start !== root);
        return false;
    };
    /**
     * Find parent by tag name
     *
     * @param {Node} node
     * @param {String|Function} tags
     * @param {HTMLElement} root
     * @return {Boolean|Node}
     */
    Dom.closest = function (node, tags, root) {
        var condition;
        if (typeof tags === 'function') {
            condition = tags;
        }
        else if (tags instanceof RegExp) {
            condition = function (tag) { return tags.test(tag.nodeName); };
        }
        else {
            condition = function (tag) { return (new RegExp('^(' + tags + ')$', 'i')).test(tag.nodeName); };
        }
        return Dom.up(node, condition, root);
    };
    /**
     * Insert newElement after element
     *
     * @param elm
     * @param newElement
     */
    Dom.after = function (elm, newElement) {
        var parentNode = elm.parentNode;
        if (!parentNode) {
            return;
        }
        if (parentNode.lastChild === elm) {
            parentNode.appendChild(newElement);
        }
        else {
            parentNode.insertBefore(newElement, elm.nextSibling);
        }
    };
    /**
     * Move all content to another element
     *
     * @param {Node} from
     * @param {Node} to
     * @param {boolean} inStart
     */
    Dom.moveContent = function (from, to, inStart) {
        if (inStart === void 0) { inStart = false; }
        var fragment = from.ownerDocument.createDocumentFragment();
        [].slice.call(from.childNodes).forEach(function (node) {
            if (node.nodeType !== Node.TEXT_NODE || node.nodeValue !== consts.INVISIBLE_SPACE) {
                fragment.appendChild(node);
            }
        });
        if (!inStart || !to.firstChild) {
            to.appendChild(fragment);
        }
        else {
            to.insertBefore(fragment, to.firstChild);
        }
    };
    Dom.all = function (node, condition, prev) {
        if (prev === void 0) { prev = false; }
        var nodes = node.childNodes ? Array.prototype.slice.call(node.childNodes) : [];
        if (condition(node)) {
            return node;
        }
        if (prev) {
            nodes = nodes.reverse();
        }
        nodes.forEach(function (child) {
            Dom.all(child, condition, prev);
        });
    };
    /**
     *
     * @param {Node} current
     * @param {String | Node} tag
     * @param {Jodit} editor
     *
     * @return {HTMLElement}
     */
    Dom.wrapInline = function (current, tag, editor) {
        var tmp, first = current, last = current;
        var selInfo = editor.selection.save();
        var needFindNext = false;
        do {
            needFindNext = false;
            tmp = first.previousSibling;
            if (tmp && !Dom.isBlock(tmp)) {
                needFindNext = true;
                first = tmp;
            }
        } while (needFindNext);
        do {
            needFindNext = false;
            tmp = last.nextSibling;
            if (tmp && !Dom.isBlock(tmp)) {
                needFindNext = true;
                last = tmp;
            }
        } while (needFindNext);
        var wrapper = typeof tag === 'string' ? editor.editorDocument.createElement(tag) : tag;
        if (first.parentNode) {
            first.parentNode.insertBefore(wrapper, first);
        }
        var next = first;
        while (next) {
            next = first.nextSibling;
            wrapper.appendChild(first);
            if (first === last || !next) {
                break;
            }
            first = next;
        }
        editor.selection.restore(selInfo);
        return wrapper;
    };
    /**
     *
     * @param {Node} current
     * @param {String | Node} tag
     * @param {Jodit} editor
     *
     * @return {HTMLElement}
     */
    Dom.wrap = function (current, tag, editor) {
        var selInfo = editor.selection.save();
        var wrapper = typeof tag === 'string' ? editor.editorDocument.createElement(tag) : tag;
        if (!current.parentNode) {
            return null;
        }
        current.parentNode.insertBefore(wrapper, current);
        wrapper.appendChild(current);
        editor.selection.restore(selInfo);
        return wrapper;
    };
    Dom.findInline = function (node, toLeft, root) {
        var prevElement = node, nextElement = null;
        do {
            if (prevElement) {
                nextElement = toLeft ? prevElement.previousSibling : prevElement.nextSibling;
                if (!nextElement && prevElement.parentNode && prevElement.parentNode !== root && Dom.isInlineBlock(prevElement.parentNode)) {
                    prevElement = prevElement.parentNode;
                }
                else {
                    break;
                }
            }
            else {
                break;
            }
        } while (!nextElement);
        while (nextElement && Dom.isInlineBlock(nextElement) && (!toLeft ? nextElement.firstChild : nextElement.lastChild)) {
            nextElement = !toLeft ? nextElement.firstChild : nextElement.lastChild;
        }
        return nextElement; //(nextElement !== root && Dom.isInlineBlock(nextElement)) ? nextElement : null;
    };
    /**
     * Check root contains child
     *
     * @param root
     * @param child
     * @return {boolean}
     */
    Dom.contains = function (root, child) {
        while (child.parentNode) {
            if (child.parentNode === root) {
                return true;
            }
            child = child.parentNode;
        }
        return false;
    };
    /**
     * Check root contains child or equal child
     *
     * @param {Node} root
     * @param {Node} child
     * @param {boolean} onlyContains
     * @return {boolean}
     */
    Dom.isOrContains = function (root, child, onlyContains) {
        if (onlyContains === void 0) { onlyContains = false; }
        return child && root && ((root === child && !onlyContains) || Dom.contains(root, child));
    };
    return Dom;
}());
exports.Dom = Dom;


/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Jodit_1 = __webpack_require__(6);
var Component = /** @class */ (function () {
    function Component(jodit) {
        var _this = this;
        this.__whoLocked = '';
        this.isLocked = function () {
            return _this.__whoLocked !== '';
        };
        this.isLockedNotBy = function (name) {
            return _this.isLocked() && _this.__whoLocked !== name;
        };
        this.__modulesInstances = {};
        this.__isFullSize = false;
        this.isFullSize = function () { return _this.__isFullSize; };
        if (jodit) {
            this.jodit = jodit;
            if (jodit instanceof Jodit_1.Jodit && this.jodit.components) {
                this.jodit.components.push(this);
            }
        }
    }
    Component.prototype.destruct = function () { };
    Component.prototype.getInstance = function (moduleName, options) {
        if (Jodit_1.Jodit.modules[moduleName] === undefined) {
            throw new Error('Need real module name');
        }
        if (this.__modulesInstances[moduleName] === undefined) {
            this.__modulesInstances[moduleName] = new Jodit_1.Jodit.modules[moduleName](this, options);
        }
        return this.__modulesInstances[moduleName];
    };
    return Component;
}());
exports.Component = Component;


/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Component_1 = __webpack_require__(4);
var Helpers_1 = __webpack_require__(0);
var consts = __webpack_require__(2);
var Dom_1 = __webpack_require__(3);
var ToolbarElement = /** @class */ (function (_super) {
    __extends(ToolbarElement, _super);
    function ToolbarElement(jodit, containerTag, containerClass) {
        if (containerTag === void 0) { containerTag = 'li'; }
        if (containerClass === void 0) { containerClass = 'jodit_toolbar_btn'; }
        var _this = _super.call(this, jodit) || this;
        _this.parentToolbar = null;
        _this.container = _this.jodit.ownerDocument.createElement(containerTag);
        _this.container.classList.add(containerClass);
        return _this;
    }
    ToolbarElement.prototype.createIcon = function (clearName, control) {
        var icon = control ? control.icon || control.name : clearName;
        if (!this.jodit.options.textIcons) {
            var iconSVG = this.jodit.events.fire('getIcon', icon, control, clearName);
            var iconElement = void 0;
            if (control && control.iconURL && iconSVG === undefined) {
                iconElement = Helpers_1.dom('<i></i>', this.jodit.ownerDocument);
                iconElement.style.backgroundImage = 'url(' + control.iconURL + ')';
            }
            else {
                if (iconSVG === undefined) {
                    if (ToolbarIcon.exists(icon)) {
                        iconSVG = ToolbarIcon.getIcon(icon);
                    }
                    else {
                        iconSVG = ToolbarIcon.getIcon('empty');
                    }
                }
                iconElement = Helpers_1.dom(iconSVG, this.jodit.ownerDocument);
            }
            iconElement.classList.add('jodit_icon', 'jodit_icon_' + clearName);
            return iconElement;
        }
        return Helpers_1.dom("<span class=\"jodit_icon\">" + this.jodit.i18n(control ? control.name : clearName) + "</span>", this.jodit.ownerDocument);
    };
    return ToolbarElement;
}(Component_1.Component));
var ToolbarPopup = /** @class */ (function (_super) {
    __extends(ToolbarPopup, _super);
    function ToolbarPopup(jodit, target, current, className) {
        if (className === void 0) { className = 'jodit_toolbar_popup'; }
        var _this = _super.call(this, jodit, 'div', className) || this;
        _this.target = target;
        _this.current = current;
        _this.className = className;
        _this.isOpened = false;
        _this.close = function (current) {
            if (!_this.isOpened) {
                return;
            }
            if (!current || !Dom_1.Dom.isOrContains(_this.container, current instanceof ToolbarPopup ? current.target : current)) {
                _this.isOpened = false;
                _this.jodit.events.off('closeAllPopups', _this.close);
                _this.doClose();
                if (_this.container.parentNode) {
                    _this.container.parentNode.removeChild(_this.container);
                }
                if (_this.jodit.selection) {
                    _this.jodit.selection.removeMarkers();
                }
            }
        };
        _this.container.setAttribute('data-editor_id', jodit.id);
        _this.jodit.events
            .on(_this.container, 'mousedown touchstart', function (e) {
            e.stopPropagation();
        });
        return _this;
    }
    ToolbarPopup.prototype.doOpen = function (content) {
        if (!content) {
            return;
        }
        Dom_1.Dom.detach(this.container);
        this.container.innerHTML = '<span class="jodit_popup_triangle"></span>';
        this.container.appendChild(Helpers_1.dom(content, this.jodit.ownerDocument));
        this.container.style.display = 'block';
        this.container.style.marginLeft = null;
    };
    /**
     * @param {HTMLElement} content
     * @param {boolean} [rightAlign=false] Open popup on right side
     * @param {boolean} [noStandartActions=false] No call standarts action
     */
    ToolbarPopup.prototype.open = function (content, rightAlign, noStandartActions) {
        if (noStandartActions === void 0) { noStandartActions = false; }
        this.jodit.events.fire('beforeOpenPopup closeAllPopups', this, content);
        noStandartActions || this.jodit.events.on('closeAllPopups', this.close);
        this.container.classList.add(this.className + '-open');
        this.doOpen(content);
        this.target.appendChild(this.container);
        if (rightAlign !== undefined) {
            this.container.classList.toggle('jodit_right', rightAlign);
        }
        if (!noStandartActions && this.parentToolbar) {
            this.jodit.events.fire(this.parentToolbar, 'afterOpenPopup', this.container);
        }
        this.isOpened = true;
    };
    ToolbarPopup.prototype.doClose = function () { };
    return ToolbarPopup;
}(ToolbarElement));
exports.ToolbarPopup = ToolbarPopup;
var ToolbarList = /** @class */ (function (_super) {
    __extends(ToolbarList, _super);
    function ToolbarList(jodit, target, current, className) {
        if (className === void 0) { className = 'jodit_toolbar_list'; }
        var _this = _super.call(this, jodit, target, current, className) || this;
        _this.target = target;
        _this.current = current;
        _this.className = className;
        _this.defaultControl = {
            template: function (editor, key, value) { return (_this.jodit.i18n(value)); }
        };
        return _this;
    }
    ToolbarList.prototype.doClose = function () {
        if (this.toolbar) {
            this.toolbar.destruct();
        }
    };
    ToolbarList.prototype.doOpen = function (control) {
        var _this = this;
        this.toolbar = new ToolbarCollection(this.jodit);
        var list = typeof control.list === 'string' ? control.list.split(/[\s,]/) : control.list;
        Helpers_1.each(list, function (key, value) {
            var button;
            if (_this.jodit.options.controls[value] !== undefined) {
                button = new ToolbarButton(_this.jodit, __assign({ name: value.toString() }, _this.jodit.options.controls[value]), _this.current); // list like array {"align": {list: ["left", "right"]}}
            }
            else if (_this.jodit.options.controls[key] !== undefined && typeof value === 'object') {
                button = new ToolbarButton(_this.jodit, __assign({ name: key.toString() }, _this.jodit.options.controls[key], value), _this.current); // list like object {"align": {list: {"left": {exec: alert}, "right": {}}}}
            }
            else {
                button = new ToolbarButton(_this.jodit, {
                    name: key.toString(),
                    exec: control.exec,
                    command: control.command,
                    isActive: control.isActiveChild,
                    isDisable: control.isDisableChild,
                    args: [
                        (control.args && control.args[0]) || key,
                        (control.args && control.args[1]) || value
                    ]
                }, _this.current); // list like object {"align": {list: {"left": {exec: alert}, "right": {}}}}
                var template = control.template || _this.defaultControl.template;
                button.textBox.innerHTML = template(_this.jodit, key, value);
            }
            _this.toolbar.appendChild(button);
        });
        this.container.appendChild(this.toolbar.container);
        this.container.style.marginLeft = null;
        this.toolbar.checkActiveButtons();
    };
    return ToolbarList;
}(ToolbarPopup));
exports.ToolbarList = ToolbarList;
var ToolbarButton = /** @class */ (function (_super) {
    __extends(ToolbarButton, _super);
    function ToolbarButton(jodit, control, target) {
        var _this = _super.call(this, jodit) || this;
        _this.__disabled = false;
        _this.__actived = false;
        _this.checkActiveStatus = function (cssObject, node) {
            var matches = 0, total = 0;
            Object.keys(cssObject).forEach(function (cssProperty) {
                var cssValue = cssObject[cssProperty];
                if (typeof cssValue === 'function') {
                    if (cssValue(_this.jodit, Helpers_1.css(node, cssProperty).toString())) {
                        matches += 1;
                    }
                }
                else {
                    if (cssValue.indexOf(Helpers_1.css(node, cssProperty).toString()) !== -1) {
                        matches += 1;
                    }
                }
                total += 1;
            });
            return total === matches;
        };
        _this.onMouseDown = function (originalEvent) {
            originalEvent.stopImmediatePropagation();
            originalEvent.preventDefault();
            if (_this.disable) {
                return false;
            }
            var control = _this.control;
            if (control.list) {
                var list = new ToolbarList(_this.jodit, _this.container, _this.target);
                list.parentToolbar = _this.parentToolbar;
                list.open(control);
                _this.jodit.events.fire('closeAllPopups', list.container);
            }
            else if (control.exec !== undefined && typeof control.exec === 'function') {
                control.exec(_this.jodit, _this.target || (_this.jodit.selection ? _this.jodit.selection.current() : false), control, originalEvent, _this.container);
                _this.jodit.events.fire('synchro');
                if (_this.parentToolbar) {
                    _this.parentToolbar.immedateCheckActiveButtons();
                }
                /**
                 * Fired after calling `button.exec` function
                 * @event afterExec
                 */
                _this.jodit.events.fire('closeAllPopups afterExec');
            }
            else if (control.popup !== undefined && typeof control.popup === 'function') {
                var popup = new ToolbarPopup(_this.jodit, _this.container, _this.target);
                popup.parentToolbar = _this.parentToolbar;
                if (_this.jodit.events.fire(Helpers_1.camelCase('before-' + control.name + '-OpenPopup'), _this.target || (_this.jodit.selection ? _this.jodit.selection.current() : false), control, popup) !== false) {
                    popup.open(control.popup(_this.jodit, _this.target || (_this.jodit.selection ? _this.jodit.selection.current() : false), control, popup.close, _this));
                }
                /**
                 * Fired after popup was opened for some control button
                 * @event after{CONTROLNAME}OpenPopup
                 */
                /**
                 * Close all opened popups
                 *
                 * @event closeAllPopups
                 */
                _this.jodit.events.fire(Helpers_1.camelCase('after-' + control.name + '-OpenPopup') + ' closeAllPopups', popup.container);
            }
            else {
                if (control.command || control.name) {
                    _this.jodit.execCommand(control.command || control.name, (control.args && control.args[0]) || false, (control.args && control.args[1]) || null);
                    _this.jodit.events.fire('closeAllPopups');
                }
            }
        };
        _this.control = control;
        _this.target = target;
        _this.anchor = _this.jodit.ownerDocument.createElement('a');
        _this.container.appendChild(_this.anchor);
        if (jodit.options.showTooltip && control.tooltip) {
            if (!jodit.options.useNativeTooltip) {
                _this.tooltip = new Tooltip(_this);
            }
            else {
                _this.anchor.setAttribute('title', _this.jodit.i18n(control.tooltip) + (control.hotkeys ? '<br>' + Helpers_1.asArray(control.hotkeys).join(' ') : ''));
            }
        }
        _this.textBox = _this.jodit.ownerDocument.createElement('span');
        _this.anchor.appendChild(_this.textBox);
        var clearName = control.name.replace(/[^a-zA-Z0-9]/g, '_');
        if (control.getContent && typeof control.getContent === 'function') {
            Dom_1.Dom.detach(_this.container);
            _this.container.appendChild(Helpers_1.dom(control.getContent(_this.jodit, control, _this), _this.jodit.ownerDocument));
        }
        else {
            if (control.list && _this.anchor) {
                var trigger = _this.jodit.ownerDocument.createElement('span');
                trigger.classList.add('jodit_with_dropdownlist-trigger');
                _this.container.classList.add('jodit_with_dropdownlist');
                _this.anchor.appendChild(trigger);
            }
            _this.textBox.appendChild(_this.createIcon(clearName, control));
        }
        _this.container.classList.add('jodit_toolbar_btn-' + clearName);
        if (control.isInput) {
            _this.container.classList.add('jodit_toolbar-input');
        }
        else {
            _this.jodit.events.on(_this.container, 'mousedown touchend', _this.onMouseDown);
        }
        return _this;
    }
    Object.defineProperty(ToolbarButton.prototype, "disable", {
        get: function () {
            return this.__disabled;
        },
        set: function (disable) {
            this.__disabled = disable;
            this.container.classList.toggle('jodit_disabled', disable);
            if (!disable) {
                if (this.container.hasAttribute('disabled')) {
                    this.container.removeAttribute('disabled');
                }
            }
            else {
                if (!this.container.hasAttribute('disabled')) {
                    this.container.setAttribute('disabled', 'disabled');
                }
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ToolbarButton.prototype, "active", {
        get: function () {
            return this.__actived;
        },
        set: function (enable) {
            this.__actived = enable;
            this.container.classList.toggle('jodit_active', enable);
        },
        enumerable: true,
        configurable: true
    });
    ToolbarButton.prototype.isDisable = function () {
        var mode = (this.control === undefined || this.control.mode === undefined) ? consts.MODE_WYSIWYG : this.control.mode;
        var isEnable = mode === consts.MODE_SPLIT || mode === this.jodit.getRealMode();
        if (typeof this.control.isDisable === 'function') {
            isEnable = isEnable && !this.control.isDisable(this.jodit, this.control, this);
        }
        if (this.jodit.options.readonly && this.jodit.options.activeButtonsInReadOnly.indexOf(this.control.name) === -1) {
            isEnable = false;
        }
        return !isEnable;
    };
    ToolbarButton.prototype.isActive = function () {
        var _this = this;
        if (typeof this.control.isActive === 'function') {
            return this.control.isActive(this.jodit, this.control, this);
        }
        var element = this.jodit.selection ? this.jodit.selection.current() : false;
        if (!element) {
            return false;
        }
        var tags, elm, css;
        if (this.control.tags || (this.control.options && this.control.options.tags)) {
            tags = this.control.tags || (this.control.options && this.control.options.tags);
            elm = element;
            if (Dom_1.Dom.up(elm, function (node) {
                if (node && tags.indexOf(node.nodeName.toLowerCase()) !== -1) {
                    return true;
                }
            }, this.jodit.editor)) {
                return true;
            }
        }
        //activate by supposed css
        if (this.control.css || (this.control.options && this.control.options.css)) {
            css = this.control.css || (this.control.options && this.control.options.css);
            elm = element;
            if (Dom_1.Dom.up(elm, function (node) {
                if (node && node.nodeType !== Node.TEXT_NODE) {
                    return _this.checkActiveStatus(css, node);
                }
            }, this.jodit.editor)) {
                return true;
            }
        }
        return false;
    };
    ToolbarButton.prototype.destruct = function () {
        this.jodit.events.off(this.container);
    };
    return ToolbarButton;
}(ToolbarElement));
exports.ToolbarButton = ToolbarButton;
/**
 * Class create tooltip for buttons in toolbar
 */
var Tooltip = /** @class */ (function () {
    function Tooltip(button) {
        var _this = this;
        this.button = button;
        this.timeout = 0;
        this.show = function () {
            var showElement = function () {
                _this.button.container.appendChild(_this.container);
                var diff = _this.container.offsetWidth - _this.button.container.offsetWidth;
                _this.container.style.marginLeft = (-diff / 2) + 'px';
            }, delay = _this.button.jodit.options.showTooltipDelay;
            _this.button.jodit.events.fire('hideTooltip');
            if (delay) {
                _this.timeout = window.setTimeout(showElement, delay);
            }
            else {
                showElement();
            }
        };
        this.hide = function () {
            window.clearTimeout(_this.timeout);
            _this.container.parentNode && _this.container.parentNode.removeChild(_this.container);
        };
        if (button.control.tooltip) {
            this.container = button.jodit.ownerDocument.createElement('div');
            this.container.classList.add('jodit_tooltip');
            this.container.innerHTML = button.jodit.i18n(button.control.tooltip) + (button.control.hotkeys ? '<br>' + Helpers_1.asArray(button.control.hotkeys).join(' ') : '');
            button.jodit.events
                .on(button.anchor, 'mouseenter', this.show)
                .on(button.anchor, 'mouseleave', this.hide)
                .on('change updateToolbar scroll hidePopup closeAllPopups hideTooltip', this.hide);
        }
    }
    return Tooltip;
}());
exports.Tooltip = Tooltip;
var ToolbarBreak = /** @class */ (function (_super) {
    __extends(ToolbarBreak, _super);
    function ToolbarBreak(jodit) {
        var _this = _super.call(this, jodit) || this;
        _this.container.classList.add('jodit_toolbar_btn-break');
        return _this;
    }
    return ToolbarBreak;
}(ToolbarElement));
exports.ToolbarBreak = ToolbarBreak;
var ToolbarSeparator = /** @class */ (function (_super) {
    __extends(ToolbarSeparator, _super);
    function ToolbarSeparator(jodit) {
        var _this = _super.call(this, jodit) || this;
        _this.container.classList.add('jodit_toolbar_btn-separator');
        return _this;
    }
    return ToolbarSeparator;
}(ToolbarElement));
exports.ToolbarSeparator = ToolbarSeparator;
var ToolbarIcon = /** @class */ (function () {
    function ToolbarIcon() {
    }
    ToolbarIcon.exists = function (name) {
        return ToolbarIcon.icons[name] !== undefined;
    };
    /**
     * Return SVG icon
     *
     * @param {string} name icon
     * @param {string} [defaultValue='<span></span>']
     * @return {string}
     */
    ToolbarIcon.getIcon = function (name, defaultValue) {
        if (defaultValue === void 0) { defaultValue = '<span></span>'; }
        return ToolbarIcon.icons[name] !== undefined ? ToolbarIcon.icons[name] : defaultValue;
    };
    ToolbarIcon.icons = {};
    return ToolbarIcon;
}());
exports.ToolbarIcon = ToolbarIcon;
var ToolbarCollection = /** @class */ (function (_super) {
    __extends(ToolbarCollection, _super);
    function ToolbarCollection(jodit) {
        var _this = _super.call(this, jodit, 'ul', 'jodit_toolbar') || this;
        _this.__buttons = [];
        _this.__getControlType = function (button) {
            var buttonControl;
            if (typeof button !== 'string') {
                buttonControl = __assign({ name: 'empty' }, button);
                if (_this.jodit.options.controls[buttonControl.name] !== undefined) {
                    buttonControl = __assign({}, _this.jodit.options.controls[buttonControl.name], buttonControl);
                }
            }
            else {
                var list = button.split(/\./);
                var store = _this.jodit.options.controls;
                if (list.length > 1) {
                    if (_this.jodit.options.controls[list[0]] !== undefined) {
                        store = _this.jodit.options.controls[list[0]];
                        button = list[1];
                    }
                }
                if (store[button] !== undefined) {
                    buttonControl = __assign({ name: button }, store[button]);
                }
                else {
                    buttonControl = {
                        name: button,
                        command: button,
                        tooltip: button,
                    };
                }
            }
            return buttonControl;
        };
        _this.immedateCheckActiveButtons = function () {
            if (_this.jodit.isLocked()) {
                return;
            }
            _this.__buttons.filter(function (button) { return button instanceof ToolbarButton; })
                .forEach(function (button) {
                button.disable = button.isDisable();
                if (!button.disable) {
                    button.active = button.isActive();
                }
                if (typeof button.control.getLabel === 'function') {
                    button.control.getLabel(_this.jodit, button.control, button);
                }
            });
            _this.jodit.events && _this.jodit.events
                .fire('updateToolbar');
        };
        _this.checkActiveButtons = Helpers_1.debounce(_this.immedateCheckActiveButtons, _this.jodit.defaultTimeout);
        _this.closeAll = function () {
            _this.jodit.events.fire('closeAllPopups');
        };
        _this.afterOpen = function (popup) {
            var offsetConainer = Helpers_1.offset(_this.jodit.container, _this.jodit, _this.jodit.ownerDocument, true);
            var offsetPopup = Helpers_1.offset(popup, _this.jodit, _this.jodit.ownerDocument, true);
            var marginLeft = Helpers_1.css(popup, 'marginLeft');
            var diffLeft = 0;
            if (offsetPopup.left + offsetPopup.width > offsetConainer.left + offsetConainer.width) {
                diffLeft = -((offsetPopup.left + offsetPopup.width) - (offsetConainer.left + offsetConainer.width));
                Helpers_1.css(popup, {
                    marginLeft: diffLeft + marginLeft
                });
                offsetPopup = Helpers_1.offset(popup, _this.jodit, _this.jodit.ownerDocument, true);
            }
            if (offsetPopup.left < offsetConainer.left) {
                if (offsetPopup.left + offsetPopup.width > offsetConainer.left + offsetConainer.width) {
                    Helpers_1.css(popup, {
                        width: offsetConainer.width
                    });
                }
                else {
                    diffLeft = offsetConainer.left - offsetPopup.left;
                    Helpers_1.css(popup, {
                        marginLeft: diffLeft + marginLeft
                    });
                }
            }
            if (diffLeft) {
                var triangle = popup.querySelector('.jodit_popup_triangle');
                if (triangle) {
                    triangle.style.marginLeft = -diffLeft + 'px';
                }
            }
        };
        _this.listenEvents = 'changeStack mousedown mouseup keydown change afterInit readonly afterResize selectionchange changeSelection focus afterSetMode touchstart';
        _this.initEvents = function () {
            _this.jodit.events
                .on(_this.jodit.ownerWindow, 'mousedown touchend', _this.closeAll)
                .on(_this, 'afterOpenPopup', _this.afterOpen)
                .on(_this.listenEvents, _this.checkActiveButtons)
                .on('afterSetMode focus', _this.immedateCheckActiveButtons);
        };
        _this.initEvents();
        return _this;
    }
    ToolbarCollection.prototype.getButtonsList = function () {
        return this.__buttons
            .map(function (a) { return a instanceof ToolbarButton ? a.control.name : ''; })
            .filter(function (a) { return a !== ''; });
    };
    ToolbarCollection.prototype.appendChild = function (button) {
        this.__buttons.push(button);
        button.parentToolbar = this;
        this.container.appendChild(button.container);
    };
    ToolbarCollection.prototype.removeChild = function (button) {
        var index = this.__buttons.indexOf(button);
        if (index !== -1) {
            this.__buttons.splice(index, 1);
            if (button.container.parentNode === this.container) {
                this.container
                    .removeChild(button.container);
            }
        }
        button.parentToolbar = null;
    };
    ToolbarCollection.prototype.build = function (buttons, container, target) {
        var _this = this;
        var lastBtnSeparator = false;
        this.clear();
        var buttonsList = typeof buttons === 'string' ? buttons.split(/[,\s]+/) : buttons;
        buttonsList
            .map(this.__getControlType)
            .forEach(function (buttonControl) {
            var button = null;
            if (_this.jodit.options.removeButtons.indexOf(buttonControl.name) !== -1) {
                return;
            }
            switch (buttonControl.name) {
                case "\n":
                    button = new ToolbarBreak(_this.jodit);
                    break;
                case '|':
                    if (!lastBtnSeparator) {
                        lastBtnSeparator = true;
                        button = new ToolbarSeparator(_this.jodit);
                    }
                    break;
                default:
                    lastBtnSeparator = false;
                    button = new ToolbarButton(_this.jodit, buttonControl, target);
            }
            if (button) {
                _this.appendChild(button);
            }
        });
        if (this.container.parentNode !== container) {
            container.appendChild(this.container);
        }
        this.immedateCheckActiveButtons();
    };
    ToolbarCollection.prototype.clear = function () {
        var _this = this;
        // in removeChild __buttons is changed
        this.__buttons.slice().forEach(function (button) {
            _this.removeChild(button);
            button.destruct();
        });
        this.__buttons.length = 0;
        // this.container.parentNode && this.container.parentNode.removeChild(this.container);
    };
    ToolbarCollection.prototype.destruct = function () {
        _super.prototype.destruct.call(this);
        this.jodit.events
            .off(this.jodit.ownerWindow, 'mousedown touchstart', this.closeAll)
            .off(this, 'afterOpenPopup', this.afterOpen)
            .off(this.listenEvents, this.checkActiveButtons)
            .off('afterSetMode focus', this.immedateCheckActiveButtons);
        this.clear();
    };
    return ToolbarCollection;
}(ToolbarElement));
exports.ToolbarCollection = ToolbarCollection;


/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Component_1 = __webpack_require__(4);
var Selection_1 = __webpack_require__(13);
var Uploader_1 = __webpack_require__(9);
var Dom_1 = __webpack_require__(3);
var EventsNative_1 = __webpack_require__(11);
var consts = __webpack_require__(2);
var Helpers_1 = __webpack_require__(0);
var helper = __webpack_require__(0);
var Config_1 = __webpack_require__(1);
var ToolbarCollection_1 = __webpack_require__(5);
var StatusBar_1 = __webpack_require__(31);
var Storage_1 = __webpack_require__(16);
var Observer_1 = __webpack_require__(17);
/** Class Jodit. Main class*/
var Jodit = /** @class */ (function (_super) {
    __extends(Jodit, _super);
    /**
     * Create instance of Jodit
     * @constructor
     *
     * @param {HTMLInputElement | string} element Selector or HTMLElement
     * @param {object} options Editor's options
     */
    function Jodit(element, options) {
        var _this = _super.call(this) || this;
        _this.version = "3.1.95"; // from webpack.config.js
        _this.components = [];
        /**
         * Container for set/get value
         * @type {Storage}
         */
        _this.storage = new Storage_1.Storage(new Storage_1.localStorageProvider());
        /**
         * iframe Iframe for iframe mode
         */
        _this.iframe = null;
        _this.__plugins = {};
        _this.__defaultStyleDisplayKey = 'data-jodit-default-style-display';
        _this.__defaultClassesKey = 'data-jodit-default-classes';
        /**
         * Editor was destructed
         *
         * @type {boolean}
         */
        _this.isDestructed = false;
        _this.commands = {};
        _this.__selectionLocked = null;
        _this.isLockedNotBy = function (name) {
            return _this.isLocked() && _this.__whoLocked !== name;
        };
        _this.mode = consts.MODE_WYSIWYG;
        /**
         * Return current version
         *
         * @method getVersion
         * @return {string}
         */
        _this.getVersion = function () {
            return _this.version;
        };
        _this.buffer = {}; // empty new object for every Jodit instance
        _this.options = (new Config_1.OptionsDefault(options));
        // in iframe it can be changed
        _this.editorDocument = _this.options.ownerDocument;
        _this.editorWindow = _this.options.ownerWindow;
        _this.ownerDocument = _this.options.ownerDocument;
        _this.ownerWindow = _this.options.ownerWindow;
        _this.events = new EventsNative_1.EventsNative(_this.ownerDocument);
        if (typeof element === 'string') {
            try {
                _this.element = _this.ownerDocument.querySelector(element);
            }
            catch (e) {
                throw new Error('String "' + element + '" should be valid HTML selector');
            }
        }
        else {
            _this.element = element;
        }
        // Duck checking
        if (!_this.element ||
            typeof _this.element !== "object" ||
            _this.element.nodeType !== Node.ELEMENT_NODE ||
            !_this.element.cloneNode) {
            throw new Error('Element "' + element + '" should be string or HTMLElement instance');
        }
        if (_this.options.events) {
            Object.keys(_this.options.events).forEach(function (key) {
                _this.events.on(key, _this.options.events[key]);
            });
        }
        _this.selection = new Selection_1.Select(_this);
        _this.uploader = new Uploader_1.Uploader(_this);
        _this.observer = new Observer_1.Observer(_this);
        _this.container = Helpers_1.dom('<div contenteditable="false" class="jodit_container" />', _this.ownerDocument);
        var buffer = null;
        if (_this.options.inline) {
            if (['TEXTAREA', 'INPUT'].indexOf(_this.element.nodeName) === -1) {
                _this.container = _this.element;
                _this.element.setAttribute(_this.__defaultClassesKey, _this.element.className.toString());
                buffer = _this.container.innerHTML;
                _this.container.innerHTML = '';
            }
            _this.container.classList.add('jodit_inline');
            _this.container.classList.add('jodit_container');
        }
        _this.container.classList.add('jodit_' + (_this.options.theme || 'default') + '_theme');
        if (_this.options.zIndex) {
            _this.container.style.zIndex = parseInt(_this.options.zIndex.toString(), 10).toString();
        }
        _this.workplace = Helpers_1.dom('<div contenteditable="false" class="jodit_workplace" />', _this.ownerDocument);
        _this.progress_bar = Helpers_1.dom('<div class="jodit_progress_bar"><div></div></div>', _this.ownerDocument);
        _this.toolbar = new ToolbarCollection_1.ToolbarCollection(_this);
        if (_this.options.toolbar) {
            _this.toolbar.build(Helpers_1.splitArray(_this.options.buttons).concat(_this.options.extraButtons), _this.container);
        }
        _this.container.classList.add('jodit_toolbar_size-' + (['middle', 'large', 'small'].indexOf(_this.options.toolbarButtonSize.toLowerCase()) !== -1 ? _this.options.toolbarButtonSize.toLowerCase() : 'middle'));
        if (_this.options.textIcons) {
            _this.container.classList.add('jodit_text_icons');
        }
        _this.events.on(_this.ownerWindow, 'resize', function () {
            if (_this.events) {
                _this.events.fire('resize');
            }
        });
        _this.container.appendChild(_this.workplace);
        _this.statusbar = new StatusBar_1.StatusBar(_this, _this.container);
        _this.workplace.appendChild(_this.progress_bar);
        if (_this.element.parentNode && _this.element !== _this.container) {
            _this.element.parentNode.insertBefore(_this.container, _this.element);
        }
        _this.helper = helper;
        _this.id = _this.element.getAttribute('id') || (new Date()).getTime().toString();
        _this.initPlugines();
        _this.__createEditor();
        // syncro
        if (_this.element !== _this.container) {
            _this.setElementValue();
        }
        else {
            buffer !== null && _this.setEditorValue(buffer); // inline mode
        }
        Jodit.instances[_this.id] = _this;
        var mode = _this.options.defaultMode;
        if (_this.options.saveModeInStorage) {
            var localMode = _this.storage.get('jodit_default_mode');
            if (localMode !== null) {
                mode = parseInt(localMode, 10);
            }
        }
        _this.setMode(mode);
        if (_this.options.readonly) {
            _this.setReadOnly(true);
        }
        //if enter plugin not installed
        try {
            _this.editorDocument.execCommand("defaultParagraphSeparator", false, _this.options.enter.toLowerCase());
        }
        catch (ignore) {
        }
        // fix for native resizing
        try {
            _this.editorDocument.execCommand('enableObjectResizing', false, false);
        }
        catch (ignore) {
        }
        try {
            _this.editorDocument.execCommand('enableInlineTableEditing', false, false);
        }
        catch (ignore) {
        }
        _this.events.fire('afterInit', _this);
        return _this;
    }
    Jodit.prototype.initPlugines = function () {
        var _this = this;
        var disable = Array.isArray(this.options.disablePlugins) ? this.options.disablePlugins.map(function (pluginName) {
            return pluginName.toLowerCase();
        }) : this.options.disablePlugins.toLowerCase().split(/[\s,]+/);
        Object.keys(Jodit.plugins).forEach(function (key) {
            if (disable.indexOf(key.toLowerCase()) === -1) {
                _this.__plugins[key] = new Jodit.plugins[key](_this);
            }
        });
    };
    /**
     * Create main DIV element and replace source textarea
     *
     * @private
     */
    Jodit.prototype.__createEditor = function () {
        var _this = this;
        if (this.events.fire('createEditor') !== false) {
            this.editor = Helpers_1.dom("<div class=\"jodit_wysiwyg\" contenteditable aria-disabled=\"false\" tabindex=\"" + this.options.tabIndex + "\"></div>", this.ownerDocument);
            this.workplace.appendChild(this.editor);
        }
        if (this.options.editorCssClass) {
            this.editor.classList.add(this.options.editorCssClass);
        }
        // proxy events
        this.events
            .on('synchro', function () {
            _this.setEditorValue();
        })
            .on(this.editor, 'selectionchange selectionstart keydown keyup keypress mousedown mouseup mousepress click copy cut dragstart drop dragover paste resize touchstart touchend focus blur', function (event) {
            if (_this.options.readonly) {
                return;
            }
            if (_this.events && _this.events.fire) {
                if (_this.events.fire(event.type, event) === false) {
                    return false;
                }
                _this.setEditorValue();
            }
        });
        if (this.options.spellcheck) {
            this.editor.setAttribute('spellcheck', "true");
        }
        // direction
        if (this.options.direction) {
            this.editor.style.direction = this.options.direction.toLowerCase() === 'rtl' ? 'rtl' : 'ltr';
        }
        // actual for inline mode
        if (this.element !== this.container) {
            // hide source element
            if (this.element.style.display) {
                this.element.setAttribute(this.__defaultStyleDisplayKey, this.element.style.display);
            }
            this.element.style.display = 'none';
        }
        if (this.options.triggerChangeEvent) {
            this.events.on('change', Helpers_1.debounce(function () {
                _this.events && _this.events.fire(_this.element, 'change');
            }, this.defaultTimeout));
        }
    };
    /**
     * Jodit's Destructor. Remove editor, and return source input
     */
    Jodit.prototype.destruct = function () {
        var _this = this;
        if (this.isDestructed) {
            return;
        }
        this.isDestructed = true;
        /**
         * Triggered before {@link events:beforeDestruct|beforeDestruct} executed. If returned false method stopped
         *
         * @event beforeDestruct
         * @example
         * ```javascript
         * var editor = new Jodit("#redactor");
         * editor.events.on('beforeDestruct', function (data) {
         *     return false;
         * });
         * ```
         */
        if (this.events.fire('beforeDestruct') === false) {
            return;
        }
        if (!this.editor) {
            return;
        }
        var buffer = this.value;
        if (this.element !== this.container) {
            if (this.element.hasAttribute(this.__defaultStyleDisplayKey)) {
                this.element.style.display = this.element.getAttribute(this.__defaultStyleDisplayKey);
                this.element.removeAttribute(this.__defaultStyleDisplayKey);
            }
            else {
                this.element.style.display = '';
            }
        }
        else {
            if (this.element.hasAttribute(this.__defaultClassesKey)) {
                this.element.className = this.element.getAttribute(this.__defaultClassesKey) || '';
                this.element.removeAttribute(this.__defaultClassesKey);
            }
        }
        if (this.element.hasAttribute('style') && !this.element.getAttribute('style')) {
            this.element.removeAttribute('style');
        }
        Object.keys(this.__plugins).forEach(function (pluginName) {
            if (_this.__plugins !== undefined && _this.__plugins[pluginName] !== undefined && _this.__plugins[pluginName].destruct !== undefined && typeof _this.__plugins[pluginName].destruct === 'function') {
                // @ts-ignore: Object is possibly 'undefined'
                _this.__plugins[pluginName].destruct();
            }
            delete _this.__plugins[pluginName];
        });
        this.components.forEach(function (component) {
            if (component.destruct !== undefined && typeof component.destruct === 'function') {
                component.destruct();
            }
        });
        delete this['selection'];
        this.events.off(this.ownerWindow);
        this.events.off(this.ownerDocument);
        this.events.off(this.ownerDocument.body);
        this.events.off(this.element);
        this.events.off(this.editor);
        this.events.destruct();
        delete this['events'];
        if (this.workplace.parentNode) {
            this.workplace.parentNode.removeChild(this.workplace);
        }
        if (this.editor.parentNode) {
            this.editor.parentNode.removeChild(this.editor);
        }
        if (this.iframe && this.iframe.parentNode) {
            this.iframe.parentNode.removeChild(this.iframe);
        }
        if (this.container.parentNode && this.container !== this.element) {
            this.container.parentNode.removeChild(this.container);
        }
        delete this['editor'];
        delete this['workplace'];
        // inline mode
        if (this.container === this.element) {
            this.element.innerHTML = buffer;
        }
        delete Jodit.instances[this.id];
        delete this['container'];
    };
    /**
     * Return source element value
     */
    Jodit.prototype.getElementValue = function () {
        return this.element.value !== undefined ? this.element.value : this.element.innerHTML;
    };
    /**
     * Return real HTML value from WYSIWYG editor.
     *
     * @return {string}
     */
    Jodit.prototype.getNativeEditorValue = function () {
        if (this.editor) {
            return this.editor.innerHTML;
        }
        return this.getElementValue();
    };
    /**
     * Return editor value
     */
    Jodit.prototype.getEditorValue = function (removeSelectionMarkers) {
        if (removeSelectionMarkers === void 0) { removeSelectionMarkers = true; }
        /**
         * Triggered before {@link Jodit~getEditorValue|getEditorValue} executed. If returned not undefined getEditorValue will return this value
         *
         * @event beforeGetValueFromEditor
         * @example
         * ```javascript
         * var editor = new Jodit("#redactor");
         * editor.events.on('beforeGetValueFromEditor', function () {
         *     return editor.editor.innerHTML.replace(/a/g, 'b');
         * });
         * ```
         */
        var value;
        value = this.events.fire('beforeGetValueFromEditor');
        if (value !== undefined) {
            return value;
        }
        value = this.getNativeEditorValue()
            .replace(consts.INVISIBLE_SPACE_REG_EXP, '');
        if (removeSelectionMarkers) {
            value = value
                .replace(/<span[^>]+id="jodit_selection_marker_[^>]+><\/span>/g, '');
        }
        if (value === '<br>') {
            value = '';
        }
        /**
         * Triggered after  {@link Jodit~getEditorValue|getEditorValue} got value from wysiwyg. It can change new_value.value
         *
         * @event afterGetValueFromEditor
         * @param string new_value
         * @example
         * ```javascript
         * var editor = new Jodit("#redactor");
         * editor.events.on('afterGetValueFromEditor', function (new_value) {
         *     new_value.value = new_value.value.replace('a', 'b');
         * });
         * ```
         */
        var new_value = { value: value };
        this.events.fire('afterGetValueFromEditor', new_value);
        return new_value.value;
    };
    Jodit.prototype.getEditorText = function () {
        if (this.editor) {
            return this.editor.innerText;
        }
        var div = this.ownerDocument.createElement('div');
        div.innerHTML = this.getElementValue();
        return div.innerText;
    };
    /**
     * Set source element value and if set sync fill editor value
     * When method was called without arguments - it is simple way to synchronize element to editor
     *
     * @param {string} [value]
     */
    Jodit.prototype.setElementValue = function (value) {
        if (typeof value !== 'string' && value !== undefined) {
            throw new Error('value must be string');
        }
        if (value !== undefined) {
            if (this.element !== this.container) {
                if (this.element.value !== undefined) {
                    this.element.value = value;
                }
                else {
                    this.element.innerHTML = value;
                }
            }
        }
        else {
            value = this.getElementValue();
        }
        if (value !== this.getEditorValue()) {
            this.setEditorValue(value);
        }
    };
    /**
     * Set editor html value and if set sync fill source element value
     * When method was called without arguments - it is simple way to synchronize editor to element
     *
     * @param {string} [value]
     */
    Jodit.prototype.setEditorValue = function (value) {
        if (!this.editor) {
            return; // try change value before init or after destruct
        }
        if (typeof value !== 'string' && value !== undefined) {
            throw new Error('value must be string');
        }
        if (value !== undefined && this.editor.innerHTML !== value) {
            this.editor.innerHTML = value;
        }
        var old_value = this.getElementValue(), new_value = this.getEditorValue(); // value may be not equal new_value becouse of afterGetValueFromEditor events
        if (old_value !== new_value) {
            this.setElementValue(new_value);
            this.events.fire('change', new_value, old_value);
        }
    };
    Object.defineProperty(Jodit.prototype, "value", {
        get: function () {
            return this.getEditorValue();
        },
        set: function (html) {
            this.setEditorValue(html);
        },
        enumerable: true,
        configurable: true
    });
    Jodit.prototype.execCustomCommands = function (commandName, second, third) {
        var _this = this;
        if (second === void 0) { second = false; }
        if (third === void 0) { third = null; }
        commandName = commandName.toLowerCase();
        if (this.commands[commandName] !== undefined) {
            var result_1 = void (0);
            this.commands[commandName].forEach(function (command) {
                var callback;
                if (typeof command === 'function') {
                    callback = command;
                }
                else {
                    callback = command.exec;
                }
                var resultCurrent = callback.call(_this, commandName, second, third);
                if (resultCurrent !== undefined) {
                    result_1 = resultCurrent;
                }
            });
            return result_1;
        }
    };
    /**
     * Register custom handler for command
     *
     * @example
     * ```javascript
     * var jodit = new Jodit('#editor);
     *
     * jodit.setEditorValue('test test test');
     *
     * jodit.registerCommand('replaceString', function (command, needle, replace) {
     *      var value = this.getEditorValue();
     *      this.setEditorValue(value.replace(needle, replace));
     *      return false; // stop execute native command
     * });
     *
     * jodit.execCommand('replaceString', 'test', 'stop');
     *
     * console.log(jodit.getEditorValue()); // stop test test
     *
     * // and you can add hotkeys for command
     * jodit.registerCommand('replaceString', {
     *    hotkeys: 'ctrl+r',
     *    exec: function (command, needle, replace) {
     *     var value = this.getEditorValue();
     *     this.setEditorValue(value.replace(needle, replace));
     *    }
     * });
     *
     * ```
     *
     * @param {string} commandNameOriginal
     * @param {CommandType | Function} command
     */
    Jodit.prototype.registerCommand = function (commandNameOriginal, command) {
        var _this = this;
        var commandName = commandNameOriginal.toLowerCase();
        if (this.commands[commandName] === undefined) {
            this.commands[commandName] = [];
        }
        this.commands[commandName].push(command);
        if (typeof command !== 'function') {
            var hotkeys = this.options.commandToHotkeys[commandName] || this.options.commandToHotkeys[commandNameOriginal] || command.hotkeys;
            if (hotkeys) {
                this.events
                    .off(Helpers_1.asArray(hotkeys).map(function (hotkey) { return hotkey + '.hotkey'; }).join(' '))
                    .on(Helpers_1.asArray(hotkeys).map(function (hotkey) { return hotkey + '.hotkey'; }).join(' '), function () {
                    return _this.execCommand(commandName); // because need `beforeCommand`
                });
            }
        }
    };
    /**
     * Execute command editor
     *
     * @method execCommand
     * @param  {string} command command. It supports all the {@link https://developer.mozilla.org/ru/docs/Web/API/Document/execCommand#commands} and a number of its own
     * for example applyCSSProperty. Comand fontSize receives the second parameter px, formatBlock and can take several options
     * @param  {boolean|string|int} second
     * @param  {boolean|string|int} third
     * @fires beforeCommand
     * @fires afterCommand
     * @example
     * ```javascript
     * this.execCommand('fontSize', 12); // sets the size of 12 px
     * this.execCommand('underline');
     * this.execCommand('formatBlock', 'p'); // will be inserted paragraph
     * ```
     */
    Jodit.prototype.execCommand = function (command, second, third) {
        if (second === void 0) { second = false; }
        if (third === void 0) { third = null; }
        if (this.options.readonly && command !== 'selectall') {
            return;
        }
        var result;
        command = command.toLowerCase();
        /**
         * Called before any command
         * @event beforeCommand
         * @param {string} command Command name in lowercase
         * @param {string} second The second parameter for the command
         * @param {string} third The third option is for the team
         * @example
         * ```javascript
         * parent.events.on('beforeCommand', function (command) {
         *  if (command === 'justifyCenter') {
         *      var p = parent.getDocument().createElement('p')
         *      parent.selection.insertNode(p)
         *      parent.selection.setCursorIn(p);
         *      p.style.textAlign = 'justyfy';
         *      return false; // break execute native command
         *  }
         * })
         * ```
         */
        result = this.events.fire('beforeCommand', command, second, third);
        if (result !== false) {
            result = this.execCustomCommands(command, second, third);
        }
        if (result !== false) {
            this.selection.focus();
            switch (command) {
                case 'selectall':
                    this.selection.select(this.editor, true);
                    break;
                default:
                    try {
                        result = this.editorDocument.execCommand(command, second, third);
                    }
                    catch (e) {
                    }
            }
        }
        /**
         * It called after any command
         * @event afterCommand
         * @param {string} command name command
         * @param {*} second The second parameter for the command
         * @param {*} third The third option is for the team
         */
        this.events.fire('afterCommand', command, second, third);
        this.setEditorValue(); // synchrony
        return result;
    };
    /**
     * Disable selecting
     */
    Jodit.prototype.lock = function (name) {
        if (name === void 0) { name = 'any'; }
        if (!this.isLocked()) {
            this.__whoLocked = name;
            this.__selectionLocked = this.selection.save();
            this.editor.classList.add('jodit_disabled');
        }
    };
    /**
     * Enable selecting
     */
    Jodit.prototype.unlock = function () {
        if (this.isLocked()) {
            this.__whoLocked = '';
            this.editor.classList.remove('jodit_disabled');
            if (this.__selectionLocked) {
                this.selection.restore(this.__selectionLocked);
            }
        }
    };
    /**
     * Return current editor mode: Jodit.MODE_WYSIWYG, Jodit.MODE_SOURCE or Jodit.MODE_SPLIT
     * @return {number}
     */
    Jodit.prototype.getMode = function () {
        return this.mode;
    };
    Jodit.prototype.isEditorMode = function () {
        return this.getRealMode() === consts.MODE_WYSIWYG;
    };
    /**
     * Return current real work mode. When editor in MODE_SOURCE or MODE_WYSIWYG it will return them, but then editor in MODE_SPLIT it will return MODE_SOURCE if Textarea(CodeMirror) focused or MODE_WYSIWYG otherwise
     *
     * @example
     * ```javascript
     * var editor = new Jodit('#editor');
     * console.log(editor.getRealMode());
     * ```
     */
    Jodit.prototype.getRealMode = function () {
        return this.getMode() !== consts.MODE_SPLIT ? this.getMode() : (Dom_1.Dom.isOrContains(this.editor, this.ownerDocument.activeElement) || Dom_1.Dom.isOrContains(this.toolbar.container, this.ownerDocument.activeElement)) ? consts.MODE_WYSIWYG : consts.MODE_SOURCE;
    };
    /**
     * Set current mode
     *
     * @fired beforeSetMode
     * @fired afterSetMode
     */
    Jodit.prototype.setMode = function (mode) {
        var _this = this;
        var oldmode = this.getMode();
        var data = {
            mode: parseInt(mode.toString(), 10)
        }, modeClasses = ['jodit_wysiwyg_mode', 'jodit_source_mode', 'jodit_split_mode'];
        /**
         * Triggered before {@link Jodit~setMode|setMode} executed. If returned false method stopped
         * @event beforeSetMode
         * @param {Object} data PlainObject {mode: {string}} In handler you can change data.mode
         * @example
         * ```javascript
         * var editor = new Jodit("#redactor");
         * editor.events.on('beforeSetMode', function (data) {
         *     data.mode = Jodit.MODE_SOURCE; // not respond to the mode change. Always make the source code mode
         * });
         * ```
         */
        if (this.events.fire('beforeSetMode', data) === false) {
            return;
        }
        this.mode = Helpers_1.inArray(data.mode, [consts.MODE_SOURCE, consts.MODE_WYSIWYG, consts.MODE_SPLIT]) ? data.mode : consts.MODE_WYSIWYG;
        if (this.options.saveModeInStorage) {
            this.storage.set('jodit_default_mode', this.mode);
        }
        modeClasses.forEach(function (className) {
            _this.container.classList.remove(className);
        });
        this.container.classList.add(modeClasses[this.mode - 1]);
        /**
         * Triggered after {@link Jodit~setMode|setMode} executed
         * @event afterSetMode
         * @example
         * ```javascript
         * var editor = new Jodit("#redactor");
         * editor.events.on('afterSetMode', function () {
         *     editor.setEditorValue(''); // clear editor's value after change mode
         * });
         * ```
         */
        if (oldmode !== this.getMode()) {
            this.events.fire('afterSetMode');
        }
    };
    /**
     * Toggle editor mode WYSIWYG to TEXTAREA(CodeMirror) to SPLIT(WYSIWYG and TEXTAREA) to again WYSIWYG
     *
     * @example
     * ```javascript
     * var editor = new Jodit('#editor');
     * editor.toggleMode();
     * ```
     */
    Jodit.prototype.toggleMode = function () {
        var mode = this.getMode();
        if (Helpers_1.inArray(mode + 1, [consts.MODE_SOURCE, consts.MODE_WYSIWYG, this.options.useSplitMode ? consts.MODE_SPLIT : 9])) {
            mode += 1;
        }
        else {
            mode = consts.MODE_WYSIWYG;
        }
        this.setMode(mode);
    };
    /**
     * Internationalization method. Uses Jodit.lang object
     *
     * @param {string} key Some text
     * @param {string[]} params Some text
     * @return {string}
     * @example
     * ```javascript
     * var editor = new Jodit("#redactor", {
     *      langusage: 'ru'
     * });
     * console.log(editor.i18n('Cancel')) //Отмена;
     *
     * Jodit.defaultOptions.language = 'ru';
     * console.log(Jodit.prototype.i18n('Cancel')) //Отмена
     *
     * Jodit.lang.cs = {
     *    Cancel: 'Zrušit'
     * };
     * Jodit.defaultOptions.language = 'cs';
     * console.log(Jodit.prototype.i18n('Cancel')) //Zrušit
     *
     * Jodit.lang.cs = {
     *    'Hello world': 'Hello \s Good \s'
     * };
     * Jodit.defaultOptions.language = 'cs';
     * console.log(Jodit.prototype.i18n('Hello world', 'mr.Perkins', 'day')) //Hello mr.Perkins Good day
     * ```
     */
    Jodit.prototype.i18n = function (key) {
        var _this = this;
        var params = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            params[_i - 1] = arguments[_i];
        }
        var debug = this.options !== undefined && this.options.debugLanguage;
        var store, parse = function (value) { return params.length ? Helpers_1.sprintf.apply(_this, [value].concat(params)) : value; }, default_language = Jodit.defaultOptions.language === 'auto' ? Helpers_1.defaultLanguage(Jodit.defaultOptions.language) : Jodit.defaultOptions.language, language = Helpers_1.defaultLanguage(this.options ? this.options.language : default_language);
        if (this.options !== undefined &&
            Jodit.lang[language] !== undefined) {
            store = Jodit.lang[language];
        }
        else {
            if (Jodit.lang[default_language] !== undefined) {
                store = Jodit.lang[default_language];
            }
            else {
                store = Jodit.lang.en;
            }
        }
        if (this.options !== undefined &&
            this.options.i18n[language] !== undefined &&
            this.options.i18n[language][key]) {
            return parse(this.options.i18n[language][key]);
        }
        if (typeof store[key] === 'string' && store[key]) {
            return parse(store[key]);
        }
        if (debug) {
            console.warn("In " + language + " not exists \"" + key + "\"");
            return '{' + key + '}';
        }
        if (typeof Jodit.lang.en[key] === 'string' && Jodit.lang.en[key]) {
            return parse(Jodit.lang.en[key]);
        }
        return parse(key);
    };
    /**
     * Switch on/off the editor into the read-only state.
     * When in readonly, the user is not able to change the editor content, but can still use some editor functions (show source code, print content, or seach).
     * This function firing the `readonly` event.
     *
     * @param {boolean} isReadOnly
     */
    Jodit.prototype.setReadOnly = function (isReadOnly) {
        this.options.readonly = isReadOnly;
        if (isReadOnly) {
            this.editor && this.editor.removeAttribute('contenteditable');
        }
        else {
            this.editor && this.editor.setAttribute('contenteditable', 'true');
        }
        this.events && this.events.fire('readonly', isReadOnly);
    };
    /**
     * Return true if editor in read-only mode
     */
    Jodit.prototype.getReadOnly = function () {
        return this.options.readonly;
    };
    Jodit.prototype.toggleFullSize = function (isFullSize) {
        if (isFullSize === undefined) {
            isFullSize = !this.__isFullSize;
        }
        if (isFullSize === this.__isFullSize) {
            return;
        }
        this.__isFullSize = isFullSize;
        if (this.events) {
            this.events.fire('toggleFullSize', isFullSize);
        }
    };
    Object.defineProperty(Jodit.prototype, "defaultTimeout", {
        /**
         * Return default timeout period in milliseconds for some debounce or throttle functions. By default return {observer.timeout} options
         *
         * @return {number}
         */
        get: function () {
            return (this.options && this.options.observer) ? this.options.observer.timeout : Jodit.defaultOptions.observer.timeout;
        },
        enumerable: true,
        configurable: true
    });
    Jodit.Array = function (array) {
        return new Helpers_1.JoditArray(array);
    };
    Jodit.Object = function (object) {
        return new Helpers_1.JoditObject(object);
    };
    Jodit.plugins = {};
    Jodit.modules = {};
    Jodit.instances = {};
    Jodit.lang = {};
    return Jodit;
}(Component_1.Component));
exports.Jodit = Jodit;


/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Jodit_1 = __webpack_require__(6);
var Component_1 = __webpack_require__(4);
var Config_1 = __webpack_require__(1);
var Helpers_1 = __webpack_require__(0);
var ToolbarCollection_1 = __webpack_require__(5);
var constants_1 = __webpack_require__(2);
var EventsNative_1 = __webpack_require__(11);
Config_1.Config.prototype.dialog = {
    zIndex: 100002,
    resizable: true,
    draggable: true,
    fullsize: false,
    fullsizeButton: false,
};
/**
 * Module to generate dialog windows
 *
 * @param {Object} parent Jodit main object
 * @param {Object} [opt] Extend Options
 */
var Dialog = /** @class */ (function (_super) {
    __extends(Dialog, _super);
    function Dialog(jodit, options) {
        if (options === void 0) { options = {}; }
        var _this = _super.call(this, jodit) || this;
        _this.lockSelect = function () {
            _this.dialogbox.classList.add('jodit_dialog_box-moved');
        };
        _this.unlockSelect = function () {
            _this.dialogbox.classList.remove('jodit_dialog_box-moved');
        };
        _this.destinition = document.body;
        _this.document = document;
        _this.window = window;
        _this.destroyAfterClose = false;
        _this.moved = false;
        _this.iSetMaximization = false;
        _this.resizeble = false;
        _this.draggable = false;
        _this.startX = 0;
        _this.startY = 0;
        _this.startPoint = { x: 0, y: 0, w: 0, h: 0 };
        _this.__isDestructed = false;
        /**
         * Closes the dialog box , if you want to call the method {@link Dialog~destruct|destruct}
         *
         * @see destroy
         * @method close
         * @fires beforeClose
         * @fires afterClose
         * @example
         * ```javascript
         * //You can close dialog two ways
         * var dialog = new Jodit.modules.Dialog();
         * dialog.open('Hello world!', 'Title');
         * var $close = Jodit.modules.helper.dom('<a href="javascript:void(0)" style="float:left;" class="jodit_button"><i class="icon icon-check"></i>&nbsp;' + Jodit.prototype.i18n('Ok') + '</a>');
         * $close.addEventListener('click', function () {
         *     dialog.close();
         * });
         * dialog.setFooter($close);
         * // and second way, you can close dialog from content
         * dialog.open('<a onclick="var event = doc.createEvent('HTMLEvents'); event.initEvent('close_dialog', true, true); this.dispatchEvent(event)">Close</a>', 'Title');
         * ```
         */
        _this.close = function (e) {
            if (_this.__isDestructed) {
                return;
            }
            if (e) {
                e.stopImmediatePropagation();
                e.preventDefault();
            }
            /**
             * Called up to close the window
             *
             * @event beforeClose
             * @this {Dialog} current dialog
             */
            if (_this.jodit && _this.jodit.events) {
                _this.jodit.events.fire(_this, 'beforeClose');
            }
            _this.dialogbox.classList && _this.dialogbox.classList.remove('active');
            if (_this.iSetMaximization) {
                _this.maximization(false);
            }
            if (_this.destroyAfterClose) {
                _this.destruct();
            }
            /**
             * It called after the window is closed
             *
             * @event afterClose
             * @this {Dialog} current dialog
             */
            if (_this.jodit && _this.jodit.events) {
                _this.jodit.events.fire(_this, 'afterClose');
            }
        };
        if (jodit && jodit instanceof Jodit_1.Jodit) {
            _this.window = jodit.ownerWindow;
            _this.document = jodit.ownerDocument;
            jodit.events.on('beforeDestruct', function () {
                _this.destruct();
            });
        }
        _this.events = (jodit && jodit.events) ? jodit.events : new EventsNative_1.EventsNative();
        var self = _this;
        self.options = (jodit && jodit.options) ? jodit.options.dialog : Config_1.Config.prototype.dialog;
        self.options = __assign({}, self.options, options);
        self.dialogbox = Helpers_1.dom('<div style="z-index:' + self.options.zIndex + '" class="jodit jodit_dialog_box">' +
            '<div class="jodit_dialog_overlay"></div>' +
            '<div class="jodit_dialog">' +
            '<div class="jodit_dialog_header non-selected">' +
            '<div class="jodit_dialog_header-title"></div>' +
            '<a href="javascript:void(0)" title="Close" class="jodit_dialog_header-button jodit_close">' + (Jodit_1.Jodit.modules.Toolbar ? Jodit_1.Jodit.modules.ToolbarIcon.getIcon('cancel') : '&times;') + '</a>' +
            '</div>' +
            '<div class="jodit_dialog_content"></div>' +
            '<div class="jodit_dialog_footer"></div>' +
            (self.options.resizable ?
                '<div class="jodit_dialog_resizer"></div>' :
                '') +
            '</div>' +
            '</div>', _this.document);
        if (jodit && jodit.id) {
            self.dialogbox.setAttribute('data-editor_id', jodit.id);
        }
        Object.defineProperty(self.dialogbox, '__jodit_dialog', {
            value: self
        });
        self.dialog = self.dialogbox.querySelector('.jodit_dialog');
        self.resizer = self.dialogbox.querySelector('.jodit_dialog_resizer');
        if (self.jodit && self.jodit.options && self.jodit.options.textIcons) {
            self.dialogbox.classList.add('jodit_text_icons');
        }
        self.dialogbox_header = self.dialogbox.querySelector('.jodit_dialog_header>.jodit_dialog_header-title');
        self.dialogbox_content = self.dialogbox.querySelector('.jodit_dialog_content');
        self.dialogbox_footer = self.dialogbox.querySelector('.jodit_dialog_footer');
        self.dialogbox_close = self.dialogbox.querySelector('.jodit_dialog_header>a.jodit_close');
        self.dialogbox_fullsize = Helpers_1.dom('<a href="javascript:void(0)" class="jodit_dialog_header-button jodit_dialog_header_fullsize">' + ToolbarCollection_1.ToolbarIcon.getIcon(!options.fullsize ? 'fullsize' : 'shrink') + '</a>', _this.document);
        self.destinition.appendChild(self.dialogbox);
        self.dialogbox.addEventListener('close_dialog', self.close);
        self.dialogbox_close.addEventListener('mousedown', self.close);
        self.dialogbox_fullsize.addEventListener('click', function () {
            var fullSize = self.maximization();
            self.dialogbox_fullsize.innerHTML = ToolbarCollection_1.ToolbarIcon.getIcon(!fullSize ? 'fullsize' : 'shrink');
        });
        self.events
            .on(_this.window, 'mousemove', self.onMouseMove.bind(self))
            .on(_this.window, 'mouseup', self.onMouseUp.bind(self))
            .on(_this.window, 'keydown', self.onKeyDown.bind(self))
            .on(_this.window, 'resize', self.onResize.bind(self));
        var headerBox = self.dialogbox.querySelector('.jodit_dialog_header');
        headerBox && headerBox.addEventListener('mousedown', self.onHeaderMouseDown.bind(self));
        if (self.options.resizable) {
            self.resizer
                .addEventListener('mousedown', self.onResizerMouseDown.bind(self));
        }
        return _this;
    }
    /**
     * Get dom element (div.jodit_dialog_box > .div.jodit_dialog)
     *
     * @return {HTMLDivElement}
     */
    // getDialog() {
    //     return this.dialog;
    // }
    /**
     * Get dom element (div.jodit_dialog_box)
     *
     * @return {HTMLDivElement}
     */
    // getBox() {
    //     return this.dialogbox;
    // }
    /**
     * Specifies the size of the window
     *
     * @param {number} [w] - The width of the window
     * @param {number} [h] - The height of the window
     */
    Dialog.prototype.setSize = function (w, h) {
        if (w) {
            Helpers_1.css(this.dialog, 'width', w);
        }
        if (h) {
            Helpers_1.css(this.dialog, 'height', h);
        }
    };
    /**
     * Specifies the position of the upper left corner of the window . If x and y are specified, the window is centered on the center of the screen
     *
     * @param {Number} [x] - Position px Horizontal
     * @param {Number} [y] - Position px Vertical
     */
    Dialog.prototype.setPosition = function (x, y) {
        var w = this.window.innerWidth, h = this.window.innerHeight, left = w / 2 - this.dialog.offsetWidth / 2, top = h / 2 - this.dialog.offsetHeight / 2;
        if (x !== undefined && y !== undefined) {
            this.offsetX = x;
            this.offsetY = y;
            this.moved = (Math.abs(x - left) > 100 || Math.abs(y - top) > 100);
        }
        this.dialog.style.left = (x || left) + 'px';
        this.dialog.style.top = (y || top) + 'px';
    };
    Dialog.prototype.setElements = function (root, elements) {
        var _this = this;
        var elements_list = [];
        Helpers_1.asArray(elements).forEach(function (elm) {
            var element = Helpers_1.dom(elm, _this.document);
            elements_list.push(element);
            if (element.parentNode !== root) {
                root.appendChild(element);
            }
        });
        [].slice.call(root.childNodes).forEach(function (elm) {
            if (elements_list.indexOf(elm) === -1) {
                root.removeChild(elm);
            }
        });
    };
    /**
     * Specifies the dialog box title . It can take a string and an array of objects
     *
     * @param {string|string[]|Element|Element[]} content - A string or an HTML element , or an array of strings and elements
     * @example
     * ```javascript
     * var dialog = new Jodi.modules.Dialog(parent);
     * dialog.setTitle('Hello world');
     * dialog.setTitle(['Hello world', '<button>OK</button>', $('<div>some</div>')]);
     * dialog.open();
     * ```
     */
    Dialog.prototype.setTitle = function (content) {
        this.setElements(this.dialogbox_header, content);
    };
    /**
     * It specifies the contents of the dialog box. It can take a string and an array of objects
     *
     * @param {string|string[]|Element|Element[]} content A string or an HTML element , or an array of strings and elements
     * @example
     * ```javascript
     * var dialog = new Jodi.modules.Dialog(parent);
     * dialog.setTitle('Hello world');
     * dialog.setContent('<form onsubmit="alert(1);"><input type="text" /></form>');
     * dialog.open();
     * ```
     */
    Dialog.prototype.setContent = function (content) {
        this.setElements(this.dialogbox_content, content);
    };
    /**
     * Sets the bottom of the dialog. It can take a string and an array of objects
     *
     * @param {string|string[]|Element|Element[]} content - A string or an HTML element , or an array of strings and elements
     * @example
     * ```javascript
     * var dialog = new Jodi.modules.Dialog(parent);
     * dialog.setTitle('Hello world');
     * dialog.setContent('<form><input id="someText" type="text" /></form>');
     * dialog.setFooter([
     *  $('<a class="jodit_button">OK</a>').click(function () {
     *      alert($('someText').val())
     *      dialog.close();
     *  })
     * ]);
     * dialog.open();
     * ```
     */
    Dialog.prototype.setFooter = function (content) {
        this.setElements(this.dialogbox_footer, content);
        this.dialog.classList.toggle('with_footer', !!content);
    };
    /**
     * Return current Z-index
     * @return {number}
     */
    Dialog.prototype.getZIndex = function () {
        return parseInt(this.dialogbox.style.zIndex || '0', 10);
    };
    /**
     * Get dialog instance with maximum z-index displaying it on top of all the dialog boxes
     *
     * @return {Dialog}
     */
    Dialog.prototype.getMaxZIndexDialog = function () {
        var maxzi = 0, dlg, zIndex, res = this;
        Helpers_1.$$('.jodit_dialog_box', this.destinition).forEach(function (dialog) {
            dlg = dialog['__jodit_dialog'];
            zIndex = parseInt(Helpers_1.css(dialog, 'zIndex'), 10);
            if (dlg.isOpened() && !isNaN(zIndex) && zIndex > maxzi) {
                res = dlg;
                maxzi = zIndex;
            }
        });
        return res;
    };
    /**
     * Sets the maximum z-index dialog box, displaying it on top of all the dialog boxes
     */
    Dialog.prototype.setMaxZIndex = function () {
        var maxzi = 0, zIndex = 0;
        Helpers_1.$$('.jodit_dialog_box', this.destinition).forEach(function (dialog) {
            zIndex = parseInt(Helpers_1.css(dialog, 'zIndex'), 10);
            maxzi = Math.max(isNaN(zIndex) ? 0 : zIndex, maxzi);
        });
        this.dialogbox
            .style.zIndex = (maxzi + 1).toString();
    };
    /**
     * Expands the dialog on full browser window
     *
     * @param {boolean} condition true - fullsize
     * @return {boolean} true - fullsize
     */
    Dialog.prototype.maximization = function (condition) {
        if (typeof condition !== 'boolean') {
            condition = !this.dialogbox.classList.contains('jodit_dialog_box-fullsize');
        }
        this.dialogbox.classList
            .toggle('jodit_dialog_box-fullsize', condition);
        [this.destinition, this.destinition.parentNode].forEach(function (box) {
            box && box.classList && box.classList.toggle('jodit_fullsize_box', condition);
        });
        this.iSetMaximization = condition;
        return condition;
    };
    /**
     * It opens a dialog box to center it, and causes the two event.
     *
     * @param {string|string[]|Element|Element[]} [content]  specifies the contents of the dialog box. Can be false или undefined. see {@link Dialog~setContent|setContent}
     * @param {string|string[]|Element|Element[]} [title]  specifies the title of the dialog box, @see setTitle
     * @param {boolean} [destroyAfter] true - After closing the window , the destructor will be called. see {@link Dialog~destruct|destruct}
     * @param {boolean} [modal] - true window will be opened in modal mode
     * @fires {@link event:beforeOpen} id returns 'false' then the window will not open
     * @fires {@link event:afterOpen}
     */
    Dialog.prototype.open = function (content, title, destroyAfter, modal) {
        /**
         * Called before the opening of the dialog box
         *
         * @event beforeOpen
         */
        if (this.jodit && this.jodit.events) {
            if (this.jodit.events.fire(this, 'beforeOpen') === false) {
                return;
            }
        }
        this.destroyAfterClose = (destroyAfter === true);
        if (this.options.fullsizeButton && this.dialogbox_close.parentNode) {
            this.dialogbox_close.parentNode.appendChild(this.dialogbox_fullsize);
        }
        if (title !== undefined) {
            this.setTitle(title);
        }
        if (content) {
            this.setContent(content);
        }
        this.dialogbox.classList.add('active');
        if (modal) {
            this.dialogbox.classList.add('jodit_modal');
        }
        this.setPosition(this.offsetX, this.offsetY);
        this.setMaxZIndex();
        if (this.options.fullsize) {
            this.maximization(true);
        }
        /**
         * Called after the opening of the dialog box
         *
         * @event afterOpen
         */
        if (this.jodit && this.jodit.events) {
            this.jodit.events.fire(this, 'afterOpen');
        }
    };
    /**
     * Open if the current window
     *
     * @return {boolean} - true window open
     */
    Dialog.prototype.isOpened = function () {
        return !this.__isDestructed && this.dialogbox.classList.contains('active');
    };
    Dialog.prototype.onMouseUp = function () {
        if (this.draggable || this.resizeble) {
            this.draggable = false;
            this.resizeble = false;
            this.unlockSelect();
            if (this.jodit && this.jodit.events) {
                /**
                 * Fired when dialog box is finished to resizing
                 * @event endResize
                 */
                this.jodit.events.fire(this, 'endResize endMove');
            }
        }
    };
    /**
     *
     * @param {MouseEvent} e
     */
    Dialog.prototype.onHeaderMouseDown = function (e) {
        var target = e.target;
        if (!this.options.draggable || (target && target.nodeName.match(/^(INPUT|SELECT)$/))) {
            return;
        }
        this.draggable = true;
        this.startX = e.clientX;
        this.startY = e.clientY;
        this.startPoint.x = Helpers_1.css(this.dialog, 'left');
        this.startPoint.y = Helpers_1.css(this.dialog, 'top');
        this.setMaxZIndex();
        e.preventDefault();
        this.lockSelect();
        if (this.jodit && this.jodit.events) {
            /**
             * Fired when dialog box is started moving
             * @event startMove
             */
            this.jodit.events.fire(this, 'startMove');
        }
    };
    Dialog.prototype.onMouseMove = function (e) {
        if (this.draggable && this.options.draggable) {
            this.setPosition(this.startPoint.x + e.clientX - this.startX, this.startPoint.y + e.clientY - this.startY);
            if (this.jodit && this.jodit.events) {
                /**
                 * Fired when dialog box is moved
                 * @event move
                 * @param {int} dx Delta X
                 * @param {int} dy Delta Y
                 */
                this.jodit.events.fire(this, 'move', e.clientX - this.startX, e.clientY - this.startY);
            }
            e.stopImmediatePropagation();
            e.preventDefault();
        }
        if (this.resizeble && this.options.resizable) {
            this.setSize(this.startPoint.w + e.clientX - this.startX, this.startPoint.h + e.clientY - this.startY);
            if (this.jodit && this.jodit.events) {
                /**
                 * Fired when dialog box is resized
                 * @event resizeDialog
                 * @param {int} dx Delta X
                 * @param {int} dy Delta Y
                 */
                this.jodit.events.fire(this, 'resizeDialog', e.clientX - this.startX, e.clientY - this.startY);
            }
            e.stopImmediatePropagation();
            e.preventDefault();
        }
    };
    /**
     *
     * @param {MouseEvent} e
     */
    Dialog.prototype.onKeyDown = function (e) {
        if (this.isOpened() && e.which === constants_1.KEY_ESC) {
            var me = this.getMaxZIndexDialog();
            if (me) {
                me.close();
            }
            else {
                this.close();
            }
            e.stopImmediatePropagation();
        }
    };
    Dialog.prototype.onResize = function () {
        if (this.options.resizable && !this.moved && this.isOpened() && !this.offsetX && !this.offsetY) {
            this.setPosition();
        }
    };
    /**
     * It destroys all objects created for the windows and also includes all the handlers for the window object
     */
    Dialog.prototype.destruct = function () {
        if (this.__isDestructed) {
            return;
        }
        if (this.dialogbox && this.dialogbox.parentNode) {
            this.dialogbox.parentNode.removeChild(this.dialogbox);
        }
        delete this.dialogbox;
        if (!this.jodit || !this.jodit.events) {
            this.events.destruct();
        }
        this.__isDestructed = true;
    };
    Dialog.prototype.onResizerMouseDown = function (e) {
        this.resizeble = true;
        this.startX = e.clientX;
        this.startY = e.clientY;
        this.startPoint.w = this.dialog.offsetWidth;
        this.startPoint.h = this.dialog.offsetHeight;
        this.lockSelect();
        if (this.jodit.events) {
            /**
             * Fired when dialog box is started resizing
             * @event startResize
             */
            this.jodit.events.fire(this, 'startResize');
        }
    };
    return Dialog;
}(Component_1.Component));
exports.Dialog = Dialog;
/**
 * Show `alert` dialog. Work without Jodit object
 *
 * @method Alert
 * @param {string} msg Message
 * @param {string|function} [title] Title or callback
 * @param {function} [callback] callback
 * @param {string} [className]
 * @example
 * ```javascript
 * Jodit.Alert("File was uploaded");
 * Jodit.Alert("File was uploaded", "Message");
 * Jodit.Alert("File was uploaded", function() {
 *    $('form').hide();
 * });
 * Jodit.Alert("File wasn't uploaded", "Error", function() {
 *    $('form').hide();
 * });
 * ```
 */
exports.Alert = function (msg, title, callback, className) {
    if (className === void 0) { className = 'jodit_alert'; }
    if (typeof title === 'function') {
        callback = title;
        title = undefined;
    }
    var dialog = new Dialog(), $div = Helpers_1.dom('<div class="' + className + '"></div>', dialog.document), $ok = Helpers_1.dom('<a href="javascript:void(0)" style="float:right;" class="jodit_button">' + ToolbarCollection_1.ToolbarIcon.getIcon('cancel') + '<span>' + Jodit_1.Jodit.prototype.i18n('Ok') + '</span></a>', dialog.document);
    $div.appendChild(Helpers_1.dom(msg, dialog.document));
    $ok.addEventListener('click', function () {
        if (!callback || typeof callback !== 'function' || callback(dialog) !== false) {
            dialog.close();
        }
    });
    dialog.setFooter([
        $ok
    ]);
    dialog.open($div, title || '&nbsp;', true, true);
    $ok.focus();
    return dialog;
};
Jodit_1.Jodit['Alert'] = exports.Alert;
/**
 * Show `promt` dialog. Work without Jodit object
 *
 * @method Promt
 * @param {string} msg Message
 * @param {string|function} [title] Title or callback
 * @param {function} [callback] callback. The first argument is the value entered
 * @param {string} [placeholder] Placeholder for input
 * @example
 * ```javascript
 * Jodit.Promt("Enter your name", "Promt Dialog", function (name) {
 *     if (name.length < 3) {
 *         Jodit.Alert("The name must be at least 3 letters");
 *         return false;
 *     }
 *     // do something
 * });
 * ```
 */
exports.Promt = function (msg, title, callback, placeholder) {
    var dialog = new Dialog(), $cancel = Helpers_1.dom('<a href="javascript:void(0)" style="float:right;" class="jodit_button">' + ToolbarCollection_1.ToolbarIcon.getIcon('cancel') + '<span>' + Jodit_1.Jodit.prototype.i18n('Cancel') + '</span></a>', dialog.document), $ok = Helpers_1.dom('<a href="javascript:void(0)" style="float:left;" class="jodit_button">' + ToolbarCollection_1.ToolbarIcon.getIcon('check') + '<span>' + Jodit_1.Jodit.prototype.i18n('Ok') + '</span></a>', dialog.document), $div = Helpers_1.dom('<form class="jodit_promt"></form>', dialog.document), $input = Helpers_1.dom('<input autofocus/>', dialog.document), $label = Helpers_1.dom('<label></label>', dialog.document);
    if (typeof title === 'function') {
        callback = title;
        title = undefined;
    }
    if (placeholder) {
        $input.setAttribute('placeholder', placeholder);
    }
    $label.appendChild(Helpers_1.dom(msg, dialog.document));
    $div.appendChild($label);
    $div.appendChild($input);
    $cancel.addEventListener('click', dialog.close, false);
    var onclick = function () {
        if (!callback || typeof callback !== 'function' || callback($input.value) !== false) {
            dialog.close();
        }
    };
    $ok.addEventListener('click', onclick);
    $div.addEventListener('submit', function () {
        onclick();
        return false;
    });
    dialog.setFooter([
        $ok,
        $cancel
    ]);
    dialog.open($div, title || '&nbsp;', true, true);
    $input.focus();
    return dialog;
};
Jodit_1.Jodit['Promt'] = exports.Promt;
/**
 * Show `confirm` dialog. Work without Jodit object
 *
 * @method Confirm
 * @param {string} msg Message
 * @param {string|function} [title] Title or callback
 * @param {function} [callback] callback. The first argument is the value entered
 * @example
 * ```javascript
 * Jodit.Confirm("Are you shure?", "Confirm Dialog", function (yes) {
 *     if (yes) {
 *         // do something
 *     }
 * });
 * ```
 */
exports.Confirm = function (msg, title, callback) {
    var dialog = new Dialog(), $div = Helpers_1.dom('<form class="jodit_promt"></form>', dialog.document), $label = Helpers_1.dom('<label></label>', dialog.document);
    if (typeof title === 'function') {
        callback = title;
        title = undefined;
    }
    $label.appendChild(Helpers_1.dom(msg, dialog.document));
    $div.appendChild($label);
    var $cancel = Helpers_1.dom('<a href="javascript:void(0)" style="float:right;" class="jodit_button">' +
        ToolbarCollection_1.ToolbarIcon.getIcon('cancel') +
        '<span>' + Jodit_1.Jodit.prototype.i18n('Cancel') + '</span>' +
        '</a>', dialog.document);
    $cancel.addEventListener('click', function () {
        if (callback) {
            callback(false);
        }
        dialog.close();
    });
    var onok = function () {
        if (callback) {
            callback(true);
        }
        dialog.close();
    };
    var $ok = Helpers_1.dom('<a href="javascript:void(0)" style="float:left;" class="jodit_button">' +
        ToolbarCollection_1.ToolbarIcon.getIcon('check') + '<span>' + Jodit_1.Jodit.prototype.i18n('Yes') + '</span>' +
        '</a>', dialog.document);
    $ok.addEventListener('click', onok);
    $div.addEventListener('submit', function () {
        onok();
        return false;
    });
    dialog.setFooter([
        $ok,
        $cancel
    ]);
    dialog.open($div, title || '&nbsp;', true, true);
    $ok.focus();
    return dialog;
};
Jodit_1.Jodit['Confirm'] = exports.Confirm;


/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Component_1 = __webpack_require__(4);
var Plugin = /** @class */ (function (_super) {
    __extends(Plugin, _super);
    function Plugin(jodit) {
        var _this = _super.call(this, jodit) || this;
        jodit.events
            .on('afterInit', _this.afterInit.bind(_this, jodit))
            .on('beforeDestruct', _this.beforeDestruct.bind(_this, jodit));
        return _this;
    }
    Plugin.prototype.beforeDestruct = function (jodit) { };
    ;
    return Plugin;
}(Component_1.Component));
exports.Plugin = Plugin;


/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Jodit_1 = __webpack_require__(6);
var Ajax_1 = __webpack_require__(14);
var Config_1 = __webpack_require__(1);
var Helpers_1 = __webpack_require__(0);
var constants_1 = __webpack_require__(2);
var Selection_1 = __webpack_require__(13);
/**
 * Module for processing download documents and images by Drag and Drop
 *
 * @tutorial {@link http://xdsoft.net/jodit/doc/tutorial-uploader-settings.html|Uploader options and Drag and Drop files}
 * @module Uploader
 * @params {Object} parent Jodit main object
 */
/**
 * @property {boolean} enableDragAndDropFileToEditor=true Enable drag and drop file toWYSIWYG editor
 */
Config_1.Config.prototype.enableDragAndDropFileToEditor = true;
Config_1.Config.prototype.uploader = {
    url: '',
    insertImageAsBase64URI: false,
    imagesExtensions: ['jpg', 'png', 'jpeg', 'gif'],
    headers: null,
    data: null,
    format: 'json',
    prepareData: function (formData) {
        return formData;
    },
    isSuccess: function (resp) {
        return resp.success;
    },
    getMessage: function (resp) {
        return (resp.data.messages !== undefined && Array.isArray(resp.data.messages)) ? resp.data.messages.join(' ') : '';
    },
    process: function (resp) {
        return resp.data;
    },
    error: function (e) {
        this.jodit.events.fire('errorMessage', e.message, 'error', 4000);
    },
    defaultHandlerSuccess: function (resp) {
        var _this = this;
        if (resp.files && resp.files.length) {
            resp.files.forEach(function (filename, index) {
                var _a = (resp.isImages && resp.isImages[index]) ? ['img', 'src'] : ['a', 'href'], tagName = _a[0], attr = _a[1];
                var elm = _this.jodit.editorDocument.createElement(tagName);
                elm.setAttribute(attr, resp.baseurl + filename);
                if (tagName === 'a') {
                    elm.innerText = resp.baseurl + filename;
                }
                if (tagName === 'img') {
                    _this.selection.insertImage(elm);
                }
                else {
                    _this.selection.insertNode(elm);
                }
            });
        }
    },
    defaultHandlerError: function (e) {
        this.jodit.events.fire('errorMessage', e.message);
    },
    contentType: function (requestData) {
        return (this.jodit.ownerWindow.FormData !== undefined && typeof requestData !== 'string') ? false : 'application/x-www-form-urlencoded; charset=UTF-8';
    }
};
var Uploader = /** @class */ (function () {
    function Uploader(editor, options) {
        var _this = this;
        this.path = '';
        this.source = 'default';
        this.jodit = editor;
        this.selection = editor instanceof Jodit_1.Jodit ? editor.selection : new Selection_1.Select(editor);
        this.options = Helpers_1.extend(true, {}, Config_1.Config.prototype.uploader, editor instanceof Jodit_1.Jodit ? editor.options.uploader : null, options);
        if (editor instanceof Jodit_1.Jodit && editor.options.enableDragAndDropFileToEditor && editor.options.uploader && (editor.options.uploader.url || editor.options.uploader.insertImageAsBase64URI)) {
            editor.events.on('afterInit', function () {
                _this.bind(editor.editor);
            });
        }
    }
    Uploader.prototype.buildData = function (data) {
        if (this.options.buildData && typeof this.options.buildData === 'function') {
            return this.options.buildData.call(this, data);
        }
        if (this.jodit.ownerWindow.FormData !== undefined) {
            if (data instanceof FormData) {
                return data;
            }
            if (typeof data === 'string') {
                return data;
            }
            var newdata_1 = new FormData();
            Object.keys(data).forEach(function (key) {
                newdata_1.append(key, data[key]);
            });
            return newdata_1;
        }
        return data;
    };
    Uploader.prototype.send = function (data, success) {
        var _this = this;
        var requestData = this.buildData(data), sendData = function (request) {
            var ajax = new Ajax_1.Ajax(_this.jodit || _this, {
                xhr: function () {
                    var xhr = new XMLHttpRequest();
                    if (_this.jodit.ownerWindow.FormData !== undefined && xhr.upload) {
                        xhr.upload.addEventListener("progress", function (evt) {
                            if (evt.lengthComputable) {
                                var percentComplete = evt.loaded / evt.total;
                                percentComplete = percentComplete * 100;
                                _this.jodit.progress_bar.style.display = 'block';
                                _this.jodit.progress_bar.style.width = percentComplete + '%';
                                if (percentComplete === 100) {
                                    _this.jodit.progress_bar.style.display = 'none';
                                }
                            }
                        }, false);
                    }
                    else {
                        _this.jodit.progress_bar.style.display = 'none';
                    }
                    return xhr;
                },
                method: 'POST',
                data: request,
                url: _this.options.url,
                headers: _this.options.headers,
                queryBuild: _this.options.queryBuild,
                contentType: _this.options.contentType.call(_this, request),
                dataType: _this.options.format || 'json',
            });
            return ajax.send()
                .then(success)
                .catch(function (error) {
                _this.options.error.call(_this, error);
            });
        };
        if (requestData instanceof Promise) {
            return requestData
                .then(sendData)
                .catch(function (error) {
                _this.options.error.call(_this, error);
            });
        }
        else {
            return sendData(requestData);
        }
    };
    Uploader.prototype.sendFiles = function (files, handlerSuccess, handlerError, process) {
        var _this = this;
        if (!files) {
            return Promise.reject(new Error('Need files'));
        }
        var uploader = this;
        var fileList = [].slice.call(files);
        if (!fileList.length) {
            return Promise.reject(new Error('Need files'));
        }
        var promises = [];
        if (this.options.insertImageAsBase64URI) {
            var file_1, i = void 0;
            var _loop_1 = function () {
                file_1 = fileList[i];
                if (file_1 && file_1.type) {
                    var mime = file_1.type.match(/\/([a-z0-9]+)/i);
                    var extension = mime[1] ? mime[1].toLowerCase() : '';
                    if (this_1.options.imagesExtensions.indexOf(extension) !== -1) {
                        var reader_1 = new FileReader();
                        promises.push(new Promise(function (resolve, reject) {
                            reader_1.onerror = reject;
                            reader_1.onloadend = function () {
                                var resp = {
                                    baseurl: '',
                                    files: [reader_1.result],
                                    isImages: [true],
                                };
                                if (typeof (handlerSuccess || uploader.options.defaultHandlerSuccess) === 'function') {
                                    (handlerSuccess || uploader.options.defaultHandlerSuccess).call(uploader, resp);
                                }
                                resolve(resp);
                            };
                            reader_1.readAsDataURL(file_1);
                        }));
                        fileList[i] = null;
                    }
                }
            };
            var this_1 = this;
            for (i = 0; i < fileList.length; i += 1) {
                _loop_1();
            }
        }
        fileList = fileList.filter(function (a) { return a; });
        if (fileList.length) {
            var form_1 = new FormData();
            form_1.append('path', uploader.path);
            form_1.append('source', uploader.source);
            var file = void 0;
            for (var i = 0; i < fileList.length; i += 1) {
                file = fileList[i];
                if (file && file.type) {
                    var mime = file.type.match(/\/([a-z0-9]+)/i);
                    var extension = mime[1] ? mime[1].toLowerCase() : '';
                    form_1.append("files[" + i + "]", fileList[i], fileList[i].name || Math.random().toString().replace('.', '') + '.' + extension);
                }
            }
            if (process) {
                process(form_1);
            }
            if (uploader.options.data && Helpers_1.isPlainObject(uploader.options.data)) {
                Object.keys(uploader.options.data).forEach(function (key) {
                    form_1.append(key, uploader.options.data[key]);
                });
            }
            uploader.options.prepareData.call(this, form_1);
            promises.push(uploader
                .send(form_1, function (resp) {
                if (_this.options.isSuccess.call(uploader, resp)) {
                    if (typeof (handlerSuccess || uploader.options.defaultHandlerSuccess) === 'function') {
                        (handlerSuccess || uploader.options.defaultHandlerSuccess).call(uploader, uploader.options.process.call(uploader, resp));
                    }
                }
                else {
                    if (typeof (handlerError || uploader.options.defaultHandlerError)) {
                        (handlerError || uploader.options.defaultHandlerError).call(uploader, new Error(uploader.options.getMessage.call(uploader, resp)));
                        return;
                    }
                }
            })
                .then(function () {
                _this.jodit.events && _this.jodit.events.fire('filesWereUploaded');
            }));
        }
        return Promise.all(promises);
    };
    /**
     * It sets the path for uploading files
     * @method setPath
     * @param {string} path
     */
    Uploader.prototype.setPath = function (path) {
        this.path = path;
    };
    /**
     * It sets the source for connector
     *
     * @method setSource
     * @param {string} source
     */
    Uploader.prototype.setSource = function (source) {
        this.source = source;
    };
    /**
     * Convert dataURI to Blob
     *
     * @param {string} dataURI
     * @return {Blob}
     */
    Uploader.dataURItoBlob = function (dataURI) {
        // convert base64 toWYSIWYG raw binary data held in a string
        // doesn't handle URLEncoded DataURIs - see SO answer #6850276 for code that does this
        var byteString = atob(dataURI.split(',')[1]), 
        // separate out the mime component
        mimeString = dataURI.split(',')[0].split(':')[1].split(';')[0], 
        // write the bytes of the string toWYSIWYG an ArrayBuffer
        ab = new ArrayBuffer(byteString.length), i, ia = new Uint8Array(ab);
        for (i = 0; i < byteString.length; i += 1) {
            ia[i] = byteString.charCodeAt(i);
        }
        // write the ArrayBuffer toWYSIWYG a blob, and you're done
        return new Blob([ia], { type: mimeString });
    };
    /**
     * Set the handlers Drag and Drop toWYSIWYG `$form`
     *
     * @method bind
     * @param {HTMLElement} form Form or any Node on which you can drag and drop the file. In addition will be processed <code>&lt;input type="file" &gt;</code>
     * @param {function} [handlerSuccess] The function toWYSIWYG be called when a successful uploading files toWYSIWYG the server
     * @param {function} [handlerError] The function that will be called during a failed download files toWYSIWYG a server
     * @example
     * ```javascript
     * var $form = jQuery('<form><input type="text" typpe="file"></form>');
     * jQuery('body').append($form);
     * Jodit.editors.someidfoeditor.uploader.bind($form[0], function (files) {
     *     var i;
     *     for (i = 0; i < data.files.length; i += 1) {
     *         parent.selection.insertImage(data.files[i])
     *     }
     * });
     * ```
     */
    Uploader.prototype.bind = function (form, handlerSuccess, handlerError) {
        var _this = this;
        var self = this, onPaste = function (e) {
            var i, file, extension, process = function (formdata) {
                if (file) {
                    formdata.append('extension', extension);
                    formdata.append("mimetype", file.type);
                }
            };
            // send data on server
            if (e.clipboardData && e.clipboardData.files && e.clipboardData.files.length) {
                _this.sendFiles(e.clipboardData.files, handlerSuccess, handlerError);
                return false;
            }
            if (Helpers_1.browser('ff') || Helpers_1.isIE()) {
                if (e.clipboardData && (!e.clipboardData.types.length && e.clipboardData.types[0] !== constants_1.TEXT_PLAIN)) {
                    var div_1 = Helpers_1.dom('<div tabindex="-1" style="left: -9999px; top: 0; width: 0; height: 100%; line-height: 140%; overflow: hidden; position: fixed; z-index: 2147483647; word-break: break-all;" contenteditable="true"></div>', _this.jodit.ownerDocument);
                    _this.jodit.ownerDocument.body.appendChild(div_1);
                    var selection_1 = (_this.jodit && _this.jodit instanceof Jodit_1.Jodit) ? _this.jodit.selection.save() : null, restore_1 = function () { return selection_1 && (_this.jodit && _this.jodit instanceof Jodit_1.Jodit) && _this.jodit.selection.restore(selection_1); };
                    div_1.focus();
                    setTimeout(function () {
                        var child = div_1.firstChild;
                        if (div_1.parentNode) {
                            div_1.parentNode.removeChild(div_1);
                        }
                        if (child && child.hasAttribute('src')) {
                            var src = child.getAttribute('src') || '';
                            restore_1();
                            self
                                .sendFiles([Uploader.dataURItoBlob(src)], handlerSuccess, handlerError);
                        }
                    }, 200);
                }
                return;
            }
            if (e.clipboardData && e.clipboardData.items && e.clipboardData.items.length) {
                for (i = 0; i < e.clipboardData.items.length; i += 1) {
                    if (e.clipboardData.items[i].kind === "file" && e.clipboardData.items[i].type === "image/png") {
                        file = e.clipboardData.items[i].getAsFile();
                        if (file) {
                            var mime = file.type.match(/\/([a-z0-9]+)/i);
                            extension = mime[1] ? mime[1].toLowerCase() : '';
                            _this.sendFiles([file], handlerSuccess, handlerError, process);
                        }
                        e.preventDefault();
                        break;
                    }
                }
            }
        };
        if (this.jodit && this.jodit.editor !== form) {
            self.jodit.events
                .on(form, 'paste', onPaste);
        }
        else {
            self.jodit.events
                .on('beforePaste', onPaste);
        }
        var hasFiles = function (event) { return event.dataTransfer && event.dataTransfer.files && event.dataTransfer.files.length !== 0; };
        self.jodit.events
            .on(form, 'dragend dragover dragenter dragleave drop', function (e) {
            e.preventDefault();
        })
            .on(form, "dragover", function (event) {
            if (hasFiles(event)) {
                form.classList.contains('jodit_draghover') ||
                    form.classList.add('jodit_draghover');
                event.preventDefault();
            }
        })
            .on(form, "dragend", function (event) {
            if (hasFiles(event)) {
                form.classList.contains('jodit_draghover') && form.classList.remove('jodit_draghover');
                event.preventDefault();
            }
        })
            .on(form, "drop", function (event) {
            form.classList.remove('jodit_draghover');
            if (hasFiles(event)) {
                event.preventDefault();
                event.stopImmediatePropagation();
                _this.sendFiles(event.dataTransfer.files, handlerSuccess, handlerError);
            }
        });
        var inputFile = form.querySelector('input[type=file]');
        if (inputFile) {
            self.jodit.events.on(inputFile, 'change', function () {
                self.sendFiles(this.files, handlerSuccess, handlerError).then(function () {
                    inputFile.value = '';
                    if (!/safari/i.test(navigator.userAgent)) {
                        inputFile.type = '';
                        inputFile.type = 'file';
                    }
                });
            });
        }
    };
    /**
     * Upload images toWYSIWYG a server by its URL, making it through the connector server.
     *
     * @param {string} url
     * @param {HandlerSuccess} [handlerSuccess]
     * @param {HandlerError} [handlerError]
     */
    Uploader.prototype.uploadRemoteImage = function (url, handlerSuccess, handlerError) {
        var _this = this;
        var uploader = this;
        uploader.send({
            action: 'fileUploadRemote',
            url: url
        }, function (resp) {
            if (uploader.options.isSuccess.call(uploader, resp)) {
                if (typeof handlerSuccess === 'function') {
                    handlerSuccess.call(uploader, _this.options.process.call(_this, resp));
                }
                else {
                    _this.options.defaultHandlerSuccess.call(uploader, _this.options.process.call(_this, resp));
                }
            }
            else {
                if (typeof (handlerError || uploader.options.defaultHandlerError) === 'function') {
                    (handlerError || _this.options.defaultHandlerError).call(uploader, new Error(uploader.options.getMessage.call(_this, resp)));
                    return;
                }
            }
        });
    };
    return Uploader;
}());
exports.Uploader = Uploader;


/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Jodit_1 = __webpack_require__(6);
var Helpers_1 = __webpack_require__(0);
var Dom_1 = __webpack_require__(3);
var Uploader_1 = __webpack_require__(9);
var Widget;
(function (Widget) {
    /**
     * Build color picker
     *
     * @param {Jodit} editor
     * @param {function} callback Callback 'function (color) {}'
     * @param {string} [coldColor] Color value ex. #fff or rgb(123, 123, 123) or rgba(123, 123, 123, 1)
     * @example
     * ```javascript
     * $tabs = TabsWidget(editor, {
     *    'Text' : ColorPickerWidget(editor, function (color) {
     *         box.style.color = color;
     *     }, box.style.color),
     *     'Background' : ColorPickerWidget(editor, function (color) {
     *         box.style.backgroundColor = color;
     *     }, box.style.backgroundColor),
     * });
     * ```
     */
    Widget.ColorPickerWidget = function (editor, callback, coldColor) {
        var valueHex = Helpers_1.normalizeColor(coldColor), form = Helpers_1.dom('<div class="jodit_colorpicker"></div>', editor.ownerDocument), iconEye = editor.options.textIcons ? '' : Jodit_1.Jodit.modules.ToolbarIcon.getIcon('eye'), iconEraser = editor.options.textIcons ? "<span>" + editor.i18n('eraser') + "</span>" : Jodit_1.Jodit.modules.ToolbarIcon.getIcon('eraser'), eachColor = function (colors) {
            var stack = [];
            if (Helpers_1.isPlainObject(colors)) {
                Object.keys(colors).forEach(function (key) {
                    stack.push('<div class="jodit_colorpicker_group jodit_colorpicker_group-' + key + '">');
                    stack.push(eachColor(colors[key]));
                    stack.push('</div>');
                });
            }
            else if (Array.isArray(colors)) {
                colors.forEach(function (color) {
                    stack.push('<a ' + (valueHex === color ? ' class="active" ' : '') + ' title="' + color + '" style="background-color:' + color + '" data-color="' + color + '" href="javascript:void(0)">' +
                        (valueHex === color ? iconEye : '') +
                        '</a>');
                });
            }
            return stack.join('');
        };
        form
            .appendChild(Helpers_1.dom('<div>' + eachColor(editor.options.colors) + '</div>', editor.ownerDocument));
        form.appendChild(Helpers_1.dom('<a ' + (editor.options.textIcons ? 'class="jodit_text_icon"' : '') + ' data-color="" href="javascript:void(0)">' + iconEraser + '</a>', editor.ownerDocument));
        editor.events
            .on(form, 'mousedown touchend', function (e) {
            e.stopPropagation();
            var target = e.target;
            if ((target.tagName.toUpperCase() === 'SVG' || target.tagName.toUpperCase() === 'PATH') && target.parentNode) {
                target = Dom_1.Dom.closest(target.parentNode, 'A', editor.editor);
            }
            if (target.tagName.toUpperCase() !== 'A') {
                return;
            }
            var active = form.querySelector('a.active');
            if (active) {
                active.classList
                    .remove('active');
                active.innerHTML = '';
            }
            var color = target.getAttribute('data-color') || '';
            if (color) {
                target.innerHTML = Jodit_1.Jodit.modules.ToolbarIcon.getIcon('eye');
                target.classList.add('active');
                var colorRGB = Helpers_1.hexToRgb(color);
                if (colorRGB) {
                    target.firstChild.style.fill = 'rgb(' + (255 - colorRGB.r) + ',' + (255 - colorRGB.g) + ',' + (255 - colorRGB.b) + ')';
                }
            }
            if (callback && typeof callback === 'function') {
                callback(color);
            }
            e.preventDefault();
        });
        return form;
    };
    /**
     * Build tabs system
     *
     * @param {Jodit} editor
     * @param {object} tabs PlainObject where 'key' will be tab's Title and `value` is tab's content
     * @param {object} state You can use for this param any HTML element for remembering active tab
     * @param {string} state.activeTab
     *
     * @example
     * ```javascript
     * let tabs = widget.create('Tabs', {
     *    'Images': '<div>Images</div>',
     *    'Title 2': editor.helper.dom('<div>Some content</div>'),
     *    'Color Picker': ColorPickerWidget(editor, function (color) {
     *         box.style.color = color;
     *     }, box.style.color),
     * });
     * ```
     */
    Widget.TabsWidget = function (editor, tabs, state) {
        var box = Helpers_1.dom('<div class="jodit_tabs"></div>', editor.ownerDocument), tabBox = Helpers_1.dom('<div class="jodit_tabs_wrapper"></div>', editor.ownerDocument), buttons = Helpers_1.dom('<div class="jodit_tabs_buttons"></div>', editor.ownerDocument), nameToTab = {}, firstTab = '', tabcount = 0;
        box.appendChild(buttons);
        box.appendChild(tabBox);
        Helpers_1.each(tabs, function (name, tabOptions) {
            var tab = Helpers_1.dom('<div class="jodit_tab"></div>', editor.ownerDocument), button = Helpers_1.dom('<a href="javascript:void(0);"></a>', editor.ownerDocument);
            if (!firstTab) {
                firstTab = name;
            }
            button.innerHTML = editor.i18n(name);
            buttons.appendChild(button);
            if (typeof tabOptions !== 'function') {
                tab.appendChild(Helpers_1.dom(tabOptions, editor.ownerDocument));
            }
            else {
                tab.appendChild(Helpers_1.dom('<div class="jodit_tab_empty"></div>', editor.ownerDocument));
            }
            tabBox.appendChild(tab);
            editor.events.on(button, 'mousedown touchend', function (e) {
                Helpers_1.$$('a', buttons).forEach(function (a) {
                    a.classList.remove('active');
                });
                Helpers_1.$$('.jodit_tab', tabBox).forEach(function (a) {
                    a.classList.remove('active');
                });
                button.classList.add('active');
                tab.classList.add('active');
                if (typeof tabOptions === 'function') {
                    tabOptions.call(editor);
                }
                e.stopPropagation();
                if (state) {
                    state.__activeTab = name;
                }
                return false;
            });
            nameToTab[name] = {
                button: button,
                tab: tab,
            };
            tabcount += 1;
        });
        if (!tabcount) {
            return box;
        }
        Helpers_1.$$('a', buttons).forEach(function (a) {
            a.style.width = (100 / tabcount).toFixed(10) + '%';
        });
        if (!state || !state.__activeTab || !nameToTab[state.__activeTab]) {
            nameToTab[firstTab].button.classList.add('active');
            nameToTab[firstTab].tab.classList.add('active');
        }
        else {
            nameToTab[state.__activeTab].button.classList.add('active');
            nameToTab[state.__activeTab].tab.classList.add('active');
        }
        return box;
    };
    /**
     *
     * @param {Jodit} editor
     * @param {Widget.ImageSelectorCallbacks} callbacks
     * @param {HTMLElement} elm
     * @param {Function} close Close popup
     * @param {boolean} isImage
     * @return {HTMLDivElement}
     * @constructor
     */
    Widget.FileSelectorWidget = function (editor, callbacks, elm, close, isImage) {
        if (isImage === void 0) { isImage = true; }
        var currentImage;
        var tabs = {};
        if (callbacks.upload && editor.options.uploader &&
            (editor.options.uploader.url || editor.options.uploader.insertImageAsBase64URI)) {
            var dragbox = Helpers_1.dom('<div class="jodit_draganddrop_file_box">' +
                '<strong>' + editor.i18n(isImage ? 'Drop image' : 'Drop file') + '</strong>' +
                '<span><br> ' + editor.i18n('or click') + '</span>' +
                '<input type="file" accept="' + (isImage ? 'image/*' : '*') + 'image/*" tabindex="-1" dir="auto" multiple=""/>' +
                '</div>', editor.ownerDocument);
            new Uploader_1.Uploader(editor).bind(dragbox, function (resp) {
                if (typeof (callbacks.upload) === 'function') {
                    callbacks.upload.call(editor, {
                        baseurl: resp.baseurl,
                        files: resp.files
                    });
                }
            }, function (error) {
                editor.events.fire('errorMessage', error.message);
            });
            var icon = editor.options.textIcons ? '' : Jodit_1.Jodit.modules.ToolbarIcon.getIcon('upload');
            tabs[icon + editor.i18n('Upload')] = dragbox;
        }
        if (callbacks.filebrowser) {
            if (editor.options.filebrowser.ajax.url || editor.options.filebrowser.items.url) {
                var icon = editor.options.textIcons ? '' : Jodit_1.Jodit.modules.ToolbarIcon.getIcon('folder');
                tabs[icon + editor.i18n('Browse')] = function () {
                    close && close();
                    if (callbacks.filebrowser) {
                        editor.getInstance('FileBrowser').open(callbacks.filebrowser, isImage);
                    }
                };
            }
        }
        if (callbacks.url) {
            var form_1 = Helpers_1.dom('<form onsubmit="return false;" class="jodit_form">' +
                '<input type="text" required name="url" placeholder="http://"/>' +
                '<input type="text" name="text" placeholder="' + editor.i18n('Alternative text') + '"/>' +
                '<div style="text-align: right">' +
                '<button>' + editor.i18n('Insert') + '</button>' +
                '</div>' +
                '</form>', editor.ownerDocument), button = form_1.querySelector('button'), url_1 = form_1.querySelector('input[name=url]');
            currentImage = null;
            if (elm && elm.nodeType !== Node.TEXT_NODE && (elm.tagName === 'IMG' || Helpers_1.$$('img', elm).length)) {
                currentImage = elm.tagName === 'IMG' ? elm : Helpers_1.$$('img', elm)[0];
                Helpers_1.val(form_1, 'input[name=url]', currentImage.getAttribute('src'));
                Helpers_1.val(form_1, 'input[name=text]', currentImage.getAttribute('alt'));
                button.innerText = editor.i18n('Update');
            }
            if (elm && elm.nodeType !== Node.TEXT_NODE && elm.nodeName === 'A') {
                Helpers_1.val(form_1, 'input[name=url]', elm.getAttribute('href') || '');
                Helpers_1.val(form_1, 'input[name=text]', elm.getAttribute('title') || '');
                button.innerText = editor.i18n('Update');
            }
            form_1.addEventListener('submit', function (event) {
                event.preventDefault();
                event.stopPropagation();
                if (!Helpers_1.val(form_1, 'input[name=url]')) {
                    url_1.focus();
                    url_1.classList.add('jodit_error');
                    return false;
                }
                if (typeof (callbacks.url) === 'function') {
                    callbacks.url.call(editor, Helpers_1.val(form_1, 'input[name=url]'), Helpers_1.val(form_1, 'input[name=text]'));
                }
                return false;
            }, false);
            var icon = editor.options.textIcons ? '' : Jodit_1.Jodit.modules.ToolbarIcon.getIcon('link');
            tabs[icon + ' URL'] = form_1;
        }
        return Widget.TabsWidget(editor, tabs);
    };
})(Widget = exports.Widget || (exports.Widget = {}));


/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var EventHandlersStore = /** @class */ (function () {
    function EventHandlersStore() {
        this.__store = {};
    }
    EventHandlersStore.prototype.get = function (event, namespace) {
        if (this.__store[namespace] !== undefined) {
            return this.__store[namespace][event];
        }
    };
    EventHandlersStore.prototype.indexOf = function (event, namespace, originalCallback) {
        var blocks = this.get(event, namespace);
        if (blocks) {
            for (var i = 0; i < blocks.length; i += 1) {
                if (blocks[i].originalCallback === originalCallback) {
                    return i;
                }
            }
        }
        return false;
    };
    // remove(event: string, namespace: string,  originalCallback: Function) {
    //     const blocks: EventHandlerBlock[] | void = this.get(namespace, event);
    //
    //     if (blocks) {
    //         return blocks.some((block: EventHandlerBlock, index: number) => {
    //             if (block.originalCallback === originalCallback) {
    //                 blocks.splice(index, 1);
    //                 return true;
    //             }
    //
    //             return false;
    //         });
    //     }
    //
    //     return false;
    // }
    EventHandlersStore.prototype.namespaces = function () {
        return Object.keys(this.__store);
    };
    EventHandlersStore.prototype.events = function (namespace) {
        return this.__store[namespace] ? Object.keys(this.__store[namespace]) : [];
    };
    EventHandlersStore.prototype.set = function (event, namespace, data, onTop) {
        if (onTop === void 0) { onTop = false; }
        if (this.__store[namespace] === undefined) {
            this.__store[namespace] = {};
        }
        if (this.__store[namespace][event] === undefined) {
            this.__store[namespace][event] = [];
        }
        if (!onTop) {
            this.__store[namespace][event].push(data);
        }
        else {
            this.__store[namespace][event].unshift(data);
        }
    };
    return EventHandlersStore;
}());
var EventsNative = /** @class */ (function () {
    function EventsNative(doc) {
        var _this = this;
        this.__defaultNameSpace = 'JoditEventDefaultNamespace';
        this.__key = '__JoditEventsNativeNamespaces';
        /**
         * Get current event name
         *
         * @example
         * ```javascript
         * parent.events.on('openDialog closeDialog', function () {
         *     if (parent.events.current === 'closeDialog') {
         *         alert('Dialog was closed');
         *     } else {
         *         alert('Dialog was opened');
         *     }
         * });
         * ```
         */
        this.current = [];
        this.doc = document;
        this.prepareEvent = function (event) {
            if (event.cancelBubble) {
                return;
            }
            if (event.type.match(/^touch/) && event.changedTouches && event.changedTouches.length) {
                ['clientX', 'clientY', 'pageX', 'pageY'].forEach(function (key) {
                    Object.defineProperty(event, key, { value: event.changedTouches[0][key], configurable: true, enumerable: true });
                });
            }
            if (!event['originalEvent']) {
                event['originalEvent'] = event;
            }
            if (event.type === 'paste' && event.clipboardData === undefined && _this.doc.defaultView.clipboardData) {
                Object.defineProperty(event, 'clipboardData', {
                    get: function () {
                        return _this.doc.defaultView.clipboardData;
                    },
                    configurable: true,
                    enumerable: true
                });
            }
        };
        this.__stopped = [];
        if (doc) {
            this.doc = doc;
        }
        this.__key += (new Date()).getTime();
    }
    EventsNative.prototype.eachEvent = function (events, callback) {
        var _this = this;
        var eventParts = events.split(/[\s,]+/);
        eventParts.forEach(function (eventNameSpace) {
            var eventAndNameSpace = eventNameSpace.split('.');
            var namespace = eventAndNameSpace[1] || _this.__defaultNameSpace;
            callback.call(_this, eventAndNameSpace[0], namespace);
        });
    };
    EventsNative.prototype.getStore = function (subject) {
        if (subject[this.__key] === undefined) {
            var store = new EventHandlersStore();
            Object.defineProperty(subject, this.__key, {
                enumerable: false,
                configurable: true,
                value: store
            });
        }
        return subject[this.__key];
    };
    EventsNative.prototype.clearStore = function (subject) {
        if (subject[this.__key] !== undefined) {
            delete subject[this.__key];
        }
    };
    /**
     * Sets the handler for the specified event ( Event List ) for a given element .
     *
     * @param {object|string} subjectOrEvents - The object for which toWYSIWYG set an event handler
     * @param {string|Function} eventsOrCallback - List of events , separated by a space or comma
     * @param {function} [handlerOrSelector] - The event handler
     * @param {selector} [selector] - Selector for capturing
     * @param {Boolean} [onTop=false] - Set handler in first
     *
     * @example
     * ```javascript
     * // set global handler
     * parent.on('beforeCommand', function (command) {
     *     alert('command');
     * });
     * ```
     * * @example
     * ```javascript
     * // set global handler
     * parent.on(document.body, 'click', function (e) {
     *     alert(this.href);
     * }, 'a');
     * ```
     */
    EventsNative.prototype.on = function (subjectOrEvents, eventsOrCallback, handlerOrSelector, selector, onTop) {
        var _this = this;
        if (onTop === void 0) { onTop = false; }
        var subject = typeof subjectOrEvents === 'string' ? this : subjectOrEvents;
        var events = typeof eventsOrCallback === 'string' ? eventsOrCallback : subjectOrEvents;
        var callback = handlerOrSelector;
        if (callback === undefined && typeof eventsOrCallback === 'function') {
            callback = eventsOrCallback;
        }
        var store = this.getStore(subject);
        if (typeof events !== 'string' || events === '') {
            throw new Error('Need events names');
        }
        if (typeof callback !== 'function') {
            throw new Error('Need event handler');
        }
        if (Array.isArray(subject)) {
            subject.forEach(function (subj) {
                _this.on(subj, events, callback, selector);
            });
            return this;
        }
        var isDOMElement = typeof subject['addEventListener'] === 'function';
        var self = this, syntheticCallback = function () {
            return callback && callback.apply(this, arguments);
        };
        if (isDOMElement) {
            syntheticCallback = function (event) {
                self.prepareEvent(event);
                if (callback && callback.call(this, event) === false) {
                    event.preventDefault();
                    event.stopImmediatePropagation();
                    return false;
                }
                return;
            };
            if (selector) {
                syntheticCallback = function (event) {
                    self.prepareEvent(event);
                    var node = event.target;
                    while (node && node !== this) {
                        if (node.matches(selector)) {
                            Object.defineProperty(event, 'target', {
                                value: node,
                                configurable: true,
                                enumerable: true
                            });
                            if (callback && callback.call(node, event) === false) {
                                event.preventDefault();
                                return false;
                            }
                            return;
                        }
                        node = node.parentNode;
                    }
                };
            }
        }
        this.eachEvent(events, function (event, namespace) {
            if (event === '') {
                throw new Error('Need event name');
            }
            if (store.indexOf(event, namespace, callback) === false) {
                var block = {
                    event: event,
                    originalCallback: callback,
                    syntheticCallback: syntheticCallback
                };
                store.set(event, namespace, block, onTop);
                if (namespace !== _this.__defaultNameSpace) {
                    store.set(event, _this.__defaultNameSpace, block, onTop);
                }
                if (isDOMElement) {
                    subject.addEventListener(event, syntheticCallback, false);
                }
            }
        });
        return this;
    };
    /**
     * Disable all handlers specified event ( Event List ) for a given element. Either a specific event handler.
     *
     * @param {object} subjectOrEvents - The object which is disabled handlers
     * @param {string|Function} [eventsOrCallback] - List of events, separated by a space or comma , which is necessary toWYSIWYG disable the handlers for a given object
     * @param {function} [handler] - Specific event handler toWYSIWYG be removed
     *
     * @example
     * ```javascript
     * var a = {name: "Anton"};
     * parent.events.on(a, 'open', function () {
     *     alert(this.name);
     * });
     *
     * parent.events.fire(a, 'open');
     * parent.events.off(a, 'open');
     * var b = {name: "Ivan"}, hndlr = function () {
     *  alert(this.name);
     * };
     * parent.events.on(b, 'open close', hndlr);
     * parent.events.fire(a, 'open');
     * parent.events.off(a, 'open', hndlr);
     * parent.events.fire(a, 'close');
     * parent.events.on('someGlobalEvents', function () {
     *   console.log(this); // parent
     * });
     * parent.events.fire('someGlobalEvents');
     * parent.events.off('someGlobalEvents');
     * ```
     */
    EventsNative.prototype.off = function (subjectOrEvents, eventsOrCallback, handler) {
        var _this = this;
        var subject = typeof subjectOrEvents === 'string' ? this : subjectOrEvents;
        var events = typeof eventsOrCallback === 'string' ? eventsOrCallback : subjectOrEvents;
        var store = this.getStore(subject);
        var callback = handler;
        if (typeof events !== 'string' || !events) {
            store.namespaces().forEach(function (namespace) {
                _this.off(subject, '.' + namespace);
            });
            this.clearStore(subject);
            return this;
        }
        if (callback === undefined && typeof eventsOrCallback === 'function') {
            callback = eventsOrCallback;
        }
        var isDOMElement = typeof subject['removeEventListener'] === 'function', removeEventListener = function (block) {
            if (isDOMElement) {
                subject.removeEventListener(block.event, block.syntheticCallback, false);
            }
        }, removeCallbackFromNameSpace = function (event, namespace) {
            if (event !== '') {
                var blocks = store.get(event, namespace);
                if (blocks && blocks.length) {
                    var found = false;
                    if (typeof callback !== 'function') {
                        blocks.forEach(removeEventListener);
                        blocks.length = 0;
                        found = true;
                    }
                    else {
                        var index = store.indexOf(event, namespace, callback);
                        if (index !== false) {
                            removeEventListener(blocks[index]);
                            blocks.splice(index, 1);
                            found = true;
                        }
                    }
                    if (found && namespace !== _this.__defaultNameSpace) {
                        removeCallbackFromNameSpace(event, _this.__defaultNameSpace);
                    }
                }
            }
            else {
                store.events(namespace).forEach(function (eventName) {
                    if (eventName !== '') {
                        removeCallbackFromNameSpace(eventName, namespace);
                    }
                });
            }
        };
        this.eachEvent(events, function (event, namespace) {
            if (namespace === _this.__defaultNameSpace) {
                store.namespaces().forEach(function (name) {
                    removeCallbackFromNameSpace(event, name);
                });
            }
            else {
                removeCallbackFromNameSpace(event, namespace);
            }
        });
        return this;
    };
    EventsNative.prototype.triggerNativeEvent = function (element, event) {
        var evt = this.doc.createEvent('HTMLEvents');
        if (typeof event === 'string') {
            evt.initEvent(event, true, true);
        }
        else {
            evt.initEvent(event.type, event.bubbles, event.cancelable);
            ['screenX', 'screenY', 'clientX', 'clientY', 'target', 'srcElement', 'currentTarget', 'timeStamp', 'which', 'keyCode'].forEach(function (property) {
                Object.defineProperty(evt, property, { value: event[property], enumerable: true });
            });
            Object.defineProperty(evt, 'originalEvent', { value: event, enumerable: true });
        }
        element.dispatchEvent(evt);
    };
    EventsNative.prototype.stopPropagation = function (subjectOrEvents, eventsList) {
        var _this = this;
        var subject = typeof subjectOrEvents === 'string' ? this : subjectOrEvents;
        var events = typeof subjectOrEvents === 'string' ? subjectOrEvents : eventsList;
        if (typeof events !== 'string') {
            throw new Error('Need event names');
        }
        var store = this.getStore(subject);
        this.eachEvent(events, function (event, namespace) {
            var blocks = store.get(event, namespace);
            if (blocks) {
                _this.__stopped.push(blocks);
            }
        });
    };
    EventsNative.prototype.removeStop = function (__currentBlocks) {
        if (__currentBlocks) {
            var index = this.__stopped.indexOf(__currentBlocks);
            index !== -1 && this.__stopped.splice(index, 1);
        }
    };
    EventsNative.prototype.isStopped = function (__currentBlocks) {
        return __currentBlocks !== undefined && this.__stopped.indexOf(__currentBlocks) !== -1;
    };
    /**
     * Sets the handler for the specified event (Event List) for a given element .
     *
     * @param {object|string} subjectOrEvents - The object which is caused by certain events
     * @param {string|Array} eventsList - List of events , separated by a space or comma
     * @param {Array} [args] - Options for the event handler
     * @return {boolean} `false` if one of the handlers return `false`
     * @example
     * ```javascript
     * var dialog = new Jodit.modules.Dialog();
     * parent.events.on('afterClose', function () {
     *     dialog.destruct(); // will be removed from DOM
     * });
     * dialog.open('Hello world!!!');
     * ```
     *  or you can trigger native browser listener
     *  ```javascript
     *  var events = new Jodit.modules.EventsNative();
     *  events.on(document.body, 'click',function (event) {
     *      alert('click on ' + event.target.id );
     *  });
     *  events.fire(document.body.querySelector('div'), 'click');
     *  ```
     *
     */
    EventsNative.prototype.fire = function (subjectOrEvents, eventsList) {
        var _this = this;
        var args = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            args[_i - 2] = arguments[_i];
        }
        var result = void (0), result_value;
        var subject = typeof subjectOrEvents === 'string' ? this : subjectOrEvents;
        var events = typeof subjectOrEvents === 'string' ? subjectOrEvents : eventsList;
        var argumentsList = typeof subjectOrEvents === 'string' ? [eventsList].concat(args) : args;
        var isDOMElement = typeof subject['dispatchEvent'] === 'function';
        if (!isDOMElement && typeof events !== 'string') {
            throw new Error('Need events names');
        }
        var store = this.getStore(subject);
        if (typeof events !== 'string' && isDOMElement) {
            this.triggerNativeEvent(subject, eventsList);
        }
        else {
            this.eachEvent(events, function (event, namespace) {
                if (isDOMElement) {
                    _this.triggerNativeEvent(subject, event);
                }
                else {
                    var blocks_1 = store.get(event, namespace);
                    if (blocks_1) {
                        try {
                            blocks_1.every(function (block) {
                                if (_this.isStopped(blocks_1)) {
                                    return false;
                                }
                                _this.current.push(event);
                                result_value = block.syntheticCallback.apply(subject, argumentsList);
                                _this.current.pop();
                                if (result_value !== undefined) {
                                    result = result_value;
                                }
                                return true;
                            });
                        }
                        finally {
                            _this.removeStop(blocks_1);
                        }
                    }
                }
            });
        }
        return result;
    };
    EventsNative.prototype.destruct = function () {
        this.off(this);
    };
    return EventsNative;
}());
exports.EventsNative = EventsNative;


/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Component_1 = __webpack_require__(4);
exports.Component = Component_1.Component;
var Ajax_1 = __webpack_require__(14);
exports.Ajax = Ajax_1.Ajax;
var ContextMenu_1 = __webpack_require__(15);
exports.ContextMenu = ContextMenu_1.ContextMenu;
var Cookie_1 = __webpack_require__(63);
exports.Cookie = Cookie_1.Cookie;
var Dialog_1 = __webpack_require__(7);
exports.Dialog = Dialog_1.Dialog;
exports.Alert = Dialog_1.Alert;
exports.Confirm = Dialog_1.Confirm;
exports.Promt = Dialog_1.Promt;
var Dom_1 = __webpack_require__(3);
exports.Dom = Dom_1.Dom;
var EventsNative_1 = __webpack_require__(11);
exports.EventsNative = EventsNative_1.EventsNative;
var FileBrowser_1 = __webpack_require__(64);
exports.FileBrowser = FileBrowser_1.FileBrowser;
var Helpers = __webpack_require__(0);
exports.Helpers = Helpers;
var ImageEditor_1 = __webpack_require__(65);
exports.ImageEditor = ImageEditor_1.ImageEditor;
var Observer_1 = __webpack_require__(17);
exports.Observer = Observer_1.Observer;
var Selection_1 = __webpack_require__(13);
exports.Select = Selection_1.Select;
var Snapshot_1 = __webpack_require__(18);
exports.Snapshot = Snapshot_1.Snapshot;
var Table_1 = __webpack_require__(20);
exports.Table = Table_1.Table;
var ToolbarCollection_1 = __webpack_require__(5);
exports.ToolbarIcon = ToolbarCollection_1.ToolbarIcon;
exports.ToolbarCollection = ToolbarCollection_1.ToolbarCollection;
exports.ToolbarButton = ToolbarCollection_1.ToolbarButton;
var Stack_1 = __webpack_require__(19);
exports.Stack = Stack_1.Stack;
var Uploader_1 = __webpack_require__(9);
exports.Uploader = Uploader_1.Uploader;


/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var consts = __webpack_require__(2);
var Component_1 = __webpack_require__(4);
var Helpers_1 = __webpack_require__(0);
var Dom_1 = __webpack_require__(3);
var constants_1 = __webpack_require__(2);
var constants_2 = __webpack_require__(2);
var Select = /** @class */ (function (_super) {
    __extends(Select, _super);
    function Select() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.isMarker = function (elm) { return (Dom_1.Dom.isNode(elm, _this.jodit.editorWindow) && elm.nodeType === Node.ELEMENT_NODE && elm.nodeName === 'SPAN' && elm.hasAttribute('data-' + consts.MARKER_CLASS)); };
        _this.marker = function (atStart, range) {
            if (atStart === void 0) { atStart = false; }
            var newRange = null;
            if (range) {
                newRange = range.cloneRange();
                newRange.collapse(atStart);
            }
            var marker = _this.jodit.editorDocument.createElement('span');
            marker.id = consts.MARKER_CLASS + '_' + (+new Date()) + "_" + ("" + Math.random()).slice(2);
            marker.style.lineHeight = "0";
            marker.style.display = "none";
            marker.setAttribute('data-' + consts.MARKER_CLASS, (atStart ? 'start' : 'end'));
            marker.appendChild(_this.jodit.editorDocument.createTextNode(consts.INVISIBLE_SPACE));
            if (newRange) {
                if (Dom_1.Dom.isOrContains(_this.jodit.editor, atStart ? newRange.startContainer : newRange.endContainer)) {
                    newRange.insertNode(marker);
                }
            }
            return marker;
        };
        /**
         * Set focus in editor
         */
        _this.focus = function () {
            var jodit = _this.jodit;
            if (!_this.isFocused()) {
                if (jodit.options.iframe && Helpers_1.isIE()) {
                    var start = 0;
                    while (start < 100000 && jodit.editorDocument.readyState !== 'complete') {
                        start++;
                    }
                }
                if (jodit.iframe) {
                    jodit.iframe.focus();
                }
                jodit.editorWindow.focus();
                jodit.editor.focus();
                var sel = jodit.editorWindow.getSelection(), range = jodit.editorDocument.createRange();
                if (!sel.rangeCount || !_this.current()) {
                    // let child: Node|null = jodit.editor.firstChild;
                    //
                    // if (!child) {
                    //     child = jodit.editorDocument.createTextNode(consts.INVISIBLE_SPACE);
                    //     jodit.editor.appendChild(child);
                    // }
                    range.setStart(jodit.editor, 0);
                    range.collapse(true);
                    sel.removeAllRanges();
                    sel.addRange(range);
                }
                return true;
            }
            return false;
        };
        _this.eachSelection = function (callback) {
            var sel = _this.jodit.editorWindow.getSelection();
            if (sel.rangeCount) {
                var range = sel.getRangeAt(0);
                var nodes_1 = [], start = range.startContainer === _this.jodit.editor ? _this.jodit.editor.childNodes[range.startOffset] : range.startContainer, end_1 = range.endContainer === _this.jodit.editor ? _this.jodit.editor.childNodes[range.endOffset - 1] : range.endContainer;
                Dom_1.Dom.find(start, function (node) {
                    if (node && node !== _this.jodit.editor && !Dom_1.Dom.isEmptyTextNode(node) && !_this.isMarker(node)) {
                        nodes_1.push(node);
                    }
                    return node === end_1;
                }, _this.jodit.editor, true, 'nextSibling', false);
                var forEvery_1 = function (current) {
                    if (current.nodeName.match(/^(UL|OL)$/)) {
                        return [].slice.call(current.childNodes).forEach(forEvery_1);
                    }
                    if (current.nodeName === 'LI') {
                        if (current.firstChild) {
                            current = current.firstChild;
                        }
                        else {
                            var currentB = _this.jodit.editorDocument.createTextNode(constants_2.INVISIBLE_SPACE);
                            current.appendChild(currentB);
                            current = currentB;
                        }
                    }
                    callback(current);
                };
                if (nodes_1.length === 0 && Dom_1.Dom.isEmptyTextNode(start)) {
                    nodes_1.push(start);
                }
                nodes_1.forEach(forEvery_1);
            }
        };
        /**
         * Apply some css rules for all selections. It method wraps selections in nodeName tag.
         *
         * @param {object} cssRules
         * @param {string} nodeName
         * @param {object} options
         */
        _this.applyCSS = function (cssRules, nodeName, options) {
            if (nodeName === void 0) { nodeName = 'span'; }
            var WRAP = 1;
            var UNWRAP = 0;
            var mode;
            var defaultTag = 'SPAN';
            var FONT = 'FONT';
            var findNextCondition = function (elm) { return (elm !== null && !Dom_1.Dom.isEmptyTextNode(elm) && !_this.isMarker(elm)); };
            var checkCssRulesFor = function (elm) {
                return elm.nodeName !== FONT &&
                    elm.nodeType === Node.ELEMENT_NODE &&
                    ((Helpers_1.isPlainObject(options) &&
                        Helpers_1.each(options, function (cssPropertyKey, cssPropertyValues) {
                            var value = Helpers_1.css(elm, cssPropertyKey, void (0), true);
                            return value !== null && value !== '' && cssPropertyValues.indexOf(value.toString().toLowerCase()) !== -1;
                        }) !== false) ||
                        (typeof options === 'function' && options(_this.jodit, elm)));
            };
            var isSuitElement = function (elm) {
                var reg = new RegExp('^' + elm.nodeName + '$', 'i');
                return (reg.test(nodeName) || !!(options && checkCssRulesFor(elm))) && findNextCondition(elm);
            };
            var toggleStyles = function (elm) {
                if (isSuitElement(elm)) {
                    // toggle CSS rules
                    if (elm.nodeName === defaultTag && cssRules) {
                        Object.keys(cssRules).forEach(function (rule) {
                            if (mode === UNWRAP || Helpers_1.css(elm, rule) == Helpers_1.normilizeCSSValue(rule, cssRules[rule])) {
                                Helpers_1.css(elm, rule, '');
                                if (mode === undefined) {
                                    mode = UNWRAP;
                                }
                            }
                            else {
                                Helpers_1.css(elm, rule, cssRules[rule]);
                                if (mode === undefined) {
                                    mode = WRAP;
                                }
                            }
                        });
                    }
                    if (!Dom_1.Dom.isBlock(elm) && (!elm.getAttribute('style') || elm.nodeName !== defaultTag)) {
                        Dom_1.Dom.unwrap(elm); // toggle `<strong>test</strong>` toWYSIWYG `test`, and `<span style="">test</span>` toWYSIWYG `test`
                        if (mode === undefined) {
                            mode = UNWRAP;
                        }
                    }
                }
            };
            if (!_this.isCollapsed()) {
                var selInfo = _this.save();
                Helpers_1.normalizeNode(_this.jodit.editor.firstChild); // FF fix for test "commandsTest - Exec command "bold" for some text that contains a few STRONG elements, should unwrap all of these"
                _this.jodit.editorDocument.execCommand('fontsize', false, 7);
                Helpers_1.$$('font[size="7"]', _this.jodit.editor).forEach(function (font) {
                    if (!Dom_1.Dom.next(font, findNextCondition, font.parentNode) && !Dom_1.Dom.prev(font, findNextCondition, font.parentNode) && isSuitElement(font.parentNode) && font.parentNode !== _this.jodit.editor && (!Dom_1.Dom.isBlock(font.parentNode) || consts.IS_BLOCK.test(nodeName))) {
                        toggleStyles(font.parentNode);
                    }
                    else if (font.firstChild && !Dom_1.Dom.next(font.firstChild, findNextCondition, font) && !Dom_1.Dom.prev(font.firstChild, findNextCondition, font) && isSuitElement(font.firstChild)) {
                        toggleStyles(font.firstChild);
                    }
                    else if (Dom_1.Dom.closest(font, isSuitElement, _this.jodit.editor)) {
                        var leftRange = _this.jodit.editorDocument.createRange(), wrapper = Dom_1.Dom.closest(font, isSuitElement, _this.jodit.editor);
                        leftRange.setStartBefore(wrapper);
                        leftRange.setEndBefore(font);
                        var leftFragment = leftRange.extractContents();
                        if ((!leftFragment.textContent || !Helpers_1.trim(leftFragment.textContent).length) && leftFragment.firstChild) {
                            Dom_1.Dom.unwrap(leftFragment.firstChild);
                        }
                        if (wrapper.parentNode) {
                            wrapper.parentNode.insertBefore(leftFragment, wrapper);
                        }
                        leftRange.setStartAfter(font);
                        leftRange.setEndAfter(wrapper);
                        var rightFragment = leftRange.extractContents();
                        // case then marker can be inside fragnment
                        if ((!rightFragment.textContent || !Helpers_1.trim(rightFragment.textContent).length) && rightFragment.firstChild) {
                            Dom_1.Dom.unwrap(rightFragment.firstChild);
                        }
                        Dom_1.Dom.after(wrapper, rightFragment);
                        toggleStyles(wrapper);
                    }
                    else {
                        // unwrap all suit elements inside
                        var needUnwrap_1 = [];
                        var firstElementSuit_1 = undefined;
                        if (font.firstChild) {
                            Dom_1.Dom.find(font.firstChild, function (elm) {
                                if (elm && isSuitElement(elm)) {
                                    if (firstElementSuit_1 === undefined) {
                                        firstElementSuit_1 = true;
                                    }
                                    needUnwrap_1.push(elm);
                                }
                                else {
                                    if (firstElementSuit_1 === undefined) {
                                        firstElementSuit_1 = false;
                                    }
                                }
                                return false;
                            }, font, true);
                        }
                        needUnwrap_1.forEach(Dom_1.Dom.unwrap);
                        if (!firstElementSuit_1) {
                            if (mode === undefined) {
                                mode = WRAP;
                            }
                            if (mode === WRAP) {
                                Helpers_1.css(Dom_1.Dom.replace(font, nodeName, false, false, _this.jodit.editorDocument), (cssRules && nodeName.toUpperCase() === defaultTag) ? cssRules : {});
                            }
                        }
                    }
                    if (font.parentNode) {
                        Dom_1.Dom.unwrap(font);
                    }
                });
                _this.restore(selInfo);
            }
            else {
                var clearStyle = false;
                if (_this.current() && Dom_1.Dom.closest(_this.current(), nodeName, _this.jodit.editor)) {
                    clearStyle = true;
                    var closest = Dom_1.Dom.closest(_this.current(), nodeName, _this.jodit.editor);
                    if (closest) {
                        _this.setCursorAfter(closest);
                    }
                }
                if (nodeName.toUpperCase() === defaultTag || !clearStyle) {
                    var node = _this.jodit.editorDocument.createElement(nodeName);
                    node.appendChild(_this.jodit.editorDocument.createTextNode(consts.INVISIBLE_SPACE));
                    _this.insertNode(node, false, false);
                    if (nodeName.toUpperCase() === defaultTag && cssRules) {
                        Helpers_1.css(node, cssRules);
                    }
                    _this.setCursorIn(node);
                }
            }
        };
        return _this;
    }
    /**
     * Remove all selected content
     */
    Select.prototype.remove = function () {
        var sel = this.jodit.editorWindow.getSelection(), current = this.current();
        if (current) {
            for (var i = 0; i < sel.rangeCount; i += 1) {
                sel.getRangeAt(i).deleteContents();
                sel.getRangeAt(i).collapse(true);
            }
        }
    };
    /**
     * Insert the cursor toWYSIWYG any point x, y
     *
     * @method insertAtPoint
     * @param {int} x Coordinate by horizontal
     * @param {int} y Coordinate by vertical
     * @return boolean Something went wrong
     */
    Select.prototype.insertCursorAtPoint = function (x, y) {
        var caret;
        var doc = this.jodit.editorDocument;
        this.removeMarkers();
        try {
            var rng = null;
            if (doc.caretPositionFromPoint) {
                caret = doc.caretPositionFromPoint(x, y);
                rng = doc.createRange();
                rng.setStart(caret.offsetNode, caret.offset);
            }
            else if (doc.caretRangeFromPoint) {
                caret = doc.caretRangeFromPoint(x, y);
                rng = doc.createRange();
                rng.setStart(caret.startContainer, caret.startOffset);
            }
            if (rng && typeof this.jodit.editorWindow.getSelection != "undefined") {
                rng.collapse(true);
                var sel = this.jodit.editorWindow.getSelection();
                sel.removeAllRanges();
                sel.addRange(rng);
            }
            else if (typeof doc.body.createTextRange !== "undefined") {
                var range = doc.body.createTextRange();
                range.moveToPoint(x, y);
                var endRange = range.duplicate();
                endRange.moveToPoint(x, y);
                range.setEndPoint("EndToEnd", endRange);
                range.select();
            }
            return true;
        }
        catch (e) {
        }
        return false;
    };
    /**
     * Remove all markers
     */
    Select.prototype.removeMarkers = function () {
        Helpers_1.$$('span[data-' + consts.MARKER_CLASS + ']', this.jodit.editor).forEach(function (marker) {
            if (marker.parentNode) {
                marker.parentNode.removeChild(marker);
            }
        });
    };
    /**
     * Restores user selections using marker invisible elements in the DOM.
     *
     * @param {markerInfo[]|null} selectionInfo
     */
    Select.prototype.restore = function (selectionInfo) {
        var _this = this;
        if (selectionInfo === void 0) { selectionInfo = []; }
        if (Array.isArray(selectionInfo)) {
            var sel_1 = this.jodit.editorWindow.getSelection();
            sel_1.removeAllRanges();
            selectionInfo.forEach(function (selection) {
                var range = _this.jodit.editorDocument.createRange(), end = _this.jodit.editor.querySelector('#' + selection.endId), start = _this.jodit.editor.querySelector('#' + selection.startId);
                if (!start) {
                    return;
                }
                if (selection.collapsed || !end) {
                    var previousNode = start.previousSibling;
                    if (previousNode && previousNode.nodeType === Node.TEXT_NODE) {
                        range.setStart(previousNode, previousNode.nodeValue ? previousNode.nodeValue.length : 0);
                    }
                    else {
                        range.setStartBefore(start);
                    }
                    if (start.parentNode) {
                        start.parentNode.removeChild(start);
                    }
                    range.collapse(true);
                }
                else {
                    range.setStartAfter(start);
                    if (start.parentNode) {
                        start.parentNode.removeChild(start);
                    }
                    range.setEndBefore(end);
                    if (end.parentNode) {
                        end.parentNode.removeChild(end);
                    }
                }
                sel_1.addRange(range);
            });
        }
    };
    /**
     * Saves selections using marker invisible elements in the DOM.
     *
     * @return markerInfo[]
     */
    Select.prototype.save = function () {
        var sel = this.jodit.editorWindow.getSelection();
        if (!sel.rangeCount) {
            return [];
        }
        var info = [], length = sel.rangeCount, i, start, end, ranges = [];
        for (i = 0; i < length; i += 1) {
            ranges[i] = sel.getRangeAt(i);
            if (ranges[i].collapsed) {
                start = this.marker(true, ranges[i]);
                info[i] = {
                    startId: start.id,
                    collapsed: true,
                    startMarker: start.outerHTML,
                };
            }
            else {
                start = this.marker(true, ranges[i]);
                end = this.marker(false, ranges[i]);
                info[i] = {
                    startId: start.id,
                    endId: end.id,
                    collapsed: false,
                    startMarker: start.outerHTML,
                    endMarker: end.outerHTML,
                };
            }
        }
        sel.removeAllRanges();
        for (i = length - 1; i >= 0; --i) {
            var start_1 = this.jodit.editorDocument.getElementById(info[i].startId);
            if (start_1) {
                if (info[i].collapsed) {
                    ranges[i].setStartAfter(start_1);
                    ranges[i].collapse(true);
                }
                else {
                    ranges[i].setStartBefore(start_1);
                    if (info[i].endId) {
                        var end_2 = this.jodit.editorDocument.getElementById(info[i].endId);
                        if (end_2) {
                            ranges[i].setEndAfter(end_2);
                        }
                    }
                }
            }
            try {
                sel.addRange(ranges[i].cloneRange());
            }
            catch (e) {
                //console.log(e);
            }
        }
        return info;
    };
    /**
     * Checks whether the current selection is something or just set the cursor is
     *
     * @return boolean true Selection does't have content
     */
    Select.prototype.isCollapsed = function () {
        var sel = this.jodit.editorWindow.getSelection(), r;
        for (r = 0; r < sel.rangeCount; r += 1) {
            if (!sel.getRangeAt(r).collapsed) {
                return false;
            }
        }
        return true;
    };
    /**
     * Checks whether the editor currently in focus
     *
     * @return boolean
     */
    Select.prototype.isFocused = function () {
        return (this.jodit.editorDocument.hasFocus && this.jodit.editorDocument.hasFocus()) && this.jodit.editor === this.jodit.editorDocument.activeElement;
    };
    /**
     * Returns the current element under the cursor inside editor
     *
     * @return false|Node The element under the cursor or false if undefined or not in editor
     */
    Select.prototype.current = function (checkChild) {
        if (checkChild === void 0) { checkChild = true; }
        if (this.jodit.getRealMode() === consts.MODE_WYSIWYG && this.jodit.editorWindow.getSelection !== undefined) {
            var sel = this.jodit.editorWindow.getSelection();
            if (sel && sel.rangeCount > 0) {
                var range = sel.getRangeAt(0);
                var node = range.startContainer, rightMode_1 = false, child = function (node) { return rightMode_1 ? node.lastChild : node.firstChild; };
                if (node.nodeType !== Node.TEXT_NODE) {
                    node = range.startContainer.childNodes[range.startOffset];
                    if (!node) {
                        node = range.startContainer.childNodes[range.startOffset - 1];
                        rightMode_1 = true;
                    }
                    if (node && sel.isCollapsed && node.nodeType !== Node.TEXT_NODE) {
                        // test Current method - Cursor in the left of some SPAN
                        if (!rightMode_1 && node.previousSibling && node.previousSibling.nodeType === Node.TEXT_NODE) {
                            node = node.previousSibling;
                        }
                        else if (checkChild) {
                            var current = child(node);
                            while (current) {
                                if (current && current.nodeType === Node.TEXT_NODE) {
                                    node = current;
                                    break;
                                }
                                current = child(current);
                            }
                        }
                    }
                }
                // check - cursor inside editor
                if (node && Dom_1.Dom.isOrContains(this.jodit.editor, node)) {
                    return node;
                }
            }
        }
        return false;
    };
    /**
     * Insert element in editor
     *
     * @param {Node} node
     * @param {Boolean} [insertCursorAfter=true] After insert, cursor will move after element
     * @param {Boolean} [fireChange=true] After insert, editor fire change event. You can prevent this behavior
     */
    Select.prototype.insertNode = function (node, insertCursorAfter, fireChange) {
        if (insertCursorAfter === void 0) { insertCursorAfter = true; }
        if (fireChange === void 0) { fireChange = true; }
        if (!(node instanceof this.jodit.editorWindow.Node)) {
            throw new Error('Parameter node most be instance of Node');
        }
        this.focus();
        if (this.jodit.editorWindow.getSelection) {
            var sel = this.jodit.editorWindow.getSelection();
            if (!this.isCollapsed()) {
                this.jodit.execCommand('Delete');
            }
            if (sel.rangeCount) {
                var range = sel.getRangeAt(0);
                if (Dom_1.Dom.isOrContains(this.jodit.editor, range.commonAncestorContainer)) {
                    range.deleteContents();
                    range.insertNode(node);
                }
                else {
                    this.jodit.editor.appendChild(node);
                }
            }
            else {
                this.jodit.editor.appendChild(node);
            }
            if (insertCursorAfter) {
                this.setCursorAfter(node);
            }
        }
        else {
            throw new Error('Jodit does\'n support this browser');
        }
        if (fireChange && this.jodit.events) {
            this.jodit.events.fire('synchro');
        }
        if (this.jodit.events) {
            this.jodit.events.fire('afterInsertNode', node);
        }
    };
    /**
     * Inserts in the current cursor position some HTML snippet
     *
     * @param  {string} html HTML The text toWYSIWYG be inserted into the document
     * @example
     * ```javascript
     * parent.selection.insertHTML('<img src="image.png"/>');
     * ```
     */
    Select.prototype.insertHTML = function (html) {
        if (html === '') {
            return;
        }
        var node = this.jodit.editorDocument.createElement('div'), fragment = this.jodit.editorDocument.createDocumentFragment();
        var lastChild, lastEditorElement;
        if (!this.isFocused() && this.jodit.isEditorMode()) {
            this.focus();
        }
        if (!(html instanceof this.jodit.editorWindow.Node)) {
            node.innerHTML = html.toString();
        }
        else if (Dom_1.Dom.isNode(html, this.jodit.editorWindow)) {
            node.appendChild(html);
        }
        if (!this.jodit.isEditorMode() && this.jodit.events.fire('insertHTML', node.innerHTML) === false) {
            return;
        }
        lastChild = node.lastChild;
        while (node.firstChild) {
            lastChild = node.firstChild;
            fragment.appendChild(node.firstChild);
        }
        this.insertNode(fragment, false);
        if (lastChild) {
            this.setCursorAfter(lastChild);
        }
        else {
            this.setCursorIn(fragment);
        }
        lastEditorElement = this.jodit.editor.lastChild;
        while (lastEditorElement && lastEditorElement.nodeType === Node.TEXT_NODE && lastEditorElement.previousSibling && lastEditorElement.nodeValue && (/^\s*$/).test(lastEditorElement.nodeValue)) {
            lastEditorElement = lastEditorElement.previousSibling;
        }
        if (lastChild) {
            if (lastEditorElement && lastChild === lastEditorElement && lastChild.nodeType === Node.ELEMENT_NODE) {
                this.jodit.editor.appendChild(this.jodit.editorDocument.createElement('br'));
            }
            this.setCursorAfter(lastChild);
        }
    };
    /**
     * Insert image in editor
     *
     * @param  {string|HTMLImageElement} url URL for image, or HTMLImageElement
     * @param  {string} [styles] If specified, it will be applied <code>$(image).css(styles)</code>
     *
     * @fired afterInsertImage
     */
    Select.prototype.insertImage = function (url, styles) {
        if (styles === void 0) { styles = {}; }
        var image = typeof url === 'string' ? Helpers_1.dom('<img src=""/>', this.jodit.editorDocument) : Helpers_1.dom(url, this.jodit.editorDocument);
        if (typeof url === 'string') {
            image.setAttribute('src', url);
        }
        var dw = this.jodit.options.imageDefaultWidth.toString();
        if (dw && "auto" !== dw && (String(dw)).indexOf("px") < 0 && (String(dw)).indexOf("%") < 0) {
            dw += "px";
        }
        styles.width = dw;
        if (styles && typeof styles === 'object') {
            Helpers_1.each(styles, function (value, key) {
                image.style[key] = value;
            });
        }
        var onload = function () {
            if (image.naturalHeight < image.offsetHeight || image.naturalWidth < image.offsetWidth) {
                image.style.width = '';
                image.style.height = '';
            }
            image.removeEventListener("load", onload);
        };
        image.addEventListener("load", onload);
        if (image.complete) {
            onload();
        }
        this.insertNode(image);
        /**
         * Triggered after image was inserted {@link Selection~insertImage|insertImage}. This method can executed from {@link FileBrowser|FileBrowser} or {@link Uploader|Uploader}
         * @event afterInsertImage
         * @param {HTMLImageElement} image
         * @example
         * ```javascript
         * var editor = new Jodit("#redactor");
         * editor.events.on('afterInsertImage', function (image) {
         *     image.className = 'bloghead4';
         * });
         * ```
         */
        this.jodit.events.fire('afterInsertImage', image);
    };
    /**
     * Set cursor after the node
     *
     * @param {Node} node
     * @return {Node} fake invisible textnode. After insert it can be removed
     */
    Select.prototype.setCursorAfter = function (node) {
        var _this = this;
        if (!(node instanceof this.jodit.editorWindow.Node)) {
            throw new Error('Parameter node most be instance of Node');
        }
        if (!Dom_1.Dom.up(node, function (elm) { return (elm === _this.jodit.editor || (elm && elm.parentNode === _this.jodit.editor)); }, this.jodit.editor)) {
            throw new Error('Node element must be in editor');
        }
        var range = this.jodit.editorDocument.createRange();
        var fakeNode = false;
        if (node.nodeType !== Node.TEXT_NODE) {
            fakeNode = this.jodit.editorDocument.createTextNode(consts.INVISIBLE_SPACE);
            range.setStartAfter(node);
            range.insertNode(fakeNode);
            range.selectNode(fakeNode);
        }
        else {
            range.setEnd(node, node.nodeValue !== null ? node.nodeValue.length : 0);
        }
        range.collapse(false);
        this.selectRange(range);
        return fakeNode;
    };
    /**
     * Checks if the cursor is at the end(start) block
     *
     * @param  {boolean} start=false true - check whether the cursor is at the start block
     * @param {HTMLElement} parentBlock - Find in this
     *
     * @return {boolean | null} true - the cursor is at the end(start) block, null - cursor somewhere outside
     */
    Select.prototype.cursorInTheEdge = function (start, parentBlock) {
        var sel = this.jodit.editorWindow.getSelection();
        var range = sel.rangeCount ? sel.getRangeAt(0) : null;
        if (!range) {
            return null;
        }
        var container = start ? range.startContainer : range.endContainer, sibling = function (node) {
            return start ? Dom_1.Dom.prev(node, function (elm) { return !!elm; }, parentBlock) : Dom_1.Dom.next(node, function (elm) { return !!elm; }, parentBlock);
        }, checkSiblings = function (next) {
            while (next) {
                next = sibling(next);
                if (next && !Dom_1.Dom.isEmptyTextNode(next) && next.nodeName !== 'BR') {
                    return false;
                }
            }
        };
        if (container.nodeType === Node.TEXT_NODE) {
            var value = container.nodeValue || '';
            if (start && range.startOffset > value.length - value.replace(constants_1.INVISIBLE_SPACE_REG_EXP_START, '').length) {
                return false;
            }
            if (!start && range.startOffset < value.replace(constants_1.INVISIBLE_SPACE_REG_EXP_END, '').length) {
                return false;
            }
            if (checkSiblings(container) === false) {
                return false;
            }
        }
        var current = this.current(false);
        if (!current || !Dom_1.Dom.isOrContains(parentBlock, current, true)) {
            return null;
        }
        if (!start && range.startContainer.childNodes[range.startOffset]) {
            if (current && !Dom_1.Dom.isEmptyTextNode(current)) {
                return false;
            }
        }
        return checkSiblings(current) !== false;
    };
    /**
     * Set cursor before the node
     *
     * @param {Node} node
     * @return {Text} fake invisible textnode. After insert it can be removed
     */
    Select.prototype.setCursorBefore = function (node) {
        var _this = this;
        if (!(node instanceof this.jodit.editorWindow.Node)) {
            throw new Error('Parameter node most be instance of Node');
        }
        if (!Dom_1.Dom.up(node, function (elm) { return (elm === _this.jodit.editor || (elm && elm.parentNode === _this.jodit.editor)); }, this.jodit.editor)) {
            throw new Error('Node element must be in editor');
        }
        var range = this.jodit.editorDocument.createRange();
        var fakeNode = false;
        if (node.nodeType !== Node.TEXT_NODE) {
            fakeNode = this.jodit.editorDocument.createTextNode(consts.INVISIBLE_SPACE);
            range.setStartBefore(node);
            range.collapse(true);
            range.insertNode(fakeNode);
            range.selectNode(fakeNode);
        }
        else {
            range.setStart(node, node.nodeValue !== null ? node.nodeValue.length : 0);
        }
        range.collapse(true);
        this.selectRange(range);
        return fakeNode;
    };
    /**
     * Set cursor in the node
     *
     * @param {Node} node
     * @param {boolean} [inStart=false] set cursor in start of element
     */
    Select.prototype.setCursorIn = function (node, inStart) {
        var _this = this;
        if (inStart === void 0) { inStart = false; }
        if (!(node instanceof this.jodit.editorWindow.Node)) {
            throw new Error('Parameter node most be instance of Node');
        }
        if (!Dom_1.Dom.up(node, function (elm) { return (elm === _this.jodit.editor || (elm && elm.parentNode === _this.jodit.editor)); }, this.jodit.editor)) {
            throw new Error('Node element must be in editor');
        }
        var range = this.jodit.editorDocument.createRange();
        var start = node, last = node;
        do {
            if (start.nodeType === Node.TEXT_NODE) {
                break;
            }
            last = start;
            start = inStart ? start.firstChild : start.lastChild;
        } while (start);
        if (!start) {
            var fakeNode = this.jodit.editorDocument.createTextNode(consts.INVISIBLE_SPACE);
            if (!/^(img|br|input)$/i.test(last.nodeName)) {
                last.appendChild(fakeNode);
                last = fakeNode;
            }
            else {
                start = last;
            }
        }
        range.selectNodeContents(start || last);
        range.collapse(inStart);
        this.selectRange(range);
        return last;
    };
    /**
     * Set range selection
     *
     * @param range
     * @fires changeSelection
     */
    Select.prototype.selectRange = function (range) {
        var sel = this.jodit.editorWindow.getSelection();
        sel.removeAllRanges();
        sel.addRange(range);
        /**
         * Fired after change selection
         *
         * @event changeSelection
         */
        this.jodit.events.fire('changeSelection');
    };
    /**
     * Select node
     *
     * @param {Node} node
     * @param {boolean} [inward=false] select all inside
     */
    Select.prototype.select = function (node, inward) {
        var _this = this;
        if (inward === void 0) { inward = false; }
        if (!(node instanceof this.jodit.editorWindow.Node)) {
            throw new Error('Parameter node most be instance of Node');
        }
        if (!Dom_1.Dom.up(node, function (elm) { return (elm === _this.jodit.editor || (elm && elm.parentNode === _this.jodit.editor)); }, this.jodit.editor)) {
            throw new Error('Node element must be in editor');
        }
        var range = this.jodit.editorDocument.createRange();
        range[inward ? 'selectNodeContents' : 'selectNode'](node);
        this.selectRange(range);
    };
    Select.prototype.getHTML = function () {
        var selection = this.jodit.editorWindow.getSelection();
        if (selection.rangeCount > 0) {
            var range = selection.getRangeAt(0);
            var clonedSelection = range.cloneContents();
            var div = this.jodit.editorDocument.createElement('div');
            div.appendChild(clonedSelection);
            return div.innerHTML;
        }
        return '';
    };
    return Select;
}(Component_1.Component));
exports.Select = Select;


/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Config_1 = __webpack_require__(1);
var Helpers_1 = __webpack_require__(0);
Config_1.Config.prototype.defaultAjaxOptions = {
    dataType: 'json',
    method: 'GET',
    url: '',
    data: null,
    contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
    headers: {
        'X-REQUESTED-WITH': 'XMLHttpRequest' // compatible with jQuery
    },
    withCredentials: true,
    xhr: function () {
        var XHR = typeof XDomainRequest === 'undefined' ? XMLHttpRequest : XDomainRequest;
        return new XHR();
    }
};
var Ajax = /** @class */ (function () {
    function Ajax(editor, options) {
        var _this = this;
        this.success_response_codes = [200, 201, 202];
        this.jodit = editor;
        this.options = Helpers_1.extend(true, {}, Config_1.Config.prototype.defaultAjaxOptions, options);
        if (this.options.xhr) {
            this.xhr = this.options.xhr();
        }
        editor && editor.events && editor.events.on('beforeDestruct', function () {
            _this.abort();
        });
    }
    Ajax.prototype.__buildParams = function (obj, prefix) {
        if (this.options.queryBuild && typeof this.options.queryBuild === 'function') {
            return this.options.queryBuild.call(this, obj, prefix);
        }
        if (typeof obj === 'string' || (this.jodit.ownerWindow['FormData'] && obj instanceof this.jodit.ownerWindow['FormData'])) {
            return obj;
        }
        var str = [], p, k, v;
        for (p in obj) {
            if (obj.hasOwnProperty(p)) {
                k = prefix ? prefix + "[" + p + "]" : p;
                v = obj[p];
                str.push(typeof v === "object" ? this.__buildParams(v, k) : encodeURIComponent(k) + "=" + encodeURIComponent(v));
            }
        }
        return str.join("&");
    };
    Ajax.prototype.abort = function () {
        this.xhr.abort();
        return this;
    };
    Ajax.prototype.send = function () {
        var _this = this;
        return new Promise(function (resolve, reject) {
            var __parse = function (resp) {
                switch (_this.options.dataType) {
                    case 'json':
                        try {
                            resp = JSON.parse(resp);
                        }
                        catch (e) {
                            reject.call(_this.xhr, e);
                            return;
                        }
                        break;
                }
                return resp;
            };
            _this.xhr.onabort = function () {
                reject(new Error(_this.xhr.statusText));
            };
            _this.xhr.onerror = function () {
                reject(new Error(_this.xhr.statusText));
            };
            _this.xhr.ontimeout = function () {
                reject(new Error(_this.xhr.statusText));
            };
            _this.xhr.onload = function () {
                _this.response = _this.xhr.responseText;
                _this.status = _this.xhr.status;
                resolve.call(_this.xhr, __parse(_this.response));
            };
            _this.xhr.onreadystatechange = function () {
                if (_this.xhr.readyState === XMLHttpRequest.DONE) {
                    var resp = _this.xhr.responseText;
                    _this.response = resp;
                    _this.status = _this.xhr.status;
                    if (_this.success_response_codes.indexOf(_this.xhr.status) > -1) {
                        resolve.call(_this.xhr, __parse(resp));
                    }
                    else {
                        reject.call(_this.xhr, new Error(_this.xhr.statusText || _this.jodit.i18n('Connection error!')));
                    }
                }
            };
            _this.xhr.withCredentials = _this.options.withCredentials || false;
            if (_this.options.url) {
                _this.xhr.open(_this.options.method || 'get', _this.options.url, true);
            }
            else {
                throw new Error('Need URL for AJAX request');
            }
            if (_this.options.contentType && _this.xhr.setRequestHeader) {
                _this.xhr.setRequestHeader("Content-type", _this.options.contentType);
            }
            if (_this.options.headers && _this.xhr.setRequestHeader) {
                Helpers_1.each(_this.options.headers, function (key, value) {
                    _this.xhr.setRequestHeader(key, value);
                });
            }
            //IE
            setTimeout(function () {
                _this.xhr.send(_this.options.data ? _this.__buildParams(_this.options.data) : undefined);
            }, 0);
        });
    };
    return Ajax;
}());
exports.Ajax = Ajax;


/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Component_1 = __webpack_require__(4);
var Helpers_1 = __webpack_require__(0);
var ToolbarCollection_1 = __webpack_require__(5);
/**
 * Module to generate context menu
 *
 * @module ContextMenu
 * @param {Object} parent Jodit main object
 */
var ContextMenu = /** @class */ (function (_super) {
    __extends(ContextMenu, _super);
    function ContextMenu(editor) {
        var _this = _super.call(this, editor) || this;
        /**
         * Hide context menu
         *
         * @method hide
         */
        _this.hide = function () {
            _this.context.classList.remove('jodit_context_menu-show');
            _this.jodit.ownerWindow
                .removeEventListener('mouseup', _this.hide);
        };
        _this.context = Helpers_1.dom("<div data-editor_id=\"" + _this.jodit.id + "\" class=\"jodit_context_menu\"></div>", editor.ownerDocument);
        editor.ownerDocument.body.appendChild(_this.context);
        return _this;
    }
    ContextMenu.prototype.destruct = function () {
        this.context && this.context.parentNode && this.context.parentNode.removeChild(this.context);
    };
    /**
     * Generate and show context menu
     *
     * @method show
     * @param {number} x Global coordinate by X
     * @param {number} y Global coordinate by Y
     * @param {Action[]} actions Array with plainobjects {icon: 'bin', title: 'Delete', exec: function () { do smth}}
     * @example
     * ```javascript
     * parent.show(e.clientX, e.clientY, [{icon: 'bin', title: 'Delete', exec: function () { alert(1) }]);
     * ```
     */
    ContextMenu.prototype.show = function (x, y, actions, zIndex) {
        var _this = this;
        var self = this;
        if (!Array.isArray(actions)) {
            return;
        }
        if (zIndex) {
            this.context.style.zIndex = zIndex.toString();
        }
        this.context.innerHTML = '';
        actions.forEach(function (item) {
            if (!item) {
                return;
            }
            var action = Helpers_1.dom('<a href="javascript:void(0)">' + (item.icon ? ToolbarCollection_1.ToolbarIcon.getIcon(item.icon) : '') + '<span></span></a>', _this.jodit.ownerDocument);
            var span = action.querySelector('span');
            action.addEventListener('click', function (e) {
                item.exec && item.exec.call(self, e);
                self.hide();
                return false;
            });
            span.innerText = self.jodit.i18n(item.title || '');
            self.context.appendChild(action);
        });
        Helpers_1.css(self.context, {
            left: x,
            top: y
        });
        this.jodit.ownerWindow
            .addEventListener('mouseup', self.hide);
        this.context.classList.add('jodit_context_menu-show');
    };
    return ContextMenu;
}(Component_1.Component));
exports.ContextMenu = ContextMenu;


/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Helpers_1 = __webpack_require__(0);
var localStorageProvider = /** @class */ (function () {
    function localStorageProvider() {
    }
    localStorageProvider.prototype.set = function (key, value) {
        localStorage.setItem(key, value.toString());
    };
    localStorageProvider.prototype.get = function (key) {
        return localStorage.getItem(key);
    };
    return localStorageProvider;
}());
exports.localStorageProvider = localStorageProvider;
var Storage = /** @class */ (function () {
    function Storage(provider) {
        this.provider = provider;
        this.prefix = 'Jodit_';
    }
    Storage.prototype.set = function (key, value) {
        this.provider.set(Helpers_1.camelCase(this.prefix + key), value);
    };
    Storage.prototype.get = function (key) {
        return this.provider.get(Helpers_1.camelCase(this.prefix + key));
    };
    return Storage;
}());
exports.Storage = Storage;


/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Config_1 = __webpack_require__(1);
var Component_1 = __webpack_require__(4);
var Snapshot_1 = __webpack_require__(18);
var Stack_1 = __webpack_require__(19);
var Helpers_1 = __webpack_require__(0);
Config_1.Config.prototype.observer = {
    timeout: 100
};
var Command = /** @class */ (function () {
    function Command(oldValue, newValue, observer) {
        this.observer = observer;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }
    Command.prototype.undo = function () {
        this.observer.snapshot.restore(this.oldValue);
    };
    Command.prototype.redo = function () {
        this.observer.snapshot.restore(this.newValue);
    };
    return Command;
}());
exports.Command = Command;
/**
 * The module monitors the status of the editor and creates / deletes the required number of Undo / Redo shots . To track changes in use {@link https://developer.mozilla.org/ru/docs/Web/API/MutationObserver|MutationObserver}
 *
 * @module Observer
 * @see {@link Snapshot|Snapshot}
 * @params {Jodit} parent Jodit main object
 */
var Observer = /** @class */ (function (_super) {
    __extends(Observer, _super);
    function Observer(editor) {
        var _this = _super.call(this, editor) || this;
        _this.onChangeStack = function () {
            _this.__newValue = _this.snapshot.make();
            if (!Snapshot_1.Snapshot.equal(_this.__newValue, _this.__startValue)) {
                _this.stack.push(new Command(_this.__startValue, _this.__newValue, _this));
                _this.__startValue = _this.__newValue;
                _this.changeStack();
            }
        };
        _this.stack = new Stack_1.Stack();
        _this.snapshot = new Snapshot_1.Snapshot(editor);
        var onChangeStack = Helpers_1.debounce(_this.onChangeStack, editor.defaultTimeout);
        editor.events
            .on('afterInit', function () {
            _this.__startValue = _this.snapshot.make();
            editor.events
                // save selection
                .on('changeSelection selectionstart selectionchange mousedown mouseup keydown keyup', function () {
                if (_this.__startValue.html === _this.jodit.getNativeEditorValue()) {
                    _this.__startValue = _this.snapshot.make();
                }
            })
                .on('change', function () {
                if (!_this.snapshot.isBlocked) {
                    onChangeStack();
                }
            });
        });
        return _this;
    }
    /**
     * Return state of the WYSIWYG editor to step back
     */
    Observer.prototype.redo = function () {
        if (this.stack.redo()) {
            this.__startValue = this.snapshot.make();
            this.changeStack();
        }
    };
    /**
     * Return the state of the WYSIWYG editor to step forward
     */
    Observer.prototype.undo = function () {
        if (this.stack.undo()) {
            this.__startValue = this.snapshot.make();
            this.changeStack();
        }
    };
    Observer.prototype.clear = function () {
        this.__startValue = this.snapshot.make();
        this.stack.clear();
        this.changeStack();
    };
    Observer.prototype.changeStack = function () {
        this.jodit && this.jodit.events && this.jodit.events.fire('changeStack');
    };
    return Observer;
}(Component_1.Component));
exports.Observer = Observer;


/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Component_1 = __webpack_require__(4);
var Dom_1 = __webpack_require__(3);
/**
 * Module for creating snapshot of editor which includes html content and the current selection
 */
var Snapshot = /** @class */ (function (_super) {
    __extends(Snapshot, _super);
    function Snapshot() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.isBlocked = false;
        return _this;
    }
    /**
     * Calc count element before some node in parentNode. All text nodes are joined
     *
     * @param {Node | null} elm
     * @return {number}
     */
    Snapshot.countNodesBeforeInParent = function (elm) {
        if (!elm.parentNode) {
            return 0;
        }
        var elms = elm.parentNode.childNodes, count = 0, last = null, j;
        for (j = 0; j < elms.length; j += 1) {
            if (last && (!(elms[j].nodeType === Node.TEXT_NODE && elms[j].textContent === '') &&
                !(last.nodeType === Node.TEXT_NODE && elms[j].nodeType === Node.TEXT_NODE))) {
                count += 1;
            }
            if (elms[j] === elm) {
                return count;
            }
            last = elms[j];
        }
        return 0;
    };
    /**
     * Calc whole hierarchy path before some element in editor's tree
     *
     * @param {Node | null} elm
     * @return {number[]}
     * @private
     */
    Snapshot.prototype.calcHierarchyLadder = function (elm) {
        var counts = [];
        if (!elm || !elm.parentNode || !Dom_1.Dom.isOrContains(this.jodit.editor, elm)) {
            return [];
        }
        while (elm && elm !== this.jodit.editor) {
            if (elm) {
                counts.push(Snapshot.countNodesBeforeInParent(elm));
            }
            elm = elm.parentNode;
        }
        return counts.reverse();
    };
    /**
     * Calc normal offset in joined text nodes
     *
     * @param {Node | null} elm
     * @param {number} offset
     * @return {number}
     */
    Snapshot.strokeOffset = function (elm, offset) {
        while (elm && elm.nodeType === Node.TEXT_NODE) {
            elm = elm.previousSibling;
            if (elm && elm.nodeType === Node.TEXT_NODE && elm.textContent !== null) {
                offset += elm.textContent.length;
            }
        }
        return offset;
    };
    /**
     * Creates object a snapshot of editor: html and the current selection. Current selection calculate by offset by start document
     *
     * @return {object} {html: string, range: {startContainer: int, startOffset: int, endContainer: int, endOffset: int}} или {html: string} при отсутствии выделения
     */
    Snapshot.prototype.make = function () {
        var snapshot = {
            html: '',
            range: {
                startContainer: [],
                startOffset: 0,
                endContainer: [],
                endOffset: 0
            }
        };
        snapshot.html = this.jodit.getNativeEditorValue();
        var sel = this.jodit.editorWindow.getSelection();
        if (sel && sel.rangeCount) {
            var range = sel.getRangeAt(0);
            var startContainer = this.calcHierarchyLadder(range.startContainer), startOffset = Snapshot.strokeOffset(range.startContainer, range.startOffset), endContainer = this.calcHierarchyLadder(range.endContainer), endOffset = Snapshot.strokeOffset(range.endContainer, range.endOffset);
            if (!startContainer.length && range.startContainer !== this.jodit.editor) {
                startOffset = 0;
            }
            if (!endContainer.length && range.endContainer !== this.jodit.editor) {
                endOffset = 0;
            }
            snapshot.range = {
                startContainer: startContainer,
                startOffset: startOffset,
                endContainer: endContainer,
                endOffset: endOffset
            };
        }
        return snapshot;
    };
    Snapshot.prototype.getElementByLadder = function (ladder) {
        var n = this.jodit.editor, i;
        for (i = 0; n && i < ladder.length; i += 1) {
            n = n.childNodes[ladder[i]];
        }
        return n;
    };
    /**
     * Compare two snapshotes, if and htmls and selections match, then return true
     *
     * @param {SnapshotType} first - the first snapshote
     * @param {SnapshotType} second - second shot
     * @return {boolean}
     */
    Snapshot.equal = function (first, second) {
        return first.html === second.html && JSON.stringify(first.range) === JSON.stringify(second.range);
    };
    /**
     * Restores the state of the editor of the snapshot. Rebounding is not only html but selected text
     *
     * @param {object} snapshot - snapshot of editor resulting from the `{@link Snapshot~make|make}`
     * @see make
     */
    Snapshot.prototype.restore = function (snapshot) {
        this.isBlocked = true;
        this.jodit.setEditorValue(snapshot.html);
        try {
            if (snapshot.range) {
                var range = this.jodit.editorDocument.createRange();
                range.setStart(this.getElementByLadder(snapshot.range.startContainer), snapshot.range.startOffset);
                range.setEnd(this.getElementByLadder(snapshot.range.endContainer), snapshot.range.endOffset);
                this.jodit.selection.selectRange(range);
            }
        }
        catch (__ignore) {
            if (false) {
                throw __ignore;
            }
        }
        this.isBlocked = false;
    };
    return Snapshot;
}(Component_1.Component));
exports.Snapshot = Snapshot;


/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Stack = /** @class */ (function () {
    function Stack() {
        this.commands = [];
        this.stackPosition = -1;
    }
    Stack.prototype.clearRedo = function () {
        this.commands.length = this.stackPosition + 1;
    };
    Stack.prototype.clear = function () {
        this.commands.length = 0;
        this.stackPosition = -1;
    };
    Stack.prototype.push = function (command) {
        this.clearRedo();
        this.commands.push(command);
        this.stackPosition += 1;
    };
    Stack.prototype.undo = function () {
        if (this.canUndo()) {
            if (this.commands[this.stackPosition]) {
                this.commands[this.stackPosition].undo();
            }
            this.stackPosition -= 1;
            return true;
        }
        return false;
    };
    Stack.prototype.redo = function () {
        if (this.canRedo()) {
            this.stackPosition += 1;
            if (this.commands[this.stackPosition]) {
                this.commands[this.stackPosition].redo();
            }
            return true;
        }
        return false;
    };
    Stack.prototype.canUndo = function () {
        return this.stackPosition >= 0;
    };
    Stack.prototype.canRedo = function () {
        return this.stackPosition < this.commands.length - 1;
    };
    return Stack;
}());
exports.Stack = Stack;


/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Module for working with tables . Delete, insert , merger, division of cells , rows and columns. When creating elements such as <table> for each of them
 * creates a new instance Jodit.modules.TableProcessor and it can be accessed via $('table').data('table-processor')
 *
 * @module Table
 * @param {Object} parent Jodit main object
 * @param {HTMLTableElement} table Table for which to create a module
 */
var Helpers_1 = __webpack_require__(0);
var consts = __webpack_require__(2);
var Dom_1 = __webpack_require__(3);
var Table = /** @class */ (function () {
    function Table() {
    }
    Table.addSelected = function (td) {
        td.setAttribute(consts.JODIT_SELECTED_CELL_MARKER, '1');
    };
    Table.restoreSelection = function (td) {
        td.removeAttribute(consts.JODIT_SELECTED_CELL_MARKER);
    };
    /**
     *
     * @param {HTMLTableElement} table
     * @return {HTMLTableCellElement[]}
     */
    Table.getAllSelectedCells = function (table) {
        return table ? Helpers_1.$$("td[" + consts.JODIT_SELECTED_CELL_MARKER + "],th[" + consts.JODIT_SELECTED_CELL_MARKER + "]", table) : [];
    };
    /**
     * @param {HTMLTableElement} table
     * @return {number}
     */
    Table.getRowsCount = function (table) {
        return table.rows.length;
    };
    /**
     * @param {HTMLTableElement} table
     * @return {number}
     */
    Table.getColumnsCount = function (table) {
        var matrix = Table.formalMatrix(table);
        return matrix.reduce(function (max_count, cells) {
            return Math.max(max_count, cells.length);
        }, 0);
    };
    /**
     *
     * @param {HTMLTableElement} table
     * @param {function(HTMLTableCellElement, int, int, int, int):boolean} [callback] if return false cycle break
     * @return {Array}
     */
    Table.formalMatrix = function (table, callback) {
        var matrix = [[],];
        var rows = Array.prototype.slice.call(table.rows);
        var setCell = function (cell, i) {
            if (matrix[i] === undefined) {
                matrix[i] = [];
            }
            var colSpan = cell.colSpan, column, rowSpan = cell.rowSpan, row, currentColumn = 0;
            while (matrix[i][currentColumn]) {
                currentColumn += 1;
            }
            for (row = 0; row < rowSpan; row += 1) {
                for (column = 0; column < colSpan; column += 1) {
                    if (matrix[i + row] === undefined) {
                        matrix[i + row] = [];
                    }
                    if (callback && callback(cell, i + row, currentColumn + column, colSpan, rowSpan) === false) {
                        return false;
                    }
                    matrix[i + row][currentColumn + column] = cell;
                }
            }
        };
        for (var i = 0, j = void 0; i < rows.length; i += 1) {
            var cells = Array.prototype.slice.call(rows[i].cells);
            for (j = 0; j < cells.length; j += 1) {
                if (setCell(cells[j], i) === false) {
                    return matrix;
                }
            }
        }
        return matrix;
    };
    /**
     * Get cell coordinate in formal table (without colspan and rowspan)
     */
    Table.formalCoordinate = function (table, cell, max) {
        if (max === void 0) { max = false; }
        var i = 0, j = 0, width = 1, height = 1;
        Table.formalMatrix(table, function (td, ii, jj, colSpan, rowSpan) {
            if (cell === td) {
                i = ii;
                j = jj;
                width = colSpan || 1;
                height = rowSpan || 1;
                if (max) {
                    j += (colSpan || 1) - 1;
                    i += (rowSpan || 1) - 1;
                }
                return false;
            }
        });
        return [i, j, width, height];
    };
    /**
     * Inserts a new line after row what contains the selected cell
     *
     * @param {HTMLTableElement} table
     * @param {Boolean|HTMLTableRowElement} [line=false] Insert a new line after/before this line contains the selected cell
     * @param {Boolean} [after=true] Insert a new line after line contains the selected cell
     */
    Table.appendRow = function (table, line, after) {
        if (line === void 0) { line = false; }
        if (after === void 0) { after = true; }
        var columnsCount = Table.getColumnsCount(table), row = table.ownerDocument.createElement('tr'), j;
        for (j = 0; j < columnsCount; j += 1) {
            row.appendChild(table.ownerDocument.createElement('td'));
        }
        if (after && line && line.nextSibling) {
            line.parentNode && line.parentNode.insertBefore(row, line.nextSibling);
        }
        else if (!after && line) {
            line.parentNode && line.parentNode.insertBefore(row, line);
        }
        else {
            (Helpers_1.$$(':scope>tbody', table)[0] || table).appendChild(row);
        }
    };
    /**
     * Remove row
     *
     * @param {HTMLTableElement} table
     * @param {int} rowIndex
     */
    Table.removeRow = function (table, rowIndex) {
        var box = Table.formalMatrix(table);
        var dec;
        var row = table.rows[rowIndex];
        Helpers_1.each(box[rowIndex], function (j, cell) {
            dec = false;
            if (rowIndex - 1 >= 0 && box[rowIndex - 1][j] === cell) {
                dec = true;
            }
            else if (box[rowIndex + 1] && box[rowIndex + 1][j] === cell) {
                if (cell.parentNode === row && cell.parentNode.nextSibling) {
                    dec = true;
                    var nextCell = j + 1;
                    while (box[rowIndex + 1][nextCell] === cell) {
                        nextCell += 1;
                    }
                    var nextRow = Dom_1.Dom.next(cell.parentNode, function (elm) { return elm && elm.nodeType === Node.ELEMENT_NODE && elm.nodeName === 'TR'; }, table);
                    if (box[rowIndex + 1][nextCell]) {
                        nextRow.insertBefore(cell, box[rowIndex + 1][nextCell]);
                    }
                    else {
                        nextRow.appendChild(cell);
                    }
                }
            }
            else {
                cell.parentNode && cell.parentNode.removeChild(cell);
            }
            if (dec && (cell.parentNode === row || cell !== box[rowIndex][j - 1])) {
                var rowSpan = cell.rowSpan;
                if (rowSpan - 1 > 1) {
                    cell.setAttribute('rowspan', (rowSpan - 1).toString());
                }
                else {
                    cell.removeAttribute('rowspan');
                }
            }
        });
        if (row && row.parentNode) {
            row.parentNode.removeChild(row);
        }
    };
    /**
     * Insert column before / after all the columns containing the selected cells
     *
     */
    Table.appendColumn = function (table, j, after) {
        if (after === void 0) { after = true; }
        var box = Table.formalMatrix(table);
        var i;
        if (j === undefined) {
            j = Table.getColumnsCount(table) - 1;
        }
        for (i = 0; i < box.length; i += 1) {
            var cell = table.ownerDocument.createElement('td');
            var td = box[i][j];
            var added = false;
            if (after) {
                if (box[i] && td && j + 1 >= box[i].length || td !== box[i][j + 1]) {
                    if (td.nextSibling) {
                        td.parentNode && td.parentNode.insertBefore(cell, td.nextSibling);
                    }
                    else {
                        td.parentNode && td.parentNode.appendChild(cell);
                    }
                    added = true;
                }
            }
            else {
                if (j - 1 < 0 || box[i][j] !== box[i][j - 1] && box[i][j].parentNode) {
                    td.parentNode && td.parentNode.insertBefore(cell, box[i][j]);
                    added = true;
                }
            }
            if (!added) {
                box[i][j].setAttribute('colspan', (parseInt(box[i][j].getAttribute('colspan') || '1', 10) + 1).toString());
            }
        }
    };
    /**
     * Remove column by index
     *
     * @param {HTMLTableElement} table
     * @param {int} [j]
     */
    Table.removeColumn = function (table, j) {
        var box = Table.formalMatrix(table);
        var dec;
        Helpers_1.each(box, function (i, cells) {
            var td = cells[j];
            dec = false;
            if (j - 1 >= 0 && box[i][j - 1] === td) {
                dec = true;
            }
            else if (j + 1 < cells.length && box[i][j + 1] === td) {
                dec = true;
            }
            else {
                td.parentNode && td.parentNode.removeChild(td);
            }
            if (dec && (i - 1 < 0 || td !== box[i - 1][j])) {
                var colSpan = td.colSpan;
                if (colSpan - 1 > 1) {
                    td.setAttribute('colspan', (colSpan - 1).toString());
                }
                else {
                    td.removeAttribute('colspan');
                }
            }
        });
    };
    /**
     * Define bound for selected cells
     *
     * @param {HTMLTableElement} table
     * @param {Array.<HTMLTableCellElement>} selectedCells
     * @return {number[][]}
     */
    Table.getSelectedBound = function (table, selectedCells) {
        var bound = [[Infinity, Infinity], [0, 0]];
        var box = Table.formalMatrix(table);
        var i, j, k;
        for (i = 0; i < box.length; i += 1) {
            for (j = 0; j < box[i].length; j += 1) {
                if (selectedCells.indexOf(box[i][j]) !== -1) {
                    bound[0][0] = Math.min(i, bound[0][0]);
                    bound[0][1] = Math.min(j, bound[0][1]);
                    bound[1][0] = Math.max(i, bound[1][0]);
                    bound[1][1] = Math.max(j, bound[1][1]);
                }
            }
        }
        for (i = bound[0][0]; i <= bound[1][0]; i += 1) {
            for (k = 1, j = bound[0][1]; j <= bound[1][1]; j += 1) {
                while (box[i][j - k] && box[i][j] === box[i][j - k]) {
                    bound[0][1] = Math.min(j - k, bound[0][1]);
                    bound[1][1] = Math.max(j - k, bound[1][1]);
                    k += 1;
                }
                k = 1;
                while (box[i][j + k] && box[i][j] === box[i][j + k]) {
                    bound[0][1] = Math.min(j + k, bound[0][1]);
                    bound[1][1] = Math.max(j + k, bound[1][1]);
                    k += 1;
                }
                k = 1;
                while (box[i - k] && box[i][j] === box[i - k][j]) {
                    bound[0][0] = Math.min(i - k, bound[0][0]);
                    bound[1][0] = Math.max(i - k, bound[1][0]);
                    k += 1;
                }
                k = 1;
                while (box[i + k] && box[i][j] === box[i + k][j]) {
                    bound[0][0] = Math.min(i + k, bound[0][0]);
                    bound[1][0] = Math.max(i + k, bound[1][0]);
                    k += 1;
                }
            }
        }
        return bound;
    };
    /**
     *
     * @param {HTMLTableElement} table
     */
    Table.normalizeTable = function (table) {
        var i, j, min, not;
        var __marked = [], box = Table.formalMatrix(table);
        // remove extra colspans
        for (j = 0; j < box[0].length; j += 1) {
            min = 1000000;
            not = false;
            for (i = 0; i < box.length; i += 1) {
                if (box[i][j] === undefined) {
                    continue; // broken table
                }
                if (box[i][j].colSpan < 2) {
                    not = true;
                    break;
                }
                min = Math.min(min, box[i][j].colSpan);
            }
            if (!not) {
                for (i = 0; i < box.length; i += 1) {
                    if (box[i][j] === undefined) {
                        continue; // broken table
                    }
                    Table.__mark(box[i][j], 'colspan', box[i][j].colSpan - min + 1, __marked);
                }
            }
        }
        // remove extra rowspans
        for (i = 0; i < box.length; i += 1) {
            min = 1000000;
            not = false;
            for (j = 0; j < box[i].length; j += 1) {
                if (box[i][j] === undefined) {
                    continue; // broken table
                }
                if (box[i][j].rowSpan < 2) {
                    not = true;
                    break;
                }
                min = Math.min(min, box[i][j].rowSpan);
            }
            if (!not) {
                for (j = 0; j < box[i].length; j += 1) {
                    if (box[i][j] === undefined) {
                        continue; // broken table
                    }
                    Table.__mark(box[i][j], 'rowspan', box[i][j].rowSpan - min + 1, __marked);
                }
            }
        }
        // remove rowspans and colspans equal 1 and empty class
        for (i = 0; i < box.length; i += 1) {
            for (j = 0; j < box[i].length; j += 1) {
                if (box[i][j] === undefined) {
                    continue; // broken table
                }
                if (box[i][j].hasAttribute('rowspan') && box[i][j].rowSpan === 1) {
                    box[i][j].removeAttribute('rowspan');
                }
                if (box[i][j].hasAttribute('colspan') && box[i][j].colSpan === 1) {
                    box[i][j].removeAttribute('colspan');
                }
                if (box[i][j].hasAttribute('class') && !box[i][j].getAttribute('class')) {
                    box[i][j].removeAttribute('class');
                }
            }
        }
        Table.__unmark(__marked);
    };
    /**
     * It combines all of the selected cells into one. The contents of the cells will also be combined
     *
     * @param {HTMLTableElement} table
     *
     */
    Table.mergeSelected = function (table) {
        var bound = Table.getSelectedBound(table, Table.getAllSelectedCells(table)), w = 0, first = null, first_j = 0, td, html = [], cols = 0, rows = 0;
        var __marked = [];
        if (bound && (bound[0][0] - bound[1][0] || bound[0][1] - bound[1][1])) {
            Table.formalMatrix(table, function (cell, i, j, cs, rs) {
                if (i >= bound[0][0] && i <= bound[1][0]) {
                    if (j >= bound[0][1] && j <= bound[1][1]) {
                        td = cell;
                        if (td['__i_am_already_was']) {
                            return;
                        }
                        td['__i_am_already_was'] = true;
                        if (i === bound[0][0] && td.style.width) {
                            w += td.offsetWidth;
                        }
                        if (Helpers_1.trim(cell.innerHTML.replace(/<br(\/)?>/g, '')) !== '') {
                            html.push(cell.innerHTML);
                        }
                        if (cs > 1) {
                            cols += cs - 1;
                        }
                        if (rs > 1) {
                            rows += rs - 1;
                        }
                        if (!first) {
                            first = cell;
                            first_j = j;
                        }
                        else {
                            Table.__mark(td, 'remove', 1, __marked);
                        }
                    }
                }
            });
            cols = bound[1][1] - bound[0][1] + 1;
            rows = bound[1][0] - bound[0][0] + 1;
            if (first) {
                if (cols > 1) {
                    Table.__mark(first, 'colspan', cols, __marked);
                }
                if (rows > 1) {
                    Table.__mark(first, 'rowspan', rows, __marked);
                }
                if (w) {
                    Table.__mark(first, 'width', ((w / table.offsetWidth) * 100).toFixed(consts.ACCURACY) + '%', __marked);
                    if (first_j) {
                        Table.setColumnWidthByDelta(table, first_j, 0, true, __marked);
                    }
                }
                first.innerHTML = html.join('<br/>');
                delete first['__i_am_already_was'];
                Table.__unmark(__marked);
                Table.normalizeTable(table);
                Helpers_1.each([].slice.call(table.rows), function (index, tr) {
                    if (!tr.cells.length) {
                        tr.parentNode.removeChild(tr);
                    }
                });
            }
        }
    };
    /**
     * Divides all selected by `jodit_focused_cell` class table cell in 2 parts vertical. Those division into 2 columns
     */
    Table.splitHorizontal = function (table) {
        var coord, td, tr, parent, after;
        var __marked = [];
        Table.getAllSelectedCells(table).forEach(function (cell) {
            td = table.ownerDocument.createElement('td');
            td.appendChild(table.ownerDocument.createElement('br'));
            tr = table.ownerDocument.createElement('tr');
            coord = Table.formalCoordinate(table, cell);
            if (cell.rowSpan < 2) {
                Table.formalMatrix(table, function (td, i, j) {
                    if (coord[0] === i && coord[1] !== j && td !== cell) {
                        Table.__mark(td, 'rowspan', td.rowSpan + 1, __marked);
                    }
                });
                Dom_1.Dom.after(Dom_1.Dom.closest(cell, 'tr', table), tr);
                tr.appendChild(td);
            }
            else {
                Table.__mark(cell, 'rowspan', cell.rowSpan - 1, __marked);
                Table.formalMatrix(table, function (td, i, j) {
                    if (i > coord[0] && i < coord[0] + cell.rowSpan && coord[1] > j && td.parentNode.rowIndex === i) {
                        after = td;
                    }
                    if (coord[0] < i && td === cell) {
                        parent = table.rows[i];
                    }
                });
                if (after) {
                    Dom_1.Dom.after(after, td);
                }
                else {
                    parent.insertBefore(td, parent.firstChild);
                }
            }
            if (cell.colSpan > 1) {
                Table.__mark(td, 'colspan', cell.colSpan, __marked);
            }
            Table.__unmark(__marked);
            Table.restoreSelection(cell);
        });
        this.normalizeTable(table);
    };
    /**
     * It splits all the selected cells into 2 parts horizontally. Those. are added new row
     *
     * @param {HTMLTableElement} table
     */
    Table.splitVertical = function (table) {
        var coord, td, percentage;
        var __marked = [];
        Table.getAllSelectedCells(table).forEach(function (cell) {
            coord = Table.formalCoordinate(table, cell);
            if (cell.colSpan < 2) {
                Table.formalMatrix(table, function (td, i, j) {
                    if (coord[1] === j && coord[0] !== i && td !== cell) {
                        Table.__mark(td, 'colspan', td.colSpan + 1, __marked);
                    }
                });
            }
            else {
                Table.__mark(cell, 'colspan', cell.colSpan - 1, __marked);
            }
            td = table.ownerDocument.createElement('td');
            td.appendChild(table.ownerDocument.createElement('br'));
            if (cell.rowSpan > 1) {
                Table.__mark(td, 'rowspan', cell.rowSpan, __marked);
            }
            var oldWidth = cell.offsetWidth; // get old width
            Dom_1.Dom.after(cell, td);
            percentage = (oldWidth / table.offsetWidth) / 2;
            Table.__mark(cell, 'width', (percentage * 100).toFixed(consts.ACCURACY) + '%', __marked);
            Table.__mark(td, 'width', (percentage * 100).toFixed(consts.ACCURACY) + '%', __marked);
            Table.__unmark(__marked);
            Table.restoreSelection(cell);
        });
        Table.normalizeTable(table);
    };
    /**
     *
     * @param {HTMLTableCellElement} cell
     * @param {string} key
     * @param {string} value
     * @param {HTMLTableCellElement[]} __marked
     * @private
     */
    Table.__mark = function (cell, key, value, __marked) {
        __marked.push(cell);
        if (!cell['__marked_value']) {
            cell['__marked_value'] = {};
        }
        cell['__marked_value'][key] = value === undefined ? 1 : value;
    };
    Table.__unmark = function (__marked) {
        __marked.forEach(function (cell) {
            if (cell['__marked_value']) {
                Helpers_1.each(cell['__marked_value'], function (key, value) {
                    switch (key) {
                        case 'remove':
                            cell.parentNode && cell.parentNode.removeChild(cell);
                            break;
                        case 'rowspan':
                            if (value > 1) {
                                cell.setAttribute('rowspan', value);
                            }
                            else {
                                cell.removeAttribute('rowspan');
                            }
                            break;
                        case 'colspan':
                            if (value > 1) {
                                cell.setAttribute('colspan', value);
                            }
                            else {
                                cell.removeAttribute('colspan');
                            }
                            break;
                        case 'width':
                            cell.style.width = value;
                            break;
                    }
                    delete cell['__marked_value'][key];
                });
                delete cell.__marked_value;
            }
        });
    };
    /**
     * Set column width used delta value
     *
     * @param {HTMLTableElement} table
     * @param {int} j column
     * @param {int} delta
     * @param {boolean} noUnmark
     * @param {HTMLTableCellElement[]} __marked
     */
    Table.setColumnWidthByDelta = function (table, j, delta, noUnmark, __marked) {
        var i, box = Table.formalMatrix(table), w, percent;
        for (i = 0; i < box.length; i += 1) {
            w = box[i][j].offsetWidth;
            percent = ((w + delta) / table.offsetWidth) * 100;
            Table.__mark(box[i][j], 'width', percent.toFixed(consts.ACCURACY) + '%', __marked);
        }
        if (!noUnmark) {
            Table.__unmark(__marked);
        }
    };
    return Table;
}());
exports.Table = Table;


/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
__webpack_require__(22);
__webpack_require__(26);
var Jodit_1 = __webpack_require__(6);
var ToolbarCollection_1 = __webpack_require__(5);
var consts = __webpack_require__(2);
var Plugins = __webpack_require__(32);
var Modules = __webpack_require__(12);
var Languages = __webpack_require__(73);
var Icons = __webpack_require__(79);
var Config_1 = __webpack_require__(1);
// copy constants in Jodit
Object.keys(consts).forEach(function (key) {
    Jodit_1.Jodit[key] = consts[key];
});
var esFilter = function (key) { return key !== '__esModule'; };
// Icons
Object.keys(Icons).filter(esFilter).forEach(function (key) {
    ToolbarCollection_1.ToolbarIcon.icons[key.replace('_', '-')] = Icons[key];
});
// Modules
Object.keys(Modules).filter(esFilter).forEach(function (key) {
    Jodit_1.Jodit.modules[key] = Modules[key];
});
//Plugins
Object.keys(Plugins).filter(esFilter).forEach(function (key) {
    Jodit_1.Jodit.plugins[key] = Plugins[key];
});
// Languages
Object.keys(Languages).filter(esFilter).forEach(function (key) {
    Jodit_1.Jodit.lang[key] = Languages[key];
});
Jodit_1.Jodit.defaultOptions = new Config_1.Config();
Config_1.OptionsDefault.prototype = Jodit_1.Jodit.defaultOptions;
if (false) {
    module.hot.accept('./plugins/index', function () {
        Object.keys(Jodit_1.Jodit.instances).forEach(function (id) {
            var plainOptions = __assign({}, Jodit_1.Jodit.instances[id].options.plainOptions);
            Jodit_1.Jodit.instances[id].destruct();
            new Jodit_1.Jodit('#' + id, plainOptions);
        });
    });
}
module.exports = Jodit_1.Jodit;


/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

// style-loader: Adds some css to the DOM by adding a <style> tag

// load the styles
var content = __webpack_require__(23);
if(typeof content === 'string') content = [[module.i, content, '']];
// add the styles to the DOM
var update = __webpack_require__(25)(content, {});
if(content.locals) module.exports = content.locals;
// Hot Module Replacement
if(false) {
	// When the styles change, update the <style> tags
	if(!content.locals) {
		module.hot.accept("!!../../node_modules/css-loader/index.js??ref--0-2!../../node_modules/clean-css-loader/index.js!../../node_modules/postcss-loader/lib/index.js??ref--0-4!../../node_modules/less-loader/dist/cjs.js??ref--0-5!./bundle.less", function() {
			var newContent = require("!!../../node_modules/css-loader/index.js??ref--0-2!../../node_modules/clean-css-loader/index.js!../../node_modules/postcss-loader/lib/index.js??ref--0-4!../../node_modules/less-loader/dist/cjs.js??ref--0-5!./bundle.less");
			if(typeof newContent === 'string') newContent = [[module.id, newContent, '']];
			update(newContent);
		});
	}
	// When the module is disposed, remove the <style> tags
	module.hot.dispose(function() { update(); });
}

/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(24)();
// imports


// module
exports.push([module.i, "/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n *//*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n *//*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit,.jodit *,.jodit_container,.jodit_container *{box-sizing:border-box}.jodit .jodit_workplace,.jodit_container .jodit_workplace{position:relative;overflow:auto}.jodit .jodit_workplace .jodit_wysiwyg,.jodit .jodit_workplace .jodit_wysiwyg_iframe,.jodit_container .jodit_workplace .jodit_wysiwyg,.jodit_container .jodit_workplace .jodit_wysiwyg_iframe{height:100%;width:100%}.jodit_container:not(.jodit_inline){background:#fff;font-size:14px;font-family:Helvetica,sans-serif}.jodit_container:not(.jodit_inline) .jodit_workplace{border:1px solid #ccc}.jodit_disabled{-webkit-user-select:none!important;-moz-user-select:none!important;-ms-user-select:none!important;user-select:none!important}.jodit_hidden{display:none!important}.jodit_wysiwyg{outline:0}.jodit_wysiwyg::-moz-selection,.jodit_wysiwyg ::-moz-selection{background:#b5d6fd;color:#000}.jodit_wysiwyg::selection,.jodit_wysiwyg ::selection{background:#b5d6fd;color:#000}.jodit_container:not(.jodit_inline) .jodit_wysiwyg{margin:0;padding:10px;outline:0;overflow-x:auto;position:relative}.jodit_container:not(.jodit_inline) .jodit_wysiwyg img{position:relative;max-width:100%}.jodit_container:not(.jodit_inline) .jodit_wysiwyg p,.jodit_container:not(.jodit_inline) .jodit_wysiwyg pre{margin:0 0 10px}.jodit_container:not(.jodit_inline) .jodit_wysiwyg h1,.jodit_container:not(.jodit_inline) .jodit_wysiwyg h2,.jodit_container:not(.jodit_inline) .jodit_wysiwyg h3,.jodit_container:not(.jodit_inline) .jodit_wysiwyg h4,.jodit_container:not(.jodit_inline) .jodit_wysiwyg h5{margin-top:0}.jodit_container:not(.jodit_inline) .jodit_wysiwyg blockquote{border-left:2px solid #222;margin-left:0;padding-left:5px;color:#222}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_clearfix:after,.jodit_clearfix:before{content:\" \";display:table}.jodit_clearfix:after{clear:both}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_dark_theme.jodit_container{background-color:#575757}.jodit_dark_theme .jodit_workplace{border-color:rgba(87,87,87,.8)}.jodit_dark_theme .jodit_statusbar{background-color:rgba(95,92,92,.8);border-color:rgba(87,87,87,.8)}.jodit_dark_theme .jodit_statusbar,.jodit_dark_theme .jodit_statusbar .jodit_statusbar_item span{color:#d1cccc}.jodit_dark_theme .jodit_toolbar_popup,.jodit_dark_theme .jodit_toolbar_popup-inline,.jodit_dark_theme .jodit_toolbar_popup-inline:before,.jodit_dark_theme .jodit_toolbar_popup:before{background:#575757}.jodit_dark_theme .jodit_toolbar{background:#5f5c5c;border-color:rgba(87,87,87,.8)}.jodit_dark_theme .jodit_toolbar li.jodit_toolbar_btn>a{color:#d1cccc}.jodit_dark_theme .jodit_toolbar li.jodit_toolbar_btn>a:hover{background-color:#575757}.jodit_dark_theme .jodit_toolbar li.jodit_toolbar_btn.jodit_toolbar_btn-break{border-top-color:#686767}.jodit_dark_theme .jodit_toolbar li.jodit_toolbar_btn.jodit_toolbar_btn-separator{border-right-color:#686767}.jodit_dark_theme .jodit_toolbar li.jodit_toolbar_btn.active,.jodit_dark_theme .jodit_toolbar li.jodit_toolbar_btn.jodit_active,.jodit_dark_theme .jodit_toolbar li.jodit_toolbar_btn:active,.jodit_dark_theme .jodit_toolbar li.jodit_toolbar_btn:hover{background-color:#575757}.jodit_dark_theme .jodit_toolbar li.jodit_toolbar_btn.jodit_with_dropdownlist .jodit_with_dropdownlist-trigger{border-top-color:silver}.jodit_dark_theme .jodit_icon{fill:silver}.jodit_dark_theme .jodit_wysiwyg,.jodit_dark_theme .jodit_wysiwyg_iframe{background-color:#575757;color:#d1cccc}.jodit_dark_theme .jodit_wysiwyg [data-jodit-selected-cell],.jodit_dark_theme .jodit_wysiwyg_iframe [data-jodit-selected-cell]{border-color:#152f5f}.jodit_dark_theme .jodit_dropdownlist{background:#5f5c5c}.jodit_dark_theme .jodit_tabs .jodit_tabs_buttons>a{background-color:#686767;color:#d1cccc}.jodit_dark_theme .jodit_tabs .jodit_tabs_buttons>a:hover{background-color:hsla(0,0%,41%,.8);color:#d1cccc;border-color:hsla(0,0%,41%,.9)}.jodit_dark_theme .jodit_tabs .jodit_tabs_buttons>a.active{background:rgba(81,81,81,.41);border-color:#686767}.jodit_dark_theme .jodit_tabs .jodit_tabs_buttons>a svg{fill:silver}.jodit_dark_theme .jodit_form input[type=text],.jodit_dark_theme .jodit_form input[type=url],.jodit_dark_theme .jodit_form textarea{background-color:rgba(81,81,81,.41);border-color:#686767;color:#d1cccc}.jodit_dark_theme .jodit_form button{background-color:hsla(0,0%,41%,.75);color:#d1cccc}.jodit_dark_theme .jodit_placeholder{color:hsla(0,5%,81%,.8)}.jodit_dark_theme .jodit_draganddrop_file_box,.jodit_dark_theme .jodit_uploadfile_button{color:#d1cccc}.jodit_dark_theme .jodit_draganddrop_file_box:hover,.jodit_dark_theme .jodit_uploadfile_button:hover{background-color:hsla(0,0%,41%,.75)}.jodit_dark_theme .jodit-add-new-line:before{border-top-color:#686767}.jodit_dark_theme .jodit-add-new-line span{background:hsla(0,0%,41%,.75);border-color:#686767}.jodit_dark_theme .jodit-add-new-line span svg{fill:#d1cccc}.jodit_dark_theme .jodit_resizer>i{background:hsla(0,0%,41%,.75);border-color:silver}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_btn{border:1px solid;border-radius:0;background-color:#f5f5f5;background-image:linear-gradient(180deg,#fff,#e6e6e6);border-color:#ccc;text-shadow:0 1px 1px hsla(0,0%,100%,.75);color:#333;background-repeat:repeat-x;outline:0;display:inline-block;padding:6px 12px;margin-bottom:0;font-size:14px;font-weight:400;line-height:1.42857143;text-align:center;white-space:nowrap;vertical-align:middle;-ms-touch-action:manipulation;touch-action:manipulation;cursor:pointer;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.jodit_btn:hover{background-color:#e6e6e6;background-position:0 -15px;text-decoration:none}.jodit_btn.jodit_btn_success{text-shadow:0 -1px 0 rgba(0,0,0,.25);background-color:#5bb75b;background-image:linear-gradient(180deg,#62c462,#51a351);border-color:rgba(0,0,0,.1) rgba(0,0,0,.1) rgba(0,0,0,.25);color:#fff}.jodit_btn.jodit_btn_success svg{fill:#fff}.jodit_btn.jodit_btn_success:hover{background-color:#51a351}.jodit_btn.jodit_btn_danger{text-shadow:0 -1px 0 rgba(0,0,0,.25);background-color:#da4f49;background-image:linear-gradient(180deg,#ee5f5b,#bd362f);border-color:rgba(0,0,0,.1) rgba(0,0,0,.1) rgba(0,0,0,.25);color:#fff}.jodit_btn.jodit_btn_danger svg{fill:#fff}.jodit_btn.jodit_btn_danger:hover{background-color:#bd362f}.jodit_btn.jodit_btn_inverse{text-shadow:0 -1px 0 rgba(0,0,0,.25);background-color:#363636;background-image:linear-gradient(180deg,#444,#222);border-color:rgba(0,0,0,.1) rgba(0,0,0,.1) rgba(0,0,0,.25);color:#fff}.jodit_btn.jodit_btn_inverse svg{fill:#fff}.jodit_btn.jodit_btn_inverse:hover{background-color:#222}.jodit_btn.active,.jodit_btn:active{background-image:none;box-shadow:inset 0 2px 4px rgba(0,0,0,.15),0 1px 2px rgba(0,0,0,.05)}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_btn_group{font-size:0;vertical-align:middle}.jodit_btn_group input{display:none}.jodit_btn_group button{float:left}.jodit_btn_group button+button{margin-left:-1px}.jodit_btn_group button:first-child,.jodit_btn_group input:first-child+button{border-right:0;border-top-right-radius:0;border-bottom-right-radius:0}.jodit_btn_group button:last-child,.jodit_btn_group input:last-child+button{border-left:0;border-top-left-radius:0;border-bottom-left-radius:0}.jodit_btn_group:after{content:\"\";clear:both;float:none;display:table}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_context_menu{font-family:Helvetica,sans-serif;display:none;background:#fff;position:absolute;min-width:150px;box-shadow:0 0 5px 0 rgba(0,0,0,.24);z-index:2222224}.jodit_context_menu a{display:block;border-bottom:1px solid hsla(0,0%,80%,.24);text-decoration:none!important;color:#727272}.jodit_context_menu a svg{float:left;display:block;width:18px;height:28px;margin:0 4.5px;fill:#727272}.jodit_context_menu a span{margin-left:27px;display:block;padding:5px;border-left:1px solid hsla(0,0%,80%,.24);line-height:18px}.jodit_context_menu a:hover{background-color:#e3e3e3;color:#000}.jodit_context_menu a:hover .jodit_icon{fill:#000}.jodit_context_menu a:last-child{border:0}.jodit_context_menu-show{display:block}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_dialog_box{box-sizing:border-box;display:none;width:0;height:0;border:0;position:absolute;will-change:left,top,width,height}.jodit_dialog_box.jodit_dialog_box-moved{-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.jodit_dialog_box *{box-sizing:border-box}.jodit_dialog_box .jodit_elfinder,.jodit_dialog_box .jodit_elfinder *{box-sizing:initial}.jodit_dialog_box .jodit_dialog_overlay{position:fixed;top:0;left:0;width:100%;height:100%;z-index:2222222;text-align:center;white-space:nowrap;overflow:auto;display:none;background-color:rgba(0,0,0,.5)}.jodit_dialog_box.active,.jodit_dialog_box.jodit_modal .jodit_dialog_overlay{display:block}.jodit_dialog_box .jodit_dialog{z-index:2222223;display:inline-block;vertical-align:middle;white-space:normal;text-align:left;position:fixed;left:0;top:0;background-color:#fff;box-shadow:0 10px 20px rgba(0,0,0,.19),0 6px 6px rgba(0,0,0,.23);min-width:200px;min-height:100px}@media (max-width:480px){.jodit_dialog_box .jodit_dialog{max-width:100%;width:100%!important;height:100%!important;top:0!important;left:0!important}}.jodit_dialog_box .jodit_dialog .jodit_promt{max-width:300px;min-width:200px;padding:10px;word-break:break-all}.jodit_dialog_box .jodit_dialog .jodit_promt label{margin-bottom:5px;display:block}.jodit_dialog_box .jodit_dialog .jodit_promt input[type=text]{display:block;border:1px solid #ccc;background:#fff;width:100%;height:28px;line-height:16px;padding:3px 6px;outline:0}.jodit_dialog_box .jodit_dialog .jodit_alert{max-width:300px;min-width:200px;padding:10px;word-break:break-all}.jodit_dialog_box .jodit_dialog .jodit_button{padding:0;margin:0;border:0;display:inline-block;vertical-align:top;width:32px;height:48px;line-height:48px;text-align:center;cursor:pointer;text-decoration:none}.jodit_dialog_box .jodit_dialog .jodit_button:not(.disabled):hover{background-color:#ecebe9}.jodit_dialog_box .jodit_dialog .jodit_button.disabled{opacity:.7}.jodit_dialog_box .jodit_dialog .jodit_input{border:1px solid #ccc;padding:5px;background-color:#fff;outline:0;width:120px;margin-left:10px;font:13px Arial;height:28px;vertical-align:middle}.jodit_dialog_box .jodit_dialog select.jodit_input{width:75px}.jodit_dialog_box .jodit_dialog .jodit_button .jodit_icon,.jodit_dialog_box .jodit_dialog .jodit_button svg,.jodit_dialog_box .jodit_dialog .jodit_dialog_header .jodit_icon,.jodit_dialog_box .jodit_dialog .jodit_dialog_header svg{width:16px;height:16px;display:inline-block;vertical-align:middle}.jodit_dialog_box .jodit_dialog .jodit_dialog_header{text-align:left;color:#222;box-shadow:0 1px 3px rgba(0,0,0,.16),0 1px 2px rgba(0,0,0,.23);cursor:move;height:48px;overflow:hidden}.jodit_dialog_box .jodit_dialog .jodit_dialog_header .jodit_dialog_header-title{font-size:18px;padding:0;padding-left:20px;margin:0;font-weight:400;line-height:48px;display:inline-block;vertical-align:top}@media (max-width:480px){.jodit_dialog_box .jodit_dialog .jodit_dialog_header .jodit_dialog_header-title{padding-left:0}}.jodit_dialog_box .jodit_dialog .jodit_dialog_header button{margin-right:10px}.jodit_dialog_box .jodit_dialog .jodit_dialog_header .jodit_dialog_header-button{color:#222;font-size:24px;font-weight:700;display:inline-block;transition:background-color .2s ease 0s;width:48px;height:48px;vertical-align:top;line-height:48px;text-decoration:none;text-align:center;float:right}.jodit_dialog_box .jodit_dialog .jodit_dialog_header .jodit_dialog_header-button:hover{background-color:#ecebe9}.jodit_dialog_box .jodit_dialog .jodit_dialog_header .jodit_close svg{width:18px;height:18px;margin:15px 0;vertical-align:top}.jodit_dialog_box .jodit_dialog .jodit_dialog_content{height:calc(100% - 48px);overflow:auto}.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group{margin-bottom:10px;padding:0 10px}.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group:first-child{margin-top:10px}.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group label{display:inline-block;max-width:100%;margin-bottom:5px;font-weight:700}.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input.select,.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input[type=number],.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input[type=text],.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input[type=url],.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select.select,.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select[type=number],.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select[type=text],.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select[type=url]{display:block;height:34px;padding:6px 4px;font-size:14px;line-height:1.42857143;color:#555;background-color:#fff;background-image:none;border:1px solid #ccc;border-radius:0;box-shadow:inset 0 1px 1px rgba(0,0,0,.075);transition:border-color .15s ease-in-out,box-shadow .15s ease-in-out}.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input.select:focus,.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input[type=number]:focus,.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input[type=text]:focus,.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input[type=url]:focus,.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select.select:focus,.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select[type=number]:focus,.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select[type=text]:focus,.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select[type=url]:focus{border-color:#66afe9;outline:0;box-shadow:inset 0 1px 1px rgba(0,0,0,.075),0 0 8px rgba(102,175,233,.6)}.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input.select[disabled],.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input[type=number][disabled],.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input[type=text][disabled],.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input[type=url][disabled],.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select.select[disabled],.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select[type=number][disabled],.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select[type=text][disabled],.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select[type=url][disabled]{background-color:#f0f0f0;color:#ccc}.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input.select:not([class*=col-]),.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input[type=number]:not([class*=col-]),.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input[type=text]:not([class*=col-]),.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input[type=url]:not([class*=col-]),.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select.select:not([class*=col-]),.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select[type=number]:not([class*=col-]),.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select[type=text]:not([class*=col-]),.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select[type=url]:not([class*=col-]){width:100%}.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group .jodit_input_group{display:table;border-collapse:separate;width:100%}.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group .jodit_input_group>*{vertical-align:middle;display:table-cell;height:34px}.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group .jodit_input_group>input{float:left;margin:0!important}.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group .jodit_input_group>input:not([class*=col-]){width:100%}.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group .jodit_input_group-buttons{width:1%;font-size:0;white-space:nowrap;vertical-align:middle}.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group .jodit_input_group-buttons>a{text-align:center;display:inline-block;border:1px solid #ccc;margin-left:-1px;position:relative;height:34px;line-height:34px}.jodit_dialog_box .jodit_dialog .jodit_dialog_footer{padding:0 10px;padding-top:10px;text-align:center;height:48px;display:none}.jodit_dialog_box .jodit_dialog .jodit_dialog_footer .jodit_button{width:auto;margin-bottom:10px;height:32px;line-height:100%;padding:0 15px;background-color:#ccc;border:1px solid #ccc;color:#000;font-size:0}.jodit_dialog_box .jodit_dialog .jodit_dialog_footer .jodit_button:before{content:\"\";display:inline-block;vertical-align:middle;height:100%}.jodit_dialog_box .jodit_dialog .jodit_dialog_footer .jodit_button svg{display:inline-block;width:24px;height:24px;vertical-align:middle}.jodit_dialog_box .jodit_dialog .jodit_dialog_footer .jodit_button span{display:inline-block;vertical-align:middle;font-size:14px;margin-left:5px}.jodit_dialog_box .jodit_dialog .jodit_dialog_footer .jodit_button:focus{border:1px solid #8bade4;outline:1px solid #82b2e8}.jodit_dialog_box .jodit_dialog .jodit_dialog_footer .jodit_button:nth-child(n+2){margin-left:10px}.jodit_dialog_box .jodit_dialog.with_footer .jodit_dialog_content{height:calc(100% - 96px)}.jodit_dialog_box .jodit_dialog.with_footer .jodit_dialog_footer{display:block}.jodit_dialog_box .jodit_dialog .jodit_dialog_resizer{position:absolute;bottom:0;right:0;cursor:se-resize;width:7px;height:7px;display:inline-block;background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAcAAAAHCAYAAADEUlfTAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAADFJREFUeNpilJGRYcACIoB4ORMuCSCOZMIlga4TRQJZJ4YETCdWCSBmZMIlATIOIMAAEyAPt4RnNx0AAAAASUVORK5CYII=)}.jodit_dialog_box .jodit_dialog .jodit_dialog_resizer:hover{border-color:rgba(0,0,0,.6)}@media (max-width:480px){.jodit_dialog_box .jodit_dialog .jodit_dialog_resizer{display:none}}.jodit_dialog_box-fullsize .jodit_dialog{top:0!important;bottom:0!important;left:0!important;right:0!important;width:100%!important;height:100%!important}.jodit_dialog_box-fullsize .jodit_dialog .jodit_dialog_resizer{display:none}@media (max-width:768px){.jodit_dialog_header .jodit_input,.jodit_dialog_header_fullsize,.jodit_dialog_header_title{display:none!important}}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_toolbar_list>.jodit_toolbar{max-height:400px;overflow:auto;box-shadow:0 3px 6px rgba(0,0,0,.16),0 3px 6px rgba(0,0,0,.23);padding:0;margin:auto;text-align:left;position:absolute;box-sizing:border-box;transition:max-height .2s ease 0s;margin-top:0!important;list-style-type:none;font-size:16px;z-index:10000;left:0;top:100%}.jodit_toolbar_list>.jodit_toolbar,.jodit_toolbar_list>.jodit_toolbar .jodit_toolbar{background:#f9f9f9}.jodit_toolbar_list>.jodit_toolbar blockquote,.jodit_toolbar_list>.jodit_toolbar h1,.jodit_toolbar_list>.jodit_toolbar h2,.jodit_toolbar_list>.jodit_toolbar h3,.jodit_toolbar_list>.jodit_toolbar h4,.jodit_toolbar_list>.jodit_toolbar h5,.jodit_toolbar_list>.jodit_toolbar p,.jodit_toolbar_list>.jodit_toolbar pre{font-family:Helvetica,sans-serif;margin:0;padding:0;font-weight:400}.jodit_toolbar_list>.jodit_toolbar h5{font-size:.8em;line-height:1.4}.jodit_toolbar_list>.jodit_toolbar h3{font-size:1.31em;line-height:1.4}.jodit_toolbar_list>.jodit_toolbar h4,.jodit_toolbar_list>.jodit_toolbar p{font-size:1em;line-height:1.5em}.jodit_toolbar_list>.jodit_toolbar h2{font-size:1.74em;line-height:1.4}.jodit_toolbar_list>.jodit_toolbar h1{font-size:2.17em;line-height:1.4}.jodit_toolbar_list>.jodit_toolbar blockquote,.jodit_toolbar_list>.jodit_toolbar pre{font-family:monospace}.jodit_toolbar_list>.jodit_toolbar li.jodit_toolbar_btn{display:block;cursor:pointer;white-space:nowrap;color:inherit;text-decoration:none;width:100%;height:auto;box-sizing:border-box;text-align:left}.jodit_toolbar_list>.jodit_toolbar li.jodit_toolbar_btn>a{background-image:none;padding:7px 24px;cursor:pointer;line-height:100%;width:auto;height:auto;display:block}.jodit_toolbar_list>.jodit_toolbar li.jodit_toolbar_btn>a>span{display:inline-block}.jodit_toolbar_list>.jodit_toolbar li.jodit_toolbar_btn>a:hover{background-color:#f3f0f0}.jodit_toolbar_list>.jodit_toolbar li.jodit_toolbar_btn>a:after{display:none}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_filebrowser{font-family:Helvetica,sans-serif;font-size:0;height:100%}.jodit_filebrowser .jodit_filebrowser_loader{height:100%;width:100%;position:absolute;top:0;left:0}.jodit_filebrowser .jodit_filebrowser_loader i{position:absolute;top:50%;left:50%;margin-top:-64px;margin-left:-64px}.jodit_filebrowser .jodit_filebrowser_status{position:absolute;font-size:10px;padding:2px 3px;border-top:1px solid hsla(0,0%,50%,.4);left:31%;right:0;bottom:0;background-color:#4a4a4a;visibility:hidden;opacity:0;transition:opacity .3s linear;color:#b38888;word-break:break-all}.jodit_filebrowser .jodit_filebrowser_status.success{color:#c5c5c5}.jodit_filebrowser .jodit_filebrowser_status.active{visibility:visible;opacity:1}.jodit_filebrowser .jodit_filebrowser_files,.jodit_filebrowser .jodit_filebrowser_tree{display:none;vertical-align:top;height:100%;position:relative}.jodit_filebrowser .jodit_filebrowser_files.active,.jodit_filebrowser .jodit_filebrowser_tree.active{display:inline-block}.jodit_filebrowser .jodit_filebrowser_files::-webkit-scrollbar,.jodit_filebrowser .jodit_filebrowser_tree::-webkit-scrollbar{width:5px}.jodit_filebrowser .jodit_filebrowser_files::-webkit-scrollbar-track,.jodit_filebrowser .jodit_filebrowser_tree::-webkit-scrollbar-track{-webkit-box-shadow:inset 0 0 6px rgba(0,0,0,.3)}.jodit_filebrowser .jodit_filebrowser_files::-webkit-scrollbar-thumb,.jodit_filebrowser .jodit_filebrowser_tree::-webkit-scrollbar-thumb{background-color:#a9a9a9;outline:1px solid #708090}.jodit_filebrowser .jodit_filebrowser_tree.active{width:31%;background-color:#3f3f3f;overflow-y:auto}@media (max-width:480px){.jodit_filebrowser .jodit_filebrowser_tree.active{display:none}}.jodit_filebrowser .jodit_filebrowser_tree.active::-webkit-scrollbar{width:5px}.jodit_filebrowser .jodit_filebrowser_tree.active::-webkit-scrollbar-track{-webkit-box-shadow:inset 0 0 6px rgba(0,0,0,.3)}.jodit_filebrowser .jodit_filebrowser_tree.active::-webkit-scrollbar-thumb{background-color:hsla(0,0%,50%,.5);outline:1px solid #708090}.jodit_filebrowser .jodit_filebrowser_tree.active .jodit_filebrowser_source_title{-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;display:block;padding:10px;color:#969696;border-bottom:1px solid #484848;line-height:17px;min-height:38px;position:relative;word-break:break-all;background:#5a5a5a;font-size:16px}.jodit_filebrowser .jodit_filebrowser_tree.active a{display:block;padding:10px 20px;text-decoration:none;color:#b1b1b1;font-weight:600;transition:background-color .2s ease 0s;border-bottom:1px solid #474747;line-height:17px;min-height:38px;position:relative;word-break:break-all;font-size:16px}.jodit_filebrowser .jodit_filebrowser_tree.active a i.remove{height:16px;width:16px;line-height:17px;font-size:16px;position:absolute;right:5px;top:11px;opacity:0;padding-left:3px;display:inline-block}.jodit_filebrowser .jodit_filebrowser_tree.active a i.remove:hover{background:#696969}.jodit_filebrowser .jodit_filebrowser_tree.active a:hover{color:#222;background-color:#ecebe9}.jodit_filebrowser .jodit_filebrowser_tree.active a:hover i.remove{opacity:.6}.jodit_filebrowser .jodit_filebrowser_tree.active a.jodit_button{cursor:pointer;background:#696969;text-align:center;width:auto;height:38px;color:#333}.jodit_filebrowser .jodit_filebrowser_tree.active a.jodit_button svg{vertical-align:top}.jodit_filebrowser .jodit_filebrowser_tree.active a.jodit_button:not(.disabled):hover{background-color:#ecebe9}.jodit_filebrowser .jodit_filebrowser_tree.active a.jodit_button.disabled,.jodit_filebrowser .jodit_filebrowser_tree.active a.jodit_button:hover i{opacity:.7}.jodit_filebrowser .jodit_filebrowser_files.active{width:100%;overflow-y:auto;padding:10px}.jodit_filebrowser .jodit_filebrowser_files.active .jodit_filebrowser_source_title{-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;margin:-10px -10px 0;display:block;padding:10px;line-height:17px;min-height:38px;position:relative;word-break:break-all;background:#5a5a5a;font-size:16px;color:#969696}.jodit_filebrowser .jodit_filebrowser_files.active a+.jodit_filebrowser_source_title{margin-top:10px}.jodit_filebrowser .jodit_filebrowser_files.active a{vertical-align:top;display:inline-block;width:150px;height:150px;line-height:150px;text-align:center;border:1px solid #ccc;margin:5px 5px 10px;font-size:0;overflow:hidden;transition:border .1s linear,bottom .1s linear;box-sizing:content-box;position:relative}.jodit_filebrowser .jodit_filebrowser_files.active a img{max-width:100%;vertical-align:middle}.jodit_filebrowser .jodit_filebrowser_files.active a:hover{border-color:#433b5c}.jodit_filebrowser .jodit_filebrowser_files.active a.active{border-color:#1e88e5;background-color:#b5b5b5}.jodit_filebrowser .jodit_filebrowser_files.active a .jodit_filebrowser_files_item-info{position:absolute;right:0;left:0;bottom:0;white-space:normal;opacity:.85;overflow:visible;padding:.3em .6em;transition:opacity .4s ease;background-color:#e9e9e9;color:#333;text-shadow:#eee 0 1px 0;font-size:14px;line-height:16px;text-align:left}.jodit_filebrowser .jodit_filebrowser_files.active a .jodit_filebrowser_files_item-info>span{display:block;text-overflow:ellipsis;white-space:nowrap;overflow:hidden;font-size:.75em}.jodit_filebrowser .jodit_filebrowser_files.active a .jodit_filebrowser_files_item-info>span.jodit_filebrowser_files_item-info-filename{font-weight:700;font-size:.9em}.jodit_filebrowser .jodit_filebrowser_files.active a.active .jodit_filebrowser_files_item-info{background-color:#b5b5b5;color:#fff;text-shadow:none}.jodit_filebrowser .jodit_filebrowser_files.active a:hover .jodit_filebrowser_files_item-info{bottom:-100px}.jodit_filebrowser .jodit_filebrowser_files.active.jodit_filebrowser_files_view-list a{display:block;width:100%;height:26px;line-height:26px;margin:0;border-width:0 0 1px;text-align:left;white-space:nowrap}.jodit_filebrowser .jodit_filebrowser_files.active.jodit_filebrowser_files_view-list a img{min-width:16px;max-width:16px;vertical-align:middle;display:inline-block;margin-left:4px}.jodit_filebrowser .jodit_filebrowser_files.active.jodit_filebrowser_files_view-list a .jodit_filebrowser_files_item-info{padding:0;position:static;display:inline-block;width:calc(100% - 20px);margin-left:4px;background-color:transparent;height:100%;line-height:inherit;vertical-align:middle;font-size:0}.jodit_filebrowser .jodit_filebrowser_files.active.jodit_filebrowser_files_view-list a .jodit_filebrowser_files_item-info>span{display:inline-block;height:100%;font-size:12px}.jodit_filebrowser .jodit_filebrowser_files.active.jodit_filebrowser_files_view-list a .jodit_filebrowser_files_item-info>span.jodit_filebrowser_files_item-info-filename{width:50%}.jodit_filebrowser .jodit_filebrowser_files.active.jodit_filebrowser_files_view-list a .jodit_filebrowser_files_item-info>span.jodit_filebrowser_files_item-info-filechanged,.jodit_filebrowser .jodit_filebrowser_files.active.jodit_filebrowser_files_view-list a .jodit_filebrowser_files_item-info>span.jodit_filebrowser_files_item-info-filesize{width:25%}.jodit_filebrowser .jodit_filebrowser_files.active.jodit_filebrowser_files_view-list a:hover{background-color:#433b5c}.jodit_filebrowser .jodit_filebrowser_files.active.jodit_filebrowser_files_view-list a:hover .jodit_filebrowser_files_item-info{color:#fff;text-shadow:none}.jodit_filebrowser .jodit_filebrowser_files.active.jodit_filebrowser_files_view-list a:before{height:100%;content:\"\";vertical-align:middle;display:inline-block}.jodit_filebrowser .jodit_filebrowser_tree.active+.jodit_filebrowser_files.active{width:69%}@media (max-width:480px){.jodit_filebrowser .jodit_filebrowser_tree.active+.jodit_filebrowser_files.active{width:auto;display:block}}.jodit_filebrowser_preview{text-align:center;min-width:300px;max-width:900px;max-height:700px;position:relative}.jodit_filebrowser_preview .jodit_filebrowser_preview_navigation{position:absolute;top:0;height:100%;left:0}.jodit_filebrowser_preview .jodit_filebrowser_preview_navigation-next{left:auto;right:0}.jodit_filebrowser_preview .jodit_filebrowser_preview_navigation svg{width:45px;height:45px;position:relative;top:50%;margin-top:-22px;transition:fill .3s linear;fill:#9e9ba7}.jodit_filebrowser_preview .jodit_filebrowser_preview_navigation:hover svg{fill:#000}.jodit_filebrowser_preview img{max-width:100%;max-height:100%}.jodit_draghover{background-color:#ecebe9}.jodit_dialog_box .jodit_dialog .jodit_dialog_header .jodit_dialog_header-title .jodit_upload_button{position:relative;width:220px;border:0;padding:25px 0;margin:10px 0;overflow:hidden}.jodit_dialog_box .jodit_dialog .jodit_dialog_header .jodit_dialog_header-title .jodit_upload_button input{cursor:pointer;position:absolute;top:0;bottom:0;right:0;margin:0 -10px 0 0;padding:0;opacity:0;font-size:400px}.jodit_dialog_box .jodit_dialog .jodit_dialog_header .jodit_dialog_header-title .jodit_toolbar{background:0 0;display:block;height:100%;border:0}.jodit_dialog_box .jodit_dialog .jodit_dialog_header .jodit_dialog_header-title .jodit_toolbar>li.jodit_toolbar_btn{vertical-align:middle}.jodit_dialog_box .jodit_dialog .jodit_dialog_header .jodit_dialog_header-title .jodit_toolbar>li.jodit_toolbar_btn input,.jodit_dialog_box .jodit_dialog .jodit_dialog_header .jodit_dialog_header-title .jodit_toolbar>li.jodit_toolbar_btn select{margin:0 5px;padding-left:10px;width:auto}.jodit_dialog_box .jodit_dialog .jodit_dialog_header .jodit_dialog_header-title.jodit_filebrowser_title_box{padding-left:10px}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_grid{width:100%}.jodit_grid [class*=jodit_col-]{display:block;float:left}.jodit_grid .jodit_col-lg-5-5{width:100%}.jodit_grid .jodit_col-lg-4-5{width:80%}.jodit_grid .jodit_col-lg-3-5{width:60%}.jodit_grid .jodit_col-lg-2-5{width:40%}.jodit_grid .jodit_col-lg-1-5{width:20%}.jodit_grid .jodit_col-lg-4-4{width:100%}.jodit_grid .jodit_col-lg-3-4{width:75%}.jodit_grid .jodit_col-lg-2-4{width:50%}.jodit_grid .jodit_col-lg-1-4{width:25%}.jodit_grid:after,.jodit_grid:before{content:\" \";display:table}.jodit_grid:after{clear:both}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */@keyframes rotate{to{transform:rotate(1turn)}}.jodit_icon-loader{background:url(data:image/png;base64,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) no-repeat 50%;background-size:100% 100%;width:128px;height:128px;will-change:transform;animation:rotate 2s ease-out 0s infinite}.jodit_icon,.jodit_icon-loader{display:inline-block;vertical-align:middle}.jodit_icon{font-style:normal;width:14px;font-size:8px;fill:#222;transform-origin:0 0!important;overflow:visible}.jodit_text_icon{font-size:14px}.jodit_toolbar_size-small .jodit_icon{min-width:12px;height:12px;line-height:12px}.jodit_toolbar_size-large .jodit_icon{min-width:16px;height:16px;line-height:16px}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_image_editor{width:100%;height:100%;padding:10px;overflow:hidden}@media (max-width:768px){.jodit_image_editor{height:auto}}.jodit_image_editor>div,.jodit_image_editor>div>div{height:100%}@media (max-width:768px){.jodit_image_editor>div,.jodit_image_editor>div>div{height:auto;min-height:200px}}.jodit_image_editor *{box-sizing:border-box}.jodit_image_editor .jodit_image_editor_slider-title{text-shadow:#f3f3f3 0 1px 0;color:#333;border-bottom:1px solid hsla(0,0%,62%,.31);background-color:#f9f9f9;padding:.8em 1em;text-overflow:ellipsis;white-space:nowrap;cursor:pointer;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;font-weight:700;line-height:1em}.jodit_image_editor .jodit_image_editor_slider-title svg{margin-right:10px;width:16px;display:inline-block;vertical-align:middle}.jodit_image_editor .jodit_image_editor_slider-content{display:none}.jodit_image_editor .jodit_image_editor_slider.active .jodit_image_editor_slider-title{background-color:#5d5d5d;color:#fff;text-shadow:#000 0 1px 0}.jodit_image_editor .jodit_image_editor_slider.active .jodit_image_editor_slider-title svg{fill:#fff}.jodit_image_editor .jodit_image_editor_slider.active .jodit_image_editor_slider-content{display:block}.jodit_image_editor_area{background-color:#eee;background-image:linear-gradient(45deg,#ccc 25%,transparent 0,transparent 75%,#ccc 0,#ccc),linear-gradient(45deg,#ccc 25%,transparent 0,transparent 75%,#ccc 0,#ccc);background-size:30px 30px;background-position:0 0,15px 15px;height:100%;overflow:hidden;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;position:relative;display:none}.jodit_image_editor_area.active{display:block}.jodit_image_editor_area .jodit_image_editor_box{overflow:hidden;position:relative;z-index:1;pointer-events:none;height:100%}.jodit_image_editor_area .jodit_image_editor_box img{-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;max-width:100%;max-height:100%}.jodit_image_editor_area .jodit_image_editor_croper,.jodit_image_editor_area .jodit_image_editor_resizer{z-index:2;width:100px;height:100px;position:absolute;box-shadow:0 0 11px #000;border:1px solid #fff;background-repeat:no-repeat;top:10px;left:20px;pointer-events:none}.jodit_image_editor_area .jodit_image_editor_croper i.jodit_bottomright,.jodit_image_editor_area .jodit_image_editor_resizer i.jodit_bottomright{position:absolute;display:inline-block;border:1px solid #383838;z-index:4;background-color:#8c7878;cursor:se-resize;border-radius:10px;height:20px;width:20px;right:-10px;bottom:-10px;box-shadow:0 0 11px #000;pointer-events:all}.jodit_image_editor_area .jodit_image_editor_croper i.jodit_bottomright:active,.jodit_image_editor_area .jodit_image_editor_resizer i.jodit_bottomright:active{border:1px solid #ff0}.jodit_image_editor_area.jodit_image_editor_area_crop{height:100%;background:#eee;text-align:center;line-height:100%;position:relative}.jodit_image_editor_area.jodit_image_editor_area_crop:before{content:\"\";line-height:100%;vertical-align:middle;height:100%;display:inline-block}.jodit_image_editor_area.jodit_image_editor_area_crop .jodit_image_editor_box{height:100%;overflow:visible;display:inline-block;vertical-align:middle;pointer-events:all;font-size:0;text-align:left;line-height:100%}.jodit_image_editor_area.jodit_image_editor_area_crop .jodit_image_editor_box img{max-width:100%;max-height:100%}.jodit_image_editor_area.jodit_image_editor_area_crop .jodit_image_editor_box:before{content:\"\";line-height:100%;vertical-align:middle;height:100%;display:inline-block}.jodit_image_editor_area.jodit_image_editor_area_crop .jodit_image_editor_box:after{content:\"\";position:absolute;top:0;left:0;bottom:0;right:0;margin:auto;background:hsla(0,0%,100%,.3);z-index:1}.jodit_image_editor_area.jodit_image_editor_area_crop .jodit_image_editor_box .jodit_image_editor_croper{pointer-events:all;cursor:move}.jodit_image_editor_area.jodit_image_editor_area_crop .jodit_image_editor_box .jodit_image_editor_croper i.jodit_sizes{font-size:12px;white-space:pre;position:absolute;bottom:-30px;left:100%;text-align:center;color:#fff;text-shadow:none;background:rgba(0,0,0,.2);border-radius:.4em;padding:9px 6px;display:block}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_properties svg{font-style:normal;display:inline-block;width:14px;height:14px;line-height:14px;font-size:8px;overflow:hidden;vertical-align:middle;fill:#222;transform-origin:0 0!important}.jodit_properties #tabsbox{padding:10px}.jodit_properties #tabsbox .jodit_form_group{padding:0}.jodit_properties .jodit_properties_view_box{padding:10px}.jodit_properties .jodit_properties_view_box .jodit_properties_image_view{height:150px;text-align:center;line-height:1;vertical-align:middle;padding:0;background-color:#f6f6f6;margin:0;vertical-align:baseline;font-size:100%;margin-bottom:10px}.jodit_properties .jodit_properties_view_box .jodit_properties_image_view:before{content:\"\";display:inline-block;vertical-align:middle;height:100%}.jodit_properties .jodit_properties_view_box .jodit_properties_image_view img{max-width:100%;max-height:100%;vertical-align:middle}.jodit_properties .jodit_properties_view_box .jodit_properties_image_sizes.jodit_form_group{padding:0!important;margin:0!important}.jodit_properties .jodit_properties_view_box .jodit_properties_image_sizes.jodit_form_group a{display:inline-block;cursor:pointer}.jodit_properties .jodit_properties_view_box .jodit_properties_image_sizes.jodit_form_group input[type=number]{display:inline-block!important;width:calc(50% - 8px)!important}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_toolbar,.jodit_toolbar *{box-sizing:border-box}.jodit_toolbar{position:relative;left:0;top:0;margin:0!important;padding:0!important;list-style:none!important;font-size:0;background:#f9f9f9;box-shadow:0 4px 4px -2px rgba(0,0,0,.14);z-index:5;border:1px solid #ccc;border-bottom:0;min-height:16px!important}.jodit_toolbar+.jodit_toolbar_dummy{display:none}.jodit_toolbar.jodit_fly{position:absolute;left:0;right:0;z-index:30000;background:#fff}.jodit_toolbar.jodit_sticky{position:fixed;position:-webkit-sticky;position:sticky;z-index:3;top:0;left:auto}.jodit_toolbar.jodit_sticky+.jodit_toolbar_dummy{display:block}.jodit_toolbar .jodit_toolbar_btn>a{color:#000;text-decoration:none;display:block;background:no-repeat 50%}.jodit_toolbar>li.jodit_toolbar_btn{display:inline-block;vertical-align:top;margin:0!important;padding:0;list-style:none!important;outline:0;position:relative;text-align:center;cursor:pointer;transition:background-color .2s linear,opacity .1s linear}.jodit_toolbar>li.jodit_toolbar_btn.jodit_disabled{background-color:transparent!important;opacity:.3;cursor:default}.jodit_toolbar>li.jodit_toolbar_btn.jodit_disabled a{cursor:default}.jodit_toolbar>li.jodit_toolbar_btn.jodit_toolbar_btn-separator{border-left:0;border-right:1px solid #e6e6e6;padding:0;margin:2px 3px 0!important;cursor:default}.jodit_toolbar>li.jodit_toolbar_btn.jodit_toolbar_btn-break{display:block!important;width:auto;border-top:1px solid #e6e6e6;height:0;margin:0 3px!important}.jodit_toolbar>li.jodit_toolbar_btn .jodit_toolbar_btn>a,.jodit_toolbar>li.jodit_toolbar_btn>a{width:100%;height:100%;display:inline-block;outline:0;text-decoration:none}.jodit_toolbar>li.jodit_toolbar_btn .jodit_toolbar_btn>a:after,.jodit_toolbar>li.jodit_toolbar_btn>a:after{content:\"\";display:inline-block;height:100%;vertical-align:middle}.jodit_toolbar>li.jodit_toolbar_btn .jodit_toolbar_btn>a:active+.jodit_tooltip,.jodit_toolbar>li.jodit_toolbar_btn>a:active+.jodit_tooltip{visibility:hidden!important}.jodit_toolbar>li.jodit_toolbar_btn.jodit_disabled .jodit_tooltip{display:none!important}.jodit_toolbar>li.jodit_toolbar_btn>a{line-height:100%}.jodit_toolbar>li.jodit_toolbar_btn.jodit_dropdown_open .jodit_tooltip,.jodit_toolbar>li.jodit_toolbar_btn .jodit_popap_open,.jodit_toolbar>li.jodit_toolbar_btn.jodit_popup_open .jodit_tooltip{visibility:hidden!important}.jodit_toolbar>li.jodit_toolbar_btn:not(.jodit_toolbar-input):hover{background-color:#dde4ef;outline:0}.jodit_toolbar>li.jodit_toolbar_btn.jodit_active,.jodit_toolbar>li.jodit_toolbar_btn:not(.jodit_toolbar-input):active{background-color:hsla(0,0%,87%,.4);outline:0}.jodit_toolbar>li.jodit_toolbar_btn.jodit-btn-hidden{display:none!important}.jodit_toolbar>li.jodit_toolbar_btn.jodit_with_dropdownlist .jodit_with_dropdownlist-trigger{width:0;height:0;border-right:3px solid transparent;border-left:3px solid transparent;border-top:3px solid #4c4c4c;display:inline-block;vertical-align:middle;margin-left:3px}.jodit_toolbar>li.jodit_toolbar_btn.jodit_toolbar-input input,.jodit_toolbar>li.jodit_toolbar_btn.jodit_toolbar-input select{-webkit-appearance:none;-moz-appearance:none;appearance:none;height:100%;border-radius:0;outline:0;line-height:100%}.jodit_toolbar>li.jodit_toolbar_btn.jodit_toolbar-input select{padding-right:20px;background:url(data:image/svg+xml;base64,PHN2ZyBpZD0iTGF5ZXJfMSIgZGF0YS1uYW1lPSJMYXllciAxIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCA0Ljk1IDEwIj48ZGVmcz48c3R5bGU+LmNscy0xe2ZpbGw6I2ZmZjt9LmNscy0ye2ZpbGw6IzQ0NDt9PC9zdHlsZT48L2RlZnM+PHRpdGxlPmFycm93czwvdGl0bGU+PHJlY3QgY2xhc3M9ImNscy0xIiB3aWR0aD0iNC45NSIgaGVpZ2h0PSIxMCIvPjxwb2x5Z29uIGNsYXNzPSJjbHMtMiIgcG9pbnRzPSIxLjQxIDQuNjcgMi40OCAzLjE4IDMuNTQgNC42NyAxLjQxIDQuNjciLz48cG9seWdvbiBjbGFzcz0iY2xzLTIiIHBvaW50cz0iMy41NCA1LjMzIDIuNDggNi44MiAxLjQxIDUuMzMgMy41NCA1LjMzIi8+PC9zdmc+) no-repeat 98% 50%!important}.jodit_toolbar>li{min-width:32px;height:32px;line-height:32px}.jodit_toolbar>li.jodit_toolbar_btn-separator{height:28px;width:0;min-width:0}.jodit_tooltip{position:fixed;background:#727171;color:#fff;font-size:12px;line-height:15px;padding:4px 5px;font-family:Arial,sans-serif;z-index:10001;width:90px;transition:opacity .3s linear}@media (max-width:768px){.jodit_tooltip{display:none}}.jodit_toolbar_size-small .jodit_toolbar{min-height:12px!important}.jodit_toolbar_size-small .jodit_toolbar>li{min-width:24px;height:24px;line-height:24px}.jodit_toolbar_size-small .jodit_toolbar>li.jodit_toolbar_btn-separator{height:20px;width:0;min-width:0}.jodit_toolbar_size-large .jodit_toolbar{min-height:18px!important}.jodit_toolbar_size-large .jodit_toolbar>li{min-width:36px;height:36px;line-height:36px}.jodit_toolbar_size-large .jodit_toolbar>li.jodit_toolbar_btn-separator{height:32px;width:0;min-width:0}.jodit_toolbar_popup{position:absolute;z-index:10;top:100%;margin-top:10px;padding-top:0;left:0;font-size:14px;line-height:14px!important;background:#fff;box-shadow:0 2px 4px rgba(0,0,0,.2);border:1px solid rgba(0,0,0,.2)}.jodit_toolbar_popup .jodit_toolbar{box-shadow:none;border-width:0;background-color:transparent}.jodit_toolbar_popup .jodit_toolbar .jodit_toolbar{background-color:#f9f9f9;box-shadow:0 4px 4px -2px rgba(0,0,0,.14);border:1px solid #ccc}.jodit_toolbar_popup>*{margin:10px}.jodit_toolbar_popup .jodit_popup_triangle{padding:0;margin:0;width:8px;height:8px;position:absolute;top:-5px;left:9px;display:inline-block;transform:rotate(45deg);background:#fff;border:1px solid rgba(0,0,0,.2);border-width:1px 0 0 1px;z-index:6}.jodit_toolbar_popup.jodit_right{left:auto;right:0}.jodit_toolbar_popup.jodit_right:before{left:auto;right:14px}.jodit_toolbar .jodit_toolbar_btn>svg{max-width:50%;vertical-align:middle;font-smoothing:antialiased}.jodit_container>.jodit_toolbar>li:first-child{margin-left:2px!important}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_draganddrop_file_box,.jodit_uploadfile_button{position:relative;width:220px;border:1px dashed #ccc;padding:25px 0;margin:10px 0;text-align:center;overflow:hidden}.jodit_draganddrop_file_box:hover,.jodit_uploadfile_button:hover{background-color:#ecebe9}.jodit_draganddrop_file_box input,.jodit_uploadfile_button input{cursor:pointer;position:absolute;top:0;bottom:0;right:0;margin:0;padding:0;opacity:0;font-size:400px}@media (max-width:768px){.jodit_draganddrop_file_box{width:auto;max-width:100%;min-width:120px}}.jodit_statusbar{border:1px solid #ccc;border-top:0;font-size:0;background-color:#f9f9f9;padding:0 5px}.jodit_statusbar .jodit_statusbar_item{font-size:11px;float:left;line-height:1.57142857em;margin:0 10px 0 0;padding:0;vertical-align:middle}.jodit_statusbar .jodit_statusbar_item.jodit_statusbar_item-right{float:right;margin:0 0 0 10px}.jodit_statusbar .jodit_statusbar_item li,.jodit_statusbar .jodit_statusbar_item ul{margin:0;padding:0;list-style:none;display:inline-block;vertical-align:top;position:relative}.jodit_statusbar .jodit_statusbar_item li li,.jodit_statusbar .jodit_statusbar_item ul li{margin-right:5px}.jodit_statusbar .jodit_statusbar_item a,.jodit_statusbar .jodit_statusbar_item span{-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;display:inline-block;vertical-align:baseline;text-align:left;white-space:nowrap;padding:2px 3px;line-height:10px;outline:0;border:0;color:#222}.jodit_statusbar .jodit_statusbar_item a span,.jodit_statusbar .jodit_statusbar_item span span{padding:0}.jodit_statusbar .jodit_statusbar_item svg{width:11px;height:11px;display:inline-block;vertical-align:top}.jodit_statusbar .jodit_statusbar_item a{text-decoration:none;cursor:default;border-radius:3px}.jodit_statusbar .jodit_statusbar_item a:hover{background-color:hsla(0,0%,88%,.99);text-decoration:none;color:#222}.jodit_statusbar:after{content:\" \";display:block;visibility:hidden;font-size:0;height:0;float:none;clear:both}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_form{color:#000}.jodit_form input[type=text],.jodit_form input[type=url],.jodit_form textarea{-webkit-appearance:none;-moz-appearance:none;display:block;outline:0;border:1px solid #b5b5b5;height:28px;line-height:28px;padding:0 5px;min-width:220px;margin-top:10px}.jodit_form input[type=text].jodit_error,.jodit_form input[type=url].jodit_error,.jodit_form textarea.jodit_error{border-color:#f7d1d1;box-shadow:inset 0 0 3px 0 hsla(0,0%,74%,.3)}@media (max-width:768px){.jodit_form input[type=text],.jodit_form input[type=url],.jodit_form textarea{min-width:150px}}.jodit_form textarea{height:128px}.jodit_form button{height:36px;line-height:1;color:#000;padding:10px;cursor:pointer;text-decoration:none;border:none;background:#d6d6d6;font-size:16px;outline:0;transition:background .2s ease 0s;margin-top:10px;margin-bottom:10px}.jodit_form button:hover{background-color:#ecebe9;color:#000}.jodit_form button:active{background:#ecebe9;color:#000}.jodit_form input[type=checkbox]{display:inline-block;z-index:2;border:0 none;cursor:pointer;height:16px;margin:0;padding:0;width:16px;position:relative;outline:0;top:3px}.jodit_form input[type=checkbox]:after{content:\"\";background:#fff;border:1px solid hsla(0,0%,88%,.99);border-radius:2px;background-clip:padding-box;width:16px;height:16px;display:inline-block;position:relative;z-index:1;box-sizing:border-box;transition:background .2s ease 0s,border-color .2s ease 0s}.jodit_form input[type=checkbox]:checked:after{background:url(\"data:image/svg+xml;charset=utf-8,%3Csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 32 32'%3E%3Cpath d='M27 4L12 19l-7-7-5 5 12 12L32 9z' fill='%23FFF'/%3E%3C/svg%3E\") no-repeat 50%;background-color:#b5b5b5;border-color:#b5b5b5}.jodit_form label{margin-top:10px;display:block;text-align:left}.jodit_form form:after{content:\"\";display:table;clear:both}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_about{padding:20px}.jodit_about a{color:#459ce7;text-decoration:none}.jodit_about a:focus,.jodit_about a:hover{color:#23527c;text-decoration:underline;outline:0}.jodit_about div{margin-bottom:5px}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_colorpicker{min-width:180px;text-align:left;margin:0;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.jodit_colorpicker .jodit_colorpicker_group{margin-bottom:5px;white-space:normal}.jodit_colorpicker a{width:18px;height:18px;line-height:16px;display:inline-block;text-decoration:none;vertical-align:middle;text-align:center}.jodit_colorpicker a.jodit_text_icon{width:auto;text-decoration:none;color:#000}.jodit_colorpicker a:before{content:\"\";display:inline-block;height:100%;vertical-align:middle;width:0}.jodit_colorpicker a svg{display:inline-block;vertical-align:middle;font-smoothing:antialiased;max-width:14px}.jodit_colorpicker a:hover{border-color:#000}.jodit_colorpicker a:active{background:#d6d6d6;color:#b5b5b5}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */@keyframes pulse{30%{opacity:.6}60%{opacity:0}to{opacity:.6}}.jodit_progress_bar{position:absolute;top:0;left:0;height:2px;z-index:2147483647;border-radius:1px;display:none}.jodit_progress_bar div{position:relative;background:#b91f1f;height:2px;transition:width .5s ease-out,opacity .5s linear;will-change:width,opacity}.jodit_progress_bar div:after,.jodit_progress_bar div:before{animation:pulse 2s ease-out 0s infinite;content:\"\";display:inline-block;position:absolute;top:0;height:2px;box-shadow:1px 0 6px 1px #b91f1f;border-radius:100%;opacity:.6}.jodit_progress_bar div:before{width:180px;right:-80px;clip:rect(-6px,90px,14px,-6px)}.jodit_progress_bar div:after{width:20px;right:0;clip:rect(-6px,22px,14px,10px)}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_tabs .jodit_tabs_buttons{line-height:18px;margin-bottom:5px;margin-top:4px}.jodit_tabs .jodit_tabs_buttons>a{display:inline-block;text-decoration:none;font-size:11px;font-weight:700;text-align:center;white-space:nowrap;height:29px;line-height:27px;position:relative;vertical-align:middle;transition:background .1s linear;text-overflow:ellipsis;overflow:hidden;box-shadow:none;background-color:#f5f5f5;color:#737373;border:1px solid rgba(0,0,0,.1);outline:0}@media (max-width:768px){.jodit_tabs .jodit_tabs_buttons>a{width:100%!important;border-radius:0!important}}.jodit_tabs .jodit_tabs_buttons>a+a{margin-left:-1px}.jodit_tabs .jodit_tabs_buttons>a i,.jodit_tabs .jodit_tabs_buttons>a svg{width:16px;height:16px;display:inline-block;vertical-align:sub;margin-right:5px;fill:#737373}.jodit_tabs .jodit_tabs_buttons>a:hover{border:1px solid #c6c6c6;color:#111;box-shadow:none;background-color:#f8f8f8;outline:0}.jodit_tabs .jodit_tabs_buttons>a:hover i,.jodit_tabs .jodit_tabs_buttons>a:hover svg{fill:#111}.jodit_tabs .jodit_tabs_buttons>a.active,.jodit_tabs .jodit_tabs_buttons>a:active{outline:0;background:#fff;border:1px solid #ccc;color:#333}.jodit_tabs .jodit_tabs_buttons>a.active i,.jodit_tabs .jodit_tabs_buttons>a.active svg,.jodit_tabs .jodit_tabs_buttons>a:active i,.jodit_tabs .jodit_tabs_buttons>a:active svg{fill:#333}.jodit_tabs .jodit_tabs_wrapper .jodit_tab{display:none}.jodit_tabs .jodit_tabs_wrapper .jodit_tab.active{display:block}.jodit_tabs .jodit_tabs_wrapper .jodit_tab .jodit_tab_empty{min-width:220px;min-height:100px}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit-add-new-line{z-index:1;position:absolute;height:20px;line-height:100%;vertical-align:middle;font-size:0;top:0;outline:0;margin-top:-10px;display:none}.jodit-add-new-line,.jodit-add-new-line *{box-sizing:border-box}.jodit-add-new-line:before{height:100%}.jodit-add-new-line:after,.jodit-add-new-line:before{display:inline-block;vertical-align:middle;content:\"\"}.jodit-add-new-line:after{box-sizing:border-box;border-top:1px solid #ccc;height:1px;width:calc(100% - 30px)}.jodit-add-new-line span{right:0;position:absolute;display:inline-block;width:30px;height:20px;background:hsla(40,7%,92%,.3);vertical-align:top;border:1px solid #ccc;padding:0 5px;cursor:pointer}.jodit-add-new-line span:hover{background:#ecebe9}.jodit-add-new-line svg{width:16px;fill:#ccc;vertical-align:top}.jodit_source_mode .jodit-add-new-line{display:none!important}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_error_box_for_messages{position:absolute;right:0;bottom:0;width:0;height:0;overflow:visible;z-index:3}.jodit_error_box_for_messages>*{position:absolute;right:5px;bottom:0;display:block;transition:opacity .1s linear,bottom .3s linear;opacity:0;background:rgba(255,0,0,.29);color:#e02b2b;padding:2px 7px;border:1px solid hsla(0,65%,67%,.44);font-size:14px;white-space:pre}.jodit_error_box_for_messages>.active{opacity:1}.jodit_error_box_for_messages>.info{background:rgba(204,229,247,.71);color:#776565;border:1px solid hsla(0,0%,60%,.44)}.jodit_error_box_for_messages>.success{background:rgba(77,236,112,.29);color:#5d5a5a;border:1px solid hsla(0,0%,58%,.44)}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_fullsize_box{z-index:100000!important;position:static!important;overflow:visible!important}body.jodit_fullsize_box,html.jodit_fullsize_box{height:0!important;width:0!important;overflow:initial!important}html.jodit_fullsize_box{position:fixed!important}.jodit_fullsize{position:absolute;top:0;left:0;right:0;bottom:0;z-index:100000;max-width:none!important}.jodit_fullsize .toolbar{width:100%!important}.jodit_fullsize .jodit_area,.jodit_fullsize .jodit_editor{height:100%}.jodit_fullsize .jodit_workflow{height:calc(100% - 24px);overflow:auto}.jodit_fullsize.jodit_toolbar_size-small .jodit_workflow{height:calc(100% - 18px)}.jodit_fullsize.jodit_toolbar_size-large .jodit_workflow{height:calc(100% - 27px)}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_placeholder{-webkit-user-select:none!important;-moz-user-select:none!important;-ms-user-select:none!important;user-select:none!important;top:0;left:0;display:block;position:absolute;padding:10px;color:rgba(0,0,0,.35);z-index:1;pointer-events:none}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_toolbar_popup-inline-target{position:absolute;width:0;height:0}.jodit_toolbar_popup-inline-target.jodit_toolbar_popup-inline-target-hidden{display:none}.jodit_toolbar_popup-inline{display:inline-block!important;position:relative!important}.jodit_toolbar_popup-inline>div{color:hsla(0,0%,88%,.99);background:#fff;box-shadow:none;background-clip:padding-box;font-family:Helvetica,sans-serif;box-sizing:border-box;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;z-index:100001!important;text-align:left;border:1px solid hsla(0,0%,88%,.99);display:inline-block;vertical-align:top}.jodit_toolbar_popup-inline .jodit_toolbar{z-index:7;border:0;white-space:normal}.jodit_toolbar_popup-inline>div>.jodit_toolbar{white-space:nowrap;box-shadow:none;vertical-align:top}.jodit_toolbar_popup-inline>.jodit_popup_triangle{padding:0;margin:0;width:8px;height:8px;position:absolute;top:-4px;margin-left:-4px;display:inline-block;transform:rotate(45deg);background:#fff;border:1px solid hsla(0,0%,88%,.99);border-width:1px 0 0 1px;z-index:6}.jodit_toolbar_popup-inline.jodit_toolbar_popup-inline-top>.jodit_popup_triangle{top:auto;bottom:-4px;border-width:0 1px 1px 0}.jodit_toolbar_popup-inline .buttons{box-shadow:0 1px 3px rgba(0,0,0,.12),0 1px 2px rgba(0,0,0,.24);padding:0 2px;white-space:nowrap;line-height:0;border-bottom:0}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */[data-jodit_iframe_wrapper]{display:block;clear:both;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;position:relative}[data-jodit_iframe_wrapper]:after{position:absolute;content:\"\";z-index:1;top:0;left:0;right:0;bottom:0;cursor:pointer;display:block;background:transparent}.jodit_resizer{width:100px;height:100px;position:absolute;border:1px solid rgba(3,14,82,.92);top:0;left:0;display:none;pointer-events:none;font-size:0}.jodit_resizer *{box-sizing:border-box}.jodit_resizer>span{opacity:0;transition:opacity .2s linear;left:50%;top:50%;height:24px;line-height:24px;font-size:12px;width:70px;margin-left:-35px;margin-top:-12px;text-align:center;overflow:visible;color:#fff;background-color:rgba(0,0,0,.35);max-width:100%}.jodit_resizer>i,.jodit_resizer>span{position:absolute;display:inline-block}.jodit_resizer>i{z-index:4;pointer-events:all;border:1px solid rgba(3,14,82,.92);background-color:hsla(0,0%,88%,.99);width:10px;height:10px}.jodit_resizer>i:hover{background-color:#f8f8f8}.jodit_resizer>i:first-child{left:-5px;top:-5px;cursor:nw-resize}.jodit_resizer>i:nth-child(2){right:-5px;top:-5px;cursor:ne-resize}.jodit_resizer>i:nth-child(3){right:-5px;bottom:-5px;cursor:se-resize}.jodit_resizer>i:nth-child(4){left:-5px;bottom:-5px;cursor:sw-resize}@media (max-width:768px){.jodit_resizer>i{width:20px;height:20px}.jodit_resizer>i:first-child{left:-10px;top:-10px;cursor:nw-resize}.jodit_resizer>i:nth-child(2){right:-10px;top:-10px;cursor:ne-resize}.jodit_resizer>i:nth-child(3){right:-10px;bottom:-10px;cursor:se-resize}.jodit_resizer>i:nth-child(4){left:-10px;bottom:-10px;cursor:sw-resize}}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_container{min-height:100px}.jodit_container .jodit_workplace{display:-ms-flexbox;display:flex;height:auto;min-height:50px;overflow:hidden}.jodit_editor_resize{position:relative}.jodit_editor_resize a{position:absolute;bottom:0;right:0;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;width:0;height:0;overflow:hidden;border-width:7px 7px 0 0;border-color:transparent #ccc transparent transparent;border-style:dashed solid dashed dashed;cursor:se-resize}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_source{display:none;position:relative;background-color:#f8f8f8;font-size:0;-ms-flex:1;flex:1;overflow:auto}.jodit_source,.jodit_source .jodit_source_mirror-fake{min-height:100%}.jodit_container.jodit_source_mode .jodit_wysiwyg,.jodit_container.jodit_source_mode .jodit_wysiwyg_iframe{display:none!important}.jodit_container.jodit_source_mode .jodit_source{display:block!important}.jodit_container.jodit_split_mode .jodit_source,.jodit_container.jodit_split_mode .jodit_wysiwyg,.jodit_container.jodit_split_mode .jodit_wysiwyg_iframe{display:block!important;width:50%;-ms-flex:1;flex:1}.jodit_source_mirror{border:0;width:100%;background:#3f3f3f;margin:0;height:100%;box-shadow:none;resize:none;box-sizing:border-box;color:#f0f0f0;outline:0;font-family:Menlo,Monaco,monospace,sans-serif;font-size:13px;line-height:1.3em;z-index:2;padding:10px;overflow:auto;white-space:pre-wrap;-moz-tab-size:2em;-o-tab-size:2em;tab-size:2em;min-height:100%}.jodit_source_mirror::-moz-selection{background:#bdbdbd}.jodit_source_mirror::selection{background:#bdbdbd}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_table_resizer{cursor:col-resize;position:absolute;z-index:3;padding-left:5px;padding-right:5px;margin-left:-5px}.jodit_table_resizer:after{content:\"\";display:block;height:100%;width:0;border:1px solid transparent;border-width:0 1px 0 0}.jodit_table_resizer-moved{z-index:2}.jodit_table_resizer-moved:after{border-color:#1e88e5}.jodit_wysiwyg table{width:100%;border:none;border-collapse:collapse;table-layout:fixed;empty-cells:show;max-width:100%}.jodit_wysiwyg table tr{-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.jodit_wysiwyg table tr td,.jodit_wysiwyg table tr th{border:1px solid #ddd;text-align:left;vertical-align:middle;-webkit-user-select:text;-moz-user-select:text;-ms-user-select:text;user-select:text}.jodit_wysiwyg table tr td[data-jodit-selected-cell],.jodit_wysiwyg table tr th[data-jodit-selected-cell]{border:1px double #1e88e5}.jodit_form_inserter .jodit_form-table-creator-box{font-size:0}.jodit_form_inserter .jodit_form-table-creator-box .jodit_form-container{display:inline-block;vertical-align:top;padding:0;margin:0;min-width:180px;font-size:0}.jodit_form_inserter .jodit_form-table-creator-box .jodit_form-container>div{width:18px;height:18px;box-sizing:border-box;display:inline-block;position:relative;vertical-align:top}.jodit_form_inserter .jodit_form-table-creator-box .jodit_form-container>div:after{content:\"\";position:absolute;top:0;left:0;display:inline-block;width:12px;height:12px;border:1px solid #ccc}.jodit_form_inserter .jodit_form-table-creator-box .jodit_form-container>div.hovered:after{background:#7a450f;border:1px solid #b5b5b5}.jodit_form_inserter .jodit_form-table-creator-box .jodit_form-options{font-size:14px;display:inline-block;vertical-align:top}.jodit_form_inserter .jodit_form-table-creator-box .jodit_form-options label{text-align:left;padding-top:0}.jodit_form_inserter .jodit_form-table-creator-box .jodit_form-options label input{margin-right:10px}.jodit_form_inserter label{text-align:center;font-size:14px;padding:8px;display:block;margin:0}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_text_icons .jodit_icon{width:auto;font-size:14px}.jodit_text_icons .jodit_icon:first-letter{text-transform:uppercase}.jodit_text_icons .jodit_tabs .jodit_tabs_buttons>a{font-family:Helvetica,sans-serif;width:auto}.jodit_text_icons .jodit_tabs .jodit_tabs_buttons>a i,.jodit_text_icons .jodit_toolbar>li{width:auto}.jodit_text_icons .jodit_toolbar>li>a{text-decoration:none}.jodit_text_icons.jodit_dialog_box .jodit_dialog .jodit_button,.jodit_text_icons.jodit_dialog_box .jodit_dialog .jodit_dialog_header a,.jodit_text_icons .jodit_toolbar>li>a{padding:0 12px;font-family:Helvetica,sans-serif;width:auto;color:rgba(0,0,0,.75)}.jodit_text_icons.jodit_dialog_box .jodit_dialog .jodit_button .jodit_icon,.jodit_text_icons.jodit_dialog_box .jodit_dialog .jodit_dialog_header a .jodit_icon{width:auto}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_widget,.jodit_widget *{box-sizing:border-box}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_search{visibility:hidden;position:absolute;top:0;right:0;width:0;height:0}.jodit_search.jodit_search-active{visibility:visible}.jodit_search .jodit_search_box{width:320px;position:absolute;right:0;background-color:#f9f9f9;border:1px solid #ccc;border-width:0 0 1px 1px;padding:5px}.jodit_search .jodit_search_box input{margin:0;width:100%;height:100%;border:0;background-color:transparent;outline:0;padding:0 10px}.jodit_search .jodit_search_box input.jodit_search-replace{display:none}.jodit_search .jodit_search_box .jodit_search_buttons,.jodit_search .jodit_search_box .jodit_search_counts,.jodit_search .jodit_search_box .jodit_search_inputs{height:30px;display:inline-block;vertical-align:top}.jodit_search .jodit_search_box .jodit_search_inputs{width:60%;padding-right:5px}.jodit_search .jodit_search_box .jodit_search_counts{width:15%;line-height:100%;text-align:center;color:#ccc;border-left:1px solid #ccc}.jodit_search .jodit_search_box .jodit_search_counts:before{content:\"\";display:inline-block;vertical-align:middle;height:100%}.jodit_search .jodit_search_box .jodit_search_counts span{display:inline-block;vertical-align:middle}.jodit_search .jodit_search_box .jodit_search_buttons{padding-left:0;width:25%}.jodit_search .jodit_search_box .jodit_search_buttons button{outline:0;width:32%;padding:1px 5px;margin-right:1%;transition:transform .1s linear;height:100%;border:1px solid transparent;background-color:transparent}.jodit_search .jodit_search_box .jodit_search_buttons button.jodit_search_buttons-replace{width:100%;border:1px solid #ccc;margin-top:2px;display:none}.jodit_search .jodit_search_box .jodit_search_buttons button:hover{background-color:#ecebe9}.jodit_search .jodit_search_box .jodit_search_buttons button:focus{border:1px solid rgba(181,214,253,.5)}.jodit_search .jodit_search_box .jodit_search_buttons button:active{border:1px solid #b5d6fd;transform:scale(.95)}.jodit_search.jodit_search-and-replace .jodit_search_counts,.jodit_search.jodit_search-and-replace .jodit_search_inputs{height:60px}.jodit_search.jodit_search-and-replace .jodit_search_counts input,.jodit_search.jodit_search-and-replace .jodit_search_inputs input{height:50%;transition:background-color .1s linear}.jodit_search.jodit_search-and-replace .jodit_search_counts input:focus,.jodit_search.jodit_search-and-replace .jodit_search_inputs input:focus{box-shadow:inset 0 0 3px 0 hsla(0,0%,80%,.58)}.jodit_search.jodit_search-and-replace .jodit_search_buttons button.jodit_search_buttons-replace,.jodit_search.jodit_search-and-replace .jodit_search_inputs input.jodit_search-replace{display:block}@media (max-width:320px){.jodit_search,.jodit_search .jodit_search_box{width:100%}}.jodit_symbols{width:460px;padding:10px}.jodit_symbols .jodit_symbols-container_preview,.jodit_symbols .jodit_symbols-container_table{display:inline-block;vertical-align:top}.jodit_symbols .jodit_symbols-container_table{width:88%}.jodit_symbols .jodit_symbols-container_preview{width:12%}.jodit_symbols .jodit_symbols-container_preview .jodit_symbols-preview{font-size:34px;text-align:center;padding:20px 0;border:1px solid #ccc}.jodit_symbols table{border:0;border-spacing:0;table-layout:fixed}.jodit_symbols table td{padding:0}.jodit_symbols table td a{font-size:16px;text-decoration:none;color:#000;display:inline-block;box-sizing:border-box;width:21.6px;height:21.6px;border:1px solid transparent;text-align:center;line-height:21.6px;vertical-align:top}.jodit_symbols table td a:focus,.jodit_symbols table td a:hover{border:1px solid #1e88e5}.jodit_sticky-dummy_toolbar{display:none}.jodit_sticky>.jodit_toolbar{position:fixed;z-index:3;top:0;left:auto}.jodit_sticky .jodit_sticky-dummy_toolbar{display:block}.jodit_paste_storage{padding:10px;max-width:600px}@media (max-width:768px){.jodit_paste_storage{max-width:100%}}.jodit_paste_storage>div{max-width:100%;max-height:300px;border:1px solid #ccc}.jodit_paste_storage>div:first-child{margin-bottom:10px}.jodit_paste_storage>div:first-child a{outline:0;box-sizing:border-box;display:block;max-width:100%;white-space:pre;overflow:hidden;text-overflow:ellipsis;padding:5px;margin:0;border:1px solid transparent;text-decoration:none;color:#000}.jodit_paste_storage>div:first-child a.jodit_active{color:#fff;background-color:#575757}.jodit_paste_storage>div:first-child a:focus{outline:0}.jodit_paste_storage>div:last-child{padding:10px;overflow:auto}.jodit_paste_storage>div:last-child li,.jodit_paste_storage>div:last-child ul{margin:0}", "", {"version":3,"sources":["D:/jodit-3.1.95/src/styles/bundle.less"],"names":[],"mappings":"AAAA;;;;GAIG;;;;GAIA;;;;GAIA,oDAAoD,qBAAqB,CAAC,0DAA0D,kBAAkB,aAAa,CAAC,8LAA8L,YAAY,UAAU,CAAC,oCAAoC,gBAAgB,eAAe,gCAAsC,CAAC,qDAAqD,qBAAqB,CAAC,gBAAgB,mCAAmC,gCAAgC,+BAA+B,0BAA0B,CAAC,cAAc,sBAAsB,CAAC,eAAe,SAAS,CAAC,+DAA+D,mBAAmB,UAAU,CAAC,qDAAqD,mBAAmB,UAAU,CAAC,mDAAmD,SAAS,aAAa,UAAU,gBAAgB,iBAAiB,CAAC,uDAAuD,kBAAkB,cAAc,CAAC,4GAA4G,eAAe,CAAC,8QAA8Q,YAAY,CAAC,8DAA8D,2BAA2B,cAAc,iBAAiB,UAAU,CAAC;;;;GAIhpD,6CAA6C,YAAY,aAAa,CAAC,sBAAsB,UAAU,CAAC;;;;GAIxG,kCAAkC,wBAAwB,CAAC,mCAAmC,8BAA8B,CAAC,mCAAmC,mCAAmC,8BAA8B,CAAC,iGAAiG,aAAa,CAAC,AAAwG,wLAAmG,kBAAkB,CAAC,iCAAiC,mBAAmB,8BAA8B,CAAC,wDAAwD,aAAa,CAAC,8DAA8D,wBAAwB,CAAC,8EAA8E,wBAAwB,CAAC,kFAAkF,0BAA0B,CAAC,yPAAyP,wBAAwB,CAAC,+GAA+G,uBAAuB,CAAC,8BAA8B,WAAW,CAAC,yEAAyE,yBAAyB,aAAa,CAAC,+HAA+H,oBAAoB,CAAC,sCAAsC,kBAAkB,CAAC,oDAAoD,yBAAyB,aAAa,CAAC,0DAA0D,mCAAsC,cAAc,8BAAiC,CAAC,2DAA2D,8BAA8B,oBAAoB,CAAC,wDAAwD,WAAW,CAAC,oIAAoI,oCAAoC,qBAAqB,aAAa,CAAC,qCAAqC,oCAAuC,aAAa,CAAC,qCAAqC,uBAA0B,CAAC,yFAAyF,aAAa,CAAC,qGAAqG,mCAAsC,CAAC,6CAA6C,wBAAwB,CAAC,2CAA2C,8BAAiC,oBAAoB,CAAC,+CAA+C,YAAY,CAAC,mCAAmC,8BAAiC,mBAAmB,CAAC;;;;GAIniG,WAAW,iBAAiB,gBAAgB,yBAAyB,sDAAyD,kBAAkB,0CAA4C,WAAW,2BAA2B,UAAU,qBAAqB,iBAAiB,gBAAgB,eAAe,gBAAgB,uBAAuB,kBAAkB,mBAAmB,sBAAsB,8BAA8B,0BAA0B,eAAe,yBAAyB,sBAAsB,qBAAqB,gBAAgB,CAAC,iBAAiB,yBAAyB,4BAA4B,oBAAoB,CAAC,6BAA6B,qCAAqC,yBAAyB,yDAA4D,2DAA2D,UAAU,CAAC,iCAAiC,SAAS,CAAC,mCAAmC,wBAAwB,CAAC,4BAA4B,qCAAqC,yBAAyB,yDAA4D,2DAA2D,UAAU,CAAC,gCAAgC,SAAS,CAAC,kCAAkC,wBAAwB,CAAC,6BAA6B,qCAAqC,yBAAyB,mDAAsD,2DAA2D,UAAU,CAAC,iCAAiC,SAAS,CAAC,mCAAmC,qBAAqB,CAAC,oCAAoC,sBAAsB,oEAAoE,CAAC;;;;GAIzsD,iBAAiB,YAAY,qBAAqB,CAAC,uBAAuB,YAAY,CAAC,wBAAwB,UAAU,CAAC,+BAA+B,gBAAgB,CAAC,8EAA8E,eAAe,0BAA0B,4BAA4B,CAAC,4EAA4E,cAAc,yBAAyB,2BAA2B,CAAC,uBAAuB,WAAW,WAAW,WAAW,aAAa,CAAC;;;;GAInhB,oBAAoB,iCAAuC,aAAa,gBAAgB,kBAAkB,gBAAgB,qCAAqC,eAAe,CAAC,sBAAsB,cAAc,2CAA8C,+BAA+B,aAAa,CAAC,0BAA0B,WAAW,cAAc,WAAW,YAAY,eAAe,YAAY,CAAC,2BAA2B,iBAAiB,cAAc,YAAY,yCAA4C,gBAAgB,CAAC,4BAA4B,yBAAyB,UAAU,CAAC,wCAAwC,SAAS,CAAC,iCAAiC,QAAQ,CAAC,yBAAyB,aAAa,CAAC;;;;GAI1tB,kBAAkB,sBAAsB,aAAa,QAAQ,SAAS,SAAS,kBAAkB,iCAAiC,CAAC,yCAAyC,yBAAyB,sBAAsB,qBAAqB,gBAAgB,CAAC,oBAAoB,qBAAqB,CAAC,sEAAsE,kBAAkB,CAAC,wCAAwC,eAAe,MAAM,OAAO,WAAW,YAAY,gBAAgB,kBAAkB,mBAAmB,cAAc,aAAa,+BAA+B,CAAC,AAAkE,6EAAyB,aAAa,CAAC,gCAAgC,gBAAgB,qBAAqB,sBAAsB,mBAAmB,gBAAgB,eAAe,OAAO,MAAM,sBAAsB,iEAAiE,gBAAgB,gBAAgB,CAAC,yBAAyB,gCAAgC,eAAe,qBAAqB,sBAAsB,gBAAgB,gBAAgB,CAAC,CAAC,6CAA6C,gBAAgB,gBAAgB,aAAa,oBAAoB,CAAC,mDAAmD,kBAAkB,aAAa,CAAC,8DAA8D,cAAc,sBAAsB,gBAAgB,WAAW,YAAY,iBAAiB,gBAAgB,SAAS,CAAC,6CAA6C,gBAAgB,gBAAgB,aAAa,oBAAoB,CAAC,8CAA8C,UAAU,SAAS,SAAS,qBAAqB,mBAAmB,WAAW,YAAY,iBAAiB,kBAAkB,eAAe,oBAAoB,CAAC,mEAAmE,wBAAwB,CAAC,uDAAuD,UAAU,CAAC,6CAA6C,sBAAsB,YAAY,sBAAsB,UAAU,YAAY,iBAAiB,gBAAgB,YAAY,qBAAqB,CAAC,mDAAmD,UAAU,CAAC,sOAAsO,WAAW,YAAY,qBAAqB,qBAAqB,CAAC,qDAAqD,gBAAgB,WAAW,+DAA+D,YAAY,YAAY,eAAe,CAAC,gFAAgF,eAAe,UAAU,kBAAkB,SAAS,gBAAgB,iBAAiB,qBAAqB,kBAAkB,CAAC,yBAAyB,gFAAgF,cAAc,CAAC,CAAC,4DAA4D,iBAAiB,CAAC,iFAAiF,WAAW,eAAe,gBAAgB,qBAAqB,wCAAwC,WAAW,YAAY,mBAAmB,iBAAiB,qBAAqB,kBAAkB,WAAW,CAAC,uFAAuF,wBAAwB,CAAC,sEAAsE,WAAW,YAAY,cAAc,kBAAkB,CAAC,sDAAsD,yBAAyB,aAAa,CAAC,wEAAwE,mBAAmB,cAAc,CAAC,oFAAoF,eAAe,CAAC,8EAA8E,qBAAqB,eAAe,kBAAkB,eAAe,CAAC,ssBAAssB,cAAc,YAAY,gBAAgB,eAAe,uBAAuB,WAAW,sBAAsB,sBAAsB,sBAAsB,gBAAgB,4CAA4C,oEAAoE,CAAC,svBAAsvB,qBAAqB,UAAU,wEAAwE,CAAC,sxBAAsxB,yBAAyB,UAAU,CAAC,81BAA81B,UAAU,CAAC,2FAA2F,cAAc,yBAAyB,UAAU,CAAC,6FAA6F,sBAAsB,mBAAmB,WAAW,CAAC,iGAAiG,WAAW,kBAAkB,CAAC,oHAAoH,UAAU,CAAC,mGAAmG,SAAS,YAAY,mBAAmB,qBAAqB,CAAC,qGAAqG,kBAAkB,qBAAqB,sBAAsB,iBAAiB,kBAAkB,YAAY,gBAAgB,CAAC,qDAAqD,eAAe,iBAAiB,kBAAkB,YAAY,YAAY,CAAC,mEAAmE,WAAW,mBAAmB,YAAY,iBAAiB,eAAe,sBAAsB,sBAAsB,WAAW,WAAW,CAAC,0EAA0E,WAAW,qBAAqB,sBAAsB,WAAW,CAAC,uEAAuE,qBAAqB,WAAW,YAAY,qBAAqB,CAAC,wEAAwE,qBAAqB,sBAAsB,eAAe,eAAe,CAAC,yEAAyE,yBAAyB,yBAAyB,CAAC,kFAAkF,gBAAgB,CAAC,kEAAkE,wBAAwB,CAAC,iEAAiE,aAAa,CAAC,sDAAsD,kBAAkB,SAAS,QAAQ,iBAAiB,UAAU,WAAW,qBAAqB,4OAA4O,CAAC,4DAA4D,2BAA2B,CAAC,yBAAyB,sDAAsD,YAAY,CAAC,CAAC,yCAAyC,gBAAgB,mBAAmB,iBAAiB,kBAAkB,qBAAqB,qBAAqB,CAAC,+DAA+D,YAAY,CAAC,yBAAyB,2FAA2F,sBAAsB,CAAC,CAAC;;;;GAIj6U,mCAAmC,iBAAiB,cAAc,+DAA+D,UAAU,YAAY,gBAAgB,kBAAkB,sBAAsB,kCAAkC,uBAAuB,qBAAqB,eAAe,cAAc,OAAO,QAAQ,CAAC,qFAAqF,kBAAkB,CAAC,wTAAwT,iCAAuC,SAAS,UAAU,eAAe,CAAC,sCAAsC,eAAe,eAAe,CAAC,sCAAsC,iBAAiB,eAAe,CAAC,2EAA2E,cAAc,iBAAiB,CAAC,sCAAsC,iBAAiB,eAAe,CAAC,sCAAsC,iBAAiB,eAAe,CAAC,qFAAqF,qBAAqB,CAAC,wDAAwD,cAAc,eAAe,mBAAmB,cAAc,qBAAqB,WAAW,YAAY,sBAAsB,eAAe,CAAC,0DAA0D,sBAAsB,iBAAiB,eAAe,iBAAiB,WAAW,YAAY,aAAa,CAAC,+DAA+D,oBAAoB,CAAC,gEAAgE,wBAAwB,CAAC,gEAAgE,YAAY,CAAC;;;;GAI54D,mBAAmB,iCAAuC,YAAY,WAAW,CAAC,6CAA6C,YAAY,WAAW,kBAAkB,MAAM,MAAM,CAAC,+CAA+C,kBAAkB,QAAQ,SAAS,iBAAiB,iBAAiB,CAAC,6CAA6C,kBAAkB,eAAe,gBAAgB,uCAA0C,SAAS,QAAQ,SAAS,yBAAyB,kBAAkB,UAAU,8BAA8B,cAAc,oBAAoB,CAAC,qDAAqD,aAAa,CAAC,oDAAoD,mBAAmB,SAAS,CAAC,uFAAuF,aAAa,mBAAmB,YAAY,iBAAiB,CAAC,qGAAqG,oBAAoB,CAAC,6HAA6H,SAAS,CAAC,yIAAyI,+CAA+C,CAAC,yIAAyI,yBAAyB,yBAAyB,CAAC,kDAAkD,UAAU,yBAAyB,eAAe,CAAC,yBAAyB,kDAAkD,YAAY,CAAC,CAAC,qEAAqE,SAAS,CAAC,2EAA2E,+CAA+C,CAAC,2EAA2E,mCAAsC,yBAAyB,CAAC,kFAAkF,yBAAyB,sBAAsB,qBAAqB,iBAAiB,cAAc,aAAa,cAAc,gCAAgC,iBAAiB,gBAAgB,kBAAkB,qBAAqB,mBAAmB,cAAc,CAAC,oDAAoD,cAAc,kBAAkB,qBAAqB,cAAc,gBAAgB,wCAAwC,gCAAgC,iBAAiB,gBAAgB,kBAAkB,qBAAqB,cAAc,CAAC,6DAA6D,YAAY,WAAW,iBAAiB,eAAe,kBAAkB,UAAU,SAAS,UAAU,iBAAiB,oBAAoB,CAAC,mEAAmE,kBAAkB,CAAC,0DAA0D,WAAW,wBAAwB,CAAC,mEAAmE,UAAU,CAAC,iEAAiE,eAAe,mBAAmB,kBAAkB,WAAW,YAAY,UAAU,CAAC,qEAAqE,kBAAkB,CAAC,sFAAsF,wBAAwB,CAAC,mJAAmJ,UAAU,CAAC,mDAAmD,WAAW,gBAAgB,YAAY,CAAC,mFAAmF,yBAAyB,sBAAsB,qBAAqB,iBAAiB,qBAA2B,cAAc,aAAa,iBAAiB,gBAAgB,kBAAkB,qBAAqB,mBAAmB,eAAe,aAAa,CAAC,qFAAqF,eAAe,CAAC,qDAAqD,mBAAmB,qBAAqB,YAAY,aAAa,kBAAkB,kBAAkB,sBAAsB,oBAAwB,YAAY,gBAAgB,+CAA+C,uBAAuB,iBAAiB,CAAC,yDAAyD,eAAe,qBAAqB,CAAC,2DAA2D,oBAAoB,CAAC,4DAA4D,qBAAqB,wBAAwB,CAAC,wFAAwF,kBAAkB,QAAQ,OAAO,SAAS,mBAAmB,YAAY,iBAAiB,kBAAkB,4BAA4B,yBAAyB,WAAW,yBAAyB,eAAe,iBAAiB,eAAe,CAAC,6FAA6F,cAAc,uBAAuB,mBAAmB,gBAAgB,eAAe,CAAC,wIAAwI,gBAAgB,cAAc,CAAC,+FAA+F,yBAAyB,WAAW,gBAAgB,CAAC,8FAA8F,aAAa,CAAC,uFAAuF,cAAc,WAAW,YAAY,iBAAiB,SAAS,qBAAuB,gBAAgB,kBAAkB,CAAC,2FAA2F,eAAe,eAAe,sBAAsB,qBAAqB,eAAe,CAAC,0HAA0H,UAAU,gBAAgB,qBAAqB,wBAAwB,gBAAgB,6BAA6B,YAAY,oBAAoB,sBAAsB,WAAW,CAAC,+HAA+H,qBAAqB,YAAY,cAAc,CAAC,0KAA0K,SAAS,CAAC,AAAoL,uVAA6K,SAAS,CAAC,6FAA6F,wBAAwB,CAAC,gIAAgI,WAAW,gBAAgB,CAAC,8FAA8F,YAAY,WAAW,sBAAsB,oBAAoB,CAAC,kFAAkF,SAAS,CAAC,yBAAyB,kFAAkF,WAAW,aAAa,CAAC,CAAC,2BAA2B,kBAAkB,gBAAgB,gBAAgB,iBAAiB,iBAAiB,CAAC,iEAAiE,kBAAkB,MAAM,YAAY,MAAM,CAAC,sEAAsE,UAAU,OAAO,CAAC,qEAAqE,WAAW,YAAY,kBAAkB,QAAQ,iBAAiB,2BAA2B,YAAY,CAAC,2EAA2E,SAAS,CAAC,+BAA+B,eAAe,eAAe,CAAC,iBAAiB,wBAAwB,CAAC,qGAAqG,kBAAkB,YAAY,SAAS,eAAe,cAAc,eAAe,CAAC,2GAA2G,eAAe,kBAAkB,MAAM,SAAS,QAAQ,mBAAmB,UAAU,UAAU,eAAe,CAAC,+FAA+F,eAAe,cAAc,YAAY,QAAQ,CAAC,oHAAoH,qBAAqB,CAAC,qPAAqP,aAAa,kBAAkB,UAAU,CAAC,4GAA4G,iBAAiB,CAAC;;;;GAI90S,YAAY,UAAU,CAAC,gCAAgC,cAAc,UAAU,CAAC,8BAA8B,UAAU,CAAC,8BAA8B,SAAS,CAAC,8BAA8B,SAAS,CAAC,8BAA8B,SAAS,CAAC,8BAA8B,SAAS,CAAC,8BAA8B,UAAU,CAAC,8BAA8B,SAAS,CAAC,8BAA8B,SAAS,CAAC,8BAA8B,SAAS,CAAC,qCAAqC,YAAY,aAAa,CAAC,kBAAkB,UAAU,CAAC;;;;GAIthB,kBAAkB,GAAG,uBAAwB,CAAC,CAAC,mBAAmB,qgOAAwgO,0BAA0B,YAAY,aAAa,AAA2C,sBAAsB,wCAAwC,CAAC,+BAA1G,qBAAqB,qBAAsB,CAA2N,AAA5J,YAAY,kBAAkB,AAAqB,WAAW,cAAc,AAAsB,UAAU,+BAA+B,gBAAgB,CAAC,iBAAiB,cAAc,CAAC,sCAAsC,eAAe,YAAY,gBAAgB,CAAC,sCAAsC,eAAe,YAAY,gBAAgB,CAAC;;;;GAIvkP,oBAAoB,WAAW,YAAY,aAAa,eAAe,CAAC,yBAAyB,oBAAoB,WAAW,CAAC,CAAC,oDAAoD,WAAW,CAAC,yBAAyB,oDAAoD,YAAY,gBAAgB,CAAC,CAAC,sBAAsB,qBAAqB,CAAC,qDAAqD,4BAA4B,WAAW,2CAA8C,yBAAyB,iBAAiB,uBAAuB,mBAAmB,eAAe,yBAAyB,sBAAsB,qBAAqB,iBAAiB,gBAAgB,eAAe,CAAC,yDAAyD,kBAAkB,WAAW,qBAAqB,qBAAqB,CAAC,uDAAuD,YAAY,CAAC,uFAAuF,yBAAyB,WAAW,wBAAwB,CAAC,2FAA2F,SAAS,CAAC,yFAAyF,aAAa,CAAC,yBAAyB,sBAAsB,qKAA6K,0BAA0B,kCAAkC,YAAY,gBAAgB,yBAAyB,sBAAsB,qBAAqB,iBAAiB,kBAAkB,YAAY,CAAC,gCAAgC,aAAa,CAAC,iDAAiD,gBAAgB,kBAAkB,UAAU,oBAAoB,WAAW,CAAC,qDAAqD,yBAAyB,sBAAsB,qBAAqB,iBAAiB,eAAe,eAAe,CAAC,yGAAyG,UAAU,YAAY,aAAa,kBAAkB,yBAAyB,sBAAsB,4BAA4B,SAAS,UAAU,mBAAmB,CAAC,iJAAiJ,kBAAkB,qBAAqB,yBAAyB,UAAU,yBAAyB,iBAAiB,mBAAmB,YAAY,WAAW,YAAY,aAAa,yBAAyB,kBAAkB,CAAC,+JAA+J,qBAAqB,CAAC,sDAAsD,YAAY,gBAAgB,kBAAkB,iBAAiB,iBAAiB,CAAC,6DAA6D,WAAW,iBAAiB,sBAAsB,YAAY,oBAAoB,CAAC,8EAA8E,YAAY,iBAAiB,qBAAqB,sBAAsB,mBAAmB,YAAY,gBAAgB,gBAAgB,CAAC,kFAAkF,eAAe,eAAe,CAAC,qFAAqF,WAAW,iBAAiB,sBAAsB,YAAY,oBAAoB,CAAC,oFAAoF,WAAW,kBAAkB,MAAM,OAAO,SAAS,QAAQ,YAAY,8BAAgC,SAAS,CAAC,yGAAyG,mBAAmB,WAAW,CAAC,uHAAuH,eAAe,gBAAgB,kBAAkB,aAAa,UAAU,kBAAkB,WAAW,iBAAiB,0BAA0B,mBAAmB,gBAAgB,aAAa,CAAC;;;;GAIhqI,sBAAsB,kBAAkB,qBAAqB,WAAW,YAAY,iBAAiB,cAAc,gBAAgB,sBAAsB,UAAU,8BAA8B,CAAC,2BAA2B,YAAY,CAAC,6CAA6C,SAAS,CAAC,6CAA6C,YAAY,CAAC,0EAA0E,aAAa,kBAAkB,cAAc,sBAAsB,UAAU,yBAAyB,SAAS,wBAAwB,eAAe,kBAAkB,CAAC,iFAAiF,WAAW,qBAAqB,sBAAsB,WAAW,CAAC,8EAA8E,eAAe,gBAAgB,qBAAqB,CAAC,4FAA4F,oBAAoB,kBAAkB,CAAC,8FAA8F,qBAAqB,cAAc,CAAC,+GAA+G,+BAA+B,+BAA+B,CAAC;;;;GAIvxC,gCAAgC,qBAAqB,CAAC,eAAe,kBAAkB,OAAO,MAAM,mBAAmB,oBAAoB,0BAA0B,YAAY,mBAAmB,0CAA0C,UAAU,sBAAsB,gBAAgB,yBAAyB,CAAC,oCAAoC,YAAY,CAAC,yBAAyB,kBAAkB,OAAO,QAAQ,cAAc,eAAe,CAAC,4BAA4B,eAAe,wBAAwB,gBAAgB,UAAU,MAAM,SAAS,CAAC,iDAAiD,aAAa,CAAC,oCAAoC,WAAW,qBAAqB,cAAc,wBAAkC,CAAC,oCAAoC,qBAAqB,mBAAmB,mBAAmB,UAAU,0BAA0B,UAAU,kBAAkB,kBAAkB,eAAe,yDAAyD,CAAC,mDAAmD,uCAAuC,WAAW,cAAc,CAAC,qDAAqD,cAAc,CAAC,gEAAgE,cAAc,+BAA+B,UAAU,2BAA2B,cAAc,CAAC,4DAA4D,wBAAwB,WAAW,6BAA6B,SAAS,sBAAsB,CAAC,+FAA+F,WAAW,YAAY,qBAAqB,UAAU,oBAAoB,CAAC,2GAA2G,WAAW,qBAAqB,YAAY,qBAAqB,CAAC,2IAA2I,2BAA2B,CAAC,kEAAkE,sBAAsB,CAAC,sCAAsC,gBAAgB,CAAC,iMAAiM,2BAA2B,CAAC,oEAAoE,yBAAyB,SAAS,CAAC,sHAAsH,mCAAsC,SAAS,CAAC,qDAAqD,sBAAsB,CAAC,6FAA6F,QAAQ,SAAS,mCAAmC,kCAAkC,6BAA6B,qBAAqB,sBAAsB,eAAe,CAAC,6HAA6H,wBAAwB,qBAAqB,gBAAgB,YAAY,gBAAgB,UAAU,gBAAgB,CAAC,+DAA+D,mBAAmB,8jBAA8jB,CAAC,kBAAkB,eAAe,YAAY,gBAAgB,CAAC,8CAA8C,YAAY,QAAQ,WAAW,CAAC,eAAe,eAAe,mBAAmB,WAAW,eAAe,iBAAiB,gBAAgB,6BAA6B,cAAc,WAAW,6BAA6B,CAAC,yBAAyB,eAAe,YAAY,CAAC,CAAC,yCAAyC,yBAAyB,CAAC,4CAA4C,eAAe,YAAY,gBAAgB,CAAC,wEAAwE,YAAY,QAAQ,WAAW,CAAC,yCAAyC,yBAAyB,CAAC,4CAA4C,eAAe,YAAY,gBAAgB,CAAC,wEAAwE,YAAY,QAAQ,WAAW,CAAC,qBAAqB,kBAAkB,WAAW,SAAS,gBAAgB,cAAc,OAAO,eAAe,2BAA2B,gBAAgB,oCAAoC,+BAA+B,CAAC,oCAAoC,gBAAgB,eAAe,4BAA4B,CAAC,mDAAmD,yBAAyB,0CAA0C,qBAAqB,CAAC,uBAAuB,WAAW,CAAC,2CAA2C,UAAU,SAAS,UAAU,WAAW,kBAAkB,SAAS,SAAS,qBAAqB,wBAAwB,gBAAgB,gCAAgC,yBAAyB,SAAS,CAAC,iCAAiC,UAAU,OAAO,CAAC,wCAAwC,UAAU,UAAU,CAAC,sCAAsC,cAAc,sBAAsB,0BAA0B,CAAC,+CAA+C,yBAAyB,CAAC;;;;GAI5qL,qDAAqD,kBAAkB,YAAY,uBAAuB,eAAe,cAAc,kBAAkB,eAAe,CAAC,iEAAiE,wBAAwB,CAAC,iEAAiE,eAAe,kBAAkB,MAAM,SAAS,QAAQ,SAAS,UAAU,UAAU,eAAe,CAAC,yBAAyB,4BAA4B,WAAW,eAAe,eAAe,CAAC,CAAC,iBAAiB,sBAAsB,aAAa,YAAY,yBAAyB,aAAa,CAAC,uCAAuC,eAAe,WAAW,yBAAyB,kBAAkB,UAAU,qBAAqB,CAAC,kEAAkE,YAAY,iBAAiB,CAAC,oFAAoF,SAAS,UAAU,gBAAgB,qBAAqB,mBAAmB,iBAAiB,CAAC,0FAA0F,gBAAgB,CAAC,qFAAqF,yBAAyB,sBAAsB,qBAAqB,iBAAiB,qBAAqB,wBAAwB,gBAAgB,mBAAmB,gBAAgB,iBAAiB,UAAU,SAAS,UAAU,CAAC,+FAA+F,SAAS,CAAC,2CAA2C,WAAW,YAAY,qBAAqB,kBAAkB,CAAC,yCAAyC,qBAAqB,eAAe,iBAAiB,CAAC,+CAA+C,oCAAuC,qBAAqB,UAAU,CAAC,uBAAuB,YAAY,cAAc,kBAAkB,YAAY,SAAS,WAAW,UAAU,CAAC;;;;GAIv8D,YAAY,UAAU,CAAC,8EAA8E,wBAAwB,qBAAqB,cAAc,UAAU,yBAAyB,YAAY,iBAAiB,cAAc,gBAAgB,eAAe,CAAC,kHAAkH,qBAAqB,4CAA+C,CAAC,yBAAyB,8EAA8E,eAAe,CAAC,CAAC,qBAAqB,YAAY,CAAC,mBAAmB,YAAY,cAAc,WAAW,aAAa,eAAe,qBAAqB,YAAY,mBAAmB,eAAe,UAAU,kCAAkC,gBAAgB,kBAAkB,CAAC,yBAAyB,yBAAyB,UAAU,CAAC,0BAA0B,mBAAmB,UAAU,CAAC,iCAAiC,qBAAqB,UAAU,cAAc,eAAe,YAAY,SAAS,UAAU,WAAW,kBAAkB,UAAU,OAAO,CAAC,uCAAuC,WAAW,gBAAgB,oCAAuC,kBAAkB,4BAA4B,WAAW,YAAY,qBAAqB,kBAAkB,UAAU,sBAAsB,0DAA0D,CAAC,+CAA+C,0MAAwR,yBAAyB,oBAAoB,CAAC,kBAAkB,gBAAgB,cAAc,eAAe,CAAC,uBAAuB,WAAW,cAAc,UAAU,CAAC;;;;GAIr4D,aAAa,YAAY,CAAC,eAAe,cAAc,oBAAoB,CAAC,0CAA0C,cAAc,0BAA0B,SAAS,CAAC,iBAAiB,iBAAiB,CAAC;;;;GAI3M,mBAAmB,gBAAgB,gBAAgB,SAAS,yBAAyB,sBAAsB,qBAAqB,gBAAgB,CAAC,4CAA4C,kBAAkB,kBAAkB,CAAC,qBAAqB,WAAW,YAAY,iBAAiB,qBAAqB,qBAAqB,sBAAsB,iBAAiB,CAAC,qCAAqC,WAAW,qBAAqB,UAAU,CAAC,4BAA4B,WAAW,qBAAqB,YAAY,sBAAsB,OAAO,CAAC,yBAAyB,qBAAqB,sBAAsB,2BAA2B,cAAc,CAAC,2BAA2B,iBAAiB,CAAC,4BAA4B,mBAAmB,aAAa,CAAC;;;;GAI/vB,iBAAiB,IAAI,UAAU,CAAC,IAAI,SAAS,CAAC,GAAG,UAAU,CAAC,CAAC,oBAAoB,kBAAkB,MAAM,OAAO,WAAW,mBAAmB,kBAAkB,YAAY,CAAC,wBAAwB,kBAAkB,mBAAmB,WAAW,iDAAiD,yBAAyB,CAAC,6DAA6D,wCAAwC,WAAW,qBAAqB,kBAAkB,MAAM,WAAW,iCAAiC,mBAAmB,UAAU,CAAC,+BAA+B,YAAY,YAAY,8BAA8B,CAAC,8BAA8B,WAAW,QAAQ,8BAA8B,CAAC;;;;GAI7sB,gCAAgC,iBAAiB,kBAAkB,cAAc,CAAC,kCAAkC,qBAAqB,qBAAqB,eAAe,gBAAgB,kBAAkB,mBAAmB,YAAY,iBAAiB,kBAAkB,sBAAsB,iCAAiC,uBAAuB,gBAAgB,gBAAgB,yBAAyB,cAAc,gCAAgC,SAAS,CAAC,yBAAyB,kCAAkC,qBAAqB,yBAAyB,CAAC,CAAC,oCAAoC,gBAAgB,CAAC,0EAA0E,WAAW,YAAY,qBAAqB,mBAAmB,iBAAiB,YAAY,CAAC,wCAAwC,yBAAyB,WAAW,gBAAgB,yBAAyB,SAAS,CAAC,sFAAsF,SAAS,CAAC,kFAAkF,UAAU,gBAAgB,sBAAsB,UAAU,CAAC,gLAAgL,SAAS,CAAC,2CAA2C,YAAY,CAAC,kDAAkD,aAAa,CAAC,4DAA4D,gBAAgB,gBAAgB,CAAC;;;;GAIlhD,oBAA0C,UAAU,kBAAkB,YAAY,iBAAiB,sBAAsB,YAAY,MAAM,UAAU,iBAAiB,YAAY,CAAC,0CAA/J,qBAAsB,CAAqL,2BAA2B,WAAY,CAAsD,qDAAtD,qBAAqB,sBAAsB,UAAU,CAAoK,AAAnK,0BAA0B,sBAAsB,AAAiC,0BAA0B,WAAW,AAAqB,uBAAuB,CAAC,yBAAyB,QAAQ,kBAAkB,qBAAqB,WAAW,YAAY,8BAAgC,mBAAmB,sBAAsB,cAAc,cAAc,CAAC,+BAA+B,kBAAkB,CAAC,wBAAwB,WAAW,UAAU,kBAAkB,CAAC,uCAAuC,sBAAsB,CAAC;;;;GAIp1B,8BAA8B,kBAAkB,QAAQ,SAAS,QAAQ,SAAS,iBAAiB,SAAS,CAAC,gCAAgC,kBAAkB,UAAU,SAAS,cAAc,gDAAgD,UAAU,6BAA6B,cAAc,gBAAgB,qCAAuC,eAAe,eAAe,CAAC,sCAAsC,SAAS,CAAC,oCAAoC,iCAAiC,cAAc,mCAAsC,CAAC,uCAAuC,gCAAgC,cAAc,mCAAsC,CAAC;;;;GAIjqB,oBAAoB,yBAAyB,0BAA0B,0BAA0B,CAAC,gDAAgD,mBAAmB,kBAAkB,0BAA0B,CAAC,wBAAwB,wBAAwB,CAAC,gBAAgB,kBAAkB,MAAM,OAAO,QAAQ,SAAS,eAAe,wBAAwB,CAAC,yBAAyB,oBAAoB,CAAC,0DAA0D,WAAW,CAAC,gCAAgC,yBAAyB,aAAa,CAAC,yDAAyD,wBAAwB,CAAC,yDAAyD,wBAAwB,CAAC;;;;GAI1sB,mBAAmB,mCAAmC,gCAAgC,+BAA+B,2BAA2B,MAAM,OAAO,cAAc,kBAAkB,aAAa,sBAAsB,UAAU,mBAAmB,CAAC;;;;GAI9P,mCAAmC,kBAAkB,QAAQ,QAAQ,CAAC,4EAA4E,YAAY,CAAC,4BAA4B,+BAA+B,2BAA2B,CAAC,gCAAgC,yBAA4B,gBAAgB,gBAAgB,4BAA4B,iCAAuC,sBAAsB,yBAAyB,sBAAsB,qBAAqB,iBAAiB,yBAAyB,gBAAgB,oCAAuC,qBAAqB,kBAAkB,CAAC,2CAA2C,UAAU,SAAS,kBAAkB,CAAC,+CAA+C,mBAAmB,gBAAgB,kBAAkB,CAAC,kDAAkD,UAAU,SAAS,UAAU,WAAW,kBAAkB,SAAS,iBAAiB,qBAAqB,wBAAwB,gBAAgB,oCAAuC,yBAAyB,SAAS,CAAC,iFAAiF,SAAS,YAAY,wBAAwB,CAAC,qCAAqC,+DAA+D,cAAc,mBAAmB,cAAc,eAAe,CAAC;;;;GAI71C,4BAA4B,cAAc,WAAW,yBAAyB,sBAAsB,qBAAqB,iBAAiB,iBAAiB,CAAC,kCAAkC,kBAAkB,WAAW,UAAU,MAAM,OAAO,QAAQ,SAAS,eAAe,cAAc,sBAAwB,CAAC,eAAe,YAAY,aAAa,kBAAkB,mCAAmC,MAAM,OAAO,aAAa,oBAAoB,WAAW,CAAC,iBAAiB,qBAAqB,CAAC,oBAA2D,UAAU,8BAA8B,SAAS,QAAQ,YAAY,iBAAiB,eAAe,WAAW,kBAAkB,iBAAiB,kBAAkB,iBAAiB,WAAW,iCAAiC,cAAc,CAAC,qCAAxR,kBAAkB,oBAAqB,CAAua,AAAtL,iBAAwD,UAAU,mBAAmB,mCAAmC,oCAAuC,WAAW,WAAW,CAAC,uBAAuB,wBAAwB,CAAC,6BAA8B,UAAU,SAAS,gBAAgB,CAAC,8BAA8B,WAAW,SAAS,gBAAgB,CAAC,8BAA8B,WAAW,YAAY,gBAAgB,CAAC,8BAA8B,UAAU,YAAY,gBAAgB,CAAC,yBAAyB,iBAAiB,WAAW,WAAW,CAAC,6BAA8B,WAAW,UAAU,gBAAgB,CAAC,8BAA8B,YAAY,UAAU,gBAAgB,CAAC,8BAA8B,YAAY,aAAa,gBAAgB,CAAC,8BAA8B,WAAW,aAAa,gBAAgB,CAAC,CAAC;;;;GAInnD,iBAAiB,gBAAgB,CAAC,kCAAkC,oBAAoB,aAAa,YAAY,gBAAgB,eAAe,CAAC,qBAAqB,iBAAiB,CAAC,uBAAuB,kBAAkB,SAAS,QAAQ,yBAAyB,sBAAsB,qBAAqB,iBAAiB,QAAQ,SAAS,gBAAgB,yBAAyB,sDAAsD,wCAAwC,gBAAgB,CAAC;;;;GAIhf,cAAc,aAAa,kBAAkB,yBAAyB,YAAY,AAAgB,WAAW,OAAO,aAAa,CAAC,sDAAhD,eAAgB,CAAwF,2GAA2G,sBAAsB,CAAC,iDAAiD,uBAAuB,CAAC,yJAAyJ,wBAAwB,UAAU,WAAW,MAAM,CAAC,qBAAqB,SAAS,WAAW,mBAAmB,SAAS,YAAY,gBAAgB,YAAY,sBAAsB,cAAc,UAAU,8CAA8C,eAAe,kBAAkB,UAAU,aAAa,cAAc,qBAAqB,kBAAkB,gBAAgB,aAAa,eAAe,CAAC,qCAAqC,kBAAkB,CAAC,gCAAgC,kBAAkB,CAAC;;;;GAIhiC,qBAAqB,kBAAkB,kBAAkB,UAAU,iBAAiB,kBAAkB,gBAAgB,CAAC,2BAA2B,WAAW,cAAc,YAAY,QAAQ,6BAA6B,sBAAsB,CAAC,2BAA2B,SAAS,CAAC,iCAAiC,oBAAoB,CAAC,qBAAqB,WAAW,YAAY,yBAAyB,mBAAmB,iBAAiB,cAAc,CAAC,wBAAwB,yBAAyB,sBAAsB,qBAAqB,gBAAgB,CAAC,sDAAsD,sBAAsB,gBAAgB,sBAAsB,yBAAyB,sBAAsB,qBAAqB,gBAAgB,CAAC,0GAA0G,yBAAyB,CAAC,mDAAmD,WAAW,CAAC,yEAAyE,qBAAqB,mBAAmB,UAAU,SAAS,gBAAgB,WAAW,CAAC,6EAA6E,WAAW,YAAY,sBAAsB,qBAAqB,kBAAkB,kBAAkB,CAAC,mFAAmF,WAAW,kBAAkB,MAAM,OAAO,qBAAqB,WAAW,YAAY,qBAAqB,CAAC,2FAA2F,mBAAmB,wBAAwB,CAAC,uEAAuE,eAAe,qBAAqB,kBAAkB,CAAC,6EAA6E,gBAAgB,aAAa,CAAC,mFAAmF,iBAAiB,CAAC,2BAA2B,kBAAkB,eAAe,YAAY,cAAc,QAAQ,CAAC;;;;GAIpgE,8BAA8B,WAAW,cAAc,CAAC,2CAA4C,wBAAwB,CAAC,oDAAoD,iCAAuC,UAAU,CAAC,AAAiE,0FAAoC,UAAU,CAAC,sCAAuG,oBAAqB,CAAsB,6KAA5G,eAAe,iCAAuC,WAAW,AAAqB,qBAAqB,CAA+N,+JAA+J,UAAU,CAAC;;;;GAI72B,AAAoC,8BAAgB,qBAAqB,CAAC;;;;GAI1E,cAAc,kBAAkB,kBAAkB,MAAM,QAAQ,QAAQ,QAAQ,CAAC,kCAAkC,kBAAkB,CAAC,gCAAgC,YAAY,kBAAkB,QAAQ,yBAAyB,sBAAsB,yBAAyB,WAAW,CAAC,sCAAsC,SAAS,WAAW,YAAY,SAAS,6BAA6B,UAAU,cAAc,CAAC,2DAA2D,YAAY,CAAC,gKAAgK,YAAY,qBAAqB,kBAAkB,CAAC,qDAAqD,UAAU,iBAAiB,CAAC,qDAAqD,UAAU,iBAAiB,kBAAkB,WAAW,0BAA0B,CAAC,4DAA4D,WAAW,qBAAqB,sBAAsB,WAAW,CAAC,0DAA0D,qBAAqB,qBAAqB,CAAC,sDAAsD,eAAe,SAAS,CAAC,6DAA6D,UAAU,UAAU,gBAAgB,gBAAgB,gCAAgC,YAAY,6BAA6B,4BAA4B,CAAC,0FAA0F,WAAW,sBAAsB,eAAe,YAAY,CAAC,mEAAmE,wBAAwB,CAAC,mEAAmE,qCAAqC,CAAC,oEAAoE,yBAAyB,oBAAwB,CAAC,wHAAwH,WAAW,CAAC,oIAAoI,WAAW,sCAAsC,CAAC,gJAAgJ,6CAAgD,CAAC,wLAAwL,aAAa,CAAC,yBAAkD,8CAAgC,UAAU,CAAC,CAAC,eAAe,YAAY,YAAY,CAAC,8FAA8F,qBAAqB,kBAAkB,CAAC,8CAA8C,SAAS,CAAC,gDAAgD,SAAS,CAAC,uEAAuE,eAAe,kBAAkB,eAAe,qBAAqB,CAAC,qBAAqB,SAAS,iBAAiB,kBAAkB,CAAC,wBAAwB,SAAS,CAAC,0BAA0B,eAAe,qBAAqB,WAAW,qBAAqB,sBAAsB,aAAa,cAAc,6BAA6B,kBAAkB,mBAAmB,kBAAkB,CAAC,gEAAgE,wBAAwB,CAAC,4BAA4B,YAAY,CAAC,6BAA6B,eAAe,UAAU,MAAM,SAAS,CAAC,0CAA0C,aAAa,CAAC,qBAAqB,aAAa,eAAe,CAAC,yBAAyB,qBAAqB,cAAc,CAAC,CAAC,yBAAyB,eAAe,iBAAiB,qBAAqB,CAAC,qCAAqC,kBAAkB,CAAC,uCAAuC,UAAU,sBAAsB,cAAc,eAAe,gBAAgB,gBAAgB,uBAAuB,YAAY,SAAS,6BAA6B,qBAAqB,UAAU,CAAC,oDAAoD,WAAW,wBAAwB,CAAC,6CAA6C,SAAS,CAAC,oCAAoC,aAAa,aAAa,CAAC,8EAA8E,QAAQ,CAAC","file":"bundle.less","sourcesContent":["/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n *//*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n *//*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit,.jodit *,.jodit_container,.jodit_container *{box-sizing:border-box}.jodit .jodit_workplace,.jodit_container .jodit_workplace{position:relative;overflow:auto}.jodit .jodit_workplace .jodit_wysiwyg,.jodit .jodit_workplace .jodit_wysiwyg_iframe,.jodit_container .jodit_workplace .jodit_wysiwyg,.jodit_container .jodit_workplace .jodit_wysiwyg_iframe{height:100%;width:100%}.jodit_container:not(.jodit_inline){background:#fff;font-size:14px;font-family:Helvetica,sans-serif,Arial}.jodit_container:not(.jodit_inline) .jodit_workplace{border:1px solid #ccc}.jodit_disabled{-webkit-user-select:none!important;-moz-user-select:none!important;-ms-user-select:none!important;user-select:none!important}.jodit_hidden{display:none!important}.jodit_wysiwyg{outline:0}.jodit_wysiwyg ::-moz-selection,.jodit_wysiwyg::-moz-selection{background:#b5d6fd;color:#000}.jodit_wysiwyg ::selection,.jodit_wysiwyg::selection{background:#b5d6fd;color:#000}.jodit_container:not(.jodit_inline) .jodit_wysiwyg{margin:0;padding:10px;outline:0;overflow-x:auto;position:relative}.jodit_container:not(.jodit_inline) .jodit_wysiwyg img{position:relative;max-width:100%}.jodit_container:not(.jodit_inline) .jodit_wysiwyg p,.jodit_container:not(.jodit_inline) .jodit_wysiwyg pre{margin:0 0 10px}.jodit_container:not(.jodit_inline) .jodit_wysiwyg h1,.jodit_container:not(.jodit_inline) .jodit_wysiwyg h2,.jodit_container:not(.jodit_inline) .jodit_wysiwyg h3,.jodit_container:not(.jodit_inline) .jodit_wysiwyg h4,.jodit_container:not(.jodit_inline) .jodit_wysiwyg h5{margin-top:0}.jodit_container:not(.jodit_inline) .jodit_wysiwyg blockquote{border-left:solid 2px #222;margin-left:0;padding-left:5px;color:#222}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_clearfix:after,.jodit_clearfix:before{content:\" \";display:table}.jodit_clearfix:after{clear:both}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_dark_theme.jodit_container{background-color:#575757}.jodit_dark_theme .jodit_workplace{border-color:rgba(87,87,87,.8)}.jodit_dark_theme .jodit_statusbar{background-color:rgba(95,92,92,.8);border-color:rgba(87,87,87,.8)}.jodit_dark_theme .jodit_statusbar,.jodit_dark_theme .jodit_statusbar .jodit_statusbar_item span{color:#d1cccc}.jodit_dark_theme .jodit_toolbar_popup,.jodit_dark_theme .jodit_toolbar_popup-inline{background:#575757}.jodit_dark_theme .jodit_toolbar_popup-inline:before,.jodit_dark_theme .jodit_toolbar_popup:before{background:#575757}.jodit_dark_theme .jodit_toolbar{background:#5f5c5c;border-color:rgba(87,87,87,.8)}.jodit_dark_theme .jodit_toolbar li.jodit_toolbar_btn>a{color:#d1cccc}.jodit_dark_theme .jodit_toolbar li.jodit_toolbar_btn>a:hover{background-color:#575757}.jodit_dark_theme .jodit_toolbar li.jodit_toolbar_btn.jodit_toolbar_btn-break{border-top-color:#686767}.jodit_dark_theme .jodit_toolbar li.jodit_toolbar_btn.jodit_toolbar_btn-separator{border-right-color:#686767}.jodit_dark_theme .jodit_toolbar li.jodit_toolbar_btn.active,.jodit_dark_theme .jodit_toolbar li.jodit_toolbar_btn.jodit_active,.jodit_dark_theme .jodit_toolbar li.jodit_toolbar_btn:active,.jodit_dark_theme .jodit_toolbar li.jodit_toolbar_btn:hover{background-color:#575757}.jodit_dark_theme .jodit_toolbar li.jodit_toolbar_btn.jodit_with_dropdownlist .jodit_with_dropdownlist-trigger{border-top-color:silver}.jodit_dark_theme .jodit_icon{fill:silver}.jodit_dark_theme .jodit_wysiwyg,.jodit_dark_theme .jodit_wysiwyg_iframe{background-color:#575757;color:#d1cccc}.jodit_dark_theme .jodit_wysiwyg [data-jodit-selected-cell],.jodit_dark_theme .jodit_wysiwyg_iframe [data-jodit-selected-cell]{border-color:#152f5f}.jodit_dark_theme .jodit_dropdownlist{background:#5f5c5c}.jodit_dark_theme .jodit_tabs .jodit_tabs_buttons>a{background-color:#686767;color:#d1cccc}.jodit_dark_theme .jodit_tabs .jodit_tabs_buttons>a:hover{background-color:rgba(104,103,103,.8);color:#d1cccc;border-color:rgba(104,103,103,.9)}.jodit_dark_theme .jodit_tabs .jodit_tabs_buttons>a.active{background:rgba(81,81,81,.41);border-color:#686767}.jodit_dark_theme .jodit_tabs .jodit_tabs_buttons>a svg{fill:silver}.jodit_dark_theme .jodit_form input[type=text],.jodit_dark_theme .jodit_form input[type=url],.jodit_dark_theme .jodit_form textarea{background-color:rgba(81,81,81,.41);border-color:#686767;color:#d1cccc}.jodit_dark_theme .jodit_form button{background-color:rgba(104,103,103,.75);color:#d1cccc}.jodit_dark_theme .jodit_placeholder{color:rgba(209,204,204,.8)}.jodit_dark_theme .jodit_draganddrop_file_box,.jodit_dark_theme .jodit_uploadfile_button{color:#d1cccc}.jodit_dark_theme .jodit_draganddrop_file_box:hover,.jodit_dark_theme .jodit_uploadfile_button:hover{background-color:rgba(104,103,103,.75)}.jodit_dark_theme .jodit-add-new-line:before{border-top-color:#686767}.jodit_dark_theme .jodit-add-new-line span{background:rgba(104,103,103,.75);border-color:#686767}.jodit_dark_theme .jodit-add-new-line span svg{fill:#d1cccc}.jodit_dark_theme .jodit_resizer>i{background:rgba(104,103,103,.75);border-color:silver}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_btn{border:1px solid;border-radius:0;background-color:#f5f5f5;background-image:linear-gradient(to bottom,#fff,#e6e6e6);border-color:#ccc;text-shadow:0 1px 1px rgba(255,255,255,.75);color:#333;background-repeat:repeat-x;outline:0;display:inline-block;padding:6px 12px;margin-bottom:0;font-size:14px;font-weight:400;line-height:1.42857143;text-align:center;white-space:nowrap;vertical-align:middle;-ms-touch-action:manipulation;touch-action:manipulation;cursor:pointer;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.jodit_btn:hover{background-color:#e6e6e6;background-position:0 -15px;text-decoration:none}.jodit_btn.jodit_btn_success{text-shadow:0 -1px 0 rgba(0,0,0,.25);background-color:#5bb75b;background-image:linear-gradient(to bottom,#62c462,#51a351);border-color:rgba(0,0,0,.1) rgba(0,0,0,.1) rgba(0,0,0,.25);color:#fff}.jodit_btn.jodit_btn_success svg{fill:#fff}.jodit_btn.jodit_btn_success:hover{background-color:#51a351}.jodit_btn.jodit_btn_danger{text-shadow:0 -1px 0 rgba(0,0,0,.25);background-color:#da4f49;background-image:linear-gradient(to bottom,#ee5f5b,#bd362f);border-color:rgba(0,0,0,.1) rgba(0,0,0,.1) rgba(0,0,0,.25);color:#fff}.jodit_btn.jodit_btn_danger svg{fill:#fff}.jodit_btn.jodit_btn_danger:hover{background-color:#bd362f}.jodit_btn.jodit_btn_inverse{text-shadow:0 -1px 0 rgba(0,0,0,.25);background-color:#363636;background-image:linear-gradient(to bottom,#444,#222);border-color:rgba(0,0,0,.1) rgba(0,0,0,.1) rgba(0,0,0,.25);color:#fff}.jodit_btn.jodit_btn_inverse svg{fill:#fff}.jodit_btn.jodit_btn_inverse:hover{background-color:#222}.jodit_btn.active,.jodit_btn:active{background-image:none;box-shadow:inset 0 2px 4px rgba(0,0,0,.15),0 1px 2px rgba(0,0,0,.05)}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_btn_group{font-size:0;vertical-align:middle}.jodit_btn_group input{display:none}.jodit_btn_group button{float:left}.jodit_btn_group button+button{margin-left:-1px}.jodit_btn_group button:first-child,.jodit_btn_group input:first-child+button{border-right:0;border-top-right-radius:0;border-bottom-right-radius:0}.jodit_btn_group button:last-child,.jodit_btn_group input:last-child+button{border-left:0;border-top-left-radius:0;border-bottom-left-radius:0}.jodit_btn_group:after{content:'';clear:both;float:none;display:table}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_context_menu{font-family:Helvetica,sans-serif,Arial;display:none;background:#fff;position:absolute;min-width:150px;box-shadow:0 0 5px 0 rgba(0,0,0,.24);z-index:2222224}.jodit_context_menu a{display:block;border-bottom:1px solid rgba(204,204,204,.24);text-decoration:none!important;color:#727272}.jodit_context_menu a svg{float:left;display:block;width:18px;height:28px;margin:0 4.5px;fill:#727272}.jodit_context_menu a span{margin-left:27px;display:block;padding:5px;border-left:1px solid rgba(204,204,204,.24);line-height:18px}.jodit_context_menu a:hover{background-color:#e3e3e3;color:#000}.jodit_context_menu a:hover .jodit_icon{fill:#000}.jodit_context_menu a:last-child{border:0}.jodit_context_menu-show{display:block}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_dialog_box{box-sizing:border-box;display:none;width:0;height:0;border:0;position:absolute;will-change:left,top,width,height}.jodit_dialog_box.jodit_dialog_box-moved{-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.jodit_dialog_box *{box-sizing:border-box}.jodit_dialog_box .jodit_elfinder,.jodit_dialog_box .jodit_elfinder *{box-sizing:initial}.jodit_dialog_box .jodit_dialog_overlay{position:fixed;top:0;left:0;width:100%;height:100%;z-index:2222222;text-align:center;white-space:nowrap;overflow:auto;display:none;background-color:rgba(0,0,0,.5)}.jodit_dialog_box.jodit_modal .jodit_dialog_overlay{display:block}.jodit_dialog_box.active{display:block}.jodit_dialog_box .jodit_dialog{z-index:2222223;display:inline-block;vertical-align:middle;white-space:normal;text-align:left;position:fixed;left:0;top:0;background-color:#fff;box-shadow:0 10px 20px rgba(0,0,0,.19),0 6px 6px rgba(0,0,0,.23);min-width:200px;min-height:100px}@media (max-width:480px){.jodit_dialog_box .jodit_dialog{max-width:100%;width:100%!important;height:100%!important;top:0!important;left:0!important}}.jodit_dialog_box .jodit_dialog .jodit_promt{max-width:300px;min-width:200px;padding:10px;word-break:break-all}.jodit_dialog_box .jodit_dialog .jodit_promt label{margin-bottom:5px;display:block}.jodit_dialog_box .jodit_dialog .jodit_promt input[type=text]{display:block;border:1px solid #ccc;background:#fff;width:100%;height:28px;line-height:16px;padding:3px 6px;outline:0}.jodit_dialog_box .jodit_dialog .jodit_alert{max-width:300px;min-width:200px;padding:10px;word-break:break-all}.jodit_dialog_box .jodit_dialog .jodit_button{padding:0;margin:0;border:0;display:inline-block;vertical-align:top;width:32px;height:48px;line-height:48px;text-align:center;cursor:pointer;text-decoration:none}.jodit_dialog_box .jodit_dialog .jodit_button:not(.disabled):hover{background-color:#ecebe9}.jodit_dialog_box .jodit_dialog .jodit_button.disabled{opacity:.7}.jodit_dialog_box .jodit_dialog .jodit_input{border:1px solid #ccc;padding:5px;background-color:#fff;outline:0;width:120px;margin-left:10px;font:13px Arial;height:28px;vertical-align:middle}.jodit_dialog_box .jodit_dialog select.jodit_input{width:75px}.jodit_dialog_box .jodit_dialog .jodit_button .jodit_icon,.jodit_dialog_box .jodit_dialog .jodit_button svg,.jodit_dialog_box .jodit_dialog .jodit_dialog_header .jodit_icon,.jodit_dialog_box .jodit_dialog .jodit_dialog_header svg{width:16px;height:16px;display:inline-block;vertical-align:middle}.jodit_dialog_box .jodit_dialog .jodit_dialog_header{text-align:left;color:#222;box-shadow:0 1px 3px rgba(0,0,0,.16),0 1px 2px rgba(0,0,0,.23);cursor:move;height:48px;overflow:hidden}.jodit_dialog_box .jodit_dialog .jodit_dialog_header .jodit_dialog_header-title{font-size:18px;padding:0;padding-left:20px;margin:0;font-weight:400;line-height:48px;display:inline-block;vertical-align:top}@media (max-width:480px){.jodit_dialog_box .jodit_dialog .jodit_dialog_header .jodit_dialog_header-title{padding-left:0}}.jodit_dialog_box .jodit_dialog .jodit_dialog_header button{margin-right:10px}.jodit_dialog_box .jodit_dialog .jodit_dialog_header .jodit_dialog_header-button{color:#222;font-size:24px;font-weight:700;display:inline-block;transition:background-color .2s ease 0s;width:48px;height:48px;vertical-align:top;line-height:48px;text-decoration:none;text-align:center;float:right}.jodit_dialog_box .jodit_dialog .jodit_dialog_header .jodit_dialog_header-button:hover{background-color:#ecebe9}.jodit_dialog_box .jodit_dialog .jodit_dialog_header .jodit_close svg{width:18px;height:18px;margin:15px 0;vertical-align:top}.jodit_dialog_box .jodit_dialog .jodit_dialog_content{height:calc(100% - 48px);overflow:auto}.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group{margin-bottom:10px;padding:0 10px}.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group:first-child{margin-top:10px}.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group label{display:inline-block;max-width:100%;margin-bottom:5px;font-weight:700}.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input.select,.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input[type=number],.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input[type=text],.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input[type=url],.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select.select,.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select[type=number],.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select[type=text],.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select[type=url]{display:block;height:34px;padding:6px 4px;font-size:14px;line-height:1.42857143;color:#555;background-color:#fff;background-image:none;border:1px solid #ccc;border-radius:0;box-shadow:inset 0 1px 1px rgba(0,0,0,.075);transition:border-color ease-in-out .15s,box-shadow ease-in-out .15s}.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input.select:focus,.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input[type=number]:focus,.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input[type=text]:focus,.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input[type=url]:focus,.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select.select:focus,.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select[type=number]:focus,.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select[type=text]:focus,.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select[type=url]:focus{border-color:#66afe9;outline:0;box-shadow:inset 0 1px 1px rgba(0,0,0,.075),0 0 8px rgba(102,175,233,.6)}.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input.select[disabled],.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input[type=number][disabled],.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input[type=text][disabled],.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input[type=url][disabled],.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select.select[disabled],.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select[type=number][disabled],.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select[type=text][disabled],.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select[type=url][disabled]{background-color:#f0f0f0;color:#ccc}.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input.select:not([class*=col-]),.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input[type=number]:not([class*=col-]),.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input[type=text]:not([class*=col-]),.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group input[type=url]:not([class*=col-]),.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select.select:not([class*=col-]),.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select[type=number]:not([class*=col-]),.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select[type=text]:not([class*=col-]),.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group select[type=url]:not([class*=col-]){width:100%}.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group .jodit_input_group{display:table;border-collapse:separate;width:100%}.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group .jodit_input_group>*{vertical-align:middle;display:table-cell;height:34px}.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group .jodit_input_group>input{float:left;margin:0!important}.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group .jodit_input_group>input:not([class*=col-]){width:100%}.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group .jodit_input_group-buttons{width:1%;font-size:0;white-space:nowrap;vertical-align:middle}.jodit_dialog_box .jodit_dialog .jodit_dialog_content .jodit_form_group .jodit_input_group-buttons>a{text-align:center;display:inline-block;border:1px solid #ccc;margin-left:-1px;position:relative;height:34px;line-height:34px}.jodit_dialog_box .jodit_dialog .jodit_dialog_footer{padding:0 10px;padding-top:10px;text-align:center;height:48px;display:none}.jodit_dialog_box .jodit_dialog .jodit_dialog_footer .jodit_button{width:auto;margin-bottom:10px;height:32px;line-height:100%;padding:0 15px;background-color:#ccc;border:1px solid #ccc;color:#000;font-size:0}.jodit_dialog_box .jodit_dialog .jodit_dialog_footer .jodit_button:before{content:'';display:inline-block;vertical-align:middle;height:100%}.jodit_dialog_box .jodit_dialog .jodit_dialog_footer .jodit_button svg{display:inline-block;width:24px;height:24px;vertical-align:middle}.jodit_dialog_box .jodit_dialog .jodit_dialog_footer .jodit_button span{display:inline-block;vertical-align:middle;font-size:14px;margin-left:5px}.jodit_dialog_box .jodit_dialog .jodit_dialog_footer .jodit_button:focus{border:1px solid #8bade4;outline:1px solid #82b2e8}.jodit_dialog_box .jodit_dialog .jodit_dialog_footer .jodit_button:nth-child(n+2){margin-left:10px}.jodit_dialog_box .jodit_dialog.with_footer .jodit_dialog_content{height:calc(100% - 96px)}.jodit_dialog_box .jodit_dialog.with_footer .jodit_dialog_footer{display:block}.jodit_dialog_box .jodit_dialog .jodit_dialog_resizer{position:absolute;bottom:0;right:0;cursor:se-resize;width:7px;height:7px;display:inline-block;background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAcAAAAHCAYAAADEUlfTAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAADFJREFUeNpilJGRYcACIoB4ORMuCSCOZMIlga4TRQJZJ4YETCdWCSBmZMIlATIOIMAAEyAPt4RnNx0AAAAASUVORK5CYII=)}.jodit_dialog_box .jodit_dialog .jodit_dialog_resizer:hover{border-color:rgba(0,0,0,.6)}@media (max-width:480px){.jodit_dialog_box .jodit_dialog .jodit_dialog_resizer{display:none}}.jodit_dialog_box-fullsize .jodit_dialog{top:0!important;bottom:0!important;left:0!important;right:0!important;width:100%!important;height:100%!important}.jodit_dialog_box-fullsize .jodit_dialog .jodit_dialog_resizer{display:none}@media (max-width:768px){.jodit_dialog_header .jodit_input,.jodit_dialog_header_fullsize,.jodit_dialog_header_title{display:none!important}}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_toolbar_list>.jodit_toolbar{max-height:400px;overflow:auto;box-shadow:0 3px 6px rgba(0,0,0,.16),0 3px 6px rgba(0,0,0,.23);padding:0;margin:auto;text-align:left;position:absolute;box-sizing:border-box;transition:max-height .2s ease 0s;margin-top:0!important;list-style-type:none;font-size:16px;z-index:10000;left:0;top:100%}.jodit_toolbar_list>.jodit_toolbar,.jodit_toolbar_list>.jodit_toolbar .jodit_toolbar{background:#f9f9f9}.jodit_toolbar_list>.jodit_toolbar blockquote,.jodit_toolbar_list>.jodit_toolbar h1,.jodit_toolbar_list>.jodit_toolbar h2,.jodit_toolbar_list>.jodit_toolbar h3,.jodit_toolbar_list>.jodit_toolbar h4,.jodit_toolbar_list>.jodit_toolbar h5,.jodit_toolbar_list>.jodit_toolbar p,.jodit_toolbar_list>.jodit_toolbar pre{font-family:Helvetica,sans-serif,Arial;margin:0;padding:0;font-weight:400}.jodit_toolbar_list>.jodit_toolbar h5{font-size:.8em;line-height:1.4}.jodit_toolbar_list>.jodit_toolbar h3{font-size:1.31em;line-height:1.4}.jodit_toolbar_list>.jodit_toolbar h4,.jodit_toolbar_list>.jodit_toolbar p{font-size:1em;line-height:1.5em}.jodit_toolbar_list>.jodit_toolbar h2{font-size:1.74em;line-height:1.4}.jodit_toolbar_list>.jodit_toolbar h1{font-size:2.17em;line-height:1.4}.jodit_toolbar_list>.jodit_toolbar blockquote,.jodit_toolbar_list>.jodit_toolbar pre{font-family:monospace}.jodit_toolbar_list>.jodit_toolbar li.jodit_toolbar_btn{display:block;cursor:pointer;white-space:nowrap;color:inherit;text-decoration:none;width:100%;height:auto;box-sizing:border-box;text-align:left}.jodit_toolbar_list>.jodit_toolbar li.jodit_toolbar_btn>a{background-image:none;padding:7px 24px;cursor:pointer;line-height:100%;width:auto;height:auto;display:block}.jodit_toolbar_list>.jodit_toolbar li.jodit_toolbar_btn>a>span{display:inline-block}.jodit_toolbar_list>.jodit_toolbar li.jodit_toolbar_btn>a:hover{background-color:#f3f0f0}.jodit_toolbar_list>.jodit_toolbar li.jodit_toolbar_btn>a:after{display:none}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_filebrowser{font-family:Helvetica,sans-serif,Arial;font-size:0;height:100%}.jodit_filebrowser .jodit_filebrowser_loader{height:100%;width:100%;position:absolute;top:0;left:0}.jodit_filebrowser .jodit_filebrowser_loader i{position:absolute;top:50%;left:50%;margin-top:-64px;margin-left:-64px}.jodit_filebrowser .jodit_filebrowser_status{position:absolute;font-size:10px;padding:2px 3px;border-top:1px solid rgba(127,127,127,.4);left:31%;right:0;bottom:0;background-color:#4a4a4a;visibility:hidden;opacity:0;transition:opacity .3s linear;color:#b38888;word-break:break-all}.jodit_filebrowser .jodit_filebrowser_status.success{color:#c5c5c5}.jodit_filebrowser .jodit_filebrowser_status.active{visibility:visible;opacity:1}.jodit_filebrowser .jodit_filebrowser_files,.jodit_filebrowser .jodit_filebrowser_tree{display:none;vertical-align:top;height:100%;position:relative}.jodit_filebrowser .jodit_filebrowser_files.active,.jodit_filebrowser .jodit_filebrowser_tree.active{display:inline-block}.jodit_filebrowser .jodit_filebrowser_files::-webkit-scrollbar,.jodit_filebrowser .jodit_filebrowser_tree::-webkit-scrollbar{width:5px}.jodit_filebrowser .jodit_filebrowser_files::-webkit-scrollbar-track,.jodit_filebrowser .jodit_filebrowser_tree::-webkit-scrollbar-track{-webkit-box-shadow:inset 0 0 6px rgba(0,0,0,.3)}.jodit_filebrowser .jodit_filebrowser_files::-webkit-scrollbar-thumb,.jodit_filebrowser .jodit_filebrowser_tree::-webkit-scrollbar-thumb{background-color:#a9a9a9;outline:1px solid #708090}.jodit_filebrowser .jodit_filebrowser_tree.active{width:31%;background-color:#3f3f3f;overflow-y:auto}@media (max-width:480px){.jodit_filebrowser .jodit_filebrowser_tree.active{display:none}}.jodit_filebrowser .jodit_filebrowser_tree.active::-webkit-scrollbar{width:5px}.jodit_filebrowser .jodit_filebrowser_tree.active::-webkit-scrollbar-track{-webkit-box-shadow:inset 0 0 6px rgba(0,0,0,.3)}.jodit_filebrowser .jodit_filebrowser_tree.active::-webkit-scrollbar-thumb{background-color:rgba(127,127,127,.5);outline:1px solid #708090}.jodit_filebrowser .jodit_filebrowser_tree.active .jodit_filebrowser_source_title{-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;display:block;padding:10px;color:#969696;border-bottom:1px solid #484848;line-height:17px;min-height:38px;position:relative;word-break:break-all;background:#5a5a5a;font-size:16px}.jodit_filebrowser .jodit_filebrowser_tree.active a{display:block;padding:10px 20px;text-decoration:none;color:#b1b1b1;font-weight:600;transition:background-color .2s ease 0s;border-bottom:1px solid #474747;line-height:17px;min-height:38px;position:relative;word-break:break-all;font-size:16px}.jodit_filebrowser .jodit_filebrowser_tree.active a i.remove{height:16px;width:16px;line-height:17px;font-size:16px;position:absolute;right:5px;top:11px;opacity:0;padding-left:3px;display:inline-block}.jodit_filebrowser .jodit_filebrowser_tree.active a i.remove:hover{background:#696969}.jodit_filebrowser .jodit_filebrowser_tree.active a:hover{color:#222;background-color:#ecebe9}.jodit_filebrowser .jodit_filebrowser_tree.active a:hover i.remove{opacity:.6}.jodit_filebrowser .jodit_filebrowser_tree.active a.jodit_button{cursor:pointer;background:#696969;text-align:center;width:auto;height:38px;color:#333}.jodit_filebrowser .jodit_filebrowser_tree.active a.jodit_button svg{vertical-align:top}.jodit_filebrowser .jodit_filebrowser_tree.active a.jodit_button:not(.disabled):hover{background-color:#ecebe9}.jodit_filebrowser .jodit_filebrowser_tree.active a.jodit_button.disabled,.jodit_filebrowser .jodit_filebrowser_tree.active a.jodit_button:hover i{opacity:.7}.jodit_filebrowser .jodit_filebrowser_files.active{width:100%;overflow-y:auto;padding:10px}.jodit_filebrowser .jodit_filebrowser_files.active .jodit_filebrowser_source_title{-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;margin:-10px -10px 0 -10px;display:block;padding:10px;line-height:17px;min-height:38px;position:relative;word-break:break-all;background:#5a5a5a;font-size:16px;color:#969696}.jodit_filebrowser .jodit_filebrowser_files.active a+.jodit_filebrowser_source_title{margin-top:10px}.jodit_filebrowser .jodit_filebrowser_files.active a{vertical-align:top;display:inline-block;width:150px;height:150px;line-height:150px;text-align:center;border:1px solid #ccc;margin:5px 5px 10px 5px;font-size:0;overflow:hidden;transition:border .1s linear,bottom .1s linear;box-sizing:content-box;position:relative}.jodit_filebrowser .jodit_filebrowser_files.active a img{max-width:100%;vertical-align:middle}.jodit_filebrowser .jodit_filebrowser_files.active a:hover{border-color:#433b5c}.jodit_filebrowser .jodit_filebrowser_files.active a.active{border-color:#1e88e5;background-color:#b5b5b5}.jodit_filebrowser .jodit_filebrowser_files.active a .jodit_filebrowser_files_item-info{position:absolute;right:0;left:0;bottom:0;white-space:normal;opacity:.85;overflow:visible;padding:.3em .6em;transition:opacity .4s ease;background-color:#e9e9e9;color:#333;text-shadow:#eee 0 1px 0;font-size:14px;line-height:16px;text-align:left}.jodit_filebrowser .jodit_filebrowser_files.active a .jodit_filebrowser_files_item-info>span{display:block;text-overflow:ellipsis;white-space:nowrap;overflow:hidden;font-size:.75em}.jodit_filebrowser .jodit_filebrowser_files.active a .jodit_filebrowser_files_item-info>span.jodit_filebrowser_files_item-info-filename{font-weight:700;font-size:.9em}.jodit_filebrowser .jodit_filebrowser_files.active a.active .jodit_filebrowser_files_item-info{background-color:#b5b5b5;color:#fff;text-shadow:none}.jodit_filebrowser .jodit_filebrowser_files.active a:hover .jodit_filebrowser_files_item-info{bottom:-100px}.jodit_filebrowser .jodit_filebrowser_files.active.jodit_filebrowser_files_view-list a{display:block;width:100%;height:26px;line-height:26px;margin:0;border-width:0 0 1px 0;text-align:left;white-space:nowrap}.jodit_filebrowser .jodit_filebrowser_files.active.jodit_filebrowser_files_view-list a img{min-width:16px;max-width:16px;vertical-align:middle;display:inline-block;margin-left:4px}.jodit_filebrowser .jodit_filebrowser_files.active.jodit_filebrowser_files_view-list a .jodit_filebrowser_files_item-info{padding:0;position:static;display:inline-block;width:calc(100% - 20px);margin-left:4px;background-color:transparent;height:100%;line-height:inherit;vertical-align:middle;font-size:0}.jodit_filebrowser .jodit_filebrowser_files.active.jodit_filebrowser_files_view-list a .jodit_filebrowser_files_item-info>span{display:inline-block;height:100%;font-size:12px}.jodit_filebrowser .jodit_filebrowser_files.active.jodit_filebrowser_files_view-list a .jodit_filebrowser_files_item-info>span.jodit_filebrowser_files_item-info-filename{width:50%}.jodit_filebrowser .jodit_filebrowser_files.active.jodit_filebrowser_files_view-list a .jodit_filebrowser_files_item-info>span.jodit_filebrowser_files_item-info-filesize{width:25%}.jodit_filebrowser .jodit_filebrowser_files.active.jodit_filebrowser_files_view-list a .jodit_filebrowser_files_item-info>span.jodit_filebrowser_files_item-info-filechanged{width:25%}.jodit_filebrowser .jodit_filebrowser_files.active.jodit_filebrowser_files_view-list a:hover{background-color:#433b5c}.jodit_filebrowser .jodit_filebrowser_files.active.jodit_filebrowser_files_view-list a:hover .jodit_filebrowser_files_item-info{color:#fff;text-shadow:none}.jodit_filebrowser .jodit_filebrowser_files.active.jodit_filebrowser_files_view-list a:before{height:100%;content:'';vertical-align:middle;display:inline-block}.jodit_filebrowser .jodit_filebrowser_tree.active+.jodit_filebrowser_files.active{width:69%}@media (max-width:480px){.jodit_filebrowser .jodit_filebrowser_tree.active+.jodit_filebrowser_files.active{width:auto;display:block}}.jodit_filebrowser_preview{text-align:center;min-width:300px;max-width:900px;max-height:700px;position:relative}.jodit_filebrowser_preview .jodit_filebrowser_preview_navigation{position:absolute;top:0;height:100%;left:0}.jodit_filebrowser_preview .jodit_filebrowser_preview_navigation-next{left:auto;right:0}.jodit_filebrowser_preview .jodit_filebrowser_preview_navigation svg{width:45px;height:45px;position:relative;top:50%;margin-top:-22px;transition:fill .3s linear;fill:#9e9ba7}.jodit_filebrowser_preview .jodit_filebrowser_preview_navigation:hover svg{fill:#000}.jodit_filebrowser_preview img{max-width:100%;max-height:100%}.jodit_draghover{background-color:#ecebe9}.jodit_dialog_box .jodit_dialog .jodit_dialog_header .jodit_dialog_header-title .jodit_upload_button{position:relative;width:220px;border:0;padding:25px 0;margin:10px 0;overflow:hidden}.jodit_dialog_box .jodit_dialog .jodit_dialog_header .jodit_dialog_header-title .jodit_upload_button input{cursor:pointer;position:absolute;top:0;bottom:0;right:0;margin:0 -10px 0 0;padding:0;opacity:0;font-size:400px}.jodit_dialog_box .jodit_dialog .jodit_dialog_header .jodit_dialog_header-title .jodit_toolbar{background:0 0;display:block;height:100%;border:0}.jodit_dialog_box .jodit_dialog .jodit_dialog_header .jodit_dialog_header-title .jodit_toolbar>li.jodit_toolbar_btn{vertical-align:middle}.jodit_dialog_box .jodit_dialog .jodit_dialog_header .jodit_dialog_header-title .jodit_toolbar>li.jodit_toolbar_btn input,.jodit_dialog_box .jodit_dialog .jodit_dialog_header .jodit_dialog_header-title .jodit_toolbar>li.jodit_toolbar_btn select{margin:0 5px;padding-left:10px;width:auto}.jodit_dialog_box .jodit_dialog .jodit_dialog_header .jodit_dialog_header-title.jodit_filebrowser_title_box{padding-left:10px}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_grid{width:100%}.jodit_grid [class*=jodit_col-]{display:block;float:left}.jodit_grid .jodit_col-lg-5-5{width:100%}.jodit_grid .jodit_col-lg-4-5{width:80%}.jodit_grid .jodit_col-lg-3-5{width:60%}.jodit_grid .jodit_col-lg-2-5{width:40%}.jodit_grid .jodit_col-lg-1-5{width:20%}.jodit_grid .jodit_col-lg-4-4{width:100%}.jodit_grid .jodit_col-lg-3-4{width:75%}.jodit_grid .jodit_col-lg-2-4{width:50%}.jodit_grid .jodit_col-lg-1-4{width:25%}.jodit_grid:after,.jodit_grid:before{content:\" \";display:table}.jodit_grid:after{clear:both}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */@keyframes rotate{to{transform:rotate(360deg)}}.jodit_icon-loader{background:url(data:image/png;base64,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) no-repeat center;background-size:100% 100%;width:128px;height:128px;display:inline-block;vertical-align:middle;will-change:transform;animation:rotate 2s ease-out 0s infinite}.jodit_icon{font-style:normal;display:inline-block;width:14px;font-size:8px;vertical-align:middle;fill:#222;transform-origin:0 0!important;overflow:visible}.jodit_text_icon{font-size:14px}.jodit_toolbar_size-small .jodit_icon{min-width:12px;height:12px;line-height:12px}.jodit_toolbar_size-large .jodit_icon{min-width:16px;height:16px;line-height:16px}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_image_editor{width:100%;height:100%;padding:10px;overflow:hidden}@media (max-width:768px){.jodit_image_editor{height:auto}}.jodit_image_editor>div,.jodit_image_editor>div>div{height:100%}@media (max-width:768px){.jodit_image_editor>div,.jodit_image_editor>div>div{height:auto;min-height:200px}}.jodit_image_editor *{box-sizing:border-box}.jodit_image_editor .jodit_image_editor_slider-title{text-shadow:#f3f3f3 0 1px 0;color:#333;border-bottom:1px solid rgba(158,158,158,.31);background-color:#f9f9f9;padding:.8em 1em;text-overflow:ellipsis;white-space:nowrap;cursor:pointer;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;font-weight:700;line-height:1em}.jodit_image_editor .jodit_image_editor_slider-title svg{margin-right:10px;width:16px;display:inline-block;vertical-align:middle}.jodit_image_editor .jodit_image_editor_slider-content{display:none}.jodit_image_editor .jodit_image_editor_slider.active .jodit_image_editor_slider-title{background-color:#5d5d5d;color:#fff;text-shadow:#000 0 1px 0}.jodit_image_editor .jodit_image_editor_slider.active .jodit_image_editor_slider-title svg{fill:#fff}.jodit_image_editor .jodit_image_editor_slider.active .jodit_image_editor_slider-content{display:block}.jodit_image_editor_area{background-color:#eee;background-image:linear-gradient(45deg,#ccc 25%,transparent 25%,transparent 75%,#ccc 75%,#ccc),linear-gradient(45deg,#ccc 25%,transparent 25%,transparent 75%,#ccc 75%,#ccc);background-size:30px 30px;background-position:0 0,15px 15px;height:100%;overflow:hidden;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;position:relative;display:none}.jodit_image_editor_area.active{display:block}.jodit_image_editor_area .jodit_image_editor_box{overflow:hidden;position:relative;z-index:1;pointer-events:none;height:100%}.jodit_image_editor_area .jodit_image_editor_box img{-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;max-width:100%;max-height:100%}.jodit_image_editor_area .jodit_image_editor_croper,.jodit_image_editor_area .jodit_image_editor_resizer{z-index:2;width:100px;height:100px;position:absolute;box-shadow:0 0 11px #000;border:1px solid #fff;background-repeat:no-repeat;top:10px;left:20px;pointer-events:none}.jodit_image_editor_area .jodit_image_editor_croper i.jodit_bottomright,.jodit_image_editor_area .jodit_image_editor_resizer i.jodit_bottomright{position:absolute;display:inline-block;border:1px solid #383838;z-index:4;background-color:#8c7878;cursor:se-resize;border-radius:10px;height:20px;width:20px;right:-10px;bottom:-10px;box-shadow:0 0 11px #000;pointer-events:all}.jodit_image_editor_area .jodit_image_editor_croper i.jodit_bottomright:active,.jodit_image_editor_area .jodit_image_editor_resizer i.jodit_bottomright:active{border:1px solid #ff0}.jodit_image_editor_area.jodit_image_editor_area_crop{height:100%;background:#eee;text-align:center;line-height:100%;position:relative}.jodit_image_editor_area.jodit_image_editor_area_crop:before{content:'';line-height:100%;vertical-align:middle;height:100%;display:inline-block}.jodit_image_editor_area.jodit_image_editor_area_crop .jodit_image_editor_box{height:100%;overflow:visible;display:inline-block;vertical-align:middle;pointer-events:all;font-size:0;text-align:left;line-height:100%}.jodit_image_editor_area.jodit_image_editor_area_crop .jodit_image_editor_box img{max-width:100%;max-height:100%}.jodit_image_editor_area.jodit_image_editor_area_crop .jodit_image_editor_box:before{content:'';line-height:100%;vertical-align:middle;height:100%;display:inline-block}.jodit_image_editor_area.jodit_image_editor_area_crop .jodit_image_editor_box:after{content:'';position:absolute;top:0;left:0;bottom:0;right:0;margin:auto;background:rgba(255,255,255,.3);z-index:1}.jodit_image_editor_area.jodit_image_editor_area_crop .jodit_image_editor_box .jodit_image_editor_croper{pointer-events:all;cursor:move}.jodit_image_editor_area.jodit_image_editor_area_crop .jodit_image_editor_box .jodit_image_editor_croper i.jodit_sizes{font-size:12px;white-space:pre;position:absolute;bottom:-30px;left:100%;text-align:center;color:#fff;text-shadow:none;background:rgba(0,0,0,.2);border-radius:.4em;padding:9px 6px;display:block}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_properties svg{font-style:normal;display:inline-block;width:14px;height:14px;line-height:14px;font-size:8px;overflow:hidden;vertical-align:middle;fill:#222;transform-origin:0 0!important}.jodit_properties #tabsbox{padding:10px}.jodit_properties #tabsbox .jodit_form_group{padding:0}.jodit_properties .jodit_properties_view_box{padding:10px}.jodit_properties .jodit_properties_view_box .jodit_properties_image_view{height:150px;text-align:center;line-height:1;vertical-align:middle;padding:0;background-color:#f6f6f6;margin:0;vertical-align:baseline;font-size:100%;margin-bottom:10px}.jodit_properties .jodit_properties_view_box .jodit_properties_image_view:before{content:'';display:inline-block;vertical-align:middle;height:100%}.jodit_properties .jodit_properties_view_box .jodit_properties_image_view img{max-width:100%;max-height:100%;vertical-align:middle}.jodit_properties .jodit_properties_view_box .jodit_properties_image_sizes.jodit_form_group{padding:0!important;margin:0!important}.jodit_properties .jodit_properties_view_box .jodit_properties_image_sizes.jodit_form_group a{display:inline-block;cursor:pointer}.jodit_properties .jodit_properties_view_box .jodit_properties_image_sizes.jodit_form_group input[type=number]{display:inline-block!important;width:calc(50% - 8px)!important}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_toolbar,.jodit_toolbar *{box-sizing:border-box}.jodit_toolbar{position:relative;left:0;top:0;margin:0!important;padding:0!important;list-style:none!important;font-size:0;background:#f9f9f9;box-shadow:0 4px 4px -2px rgba(0,0,0,.14);z-index:5;border:1px solid #ccc;border-bottom:0;min-height:16px!important}.jodit_toolbar+.jodit_toolbar_dummy{display:none}.jodit_toolbar.jodit_fly{position:absolute;left:0;right:0;z-index:30000;background:#fff}.jodit_toolbar.jodit_sticky{position:fixed;position:-webkit-sticky;position:sticky;z-index:3;top:0;left:auto}.jodit_toolbar.jodit_sticky+.jodit_toolbar_dummy{display:block}.jodit_toolbar .jodit_toolbar_btn>a{color:#000;text-decoration:none;display:block;background:no-repeat center center}.jodit_toolbar>li.jodit_toolbar_btn{display:inline-block;vertical-align:top;margin:0!important;padding:0;list-style:none!important;outline:0;position:relative;text-align:center;cursor:pointer;transition:background-color .2s linear,opacity .1s linear}.jodit_toolbar>li.jodit_toolbar_btn.jodit_disabled{background-color:transparent!important;opacity:.3;cursor:default}.jodit_toolbar>li.jodit_toolbar_btn.jodit_disabled a{cursor:default}.jodit_toolbar>li.jodit_toolbar_btn.jodit_toolbar_btn-separator{border-left:0;border-right:1px solid #e6e6e6;padding:0;margin:2px 3px 0!important;cursor:default}.jodit_toolbar>li.jodit_toolbar_btn.jodit_toolbar_btn-break{display:block!important;width:auto;border-top:1px solid #e6e6e6;height:0;margin:0 3px!important}.jodit_toolbar>li.jodit_toolbar_btn .jodit_toolbar_btn>a,.jodit_toolbar>li.jodit_toolbar_btn>a{width:100%;height:100%;display:inline-block;outline:0;text-decoration:none}.jodit_toolbar>li.jodit_toolbar_btn .jodit_toolbar_btn>a:after,.jodit_toolbar>li.jodit_toolbar_btn>a:after{content:'';display:inline-block;height:100%;vertical-align:middle}.jodit_toolbar>li.jodit_toolbar_btn .jodit_toolbar_btn>a:active+.jodit_tooltip,.jodit_toolbar>li.jodit_toolbar_btn>a:active+.jodit_tooltip{visibility:hidden!important}.jodit_toolbar>li.jodit_toolbar_btn.jodit_disabled .jodit_tooltip{display:none!important}.jodit_toolbar>li.jodit_toolbar_btn>a{line-height:100%}.jodit_toolbar>li.jodit_toolbar_btn .jodit_popap_open,.jodit_toolbar>li.jodit_toolbar_btn.jodit_dropdown_open .jodit_tooltip,.jodit_toolbar>li.jodit_toolbar_btn.jodit_popup_open .jodit_tooltip{visibility:hidden!important}.jodit_toolbar>li.jodit_toolbar_btn:not(.jodit_toolbar-input):hover{background-color:#dde4ef;outline:0}.jodit_toolbar>li.jodit_toolbar_btn.jodit_active,.jodit_toolbar>li.jodit_toolbar_btn:not(.jodit_toolbar-input):active{background-color:rgba(221,221,221,.4);outline:0}.jodit_toolbar>li.jodit_toolbar_btn.jodit-btn-hidden{display:none!important}.jodit_toolbar>li.jodit_toolbar_btn.jodit_with_dropdownlist .jodit_with_dropdownlist-trigger{width:0;height:0;border-right:3px solid transparent;border-left:3px solid transparent;border-top:3px solid #4c4c4c;display:inline-block;vertical-align:middle;margin-left:3px}.jodit_toolbar>li.jodit_toolbar_btn.jodit_toolbar-input input,.jodit_toolbar>li.jodit_toolbar_btn.jodit_toolbar-input select{-webkit-appearance:none;-moz-appearance:none;appearance:none;height:100%;border-radius:0;outline:0;line-height:100%}.jodit_toolbar>li.jodit_toolbar_btn.jodit_toolbar-input select{padding-right:20px;background:url(data:image/svg+xml;base64,PHN2ZyBpZD0iTGF5ZXJfMSIgZGF0YS1uYW1lPSJMYXllciAxIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCA0Ljk1IDEwIj48ZGVmcz48c3R5bGU+LmNscy0xe2ZpbGw6I2ZmZjt9LmNscy0ye2ZpbGw6IzQ0NDt9PC9zdHlsZT48L2RlZnM+PHRpdGxlPmFycm93czwvdGl0bGU+PHJlY3QgY2xhc3M9ImNscy0xIiB3aWR0aD0iNC45NSIgaGVpZ2h0PSIxMCIvPjxwb2x5Z29uIGNsYXNzPSJjbHMtMiIgcG9pbnRzPSIxLjQxIDQuNjcgMi40OCAzLjE4IDMuNTQgNC42NyAxLjQxIDQuNjciLz48cG9seWdvbiBjbGFzcz0iY2xzLTIiIHBvaW50cz0iMy41NCA1LjMzIDIuNDggNi44MiAxLjQxIDUuMzMgMy41NCA1LjMzIi8+PC9zdmc+) no-repeat 98% 50%!important}.jodit_toolbar>li{min-width:32px;height:32px;line-height:32px}.jodit_toolbar>li.jodit_toolbar_btn-separator{height:28px;width:0;min-width:0}.jodit_tooltip{position:fixed;background:#727171;color:#fff;font-size:12px;line-height:15px;padding:4px 5px;font-family:Arial,sans-serif;z-index:10001;width:90px;transition:opacity .3s linear}@media (max-width:768px){.jodit_tooltip{display:none}}.jodit_toolbar_size-small .jodit_toolbar{min-height:12px!important}.jodit_toolbar_size-small .jodit_toolbar>li{min-width:24px;height:24px;line-height:24px}.jodit_toolbar_size-small .jodit_toolbar>li.jodit_toolbar_btn-separator{height:20px;width:0;min-width:0}.jodit_toolbar_size-large .jodit_toolbar{min-height:18px!important}.jodit_toolbar_size-large .jodit_toolbar>li{min-width:36px;height:36px;line-height:36px}.jodit_toolbar_size-large .jodit_toolbar>li.jodit_toolbar_btn-separator{height:32px;width:0;min-width:0}.jodit_toolbar_popup{position:absolute;z-index:10;top:100%;margin-top:10px;padding-top:0;left:0;font-size:14px;line-height:14px!important;background:#fff;box-shadow:0 2px 4px rgba(0,0,0,.2);border:1px solid rgba(0,0,0,.2)}.jodit_toolbar_popup .jodit_toolbar{box-shadow:none;border-width:0;background-color:transparent}.jodit_toolbar_popup .jodit_toolbar .jodit_toolbar{background-color:#f9f9f9;box-shadow:0 4px 4px -2px rgba(0,0,0,.14);border:1px solid #ccc}.jodit_toolbar_popup>*{margin:10px}.jodit_toolbar_popup .jodit_popup_triangle{padding:0;margin:0;width:8px;height:8px;position:absolute;top:-5px;left:9px;display:inline-block;transform:rotate(45deg);background:#fff;border:1px solid rgba(0,0,0,.2);border-width:1px 0 0 1px;z-index:6}.jodit_toolbar_popup.jodit_right{left:auto;right:0}.jodit_toolbar_popup.jodit_right:before{left:auto;right:14px}.jodit_toolbar .jodit_toolbar_btn>svg{max-width:50%;vertical-align:middle;font-smoothing:antialiased}.jodit_container>.jodit_toolbar>li:first-child{margin-left:2px!important}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_draganddrop_file_box,.jodit_uploadfile_button{position:relative;width:220px;border:dashed 1px #ccc;padding:25px 0;margin:10px 0;text-align:center;overflow:hidden}.jodit_draganddrop_file_box:hover,.jodit_uploadfile_button:hover{background-color:#ecebe9}.jodit_draganddrop_file_box input,.jodit_uploadfile_button input{cursor:pointer;position:absolute;top:0;bottom:0;right:0;margin:0;padding:0;opacity:0;font-size:400px}@media (max-width:768px){.jodit_draganddrop_file_box{width:auto;max-width:100%;min-width:120px}}.jodit_statusbar{border:1px solid #ccc;border-top:0;font-size:0;background-color:#f9f9f9;padding:0 5px}.jodit_statusbar .jodit_statusbar_item{font-size:11px;float:left;line-height:1.57142857em;margin:0 10px 0 0;padding:0;vertical-align:middle}.jodit_statusbar .jodit_statusbar_item.jodit_statusbar_item-right{float:right;margin:0 0 0 10px}.jodit_statusbar .jodit_statusbar_item li,.jodit_statusbar .jodit_statusbar_item ul{margin:0;padding:0;list-style:none;display:inline-block;vertical-align:top;position:relative}.jodit_statusbar .jodit_statusbar_item li li,.jodit_statusbar .jodit_statusbar_item ul li{margin-right:5px}.jodit_statusbar .jodit_statusbar_item a,.jodit_statusbar .jodit_statusbar_item span{-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;display:inline-block;vertical-align:baseline;text-align:left;white-space:nowrap;padding:2px 3px;line-height:10px;outline:0;border:0;color:#222}.jodit_statusbar .jodit_statusbar_item a span,.jodit_statusbar .jodit_statusbar_item span span{padding:0}.jodit_statusbar .jodit_statusbar_item svg{width:11px;height:11px;display:inline-block;vertical-align:top}.jodit_statusbar .jodit_statusbar_item a{text-decoration:none;cursor:default;border-radius:3px}.jodit_statusbar .jodit_statusbar_item a:hover{background-color:rgba(225,225,225,.99);text-decoration:none;color:#222}.jodit_statusbar:after{content:' ';display:block;visibility:hidden;font-size:0;height:0;float:none;clear:both}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_form{color:#000}.jodit_form input[type=text],.jodit_form input[type=url],.jodit_form textarea{-webkit-appearance:none;-moz-appearance:none;display:block;outline:0;border:1px solid #b5b5b5;height:28px;line-height:28px;padding:0 5px;min-width:220px;margin-top:10px}.jodit_form input[type=text].jodit_error,.jodit_form input[type=url].jodit_error,.jodit_form textarea.jodit_error{border-color:#f7d1d1;box-shadow:inset 0 0 3px 0 rgba(189,189,189,.3)}@media (max-width:768px){.jodit_form input[type=text],.jodit_form input[type=url],.jodit_form textarea{min-width:150px}}.jodit_form textarea{height:128px}.jodit_form button{height:36px;line-height:1;color:#000;padding:10px;cursor:pointer;text-decoration:none;border:none;background:#d6d6d6;font-size:16px;outline:0;transition:background .2s ease 0s;margin-top:10px;margin-bottom:10px}.jodit_form button:hover{background-color:#ecebe9;color:#000}.jodit_form button:active{background:#ecebe9;color:#000}.jodit_form input[type=checkbox]{display:inline-block;z-index:2;border:0 none;cursor:pointer;height:16px;margin:0;padding:0;width:16px;position:relative;outline:0;top:3px}.jodit_form input[type=checkbox]:after{content:'';background:#fff;border:solid 1px rgba(225,225,225,.99);border-radius:2px;background-clip:padding-box;width:16px;height:16px;display:inline-block;position:relative;z-index:1;box-sizing:border-box;transition:background .2s ease 0s,border-color .2s ease 0s}.jodit_form input[type=checkbox]:checked:after{background:url(\"data:image/svg+xml,%3Csvg%20xmlns%3D'http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg'%20viewBox%3D%220%200%2032%2032%22%3E%0A%20%20%20%20%3Cpath%20d%3D%22M27%204l-15%2015-7-7-5%205%2012%2012%2020-20z%22%20fill%3D%22%23FFFFFF%22%2F%3E%0A%3C%2Fsvg%3E\") no-repeat center center;background-color:#b5b5b5;border-color:#b5b5b5}.jodit_form label{margin-top:10px;display:block;text-align:left}.jodit_form form:after{content:\"\";display:table;clear:both}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_about{padding:20px}.jodit_about a{color:#459ce7;text-decoration:none}.jodit_about a:focus,.jodit_about a:hover{color:#23527c;text-decoration:underline;outline:0}.jodit_about div{margin-bottom:5px}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_colorpicker{min-width:180px;text-align:left;margin:0;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.jodit_colorpicker .jodit_colorpicker_group{margin-bottom:5px;white-space:normal}.jodit_colorpicker a{width:18px;height:18px;line-height:16px;display:inline-block;text-decoration:none;vertical-align:middle;text-align:center}.jodit_colorpicker a.jodit_text_icon{width:auto;text-decoration:none;color:#000}.jodit_colorpicker a:before{content:'';display:inline-block;height:100%;vertical-align:middle;width:0}.jodit_colorpicker a svg{display:inline-block;vertical-align:middle;font-smoothing:antialiased;max-width:14px}.jodit_colorpicker a:hover{border-color:#000}.jodit_colorpicker a:active{background:#d6d6d6;color:#b5b5b5}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */@keyframes pulse{30%{opacity:.6}60%{opacity:0}to{opacity:.6}}.jodit_progress_bar{position:absolute;top:0;left:0;height:2px;z-index:2147483647;border-radius:1px;display:none}.jodit_progress_bar div{position:relative;background:#b91f1f;height:2px;transition:width .5s ease-out,opacity .5s linear;will-change:width,opacity}.jodit_progress_bar div:after,.jodit_progress_bar div:before{animation:pulse 2s ease-out 0s infinite;content:'';display:inline-block;position:absolute;top:0;height:2px;box-shadow:#b91f1f 1px 0 6px 1px;border-radius:100%;opacity:.6}.jodit_progress_bar div:before{width:180px;right:-80px;clip:rect(-6px,90px,14px,-6px)}.jodit_progress_bar div:after{width:20px;right:0;clip:rect(-6px,22px,14px,10px)}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_tabs .jodit_tabs_buttons{line-height:18px;margin-bottom:5px;margin-top:4px}.jodit_tabs .jodit_tabs_buttons>a{display:inline-block;text-decoration:none;font-size:11px;font-weight:700;text-align:center;white-space:nowrap;height:29px;line-height:27px;position:relative;vertical-align:middle;transition:background .1s linear;text-overflow:ellipsis;overflow:hidden;box-shadow:none;background-color:#f5f5f5;color:#737373;border:1px solid rgba(0,0,0,.1);outline:0}@media (max-width:768px){.jodit_tabs .jodit_tabs_buttons>a{width:100%!important;border-radius:0!important}}.jodit_tabs .jodit_tabs_buttons>a+a{margin-left:-1px}.jodit_tabs .jodit_tabs_buttons>a i,.jodit_tabs .jodit_tabs_buttons>a svg{width:16px;height:16px;display:inline-block;vertical-align:sub;margin-right:5px;fill:#737373}.jodit_tabs .jodit_tabs_buttons>a:hover{border:1px solid #c6c6c6;color:#111;box-shadow:none;background-color:#f8f8f8;outline:0}.jodit_tabs .jodit_tabs_buttons>a:hover i,.jodit_tabs .jodit_tabs_buttons>a:hover svg{fill:#111}.jodit_tabs .jodit_tabs_buttons>a.active,.jodit_tabs .jodit_tabs_buttons>a:active{outline:0;background:#fff;border:1px solid #ccc;color:#333}.jodit_tabs .jodit_tabs_buttons>a.active i,.jodit_tabs .jodit_tabs_buttons>a.active svg,.jodit_tabs .jodit_tabs_buttons>a:active i,.jodit_tabs .jodit_tabs_buttons>a:active svg{fill:#333}.jodit_tabs .jodit_tabs_wrapper .jodit_tab{display:none}.jodit_tabs .jodit_tabs_wrapper .jodit_tab.active{display:block}.jodit_tabs .jodit_tabs_wrapper .jodit_tab .jodit_tab_empty{min-width:220px;min-height:100px}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit-add-new-line{box-sizing:border-box;z-index:1;position:absolute;height:20px;line-height:100%;vertical-align:middle;font-size:0;top:0;outline:0;margin-top:-10px;display:none}.jodit-add-new-line *{box-sizing:border-box}.jodit-add-new-line:before{height:100%;display:inline-block;vertical-align:middle;content:''}.jodit-add-new-line:after{box-sizing:border-box;vertical-align:middle;content:'';border-top:1px solid #ccc;height:1px;display:inline-block;width:calc(100% - 30px)}.jodit-add-new-line span{right:0;position:absolute;display:inline-block;width:30px;height:20px;background:rgba(236,235,233,.3);vertical-align:top;border:1px solid #ccc;padding:0 5px;cursor:pointer}.jodit-add-new-line span:hover{background:#ecebe9}.jodit-add-new-line svg{width:16px;fill:#ccc;vertical-align:top}.jodit_source_mode .jodit-add-new-line{display:none!important}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_error_box_for_messages{position:absolute;right:0;bottom:0;width:0;height:0;overflow:visible;z-index:3}.jodit_error_box_for_messages>*{position:absolute;right:5px;bottom:0;display:block;transition:opacity .1s linear,bottom .3s linear;opacity:0;background:rgba(255,0,0,.29);color:#e02b2b;padding:2px 7px;border:1px solid rgba(226,117,117,.44);font-size:14px;white-space:pre}.jodit_error_box_for_messages>.active{opacity:1}.jodit_error_box_for_messages>.info{background:rgba(204,229,247,.71);color:#776565;border:1px solid rgba(154,154,154,.44)}.jodit_error_box_for_messages>.success{background:rgba(77,236,112,.29);color:#5d5a5a;border:1px solid rgba(148,148,148,.44)}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_fullsize_box{z-index:100000!important;position:static!important;overflow:visible!important}body.jodit_fullsize_box,html.jodit_fullsize_box{height:0!important;width:0!important;overflow:initial!important}html.jodit_fullsize_box{position:fixed!important}.jodit_fullsize{position:absolute;top:0;left:0;right:0;bottom:0;z-index:100000;max-width:none!important}.jodit_fullsize .toolbar{width:100%!important}.jodit_fullsize .jodit_area,.jodit_fullsize .jodit_editor{height:100%}.jodit_fullsize .jodit_workflow{height:calc(100% - 24px);overflow:auto}.jodit_fullsize.jodit_toolbar_size-small .jodit_workflow{height:calc(100% - 18px)}.jodit_fullsize.jodit_toolbar_size-large .jodit_workflow{height:calc(100% - 27px)}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_placeholder{-webkit-user-select:none!important;-moz-user-select:none!important;-ms-user-select:none!important;user-select:none!important;top:0;left:0;display:block;position:absolute;padding:10px;color:rgba(0,0,0,.35);z-index:1;pointer-events:none}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_toolbar_popup-inline-target{position:absolute;width:0;height:0}.jodit_toolbar_popup-inline-target.jodit_toolbar_popup-inline-target-hidden{display:none}.jodit_toolbar_popup-inline{display:inline-block!important;position:relative!important}.jodit_toolbar_popup-inline>div{color:rgba(225,225,225,.99);background:#fff;box-shadow:none;background-clip:padding-box;font-family:Helvetica,sans-serif,Arial;box-sizing:border-box;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;z-index:100001!important;text-align:left;border:1px solid rgba(225,225,225,.99);display:inline-block;vertical-align:top}.jodit_toolbar_popup-inline .jodit_toolbar{z-index:7;border:0;white-space:normal}.jodit_toolbar_popup-inline>div>.jodit_toolbar{white-space:nowrap;box-shadow:none;vertical-align:top}.jodit_toolbar_popup-inline>.jodit_popup_triangle{padding:0;margin:0;width:8px;height:8px;position:absolute;top:-4px;margin-left:-4px;display:inline-block;transform:rotate(45deg);background:#fff;border:1px solid rgba(225,225,225,.99);border-width:1px 0 0 1px;z-index:6}.jodit_toolbar_popup-inline.jodit_toolbar_popup-inline-top>.jodit_popup_triangle{top:auto;bottom:-4px;border-width:0 1px 1px 0}.jodit_toolbar_popup-inline .buttons{box-shadow:0 1px 3px rgba(0,0,0,.12),0 1px 2px rgba(0,0,0,.24);padding:0 2px;white-space:nowrap;line-height:0;border-bottom:0}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */[data-jodit_iframe_wrapper]{display:block;clear:both;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;position:relative}[data-jodit_iframe_wrapper]:after{position:absolute;content:'';z-index:1;top:0;left:0;right:0;bottom:0;cursor:pointer;display:block;background:rgba(0,0,0,0)}.jodit_resizer{width:100px;height:100px;position:absolute;border:1px solid rgba(3,14,82,.92);top:0;left:0;display:none;pointer-events:none;font-size:0}.jodit_resizer *{box-sizing:border-box}.jodit_resizer>span{position:absolute;display:inline-block;opacity:0;transition:opacity .2s linear;left:50%;top:50%;height:24px;line-height:24px;font-size:12px;width:70px;margin-left:-35px;margin-top:-12px;text-align:center;overflow:visible;color:#fff;background-color:rgba(0,0,0,.35);max-width:100%}.jodit_resizer>i{position:absolute;display:inline-block;z-index:4;pointer-events:all;border:1px solid rgba(3,14,82,.92);background-color:rgba(225,225,225,.99);width:10px;height:10px}.jodit_resizer>i:hover{background-color:#f8f8f8}.jodit_resizer>i:nth-child(1){left:-5px;top:-5px;cursor:nw-resize}.jodit_resizer>i:nth-child(2){right:-5px;top:-5px;cursor:ne-resize}.jodit_resizer>i:nth-child(3){right:-5px;bottom:-5px;cursor:se-resize}.jodit_resizer>i:nth-child(4){left:-5px;bottom:-5px;cursor:sw-resize}@media (max-width:768px){.jodit_resizer>i{width:20px;height:20px}.jodit_resizer>i:nth-child(1){left:-10px;top:-10px;cursor:nw-resize}.jodit_resizer>i:nth-child(2){right:-10px;top:-10px;cursor:ne-resize}.jodit_resizer>i:nth-child(3){right:-10px;bottom:-10px;cursor:se-resize}.jodit_resizer>i:nth-child(4){left:-10px;bottom:-10px;cursor:sw-resize}}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_container{min-height:100px}.jodit_container .jodit_workplace{display:-ms-flexbox;display:flex;height:auto;min-height:50px;overflow:hidden}.jodit_editor_resize{position:relative}.jodit_editor_resize a{position:absolute;bottom:0;right:0;-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;width:0;height:0;overflow:hidden;border-width:7px 7px 0 0;border-color:transparent #ccc transparent transparent;border-style:dashed solid dashed dashed;cursor:se-resize}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_source{display:none;position:relative;background-color:#f8f8f8;font-size:0;min-height:100%;-ms-flex:1;flex:1;overflow:auto}.jodit_source .jodit_source_mirror-fake{min-height:100%}.jodit_container.jodit_source_mode .jodit_wysiwyg,.jodit_container.jodit_source_mode .jodit_wysiwyg_iframe{display:none!important}.jodit_container.jodit_source_mode .jodit_source{display:block!important}.jodit_container.jodit_split_mode .jodit_source,.jodit_container.jodit_split_mode .jodit_wysiwyg,.jodit_container.jodit_split_mode .jodit_wysiwyg_iframe{display:block!important;width:50%;-ms-flex:1;flex:1}.jodit_source_mirror{border:0;width:100%;background:#3f3f3f;margin:0;height:100%;box-shadow:none;resize:none;box-sizing:border-box;color:#f0f0f0;outline:0;font-family:Menlo,Monaco,monospace,sans-serif;font-size:13px;line-height:1.3em;z-index:2;padding:10px;overflow:auto;white-space:pre-wrap;-moz-tab-size:2em;-o-tab-size:2em;tab-size:2em;min-height:100%}.jodit_source_mirror::-moz-selection{background:#bdbdbd}.jodit_source_mirror::selection{background:#bdbdbd}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_table_resizer{cursor:col-resize;position:absolute;z-index:3;padding-left:5px;padding-right:5px;margin-left:-5px}.jodit_table_resizer:after{content:'';display:block;height:100%;width:0;border:1px solid transparent;border-width:0 1px 0 0}.jodit_table_resizer-moved{z-index:2}.jodit_table_resizer-moved:after{border-color:#1e88e5}.jodit_wysiwyg table{width:100%;border:none;border-collapse:collapse;table-layout:fixed;empty-cells:show;max-width:100%}.jodit_wysiwyg table tr{-webkit-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none}.jodit_wysiwyg table tr td,.jodit_wysiwyg table tr th{border:1px solid #ddd;text-align:left;vertical-align:middle;-webkit-user-select:text;-moz-user-select:text;-ms-user-select:text;user-select:text}.jodit_wysiwyg table tr td[data-jodit-selected-cell],.jodit_wysiwyg table tr th[data-jodit-selected-cell]{border:1px double #1e88e5}.jodit_form_inserter .jodit_form-table-creator-box{font-size:0}.jodit_form_inserter .jodit_form-table-creator-box .jodit_form-container{display:inline-block;vertical-align:top;padding:0;margin:0;min-width:180px;font-size:0}.jodit_form_inserter .jodit_form-table-creator-box .jodit_form-container>div{width:18px;height:18px;box-sizing:border-box;display:inline-block;position:relative;vertical-align:top}.jodit_form_inserter .jodit_form-table-creator-box .jodit_form-container>div:after{content:'';position:absolute;top:0;left:0;display:inline-block;width:12px;height:12px;border:1px solid #ccc}.jodit_form_inserter .jodit_form-table-creator-box .jodit_form-container>div.hovered:after{background:#7a450f;border:solid 1px #b5b5b5}.jodit_form_inserter .jodit_form-table-creator-box .jodit_form-options{font-size:14px;display:inline-block;vertical-align:top}.jodit_form_inserter .jodit_form-table-creator-box .jodit_form-options label{text-align:left;padding-top:0}.jodit_form_inserter .jodit_form-table-creator-box .jodit_form-options label input{margin-right:10px}.jodit_form_inserter label{text-align:center;font-size:14px;padding:8px;display:block;margin:0}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_text_icons .jodit_icon{width:auto;font-size:14px}.jodit_text_icons .jodit_icon::first-letter{text-transform:uppercase}.jodit_text_icons .jodit_tabs .jodit_tabs_buttons>a{font-family:Helvetica,sans-serif,Arial;width:auto}.jodit_text_icons .jodit_tabs .jodit_tabs_buttons>a i{width:auto}.jodit_text_icons .jodit_toolbar>li{width:auto}.jodit_text_icons .jodit_toolbar>li>a{padding:0 12px;font-family:Helvetica,sans-serif,Arial;width:auto;text-decoration:none;color:rgba(0,0,0,.75)}.jodit_text_icons.jodit_dialog_box .jodit_dialog .jodit_button,.jodit_text_icons.jodit_dialog_box .jodit_dialog .jodit_dialog_header a{width:auto;padding:0 12px;font-family:Helvetica,sans-serif,Arial;color:rgba(0,0,0,.75)}.jodit_text_icons.jodit_dialog_box .jodit_dialog .jodit_button .jodit_icon,.jodit_text_icons.jodit_dialog_box .jodit_dialog .jodit_dialog_header a .jodit_icon{width:auto}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_widget{box-sizing:border-box}.jodit_widget *{box-sizing:border-box}/*!\n * Jodit Editor (https://xdsoft.net/jodit/)\n * License https://xdsoft.net/jodit/license.html\n * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net\n */.jodit_search{visibility:hidden;position:absolute;top:0;right:0;width:0;height:0}.jodit_search.jodit_search-active{visibility:visible}.jodit_search .jodit_search_box{width:320px;position:absolute;right:0;background-color:#f9f9f9;border:1px solid #ccc;border-width:0 0 1px 1px;padding:5px}.jodit_search .jodit_search_box input{margin:0;width:100%;height:100%;border:0;background-color:transparent;outline:0;padding:0 10px}.jodit_search .jodit_search_box input.jodit_search-replace{display:none}.jodit_search .jodit_search_box .jodit_search_buttons,.jodit_search .jodit_search_box .jodit_search_counts,.jodit_search .jodit_search_box .jodit_search_inputs{height:30px;display:inline-block;vertical-align:top}.jodit_search .jodit_search_box .jodit_search_inputs{width:60%;padding-right:5px}.jodit_search .jodit_search_box .jodit_search_counts{width:15%;line-height:100%;text-align:center;color:#ccc;border-left:1px solid #ccc}.jodit_search .jodit_search_box .jodit_search_counts:before{content:'';display:inline-block;vertical-align:middle;height:100%}.jodit_search .jodit_search_box .jodit_search_counts span{display:inline-block;vertical-align:middle}.jodit_search .jodit_search_box .jodit_search_buttons{padding-left:0;width:25%}.jodit_search .jodit_search_box .jodit_search_buttons button{outline:0;width:32%;padding:1px 5px;margin-right:1%;transition:transform .1s linear;height:100%;border:1px solid transparent;background-color:transparent}.jodit_search .jodit_search_box .jodit_search_buttons button.jodit_search_buttons-replace{width:100%;border:1px solid #ccc;margin-top:2px;display:none}.jodit_search .jodit_search_box .jodit_search_buttons button:hover{background-color:#ecebe9}.jodit_search .jodit_search_box .jodit_search_buttons button:focus{border:1px solid rgba(181,214,253,.5)}.jodit_search .jodit_search_box .jodit_search_buttons button:active{border:1px solid #b5d6fd;transform:scale(.95,.95)}.jodit_search.jodit_search-and-replace .jodit_search_counts,.jodit_search.jodit_search-and-replace .jodit_search_inputs{height:60px}.jodit_search.jodit_search-and-replace .jodit_search_counts input,.jodit_search.jodit_search-and-replace .jodit_search_inputs input{height:50%;transition:background-color .1s linear}.jodit_search.jodit_search-and-replace .jodit_search_counts input:focus,.jodit_search.jodit_search-and-replace .jodit_search_inputs input:focus{box-shadow:inset 0 0 3px 0 rgba(204,204,204,.58)}.jodit_search.jodit_search-and-replace .jodit_search_buttons button.jodit_search_buttons-replace,.jodit_search.jodit_search-and-replace .jodit_search_inputs input.jodit_search-replace{display:block}@media (max-width:320px){.jodit_search{width:100%}.jodit_search .jodit_search_box{width:100%}}.jodit_symbols{width:460px;padding:10px}.jodit_symbols .jodit_symbols-container_preview,.jodit_symbols .jodit_symbols-container_table{display:inline-block;vertical-align:top}.jodit_symbols .jodit_symbols-container_table{width:88%}.jodit_symbols .jodit_symbols-container_preview{width:12%}.jodit_symbols .jodit_symbols-container_preview .jodit_symbols-preview{font-size:34px;text-align:center;padding:20px 0;border:1px solid #ccc}.jodit_symbols table{border:0;border-spacing:0;table-layout:fixed}.jodit_symbols table td{padding:0}.jodit_symbols table td a{font-size:16px;text-decoration:none;color:#000;display:inline-block;box-sizing:border-box;width:21.6px;height:21.6px;border:1px solid transparent;text-align:center;line-height:21.6px;vertical-align:top}.jodit_symbols table td a:focus,.jodit_symbols table td a:hover{border:1px solid #1e88e5}.jodit_sticky-dummy_toolbar{display:none}.jodit_sticky>.jodit_toolbar{position:fixed;z-index:3;top:0;left:auto}.jodit_sticky .jodit_sticky-dummy_toolbar{display:block}.jodit_paste_storage{padding:10px;max-width:600px}@media (max-width:768px){.jodit_paste_storage{max-width:100%}}.jodit_paste_storage>div{max-width:100%;max-height:300px;border:1px solid #ccc}.jodit_paste_storage>div:first-child{margin-bottom:10px}.jodit_paste_storage>div:first-child a{outline:0;box-sizing:border-box;display:block;max-width:100%;white-space:pre;overflow:hidden;text-overflow:ellipsis;padding:5px;margin:0;border:1px solid transparent;text-decoration:none;color:#000}.jodit_paste_storage>div:first-child a.jodit_active{color:#fff;background-color:#575757}.jodit_paste_storage>div:first-child a:focus{outline:0}.jodit_paste_storage>div:last-child{padding:10px;overflow:auto}.jodit_paste_storage>div:last-child li,.jodit_paste_storage>div:last-child ul{margin:0}"],"sourceRoot":""}]);

// exports


/***/ }),
/* 24 */
/***/ (function(module, exports) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/
// css base code, injected by the css-loader
module.exports = function() {
	var list = [];

	// return the list of modules as css string
	list.toString = function toString() {
		var result = [];
		for(var i = 0; i < this.length; i++) {
			var item = this[i];
			if(item[2]) {
				result.push("@media " + item[2] + "{" + item[1] + "}");
			} else {
				result.push(item[1]);
			}
		}
		return result.join("");
	};

	// import a list of modules into the list
	list.i = function(modules, mediaQuery) {
		if(typeof modules === "string")
			modules = [[null, modules, ""]];
		var alreadyImportedModules = {};
		for(var i = 0; i < this.length; i++) {
			var id = this[i][0];
			if(typeof id === "number")
				alreadyImportedModules[id] = true;
		}
		for(i = 0; i < modules.length; i++) {
			var item = modules[i];
			// skip already imported module
			// this implementation is not 100% perfect for weird media query combinations
			//  when a module is imported multiple times with different media queries.
			//  I hope this will never occur (Hey this way we have smaller bundles)
			if(typeof item[0] !== "number" || !alreadyImportedModules[item[0]]) {
				if(mediaQuery && !item[2]) {
					item[2] = mediaQuery;
				} else if(mediaQuery) {
					item[2] = "(" + item[2] + ") and (" + mediaQuery + ")";
				}
				list.push(item);
			}
		}
	};
	return list;
};


/***/ }),
/* 25 */
/***/ (function(module, exports) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/
var stylesInDom = {},
	memoize = function(fn) {
		var memo;
		return function () {
			if (typeof memo === "undefined") memo = fn.apply(this, arguments);
			return memo;
		};
	},
	isOldIE = memoize(function() {
		return /msie [6-9]\b/.test(self.navigator.userAgent.toLowerCase());
	}),
	getHeadElement = memoize(function () {
		return document.head || document.getElementsByTagName("head")[0];
	}),
	singletonElement = null,
	singletonCounter = 0,
	styleElementsInsertedAtTop = [];

module.exports = function(list, options) {
	if(typeof DEBUG !== "undefined" && DEBUG) {
		if(typeof document !== "object") throw new Error("The style-loader cannot be used in a non-browser environment");
	}

	options = options || {};
	// Force single-tag solution on IE6-9, which has a hard limit on the # of <style>
	// tags it will allow on a page
	if (typeof options.singleton === "undefined") options.singleton = isOldIE();

	// By default, add <style> tags to the bottom of <head>.
	if (typeof options.insertAt === "undefined") options.insertAt = "bottom";

	var styles = listToStyles(list);
	addStylesToDom(styles, options);

	return function update(newList) {
		var mayRemove = [];
		for(var i = 0; i < styles.length; i++) {
			var item = styles[i];
			var domStyle = stylesInDom[item.id];
			domStyle.refs--;
			mayRemove.push(domStyle);
		}
		if(newList) {
			var newStyles = listToStyles(newList);
			addStylesToDom(newStyles, options);
		}
		for(var i = 0; i < mayRemove.length; i++) {
			var domStyle = mayRemove[i];
			if(domStyle.refs === 0) {
				for(var j = 0; j < domStyle.parts.length; j++)
					domStyle.parts[j]();
				delete stylesInDom[domStyle.id];
			}
		}
	};
}

function addStylesToDom(styles, options) {
	for(var i = 0; i < styles.length; i++) {
		var item = styles[i];
		var domStyle = stylesInDom[item.id];
		if(domStyle) {
			domStyle.refs++;
			for(var j = 0; j < domStyle.parts.length; j++) {
				domStyle.parts[j](item.parts[j]);
			}
			for(; j < item.parts.length; j++) {
				domStyle.parts.push(addStyle(item.parts[j], options));
			}
		} else {
			var parts = [];
			for(var j = 0; j < item.parts.length; j++) {
				parts.push(addStyle(item.parts[j], options));
			}
			stylesInDom[item.id] = {id: item.id, refs: 1, parts: parts};
		}
	}
}

function listToStyles(list) {
	var styles = [];
	var newStyles = {};
	for(var i = 0; i < list.length; i++) {
		var item = list[i];
		var id = item[0];
		var css = item[1];
		var media = item[2];
		var sourceMap = item[3];
		var part = {css: css, media: media, sourceMap: sourceMap};
		if(!newStyles[id])
			styles.push(newStyles[id] = {id: id, parts: [part]});
		else
			newStyles[id].parts.push(part);
	}
	return styles;
}

function insertStyleElement(options, styleElement) {
	var head = getHeadElement();
	var lastStyleElementInsertedAtTop = styleElementsInsertedAtTop[styleElementsInsertedAtTop.length - 1];
	if (options.insertAt === "top") {
		if(!lastStyleElementInsertedAtTop) {
			head.insertBefore(styleElement, head.firstChild);
		} else if(lastStyleElementInsertedAtTop.nextSibling) {
			head.insertBefore(styleElement, lastStyleElementInsertedAtTop.nextSibling);
		} else {
			head.appendChild(styleElement);
		}
		styleElementsInsertedAtTop.push(styleElement);
	} else if (options.insertAt === "bottom") {
		head.appendChild(styleElement);
	} else {
		throw new Error("Invalid value for parameter 'insertAt'. Must be 'top' or 'bottom'.");
	}
}

function removeStyleElement(styleElement) {
	styleElement.parentNode.removeChild(styleElement);
	var idx = styleElementsInsertedAtTop.indexOf(styleElement);
	if(idx >= 0) {
		styleElementsInsertedAtTop.splice(idx, 1);
	}
}

function createStyleElement(options) {
	var styleElement = document.createElement("style");
	styleElement.type = "text/css";
	insertStyleElement(options, styleElement);
	return styleElement;
}

function createLinkElement(options) {
	var linkElement = document.createElement("link");
	linkElement.rel = "stylesheet";
	insertStyleElement(options, linkElement);
	return linkElement;
}

function addStyle(obj, options) {
	var styleElement, update, remove;

	if (options.singleton) {
		var styleIndex = singletonCounter++;
		styleElement = singletonElement || (singletonElement = createStyleElement(options));
		update = applyToSingletonTag.bind(null, styleElement, styleIndex, false);
		remove = applyToSingletonTag.bind(null, styleElement, styleIndex, true);
	} else if(obj.sourceMap &&
		typeof URL === "function" &&
		typeof URL.createObjectURL === "function" &&
		typeof URL.revokeObjectURL === "function" &&
		typeof Blob === "function" &&
		typeof btoa === "function") {
		styleElement = createLinkElement(options);
		update = updateLink.bind(null, styleElement);
		remove = function() {
			removeStyleElement(styleElement);
			if(styleElement.href)
				URL.revokeObjectURL(styleElement.href);
		};
	} else {
		styleElement = createStyleElement(options);
		update = applyToTag.bind(null, styleElement);
		remove = function() {
			removeStyleElement(styleElement);
		};
	}

	update(obj);

	return function updateStyle(newObj) {
		if(newObj) {
			if(newObj.css === obj.css && newObj.media === obj.media && newObj.sourceMap === obj.sourceMap)
				return;
			update(obj = newObj);
		} else {
			remove();
		}
	};
}

var replaceText = (function () {
	var textStore = [];

	return function (index, replacement) {
		textStore[index] = replacement;
		return textStore.filter(Boolean).join('\n');
	};
})();

function applyToSingletonTag(styleElement, index, remove, obj) {
	var css = remove ? "" : obj.css;

	if (styleElement.styleSheet) {
		styleElement.styleSheet.cssText = replaceText(index, css);
	} else {
		var cssNode = document.createTextNode(css);
		var childNodes = styleElement.childNodes;
		if (childNodes[index]) styleElement.removeChild(childNodes[index]);
		if (childNodes.length) {
			styleElement.insertBefore(cssNode, childNodes[index]);
		} else {
			styleElement.appendChild(cssNode);
		}
	}
}

function applyToTag(styleElement, obj) {
	var css = obj.css;
	var media = obj.media;

	if(media) {
		styleElement.setAttribute("media", media)
	}

	if(styleElement.styleSheet) {
		styleElement.styleSheet.cssText = css;
	} else {
		while(styleElement.firstChild) {
			styleElement.removeChild(styleElement.firstChild);
		}
		styleElement.appendChild(document.createTextNode(css));
	}
}

function updateLink(linkElement, obj) {
	var css = obj.css;
	var sourceMap = obj.sourceMap;

	if(sourceMap) {
		// http://stackoverflow.com/a/26603875
		css += "\n/*# sourceMappingURL=data:application/json;base64," + btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))) + " */";
	}

	var blob = new Blob([css], { type: "text/css" });

	var oldSrc = linkElement.href;

	linkElement.href = URL.createObjectURL(blob);

	if(oldSrc)
		URL.revokeObjectURL(oldSrc);
}


/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
__webpack_require__(27);
__webpack_require__(28);
(function (e) {
    e.matches || (e.matches = e.matchesSelector !== undefined ? e.matchesSelector : function (selector) {
        var matches = this.ownerDocument.querySelectorAll(selector), th = this;
        return Array.prototype.some.call(matches, function (e) {
            return e === th;
        });
    });
})(Element.prototype);


/***/ }),
/* 27 */
/***/ (function(module, exports) {

/*
 * classList.js: Cross-browser full element.classList implementation.
 * 1.1.20170427
 *
 * By Eli Grey, http://eligrey.com
 * License: Dedicated to the public domain.
 *   See https://github.com/eligrey/classList.js/blob/master/LICENSE.md
 */

/*global self, document, DOMException */

/*! @source http://purl.eligrey.com/github/classList.js/blob/master/classList.js */

if ("document" in window.self) {

// Full polyfill for browsers with no classList support
// Including IE < Edge missing SVGElement.classList
if (!("classList" in document.createElement("_")) 
	|| document.createElementNS && !("classList" in document.createElementNS("http://www.w3.org/2000/svg","g"))) {

(function (view) {

"use strict";

if (!('Element' in view)) return;

var
	  classListProp = "classList"
	, protoProp = "prototype"
	, elemCtrProto = view.Element[protoProp]
	, objCtr = Object
	, strTrim = String[protoProp].trim || function () {
		return this.replace(/^\s+|\s+$/g, "");
	}
	, arrIndexOf = Array[protoProp].indexOf || function (item) {
		var
			  i = 0
			, len = this.length
		;
		for (; i < len; i++) {
			if (i in this && this[i] === item) {
				return i;
			}
		}
		return -1;
	}
	// Vendors: please allow content code to instantiate DOMExceptions
	, DOMEx = function (type, message) {
		this.name = type;
		this.code = DOMException[type];
		this.message = message;
	}
	, checkTokenAndGetIndex = function (classList, token) {
		if (token === "") {
			throw new DOMEx(
				  "SYNTAX_ERR"
				, "An invalid or illegal string was specified"
			);
		}
		if (/\s/.test(token)) {
			throw new DOMEx(
				  "INVALID_CHARACTER_ERR"
				, "String contains an invalid character"
			);
		}
		return arrIndexOf.call(classList, token);
	}
	, ClassList = function (elem) {
		var
			  trimmedClasses = strTrim.call(elem.getAttribute("class") || "")
			, classes = trimmedClasses ? trimmedClasses.split(/\s+/) : []
			, i = 0
			, len = classes.length
		;
		for (; i < len; i++) {
			this.push(classes[i]);
		}
		this._updateClassName = function () {
			elem.setAttribute("class", this.toString());
		};
	}
	, classListProto = ClassList[protoProp] = []
	, classListGetter = function () {
		return new ClassList(this);
	}
;
// Most DOMException implementations don't allow calling DOMException's toString()
// on non-DOMExceptions. Error's toString() is sufficient here.
DOMEx[protoProp] = Error[protoProp];
classListProto.item = function (i) {
	return this[i] || null;
};
classListProto.contains = function (token) {
	token += "";
	return checkTokenAndGetIndex(this, token) !== -1;
};
classListProto.add = function () {
	var
		  tokens = arguments
		, i = 0
		, l = tokens.length
		, token
		, updated = false
	;
	do {
		token = tokens[i] + "";
		if (checkTokenAndGetIndex(this, token) === -1) {
			this.push(token);
			updated = true;
		}
	}
	while (++i < l);

	if (updated) {
		this._updateClassName();
	}
};
classListProto.remove = function () {
	var
		  tokens = arguments
		, i = 0
		, l = tokens.length
		, token
		, updated = false
		, index
	;
	do {
		token = tokens[i] + "";
		index = checkTokenAndGetIndex(this, token);
		while (index !== -1) {
			this.splice(index, 1);
			updated = true;
			index = checkTokenAndGetIndex(this, token);
		}
	}
	while (++i < l);

	if (updated) {
		this._updateClassName();
	}
};
classListProto.toggle = function (token, force) {
	token += "";

	var
		  result = this.contains(token)
		, method = result ?
			force !== true && "remove"
		:
			force !== false && "add"
	;

	if (method) {
		this[method](token);
	}

	if (force === true || force === false) {
		return force;
	} else {
		return !result;
	}
};
classListProto.toString = function () {
	return this.join(" ");
};

if (objCtr.defineProperty) {
	var classListPropDesc = {
		  get: classListGetter
		, enumerable: true
		, configurable: true
	};
	try {
		objCtr.defineProperty(elemCtrProto, classListProp, classListPropDesc);
	} catch (ex) { // IE 8 doesn't support enumerable:true
		// adding undefined to fight this issue https://github.com/eligrey/classList.js/issues/36
		// modernie IE8-MSW7 machine has IE8 8.0.6001.18702 and is affected
		if (ex.number === undefined || ex.number === -0x7FF5EC54) {
			classListPropDesc.enumerable = false;
			objCtr.defineProperty(elemCtrProto, classListProp, classListPropDesc);
		}
	}
} else if (objCtr[protoProp].__defineGetter__) {
	elemCtrProto.__defineGetter__(classListProp, classListGetter);
}

}(window.self));

}

// There is full or partial native classList support, so just check if we need
// to normalize the add/remove and toggle APIs.

(function () {
	"use strict";

	var testElement = document.createElement("_");

	testElement.classList.add("c1", "c2");

	// Polyfill for IE 10/11 and Firefox <26, where classList.add and
	// classList.remove exist but support only one argument at a time.
	if (!testElement.classList.contains("c2")) {
		var createMethod = function(method) {
			var original = DOMTokenList.prototype[method];

			DOMTokenList.prototype[method] = function(token) {
				var i, len = arguments.length;

				for (i = 0; i < len; i++) {
					token = arguments[i];
					original.call(this, token);
				}
			};
		};
		createMethod('add');
		createMethod('remove');
	}

	testElement.classList.toggle("c3", false);

	// Polyfill for IE 10 and Firefox <24, where classList.toggle does not
	// support the second argument.
	if (testElement.classList.contains("c3")) {
		var _toggle = DOMTokenList.prototype.toggle;

		DOMTokenList.prototype.toggle = function(token, force) {
			if (1 in arguments && !this.contains(token) === !force) {
				return force;
			} else {
				return _toggle.call(this, token);
			}
		};

	}

	testElement = null;
}());

}


/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
// This file can be required in Browserify and Node.js for automatic polyfill
// To use it:  require('es6-promise/auto');

module.exports = __webpack_require__(29).polyfill();


/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

/* WEBPACK VAR INJECTION */(function(global) {/*!
 * @overview es6-promise - a tiny implementation of Promises/A+.
 * @copyright Copyright (c) 2014 Yehuda Katz, Tom Dale, Stefan Penner and contributors (Conversion to ES6 API by Jake Archibald)
 * @license   Licensed under MIT license
 *            See https://raw.githubusercontent.com/stefanpenner/es6-promise/master/LICENSE
 * @version   v4.2.4+314e4831
 */

(function (global, factory) {
	 true ? module.exports = factory() :
	typeof define === 'function' && define.amd ? define(factory) :
	(global.ES6Promise = factory());
}(this, (function () { 'use strict';

function objectOrFunction(x) {
  var type = typeof x;
  return x !== null && (type === 'object' || type === 'function');
}

function isFunction(x) {
  return typeof x === 'function';
}



var _isArray = void 0;
if (Array.isArray) {
  _isArray = Array.isArray;
} else {
  _isArray = function (x) {
    return Object.prototype.toString.call(x) === '[object Array]';
  };
}

var isArray = _isArray;

var len = 0;
var vertxNext = void 0;
var customSchedulerFn = void 0;

var asap = function asap(callback, arg) {
  queue[len] = callback;
  queue[len + 1] = arg;
  len += 2;
  if (len === 2) {
    // If len is 2, that means that we need to schedule an async flush.
    // If additional callbacks are queued before the queue is flushed, they
    // will be processed by this flush that we are scheduling.
    if (customSchedulerFn) {
      customSchedulerFn(flush);
    } else {
      scheduleFlush();
    }
  }
};

function setScheduler(scheduleFn) {
  customSchedulerFn = scheduleFn;
}

function setAsap(asapFn) {
  asap = asapFn;
}

var browserWindow = typeof window !== 'undefined' ? window : undefined;
var browserGlobal = browserWindow || {};
var BrowserMutationObserver = browserGlobal.MutationObserver || browserGlobal.WebKitMutationObserver;
var isNode = typeof self === 'undefined' && typeof process !== 'undefined' && {}.toString.call(process) === '[object process]';

// test for web worker but not in IE10
var isWorker = typeof Uint8ClampedArray !== 'undefined' && typeof importScripts !== 'undefined' && typeof MessageChannel !== 'undefined';

// node
function useNextTick() {
  // node version 0.10.x displays a deprecation warning when nextTick is used recursively
  // see https://github.com/cujojs/when/issues/410 for details
  return function () {
    return process.nextTick(flush);
  };
}

// vertx
function useVertxTimer() {
  if (typeof vertxNext !== 'undefined') {
    return function () {
      vertxNext(flush);
    };
  }

  return useSetTimeout();
}

function useMutationObserver() {
  var iterations = 0;
  var observer = new BrowserMutationObserver(flush);
  var node = document.createTextNode('');
  observer.observe(node, { characterData: true });

  return function () {
    node.data = iterations = ++iterations % 2;
  };
}

// web worker
function useMessageChannel() {
  var channel = new MessageChannel();
  channel.port1.onmessage = flush;
  return function () {
    return channel.port2.postMessage(0);
  };
}

function useSetTimeout() {
  // Store setTimeout reference so es6-promise will be unaffected by
  // other code modifying setTimeout (like sinon.useFakeTimers())
  var globalSetTimeout = setTimeout;
  return function () {
    return globalSetTimeout(flush, 1);
  };
}

var queue = new Array(1000);
function flush() {
  for (var i = 0; i < len; i += 2) {
    var callback = queue[i];
    var arg = queue[i + 1];

    callback(arg);

    queue[i] = undefined;
    queue[i + 1] = undefined;
  }

  len = 0;
}

function attemptVertx() {
  try {
    var vertx = Function('return this')().require('vertx');
    vertxNext = vertx.runOnLoop || vertx.runOnContext;
    return useVertxTimer();
  } catch (e) {
    return useSetTimeout();
  }
}

var scheduleFlush = void 0;
// Decide what async method to use to triggering processing of queued callbacks:
if (isNode) {
  scheduleFlush = useNextTick();
} else if (BrowserMutationObserver) {
  scheduleFlush = useMutationObserver();
} else if (isWorker) {
  scheduleFlush = useMessageChannel();
} else if (browserWindow === undefined && "function" === 'function') {
  scheduleFlush = attemptVertx();
} else {
  scheduleFlush = useSetTimeout();
}

function then(onFulfillment, onRejection) {
  var parent = this;

  var child = new this.constructor(noop);

  if (child[PROMISE_ID] === undefined) {
    makePromise(child);
  }

  var _state = parent._state;


  if (_state) {
    var callback = arguments[_state - 1];
    asap(function () {
      return invokeCallback(_state, child, callback, parent._result);
    });
  } else {
    subscribe(parent, child, onFulfillment, onRejection);
  }

  return child;
}

/**
  `Promise.resolve` returns a promise that will become resolved with the
  passed `value`. It is shorthand for the following:

  ```javascript
  let promise = new Promise(function(resolve, reject){
    resolve(1);
  });

  promise.then(function(value){
    // value === 1
  });
  ```

  Instead of writing the above, your code now simply becomes the following:

  ```javascript
  let promise = Promise.resolve(1);

  promise.then(function(value){
    // value === 1
  });
  ```

  @method resolve
  @static
  @param {Any} value value that the returned promise will be resolved with
  Useful for tooling.
  @return {Promise} a promise that will become fulfilled with the given
  `value`
*/
function resolve$1(object) {
  /*jshint validthis:true */
  var Constructor = this;

  if (object && typeof object === 'object' && object.constructor === Constructor) {
    return object;
  }

  var promise = new Constructor(noop);
  resolve(promise, object);
  return promise;
}

var PROMISE_ID = Math.random().toString(36).substring(2);

function noop() {}

var PENDING = void 0;
var FULFILLED = 1;
var REJECTED = 2;

var TRY_CATCH_ERROR = { error: null };

function selfFulfillment() {
  return new TypeError("You cannot resolve a promise with itself");
}

function cannotReturnOwn() {
  return new TypeError('A promises callback cannot return that same promise.');
}

function getThen(promise) {
  try {
    return promise.then;
  } catch (error) {
    TRY_CATCH_ERROR.error = error;
    return TRY_CATCH_ERROR;
  }
}

function tryThen(then$$1, value, fulfillmentHandler, rejectionHandler) {
  try {
    then$$1.call(value, fulfillmentHandler, rejectionHandler);
  } catch (e) {
    return e;
  }
}

function handleForeignThenable(promise, thenable, then$$1) {
  asap(function (promise) {
    var sealed = false;
    var error = tryThen(then$$1, thenable, function (value) {
      if (sealed) {
        return;
      }
      sealed = true;
      if (thenable !== value) {
        resolve(promise, value);
      } else {
        fulfill(promise, value);
      }
    }, function (reason) {
      if (sealed) {
        return;
      }
      sealed = true;

      reject(promise, reason);
    }, 'Settle: ' + (promise._label || ' unknown promise'));

    if (!sealed && error) {
      sealed = true;
      reject(promise, error);
    }
  }, promise);
}

function handleOwnThenable(promise, thenable) {
  if (thenable._state === FULFILLED) {
    fulfill(promise, thenable._result);
  } else if (thenable._state === REJECTED) {
    reject(promise, thenable._result);
  } else {
    subscribe(thenable, undefined, function (value) {
      return resolve(promise, value);
    }, function (reason) {
      return reject(promise, reason);
    });
  }
}

function handleMaybeThenable(promise, maybeThenable, then$$1) {
  if (maybeThenable.constructor === promise.constructor && then$$1 === then && maybeThenable.constructor.resolve === resolve$1) {
    handleOwnThenable(promise, maybeThenable);
  } else {
    if (then$$1 === TRY_CATCH_ERROR) {
      reject(promise, TRY_CATCH_ERROR.error);
      TRY_CATCH_ERROR.error = null;
    } else if (then$$1 === undefined) {
      fulfill(promise, maybeThenable);
    } else if (isFunction(then$$1)) {
      handleForeignThenable(promise, maybeThenable, then$$1);
    } else {
      fulfill(promise, maybeThenable);
    }
  }
}

function resolve(promise, value) {
  if (promise === value) {
    reject(promise, selfFulfillment());
  } else if (objectOrFunction(value)) {
    handleMaybeThenable(promise, value, getThen(value));
  } else {
    fulfill(promise, value);
  }
}

function publishRejection(promise) {
  if (promise._onerror) {
    promise._onerror(promise._result);
  }

  publish(promise);
}

function fulfill(promise, value) {
  if (promise._state !== PENDING) {
    return;
  }

  promise._result = value;
  promise._state = FULFILLED;

  if (promise._subscribers.length !== 0) {
    asap(publish, promise);
  }
}

function reject(promise, reason) {
  if (promise._state !== PENDING) {
    return;
  }
  promise._state = REJECTED;
  promise._result = reason;

  asap(publishRejection, promise);
}

function subscribe(parent, child, onFulfillment, onRejection) {
  var _subscribers = parent._subscribers;
  var length = _subscribers.length;


  parent._onerror = null;

  _subscribers[length] = child;
  _subscribers[length + FULFILLED] = onFulfillment;
  _subscribers[length + REJECTED] = onRejection;

  if (length === 0 && parent._state) {
    asap(publish, parent);
  }
}

function publish(promise) {
  var subscribers = promise._subscribers;
  var settled = promise._state;

  if (subscribers.length === 0) {
    return;
  }

  var child = void 0,
      callback = void 0,
      detail = promise._result;

  for (var i = 0; i < subscribers.length; i += 3) {
    child = subscribers[i];
    callback = subscribers[i + settled];

    if (child) {
      invokeCallback(settled, child, callback, detail);
    } else {
      callback(detail);
    }
  }

  promise._subscribers.length = 0;
}

function tryCatch(callback, detail) {
  try {
    return callback(detail);
  } catch (e) {
    TRY_CATCH_ERROR.error = e;
    return TRY_CATCH_ERROR;
  }
}

function invokeCallback(settled, promise, callback, detail) {
  var hasCallback = isFunction(callback),
      value = void 0,
      error = void 0,
      succeeded = void 0,
      failed = void 0;

  if (hasCallback) {
    value = tryCatch(callback, detail);

    if (value === TRY_CATCH_ERROR) {
      failed = true;
      error = value.error;
      value.error = null;
    } else {
      succeeded = true;
    }

    if (promise === value) {
      reject(promise, cannotReturnOwn());
      return;
    }
  } else {
    value = detail;
    succeeded = true;
  }

  if (promise._state !== PENDING) {
    // noop
  } else if (hasCallback && succeeded) {
    resolve(promise, value);
  } else if (failed) {
    reject(promise, error);
  } else if (settled === FULFILLED) {
    fulfill(promise, value);
  } else if (settled === REJECTED) {
    reject(promise, value);
  }
}

function initializePromise(promise, resolver) {
  try {
    resolver(function resolvePromise(value) {
      resolve(promise, value);
    }, function rejectPromise(reason) {
      reject(promise, reason);
    });
  } catch (e) {
    reject(promise, e);
  }
}

var id = 0;
function nextId() {
  return id++;
}

function makePromise(promise) {
  promise[PROMISE_ID] = id++;
  promise._state = undefined;
  promise._result = undefined;
  promise._subscribers = [];
}

function validationError() {
  return new Error('Array Methods must be provided an Array');
}

var Enumerator = function () {
  function Enumerator(Constructor, input) {
    this._instanceConstructor = Constructor;
    this.promise = new Constructor(noop);

    if (!this.promise[PROMISE_ID]) {
      makePromise(this.promise);
    }

    if (isArray(input)) {
      this.length = input.length;
      this._remaining = input.length;

      this._result = new Array(this.length);

      if (this.length === 0) {
        fulfill(this.promise, this._result);
      } else {
        this.length = this.length || 0;
        this._enumerate(input);
        if (this._remaining === 0) {
          fulfill(this.promise, this._result);
        }
      }
    } else {
      reject(this.promise, validationError());
    }
  }

  Enumerator.prototype._enumerate = function _enumerate(input) {
    for (var i = 0; this._state === PENDING && i < input.length; i++) {
      this._eachEntry(input[i], i);
    }
  };

  Enumerator.prototype._eachEntry = function _eachEntry(entry, i) {
    var c = this._instanceConstructor;
    var resolve$$1 = c.resolve;


    if (resolve$$1 === resolve$1) {
      var _then = getThen(entry);

      if (_then === then && entry._state !== PENDING) {
        this._settledAt(entry._state, i, entry._result);
      } else if (typeof _then !== 'function') {
        this._remaining--;
        this._result[i] = entry;
      } else if (c === Promise$1) {
        var promise = new c(noop);
        handleMaybeThenable(promise, entry, _then);
        this._willSettleAt(promise, i);
      } else {
        this._willSettleAt(new c(function (resolve$$1) {
          return resolve$$1(entry);
        }), i);
      }
    } else {
      this._willSettleAt(resolve$$1(entry), i);
    }
  };

  Enumerator.prototype._settledAt = function _settledAt(state, i, value) {
    var promise = this.promise;


    if (promise._state === PENDING) {
      this._remaining--;

      if (state === REJECTED) {
        reject(promise, value);
      } else {
        this._result[i] = value;
      }
    }

    if (this._remaining === 0) {
      fulfill(promise, this._result);
    }
  };

  Enumerator.prototype._willSettleAt = function _willSettleAt(promise, i) {
    var enumerator = this;

    subscribe(promise, undefined, function (value) {
      return enumerator._settledAt(FULFILLED, i, value);
    }, function (reason) {
      return enumerator._settledAt(REJECTED, i, reason);
    });
  };

  return Enumerator;
}();

/**
  `Promise.all` accepts an array of promises, and returns a new promise which
  is fulfilled with an array of fulfillment values for the passed promises, or
  rejected with the reason of the first passed promise to be rejected. It casts all
  elements of the passed iterable to promises as it runs this algorithm.

  Example:

  ```javascript
  let promise1 = resolve(1);
  let promise2 = resolve(2);
  let promise3 = resolve(3);
  let promises = [ promise1, promise2, promise3 ];

  Promise.all(promises).then(function(array){
    // The array here would be [ 1, 2, 3 ];
  });
  ```

  If any of the `promises` given to `all` are rejected, the first promise
  that is rejected will be given as an argument to the returned promises's
  rejection handler. For example:

  Example:

  ```javascript
  let promise1 = resolve(1);
  let promise2 = reject(new Error("2"));
  let promise3 = reject(new Error("3"));
  let promises = [ promise1, promise2, promise3 ];

  Promise.all(promises).then(function(array){
    // Code here never runs because there are rejected promises!
  }, function(error) {
    // error.message === "2"
  });
  ```

  @method all
  @static
  @param {Array} entries array of promises
  @param {String} label optional string for labeling the promise.
  Useful for tooling.
  @return {Promise} promise that is fulfilled when all `promises` have been
  fulfilled, or rejected if any of them become rejected.
  @static
*/
function all(entries) {
  return new Enumerator(this, entries).promise;
}

/**
  `Promise.race` returns a new promise which is settled in the same way as the
  first passed promise to settle.

  Example:

  ```javascript
  let promise1 = new Promise(function(resolve, reject){
    setTimeout(function(){
      resolve('promise 1');
    }, 200);
  });

  let promise2 = new Promise(function(resolve, reject){
    setTimeout(function(){
      resolve('promise 2');
    }, 100);
  });

  Promise.race([promise1, promise2]).then(function(result){
    // result === 'promise 2' because it was resolved before promise1
    // was resolved.
  });
  ```

  `Promise.race` is deterministic in that only the state of the first
  settled promise matters. For example, even if other promises given to the
  `promises` array argument are resolved, but the first settled promise has
  become rejected before the other promises became fulfilled, the returned
  promise will become rejected:

  ```javascript
  let promise1 = new Promise(function(resolve, reject){
    setTimeout(function(){
      resolve('promise 1');
    }, 200);
  });

  let promise2 = new Promise(function(resolve, reject){
    setTimeout(function(){
      reject(new Error('promise 2'));
    }, 100);
  });

  Promise.race([promise1, promise2]).then(function(result){
    // Code here never runs
  }, function(reason){
    // reason.message === 'promise 2' because promise 2 became rejected before
    // promise 1 became fulfilled
  });
  ```

  An example real-world use case is implementing timeouts:

  ```javascript
  Promise.race([ajax('foo.json'), timeout(5000)])
  ```

  @method race
  @static
  @param {Array} promises array of promises to observe
  Useful for tooling.
  @return {Promise} a promise which settles in the same way as the first passed
  promise to settle.
*/
function race(entries) {
  /*jshint validthis:true */
  var Constructor = this;

  if (!isArray(entries)) {
    return new Constructor(function (_, reject) {
      return reject(new TypeError('You must pass an array to race.'));
    });
  } else {
    return new Constructor(function (resolve, reject) {
      var length = entries.length;
      for (var i = 0; i < length; i++) {
        Constructor.resolve(entries[i]).then(resolve, reject);
      }
    });
  }
}

/**
  `Promise.reject` returns a promise rejected with the passed `reason`.
  It is shorthand for the following:

  ```javascript
  let promise = new Promise(function(resolve, reject){
    reject(new Error('WHOOPS'));
  });

  promise.then(function(value){
    // Code here doesn't run because the promise is rejected!
  }, function(reason){
    // reason.message === 'WHOOPS'
  });
  ```

  Instead of writing the above, your code now simply becomes the following:

  ```javascript
  let promise = Promise.reject(new Error('WHOOPS'));

  promise.then(function(value){
    // Code here doesn't run because the promise is rejected!
  }, function(reason){
    // reason.message === 'WHOOPS'
  });
  ```

  @method reject
  @static
  @param {Any} reason value that the returned promise will be rejected with.
  Useful for tooling.
  @return {Promise} a promise rejected with the given `reason`.
*/
function reject$1(reason) {
  /*jshint validthis:true */
  var Constructor = this;
  var promise = new Constructor(noop);
  reject(promise, reason);
  return promise;
}

function needsResolver() {
  throw new TypeError('You must pass a resolver function as the first argument to the promise constructor');
}

function needsNew() {
  throw new TypeError("Failed to construct 'Promise': Please use the 'new' operator, this object constructor cannot be called as a function.");
}

/**
  Promise objects represent the eventual result of an asynchronous operation. The
  primary way of interacting with a promise is through its `then` method, which
  registers callbacks to receive either a promise's eventual value or the reason
  why the promise cannot be fulfilled.

  Terminology
  -----------

  - `promise` is an object or function with a `then` method whose behavior conforms to this specification.
  - `thenable` is an object or function that defines a `then` method.
  - `value` is any legal JavaScript value (including undefined, a thenable, or a promise).
  - `exception` is a value that is thrown using the throw statement.
  - `reason` is a value that indicates why a promise was rejected.
  - `settled` the final resting state of a promise, fulfilled or rejected.

  A promise can be in one of three states: pending, fulfilled, or rejected.

  Promises that are fulfilled have a fulfillment value and are in the fulfilled
  state.  Promises that are rejected have a rejection reason and are in the
  rejected state.  A fulfillment value is never a thenable.

  Promises can also be said to *resolve* a value.  If this value is also a
  promise, then the original promise's settled state will match the value's
  settled state.  So a promise that *resolves* a promise that rejects will
  itself reject, and a promise that *resolves* a promise that fulfills will
  itself fulfill.


  Basic Usage:
  ------------

  ```js
  let promise = new Promise(function(resolve, reject) {
    // on success
    resolve(value);

    // on failure
    reject(reason);
  });

  promise.then(function(value) {
    // on fulfillment
  }, function(reason) {
    // on rejection
  });
  ```

  Advanced Usage:
  ---------------

  Promises shine when abstracting away asynchronous interactions such as
  `XMLHttpRequest`s.

  ```js
  function getJSON(url) {
    return new Promise(function(resolve, reject){
      let xhr = new XMLHttpRequest();

      xhr.open('GET', url);
      xhr.onreadystatechange = handler;
      xhr.responseType = 'json';
      xhr.setRequestHeader('Accept', 'application/json');
      xhr.send();

      function handler() {
        if (this.readyState === this.DONE) {
          if (this.status === 200) {
            resolve(this.response);
          } else {
            reject(new Error('getJSON: `' + url + '` failed with status: [' + this.status + ']'));
          }
        }
      };
    });
  }

  getJSON('/posts.json').then(function(json) {
    // on fulfillment
  }, function(reason) {
    // on rejection
  });
  ```

  Unlike callbacks, promises are great composable primitives.

  ```js
  Promise.all([
    getJSON('/posts'),
    getJSON('/comments')
  ]).then(function(values){
    values[0] // => postsJSON
    values[1] // => commentsJSON

    return values;
  });
  ```

  @class Promise
  @param {Function} resolver
  Useful for tooling.
  @constructor
*/

var Promise$1 = function () {
  function Promise(resolver) {
    this[PROMISE_ID] = nextId();
    this._result = this._state = undefined;
    this._subscribers = [];

    if (noop !== resolver) {
      typeof resolver !== 'function' && needsResolver();
      this instanceof Promise ? initializePromise(this, resolver) : needsNew();
    }
  }

  /**
  The primary way of interacting with a promise is through its `then` method,
  which registers callbacks to receive either a promise's eventual value or the
  reason why the promise cannot be fulfilled.
   ```js
  findUser().then(function(user){
    // user is available
  }, function(reason){
    // user is unavailable, and you are given the reason why
  });
  ```
   Chaining
  --------
   The return value of `then` is itself a promise.  This second, 'downstream'
  promise is resolved with the return value of the first promise's fulfillment
  or rejection handler, or rejected if the handler throws an exception.
   ```js
  findUser().then(function (user) {
    return user.name;
  }, function (reason) {
    return 'default name';
  }).then(function (userName) {
    // If `findUser` fulfilled, `userName` will be the user's name, otherwise it
    // will be `'default name'`
  });
   findUser().then(function (user) {
    throw new Error('Found user, but still unhappy');
  }, function (reason) {
    throw new Error('`findUser` rejected and we're unhappy');
  }).then(function (value) {
    // never reached
  }, function (reason) {
    // if `findUser` fulfilled, `reason` will be 'Found user, but still unhappy'.
    // If `findUser` rejected, `reason` will be '`findUser` rejected and we're unhappy'.
  });
  ```
  If the downstream promise does not specify a rejection handler, rejection reasons will be propagated further downstream.
   ```js
  findUser().then(function (user) {
    throw new PedagogicalException('Upstream error');
  }).then(function (value) {
    // never reached
  }).then(function (value) {
    // never reached
  }, function (reason) {
    // The `PedgagocialException` is propagated all the way down to here
  });
  ```
   Assimilation
  ------------
   Sometimes the value you want to propagate to a downstream promise can only be
  retrieved asynchronously. This can be achieved by returning a promise in the
  fulfillment or rejection handler. The downstream promise will then be pending
  until the returned promise is settled. This is called *assimilation*.
   ```js
  findUser().then(function (user) {
    return findCommentsByAuthor(user);
  }).then(function (comments) {
    // The user's comments are now available
  });
  ```
   If the assimliated promise rejects, then the downstream promise will also reject.
   ```js
  findUser().then(function (user) {
    return findCommentsByAuthor(user);
  }).then(function (comments) {
    // If `findCommentsByAuthor` fulfills, we'll have the value here
  }, function (reason) {
    // If `findCommentsByAuthor` rejects, we'll have the reason here
  });
  ```
   Simple Example
  --------------
   Synchronous Example
   ```javascript
  let result;
   try {
    result = findResult();
    // success
  } catch(reason) {
    // failure
  }
  ```
   Errback Example
   ```js
  findResult(function(result, err){
    if (err) {
      // failure
    } else {
      // success
    }
  });
  ```
   Promise Example;
   ```javascript
  findResult().then(function(result){
    // success
  }, function(reason){
    // failure
  });
  ```
   Advanced Example
  --------------
   Synchronous Example
   ```javascript
  let author, books;
   try {
    author = findAuthor();
    books  = findBooksByAuthor(author);
    // success
  } catch(reason) {
    // failure
  }
  ```
   Errback Example
   ```js
   function foundBooks(books) {
   }
   function failure(reason) {
   }
   findAuthor(function(author, err){
    if (err) {
      failure(err);
      // failure
    } else {
      try {
        findBoooksByAuthor(author, function(books, err) {
          if (err) {
            failure(err);
          } else {
            try {
              foundBooks(books);
            } catch(reason) {
              failure(reason);
            }
          }
        });
      } catch(error) {
        failure(err);
      }
      // success
    }
  });
  ```
   Promise Example;
   ```javascript
  findAuthor().
    then(findBooksByAuthor).
    then(function(books){
      // found books
  }).catch(function(reason){
    // something went wrong
  });
  ```
   @method then
  @param {Function} onFulfilled
  @param {Function} onRejected
  Useful for tooling.
  @return {Promise}
  */

  /**
  `catch` is simply sugar for `then(undefined, onRejection)` which makes it the same
  as the catch block of a try/catch statement.
  ```js
  function findAuthor(){
  throw new Error('couldn't find that author');
  }
  // synchronous
  try {
  findAuthor();
  } catch(reason) {
  // something went wrong
  }
  // async with promises
  findAuthor().catch(function(reason){
  // something went wrong
  });
  ```
  @method catch
  @param {Function} onRejection
  Useful for tooling.
  @return {Promise}
  */


  Promise.prototype.catch = function _catch(onRejection) {
    return this.then(null, onRejection);
  };

  /**
    `finally` will be invoked regardless of the promise's fate just as native
    try/catch/finally behaves
  
    Synchronous example:
  
    ```js
    findAuthor() {
      if (Math.random() > 0.5) {
        throw new Error();
      }
      return new Author();
    }
  
    try {
      return findAuthor(); // succeed or fail
    } catch(error) {
      return findOtherAuther();
    } finally {
      // always runs
      // doesn't affect the return value
    }
    ```
  
    Asynchronous example:
  
    ```js
    findAuthor().catch(function(reason){
      return findOtherAuther();
    }).finally(function(){
      // author was either found, or not
    });
    ```
  
    @method finally
    @param {Function} callback
    @return {Promise}
  */


  Promise.prototype.finally = function _finally(callback) {
    var promise = this;
    var constructor = promise.constructor;

    return promise.then(function (value) {
      return constructor.resolve(callback()).then(function () {
        return value;
      });
    }, function (reason) {
      return constructor.resolve(callback()).then(function () {
        throw reason;
      });
    });
  };

  return Promise;
}();

Promise$1.prototype.then = then;
Promise$1.all = all;
Promise$1.race = race;
Promise$1.resolve = resolve$1;
Promise$1.reject = reject$1;
Promise$1._setScheduler = setScheduler;
Promise$1._setAsap = setAsap;
Promise$1._asap = asap;

/*global self*/
function polyfill() {
  var local = void 0;

  if (typeof global !== 'undefined') {
    local = global;
  } else if (typeof self !== 'undefined') {
    local = self;
  } else {
    try {
      local = Function('return this')();
    } catch (e) {
      throw new Error('polyfill failed because global object is unavailable in this environment');
    }
  }

  var P = local.Promise;

  if (P) {
    var promiseToString = null;
    try {
      promiseToString = Object.prototype.toString.call(P.resolve());
    } catch (e) {
      // silently ignored
    }

    if (promiseToString === '[object Promise]' && !P.cast) {
      return;
    }
  }

  local.Promise = Promise$1;
}

// Strange compat..
Promise$1.polyfill = polyfill;
Promise$1.Promise = Promise$1;

return Promise$1;

})));



//# sourceMappingURL=es6-promise.map

/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(30)))

/***/ }),
/* 30 */
/***/ (function(module, exports) {

var g;

// This works in non-strict mode
g = (function() {
	return this;
})();

try {
	// This works if eval is allowed (see CSP)
	g = g || Function("return this")() || (1,eval)("this");
} catch(e) {
	// This works if the window reference is available
	if(typeof window === "object")
		g = window;
}

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

module.exports = g;


/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Component_1 = __webpack_require__(4);
var StatusBar = /** @class */ (function (_super) {
    __extends(StatusBar, _super);
    function StatusBar(jodit, target) {
        var _this = _super.call(this, jodit) || this;
        _this.target = target;
        _this.container = jodit.ownerDocument.createElement('div');
        _this.container.classList.add('jodit_statusbar');
        target.appendChild(_this.container);
        _this.hide();
        return _this;
    }
    StatusBar.prototype.hide = function () {
        this.container && (this.container.style.display = 'none');
    };
    StatusBar.prototype.show = function () {
        this.container && (this.container.style.display = 'block');
    };
    StatusBar.prototype.append = function (child, inTheRight) {
        if (inTheRight === void 0) { inTheRight = false; }
        var wrapper = this.jodit.ownerDocument.createElement('div');
        wrapper.classList.add('jodit_statusbar_item');
        if (inTheRight) {
            wrapper.classList.add('jodit_statusbar_item-right');
        }
        wrapper.appendChild(child);
        this.container.appendChild(wrapper);
        this.show();
        this.jodit.events.fire('resize');
    };
    StatusBar.prototype.destruct = function () {
        _super.prototype.destruct.call(this);
        this.container.parentNode && this.container.parentNode.removeChild(this.container);
    };
    return StatusBar;
}(Component_1.Component));
exports.StatusBar = StatusBar;


/***/ }),
/* 32 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var add_new_line_1 = __webpack_require__(33);
exports.addNewLine = add_new_line_1.addNewLine;
var autofocus_1 = __webpack_require__(34);
exports.autofocus = autofocus_1.autofocus;
var backspace_1 = __webpack_require__(35);
exports.backspace = backspace_1.backspace;
var bold_1 = __webpack_require__(36);
exports.bold = bold_1.bold;
var cleanHTML_1 = __webpack_require__(37);
exports.cleanHTML = cleanHTML_1.cleanHTML;
var color_1 = __webpack_require__(38);
exports.color = color_1.color;
__webpack_require__(39);
var enter_1 = __webpack_require__(40);
exports.enter = enter_1.enter;
var errorMessages_1 = __webpack_require__(41);
exports.errorMessages = errorMessages_1.errorMessages;
var font_1 = __webpack_require__(42);
exports.font = font_1.font;
var formatBlock_1 = __webpack_require__(43);
exports.formatBlock = formatBlock_1.formatBlock;
var fullsize_1 = __webpack_require__(44);
exports.fullsize = fullsize_1.fullsize;
var iframe_1 = __webpack_require__(45);
exports.iframe = iframe_1.iframe;
var indent_1 = __webpack_require__(46);
exports.indent = indent_1.indent;
var imageProcessor_1 = __webpack_require__(47);
exports.imageProcessor = imageProcessor_1.imageProcessor;
var imageProperties_1 = __webpack_require__(48);
exports.imageProperties = imageProperties_1.imageProperties;
var inline_popup_1 = __webpack_require__(49);
exports.inlinePopup = inline_popup_1.inlinePopup;
var justify_1 = __webpack_require__(50);
exports.justify = justify_1.justify;
var link_1 = __webpack_require__(51);
exports.link = link_1.link;
var mobile_1 = __webpack_require__(52);
exports.mobile = mobile_1.mobile;
var orderedlist_1 = __webpack_require__(53);
exports.orderedlist = orderedlist_1.orderedlist;
var paste_1 = __webpack_require__(54);
exports.paste = paste_1.paste;
var placeholder_1 = __webpack_require__(55);
exports.placeholder = placeholder_1.placeholder;
var redoundo_1 = __webpack_require__(56);
exports.redoundo = redoundo_1.redoundo;
var resizer_1 = __webpack_require__(57);
exports.resizer = resizer_1.resizer;
var size_1 = __webpack_require__(58);
exports.size = size_1.size;
var source_1 = __webpack_require__(59);
exports.source = source_1.source;
var symbols_1 = __webpack_require__(60);
exports.symbols = symbols_1.symbols;
var hotkeys_1 = __webpack_require__(61);
exports.hotkeys = hotkeys_1.hotkeys;
var table_1 = __webpack_require__(62);
exports.table = table_1.TableProcessor;
var tableKeyboardNavigation_1 = __webpack_require__(66);
exports.tableKeyboardNavigation = tableKeyboardNavigation_1.tableKeyboardNavigation;
var search_1 = __webpack_require__(67);
exports.search = search_1.search;
var sticky_1 = __webpack_require__(68);
exports.sticky = sticky_1.sticky;
var stat_1 = __webpack_require__(69);
exports.stat = stat_1.stat;
var xpath_1 = __webpack_require__(70);
exports.xpath = xpath_1.xpath;
var DragAndDrop_1 = __webpack_require__(71);
exports.DragAndDrop = DragAndDrop_1.DragAndDrop;
var paste_storage_1 = __webpack_require__(72);
exports.pasteStorage = paste_storage_1.pasteStorage;


/***/ }),
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Config_1 = __webpack_require__(1);
var Helpers_1 = __webpack_require__(0);
var ToolbarCollection_1 = __webpack_require__(5);
var Dom_1 = __webpack_require__(3);
/**
 * Create helper
 * @type {boolean}
 */
Config_1.Config.prototype.addNewLine = true;
/**
 * On dbl click on empty space of editor it add new P element
 * @type {boolean}
 */
Config_1.Config.prototype.addNewLineOnDBLClick = true;
/**
 * Whar kind of tags it will be impact
 * @type {string[]}
 */
Config_1.Config.prototype.addNewLineTagsTriggers = ['table', 'iframe', 'img', 'hr', 'jodit'];
/**
 * Create helper for adding new paragraph(Jodit.defaultOptions.enter tag) before iframe, table or image
 *
 * @param {Jodit} editor
 */
function addNewLine(editor) {
    if (!editor.options.addNewLine) {
        return;
    }
    var line = Helpers_1.dom('<div role="button" tabIndex="-1" title="' + editor.i18n("Break") + '" class="jodit-add-new-line"><span>' + ToolbarCollection_1.ToolbarIcon.getIcon('enter') + '</span></div>', editor.ownerDocument);
    var delta = 10;
    var isMatchedTag = new RegExp('^(' + editor.options.addNewLineTagsTriggers.join('|') + ')$', 'i');
    var timeout;
    var hidden = false;
    var preview = false;
    var current;
    var lineInFocus = false;
    var show = function () {
        if (editor.options.readonly || editor.isLocked()) {
            return;
        }
        if (editor.container.classList.contains('jodit_popup_active')) {
            return;
        }
        clearTimeout(timeout);
        line.classList.toggle('jodit-add-new-line_after', !preview);
        line.style.display = 'block';
        line.style.width = editor.editor.clientWidth + 'px';
        hidden = false;
    };
    var hideForce = function () {
        clearTimeout(timeout);
        lineInFocus = false;
        line.style.display = 'none';
        hidden = true;
    };
    var canGetFocus = function (elm) {
        return elm !== null && Dom_1.Dom.isBlock(elm) && !/^(img|table|iframe|hr)$/i.test(elm.nodeName);
    };
    var hide = function () {
        if (hidden || lineInFocus) {
            return;
        }
        clearTimeout(timeout);
        timeout = window.setTimeout(hideForce, 500);
    };
    editor.events
        .on('beforeDestruct', function () {
        line.parentNode && line.parentNode.removeChild(line);
    })
        .on('afterInit', function () {
        editor.container.appendChild(line);
        editor.events
            .on(line, 'mousemove', function (e) {
            e.stopPropagation();
        })
            .on(line, 'mousedown touchstart', function (e) {
            var p = editor.editorDocument.createElement(editor.options.enter);
            if (preview && current && current.parentNode) {
                current.parentNode.insertBefore(p, current);
            }
            else {
                editor.editor.appendChild(p);
            }
            editor.selection.setCursorIn(p);
            editor.setEditorValue();
            hideForce();
            e.preventDefault();
        });
    })
        .on('afterInit', function () {
        editor.events
            .on(editor.editor, 'scroll', function () {
            hideForce();
        })
            .on(editor.container, 'mouseleave', hide)
            .on(line, 'mouseenter', function () {
            clearTimeout(timeout);
            lineInFocus = true;
        })
            .on(line, 'mouseleave', function () {
            lineInFocus = false;
        })
            .on(editor.editor, 'dblclick', function (e) {
            if (editor.options.addNewLineOnDBLClick && e.target === editor.editor && editor.selection.isCollapsed()) {
                var editorBound = Helpers_1.offset(editor.editor, editor, editor.editorDocument);
                var top_1 = (e.pageY - editor.editorWindow.pageYOffset);
                var p = editor.editorDocument.createElement(editor.options.enter);
                if (Math.abs(top_1 - editorBound.top) < Math.abs(top_1 - (editorBound.height + editorBound.top)) && editor.editor.firstChild) {
                    editor.editor.insertBefore(p, editor.editor.firstChild);
                }
                else {
                    editor.editor.appendChild(p);
                }
                editor.selection.setCursorIn(p);
                editor.setEditorValue();
                hideForce();
                e.preventDefault();
            }
        })
            .on(editor.editor, 'mousemove', Helpers_1.debounce(function (e) {
            var currentElement = editor.editorDocument.elementFromPoint(e.pageX - editor.editorWindow.pageXOffset, e.pageY - editor.editorWindow.pageYOffset);
            if (currentElement && Dom_1.Dom.isOrContains(line, currentElement)) {
                return;
            }
            if (!currentElement || !Dom_1.Dom.isOrContains(editor.editor, currentElement)) {
                return;
            }
            if (!currentElement || !currentElement.nodeName.match(isMatchedTag) || !Dom_1.Dom.isOrContains(editor.editor, currentElement)) {
                currentElement = Dom_1.Dom.closest(currentElement, isMatchedTag, editor.editor);
                if (!currentElement) {
                    hide();
                    return;
                }
            }
            if (currentElement.nodeName.match(isMatchedTag)) {
                var parentBox = Dom_1.Dom.up(currentElement, Dom_1.Dom.isBlock, editor.editor);
                if (parentBox && parentBox !== editor.editor) {
                    currentElement = parentBox;
                }
            }
            var editorBound = Helpers_1.offset(editor.editor, editor, editor.editorDocument);
            var position = Helpers_1.offset(currentElement, editor, editor.editorDocument);
            var top = false;
            if (Math.abs(e.pageY - position.top) < delta) {
                top = position.top;
                if (top - editorBound.top >= 20) {
                    top -= 15;
                }
                preview = true;
            }
            if (Math.abs(e.pageY - (position.top + position.height)) < delta) {
                top = position.top + position.height;
                if ((editorBound.top + editorBound.height) - top >= 25) {
                    top += 15;
                }
                preview = false;
            }
            if (top !== false && ((preview && !Dom_1.Dom.prev(currentElement, canGetFocus, editor.editor)) || (!preview && !Dom_1.Dom.next(currentElement, canGetFocus, editor.editor)))) {
                line.style.top = top + 'px';
                current = currentElement;
                show();
            }
            else {
                current = false;
                hide();
            }
        }, editor.defaultTimeout));
    });
}
exports.addNewLine = addNewLine;


/***/ }),
/* 34 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Config_1 = __webpack_require__(1);
var Dom_1 = __webpack_require__(3);
/**
 * @property{boolean} autofocus=false true After loading the page into the editor once the focus is set
 */
Config_1.Config.prototype.autofocus = false;
/**
 * Autofocus plugin - set focus inside the editor after reload
 *
 * @param {Jodit} editor
 */
function autofocus(editor) {
    var timeout;
    editor.events
        .on('afterInit', function () {
        if (editor.options.autofocus) {
            if (editor.defaultTimeout) {
                timeout = window.setTimeout(editor.selection.focus, 300);
            }
            else {
                editor.selection.focus();
            }
        }
    })
        .on('mousedown', function (e) {
        if (editor.isEditorMode() && e.target && Dom_1.Dom.isBlock(e.target) && !e.target.childNodes.length) {
            if (editor.editor === e.target) {
                editor.selection.focus();
            }
            else {
                editor.selection.setCursorIn(e.target);
            }
        }
    })
        .on('beforeDestruct', function () {
        clearTimeout(timeout);
    });
}
exports.autofocus = autofocus;


/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var consts = __webpack_require__(2);
var Helpers_1 = __webpack_require__(0);
var Dom_1 = __webpack_require__(3);
/**
 * Plug-in process entering Backspace key
 *
 * @module backspace
 */
function backspace(editor) {
    var removeEmptyBlocks = function (container) {
        var box = container, parent;
        Helpers_1.normalizeNode(container);
        do {
            var html = box.innerHTML.replace(consts.INVISIBLE_SPACE_REG_EXP, '');
            if ((!html.length || html === '<br>') && !Dom_1.Dom.isCell(box, editor.editorWindow) && box.parentNode && container !== editor.editor) {
                parent = box.parentNode;
                box.parentNode.removeChild(box);
            }
            else {
                break;
            }
            box = parent;
        } while (box && box !== editor.editor);
    };
    var removeChar = function (box, toLeft, range) {
        if (box.node && box.node.nodeType === Node.TEXT_NODE && typeof box.node.nodeValue === 'string') {
            // remove invisible spaces
            var startOffset = toLeft ? box.node.nodeValue.length : 0;
            var startOffsetInRange = startOffset;
            var value = box.node.nodeValue, increment = toLeft ? -1 : 1;
            while (startOffset >= 0 && startOffset <= value.length && value[startOffset + (toLeft ? -1 : 0)] === consts.INVISIBLE_SPACE) {
                startOffset += increment;
            }
            if (startOffset !== startOffsetInRange) {
                if (toLeft) {
                    value = value.substr(0, startOffset) + value.substr(startOffsetInRange);
                }
                else {
                    value = value.substr(0, startOffsetInRange) + value.substr(startOffset);
                    startOffset = startOffsetInRange;
                }
                box.node.nodeValue = value;
            }
            range.setStart(box.node, startOffset);
            range.collapse(true);
            editor.selection.selectRange(range);
            var nextElement = Dom_1.Dom.findInline(box.node, toLeft, editor.editor);
            if (value.length) {
                var setRange = false;
                if (toLeft) {
                    if (startOffset) {
                        // box.node.nodeValue = value.substr(0, startOffset - 1) + value.substr(startOffset);
                        // if (!box.node.nodeValue.length) {
                        //     box.node.nodeValue = consts.INVISIBLE_SPACE;
                        // }
                        // startOffset -= 1;
                        setRange = true;
                    }
                }
                else {
                    if (startOffset < value.length) {
                        // box.node.nodeValue = value.substr(0, startOffset) + value.substr(startOffset + 1);
                        // if (!box.node.nodeValue.length) {
                        //     box.node.nodeValue = consts.INVISIBLE_SPACE;
                        // }
                        setRange = true;
                    }
                }
                if (setRange) {
                    // range.setStart(box.node, startOffset);
                    // range.collapse(true);
                    // editor.selection.selectRange(range);
                    return true;
                }
            }
            else {
                range.setStartBefore(box.node);
                range.collapse(true);
                editor.selection.selectRange(range);
                box.node && box.node.parentNode && box.node.parentNode.removeChild(box.node);
                box.node = nextElement;
            }
            if (nextElement) {
                if (Dom_1.Dom.isInlineBlock(nextElement)) {
                    nextElement = toLeft ? nextElement.lastChild : nextElement.firstChild;
                }
                if (nextElement && nextElement.nodeType === Node.TEXT_NODE) {
                    box.node = nextElement;
                    return removeChar(box, toLeft, range);
                }
            }
        }
    };
    var potentialRemovable = /^(IMG|BR|IFRAME|SCRIPT|INPUT|TEXTAREA|HR)$/;
    var removePotential = function (node) {
        if (node && potentialRemovable.test(node.nodeName)) {
            node.parentNode && node.parentNode.removeChild(node);
            return false;
        }
    };
    var removeInline = function (box, toLeft, range) {
        if (box.node) {
            var workElement = box.node;
            var removeCharFlag = removeChar(box, toLeft, range);
            if (removeCharFlag !== undefined) {
                return true;
            }
            if (!box.node) {
                box.node = workElement.parentNode;
            }
            if (box.node === editor.editor) {
                return false;
            }
            var node = box.node;
            if (removePotential(node) === false) {
                return false;
            }
            if (node) {
                node = toLeft ? node.previousSibling : node.nextSibling;
                ;
            }
            while (node && node.nodeType === Node.TEXT_NODE && node.nodeValue && node.nodeValue.match(/^[\n\r]+$/)) {
                node = toLeft ? node.previousSibling : node.nextSibling;
            }
            return removePotential(node);
        }
    };
    var isEmpty = function (node) {
        if (node.nodeName.match(/^(TD|TH|TR|TABLE|LI)$/) !== null) {
            return false;
        }
        if (Dom_1.Dom.isEmpty(node) || node.nodeName.match(potentialRemovable) !== null) {
            return true;
        }
        if (node.nodeType === Node.TEXT_NODE && !Dom_1.Dom.isEmptyTextNode(node)) {
            return false;
        }
        return node.childNodes.length ? [].slice.call(node.childNodes).every(isEmpty) : true;
    };
    editor.events
        .on('afterCommand', function (command) {
        if (command === 'delete') {
            var current = editor.selection.current();
            if (current && current.firstChild && current.firstChild.nodeName === 'BR') {
                current.removeChild(current.firstChild);
            }
            if (!Helpers_1.trim(editor.editor.innerText) && !editor.editor.querySelector('img') && (!current || !Dom_1.Dom.closest(current, 'table', editor.editor))) {
                editor.editor.innerHTML = '';
                var node = editor.selection.setCursorIn(editor.editor);
                node.parentNode && node.parentNode.removeChild(node);
            }
        }
    })
        .on('keydown', function (event) {
        if (event.which === consts.KEY_BACKSPACE || event.which === consts.KEY_DELETE) {
            var toLeft = event.which === consts.KEY_BACKSPACE;
            if (!editor.selection.isFocused()) {
                !editor.selection.focus();
            }
            if (!editor.selection.isCollapsed()) {
                editor.execCommand('Delete');
                return false;
            }
            var sel = editor.editorWindow.getSelection(), range = sel.rangeCount ? sel.getRangeAt(0) : false;
            if (!range) {
                return false;
            }
            var fakeNode = editor.ownerDocument.createTextNode(consts.INVISIBLE_SPACE);
            var marker = editor.editorDocument.createElement('span');
            try {
                range.insertNode(fakeNode);
                if (!Dom_1.Dom.isOrContains(editor.editor, fakeNode)) {
                    return false;
                }
                var container = Dom_1.Dom.up(fakeNode, Dom_1.Dom.isBlock, editor.editor);
                var workElement = Dom_1.Dom.findInline(fakeNode, toLeft, editor.editor);
                var box = {
                    node: workElement
                };
                var tryRemoveInline = void 0;
                if (workElement) {
                    tryRemoveInline = removeInline(box, toLeft, range);
                }
                else if (fakeNode.parentNode) {
                    tryRemoveInline = removeInline({
                        node: toLeft ? fakeNode.parentNode.previousSibling : fakeNode.parentNode.nextSibling
                    }, toLeft, range);
                }
                if (tryRemoveInline !== void (0)) {
                    return tryRemoveInline ? void (0) : false;
                }
                if (container && container.nodeName.match(/^(TD)$/)) {
                    return false;
                }
                var prevBox = toLeft ? Dom_1.Dom.prev(box.node || fakeNode, Dom_1.Dom.isBlock, editor.editor) : Dom_1.Dom.next(box.node || fakeNode, Dom_1.Dom.isBlock, editor.editor);
                if (!prevBox && container && container.parentNode) {
                    prevBox = editor.editorDocument.createElement(editor.options.enter);
                    var box_1 = container;
                    while (box_1 && box_1.parentNode && box_1.parentNode !== editor.editor) {
                        box_1 = box_1.parentNode;
                    }
                    box_1.parentNode && box_1.parentNode.insertBefore(prevBox, box_1);
                }
                else {
                    if (prevBox && isEmpty(prevBox)) {
                        prevBox.parentNode && prevBox.parentNode.removeChild(prevBox);
                        return false;
                    }
                }
                if (prevBox) {
                    var tmpNode = editor.selection.setCursorIn(prevBox, !toLeft);
                    editor.selection.insertNode(marker, false, false);
                    if (tmpNode.nodeType === Node.TEXT_NODE && tmpNode.nodeValue === consts.INVISIBLE_SPACE) {
                        tmpNode.parentNode && tmpNode.parentNode.removeChild(tmpNode);
                    }
                }
                if (container) {
                    removeEmptyBlocks(container);
                    if (prevBox && container.parentNode) {
                        if (container.nodeName === prevBox.nodeName &&
                            container.parentNode && prevBox.parentNode &&
                            container.parentNode !== editor.editor && prevBox.parentNode !== editor.editor &&
                            container.parentNode !== prevBox.parentNode &&
                            container.parentNode.nodeName === prevBox.parentNode.nodeName) {
                            container = container.parentNode;
                            prevBox = prevBox.parentNode;
                        }
                        Dom_1.Dom.moveContent(container, prevBox, !toLeft);
                        Helpers_1.normalizeNode(prevBox);
                    }
                    if (prevBox && prevBox.nodeName === 'LI') {
                        var UL = Dom_1.Dom.closest(prevBox, 'Ul|OL', editor.editor);
                        if (UL) {
                            var nextBox = UL.nextSibling;
                            if (nextBox && nextBox.nodeName === UL.nodeName && UL !== nextBox) {
                                Dom_1.Dom.moveContent(nextBox, UL, !toLeft);
                                nextBox.parentNode && nextBox.parentNode.removeChild(nextBox);
                            }
                        }
                    }
                    removeEmptyBlocks(container);
                    return false;
                }
            }
            finally {
                fakeNode.parentNode && fakeNode.nodeValue === consts.INVISIBLE_SPACE && fakeNode.parentNode.removeChild(fakeNode);
                if (marker && Dom_1.Dom.isOrContains(editor.editor, marker, true)) {
                    var tmpNode = editor.selection.setCursorBefore(marker);
                    marker.parentNode && marker.parentNode.removeChild(marker);
                    if (tmpNode && tmpNode.parentNode && (Dom_1.Dom.findInline(tmpNode, true, tmpNode.parentNode) || Dom_1.Dom.findInline(tmpNode, true, tmpNode.parentNode))) {
                        tmpNode.parentNode.removeChild(tmpNode);
                    }
                }
                editor.setEditorValue();
            }
            return false;
        }
    });
}
exports.backspace = backspace;


/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Jodit_1 = __webpack_require__(6);
var Config_1 = __webpack_require__(1);
Config_1.Config.prototype.controls.bold = {
    tagRegExp: /^(strong|b)$/i,
    tags: ["strong", "b"],
    css: {
        "font-weight": ["bold", "700"]
    },
    tooltip: "Bold",
};
Config_1.Config.prototype.controls.italic = {
    tagRegExp: /^(em|i)$/i,
    tags: ["em", "i"],
    css: {
        "font-style": "italic"
    },
    tooltip: "Italic",
};
Config_1.Config.prototype.controls.underline = {
    tagRegExp: /^(u)$/i,
    tags: ['u'],
    css: {
        "text-decoration": "underline"
    },
    tooltip: "Underline",
};
Config_1.Config.prototype.controls.strikethrough = {
    tagRegExp: /^(s)$/i,
    tags: ['s'],
    css: {
        "text-decoration": "line-through"
    },
    tooltip: "Strike through",
};
/**
 * Bold plugin - change B to Strong, i to Em
 */
function bold(editor) {
    var callBack = function (command) {
        var control = Jodit_1.Jodit.defaultOptions.controls[command];
        var cssOptions = __assign({}, control.css), cssRules = {};
        Object.keys(cssOptions).forEach(function (key) {
            cssRules[key] = Array.isArray(cssOptions[key]) ? cssOptions[key][0] : cssOptions[key];
        });
        editor.selection.applyCSS(cssRules, control.tags ? control.tags[0] : undefined, control.css);
        editor.setEditorValue();
        return false;
    };
    editor.registerCommand('bold', {
        exec: callBack,
        hotkeys: 'ctrl+b'
    });
    editor.registerCommand('italic', {
        exec: callBack,
        hotkeys: 'ctrl+i'
    });
    editor.registerCommand('underline', {
        exec: callBack,
        hotkeys: 'ctrl+u'
    });
    editor.registerCommand('strikethrough', {
        exec: callBack
    });
}
exports.bold = bold;


/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Config_1 = __webpack_require__(1);
var consts = __webpack_require__(2);
var Helpers_1 = __webpack_require__(0);
var Dom_1 = __webpack_require__(3);
var constants_1 = __webpack_require__(2);
Config_1.Config.prototype.cleanHTML = {
    timeout: 300,
    removeEmptyElements: true,
    fillEmptyParagraph: true,
    replaceNBSP: true,
    cleanOnPaste: true,
    replaceOldTags: {
        i: 'em',
        b: 'strong',
    },
    allowTags: false,
    denyTags: false,
};
Config_1.Config.prototype.controls.eraser = {
    command: 'removeFormat',
    tooltip: 'Clear Formatting'
};
/**
 * Clean HTML after removeFormat and insertHorizontalRule command
 */
function cleanHTML(editor) {
    // TODO compare this functionality and plugin paste.ts
    if (editor.options.cleanHTML.cleanOnPaste) {
        editor.events.on('processPaste', function (event, html) {
            return Helpers_1.cleanFromWord(html);
        });
    }
    var attributesReg = /([^\[]*)\[([^\]]+)]/, seperator = /[\s]*,[\s]*/, attrReg = /^(.*)[\s]*=[\s]*(.*)$/;
    var getHash = function (tags) {
        var tagsHash = {};
        if (typeof tags === 'string') {
            tags.split(seperator).map(function (elm) {
                elm = Helpers_1.trim(elm);
                var attr = attributesReg.exec(elm), allowAttributes = {}, attributeMap = function (attr) {
                    attr = Helpers_1.trim(attr);
                    var val = attrReg.exec(attr);
                    if (val) {
                        allowAttributes[val[1]] = val[2];
                    }
                    else {
                        allowAttributes[attr] = true;
                    }
                };
                if (attr) {
                    var attr2 = attr[2].split(seperator);
                    if (attr[1]) {
                        attr2.forEach(attributeMap);
                        tagsHash[attr[1].toUpperCase()] = allowAttributes;
                    }
                }
                else {
                    tagsHash[elm.toUpperCase()] = true;
                }
            });
            return tagsHash;
        }
        if (tags) {
            Object.keys(tags).forEach(function (tagName) {
                tagsHash[tagName.toUpperCase()] = tags[tagName];
            });
            return tagsHash;
        }
        return false;
    };
    var current, allowTagsHash = getHash(editor.options.cleanHTML.allowTags), denyTagsHash = getHash(editor.options.cleanHTML.denyTags);
    var hasNotEmptyTextSibling = function (node, next) {
        if (next === void 0) { next = false; }
        var prev = next ? node.nextSibling : node.previousSibling;
        while (prev) {
            if (prev.nodeType === Node.ELEMENT_NODE || !Dom_1.Dom.isEmptyTextNode(prev)) {
                return true;
            }
            prev = next ? prev.nextSibling : prev.previousSibling;
        }
        return false;
    };
    var isRemovableNode = function (node) {
        if (node.nodeType !== Node.TEXT_NODE &&
            ((allowTagsHash && !allowTagsHash[node.nodeName]) ||
                (denyTagsHash && denyTagsHash[node.nodeName]))) {
            return true;
        }
        // remove extra br
        if (current &&
            node.nodeName === 'BR' &&
            hasNotEmptyTextSibling(node) &&
            !hasNotEmptyTextSibling(node, true) &&
            Dom_1.Dom.up(node, Dom_1.Dom.isBlock, editor.editor) !== Dom_1.Dom.up(current, Dom_1.Dom.isBlock, editor.editor)) {
            return true;
        }
        return (editor.options.cleanHTML.removeEmptyElements &&
            current !== false &&
            node.nodeType === Node.ELEMENT_NODE &&
            node.nodeName.match(constants_1.IS_INLINE) !== null &&
            !editor.selection.isMarker(node) &&
            Helpers_1.trim(node.innerHTML).length === 0 &&
            !Dom_1.Dom.isOrContains(node, current));
    };
    editor.events
        .on('change afterSetMode afterInit mousedown keydown', Helpers_1.debounce(function () {
        if (!editor.isDestructed && editor.isEditorMode()) {
            current = editor.selection.current();
            var node = null, remove_1 = [], work_1 = false, i_1 = 0, replaceOldTags = editor.options.cleanHTML.replaceOldTags;
            if (replaceOldTags && current) {
                var tags = Object.keys(replaceOldTags).join('|');
                if (editor.selection.isCollapsed()) {
                    var oldParent = Dom_1.Dom.closest(current, tags, editor.editor);
                    if (oldParent) {
                        var selInfo = editor.selection.save();
                        var tagName = replaceOldTags[oldParent.nodeName.toLowerCase()] || replaceOldTags[oldParent.nodeName];
                        Dom_1.Dom.replace(oldParent, tagName, true, false, editor.editorDocument);
                        editor.selection.restore(selInfo);
                    }
                }
            }
            var checkNode_1 = function (node) {
                if (node) {
                    if (isRemovableNode(node)) {
                        remove_1.push(node);
                        return checkNode_1(node.nextSibling);
                    }
                    if (editor.options.cleanHTML.fillEmptyParagraph && Dom_1.Dom.isBlock(node) && Dom_1.Dom.isEmpty(node, /^(img|svg|canvas|input|textarea|form|br)$/)) {
                        var br = editor.editorDocument.createElement('br');
                        node.appendChild(br);
                    }
                    if (allowTagsHash && allowTagsHash[node.nodeName] !== true) {
                        if (node.attributes && node.attributes.length) {
                            var removeAttrs = [];
                            for (i_1 = 0; i_1 < node.attributes.length; i_1 += 1) {
                                if (!allowTagsHash[node.nodeName][node.attributes[i_1].name] ||
                                    (allowTagsHash[node.nodeName][node.attributes[i_1].name] !== true &&
                                        allowTagsHash[node.nodeName][node.attributes[i_1].name] !== node.attributes[i_1].value)) {
                                    removeAttrs.push(node.attributes[i_1].name);
                                }
                            }
                            if (removeAttrs.length) {
                                work_1 = true;
                            }
                            removeAttrs.forEach(function (attr) {
                                node.removeAttribute(attr);
                            });
                        }
                    }
                    checkNode_1(node.firstChild);
                    checkNode_1(node.nextSibling);
                }
            };
            if (editor.editor.firstChild) {
                node = editor.editor.firstChild;
            }
            checkNode_1(node);
            remove_1.forEach(function (node) { return node.parentNode && node.parentNode.removeChild(node); });
            if (remove_1.length || work_1) {
                editor.events && editor.events.fire('syncho');
            }
        }
    }, editor.options.cleanHTML.timeout))
        // remove invisible chars if node has another chars
        .on('keyup', function () {
        if (editor.options.readonly) {
            return;
        }
        var current = editor.selection.current();
        if (current) {
            var currentParagraph = Dom_1.Dom.up(current, Dom_1.Dom.isBlock, editor.editor);
            if (currentParagraph) {
                Dom_1.Dom.all(currentParagraph, function (node) {
                    if (node.nodeType === Node.TEXT_NODE) {
                        if (node.nodeValue !== null && consts.INVISIBLE_SPACE_REG_EXP.test(node.nodeValue) && node.nodeValue.replace(consts.INVISIBLE_SPACE_REG_EXP, '').length !== 0) {
                            node.nodeValue = node.nodeValue.replace(consts.INVISIBLE_SPACE_REG_EXP, '');
                            if (node === current && editor.selection.isCollapsed()) {
                                editor.selection.setCursorAfter(node);
                            }
                        }
                    }
                });
            }
        }
    })
        // remove invisible spaces then they already not need
        // TODO refactor this and code above
        // .on('keyup',  () => {
        //     if (editor.selection.isCollapsed()) {
        //         let node: Node | null = <Node | null> editor.selection.current();
        //         if (node && node.nodeType === Node.TEXT_NODE && node.nodeValue !== consts.INVISIBLE_SPACE) {
        //             console.log(node);
        //             while (node = Dom.findInline(node, true, editor.editor)) {
        //                 console.log(node);
        //                 debugger
        //                 if (node && node.nodeType === Node.TEXT_NODE && node.nodeValue && node.nodeValue.match(consts.INVISIBLE_SPACE_REG_EXP)) {
        //                     node.nodeValue = node.nodeValue.replace(consts.INVISIBLE_SPACE_REG_EXP, '');
        //                 }
        //             }
        //         }
        //     }
        // })
        .on('afterCommand', function (command) {
        var sel = editor.selection, hr, node;
        switch (command.toLowerCase()) {
            case 'inserthorizontalrule':
                hr = editor.editor.querySelector('hr[id=null]');
                if (hr) {
                    node = Dom_1.Dom.next(hr, Dom_1.Dom.isBlock, editor.editor, false);
                    if (!node) {
                        node = editor.editorDocument.createElement(editor.options.enter);
                        if (node) {
                            Dom_1.Dom.after(hr, node);
                        }
                    }
                    sel.setCursorIn(node);
                }
                break;
            case 'removeformat':
                node = sel.current();
                var clean_1 = function (elm) {
                    switch (elm.nodeType) {
                        case Node.ELEMENT_NODE:
                            Dom_1.Dom.each(elm, clean_1);
                            if (elm.nodeName === 'FONT') {
                                Dom_1.Dom.unwrap(elm);
                            }
                            else {
                                // clean some "style" attributes in selected range
                                [].slice.call(elm.attributes).forEach(function (attr) {
                                    if (['src', 'href', 'rel', 'content'].indexOf(attr.name.toLowerCase()) === -1) {
                                        elm.removeAttribute(attr.name);
                                    }
                                });
                                Helpers_1.normalizeNode(elm);
                            }
                            break;
                        case Node.TEXT_NODE:
                            if (editor.options.cleanHTML.replaceNBSP && elm.nodeType === Node.TEXT_NODE && elm.nodeValue !== null && elm.nodeValue.match(consts.SPACE_REG_EXP)) {
                                elm.nodeValue = elm.nodeValue.replace(consts.SPACE_REG_EXP, ' ');
                            }
                            break;
                        default:
                            elm.parentNode && elm.parentNode.removeChild(elm);
                    }
                };
                if (!sel.isCollapsed()) {
                    editor.selection.eachSelection(function (current) {
                        clean_1(current);
                    });
                }
                else {
                    while (node && node.nodeType !== Node.ELEMENT_NODE && node !== editor.editor) {
                        clean_1(node);
                        if (node) {
                            node = node.parentNode;
                        }
                    }
                }
                break;
        }
    });
}
exports.cleanHTML = cleanHTML;


/***/ }),
/* 38 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Helpers_1 = __webpack_require__(0);
var Config_1 = __webpack_require__(1);
var Widget_1 = __webpack_require__(10);
var TabsWidget = Widget_1.Widget.TabsWidget;
var ColorPickerWidget = Widget_1.Widget.ColorPickerWidget;
var Dom_1 = __webpack_require__(3);
Config_1.Config.prototype.controls.brush = {
    isActive: function (editor, btn, button) {
        var current = editor.selection.current();
        var icon = button.container.querySelector('svg');
        if (current) {
            var currentBpx = Dom_1.Dom.closest(current, function (elm) {
                return Dom_1.Dom.isBlock(elm) || (Dom_1.Dom.isNode(elm, editor.editorWindow) && elm.nodeType === Node.ELEMENT_NODE);
            }, editor.editor) || editor.editor;
            var color_1 = Helpers_1.css(currentBpx, 'color').toString();
            var bg = Helpers_1.css(currentBpx, 'background-color').toString();
            if (color_1 !== Helpers_1.css(editor.editor, 'color').toString()) {
                icon && (icon.style.fill = color_1);
                return true;
            }
            if (bg !== Helpers_1.css(editor.editor, 'background-color').toString()) {
                icon && (icon.style.fill = bg);
                return true;
            }
        }
        if (icon && icon.style.fill) {
            icon.style.fill = null;
        }
        return false;
    },
    popup: function (editor, current, self, close) {
        var color = '', bg_color = '', tabs, currentElement = null;
        if (current && current !== editor.editor && Dom_1.Dom.isNode(current, editor.editorWindow) && current.nodeType === Node.ELEMENT_NODE) {
            color = Helpers_1.css(current, 'color').toString();
            bg_color = Helpers_1.css(current, 'background-color').toString();
            currentElement = current;
        }
        var backgroundTag = ColorPickerWidget(editor, function (value) {
            if (!currentElement) {
                editor.execCommand('background', false, value);
            }
            else {
                currentElement.style.backgroundColor = value;
            }
            close();
        }, bg_color);
        var colorTab = ColorPickerWidget(editor, function (value) {
            if (!currentElement) {
                editor.execCommand('forecolor', false, value);
            }
            else {
                currentElement.style.color = value;
            }
            close();
        }, color);
        if (editor.options.colorPickerDefaultTab === 'background') {
            tabs = {
                Background: backgroundTag,
                Text: colorTab
            };
        }
        else {
            tabs = {
                Text: colorTab,
                Background: backgroundTag
            };
        }
        return TabsWidget(editor, tabs, currentElement);
    },
    tooltip: "Fill color or set the text color"
};
/**
 * Process commands `background` and `forecolor`
 * @param {Jodit} editor
 */
function color(editor) {
    var callback = function (command, second, third) {
        var color = Helpers_1.normalizeColor(third);
        switch (command) {
            case 'background':
                editor.selection.applyCSS({
                    backgroundColor: !color ? '' : color
                });
                break;
            case 'forecolor':
                editor.selection.applyCSS({
                    color: !color ? '' : color
                });
                break;
        }
        editor.setEditorValue();
        return false;
    };
    editor.registerCommand('forecolor', callback);
    editor.registerCommand('background', callback);
}
exports.color = color;


/***/ }),
/* 39 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Config_1 = __webpack_require__(1);
var Dom_1 = __webpack_require__(3);
var Helpers_1 = __webpack_require__(0);
var pluginKey = 'copyformat';
/**
 * Plug-in copy and paste formatting from elements
 *
 * @module copyformat
 */
var copyStyles = [
    'fontWeight',
    'fontStyle',
    'fontSize',
    'color',
    'margin',
    'padding',
    'borderWidth',
    'borderStyle',
    'borderColor',
    'borderRadius',
    'backgroundColor',
    'textDecorationLine',
    'fontFamily'
];
var getStyle = function (editor, key, box, defaultStyles) {
    var result = Helpers_1.css(box, key);
    if (result == defaultStyles[key]) {
        if (box.parentNode && box !== editor.editor && box.parentNode !== editor.editor) {
            result = getStyle(editor, key, box.parentNode, defaultStyles);
        }
        else {
            result = void (0);
        }
    }
    return result;
};
var getStyles = function (editor, box, defaultStyles) {
    var result = {};
    if (box) {
        copyStyles.forEach(function (key) {
            result[key] = getStyle(editor, key, box, defaultStyles);
            if (key.match(/border(Style|Color)/) && !result['borderWidth']) {
                result[key] = void (0);
            }
        });
    }
    return result;
};
Config_1.Config.prototype.controls.copyformat = {
    exec: function (editor, current) {
        if (current) {
            if (editor.buffer[pluginKey]) {
                editor.buffer[pluginKey] = false;
                editor.events.off(editor.editor, 'mouseup.' + pluginKey);
            }
            else {
                var defaultStyles_1 = {};
                var box = Dom_1.Dom.up(current, function (elm) { return (elm && elm.nodeType !== Node.TEXT_NODE); }, editor.editor) || editor.editor;
                var ideal_1 = editor.editorDocument.createElement('span');
                editor.editor.appendChild(ideal_1);
                copyStyles.forEach(function (key) {
                    defaultStyles_1[key] = Helpers_1.css(ideal_1, key);
                });
                if (ideal_1 !== editor.editor) {
                    ideal_1.parentNode && ideal_1.parentNode.removeChild(ideal_1);
                }
                var format_1 = getStyles(editor, box, defaultStyles_1);
                var onmousedown_1 = function () {
                    editor.buffer[pluginKey] = false;
                    var current = editor.selection.current();
                    if (current) {
                        if (current.nodeName === 'IMG') {
                            Helpers_1.css(current, format_1);
                        }
                        else {
                            editor.selection.applyCSS(format_1);
                        }
                    }
                    editor.events.off(editor.editor, 'mouseup.' + pluginKey);
                };
                editor.events.on(editor.editor, 'mouseup.' + pluginKey, onmousedown_1);
                editor.buffer[pluginKey] = true;
            }
        }
    },
    isActive: function (editor) {
        return !!editor.buffer[pluginKey];
    },
    tooltip: "Paint format"
};


/***/ }),
/* 40 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Helpers_1 = __webpack_require__(0);
var consts = __webpack_require__(2);
var Dom_1 = __webpack_require__(3);
/**
 * Insert default paragraph
 *
 * @param {Jodit} editor
 * @param {Node} [fake]
 * @param {String} [wrapperTag]
 * @param {CSSStyleSheet} [style]
 * @return {HTMLElement}
 */
exports.insertParagraph = function (editor, fake, wrapperTag, style) {
    if (!wrapperTag) {
        wrapperTag = editor.options.enter.toLowerCase();
    }
    var p = editor.editorDocument.createElement(wrapperTag), helper_node = editor.editorDocument.createElement('br');
    p.appendChild(helper_node);
    if (style && style.cssText) {
        p.setAttribute('style', style.cssText);
    }
    editor.selection.insertNode(p, false, false);
    editor.selection.setCursorBefore(helper_node);
    var range = editor.editorDocument.createRange();
    range.setStartBefore(helper_node);
    range.collapse(true);
    editor.selection.selectRange(range);
    if (fake && fake.parentNode) {
        fake.parentNode.removeChild(fake);
    }
    Helpers_1.scrollIntoView(p, editor.editor, editor.editorDocument);
    editor.events && editor.events.fire('synchro'); // fire change
    return p;
};
/**
 * One of most important core plugins. It is responsible for all the browsers to have the same effect when the Enter button is pressed. By default, it should insert the <p>
 */
function enter(editor) {
    editor.events.on('keydown', function (event) {
        if (event.which === consts.KEY_ENTER) {
            /**
             * Fired on processing `Enter` key. If return some value, plugin `enter` will do nothing. if return false - prevent default Enter behavior
             *
             * @event beforeEnter
             */
            var beforeEnter = editor.events.fire('beforeEnter', event);
            if (beforeEnter !== undefined) {
                return beforeEnter;
            }
            if (!editor.selection.isCollapsed()) {
                editor.execCommand('Delete');
            }
            editor.selection.focus();
            var current = editor.selection.current(false);
            var sel = editor.editorWindow.getSelection();
            var range = sel.rangeCount ? sel.getRangeAt(0) : editor.editorDocument.createRange();
            if (!current || current === editor.editor) {
                editor.selection.current();
                current = editor.editorDocument.createTextNode(consts.INVISIBLE_SPACE);
                if (sel.rangeCount) {
                    range.insertNode(current);
                }
                else {
                    editor.editor.appendChild(current);
                }
                range.selectNode(current);
                range.collapse(false);
                sel.removeAllRanges();
                sel.addRange(range);
            }
            var currentBox = current ? Dom_1.Dom.up(current, Dom_1.Dom.isBlock, editor.editor) : false;
            // if use <br> tag for break line or when was entered SHIFt key or in <td> or <th> or <blockquote>
            if (editor.options.enter.toLowerCase() === consts.BR.toLowerCase() || event.shiftKey || Dom_1.Dom.closest(current, 'PRE|BLOCKQUOTE', editor.editor)) {
                var br = editor.editorDocument.createElement('br');
                editor.selection.insertNode(br, true);
                Helpers_1.scrollIntoView(br, editor.editor, editor.editorDocument);
                return false;
            }
            // wrap no wrapped element
            if (!currentBox && current && !Dom_1.Dom.prev(current, function (elm) { return (Dom_1.Dom.isBlock(elm) || (!!elm && Dom_1.Dom.isImage(elm, editor.ownerWindow))); }, editor.editor)) {
                var needWrap_1 = current;
                Dom_1.Dom.up(needWrap_1, function (node) {
                    if (node && node.hasChildNodes() && node !== editor.editor) {
                        needWrap_1 = node;
                    }
                }, editor.editor);
                currentBox = Dom_1.Dom.wrapInline(needWrap_1, editor.options.enter, editor);
                if (Dom_1.Dom.isEmpty(currentBox)) {
                    var helper_node = editor.editorDocument.createElement('br');
                    currentBox.appendChild(helper_node);
                    editor.selection.setCursorBefore(helper_node);
                }
                range = sel.rangeCount ? sel.getRangeAt(0) : editor.editorDocument.createRange();
            }
            var isLi = false, fake = false, insertNew = false;
            if (currentBox) {
                if (!Dom_1.Dom.canSplitBlock(currentBox, editor.editorWindow)) {
                    var br = editor.editorDocument.createElement('br');
                    editor.selection.insertNode(br, false);
                    editor.selection.setCursorAfter(br);
                    return false;
                }
                isLi = currentBox.nodeName === 'LI';
                if (isLi) {
                    if (Dom_1.Dom.isEmpty(currentBox)) {
                        var fake_1 = false;
                        var ul = Dom_1.Dom.closest(currentBox, 'ol|ul', editor.editor);
                        // If there is no LI element before
                        if (!Dom_1.Dom.prev(currentBox, function (elm) { return elm && elm.nodeName === 'LI'; }, ul)) {
                            fake_1 = editor.selection.setCursorBefore(ul);
                            // If there is no LI element after
                        }
                        else if (!Dom_1.Dom.next(currentBox, function (elm) { return elm && elm.nodeName === 'LI'; }, ul)) {
                            fake_1 = editor.selection.setCursorAfter(ul);
                        }
                        else {
                            var leftRange = editor.editorDocument.createRange();
                            leftRange.setStartBefore(ul);
                            leftRange.setEndAfter(currentBox);
                            var fragment = leftRange.extractContents();
                            if (ul.parentNode) {
                                ul.parentNode.insertBefore(fragment, ul);
                            }
                            fake_1 = editor.selection.setCursorBefore(ul);
                        }
                        if (currentBox.parentNode) {
                            currentBox.parentNode.removeChild(currentBox);
                        }
                        exports.insertParagraph(editor, fake_1);
                        if (!Helpers_1.$$('li', ul).length && ul.parentNode) {
                            ul.parentNode.removeChild(ul);
                        }
                        return false;
                    }
                }
                if (editor.selection.cursorInTheEdge(true, currentBox)) {
                    // if we are in the left edge of paragraph
                    fake = editor.selection.setCursorBefore(currentBox);
                    exports.insertParagraph(editor, fake, isLi ? 'li' : editor.options.enter, currentBox.style);
                    editor.selection.setCursorIn(currentBox, true);
                    return false;
                }
                if (editor.selection.cursorInTheEdge(false, currentBox) === false) {
                    // if we are not in right edge of paragraph
                    // split p,h1 etc on two parts
                    var leftRange = editor.editorDocument.createRange();
                    leftRange.setStartBefore(currentBox);
                    leftRange.setEnd(range.startContainer, range.startOffset);
                    var fragment = leftRange.extractContents();
                    if (currentBox.parentNode) {
                        currentBox.parentNode.insertBefore(fragment, currentBox);
                    }
                    editor.selection.setCursorIn(currentBox, true);
                }
                else {
                    fake = editor.selection.setCursorAfter(currentBox);
                }
            }
            else {
                insertNew = true;
            }
            if (insertNew || fake) {
                exports.insertParagraph(editor, fake, isLi ? 'li' : editor.options.enter, currentBox ? currentBox.style : void (0));
            }
            return false;
        }
    });
}
exports.enter = enter;


/***/ }),
/* 41 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Config_1 = __webpack_require__(1);
var Helpers_1 = __webpack_require__(0);
/**
* @property{boolean} showMessageErrors=true
*/
Config_1.Config.prototype.showMessageErrors = true;
/**
* @property{int} showMessageErrorTime=3000 How long show messages
*/
Config_1.Config.prototype.showMessageErrorTime = 3000;
/**
* @property{int} showMessageErrorOffsetPx=3 Offset fo message
*/
Config_1.Config.prototype.showMessageErrorOffsetPx = 3;
/**
 * Plugin toWYSIWYG display pop-up messages in the lower right corner of the editor
 */
function errorMessages(editor) {
    if (editor.options.showMessageErrors) {
        var height_1;
        var messagesBox_1 = Helpers_1.dom('<div class="jodit_error_box_for_messages"></div>', editor.ownerDocument), recalcOffsets_1 = function () {
            height_1 = 5;
            [].slice.call(messagesBox_1.childNodes).forEach(function (elm) {
                Helpers_1.css(messagesBox_1, 'bottom', height_1 + 'px');
                height_1 += elm.offsetWidth + editor.options.showMessageErrorOffsetPx;
            });
        };
        editor.workplace.appendChild(messagesBox_1);
        /**
         * Вывести всплывающее сообщение внизу редактора
         *
         * @event errorMessage
         * @param {string} message  Сообщение
         * @param {string} className Дополнительный класс собобщения. Допускаются info, error, success
         * @param {string} timeout Сколько миллисекунд показывать. По умолчанию используется options.showMessageErrorTime = 2000
         * @example
         * ```javascript
         * parent.events.fire('errorMessage', 'Error 123. File has not been upload');
         * parent.events.fire('errorMessage', 'You can upload file', 'info', 4000);
         * parent.events.fire('errorMessage', 'File was uploaded', 'success', 4000);
         * ```
         */
        editor.events.on('errorMessage', function (message, className, timeout) {
            var newmessage = Helpers_1.dom('<div class="active ' + (className || '') + '">' + message + '</div>', editor.ownerDocument);
            messagesBox_1.appendChild(newmessage);
            recalcOffsets_1();
            setTimeout(function () {
                newmessage.classList.remove('active');
                setTimeout(function () {
                    messagesBox_1.removeChild(newmessage);
                    recalcOffsets_1();
                }, 300);
            }, timeout || editor.options.showMessageErrorTime);
        });
    }
}
exports.errorMessages = errorMessages;


/***/ }),
/* 42 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Helpers_1 = __webpack_require__(0);
var Config_1 = __webpack_require__(1);
var Dom_1 = __webpack_require__(3);
Config_1.Config.prototype.controls.fontsize = {
    command: 'fontSize',
    list: ["8", "9", "10", "11", "12", "14", "16", "18", "24", "30", "36", "48", "60", "72", "96"],
    template: function (editor, key, value) { return value; },
    tooltip: "Font size",
    isActiveChild: function (editor, control) {
        var current = editor.selection.current();
        if (current) {
            var currentBpx = Dom_1.Dom.closest(current, function (elm) {
                return Dom_1.Dom.isBlock(elm) || (Dom_1.Dom.isNode(elm, editor.editorWindow) && elm.nodeType === Node.ELEMENT_NODE);
            }, editor.editor) || editor.editor;
            var fontSize = Helpers_1.css(currentBpx, 'font-size');
            return !!(fontSize && control.args && control.args[1].toString() === fontSize.toString());
        }
        return false;
    },
    isActive: function (editor) {
        var current = editor.selection.current();
        if (current) {
            var currentBpx = Dom_1.Dom.closest(current, function (elm) {
                return Dom_1.Dom.isBlock(elm) || (Dom_1.Dom.isNode(elm, editor.editorWindow) && elm.nodeType === Node.ELEMENT_NODE);
            }, editor.editor) || editor.editor;
            return Helpers_1.css(currentBpx, 'font-size').toString() !== Helpers_1.css(editor.editor, 'font-size').toString();
        }
        return false;
    }
};
Config_1.Config.prototype.controls.font = {
    command: 'fontname',
    exec: function (editor, event, control) {
        editor.execCommand(control.command, false, control.args ? control.args[0] : undefined);
    },
    list: {
        "Helvetica,sans-serif": "Helvetica",
        "Arial,Helvetica,sans-serif": "Arial",
        "Georgia,serif": "Georgia",
        "Impact,Charcoal,sans-serif": "Impact",
        "Tahoma,Geneva,sans-serif": "Tahoma",
        "'Times New Roman',Times,serif": "Times New Roman",
        "Verdana,Geneva,sans-serif": "Verdana"
    },
    template: function (editor, key, value) {
        return "<span style=\"font-family: " + key + "\">" + value + "</span>";
    },
    isActiveChild: function (editor, control) {
        var current = editor.selection.current();
        var normFonts = function (font) {
            return font.toLowerCase()
                .replace(/['"]+/g, '')
                .replace(/[^a-z0-9]+/g, ',');
        };
        if (current) {
            var currentBpx = Dom_1.Dom.closest(current, function (elm) {
                return Dom_1.Dom.isBlock(elm) || (Dom_1.Dom.isNode(elm, editor.editorWindow) && elm.nodeType === Node.ELEMENT_NODE);
            }, editor.editor) || editor.editor;
            var font_1 = Helpers_1.css(currentBpx, 'font-family').toString();
            return !!(font_1 && control.args && normFonts(control.args[0].toString()) === normFonts(font_1));
        }
        return false;
    },
    isActive: function (editor) {
        var current = editor.selection.current();
        if (current) {
            var currentBpx = Dom_1.Dom.closest(current, function (elm) {
                return Dom_1.Dom.isBlock(elm) || (Dom_1.Dom.isNode(elm, editor.editorWindow) && elm.nodeType === Node.ELEMENT_NODE);
            }, editor.editor) || editor.editor;
            return Helpers_1.css(currentBpx, 'font-family').toString() !== Helpers_1.css(editor.editor, 'font-family').toString();
        }
        return false;
    },
    tooltip: "Font family"
};
/**
 * Process commands `fontsize` and `fontname`
 * @param {Jodit} editor
 */
function font(editor) {
    var callback = function (command, second, third) {
        switch (command) {
            case 'fontsize':
                editor.selection.applyCSS({
                    fontSize: Helpers_1.normalizeSize(third)
                });
                break;
            case 'fontname':
                editor.selection.applyCSS({
                    fontFamily: third
                });
                break;
        }
        editor.setEditorValue();
        return false;
    };
    editor.registerCommand('fontsize', callback);
    editor.registerCommand('fontname', callback);
}
exports.font = font;


/***/ }),
/* 43 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Dom_1 = __webpack_require__(3);
var consts = __webpack_require__(2);
var Config_1 = __webpack_require__(1);
Config_1.Config.prototype.controls.paragraph = {
    command: 'formatBlock',
    getLabel: function (editor, btn, button) {
        var current = editor.selection.current();
        if (current && editor.options.textIcons) {
            var currentBox = Dom_1.Dom.closest(current, Dom_1.Dom.isBlock, editor.editor) || editor.editor, currentValue = currentBox.nodeName.toLowerCase();
            if (btn.data && btn.data.currentValue !== currentValue && btn.list && btn.list[currentValue]) {
                button.textBox.innerHTML = "<span>" + btn.list[currentValue] + "</span>";
                button.textBox.firstChild.classList.add('jodit_icon');
                btn.data.currentValue = currentValue;
            }
        }
        return false;
    },
    exec: function (editor, event, control) {
        editor.execCommand(control.command, false, control.args ? control.args[0] : undefined);
    },
    data: {
        currentValue: 'left'
    },
    list: {
        p: "Normal",
        h1: "Heading 1",
        h2: "Heading 2",
        h3: "Heading 3",
        h4: "Heading 4",
        blockquote: "Quote",
    },
    isActiveChild: function (editor, control) {
        var current = editor.selection.current();
        if (current) {
            var currentBox = Dom_1.Dom.closest(current, Dom_1.Dom.isBlock, editor.editor);
            return currentBox &&
                currentBox !== editor.editor &&
                control.args !== undefined &&
                currentBox.nodeName.toLowerCase() === control.args[0];
        }
        return false;
    },
    isActive: function (editor, control) {
        var current = editor.selection.current();
        if (current) {
            var currentBpx = Dom_1.Dom.closest(current, Dom_1.Dom.isBlock, editor.editor);
            return currentBpx &&
                currentBpx !== editor.editor &&
                control.list !== undefined &&
                currentBpx.nodeName.toLowerCase() !== 'p' &&
                control.list[currentBpx.nodeName.toLowerCase()] !== undefined;
        }
        return false;
    },
    template: function (editor, key, value) {
        return '<' + key + ' class="jodit_list_element"><span>' + editor.i18n(value) + '</span></' + key + '></li>';
    },
    tooltip: "Insert format block"
};
/**
 * Process command - `formatblock`
 *
 * @param {Jodit} editor
 */
function formatBlock(editor) {
    editor.registerCommand('formatblock', function (command, second, third) {
        editor.selection.focus();
        var work = false;
        editor.selection.eachSelection(function (current) {
            var selectionInfo = editor.selection.save();
            var currentBox = current ? Dom_1.Dom.up(current, Dom_1.Dom.isBlock, editor.editor) : false;
            if ((!currentBox || currentBox.nodeName === 'LI') && current) {
                currentBox = Dom_1.Dom.wrapInline(current, editor.options.enter, editor);
            }
            if (!currentBox) {
                editor.selection.restore(selectionInfo);
                return false;
            }
            if (!currentBox.tagName.match(/TD|TH|TBODY|TABLE|THEAD/i)) {
                if (third === editor.options.enter.toLowerCase() &&
                    currentBox.parentNode &&
                    currentBox.parentNode.nodeName === 'LI') {
                    Dom_1.Dom.unwrap(currentBox);
                }
                else {
                    Dom_1.Dom.replace(currentBox, third, true, false, editor.editorDocument);
                }
            }
            else {
                if (!editor.selection.isCollapsed()) {
                    editor.selection.applyCSS({}, third);
                }
                else {
                    Dom_1.Dom.wrapInline(current, third, editor);
                }
            }
            work = true;
            editor.selection.restore(selectionInfo);
        });
        if (!work) {
            var currentBox = editor.editorDocument.createElement(third);
            currentBox.innerHTML = consts.INVISIBLE_SPACE;
            editor.selection.insertNode(currentBox, false);
            editor.selection.setCursorIn(currentBox);
        }
        editor.setEditorValue();
        return false;
    });
}
exports.formatBlock = formatBlock;


/***/ }),
/* 44 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Config_1 = __webpack_require__(1);
var Helpers_1 = __webpack_require__(0);
var ToolbarCollection_1 = __webpack_require__(5);
var consts = __webpack_require__(2);
Config_1.Config.prototype.fullsize = false;
Config_1.Config.prototype.globalFullsize = true;
Config_1.Config.prototype.controls.fullsize = {
    exec: function (editor) {
        editor.toggleFullSize();
    },
    isActive: function (editor) { return editor.isFullSize(); },
    getLabel: function (editor, btn, button) {
        var mode = editor.isFullSize() ? 'shrink' : 'fullsize';
        button.textBox.innerHTML = !editor.options.textIcons ? ToolbarCollection_1.ToolbarIcon.getIcon(mode) : "<span>" + editor.i18n(mode) + "</span>";
        button.textBox.firstChild.classList.add('jodit_icon');
    },
    tooltip: 'Open editor in fullsize',
    mode: consts.MODE_SOURCE + consts.MODE_WYSIWYG
};
/**
 * Process `toggleFullSize` event, and behavior - set/unset fullsize mode
 *
 * @param {Jodit} editor
 */
function fullsize(editor) {
    var shown = false, oldHeight = 0, oldWidth = 0, wasToggled = false, resize = function () {
        if (editor.events) {
            if (shown) {
                oldHeight = Helpers_1.css(editor.container, 'height');
                oldWidth = Helpers_1.css(editor.container, 'width');
                Helpers_1.css(editor.container, {
                    height: editor.ownerWindow.innerHeight,
                    width: editor.ownerWindow.innerWidth
                });
                wasToggled = true;
            }
            else if (wasToggled) {
                Helpers_1.css(editor.container, {
                    height: oldHeight || 'auto',
                    width: oldWidth || 'auto'
                });
            }
        }
    }, toggle = function (condition) {
        if (condition === undefined) {
            condition = !editor.container.classList.contains('jodit_fullsize');
        }
        editor.options.fullsize = !!condition;
        shown = condition;
        editor.container.classList.toggle('jodit_fullsize', condition);
        if (editor.toolbar) {
            Helpers_1.css(editor.toolbar.container, 'width', 'auto');
        }
        if (editor.options.globalFullsize) {
            var node = editor.container.parentNode;
            while (node && !(node instanceof Document)) {
                node.classList.toggle('jodit_fullsize_box', condition);
                node = node.parentNode;
            }
            resize();
        }
        editor.events.fire('afterResize');
    };
    if (editor.options.globalFullsize) {
        editor.events.on(editor.ownerWindow, 'resize', resize);
    }
    editor.events
        .on('afterInit', function () {
        editor.toggleFullSize(editor.options.fullsize);
    })
        .on('toggleFullSize', toggle)
        .on('beforeDestruct', function () {
        toggle(false);
    });
}
exports.fullsize = fullsize;


/***/ }),
/* 45 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Config_1 = __webpack_require__(1);
var Helpers_1 = __webpack_require__(0);
/**
 * When this option is enabled, the editor's content will be placed in an iframe and isolated from the rest of the page.
 *
 * @example
 * ```javascript
 * new Jodit('#editor', {
 *    iframe = true;
 *    iframeStyle = 'html{margin: 0px;}body{padding:10px;background:transparent;color:#000;position:relative;z-index: 2;user-select:auto;margin:0px;overflow:hidden;}body:after{content:"";clear:both;display:block}';
 * });
 * ```
 */
Config_1.Config.prototype.iframe = false;
/**
 * Base URL where the root directory for {@link Jodit.defaultOptions.iframe|iframe} mode
 *
 * @example
 * ```javascript
 * new Jodit('#editor', {
 *    iframe: true,
 *    iframeBaseUrl: 'http://xdsoft.net/jodit/docs/',
 * });
 * ```
 */
Config_1.Config.prototype.iframeBaseUrl = '';
/**
 * Custom style toWYSIWYG be used inside the iframe toWYSIWYG display content.
 * @example
 * ```javascript
 * new Jodit('#editor', {
 *    iframe: true,
 *    iframeStyle: 'html{margin: 0px;}',
 * })
 * ```
 */
Config_1.Config.prototype.iframeStyle = 'html{' +
    'margin: 0px;' +
    'min-height: 100%;' +
    '}' +
    'body{' +
    'box-sizing: border-box;' +
    'font-size: 13px;' +
    '    line-height: 1.6;' +
    'padding:10px;' +
    'background:transparent;' +
    'color:#000;' +
    'position:' +
    'relative;' +
    'z-index: 2;' +
    'user-select:auto;' +
    'margin:0px;' +
    'overflow:auto;' +
    '}' +
    'table{' +
    'width:100%;' +
    'border: none;' +
    'border-collapse:collapse;' +
    'empty-cells: show;' +
    'max-width: 100%;' +
    '}' +
    'th,td{' +
    'padding: 2px 5px;' +
    'border:1px solid #ccc;' +
    '-webkit-user-select:text;' +
    '-moz-user-select:text;' +
    '-ms-user-select:text;' +
    'user-select:text' +
    '}' +
    'td[data-jodit-selected-cell],' +
    'th[data-jodit-selected-cell]{' +
    'border: 1px double #1e88e5' +
    '}' +
    'p{' +
    'margin-top:0;' +
    '}' +
    '.jodit_editor .jodit_iframe_wrapper{' +
    'display: block;' +
    'clear: both;' +
    'user-select: none;' +
    'position: relative;' +
    '}' +
    '.jodit_editor .jodit_iframe_wrapper:after {' +
    'position:absolute;' +
    'content:"";' +
    'z-index:1;' +
    'top:0;' +
    'left:0;' +
    'right: 0;' +
    'bottom: 0;' +
    'cursor: pointer;' +
    'display: block;' +
    'background: rgba(0, 0, 0, 0);' +
    '} ' +
    '.jodit_disabled{' +
    'user-select: none;' +
    '-o-user-select: none;' +
    '-moz-user-select: none;' +
    '-khtml-user-select: none;' +
    '-webkit-user-select: none;' +
    '-ms-user-select: none' +
    '}';
/**
 * Custom stylesheet files toWYSIWYG be used inside the iframe toWYSIWYG display content.
 *
 * @example
 * ```javascript
 * new Jodit('#editor', {
 *    iframe: true,
 *    iframeCSSLinks: ['styles/default.css'],
 * })
 * ```
 */
Config_1.Config.prototype.iframeCSSLinks = [];
/**
 * Iframe plugin - use `iframe` instead of DIV in editor. It can be need when you want attach custom styles in editor in backend of you system
 */
function iframe(editor) {
    editor.events
        .on('afterSetMode', function () {
        if (editor.isEditorMode()) {
            editor.selection.focus();
        }
    })
        .on('generateDocumentStructure.iframe', function (doc) {
        doc.open();
        doc.write("<!DOCTYPE html>\n                    <html dir=\"" + editor.options.direction + "\" class=\"jodit\" lang=\"" + Helpers_1.defaultLanguage(editor.options.language) + "\">\n                        <head>\n                            " + (editor.options.iframeBaseUrl ? "<base href=\"" + editor.options.iframeBaseUrl + "\"/>" : '') + "\n                        </head>\n                        <body class=\"jodit_wysiwyg\" style=\"outline:none\" contenteditable=\"true\"></body>\n                    </html>");
        doc.close();
        if (editor.options.iframeCSSLinks) {
            editor.options.iframeCSSLinks.forEach(function (href) {
                var link = Helpers_1.dom('<link rel="stylesheet" href="' + href + '">', doc);
                doc.head.appendChild(link);
            });
        }
        if (editor.options.iframeStyle) {
            var style = doc.createElement('style');
            style.innerHTML = editor.options.iframeStyle;
            doc.head.appendChild(style);
        }
    })
        .on('createEditor', function () {
        if (!editor.options.iframe) {
            return;
        }
        editor.iframe = editor.ownerDocument.createElement("iframe");
        editor.iframe.style.display = 'block';
        editor.iframe.src = 'about:blank';
        editor.iframe.className = 'jodit_wysiwyg_iframe';
        editor.iframe.frameBorder = '0';
        editor.iframe.setAttribute('allowtransparency', 'true');
        editor.iframe.setAttribute('tabindex', '0');
        editor.iframe.setAttribute('frameborder', '0');
        editor.workplace.appendChild(editor.iframe);
        var doc = editor.iframe.contentWindow.document;
        editor.events.fire('generateDocumentStructure.iframe', doc);
        editor.editorDocument = doc;
        editor.editorWindow = editor.iframe.contentWindow;
        editor.editor = doc.body;
        if (editor.options.height === 'auto') {
            doc.documentElement.style.overflowY = 'hidden';
            var resizeIframe = Helpers_1.throttle(function () {
                if (editor.editor && editor.iframe && editor.options.height === 'auto') {
                    Helpers_1.css(editor.iframe, 'height', editor.editor.offsetHeight);
                }
            }, editor.defaultTimeout / 2);
            editor.events
                .on('change afterInit afterSetMode resize', resizeIframe)
                .on([editor.iframe, editor.editorWindow, doc.documentElement], 'load', resizeIframe)
                .on(doc, 'readystatechange DOMContentLoaded', resizeIframe);
        }
        (function (e) {
            e.matches || (e.matches = Element.prototype.matches); // fix inside iframe polifill
        })(editor.editorWindow.Element.prototype);
        //throw events in our word
        editor.events
            .on(editor.editorDocument.documentElement, 'mousedown touchend', function () {
            if (!editor.selection.isFocused()) {
                editor.selection.focus();
                editor.selection.setCursorIn(editor.editor);
            }
        })
            .on(editor.editorWindow, 'mousedown touchstart keydown keyup touchend click mouseup mousemove scroll', function (e) {
            editor.events && editor.events.fire && editor.events.fire(window, e);
        });
        return false;
    });
}
exports.iframe = iframe;


/***/ }),
/* 46 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Config_1 = __webpack_require__(1);
var Dom_1 = __webpack_require__(3);
Config_1.Config.prototype.controls.indent = {
    tooltip: "Increase Indent",
};
Config_1.Config.prototype.controls.outdent = {
    isDisable: function (editor) {
        var current = editor.selection.current();
        if (current) {
            var currentBox = Dom_1.Dom.closest(current, Dom_1.Dom.isBlock, editor.editor);
            if (currentBox && currentBox.style && currentBox.style.marginLeft) {
                return parseInt(currentBox.style.marginLeft, 10) <= 0;
            }
        }
        return true;
    },
    tooltip: "Decrease Indent",
};
/**
 * The number of pixels to use for indenting the current line.
 * @type {number}
 */
Config_1.Config.prototype.indentMargin = 10;
/**
 * Indents the line containing the selection or insertion point.
 * @param {Jodit} editor
 */
function indent(editor) {
    var callback = function (command) {
        editor.selection.eachSelection(function (current) {
            var selectionInfo = editor.selection.save();
            var currentBox = current ? Dom_1.Dom.up(current, Dom_1.Dom.isBlock, editor.editor) : false;
            if (!currentBox && current) {
                currentBox = Dom_1.Dom.wrapInline(current, editor.options.enter, editor);
            }
            if (!currentBox) {
                editor.selection.restore(selectionInfo);
                return false;
            }
            if (currentBox && currentBox.style) {
                var marginLeft = currentBox.style.marginLeft ? parseInt(currentBox.style.marginLeft, 10) : 0;
                marginLeft += editor.options.indentMargin * (command === 'outdent' ? -1 : 1);
                currentBox.style.marginLeft = marginLeft > 0 ? marginLeft + 'px' : '';
                if (!currentBox.getAttribute('style')) {
                    currentBox.removeAttribute('style');
                }
            }
            editor.selection.restore(selectionInfo);
        });
        editor.setEditorValue();
        return false;
    };
    editor.registerCommand('indent', {
        exec: callback,
        hotkeys: 'ctrl+]'
    });
    editor.registerCommand('outdent', {
        exec: callback,
        hotkeys: 'ctrl+['
    });
}
exports.indent = indent;


/***/ }),
/* 47 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Helpers_1 = __webpack_require__(0);
var JODIT_IMAGE_PROCESSOR_BINDED = '__jodit_imageprocessor_binded';
/**
 * Change editor's size after load all images
 *
 * @param {Jodit} editor
 */
function imageProcessor(editor) {
    editor.events.on('change afterInit', Helpers_1.debounce(function () {
        if (editor.editor) {
            Helpers_1.$$('img', editor.editor).forEach(function (elm) {
                if (!elm[JODIT_IMAGE_PROCESSOR_BINDED]) {
                    elm[JODIT_IMAGE_PROCESSOR_BINDED] = true;
                    if (!elm.complete) {
                        elm.addEventListener('load', function ElementOnLoad() {
                            editor.events && editor.events.fire && editor.events.fire('resize');
                            elm.removeEventListener('load', ElementOnLoad);
                        });
                    }
                    editor.events.on(elm, 'mousedown touchstart', function () {
                        editor.selection.select(elm);
                    });
                }
            });
        }
    }, editor.defaultTimeout));
}
exports.imageProcessor = imageProcessor;


/***/ }),
/* 48 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Jodit_1 = __webpack_require__(6);
var Config_1 = __webpack_require__(1);
var Helpers_1 = __webpack_require__(0);
var Dialog_1 = __webpack_require__(7);
var ToolbarCollection_1 = __webpack_require__(5);
var Dom_1 = __webpack_require__(3);
var Widget_1 = __webpack_require__(10);
var TabsWidget = Widget_1.Widget.TabsWidget;
var FileSelectorWidget = Widget_1.Widget.FileSelectorWidget;
Config_1.Config.prototype.image = {
    openOnDblClick: true,
    editSrc: true,
    useImageEditor: true,
    editTitle: true,
    editAlt: true,
    editLink: true,
    editSize: true,
    editBorderRadius: true,
    editMargins: true,
    editClass: true,
    editStyle: true,
    editId: true,
    editAlign: true,
    showPreview: true,
    selectImageAfterClose: true,
};
/**
 * Show dialog with image's options
 *
 * @param {Jodit} editor
 */
function imageProperties(editor) {
    /**
     * Open dialog editing image properties
     *
     * @example
     * ```javascript
     * var editor = new Jodit('#editor');
     *     img = editor.editorDocument.createElement('img');
     *
     * img.setAttribute('src', 'images/someimage.png');
     * editor.{@link Selection~select|select}(img);
     * // open the properties of the editing window
     * editor.plugins.image.open.call(img); // `this` must be HTMLImageElement
     * ```
     */
    var open = function (e) {
        var _this = this;
        if (editor.options.readonly) {
            return;
        }
        e && e.stopImmediatePropagation();
        var image = this, dialog = new Dialog_1.Dialog(editor), cancel = Helpers_1.dom('<a href="javascript:void(0)" style="float:right;" class="jodit_button">' + ToolbarCollection_1.ToolbarIcon.getIcon('cancel') + '<span>' + editor.i18n('Cancel') + '</span></a>', editor.ownerDocument), check = Helpers_1.dom('<a href="javascript:void(0)" style="float:left;" class="jodit_button">' + ToolbarCollection_1.ToolbarIcon.getIcon('check') + '<span>' + editor.i18n('Ok') + '</span></a>', editor.ownerDocument), buttons = {
            remove: Helpers_1.dom('<a href="javascript:void(0)" class="jodit_button">' + ToolbarCollection_1.ToolbarIcon.getIcon('bin') + ' ' + editor.i18n('Delete') + '</a>', editor.ownerDocument)
        }, prop = Helpers_1.dom('<form class="jodit_properties">' +
            '<div class="jodit_grid">' +
            '<div class="jodit_col-lg-2-5">' +
            '<div class="jodit_properties_view_box">' +
            '<div style="' + (!editor.options.image.showPreview ? 'display:none' : '') + '" class="jodit_properties_image_view">' +
            '<img class="imageViewSrc" src="" alt=""/>' +
            '</div>' +
            '<div style="' + (!editor.options.image.editSize ? 'display:none' : '') + '" class="jodit_form_group jodit_properties_image_sizes">' +
            '<input type="number" class="imageWidth"/>' +
            '<a class="jodit_lock_helper jodit_lock_size" href="javascript:void(0)">' +
            ToolbarCollection_1.ToolbarIcon.getIcon('lock') +
            '</a>' +
            '<input type="number" class="imageHeight"/>' +
            '</div>' +
            '</div>' +
            '</div>' +
            '<div class="jodit_col-lg-3-5 tabsbox"></div>' +
            '</div>' +
            '</form>', editor.ownerDocument), positionTab = Helpers_1.dom('<div style="' + (!editor.options.image.editMargins ? 'display:none' : '') + '" class="jodit_form_group">' +
            '<label>' + editor.i18n('Margins') + '</label>' +
            '<div class="jodit_grid">' +
            '<input class="jodit_col-lg-1-5 margins marginTop" data-id="marginTop" type="text" placeholder="' + editor.i18n('top') + '"/>' +
            '<a style="text-align: center;" class="jodit_lock_helper jodit_lock_margin jodit_col-lg-1-5" href="javascript:void(0)">' +
            ToolbarCollection_1.ToolbarIcon.getIcon('lock') +
            '</a>' +
            '<input disabled="true" class="jodit_col-lg-1-5 margins marginRight" data-id="marginRight" type="text" placeholder="' + editor.i18n('right') + '"/>' +
            '<input disabled="true" class="jodit_col-lg-1-5 margins marginBottom" data-id="marginBottom" type="text" placeholder="' + editor.i18n('bottom') + '"/>' +
            '<input disabled="true" class="jodit_col-lg-1-5 margins marginLeft" data-id="marginLeft" type="text" placeholder="' + editor.i18n('left') + '"/>' +
            '</div>' +
            '</div>' +
            '<div style="' + (!editor.options.image.editStyle ? 'display:none' : '') + '" class="jodit_form_group">' +
            '<label>' + editor.i18n('Styles') + '</label>' +
            '<input type="text" class="style"/>' +
            '</div>' +
            '<div style="' + (!editor.options.image.editClass ? 'display:none' : '') + '" class="jodit_form_group">' +
            '<label for="classes">' + editor.i18n('Classes') + '</label>' +
            '<input type="text" class="classes"/>' +
            '</div>' +
            '<div style="' + (!editor.options.image.editId ? 'display:none' : '') + '" class="jodit_form_group">' +
            '<label for="id">Id</label>' +
            '<input type="text" class="id"/>' +
            '</div>' +
            '<div style="' + (!editor.options.image.editBorderRadius ? 'display:none' : '') + '" class="jodit_form_group">' +
            '<label for="border_radius">Border radius</label>' +
            '<input type="number" class="border_radius"/>' +
            '</div>' +
            '<div style="' + (!editor.options.image.editAlign ? 'display:none' : '') + '" class="jodit_form_group">' +
            '<label for="align">' + editor.i18n('Align') + '</label>' +
            '<select class="select align">' +
            '<option value="">' + editor.i18n('--Not Set--') + '</option>' +
            '<option value="left">' + editor.i18n('Left') + '</option>' +
            '<option value="center">' + editor.i18n('Center') + '</option>' +
            '<option value="right">' + editor.i18n('Right') + '</option>' +
            '</optgroup>' +
            '</select>' +
            '</div>', editor.ownerDocument), mainTab = Helpers_1.dom('<div style="' + (!editor.options.image.editSrc ? 'display:none' : '') + '" class="jodit_form_group">' +
            '<label>' + editor.i18n('Src') + '</label>' +
            '<div class="jodit_input_group">' +
            '<input type="text" class="imageSrc"/>' +
            ((editor.options.filebrowser.ajax.url || editor.options.uploader.url) ?
                '<div class="jodit_input_group-buttons">' +
                    ((editor.options.filebrowser.ajax.url || editor.options.uploader.url) ? '<a class="jodit_button jodit_rechange" href="javascript:void(0)">' + ToolbarCollection_1.ToolbarIcon.getIcon('image') + '</a>' : '') +
                    ((editor.options.image.useImageEditor && Jodit_1.Jodit.modules.ImageEditor !== undefined && editor.options.filebrowser.ajax.url) ? '<a class="jodit_button jodit_use_image_editor" href="javascript:void(0)">' + ToolbarCollection_1.ToolbarIcon.getIcon('crop') + '</a>' : '') +
                    '</div>' : '') +
            '</div>' +
            '</div>' +
            '<div style="' + (!editor.options.image.editTitle ? 'display:none' : '') + '" class="jodit_form_group">' +
            '<label for="imageTitle">' + editor.i18n('Title') + '</label>' +
            '<input type="text" class="imageTitle"/>' +
            '</div>' +
            '<div style="' + (!editor.options.image.editAlt ? 'display:none' : '') + '" class="jodit_form_group">' +
            '<label for="imageAlt">' + editor.i18n('Alternative') + '</label>' +
            '<input type="text" class="imageAlt"/>' +
            '</div>' +
            '<div style="' + (!editor.options.image.editLink ? 'display:none' : '') + '" class="jodit_form_group">' +
            '<label for="imageLink">' + editor.i18n('Link') + '</label>' +
            '<input type="text" class="imageLink"/>' +
            '</div>' +
            '<div style="' + (!editor.options.image.editLink ? 'display:none' : '') + '" class="jodit_form_group">' +
            '<input type="checkbox" class="imageLinkOpenInNewTab"/> ' + editor.i18n('Open link in new tab') +
            '</div>', editor.ownerDocument), ratio = image.naturalWidth / image.naturalHeight || 1, $w = prop.querySelector('.imageWidth'), $h = prop.querySelector('.imageHeight'), updateAlign = function () {
            if (image.style.cssFloat && ['left', 'right'].indexOf(image.style.cssFloat.toLowerCase()) !== -1) {
                Helpers_1.val(prop, '.align', Helpers_1.css(image, 'float'));
            }
            else {
                if (Helpers_1.css(image, 'display') === 'block' && image.style.marginLeft === 'auto' && image.style.marginRight === 'auto') {
                    Helpers_1.val(prop, '.align', 'center');
                }
            }
        }, updateBorderRadius = function () {
            Helpers_1.val(prop, '.border_radius', (parseInt(image.style.borderRadius || '0', 10) || '0').toString());
        }, updateId = function () {
            Helpers_1.val(prop, '.id', image.getAttribute('id') || '');
        }, updateStyle = function () {
            Helpers_1.val(prop, '.style', image.getAttribute('style') || '');
        }, updateClasses = function () {
            Helpers_1.val(prop, '.classes', (image.getAttribute('class') || '').replace(/jodit_focused_image[\s]*/, ''));
        }, updateMargins = function () {
            if (!editor.options.image.editMargins) {
                return;
            }
            var notequal = false;
            Helpers_1.$$('.margins', prop).forEach(function (elm) {
                var id = elm.getAttribute('data-id') || '', value = image.style[id];
                if (!value) {
                    return;
                }
                if (/^[0-9]+(px)?$/.test(value)) {
                    value = parseInt(value, 10);
                }
                elm.value = value.toString() || '';
                if (!notequal && id !== 'marginTop' && elm.value !== Helpers_1.val(prop, '.marginTop')) {
                    notequal = true;
                }
            });
            lockMargin = !notequal;
            var lock_margin = prop.querySelector('.jodit_lock_margin');
            if (lock_margin) {
                lock_margin.innerHTML = ToolbarCollection_1.ToolbarIcon.getIcon(lockMargin ? 'lock' : 'unlock');
            }
            Helpers_1.$$('.margins:not(.marginTop)', prop).forEach(function (elm) { return !lockMargin ? elm.removeAttribute('disabled') : elm.setAttribute('disabled', 'true'); });
        }, updateSizes = function () {
            $w.value = image.offsetWidth.toString();
            $h.value = image.offsetHeight.toString();
        }, updateText = function () {
            if (image.hasAttribute('title')) {
                Helpers_1.val(prop, '.imageTitle', image.getAttribute('title') || '');
            }
            if (image.hasAttribute('alt')) {
                Helpers_1.val(prop, '.imageAlt', image.getAttribute('alt') || '');
            }
            var a = Dom_1.Dom.closest(image, 'a', editor.editor);
            if (a) {
                Helpers_1.val(prop, '.imageLink', a.getAttribute('href') || '');
                prop.querySelector('.imageLinkOpenInNewTab').checked = a.getAttribute('target') === '_blank';
            }
        }, updateSrc = function () {
            Helpers_1.val(prop, '.imageSrc', image.getAttribute('src') || '');
            var imageViewSrc = prop.querySelector('.imageViewSrc');
            if (imageViewSrc) {
                imageViewSrc.setAttribute('src', image.getAttribute('src') || '');
            }
        }, update = function () {
            updateSrc();
            updateText();
            updateSizes();
            updateMargins();
            updateClasses();
            updateId();
            updateBorderRadius();
            updateAlign();
            updateStyle();
        };
        var timer, lockSize = true, lockMargin = true, tabs = {}, tabsbox = prop.querySelector('.tabsbox');
        tabs[editor.i18n('Image')] = mainTab;
        tabs[editor.i18n('Advanced')] = positionTab;
        if (tabsbox) {
            tabsbox.appendChild(TabsWidget(editor, tabs));
        }
        update();
        editor.events.on(dialog, 'afterClose', function () {
            dialog.destruct();
            if (image.parentNode && editor.options.image.selectImageAfterClose) {
                editor.selection.select(image);
            }
        });
        buttons.remove.addEventListener('click', function () {
            if (image.parentNode) {
                image.parentNode.removeChild(image);
            }
            dialog.close();
        });
        if (editor.options.image.useImageEditor) {
            Helpers_1.$$('.jodit_use_image_editor', mainTab).forEach(function (btn) {
                editor.events
                    .on(btn, 'mousedown touchstart', function () {
                    var url = image.getAttribute('src') || '', a = editor.ownerDocument.createElement('a'), loadExternal = function () {
                        if (a.host !== location.host) {
                            Dialog_1.Confirm(editor.i18n('You can only edit your own images. Download this image on the host?'), function (yes) {
                                if (yes && editor.uploader) {
                                    editor.uploader.uploadRemoteImage(a.href.toString(), function (resp) {
                                        Dialog_1.Alert(editor.i18n('The image has been successfully uploaded to the host!'), function () {
                                            if (typeof resp.newfilename === 'string') {
                                                image.setAttribute('src', resp.baseurl + resp.newfilename);
                                                updateSrc();
                                            }
                                        });
                                    }, function (error) {
                                        Dialog_1.Alert(editor.i18n('There was an error loading %s', error.message));
                                    });
                                }
                            });
                            return;
                        }
                    };
                    a.href = url;
                    editor.getInstance('FileBrowser').getPathByUrl(a.href.toString(), function (path, name, source) {
                        editor.getInstance('FileBrowser')
                            .openImageEditor(a.href, name, path, source, function () {
                            var timestamp = (new Date()).getTime();
                            image.setAttribute('src', url + (url.indexOf('?') !== -1 ? '' : '?') + '&_tmp=' + timestamp.toString());
                            updateSrc();
                        }, function (error) {
                            Dialog_1.Alert(error.message);
                        });
                    }, function (error) {
                        Dialog_1.Alert(error.message, loadExternal);
                    });
                });
            });
        }
        Helpers_1.$$('.jodit_rechange', mainTab).forEach(function (imagebtn) {
            imagebtn.addEventListener('mousedown', function (e) {
                imagebtn.classList.toggle('active');
                var popup = new ToolbarCollection_1.ToolbarPopup(editor, imagebtn);
                popup.open(FileSelectorWidget(editor, {
                    upload: function (data) {
                        if (data.files && data.files.length) {
                            image.setAttribute('src', data.baseurl + data.files[0]);
                        }
                        update();
                        popup.close();
                    },
                    filebrowser: function (data) {
                        if (data && data.files && Array.isArray(data.files) && data.files.length) {
                            image.setAttribute('src', data.files[0]);
                            popup.close();
                            update();
                        }
                    }
                }, image, popup.close), true);
                e.stopPropagation();
            });
        });
        var jodit_lock_size = prop.querySelector('.jodit_lock_helper.jodit_lock_size');
        var jodit_lock_margin = prop.querySelector('.jodit_lock_helper.jodit_lock_margin');
        if (jodit_lock_size) {
            jodit_lock_size.addEventListener('click', function () {
                lockSize = !lockSize;
                this.innerHTML = ToolbarCollection_1.ToolbarIcon.getIcon(lockSize ? 'lock' : 'unlock');
                editor.events.fire($w, 'change');
            });
        }
        if (jodit_lock_margin) {
            jodit_lock_margin.addEventListener('click', function () {
                lockMargin = !lockMargin;
                this.innerHTML = ToolbarCollection_1.ToolbarIcon.getIcon(lockMargin ? 'lock' : 'unlock');
                if (!lockMargin) {
                    Helpers_1.$$('.margins', prop).forEach(function (elm) { if (!elm.matches('.marginTop'))
                        elm.removeAttribute('disabled'); });
                }
                else {
                    Helpers_1.$$('.margins', prop).forEach(function (elm) { if (!elm.matches('.marginTop'))
                        elm.setAttribute('disabled', 'true'); });
                }
            });
        }
        var changeSizes = function (e) {
            var w = parseInt($w.value, 10), h = parseInt($h.value, 10);
            if (e.target === $w) {
                $h.value = Math.round(w / ratio).toString();
            }
            else {
                $w.value = Math.round(h * ratio).toString();
            }
        };
        editor.events.on([$w, $h], 'change keydown mousedown paste', function (e) {
            if (!lockSize) {
                return;
            }
            if (editor.defaultTimeout) {
                clearTimeout(timer);
                timer = window.setTimeout(changeSizes.bind(_this, e), editor.defaultTimeout);
            }
            else {
                changeSizes(e);
            }
        });
        dialog.setTitle([editor.i18n('Image properties'), buttons.remove]);
        dialog.setContent(prop);
        cancel.addEventListener('click', function () {
            dialog.close();
        });
        check.addEventListener('click', function () {
            // styles
            if (editor.options.image.editStyle) {
                if (Helpers_1.val(prop, '.style')) {
                    image.setAttribute('style', Helpers_1.val(prop, '.style'));
                }
                else {
                    image.removeAttribute('style');
                }
            }
            // Src
            if (Helpers_1.val(prop, '.imageSrc')) {
                image.setAttribute('src', Helpers_1.val(prop, '.imageSrc'));
            }
            else {
                if (image.parentNode) {
                    image.parentNode.removeChild(image);
                }
                dialog.close();
                return;
            }
            // Border radius
            if (Helpers_1.val(prop, '.border_radius') !== '0' && /^[0-9]+$/.test(Helpers_1.val(prop, '.border_radius'))) {
                image.style.borderRadius = Helpers_1.val(prop, '.border_radius') + 'px';
            }
            else {
                image.style.borderRadius = '';
            }
            // Title
            if (Helpers_1.val(prop, '.imageTitle')) {
                image.setAttribute('title', Helpers_1.val(prop, '.imageTitle'));
            }
            else {
                image.removeAttribute('title');
            }
            // Alt
            if (Helpers_1.val(prop, '.imageAlt')) {
                image.setAttribute('alt', Helpers_1.val(prop, '.imageAlt'));
            }
            else {
                image.removeAttribute('alt');
            }
            // Link
            var link = Dom_1.Dom.closest(image, 'a', editor.editor);
            if (Helpers_1.val(prop, '.imageLink')) {
                if (!link) {
                    link = Dom_1.Dom.wrap(image, 'a', editor);
                }
                link.setAttribute('href', Helpers_1.val(prop, '.imageLink'));
                if (prop.querySelector('.imageLinkOpenInNewTab').checked) {
                    link.setAttribute('target', '_blank');
                }
                else {
                    link.removeAttribute('target');
                }
            }
            else {
                if (link && link.parentNode) {
                    link.parentNode.replaceChild(image, link);
                }
            }
            var normalSize = function (val) {
                val = Helpers_1.trim(val);
                return (/^[0-9]+$/).test(val) ? val + 'px' : val;
            };
            // Size
            if ($w.value !== image.offsetWidth.toString() || $h.value !== image.offsetHeight.toString()) {
                Helpers_1.css(image, {
                    width: Helpers_1.trim($w.value) ? normalSize($w.value) : null,
                    height: Helpers_1.trim($h.value) ? normalSize($h.value) : null
                });
            }
            if (editor.options.image.editMargins) {
                if (!lockMargin) {
                    Helpers_1.$$('.margins', prop).forEach(function (margin) {
                        var id = margin.getAttribute('data-id') || '';
                        Helpers_1.css(image, id, normalSize(margin.value));
                    });
                }
                else {
                    Helpers_1.css(image, 'margin', normalSize(Helpers_1.val(prop, '.marginTop')));
                }
            }
            if (editor.options.image.editClass) {
                if (Helpers_1.val(prop, '.classes')) {
                    image.setAttribute('class', Helpers_1.val(prop, '.classes'));
                }
                else {
                    image.removeAttribute('class');
                }
            }
            if (editor.options.image.editId) {
                if (Helpers_1.val(prop, '.id')) {
                    image.setAttribute('id', Helpers_1.val(prop, '.id'));
                }
                else {
                    image.removeAttribute('id');
                }
            }
            var clearCenterAlign = function () {
                if (Helpers_1.css(image, 'display') === 'block') {
                    Helpers_1.css(image, 'display', '');
                }
                if (image.style.marginLeft === 'auto' && image.style.marginRight === 'auto') {
                    image.style.marginLeft = '';
                    image.style.marginRight = '';
                }
            };
            if (editor.options.image.editAlign) {
                if (Helpers_1.val(prop, '.align')) {
                    if (['right', 'left'].indexOf(Helpers_1.val(prop, '.align').toLowerCase()) !== -1) {
                        Helpers_1.css(image, 'float', Helpers_1.val(prop, '.align'));
                        clearCenterAlign();
                    }
                    else {
                        Helpers_1.css(image, 'float', '');
                        Helpers_1.css(image, {
                            'display': 'block',
                            'margin-left': 'auto',
                            'margin-right': 'auto'
                        });
                    }
                }
                else {
                    if (Helpers_1.css(image, 'float') && ['right', 'left'].indexOf(Helpers_1.css(image, 'float').toString().toLowerCase()) !== -1) {
                        Helpers_1.css(image, 'float', '');
                    }
                    clearCenterAlign();
                }
            }
            if (!image.getAttribute('style')) {
                image.removeAttribute('style');
            }
            editor.setEditorValue();
            dialog.close();
        });
        dialog.setFooter([
            check,
            cancel
        ]);
        dialog.setSize(500);
        dialog.open();
        if (e) {
            e.preventDefault();
        }
        return false;
    };
    editor.events
        .on('afterInit', function () {
        if (editor.options.image.openOnDblClick) {
            editor.events.on(editor.editor, 'dblclick', open, 'img');
        }
        else {
            editor.events.on(editor.editor, 'dblclick', function (event) {
                event.stopImmediatePropagation();
                editor.selection.select(this);
            }, 'img');
        }
    })
        .on('openImageProperties', function (image) {
        open.call(image);
    });
}
exports.imageProperties = imageProperties;


/***/ }),
/* 49 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Plugin_1 = __webpack_require__(8);
var ToolbarCollection_1 = __webpack_require__(5);
var Helpers_1 = __webpack_require__(0);
var Table_1 = __webpack_require__(20);
var Config_1 = __webpack_require__(1);
var Widget_1 = __webpack_require__(10);
var ColorPickerWidget = Widget_1.Widget.ColorPickerWidget;
var TabsWidget = Widget_1.Widget.TabsWidget;
var Dom_1 = __webpack_require__(3);
Config_1.Config.prototype.toolbarInline = true;
Config_1.Config.prototype.toolbarInlineDisableFor = [];
Config_1.Config.prototype.popup = {
    a: [
        {
            name: 'eye',
            tooltip: 'Open link',
            exec: function (editor, current) {
                var href = current.getAttribute('href');
                if (current && href) {
                    editor.ownerWindow.open(href);
                }
            }
        },
        {
            name: 'link',
            tooltip: 'Edit link',
            icon: 'pencil'
        },
        'unlink',
        'brush',
        'file',
    ],
    img: [
        {
            name: 'bin',
            tooltip: 'Delete',
            exec: function (editor, image) {
                if (image.parentNode) {
                    image.parentNode.removeChild(image);
                    editor.events.fire('hidePopup');
                }
            }
        },
        {
            name: 'pencil',
            exec: function (editor, current) {
                var tagName = current.tagName.toLowerCase();
                if (tagName === 'img') {
                    editor.events.fire('openImageProperties', current);
                }
            },
            tooltip: 'Edit'
        },
        {
            name: 'valign',
            list: [
                'Top',
                'Middle',
                'Bottom'
            ],
            tooltip: 'Vertical align',
            exec: function (editor, image, control) {
                var tagName = image.tagName.toLowerCase();
                if (tagName !== 'img') {
                    return;
                }
                var command = (control.args && typeof control.args[1] === 'string') ? control.args[1].toLowerCase() : '';
                Helpers_1.css(image, 'vertical-align', command);
                editor.events.fire('recalcPositionPopup');
            }
        },
        {
            name: 'left',
            list: [
                'Left',
                'Right',
                'Center',
                'Normal'
            ],
            exec: function (editor, image, control) {
                var tagName = image.tagName.toLowerCase();
                if (tagName !== 'img') {
                    return;
                }
                var clearCenterAlign = function () {
                    if (Helpers_1.css(image, 'display') === 'block') {
                        Helpers_1.css(image, 'display', '');
                    }
                    if (image.style.marginLeft === 'auto' && image.style.marginRight === 'auto') {
                        image.style.marginLeft = '';
                        image.style.marginRight = '';
                    }
                };
                var command = (control.args && typeof control.args[1] === 'string') ? control.args[1].toLowerCase() : '';
                if (command !== 'normal') {
                    if (['right', 'left'].indexOf(command) !== -1) {
                        Helpers_1.css(image, 'float', command);
                        clearCenterAlign();
                    }
                    else {
                        Helpers_1.css(image, 'float', '');
                        Helpers_1.css(image, {
                            'display': 'block',
                            'margin-left': 'auto',
                            'margin-right': 'auto'
                        });
                    }
                }
                else {
                    if (Helpers_1.css(image, 'float') && ['right', 'left'].indexOf(Helpers_1.css(image, 'float').toLowerCase()) !== -1) {
                        Helpers_1.css(image, 'float', '');
                    }
                    clearCenterAlign();
                }
                editor.events.fire('recalcPositionPopup');
            },
            tooltip: 'Horizontal align'
        }
    ],
    table: [
        {
            name: 'brush',
            popup: function (editor, elm) {
                var $bg, $cl, $br, $tab, selected = Table_1.Table.getAllSelectedCells(elm), color, br_color, bg_color;
                if (!selected.length) {
                    return false;
                }
                color = Helpers_1.css(selected[0], 'color');
                bg_color = Helpers_1.css(selected[0], 'background-color');
                br_color = Helpers_1.css(selected[0], 'border-color');
                $bg = ColorPickerWidget(editor, function (value) {
                    selected.forEach(function (cell) {
                        Helpers_1.css(cell, 'background-color', value);
                    });
                    editor.setEditorValue();
                    // close();
                }, bg_color);
                $cl = ColorPickerWidget(editor, function (value) {
                    selected.forEach(function (cell) {
                        Helpers_1.css(cell, 'color', value);
                    });
                    editor.setEditorValue();
                    // close();
                }, color);
                $br = ColorPickerWidget(editor, function (value) {
                    selected.forEach(function (cell) {
                        Helpers_1.css(cell, 'border-color', value);
                    });
                    editor.setEditorValue();
                    // close();
                }, br_color);
                $tab = TabsWidget(editor, {
                    Background: $bg,
                    Text: $cl,
                    Border: $br,
                });
                return $tab;
            },
            tooltip: 'Background'
        },
        {
            name: 'valign',
            list: [
                'Top',
                'Middle',
                'Bottom'
            ],
            exec: function (editor, table, control) {
                var command = (control.args && typeof control.args[1] === 'string') ? control.args[1].toLowerCase() : '';
                Table_1.Table.getAllSelectedCells(table).forEach(function (cell) {
                    Helpers_1.css(cell, 'vertical-align', command);
                });
            },
            tooltip: 'Vertical align'
        },
        {
            name: 'splitv',
            list: {
                tablesplitv: 'Split vertical',
                tablesplitg: 'Split horizontal'
            },
            tooltip: 'Split'
        },
        {
            name: 'align',
            icon: 'left'
        },
        "\n",
        {
            name: 'merge',
            command: 'tablemerge',
            tooltip: 'Merge'
        },
        {
            name: 'addcolumn',
            list: {
                tableaddcolumnbefore: 'Insert column before',
                tableaddcolumnafter: 'Insert column after'
            },
            exec: function (editor, table, control) {
                var command = (control.args && typeof control.args[0] === 'string') ? control.args[0].toLowerCase() : '';
                editor.execCommand(command, false, table);
            },
            tooltip: 'Add column'
        },
        {
            name: 'addrow',
            list: {
                tableaddrowbefore: 'Insert row above',
                tableaddrowafter: 'Insert row below'
            },
            exec: function (editor, table, control) {
                var command = (control.args && typeof control.args[0] === 'string') ? control.args[0].toLowerCase() : '';
                editor.execCommand(command, false, table);
            },
            tooltip: 'Add row'
        },
        {
            name: 'bin',
            list: {
                tablebin: 'Delete table',
                tablebinrow: 'Delete row',
                tablebincolumn: 'Delete column',
                tableempty: 'Empty cell'
            },
            exec: function (editor, table, control) {
                var command = (control.args && typeof control.args[0] === 'string') ? control.args[0].toLowerCase() : '';
                editor.execCommand(command, false, table);
            },
            tooltip: 'Delete'
        }
    ]
};
/**
 * Support inline toolbar
 *
 * @param {Jodit} editor
 */
var inlinePopup = /** @class */ (function (_super) {
    __extends(inlinePopup, _super);
    function inlinePopup(jodit) {
        var _this = _super.call(this, jodit) || this;
        _this.isShown = false;
        _this.calcWindSizes = function () {
            var win = _this.jodit.ownerWindow;
            var docElement = _this.jodit.ownerDocument.documentElement;
            var body = _this.jodit.ownerDocument.body;
            var scrollTop = win.pageYOffset || docElement.scrollTop || body.scrollTop;
            var clientTop = docElement.clientTop || body.clientTop || 0;
            var scrollLeft = win.pageXOffset || docElement.scrollLeft || body.scrollLeft;
            var clientLeft = docElement.clientLeft || body.clientLeft || 0;
            var windWidth = docElement.clientWidth + scrollLeft - clientLeft;
            var windHeight = docElement.clientHeight + scrollTop - clientTop;
            return {
                left: clientLeft,
                top: clientTop,
                width: windWidth,
                height: windHeight
            };
        };
        _this._hiddenClass = 'jodit_toolbar_popup-inline-target-hidden';
        _this.calcPosition = function (rect, windowSize) {
            _this.popup.target.classList.remove(_this._hiddenClass);
            var selectionCenterLeft = rect.left + rect.width / 2;
            var workplacePosition = Helpers_1.offset(_this.jodit.workplace, _this.jodit, _this.jodit.ownerDocument, true);
            var targetTop = rect.top + rect.height + 10;
            var diff = 50;
            _this.target.style.left = selectionCenterLeft + 'px';
            _this.target.style.top = targetTop + 'px';
            if (_this.jodit.isFullSize()) {
                _this.target.style.zIndex = Helpers_1.css(_this.jodit.container, 'zIndex').toString();
            }
            var halfWidthPopup = _this.container.offsetWidth / 2;
            var marginLeft = -halfWidthPopup;
            _this.popup.container.classList.remove('jodit_toolbar_popup-inline-top');
            if (targetTop + _this.container.offsetHeight > windowSize.height) {
                targetTop = rect.top - _this.container.offsetHeight - 10;
                _this.target.style.top = targetTop + 'px';
                _this.popup.container.classList.add('jodit_toolbar_popup-inline-top');
            }
            if (selectionCenterLeft - halfWidthPopup < 0) {
                marginLeft = -(rect.width / 2 + rect.left);
            }
            if (selectionCenterLeft + halfWidthPopup > windowSize.width) {
                marginLeft = -(_this.container.offsetWidth - (windowSize.width - selectionCenterLeft));
            }
            _this.container.style.marginLeft = marginLeft + 'px';
            if (workplacePosition.top - targetTop > diff || targetTop - (workplacePosition.top + workplacePosition.height) > diff) {
                _this.popup.target.classList.add(_this._hiddenClass);
            }
        };
        _this.reCalcPosition = function () {
            if (_this.__getRect) {
                _this.calcPosition(_this.__getRect(), _this.calcWindSizes());
            }
        };
        _this.showPopup = function (rect, type, elm) {
            if (!_this.jodit.options.toolbarInline ||
                !_this.jodit.options.popup[type.toLowerCase()]) {
                return false;
            }
            if (_this.isExcludedTarget(type)) {
                return true;
            }
            _this.isShown = true;
            _this.isTargetAction = true;
            var windSize = _this.calcWindSizes();
            _this.target.parentNode || _this.jodit.ownerDocument.body.appendChild(_this.target);
            _this.toolbar.build(_this.jodit.options.popup[type.toLowerCase()], _this.container, elm);
            _this.popup.open(_this.container, false, true);
            _this.__getRect = rect;
            _this.calcPosition(rect(), windSize);
            return true;
        };
        _this.hidePopup = function (root) {
            if (root && (root instanceof _this.jodit.editorWindow.Node || root instanceof ToolbarCollection_1.ToolbarPopup) && Dom_1.Dom.isOrContains(_this.target, root instanceof ToolbarCollection_1.ToolbarPopup ? root.target : root)) {
                return;
            }
            _this.isTargetAction = false;
            _this.isShown = false;
            _this.popup.close();
            _this.target.parentNode && _this.target.parentNode.removeChild(_this.target);
        };
        // was started selection
        _this.isSelectionStarted = false;
        _this.onSelectionEnd = Helpers_1.debounce(function () {
            if (!_this.jodit.isEditorMode()) {
                return;
            }
            if (_this.isSelectionStarted) {
                if (!_this.isTargetAction) {
                    _this.onChangeSelection();
                }
            }
            _this.isSelectionStarted = false;
            _this.isTargetAction = false;
        }, _this.jodit.defaultTimeout);
        _this.isTargetAction = false;
        /**
         * Popup was opened for some selection text (not for image or link)
         * @type {boolean}
         */
        _this.isSelectionPopup = false;
        _this.onSelectionStart = function (event) {
            if (!_this.jodit.isEditorMode()) {
                return;
            }
            _this.isTargetAction = false;
            _this.isSelectionPopup = false;
            if (!_this.isSelectionStarted) {
                var elements = Object.keys(_this.jodit.options.popup).join('|');
                var target_1 = event.target.nodeName === 'IMG' ? event.target : Dom_1.Dom.closest(event.target, elements, _this.jodit.editor);
                if (!target_1 || !_this.showPopup(function () { return Helpers_1.offset(target_1, _this.jodit, _this.jodit.editorDocument); }, target_1.nodeName, target_1)) {
                    _this.isSelectionStarted = true;
                }
            }
        };
        _this.onChangeSelection = function () {
            if (!_this.jodit.options.toolbarInline || !_this.jodit.isEditorMode()) {
                return;
            }
            if (_this.hideIfCollapsed()) {
                return;
            }
            if (_this.jodit.options.popup.selection !== undefined) {
                var sel = _this.jodit.editorWindow.getSelection();
                if (sel.rangeCount) {
                    _this.isSelectionPopup = true;
                    var range_1 = sel.getRangeAt(0);
                    _this.showPopup(function () { return Helpers_1.offset(range_1, _this.jodit, _this.jodit.editorDocument); }, 'selection');
                }
            }
        };
        _this.checkIsTargetEvent = function () {
            if (!_this.isTargetAction) {
                _this.hidePopup();
            }
            else {
                _this.isTargetAction = false;
            }
        };
        _this.toolbar = new ToolbarCollection_1.ToolbarCollection(jodit);
        _this.target = jodit.ownerDocument.createElement('div');
        _this.container = jodit.ownerDocument.createElement('div');
        _this.target.classList.add('jodit_toolbar_popup-inline-target');
        _this.popup = new ToolbarCollection_1.ToolbarPopup(jodit, _this.target, void (0), 'jodit_toolbar_popup-inline');
        return _this;
    }
    inlinePopup.prototype.isExcludedTarget = function (type) {
        return Helpers_1.splitArray(this.jodit.options.toolbarInlineDisableFor)
            .map(function (a) { return a.toLowerCase(); })
            .indexOf(type.toLowerCase()) !== -1;
    };
    inlinePopup.prototype.hideIfCollapsed = function () {
        if (this.jodit.selection.isCollapsed()) {
            this.hidePopup();
            return true;
        }
        return false;
    };
    ;
    inlinePopup.prototype.afterInit = function (editor) {
        var _this = this;
        editor.events
            .on(this.target, 'mousedown keydown touchstart', function (e) {
            e.stopPropagation();
        })
            .on('beforeOpenPopup hidePopup', this.hidePopup)
            .on('recalcPositionPopup', this.reCalcPosition)
            .on('getDiffButtons.mobile', function (_toolbar) {
            if (_this.toolbar === _toolbar) {
                return Helpers_1.splitArray(editor.options.buttons)
                    .filter(function (name) { return name !== '|' && name !== '\n'; })
                    .filter(function (name) {
                    return _this.toolbar.getButtonsList().indexOf(name) < 0;
                });
            }
        })
            .on('selectionchange', this.onChangeSelection)
            .on('afterCommand afterExec', function () {
            if (_this.isShown && _this.isSelectionPopup) {
                _this.onChangeSelection();
            }
        })
            .on('showPopup', function (elm, rect) {
            var elementName = (typeof elm === 'string' ? elm : elm.nodeName).toLowerCase();
            _this.isSelectionPopup = false;
            _this.showPopup(rect, elementName, typeof elm === 'string' ? void (0) : elm);
        })
            .on('mousedown keydown touchstart', this.onSelectionStart)
            .on([editor.ownerWindow, editor.editor], 'scroll resize', this.reCalcPosition)
            .on([editor.ownerWindow], 'mouseup keyup touchend', this.onSelectionEnd)
            .on([editor.ownerWindow], 'mousedown keydown touchstart', this.checkIsTargetEvent);
    };
    inlinePopup.prototype.beforeDestruct = function (editor) {
        this.popup.destruct();
        this.toolbar.destruct();
        this.target.parentNode && this.target.parentNode.removeChild(this.target);
        editor.events
            .off([editor.ownerWindow], 'scroll resize', this.reCalcPosition)
            .off([editor.ownerWindow], 'mouseup keyup touchend', this.onSelectionEnd)
            .off([editor.ownerWindow], 'mousedown keydown touchstart', this.checkIsTargetEvent);
        _super.prototype.destruct.call(this);
    };
    return inlinePopup;
}(Plugin_1.Plugin));
exports.inlinePopup = inlinePopup;


/***/ }),
/* 50 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Helpers_1 = __webpack_require__(0);
var Dom_1 = __webpack_require__(3);
var Config_1 = __webpack_require__(1);
var ToolbarCollection_1 = __webpack_require__(5);
Config_1.Config.prototype.controls.align = {
    name: 'left',
    tooltip: "Align",
    getLabel: function (editor, btn, button) {
        var current = editor.selection.current();
        if (current) {
            var currentBox = Dom_1.Dom.closest(current, Dom_1.Dom.isBlock, editor.editor) || editor.editor;
            var currentValue = Helpers_1.css(currentBox, 'text-align').toString();
            if (btn.defaultValue && btn.defaultValue.indexOf(currentValue) !== -1) {
                currentValue = 'left';
            }
            if (btn.data && btn.data.currentValue !== currentValue && btn.list && btn.list.indexOf(currentValue) !== -1) {
                button.textBox.innerHTML = !editor.options.textIcons ? ToolbarCollection_1.ToolbarIcon.getIcon(currentValue, '') : "<span>" + currentValue + "</span>";
                button.textBox.firstChild.classList.add('jodit_icon');
                btn.data.currentValue = currentValue;
            }
        }
        return false;
    },
    isActive: function (editor, btn) {
        var current = editor.selection.current();
        if (current && btn.defaultValue) {
            var currentBox = Dom_1.Dom.closest(current, Dom_1.Dom.isBlock, editor.editor) || editor.editor;
            return btn.defaultValue.indexOf(Helpers_1.css(currentBox, 'text-align').toString()) === -1;
        }
        return false;
    },
    defaultValue: ['left', 'start', 'inherit'],
    data: {
        currentValue: 'left'
    },
    list: [
        'center',
        'left',
        'right',
        'justify',
    ],
};
Config_1.Config.prototype.controls.center = {
    command: 'justifyCenter',
    tags: ["center"],
    css: {
        "text-align": "center"
    },
    tooltip: "Align Center"
};
Config_1.Config.prototype.controls.justify = {
    command: 'justifyFull',
    css: {
        "text-align": "justify"
    },
    tooltip: "Align Justify"
};
Config_1.Config.prototype.controls.left = {
    command: 'justifyLeft',
    css: {
        "text-align": "left"
    },
    tooltip: "Align Left"
};
Config_1.Config.prototype.controls.right = {
    command: 'justifyRight',
    css: {
        "text-align": "right"
    },
    tooltip: "Align Right"
};
/**
 * Process commands: `justifyfull`, `justifyleft`, `justifyright`, `justifycenter`
 *
 * @param {Jodit} editor
 */
function justify(editor) {
    var callback = function (command) {
        var justify = function (box) {
            if (box instanceof editor.editorWindow.HTMLElement) {
                switch (command.toLowerCase()) {
                    case 'justifyfull':
                        box.style.textAlign = 'justify';
                        break;
                    case 'justifyright':
                        box.style.textAlign = 'right';
                        break;
                    case 'justifyleft':
                        box.style.textAlign = 'left';
                        break;
                    case 'justifycenter':
                        box.style.textAlign = 'center';
                        break;
                }
            }
        };
        editor.selection.focus();
        editor.selection.eachSelection(function (current) {
            if (!current) {
                if (editor.editor.querySelector('.jodit_selected_cell')) {
                    Helpers_1.$$('.jodit_selected_cell', editor.editor).forEach(justify);
                    return false;
                }
            }
            if (!(current instanceof editor.editorWindow.Node)) {
                return;
            }
            var currentBox = current ? Dom_1.Dom.up(current, Dom_1.Dom.isBlock, editor.editor) : false;
            if (!currentBox && current) {
                currentBox = Dom_1.Dom.wrapInline(current, editor.options.enter, editor);
            }
            justify(currentBox);
        });
        return false;
    };
    editor.registerCommand('justifyfull', callback);
    editor.registerCommand('justifyright', callback);
    editor.registerCommand('justifyleft', callback);
    editor.registerCommand('justifycenter', callback);
}
exports.justify = justify;


/***/ }),
/* 51 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Config_1 = __webpack_require__(1);
var Helpers_1 = __webpack_require__(0);
var Dom_1 = __webpack_require__(3);
Config_1.Config.prototype.link = {
    followOnDblClick: true,
    processVideoLink: true,
    processPastedLink: true,
    openLinkDialogAfterPost: true,
    removeLinkAfterFormat: true,
};
Config_1.Config.prototype.controls.unlink = {
    exec: function (editor, current) {
        var anchor = Dom_1.Dom.closest(current, 'A', editor.editor);
        if (anchor) {
            Dom_1.Dom.unwrap(anchor);
        }
        editor.events.fire('hidePopup');
    }
};
Config_1.Config.prototype.controls.link = {
    isActive: function (editor) {
        var current = editor.selection.current();
        return current && Dom_1.Dom.closest(current, 'a', editor.editor) !== false;
    },
    popup: function (editor, current, self, close) {
        var sel = editor.editorWindow.getSelection(), form = Helpers_1.dom('<form class="jodit_form">' +
            '<input required type="text" name="url" placeholder="http://" type="text"/>' +
            '<input name="text" placeholder="' + editor.i18n('Text') + '" type="text"/>' +
            '<label>' +
            '<input name="target" type="checkbox"/> ' + editor.i18n('Open in new tab') +
            '</label>' +
            '<label>' +
            '<input name="nofollow" type="checkbox"/> ' + editor.i18n('No follow') +
            '</label>' +
            '<div style="text-align: right">' +
            '<button class="jodit_unlink_button" type="button">' + editor.i18n('Unlink') + '</button> &nbsp;&nbsp;' +
            '<button class="jodit_link_insert_button" type="submit"></button>' +
            '</div>' +
            '<form/>', editor.ownerDocument);
        if (current && Dom_1.Dom.closest(current, 'A', editor.editor)) {
            current = Dom_1.Dom.closest(current, 'A', editor.editor);
        }
        else {
            current = false;
        }
        var link = form.querySelector('.jodit_link_insert_button');
        var unlink = form.querySelector('.jodit_unlink_button');
        if (current) {
            Helpers_1.val(form, 'input[name=url]', current.getAttribute('href') || '');
            Helpers_1.val(form, 'input[name=text]', current.innerText);
            form.querySelector('input[name=target]').checked = (current.getAttribute('target') === '_blank');
            form.querySelector('input[name=nofollow]').checked = (current.getAttribute('rel') === 'nofollow');
            if (link) {
                link.innerHTML = editor.i18n('Update');
            }
        }
        else {
            if (unlink) {
                unlink.style.display = 'none';
            }
            Helpers_1.val(form, 'input[name=text]', sel.toString());
            if (link) {
                link.innerHTML = editor.i18n('Insert');
            }
        }
        var selInfo = editor.selection.save();
        if (unlink) {
            unlink.addEventListener('mousedown', function (e) {
                if (current) {
                    Dom_1.Dom.unwrap(current);
                }
                editor.selection.restore(selInfo);
                close();
                e.preventDefault();
            });
        }
        form.addEventListener('submit', function (event) {
            event.preventDefault();
            editor.selection.restore(selInfo);
            var a = current || editor.editorDocument.createElement('a');
            if (!Helpers_1.val(form, 'input[name=url]')) {
                form.querySelector('input[name=url]').focus();
                form.querySelector('input[name=url]').classList.add('jodit_error');
                return false;
            }
            a.setAttribute('href', Helpers_1.val(form, 'input[name=url]'));
            a.innerText = Helpers_1.val(form, 'input[name=text]');
            if (form.querySelector('input[name=target]').checked) {
                a.setAttribute('target', '_blank');
            }
            else {
                a.removeAttribute('target');
            }
            if (form.querySelector('input[name=nofollow]').checked) {
                a.setAttribute('rel', 'nofollow');
            }
            else {
                a.removeAttribute('rel');
            }
            if (!current) {
                editor.selection.insertNode(a);
            }
            close();
            return false;
        });
        return form;
    },
    tags: ["a"],
    tooltip: "Insert link"
};
/**
 * Process link. Insert, dbclick or remove format
 *
 * @module plugins/link
 */
function link(jodit) {
    if (jodit.options.link.followOnDblClick) {
        jodit.events.on('afterInit', function () {
            jodit.events.on(jodit.editor, 'dblclick', function (e) {
                var href = this.getAttribute('href');
                if (href) {
                    location.href = href;
                    e.preventDefault();
                }
            }, 'a');
        });
    }
    if (jodit.options.link.processPastedLink) {
        jodit.events.on('processPaste', function (event, html) {
            if (Helpers_1.isURL(html)) {
                var embed = Helpers_1.convertMediaURLToVideoEmbed(html);
                if (embed !== html) {
                    return Helpers_1.dom(embed, jodit.editorDocument);
                }
                var a = jodit.editorDocument.createElement('a');
                a.setAttribute('href', html);
                a.innerText = html;
                if (jodit.options.link.openLinkDialogAfterPost) {
                    setTimeout(function () {
                        //parent.selection.setCursorIn(a, true);
                        //editor.selection.selectNodes(Array.prototype.slice.call(a.childNodes));
                    }, 100);
                }
                return a;
            }
        });
    }
    if (jodit.options.link.removeLinkAfterFormat) {
        jodit.events.on('afterCommand', function (command) {
            var sel = jodit.selection, newtag, node;
            if (command === 'removeFormat') {
                node = sel.current();
                if (node && node.nodeName !== 'A') {
                    node = Dom_1.Dom.closest(node, 'A', jodit.editor);
                }
                if (node && node.nodeName === 'A') {
                    if (node.innerHTML === node.innerText) {
                        newtag = jodit.editorDocument.createTextNode(node.innerHTML);
                    }
                    else {
                        newtag = jodit.editorDocument.createElement('span');
                        newtag.innerHTML = node.innerHTML;
                    }
                    if (node.parentNode) {
                        node.parentNode.replaceChild(newtag, node);
                        jodit.selection.setCursorIn(newtag, true);
                    }
                }
            }
        });
    }
}
exports.link = link;


/***/ }),
/* 52 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Config_1 = __webpack_require__(1);
var ToolbarCollection_1 = __webpack_require__(5);
var consts = __webpack_require__(2);
var Helpers_1 = __webpack_require__(0);
Config_1.Config.prototype.mobileTapTimeout = 300;
/**
 * After resize it will change buttons set for different sizes
 *
 * @type {boolean}
 */
Config_1.Config.prototype.toolbarAdaptive = true;
Config_1.Config.prototype.controls.dots = {
    mode: consts.MODE_SOURCE + consts.MODE_WYSIWYG,
    popup: function (editor, current, control, close, button) {
        var store = control.data;
        if (store === undefined) {
            store = {
                container: editor.ownerDocument.createElement('div'),
                toolbar: new ToolbarCollection_1.ToolbarCollection(editor),
                rebuild: function () {
                    var buttons = editor.events.fire('getDiffButtons.mobile', button.parentToolbar);
                    if (buttons && store) {
                        store.toolbar.build(Helpers_1.splitArray(buttons), store.container);
                    }
                }
            };
            store.container.style.width = '100px';
            control.data = store;
        }
        store.rebuild();
        return store.container;
    }
};
/**
 * Rebuild toolbar in depends of editor's width
 */
function mobile(editor) {
    var timeout = 0, now, store = Helpers_1.splitArray(editor.options.buttons);
    editor.events
        .on('touchend', function (e) {
        if (e.changedTouches.length) {
            now = (new Date()).getTime();
            if (now - timeout > editor.options.mobileTapTimeout) {
                timeout = now;
                editor.selection.insertCursorAtPoint(e.changedTouches[0].clientX, e.changedTouches[0].clientY);
            }
        }
    })
        .on('getDiffButtons.mobile', function (toolbar) {
        if (toolbar === editor.toolbar) {
            return Helpers_1.splitArray(editor.options.buttons).filter(function (i) {
                return store.indexOf(i) < 0;
            });
        }
    });
    if (editor.options.toolbarAdaptive) {
        editor.events.on('resize afterInit', function () {
            if (!editor.options.toolbar) {
                return;
            }
            var width = editor.container.offsetWidth;
            var newStore = [];
            if (width >= editor.options.sizeLG) {
                newStore = Helpers_1.splitArray(editor.options.buttons);
            }
            else if (width >= editor.options.sizeMD) {
                newStore = Helpers_1.splitArray(editor.options.buttonsMD);
            }
            else if (width >= editor.options.sizeSM) {
                newStore = Helpers_1.splitArray(editor.options.buttonsSM);
            }
            else {
                newStore = Helpers_1.splitArray(editor.options.buttonsXS);
            }
            if (newStore.toString() !== store.toString()) {
                store = newStore;
                editor.toolbar.build(store.concat(editor.options.extraButtons), editor.container);
            }
        });
    }
}
exports.mobile = mobile;


/***/ }),
/* 53 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Dom_1 = __webpack_require__(3);
var Config_1 = __webpack_require__(1);
Config_1.Config.prototype.controls.ul = {
    command: 'insertUnorderedList',
    controlName: 'ul',
    tags: ["ul"],
    tooltip: "Insert Unordered List"
};
Config_1.Config.prototype.controls.ol = {
    command: 'insertOrderedList',
    controlName: 'ol',
    tags: ["ol"],
    tooltip: "Insert Ordered List"
};
/**
 * Process commands insertOrderedList and insertUnOrderedList
 */
function orderedlist(editor) {
    editor.events.on('afterCommand', function (command) {
        if (/insert(un)?orderedlist/i.test(command)) {
            var ul = Dom_1.Dom.up(editor.selection.current(), function (tag) { return (tag && /^UL|OL$/i.test(tag.nodeName)); }, editor.editor);
            if (ul && ul.parentNode && ul.parentNode.nodeName === 'P') {
                var selection = editor.selection.save();
                Dom_1.Dom.unwrap(ul.parentNode);
                [].slice.call(ul.childNodes).forEach(function (li) {
                    if (li.lastChild && li.lastChild.nodeType === Node.ELEMENT_NODE && li.lastChild.nodeName === 'BR') {
                        li.removeChild(li.lastChild);
                    }
                });
                editor.selection.restore(selection);
            }
            editor.setEditorValue();
        }
    });
}
exports.orderedlist = orderedlist;


/***/ }),
/* 54 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Dialog_1 = __webpack_require__(7);
var Helpers_1 = __webpack_require__(0);
var Config_1 = __webpack_require__(1);
var constants_1 = __webpack_require__(2);
Config_1.Config.prototype.askBeforePasteHTML = true;
Config_1.Config.prototype.askBeforePasteFromWord = true;
Config_1.Config.prototype.defaultActionOnPaste = constants_1.INSERT_AS_HTML;
Config_1.Config.prototype.controls.cut = {
    command: 'cut',
    isDisable: function (editor) {
        var sel = editor.editorWindow.getSelection();
        return !sel || sel.isCollapsed;
    },
    tooltip: 'Cut selection'
};
/**
 * Ask before paste HTML source
 *
 * @module insertHTML
 */
function paste(editor) {
    var buffer = '';
    var strip_tags = function (html) {
        var div = document.createElement('div');
        div.innerHTML = html;
        return div.innerText;
    };
    var ClearOrKeep = function (msg, title, callback, clearButton, clear2Button) {
        if (clearButton === void 0) { clearButton = 'Clean'; }
        if (clear2Button === void 0) { clear2Button = 'Insert only Text'; }
        if (editor.events && editor.events.fire('beforeOpenPasteDialog', msg, title, callback, clearButton, clear2Button) === false) {
            return;
        }
        var dialog = Dialog_1.Confirm("<div style=\"word-break: normal; white-space: normal\">" + msg + "</div>", title, callback);
        dialog.dialogbox.setAttribute('data-editor_id', editor.id);
        var keep = Helpers_1.dom('<a href="javascript:void(0)" style="float:left;" class="jodit_button">' +
            '<span>' + editor.i18n('Keep') + '</span>' +
            '</a>', dialog.document);
        var clear = Helpers_1.dom('<a href="javascript:void(0)" style="float:left;" class="jodit_button">' +
            '<span>' + editor.i18n(clearButton) + '</span>' +
            '</a>', dialog.document);
        var clear2 = Helpers_1.dom('<a href="javascript:void(0)" style="float:left;" class="jodit_button">' +
            '<span>' + editor.i18n(clear2Button) + '</span>' +
            '</a>', dialog.document);
        var cancel = Helpers_1.dom('<a href="javascript:void(0)" style="float:right;" class="jodit_button">' +
            '<span>' + editor.i18n('Cancel') + '</span>' +
            '</a>', dialog.document);
        editor.events.on(keep, 'click', function () {
            dialog.close();
            callback && callback(true);
        });
        editor.events.on(clear, 'click', function () {
            dialog.close();
            callback && callback(false);
        });
        editor.events.on(clear2, 'click', function () {
            dialog.close();
            callback && callback(0);
        });
        editor.events.on(cancel, 'click', function () {
            dialog.close();
        });
        dialog.setFooter([
            keep,
            clear,
            clear2Button ? clear2 : '',
            cancel,
        ]);
        editor.events && editor.events.fire('afterOpenPasteDialog', dialog, msg, title, callback, clearButton, clear2Button);
        return dialog;
    };
    var insertByType = function (html, type) {
        switch (type) {
            case constants_1.INSERT_CLEAR_HTML:
                html = Helpers_1.cleanFromWord(html);
                break;
            case constants_1.INSERT_ONLY_TEXT:
                html = strip_tags(html);
                break;
            case constants_1.INSERT_AS_TEXT:
                html = Helpers_1.htmlspecialchars(html);
                break;
            default:
        }
        editor.selection.insertHTML(html);
    };
    var insertHTML = function (html, event) {
        if (Helpers_1.isHTML(html) && buffer !== trimFragment(html)) {
            editor.events.stopPropagation('beforePaste');
            html = trimFragment(html);
            ClearOrKeep(editor.i18n('Your code is similar to HTML. Keep as HTML?'), editor.i18n('Paste as HTML'), function (agree) {
                var insertType = constants_1.INSERT_AS_HTML;
                if (agree === false) {
                    insertType = constants_1.INSERT_AS_TEXT;
                }
                if (agree === 0) {
                    insertType = constants_1.INSERT_ONLY_TEXT;
                }
                if (event.type === 'drop') {
                    editor.selection.insertCursorAtPoint(event.clientX, event.clientY);
                }
                insertByType(html, insertType);
                editor.setEditorValue();
            }, 'Insert as Text');
            return false;
        }
    };
    var trimFragment = function (html) {
        var start = html.search(/<!--StartFragment-->/i);
        if (start !== -1) {
            html = html.substr(start + 20);
        }
        var end = html.search(/<!--EndFragment-->/i);
        if (end !== -1) {
            html = html.substr(0, end);
        }
        return html;
    };
    var getDataTransfer = function (event) {
        if (event.clipboardData) {
            return event.clipboardData;
        }
        return event.dataTransfer;
    };
    editor.events
        .on('copy cut', function (event) {
        var selectedText = editor.selection.getHTML();
        var clipboardData = getDataTransfer(event) || getDataTransfer(editor.editorWindow) || getDataTransfer(event.originalEvent);
        clipboardData.setData(constants_1.TEXT_PLAIN, strip_tags(selectedText));
        clipboardData.setData(constants_1.TEXT_HTML, selectedText);
        buffer = selectedText;
        if (event.type === 'cut') {
            editor.selection.remove();
            editor.selection.focus();
        }
        event.preventDefault();
        editor.events.fire('afterCopy', selectedText);
    })
        .on('paste', function (event) {
        /**
         * Triggered before pasting something into the Jodit Editor
         *
         * @event beforePaste
         * @param {ClipboardEvent} event
         * @return Returning false in the handler assigned toWYSIWYG the event will cancel the current action.
         * @example
         * ```javascript
         * var editor = new Jodit("#redactor");
         * editor.events.on('beforePaste', function (event) {
             *     return false; // deny paste
             * });
         * ```
         */
        if (editor.events.fire('beforePaste', event) === false) {
            event.preventDefault();
            return false;
        }
        if (event && getDataTransfer(event)) {
            var i = void 0, types = getDataTransfer(event).types, types_str = '', clipboard_html = '';
            if (Array.isArray(types) || Helpers_1.type(types) === 'domstringlist') {
                for (i = 0; i < types.length; i += 1) {
                    types_str += types[i] + ";";
                }
            }
            else {
                types_str = types;
            }
            if (/text\/html/i.test(types_str)) {
                clipboard_html = getDataTransfer(event).getData("text/html");
            }
            else if (/text\/rtf/i.test(types_str) && Helpers_1.browser('safari')) {
                clipboard_html = getDataTransfer(event).getData("text/rtf");
            }
            else if (/text\/plain/i.test(types_str) && !Helpers_1.browser('mozilla')) {
                clipboard_html = getDataTransfer(event).getData(constants_1.TEXT_PLAIN);
            }
            else if (/text/i.test(types_str) && Helpers_1.isIE) {
                clipboard_html = getDataTransfer(event).getData(constants_1.TEXT_PLAIN);
            }
            if (clipboard_html instanceof editor.editorWindow.Node || Helpers_1.trim(clipboard_html) !== '') {
                /**
                 * Triggered after the content is pasted from the clipboard into the Jodit. If a string is returned the new string will be used as the pasted content.
                 *
                 * @event beforePaste
                 * @param {ClipboardEvent} event
                 * @return Return {string|undefined}
                 * @example
                 * ```javascript
                 * var editor = new Jodit("#redactor");
                 * editor.events.on('beforePaste', function (event) {
                     *     return false; // deny paste
                     * });
                 * ```
                 */
                clipboard_html = trimFragment(clipboard_html);
                if (buffer !== clipboard_html) {
                    clipboard_html = editor.events.fire('processPaste', event, clipboard_html);
                }
                if (typeof clipboard_html === 'string' || clipboard_html instanceof editor.editorWindow.Node) {
                    if (event.type === 'drop') {
                        editor.selection.insertCursorAtPoint(event.clientX, event.clientY);
                    }
                    insertByType(clipboard_html, editor.options.defaultActionOnPaste);
                }
                event.preventDefault();
                event.stopPropagation();
            }
        }
        /**
         * Triggered after pasting something into the Jodit
         *
         * @event afterPaste
         * @param {ClipboardEvent} event
         * @return Return {string|undefined}
         * @example
         * ```javascript
         * var editor = new Jodit("#redactor");
         * editor.events.on('afterPaste', function (event) {
             *     return false; // deny paste
             * });
         * ```
         */
        if (editor.events.fire('afterPaste', event) === false) {
            return false;
        }
    });
    if (editor.options.askBeforePasteHTML) {
        editor.events
            .on('beforePaste', function (event) {
            if (event && getDataTransfer(event).getData(constants_1.TEXT_PLAIN)) {
                var html = getDataTransfer(event).getData(constants_1.TEXT_PLAIN);
                return insertHTML(html, event);
            }
        });
    }
    if (editor.options.askBeforePasteFromWord) {
        editor.events
            .on('beforePaste', function (event) {
            if (event && getDataTransfer(event).getData && getDataTransfer(event).getData(constants_1.TEXT_HTML)) {
                var processHTMLData_1 = function (html) {
                    if (Helpers_1.isHTML(html) && buffer !== trimFragment(html)) {
                        if (Helpers_1.isHTMLFromWord(html)) {
                            ClearOrKeep(editor.i18n('The pasted content is coming from a Microsoft Word/Excel document. Do you want to keep the format or clean it up?'), editor.i18n('Word Paste Detected'), function (agree) {
                                if (agree === true) {
                                    html = Helpers_1.applyStyles(html);
                                    if (editor.options.beautifyHTML && editor.ownerWindow['html_beautify']) {
                                        html = editor.ownerWindow['html_beautify'](html);
                                    }
                                }
                                if (agree === false) {
                                    html = Helpers_1.cleanFromWord(html);
                                }
                                if (agree === 0) {
                                    html = strip_tags(Helpers_1.cleanFromWord(html));
                                }
                                editor.selection.insertHTML(html);
                                editor.setEditorValue();
                            });
                        }
                        else {
                            insertHTML(html, event);
                        }
                        return false;
                    }
                };
                if (getDataTransfer(event).types && [].slice.call(getDataTransfer(event).types).indexOf("text/html") !== -1) {
                    var html = getDataTransfer(event).getData(constants_1.TEXT_HTML);
                    return processHTMLData_1(html);
                }
                else if (event.type !== 'drop') {
                    var div_1 = Helpers_1.dom('<div tabindex="-1" style="left: -9999px; top: 0; width: 0; height: 100%; line-height: 140%; overflow: hidden; position: fixed; z-index: 2147483647; word-break: break-all;" contenteditable="true"></div>', editor.ownerDocument);
                    editor.container.appendChild(div_1);
                    var selData_1 = editor.selection.save();
                    div_1.focus();
                    var tick_1 = 0;
                    var removeFakeFocus_1 = function () {
                        div_1.parentNode && div_1.parentNode.removeChild(div_1);
                        editor.selection.restore(selData_1);
                    };
                    var waitData_1 = function () {
                        tick_1 += 1;
                        // If data has been processes by browser, process it
                        if (div_1.childNodes && div_1.childNodes.length > 0) {
                            var pastedData = div_1.innerHTML;
                            removeFakeFocus_1();
                            if (processHTMLData_1(pastedData) !== false) {
                                editor.selection.insertHTML(pastedData);
                            }
                        }
                        else {
                            if (tick_1 < 5) {
                                setTimeout(function () {
                                    waitData_1();
                                }, 20);
                            }
                            else {
                                removeFakeFocus_1();
                            }
                        }
                    };
                    waitData_1();
                }
            }
        });
    }
}
exports.paste = paste;


/***/ }),
/* 55 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Config_1 = __webpack_require__(1);
var consts = __webpack_require__(2);
var Helpers_1 = __webpack_require__(0);
Config_1.Config.prototype.showPlaceholder = true;
/**
 * @property {boolean} useInputsPlaceholder=true use a placeholder from original input field, if it was set
 * @example
 * ```javascript
 * //<textarea id="editor" placeholder="start typing text ..." cols="30" rows="10"></textarea>
 * var editor = new Jodit('#editor', {
 *    useInputsPlaceholder: true
 * });
 * ```
 */
Config_1.Config.prototype.useInputsPlaceholder = true;
/**
 * @property {string} placeholder='Type something' Default placeholder
 * @example
 * ```javascript
 * var editor = new Jodit('#editor', {
 *    placeholder: 'start typing text ...'
 * });
 * ```
 */
Config_1.Config.prototype.placeholder = 'Type something';
/**
 * Show placeholder inside empty editor
 *
 * @param {Jodit} editor
 */
function placeholder(editor) {
    if (!editor.options.showPlaceholder) {
        return;
    }
    this.destruct = function () {
        if (placeholder.parentNode) {
            placeholder.parentNode.removeChild(placeholder);
        }
    };
    var show = function () {
        if (!placeholder.parentNode || editor.options.readonly) {
            return;
        }
        var marginTop = 0, marginLeft = 0;
        var style = editor.editorWindow.getComputedStyle(editor.editor);
        if (editor.editor.firstChild && editor.editor.firstChild.nodeType === Node.ELEMENT_NODE) {
            var style2 = editor.editorWindow.getComputedStyle(editor.editor.firstChild);
            marginTop = parseInt(style2.getPropertyValue('margin-top'), 10);
            marginLeft = parseInt(style2.getPropertyValue('margin-left'), 10);
            placeholder.style.fontSize = parseInt(style2.getPropertyValue('font-size'), 10) + 'px';
            placeholder.style.lineHeight = style2.getPropertyValue('line-height');
        }
        else {
            placeholder.style.fontSize = parseInt(style.getPropertyValue('font-size'), 10) + 'px';
            placeholder.style.lineHeight = style.getPropertyValue('line-height');
        }
        Helpers_1.css(placeholder, {
            display: 'block',
            marginTop: Math.max(parseInt(style.getPropertyValue('margin-top'), 10), marginTop),
            marginLeft: Math.max(parseInt(style.getPropertyValue('margin-left'), 10), marginLeft)
        });
    }, hide = function () {
        if (placeholder.parentNode) {
            placeholder.style.display = 'none';
        }
    }, toggle = Helpers_1.debounce(function () {
        if (placeholder.parentNode === null) {
            return;
        }
        if (!editor.editor) {
            return;
        }
        if (editor.getRealMode() !== consts.MODE_WYSIWYG) {
            return hide();
        }
        var value = editor.getEditorValue();
        if (value && !/^<(p|div|h[1-6])><\/\1>$/.test(value)) {
            hide();
        }
        else {
            show();
        }
    }, editor.defaultTimeout / 10);
    var placeholder = Helpers_1.dom('<span style="display: none;" class="jodit_placeholder">' + editor.i18n(editor.options.placeholder) + '</span>', editor.ownerDocument);
    if (editor.options.direction === 'rtl') {
        placeholder.style.right = '0px';
        placeholder.style.direction = 'rtl';
    }
    if (editor.options.useInputsPlaceholder && editor.element.hasAttribute('placeholder')) {
        placeholder.innerHTML = editor.element.getAttribute('placeholder') || '';
    }
    editor.events
        .on('readonly', function (isReadOnly) {
        if (isReadOnly) {
            hide();
        }
        else {
            toggle();
        }
    })
        .on('afterInit', function () {
        editor.workplace
            .appendChild(placeholder);
        toggle();
        editor.events.fire('placeholder', placeholder.innerHTML);
        editor.events
            .on('change keyup mouseup keydown mousedown afterSetMode', toggle)
            .on(window, 'load', toggle);
    });
}
exports.placeholder = placeholder;


/***/ }),
/* 56 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var consts = __webpack_require__(2);
var Config_1 = __webpack_require__(1);
var Component_1 = __webpack_require__(4);
Config_1.Config.prototype.controls.redo = {
    mode: consts.MODE_SPLIT,
    isDisable: function (editor) { return !editor.observer.stack.canRedo(); },
    tooltip: 'Redo'
};
Config_1.Config.prototype.controls.undo = {
    mode: consts.MODE_SPLIT,
    isDisable: function (editor) { return !editor.observer.stack.canUndo(); },
    tooltip: 'Undo'
};
/**
 * Custom process Redo and Undo functionality
 */
var redoundo = /** @class */ (function (_super) {
    __extends(redoundo, _super);
    function redoundo(editor) {
        var _this = _super.call(this, editor) || this;
        var callback = function (command) {
            if (editor.getRealMode() === consts.MODE_WYSIWYG) {
                _this.jodit.observer[command]();
            }
            return false;
        };
        editor.registerCommand('redo', {
            exec: callback,
            hotkeys: 'ctrl+y,ctrl+shift+z'
        });
        editor.registerCommand('undo', {
            exec: callback,
            hotkeys: 'ctrl+z'
        });
        return _this;
    }
    return redoundo;
}(Component_1.Component));
exports.redoundo = redoundo;


/***/ }),
/* 57 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Config_1 = __webpack_require__(1);
var consts = __webpack_require__(2);
var Helpers_1 = __webpack_require__(0);
Config_1.Config.prototype.useIframeResizer = true;
/**
 * @property{boolean} useTableResizer=true Use true frame for editing table size
 */
Config_1.Config.prototype.useTableResizer = true;
/**
 * @property{boolean} useImageResizer=true Use true image editing frame size
 */
Config_1.Config.prototype.useImageResizer = true;
/**
 * @property {object} resizer
 * @property {int} resizer.min_width=10 The minimum width for the editable element
 * @property {int} resizer.min_height=10 The minimum height for the item being edited
 * @property {boolean} resizer.showSize=true Show size
 */
Config_1.Config.prototype.resizer = {
    showSize: true,
    min_width: 10,
    min_height: 10
};
/**
 * Resize table and img
 * @param {Jodit} editor
 */
function resizer(editor) {
    // let clicked = false,
    //     resized = false,
    var LOCK_KEY = 'resizer';
    var handle, currentElement, resizeElementClicked = false, isResizing = false, start_x, start_y, width, height, ratio, new_h, new_w, diff_x, diff_y, 
    // timeouts = [],
    resizerIsVisible = false, timeoutSizeViewer = 0;
    var resizer = Helpers_1.dom('<div data-editor_id="' + editor.id + '" style="display:none" class="jodit_resizer">' +
        '<i class="jodit_resizer-topleft"></i>' +
        '<i class="jodit_resizer-topright"></i>' +
        '<i class="jodit_resizer-bottomright"></i>' +
        '<i class="jodit_resizer-bottomleft"></i>' +
        '<span>100x100</span>' +
        '</div>', editor.ownerDocument), sizeViewer = resizer.getElementsByTagName('span')[0], hideResizer = function () {
        isResizing = false;
        resizerIsVisible = false;
        currentElement = null;
        resizer.style.display = 'none';
    }, showSizeViewer = function (w, h) {
        if (!editor.options.resizer.showSize) {
            return;
        }
        sizeViewer.style.opacity = '1';
        sizeViewer.innerHTML = w + " x " + h;
        window.clearTimeout(timeoutSizeViewer);
        timeoutSizeViewer = window.setTimeout(function () {
            sizeViewer.style.opacity = '0';
        }, 1000);
    }, updateSize = function () {
        if (resizerIsVisible && currentElement && resizer) {
            var workplacePosition = Helpers_1.offset((resizer.parentNode || editor.ownerDocument.documentElement), editor, editor.ownerDocument, true), pos = Helpers_1.offset(currentElement, editor, editor.editorDocument), left = parseInt(resizer.style.left || '0', 10), top_1 = parseInt(resizer.style.top || '0', 10), width_1 = resizer.offsetWidth, height_1 = resizer.offsetHeight;
            // 1 - because need move border higher and toWYSIWYG the left than the picture
            // 2 - in box-sizing: border-box mode width is real width indifferent by border-width.
            var newTop = pos.top - 1 - workplacePosition.top;
            var newLeft = pos.left - 1 - workplacePosition.left;
            if (top_1 !== newTop || left !== newLeft || width_1 !== currentElement.offsetWidth || height_1 !== currentElement.offsetHeight) {
                resizer.style.top = newTop + 'px';
                resizer.style.left = newLeft + 'px';
                resizer.style.width = currentElement.offsetWidth + 'px';
                resizer.style.height = currentElement.offsetHeight + 'px';
                if (editor.events) {
                    editor.events.fire(currentElement, 'changesize');
                    // check for first init. Ex. inlinePopup hides when it was fired
                    if (!isNaN(left)) {
                        editor.events.fire('resize');
                    }
                }
            }
        }
    }, showResizer = function () {
        if (editor.options.readonly) {
            return;
        }
        if (!resizer.parentNode) {
            editor.workplace.appendChild(resizer);
        }
        resizerIsVisible = true;
        resizer.style.display = 'block';
        if (editor.isFullSize()) {
            resizer.style.zIndex = Helpers_1.css(editor.container, 'zIndex').toString();
        }
        updateSize();
    }, 
    /**
     * Bind an edit element toWYSIWYG element
     * @param {HTMLElement} element The element that you want toWYSIWYG add a function toWYSIWYG resize
     */
    bind = function (element) {
        var wrapper;
        if (element.tagName === 'IFRAME') {
            if (element.parentNode && element.parentNode.getAttribute('data-jodit_iframe_wrapper')) {
                element = element.parentNode;
            }
            else {
                wrapper = Helpers_1.dom('<jodit data-jodit-temp="1" contenteditable="false" draggable="true" data-jodit_iframe_wrapper="1"></jodit>', editor.editorDocument);
                wrapper.style.display = element.style.display === 'inline-block' ? 'inline-block' : 'block';
                wrapper.style.width = element.offsetWidth + 'px';
                wrapper.style.height = element.offsetHeight + 'px';
                if (element.parentNode) {
                    element.parentNode.insertBefore(wrapper, element);
                }
                wrapper.appendChild(element);
                var iframe_1 = element;
                editor.events.on(wrapper, 'changesize', function () {
                    iframe_1.setAttribute('width', wrapper.offsetWidth + 'px');
                    iframe_1.setAttribute('height', wrapper.offsetHeight + 'px');
                });
                element = wrapper;
            }
        }
        var timer;
        editor.events
            .on(element, 'dragstart', hideResizer)
            .on(element, 'mousedown', function (event) {
            // for IE don't show native resizer
            if (Helpers_1.isIE() && element.nodeName === 'IMG') {
                event.preventDefault();
            }
        })
            .on(element, 'mousedown touchstart', function () {
            if (!resizeElementClicked) {
                resizeElementClicked = true;
                currentElement = element;
                showResizer();
                if (currentElement.tagName === 'IMG' && !currentElement.complete) {
                    currentElement.addEventListener('load', function ElementOnLoad() {
                        updateSize();
                        if (currentElement) {
                            currentElement.removeEventListener('load', ElementOnLoad);
                        }
                    });
                }
                clearTimeout(timer);
            }
            timer = window.setTimeout(function () {
                resizeElementClicked = false;
            }, 400);
        });
    };
    // resizeElement = {};
    Helpers_1.$$('i', resizer).forEach(function (resizeHandle) {
        editor.events
            .on(resizeHandle, 'mousedown touchstart', function (e) {
            if (!currentElement || !currentElement.parentNode) {
                hideResizer();
                return false;
            }
            // resizeElementClicked = false;
            handle = resizeHandle;
            e.preventDefault();
            e.stopImmediatePropagation();
            width = currentElement.offsetWidth;
            height = currentElement.offsetHeight;
            ratio = width / height;
            // clicked = true;
            isResizing = true;
            // resized = false;
            start_x = e.clientX;
            start_y = e.clientY;
            editor.events.fire('hidePopup');
            editor.lock(LOCK_KEY);
        });
    });
    editor.events
        .on('readonly', function (isReadOnly) {
        if (isReadOnly) {
            hideResizer();
        }
    })
        .on('beforeDestruct', function () {
        if (resizer.parentNode) {
            resizer.parentNode.removeChild(resizer);
        }
    })
        .on('afterInit', function () {
        editor.events
            .on(editor.editor, 'keydown', function (e) {
            if (resizerIsVisible && e.keyCode === consts.KEY_DELETE && currentElement && currentElement.tagName.toLowerCase() !== 'table') {
                if (currentElement.tagName !== 'JODIT') {
                    editor.selection.select(currentElement);
                }
                else {
                    if (currentElement.parentNode) {
                        currentElement.parentNode.removeChild(currentElement);
                    }
                    hideResizer();
                    e.preventDefault();
                }
            }
        })
            .on(editor.ownerWindow, 'mousemove touchmove', function (e) {
            if (isResizing) {
                diff_x = e.clientX - start_x;
                diff_y = e.clientY - start_y;
                if (!currentElement) {
                    return;
                }
                var className = handle.className;
                if ('IMG' === currentElement.tagName) {
                    if (diff_x) {
                        new_w = width + (className.match(/left/) ? -1 : 1) * diff_x;
                        new_h = Math.round(new_w / ratio);
                    }
                    else {
                        new_h = height + (className.match(/top/) ? -1 : 1) * diff_y;
                        new_w = Math.round(new_h * ratio);
                    }
                    if (new_w > Helpers_1.innerWidth(editor.editor, editor.ownerWindow)) {
                        new_w = Helpers_1.innerWidth(editor.editor, editor.ownerWindow);
                        new_h = Math.round(new_w / ratio);
                    }
                }
                else {
                    new_w = width + (className.match(/left/) ? -1 : 1) * diff_x;
                    new_h = height + (className.match(/top/) ? -1 : 1) * diff_y;
                }
                if (new_w > editor.options.resizer.min_width) {
                    if (new_w < resizer.parentNode.offsetWidth) {
                        currentElement.style.width = new_w + 'px';
                    }
                    else {
                        currentElement.style.width = '100%';
                    }
                }
                if (new_h > editor.options.resizer.min_height) {
                    currentElement.style.height = new_h + 'px';
                }
                updateSize();
                showSizeViewer(currentElement.offsetWidth, currentElement.offsetHeight);
                e.stopImmediatePropagation();
            }
        })
            .on(editor.ownerWindow, 'resize', function () {
            if (resizerIsVisible) {
                updateSize();
            }
        })
            .on(editor.ownerWindow, 'mouseup keydown touchend', function (e) {
            if (resizerIsVisible && !resizeElementClicked) {
                if (isResizing) {
                    editor.unlock();
                    isResizing = false;
                    editor.setEditorValue();
                    e.stopImmediatePropagation();
                }
                else {
                    hideResizer();
                }
            }
        })
            .on([editor.ownerWindow, editor.editor], 'scroll', function () {
            if (resizerIsVisible && !isResizing) {
                hideResizer();
            }
        });
    })
        .on('afterGetValueFromEditor', function (data) {
        data.value = data.value.replace(/<jodit[^>]+data-jodit_iframe_wrapper[^>]+>(.*?<iframe[^>]+>[\s\n\r]*<\/iframe>.*?)<\/jodit>/ig, '$1');
    }).on('change afterInit afterSetMode', Helpers_1.debounce(function () {
        if (resizerIsVisible) {
            if (!currentElement || !currentElement.parentNode) {
                hideResizer();
            }
            else {
                updateSize();
            }
        }
        if (!editor.isDestructed) {
            Helpers_1.$$('img, table, iframe', editor.editor).forEach(function (elm) {
                if (editor.getMode() === consts.MODE_SOURCE) {
                    return;
                }
                if (!elm['__jodit_resizer_binded'] && ((elm.tagName === 'IFRAME' && editor.options.useIframeResizer) || (elm.tagName === 'IMG' && editor.options.useImageResizer) || (elm.tagName === 'TABLE' && editor.options.useTableResizer))) {
                    elm['__jodit_resizer_binded'] = true;
                    bind(elm);
                }
            });
        }
    }, editor.defaultTimeout));
}
exports.resizer = resizer;


/***/ }),
/* 58 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Helpers_1 = __webpack_require__(0);
var Config_1 = __webpack_require__(1);
Config_1.Config.prototype.allowResizeX = false;
Config_1.Config.prototype.allowResizeY = true;
/**
 * Resize editor
 * @param {Jodit} editor
 */
function size(editor) {
    var setHeight = function (height) {
        Helpers_1.css(editor.container, 'height', height);
        if (editor.options.saveHeightInStorage) {
            editor.storage.set('height', height);
        }
    };
    var setWidth = function (width) { return Helpers_1.css(editor.container, 'width', width); };
    var setHeightWorkPlace = function (height) { return Helpers_1.css(editor.workplace, 'height', height); };
    // const setWidthWorkPlace = (width: number | string) => css(editor.workplace, 'width', width);
    if (editor.options.height !== 'auto' && (editor.options.allowResizeX || editor.options.allowResizeY)) {
        var handle_1 = Helpers_1.dom('<div class="jodit_editor_resize" ><a href="javascript:void(0)"></a></div>', editor.ownerDocument), start_1 = {
            x: 0, y: 0, w: 0, h: 0
        };
        var isResized_1 = false;
        editor.events
            .on(handle_1, 'mousedown touchstart', function (e) {
            isResized_1 = true;
            start_1.x = e.clientX;
            start_1.y = e.clientY;
            start_1.w = editor.container.offsetWidth;
            start_1.h = editor.container.offsetHeight;
            editor.lock();
            e.preventDefault();
        })
            .on(editor.ownerWindow, 'mousemove touchmove', Helpers_1.throttle(function (e) {
            if (isResized_1) {
                setHeight(editor.options.allowResizeY ? start_1.h + e.clientY - start_1.y : start_1.h);
                setWidth(editor.options.allowResizeX ? start_1.w + e.clientX - start_1.x : start_1.w);
                resizeWorkspaceImd();
                editor.events.fire('resize');
            }
        }, editor.defaultTimeout / 10))
            .on(editor.ownerWindow, 'mouseup touchsend', function () {
            if (isResized_1) {
                isResized_1 = false;
                editor.unlock();
            }
        })
            .on('afterInit', function () {
            editor.container.appendChild(handle_1);
        })
            .on('toggleFullSize', function (fullsize) {
            handle_1.style.display = fullsize ? 'none' : 'block';
        });
    }
    var getNotWorkHeight = function () { return (editor.options.toolbar ? editor.toolbar.container.offsetHeight : 0) + (editor.statusbar ? editor.statusbar.container.offsetHeight : 0); };
    var calcMinHeightWorkspace = function () {
        if (!editor.container || !editor.container.parentNode) {
            return;
        }
        var minHeight = Helpers_1.css(editor.container, 'minHeight') - getNotWorkHeight();
        [editor.workplace, editor.iframe, editor.editor].map(function (elm) {
            var minHeightD = elm === editor.editor ? minHeight - 2 : minHeight; // borders
            elm && Helpers_1.css(elm, 'minHeight', minHeightD);
            editor.events.fire('setMinHeight', minHeightD);
        });
    };
    var resizeWorkspaceImd = function () {
        if (editor.options.inline) {
            return;
        }
        calcMinHeightWorkspace();
        if (editor.container && (editor.options.height !== 'auto' || editor.isFullSize())) {
            setHeightWorkPlace(editor.container.offsetHeight - getNotWorkHeight());
        }
    };
    var resizeWorkspace = Helpers_1.debounce(resizeWorkspaceImd, editor.defaultTimeout);
    editor.events
        .on('toggleFullSize', function (fullsize) {
        if (!fullsize && editor.options.height === 'auto') {
            setHeightWorkPlace('auto');
            calcMinHeightWorkspace();
        }
    })
        .on('afterInit', function () {
        if (!editor.options.inline) {
            Helpers_1.css(editor.editor, {
                minHeight: '100%',
            });
            Helpers_1.css(editor.container, {
                minHeight: editor.options.minHeight,
                minWidth: editor.options.minWidth,
                maxWidth: editor.options.maxWidth,
            });
        }
        var height = editor.options.height;
        if (editor.options.saveHeightInStorage && height !== 'auto') {
            var localHeight = editor.storage.get('height');
            if (localHeight) {
                height = localHeight;
            }
        }
        if (!editor.options.inline) {
            setHeight(height);
            setWidth(editor.options.width);
        }
        resizeWorkspaceImd();
    }, undefined, undefined, true)
        .on(window, 'load', resizeWorkspace)
        .on('afterInit resize updateToolbar scroll afterResize', resizeWorkspace);
}
exports.size = size;


/***/ }),
/* 59 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Config_1 = __webpack_require__(1);
var consts = __webpack_require__(2);
var Helpers_1 = __webpack_require__(0);
var Component_1 = __webpack_require__(4);
var constants_1 = __webpack_require__(2);
Config_1.Config.prototype.beautifyHTML = true;
Config_1.Config.prototype.useAceEditor = true;
Config_1.Config.prototype.sourceEditorNativeOptions = {
    /**
     * Show gutter
     */
    showGutter: true,
    /**
     * Default theme
     */
    theme: 'ace/theme/idle_fingers',
    /**
     * Default mode
     */
    mode: 'ace/mode/html',
    /**
     * Wrap lines. Possible values - "off", 80-100..., true, "free"
     */
    wrap: true,
    /**
     * Highlight active line
     */
    highlightActiveLine: true,
};
Config_1.Config.prototype.sourceEditorCDNUrlsJS = [
    'https://cdnjs.cloudflare.com/ajax/libs/ace/1.3.3/ace.js',
];
Config_1.Config.prototype.beautifyHTMLCDNUrlsJS = [
    'https://cdnjs.cloudflare.com/ajax/libs/js-beautify/1.7.5/beautify.min.js',
    'https://cdnjs.cloudflare.com/ajax/libs/js-beautify/1.7.5/beautify-html.min.js',
];
Config_1.Config.prototype.controls.source = {
    mode: consts.MODE_SPLIT,
    exec: function (editor) {
        editor.toggleMode();
    },
    isActive: function (editor) {
        return editor.getRealMode() === consts.MODE_SOURCE;
    },
    tooltip: "Change mode"
};
/**
 * Plug-in change simple textarea on CodeMirror editor in Source code mode
 *
 * @module source
 */
var source = /** @class */ (function (_super) {
    __extends(source, _super);
    function source(editor) {
        var _this = _super.call(this, editor) || this;
        _this.className = 'jodit_ace_editor';
        _this.loadNext = function (i, urls, eventOnFinalize, className) {
            if (eventOnFinalize === void 0) { eventOnFinalize = 'aceReady'; }
            if (className === void 0) { className = _this.className; }
            if (eventOnFinalize && urls[i] === undefined && _this.jodit && _this.jodit.events) {
                _this.jodit.events && _this.jodit.events.fire(eventOnFinalize);
                _this.jodit.events && _this.jodit.events.fire(_this.jodit.ownerWindow, eventOnFinalize);
                return;
            }
            if (urls[i] !== undefined) {
                Helpers_1.appendScript(urls[i], function () {
                    _this.loadNext(i + 1, urls, eventOnFinalize, className);
                }, className, _this.jodit.ownerDocument);
            }
        };
        _this.fromWYSIWYG = function (force) {
            if (force === void 0) { force = false; }
            if (!_this.__lock || force === true) {
                _this.__lock = true;
                var new_value = _this.jodit.getEditorValue(false);
                if (new_value !== _this.getMirrorValue()) {
                    _this.setMirrorValue(new_value);
                }
                _this.__lock = false;
            }
        };
        _this.insertHTML = function (html) {
            if (_this.mirror.selectionStart || _this.mirror.selectionStart === 0) {
                var startPos = _this.mirror.selectionStart, endPos = _this.mirror.selectionEnd;
                _this.mirror.value = _this.mirror.value.substring(0, startPos)
                    + html
                    + _this.mirror.value.substring(endPos, _this.mirror.value.length);
            }
            else {
                _this.mirror.value += _this.mirror;
            }
            _this.toWYSIWYG();
        };
        _this.__lock = false;
        _this.toWYSIWYG = function () {
            if (!_this.__lock) {
                _this.__lock = true;
                _this.jodit.setEditorValue(_this.getMirrorValue());
                _this.__lock = false;
            }
        };
        _this.autosize = Helpers_1.debounce(function () {
            _this.mirror.style.height = 'auto';
            _this.mirror.style.height = _this.mirror.scrollHeight + 'px';
        }, _this.jodit.defaultTimeout);
        _this.getNormalPosition = function (pos, str) {
            var start = pos;
            while (start > 0) {
                start--;
                if (str[start] === '<' && str[start + 1] !== undefined && str[start + 1].match(/[\w\/]+/i)) {
                    return start;
                }
                if (str[start] === '>') {
                    return pos;
                }
            }
            return pos;
        };
        _this.tempMarkerStart = '{start-jodit-selection}';
        _this.tempMarkerStartReg = /{start-jodit-selection}/g;
        _this.tempMarkerEnd = '{end-jodit-selection}';
        _this.tempMarkerEndReg = /{end-jodit-selection}/g;
        _this.__clear = function (str) { return str.replace(consts.INVISIBLE_SPACE_REG_EXP, ''); };
        _this.selInfo = [];
        _this.selectAll = function () {
            _this.mirror.select();
        };
        _this.onSelectAll = function (command) {
            if (command.toLowerCase() === 'selectall' && _this.jodit.getRealMode() === constants_1.MODE_SOURCE) {
                _this.selectAll();
                return false;
            }
        };
        // override it for ace editors
        _this.getSelectionStart = function () {
            return _this.mirror.selectionStart;
        };
        _this.getSelectionEnd = function () {
            return _this.mirror.selectionEnd;
        };
        _this.setMirrorSelectionRange = function (start, end) {
            _this.mirror.setSelectionRange(start, end);
        };
        _this.saveSelection = function () {
            if (_this.jodit.getRealMode() === consts.MODE_WYSIWYG) {
                _this.selInfo = _this.jodit.selection.save() || [];
                _this.jodit.setEditorValue();
                _this.fromWYSIWYG(true);
            }
            else {
                _this.selInfo.length = 0;
                var value = _this.getMirrorValue();
                if (_this.getSelectionStart() === _this.getSelectionEnd()) {
                    var marker = _this.jodit.selection.marker(true);
                    _this.selInfo[0] = {
                        startId: marker.id,
                        collapsed: true,
                        startMarker: marker.outerHTML
                    };
                    var selectionStart = _this.getNormalPosition(_this.getSelectionStart(), _this.getMirrorValue());
                    _this.setMirrorValue(value.substr(0, selectionStart) + _this.__clear(_this.selInfo[0].startMarker) + value.substr(selectionStart));
                }
                else {
                    var markerStart = _this.jodit.selection.marker(true);
                    var markerEnd = _this.jodit.selection.marker(false);
                    _this.selInfo[0] = {
                        startId: markerStart.id,
                        endId: markerEnd.id,
                        collapsed: false,
                        startMarker: _this.__clear(markerStart.outerHTML),
                        endMarker: _this.__clear(markerEnd.outerHTML)
                    };
                    var selectionStart = _this.getNormalPosition(_this.getSelectionStart(), value);
                    var selectionEnd = _this.getNormalPosition(_this.getSelectionEnd(), value);
                    _this.setMirrorValue(value.substr(0, selectionStart) +
                        _this.selInfo[0].startMarker +
                        value.substr(selectionStart, selectionEnd - selectionStart) +
                        _this.selInfo[0].endMarker +
                        value.substr(selectionEnd));
                }
                _this.toWYSIWYG();
            }
        };
        _this.restoreSelection = function () {
            if (!_this.selInfo.length) {
                return;
            }
            if (_this.jodit.getRealMode() === consts.MODE_WYSIWYG) {
                _this.__lock = true;
                _this.jodit.selection.restore(_this.selInfo);
                _this.__lock = false;
                return;
            }
            var value = _this.getMirrorValue();
            var selectionStart = 0, selectionEnd = 0;
            try {
                if (_this.selInfo[0].startMarker) {
                    value = value.replace(/<span[^>]+data-jodit_selection_marker="start"[^>]*>[<>]*?<\/span>/gmi, _this.tempMarkerStart);
                }
                if (_this.selInfo[0].endMarker) {
                    value = value.replace(/<span[^>]+data-jodit_selection_marker="end"[^>]*>[<>]*?<\/span>/gmi, _this.tempMarkerEnd);
                }
                if (_this.jodit.ownerWindow['html_beautify'] && _this.jodit.options.beautifyHTML) {
                    value = _this.jodit.ownerWindow['html_beautify'](value);
                }
                selectionStart = value.indexOf(_this.tempMarkerStart);
                selectionEnd = selectionStart;
                value = value.replace(_this.tempMarkerStartReg, '');
                if (!_this.selInfo[0].collapsed || selectionStart === -1) {
                    selectionEnd = value.indexOf(_this.tempMarkerEnd);
                    if (selectionStart === -1) {
                        selectionStart = selectionEnd;
                    }
                }
                value = value.replace(_this.tempMarkerEndReg, '');
            }
            finally {
                value = value
                    .replace(_this.tempMarkerEndReg, '')
                    .replace(_this.tempMarkerStartReg, '');
            }
            _this.setMirrorValue(value);
            _this.setMirrorSelectionRange(selectionStart, selectionEnd);
            _this.toWYSIWYG();
            _this.setFocusToMirror(); // need for setting focus after change mode
        };
        _this.mirrorContainer = Helpers_1.dom('<div class="jodit_source"/>', _this.jodit.ownerDocument);
        _this.mirror = Helpers_1.dom('<textarea class="jodit_source_mirror"/>', _this.jodit.ownerDocument);
        editor.events
            .on(_this.mirror, 'mousedown keydown touchstart input', Helpers_1.debounce(_this.toWYSIWYG, editor.defaultTimeout))
            .on(_this.mirror, 'change keydown mousedown touchstart input', _this.autosize)
            .on('afterSetMode', _this.autosize)
            .on(_this.mirror, 'mousedown focus', function (e) {
            editor.events.fire(e.type, e);
        });
        editor.events
            .on('setMinHeight', function (minHeightD) {
            _this.mirror && Helpers_1.css(_this.mirror, 'minHeight', minHeightD);
        })
            .on('insertHTML', function (html) {
            if (!editor.options.readonly && !_this.jodit.isEditorMode()) {
                _this.insertHTML(html);
                return false;
            }
        })
            .on('aceInited', function () {
            if (editor.options.readonly) {
                if (_this.aceEditor) {
                    _this.aceEditor.setReadOnly(true);
                }
            }
        }, void (0), void (0), true)
            .on('readonly', function (isReadOnly) {
            if (isReadOnly) {
                _this.mirror.setAttribute('readonly', 'true');
            }
            else {
                _this.mirror.removeAttribute('readonly');
            }
            if (_this.aceEditor) {
                _this.aceEditor.setReadOnly(isReadOnly);
            }
        })
            .on('placeholder', function (text) {
            _this.mirror.setAttribute('placeholder', text);
        })
            .on('afterInit aceInited', function () {
            // save restore selection
            editor.events
                .on('beforeSetMode', _this.saveSelection)
                .on('afterSetMode', _this.restoreSelection);
        })
            .on('afterInit', function () {
            _this.mirrorContainer.appendChild(_this.mirror);
            editor.workplace.appendChild(_this.mirrorContainer);
            _this.autosize();
            var className = 'beutyfy_html_jodit_helper';
            if (editor.options.beautifyHTML && editor.ownerWindow['html_beautify'] === undefined && !Helpers_1.$$('script.' + className, editor.ownerDocument.body).length) {
                _this.loadNext(0, editor.options.beautifyHTMLCDNUrlsJS, false, className);
            }
            if (editor.options.useAceEditor) {
                _this.replaceMirrorToACE();
            }
        })
            .on('beforeCommand', _this.onSelectAll)
            .on('change afterInit', _this.fromWYSIWYG);
        return _this;
    }
    source.prototype.getMirrorValue = function () {
        return this.mirror.value;
    };
    source.prototype.setMirrorValue = function (value) {
        this.mirror.value = value;
    };
    source.prototype.setFocusToMirror = function () {
        this.mirror.focus();
    };
    source.prototype.replaceMirrorToACE = function () {
        var _this = this;
        var editor = this.jodit, aceEditor, undoManager;
        var updateButtons = function () {
            if (undoManager && editor.getRealMode() === consts.MODE_SOURCE) {
                editor.events.fire('canRedo', undoManager.hasRedo());
                editor.events.fire('canUndo', undoManager.hasUndo());
            }
        }, getLastColumnIndex = function (row) {
            return aceEditor.session.getLine(row).length;
        }, getLastColumnIndices = function () {
            var rows = aceEditor.session.getLength();
            var lastColumnIndices = [];
            var lastColIndex = 0;
            for (var i = 0; i < rows; i++) {
                lastColIndex += getLastColumnIndex(i);
                if (i > 0) {
                    lastColIndex += 1;
                }
                lastColumnIndices[i] = lastColIndex;
            }
            return lastColumnIndices;
        }, getRowColumnIndices = function (characterIndex) {
            var lastColumnIndices = getLastColumnIndices();
            if (characterIndex <= lastColumnIndices[0]) {
                return { row: 0, column: characterIndex };
            }
            var row = 1;
            for (var i = 1; i < lastColumnIndices.length; i++) {
                if (characterIndex > lastColumnIndices[i]) {
                    row = i + 1;
                }
            }
            var column = characterIndex - lastColumnIndices[row - 1] - 1;
            return { row: row, column: column };
        }, setSelectionRangeIndices = function (start, end) {
            var startRowColumn = getRowColumnIndices(start);
            var endRowColumn = getRowColumnIndices(end);
            aceEditor.getSelection().setSelectionRange({
                start: startRowColumn,
                end: endRowColumn
            });
        }, getIndexByRowColumn = function (row, column) {
            var lastColumnIndices = getLastColumnIndices();
            return lastColumnIndices[row] - getLastColumnIndex(row) + column;
        }, tryInitAceEditor = function () {
            if (aceEditor === undefined && _this.jodit.ownerWindow['ace'] !== undefined) {
                var fakeMirror = Helpers_1.dom('<div class="jodit_source_mirror-fake"/>', _this.jodit.ownerDocument);
                _this.mirrorContainer.insertBefore(fakeMirror, _this.mirrorContainer.firstChild);
                _this.aceEditor = aceEditor = _this.jodit.ownerWindow['ace'].edit(fakeMirror);
                aceEditor.setTheme(editor.options.sourceEditorNativeOptions.theme);
                aceEditor.renderer.setShowGutter(editor.options.sourceEditorNativeOptions.showGutter);
                aceEditor.getSession().setMode(editor.options.sourceEditorNativeOptions.mode);
                aceEditor.setHighlightActiveLine(editor.options.sourceEditorNativeOptions.highlightActiveLine);
                aceEditor.getSession().setUseWrapMode(true);
                aceEditor.setOption("indentedSoftWrap", false);
                aceEditor.setOption('wrap', editor.options.sourceEditorNativeOptions.wrap);
                aceEditor.getSession().setUseWorker(false);
                aceEditor.$blockScrolling = Infinity;
                // aceEditor.setValue(this.getMirrorValue());
                // aceEditor.clearSelection();
                aceEditor.setOptions({
                    maxLines: Infinity
                });
                aceEditor.on('change', _this.toWYSIWYG);
                aceEditor.on('focus', function (e) {
                    editor.events.fire('focus', e);
                });
                aceEditor.on('mousedown', function (e) {
                    editor.events.fire('mousedown', e);
                });
                _this.mirror.style.display = 'none';
                undoManager = aceEditor.getSession().getUndoManager();
                _this.setMirrorValue = function (value) {
                    if (editor.options.beautifyHTML && editor.ownerWindow['html_beautify']) {
                        aceEditor.setValue(editor.ownerWindow['html_beautify'](value));
                    }
                    else {
                        aceEditor.setValue(value);
                    }
                    aceEditor.clearSelection();
                    updateButtons();
                };
                if (_this.jodit.getRealMode() !== consts.MODE_WYSIWYG) {
                    _this.setMirrorValue(_this.getMirrorValue());
                }
                _this.getMirrorValue = function () {
                    return aceEditor.getValue();
                };
                _this.setFocusToMirror = function () {
                    aceEditor.focus();
                };
                _this.getSelectionStart = function () {
                    var range = aceEditor.selection.getRange();
                    return getIndexByRowColumn(range.start.row, range.start.column);
                };
                _this.getSelectionEnd = function () {
                    var range = aceEditor.selection.getRange();
                    return getIndexByRowColumn(range.end.row, range.end.column);
                };
                _this.selectAll = function () {
                    aceEditor.selection.selectAll();
                };
                _this.insertHTML = function (html) {
                    var start = aceEditor.selection.getCursor(), end = aceEditor.session.insert(start, html);
                    aceEditor.selection.setRange({
                        start: start, end: end
                    }, false);
                };
                _this.setMirrorSelectionRange = function (start, end) {
                    setSelectionRangeIndices(start, end);
                };
                editor.events
                    .on('afterResize', function () {
                    aceEditor.resize();
                })
                    .fire('aceInited', editor);
            }
        };
        editor.events
            .on(this.jodit.ownerWindow, 'aceReady', tryInitAceEditor) // work in global scope
            .on('aceReady', tryInitAceEditor) // work in local scope
            .on('afterSetMode', function () {
            if (editor.getRealMode() !== consts.MODE_SOURCE && editor.getMode() !== consts.MODE_SPLIT) {
                return;
            }
            _this.fromWYSIWYG();
            tryInitAceEditor();
        })
            .on('beforeCommand', function (command) {
            if (editor.getRealMode() !== consts.MODE_WYSIWYG && (command === 'redo' || command === 'undo') && undoManager) {
                if (undoManager['has' + command.substr(0, 1).toUpperCase() + command.substr(1)]) {
                    aceEditor[command]();
                }
                updateButtons();
                return false;
            }
        });
        tryInitAceEditor();
        // global add ace editor in browser
        if (this.jodit.ownerWindow['ace'] === undefined && !Helpers_1.$$('script.' + this.className, this.jodit.ownerDocument.body).length) {
            this.loadNext(0, editor.options.sourceEditorCDNUrlsJS, 'aceReady', this.className);
        }
    };
    return source;
}(Component_1.Component));
exports.source = source;


/***/ }),
/* 60 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Config_1 = __webpack_require__(1);
var Dialog_1 = __webpack_require__(7);
var Helpers_1 = __webpack_require__(0);
var constants_1 = __webpack_require__(2);
Config_1.Config.prototype.usePopupForSpecialCharacters = false;
Config_1.Config.prototype.specialCharacters = [
    '!', '&quot;', '#', '$', '%', '&amp;', "'", '(', ')', '*', '+', '-', '.', '/',
    '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';',
    '&lt;', '=', '&gt;', '?', '@',
    'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',
    'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
    '[', ']', '^', '_', '`',
    'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p',
    'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
    '{', '|', '}', '~',
    '&euro;', '&lsquo;', '&rsquo;', '&ldquo;', '&rdquo;', '&ndash;', '&mdash;', '&iexcl;', '&cent;', '&pound;',
    '&curren;', '&yen;', '&brvbar;', '&sect;', '&uml;', '&copy;', '&ordf;', '&laquo;', '&raquo;', '&not;', '&reg;', '&macr;',
    '&deg;', '&sup2;', '&sup3;', '&acute;', '&micro;', '&para;', '&middot;', '&cedil;', '&sup1;', '&ordm;',
    '&frac14;', '&frac12;', '&frac34;', '&iquest;', '&Agrave;', '&Aacute;', '&Acirc;', '&Atilde;', '&Auml;', '&Aring;',
    '&AElig;', '&Ccedil;', '&Egrave;', '&Eacute;', '&Ecirc;', '&Euml;', '&Igrave;', '&Iacute;', '&Icirc;', '&Iuml;',
    '&ETH;', '&Ntilde;', '&Ograve;', '&Oacute;', '&Ocirc;', '&Otilde;', '&Ouml;', '&times;', '&Oslash;', '&Ugrave;',
    '&Uacute;', '&Ucirc;', '&Uuml;', '&Yacute;', '&THORN;', '&szlig;', '&agrave;', '&aacute;', '&acirc;', '&atilde;',
    '&auml;', '&aring;', '&aelig;', '&ccedil;', '&egrave;', '&eacute;', '&ecirc;', '&euml;', '&igrave;', '&iacute;',
    '&icirc;', '&iuml;', '&eth;', '&ntilde;', '&ograve;', '&oacute;', '&ocirc;', '&otilde;', '&ouml;', '&divide;',
    '&oslash;', '&ugrave;', '&uacute;', '&ucirc;', '&uuml;', '&yacute;', '&thorn;', '&yuml;', '&OElig;', '&oelig;',
    '&#372;', '&#374', '&#373', '&#375;', '&sbquo;', '&#8219;', '&bdquo;', '&hellip;', '&trade;', '&#9658;', '&bull;',
    '&rarr;', '&rArr;', '&hArr;', '&diams;', '&asymp;'
];
Config_1.Config.prototype.controls.symbol = {
    icon: 'omega',
    hotkeys: 'ctrl+shift+i',
    tooltip: 'Insert Special Character',
    popup: function (editor, current, control, close) {
        var container = editor.events.fire('generateSpecialCharactersTable.symbols');
        if (container) {
            if (editor.options.usePopupForSpecialCharacters) {
                var box = editor.ownerDocument.createElement('div');
                box.classList.add('jodit_symbols');
                box.appendChild(container);
                editor.events.on(container, 'close_dialog', close);
                return box;
            }
            else {
                var dialog_1 = Dialog_1.Alert(container, editor.i18n('Select Special Character'), void (0), 'jodit_symbols');
                var a = container.querySelector('a');
                a && a.focus();
                editor.events.on('beforeDestruct', function () {
                    dialog_1 && dialog_1.close();
                });
            }
        }
    }
};
/**
 * The plugin inserts characters that are not part of the standard keyboard.
 */
var symbols = /** @class */ (function () {
    function symbols(editor) {
        var _this = this;
        this.countInRow = 17;
        editor.events
            .on('generateSpecialCharactersTable.symbols', function () {
            var container = Helpers_1.dom('<div class="jodit_symbols-container">' +
                '<div class="jodit_symbols-container_table"><table><tbody></tbody></table></div>' +
                '<div class="jodit_symbols-container_preview"><div class="jodit_symbols-preview"></div></div>' +
                '</div>', editor.ownerDocument), preview = container.querySelector('.jodit_symbols-preview'), table = container.querySelector('table'), body = table.tBodies[0], chars = [];
            for (var i = 0; i < editor.options.specialCharacters.length;) {
                var tr = editor.ownerDocument.createElement('tr');
                for (var j = 0; j < _this.countInRow && i < editor.options.specialCharacters.length; j += 1, i += 1) {
                    var td = editor.ownerDocument.createElement('td'), a = Helpers_1.dom("<a data-index=\"" + i + "\" data-index-j=\"" + j + "\" href=\"javascript:void(0)\" role=\"option\" tabindex=\"-1\">" + editor.options.specialCharacters[i] + "</a>", editor.ownerDocument);
                    chars.push(a);
                    td.appendChild(a);
                    tr.appendChild(td);
                }
                body.appendChild(tr);
            }
            var self = _this;
            editor.events
                .on(chars, 'focus', function () {
                preview.innerHTML = this.innerHTML;
            })
                .on(chars, 'mousedown', function (e) {
                if (this && this.nodeName === 'A') {
                    editor.selection.focus();
                    editor.selection.insertHTML(this.innerHTML);
                    editor.events.fire(this, 'close_dialog');
                    e && e.preventDefault();
                    e && e.stopImmediatePropagation();
                }
            })
                .on(chars, 'mouseenter', function () {
                if (this && this.nodeName === 'A') {
                    this.focus();
                }
            })
                .on(chars, 'keydown', function (e) {
                var target = e.target;
                if (target && target.nodeName === 'A') {
                    var index = parseInt(target.getAttribute('data-index') || '0', 0), jIndex = parseInt(target.getAttribute('data-index-j') || '0', 0), newIndex = void 0;
                    switch (e.which) {
                        case constants_1.KEY_UP:
                        case constants_1.KEY_DOWN:
                            newIndex = e.which === constants_1.KEY_UP ? index - self.countInRow : index + self.countInRow;
                            if (chars[newIndex] === undefined) {
                                newIndex = e.which === constants_1.KEY_UP ? Math.floor(chars.length / self.countInRow) * self.countInRow + jIndex : jIndex;
                                if (newIndex > chars.length - 1) {
                                    newIndex -= self.countInRow;
                                }
                            }
                            chars[newIndex] && chars[newIndex].focus();
                            break;
                        case constants_1.KEY_RIGHT:
                        case constants_1.KEY_LEFT:
                            newIndex = e.which === constants_1.KEY_LEFT ? index - 1 : index + 1;
                            if (chars[newIndex] === undefined) {
                                newIndex = e.which === constants_1.KEY_LEFT ? chars.length - 1 : 0;
                            }
                            chars[newIndex] && chars[newIndex].focus();
                            break;
                        case constants_1.KEY_ENTER:
                            editor.events.fire(target, 'mousedown');
                            e.stopImmediatePropagation();
                            e.preventDefault();
                            break;
                    }
                }
            });
            return container;
        });
    }
    return symbols;
}());
exports.symbols = symbols;


/***/ }),
/* 61 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Config_1 = __webpack_require__(1);
var Component_1 = __webpack_require__(4);
var Helpers_1 = __webpack_require__(0);
/**
 * You can redefine hotkeys for some command
 *
 * var jodit = new Jodit('#editor', {
 *  commandToHotkeys: {
 *      bold: 'ctrl+shift+b',
 *      italic: ['ctrl+i', 'ctrl+b'],
 *  }
 * })
 * @type {{}}
 */
Config_1.Config.prototype.commandToHotkeys = {
    removeFormat: 'ctrl+shift+m',
    insertOrderedList: 'ctrl+shift+7',
    insertUnorderedList: 'ctrl+shift+8',
    selectall: 'ctrl+a',
};
/**
 * Allow set hotkey for command or button
 */
var hotkeys = /** @class */ (function (_super) {
    __extends(hotkeys, _super);
    function hotkeys(editor) {
        var _this = _super.call(this, editor) || this;
        _this.specialKeys = {
            8: "backspace",
            9: "tab",
            10: "return",
            13: "return",
            16: "shift",
            17: "ctrl",
            18: "alt",
            19: "pause",
            20: "capslock",
            27: "esc",
            32: "space",
            33: "pageup",
            34: "pagedown",
            35: "end",
            36: "home",
            37: "left",
            38: "up",
            39: "right",
            40: "down",
            45: "insert",
            46: "del",
            59: ";",
            61: "=",
            96: "0",
            97: "1",
            98: "2",
            99: "3",
            100: "4",
            101: "5",
            102: "6",
            103: "7",
            104: "8",
            105: "9",
            106: "*",
            107: "+",
            109: "-",
            110: ".",
            111: "/",
            112: "f1",
            113: "f2",
            114: "f3",
            115: "f4",
            116: "f5",
            117: "f6",
            118: "f7",
            119: "f8",
            120: "f9",
            121: "f10",
            122: "f11",
            123: "f12",
            144: "numlock",
            145: "scroll",
            173: "-",
            186: ";",
            187: "=",
            188: ",",
            189: "-",
            190: ".",
            191: "/",
            192: "`",
            219: "[",
            220: "\\",
            221: "]",
            222: "'"
        };
        _this.shiftNums = {
            "`": "~",
            "1": "!",
            "2": "@",
            "3": "#",
            "4": "$",
            "5": "%",
            "6": "^",
            "7": "&",
            "8": "*",
            "9": "(",
            "0": ")",
            "-": "_",
            "=": "+",
            ";": ": ",
            "'": "\"",
            ",": "<",
            ".": ">",
            "/": "?",
            "\\": "|"
        };
        _this.possible = {};
        _this.onKeyPress = function (event) {
            var special = event.type !== "keypress" && _this.specialKeys[event.which], character = String.fromCharCode(event.which).toLowerCase();
            var modif = "";
            if (event.metaKey && !event.ctrlKey) {
                modif += "ctrl+"; // for mac OS -  CMD will be CTRL
            }
            ["alt", "ctrl", "shift"].forEach(function (specialKey) {
                if (event[specialKey + 'Key'] && special !== specialKey) {
                    modif += specialKey + '+';
                }
            });
            if (event.metaKey && modif.indexOf("alt+ctrl+shift+") > -1) {
                modif = modif.replace("alt+ctrl+shift+", "hyper+");
            }
            if (special) {
                _this.possible[modif + special] = true;
            }
            else {
                _this.possible[modif + character] = true;
                if (_this.shiftNums[character]) {
                    _this.possible[modif + _this.shiftNums[character]] = true;
                }
                // "$" can be triggered as "Shift+4" or "Shift+$" or just "$"
                if (modif === "shift+") {
                    _this.possible[_this.shiftNums[character]] = true;
                }
            }
        };
        var commands = Object.keys(editor.options.commandToHotkeys);
        commands.forEach(function (commandName) {
            var hotkeys = editor.options.commandToHotkeys[commandName];
            if (hotkeys) {
                editor.events
                    .off(Helpers_1.asArray(hotkeys).map(function (hotkey) { return hotkey + '.hotkey'; }).join(' '))
                    .on(Helpers_1.asArray(hotkeys).map(function (hotkey) { return hotkey + '.hotkey'; }).join(' '), function () {
                    return editor.execCommand(commandName); // because need `beforeCommand`
                });
            }
        });
        editor.events
            .on('afterInit', function () {
            var runPossible = function (event) {
                var noStop = true;
                Object.keys(_this.possible).forEach(function (hotkey) {
                    if (_this.jodit.events.fire(hotkey, event.type) === false) {
                        noStop = false;
                    }
                });
                if (!noStop) {
                    return false;
                }
            };
            var itIsHotkey = false;
            var self = _this;
            editor.events
                .on('keydown', function (event) {
                self.possible = {};
                self.onKeyPress(event);
                if (runPossible(event) === false) {
                    itIsHotkey = true;
                    editor.events.stopPropagation('keydown');
                    return false;
                }
            }, void (0), void (0), true)
                .on('keyup', function () {
                if (itIsHotkey) {
                    itIsHotkey = false;
                    editor.events.stopPropagation('keyup');
                    return false;
                }
            }, void (0), void (0), true);
        });
        return _this;
    }
    return hotkeys;
}(Component_1.Component));
exports.hotkeys = hotkeys;


/***/ }),
/* 62 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var consts = __webpack_require__(2);
var Helpers_1 = __webpack_require__(0);
var Config_1 = __webpack_require__(1);
var index_1 = __webpack_require__(12);
Config_1.Config.prototype.useTableProcessor = true;
Config_1.Config.prototype.useExtraClassesOptions = true;
Config_1.Config.prototype.controls.table = {
    data: {
        cols: 10,
        rows: 10,
        classList: {
            'table table-bordered': 'Bootstrap Bordered',
            'table table-striped': 'Bootstrap Striped',
            'table table-dark': 'Bootstrap Dark',
        }
    },
    popup: function (editor, current, control, close, button) {
        var i, j, k, div, rows_count = 1, cols_count = 1, default_rows_count = (control.data && control.data.rows) ? control.data.rows : 10, default_cols_count = (control.data && control.data.cols) ? control.data.cols : 10;
        var generateExtraClasses = function () {
            if (!editor.options.useExtraClassesOptions) {
                return '';
            }
            var out = [];
            if (control.data) {
                var classList_1 = control.data.classList;
                Object.keys(classList_1).forEach(function (classes) {
                    out.push("<label><input value=\"" + classes + "\" type=\"checkbox\"/>" + classList_1[classes] + "</label>");
                });
            }
            return out.join('');
        };
        var form = Helpers_1.dom('<form class="jodit_form jodit_form_inserter">' +
            '<label>' +
            '<span>1</span> &times; <span>1</span>' +
            '</label>' +
            '<div class="jodit_form-table-creator-box">' +
            '<div class="jodit_form-container"></div>' +
            '<div class="jodit_form-options">' + generateExtraClasses() + '</div>' +
            '</div>' +
            '</form>', editor.ownerDocument), rows = form.querySelectorAll('span')[0], cols = form.querySelectorAll('span')[1], blocksContainer = form.querySelector('.jodit_form-container'), mainBox = form.querySelector('.jodit_form-table-creator-box'), options = form.querySelector('.jodit_form-options'), cells = [];
        var generateRows = function (need_rows) {
            var cnt = need_rows * default_cols_count;
            if (cells.length > cnt) {
                for (i = cnt; i < cells.length; i += 1) {
                    blocksContainer.removeChild(cells[i]);
                    delete cells[i];
                }
                cells.length = cnt;
            }
            for (i = 0; i < cnt; i += 1) {
                if (!cells[i]) {
                    div = editor.ownerDocument.createElement('div');
                    div.setAttribute('data-index', i.toString());
                    cells.push(div);
                }
            }
            cells.forEach(function (cell) {
                blocksContainer.appendChild(cell);
            });
            var width = (cells[0].offsetWidth || 18) * default_cols_count;
            blocksContainer.style.width = width + 'px';
            mainBox.style.width = (width + options.offsetWidth + 1) + 'px';
        };
        var mouseenter = function (e, index) {
            var div = e.target;
            if (!div || div.tagName !== 'DIV') {
                return;
            }
            k = (index === undefined || isNaN(index)) ? parseInt(div.getAttribute('data-index') || '0', 10) : index || 0;
            rows_count = Math.ceil((k + 1) / default_cols_count);
            cols_count = k % default_cols_count + 1;
            // generateRows(rows_count + 1 > default_rows_count ? rows_count + 1 : default_rows_count);
            // if (cols_count === default_cols_count || (cols_count < default_cols_count - 1 && default_cols_count > 10)) {
            //     default_cols_count = cols_count === default_cols_count ? default_cols_count + 1 : default_cols_count - 1;
            //     return mouseenter(e, cols_count + (rows_count - 1)  * default_cols_count - 1);
            // }
            for (i = 0; i < cells.length; i += 1) {
                if (cols_count >= i % default_cols_count + 1 && rows_count >= Math.ceil((i + 1) / default_cols_count)) {
                    cells[i].className = 'hovered';
                }
                else {
                    cells[i].className = '';
                }
            }
            cols.innerText = cols_count.toString();
            rows.innerText = rows_count.toString();
        };
        blocksContainer.addEventListener('mousemove', mouseenter);
        editor.events
            .on(blocksContainer, 'touchstart mousedown', function (e) {
            var div = e.target, doc = editor.editorDocument;
            e.preventDefault();
            e.stopImmediatePropagation();
            if (div.tagName !== 'DIV') {
                return;
            }
            k = parseInt(div.getAttribute('data-index') || '0', 10);
            rows_count = Math.ceil((k + 1) / default_cols_count);
            cols_count = k % default_cols_count + 1;
            var table = doc.createElement('table');
            table.style.width = '100%';
            var first_td = null, tr, td, br;
            // w: string = (100 / cols_count).toFixed(7);
            for (i = 1; i <= rows_count; i += 1) {
                tr = doc.createElement('tr');
                for (j = 1; j <= cols_count; j += 1) {
                    td = doc.createElement('td');
                    // td.style.width = w + '%';
                    if (!first_td) {
                        first_td = td;
                    }
                    br = doc.createElement('br');
                    td.appendChild(br);
                    tr.appendChild(doc.createTextNode("\n"));
                    tr.appendChild(doc.createTextNode("\t"));
                    tr.appendChild(td);
                }
                table.appendChild(doc.createTextNode("\n"));
                table.appendChild(tr);
            }
            var current = editor.selection.current();
            if (current && editor.selection.isCollapsed()) {
                var block = index_1.Dom.closest(current, index_1.Dom.isBlock, editor.editor);
                if (block && block !== editor.editor && !block.nodeName.match(/^TD|TH|TBODY|TABLE|THEADER|TFOOTER$/)) {
                    editor.selection.setCursorAfter(block);
                }
            }
            Helpers_1.$$('input[type=checkbox]:checked', options).forEach(function (input) {
                input.value.split(/[\s]+/).forEach(function (className) {
                    table.classList.add(className);
                });
            });
            editor.selection.insertNode(doc.createTextNode("\n"));
            editor.selection.insertNode(table, false);
            if (first_td) {
                editor.selection.setCursorIn(first_td);
                Helpers_1.scrollIntoView(first_td, editor.editor, editor.editorDocument);
            }
            close();
        })
            .off(button.parentToolbar, 'afterOpenPopup.tableGenerator')
            .on(button.parentToolbar, 'afterOpenPopup.tableGenerator', function () {
            generateRows(default_rows_count);
            if (cells[0]) {
                cells[0].className = 'hovered';
            }
        });
        return form;
    },
    tooltip: "Insert table"
};
/**
 * Process tables in editor
 */
var TableProcessor = /** @class */ (function (_super) {
    __extends(TableProcessor, _super);
    /**
     *
     * @param {Jodit} editor
     */
    function TableProcessor(editor) {
        var _this = _super.call(this, editor) || this;
        _this.__key = 'table_processor_observer';
        _this.__selectMode = false;
        _this.__resizerDelta = 0;
        _this.__drag = false;
        _this.__addResizer = function () {
            if (!_this.__resizerHandler) {
                _this.__resizerHandler = _this.jodit.container.querySelector('.jodit_table_resizer');
                if (!_this.__resizerHandler) {
                    _this.__resizerHandler = Helpers_1.dom('<div class="jodit_table_resizer"></div>', _this.jodit.ownerDocument);
                    var startX_1 = 0; //, startLeft = 0;
                    _this.jodit.events
                        .on(_this.__resizerHandler, 'mousedown touchstart', function (event) {
                        _this.__drag = true;
                        startX_1 = event.clientX;
                        _this.jodit.lock(_this.__key);
                        _this.__resizerHandler.classList.add('jodit_table_resizer-moved');
                        var box, tableBox = _this.__workTable.getBoundingClientRect();
                        _this.__minX = 0;
                        _this.__maxX = 1000000;
                        if (_this.__wholeTable !== null) {
                            tableBox = _this.__workTable.parentNode.getBoundingClientRect();
                            _this.__minX = tableBox.left;
                            _this.__maxX = tableBox.left + tableBox.width;
                        }
                        else {
                            // find maximum columns
                            var coordinate_1 = index_1.Table.formalCoordinate(_this.__workTable, _this.__workCell, true);
                            index_1.Table.formalMatrix(_this.__workTable, function (td, i, j) {
                                if (coordinate_1[1] === j) {
                                    box = td.getBoundingClientRect();
                                    _this.__minX = Math.max(box.left + consts.NEARBY / 2, _this.__minX);
                                }
                                if (coordinate_1[1] + 1 === j) {
                                    box = td.getBoundingClientRect();
                                    _this.__maxX = Math.min(box.left + box.width - consts.NEARBY / 2, _this.__maxX);
                                }
                            });
                        }
                        return false;
                    })
                        .on(_this.jodit.ownerWindow, 'mousemove touchmoove', function (event) {
                        if (_this.__drag) {
                            var x = event.clientX;
                            if (x < _this.__minX) {
                                x = _this.__minX;
                            }
                            if (x > _this.__maxX) {
                                x = _this.__maxX;
                            }
                            _this.__resizerDelta = x - startX_1;
                            _this.__resizerHandler.style.left = x + 'px';
                            _this.jodit.editorWindow.getSelection().removeAllRanges();
                            if (event.preventDefault) {
                                event.preventDefault();
                            }
                        }
                    });
                    _this.jodit.container.appendChild(_this.__resizerHandler);
                }
            }
        };
        /**
         *
         * @param {string} command
         */
        _this.onExecCommand = function (command) {
            if (/table(splitv|splitg|merge|empty|bin|binrow|bincolumn|addcolumn|addrow)/.test(command)) {
                command = command.replace('table', '');
                var cells = index_1.Table.getAllSelectedCells(_this.jodit.editor);
                if (cells.length) {
                    var cell = cells.shift();
                    if (!cell) {
                        return;
                    }
                    var table = index_1.Dom.closest(cell, 'table', _this.jodit.editor);
                    switch (command) {
                        case 'splitv':
                            index_1.Table.splitVertical(table);
                            break;
                        case 'splitg':
                            index_1.Table.splitHorizontal(table);
                            break;
                        case 'merge':
                            index_1.Table.mergeSelected(table);
                            break;
                        case 'empty':
                            index_1.Table.getAllSelectedCells(_this.jodit.editor).forEach(function (cell) { return cell.innerHTML = ''; });
                            break;
                        case 'bin':
                            if (table.parentNode) {
                                table.parentNode.removeChild(table);
                            }
                            break;
                        case 'binrow':
                            index_1.Table.removeRow(table, cell.parentNode.rowIndex);
                            break;
                        case 'bincolumn':
                            index_1.Table.removeColumn(table, cell.cellIndex);
                            break;
                        case 'addcolumnafter':
                        case 'addcolumnbefore':
                            index_1.Table.appendColumn(table, cell.cellIndex, command === 'addcolumnafter');
                            break;
                        case 'addrowafter':
                        case 'addrowbefore':
                            index_1.Table.appendRow(table, cell.parentNode, command === 'addrowafter');
                            break;
                    }
                }
                return false;
            }
        };
        if (!editor.options.useTableProcessor) {
            return _this;
        }
        editor.events
            .on(_this.jodit.ownerWindow, 'mouseup touchend', function () {
            if (_this.__selectMode || _this.__drag) {
                _this.__selectMode = false;
                _this.jodit.unlock();
            }
            if (_this.__resizerHandler && _this.__drag) {
                _this.__drag = false;
                _this.__resizerHandler.classList.remove('jodit_table_resizer-moved');
                // resize column
                if (_this.__wholeTable === null) {
                    var __marked = [];
                    index_1.Table.setColumnWidthByDelta(_this.__workTable, index_1.Table.formalCoordinate(_this.__workTable, _this.__workCell, true)[1], _this.__resizerDelta, true, __marked);
                    var nextTD = index_1.Dom.next(_this.__workCell, TableProcessor.isCell, _this.__workCell.parentNode);
                    index_1.Table.setColumnWidthByDelta(_this.__workTable, index_1.Table.formalCoordinate(_this.__workTable, nextTD)[1], -_this.__resizerDelta, false, __marked);
                }
                else {
                    var width = _this.__workTable.offsetWidth, parentWidth = Helpers_1.getContentWidth(_this.__workTable.parentNode, _this.jodit.editorWindow);
                    // right side
                    if (_this.__wholeTable === false) {
                        _this.__workTable.style.width = ((width + _this.__resizerDelta) / parentWidth) * 100 + '%';
                    }
                    else {
                        var margin = parseInt(_this.jodit.editorWindow.getComputedStyle(_this.__workTable).marginLeft || '0', 10);
                        _this.__workTable.style.width = ((width - _this.__resizerDelta) / parentWidth) * 100 + '%';
                        _this.__workTable.style.marginLeft = ((margin + _this.__resizerDelta) / parentWidth) * 100 + '%';
                    }
                }
                editor.setEditorValue();
                editor.selection.focus();
            }
        })
            .on(_this.jodit.ownerWindow, 'scroll', function () {
            if (_this.__drag) {
                var parent_1 = index_1.Dom.up(_this.__workCell, function (elm) { return (elm && elm.nodeName === 'TABLE'); }, editor.editor);
                if (parent_1) {
                    var parentBox = parent_1.getBoundingClientRect();
                    _this.__resizerHandler.style.top = parentBox.top + 'px';
                }
            }
        })
            .on(_this.jodit.ownerWindow, 'mousedown touchend', function (event) {
            // need use event['originalEvent'] because of IE can not set target from another window to current window
            var current_cell = index_1.Dom.closest(event['originalEvent'].target, 'TD|TH', _this.jodit.editor);
            var table = null;
            if (current_cell instanceof _this.jodit.editorWindow.HTMLTableCellElement) {
                table = index_1.Dom.closest(current_cell, 'table', _this.jodit.editor);
            }
            if (table) {
                _this.__deSelectAll(table, current_cell instanceof _this.jodit.editorWindow.HTMLTableCellElement ? current_cell : false);
            }
            else {
                _this.__deSelectAll();
            }
        })
            .on('afterGetValueFromEditor', function (data) {
            data.value = data.value.replace(new RegExp("([s]*)" + consts.JODIT_SELECTED_CELL_MARKER + "=\"1\"", 'g'), '');
        })
            .on('change afterCommand afterSetMode', function () {
            Helpers_1.$$('table', editor.editor).forEach(function (table) {
                if (!table[_this.__key]) {
                    _this.observe(table);
                }
            });
        })
            .on('beforeSetMode', function () {
            index_1.Table.getAllSelectedCells(editor.editor).forEach(function (td) {
                index_1.Table.restoreSelection(td);
                index_1.Table.normalizeTable(index_1.Dom.closest(td, 'table', editor.editor));
            });
        })
            .on('keydown', function (event) {
            if (event.which === consts.KEY_TAB) {
                Helpers_1.$$('table', editor.editor).forEach(function (table) {
                    _this.__deSelectAll(table);
                });
            }
        })
            .on('beforeCommand', _this.onExecCommand.bind(_this));
        return _this;
    }
    /**
     *
     * @param {HTMLTableElement} [table]
     * @param {HTMLTableCellElement} [current_cell]
     * @private
     */
    TableProcessor.prototype.__deSelectAll = function (table, current_cell) {
        var cells = table ? index_1.Table.getAllSelectedCells(table) : index_1.Table.getAllSelectedCells(this.jodit.editor);
        if (cells.length) {
            cells.forEach(function (cell) {
                if (!current_cell || current_cell !== cell) {
                    index_1.Table.restoreSelection(cell);
                }
            });
        }
    };
    TableProcessor.isCell = function (tag) {
        return !!tag && /^TD|TH$/i.test(tag.nodeName);
    };
    /**
     *
     * @param {HTMLTableCellElement} cell
     * @param {boolean|null} [wholeTable=null] true - resize whole table by left side, false - resize whole table by right side, null - resize column
     * @private
     */
    TableProcessor.prototype.__setWorkCell = function (cell, wholeTable) {
        if (wholeTable === void 0) { wholeTable = null; }
        this.__wholeTable = wholeTable;
        this.__workCell = cell;
        this.__workTable = index_1.Dom.up(cell, function (elm) { return (elm && elm.nodeName === 'TABLE'); }, this.jodit.editor);
    };
    /**
     * Calc helper resizer position
     *
     * @param {HTMLTableElement} table
     * @param {HTMLTableCellElement} cell
     * @param {int} [offsetX=0]
     * @param {int} [delta=0]
     *
     * @private
     */
    TableProcessor.prototype.__calcResizerPosition = function (table, cell, offsetX, delta) {
        if (offsetX === void 0) { offsetX = 0; }
        if (delta === void 0) { delta = 0; }
        var box = Helpers_1.offset(cell, this.jodit, this.jodit.editorDocument);
        if (offsetX <= consts.NEARBY || box.width - offsetX <= consts.NEARBY) {
            var parentBox = Helpers_1.offset(table, this.jodit, this.jodit.editorDocument);
            this.__resizerHandler.style.left = (offsetX <= consts.NEARBY ? box.left : box.left + box.width) + delta + 'px';
            this.__resizerHandler.style.height = parentBox.height + 'px';
            this.__resizerHandler.style.top = parentBox.top + 'px';
            this.__resizerHandler.style.display = 'block';
            if (offsetX <= consts.NEARBY) {
                var prevTD = index_1.Dom.prev(cell, TableProcessor.isCell, cell.parentNode);
                if (prevTD) {
                    this.__setWorkCell(prevTD);
                }
                else {
                    this.__setWorkCell(cell, true);
                }
            }
            else {
                var nextTD = index_1.Dom.next(cell, TableProcessor.isCell, cell.parentNode);
                this.__setWorkCell(cell, !nextTD ? false : null);
            }
        }
        else {
            this.__resizerHandler.style.display = 'none';
        }
    };
    TableProcessor.prototype.observe = function (table) {
        var _this = this;
        table[this.__key] = true;
        var start;
        this.jodit.events
            .on(table, 'mousedown touchstart', function (event) {
            if (_this.jodit.options.readonly) {
                return;
            }
            var cell = index_1.Dom.up(event.target, TableProcessor.isCell, table);
            if (cell && cell instanceof _this.jodit.editorWindow.HTMLElement) {
                if (!cell.firstChild) {
                    cell.appendChild(_this.jodit.editorDocument.createElement('br'));
                }
                start = cell;
                index_1.Table.addSelected(cell);
                _this.__selectMode = true;
            }
        })
            .on(table, 'mouseleave', function (e) {
            if (_this.__resizerHandler && _this.__resizerHandler !== e.relatedTarget) {
                _this.__resizerHandler.style.display = 'none';
            }
        })
            .on(table, 'mousemove touchmove', function (event) {
            if (_this.jodit.options.readonly) {
                return;
            }
            if (_this.__drag || _this.jodit.isLockedNotBy(_this.__key)) {
                return;
            }
            var cell = index_1.Dom.up(event.target, TableProcessor.isCell, table);
            if (cell) {
                if (_this.__selectMode) {
                    if (cell !== start) {
                        _this.jodit.lock(_this.__key);
                        _this.jodit.editorWindow.getSelection().removeAllRanges();
                        if (event.preventDefault) {
                            event.preventDefault();
                        }
                    }
                    _this.__deSelectAll(table);
                    var bound = index_1.Table.getSelectedBound(table, [cell, start]), box = index_1.Table.formalMatrix(table);
                    for (var i = bound[0][0]; i <= bound[1][0]; i += 1) {
                        for (var j = bound[0][1]; j <= bound[1][1]; j += 1) {
                            index_1.Table.addSelected(box[i][j]);
                        }
                    }
                    var max_1 = box[bound[1][0]][bound[1][1]], min_1 = box[bound[0][0]][bound[0][1]];
                    _this.jodit.events
                        .fire('showPopup', table, function () {
                        var minOffset = Helpers_1.offset(min_1, _this.jodit, _this.jodit.editorDocument);
                        var maxOffset = Helpers_1.offset(max_1, _this.jodit, _this.jodit.editorDocument);
                        return {
                            left: minOffset.left,
                            top: minOffset.top,
                            width: maxOffset.left - minOffset.left + maxOffset.width,
                            height: maxOffset.top - minOffset.top + maxOffset.height
                        };
                    });
                    event.stopPropagation();
                }
                else {
                    _this.__calcResizerPosition(table, cell, event.offsetX);
                }
            }
        });
        this.__addResizer();
    };
    return TableProcessor;
}(index_1.Component));
exports.TableProcessor = TableProcessor;


/***/ }),
/* 63 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var Cookie = /** @class */ (function () {
    function Cookie() {
    }
    /**
     * Set cookie value
     *
     * @method set
     * @param {string|number} name
     * @param {string|number} value
     * @param {int} [days] if it value < 0 cookie removed
     * @example
     * ```javascript
     * Jodit.modules.Cookie.set('somename', somevalue, 5);
     * ```
     */
    Cookie.prototype.set = function (name, value, days) {
        var expires, date;
        if (days) {
            date = new Date();
            date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
            expires = '; expires=' + date.toUTCString();
        }
        else {
            expires = '';
        }
        document.cookie = name + "=" + value + expires + '; path=/';
    };
    /**
     * Get cookie value by key
     *
     * @method get
     * @param {string} name
     * @return {string}
     * @example
     * ```javascript
     * console.log(Jodit.modules.Cookie.get('somename'));
     * ```
     */
    Cookie.prototype.get = function (name) {
        var nameEQ = name + '=', i, c, ca = document.cookie.split(';');
        for (i = 0; i < ca.length; i += 1) {
            c = ca[i];
            while (c.charAt(0) === ' ') {
                c = c.substring(1, c.length);
            }
            if (c.indexOf(nameEQ) === 0) {
                return c.substring(nameEQ.length, c.length);
            }
        }
        return null;
    };
    /**
     * Remove cookie by key
     *
     * @method remove
     * @param {string} name
     * @example
     * ```javascript
     * Jodit.modules.Cookie.remove('somename');
     * ```
     */
    Cookie.prototype.remove = function (name) {
        this.set(name, '', -1);
    };
    return Cookie;
}());
exports.Cookie = Cookie;


/***/ }),
/* 64 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Jodit_1 = __webpack_require__(6);
var Component_1 = __webpack_require__(4);
var Dialog_1 = __webpack_require__(7);
var Config_1 = __webpack_require__(1);
var Helpers_1 = __webpack_require__(0);
var ToolbarCollection_1 = __webpack_require__(5);
var ContextMenu_1 = __webpack_require__(15);
var Uploader_1 = __webpack_require__(9);
var Ajax_1 = __webpack_require__(14);
var consts = __webpack_require__(2);
var EventsNative_1 = __webpack_require__(11);
var Storage_1 = __webpack_require__(16);
Config_1.Config.prototype.filebrowser = {
    filter: function (item, search) {
        search = search.toLowerCase();
        if (typeof item === 'string') {
            return item.toLowerCase().indexOf(search) !== -1;
        }
        if (typeof item.name === 'string') {
            return item.name.toLowerCase().indexOf(search) !== -1;
        }
        if (typeof item.file === 'string') {
            return item.file.toLowerCase().indexOf(search) !== -1;
        }
        return true;
    },
    sortBy: 'changed',
    sort: function (a, b, sortBy) {
        var compareStr = function (f, s) {
            if (f < s) {
                return -1;
            }
            if (f > s) {
                return 1;
            }
            return 0;
        }, first, second;
        if (typeof a === 'string') {
            return compareStr(a.toLowerCase(), b.toLowerCase());
        }
        if (a[sortBy] === undefined || sortBy === 'name') {
            if (typeof a.name === 'string') {
                return compareStr(a.name.toLowerCase(), b.name.toLowerCase());
            }
            if (typeof a.file === 'string') {
                return compareStr(a.file.toLowerCase(), b.file.toLowerCase());
            }
            return 0;
        }
        switch (sortBy) {
            case 'changed':
                first = new Date(a.changed);
                second = new Date(b.changed);
                return second.getTime() - first.getTime();
            case 'size':
                return Helpers_1.humanSizeToBytes(a.size) - Helpers_1.humanSizeToBytes(b.size);
        }
        return 0;
    },
    editImage: true,
    preview: true,
    showPreviewNavigation: true,
    showSelectButtonInPreview: true,
    contextMenu: true,
    howLongShowMsg: 3000,
    createNewFolder: true,
    deleteFolder: true,
    moveFolder: true,
    moveFile: true,
    showFoldersPanel: true,
    width: 763,
    height: 400,
    buttons: [
        'filebrowser.upload',
        'filebrowser.remove',
        'filebrowser.update',
        'filebrowser.select',
        'filebrowser.edit',
        '|',
        'filebrowser.tiles',
        'filebrowser.list',
        '|',
        'filebrowser.filter',
        '|',
        'filebrowser.sort',
    ],
    view: null,
    isSuccess: function (resp) {
        return resp.success;
    },
    getMessage: function (resp) {
        return (resp.data.messages !== undefined && Array.isArray(resp.data.messages)) ? resp.data.messages.join(' ') : '';
    },
    showFileName: true,
    showFileSize: true,
    showFileChangeTime: true,
    getThumbTemplate: function (item, source, source_name) {
        var name = '', thumb = '', info, timestamp = (new Date()).getTime().toString();
        if (item.file !== undefined) {
            name = item.file;
            thumb = item.file;
        }
        if (item.thumb) {
            thumb = item.thumb;
        }
        info = "<div class=\"" + ITEM_CLASS + "-info\">\n            " + (this.options.showFileName ? "<span class=\"" + ITEM_CLASS + "-info-filename\">" + name + "</span>" : '') + "\n            " + ((this.options.showFileSize && item.size) ? "<span class=\"" + ITEM_CLASS + "-info-filesize\">" + item.size + "</span>" : '') + "\n            " + ((this.options.showFileChangeTime && item.changed) ? "<span class=\"" + ITEM_CLASS + "-info-filechanged\">" + item.changed + "</span>" : '') + "\n        </div>";
        var imageURL = Helpers_1.urlNormalize(source.baseurl + source.path + name);
        return "<a data-is-file=\"" + (item.isImage ? 0 : 1) + "\" draggable=\"true\" class=\"" + ITEM_CLASS + "\" href=\"" + imageURL + "\" data-source=\"" + source_name + "\" data-path=\"" + Helpers_1.pathNormalize(source.path ? source.path + '/' : '/') + "\" data-name=\"" + name + "\" title=\"" + name + "\" data-url=\"" + imageURL + "\">\n            <img data-is-file=\"" + (item.isImage ? 0 : 1) + "\" data-src=\"" + imageURL + "\" src=\"" + Helpers_1.urlNormalize(source.baseurl + source.path + thumb) + "?_tmst=" + timestamp + "\" alt=\"" + name + "\"/>\n            " + ((this.options.showFileName || (this.options.showFileSize && item.size) || (this.options.showFileChangeTime && item.changed)) ? info : '') + "\n        </a>";
    },
    ajax: {
        url: '',
        async: true,
        data: {},
        cache: true,
        contentType: 'application/x-www-form-urlencoded; charset=UTF-8',
        method: 'POST',
        processData: true,
        dataType: 'json',
        headers: {},
        prepareData: function (data) {
            return data;
        },
        process: function (resp) {
            return resp;
        }
    },
    create: {
        data: { action: 'folderCreate' },
    },
    getLocalFileByUrl: {
        data: { action: 'getLocalFileByUrl' },
    },
    resize: {
        data: { action: 'imageResize' },
    },
    crop: {
        data: { action: 'imageCrop' },
    },
    move: {
        data: { action: 'fileMove' },
    },
    fileRemove: {
        data: { action: 'fileRemove' },
    },
    folderRemove: {
        data: { action: 'folderRemove' },
    },
    items: {
        data: { action: 'files' },
    },
    folder: {
        data: { action: 'folders' },
    },
    permissions: {
        data: { action: 'permissions' },
    },
    uploader: null // use default Uploader's settings
};
Config_1.Config.prototype.controls.filebrowser = {
    upload: {
        icon: 'plus',
        exec: function () { },
        isDisable: function (browser) { return !browser.canI('FileUpload'); },
        getContent: function (editor, control) {
            var btn = Helpers_1.dom('<span class="jodit_upload_button">' +
                ToolbarCollection_1.ToolbarIcon.getIcon('plus') +
                '<input type="file" accept="' + (editor.buffer.fileBrowserOnlyImages ? 'image/*' : '*') + '" tabindex="-1" dir="auto" multiple=""/>' +
                '</span>', editor.ownerDocument), input = btn.querySelector('input');
            editor.events
                .on('updateToolbar', function () {
                if (control && control.isDisable) {
                    control.isDisable(editor, control) ? input.setAttribute('disabled', 'disabled') : input.removeAttribute('disabled');
                }
            })
                .fire('bindUploader.filebrowser', btn);
            return btn;
        }
    },
    remove: {
        icon: 'bin',
        isDisable: function (browser) {
            return browser.getActiveElements().length === 0 || !browser.canI('FileRemove');
        },
        exec: function (editor) {
            editor.events.fire('fileRemove.filebrowser');
        },
    },
    update: {
        exec: function (editor) {
            editor.events.fire('update.filebrowser');
        },
    },
    select: {
        icon: 'check',
        isDisable: function (browser) {
            return browser.getActiveElements().length === 0;
        },
        exec: function (editor) {
            editor.events.fire('select.filebrowser');
        },
    },
    edit: {
        icon: 'pencil',
        isDisable: function (browser) {
            var selected = browser.getActiveElements();
            return selected.length !== 1 || selected[0].getAttribute('data-is-file') === "1" || !(browser.canI('ImageCrop') || browser.canI('ImageResize'));
        },
        exec: function (editor) {
            editor.events.fire('edit.filebrowser');
        },
    },
    tiles: {
        icon: 'th',
        isActive: function (editor) { return editor.buffer.fileBrowserView === 'tiles'; },
        exec: function (editor) {
            editor.events.fire('view.filebrowser', 'tiles');
        },
    },
    list: {
        icon: 'th-list',
        isActive: function (editor) { return editor.buffer.fileBrowserView === 'list'; },
        exec: function (editor) {
            editor.events.fire('view.filebrowser', 'list');
        },
    },
    filter: {
        isInput: true,
        getContent: function (editor) {
            var input = Helpers_1.dom('<input class="jodit_input" placeholder="' + editor.i18n('Filter') + '"/>', editor.ownerDocument);
            editor.events.on(input, 'keydown mousedown', Helpers_1.debounce(function () {
                editor.events.fire('filter.filebrowser', input.value);
            }, editor.defaultTimeout));
            return input;
        }
    },
    sort: {
        isInput: true,
        getContent: function (editor) {
            var select = Helpers_1.dom('<select class="jodit_input">' +
                '<option value="changed">' + editor.i18n('Sort by changed') + '</option>' +
                '<option value="name">' + editor.i18n('Sort by name') + '</option>' +
                '<option value="size">' + editor.i18n('Sort by size') + '</option>' +
                '</select>', editor.ownerDocument);
            editor.events
                .on('sort.filebrowser', function (value) {
                if (select.value !== value) {
                    select.value = value;
                }
            })
                .on(select, 'change', function () {
                editor.events.fire('sort.filebrowser', select.value);
            });
            return select;
        }
    },
};
var DEFAULT_SOURCE_NAME = 'default';
var ITEM_CLASS = 'jodit_filebrowser_files_item';
var FileBrowser = /** @class */ (function (_super) {
    __extends(FileBrowser, _super);
    function FileBrowser(editor, options) {
        if (options === void 0) { options = {}; }
        var _this = _super.call(this, editor) || this;
        _this.currentPath = '';
        _this.currentSource = DEFAULT_SOURCE_NAME;
        _this.currentBaseUrl = '';
        /**
         * Container for set/get value
         * @type {Storage}
         */
        _this.storage = new Storage_1.Storage(new Storage_1.localStorageProvider());
        _this.__currentPermissions = null;
        _this.editorDocument = document;
        _this.editorWindow = window;
        _this.view = 'tiles';
        _this.sortBy = 'changed';
        _this.dragger = false;
        _this.filterWord = '';
        /**
         * Get path by url. You can use this method in another modules
         *
         * @method getPathByUrl
         * @param {string} url Full url
         * @param {function} success
         * @param {string} success.path path toWYSIWYG file from connector's root (without filename)
         * @param {string} success.name filename
         * @param {function} onFailed filename
         * @param {string} onFailed.message
         */
        _this.getPathByUrl = function (url, success, onFailed) {
            var action = 'getLocalFileByUrl', self = _this;
            _this.options[action].data.url = url;
            _this.send(action, function (resp) {
                if (self.options.isSuccess(resp)) {
                    success(resp.data.path, resp.data.name, resp.data.source);
                }
                else {
                    onFailed(new Error(_this.options.getMessage(resp)));
                }
            }, function (resp) {
                onFailed(resp);
            });
        };
        _this.loadItems = function (path, source) {
            var self = _this;
            self.options.items.data.path = path;
            self.options.items.data.source = source;
            self.files.classList.add('active');
            self.files.appendChild(self.loader.cloneNode(true));
            return self.send('items', function (resp) {
                var process = self.options.items.process;
                if (!process) {
                    process = _this.options.ajax.process;
                }
                if (process) {
                    var respData = process.call(self, resp);
                    self.generateItemsBox(respData.data.sources);
                    self.someSelectedWasChanged();
                }
            }, function (error) {
                Dialog_1.Alert(error.message);
                self.errorHandler(error);
            });
        };
        /**
         * Create a directory on the server
         *
         * @method create
         * @param {string} name Name the new folder
         * @param {string} path Relative toWYSIWYG the directory in which you want toWYSIWYG create a folder
         * @param {string} source Server source key
         */
        _this.create = function (name, path, source) {
            _this.options.create.data.source = source;
            _this.options.create.data.path = path;
            _this.options.create.data.name = name;
            return _this.send('create', function (resp) {
                if (_this.options.isSuccess(resp)) {
                    _this.currentPath = path;
                    _this.currentSource = source;
                    _this.loadTree(path, source);
                }
                else {
                    _this.status(_this.options.getMessage(resp));
                }
            }, function (error) {
                _this.status(error.message);
            });
        };
        /**
         * Move a file / directory on the server
         *
         * @method move
         * @param {string} filepath The relative path toWYSIWYG the file / folder source
         * @param {string} path Relative toWYSIWYG the directory where you want toWYSIWYG move the file / folder
         * @param {string} source Source
         */
        _this.move = function (filepath, path, source) {
            _this.options.move.data.from = filepath;
            _this.options.move.data.path = path;
            _this.options.move.data.source = source;
            return _this.send('move', function (resp) {
                if (_this.options.isSuccess(resp)) {
                    _this.loadTree(path, source);
                }
                else {
                    _this.status(_this.options.getMessage(resp));
                }
            }, function (error) {
                _this.status(error.message);
            });
        };
        /**
         * Close dialog
         * @method close
         */
        _this.close = function () {
            _this.dialog.close();
        };
        _this.onlyImages = false;
        /**
         * It opens a web browser window
         *
         * @param {Function} callback The function that will be called after the file selection in the browser
         * @param {boolean} [onlyImages=false] Show only images
         * @example
         * ```javascript
         * var fb = new Jodit.modules.FileBrowser(parent);
         * fb.open(function (data) {
         *     var i;
         *     for (i = 0;i < data.files.length; i += 1) {
         *         parent.selection.insertImage(data.baseurl + data.files[i]);
         *     }
         * });
         * ```
         * @return Promise
         */
        _this.open = function (callback, onlyImages) {
            if (onlyImages === void 0) { onlyImages = false; }
            _this.onlyImages = onlyImages;
            _this.buffer.fileBrowserOnlyImages = onlyImages;
            return new Promise(function (resolve) {
                if (_this.options.items.url) {
                    var localTimeout_1 = 0;
                    _this.events
                        .off(_this.files, 'dblclick')
                        .on(_this.files, 'dblclick', _this.onSelect(callback), 'a')
                        .on(_this.files, 'touchstart', function () {
                        var now = (new Date()).getTime();
                        if (now - localTimeout_1 < consts.EMULATE_DBLCLICK_TIMEOUT) {
                            _this.onSelect(callback)();
                        }
                        localTimeout_1 = now;
                    }, 'a')
                        .off('select.filebrowser')
                        .on('select.filebrowser', _this.onSelect(callback));
                    var header = _this.ownerDocument.createElement('div');
                    _this.toolbar.build(_this.options.buttons, header);
                    _this.dialog.dialogbox_header.classList.add('jodit_filebrowser_title_box');
                    _this.dialog.open(_this.browser, header);
                    _this.events
                        .fire('sort.filebrowser', _this.sortBy);
                    _this.loadTree(_this.currentPath, _this.currentSource)
                        .then(resolve);
                }
                else {
                    throw new Error('Need set options.filebrowser.ajax.url');
                }
            });
        };
        _this.errorHandler = function (resp) {
            if (resp instanceof Error) {
                _this.status(_this.i18n(resp.message));
            }
            else {
                _this.status(_this.options.getMessage(resp));
            }
        };
        _this.uploadHandler = function () {
            _this.loadItems(_this.currentPath, _this.currentSource);
        };
        /**
         * Open Image Editor
         *
         * @method openImageEditor
         */
        _this.openImageEditor = function (href, name, path, source, onSuccess, onFailed) {
            return _this.getInstance('ImageEditor')
                .open(href, function (newname, box, success, failed) {
                if (_this.options[box.action] === undefined) {
                    _this.options[box.action] = {};
                }
                if (_this.options[box.action].data === undefined) {
                    _this.options[box.action].data = {
                        action: box.action
                    };
                }
                _this.options[box.action].data.newname = newname || name;
                _this.options[box.action].data.box = box.box;
                _this.options[box.action].data.path = path;
                _this.options[box.action].data.name = name;
                _this.options[box.action].data.source = source;
                _this.send(box.action, function (resp) {
                    if (_this.options.isSuccess(resp)) {
                        _this.loadTree(_this.currentPath, _this.currentSource);
                        success();
                        if (onSuccess) {
                            onSuccess();
                        }
                    }
                    else {
                        failed(new Error(_this.options.getMessage(resp)));
                        if (onFailed) {
                            onFailed(new Error(_this.options.getMessage(resp)));
                        }
                    }
                }, function (error) {
                    failed(error);
                    if (onFailed) {
                        onFailed(error);
                    }
                });
            });
        };
        var self = _this, doc = editor ? editor.ownerDocument : document, editorDoc = editor ? editor.editorDocument : doc;
        if (editor) {
            _this.id = editor.id;
        }
        _this.ownerDocument = doc;
        _this.ownerWindow = editor ? editor.ownerWindow : window;
        _this.progress_bar = editor ? editor.progress_bar : document.createElement('div');
        _this.editor = editor ? editor.editor : document.createElement('div');
        _this.events = editor ? editor.events : new EventsNative_1.EventsNative(doc);
        _this.buffer = editor ? editor.buffer : {};
        self.options = (new Config_1.OptionsDefault(Helpers_1.extend(true, {}, Jodit_1.Jodit.defaultOptions.filebrowser, options, self.jodit ? self.jodit.options.filebrowser : void (0))));
        self.dialog = new Dialog_1.Dialog(editor || self, {
            fullsizeButton: true
        });
        self.toolbar = new ToolbarCollection_1.ToolbarCollection(self);
        self.loader = Helpers_1.dom('<div class="jodit_filebrowser_loader"><i class="jodit_icon-loader"></i></div>', doc);
        self.browser = Helpers_1.dom('<div class="jodit_filebrowser non-selected">' +
            (self.options.showFoldersPanel ? '<div class="jodit_filebrowser_tree"></div>' : '') +
            '<div class="jodit_filebrowser_files"></div>' +
            '<div class="jodit_filebrowser_status"></div>' +
            '</div>', doc);
        self.status_line = self.browser.querySelector('.jodit_filebrowser_status');
        self.tree = self.browser.querySelector('.jodit_filebrowser_tree');
        self.files = self.browser.querySelector('.jodit_filebrowser_files');
        self.events
            .on('view.filebrowser', function (view) {
            if (view !== self.view) {
                self.view = view;
                self.buffer.fileBrowserView = view;
                self.files.classList.remove('jodit_filebrowser_files_view-tiles');
                self.files.classList.remove('jodit_filebrowser_files_view-list');
                self.files.classList.add('jodit_filebrowser_files_view-' + self.view);
                self.storage.set('jodit_filebrowser_view', self.view);
            }
        })
            .on('sort.filebrowser', function (value) {
            if (value !== self.sortBy) {
                self.sortBy = value;
                _this.storage.set('jodit_filebrowser_sortby', self.sortBy);
                self.loadItems(self.currentPath, self.currentSource);
            }
        })
            .on('filter.filebrowser', function (value) {
            if (value !== self.filterWord) {
                self.filterWord = value;
                self.loadItems(self.currentPath, self.currentSource);
            }
        })
            .on('fileRemove.filebrowser', function () {
            if (_this.getActiveElements().length) {
                Dialog_1.Confirm(self.i18n('Are you shure?'), '', function (yes) {
                    if (yes) {
                        var promises_1 = [];
                        self.getActiveElements().forEach(function (a) {
                            promises_1.push(self.fileRemove(self.currentPath, a.getAttribute('data-name') || '', a.getAttribute('data-source') || ''));
                        });
                        Promise.all(promises_1)
                            .then(function () {
                            self.someSelectedWasChanged();
                            self.loadTree(self.currentPath, self.currentSource);
                        });
                    }
                });
            }
        })
            .on('edit.filebrowser', function () {
            var files = _this.getActiveElements();
            if (files.length === 1) {
                self.openImageEditor(files[0].getAttribute('href') || '', files[0].getAttribute('data-name') || '', files[0].getAttribute('data-path') || '', files[0].getAttribute('data-source') || '');
            }
        })
            .on('update.filebrowser', function () {
            self.loadTree(_this.currentPath, _this.currentSource);
        })
            .on(self.tree, 'click', function (e) {
            var a = this.parentNode, path = a.getAttribute('data-path') || '';
            Dialog_1.Confirm(self.i18n('Are you shure?'), '', function (yes) {
                if (yes) {
                    self
                        .folderRemove(path, a.getAttribute('data-name') || '', a.getAttribute('data-source') || '')
                        .then(function () {
                        self.loadTree(self.currentPath, self.currentSource);
                    });
                }
            });
            e.stopImmediatePropagation();
            return false;
        }, 'a>i.remove')
            .on(self.tree, 'click', function () {
            var _this = this;
            if (this.classList.contains('addfolder')) {
                Dialog_1.Promt(self.i18n('Enter Directory name'), self.i18n('Create directory'), function (name) {
                    self.create(name, _this.getAttribute('data-path') || '', _this.getAttribute('data-source') || '');
                }, self.i18n('type name'));
            }
            else {
                self.currentPath = this.getAttribute('data-path') || '';
                self.currentSource = this.getAttribute('data-source') || '';
                self.loadTree(self.currentPath, self.currentSource);
            }
        }, 'a')
            .on(_this.tree, 'dragstart', function () {
            self.dragger = this;
        }, 'a')
            .on(_this.tree, 'drop', function () {
            if (self.options.moveFolder && self.dragger) {
                var path = self.dragger.getAttribute('data-path') || '';
                //move folder
                if (!self.options.moveFolder && self.dragger.classList.contains('jodit_filebrowser_tree_item')) {
                    return false;
                }
                //move file
                if (self.dragger.classList.contains(ITEM_CLASS)) {
                    path += self.dragger.getAttribute('data-name');
                    if (!self.options.moveFile) {
                        return false;
                    }
                }
                self.move(path, this.getAttribute('data-path') || '', this.getAttribute('data-source') || '');
            }
        }, 'a');
        var contextmenu = new ContextMenu_1.ContextMenu(_this.jodit || _this);
        self.events
            .on(self.files, 'contextmenu', function (e) {
            var _this = this;
            if (self.options.contextMenu) {
                var item_1 = this;
                contextmenu.show(e.pageX, e.pageY, [
                    (item_1.getAttribute('data-is-file') !== "1" && self.options.editImage && (self.canI('ImageResize') || self.canI('ImageCrop'))) ? {
                        icon: 'pencil',
                        title: 'Edit',
                        exec: function () {
                            self.openImageEditor(item_1.getAttribute('href') || '', item_1.getAttribute('data-name') || '', item_1.getAttribute('data-path') || '', item_1.getAttribute('data-source') || '');
                        }
                    } : false,
                    self.canI('FileRemove') ? {
                        icon: 'bin',
                        title: 'Delete',
                        exec: function () {
                            self
                                .fileRemove(self.currentPath, item_1.getAttribute('data-name') || '', item_1.getAttribute('data-source') || '');
                            self.someSelectedWasChanged();
                            self.loadTree(self.currentPath, self.currentSource);
                        }
                    } : false,
                    self.options.preview ? {
                        icon: 'eye',
                        title: 'Preview',
                        exec: function () {
                            var src = item_1.getAttribute('href') || '';
                            var preview = new Dialog_1.Dialog(self), temp_content = Helpers_1.dom('<div class="jodit_filebrowser_preview"><i class="jodit_icon-loader"></i></div>', doc), image = doc.createElement('img'), addLoadHandler = function () {
                                var onload = function () {
                                    _this.removeEventListener('load', onload);
                                    temp_content.innerHTML = '';
                                    if (self.options.showPreviewNavigation) {
                                        var next = Helpers_1.dom('<a href="javascript:void(0)" class="jodit_filebrowser_preview_navigation jodit_filebrowser_preview_navigation-next">' + ToolbarCollection_1.ToolbarIcon.getIcon('angle-right') + '</a>', doc), prev = Helpers_1.dom('<a href="javascript:void(0)" class="jodit_filebrowser_preview_navigation jodit_filebrowser_preview_navigation-prev">' + ToolbarCollection_1.ToolbarIcon.getIcon('angle-left') + '</a>', doc);
                                        if (item_1.previousSibling && item_1.previousSibling.classList && item_1.previousSibling.classList.contains(ITEM_CLASS)) {
                                            temp_content.appendChild(prev);
                                        }
                                        if (item_1.nextSibling && item_1.nextSibling.classList && item_1.nextSibling.classList.contains(ITEM_CLASS)) {
                                            temp_content.appendChild(next);
                                        }
                                        self.events.on([next, prev], 'click', function () {
                                            if (this.classList.contains('jodit_filebrowser_preview_navigation-next')) {
                                                item_1 = item_1.nextSibling;
                                            }
                                            else {
                                                item_1 = item_1.previousSibling;
                                            }
                                            temp_content.innerHTML = '<i class="jodit_icon-loader"></i>';
                                            src = item_1.getAttribute('href') || '';
                                            image.setAttribute('src', src);
                                            addLoadHandler();
                                        });
                                    }
                                    temp_content.appendChild(image);
                                    preview.setPosition();
                                };
                                image.addEventListener("load", onload);
                                if (image.complete) {
                                    onload();
                                }
                            };
                            addLoadHandler();
                            image.setAttribute('src', src);
                            preview.setContent(temp_content);
                            preview.open();
                        }
                    } : false,
                    {
                        icon: 'upload',
                        title: 'Download',
                        exec: function () {
                            var url = item_1.getAttribute('href');
                            if (url) {
                                self.ownerWindow.open(url);
                            }
                        }
                    }
                ], self.dialog.getZIndex() + 1);
                e.stopPropagation();
                e.preventDefault();
                return false;
            }
        }, 'a')
            .on(self.files, 'click', function (e) {
            if (!Helpers_1.ctrlKey(e)) {
                _this.getActiveElements().forEach(function (elm) {
                    elm.classList.remove('active');
                });
                self.someSelectedWasChanged();
            }
        })
            .on(self.files, 'click', function (e) {
            if (!Helpers_1.ctrlKey(e)) {
                self.getActiveElements().forEach(function (elm) {
                    elm.classList.remove('active');
                });
            }
            this.classList.toggle('active');
            self.someSelectedWasChanged();
            e.stopPropagation();
            return false;
        }, 'a')
            .on(self.dialog.dialogbox, 'drop', function (e) { return e.preventDefault(); });
        _this.dialog.setSize(_this.options.width, _this.options.height);
        _this.options.getLocalFileByUrl = Helpers_1.extend(true, {}, _this.options.ajax, _this.options.getLocalFileByUrl);
        _this.options.crop = Helpers_1.extend(true, {}, _this.options.ajax, _this.options.crop);
        _this.options.resize = Helpers_1.extend(true, {}, _this.options.ajax, _this.options.resize);
        _this.options.create = Helpers_1.extend(true, {}, _this.options.ajax, _this.options.create);
        _this.options.move = Helpers_1.extend(true, {}, _this.options.ajax, _this.options.move);
        _this.options.fileRemove = Helpers_1.extend(true, {}, _this.options.ajax, _this.options.fileRemove);
        _this.options.folderRemove = Helpers_1.extend(true, {}, _this.options.ajax, _this.options.folderRemove);
        _this.options.folder = Helpers_1.extend(true, {}, _this.options.ajax, _this.options.folder);
        _this.options.items = Helpers_1.extend(true, {}, _this.options.ajax, _this.options.items);
        _this.options.permissions = Helpers_1.extend(true, {}, _this.options.ajax, _this.options.permissions);
        if (_this.storage.get('jodit_filebrowser_view') && _this.options.view === null) {
            _this.view = _this.storage.get('jodit_filebrowser_view') === 'list' ? 'list' : 'tiles';
        }
        else {
            _this.view = _this.options.view === 'list' ? 'list' : 'tiles';
        }
        _this.files.classList.add('jodit_filebrowser_files_view-' + _this.view);
        self.buffer.fileBrowserView = _this.view;
        _this.sortBy = (['changed', 'name', 'size']).indexOf(_this.options.sortBy) !== -1 ? _this.options.sortBy : 'changed';
        if (_this.storage.get('jodit_filebrowser_sortby')) {
            _this.sortBy = (['changed', 'name', 'size']).indexOf(_this.storage.get('jodit_filebrowser_sortby') || '') !== -1 ? _this.storage.get('jodit_filebrowser_sortby') || '' : 'changed';
        }
        _this.currentBaseUrl = Helpers_1.$$('base', editorDoc).length ? Helpers_1.$$('base', editorDoc)[0].getAttribute('href') || '' : location.protocol + '//' + location.host;
        if (Jodit_1.Jodit.modules.Uploader !== undefined) {
            var uploaderOptions = Helpers_1.extend(true, {}, Jodit_1.Jodit.defaultOptions.uploader, self.options.uploader, (_this.jodit && _this.jodit.options && _this.jodit.options.uploader !== null) ? __assign({}, _this.jodit.options.uploader) : {});
            _this.uploader = new Uploader_1.Uploader(_this.jodit || _this, uploaderOptions);
            _this.uploader.setPath(_this.currentPath);
            _this.uploader.setSource(_this.currentSource);
            _this.uploader.bind(_this.browser, _this.uploadHandler, _this.errorHandler);
            _this.events.on('bindUploader.filebrowser', function (button) {
                _this.uploader.bind(button, _this.uploadHandler, _this.errorHandler);
            });
        }
        return _this;
    }
    FileBrowser.prototype.canI = function (action) {
        return this.__currentPermissions !== null && (this.__currentPermissions['allow' + action] === undefined || this.__currentPermissions['allow' + action]);
    };
    FileBrowser.prototype.i18n = function (text) {
        return this.jodit ? this.jodit.i18n(text) : Jodit_1.Jodit.prototype.i18n(text);
    };
    FileBrowser.prototype.getRealMode = function () {
        return consts.MODE_WYSIWYG;
    };
    /**
     *
     * @return {boolean}
     */
    FileBrowser.prototype.isOpened = function () {
        return this.dialog.isOpened() && this.browser.style.display !== 'none';
    };
    /**
     * It displays a message in the status bar of filebrowser
     *
     * @method status
     * @param {string} message Message
     * @param {boolean} [success] true It will be shown a message light . If no option is specified , an error will be shown the red
     * @example
     * ```javascript
     * parent.filebrowser.status('There was an error uploading file', false);
     * ```
     */
    FileBrowser.prototype.status = function (message, success) {
        var _this = this;
        clearTimeout(this.statustimer);
        this.status_line
            .classList.remove('success');
        this.status_line
            .classList.add('active');
        this.status_line.innerHTML = message;
        if (success) {
            this.status_line
                .classList.add('success');
        }
        this.statustimer = window.setTimeout(function () {
            _this.status_line
                .classList.remove('active');
        }, this.options.howLongShowMsg);
    };
    FileBrowser.prototype.generateFolderTree = function (sources) {
        var _this = this;
        var folders = [];
        Helpers_1.each(sources, function (source_name, source) {
            if (source_name && source_name !== DEFAULT_SOURCE_NAME) {
                folders.push('<div class="jodit_filebrowser_source_title">' + source_name + '</div>');
            }
            source.folders.forEach(function (name) {
                var folder = '<a draggable="draggable" class="jodit_filebrowser_tree_item" href="javascript:void(0)" data-path="' + Helpers_1.pathNormalize(source.path + name) + '/" data-source="' + source_name + '">' +
                    '<span>' + name + '</span>';
                if (_this.options.deleteFolder && name !== '..' && name !== '.') {
                    folder += '<i class="remove" data-path="' + Helpers_1.pathNormalize(source.path + name + '/') + '">&times;</i>';
                }
                folder += '</a>';
                folders.push(folder);
            });
            if (_this.options.createNewFolder && _this.canI('FolderCreate')) {
                folders.push('<a class="jodit_button addfolder" href="javascript:void(0)" data-path="' + Helpers_1.pathNormalize(source.path + name) + '/" data-source="' + source_name + '">' + ToolbarCollection_1.ToolbarIcon.getIcon('plus') + ' ' + _this.i18n('Add folder') + '</a>');
            }
        });
        this.tree.innerHTML = folders.join('');
    };
    FileBrowser.prototype.generateItemsBox = function (sources) {
        var _this = this;
        var files = [];
        Helpers_1.each(sources, function (source_name, source) {
            if (source_name && source_name !== DEFAULT_SOURCE_NAME) {
                files.push("<div class=\"jodit_filebrowser_source_title\">" + (source_name + (source.path ? ' - ' + source.path : '')) + "</div>");
            }
            if (source.files && source.files.length) {
                if (typeof _this.options.sort === 'function') {
                    source.files.sort(function (a, b) {
                        return _this.options.sort(a, b, _this.sortBy, _this.jodit);
                    });
                }
                source.files.forEach(function (item) {
                    if (_this.options.filter === undefined || _this.options.filter(item, _this.filterWord)) {
                        if (!_this.onlyImages || item.isImage === undefined || item.isImage) {
                            files.push(_this.options.getThumbTemplate.call(_this, item, source, source_name));
                        }
                    }
                });
            }
            else {
                files.push("<div>" + _this.i18n('There are no files') + "</div>");
            }
        });
        this.files.innerHTML = files.join('');
    };
    FileBrowser.prototype.getActiveElements = function () {
        return Helpers_1.$$(':scope>a.active', this.files);
    };
    FileBrowser.prototype.someSelectedWasChanged = function () {
        this.events.fire('changeSelection');
    };
    /**
     *
     * @param {string} name
     * @param {Function} success
     * @param {Function} error
     * @return {Promise}
     */
    FileBrowser.prototype.send = function (name, success, error) {
        var opts = Helpers_1.extend(true, {}, this.options.ajax, this.options[name] !== undefined ? this.options[name] : this.options.ajax);
        if (opts.prepareData) {
            opts.data = opts.prepareData.call(this, opts.data);
        }
        var ajax = new Ajax_1.Ajax(this.jodit || this, opts);
        return ajax.send()
            .then(success)
            .catch(error);
    };
    FileBrowser.prototype.loadPermissions = function (path, source) {
        var _this = this;
        var self = this;
        self.options.permissions.data.path = path;
        self.options.permissions.data.source = source;
        if (self.options.permissions.url) {
            return self
                .send('permissions', function (resp) {
                var process = self.options.permissions.process;
                if (!process) {
                    process = _this.options.ajax.process;
                }
                if (process) {
                    var respData = process.call(self, resp);
                    if (respData.data.permissions) {
                        _this.__currentPermissions = respData.data.permissions;
                    }
                }
            }, function (error) {
                Dialog_1.Alert(error.message);
                self.errorHandler(error);
            });
        }
        else {
            return Promise.resolve();
        }
    };
    FileBrowser.prototype.loadTree = function (path, source) {
        var _this = this;
        return this.loadPermissions(path, source)
            .then(function () {
            var self = _this;
            self.options.folder.data.path = path;
            self.options.folder.data.source = source;
            if (self.uploader) {
                self.uploader.setPath(path);
                self.uploader.setSource(source);
            }
            var tree = [];
            if (self.options.showFoldersPanel) {
                if (self.options.folder.url) {
                    self.tree.classList.add('active');
                    self.tree.innerHTML = '';
                    self.tree.appendChild(self.loader.cloneNode(true));
                    tree.push(_this.send('folder', function (resp) {
                        var process = self.options.folder.process;
                        if (!process) {
                            process = _this.options.ajax.process;
                        }
                        if (process) {
                            var respData = process.call(self, resp);
                            self.generateFolderTree(respData.data.sources);
                        }
                    }, function () {
                        self.errorHandler(new Error(self.jodit.i18n('Error on load folders')));
                    }));
                }
                else {
                    self.tree.classList.remove('active');
                }
            }
            tree.push(_this.loadItems(path, source));
            return Promise.all(tree);
        });
    };
    /**
     * Deleting a file
     *
     * @param path Relative path
     * @param file The filename
     * @param source Source
     */
    FileBrowser.prototype.fileRemove = function (path, file, source) {
        var _this = this;
        this.options.fileRemove.data.path = path;
        this.options.fileRemove.data.name = file;
        this.options.fileRemove.data.source = source;
        return this
            .send('fileRemove', function (resp) {
            if (_this.options.remove.process) {
                resp = _this.options.remove.process.call(_this, resp);
            }
            if (!_this.options.isSuccess(resp)) {
                _this.status(_this.options.getMessage(resp));
            }
            else {
                _this.someSelectedWasChanged();
                _this.status(_this.options.getMessage(resp), true);
            }
        }, function (error) {
            _this.status(error.message);
        });
    };
    /**
     * Deleting a folder
     *
     * @param path Relative path
     * @param file The filename
     * @param source Source
     */
    FileBrowser.prototype.folderRemove = function (path, file, source) {
        var _this = this;
        this.options.folderRemove.data.path = path;
        this.options.folderRemove.data.name = file;
        this.options.folderRemove.data.source = source;
        return this
            .send('folderRemove', function (resp) {
            if (_this.options.remove.process) {
                resp = _this.options.remove.process.call(_this, resp);
            }
            if (!_this.options.isSuccess(resp)) {
                _this.status(_this.options.getMessage(resp));
            }
            else {
                _this.someSelectedWasChanged();
                _this.status(_this.options.getMessage(resp), true);
            }
        }, function (error) {
            _this.status(error.message);
        });
    };
    FileBrowser.prototype.onSelect = function (callback) {
        var _this = this;
        return function () {
            var actives = _this.getActiveElements();
            if (actives.length) {
                var urls_1 = [];
                actives.forEach(function (elm) {
                    var url = elm.getAttribute('data-url');
                    url && urls_1.push(url);
                });
                _this.close();
                if (typeof callback === 'function') {
                    callback({
                        baseurl: '',
                        files: urls_1
                    });
                }
            }
            return false;
        };
    };
    Object.defineProperty(FileBrowser.prototype, "defaultTimeout", {
        /**
         * Return default timeout period in milliseconds for some debounce or throttle functions. By default return {observer.timeout} options
         *
         * @return {number}
         */
        get: function () {
            return (this.jodit) ? this.jodit.defaultTimeout : Jodit_1.Jodit.defaultOptions.observer.timeout;
        },
        enumerable: true,
        configurable: true
    });
    return FileBrowser;
}(Component_1.Component));
exports.FileBrowser = FileBrowser;


/***/ }),
/* 65 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Component_1 = __webpack_require__(4);
var Config_1 = __webpack_require__(1);
var Helpers_1 = __webpack_require__(0);
var ToolbarCollection_1 = __webpack_require__(5);
var Dialog_1 = __webpack_require__(7);
var Jodit_1 = __webpack_require__(6);
Config_1.Config.prototype.imageeditor = {
    /**
     * @property{boolean} imageeditor.closeAfterSave=false Close editor after save image
     */
    closeAfterSave: false,
    /**
     * @property{string|int} imageeditor.width=85% Default dialog width by screen
     */
    width: '85%',
    /**
     * @property{string|int} imageeditor.height=85% Default dialog height by screen
     */
    height: '85%',
    /**
     * @property{boolean} imageeditor.crop=true Show tab cropping
     */
    crop: true,
    /**
     * @property{boolean} imageeditor.resize=true Show tab resizing
     */
    resize: true,
    /**
     * @property{boolean} imageeditor.resizeUseRatio=true Keep aspect ratio on resize
     */
    resizeUseRatio: true,
    /**
     * @property{int} imageeditor.resizeMinWidth=20 minimal width on resize
     */
    resizeMinWidth: 20,
    /**
     * @property{boolean} imageeditor.resizeMinHeight=20 minimal height on resize
     */
    resizeMinHeight: 20,
    /**
     * @property{boolean} imageeditor.cropUseRatio=true Keep aspect ratio on crop
     */
    cropUseRatio: true,
    /**
     * @property{string} imageeditor.cropDefaultWidth=70% In the tab, crop the image is displayed not in real size. Boxing default size for it
     * @property{string} imageeditor.cropDefaultHeight=70%
     */
    cropDefaultWidth: '70%',
    cropDefaultHeight: '70%',
};
/**
 * The module allows you toWYSIWYG edit the image: resize or cut any part of it
 *
 */
var ImageEditor = /** @class */ (function (_super) {
    __extends(ImageEditor, _super);
    function ImageEditor(editor) {
        var _this = _super.call(this, editor) || this;
        _this.resizeUseRatio = true;
        _this.cropUseRatio = true;
        _this.clicked = false;
        _this.activeTab = 'resize';
        /**
         * Hide image editor
         *
         * @method hide
         */
        _this.hide = function () {
            _this.dialog.close();
        };
        _this.calcValueByPercent = function (value, percent) {
            var percentStr = percent.toString();
            var valueNbr = parseFloat(value.toString());
            var match;
            match = /^[\-+]?[0-9]+(px)?$/.exec(percentStr);
            if (match) {
                return parseInt(percentStr, 10);
            }
            match = /^([\-+]?[0-9.]+)%$/.exec(percentStr);
            if (match) {
                return Math.round(valueNbr * (parseFloat(match[1]) / 100));
            }
            return valueNbr || 0;
        };
        _this.calcCropBox = function () {
            var w = _this.crop_box.parentNode.offsetWidth * 0.8, h = _this.crop_box.parentNode.offsetHeight * 0.8, wn = w, hn = h;
            if (w > _this.naturalWidth && h > _this.naturalHeight) {
                wn = _this.naturalWidth;
                hn = _this.naturalHeight;
            }
            else if (_this.ratio > w / h) {
                wn = w;
                hn = _this.naturalHeight * (w / _this.naturalWidth);
            }
            else {
                wn = _this.naturalWidth * (h / _this.naturalHeight);
                hn = h;
            }
            Helpers_1.css(_this.crop_box, {
                width: wn,
                height: hn
            });
        };
        _this.showCrop = function () {
            if (!_this.cropImage) {
                return;
            }
            _this.calcCropBox();
            _this.new_w = _this.calcValueByPercent(_this.cropImage.offsetWidth || _this.image.offsetWidth, _this.options.cropDefaultWidth);
            if (_this.cropUseRatio) {
                _this.new_h = _this.new_w / _this.ratio;
            }
            else {
                _this.new_h = _this.calcValueByPercent(_this.cropImage.offsetHeight || _this.image.offsetHeight, _this.options.cropDefaultHeight);
            }
            Helpers_1.css(_this.cropHandler, {
                backgroundImage: 'url(' + _this.cropImage.getAttribute('src') + ')',
                width: _this.new_w,
                height: _this.new_h,
                left: (_this.cropImage.offsetWidth || _this.image.offsetWidth) / 2 - _this.new_w / 2,
                top: (_this.cropImage.offsetHeight || _this.image.offsetHeight) / 2 - _this.new_h / 2
            });
            _this.jodit.events.fire(_this.cropHandler, 'updatesize');
        };
        _this.cropBox = {
            x: 0,
            y: 0,
            w: 0,
            h: 0,
        };
        _this.updateCropBox = function () {
            if (!_this.cropImage) {
                return;
            }
            var ratioX = _this.cropImage.offsetWidth / _this.naturalWidth, ratioY = _this.cropImage.offsetHeight / _this.naturalHeight;
            _this.cropBox.x = Helpers_1.css(_this.cropHandler, 'left') / ratioX;
            _this.cropBox.y = Helpers_1.css(_this.cropHandler, 'top') / ratioY;
            _this.cropBox.w = _this.cropHandler.offsetWidth / ratioX;
            _this.cropBox.h = _this.cropHandler.offsetHeight / ratioY;
            _this.sizes.innerText = _this.cropBox.w.toFixed(0) + 'x' + _this.cropBox.h.toFixed(0);
        };
        _this.resizeBox = {
            w: 0,
            h: 0,
        };
        _this.updateResizeBox = function () {
            _this.resizeBox.w = _this.image.offsetWidth || _this.naturalWidth;
            _this.resizeBox.h = _this.image.offsetHeight || _this.naturalHeight;
        };
        /**
         * Open image editor
         *
         * @method open
         * @param {string} url
         * @param {function} save
         * @param {string} [save.name] new filename
         * @param {object} save.data Bound box for resize and crop operation
         * @param {string} save.data.action resize or crop
         * @param {object} save.data.box Bound box
         * @param {function} save.success called after success operation
         * @param {function} save.failed called after failed operation
         * @example
         * ```javascript
         * var jodit = new Jodit('.editor', {
         *     imageeditor: {
         *         crop: false,
         *         closeAfterSave: true,
         *         width: 500
         *     }
         * });
         * jodit.imageeditor.open('http://xdsoft.net/jodit/images/test.png', function (name, data, success, failed) {
         *     var img = jodit.node.create('img');
         *     img.setAttribute('src', 'http://xdsoft.net/jodit/images/test.png');
         *     if (box.action !== 'resize') {
         *          return failed('Sorry it is work only in resize mode. For croping use FileBrowser');
         *     }
         *     img.style.width = data.w;
         *     img.style.height = data.h;
         *     jodit.selection.insertNode(img);
         *     success();
         * });
         * ```
         */
        _this.open = function (url, save) {
            return new Promise(function (resolve) {
                var timestamp = (new Date()).getTime();
                _this.image = _this.jodit.ownerDocument.createElement('img');
                Helpers_1.$$('img,.jodit_icon-loader', _this.resize_box).forEach(function (elm) {
                    elm.parentNode && elm.parentNode.removeChild(elm);
                });
                Helpers_1.$$('img,.jodit_icon-loader', _this.crop_box).forEach(function (elm) {
                    elm.parentNode && elm.parentNode.removeChild(elm);
                });
                Helpers_1.css(_this.cropHandler, 'background', 'transparent');
                _this.onSave = save;
                _this.resize_box.appendChild(Helpers_1.dom('<i class="jodit_icon-loader"></i>', _this.jodit.ownerDocument));
                _this.crop_box.appendChild(Helpers_1.dom('<i class="jodit_icon-loader"></i>', _this.jodit.ownerDocument));
                if (/\?/.test(url)) {
                    url += '&_tst=' + timestamp;
                }
                else {
                    url += '?_tst=' + timestamp;
                }
                _this.image.setAttribute('src', url);
                _this.dialog.open();
                var onload = function () {
                    _this.image.removeEventListener("load", onload);
                    _this.naturalWidth = _this.image.naturalWidth;
                    _this.naturalHeight = _this.image.naturalHeight;
                    _this.widthInput.value = _this.naturalWidth.toString();
                    _this.heightInput.value = _this.naturalHeight.toString();
                    _this.ratio = _this.naturalWidth / _this.naturalHeight;
                    _this.resize_box.appendChild(_this.image);
                    _this.cropImage = _this.image.cloneNode();
                    _this.crop_box.appendChild(_this.cropImage);
                    Helpers_1.$$('.jodit_icon-loader', _this.editor).forEach(function (elm) {
                        elm.parentNode && elm.parentNode.removeChild(elm);
                    });
                    if (_this.activeTab === 'crop') {
                        _this.showCrop();
                    }
                    _this.jodit.events.fire(_this.resizeHandler, 'updatesize');
                    _this.jodit.events.fire(_this.cropHandler, 'updatesize');
                    _this.dialog.setPosition();
                    _this.jodit.events.fire('afterImageEditor');
                    resolve(_this.dialog);
                };
                _this.image.addEventListener("load", onload);
                if (_this.image.complete) {
                    onload();
                }
            });
        };
        _this.setHandlers = function () {
            var self = _this;
            self.jodit.events
                .on([self.editor.querySelector('.jodit_bottomright'), self.cropHandler], 'mousedown', function (e) {
                self.target = e.target || e.srcElement;
                e.preventDefault();
                e.stopImmediatePropagation();
                self.clicked = true;
                self.start_x = e.clientX;
                self.start_y = e.clientY;
                if (self.activeTab === 'crop') {
                    self.top_x = Helpers_1.css(self.cropHandler, 'left');
                    self.top_y = Helpers_1.css(self.cropHandler, 'top');
                    self.width = self.cropHandler.offsetWidth;
                    self.height = self.cropHandler.offsetHeight;
                }
                else {
                    self.width = self.image.offsetWidth;
                    self.height = self.image.offsetHeight;
                }
            })
                .off(_this.jodit.ownerWindow, '.jodit_image_editor' + self.jodit.id)
                .on(_this.jodit.ownerWindow, 'mousemove.jodit_image_editor' + self.jodit.id, Helpers_1.throttle(function (e) {
                if (self.clicked) {
                    self.diff_x = e.clientX - self.start_x;
                    self.diff_y = e.clientY - self.start_y;
                    if ((self.activeTab === 'resize' && self.resizeUseRatio) || (self.activeTab === 'crop' && self.cropUseRatio)) {
                        if (self.diff_x) {
                            self.new_w = self.width + self.diff_x;
                            self.new_h = Math.round(self.new_w / self.ratio);
                        }
                        else {
                            self.new_h = self.height + self.diff_y;
                            self.new_w = Math.round(self.new_h * self.ratio);
                        }
                    }
                    else {
                        self.new_w = self.width + self.diff_x;
                        self.new_h = self.height + self.diff_y;
                    }
                    if (self.activeTab === 'resize') {
                        if (self.new_w > self.options.resizeMinWidth) {
                            Helpers_1.css(self.image, 'width', self.new_w + 'px');
                            self.widthInput.value = self.new_w.toString();
                        }
                        if (self.new_h > self.options.resizeMinHeight) {
                            Helpers_1.css(self.image, 'height', self.new_h + 'px');
                            self.heightInput.value = self.new_h.toString();
                        }
                        _this.jodit.events.fire(self.resizeHandler, 'updatesize');
                    }
                    else {
                        if (self.target !== self.cropHandler) {
                            if (self.top_x + self.new_w > self.cropImage.offsetWidth) {
                                self.new_w = self.cropImage.offsetWidth - self.top_x;
                            }
                            if (self.top_y + self.new_h > self.cropImage.offsetHeight) {
                                self.new_h = self.cropImage.offsetHeight - self.top_y;
                            }
                            Helpers_1.css(self.cropHandler, {
                                width: self.new_w,
                                height: self.new_h
                            });
                        }
                        else {
                            if (self.top_x + self.diff_x + self.cropHandler.offsetWidth > self.cropImage.offsetWidth) {
                                self.diff_x = self.cropImage.offsetWidth - self.top_x - self.cropHandler.offsetWidth;
                            }
                            Helpers_1.css(self.cropHandler, 'left', self.top_x + self.diff_x);
                            if (self.top_y + self.diff_y + self.cropHandler.offsetHeight > self.cropImage.offsetHeight) {
                                self.diff_y = self.cropImage.offsetHeight - self.top_y - self.cropHandler.offsetHeight;
                            }
                            Helpers_1.css(self.cropHandler, 'top', self.top_y + self.diff_y);
                        }
                        _this.jodit.events.fire(self.cropHandler, 'updatesize');
                    }
                    e.stopImmediatePropagation();
                }
            }, 5))
                .on(_this.jodit.ownerWindow, 'resize.jodit_image_editor' + self.jodit.id, function () {
                _this.jodit.events.fire(self.resizeHandler, 'updatesize');
                self.showCrop();
                _this.jodit.events.fire(self.cropHandler, 'updatesize');
            })
                .on(_this.jodit.ownerWindow, 'mouseup.jodit_image_editor' + self.jodit.id + ' keydown.jodit_image_editor' + self.jodit.id, function (e) {
                if (self.clicked) {
                    self.clicked = false;
                    e.stopImmediatePropagation();
                }
            });
            // btn group
            Helpers_1.$$('.jodit_btn_group', self.editor).forEach(function (group) {
                var input = group.querySelector('input');
                self.jodit.events.on(group, 'click change', function () {
                    var button = this;
                    Helpers_1.$$('button', group).forEach(function (button) { return button.classList.remove('active'); });
                    button.classList.add('active');
                    input.checked = !!button.getAttribute('data-yes');
                    self.jodit.events.fire(input, 'change');
                }, 'button');
            });
            self.jodit.events
                .on(_this.editor, 'click', function () {
                Helpers_1.$$('.jodit_image_editor_slider,.jodit_image_editor_area', self.editor).forEach(function (elm) { return elm.classList.remove('active'); });
                var slide = this.parentNode;
                slide.classList.add('active');
                self.activeTab = slide.getAttribute('data-area') || '';
                var tab = self.editor.querySelector('.jodit_image_editor_area.jodit_image_editor_area_' + self.activeTab);
                if (tab) {
                    tab.classList.add('active');
                }
                if (self.activeTab === 'crop') {
                    self.showCrop();
                }
            }, '.jodit_image_editor_slider-title')
                .on(self.widthInput, 'change mousedown keydown', Helpers_1.debounce(function () {
                var value = parseInt(self.widthInput.value, 10);
                var another;
                if (value > self.jodit.options.resizer.min_width) {
                    Helpers_1.css(self.image, 'width', value + 'px');
                    if (self.resizeUseRatio) {
                        another = Math.round(value / self.ratio);
                        if (another > self.jodit.options.resizer.min_height) {
                            Helpers_1.css(self.image, 'height', another + 'px');
                            self.heightInput.value = another.toString();
                        }
                    }
                }
                _this.jodit.events.fire(self.resizeHandler, 'updatesize');
            }, 200))
                .on(self.heightInput, 'change mousedown keydown', Helpers_1.debounce(function () {
                var value = parseInt(self.heightInput.value, 10);
                var another;
                if (value > self.jodit.options.resizer.min_height) {
                    Helpers_1.css(self.image, 'height', value + 'px');
                    if (self.resizeUseRatio) {
                        another = Math.round(value * self.ratio);
                        if (another > self.jodit.options.resizer.min_width) {
                            Helpers_1.css(self.image, 'width', another + 'px');
                            self.widthInput.value = another.toString();
                        }
                    }
                }
                _this.jodit.events.fire(self.resizeHandler, 'updatesize');
            }, 200));
            var rationResizeButton = self.editor.querySelector('.jodit_image_editor_keep_spect_ratio');
            if (rationResizeButton) {
                rationResizeButton.addEventListener('change', function () {
                    self.resizeUseRatio = rationResizeButton.checked;
                });
            }
            // use ratio
            var rationCropButton = self.editor.querySelector('.jodit_image_editor_keep_spect_ratio_crop');
            if (rationCropButton) {
                rationCropButton.addEventListener('change', function () {
                    self.cropUseRatio = rationCropButton.checked;
                });
            }
            self.jodit.events
                .on(self.resizeHandler, 'updatesize', function () {
                Helpers_1.css(self.resizeHandler, {
                    top: 0,
                    left: 0,
                    width: (self.image.offsetWidth || self.naturalWidth) + 'px',
                    height: (self.image.offsetHeight || self.naturalHeight) + 'px'
                });
                _this.updateResizeBox();
            })
                .on(self.cropHandler, 'updatesize', function () {
                if (!self.cropImage) {
                    return;
                }
                var new_x = Helpers_1.css(self.cropHandler, 'left'), new_y = Helpers_1.css(self.cropHandler, 'top'), new_width = self.cropHandler.offsetWidth, new_height = self.cropHandler.offsetHeight;
                if (new_x < 0) {
                    new_x = 0;
                }
                if (new_y < 0) {
                    new_y = 0;
                }
                if (new_x + new_width > self.cropImage.offsetWidth) {
                    new_width = self.cropImage.offsetWidth - new_x;
                    if (self.cropUseRatio) {
                        new_height = new_width / self.ratio;
                    }
                }
                if (new_y + new_height > self.cropImage.offsetHeight) {
                    new_height = self.cropImage.offsetHeight - new_y;
                    if (self.cropUseRatio) {
                        new_width = new_height * self.ratio;
                    }
                }
                Helpers_1.css(self.cropHandler, {
                    width: new_width,
                    height: new_height,
                    left: new_x,
                    top: new_y,
                    backgroundPosition: (-new_x - 1) + 'px ' + (-new_y - 1) + 'px',
                    backgroundSize: self.cropImage.offsetWidth + 'px ' + self.cropImage.offsetHeight + 'px'
                });
                self.updateCropBox();
            });
            self.buttons.forEach(function (button) {
                button.addEventListener('mousedown', function (e) {
                    e.stopImmediatePropagation();
                });
                button.addEventListener('click', function () {
                    var data = {
                        action: self.activeTab,
                        box: self.activeTab === 'resize' ? self.resizeBox : self.cropBox
                    };
                    switch (button.getAttribute('data-action')) {
                        case 'saveas':
                            Dialog_1.Promt(self.jodit.i18n('Enter new name'), self.jodit.i18n('Save in new file'), function (name) {
                                if (!Helpers_1.trim(name)) {
                                    Dialog_1.Alert(self.jodit.i18n('The name should not be empty'));
                                    return false;
                                }
                                self.onSave(name, data, self.hide, function (message) {
                                    Dialog_1.Alert(message);
                                });
                            });
                            break;
                        case 'save':
                            self.onSave(undefined, data, self.hide, function (message) {
                                Dialog_1.Alert(message);
                            });
                            break;
                        case 'reset':
                            if (self.activeTab === 'resize') {
                                Helpers_1.css(self.image, {
                                    width: null,
                                    height: null,
                                });
                                self.widthInput.value = self.naturalWidth.toString();
                                self.heightInput.value = self.naturalHeight.toString();
                                self.jodit.events.fire(self.resizeHandler, 'updatesize');
                            }
                            else {
                                self.showCrop();
                            }
                            break;
                    }
                });
            });
        };
        _this.options = (editor && editor.options) ? editor.options.imageeditor : Jodit_1.Jodit.defaultOptions.imageeditor;
        _this.resizeUseRatio = _this.options.resizeUseRatio;
        _this.cropUseRatio = _this.options.cropUseRatio;
        _this.buttons = [
            Helpers_1.dom('<button data-action="reset" type="button" class="jodit_btn">' + ToolbarCollection_1.ToolbarIcon.getIcon('update') + ' ' + editor.i18n('Reset') + '</button>', editor.ownerDocument),
            Helpers_1.dom('<button data-action="save" type="button" class="jodit_btn jodit_btn_success">' + ToolbarCollection_1.ToolbarIcon.getIcon('save') + ' ' + editor.i18n('Save') + '</button>', editor.ownerDocument),
            Helpers_1.dom('<button data-action="saveas" type="button" class="jodit_btn jodit_btn_success">' + ToolbarCollection_1.ToolbarIcon.getIcon('save') + ' ' + editor.i18n('Save as ...') + '</button>', editor.ownerDocument),
        ];
        _this.activeTab = _this.options.resize ? 'resize' : 'crop';
        _this.editor = Helpers_1.dom('<form class="jodit_image_editor jodit_properties">' +
            '<div class="jodit_grid">' +
            '<div class="jodit_col-lg-3-4">' +
            (_this.options.resize ?
                '<div class="jodit_image_editor_area jodit_image_editor_area_resize active">\
                                <div class="jodit_image_editor_box"></div>\
                                <div class="jodit_image_editor_resizer">\
                                    <i class="jodit_bottomright"></i>\
                                </div>\
                            </div>' : '') +
            (_this.options.crop ?
                '<div class="jodit_image_editor_area jodit_image_editor_area_crop' + (!_this.options.resize ? ' active' : '') + '">\
                                <div class="jodit_image_editor_box">\
                                    <div class="jodit_image_editor_croper">\
                                        <i class="jodit_bottomright"></i>\
                                        <i class="jodit_sizes"></i>\
                                    </div>\
                                </div>\
                            </div>' : '') +
            '</div>' +
            '<div class="jodit_col-lg-1-4">' +
            (_this.options.resize ?
                '<div data-area="resize" class="jodit_image_editor_slider active">\
                                <div class="jodit_image_editor_slider-title">' + ToolbarCollection_1.ToolbarIcon.getIcon('resize') + editor.i18n('Resize') + '</div>\
                                <div class="jodit_image_editor_slider-content">\
                                    <div class="jodit_form_group">\
                                        <label for="jodit_image_editor_width">' + editor.i18n('Width') + '</label>\
                                        <input type="number" class="jodit_image_editor_width"/>\
                                    </div>\
                                    <div class="jodit_form_group">\
                                        <label for="jodit_image_editor_height">' + editor.i18n('Height') + '</label>\
                                        <input type="number" class="jodit_image_editor_height"/>\
                                    </div>\
                                    <div class="jodit_form_group">\
                                        <label>' + editor.i18n('Keep Aspect Ratio') + '</label>\
                                        <div class="jodit_btn_group jodit_btn_radio_group">\
                                            <input ' + (_this.resizeUseRatio ? 'checked' : '') + ' type="checkbox" class="jodit_image_editor_keep_spect_ratio"/>\
                                            <button type="button"  data-yes="1" class="jodit_col6 jodit_btn jodit_btn_success ' + (_this.resizeUseRatio ? 'active' : '') + '">' + editor.i18n('Yes') + '</button>\
                                            <button type="button" class="jodit_col6 jodit_btn' + (!_this.resizeUseRatio ? 'active' : '') + '">' + editor.i18n('No') + '</button>\
                                        </div>\
                                    </div>\
                                </div>\
                            </div>' : '') +
            (_this.options.crop ?
                '<div data-area="crop" class="jodit_image_editor_slider' + (!_this.options.resize ? ' active' : '') + '">\
                                <div class="jodit_image_editor_slider-title">' + ToolbarCollection_1.ToolbarIcon.getIcon('crop') + editor.i18n('Crop') + '</div>\
                                <div class="jodit_image_editor_slider-content">\
                                    <div class="jodit_form_group">\
                                        <label>' + editor.i18n('Keep Aspect Ratio') + '</label>\
                                        <div class="jodit_btn_group jodit_btn_radio_group">\
                                            <input ' + (_this.cropUseRatio ? 'checked' : '') + ' type="checkbox" class="jodit_image_editor_keep_spect_ratio_crop"/>\
                                            <button type="button" data-yes="1" class="jodit_col6 jodit_btn jodit_btn_success ' + (_this.cropUseRatio ? 'active' : '') + '">' + editor.i18n('Yes') + '</button>\
                                            <button type="button" class="jodit_col6 jodit_btn ' + (!_this.cropUseRatio ? 'active' : '') + '">' + editor.i18n('No') + '</button>\
                                        </div>\
                                    </div>\
                                </div>\
                            </div>' : '') +
            '</div>' +
            '</div>' +
            '</form>', editor.ownerDocument);
        _this.widthInput = _this.editor.querySelector('.jodit_image_editor_width');
        _this.heightInput = _this.editor.querySelector('.jodit_image_editor_height');
        _this.resize_box = _this.editor.querySelector('.jodit_image_editor_area.jodit_image_editor_area_resize .jodit_image_editor_box');
        _this.crop_box = _this.editor.querySelector('.jodit_image_editor_area.jodit_image_editor_area_crop .jodit_image_editor_box');
        _this.sizes = _this.editor.querySelector('.jodit_image_editor_area.jodit_image_editor_area_crop .jodit_sizes');
        _this.resizeHandler = _this.editor.querySelector('.jodit_image_editor_resizer');
        _this.cropHandler = _this.editor.querySelector('.jodit_image_editor_croper');
        _this.dialog = new Dialog_1.Dialog(editor);
        _this.dialog.setContent(_this.editor);
        _this.dialog.setSize(_this.options.width, _this.options.height);
        _this.dialog.setTitle(_this.buttons);
        _this.setHandlers();
        return _this;
    }
    return ImageEditor;
}(Component_1.Component));
exports.ImageEditor = ImageEditor;


/***/ }),
/* 66 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var consts = __webpack_require__(2);
var index_1 = __webpack_require__(12);
/**
 * Process navigate keypressing in table cell
 *
 * @param {Jodit} editor
 */
function tableKeyboardNavigation(editor) {
    editor.events.on('keydown', function (event) {
        var current, block;
        if (event.which === consts.KEY_TAB ||
            event.which === consts.KEY_LEFT ||
            event.which === consts.KEY_RIGHT ||
            event.which === consts.KEY_UP ||
            event.which === consts.KEY_DOWN) {
            current = editor.selection.current();
            block = index_1.Dom.up(current, function (elm) { return (elm && elm.nodeName && /^td|th$/i.test(elm.nodeName)); }, editor.editor);
            if (!block) {
                return;
            }
            var sel = editor.editorWindow.getSelection(), range = sel.rangeCount ? sel.getRangeAt(0) : editor.editorDocument.createRange();
            if (event.which !== consts.KEY_TAB && current !== block) {
                if (((event.which === consts.KEY_LEFT || event.which === consts.KEY_UP) &&
                    (index_1.Dom.prev(current, function (elm) { return (event.which === consts.KEY_UP ? (elm && elm.nodeName === 'BR') : !!elm); }, block) || (event.which !== consts.KEY_UP && current.nodeType === Node.TEXT_NODE && range.startOffset !== 0))) || ((event.which === consts.KEY_RIGHT || event.which === consts.KEY_DOWN) &&
                    (index_1.Dom.next(current, function (elm) { return (event.which === consts.KEY_DOWN ? (elm && elm.nodeName === 'BR') : !!elm); }, block) || (event.which !== consts.KEY_DOWN && current.nodeType === Node.TEXT_NODE && current.nodeValue && range.startOffset !== current.nodeValue.length)))) {
                    return;
                }
            }
        }
        else {
            return;
        }
        var table = index_1.Dom.up(block, function (elm) { return (elm && /^table$/i.test(elm.nodeName)); }, editor.editor);
        var next = null;
        switch (event.which) {
            case consts.KEY_TAB:
            // case consts.KEY_RIGHT:
            case consts.KEY_LEFT:
                var sibling = (event.which === consts.KEY_LEFT || event.shiftKey) ? 'prev' : 'next';
                next = index_1.Dom[sibling](block, function (elm) { return (elm && /^td|th$/i.test(elm.tagName)); }, table);
                if (!next) {
                    index_1.Table.appendRow(table, sibling === 'next' ? false : table.querySelector('tr'), sibling === 'next');
                    next = index_1.Dom[sibling](block, function (elm) { return (elm && index_1.Dom.isCell(elm, editor.editorWindow)); }, table);
                }
                break;
            case consts.KEY_UP:
            case consts.KEY_DOWN:
                {
                    var i_1 = 0, j_1 = 0, matrix = index_1.Table.formalMatrix(table, function (elm, _i, _j) {
                        if (elm === block) {
                            i_1 = _i;
                            j_1 = _j;
                        }
                    });
                    if (event.which === consts.KEY_UP) {
                        if (matrix[i_1 - 1] !== undefined) {
                            next = matrix[i_1 - 1][j_1];
                        }
                    }
                    else {
                        if (matrix[i_1 + 1] !== undefined) {
                            next = matrix[i_1 + 1][j_1];
                        }
                    }
                }
                break;
        }
        if (next) {
            if (!next.firstChild) {
                var first = editor.editorDocument.createElement('br');
                next.appendChild(first);
                editor.selection.setCursorBefore(first);
            }
            else {
                if (event.which === consts.KEY_TAB) {
                    editor.selection.select(next, true);
                }
                else {
                    editor.selection.setCursorIn(next, event.which === consts.KEY_RIGHT || event.which === consts.KEY_DOWN);
                }
            }
            return false;
        }
    });
}
exports.tableKeyboardNavigation = tableKeyboardNavigation;


/***/ }),
/* 67 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Config_1 = __webpack_require__(1);
var Helpers_1 = __webpack_require__(0);
var index_1 = __webpack_require__(12);
var consts = __webpack_require__(2);
var constants_1 = __webpack_require__(2);
Config_1.Config.prototype.useSearch = true;
/**
 * Search plugin. it is used for custom search in text
 * ![search](https://user-images.githubusercontent.com/794318/34545433-cd0a9220-f10e-11e7-8d26-7e22f66e266d.gif)
 *
 * @example
 * ```typescript
 * var jodit = new Jodit('#editor', {
 *  useSearch: false
 * });
 * // or
 * var jodit = new Jodit('#editor', {
 *  disablePlugins: 'search'
 * });
 * ```
 */
var search = /** @class */ (function (_super) {
    __extends(search, _super);
    function search(editor) {
        var _this = _super.call(this, editor) || this;
        _this.template = '<div class="jodit_search">' +
            '<div class="jodit_search_box">' +
            '<div class="jodit_search_inputs">' +
            '<input tabindex="0" class="jodit_search-query" placeholder="' + _this.jodit.i18n('Search for') + '" type="text"/>' +
            '<input tabindex="0" class="jodit_search-replace" placeholder="' + _this.jodit.i18n('Replace with') + '" type="text"/>' +
            '</div>' +
            '<div class="jodit_search_counts">' +
            '<span>0/0</span>' +
            '</div>' +
            '<div class="jodit_search_buttons">' +
            '<button tabindex="0" type="button" class="jodit_search_buttons-next">' + index_1.ToolbarIcon.getIcon('angle-down') + '</button>' +
            '<button tabindex="0" type="button" class="jodit_search_buttons-prev">' + index_1.ToolbarIcon.getIcon('angle-up') + '</button>' +
            '<button tabindex="0" type="button" class="jodit_search_buttons-cancel">' + index_1.ToolbarIcon.getIcon('cancel') + '</button>' +
            '<button tabindex="0" type="button" class="jodit_search_buttons-replace">' + _this.jodit.i18n('Replace') + '</button>' +
            '</div>' +
            '</div>' +
            '</div>';
        _this.eachMap = function (node, callback, next) {
            index_1.Dom.findWithCurrent(node, function (child) {
                return !!child && callback(child) === true;
            }, _this.jodit.editor, next ? 'nextSibling' : 'previousSibling', next ? 'firstChild' : 'lastChild');
        };
        _this.updateCounters = function () {
            if (!_this.isOpened) {
                return;
            }
            _this.counterBox.style.display = _this.queryInput.value.length ? 'inline-block' : 'none';
            var sel = _this.jodit.editorWindow.getSelection(), range = sel.rangeCount ? sel.getRangeAt(0) : _this.jodit.editorDocument.createRange(), counts = _this.calcCounts(_this.queryInput.value, range);
            _this.counterBox.innerText = counts.join('/');
        };
        _this.calcCounts = function (query, current) {
            if (current === void 0) { current = false; }
            var currentIndex = 0, count = 0, bounds = [], bound = false, start = _this.jodit.editor.firstChild;
            while (start && query.length) {
                bound = _this.find(start, query, true, 0, bound || _this.jodit.editorDocument.createRange());
                if (bound) {
                    if (_this.boundAlreadyWas(bound, bounds)) {
                        break;
                    }
                    bounds.push(bound);
                    start = bound.startContainer;
                    count += 1;
                    if (current && _this.boundAlreadyWas(current, [bound])) {
                        currentIndex = count;
                    }
                }
                else {
                    start = null;
                }
            }
            return [currentIndex, count];
        };
        _this.findAndReplace = function (start, query) {
            var sel = _this.jodit.editorWindow.getSelection(), range = sel.rangeCount ? sel.getRangeAt(0) : _this.jodit.editorDocument.createRange(), bound = _this.find(start, query, true, 0, range);
            if (bound && bound.startContainer && bound.endContainer) {
                var range_1 = _this.jodit.editorDocument.createRange();
                try {
                    if (bound && bound.startContainer && bound.endContainer) {
                        range_1.setStart(bound.startContainer, bound.startOffset);
                        range_1.setEnd(bound.endContainer, bound.endOffset);
                        range_1.deleteContents();
                        var textNode = _this.jodit.editorDocument.createTextNode(_this.replaceInput.value);
                        range_1.insertNode(textNode);
                        _this.jodit.selection.select(textNode);
                        _this.tryScrollToElement(textNode);
                    }
                }
                catch (e) {
                }
                return true;
            }
            return false;
        };
        _this.findAndSelect = function (start, query, next) {
            var sel = _this.jodit.editorWindow.getSelection(), range = sel.rangeCount ? sel.getRangeAt(0) : _this.jodit.editorDocument.createRange(), bound = _this.find(start, query, next, 0, range);
            if (bound && bound.startContainer && bound.endContainer) {
                var range_2 = _this.jodit.editorDocument.createRange();
                try {
                    range_2.setStart(bound.startContainer, bound.startOffset);
                    range_2.setEnd(bound.endContainer, bound.endOffset);
                    _this.jodit.selection.selectRange(range_2);
                }
                catch (e) {
                }
                _this.tryScrollToElement(bound.startContainer);
                _this.current = bound.startContainer;
                _this.updateCounters();
                return true;
            }
            return false;
        };
        _this.find = function (start, query, next, deep, range) {
            if (start && query.length) {
                var sentence_1 = '', bound_1 = {
                    startContainer: null,
                    startOffset: null,
                    endContainer: null,
                    endOffset: null,
                };
                _this.eachMap(start, function (elm) {
                    if (elm.nodeType === Node.TEXT_NODE && elm.nodeValue !== null && elm.nodeValue.length) {
                        var value = elm.nodeValue;
                        if (!next && elm === range.startContainer) {
                            value = !deep ? value.substr(0, range.startOffset) : value.substr(range.endOffset);
                        }
                        else if (next && elm === range.endContainer) {
                            value = !deep ? value.substr(range.endOffset) : value.substr(0, range.startOffset);
                        }
                        var tmpSentence = next ? sentence_1 + value : value + sentence_1;
                        var part = search.findSomePartOfString(query, tmpSentence, next);
                        if (part !== false) {
                            var currentPart = search.findSomePartOfString(query, value, next);
                            if (currentPart === true) {
                                currentPart = Helpers_1.trim(query);
                            }
                            else if (currentPart === false) {
                                currentPart = search.findSomePartOfString(value, query, next);
                                if (currentPart === true) {
                                    currentPart = Helpers_1.trim(value);
                                }
                            }
                            var currentPartIndex = search.getSomePartOfStringIndex(query, value, next) || 0;
                            if (((next && !deep) || (!next && deep)) && elm.nodeValue.length - value.length > 0) {
                                currentPartIndex += elm.nodeValue.length - value.length;
                            }
                            if (bound_1.startContainer === null) {
                                bound_1.startContainer = elm;
                                bound_1.startOffset = currentPartIndex;
                            }
                            if (part !== true) {
                                sentence_1 = tmpSentence;
                            }
                            else {
                                bound_1.endContainer = elm;
                                bound_1.endOffset = currentPartIndex;
                                bound_1.endOffset += currentPart.length;
                                return true;
                            }
                        }
                        else {
                            sentence_1 = '';
                            bound_1 = {
                                startContainer: null,
                                startOffset: null,
                                endContainer: null,
                                endOffset: null,
                            };
                        }
                    }
                    else if (index_1.Dom.isBlock(elm) && sentence_1 !== '') {
                        sentence_1 = next ? sentence_1 + ' ' : ' ' + sentence_1;
                    }
                    return false;
                }, next);
                if (bound_1.startContainer && bound_1.endContainer) {
                    return bound_1;
                }
                if (!deep) {
                    _this.current = next ? _this.jodit.editor.firstChild : _this.jodit.editor.lastChild;
                    return _this.find(_this.current, query, next, deep + 1, range);
                }
            }
            return false;
        };
        _this.isOpened = false;
        _this.open = function (searchAndReplace) {
            if (searchAndReplace === void 0) { searchAndReplace = false; }
            if (!_this.isOpened) {
                _this.searchBox.classList.add('jodit_search-active');
                _this.isOpened = true;
            }
            _this.jodit.events.fire('hidePopup');
            _this.searchBox.classList.toggle('jodit_search-and-replace', searchAndReplace);
            _this.current = _this.jodit.selection.current();
            _this.selInfo = _this.jodit.selection.save();
            var sel = _this.jodit.ownerWindow.getSelection().toString();
            if (sel) {
                _this.queryInput.value = sel;
            }
            _this.updateCounters();
            if (sel) {
                _this.queryInput.select();
            }
            else {
                _this.queryInput.focus();
            }
        };
        _this.selInfo = null;
        _this.current = false;
        _this.close = function () {
            if (!_this.isOpened) {
                return;
            }
            if (_this.selInfo) {
                _this.jodit.selection.restore(_this.selInfo);
                _this.selInfo = null;
            }
            _this.searchBox.classList.remove('jodit_search-active');
            _this.isOpened = false;
        };
        if (editor.options.useSearch) {
            var self_1 = _this;
            self_1.searchBox = Helpers_1.dom(self_1.template, editor.ownerDocument);
            self_1.queryInput = self_1.searchBox.querySelector('input.jodit_search-query');
            self_1.replaceInput = self_1.searchBox.querySelector('input.jodit_search-replace');
            self_1.closeButton = self_1.searchBox.querySelector('.jodit_search_buttons-cancel');
            self_1.nextButton = self_1.searchBox.querySelector('.jodit_search_buttons-next');
            self_1.prevButton = self_1.searchBox.querySelector('.jodit_search_buttons-prev');
            self_1.replaceButton = self_1.searchBox.querySelector('.jodit_search_buttons-replace');
            self_1.counterBox = self_1.searchBox.querySelector('.jodit_search_counts span');
            editor.events
                .on(self_1.closeButton, 'click', _this.close)
                .on(self_1.queryInput, 'mousedown', function () {
                if (editor.selection.isFocused()) {
                    editor.selection.removeMarkers();
                    self_1.selInfo = editor.selection.save();
                }
            })
                .on(self_1.replaceButton, 'click', function (e) {
                self_1.findAndReplace(editor.selection.current() || editor.editor.firstChild, self_1.queryInput.value);
                _this.updateCounters();
                e.preventDefault();
                e.stopImmediatePropagation();
            })
                .on([self_1.nextButton, self_1.prevButton], 'click', function (e) {
                editor.events.fire(self_1.nextButton === this ? 'searchNext' : 'searchPrevious');
                e.preventDefault();
                e.stopImmediatePropagation();
            })
                .on(_this.queryInput, 'keydown', Helpers_1.debounce(function (e) {
                switch (e.which) {
                    case consts.KEY_ENTER:
                        e.preventDefault();
                        e.stopImmediatePropagation();
                        if (editor.events.fire('searchNext')) {
                            _this.close();
                        }
                        break;
                    default:
                        _this.updateCounters();
                        break;
                }
            }, _this.jodit.defaultTimeout))
                .on(_this.jodit.container, 'keydown', function (e) {
                if (editor.getRealMode() !== constants_1.MODE_WYSIWYG) {
                    return;
                }
                switch (e.which) {
                    case consts.KEY_ESC:
                        _this.close();
                        break;
                    case consts.KEY_F3:
                        if (self_1.queryInput.value) {
                            editor.events.fire(!e.shiftKey ? 'searchNext' : 'searchPrevious');
                            e.preventDefault();
                        }
                        break;
                }
            })
                .on('beforeSetMode', function () {
                _this.close();
            })
                .on('afterInit', function () {
                editor.workplace.appendChild(_this.searchBox);
            })
                .on('keydown mousedown', function () {
                if (_this.selInfo) {
                    editor.selection.removeMarkers();
                    _this.selInfo = null;
                }
                if (_this.isOpened) {
                    _this.current = _this.jodit.selection.current();
                    _this.updateCounters();
                }
            })
                .on('searchNext searchPrevious', function () {
                return self_1.findAndSelect(editor.selection.current() || editor.editor.firstChild, self_1.queryInput.value, editor.events.current[editor.events.current.length - 1] === 'searchNext');
            })
                .on('search', function (value, next) {
                if (next === void 0) { next = true; }
                editor.execCommand('search', value, next);
            });
            editor.registerCommand('search', {
                exec: function (command, value, next) {
                    if (next === void 0) { next = true; }
                    self_1.findAndSelect(editor.selection.current() || editor.editor.firstChild, value, next);
                    return false;
                }
            });
            editor.registerCommand('openSearchDialog', {
                exec: function () {
                    self_1.open();
                    return false;
                },
                hotkeys: 'ctrl+f'
            });
            editor.registerCommand('openReplaceDialog', {
                exec: function () {
                    if (!editor.options.readonly) {
                        self_1.open(true);
                    }
                    return false;
                },
                hotkeys: 'ctrl+h'
            });
        }
        return _this;
    }
    search.getSomePartOfStringIndex = function (needle, haystack, start) {
        if (start === void 0) { start = true; }
        return this.findSomePartOfString(needle, haystack, start, true);
    };
    search.findSomePartOfString = function (needle, haystack, start, getIndex) {
        if (start === void 0) { start = true; }
        if (getIndex === void 0) { getIndex = false; }
        needle = Helpers_1.trim(needle.toLowerCase().replace(consts.SPACE_REG_EXP, ' '));
        haystack = haystack.toLowerCase();
        var i = start ? 0 : haystack.length - 1, needleStart = start ? 0 : needle.length - 1, startAtIndex = null, inc = start ? 1 : -1;
        var tmp = [];
        var tmpEqualLength = 0;
        for (; haystack[i] !== undefined; i += inc) {
            var some = needle[needleStart] === haystack[i];
            if (some || (startAtIndex !== null && consts.SPACE_REG_EXP.test(haystack[i]))) {
                if (startAtIndex === null || !start) {
                    startAtIndex = i;
                }
                tmp.push(haystack[i]);
                if (some) {
                    tmpEqualLength += 1;
                    needleStart += inc;
                }
            }
            else {
                startAtIndex = null;
                tmp.length = 0;
                tmpEqualLength = 0;
                needleStart = start ? 0 : needle.length - 1;
            }
            if (tmpEqualLength === needle.length) {
                return getIndex ? startAtIndex : true;
            }
        }
        return getIndex ? (startAtIndex !== null ? startAtIndex : false) : (tmp.length ? (start ? tmp.join('') : tmp.reverse().join('')) : false);
    };
    search.prototype.boundAlreadyWas = function (current, bounds) {
        return bounds.some(function (bound) {
            return bound.startContainer === current.startContainer && bound.endContainer === current.endContainer &&
                bound.startOffset === current.startOffset && bound.endOffset === current.endOffset;
        }, false);
    };
    search.prototype.tryScrollToElement = function (startContainer) {
        // find scrollable element
        var parentBox = index_1.Dom.closest(startContainer, function (elm) { return elm && elm.nodeType === Node.ELEMENT_NODE; }, this.jodit.editor);
        if (!parentBox) {
            parentBox = index_1.Dom.prev(startContainer, function (elm) { return elm && elm.nodeType === Node.ELEMENT_NODE; }, this.jodit.editor);
        }
        parentBox && parentBox !== this.jodit.editor && parentBox.scrollIntoView();
    };
    return search;
}(index_1.Component));
exports.search = search;


/***/ }),
/* 68 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Helpers_1 = __webpack_require__(0);
var Component_1 = __webpack_require__(4);
var Config_1 = __webpack_require__(1);
var constants_1 = __webpack_require__(2);
Config_1.Config.prototype.toolbarSticky = true;
Config_1.Config.prototype.toolbarDisableStickyForMobile = true;
Config_1.Config.prototype.toolbarStickyOffset = 0;
var sticky = /** @class */ (function (_super) {
    __extends(sticky, _super);
    function sticky(jodit) {
        var _this = _super.call(this, jodit) || this;
        _this.isToolbarSticked = false;
        _this.createDummy = function (toolbar) {
            if (!_this.dummyBox) {
                _this.dummyBox = _this.jodit.ownerDocument.createElement('div');
                _this.dummyBox.classList.add('jodit_sticky-dummy_toolbar');
                _this.jodit.container.insertBefore(_this.dummyBox, toolbar);
            }
        };
        _this.addSticky = function (toolbar) {
            if (!_this.isToolbarSticked) {
                _this.createDummy(toolbar);
                _this.jodit.container.classList.add('jodit_sticky');
                _this.isToolbarSticked = true;
            }
            // on resize it should work always
            Helpers_1.css(toolbar, {
                top: _this.jodit.options.toolbarStickyOffset,
                width: _this.jodit.container.offsetWidth
            });
            Helpers_1.css(_this.dummyBox, {
                height: toolbar.offsetHeight
            });
        };
        _this.removeSticky = function (toolbar) {
            if (_this.isToolbarSticked) {
                Helpers_1.css(toolbar, {
                    width: '',
                    top: ''
                });
                _this.jodit.container.classList.remove('jodit_sticky');
                _this.isToolbarSticked = false;
            }
        };
        jodit.events
            .on('afterInit', function () {
            jodit.events.on(jodit.ownerWindow, 'scroll wheel mousewheel resize', function () {
                var scrollWindowTop = jodit.ownerWindow.pageYOffset || jodit.ownerDocument.documentElement.scrollTop, offsetEditor = Helpers_1.offset(jodit.container, jodit, jodit.ownerDocument, true), doSticky = jodit.getMode() === constants_1.MODE_WYSIWYG && (scrollWindowTop + jodit.options.toolbarStickyOffset > offsetEditor.top &&
                    scrollWindowTop + jodit.options.toolbarStickyOffset < offsetEditor.top + offsetEditor.height) &&
                    !(jodit.options.toolbarDisableStickyForMobile && _this.isMobile());
                if (jodit.options.toolbarSticky && jodit.options.toolbar) {
                    doSticky ? _this.addSticky(jodit.toolbar.container) : _this.removeSticky(jodit.toolbar.container);
                }
                jodit.events.fire('toggleSticky', doSticky);
            });
        });
        return _this;
    }
    sticky.prototype.isMobile = function () {
        return this.jodit && this.jodit.options && this.jodit.container && this.jodit.options.sizeSM >= this.jodit.container.offsetWidth;
    };
    return sticky;
}(Component_1.Component));
exports.sticky = sticky;


/***/ }),
/* 69 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Config_1 = __webpack_require__(1);
var Plugin_1 = __webpack_require__(8);
var Helpers_1 = __webpack_require__(0);
var constants_1 = __webpack_require__(2);
Config_1.Config.prototype.showCharsCounter = true;
Config_1.Config.prototype.showWordsCounter = true;
/**
 * Show stat data - words and chars count
 */
var stat = /** @class */ (function (_super) {
    __extends(stat, _super);
    function stat() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.calc = Helpers_1.throttle(function () {
            var text = _this.jodit.getEditorText();
            if (_this.jodit.options.showCharsCounter) {
                _this.charCounter.innerText = _this.jodit.i18n('Chars: %d', text.replace(constants_1.SPACE_REG_EXP, '').length);
            }
            if (_this.jodit.options.showWordsCounter) {
                _this.wordCounter.innerText = _this.jodit.i18n('Words: %d', text
                    .replace(constants_1.INVISIBLE_SPACE_REG_EXP, '')
                    .split(constants_1.SPACE_REG_EXP)
                    .filter(function (e) { return e.length; }).length);
            }
        }, _this.jodit.defaultTimeout);
        return _this;
    }
    stat.prototype.afterInit = function () {
        if (this.jodit.options.showCharsCounter) {
            this.charCounter = this.jodit.ownerDocument.createElement('span');
            this.jodit.statusbar.append(this.charCounter, true);
        }
        if (this.jodit.options.showWordsCounter) {
            this.wordCounter = this.jodit.ownerDocument.createElement('span');
            this.jodit.statusbar.append(this.wordCounter, true);
        }
        this.jodit.events.on('change', this.calc);
        this.calc();
    };
    return stat;
}(Plugin_1.Plugin));
exports.stat = stat;


/***/ }),
/* 70 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var Config_1 = __webpack_require__(1);
var Plugin_1 = __webpack_require__(8);
var Helpers_1 = __webpack_require__(0);
var Dom_1 = __webpack_require__(3);
var ToolbarCollection_1 = __webpack_require__(5);
var constants_1 = __webpack_require__(2);
var ContextMenu_1 = __webpack_require__(15);
Config_1.Config.prototype.controls.selectall = {
    icon: 'select-all',
    command: 'selectall',
    tooltip: 'Select all'
};
Config_1.Config.prototype.showXPathInStatusbar = true;
/**
 * Show path to current element in status bar
 */
var xpath = /** @class */ (function (_super) {
    __extends(xpath, _super);
    function xpath() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.onContext = function (bindElement, event) {
            if (!_this.menu) {
                _this.menu = new ContextMenu_1.ContextMenu(_this.jodit);
            }
            _this.menu.show(event.clientX, event.clientY, [
                {
                    icon: 'bin',
                    title: bindElement === _this.jodit.editor ? 'Clear' : 'Remove',
                    exec: function () {
                        if (bindElement !== _this.jodit.editor) {
                            bindElement.parentNode && bindElement.parentNode.removeChild(bindElement);
                        }
                        else {
                            _this.jodit.value = '';
                        }
                        _this.jodit.setEditorValue();
                    }
                },
                {
                    icon: 'select-all',
                    title: 'Select',
                    exec: function () {
                        _this.jodit.selection.select(bindElement);
                    }
                }
            ]);
            return false;
        };
        _this.onSelectPath = function (bindElement, event) {
            _this.jodit.selection.focus();
            var path = event.target.getAttribute('data-path') || '/';
            if (path === '/') {
                _this.jodit.execCommand('selectall');
                return false;
            }
            try {
                var elm = _this.jodit.editorDocument.evaluate(path, _this.jodit.editor, null, XPathResult.ANY_TYPE, null).iterateNext();
                if (elm) {
                    _this.jodit.selection.select(elm);
                    return false;
                }
            }
            catch (e) {
            }
            _this.jodit.selection.select(bindElement);
            return false;
        };
        _this.tpl = function (bindElement, path, name, title) {
            var li = Helpers_1.dom("<li><a role=\"button\" data-path=\"" + path + "\" href=\"javascript:void(0)\" title=\"" + title + "\" tabindex=\"-1\">" + name + "</a></li>", _this.jodit.ownerDocument);
            var a = li.firstChild;
            _this.jodit.events
                .on(a, 'click', _this.onSelectPath.bind(_this, bindElement))
                .on(a, 'contextmenu', _this.onContext.bind(_this, bindElement));
            return li;
        };
        _this.appendSelectAll = function () {
            var li = new ToolbarCollection_1.ToolbarButton(_this.jodit, __assign({ name: 'selectall' }, _this.jodit.options.controls.selectall, { tooltip: '' }));
            _this.container.insertBefore(li.container, _this.container.firstChild);
        };
        _this.calcPathImd = function () {
            var current = _this.jodit.selection.current();
            var index = 0;
            _this.container.innerHTML = constants_1.INVISIBLE_SPACE;
            if (current) {
                Dom_1.Dom.up(current, function (elm) {
                    if (_this.jodit.editor !== elm && elm.nodeType !== Node.TEXT_NODE) {
                        var name_1 = elm.nodeName.toLowerCase(), xpath_1 = Helpers_1.getXPathByElement(elm, _this.jodit.editor).replace(/^\//, '');
                        var li = _this.tpl(elm, xpath_1, name_1, _this.jodit.i18n('Select %s', name_1));
                        _this.container.insertBefore(li, _this.container.firstChild);
                    }
                    index += 1;
                }, _this.jodit.editor);
            }
            _this.appendSelectAll();
        };
        _this.calcPath = Helpers_1.debounce(_this.calcPathImd, _this.jodit.defaultTimeout * 2);
        return _this;
    }
    xpath.prototype.afterInit = function () {
        var _this = this;
        if (this.jodit.options.showXPathInStatusbar) {
            this.container = this.jodit.ownerDocument.createElement('ul');
            this.container.classList.add('jodit_xpath');
            this.jodit.statusbar.append(this.container);
            this.jodit.events
                .on('mouseup change keydown changeSelection', this.calcPath)
                .on('afterSetMode afterInit', function () {
                if (_this.jodit.getRealMode() === constants_1.MODE_WYSIWYG) {
                    _this.calcPath();
                }
                else {
                    _this.container.innerHTML = constants_1.INVISIBLE_SPACE;
                    _this.appendSelectAll();
                }
            });
            this.calcPath();
        }
    };
    return xpath;
}(Plugin_1.Plugin));
exports.xpath = xpath;


/***/ }),
/* 71 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Plugin_1 = __webpack_require__(8);
var Helpers_1 = __webpack_require__(0);
var constants_1 = __webpack_require__(2);
var Dom_1 = __webpack_require__(3);
/**
 * Process drag and drop image from FileBrowser and movev image inside the editor
 */
var DragAndDrop = /** @class */ (function (_super) {
    __extends(DragAndDrop, _super);
    function DragAndDrop() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.isFragmentFromEditor = false;
        _this.isCopyMode = false;
        _this.startDragPoint = { x: 0, y: 0 };
        _this.draggable = null;
        _this.onDragEnd = function () {
            if (_this.draggable) {
                _this.draggable.parentNode && _this.draggable.parentNode.removeChild(_this.draggable);
                _this.draggable = null;
            }
            _this.isCopyMode = false;
        };
        _this.onDrag = Helpers_1.throttle(function (event) {
            if (_this.draggable) {
                if (!_this.draggable.parentNode) {
                    _this.jodit.ownerDocument.body.appendChild(_this.draggable);
                }
                _this.jodit.events.fire('hidePopup');
                Helpers_1.css(_this.draggable, {
                    left: event.clientX + 20,
                    top: event.clientY + 20,
                });
            }
        }, 10);
        _this.bufferRange = null;
        _this.onDragStart = function (event) {
            var target = event.target;
            _this.onDragEnd(); // remove olddraggable
            _this.isFragmentFromEditor = Dom_1.Dom.isOrContains(_this.jodit.editor, target, true);
            _this.isCopyMode = _this.isFragmentFromEditor ? Helpers_1.ctrlKey(event) : true; // we can move only element from editor
            if (_this.isFragmentFromEditor) {
                var sel = _this.jodit.editorWindow.getSelection();
                var range = sel.rangeCount ? sel.getRangeAt(0) : null;
                if (range) {
                    _this.bufferRange = range.cloneRange();
                }
            }
            else {
                _this.bufferRange = null;
            }
            _this.startDragPoint.x = event.clientX;
            _this.startDragPoint.y = event.clientY;
            if (target.nodeType === Node.ELEMENT_NODE && target.matches('.jodit_filebrowser_files_item')) {
                target = target.querySelector('img');
            }
            if (target.nodeName === 'IMG') {
                _this.draggable = target.cloneNode(true);
                Helpers_1.dataBind(_this.draggable, 'target', target);
                Helpers_1.css(_this.draggable, {
                    'z-index': 100000000000000,
                    position: 'fixed',
                    display: 'inlin-block',
                    left: _this.startDragPoint.x,
                    top: _this.startDragPoint.y,
                    width: target.offsetWidth,
                    height: target.offsetHeight,
                });
            }
        };
        _this.getDataTransfer = function (event) {
            return event.dataTransfer;
        };
        _this.getText = function (event) {
            var dt = _this.getDataTransfer(event);
            return dt.getData(constants_1.TEXT_HTML) || dt.getData(constants_1.TEXT_PLAIN);
        };
        _this.onDrop = function (event) {
            if (!event.dataTransfer.files || !event.dataTransfer.files.length) {
                if (!_this.isFragmentFromEditor && !_this.draggable) {
                    _this.jodit.events.fire('paste', event);
                    event.preventDefault();
                    event.stopPropagation();
                    return false;
                }
                var sel = _this.jodit.editorWindow.getSelection();
                var range = _this.bufferRange || (sel.rangeCount ? sel.getRangeAt(0) : null);
                var fragment = null;
                if (!_this.draggable && range) {
                    fragment = _this.isCopyMode ? range.cloneContents() : range.extractContents();
                }
                else if (_this.draggable) {
                    if (_this.isCopyMode) {
                        var _a = _this.draggable.getAttribute('data-is-file') === "1" ? ['a', 'href'] : ['img', 'src'], tagName = _a[0], attr = _a[1];
                        fragment = _this.jodit.editorDocument.createElement(tagName);
                        fragment.setAttribute(attr, _this.draggable.getAttribute('data-src') || _this.draggable.getAttribute('src') || '');
                        if (tagName === 'a') {
                            fragment.innerText = fragment.getAttribute(attr) || '';
                        }
                    }
                    else {
                        fragment = Helpers_1.dataBind(_this.draggable, 'target');
                    }
                }
                else if (_this.getText(event)) {
                    fragment = Helpers_1.dom(_this.getText(event), _this.jodit.editorDocument);
                }
                sel.removeAllRanges();
                _this.jodit.selection.insertCursorAtPoint(event.clientX, event.clientY);
                if (fragment) {
                    _this.jodit.selection.insertNode(fragment, false, false);
                    if (range && fragment.firstChild && fragment.lastChild) {
                        range.setStartBefore(fragment.firstChild);
                        range.setEndAfter(fragment.lastChild);
                        _this.jodit.selection.selectRange(range);
                        _this.jodit.events.fire('synchro');
                    }
                    if (fragment.nodeName === 'IMG' && _this.jodit.events) {
                        _this.jodit.events.fire('afterInsertImage', fragment);
                    }
                }
                event.preventDefault();
                event.stopPropagation();
            }
            _this.isFragmentFromEditor = false;
        };
        return _this;
    }
    DragAndDrop.prototype.afterInit = function () {
        this.jodit.events
            .on(window, 'dragover', this.onDrag)
            .on([window, this.jodit.editorDocument, this.jodit.editor], 'dragstart', this.onDragStart)
            .on('drop', this.onDrop)
            .on(window, 'dragend drop mouseup', this.onDragEnd);
        // .on('drop', this.onDropImageURLFromFileBrowser)
    };
    DragAndDrop.prototype.beforeDestruct = function () {
        this.onDragEnd();
    };
    return DragAndDrop;
}(Plugin_1.Plugin));
exports.DragAndDrop = DragAndDrop;


/***/ }),
/* 72 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
var Plugin_1 = __webpack_require__(8);
var Dialog_1 = __webpack_require__(7);
var constants_1 = __webpack_require__(2);
var Helpers_1 = __webpack_require__(0);
/**
 * Show dialog choose content to paste
 */
var pasteStorage = /** @class */ (function (_super) {
    __extends(pasteStorage, _super);
    function pasteStorage() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.currentIndex = 0;
        _this.paste = function () {
            _this.jodit.selection.focus();
            _this.jodit.selection.insertHTML(_this.list[_this.currentIndex]);
            if (_this.currentIndex !== 0) {
                var buffer = _this.list[0];
                _this.list[0] = _this.list[_this.currentIndex];
                _this.list[_this.currentIndex] = buffer;
            }
            _this.dialog.close();
            _this.jodit.setEditorValue();
        };
        _this.onKeyDown = function (e) {
            var index = _this.currentIndex;
            if ([constants_1.KEY_UP, constants_1.KEY_DOWN, constants_1.KEY_ENTER].indexOf(e.which) === -1) {
                return;
            }
            if (e.which === constants_1.KEY_UP) {
                if (index === 0) {
                    index = _this.list.length - 1;
                }
                else {
                    index -= 1;
                }
            }
            if (e.which === constants_1.KEY_DOWN) {
                if (index === _this.list.length - 1) {
                    index = 0;
                }
                else {
                    index += 1;
                }
            }
            if (e.which === constants_1.KEY_ENTER) {
                _this.paste();
                return;
            }
            if (index !== _this.currentIndex) {
                _this.selectIndex(index);
            }
            e.stopImmediatePropagation();
            e.preventDefault();
        };
        _this.selectIndex = function (index) {
            [].slice.call(_this.listBox.childNodes).forEach(function (a, i) {
                a.classList.remove('jodit_active');
                if (index === i) {
                    a.classList.add('jodit_active');
                    _this.previewBox.innerHTML = _this.list[index];
                    a.focus();
                }
            });
            _this.currentIndex = index;
        };
        _this.showDialog = function () {
            if (_this.list.length < 2) {
                return;
            }
            _this.dialog || _this.createDialog();
            _this.listBox.innerHTML = '';
            _this.previewBox.innerHTML = '';
            _this.list.forEach(function (html, index) {
                var a = _this.jodit.ownerDocument.createElement('a');
                a.innerText = (index + 1) + '. ' + html.replace(constants_1.SPACE_REG_EXP, '');
                a.addEventListener('keydown', _this.onKeyDown);
                a.setAttribute('href', 'javascript:void(0)');
                a.setAttribute('data-index', index.toString());
                a.setAttribute('tab-index', '-1');
                _this.listBox.appendChild(a);
            });
            _this.dialog.open();
            setTimeout(function () {
                _this.selectIndex(0);
            }, 100);
        };
        _this.list = [];
        return _this;
    }
    pasteStorage.prototype.createDialog = function () {
        var _this = this;
        this.dialog = new Dialog_1.Dialog(this.jodit);
        var pasteButton = Helpers_1.dom('<a href="javascript:void(0)" style="float:right;" class="jodit_button">' +
            '<span>' + this.jodit.i18n('Paste') + '</span>' +
            '</a>', this.jodit.ownerDocument);
        pasteButton.addEventListener('click', this.paste);
        var cancelButton = Helpers_1.dom('<a href="javascript:void(0)" style="float:right; margin-right: 10px;" class="jodit_button">' +
            '<span>' + this.jodit.i18n('Cancel') + '</span>' +
            '</a>', this.jodit.ownerDocument);
        cancelButton.addEventListener('click', this.dialog.close);
        this.container = this.jodit.ownerDocument.createElement('div');
        this.container.classList.add('jodit_paste_storage');
        this.listBox = this.jodit.ownerDocument.createElement('div');
        this.previewBox = this.jodit.ownerDocument.createElement('div');
        this.container.appendChild(this.listBox);
        this.container.appendChild(this.previewBox);
        this.dialog.setTitle(this.jodit.i18n('Choose Content to Paste'));
        this.dialog.setContent(this.container);
        this.dialog.setFooter([pasteButton, cancelButton]);
        this.jodit.events
            .on(this.listBox, 'click dblclick', function (e) {
            var a = e.target;
            if (a && a.nodeName === 'A' && a.hasAttribute('data-index')) {
                _this.selectIndex(parseInt(a.getAttribute('data-index') || '0', 10));
            }
            if (e.type === 'dblclick') {
                _this.paste();
            }
            return false;
        }, 'a');
    };
    pasteStorage.prototype.afterInit = function () {
        var _this = this;
        this.jodit.events.on('afterCopy', function (html) {
            if (_this.list.indexOf(html) !== -1) {
                _this.list.splice(_this.list.indexOf(html), 1);
            }
            _this.list.unshift(html);
            if (_this.list.length > 5) {
                _this.list.length = 5;
            }
        });
        this.jodit.registerCommand('showPasteStorage', {
            exec: this.showDialog,
            hotkeys: 'ctrl+shift+v'
        });
    };
    return pasteStorage;
}(Plugin_1.Plugin));
exports.pasteStorage = pasteStorage;


/***/ }),
/* 73 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/*!
 * Jodit Editor (https://xdsoft.net/jodit/)
 * License https://xdsoft.net/jodit/license.html
 * Copyright 2013-2018 Valeriy Chupurnov https://xdsoft.net
 */
Object.defineProperty(exports, "__esModule", { value: true });
var de_1 = __webpack_require__(74);
exports.de = de_1.default;
var en_1 = __webpack_require__(75);
exports.en = en_1.default;
var fr_1 = __webpack_require__(76);
exports.fr = fr_1.default;
var ru_1 = __webpack_require__(77);
exports.ru = ru_1.default;
var ar_1 = __webpack_require__(78);
exports.ar = ar_1.default;


/***/ }),
/* 74 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.default = {
    'Type something': 'Bitte geben Sie einen Text ein',
    // About
    'Advanced': 'Fortgeschritten',
    'About Jodit': 'Über Jodit',
    'Jodit Editor': 'Jodit Editor',
    'Free Non-commercial Version': 'Freie Nicht-kommerzielle Version',
    'GNU General Public License, version 2 or later': 'GNU General Public License, Version 2 oder höher',
    'Jodit User\'s Guide': 'Das Jodit Benutzerhandbuch',
    'contains detailed help for using': 'beinhaltet ausführliche Informationen wie Sie den Editor verwenden können.',
    'For information about the license, please go to our website:': 'Für Lizenz-Informationen, besuchen Sie bitte unsere Webseite:',
    'Buy full version': 'Vollversion kaufen',
    'Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.': 'Copyright © XDSoft.net - Chupurnov Valeriy. Alle Rechte vorbehalten.',
    // Toolbar
    'Anchor': 'Anker',
    'Open in new tab': 'In neuer Registerkarte öffnen',
    'Open editor in fullsize': 'Editor in voller Größe öffnen',
    'Clear Formatting': 'Formatierung löschen',
    'Fill color or set the text color': 'Füllfarbe oder Textfarbe ändern',
    'Redo': 'Wiederholen',
    'Undo': 'Rückgängig machen',
    'Bold': 'Fett',
    'Italic': 'Kursiv',
    'Insert Unordered List': 'Ungeordnete Liste einfügen',
    'Insert Ordered List': 'Sortierte Liste einfügen',
    'Align Center': 'Mittig ausrichten',
    'Align Justify': 'Blocksatz',
    'Align Left': 'Links ausrichten',
    'Align Right': 'Rechts ausrichten',
    'Insert Horizontal Line': 'Horizontale Linie einfügen',
    'Insert Image': 'Bild einfügen',
    'Insert file': 'Datei einfügen',
    'Insert youtube/vimeo video': 'Youtube/vimeo Video einfügen',
    'Insert link': 'Link einfügen',
    'Font size': 'Schriftgröße',
    'Font family': 'Schriftfamilie',
    'Insert format block': 'Formatblock einfügen',
    'Normal': 'Normal',
    'Heading 1': 'Überschrift 1',
    'Heading 2': 'Überschrift 2',
    'Heading 3': 'Überschrift 3',
    'Heading 4': 'Überschrift 4',
    'Quote': 'Zitat',
    'Code': 'Code',
    'Insert': 'Einfügen',
    'Insert table': 'Tabelle einfügen',
    'Decrease Indent': 'Einzug verkleinern',
    'Increase Indent': 'Einzug vergrößern',
    'Select Special Character': 'Sonderzeichen auswählen',
    'Insert Special Character': 'Sonderzeichen einfügen',
    'Paint format': 'Format kopieren',
    'Change mode': 'Änderungsmodus',
    //plugin Image
    'Margins': 'Ränder',
    'top': 'Oben',
    'right': 'Rechts',
    'bottom': 'Unten',
    'left': 'Links',
    'Styles': 'CSS Stiel',
    'Classes': 'CSS Klassen',
    'Align': 'Ausrichten',
    'Right': 'Rechts',
    'Center': 'Zentriert',
    'Left': 'Links',
    '--Not Set--': 'Keine',
    'Src': 'Pfad',
    'Title': 'Titel',
    'Alternative': 'Alternativer Text',
    'Link': 'Link',
    'Open link in new tab': 'Link in neuem Tab öffnen',
    'Image': 'Bild',
    'file': 'Datei',
    'Advansed': 'Erweitert',
    'Image properties': 'Bildeigenschaften',
    'Cancel': 'Abbrechen',
    'Ok': 'OK',
    //plugin paste
    'Your code is similar to HTML. Keep as HTML?': 'Es scheint als dass Sie HTML-Text einfügen möchten',
    'Paste as HTML': 'Als HTML einfügen?',
    'Keep': 'Original speichern',
    'Clean': 'Säubern',
    'Insert as Text': 'Als Text einfügen',
    'Word Paste Detected': 'InWord formatierter Text erkannt',
    'The pasted content is coming from a Microsoft Word/Excel document. Do you want to keep the format or clean it up?': 'Der Inhalt, den Sie einfügen, stammt aus einem Microsoft Word / Excel-Dokument. Möchten Sie das Format erhalten oder löschen?',
    'Insert only Text': 'Als Text einfügen',
    // File Browser module
    'File Browser': 'Dateibrowser',
    'Error on load list': 'Fehler beim Laden der Liste',
    'Error on load folders': 'Fehler beim Laden der Ordner',
    'Are you shure?': 'Sind Sie sicher?',
    'Enter Directory name': 'Geben Sie den Verzeichnisnamen ein',
    'Create directory': 'Verzeichnis erstellen',
    'type name': 'Typname',
    // Form module
    'Drop image': 'Bild hier hinziehen',
    'Drop file': 'Datei löschen',
    'or click': 'oder hier klicken',
    'Alternative text': 'Alternativtext',
    'Browse': 'Auswählen',
    'Upload': 'Hochladen',
    'Background': 'Hintergrund',
    'Text': 'Text',
    // popap module
    'Top': 'Oben',
    'Middle': 'Mittig',
    'Bottom': 'Unten',
    'Insert column before': 'Spalte einfügen vor',
    'Insert column after': 'Spalte einfügen nach',
    'Insert row above': 'Zeile einfügen oberhalb',
    'Insert row below': 'Zeile unterhalb einfügen',
    'Delete table': 'Tabelle löschen',
    'Delete row': 'Zeile löschen',
    'Delete column': 'Spalte löschen',
    'Empty cell': 'Leere Zelle',
    'Delete': 'Löschen',
    'Strike through': 'Durchschlagen',
    'Underline': 'Unterstreichen',
    'Break': 'Pause',
    'Search for': 'Suche nach',
    'Replace with': 'Ersetzen durch',
    'Replace': 'Ersetzen',
    'Edit': 'Bearbeiten',
    'Vertical align': 'Vertikale Ausrichtung',
    'Horizontal align': 'Horizontale Ausrichtung',
    'Filter': 'filter',
    'Sort by changed': 'Sortieren nach geändert',
    'Sort by name': 'Nach Name sortieren',
    'Sort by size': 'Nach Größe sortiert',
    'Add folder': 'Ordner hinzufügen',
    'Split vertical': 'Split vertikal',
    'Split horizontal': 'Split horizontally',
    'Merge': 'Verschmelzen',
    'Add column': 'Spalte hinzufügen',
    'Add row': 'Zeile hinzufügen',
    'Border': 'Rand',
    'Embed code': 'Code einbetten',
    'Update': 'Aktualisieren',
    'superscript': 'hochgestellt',
    'subscript': 'Index',
    'Cut selection': 'Auswahl ausschneid',
    'Paste': 'Einfügen',
    'Choose Content to Paste': 'Wählen Sie Inhalt zum Einfügen',
    // stat
    'Chars: %d': 'Zeichen: %d',
    'Words: %d': 'Wörter: %d',
    'All': 'Wählen Sie Alle aus',
    'Select %s': 'Markieren: %s',
    'Select all': 'Wählen Sie Alle aus',
    'source': 'HTML',
    'bold': 'Fett gedruckt',
    'italic': 'kursiv',
    'brush': 'Bürste',
    'link': 'Verknüpfung',
    'undo': 'rückgängig machen',
    'redo': 'wiederholen',
    'table': 'Tabelle',
    'image': 'Bild',
    'eraser': 'Radiergummi',
    'paragraph': 'Absatz',
    'fontsize': 'Schriftgröße',
    'video': 'Video',
    'font': 'Schriftart',
    'about': 'Über',
    'print': 'drucken',
    'symbol': 'Symbol',
    'underline': 'unterstreichen',
    'strikethrough': 'durchgestrichen',
    'indent': 'Einzug',
    'outdent': 'Aussenseiter',
    'fullsize': 'Vollgröße',
    'shrink': 'schrumpfen',
    'copyformat': 'Format kopierenт',
    'hr': 'die Linie',
    'ul': 'Liste von',
    'ol': 'Nummerierte Liste',
    'cut': 'Schnitt',
    'selectall': 'Wählen Sie Alle aus',
    'Open link': 'Link öffnen',
    'Edit link': 'Link bearbeiten',
    'No follow': 'Nofollow-Attribut',
    'Unlink': 'Link entfernen',
    ' URL': 'URL',
    'Reset': 'Wiederherstellen',
    'Save': 'Speichern',
    'Save as ...': 'Speichern als',
    'Resize': 'Ändern Sie die Größe',
    'Crop': 'Größe anpassen',
    'Width': 'Breite',
    'Height': 'Höhe',
    'Keep Aspect Ratio': 'Halten Sie Proportionen',
    'Yes': 'Ja',
    'No': 'Nein',
    'Remove': 'Entfernen',
    'Select': 'Markieren',
    'You can only edit your own images. Download this image on the host?': 'Sie können nur Ihre eigenen Bilder bearbeiten. Laden Sie dieses Bild auf dem Host herunter?',
    'The image has been successfully uploaded to the host!': 'Das Bild wurde erfolgreich auf den Server hochgeladen!null',
};


/***/ }),
/* 75 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.default = {
    'Type something': 'Start writing...',
};


/***/ }),
/* 76 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.default = {
    'Type something': 'Ecrivez ici',
    // About
    'About Jodit': 'A propos de Jodit',
    'Jodit Editor': 'Editeur Jodit',
    'Free Non-commercial Version': 'Version gratuite, non commerciale',
    'GNU General Public License, version 2 or later': 'GNU General Public License, version 2 ou ultérieure',
    'Jodit User\'s Guide': 'Guide de l\'utilisateur',
    'contains detailed help for using': 'Aide détaillée à l\'utilisation',
    'For information about the license, please go to our website:': 'Consulter la licence sur notre site web:',
    'Buy full version': 'Acheter la version complète',
    'Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.': 'Copyright © XDSoft.net - Chupurnov Valeriy. Tous droits réservés.',
    // Toolbar
    'Anchor': 'Ancre',
    'Open in new tab': 'Ouvrir dans un nouvel onglet',
    'Open editor in fullsize': 'Ouvrir l\'éditeur en pleine page',
    'Clear Formatting': 'Supprimer le formattage',
    'Fill color or set the text color': 'Modifier la couleur du fond ou du texte',
    'Redo': 'Refaire',
    'Undo': 'Défaire',
    'Bold': 'Gras',
    'Italic': 'Italique',
    'Insert Unordered List': 'Liste non ordonnée',
    'Insert Ordered List': 'Liste ordonnée',
    'Align Center': 'Centrer',
    'Align Justify': 'Justifier',
    'Align Left': 'Aligner à gauche ',
    'Align Right': 'Aligner à droite',
    'Insert Horizontal Line': 'Insérer une ligne horizontale',
    'Insert Image': 'Insérer une image',
    'Insert file': 'Insérer un fichier',
    'Insert youtube/vimeo video': 'Insérer une vidéo',
    'Insert link': 'Insérer un lien',
    'Font size': 'Taille des caractères',
    'Font family': 'Famille des caractères',
    'Insert format block': 'Bloc formatté',
    'Normal': 'Normal',
    'Heading 1': 'Titre 1',
    'Heading 2': 'Titre 2',
    'Heading 3': 'Titre 3',
    'Heading 4': 'Titre 4',
    'Quote': 'Citation',
    'Code': 'Code',
    'Insert': 'Insérer',
    'Insert table': 'Insérer un tableau',
    'Decrease Indent': 'Diminuer le retrait',
    'Increase Indent': 'Retrait plus',
    'Select Special Character': 'Sélectionnez un caractère spécial',
    'Insert Special Character': 'Insérer un caractère spécial',
    'Paint format': 'Cloner le format',
    'Change mode': 'Mode wysiwyg <-> code html',
    //plugin Image
    'Margins': 'Marges',
    'top': 'haut',
    'right': 'droite',
    'bottom': 'Bas',
    'left': 'gauche',
    'Styles': 'Styles',
    'Classes': 'Classes',
    'Align': 'Alignement',
    'Right': 'Droite',
    'Center': 'Centre',
    'Left': 'Gauche',
    '--Not Set--': '--Non disponible--',
    'Src': 'Source',
    'Title': 'Titre',
    'Alternative': 'Alternative',
    'Filter': 'Filtre',
    'Link': 'Lien',
    'Open link in new tab': 'Ouvrir le lien dans un nouvel onglet',
    'Image': 'Image',
    'file': 'fichier',
    'Advanced': 'Avancé',
    'Image properties': 'Propriétés de l\'image',
    'Cancel': 'Effacer',
    'Ok': 'OK',
    //plugin paste
    'Your code is similar to HTML. Keep as HTML?': 'Votre texte que vous essayez de coller est similaire au HTML. Collez-le en HTML?',
    'Paste as HTML': 'Coller en HTML?',
    'Keep': 'Sauvegarder l\'original',
    'Clean': 'Nettoyer',
    'Insert as Text': 'Coller en tant que texte',
    'Word Paste Detected': 'C\'est peut-être un fragment de Word ou Excel',
    'The pasted content is coming from a Microsoft Word/Excel document. Do you want to keep the format or clean it up?': 'Le contenu que vous insérez provient d\'un document Microsoft Word / Excel. Voulez-vous enregistrer le format ou l\'effacer?',
    'Insert only Text': 'Coller le texte seulement',
    // File Browser module
    'File Browser': 'Explorateur de fichiers',
    'Error on load list': 'Erreur de liste de chargement',
    'Error on load folders': 'Erreur de dossier de chargement',
    'Are you shure?': 'Etes-vous sûrs ?',
    'Enter Directory name': 'Entrer le non de dossier',
    'Create directory': 'Créer un dossier',
    'type name': 'type de fichier',
    // Form module
    'Drop image': 'Coller une image',
    'Drop file': 'Déposer un fichier',
    'or click': 'ou cliquer',
    'Alternative text': 'Texte de remplacemement',
    'Browse': 'Chercher',
    'Upload': 'Charger',
    'Background': 'Arrière-plan',
    'Text': 'Texte',
    // popap module
    'Top': 'Haut',
    'Middle': 'Milieu',
    'Bottom': 'Bas',
    'Insert column before': 'Insérer une colonne avant',
    'Insert column after': 'Insérer une colonne après',
    'Insert row above': 'Insérer une ligne en dessus',
    'Insert row below': 'Insérer une ligne en dessous',
    'Delete table': 'Supprimer le tableau',
    'Delete row': 'Supprimer la ligne',
    'Delete column': 'Supprimer la colonne',
    'Empty cell': 'Vider la cellule',
    // stat
    'Chars: %d': 'Symboles: %d',
    'Words: %d': 'Mots: %d',
    'Strike through': 'Frapper à travers',
    'Underline': 'Souligner',
    'superscript': 'exposant',
    'subscript': 'indice',
    'Cut selection': 'Couper la sélection',
    'Select all': 'Tout sélectionner',
    'Break': 'Pause',
    'Search for': 'Rechercher',
    'Replace with': 'Remplacer par',
    'Replace': 'Remplacer',
    'Paste': 'Coller',
    'Choose Content to Paste': 'Choisissez le contenu à coller',
    'source': 'la source',
    'bold': 'graisseux',
    'italic': 'italique',
    'brush': 'verser',
    'link': 'lien',
    'undo': 'abolir',
    'redo': 'prêt',
    'table': 'graphique',
    'image': 'Image',
    'eraser': 'la gommen',
    'paragraph': 'clause',
    'fontsize': 'taille de police',
    'video': 'Video',
    'font': 'police',
    'about': 'à propos de l\'éditeur',
    'print': 'impression',
    'symbol': 'caractère',
    'underline': 'souligné',
    'strikethrough': 'barré',
    'indent': 'indentation',
    'outdent': 'indifférent',
    'fullsize': 'taille réelle',
    'shrink': 'taille conventionnelle',
    'copyformat': 'Format de copie',
    'hr': 'la ligne',
    'ul': 'Liste des',
    'ol': 'Liste numérotée',
    'cut': 'Couper',
    'selectall': 'Sélectionner tout',
    'Open link': 'Ouvrir le lien',
    'Edit link': 'Modifier le lien',
    'No follow': 'Attribut Nofollow',
    'Unlink': 'Supprimer le lien',
    ' URL': 'URL',
    'Reset': 'Restaurer',
    'Save': 'Sauvegarder',
    'Save as ...': 'Enregistrer sous',
    'Resize': 'Changer la taille',
    'Crop': 'Taille de garniture',
    'Width': 'Largeur',
    'Height': 'Hauteur',
    'Keep Aspect Ratio': 'Garder les proportions',
    'Yes': 'Oui',
    'No': 'Non',
    'Remove': 'Supprimer',
    'Select': 'Mettre en évidence',
    'Select %s': 'Mettre en évidence: %s',
    'Update': 'Mettre à jour',
    'Vertical align': 'Alignement vertical',
    'Merge': 'aller',
    'Add column': 'Ajouter une colonne',
    'Add row': 'Ajouter une rangée',
    'Delete': 'Effacer',
    'Horizontal align': 'Alignement horizontal',
    'Sort by changed': 'Trier par modifié',
    'Sort by name': 'Trier par nom',
    'Sort by size': 'Classer par taille',
    'Add folder': 'Ajouter le dossier',
    'You can only edit your own images. Download this image on the host?': 'Vous ne pouvez éditer que vos propres images. Téléchargez cette image sur l\'hôte?',
    'The image has been successfully uploaded to the host!': 'L\'image a été téléchargée avec succès sur le serveur!null',
};


/***/ }),
/* 77 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.default = {
    'Type something': 'Напишите что-либо',
    // About
    'About Jodit': 'О Jodit',
    'Jodit Editor': 'Редактор Jodit',
    'Free Non-commercial Version': 'Версия для не коммерческого использования',
    'GNU General Public License, version 2 or later': 'Стандартная общественная лицензия GNU (GPL), версия 2 или выше',
    'Jodit User\'s Guide': 'Jodit Руководство пользователя',
    'contains detailed help for using': 'содержит детальную информацию по использованию',
    'For information about the license, please go to our website:': 'Для получения сведений о лицензии , пожалуйста, перейдите на наш сайт:',
    'Buy full version': 'Купить полную версию',
    'Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.': 'Авторские права © XDSoft.net - Чупурнов Валерий. Все права защищены.',
    // Toolbar
    'Anchor': 'Анкор',
    'Open in new tab': 'Открывать ссылку в новой вкладке',
    'Open editor in fullsize': 'Открыть редактор в полном размере',
    'Clear Formatting': 'Очистить форматирование',
    'Fill color or set the text color': 'Цвет заливки или цвет текста',
    'Redo': 'Повтор',
    'Undo': 'Отмена',
    'Bold': 'Жирный',
    'Italic': 'Наклонный',
    'Insert Unordered List': 'Вставка маркированного списка',
    'Insert Ordered List': 'Вставить нумерованный список',
    'Align Center': 'Выровнять по центру',
    'Align Justify': 'Выровнять по ширине',
    'Align Left': 'Выровнять по левому краю',
    'Align Right': 'Выровнять по правому краю',
    'Insert Horizontal Line': 'Вставить горизонтальную линию',
    'Insert Image': 'Вставить изображение',
    'Insert file': 'Вставить файл',
    'Insert youtube/vimeo video': 'Вставьте видео',
    'Insert link': 'Вставить ссылку',
    'Font size': 'Размер шрифта',
    'Font family': 'Шрифт',
    'Insert format block': 'Вставить блочный элемент',
    'Normal': 'Нормальный текст',
    'Heading 1': 'Заголовок 1',
    'Heading 2': 'Заголовок 2',
    'Heading 3': 'Заголовок 3',
    'Heading 4': 'Заголовок 4',
    'Quote': 'Цитата',
    'Code': 'Код',
    'Insert': 'Вставить',
    'Insert table': 'Вставить таблицу',
    'Decrease Indent': 'Уменьшить отступ',
    'Increase Indent': 'Увеличить отступ',
    'Select Special Character': 'Выберите специальный символ',
    'Insert Special Character': 'Вставить специальный символ',
    'Paint format': 'Формат краски',
    'Change mode': 'Источник',
    //plugin Image
    'Margins': 'Отступы',
    'top': 'сверху',
    'right': 'справа',
    'bottom': 'снизу',
    'left': 'слева',
    'Styles': 'Стили',
    'Classes': 'Классы',
    'Align': 'Выравнивание',
    'Right': 'По правому краю',
    'Center': 'По центру',
    'Left': 'По левому краю',
    '--Not Set--': '--не устанавливать--',
    'Src': 'src',
    'Title': 'Заголовок',
    'Alternative': 'Альтернативный текст (alt)',
    'Link': 'Ссылка',
    'Open link in new tab': 'Открывать ссылку в новом окне',
    'Image': 'Изображение',
    'file': 'Файл',
    'Advanced': 'Расширенные',
    'Image properties': 'Свойства изображения',
    'Cancel': 'Отмена',
    'Ok': 'Ок',
    //plugin paste
    'Your code is similar to HTML. Keep as HTML?': 'Ваш текст, который вы пытаетесь вставить похож на HTML. Вставить его как HTML?',
    'Paste as HTML': 'Вставить как HTML?',
    'Keep': 'Сохранить оригинал',
    'Clean': 'Почистить',
    'Insert as Text': 'Вставить как текст',
    'Insert only Text': 'Вставить только текст',
    'Word Paste Detected': 'Возможно это фрагмент Word или Excel',
    'The pasted content is coming from a Microsoft Word/Excel document. Do you want to keep the format or clean it up?': 'Контент который вы вставляете поступает из документа Microsoft Word / Excel. Вы хотите сохранить формат или очистить его?',
    // File Browser module
    'File Browser': 'Браузер файлов',
    'Error on load list': 'Ошибка при загрузке списка изображений',
    'Error on load folders': 'Ошибка при загрузке списка директорий',
    'Are you shure?': 'Вы уверены?',
    'Enter Directory name': 'Введите название директории',
    'Create directory': 'Создать директорию',
    'type name': 'введите название',
    // Form module
    'Drop image': 'Перетащите сюда изображение',
    'Drop file': 'Перетащите сюда файл',
    'or click': 'или нажмите',
    'Alternative text': 'Альтернативный текст',
    'Browse': 'Сервер',
    'Upload': 'Загрузка',
    'Background': 'Фон',
    'Text': 'Текст',
    // popap module
    'Top': ' К верху',
    'Middle': 'По середине',
    'Bottom': 'К низу',
    'Insert column before': 'Вставить столбец до',
    'Insert column after': 'Вставить столбец после',
    'Insert row above': 'Вставить ряд выше',
    'Insert row below': 'Вставить ряд ниже',
    'Delete table': 'Удалить таблицу',
    'Delete row': 'Удалять ряд',
    'Delete column': 'Удалить столбец',
    'Empty cell': 'Отчистить ячейку',
    'source': 'HTML',
    'bold': 'жирный',
    'italic': 'курсив',
    'brush': 'заливка',
    'link': 'ссылка',
    'undo': 'отменить',
    'redo': 'повторить',
    'table': 'таблица',
    'image': 'изображение',
    'eraser': 'очистить',
    'paragraph': 'параграф',
    'fontsize': 'размер шрифта',
    'video': 'видео',
    'font': 'шрифт',
    'about': 'о редакторе',
    'print': 'печать',
    'symbol': 'символ',
    'underline': 'подчеркнутый',
    'strikethrough': 'перечеркнутый',
    'indent': 'отступ',
    'outdent': 'выступ',
    'fullsize': 'во весь экран',
    'shrink': 'обычный размер',
    'copyformat': 'Копировать формат',
    'hr': 'линия',
    'ul': 'Список',
    'ol': 'Нумерованный список',
    'cut': 'Вырезать',
    'selectall': 'Выделить все',
    'Embed code': 'Код',
    'Open link': 'Открыть ссылку',
    'Edit link': 'Редактировать ссылку',
    'No follow': 'Атрибут nofollow',
    'Unlink': 'Убрать ссылку',
    'Update': 'Обновить',
    ' URL': 'URL',
    'Edit': 'Редактировать',
    'Horizontal align': 'Горизонтальное выравнивание',
    'Filter': 'Фильтр',
    'Sort by changed': 'По изменению',
    'Sort by name': 'По имени',
    'Sort by size': 'По размеру',
    'Add folder': 'Добавить папку',
    'Reset': 'Восстановить',
    'Save': 'Сохранить',
    'Save as ...': 'Сохранить как',
    'Resize': 'Изменить размер',
    'Crop': 'Обрезать размер',
    'Width': 'Ширина',
    'Height': 'Высота',
    'Keep Aspect Ratio': 'Сохранять пропорции',
    'Yes': 'Да',
    'No': 'Нет',
    'Remove': 'Удалить',
    'Select': 'Выделить',
    // stat
    'Chars: %d': 'Символов: %d',
    'Words: %d': 'Слов: %d',
    'All': 'Выделить все',
    'Select %s': 'Выделить: %s',
    'Select all': 'Выделить все',
    'Vertical align': 'Вертикальное выравнивание',
    'Split': 'Разделить',
    'Split vertical': 'Разделить по вертикали',
    'Split horizontal': 'Разделить по горизонтали',
    'Merge': 'Объеденить в одну',
    'Add column': 'Добавить столбец',
    'Add row': 'Добавить строку',
    'Delete': 'Удалить',
    'Border': 'Рамка',
    'License: %s': 'Лицензия: %s',
    'Strike through': 'Перечеркнуть',
    'Underline': 'Подчеркивание',
    'superscript': 'верхний индекс',
    'subscript': 'индекс',
    'Cut selection': 'Вырезать',
    'Break': 'Разделитель',
    'Search for': 'Найти',
    'Replace with': 'Заменить на',
    'Replace': 'Заменить',
    'Paste': 'Вставить',
    'Choose Content to Paste': 'Выбрать контент для вставки',
    'You can only edit your own images. Download this image on the host?': 'Вы можете редактировать только свои собственные изображения. Загрузить это изображение на ваш сервер?',
    'The image has been successfully uploaded to the host!': 'Изображение успешно загружено на сервер!',
};


/***/ }),
/* 78 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.default = {
    'Type something': 'إبدأ في الكتابة...',
    // About
    'About Jodit': 'حول جوديت',
    'Jodit Editor': 'محرر جوديت',
    'Free Non-commercial Version': 'الإصدار الغير تجاري مجاني',
    'GNU General Public License, version 2 or later': 'رخصة جنو العمومية العامة ، الإصدار الثاني أو الأحدث',
    'Jodit User\'s Guide': 'دليل مستخدم جوديت',
    'contains detailed help for using': 'يحتوي على مساعدة مفصلة للاستخدام',
    'For information about the license, please go to our website:': 'للحصول على معلومات حول الترخيص، يرجى الذهاب لموقعنا:',
    'Buy full version': 'شراء النسخة الكاملة',
    'Copyright © XDSoft.net - Chupurnov Valeriy. All rights reserved.': 'حقوق الطبع والنشر © XDSoft.net - Chupurnov Valeriy. كل الحقوق محفوظة.',
    // Toolbar
    'Anchor': 'مِرْساة',
    'Open in new tab': 'فتح في نافذة جديدة',
    'Open editor in fullsize': 'فتح المحرر في الحجم الكامل',
    'Clear Formatting': 'مسح التنسيق',
    'Fill color or set the text color': 'ملء اللون أو تعيين لون النص',
    'Redo': 'إعادة',
    'Undo': 'تراجع',
    'Bold': 'عريض',
    'Italic': 'مائل',
    'Insert Unordered List': 'إدراج قائمة غير مرتبة',
    'Insert Ordered List': 'إدراج قائمة مرتبة',
    'Align Center': 'محاذاة للوسط',
    'Align Justify': 'محاذاة مثبتة',
    'Align Left': 'محاذاة لليسار',
    'Align Right': 'محاذاة لليمين',
    'Insert Horizontal Line': 'إدراج خط أفقي',
    'Insert Image': 'إدراج صورة',
    'Insert file': 'ادخال الملف',
    'Insert youtube/vimeo video': 'إدراج فيديو يوتيوب/فيميو ',
    'Insert link': 'إدراج رابط',
    'Font size': 'حجم الخط',
    'Font family': 'نوع الخط',
    'Insert format block': 'إدراج كتلة تنسيق',
    'Normal': 'عادي',
    'Heading 1': 'عنوان 1',
    'Heading 2': 'عنوان 2',
    'Heading 3': 'عنوان 3',
    'Heading 4': 'عنوان 4',
    'Quote': 'إقتباس',
    'Code': 'كود',
    'Insert': 'إدراج',
    'Insert table': 'إدراج جدول',
    'Decrease Indent': 'تقليل المسافة البادئة',
    'Increase Indent': 'زيادة المسافة البادئة',
    'Select Special Character': 'تحديد أحرف خاصة',
    'Insert Special Character': 'إدراج حرف خاص',
    'Paint format': 'تنسيق الرسم',
    'Change mode': 'تغيير الوضع',
    //plugin Image
    'Margins': 'هوامش',
    'top': 'أعلى',
    'right': 'يمين',
    'bottom': 'أسفل',
    'left': 'يسار',
    'Styles': 'الأنماط',
    'Classes': 'الطبقات',
    'Align': 'محاذاة',
    'Right': 'اليمين',
    'Center': 'الوسط',
    'Left': 'اليسار',
    '--Not Set--': '--غير مضبوط--',
    'Src': 'Src',
    'Title': 'العنوان',
    'Alternative': 'العنوان البديل',
    'Link': 'الرابط',
    'Open link in new tab': 'افتح الرابط في نافذة جديدة',
    'Image': 'الصورة',
    'file': 'ملف',
    'Advanced': 'متقدم',
    'Image properties': 'خصائص الصورة',
    'Cancel': 'إلغاء',
    'Ok': 'حسنا',
    // File Browser module
    'File Browser': 'متصفح الملفات',
    'Error on load list': 'حدث خطأ في تحميل القائمة ',
    'Error on load folders': 'حدث خطأ في تحميل المجلدات',
    'Are you shure?': 'هل أنت واثق؟',
    'Enter Directory name': 'أدخل اسم المجلد',
    'Create directory': 'إنشاء مجلد',
    'type name': 'أكتب إسم',
    // Form module
    'Drop image': 'إسقاط صورة',
    'Drop file': 'إسقاط الملف',
    'or click': 'أو أنقر',
    'Alternative text': 'النص البديل',
    'Upload': 'رفع',
    'Browse': 'تصفح',
    'Background': 'الخلفية',
    'Text': 'نص',
    // popap module
    'Top': 'أعلى',
    'Middle': 'الوسط',
    'Bottom': 'الأسفل',
    'Insert column before': 'إدراج عمود قبل',
    'Insert column after': 'إدراج عمود بعد',
    'Insert row above': 'إدراج صف أعلى',
    'Insert row below': 'إدراج صف أسفل',
    'Delete table': 'حذف الجدول',
    'Delete row': 'حذف الصف',
    'Delete column': 'حذف العمود',
    'Empty cell': 'خلية فارغة',
    // stat
    'Chars: %d': '%d حرف',
    'Words: %d': '%d كلام',
    'Strike through': 'اضرب من خلال',
    'Underline': 'أكد',
    'superscript': 'حرف فوقي',
    'subscript': 'مخطوطة',
    'Cut selection': 'قطع الاختيار',
    'Select all': 'اختر الكل',
    'Break': 'استراحة',
    'Search for': 'البحث عن',
    'Replace with': 'استبدل ب',
    'Replace': 'يحل محل',
    'Paste': 'معجون',
    'Choose Content to Paste': 'اختر محتوى للصق',
    'source': 'مصدر',
    'bold': 'بالخط العريض',
    'italic': 'مائل',
    'brush': 'شغل',
    'link': 'صلة',
    'undo': 'إلغاء',
    'redo': 'كرر',
    'table': 'طاولة',
    'image': 'صورة',
    'eraser': 'نظيف',
    'paragraph': 'فقرة',
    'fontsize': 'حجم الخط',
    'video': 'فيديو',
    'font': 'الخط',
    'about': 'حول المحرر',
    'print': 'طباعة',
    'symbol': 'رمز',
    'underline': 'أكد',
    'strikethrough': 'شطب',
    'indent': 'المسافة البادئة',
    'outdent': 'نتوء',
    'fullsize': 'ملء الشاشة',
    'shrink': 'الحجم التقليدي',
    'copyformat': 'نسخ التنسيق',
    'hr': 'الخط',
    'ul': 'قائمة',
    'ol': 'قائمة مرقمة',
    'cut': 'قطع',
    'selectall': 'اختر الكل',
    'Embed code': 'قانون',
    'Open link': 'فتح الرابط',
    'Edit link': 'تعديل الرابط',
    'No follow': 'سمة Nofollow',
    'Unlink': 'إزالة الرابط',
    'Update': 'تحديث',
    ' URL': 'URL',
    'Edit': 'تحرير',
    'Horizontal align': 'محاذاة أفقية',
    'Filter': 'فلتر',
    'Sort by changed': 'عن طريق التغيير',
    'Sort by name': 'بالاسم',
    'Sort by size': 'حسب الحجم',
    'Add folder': 'إضافة مجلد',
    'Reset': 'إعادة',
    'Save': 'احتفظ',
    'Save as ...': 'حفظ باسم',
    'Resize': 'تغيير الحجم',
    'Crop': 'حجم القطع',
    'Width': 'عرض',
    'Height': 'ارتفاع',
    'Keep Aspect Ratio': 'حافظ على النسب',
    'Yes': 'أن',
    'No': 'لا',
    'Remove': 'حذف',
    'Select': 'تميز',
    'Select %s': 'تميز %s',
    'Vertical align': 'محاذاة عمودية',
    'Split': 'انشق، مزق',
    'Merge': 'اذهب',
    'Add column': 'أضف العمود',
    'Add row': 'اضف سطر',
    'License: %s': 'رخصة %s',
    'Delete': 'حذف',
    'Split vertical': 'انقسام عمودي',
    'Split horizontal': 'تقسيم أفقي',
    'Border': 'الحدود',
    'Your code is similar to HTML. Keep as HTML?': 'يشبه الكود الخاص بك HTML. تبقي كما HTML؟',
    'Paste as HTML': 'الصق ك HTML',
    'Keep': 'احتفظ',
    'Insert as Text': 'إدراج كنص',
    'Insert only Text': 'إدراج النص فقط',
    'You can only edit your own images. Download this image on the host?': 'يمكنك فقط تحرير صورك الخاصة. تحميل هذه الصورة على المضيف؟',
    'The image has been successfully uploaded to the host!': 'تم تحميل الصورة بنجاح على الخادم!',
};


/***/ }),
/* 79 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var about = __webpack_require__(80);
exports.about = about;
var addcolumn = __webpack_require__(81);
exports.addcolumn = addcolumn;
var addrow = __webpack_require__(82);
exports.addrow = addrow;
var angle_left = __webpack_require__(83);
exports.angle_left = angle_left;
var angle_down = __webpack_require__(84);
exports.angle_down = angle_down;
var angle_right = __webpack_require__(85);
exports.angle_right = angle_right;
var angle_up = __webpack_require__(86);
exports.angle_up = angle_up;
var arrows_alt = __webpack_require__(87);
exports.arrows_alt = arrows_alt;
var arrows_h = __webpack_require__(88);
exports.arrows_h = arrows_h;
var attachment = __webpack_require__(89);
exports.attachment = attachment;
var bin = __webpack_require__(90);
exports.bin = bin;
var dots = __webpack_require__(91);
exports.dots = dots;
var bold = __webpack_require__(92);
exports.bold = bold;
var brush = __webpack_require__(93);
exports.brush = brush;
var cancel = __webpack_require__(94);
exports.cancel = cancel;
var center = __webpack_require__(95);
exports.center = center;
var chain_broken = __webpack_require__(96);
exports.chain_broken = chain_broken;
var check_square = __webpack_require__(97);
exports.check_square = check_square;
var check = __webpack_require__(98);
exports.check = check;
var copyformat = __webpack_require__(99);
exports.copyformat = copyformat;
var crop = __webpack_require__(100);
exports.crop = crop;
var cut = __webpack_require__(101);
exports.cut = cut;
var dedent = __webpack_require__(102);
exports.dedent = dedent;
var enter = __webpack_require__(103);
exports.enter = enter;
var eraser = __webpack_require__(104);
exports.eraser = eraser;
var eye = __webpack_require__(105);
exports.eye = eye;
var file = __webpack_require__(106);
exports.file = file;
var folder = __webpack_require__(107);
exports.folder = folder;
var font = __webpack_require__(108);
exports.font = font;
var fontsize = __webpack_require__(109);
exports.fontsize = fontsize;
var fullsize = __webpack_require__(110);
exports.fullsize = fullsize;
var hr = __webpack_require__(111);
exports.hr = hr;
var image = __webpack_require__(112);
exports.image = image;
var info_circle = __webpack_require__(113);
exports.info_circle = info_circle;
var italic = __webpack_require__(114);
exports.italic = italic;
var justify = __webpack_require__(115);
exports.justify = justify;
var left = __webpack_require__(116);
exports.left = left;
var link = __webpack_require__(117);
exports.link = link;
var lock = __webpack_require__(118);
exports.lock = lock;
var menu = __webpack_require__(119);
exports.menu = menu;
var merge = __webpack_require__(120);
exports.merge = merge;
var ol = __webpack_require__(121);
exports.ol = ol;
var paragraph = __webpack_require__(122);
exports.paragraph = paragraph;
var pencil = __webpack_require__(123);
exports.pencil = pencil;
var plus = __webpack_require__(124);
exports.plus = plus;
var redo = __webpack_require__(125);
exports.redo = redo;
var resize = __webpack_require__(126);
exports.resize = resize;
var resizer = __webpack_require__(127);
exports.resizer = resizer;
var right = __webpack_require__(128);
exports.right = right;
var save = __webpack_require__(129);
exports.save = save;
var select_all = __webpack_require__(130);
exports.select_all = select_all;
var shrink = __webpack_require__(131);
exports.shrink = shrink;
var source = __webpack_require__(132);
exports.source = source;
var splitg = __webpack_require__(133);
exports.splitg = splitg;
var splitv = __webpack_require__(134);
exports.splitv = splitv;
var strikethrough = __webpack_require__(135);
exports.strikethrough = strikethrough;
var subscript = __webpack_require__(136);
exports.subscript = subscript;
var superscript = __webpack_require__(137);
exports.superscript = superscript;
var table = __webpack_require__(138);
exports.table = table;
var th_list = __webpack_require__(139);
exports.th_list = th_list;
var th = __webpack_require__(140);
exports.th = th;
var ul = __webpack_require__(141);
exports.ul = ul;
var underline = __webpack_require__(142);
exports.underline = underline;
var undo = __webpack_require__(143);
exports.undo = undo;
var unlink = __webpack_require__(144);
exports.unlink = unlink;
var unlock = __webpack_require__(145);
exports.unlock = unlock;
var update = __webpack_require__(146);
exports.update = update;
var upload = __webpack_require__(147);
exports.upload = upload;
var valign = __webpack_require__(148);
exports.valign = valign;
var video = __webpack_require__(149);
exports.video = video;
var outdent = __webpack_require__(150);
exports.outdent = outdent;
var indent = __webpack_require__(151);
exports.indent = indent;
var print = __webpack_require__(152);
exports.print = print;
var omega = __webpack_require__(153);
exports.omega = omega;


/***/ }),
/* 80 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1088 1256v240q0 16-12 28t-28 12h-240q-16 0-28-12t-12-28v-240q0-16 12-28t28-12h240q16 0 28 12t12 28zm316-600q0 54-15.5 101t-35 76.5-55 59.5-57.5 43.5-61 35.5q-41 23-68.5 65t-27.5 67q0 17-12 32.5t-28 15.5h-240q-15 0-25.5-18.5t-10.5-37.5v-45q0-83 65-156.5t143-108.5q59-27 84-56t25-76q0-42-46.5-74t-107.5-32q-65 0-108 29-35 25-107 115-13 16-31 16-12 0-25-8l-164-125q-13-10-15.5-25t5.5-28q160-266 464-266 80 0 161 31t146 83 106 127.5 41 158.5z\"></path></svg>"

/***/ }),
/* 81 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 18.151 18.151\"><g><g><path d=\"M6.237,16.546H3.649V1.604h5.916v5.728c0.474-0.122,0.968-0.194,1.479-0.194 c0.042,0,0.083,0.006,0.125,0.006V0H2.044v18.15h5.934C7.295,17.736,6.704,17.19,6.237,16.546z\"></path><path d=\"M11.169,8.275c-2.723,0-4.938,2.215-4.938,4.938s2.215,4.938,4.938,4.938s4.938-2.215,4.938-4.938 S13.892,8.275,11.169,8.275z M11.169,16.81c-1.983,0-3.598-1.612-3.598-3.598c0-1.983,1.614-3.597,3.598-3.597 s3.597,1.613,3.597,3.597C14.766,15.198,13.153,16.81,11.169,16.81z\"></path><polygon points=\"11.792,11.073 10.502,11.073 10.502,12.578 9.03,12.578 9.03,13.868 10.502,13.868 10.502,15.352 11.792,15.352 11.792,13.868 13.309,13.868 13.309,12.578 11.792,12.578 \"></polygon></g></g></svg>"

/***/ }),
/* 82 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 432 432\"><g><g><polygon points=\"203.688,96 0,96 0,144 155.688,144 \"></polygon><polygon points=\"155.719,288 0,288 0,336 203.719,336 \"></polygon><rect x=\"252\" y=\"96\"></rect><rect></rect><rect x=\"252\" y=\"288\"></rect><rect y=\"384\"></rect><path d=\"M97.844,230.125c-3.701-3.703-5.856-8.906-5.856-14.141s2.154-10.438,5.856-14.141l9.844-9.844H0v48h107.719 L97.844,230.125z\"></path><polygon points=\"232,176 232,96 112,216 232,336 232,256 432,256 432,176 \"></polygon></g></g></svg>"

/***/ }),
/* 83 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1203 544q0 13-10 23l-393 393 393 393q10 10 10 23t-10 23l-50 50q-10 10-23 10t-23-10l-466-466q-10-10-10-23t10-23l466-466q10-10 23-10t23 10l50 50q10 10 10 23z\"></path></svg>"

/***/ }),
/* 84 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1395 736q0 13-10 23l-466 466q-10 10-23 10t-23-10l-466-466q-10-10-10-23t10-23l50-50q10-10 23-10t23 10l393 393 393-393q10-10 23-10t23 10l50 50q10 10 10 23z\"></path></svg>"

/***/ }),
/* 85 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1171 960q0 13-10 23l-466 466q-10 10-23 10t-23-10l-50-50q-10-10-10-23t10-23l393-393-393-393q-10-10-10-23t10-23l50-50q10-10 23-10t23 10l466 466q10 10 10 23z\"></path></svg>"

/***/ }),
/* 86 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1395 1184q0 13-10 23l-50 50q-10 10-23 10t-23-10l-393-393-393 393q-10 10-23 10t-23-10l-50-50q-10-10-10-23t10-23l466-466q10-10 23-10t23 10l466 466q10 10 10 23z\"></path></svg>"

/***/ }),
/* 87 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1411 541l-355 355 355 355 144-144q29-31 70-14 39 17 39 59v448q0 26-19 45t-45 19h-448q-42 0-59-40-17-39 14-69l144-144-355-355-355 355 144 144q31 30 14 69-17 40-59 40h-448q-26 0-45-19t-19-45v-448q0-42 40-59 39-17 69 14l144 144 355-355-355-355-144 144q-19 19-45 19-12 0-24-5-40-17-40-59v-448q0-26 19-45t45-19h448q42 0 59 40 17 39-14 69l-144 144 355 355 355-355-144-144q-31-30-14-69 17-40 59-40h448q26 0 45 19t19 45v448q0 42-39 59-13 5-25 5-26 0-45-19z\"></path></svg>"

/***/ }),
/* 88 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1792 896q0 26-19 45l-256 256q-19 19-45 19t-45-19-19-45v-128h-1024v128q0 26-19 45t-45 19-45-19l-256-256q-19-19-19-45t19-45l256-256q19-19 45-19t45 19 19 45v128h1024v-128q0-26 19-45t45-19 45 19l256 256q19 19 19 45z\"></path></svg>"

/***/ }),
/* 89 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1596 1385q0 117-79 196t-196 79q-135 0-235-100l-777-776q-113-115-113-271 0-159 110-270t269-111q158 0 273 113l605 606q10 10 10 22 0 16-30.5 46.5t-46.5 30.5q-13 0-23-10l-606-607q-79-77-181-77-106 0-179 75t-73 181q0 105 76 181l776 777q63 63 145 63 64 0 106-42t42-106q0-82-63-145l-581-581q-26-24-60-24-29 0-48 19t-19 48q0 32 25 59l410 410q10 10 10 22 0 16-31 47t-47 31q-12 0-22-10l-410-410q-63-61-63-149 0-82 57-139t139-57q88 0 149 63l581 581q100 98 100 235z\"></path></svg>"

/***/ }),
/* 90 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M704 1376v-704q0-14-9-23t-23-9h-64q-14 0-23 9t-9 23v704q0 14 9 23t23 9h64q14 0 23-9t9-23zm256 0v-704q0-14-9-23t-23-9h-64q-14 0-23 9t-9 23v704q0 14 9 23t23 9h64q14 0 23-9t9-23zm256 0v-704q0-14-9-23t-23-9h-64q-14 0-23 9t-9 23v704q0 14 9 23t23 9h64q14 0 23-9t9-23zm-544-992h448l-48-117q-7-9-17-11h-317q-10 2-17 11zm928 32v64q0 14-9 23t-23 9h-96v948q0 83-47 143.5t-113 60.5h-832q-66 0-113-58.5t-47-141.5v-952h-96q-14 0-23-9t-9-23v-64q0-14 9-23t23-9h309l70-167q15-37 54-63t79-26h320q40 0 79 26t54 63l70 167h309q14 0 23 9t9 23z\"></path></svg>"

/***/ }),
/* 91 */
/***/ (function(module, exports) {

module.exports = "<svg enable-background=\"new 0 0 24 24\" viewBox=\"0 0 24 24\" xml:space=\"preserve\"><circle cx=\"12\" cy=\"12\" r=\"2.2\"></circle><circle cx=\"12\" cy=\"5\" r=\"2.2\"></circle><circle cx=\"12\" cy=\"19\" r=\"2.2\"></circle></svg>"

/***/ }),
/* 92 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M747 1521q74 32 140 32 376 0 376-335 0-114-41-180-27-44-61.5-74t-67.5-46.5-80.5-25-84-10.5-94.5-2q-73 0-101 10 0 53-.5 159t-.5 158q0 8-1 67.5t-.5 96.5 4.5 83.5 12 66.5zm-14-746q42 7 109 7 82 0 143-13t110-44.5 74.5-89.5 25.5-142q0-70-29-122.5t-79-82-108-43.5-124-14q-50 0-130 13 0 50 4 151t4 152q0 27-.5 80t-.5 79q0 46 1 69zm-541 889l2-94q15-4 85-16t106-27q7-12 12.5-27t8.5-33.5 5.5-32.5 3-37.5.5-34v-65.5q0-982-22-1025-4-8-22-14.5t-44.5-11-49.5-7-48.5-4.5-30.5-3l-4-83q98-2 340-11.5t373-9.5q23 0 68.5.5t67.5.5q70 0 136.5 13t128.5 42 108 71 74 104.5 28 137.5q0 52-16.5 95.5t-39 72-64.5 57.5-73 45-84 40q154 35 256.5 134t102.5 248q0 100-35 179.5t-93.5 130.5-138 85.5-163.5 48.5-176 14q-44 0-132-3t-132-3q-106 0-307 11t-231 12z\"></path></svg>"

/***/ }),
/* 93 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M896 1152q0-36-20-69-1-1-15.5-22.5t-25.5-38-25-44-21-50.5q-4-16-21-16t-21 16q-7 23-21 50.5t-25 44-25.5 38-15.5 22.5q-20 33-20 69 0 53 37.5 90.5t90.5 37.5 90.5-37.5 37.5-90.5zm512-128q0 212-150 362t-362 150-362-150-150-362q0-145 81-275 6-9 62.5-90.5t101-151 99.5-178 83-201.5q9-30 34-47t51-17 51.5 17 33.5 47q28 93 83 201.5t99.5 178 101 151 62.5 90.5q81 127 81 275z\"></path></svg>"

/***/ }),
/* 94 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1490 1322q0 40-28 68l-136 136q-28 28-68 28t-68-28l-294-294-294 294q-28 28-68 28t-68-28l-136-136q-28-28-28-68t28-68l294-294-294-294q-28-28-28-68t28-68l136-136q28-28 68-28t68 28l294 294 294-294q28-28 68-28t68 28l136 136q28 28 28 68t-28 68l-294 294 294 294q28 28 28 68z\"></path></svg>"

/***/ }),
/* 95 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1792 1344v128q0 26-19 45t-45 19h-1664q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1664q26 0 45 19t19 45zm-384-384v128q0 26-19 45t-45 19h-896q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h896q26 0 45 19t19 45zm256-384v128q0 26-19 45t-45 19h-1408q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1408q26 0 45 19t19 45zm-384-384v128q0 26-19 45t-45 19h-640q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h640q26 0 45 19t19 45z\"></path></svg>"

/***/ }),
/* 96 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M503 1271l-256 256q-10 9-23 9-12 0-23-9-9-10-9-23t9-23l256-256q10-9 23-9t23 9q9 10 9 23t-9 23zm169 41v320q0 14-9 23t-23 9-23-9-9-23v-320q0-14 9-23t23-9 23 9 9 23zm-224-224q0 14-9 23t-23 9h-320q-14 0-23-9t-9-23 9-23 23-9h320q14 0 23 9t9 23zm1264 128q0 120-85 203l-147 146q-83 83-203 83-121 0-204-85l-334-335q-21-21-42-56l239-18 273 274q27 27 68 27.5t68-26.5l147-146q28-28 28-67 0-40-28-68l-274-275 18-239q35 21 56 42l336 336q84 86 84 204zm-617-724l-239 18-273-274q-28-28-68-28-39 0-68 27l-147 146q-28 28-28 67 0 40 28 68l274 274-18 240q-35-21-56-42l-336-336q-84-86-84-204 0-120 85-203l147-146q83-83 203-83 121 0 204 85l334 335q21 21 42 56zm633 84q0 14-9 23t-23 9h-320q-14 0-23-9t-9-23 9-23 23-9h320q14 0 23 9t9 23zm-544-544v320q0 14-9 23t-23 9-23-9-9-23v-320q0-14 9-23t23-9 23 9 9 23zm407 151l-256 256q-11 9-23 9t-23-9q-9-10-9-23t9-23l256-256q10-9 23-9t23 9q9 10 9 23t-9 23z\"></path></svg>"

/***/ }),
/* 97 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M813 1299l614-614q19-19 19-45t-19-45l-102-102q-19-19-45-19t-45 19l-467 467-211-211q-19-19-45-19t-45 19l-102 102q-19 19-19 45t19 45l358 358q19 19 45 19t45-19zm851-883v960q0 119-84.5 203.5t-203.5 84.5h-960q-119 0-203.5-84.5t-84.5-203.5v-960q0-119 84.5-203.5t203.5-84.5h960q119 0 203.5 84.5t84.5 203.5z\"></path></svg>"

/***/ }),
/* 98 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1472 930v318q0 119-84.5 203.5t-203.5 84.5h-832q-119 0-203.5-84.5t-84.5-203.5v-832q0-119 84.5-203.5t203.5-84.5h832q63 0 117 25 15 7 18 23 3 17-9 29l-49 49q-10 10-23 10-3 0-9-2-23-6-45-6h-832q-66 0-113 47t-47 113v832q0 66 47 113t113 47h832q66 0 113-47t47-113v-254q0-13 9-22l64-64q10-10 23-10 6 0 12 3 20 8 20 29zm231-489l-814 814q-24 24-57 24t-57-24l-430-430q-24-24-24-57t24-57l110-110q24-24 57-24t57 24l263 263 647-647q24-24 57-24t57 24l110 110q24 24 24 57t-24 57z\"></path></svg>"

/***/ }),
/* 99 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 16 16\"><path d=\"M16 9v-6h-3v-1c0-0.55-0.45-1-1-1h-11c-0.55 0-1 0.45-1 1v3c0 0.55 0.45 1 1 1h11c0.55 0 1-0.45 1-1v-1h2v4h-9v2h-0.5c-0.276 0-0.5 0.224-0.5 0.5v5c0 0.276 0.224 0.5 0.5 0.5h2c0.276 0 0.5-0.224 0.5-0.5v-5c0-0.276-0.224-0.5-0.5-0.5h-0.5v-1h9zM12 3h-11v-1h11v1z\"></path></svg>"

/***/ }),
/* 100 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M621 1280h595v-595zm-45-45l595-595h-595v595zm1152 77v192q0 14-9 23t-23 9h-224v224q0 14-9 23t-23 9h-192q-14 0-23-9t-9-23v-224h-864q-14 0-23-9t-9-23v-864h-224q-14 0-23-9t-9-23v-192q0-14 9-23t23-9h224v-224q0-14 9-23t23-9h192q14 0 23 9t9 23v224h851l246-247q10-9 23-9t23 9q9 10 9 23t-9 23l-247 246v851h224q14 0 23 9t9 23z\"></path></svg>"

/***/ }),
/* 101 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M960 896q26 0 45 19t19 45-19 45-45 19-45-19-19-45 19-45 45-19zm300 64l507 398q28 20 25 56-5 35-35 51l-128 64q-13 7-29 7-17 0-31-8l-690-387-110 66q-8 4-12 5 14 49 10 97-7 77-56 147.5t-132 123.5q-132 84-277 84-136 0-222-78-90-84-79-207 7-76 56-147t131-124q132-84 278-84 83 0 151 31 9-13 22-22l122-73-122-73q-13-9-22-22-68 31-151 31-146 0-278-84-82-53-131-124t-56-147q-5-59 15.5-113t63.5-93q85-79 222-79 145 0 277 84 83 52 132 123t56 148q4 48-10 97 4 1 12 5l110 66 690-387q14-8 31-8 16 0 29 7l128 64q30 16 35 51 3 36-25 56zm-681-260q46-42 21-108t-106-117q-92-59-192-59-74 0-113 36-46 42-21 108t106 117q92 59 192 59 74 0 113-36zm-85 745q81-51 106-117t-21-108q-39-36-113-36-100 0-192 59-81 51-106 117t21 108q39 36 113 36 100 0 192-59zm178-613l96 58v-11q0-36 33-56l14-8-79-47-26 26q-3 3-10 11t-12 12q-2 2-4 3.5t-3 2.5zm224 224l96 32 736-576-128-64-768 431v113l-160 96 9 8q2 2 7 6 4 4 11 12t11 12l26 26zm704 416l128-64-520-408-177 138q-2 3-13 7z\"></path></svg>"

/***/ }),
/* 102 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M384 544v576q0 13-9.5 22.5t-22.5 9.5q-14 0-23-9l-288-288q-9-9-9-23t9-23l288-288q9-9 23-9 13 0 22.5 9.5t9.5 22.5zm1408 768v192q0 13-9.5 22.5t-22.5 9.5h-1728q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1728q13 0 22.5 9.5t9.5 22.5zm0-384v192q0 13-9.5 22.5t-22.5 9.5h-1088q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1088q13 0 22.5 9.5t9.5 22.5zm0-384v192q0 13-9.5 22.5t-22.5 9.5h-1088q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1088q13 0 22.5 9.5t9.5 22.5zm0-384v192q0 13-9.5 22.5t-22.5 9.5h-1728q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1728q13 0 22.5 9.5t9.5 22.5z\"></path></svg>"

/***/ }),
/* 103 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 128 128\" xml:space=\"preserve\"><g><polygon points=\"112.4560547,23.3203125 112.4560547,75.8154297 31.4853516,75.8154297 31.4853516,61.953125 16.0131836,72.6357422 0.5410156,83.3164063 16.0131836,93.9990234 31.4853516,104.6796875 31.4853516,90.8183594 112.4560547,90.8183594 112.4560547,90.8339844 127.4589844,90.8339844 127.4589844,23.3203125 \"></polygon></g></svg>"

/***/ }),
/* 104 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M832 1408l336-384h-768l-336 384h768zm1013-1077q15 34 9.5 71.5t-30.5 65.5l-896 1024q-38 44-96 44h-768q-38 0-69.5-20.5t-47.5-54.5q-15-34-9.5-71.5t30.5-65.5l896-1024q38-44 96-44h768q38 0 69.5 20.5t47.5 54.5z\"></path></svg>"

/***/ }),
/* 105 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1664 960q-152-236-381-353 61 104 61 225 0 185-131.5 316.5t-316.5 131.5-316.5-131.5-131.5-316.5q0-121 61-225-229 117-381 353 133 205 333.5 326.5t434.5 121.5 434.5-121.5 333.5-326.5zm-720-384q0-20-14-34t-34-14q-125 0-214.5 89.5t-89.5 214.5q0 20 14 34t34 14 34-14 14-34q0-86 61-147t147-61q20 0 34-14t14-34zm848 384q0 34-20 69-140 230-376.5 368.5t-499.5 138.5-499.5-139-376.5-368q-20-35-20-69t20-69q140-229 376.5-368t499.5-139 499.5 139 376.5 368q20 35 20 69z\"></path></svg>"

/***/ }),
/* 106 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1152 512v-472q22 14 36 28l408 408q14 14 28 36h-472zm-128 32q0 40 28 68t68 28h544v1056q0 40-28 68t-68 28h-1344q-40 0-68-28t-28-68v-1600q0-40 28-68t68-28h800v544z\"></path></svg>"

/***/ }),
/* 107 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1728 608v704q0 92-66 158t-158 66h-1216q-92 0-158-66t-66-158v-960q0-92 66-158t158-66h320q92 0 158 66t66 158v32h672q92 0 158 66t66 158z\"></path></svg>"

/***/ }),
/* 108 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M789 559l-170 450q33 0 136.5 2t160.5 2q19 0 57-2-87-253-184-452zm-725 1105l2-79q23-7 56-12.5t57-10.5 49.5-14.5 44.5-29 31-50.5l237-616 280-724h128q8 14 11 21l205 480q33 78 106 257.5t114 274.5q15 34 58 144.5t72 168.5q20 45 35 57 19 15 88 29.5t84 20.5q6 38 6 57 0 4-.5 13t-.5 13q-63 0-190-8t-191-8q-76 0-215 7t-178 8q0-43 4-78l131-28q1 0 12.5-2.5t15.5-3.5 14.5-4.5 15-6.5 11-8 9-11 2.5-14q0-16-31-96.5t-72-177.5-42-100l-450-2q-26 58-76.5 195.5t-50.5 162.5q0 22 14 37.5t43.5 24.5 48.5 13.5 57 8.5 41 4q1 19 1 58 0 9-2 27-58 0-174.5-10t-174.5-10q-8 0-26.5 4t-21.5 4q-80 14-188 14z\"></path></svg>"

/***/ }),
/* 109 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1744 1408q33 0 42 18.5t-11 44.5l-126 162q-20 26-49 26t-49-26l-126-162q-20-26-11-44.5t42-18.5h80v-1024h-80q-33 0-42-18.5t11-44.5l126-162q20-26 49-26t49 26l126 162q20 26 11 44.5t-42 18.5h-80v1024h80zm-1663-1279l54 27q12 5 211 5 44 0 132-2t132-2q36 0 107.5.5t107.5.5h293q6 0 21 .5t20.5 0 16-3 17.5-9 15-17.5l42-1q4 0 14 .5t14 .5q2 112 2 336 0 80-5 109-39 14-68 18-25-44-54-128-3-9-11-48t-14.5-73.5-7.5-35.5q-6-8-12-12.5t-15.5-6-13-2.5-18-.5-16.5.5q-17 0-66.5-.5t-74.5-.5-64 2-71 6q-9 81-8 136 0 94 2 388t2 455q0 16-2.5 71.5t0 91.5 12.5 69q40 21 124 42.5t120 37.5q5 40 5 50 0 14-3 29l-34 1q-76 2-218-8t-207-10q-50 0-151 9t-152 9q-3-51-3-52v-9q17-27 61.5-43t98.5-29 78-27q19-42 19-383 0-101-3-303t-3-303v-117q0-2 .5-15.5t.5-25-1-25.5-3-24-5-14q-11-12-162-12-33 0-93 12t-80 26q-19 13-34 72.5t-31.5 111-42.5 53.5q-42-26-56-44v-383z\"></path></svg>"

/***/ }),
/* 110 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M883 1056q0 13-10 23l-332 332 144 144q19 19 19 45t-19 45-45 19h-448q-26 0-45-19t-19-45v-448q0-26 19-45t45-19 45 19l144 144 332-332q10-10 23-10t23 10l114 114q10 10 10 23zm781-864v448q0 26-19 45t-45 19-45-19l-144-144-332 332q-10 10-23 10t-23-10l-114-114q-10-10-10-23t10-23l332-332-144-144q-19-19-19-45t19-45 45-19h448q26 0 45 19t19 45z\"></path></svg>"

/***/ }),
/* 111 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1600 736v192q0 40-28 68t-68 28h-1216q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h1216q40 0 68 28t28 68z\"></path></svg>"

/***/ }),
/* 112 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M576 576q0 80-56 136t-136 56-136-56-56-136 56-136 136-56 136 56 56 136zm1024 384v448h-1408v-192l320-320 160 160 512-512zm96-704h-1600q-13 0-22.5 9.5t-9.5 22.5v1216q0 13 9.5 22.5t22.5 9.5h1600q13 0 22.5-9.5t9.5-22.5v-1216q0-13-9.5-22.5t-22.5-9.5zm160 32v1216q0 66-47 113t-113 47h-1600q-66 0-113-47t-47-113v-1216q0-66 47-113t113-47h1600q66 0 113 47t47 113z\"></path></svg>"

/***/ }),
/* 113 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1152 1376v-160q0-14-9-23t-23-9h-96v-512q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v160q0 14 9 23t23 9h96v320h-96q-14 0-23 9t-9 23v160q0 14 9 23t23 9h448q14 0 23-9t9-23zm-128-896v-160q0-14-9-23t-23-9h-192q-14 0-23 9t-9 23v160q0 14 9 23t23 9h192q14 0 23-9t9-23zm640 416q0 209-103 385.5t-279.5 279.5-385.5 103-385.5-103-279.5-279.5-103-385.5 103-385.5 279.5-279.5 385.5-103 385.5 103 279.5 279.5 103 385.5z\"></path></svg>"

/***/ }),
/* 114 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M384 1662l17-85q6-2 81.5-21.5t111.5-37.5q28-35 41-101 1-7 62-289t114-543.5 52-296.5v-25q-24-13-54.5-18.5t-69.5-8-58-5.5l19-103q33 2 120 6.5t149.5 7 120.5 2.5q48 0 98.5-2.5t121-7 98.5-6.5q-5 39-19 89-30 10-101.5 28.5t-108.5 33.5q-8 19-14 42.5t-9 40-7.5 45.5-6.5 42q-27 148-87.5 419.5t-77.5 355.5q-2 9-13 58t-20 90-16 83.5-6 57.5l1 18q17 4 185 31-3 44-16 99-11 0-32.5 1.5t-32.5 1.5q-29 0-87-10t-86-10q-138-2-206-2-51 0-143 9t-121 11z\"></path></svg>"

/***/ }),
/* 115 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1792 1344v128q0 26-19 45t-45 19h-1664q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1664q26 0 45 19t19 45zm0-384v128q0 26-19 45t-45 19h-1664q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1664q26 0 45 19t19 45zm0-384v128q0 26-19 45t-45 19h-1664q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1664q26 0 45 19t19 45zm0-384v128q0 26-19 45t-45 19h-1664q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1664q26 0 45 19t19 45z\"></path></svg>"

/***/ }),
/* 116 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1792 1344v128q0 26-19 45t-45 19h-1664q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1664q26 0 45 19t19 45zm-384-384v128q0 26-19 45t-45 19h-1280q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1280q26 0 45 19t19 45zm256-384v128q0 26-19 45t-45 19h-1536q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1536q26 0 45 19t19 45zm-384-384v128q0 26-19 45t-45 19h-1152q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1152q26 0 45 19t19 45z\"></path></svg>"

/***/ }),
/* 117 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1520 1216q0-40-28-68l-208-208q-28-28-68-28-42 0-72 32 3 3 19 18.5t21.5 21.5 15 19 13 25.5 3.5 27.5q0 40-28 68t-68 28q-15 0-27.5-3.5t-25.5-13-19-15-21.5-21.5-18.5-19q-33 31-33 73 0 40 28 68l206 207q27 27 68 27 40 0 68-26l147-146q28-28 28-67zm-703-705q0-40-28-68l-206-207q-28-28-68-28-39 0-68 27l-147 146q-28 28-28 67 0 40 28 68l208 208q27 27 68 27 42 0 72-31-3-3-19-18.5t-21.5-21.5-15-19-13-25.5-3.5-27.5q0-40 28-68t68-28q15 0 27.5 3.5t25.5 13 19 15 21.5 21.5 18.5 19q33-31 33-73zm895 705q0 120-85 203l-147 146q-83 83-203 83-121 0-204-85l-206-207q-83-83-83-203 0-123 88-209l-88-88q-86 88-208 88-120 0-204-84l-208-208q-84-84-84-204t85-203l147-146q83-83 203-83 121 0 204 85l206 207q83 83 83 203 0 123-88 209l88 88q86-88 208-88 120 0 204 84l208 208q84 84 84 204z\"></path></svg>"

/***/ }),
/* 118 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M640 768h512v-192q0-106-75-181t-181-75-181 75-75 181v192zm832 96v576q0 40-28 68t-68 28h-960q-40 0-68-28t-28-68v-576q0-40 28-68t68-28h32v-192q0-184 132-316t316-132 316 132 132 316v192h32q40 0 68 28t28 68z\"></path></svg>"

/***/ }),
/* 119 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1664 1344v128q0 26-19 45t-45 19h-1408q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1408q26 0 45 19t19 45zm0-512v128q0 26-19 45t-45 19h-1408q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1408q26 0 45 19t19 45zm0-512v128q0 26-19 45t-45 19h-1408q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1408q26 0 45 19t19 45z\"></path></svg>"

/***/ }),
/* 120 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 312.000000 312.000000\"><g transform=\"translate(0.000000,312.000000) scale(0.100000,-0.100000)\" stroke=\"none\"><path d=\"M50 3109 c0 -7 -11 -22 -25 -35 l-25 -23 0 -961 0 -961 32 -29 32 -30 501 -2 500 -3 3 -502 2 -502 31 -30 31 -31 958 0 958 0 23 25 c13 13 30 25 37 25 9 0 12 199 12 960 0 686 -3 960 -11 960 -6 0 -24 12 -40 28 l-29 27 -503 5 -502 5 -5 502 -5 503 -28 29 c-15 16 -27 34 -27 40 0 8 -274 11 -960 11 -710 0 -960 -3 -960 -11z m1738 -698 l2 -453 -40 -40 c-22 -22 -40 -43 -40 -47 0 -4 36 -42 79 -85 88 -87 82 -87 141 -23 l26 27 455 -2 454 -3 0 -775 0 -775 -775 0 -775 0 -3 450 -2 449 47 48 47 48 -82 80 c-44 44 -84 80 -87 80 -3 0 -25 -18 -48 -40 l-41 -40 -456 2 -455 3 -3 765 c-1 421 0 771 3 778 3 10 164 12 777 10 l773 -3 3 -454z\"></path><path d=\"M607 2492 c-42 -42 -77 -82 -77 -87 0 -6 86 -96 190 -200 105 -104 190 -197 190 -205 0 -8 -41 -56 -92 -107 -65 -65 -87 -94 -77 -98 8 -3 138 -4 289 -3 l275 3 3 275 c1 151 0 281 -3 289 -4 10 -35 -14 -103 -82 -54 -53 -103 -97 -109 -97 -7 0 -99 88 -206 195 -107 107 -196 195 -198 195 -3 0 -39 -35 -82 -78z\"></path><path d=\"M1470 1639 c-47 -49 -87 -91 -89 -94 -5 -6 149 -165 160 -165 9 0 189 179 189 188 0 12 -154 162 -165 161 -6 0 -48 -41 -95 -90z\"></path><path d=\"M1797 1303 c-9 -8 -9 -568 0 -576 4 -4 50 36 103 88 54 52 101 95 106 95 5 0 95 -85 199 -190 104 -104 194 -190 200 -190 6 0 46 36 90 80 l79 79 -197 196 c-108 108 -197 199 -197 203 0 4 45 52 99 106 55 55 98 103 95 108 -6 10 -568 11 -577 1z\"></path></g></svg>"

/***/ }),
/* 121 */
/***/ (function(module, exports) {

module.exports = "<svg role=\"img\" viewBox=\"0 0 1792 1792\"><path d=\"M381 1620q0 80-54.5 126t-135.5 46q-106 0-172-66l57-88q49 45 106 45 29 0 50.5-14.5t21.5-42.5q0-64-105-56l-26-56q8-10 32.5-43.5t42.5-54 37-38.5v-1q-16 0-48.5 1t-48.5 1v53h-106v-152h333v88l-95 115q51 12 81 49t30 88zm2-627v159h-362q-6-36-6-54 0-51 23.5-93t56.5-68 66-47.5 56.5-43.5 23.5-45q0-25-14.5-38.5t-39.5-13.5q-46 0-81 58l-85-59q24-51 71.5-79.5t105.5-28.5q73 0 123 41.5t50 112.5q0 50-34 91.5t-75 64.5-75.5 50.5-35.5 52.5h127v-60h105zm1409 319v192q0 13-9.5 22.5t-22.5 9.5h-1216q-13 0-22.5-9.5t-9.5-22.5v-192q0-14 9-23t23-9h1216q13 0 22.5 9.5t9.5 22.5zm-1408-899v99h-335v-99h107q0-41 .5-122t.5-121v-12h-2q-8 17-50 54l-71-76 136-127h106v404h108zm1408 387v192q0 13-9.5 22.5t-22.5 9.5h-1216q-13 0-22.5-9.5t-9.5-22.5v-192q0-14 9-23t23-9h1216q13 0 22.5 9.5t9.5 22.5zm0-512v192q0 13-9.5 22.5t-22.5 9.5h-1216q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1216q13 0 22.5 9.5t9.5 22.5z\"></path></svg>"

/***/ }),
/* 122 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1534 189v73q0 29-18.5 61t-42.5 32q-50 0-54 1-26 6-32 31-3 11-3 64v1152q0 25-18 43t-43 18h-108q-25 0-43-18t-18-43v-1218h-143v1218q0 25-17.5 43t-43.5 18h-108q-26 0-43.5-18t-17.5-43v-496q-147-12-245-59-126-58-192-179-64-117-64-259 0-166 88-286 88-118 209-159 111-37 417-37h479q25 0 43 18t18 43z\"></path></svg>"

/***/ }),
/* 123 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M491 1536l91-91-235-235-91 91v107h128v128h107zm523-928q0-22-22-22-10 0-17 7l-542 542q-7 7-7 17 0 22 22 22 10 0 17-7l542-542q7-7 7-17zm-54-192l416 416-832 832h-416v-416zm683 96q0 53-37 90l-166 166-416-416 166-165q36-38 90-38 53 0 91 38l235 234q37 39 37 91z\"></path></svg>"

/***/ }),
/* 124 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1600 736v192q0 40-28 68t-68 28h-416v416q0 40-28 68t-68 28h-192q-40 0-68-28t-28-68v-416h-416q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h416v-416q0-40 28-68t68-28h192q40 0 68 28t28 68v416h416q40 0 68 28t28 68z\"></path></svg>"

/***/ }),
/* 125 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1664 256v448q0 26-19 45t-45 19h-448q-42 0-59-40-17-39 14-69l138-138q-148-137-349-137-104 0-198.5 40.5t-163.5 109.5-109.5 163.5-40.5 198.5 40.5 198.5 109.5 163.5 163.5 109.5 198.5 40.5q119 0 225-52t179-147q7-10 23-12 14 0 25 9l137 138q9 8 9.5 20.5t-7.5 22.5q-109 132-264 204.5t-327 72.5q-156 0-298-61t-245-164-164-245-61-298 61-298 164-245 245-164 298-61q147 0 284.5 55.5t244.5 156.5l130-129q29-31 70-14 39 17 39 59z\"></path></svg>"

/***/ }),
/* 126 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 24 24\" xmlns:sketch=\"http://www.bohemiancoding.com/sketch/ns\"><title></title><desc></desc><defs></defs><g><g transform=\"translate(-251.000000, -443.000000)\"><g transform=\"translate(215.000000, 119.000000)\"></g><path d=\"M252,448 L256,448 L256,444 L252,444 L252,448 Z M257,448 L269,448 L269,446 L257,446 L257,448 Z M257,464 L269,464 L269,462 L257,462 L257,464 Z M270,444 L270,448 L274,448 L274,444 L270,444 Z M252,462 L252,466 L256,466 L256,462 L252,462 Z M270,462 L270,466 L274,466 L274,462 L270,462 Z M254,461 L256,461 L256,449 L254,449 L254,461 Z M270,461 L272,461 L272,449 L270,449 L270,461 Z\"></path></g></g></svg>"

/***/ }),
/* 127 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M844 472q0 60-19 113.5t-63 92.5-105 39q-76 0-138-57.5t-92-135.5-30-151q0-60 19-113.5t63-92.5 105-39q77 0 138.5 57.5t91.5 135 30 151.5zm-342 483q0 80-42 139t-119 59q-76 0-141.5-55.5t-100.5-133.5-35-152q0-80 42-139.5t119-59.5q76 0 141.5 55.5t100.5 134 35 152.5zm394-27q118 0 255 97.5t229 237 92 254.5q0 46-17 76.5t-48.5 45-64.5 20-76 5.5q-68 0-187.5-45t-182.5-45q-66 0-192.5 44.5t-200.5 44.5q-183 0-183-146 0-86 56-191.5t139.5-192.5 187.5-146 193-59zm239-211q-61 0-105-39t-63-92.5-19-113.5q0-74 30-151.5t91.5-135 138.5-57.5q61 0 105 39t63 92.5 19 113.5q0 73-30 151t-92 135.5-138 57.5zm432-104q77 0 119 59.5t42 139.5q0 74-35 152t-100.5 133.5-141.5 55.5q-77 0-119-59t-42-139q0-74 35-152.5t100.5-134 141.5-55.5z\"></path></svg>"

/***/ }),
/* 128 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1792 1344v128q0 26-19 45t-45 19h-1664q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1664q26 0 45 19t19 45zm0-384v128q0 26-19 45t-45 19h-1280q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1280q26 0 45 19t19 45zm0-384v128q0 26-19 45t-45 19h-1536q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1536q26 0 45 19t19 45zm0-384v128q0 26-19 45t-45 19h-1152q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1152q26 0 45 19t19 45z\"></path></svg>"

/***/ }),
/* 129 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M512 1536h768v-384h-768v384zm896 0h128v-896q0-14-10-38.5t-20-34.5l-281-281q-10-10-34-20t-39-10v416q0 40-28 68t-68 28h-576q-40 0-68-28t-28-68v-416h-128v1280h128v-416q0-40 28-68t68-28h832q40 0 68 28t28 68v416zm-384-928v-320q0-13-9.5-22.5t-22.5-9.5h-192q-13 0-22.5 9.5t-9.5 22.5v320q0 13 9.5 22.5t22.5 9.5h192q13 0 22.5-9.5t9.5-22.5zm640 32v928q0 40-28 68t-68 28h-1344q-40 0-68-28t-28-68v-1344q0-40 28-68t68-28h928q40 0 88 20t76 48l280 280q28 28 48 76t20 88z\"></path></svg>"

/***/ }),
/* 130 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 18 18\"><g fill-rule=\"evenodd\" stroke=\"none\" stroke-width=\"1\"><g transform=\"translate(-381.000000, -381.000000)\"><g transform=\"translate(381.000000, 381.000000)\"><path d=\"M0,2 L2,2 L2,0 C0.9,0 0,0.9 0,2 L0,2 Z M0,10 L2,10 L2,8 L0,8 L0,10 L0,10 Z M4,18 L6,18 L6,16 L4,16 L4,18 L4,18 Z M0,6 L2,6 L2,4 L0,4 L0,6 L0,6 Z M10,0 L8,0 L8,2 L10,2 L10,0 L10,0 Z M16,0 L16,2 L18,2 C18,0.9 17.1,0 16,0 L16,0 Z M2,18 L2,16 L0,16 C0,17.1 0.9,18 2,18 L2,18 Z M0,14 L2,14 L2,12 L0,12 L0,14 L0,14 Z M6,0 L4,0 L4,2 L6,2 L6,0 L6,0 Z M8,18 L10,18 L10,16 L8,16 L8,18 L8,18 Z M16,10 L18,10 L18,8 L16,8 L16,10 L16,10 Z M16,18 C17.1,18 18,17.1 18,16 L16,16 L16,18 L16,18 Z M16,6 L18,6 L18,4 L16,4 L16,6 L16,6 Z M16,14 L18,14 L18,12 L16,12 L16,14 L16,14 Z M12,18 L14,18 L14,16 L12,16 L12,18 L12,18 Z M12,2 L14,2 L14,0 L12,0 L12,2 L12,2 Z M4,14 L14,14 L14,4 L4,4 L4,14 L4,14 Z M6,6 L12,6 L12,12 L6,12 L6,6 L6,6 Z\"></path></g></g></g></svg>"

/***/ }),
/* 131 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M896 960v448q0 26-19 45t-45 19-45-19l-144-144-332 332q-10 10-23 10t-23-10l-114-114q-10-10-10-23t10-23l332-332-144-144q-19-19-19-45t19-45 45-19h448q26 0 45 19t19 45zm755-672q0 13-10 23l-332 332 144 144q19 19 19 45t-19 45-45 19h-448q-26 0-45-19t-19-45v-448q0-26 19-45t45-19 45 19l144 144 332-332q10-10 23-10t23 10l114 114q10 10 10 23z\"></path></svg>"

/***/ }),
/* 132 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M553 1399l-50 50q-10 10-23 10t-23-10l-466-466q-10-10-10-23t10-23l466-466q10-10 23-10t23 10l50 50q10 10 10 23t-10 23l-393 393 393 393q10 10 10 23t-10 23zm591-1067l-373 1291q-4 13-15.5 19.5t-23.5 2.5l-62-17q-13-4-19.5-15.5t-2.5-24.5l373-1291q4-13 15.5-19.5t23.5-2.5l62 17q13 4 19.5 15.5t2.5 24.5zm657 651l-466 466q-10 10-23 10t-23-10l-50-50q-10-10-10-23t10-23l393-393-393-393q-10-10-10-23t10-23l50-50q10-10 23-10t23 10l466 466q10 10 10 23t-10 23z\"></path></svg>"

/***/ }),
/* 133 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 48 48\"><path d=\"M6 42h4v-4h-4v4zm4-28h-4v4h4v-4zm-4 20h4v-4h-4v4zm8 8h4v-4h-4v4zm-4-36h-4v4h4v-4zm8 0h-4v4h4v-4zm16 0h-4v4h4v-4zm-8 8h-4v4h4v-4zm0-8h-4v4h4v-4zm12 28h4v-4h-4v4zm-16 8h4v-4h-4v4zm-16-16h36v-4h-36v4zm32-20v4h4v-4h-4zm0 12h4v-4h-4v4zm-16 16h4v-4h-4v4zm8 8h4v-4h-4v4zm8 0h4v-4h-4v4z\"></path><path d=\"M0 0h48v48h-48z\" fill=\"none\"></path></svg>"

/***/ }),
/* 134 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 48 48\"><path d=\"M6 18h4v-4h-4v4zm0-8h4v-4h-4v4zm8 32h4v-4h-4v4zm0-16h4v-4h-4v4zm-8 0h4v-4h-4v4zm0 16h4v-4h-4v4zm0-8h4v-4h-4v4zm8-24h4v-4h-4v4zm24 24h4v-4h-4v4zm-16 8h4v-36h-4v36zm16 0h4v-4h-4v4zm0-16h4v-4h-4v4zm0-20v4h4v-4h-4zm0 12h4v-4h-4v4zm-8-8h4v-4h-4v4zm0 32h4v-4h-4v4zm0-16h4v-4h-4v4z\"></path><path d=\"M0 0h48v48h-48z\" fill=\"none\"></path></svg>"

/***/ }),
/* 135 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1760 896q14 0 23 9t9 23v64q0 14-9 23t-23 9h-1728q-14 0-23-9t-9-23v-64q0-14 9-23t23-9h1728zm-1277-64q-28-35-51-80-48-97-48-188 0-181 134-309 133-127 393-127 50 0 167 19 66 12 177 48 10 38 21 118 14 123 14 183 0 18-5 45l-12 3-84-6-14-2q-50-149-103-205-88-91-210-91-114 0-182 59-67 58-67 146 0 73 66 140t279 129q69 20 173 66 58 28 95 52h-743zm507 256h411q7 39 7 92 0 111-41 212-23 55-71 104-37 35-109 81-80 48-153 66-80 21-203 21-114 0-195-23l-140-40q-57-16-72-28-8-8-8-22v-13q0-108-2-156-1-30 0-68l2-37v-44l102-2q15 34 30 71t22.5 56 12.5 27q35 57 80 94 43 36 105 57 59 22 132 22 64 0 139-27 77-26 122-86 47-61 47-129 0-84-81-157-34-29-137-71z\"></path></svg>"

/***/ }),
/* 136 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1025 1369v167h-248l-159-252-24-42q-8-9-11-21h-3l-9 21q-10 20-25 44l-155 250h-258v-167h128l197-291-185-272h-137v-168h276l139 228q2 4 23 42 8 9 11 21h3q3-9 11-21l25-42 140-228h257v168h-125l-184 267 204 296h109zm639 217v206h-514l-4-27q-3-45-3-46 0-64 26-117t65-86.5 84-65 84-54.5 65-54 26-64q0-38-29.5-62.5t-70.5-24.5q-51 0-97 39-14 11-36 38l-105-92q26-37 63-66 80-65 188-65 110 0 178 59.5t68 158.5q0 66-34.5 118.5t-84 86-99.5 62.5-87 63-41 73h232v-80h126z\"></path></svg>"

/***/ }),
/* 137 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1025 1369v167h-248l-159-252-24-42q-8-9-11-21h-3l-9 21q-10 20-25 44l-155 250h-258v-167h128l197-291-185-272h-137v-168h276l139 228q2 4 23 42 8 9 11 21h3q3-9 11-21l25-42 140-228h257v168h-125l-184 267 204 296h109zm637-679v206h-514l-3-27q-4-28-4-46 0-64 26-117t65-86.5 84-65 84-54.5 65-54 26-64q0-38-29.5-62.5t-70.5-24.5q-51 0-97 39-14 11-36 38l-105-92q26-37 63-66 83-65 188-65 110 0 178 59.5t68 158.5q0 56-24.5 103t-62 76.5-81.5 58.5-82 50.5-65.5 51.5-30.5 63h232v-80h126z\"></path></svg>"

/***/ }),
/* 138 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M576 1376v-192q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v192q0 14 9 23t23 9h320q14 0 23-9t9-23zm0-384v-192q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v192q0 14 9 23t23 9h320q14 0 23-9t9-23zm512 384v-192q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v192q0 14 9 23t23 9h320q14 0 23-9t9-23zm-512-768v-192q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v192q0 14 9 23t23 9h320q14 0 23-9t9-23zm512 384v-192q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v192q0 14 9 23t23 9h320q14 0 23-9t9-23zm512 384v-192q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v192q0 14 9 23t23 9h320q14 0 23-9t9-23zm-512-768v-192q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v192q0 14 9 23t23 9h320q14 0 23-9t9-23zm512 384v-192q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v192q0 14 9 23t23 9h320q14 0 23-9t9-23zm0-384v-192q0-14-9-23t-23-9h-320q-14 0-23 9t-9 23v192q0 14 9 23t23 9h320q14 0 23-9t9-23zm128-320v1088q0 66-47 113t-113 47h-1344q-66 0-113-47t-47-113v-1088q0-66 47-113t113-47h1344q66 0 113 47t47 113z\"></path></svg>"

/***/ }),
/* 139 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M512 1248v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm0-512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm1280 512v192q0 40-28 68t-68 28h-960q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h960q40 0 68 28t28 68zm-1280-1024v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm1280 512v192q0 40-28 68t-68 28h-960q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h960q40 0 68 28t28 68zm0-512v192q0 40-28 68t-68 28h-960q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h960q40 0 68 28t28 68z\"></path></svg>"

/***/ }),
/* 140 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M512 1248v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm0-512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm640 512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm-640-1024v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm640 512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm640 512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm-640-1024v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm640 512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68zm0-512v192q0 40-28 68t-68 28h-320q-40 0-68-28t-28-68v-192q0-40 28-68t68-28h320q40 0 68 28t28 68z\"></path></svg>"

/***/ }),
/* 141 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M384 1408q0 80-56 136t-136 56-136-56-56-136 56-136 136-56 136 56 56 136zm0-512q0 80-56 136t-136 56-136-56-56-136 56-136 136-56 136 56 56 136zm1408 416v192q0 13-9.5 22.5t-22.5 9.5h-1216q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1216q13 0 22.5 9.5t9.5 22.5zm-1408-928q0 80-56 136t-136 56-136-56-56-136 56-136 136-56 136 56 56 136zm1408 416v192q0 13-9.5 22.5t-22.5 9.5h-1216q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1216q13 0 22.5 9.5t9.5 22.5zm0-512v192q0 13-9.5 22.5t-22.5 9.5h-1216q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1216q13 0 22.5 9.5t9.5 22.5z\"></path></svg>"

/***/ }),
/* 142 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M176 223q-37-2-45-4l-3-88q13-1 40-1 60 0 112 4 132 7 166 7 86 0 168-3 116-4 146-5 56 0 86-2l-1 14 2 64v9q-60 9-124 9-60 0-79 25-13 14-13 132 0 13 .5 32.5t.5 25.5l1 229 14 280q6 124 51 202 35 59 96 92 88 47 177 47 104 0 191-28 56-18 99-51 48-36 65-64 36-56 53-114 21-73 21-229 0-79-3.5-128t-11-122.5-13.5-159.5l-4-59q-5-67-24-88-34-35-77-34l-100 2-14-3 2-86h84l205 10q76 3 196-10l18 2q6 38 6 51 0 7-4 31-45 12-84 13-73 11-79 17-15 15-15 41 0 7 1.5 27t1.5 31q8 19 22 396 6 195-15 304-15 76-41 122-38 65-112 123-75 57-182 89-109 33-255 33-167 0-284-46-119-47-179-122-61-76-83-195-16-80-16-237v-333q0-188-17-213-25-36-147-39zm1488 1409v-64q0-14-9-23t-23-9h-1472q-14 0-23 9t-9 23v64q0 14 9 23t23 9h1472q14 0 23-9t9-23z\"></path></svg>"

/***/ }),
/* 143 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1664 896q0 156-61 298t-164 245-245 164-298 61q-172 0-327-72.5t-264-204.5q-7-10-6.5-22.5t8.5-20.5l137-138q10-9 25-9 16 2 23 12 73 95 179 147t225 52q104 0 198.5-40.5t163.5-109.5 109.5-163.5 40.5-198.5-40.5-198.5-109.5-163.5-163.5-109.5-198.5-40.5q-98 0-188 35.5t-160 101.5l137 138q31 30 14 69-17 40-59 40h-448q-26 0-45-19t-19-45v-448q0-42 40-59 39-17 69 14l130 129q107-101 244.5-156.5t284.5-55.5q156 0 298 61t245 164 164 245 61 298z\"></path></svg>"

/***/ }),
/* 144 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M503 1271l-256 256q-10 9-23 9-12 0-23-9-9-10-9-23t9-23l256-256q10-9 23-9t23 9q9 10 9 23t-9 23zm169 41v320q0 14-9 23t-23 9-23-9-9-23v-320q0-14 9-23t23-9 23 9 9 23zm-224-224q0 14-9 23t-23 9h-320q-14 0-23-9t-9-23 9-23 23-9h320q14 0 23 9t9 23zm1264 128q0 120-85 203l-147 146q-83 83-203 83-121 0-204-85l-334-335q-21-21-42-56l239-18 273 274q27 27 68 27.5t68-26.5l147-146q28-28 28-67 0-40-28-68l-274-275 18-239q35 21 56 42l336 336q84 86 84 204zm-617-724l-239 18-273-274q-28-28-68-28-39 0-68 27l-147 146q-28 28-28 67 0 40 28 68l274 274-18 240q-35-21-56-42l-336-336q-84-86-84-204 0-120 85-203l147-146q83-83 203-83 121 0 204 85l334 335q21 21 42 56zm633 84q0 14-9 23t-23 9h-320q-14 0-23-9t-9-23 9-23 23-9h320q14 0 23 9t9 23zm-544-544v320q0 14-9 23t-23 9-23-9-9-23v-320q0-14 9-23t23-9 23 9 9 23zm407 151l-256 256q-11 9-23 9t-23-9q-9-10-9-23t9-23l256-256q10-9 23-9t23 9q9 10 9 23t-9 23z\"></path></svg>"

/***/ }),
/* 145 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1728 576v256q0 26-19 45t-45 19h-64q-26 0-45-19t-19-45v-256q0-106-75-181t-181-75-181 75-75 181v192h96q40 0 68 28t28 68v576q0 40-28 68t-68 28h-960q-40 0-68-28t-28-68v-576q0-40 28-68t68-28h672v-192q0-185 131.5-316.5t316.5-131.5 316.5 131.5 131.5 316.5z\"></path></svg>"

/***/ }),
/* 146 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1639 1056q0 5-1 7-64 268-268 434.5t-478 166.5q-146 0-282.5-55t-243.5-157l-129 129q-19 19-45 19t-45-19-19-45v-448q0-26 19-45t45-19h448q26 0 45 19t19 45-19 45l-137 137q71 66 161 102t187 36q134 0 250-65t186-179q11-17 53-117 8-23 30-23h192q13 0 22.5 9.5t9.5 22.5zm25-800v448q0 26-19 45t-45 19h-448q-26 0-45-19t-19-45 19-45l138-138q-148-137-349-137-134 0-250 65t-186 179q-11 17-53 117-8 23-30 23h-199q-13 0-22.5-9.5t-9.5-22.5v-7q65-268 270-434.5t480-166.5q146 0 284 55.5t245 156.5l130-129q19-19 45-19t45 19 19 45z\"></path></svg>"

/***/ }),
/* 147 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1344 1472q0-26-19-45t-45-19-45 19-19 45 19 45 45 19 45-19 19-45zm256 0q0-26-19-45t-45-19-45 19-19 45 19 45 45 19 45-19 19-45zm128-224v320q0 40-28 68t-68 28h-1472q-40 0-68-28t-28-68v-320q0-40 28-68t68-28h427q21 56 70.5 92t110.5 36h256q61 0 110.5-36t70.5-92h427q40 0 68 28t28 68zm-325-648q-17 40-59 40h-256v448q0 26-19 45t-45 19h-256q-26 0-45-19t-19-45v-448h-256q-42 0-59-40-17-39 14-69l448-448q18-19 45-19t45 19l448 448q31 30 14 69z\"></path></svg>"

/***/ }),
/* 148 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1216 320q0 26-19 45t-45 19h-128v1024h128q26 0 45 19t19 45-19 45l-256 256q-19 19-45 19t-45-19l-256-256q-19-19-19-45t19-45 45-19h128v-1024h-128q-26 0-45-19t-19-45 19-45l256-256q19-19 45-19t45 19l256 256q19 19 19 45z\"></path></svg>"

/***/ }),
/* 149 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M1792 352v1088q0 42-39 59-13 5-25 5-27 0-45-19l-403-403v166q0 119-84.5 203.5t-203.5 84.5h-704q-119 0-203.5-84.5t-84.5-203.5v-704q0-119 84.5-203.5t203.5-84.5h704q119 0 203.5 84.5t84.5 203.5v165l403-402q18-19 45-19 12 0 25 5 39 17 39 59z\"></path></svg>"

/***/ }),
/* 150 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M384 544v576q0 13-9.5 22.5t-22.5 9.5q-14 0-23-9l-288-288q-9-9-9-23t9-23l288-288q9-9 23-9 13 0 22.5 9.5t9.5 22.5zm1408 768v192q0 13-9.5 22.5t-22.5 9.5h-1728q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1728q13 0 22.5 9.5t9.5 22.5zm0-384v192q0 13-9.5 22.5t-22.5 9.5h-1088q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1088q13 0 22.5 9.5t9.5 22.5zm0-384v192q0 13-9.5 22.5t-22.5 9.5h-1088q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1088q13 0 22.5 9.5t9.5 22.5zm0-384v192q0 13-9.5 22.5t-22.5 9.5h-1728q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1728q13 0 22.5 9.5t9.5 22.5z\"></path></svg>"

/***/ }),
/* 151 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M352 832q0 14-9 23l-288 288q-9 9-23 9-13 0-22.5-9.5t-9.5-22.5v-576q0-13 9.5-22.5t22.5-9.5q14 0 23 9l288 288q9 9 9 23zm1440 480v192q0 13-9.5 22.5t-22.5 9.5h-1728q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1728q13 0 22.5 9.5t9.5 22.5zm0-384v192q0 13-9.5 22.5t-22.5 9.5h-1088q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1088q13 0 22.5 9.5t9.5 22.5zm0-384v192q0 13-9.5 22.5t-22.5 9.5h-1088q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1088q13 0 22.5 9.5t9.5 22.5zm0-384v192q0 13-9.5 22.5t-22.5 9.5h-1728q-13 0-22.5-9.5t-9.5-22.5v-192q0-13 9.5-22.5t22.5-9.5h1728q13 0 22.5 9.5t9.5 22.5z\"></path></svg>"

/***/ }),
/* 152 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 1792 1792\"><path d=\"M448 1536h896v-256h-896v256zm0-640h896v-384h-160q-40 0-68-28t-28-68v-160h-640v640zm1152 64q0-26-19-45t-45-19-45 19-19 45 19 45 45 19 45-19 19-45zm128 0v416q0 13-9.5 22.5t-22.5 9.5h-224v160q0 40-28 68t-68 28h-960q-40 0-68-28t-28-68v-160h-224q-13 0-22.5-9.5t-9.5-22.5v-416q0-79 56.5-135.5t135.5-56.5h64v-544q0-40 28-68t68-28h672q40 0 88 20t76 48l152 152q28 28 48 76t20 88v256h64q79 0 135.5 56.5t56.5 135.5z\"></path></svg>"

/***/ }),
/* 153 */
/***/ (function(module, exports) {

module.exports = "<svg viewBox=\"0 0 270 270\"><path d=\"m240.443652,220.45085l-47.410809,0l0,-10.342138c13.89973,-8.43655 25.752896,-19.844464 34.686646,-33.469923c11.445525,-17.455846 17.496072,-37.709239 17.496072,-58.570077c0,-59.589197 -49.208516,-108.068714 -109.693558,-108.068714s-109.69263,48.479517 -109.69263,108.069628c0,20.860839 6.050547,41.113316 17.497001,58.570077c8.93375,13.625459 20.787845,25.032458 34.686646,33.469008l0,10.342138l-47.412666,0c-10.256959,0 -18.571354,8.191376 -18.571354,18.296574c0,10.105198 8.314395,18.296574 18.571354,18.296574l65.98402,0c10.256959,0 18.571354,-8.191376 18.571354,-18.296574l0,-39.496814c0,-7.073455 -4.137698,-13.51202 -10.626529,-16.537358c-25.24497,-11.772016 -41.557118,-37.145704 -41.557118,-64.643625c0,-39.411735 32.545369,-71.476481 72.549922,-71.476481c40.004553,0 72.550851,32.064746 72.550851,71.476481c0,27.497006 -16.312149,52.87161 -41.557118,64.643625c-6.487902,3.026253 -10.6256,9.464818 -10.6256,16.537358l0,39.496814c0,10.105198 8.314395,18.296574 18.571354,18.296574l65.982163,0c10.256959,0 18.571354,-8.191376 18.571354,-18.296574c0,-10.105198 -8.314395,-18.296574 -18.571354,-18.296574z\"></path></svg>"

/***/ })
/******/ ]);
});