Ext.tip.QuickTipManager.init();
(function ($) {

	//---adding bg to text 
	function createSVGTextBg(element, color) {
		var svgNS = "http://www.w3.org/2000/svg",
			bounds = element.getBBox(),
			elemBG = document.createElementNS(svgNS, "rect"),
			style = getComputedStyle(element),
			paddingRight = parseInt(style["padding-right"]),
			paddingTop = parseInt(style["padding-top"]),
			paddingLeft = parseInt(style["padding-left"]),
			paddingBottom = parseInt(style["padding-bottom"]);
		elemBG.setAttribute("x", bounds.x - parseInt(style["padding-left"]))
		elemBG.setAttribute("y", bounds.y - parseInt(style["padding-top"]))
		elemBG.setAttribute("width", bounds.width + paddingLeft + paddingRight)
		elemBG.setAttribute("height", bounds.height + paddingTop + paddingBottom)
		elemBG.setAttribute("fill", color)
		elemBG.setAttribute("class", "textbg")
		if (element.hasAttribute("transform")) {
			elemBG.setAttribute("transform", element.getAttribute("transform"))
		}
		element.parentNode.insertBefore(elemBG, element)
	}
	d3.selection.prototype.moveToFront = function () {
		return this.each(function () {
			this.parentNode.appendChild(this);
		});
	};
	d3.selection.prototype.moveToBack = function () {
		return this.each(function () {
			var firstChild = this.parentNode.firstChild;
			if (firstChild) {
				this.parentNode.insertBefore(this, firstChild);
			}
		});
	};

	function drawRect(x, y, width, height, radius, topleft, topright, bottomleft, bottomright) {
		var path;
		path = "M" + (x + radius) + "," + y;
		path += "h" + (width - 2 * radius);
		if (topright) {
			path += "a" + radius + "," + radius + " 0 0 1 " + radius + "," + radius;
		} else {
			path += "h" + radius;
			path += "v" + radius;
		}
		path += "v" + (height - 2 * radius);
		if (bottomright) {
			path += "a" + radius + "," + radius + " 0 0 1 " + -radius + "," + radius;
		} else {
			path += "v" + radius;
			path += "h" + -radius;
		}
		path += "h" + (2 * radius - width);
		if (bottomleft) {
			path += "a" + radius + "," + radius + " 0 0 1 " + -radius + "," + -radius;
		} else {
			path += "h" + -radius;
			path += "v" + -radius;
		}
		path += "v" + (2 * radius - height);
		if (topleft) {
			path += "a" + radius + "," + radius + " 0 0 1 " + radius + "," + -radius;
		} else {
			path += "v" + -radius;
			path += "h" + radius;
		}
		path += "z";
		return path;
	}
	// -- default settings
	var settings = {
		chartTitle: 'Testing',
		renderTo: 'body',
		width: 800,
		height: 900,
		url: null,
		zoom: true,
		segmentName: null,
		//layoutAlign: Ext.isEmpty(window.parent.isTvMode) ? 'left' : 'center',
		layoutAlign: 'center',
		fromPage: null,
		loadingText: "creating topology...",
		min_zoom: 0.2,
		max_zoom: 2,
		default_zoom: 1,
		gravity: 0,
		charge: function (d, i) {
			return i ? 0 : -2000;
		},
		segmentStateCls: null,
		enableFitLayout: true,
		linkDistance: 3,
		initialX: null,
		initialY: null,
		zoomObj: d3.behavior.zoom(),
		collideLayout: false,
		draggable: true,
		margin: {
			top: -8,
			right: -8,
			bottom: -8,
			left: -8
		}
	};
	var data, loading, connectedNodes, timer, mousedownsearch = false,
		segmentName1, oldSgt, newSgt, segmentName, movementX, movementY, HX, HY, LX, LY,
		hideScrollbar = true,
		translateZ, scaleZ, svgScale = {},
		svg, body = d3.select("body"),
		toolTip, header, slider_tooltip, duration = 500,
		force;


	// -- rendering data 
	$.fn.renderDiagram = function (options) {

		var options = $.extend({}, settings, options);

		options.linkDistance = (options.width + options.height) / 2;
		// -- Force layout object
		force = d3.layout.force();
		segmentName1 = options.segmentName;
		groupOpenIdTopoValt = options.groupOpenIdTopoValt;
		pageNoTopoValt = options.pageNoTopoValt;

		if (window.localStorage.getItem("pervoiussgt")) {
			oldSgt = window.localStorage.getItem("pervoiussgt");
		}

		segmentName = options.segmentName;
		window.localStorage.setItem("currentsgt", segmentName);
		newSgt = window.localStorage.getItem("currentsgt");
		if (oldSgt == newSgt) {

		} else {

			window.localStorage.setItem("pervoiussgt", segmentName);
			for (i = 0; i <= window.localStorage.length; i++) {
				key = window.localStorage.key(i);
				val = window.localStorage.getItem(key);
				if (localStorage.getItem('svgScale')) {
					window.localStorage.removeItem('svgScale');

				}
			}
		}

		d3.json('#', function (error, graph) {

			var graph = options.data;

			xScale = d3.scale.linear().domain([0, options.width]);
			yScale = d3.scale.linear().domain([0, options.height]);
			var tip, i = 0,
				timeout;
			if (error) {
				//d3.select(options.renderTo).text('MAY BE ERROR IN YOUR DATA');
			}

			this.nodes = graph.rootJson.nodes;
			this.links = graph.rootJson.links;

			var Nodes = this.nodes;
			var Links = this.links;

			/************text bg ************/
			var color = graph.rootJson.paper.skin == "Dark" ? "#444444" : "#ffffff";
			var textbg = d3.select('svg.svgparentTag').append("defs").append("filter").attr("id", "textBg").attr("filterUnits", "objectBoundingBox")
				.attr('x', 0).attr('y', 0).attr('height', 1.1).attr('width', 1);

			textbg.append('feFlood').attr('flood-color', color).attr('flood-opacity', "1").attr('result', "flood");
			textbg.append('feComposite').attr('in', 'SourceGraphic').attr('in2', 'BackgroundImage').attr('operator', 'over').attr('result', 'comp');
			/********************************/
			// -- Forming the force layout 
			var k = Math.sqrt(Nodes.length / (options.width * options.height));
			force.nodes(this.nodes).links(this.links).gravity(100 * k).charge(-10 / k).linkDistance(options.linkDistance).size([options.width, options.height]).start();

			HX = d3.max(this.nodes, function (d) {
				return d.x;
			});
			HY = d3.max(this.nodes, function (d) {
				return d.y;
			});
			LX = d3.min(this.nodes, function (d) {
				return d.x;
			});
			LY = d3.min(this.nodes, function (d) {
				return d.y;
			});

			if (options.layoutAlign == 'center') {
				movementX = (options.width - HX) / 2;
				movementY = (options.height - HY) / 2;


			} else if (options.layoutAlign == 'left') {

				movementX = 0;
				movementY = 0;
			} else {
				movementX = 0;
				movementY = 0;
			}


			// --Find link 
			var edges = [];
			var toggle = 0;

			// -- Create an array logging what is connected to what
			var linkedByIndex = {};
			for (i = 0; i < this.nodes.length; i++) {
				linkedByIndex[i + "," + i] = 1;
			};
			this.links.forEach(function (d) {
				linkedByIndex[d.source.index + "," + d.target.index] = 1;
			});
			// -- This function looks up whether a pair are neighbours
			function neighboring(a, b) {
				return linkedByIndex[a.index + "," + b.index];
			}
			connectedNodes = function () {
				clearTimeout(timer);
				if (d3.event.defaultPrevented) return;
				if (toggle == 0) {
					//-- Reduce the opacity of all but the neighbouring nodes
					d = d3.select(this).node().__data__;
					groupNodes.style("opacity", function (o) {
						return neighboring(d, o) | neighboring(o, d) ? 1 : 0.1;
					});
					path.style("opacity", function (o) {
						return d.index == o.source.index | d.index == o.target.index ? 1 : 0.1;
					});
					//-- Reduce the opacity
					toggle = 1;
				} else {
					//--Put them back to opacity=1
					groupNodes.style("opacity", 1);
					path.style("opacity", 1);
					toggle = 0;
				}
			}

			// -- search node function
			var optArray = [];
			var nodeXY = [];
			var result = [];
			// WHY i =1 ? because 1 =="USER"
			for (var i = 1; i < this.nodes.length; i++) {
				optArray.push(this.nodes[i].cName, this.nodes[i].cType);
				nodeXY.push(this.nodes[i].x, this.nodes[i].y);
			}
			//$('#searchnode').live('click', function(e) {
			$('body').on('click', '#searchnode', function (e) {
				e.stopImmediatePropagation();
				searchNode();
				$('#search').focus();
			});
			optArray = optArray.sort();

			function searchNode() {
				var selectedVal = $("#search").val(),
					getX, getY;
				if (selectedVal == null || selectedVal == "" || selectedVal == 'undefined') {
					//Ext.Msg.alert('Topology', 'Please enter valid component type');
					Ext.Msg.show({
						title: 'Topology',
						msg: 'Please enter component name',
						icon: 'iconInformation',
						buttons: Ext.Msg.OK
					});
					return;
				}
				var node = d3.select('svg.svgparentTag').selectAll(".g_node");

				optArray.filter(function (_item) {
					return (_item.toString().toLowerCase().indexOf(selectedVal.toLowerCase()) > -1);
				}).forEach(function (_item, i) {
					result.push(_item);
				});
				if (result.length === 0) {
					//Ext.Msg.alert('Topology', 'No result found');
					Ext.Msg.show({
						title: 'Topology',
						msg: 'No data available for the current search!',
						icon: 'iconExclamation',
						buttons: Ext.Msg.OK
					});
				}
				for (var t = 0; t < result.length; t++) {
					if (result.length == 0) {
						if (result[t] == null || result[t] == "" || result[t] == 'undefined') {
							return;
						} else {

							var selected = node.filter(function (d, i) {
								if (result[t] != null && result[t] == d.cName || result[t] == d.cType) {

									if (options.layoutAlign == 'center') {
										getX = d.x + movementX;
										getY = d.y + movementY;
										d3.select(this)
											.append("rect")
											.attr("class", "highlitenode")
											.attr("rx", 5)
											.attr('ry', 5)
											.attr('y', movementY - 35)
											.attr('x', movementX - 35)
											.attr('height', 50)
											.attr('width', 80)
											.style({
												"stroke": "#c8c8c8",
												"stroke-width": "2px",
												"fill": "none"
											})
											.transition()
											.duration(duration)
											.remove();

									} else {

										getX = d.x;
										getY = d.y;
										d3.select(this)
											.append("rect")
											.attr("class", "highlitenode")
											.attr("rx", 5).attr('ry', 5)
											.attr('y', movementY - 35)
											.attr('x', movementX - 35)
											.attr('height', 50)
											.attr('width', 80)
											.style({
												"stroke": "#c8c8c8",
												"stroke-width": "2px",
												"fill": "none"
											})
											.transition()
											.duration(5000)
											.remove();

									}


								} else {

								}
								return d.cName != result[t] || result[t] != d.cType && d.px && d.py;
								//selected.style("opacity", "0");
							});

							d3.select('svg.svgparentTag')
								.select('.pitch')
								.transition()
								.duration(2000)
								.call(options.zoomObj.scale(1.5).translate([(-parseInt(getX + movementX) * 1.5 + options.width / 2), (-parseInt(getY + movementY) * 1.5 + options.height / 2)]).event);
						}
					} else {

						var selected = node.filter(function (d, i) {
							if (result[t] != null && result[t] == d.cName || result[t] == d.cType) {

								if (options.layoutAlign == 'center') {

									d3.select(this)
										.append("rect")
										.attr("class", "highlitenode")
										.attr("rx", 5)
										.attr('ry', 5)
										.attr('y', movementY - 35)
										.attr('x', movementX - 35)
										.attr('height', 50)
										.attr('width', 80)
										.style({
											"stroke": "#c8c8c8",
											"stroke-width": "2px",
											"fill": "none"
										})
										.transition()
										.duration(5000)
										.remove();

								} else {

									d3.select(this)
										.append("rect")
										.attr("class", "highlitenode")
										.attr("rx", 5)
										.attr('ry', 5)
										.attr('y', movementY - 35)
										.attr('x', movementX - 35)
										.attr('height', 50)
										.attr('width', 80)
										.style({
											"stroke": "#c8c8c8",
											"stroke-width": "2px",
											"fill": "none"
										})
										.transition()
										.duration(5000)
										.remove();

								}


								getX = d.x;
								getY = d.y;
							}
							//	selected.style("opacity", "0");
							return d.cName != result[t] || result[t] != d.cType && d.px && d.py;

						});

						/*d3.select('svg.svgparentTag')
							.select('.pitch')
							.transition()
							.duration(2000)
							.call(options.zoomObj.scale(options.default_zoom)
							.translate([options.margin.left,options.margin.top]).event);*/

						d3.select('svg.svgparentTag')
							.select('.pitch')
							.transition()
							.duration(2000)
							.call(options.zoomObj.scale(1.5).translate([(-parseInt(getX + movementX) * 1.5 + options.width / 2), (-parseInt(getY + movementY) * 1.5 + options.height / 2)]).event);
						//.call(options.zoomObj.scale(options.default_zoom)
						//.translate([getX,getY]).event);
					}



					$('html,body').animate({
						scrollTop: $('.svgparentTag').offset().top - ($(window).height() - options.height) / 2
					}, 200);
					// $(document).animate({ scrollTop: $('.svgparentTag').offset().top - ( $(window).height() - options.height ) / 2  }, 200);


					var link = d3.select('svg.svgparentTag').selectAll(".link")
					link.style("opacity", "0");
					d3.selectAll(".g_node, .link, .changeColor").transition().duration(2000).style("opacity", 1);
				}
				// empty the result array
				result = [];
			}



			//$('#search').live("keypress",function(e){
			$('body').on('keypress', '#search', function (e) {
				if (e.keyCode == 13) {
					$('#searchnode').trigger('click');
					return false;
				}
			});
			/*$(window).keyup(function(event){
				if(event.keyCode == 13){
					$('#searchnode').trigger('click');
					return false;
				}
			});*/

			$("#searchnode").mousedown(function () {
				mousedownsearch = true;
			});

			var drag = force
				.drag()
				.on("drag", dragged)
				.on("dragstart", dragStart)
				.on("dragend", dragEnd);

			//Force drag event
			var selectedItem, selectedItemX, selectedItemY;

			function dragStart(d) {

				d3.event.sourceEvent.stopPropagation();
				d3.select(this).classed("fixed", d.fixed = true);
				if (d3.select(".tooltip")) {
					d3.select(".tooltip").remove();
				}
				d3.select(this).style('cursor', 'move');


			}

			function dragged(d) {

				if (d3.select(".tooltip")) {
					d3.select(".tooltip").remove();
				}

				selectedItem = d3.transform(d3.select(this).attr("transform"));

				var bbox = d3.select(this).node().getBBox(),
					bbox_width = bbox.width * scaleZ - 10,
					bbox_height = bbox.height * scaleZ - 10;
				force.drag().origin(function () {
					t = selectedItem.translate;
					return {
						x: t[0],
						y: t[1]
					};
				}).on("drag.force", function () {
					d3.select(this).attr("transform", "translate(" + d3.event.dx + "," + d3.event.dy + ")");
				});
				if (d3.event.sourceEvent.pageX <= bbox_width || d3.event.sourceEvent.pageX >= options.width + options.margin.left + options.margin.right - bbox_width || d3.event.sourceEvent.pageY <= bbox_height || d3.event.sourceEvent.pageY >= options.height + options.margin.top + options.margin.bottom - bbox_height) {

					force.stop();

				} else {
					d.px += d3.event.dx;
					d.py += d3.event.dy;
					d.x += d3.event.dx;
					d.y += d3.event.dy;
					force.resume();
				}

				force.tick();
			}

			function dragEnd(d) {

				try {
					moveEnd(d); //user defind method
				} catch (e) {
					//console.log(e);
				}
				d3.select(this).style('cursor', 'pointer');
				force.tick();
				force.resume();


			}


			var path = d3.select('.pitch').append("svg:g").selectAll("path.marker")
				.data(force.links())
				.enter()
				.append("svg:path")
				.attr("class", "link")
				.attr("stroke-dasharray", "0")
				.attr("stroke-linecap", "round")
				.style("stroke-width", function (d) {
					return 1;
				})
				.attr("transform", function (d) {
					return "translate(" + movementX + "," + movementY + ")";
				});

			path.filter(function (d) {
				return d.arrow == true;
			}).attr("marker-mid", function (d) {
				return "url(#BLUE)";
			})

			// -- draggable
			if (options.draggable) {


				var groupNodes = d3.select('.pitch')
					.selectAll('g.g_node')
					.data(this.nodes)
					.enter()
					.append('g')
					.classed('g_node', true)
					.attr('style', function (d) {
						if (d.cursor) {
							return "cursor:pointer !important;"
						} else {
							return "cursor:default !important;"
						}
					})
					.attr("id", function (d, i) {
						return "nodeID-" + i;
					})
					.attr("index", function (d, i) {
						return i;
					})
					.attr("transform", function (d) {
						return "translate(" + movementX + "," + movementY + ")";
					}).call(drag);

			} else {
				var dargEvent = d3.behavior.drag().on('dragstart', function () {
					d3.event.sourceEvent.stopPropagation();
				});
				var groupNodes = d3.select('.pitch')
					.selectAll('g.g_node')
					.data(this.nodes)
					.enter()
					.append('g')
					.classed('g_node', true)
					.attr('style', function (d) {
						if (d.cursor) {
							return "cursor:pointer !important;"
						} else {
							return "cursor: default !important;"
						}
					})
					.attr("id", function (d, i) {
						return "nodeID-" + i;
					})
					.attr("index", function (d, i) {
						return i;
					})
					.attr("transform", function (d) {
						return "translate(" + movementX + "," + movementY + ")";
					}).call(dargEvent);

			}
			//Group items;
			var groupBoxProps = {
				width: 80,
				height: 57,
				borderRadius: 3
			};
			var componentList = {
				width: 92,
				height: 110,
				listHeight: 22
			};
			var navigationButton = {
				width: 8,
				height: 8,
				positionLeft: 5,
				positionRight: 5
			};
			
			var defaultPagingIndex = options.pageNoTopoValt; //SET INI paging Index value
			var indexvalue = !Ext.isEmpty(defaultPagingIndex) ? defaultPagingIndex : 0;
			var groupItems = groupNodes.append('g').attr('class', 'inner_grp');
		
			
			groupItems.filter(function (d) {
				return d.isGroup;
			}).append('path').attr("d", function (d) {
				return drawRect(((movementX) - (groupBoxProps.width / 2)), ((movementY) - (groupBoxProps.height / 2)), groupBoxProps.width, groupBoxProps.height, groupBoxProps.borderRadius, groupBoxProps.borderRadius, groupBoxProps.borderRadius, 0, 0);
			}).attr('class', function () {
				return 'grp_items';
			});

			var grpComponent = groupItems.append('g').attr('class', function (d,i) {
				if (!d.isGroup) {
						d3.select(this).remove();
						return 'hidden';
					} else {
						return '';
					}
				
			});
			grpComponent.append('path').attr("d", function (d) {
				return drawRect(((movementX) - (groupBoxProps.width / 2)), ((movementY) + (groupBoxProps.height / 2)), groupBoxProps.width, 17, groupBoxProps.borderRadius, 0, 0, groupBoxProps.borderRadius, groupBoxProps.borderRadius);
			}).attr('class', function (d,i) {
				if (!d.isGroup) {
						return 'grp_componenetLabel hidden';
					} else {
						return 'grp_componenetLabel';
					}
				
			});

			var grpText = grpComponent.append('text').text(function (d) {
					var label = 'components';
					if (d.groupLength == 0) {
						var label = 'component';
					}
					if (!d.isGroup) {
						return "";
					} else {
						return d.groupLength + ' ' + label;
					}

				})
				.attr("text-anchor", "middle")
				.attr("transform", function (d) {
					return "translate(" + movementX + "," + ((movementY) + (groupBoxProps.height / 2) + 11) + ")";
				}).attr('class', 'componenetlabel');

			grpComponent.on('click', function (d, i) {
				if (!Ext.isEmpty(Ext.getCmp('alarmPopup'))) {
					Ext.getCmp('alarmPopup').close();
				}
				loadGroup(i, 0, 'reset');
				saveGroupOpenforMonitor(i, 0);
			}).on('mouseenter',function(d,i){
					d3.select(this).select('.componenetlabel')
					.transition()
					.style('font-size', '8.5px')
					.duration(500);
			}).on('mouseleave',function(d,i){
					d3.select(this).select('.componenetlabel')
					.transition()
					.style('font-size', '8px')
					.duration(500);
			});


			//load paging 
			function loadGroup(grpindex, pageIndex, action) {

				var chunkLength = 5,
					check = _.chunk(graph.rootJson.nodes[grpindex]['groupItems'], chunkLength),
					checkLength = check.length,
					defaultCheckLength = check[0].length,
					groupLength = graph.rootJson.nodes[grpindex]['groupItems'].length,
					perDefinedTextInfo = [],
					pagesof = 1,
					record_per_page = 0,
					parentIndex = grpindex;
				// Preparing the paging textInfo

				for (var j = 0; j < checkLength; j++) {
					record_per_page += check[j].length;
					if (j == 0) {
						pagesof = 1;
						starts = true;
					} else {
						pagesof = pagesof + check[j].length;
						starts = false;
					}
					var page = (j == checkLength - 1 ? groupLength - check[checkLength - 1].length + 1 : pagesof);
					var totalList = record_per_page;
					perDefinedTextInfo.push({
						"page": "Showing " + page + "-" + totalList + " of " + groupLength + ""
					});
				}
				if (!d3.select('.listGrp').empty()) {
					d3.select('.listGrp').remove();
				}

				var listGrp = d3.select('#nodeID-' + parentIndex).append('g').attr('class', 'listGrp').attr('id', function (d, k) {
					return 'groupComponents-' + parentIndex;
				}).style('visibility','hidden').style("opacity", 0);

				listGrp.append('path').attr("d", function (d) {
					return drawRect((movementX - (componentList.width / 2)), ((movementY) - (componentList.height / 2)), componentList.width, componentList.height, groupBoxProps.borderRadius, groupBoxProps.borderRadius, groupBoxProps.borderRadius, 0, 0);
				}).attr('class', function () {
					return 'grp_items';
				});


				//Pagination 
				listGrp.append('path').attr("d", function (d) {
					return drawRect((movementX - (componentList.width / 2)), ((movementY) + (componentList.height / 2)), componentList.width, 15, groupBoxProps.borderRadius, 0, 0, groupBoxProps.borderRadius, groupBoxProps.borderRadius);
				}).attr('class', function () {
					return 'panging_grp_items';
				});
				listGrp.moveToFront();
				// close 
				var closeBt = listGrp.append('image')
					.attr("xlink:href", function () {
						return "/final/images/" + graph.rootJson.paper.skin + "/close_details.svg";
					})
					.attr("x", "" + ((movementX + (componentList.width / 2) - 12)) + "")
					.attr("y", "" + ((movementY - componentList.height / 2) - 10) + "")
					.attr('height', 10)
					.attr('width', 10).attr('class', 'close').attr('id', function (d, k) {
						return 'closeDetails-' + k;
					});

				closeBt.on('click', function (d, c) {

					//d3.select('#groupComponents-' + parentIndex).remove();
					d3.select('#groupComponents-' + parentIndex).transition().duration(500).style("opacity", 0).each("end", function(){
						d3.select('#groupComponents-' + parentIndex).remove();
					});

					saveGroupOpenforMonitor("AllClosed", 0);
					//window.parent.isOpen = false;
				});

				var pagingInfo = listGrp.append('text').attr("transform", function (d) {
					return "translate(" + movementX + "," + ((movementY + 12) + ((componentList.height / 2) - 2)) + ")";
				}).attr('text-anchor', 'middle').attr('class', 'pagingText');



				var loadPagingItems = function (arr, index) {
					if (d3.select('#groupComponents-' + parentIndex).selectAll('.listitems')) {
						d3.select('#groupComponents-' + parentIndex).selectAll('.listitems').remove();
					}
					
					if (!Ext.isEmpty(perDefinedTextInfo[index])) {
						pagingInfo.text(function () {
							return perDefinedTextInfo[index].page;
						});
					} else {
						pagingInfo.text(function () {
							return perDefinedTextInfo[0].page;
						});
					}

					var grparray = "";
					if (!Ext.isEmpty(arr[index])) {
						grparray = arr[index];
					} else {
						grparray = arr[0];
					}
					grparray.forEach(function (value, index) {
						
						var list = listGrp.append('g').attr("transform", function (d) {
							return "translate(" + (movementX - (componentList.width / 2)) + "," + ((movementY - (componentList.height / 2)) + (componentList.listHeight * index)) + ")";
						}).attr('class', 'listitems').attr('data-qtip', value.componentName);

						if (index == 0) {
							list.append('path').attr("d", function (d) {
								return drawRect(0, 0, componentList.width, 22, 3, 3, 3, 0, 0);
							}).attr('class', 'grp_list');
						} else {
							list.append('rect').attr('width', componentList.width).attr('height', componentList.listHeight).attr('class', 'grp_list');
						}
						var componentIconDim = 14;
						list.append("image")
							.attr("class", "componentIcon")
							.attr("xlink:href", function (d) {
								return value.componentIcon;
							})
							.attr("width", function (d) {
								return componentIconDim;
							})
							.attr("height", function (d) {
								return componentIconDim;
							})
							.attr("transform", function (d) {
								return "translate(" + 5 + "," + (15 - (componentList.listHeight / 2)) + ")";
							});

						list.append("image")
							.attr("class", "stateIcon")
							.attr("xlink:href", function (d) {
								return "/final/images/" + graph.rootJson.paper.skin + "/" + value.componentState + ".svg";
							})
							.attr("width", function (d) {
								return 9;
							})
							.attr("height", function (d) {
								return 9;
							})
							.attr("transform", function (d) {
								return "translate(" + componentIconDim + "," + (22 - (componentList.listHeight / 2)) + ")";
							});
						list.append('text').text(function (d) {
							return textTrim(value.componentName, 14);
						}).attr("transform", function (d) {
							return "translate(" + (componentIconDim + 10) + "," + (componentList.listHeight / 2) + ")";
						}).attr('dy', 3).style({'font-size':'7px','font-weight': '400'});

						//group go to layer model
						list.on('click', function (d) {
							if (d3.event.defaultPrevented) return;
							window.parent.location = value.linktoLayermodel;
						});

					});

				};

				// default load
				if (action == 'reset') {
					indexvalue = 0;
					loadPagingItems(check, indexvalue);
				} else {
					loadPagingItems(check, indexvalue);
				}


				//pagingInfo.text(function () {
				//return perDefinedTextInfo[indexvalue].page;
				//});
				//var tm = new Ext.util.TextMetrics();
				var previousIndex = function (arr, index) {
					loadPagingItems(arr, index);
					/*if(tm.getWidth(perDefinedTextInfo[index].page) > 100){
						pagingInfo.style('font-size','6px');
					}else{
						pagingInfo.style('font-size','7px');
					}*/
					
				};

				var nextIndex = function (arr, index) {
					loadPagingItems(arr, index);
					/*
					if(tm.getWidth(perDefinedTextInfo[index].page) > 100){
						pagingInfo.style('font-size','6px')
					}else{
						pagingInfo.style('font-size','7px');
					}*/
					
				};

				//leftarrow
				listGrp.append('image')
					.attr('class', 'next')
					.attr("xlink:href", function () {
						return "/final/images/" + graph.rootJson.paper.skin + "/leftarrow.svg";
					})
					.attr("x", "" + (movementX - (componentList.width / 2) + 3) + "")
					.attr("y", "" + (movementY + (componentList.height / 2) + 4) + "")
					.attr('height', navigationButton.height)
					.attr('width', navigationButton.width).on('click', function () {
						indexvalue--;
						if (indexvalue == 0) {
							d3.select('#groupComponents-' + parentIndex).select('.previousDisable').remove();
							//leftarrow
							listGrp.append('image')
								.attr("xlink:href", function () {
									return "/final/images/" + graph.rootJson.paper.skin + "/leftarrowDisabled.svg";
								})
								.attr("x", "" + (movementX - (componentList.width / 2) + 3) + "")
								.attr("y", "" + (movementY + (componentList.height / 2) + 4) + "")
								.attr('height', navigationButton.height)
								.attr('width', navigationButton.width).attr('class', 'nextDisable');
						}
						if (indexvalue == -1) {
							return;
						} else {
							d3.select('#groupComponents-' + parentIndex).select('.previousDisable').remove();
							previousIndex(check, indexvalue);
						}
						//console.log('indexvalue---per', indexvalue)
						saveGroupOpenforMonitor(parentIndex, indexvalue);
					});




				//rightarrow
				listGrp.append('image')
					.attr("xlink:href", function () {
						return "/final/images/" + graph.rootJson.paper.skin + "/rightarrow.svg";
					})
					.attr("x", "" + (movementX + ((componentList.width / 2) - 10)) + "")
					.attr("y", "" + (movementY + ((componentList.height / 2) + 4)) + "")
					.attr('class', 'previous')
					.attr('height', navigationButton.height)
					.attr('width', navigationButton.width).on('click', function (d) {
						indexvalue++;
						//rightarrow
						if (indexvalue == checkLength - 1) {
							d3.select('#groupComponents-' + parentIndex).select('.nextDisable').remove();
							listGrp.append('image')
								.attr("xlink:href", function () {
									return "/final/images/" + graph.rootJson.paper.skin + "/rightarrowDisabled.svg";
								})
								.attr("x", "" + (movementX + ((componentList.width / 2) - 10)) + "")
								.attr("y", "" + (movementY + ((componentList.height / 2) + 4)) + "")
								.attr('height', navigationButton.height)
								.attr('width', navigationButton.width).attr('class', 'previousDisable');


						}
						if (indexvalue == checkLength) {
							return;
						} else {
							d3.select('#groupComponents-' + parentIndex).select('.nextDisable').remove();
							nextIndex(check, indexvalue);

						}

						saveGroupOpenforMonitor(parentIndex, indexvalue);
					});
				//default disable
				if (groupLength < chunkLength) {
					listGrp.append('image')
						.attr("xlink:href", function () {
							return "/final/images/" + graph.rootJson.paper.skin + "/leftarrowDisabled.svg";
						})
						.attr("x", "" + (movementX - (componentList.width / 2) + 3) + "")
						.attr("y", "" + (movementY + (componentList.height / 2) + 4) + "")
						.attr('height', navigationButton.height)
						.attr('width', navigationButton.width).attr('class', 'nextDisable');
					listGrp.append('image')
						.attr("xlink:href", function () {
							return "/final/images/" + graph.rootJson.paper.skin + "/rightarrowDisabled.svg";
						})
						.attr("x", "" + (movementX + ((componentList.width / 2) - 10)) + "")
						.attr("y", "" + (movementY + ((componentList.height / 2) + 4)) + "")
						.attr('class', 'previous')
						.attr('height', navigationButton.height)
						.attr('width', navigationButton.width).attr('class', 'previousDisable');
				}

				if (indexvalue == 0) {
					//leftarrow
					listGrp.append('image')
						.attr("xlink:href", function () {
							return "/final/images/" + graph.rootJson.paper.skin + "/leftarrowDisabled.svg";
						})
						.attr("x", "" + (movementX - (componentList.width / 2) + 3) + "")
						.attr("y", "" + (movementY + (componentList.height / 2) + 4) + "")
						.attr('height', navigationButton.height)
						.attr('width', navigationButton.width).attr('class', 'nextDisable');
				} else if ((checkLength - 1) == defaultPagingIndex) {
					//Rightarrow
					listGrp.append('image')
						.attr("xlink:href", function () {
							return "/final/images/" + graph.rootJson.paper.skin + "/rightarrowDisabled.svg";
						})
						.attr("x", "" + (movementX + ((componentList.width / 2) - 10)) + "")
						.attr("y", "" + (movementY + ((componentList.height / 2) + 4)) + "")
						.attr('class', 'previous')
						.attr('height', navigationButton.height)
						.attr('width', navigationButton.width).attr('class', 'previousDisable');
				} else {
					//todo
				}
				listGrp.transition().duration(500).style('visibility','visible').style("opacity", 1);
				$(document).on('keyup',function(evt) {
					if (evt.keyCode == 27) {
					   d3.select('#groupComponents-' + parentIndex).transition().duration(500).style("opacity", 0).each("end", function(){
							d3.select('#groupComponents-' + parentIndex).remove();
						});

						saveGroupOpenforMonitor("AllClosed", 0);
					}
				});
			}

			var patchx = groupNodes.filter(function (d) {
					return !d.isGroup;
				}).append('svg:circle')
				.attr('class', 'node_patch_x')
				.attr('r', 25)
				.attr('fill', function () {
					var color = graph.rootJson.paper.skin == "Dark" ? "#404040" : "#ffffff"; //default	
					return color;

				})
				.attr("transform", function (d) {
					return "translate(" + (movementX + 5) + "," + (movementY - 5) + ")";
				});
			var patch = groupNodes.filter(function (d) {
					return !d.isGroup;
				}).filter(function (d) {
					return !d.isGroup;
				}).append('svg:circle')
				.attr('class', 'node_patch')
				.attr('r', 30)
				.attr('fill', function () {
					var color = graph.rootJson.paper.skin == "Dark" ? "#404040" : "#ffffff"; //default	
					return color;

				})
				.attr('stroke', function () {
					var color = graph.rootJson.paper.skin == "Dark" ? "#404040" : "#ffffff"; //default
					return color;
				})
				.attr("transform", function (d) {
					return "translate(" + (movementX + 5) + "," + (movementY - 5) + ")";
				}).style('display', 'none').style("opacity", 0);
			var patch2 = groupNodes.filter(function (d) {
					return !d.isGroup;
				}).append('svg:circle')
				.attr('class', 'node_patch')
				.attr('r', 25)
				.attr('fill', function () {
					var color = graph.rootJson.paper.skin == "Dark" ? "#404040" : "#ffffff"; //default	
					return color;

				})
				.attr('stroke', function () {
					var color = graph.rootJson.paper.skin == "Dark" ? "#404040" : "#ffffff"; //default
					return color;
				})
				.attr("transform", function (d) {
					return "translate(" + (movementX + 5) + "," + (movementY - 5) + ")";
				}).style('display', 'none').style("opacity", 0);



			//drawRect(((movementX) - (groupBoxProps.width/2)), ((movementY) - (groupBoxProps.height/2)), groupBoxProps.width, groupBoxProps.height, groupBoxProps.borderRadius, groupBoxProps.borderRadius, groupBoxProps.borderRadius, 0, 0); 			
			var serverIcons = groupNodes
				.append('svg:image')
				.attr('class', 'serverimg')
				.attr('height', function (d) {
					return !d.isGroup ? 48 : 30;
				})
				.attr('width', function (d) {
					return !d.isGroup ? 48 : 30;
				})
				.attr("xlink:href", function (d) {
					return d.cImage_url
				}).attr("x", function (d) {

					if (!d.isGroup) {
						return movementX - 20;
					} else {
						return ((movementX) - (groupBoxProps.width / 2)) + 24;
					}

				}).attr("y", function (d) {

					if (!d.isGroup) {
						return movementY - 30;
					} else {
						return movementY - 28;
					}

				}).attr('data-qtip', function (d, i) {
					//return d.cType+"</br>"+d.cName;
					if (d.cType != undefined && d.cType != null && d.cName != undefined && d.cType != null && d.cType != 'user')
						return d.cType + "</br>" + d.cName;
				});

			//Here you move the nodes;
			var clickedOnce = false;

			serverIcons.filter(function (d) {
				return d.linktoLayermodel;
			}).on('click', function (d) {
				if (d3.event.defaultPrevented) return;
				if (timer) clearTimeout(timer);
				timer = setTimeout(function () {

					window.parent.location = d.linktoLayermodel;
				}, 250);


			});
			serverIcons.on('dblclick', connectedNodes);

			/*groupNodes.append("title").text(function(d) {
			    return d.cName;
			});*/

			/*var textStroke = groupNodes.append("text").each(function (d) {
        var arr = d.cName.split(" ");
        if (arr != undefined) {
            for (i = 0; i < arr.length; i++) {
                d3.select(this).append("tspan")
                    .text(arr[i])
                    .attr("dy", i ? "1.2em" : 0)
                    .attr("x", 0)
                    .attr("text-anchor", "middle")
                    .attr("class", "tspan0" + i);
            }
        }
    }).attr("dy","0.35em").attr("class", "componentname_stroke").attr("transform", function(d) {
                return "translate(" + movementX + "," + (movementY +43) + ")";
            });*/
			//Here you move the nodes;
			var groupText = groupNodes.append('g')
				.attr('class', 'groupText')
				.attr("transform", function (d) {
					return "translate(0,4)";
				});
			var texts = groupText.append("text").attr("class", function (d) {
					if (!d.isGroup) {
						return "componentname";
					} else {
						return "componentname group";
					}

				}).each(function (d) {
					var arr = d.cName.split(" ");
					if (arr != undefined) {
						for (i = 0; i < arr.length; i++) {
							d3.select(this).append("tspan")
								.text(arr[i])
								.attr("dy", i ? "1.2em" : 0)
								.attr("x", 0)
								.attr("class", "tspan0" + i);
						}
					}
				}).attr("text-anchor", "middle")
				.text(function (d) {
					//return d.cType;
					return textTrim(d.cName, 18);
				})
				.attr('data-qtip', function (d, i) {
					return d.cName;
				})
				.attr("transform", function (d) {
					return (!d.isGroup) ? "translate(" + movementX + "," + (movementY + 45) + ")" : "translate(" + movementX + "," + (movementY + 20) + ")";
					// return "translate(" + movementX + "," + (movementY + 45) + ")";
				}); //.style('filter', 'url(#textBg)');

			/*Adding Click fn also to Text*/
			texts.filter(function (d) {
				return d.linktoLayermodel;
			}).on('click', function (d) {
				if (d3.event.defaultPrevented) return;
				if (timer) clearTimeout(timer);
				timer = setTimeout(function () {
					window.parent.location = d.linktoLayermodel;
				}, 250);
			});

			texts.on('dblclick', connectedNodes);




			/*var userTextStroke = textStroke.filter(function(d) {
                return d.cName === 'User'
            }).attr('class', 'userNode').style('display','none');*/

			var userText = texts.filter(function (d) {
				return d.cName === 'User';
			}).attr('class', 'userNode').style('display', 'none');


			/*var componentTypeStroke = groupNodes.append("text").attr("class", "componenttype_stroke").attr("text-anchor", "middle").text(function(d) {
                return d.cType;
            }).attr("transform", function(d) {
                return "translate(" + movementX + "," + (movementY +30) + ")";
            });*/
			function textTrim(string, maxLength) {
				if (!string) return string;
				if (maxLength < 1) return string;
				if (string.length <= maxLength) return string;
				if (maxLength == 1) return string.substring(0, 1) + '...';

				var midpoint = Math.ceil(string.length / 2);
				var toremove = string.length - maxLength;
				var lstrip = Math.ceil(toremove / 2);
				var rstrip = toremove - lstrip;
				return string.substring(0, midpoint - lstrip) + '...' +
					string.substring(midpoint + rstrip);
			}
			var componentType = groupText.append("text")
				.attr("class", function (d) {
					if (!d.isGroup) {
						return "componenttype";
					} else {
						return "componenttype group";
					}
				})
				.attr("text-anchor", "middle")
				.text(function (d) {
					return textTrim(d.cType, 18);
				})
				.attr('data-qtip', function (d, i) {
					return d.cType;
				})
				.attr("transform", function (d) {
					//return "translate(" + movementX + "," + (movementY + 33) + ")";
					return (!d.isGroup) ? "translate(" + movementX + "," + (movementY + 33) + ")" : "translate(" + movementX + "," + (movementY + 10) + ")";
				}); //.style('filter', 'url(#textBg)');

			/*Adding Click fn also to Text*/
			componentType.filter(function (d) {
				return d.linktoLayermodel;
			}).on('click', function (d) {
				if (d3.event.defaultPrevented) return;
				if (timer) clearTimeout(timer);
				timer = setTimeout(function () {
					window.parent.location = d.linktoLayermodel;
				}, 250);
			});
			componentType.on('dblclick', connectedNodes);

			var stateImages = groupNodes.filter(function (d) {
					return d.cStateImage_url;
				}).append("image")
				.attr("class", "stateIcon")
				.attr("xlink:href", function (d) {
					return "/final/images/" + graph.rootJson.paper.skin + "/" + d.cStateImage_url + ".svg";
				})
				.attr("width", function (d) {
					return !d.isGroup ? 14 : 14;
				})
				.attr("height", function (d) {
					return !d.isGroup ? 14 : 14;
				})
				.attr("transform", function (d) {

					var y = d3.select(d3.select(this).node().parentNode).select('.serverimg').node().getBBox().y,
						x = d3.select(d3.select(this).node().parentNode).select('.serverimg').node().getBBox().x,
						width = d3.select(d3.select(this).node().parentNode).select('.serverimg').node().getBBox().width - 5,
						height = d3.select(d3.select(this).node().parentNode).select('.serverimg').node().getBBox().height / 2;

					return (!d.isGroup) ? "translate(" + (movementX + 16) + "," + (movementY + 6) + ")" : "translate(" + (x + width) + "," + (y + height) + ")";
				}).on("click", showData);

			function showData(d) {
				if (d.AlarmPopup) {
					showAlarmListOnHover(d.AlarmPopup, d.AlarmTitle, d3.event.pageX, d3.event.pageY);
				} else {
					return false;
				}
			}


			//default Load of Group if any 
			if (!Ext.isEmpty(options.groupOpenIdTopoValt) && !(options.groupOpenIdTopoValt == "AllClosed")) {
				//console.log('parseInt(options.groupOpenIdTopoValt)',parseInt(options.groupOpenIdTopoValt))
				loadGroup(parseInt(options.groupOpenIdTopoValt), parseInt(options.pageNoTopoValt), 'onload');
			}

			// -- Tick function

			force.on("tick", function (e) {

				if (options.collideLayout) {
					groupNodes.each(collide(0.4));

				}

				groupNodes.on('mouseover', function (d) {
					if (d3.event.defaultPrevented) return;
					var color = graph.rootJson.paper.skin == "Dark" ? "#0e0e0e" : "#fffd6e"; //default			


					path.style({
						'stroke-width': function (l) {
							if (d === l.source || d === l.target) {
								return 1.2;
							} else {
								return 1;
							}
						},
						'stroke': function (l) {
							if (d === l.source || d === l.target) {
								return "#909090";
							} else {
								return "#909090";
							}
						}
					}).attr('class', function (l) {
						if (d === l.source || d === l.target) {
							return "changeColor";
						} else {
							return "defalutArrow";
						}
					}, true).style("stroke-dasharray", function (l) {
						if (d === l.source || d === l.target) {
							return ("3, 3");
						} else {
							return ("0, 0");
						}

					});

					d3.selectAll('.changeColor').filter(function (d) {
						return d.arrow == true;
					}).style({
						"marker-mid": "url(#BLACK)"
					});

					d3.select(this).selectAll('.node_patch').each(function (d, i) {
						if (i == 0) {
							d3.select(this).transition().duration(500).attr('fill', function () {
								var color = graph.rootJson.paper.skin == "Dark" ? "#474c4f" : "#e7f5fb"; //default	
								return color;
							}).attr('stroke', function () {
								var color = graph.rootJson.paper.skin == "Dark" ? "#51656c" : "#d6effb"; //default	
								return color;
							}).style('display', 'block').style("opacity", 1);
						} else {
							d3.select(this).transition().duration(400).attr('fill', function () {
								var color = graph.rootJson.paper.skin == "Dark" ? "#4e575c" : "#d2ecf8"; //default	
								return color;
							}).attr('stroke', function () {
								var color = graph.rootJson.paper.skin == "Dark" ? "#576f79" : "#b5e1f7"; //default	
								return color;
							}).style('display', 'block').style("opacity", 1);
						}
					});

				}).on('mouseout', function (d) {
					if (d3.event.defaultPrevented) return;
					//d3.select(this).select('.patch').attr("filter", null).style({'fill-opacity':'0.9','fill':null});
					//d3.select(".tooltip").remove();
					path.style('stroke-width', 1).style('stroke', '#909090').style("stroke-dasharray", function (l) {
						if (d === l.source || d === l.target) {
							return ("0, 0");
						} else {
							return ("0, 0");
						}

					});
					d3.selectAll('.changeColor').filter(function (d) {
						return d.arrow == true;
					}).style({
						"marker-mid": "url(#BLACK)"
					});

					d3.select(this).selectAll('.node_patch').transition().duration(500)
						.attr('fill', function () {
							var color = graph.rootJson.paper.skin == "Dark" ? "#444444" : "#ffffff"; //default	
							return color;

						}).attr('stroke', function () {
							var color = graph.rootJson.paper.skin == "Dark" ? "#586e79" : "#ffffff"; //default	
							return color;
						}).style('display', 'none').style("opacity", 0);
				});

				path.each(function () {
					this.parentNode.insertBefore(this, this);
				}); //IE 

				groupNodes.attr("transform", function (d) {
					//Here i create a node radius so it doesnt go offscreen
					return "translate(" + d.x + "," + d.y + ")";

				});


				path.attr("d", function (d) {
					var dx = d.target.x - d.source.x,
						dy = d.target.y - d.source.y,
						dr = Math.sqrt(dx * dx + dy * dy) / 4,
						mLx = d.source.x + dx / 2,
						mLy = d.source.y + dy / 2,
						mAx = d.source.x + dx,
						mAy = d.source.y + dy;
					if (d.source.x === d.target.x) {
						//dr = Math.sqrt(dx * dx + dy * dy) / 1.8;
						var sweep = 1;
						if (d.source.y > d.target.y) {
							sweep = 0;

						}

						return "M" +
							d.source.x + "," + d.source.y +
							"A" + dr + "," + dr +
							" 0, 0" + sweep + " " +
							d.target.x + "," + d.target.y;

					}
					return [
						"M", d.source.x, d.source.y,
						"L", mLx, mLy,
						"L", d.target.x, d.target.y

					].join(" ");

				});
				userText.style({
					'display': 'none'
				});
				//d3plus.textwrap().container(d3.select(".g_node")).draw();
			});
			// Adding background to the text
			var componentnametext = document.querySelectorAll(".componentname");
			var componenttypetext = document.querySelectorAll(".componenttype");
			var color = graph.rootJson.paper.skin == "Dark" ? "#444444" : "#ffffff";
			for (var i = 0; i < componenttypetext.length; i++) {
				if (!d3.select(componenttypetext[i]).classed('group')) {
					createSVGTextBg(componenttypetext[i], color);
				}

			}
			for (var i = 0; i < componentnametext.length; i++) {
				if (!d3.select(componentnametext[i]).classed('group')) {
					createSVGTextBg(componentnametext[i], color);
				}

			}

			var padding = 250, // separation between circles
				radius = 2,
				that = this;

			function collide(alpha) {
				var quadtree = d3.geom.quadtree(that.nodes);

				return function (d) {
					var rb = 2 * radius + padding,
						nx1 = d.x - rb,
						nx2 = d.x + rb,
						ny1 = d.y - rb,
						ny2 = d.y + rb;
					quadtree.visit(function (quad, x1, y1, x2, y2) {
						if (quad.point && (quad.point !== d)) {
							var x = d.x - quad.point.x,
								y = d.y - quad.point.y,
								l = Math.sqrt(x * x + y * y);
							if (l < rb) {
								l = (l - rb) / l * alpha;
								d.x -= x *= l;
								d.y -= y *= l;
								quad.point.x += x;
								quad.point.y += y;
							}
						}
						return x1 > nx2 || x2 < nx1 || y1 > ny2 || y2 < ny1;
					});
				};
			}

		});

	}

	$.fn.reusableSVG = function () {

		// -- glow while drag

		var defs = d3.select('svg.svgparentTag').append("defs");
		defs.append("filter")
			.attr("id", "blur_patch")
			.attr("x", "-20")
			.attr("y", "-40")
			.attr("width", "60")
			.attr("height", "60")
			.append("feGaussianBlur")
			.attr("in", "SourceGraphic")
			.attr("stdDeviation", "15").append("feOffset")
			.attr("dx", "2").attr("dy", "2").append("feComponentTransfer").append("feFuncA")
			.attr("type", "linear").attr("slope", "0.2")
			.append("feMerge").append("feMergeNode").attr("in", "SourceGraphic")
			.attr("type", "linear").attr("slope", "0.2");





		d3.select('svg.svgparentTag')
			.selectAll("marker")
			.data([{
				"name": "BLACK",
				"color": "#909090"
			}, {
				"name": "BLUE",
				"color": "#909090"
			}])
			.enter().append("svg:marker")
			.attr("id", function (d) {
				return d.name
			})
			.attr("fill", function (d) {
				return d.color;
			})
			.attr("viewBox", "0 -5 10 10")
			.attr("markerWidth", 6)
			.attr('markerUnits', 'userSpaceOnUse')
			.attr("refX", 0)
			.attr("refY", 0)
			.attr("markerHeight", 8)
			.attr("orient", "auto")
			.append("svg:path")
			.attr("d", "M0,-7L10,0L0,7");
	}

	$.fn.renderSvg = function (options) {

		var options = $.extend({}, settings, options);
		var dom = d3.select(options.renderTo);


		this.renderDiagram(options);
		//-- header
		if (options.fromPage != null) {
			header = d3.select(options.renderTo).append("div").attr('class', 'header');
			if (options.isShowSegmenrServiceHeader == true) {
				header.html("<div class='Theader'><div>" + options.fromPage + ":</div><div class='t_titlefont' style='margin-top:10px'><div style='float:left' class='" + options.segmentStateCls + "'></div><div class='t_titlefont' style='float:left;margin:3px'>" + options.segmentName + "</div><div style='clear:both'></div></div></div>");
			} else {
				header.html("<div class='Theader'><div class='t_titlefont'><div style='float:left' class='" + options.segmentStateCls + "'></div><div class='t_titlefont' style='float:left;margin:3px'>" + options.segmentName + "</div><div style='clear:both'></div></div></div>");
			}
		}
		svg = d3.select(options.renderTo)
			.append('svg')
			.attr("viewBox", "0 0 " + options.width + " " + options.height)
			.attr("preserveAspectRatio", "xMinYMin")
			.attr('class', 'svgparentTag')
			.attr("width", options.width + options.margin.left + options.margin.right)
			.attr("height", options.height + options.margin.top + options.margin.bottom)
			.append("g")
			.attr('class', 'pitch')
			.attr("transform", "translate(" + options.margin.left + "," + options.margin.top + ")");


		// -- glow while drag 
		this.reusableSVG();

		// -- pre Loading text 
		loading = svg.append("text").attr({
			x: options.width / 2,
			y: options.height / 2
		}).text(options.loadingText);



		if (options.zoom) {
			d3.select(options.renderTo).select('svg').remove();

			if (options.initialX == null || options.initialY == null) {
				options.initialX = options.width / 2;
				options.initialY = options.height / 2;
			}
			var xz = d3.scale.linear()
				.domain([-options.width / 2, options.width / 2])
				.range([0, options.width]);

			var yz = d3.scale.linear()
				.domain([-options.height / 2, options.height / 2])
				.range([options.height, 0]);

			var hideText = function (value, scale) {
				if (value > scale) {
					d3.selectAll('text').transition().style("opacity", 0);
					Ext.defer(function () {
						d3.selectAll('.textbg').transition().style("opacity", 0);
					}, 200)

				} else {
					if (scale > 1.5) {
						//d3.selectAll('.componenttype').style('font-family','Roboto-Regular')
						//d3.selectAll('.componenttype').style('font-weight','100')
						//d3.selectAll('.componenttype').style('text-shadow','0px 0px 0px')
						//d3.selectAll('.componentname').style('font-family','Roboto-Regular')
						//d3.selectAll('.componentname').style('font-weight','100')
						//d3.selectAll('.componenttype').style('font-size','10')
						//d3.selectAll('.componentname').style('font-size','9')
					} else {
						//d3.selectAll('.componenttype').style('font-family','Roboto-Regular')
						//d3.selectAll('.componenttype').style('font-weight','100')
						//d3.selectAll('.componenttype').style('text-shadow','0px 0px 0px')
						//d3.selectAll('.componentname').style('font-family','Roboto-Regular')
						//d3.selectAll('.componentname').style('font-weight','100')
						////d3.selectAll('.componenttype').style('font-size','11')
						//d3.selectAll('.componentname').style('font-size','10')
					}
					d3.selectAll('text').transition().style("opacity", 1);
					Ext.defer(function () {
						d3.selectAll('.textbg').transition().style("opacity", 1);
					}, 200)
				}
			}


			$(document).mousedown(function () {
				d3.select('.pitch').style("cursor", "url('/final/images/closedhand.cur'),default");
			});
			$(document).mouseup(function () {
				d3.select('.pitch').style("cursor", "url('/final/images/openhand.cur'),default");
			});
			$(document).mousemove(function () {
				d3.select('.pitch').style("cursor", "url('/final/images/openhand.cur'),default");
			});
			// -- Zoom function 
			var zoomFn = function () {
				//Setting up localStorage
				if (d3.select(".tooltip")) {
					d3.select(".tooltip").remove();
				}
				svgScale.scale = d3.event.scale;
				svgScale.transform = d3.event.translate;
				localStorage.setItem('svgScale', JSON.stringify(svgScale));

				if (typeof (JSON.parse(localStorage.getItem('svgScale')).transform) != 'undefined' &&
					typeof (JSON.parse(localStorage.getItem('svgScale')).scale) != 'undefined') {

					translateZ = JSON.parse(localStorage.getItem('svgScale')).transform;
					scaleZ = JSON.parse(localStorage.getItem('svgScale')).scale;

				} else {

					translateZ = options.initialX + "," + options.initialY;
					scaleZ = options.default_zoom;
				}
				var scale = 1 / zoom.scale();

				svg.select('.zoomrect').attr("transform", "translate(" + translateZ + ")scale(" + scaleZ + ")");
				//zoom.center([options.width/2,options.height/2]);
				$(".slider").slider("value", scaleZ);
				//hideText(1,scaleZ);
				svg.attr("transform", "translate(" + translateZ + ")scale(" + scaleZ + ")");
			};

			var zoomStartFn = function () {
				if (slider_tooltip) {
					slider_tooltip.text(Math.round(scaleZ * 100) + '%');
					slider_tooltip.show().delay(5000).fadeOut('slow');
				}
				
					
					if(d3.selectAll('.grp_items')){
						var borderScale = d3.scale.linear().domain([0.5*0.1, 0.5*1]).range([0.5*0.1, 0.5*0.5]);
						d3.selectAll('.grp_items').style('stroke-width',borderScale(0.5*scaleZ));
						d3.selectAll('.grp_list').style('stroke-width',borderScale(0.5*scaleZ));
					}
			}

			var zoomEndFn = function () {
				try {
					if (scaleZ != null && translateZ != null && !isNaN(scaleZ) && !isNaN(translateZ[0])) {
						if (translateZ[0] != null && translateZ[1] != null) {
							saveZoomPositionsforMonitor("zoom", scaleZ, translateZ);
						}
					}
				} catch (w) {
					//console.log("w=-=-=->>",w)
				}
			}
			var zoom = options.zoomObj
				// .x(xz)
				//.y(yz)
				.scaleExtent([options.min_zoom, options.max_zoom])
				.translate([options.initialX, options.initialY])
				//.center([options.width / 2, options.height / 2])
				.scale(scaleZ)
				.on("zoom", zoomFn)
				.on("zoomstart", zoomStartFn)
				.on("zoomend", zoomEndFn)
				.size([options.width / 2, options.height / 2]);




			if (zoomFn) {
				
				if (localStorage.getItem('svgScale') === null) {
					translateZ = options.initialX + "," + options.initialY;

					if (options.zoomLevelTopoValSet != undefined && options.zoomLevelTopoValSet != null && options.zoomLevelTopoValSet != -1)
						scaleZ = options.zoomLevelTopoValSet;
					else
						scaleZ = options.default_zoom;

					if (options.zoomLevelTopoValSet != undefined && options.zoomLevelTopoValSet != null && options.zoomLevelTopoValSet != -1 && options.translateTopoValSet != undefined && options.translateTopoValSet != null && options.translateTopoValSet.trim().length > 0 && options.translateTopoValSet.trim().length > 1) {
						var tyui = options.translateTopoValSet;
						var initialEntryX = 0;
						var initialEntryY = 0;
						if (tyui.trim().length > 1 && tyui.indexOf(",") > -1) {
							initialEntryX = tyui.substring(0, tyui.indexOf(","));
							initialEntryY = tyui.substring(tyui.indexOf(",") + 1);
						}
						translateZ = initialEntryX + "," + initialEntryY;
						zoom.translate([initialEntryX, initialEntryY]).scale(scaleZ).event(svg);
					} else {
						zoom.translate([options.initialX, options.initialY]).scale(options.default_zoom).event(svg);
					}

					//zoom.translate([options.initialX,options.initialY]).scale(options.default_zoom);
					//alert('initial');	

				} else {
					translateZ = JSON.parse(localStorage.getItem('svgScale')).transform;
					//scaleZ = JSON.parse(localStorage.getItem( 'svgScale' )).scale;
					if (options.zoomLevelTopoValSet != undefined && options.zoomLevelTopoValSet != null && options.zoomLevelTopoValSet != -1)
						scaleZ = options.zoomLevelTopoValSet;
					else
						scaleZ = JSON.parse(localStorage.getItem('svgScale')).scale;

					if (options.translateTopoValSet != undefined && options.translateTopoValSet != null && options.translateTopoValSet.trim().length > 0 && options.translateTopoValSet.trim().length > 1) {
						var tyui = options.translateTopoValSet;
						var initialEntryX = 0;
						var initialEntryY = 0;
						if (tyui.trim().length > 1 && tyui.indexOf(",") > -1) {
							initialEntryX = tyui.substring(0, tyui.indexOf(","));
							initialEntryY = tyui.substring(tyui.indexOf(",") + 1);
						}
						translateZ = initialEntryX + "," + initialEntryY;
						zoom.translate([initialEntryX, initialEntryY]).scale(scaleZ).event(svg);
					} else {
						zoom.translate(translateZ).scale(scaleZ).event(svg);
					}
					//alert('initial else');	
				}

					

			}



			var svg = d3.select(options.renderTo)
				.append('svg')
				.attr("viewBox", "0 0 " + options.width + " " + options.height)
				.attr("preserveAspectRatio", "xMidYMid meet")
				.attr('class', 'svgparentTag')
				.attr("width", options.width + options.margin.left + options.margin.right)
				.attr("height", options.height + options.margin.top + options.margin.bottom)
				.call(zoom).on("dblclick.zoom", null)
				.append("g")
				.attr('class', 'pitch')
				.attr("transform", "translate(" + translateZ + ")scale(" + scaleZ + ")")
				.on("dblclick.zoom", null).on("click.zoom", null);



			// -- glow while drag 
			this.reusableSVG();

			var rect = svg.append("rect")
				.attr("class", 'zoomrect')
				.attr("width", (options.width + options.margin.left + options.margin.right) * scaleZ)
				.attr("height", (options.height + options.margin.top + options.margin.bottom) * scaleZ)
				.attr("transform", "translate(" + [-1 * (scaleZ * options.initialX), -1 * (scaleZ * options.initialY)] + ")" + " scale(" + scaleZ + ")")
				.style("fill", "none")
				.style("pointer-events", "all");

			function interpolateZoom(translate, scale) {
				var self = this;
				return d3.transition().duration(duration).tween("zoom", function () {
					var iTranslate = d3.interpolate(zoom.translate(), translate),
						iScale = d3.interpolate(zoom.scale(), scale);

					return function (t) {
						zoom
							.scale(iScale(t))
							.translate(iTranslate(t))
							.event(svg);
					};
				}).each('end', function () {
					var timeout = window.setTimeout(function () {
						saveZoomPositionsforMonitor("zoom", scale, translate);
					}, 800);
					delete timeout;
				});
			}

			// -- zoom buttons [+][-] method
			function zoomClick() {
				var clicked = d3.event.target,
					direction = 1,
					factor = 0.2,
					target_zoom = ((options.max_zoom - options.min_zoom) / 100),
					center = [options.width / 2, options.height / 2],
					extent = zoom.scaleExtent([options.min_zoom, options.max_zoom]),
					translate = zoom.translate(),
					translate0 = [],
					l = [],
					view = {
						x: translate[0],
						y: translate[1],
						k: zoom.scale()
					};

				d3.event.preventDefault();
				direction = (this.id === 'zoom_in') ? 1 : -1;
				target_zoom = zoom.scale() * (1 + factor * direction);

				if (target_zoom < extent[0] || target_zoom > extent[1]) {
					return false;
				}

				translate0 = [(center[0] - view.x) / view.k, (center[1] - view.y) / view.k];
				view.k = target_zoom;
				l = [translate0[0] * view.k + view.x, translate0[1] * view.k + view.y];

				view.x += center[0] - l[0];
				view.y += center[1] - l[1];
				if (view.k <= options.min_zoom || view.k >= options.max_zoom) {
					$(".slider").slider("value", view.k);
					return false
				} else {

					interpolateZoom([view.x, view.y], view.k);
				}


			}


			// -- slider function
			function slideFn(value) {
				var scale = zoom.scale();
				var extent = zoom.scaleExtent();
				var newScale = value;
				if (extent[0] <= newScale && newScale <= extent[1]) {

					var t = zoom.translate();
					var c = [options.width / 2, options.height / 2];
					zoom.scale(newScale)
						.translate([c[0] + (t[0] - c[0]) / scale * newScale, c[1] + (t[1] - c[1]) / scale * newScale])
						.event(svg);

				}
			};

			function graphBounds() {

				var x = Number.POSITIVE_INFINITY,
					X = Number.NEGATIVE_INFINITY,
					y = Number.POSITIVE_INFINITY,
					Y = Number.NEGATIVE_INFINITY;
				//	item = d3.select(".g_node").node().getBBox();
				d3.select('.pitch').selectAll(".g_node").each(function (v) {
					getX = v.x - movementX;
					getY = v.y - movementY;
				
					var item = d3.select(this).node().getBBox();
					x = Math.min(x, (v.x + movementX) - item.width);
					X = Math.max(X, (v.x + movementX) + item.width);
					y = Math.min(y, (v.y + movementY) - item.height);
					Y = Math.max(Y, (v.y + movementY) + item.height);
				});
				return {
					x: x,
					X: X,
					y: y,
					Y: Y
				};
			}

			function zoomToFit() {
				var b = graphBounds();
				var w = b.X - b.x,
					h = b.Y - b.y;
				/*var cw = $(window).width() + options.margin.left + options.margin.right, 
					ch = $(window).height() + options.margin.top + options.margin.bottom;
				var s = Math.min(cw / w , ch / h);
				var tx = (-b.x * s + (cw / s - w) * s / 2) ,
				ty = (-b.y * s + (ch / s - h) * s / 2);*/
				var cw = $(window).width() + options.margin.left + options.margin.right,
					ch = $(window).height() + options.margin.top + options.margin.bottom,
					s = d3.min([Math.min(cw / w, ch / h), options.max_zoom]);
				tx = (-b.x - movementX * s + (cw / s - w) * s / 2),
					ty = (-b.y - movementY * s + (ch / s - h) * s / 2);

				if (options.layoutAlign == 'center' && options.enableFitLayout) {
					//alert("center+auto");
					var cw = ($(window).width() + options.margin.left + options.margin.right),
						ch = $(window).height() + options.margin.top + options.margin.bottom;
					s = d3.min([Math.min(cw / w, ch / h), options.max_zoom]);
					tx = (-b.x * s + (cw / s - w) * s / 2),
						ty = (-b.y * s + (ch / s - h) * s / 2);
					

				} else if (options.layoutAlign == 'left' && options.enableFitLayout) {
					//alert('left+auto');
					cw = options.width + options.margin.left + options.margin.right,
						ch = options.height + options.margin.top + options.margin.bottom;
					s = d3.min([Math.min(cw / w, ch / h), options.max_zoom]);
					tx = (-b.x * s + (cw / s - w) * s / 2),
						ty = (-b.y - movementY * s + (ch / s - h) * s / 2);

					//tx = tx - HX - LX ;

				} else if (options.layoutAlign == 'left' && options.enableFitLayout == false) {
					//alert('left+manual')
					cw = $(window).width() + options.margin.left + options.margin.right,
						ch = $(window).height() + options.margin.top + options.margin.bottom;
					s = d3.min([Math.min(cw / w, ch / h), options.max_zoom]);
					tx = (-b.x * s + (cw / s - w) * s / 2),
						ty = (-b.y - movementY * s + (ch / s - h) * s / 2);


				}

				//d3.select('svg.svgparentTag').select('.pitch').transition().duration(2000).call(options.zoomObj.scale(s)
				//.translate([parseInt(tx),parseInt(ty)]).event);
				interpolateZoom([parseInt(tx), parseInt(ty)], s);
				$(".slider").slider("value", s);
				//hideText(1,s); // -- show text
				//-- checking for scroll in window
				/*if ($(document).height() > $(window).height()) {
					 $('html,body').animate({scrollTop:0},200);
				}*/

				delete tx, ty, s, cw, ch;
			}
			var slider = dom.append('div').attr('class', 'slider');
			var slider_buttons = dom.append('div').attr('class', 'slider_buttons');
			var zoomslider_in = slider_buttons.append('button').attr('id', 'zoom_in').attr('class', 'button_zoom zoomInbt zoomtop');
			var zoomslider_out = slider_buttons.append('button').attr('id', 'zoom_out').attr('class', 'button_zoom zoomOutbt zoombottom');


			$(options.renderTo).append('<div class="ui-widget searchbox" style="margin-top:8px"><div class="iconSearchBig toposearch" title="Search"><div id="searchcom" style="display:none;position:absolute;left:-50px"><div class="searchstroke"><input id="search"/><button title="Search" type="button"  id="searchnode">&nbsp;</button></div></div></div><button id="fit" class="iconAutofit" title="Fit">&nbsp;</button></div>');
			// -- Zoom in and zoom out
			d3.selectAll('button.button_zoom').on('click', zoomClick);


			//$('.toposearch').live('click', function() {
			$('body').on('click', '.toposearch', function () {
				$("#searchcom").animate({
					left: "-145px",
				}, 100, function () {
					$('#search').focus();

				}).show();
			});
			$('#search').blur(function () {
				if (mousedownsearch) {
					mousedownsearch = false;
				} else {
					$("#searchcom").animate({
						left: "-50px",
					}, 100).hide();
				}
			});

			//$('#searchnode').live('click', function(e) {
			$('body').on('click', '#searchnode', function (e) {
				var selectedVal = $("#search").val(),
					getX, getY;
				if (selectedVal == null || selectedVal == "" || selectedVal == 'undefined') {
					//Ext.Msg.alert('Topology', 'Please enter valid component type');
					zoomToFit();
				}
				var optArray = [];
				var result = [];
				var graph = options.data;
				this.nodes = graph.rootJson.nodes;
				// WHY i =1 ? because 1 =="USER"
				for (var i = 1; i < this.nodes.length; i++) {
					optArray.push(this.nodes[i].cName, this.nodes[i].cType);
				}
				optArray = optArray.sort();
				optArray.filter(function (_item) {
					return (_item.toString().toLowerCase().indexOf(selectedVal.toLowerCase()) > -1);
				}).forEach(function (_item, i) {
					result.push(_item);
				});
				if (result.length === 0) {
					zoomToFit();
				}
			});

			//$('#fit').live('click', function() {
			$('body').on('click', '#fit', function () {
				zoomToFit();
			});

			// -- checking for auto layout and fit the zoom
			if (options.enableFitLayout == true) {
				if (zoomFn) {
					//if (localStorage.getItem('svgScale') === null && (options.zoomLevelTopoValSet == undefined || options.zoomLevelTopoValSet == null || options.zoomLevelTopoValSet == -1))
					if (options.zoomLevelTopoValSet == undefined || options.zoomLevelTopoValSet == null || options.zoomLevelTopoValSet == -1) {
						var timeout = window.setTimeout(function () {
							$("#fit").click()
						}, 800);
						delete timeout;
					}
				}

			}
			//	window.setTimeout(function(){$( "#fit" ).click()},500);
			slider_tooltip = $('<span id="tooltip" class="slider_tooltip" />').css({
				position: 'absolute',
				top: -5,
				left: 20
			}).hide();

			$(".slider").slider({
				animate: "slow",
				// range: "min",
				orientation: "vertical",
				min: options.min_zoom,
				max: options.max_zoom,
				value: scaleZ,
				step: ((options.max_zoom - options.min_zoom) / 100),
				slide: function (event, ui) {

					slider_tooltip.text(Math.round(ui.value * 100) + '%');
					slideFn(ui.value);

				}
			}).find(".ui-slider-handle").append(slider_tooltip).hover(function () {
				slider_tooltip.text(Math.round(scaleZ * 100) + '%');
				slider_tooltip.fadeIn('fast');
			}, function () {
				slider_tooltip.delay(20).fadeOut('fast');
			});

		} else {

			//console.log('false');
		}

		$(window).resize(function () {

			$('.ui-widget-content').css({
				'margin-top': $(window).height() - 180,
				'margin-left': 20
			});
			$('.slider_buttons').css({
				'margin-top': $(window).height() - 190,
				'margin-left': 20
			});

		}).resize();
	};


}(jQuery));