/*
 * raphael.zoom 0.0.3
 *
 * Copyright (c) 2009 Wout Fierens
 * Licensed under the MIT (http://www.opensource.org/licenses/mit-license.php) license.
 */
 
// initialize zoom of paper
Raphael.fn.initZoom = function(zoom) {
  this.zoom = zoom || 1;
  var elems = this.elements();
  for(element in elems){
    elems[element].initZoom(this.zoom);
  }
}

// set the zoom of all elements
Raphael.fn.setZoom = function(zoom) {
  if (!this.zoom) this.initZoom();
  var elems = this.elements();
  for(element in elems){
     if (!elems[element].zoom) elems[element].initZoom(this.zoom);
     elems[element].setZoom(zoom);
   }
  this.zoom = zoom;
}

// get all elements in the paper
Raphael.fn.elements = function() {
  var b = this.bottom,
      r = []; 
  while (b) { 
    r.push(b); 
    b = b.next; 
  }
  return r;
}

// initialize zoom of element
Raphael.el.initZoom = function(zoom) {
  var sw = parseFloat(this.attrs["stroke-width"]) || 0;
  this.zoom = {
    value: zoom,
    "stroke-width": sw
  };
  this.setStrokeWidth(sw);
  if (this.type == "text") {
    var fs = parseFloat(this.attrs["font-size"]) || 0
    this.zoom["font-size"] = fs;
    this.zoom["x"] = (parseFloat(this.attrs["x"]) || 0) / zoom;
    this.zoom["y"] = (parseFloat(this.attrs["y"]) || 0) / zoom;
    this.setFontSize(fs);
  }
}

// zoom element preserving some original values
Raphael.el.setZoom = function(zoom) {
  if (!zoom) return;
  if (!this.zoom) this.initZoom(zoom);
  // scale to zoom
  var new_zoom = zoom / this.zoom.value;
  this.scale(new_zoom, new_zoom,0,0);
  this.applyScale();
  // save new zoom
  this.zoom.value = zoom;
  this.setStrokeWidth(this.zoom["stroke-width"]);
  if (this.type == "text") {
    this.setFontSize(this.zoom["font-size"] * zoom);
    this.attr("x", this.zoom["x"] * zoom);
    this.attr("y", this.zoom["y"] * zoom);
  }
  return this;
}

// set element zoomed attributes
Raphael.el.setAttr = function() {
  if (typeof arguments[0] == "string") {
    attr = {};
    attr[arguments[0]] = arguments[1];
  } else {
    attr = arguments[0];
  }
  for(key in attr){
    switch(key) {
      case "stroke-width":
        this.setStrokeWidth(attr[key]);
      break;
      case "font-size":
        this.setFontSize(attr[key]);
      break;
      case "x":
      case "y":
        if (this.type == "text") this.zoom[key] = attr[key] / this.zoom.value;
        this.attr(key, attr[key]);
      break;
      default:
        this.attr(key, attr[key]);
      break;
    }
  }
}

// set element translation
Raphael.el.setTranslation = function(x, y) {
  if (this.type == "text")
    this.setAttr({
      x: this.attrs["x"] + x,
      y: this.attrs["y"] + y
    });
  else
    this.translate(x,y);
}

// set element zoomed stroke width
Raphael.el.setStrokeWidth = function(sw) {
  if (sw.isFloat()) {
    sw = parseFloat(sw);
    this.attr({ "stroke-width": sw * this.zoom.value });
    this.zoom["stroke-width"] = sw;
  }
  return this;
}

// set element font size
Raphael.el.setFontSize = function(fs) {
  if (fs.isFloat()) {
    fs = parseFloat(fs);
    this.attr({ "font-size": fs });
    this.zoom["font-size"] = fs / this.zoom.value;
  }
  return this;
}

// apply the current scale and reset it to 1
Raphael.el.applyScale = function() {
  this._.sx = 1;
  this._.sy = 1;
  this.scale(1, 1);
}


Number.prototype.isInt = function(){
    if (this == 0) return true;
    return parseInt(this) ? true : false;
}

Number.prototype.isFloat = function() {
    if (this == 0.0) return true;
    return parseFloat(this) ? true : false;
}

String.prototype.isInt = function() {
    if (this == "0") return true;
    return parseInt(this) ? true : false;
}
  
String.prototype.isFloat = function() {
    if (["0", "0.0"].indexOf(this) > -1) return true;
    return parseFloat(this) ? true : false;
}

Raphael.fn.connection = function (color, obj1, obj2, line, bg, lorn) {
	if (obj1.line && obj1.from && obj1.to) {
		line = obj1;
		obj1 = line.from;
		obj2 = line.to;
		lorn = line.link;
		//alert('lorn :'+lorn + " Length:"+lorn.length);
		/*var check = line.line.attr('path').toString();
		var ind1 = check.indexOf("L");
		var ind2;
		lorn='N';
		if(ind1 > 0)
		{
			ind2 = check.lastIndexOf("L");
		}
		else
		{
			//IE issue ==> While Zooming, IE replaces "L" by "l" in the path
			ind1 = check.indexOf("l");
			if(ind1 > 0)
			{
				ind2 = 	check.lastIndexOf("l");
			}
		}

		if(ind1 == ind2)
		{
			lorn = 'N';
		}
		else
		{
			lorn = 'L';
		} */
	}

	var bb1 = obj1.getBBox(),
		bb2 = obj2.getBBox();

	// For zooming the Arrows
	var zzz = document.getElementById('zoom').value;
	var zoom = 1 ;
	if(parseFloat(zzz) >=1)
	{
		zoom = parseFloat(zzz).toFixed(2) / 100;
	}
	else
	{
		zoom = parseFloat(zzz).toFixed(2);
	}

	var categoryType = 0;

	var obj1X = bb1.x;
	var obj1Y = bb1.y;
	var obj1H = bb1.height;
	var obj1W = bb1.width;

	var obj2X = bb2.x;
	var obj2Y = bb2.y;
	var obj2H = bb2.height;
	var obj2W = bb2.width;

	var x1 = obj1X + (obj1W / 2);
	var y1 = obj1Y + (obj1H / 2);
	var x2 = obj2X + (obj2W / 2);
	var y2 = obj2Y + (obj2H / 2);

	if(x1 == x2) 
	{
		//x1 = x1 + obj1W;
		//x2 = x2 + obj2W;
		categoryType = 1;
		//Draw Arc....
	}
	else if(x1 > x2)
	{
		//x2 = x2 + obj2W;
		categoryType = 2;
	}
	else
	{
		//x1 = x1 + obj1W;
		categoryType = 2;
	}

	var triangle=null;

	if(categoryType == 1)
	{
		
		var diff = Math.abs(y2 -y1) / 4;
		//y1 = y1+12*zoom;
		//y2 = y2+12*zoom;
		if(lorn == 'L')
		{
			var midX = (x1 + x2)/ 2;
			var midY = (y1 + y2)/ 2;

			var cos = 0.866;
			var sin = 0.500;
			var dx = (x2 - x1);
			var dy = (y2 - y1);
			
			//Normailze to fixed Size Arrows.
			var length = Math.sqrt(dx * dx + dy * dy);
			dx = 8 * (dx / length) * zoom;
			dy = 8 * (dy / length) * zoom;

			var pX1 = (midX + diff) + (dx * cos + dy * -sin);
			var pY1 = midY + (dx * sin + dy * cos);

			var pX2 = (midX + diff) + (dx * cos + dy * sin);
			var pY2 = midY + (dx * -sin + dy * cos);

			path =[	"M", x1, y1,
					"C", x1 + diff, y1, midX + diff , midY ,midX + diff , midY, 
					"L",midX + diff, midY,
					"L", pX1, pY1,
					"L", pX2, pY2, 
					"L",midX + diff, midY,
					"C",midX + diff, midY,x2 + diff,y2 ,x2 , y2, 
					"L",x2, y2];

			// For Arrow
			triangle = ["M", midX + diff, midY,
						"L", pX1, pY1,
						"L", pX2, pY2, 
						"L",midX + diff, midY,
						"z"];
		}
		else
		{
			path =[	"M", x1, y1,
					"C", x1 + diff, y1, x2 + diff , y2 ,x2 , y2, 
					"L",x2, y2];
			triangle = ["M", x1, y1, "z"]; //.. to avoid error while Zooming
		}
	}
	else if(categoryType == 2)
	{
		//y1 = y1+12*zoom;
		//y2 = y2+12*zoom;
		if(lorn == 'L')
		{
			var midX = (x1 + x2)/ 2;
			var midY = (y1 + y2)/ 2;

			var cos = 0.866;
			var sin = 0.500;
			var dx = (x2 - x1);
			var dy = (y2 - y1);

			//Normailze to fixed Size Arrows.
			var length = Math.sqrt(dx * dx + dy * dy);
			dx = 8 * (dx / length) * zoom;
			dy = 8 * (dy / length) * zoom;

			var pX1 = midX + (dx * cos + dy * -sin);
			var pY1 = midY + (dx * sin + dy * cos);

			var pX2 = midX + (dx * cos + dy * sin);
			var pY2 = midY + (dx * -sin + dy * cos);
			//y1 = y1+10*zoom;
			//y2 = y2+10*zoom;
			path = ["M", x1, y1,
					"L", midX, midY,
					"L", pX1, pY1, 
					//"L", midX, midY, 
					"L", pX2, pY2, 
					"L" ,midX, midY, 
					"L", x2, y2];

			//For Arrow
			triangle = ["M", midX, midY,
						"L", pX1, pY1, 
						"L", pX2, pY2, 
						"L" ,midX, midY,
						"z"];
			
		}
		else
		{
			path = ["M" , x1, y1 ,"L" , x2 ,y2];    // Straight Line
			triangle = ["M", x1, y1, "z"]; //.. to avoid error while Zooming
		}
	}

	if (line && line.line) 
	{
		line.bg && line.bg.attr({path: path});
		line.line.attr({path: path});
		line.tri.attr({path: triangle});
	}
	else
	{
		//var color = typeof line == "string" ? line : "#B0A86E";
		return {
			bg: bg && bg.split && (this.path(path).toBack()).attr({stroke: bg.split("|")[0], "stroke-width": bg.split("|")[1] || 3}),
			line: (this.path(path).toBack()).attr({stroke: color}),
			tri: this.path(triangle).attr({stroke: color,"fill": color}),
			link: lorn,
			from: obj1,
			to: obj2
		};
	}
};


Raphael.fn.connection1 = function (color, obj1, obj2, line, bg, lorn, duplicateLink) {
	if (obj1.line && obj1.from && obj1.to) {
		line = obj1;
		obj1 = line.from;
		obj2 = line.to;
		lorn = line.link;		
	}
	
	var bb1 = obj1.getBBox(),
		bb2 = obj2.getBBox();

	// For zooming the Arrows
	var zzz = document.getElementById('zoom').value;
	var zoom = 1 ;
	if(parseFloat(zzz) >=1)
	{
		zoom = parseFloat(zzz).toFixed(2) / 100;
	}
	else
	{
		zoom = parseFloat(zzz).toFixed(2);
	}

	var categoryType = 0;

	var obj1X = bb1.x;
	var obj1Y = bb1.y;
	var obj1H = bb1.height;
	var obj1W = bb1.width;

	var obj2X = bb2.x;
	var obj2Y = bb2.y;
	var obj2H = bb2.height;
	var obj2W = bb2.width;

	var x1 = obj1X + (obj1W / 2);
	var y1 = obj1Y + (obj1H / 2);
	var x2 = obj2X + (obj2W / 2);
	var y2 = obj2Y + (obj2H / 2);
	var endX2='';

	if(duplicateLink)
	{
		y1 = obj1Y + (obj1H / 2.2);
		y2 = obj2Y + (obj2H / 2.2);
	}

	if(x1 == x2) 
	{
		//x1 = x1 + obj1W;
		//x2 = x2 + obj2W;
		categoryType = 1;
		//Draw Arc....
	}
	else if(x1 > x2)
	{
		//x2 = x2 + obj2W;
		categoryType = 2;
	}
	else
	{
		//x1 = x1 + obj1W;
		categoryType = 2;
	}

	var triangle=null;

	if(categoryType == 1)
	{
		//y1=y1+5*zoom;
		//y2=y2+5*zoom;
		var diff = Math.abs(y2 -y1) / 4;
		if(duplicateLink)
		{	
			y1 = obj1Y + (obj1H);
			y2 = obj2Y;			
			diff = Math.abs(y2 -y1) / 4;
		}
		if(lorn == 'L')
		{
			var midX = (x1 + x2)/ 2;
			var midY = (y1 + y2)/ 2;

			var midXX = (x1+(x1 + x2)/ 2)/2;
			var midYY = (y1+(y1 + y2)/ 2)/2;	

			
			var cos = 0.866;
			var sin = 0.500;
			var dx = (x2 - x1);
			var dy = (y2 - y1);
			
			//Normailze to fixed Size Arrows.
			var length = Math.sqrt(dx * dx + dy * dy);
			dx = 8 * (dx / length) * zoom;
			dy = 8 * (dy / length) * zoom;

			var pX1 = (midX + diff) + (dx * cos + dy * -sin);
			var pY1 = midY + (dx * sin + dy * cos);

			var pX2 = (midX + diff) + (dx * cos + dy * sin);
			var pY2 = midY + (dx * -sin + dy * cos);

			var sX1 = (x1 + diff) + (dx * cos + dy * -sin);
			var sY1 = y1 + (dx * sin + dy * cos);
			var sX2 = (x1 + diff) + (dx * cos + dy * sin);
			var sY2 = y1 + (dx * -sin + dy * cos);

			path =[	"M", x2, y2,
					"C", x2 + diff, y2, midX + diff , midY ,midX + diff , midY
					//"L",midX + diff, midY,
					//"L", pX1, pY1,
					//"L", pX2, pY2, 
					//"L",midX + diff, midY,
					//"C",midX + diff, midY,x2 + diff,y2 ,x2 , y2,
					//"L",x2, y2
					];
			

			// For Arrow
			triangle = ["M", midX + diff, midY,
						"L", pX1, pY1,
						"L", pX2, pY2, 
						"L",midX + diff, midY,
						"z"];						 

			animatedPath = ["M", x2, y2,
							"C", x2 + diff, y2, midX + diff , midY ,midX + diff , midY, 
							//"L",midX + diff, midY,
							//"L", pX1+x2, pY1+y2,
							//"L", pX2, pY2, 
							//"L",midX + diff, midY,
							"C",midX + diff, midY ,x1 + diff,y1 ,x1 , y1,
							"L",x1, y1						
							];		
			

			triPosition	= ["M", x1,y1,
							//"C", midX + diff, midY, midXX + diff , midYY ,midXX + diff , midYY,
							//"L", midX+ diff, midY
							"C",midX + diff, midY,x1 + diff,y1 ,x1 , y1,
							"C", x2 + diff, y2, midX + diff , midY ,midX + diff , midY, 
							"L", x2, y2
						   ];

			
		}
		else
		{
			path =   ["M", x2, y2];
			animatedPath =[	"M", x2, y2,
							"C", x2 + diff, y2, x1 + diff , y1 ,x1 , y1, 
							"L",x1, y1];
			triPosition	= ["M", x1,y1,							
							"C", x2 + diff, y2, x1 + diff , y1 ,x1 , y1,
							"L", x2, y2
						   ];					

			triangle = ["M", x1, y1, "z"]; //.. to avoid error while Zooming
		}		
	}
	else if(categoryType == 2)
	{
		//y1=y1+5*zoom;
		//y2=y2+5*zoom;
		if(lorn == 'L')
		{
			var midX = (x1 + x2)/ 2;
			var midY = (y1 + y2)/ 2;			

			var cos = 0.866;
			var sin = 0.500;
			var dx = (x2 - x1);
			var dy = (y2 - y1);

			//Normailze to fixed Size Arrows.
			var length = Math.sqrt(dx * dx + dy * dy);
			dx = 8 * (dx / length) * zoom;
			dy = 8 * (dy / length) * zoom;

			var pX1 = midX + (dx * cos + dy * -sin);
			var pY1 = midY + (dx * sin + dy * cos);

			var pX2 = midX + (dx * cos + dy * sin);
			var pY2 = midY + (dx * -sin + dy * cos);

			var sX1 = x1 + (dx * cos + dy * -sin);
			var sY1 = y1 + (dx * sin + dy * cos);
			var sX2 = x1 + (dx * cos + dy * sin);
			var sY2 = y1 + (dx * -sin + dy * cos);

			path = ["M", x2, y2
					//"L", midX, midY,
					//"L", pX1, pY1, 
					//"L", midX, midY, 
					//"L", pX2, pY2, 
					//"L" ,midX, midY, 
					//"L", x2, y2
					];

			//For Arrow
			triangle = ["M", midX, midY,
						"L", pX1, pY1, 
						"L", pX2, pY2, 
						"L" ,midX, midY,
						"z"];
			
			animatedPath = ["M", x2, y2,
							//"L", midX, midY,
							//"L", pX1, pY1, 
							//"L", midX, midY, 
							//"L", pX2, pY2, 
							//"L" ,midX, midY, 
							"L", x1, y1							
							];				

			triPosition	= ["M", x1, y1,
						   "L", x2, y2
						  ];			
			
					
		}
		else
		{
			//path = ["M" , x1, y1 ,"L" , x2 ,y2];    // Straight Line
			path = ["M", x2, y2];
			animatedPath = ["M" , x2, y2 ,"L" , x1 ,y1];
			triPosition	= ["M", x1, y1,
						   "L", x2, y2
						  ];	

			triangle = ["M", x1, y1, "z"]; //.. to avoid error while Zooming
		}
	}

	if (line && line.line) 
	{
		line.bg && line.bg.attr({path: path});
		line.line.attr({path: path});
		line.tri.attr({path: triangle});
	}
	else
	{
		return {
			bg: bg && bg.split && this.path(path).attr({stroke: bg.split("|")[0], "stroke-width": bg.split("|")[1] || 3}).hide(),
			line: this.path(animatedPath).attr({stroke: color}).hide(),
			tri: this.path(triangle).attr({stroke: color,"fill": color}),
			link: lorn,
			from: obj1,
			to: obj2,
			path: path,			
			startPosition : triPosition,
			animatedPath : animatedPath
			
		};		
	}
};

Raphael.fn.connectionbtm = function (color, duplicateLink , obj1, obj2, line, bg, lorn, callsText) {
	if (obj1.line && obj1.from && obj1.to) {
		line = obj1;
		obj1 = line.from;
		obj2 = line.to;
		lorn = line.link;		
	}
	
	var bb1 = obj1.getBBox(),
		bb2 = obj2.getBBox();

	// For zooming the Arrows
	//var zzz = document.getElementById('zoom').value;
	var zoom = 1 ;
	/*if(parseFloat(zzz) >=1)
	{
		zoom = parseFloat(zzz).toFixed(2) / 100;
	}
	else
	{
		zoom = parseFloat(zzz).toFixed(2);
	}*/

	var categoryType = 0;

	var obj1X = bb1.x;
	var obj1Y = bb1.y;
	var obj1H = bb1.height;
	var obj1W = bb1.width;

	var obj2X = bb2.x;
	var obj2Y = bb2.y;
	var obj2H = bb2.height;
	var obj2W = bb2.width;

	var x1 = obj1X + (obj1W / 2);
	var y1 = obj1Y + (obj1H / 2);
	var x2 = obj2X + (obj2W / 2);
	var y2 = obj2Y + (obj2H / 2);
	var endX2='';

	if(duplicateLink == "Y")
	{
		y1 = obj1Y + (obj1H / 3.2);
		y2 = obj2Y + (obj2H / 3.2);
	}

	/*if(x1 == x2) 
	{
		x1 = x1 + obj1W;
		x2 = x2 + obj2W;
		categoryType = 1;
		//Draw Arc....
	}
	else*/ if(x1 > x2)
	{
		//x2 = x2 + obj2W;
		categoryType = 2;
	}
	else
	{
		//x1 = x1 + obj1W;
		categoryType = 2;
	}

	var triangle=null;

	if(categoryType == 1)
	{
		var diff = Math.abs(y2 -y1) / 4;
		if(duplicateLink == "Y")
		{	
			y1 = obj1Y + (obj1H);
			y2 = obj2Y;			
			diff = Math.abs(y2 -y1) / 4;
		}
		if(lorn == 'L')
		{
			var midX = (x1 + x2)/ 2;
			var midY = (y1 + y2)/ 2;

			var midXX = (x1+(x1 + x2)/ 2)/2;
			var midYY = (y1+(y1 + y2)/ 2)/2;	

			
			var cos = 0.866;
			var sin = 0.500;
			var dx = (x2 - x1);
			var dy = (y2 - y1);
			
			//Normailze to fixed Size Arrows.
			var length = Math.sqrt(dx * dx + dy * dy);
			dx = 8 * (dx / length) * zoom;
			dy = 8 * (dy / length) * zoom;

			var pX1 = (midX + diff) + (dx * cos + dy * -sin);
			var pY1 = midY + (dx * sin + dy * cos);

			var pX2 = (midX + diff) + (dx * cos + dy * sin);
			var pY2 = midY + (dx * -sin + dy * cos);

			var sX1 = (x1 + diff) + (dx * cos + dy * -sin);
			var sY1 = y1 + (dx * sin + dy * cos);
			var sX2 = (x1 + diff) + (dx * cos + dy * sin);
			var sY2 = y1 + (dx * -sin + dy * cos);

			path =[	"M", x2, y2,
					"C", x2 + diff, y2, midX + diff , midY ,midX + diff , midY
					//"L",midX + diff, midY,
					//"L", pX1, pY1,
					//"L", pX2, pY2, 
					//"L",midX + diff, midY,
					//"C",midX + diff, midY,x2 + diff,y2 ,x2 , y2,
					//"L",x2, y2
					];

			// For Arrow
			triangle = ["M", midX + diff, midY,
						"L", pX1, pY1,
						"L", pX2, pY2, 
						"L",midX + diff, midY,
						"z"];

			animatedPath = ["M", x2, y2,
							"C", x2 + diff, y2, midX + diff , midY ,midX + diff , midY, 
							//"L",midX + diff, midY,
							//"L", pX1+x2, pY1+y2,
							//"L", pX2, pY2, 
							//"L",midX + diff, midY,
							"C",midX + diff, midY ,x1 + diff,y1 ,x1 , y1,
							"L",x1, y1
							];

			triPosition	= ["M", x1,y1,
							//"C", midX + diff, midY, midXX + diff , midYY ,midXX + diff , midYY,
							//"L", midX+ diff, midY
							"C",midX + diff, midY,x1 + diff,y1 ,x1 , y1,
							"C", x2 + diff, y2, midX + diff , midY ,midX + diff , midY, 
							"L", x2, y2
						   ];
		}
		else
		{
			path =   ["M", x2, y2];
			animatedPath =[	"M", x2, y2,
							"C", x2 + diff, y2, x1 + diff , y1 ,x1 , y1, 
							"L",x1, y1];
			triPosition	= ["M", x1,y1,							
							"C", x2 + diff, y2, x1 + diff , y1 ,x1 , y1,
							"L", x2, y2
						   ];					

			triangle = ["M", x1, y1, "z"]; //.. to avoid error while Zooming
		}		
	}
	else if(categoryType == 2)
	{
		if(lorn == 'L')
		{
			var midX = (x1 + x2)/ 2;
			var midY = (y1 + y2)/ 2;

			var midXX = (x1 + midX)/2; 
			var midYY = (y1 + midY)/2;
			midXX = (midXX + midX)/2;
			midYY = (midYY + midY)/2;

			var cos = 0.866;
			var sin = 0.500;
			var dx = (x2 - x1);
			var dy = (y2 - y1);

			//Normailze to fixed Size Arrows.
			var length = Math.sqrt(dx * dx + dy * dy);
			dx = 8 * (dx / length) * zoom;
			dy = 8 * (dy / length) * zoom;

			var pX1 = midX + (dx * cos + dy * -sin);
			var pY1 = midY + (dx * sin + dy * cos);

			var pX2 = midX + (dx * cos + dy * sin);
			var pY2 = midY + (dx * -sin + dy * cos);

			var sX1 = x1 + (dx * cos + dy * -sin);
			var sY1 = y1 + (dx * sin + dy * cos);
			var sX2 = x1 + (dx * cos + dy * sin);
			var sY2 = y1 + (dx * -sin + dy * cos);

			path = ["M", x2, y2
					//"L", midX, midY,
					//"L", pX1, pY1, 
					//"L", midX, midY, 
					//"L", pX2, pY2, 
					//"L" ,midX, midY, 
					//"L", x2, y2
					];

			//For Arrow
			triangle = ["M", midX, midY,
						"L", pX1, pY1, 
						"L", pX2, pY2, 
						"L" ,midX, midY,
						"z"];
			
			animatedPath = ["M", x2, y2,
							//"L", midX, midY,
							//"L", pX1, pY1, 
							//"L", midX, midY, 
							//"L", pX2, pY2, 
							//"L" ,midX, midY, 
							"L", x1, y1
							];

			triPosition	= ["M", x1, y1,
						   "L", x2, y2
						  ];
		}
		else
		{
			//path = ["M" , x1, y1 ,"L" , x2 ,y2];    // Straight Line
			path = ["M", x2, y2];
			animatedPath = ["M" , x2, y2 ,"L" , x1 ,y1];
			triPosition	= ["M", x1, y1,
						   "L", x2, y2
						  ];	

			triangle = ["M", x1, y1, "z"]; //.. to avoid error while Zooming
		}
	}
	var animCircle = obj1.paper.circle(x2 , y2 , 3* zoom, 3* zoom) .attr({stroke: color, fill: color});
	var legendText = obj1.paper.text(midX  , midYY- 12*zoom , callsText).attr({"font-size" : 12*zom, "fill": color , "font-family":"Calibri" });

	if (line && line.line) 
	{
		line.line.attr({path: animatedPath , stroke: color , 'stroke-width':1.1 ,'stroke-dasharray': ""});
		line.tri.attr({path: triangle , stroke: color,"fill": color});
		animCircle.remove();
		legendText.remove();
	}
	else
	{
		return {
			line: (this.path(animatedPath).toBack()).attr({stroke: color ,'stroke-width':1.1 ,'stroke-dasharray': ""}),
			tri: this.path(triangle).attr({stroke: color,"fill": color}),
			link: lorn,
			from: obj1,
			to: obj2,
			path: animatedPath,
			startPosition : triPosition,
			animatedPath : animatedPath,
			legendText : legendText,
			animCircle: animCircle
		};
	}
};