/*BorderPanelLayout is a panel with specific functionality and design workouts.
* Scope for extension of BorderPanelyout would involve chart and legend placement with button toggle hide and show functionality
* Scope would also provide resize of legend panel for intricate legend data with clear visibility
* Provide toggle header icon to legend panel hide and show
* icon was placed inside a method expandButton, so that which involes a step to extend the function and add in necessary header tools.
* renderChart method involed the functionality to creating chart with legend panel or normal panel with necessary certain parameters to be parse
* API provides certain parameters for easy convention. involving
	* isChart - boolean - stating whether the panel will involve chart desing or normal panel desing
	* isToggleHeader - boolean - defines whether the header tools would have toggle functionality and closing legend panel while widget mouseout
	* highChartObj - obj - to store create chart obj for future reuse for redraw or setdata
* Necessary parameters to be parse on renderChart method for chart and legend creation
	* c - obj of the widget to be parse
	* chart_checkbox - legend filter check box if avail
	* chartLegendData - legend data 

 * For more details and to check the steps involve for creation, you can check the documentation in same folder BorderPanelLayout.docx

*/


Ext.define('utilities.BorderPanelLayout',{
	extend:'Ext.panel.Panel',
	//cls:'fluidPanel',
	alias:'widget.BorderPanel',
	highChartObj:null,			/* storing created chart obj*/
	isChart: false,				/*boolean for design necessity*/
	isToggleHeader: false,		/*boolean for toggle header functionality and mouse events*/
	flex:1,
	layout:{
		type: 'fit',
	},
	createLayoutOnStartup : false,
	widgetBtnArr : null,
	errorMsg : '',
	expandButton:function(){ /*Method to add button and its click functionality*/
		var c = this;
		var button  = {
					xtype:'button',
					height:16,
					cls:'dragTools',
					width:16,
					iconCls:'iconSpilitOnWidget',
					margin:'2 5 0 6',
					enableToggle:true,
					hidden:false,
					tooltip:'Expand',
					id: 'iconSpilit_'+c.id,
					style:{'float':'left'},
					handler: function(e){
						if(e.pressed == true){
							var split_id = e.up('panel').id;
							Ext.getCmp('border_'+split_id).expand(false);
							e.setTooltip('Collapse')
						}else{
							var split_id = e.up('panel').id;
							Ext.getCmp('border_'+split_id).collapse();
							$('#border_'+split_id+'-splitter').addClass('x-splitter-collapsed')
							e.setTooltip('Expand');
						}		
					}
				};
		return button;
	},
	initComponent: function () {
		var me = this;
		if(me.createLayoutOnStartup)
		{
			me.renderChart(me,null,null);
		}
        me.callParent();
    },
	loadFilterOptions : function(chart_checkbox)
	{
		if(!Ext.isEmpty(chart_checkbox))
		{
			var filterChkBoxOptsObj=Ext.getCmp('checkboxgroup_'+this.id);
			if(!Ext.isEmpty(filterChkBoxOptsObj))
			{
				filterChkBoxOptsObj.removeAll();
				filterChkBoxOptsObj.checkboxLength=chart_checkbox.length
				filterChkBoxOptsObj.add(chart_checkbox);
			}
		}
	},
	loadLegendPanelData : function(chartLegendData)
	{
		if(!Ext.isEmpty(chartLegendData))
		{
			var legendData=Ext.getCmp('legend_dataview'+this.id);
			legendData.getStore().loadData(chartLegendData);
		}
	},
	updateErrorMsg : function(errMsg)
	{
		var me = this;
		var chartContainer=Ext.getCmp('ChartArea_'+me.id);
		if(!Ext.isEmpty(chartContainer))
		{
			//chartContainer.removeAll();
			if(errMsg!=null && errMsg.indexOf("<div")==-1)
			{
				errMsg='<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconExclamation" style="margin:0px auto"></div><div style="text-align:center">' + errMsg
					+ '!</div></div></div>';
			}
			chartContainer.add({
				xtype : 'panel',
				html : errMsg
			});
			chartContainer.doLayout();
		}
	},
	updateCurrentMeasure : function(currentMess,bId)
	{
		var me = this;
		//var chartContainer=Ext.getCmp('BeforeChartPnl_'+me.id);
		var chartContainer=Ext.getCmp('CurrentMesPnl_'+me.id);
		if(!Ext.isEmpty(chartContainer))
		{
			chartContainer.removeAll();
			chartContainer.add({
				xtype : 'container',
				html : currentMess
			});
			chartContainer.doLayout();
		}
	},
	renderChart: function(c,chart_checkbox,chartLegendData){   /*Method for draw eother chart with legend panel or simple panel with without legend display - necessary parameters to be parse*/
			var me = this;
			if(Ext.isEmpty(chartLegendData))
			{
				chartLegendData=[];
			}
			if(Ext.isEmpty(chart_checkbox))
			{
				chart_checkbox=[];
			}
			var chartLegendsTpl = new Ext.XTemplate(
				'<div>',
				'<tpl for=".">',
				'<div  style="border:0px solid red;cursor:pointer;height:100%;margin:7px 5px 5px 5px;white-space: nowrap;overflow:hidden;text-overflow:ellipsis" ><div style="margin-right:5px;background:{color};height:10px;width:15px;display:inline-block"></div><span class="set_cls" data-qtip="{legendName}" data-qclass="yellowTip">{legendName}</span></div>',
				'</tpl>',
				'</div>'
			);
			
			if(this.isChart){
				if(this.errorMsg == '-' || this.createLayoutOnStartup){
					var resize_min = 235;
					if(!Ext.isEmpty(chart_checkbox) && chart_checkbox.length < 3){
						resize_min = 185;
					}
					c.items = {
						xtype:'panel',
						layout:'border',
						defaults: {
							collapsible: false,
							split: true,
							//bodyStyle: 'padding:15px'
						},
						height:600,
						width:850,
						cls:'Chart_Panel',
								ui:'newGraphPanel',
					items:[
						{
							xtype : 'panel',
							region:'center',
							collapsible: false,
							width : '100%',
							height : '100%',
							flex : 1,
							layout : {
								type : 'vbox',
								align : 'stretch',
								pack : 'center'
							},
							style:{'overflow-y':'auto'},
							reference:'center',
							cls:'render_chart',
							id : 'ChartArea_'+c.id,
							items : c.widgetBtnArr,
							//style:{'border':'1px solid blue !important'},
						},{
							xtype : 'panel',
							region: 'east',     // position for legend region
							width: resize_min,
							split:true,
							border: false,
							height:150,
							floating :false,
							hideCollapseTool: true,
							header:false,
							collapsed: true,
							resizable : false,
							collapseMode:'mini',
							id:'border_'+c.id,
							minWidth:150,
							cls:'Legend_Panel',
							minWidth:resize_min,
							layout:{
								type:'vbox',
								align:'stretch',
							},
							tbar:[
								{
									xtype:'checkboxgroup',
									id:'checkboxgroup_'+c.id,
									pnlId : c.id,
									layout:{
										type:'hbox',
									},
									defaults:{
										padding:'3 5 0 5',
									},
									cls:'LegendPanel_header',
									checkboxLength : chart_checkbox.length,
									items:chart_checkbox
									}],
							items:[{
								xtype:'dataview',
								cls:'legend_data',
								id:'legend_dataview'+c.id,
								layout:{
									type:'fit',
								},
								padding:'7 5 3 7',
								flex:1,
								autoscroll:true,
								overflowY:'auto',
								storeId:'legend_Store',
								store:Ext.data.Store({
									fields:['color','legendName'],
									data:chartLegendData
								}),
								tpl:chartLegendsTpl,
							}],
						}
					]
				};
					/* Prevent resize mouseclick event with parent mouseleave event*/
					Ext.require('Ext.resizer.SplitterTracker',function(){
						Ext.override(Ext.resizer.SplitterTracker,{
							createDragOverlay: function () {
							var overlay;
							overlay = this.overlay =  Ext.get(c.id).createChild({
							cls: this.overlayCls, 
							html: '&#160;'
						});
							overlay.unselectable();
							overlay.setSize(Ext.Element.getViewWidth(true), Ext.Element.getViewHeight(true));
							overlay.show();
						 },
						})
					});
					
					
				}
				/*else
				{
					c.add({
						xtype : 'panel',
						html : '<div style="height:100%;width:100%;display:table"><div class="msgFont" style="display:table-cell;vertical-align:middle"> <div class="iconExclamation" style="margin:0px auto"></div><div style="text-align:center">' + this.errorMsg
							+ '!</div></div></div>'
					});
				}*/
			}else{
				this.items={
					xtype:'panel',
					height:600,
					width:850,
							ui:'newGraphPanel',
					cls:'Chart_Panel',
				};
			}
					
			/*Defines toggle header without mouseout legend panel close functionality - if not split icon will be displayed upfront and not mouseout events*/
				 if(this.isToggleHeader){
			
					for (var i=0;i<c.tools.length;i++)
					{
						$('#'+c.tools[i].id).hide();						
					}
					/*Mouse Over events*/
					c.mon(c.el,'mouseenter',function(){
						for (var i=0;i<c.tools.length;i++)
						{
							$('#'+c.tools[i].id).show();						
						}
					});
					c.mon(c.el,'mouseleave',function(){
						for (var i=0;i<c.tools.length;i++)
						{
							$('#'+c.tools[i].id).hide();
						}
						/*MouseOut legend panel close event*/
						if(Ext.getCmp('border_'+c.id) != null && Ext.getCmp('border_'+c.id) != '' && Ext.getCmp('border_'+c.id) != 'undefined'){
							if((Ext.getCmp('border_'+c.id).hidden == false)){
								Ext.getCmp('border_'+c.id).collapse();
								$('#border_'+c.id+'-splitter').addClass('x-splitter-collapsed')
								Ext.getCmp('iconSpilit_'+c.id).setTooltip('Expand');
								Ext.getCmp('iconSpilit_'+c.id).pressed = false;
								$('#iconSpilit_'+c.id).removeClass('x-btn-pressed')
							}
						}
					});
				};	
				
	}
})