Ext.define("utilities.CustomGrid", {
    extend: "Ext.grid.Panel",
    alias: "widget.customgrid",
	autoDestroy:true,
    border: false,
    frame: false,
    elt: null,
	needtoFixColumn:false,
    initComponent: function () {

		if (!Ext.isEmpty(this.needtoFixColumn) && this.needtoFixColumn)
		{
			if (!Ext.isEmpty(this.forceFitColsCount))
			{
				//console.log('this.forceFitColsCount	'+this.forceFitColsCount);
				//if (Object.keys(this.getStore().getAt(0).data).length<=this.forceFitColsCount)
				if(this.dispDataCount!=undefined && this.dispDataCount<=this.forceFitColsCount)
				{
					this.forceFit=true;
				}
				else if(((this.store.data.items[0]!=undefined) && (Object.keys(this.store.data.items[0].raw).length<=this.forceFitColsCount)) || (Object.keys(this.store.proxy.data[0]).length<=this.forceFitColsCount) )
				{
					this.forceFit=true;
				}
				else
				{
					this.forceFit=false;
				}
			}
			this.callParent();
 			this.addListener('afterrender',this.setGridColumnWidthBasedOnText,this,this.columns);
			//console.log('this.popUpData customgrid	'+this.popUpData);
			if (Ext.isEmpty(this.popUpData))
			{
 				this.addListener('viewready',this.showGridCellToolTip,this);
			}
			if (this.rowspan==true)
			{
 				this.getView().on('refresh', this.updateRowSpan, this);
			}
		}
		else
			this.callParent();
	},
    viewConfig: {
        onItemMouseEnter: function (record, item, index, e) {
            if (this.trackOver) {
                return false;
            }
        },
        onItemMouseLeave: function (record, item, index, e) {
            if (this.trackOver) {
                return false;
            }
        }
    },
	updateRowSpan: function() {
		//console.log('updateRowSpan from customgrid');
		var columns = this.columns,
			view = this.getView(),
			store = this.getStore(),
			rowCount = store.getCount(),
			
			column = columns[0],	//this method is meant to apply rowspan in grid for first column only
			dataIndex = column.dataIndex,
			
			spanCell = null,
			spanCount = null;
			spanValue = null;
	
		for (var row = 0; row < rowCount; ++row) 
		{
			 var cell = view.getCellByPosition({ row: row, column: 0 }).dom,
				record = store.getAt(row),
				value = record.get(dataIndex);
		
			if (spanValue != value) 
			{
				if (spanCell !== null) {
					spanCell.rowSpan = spanCount;
				}
				
				Ext.fly(cell).setStyle('display', '');
				spanCell = cell;
				spanCount = 1;
				spanValue = value;
			}
			else 
			{
				spanCount++;
				Ext.fly(cell).setStyle('display', 'none');
			}
		}
		
		if (spanCell !== null) {
			spanCell.rowSpan = spanCount;
		}
    },
	showGridCellToolTip:function(grid)
	{
		var view = grid.view;
		// record the current cellIndex
		grid.mon(view, {
			uievent: function (type, view, cell, recordIndex, cellIndex, e) {
				grid.cellIndex = cellIndex;
				grid.recordIndex = recordIndex;
			}
		});

		grid.tip = Ext.create('Ext.tip.ToolTip', {
			target: view.el,
			delegate: '.x-grid-cell',
			trackMouse: true,
			renderTo: Ext.getBody(),
			listeners: {
				beforeshow: function updateTipBody(tip) {
					if (!Ext.isEmpty(grid.cellIndex) && grid.cellIndex !== -1) {
						header = grid.headerCt.getGridColumns()[grid.cellIndex];
  						var cellValue=grid.getStore().getAt(grid.recordIndex).get(header.dataIndex);
						var cellTipText;
						if (!Ext.isEmpty(cellValue))
						{
							if (cellValue instanceof Object)
							{
								for (var key in cellValue)
								{
									var str=cellValue[key];
									if (str.indexOf('servlet')<0 && str.toLowerCase().indexOf('com.eg')<0)
									{
										cellTipText=str;
									}
								}
							}
							else
							{
								if (cellValue.indexOf('~')>-1)
								{
									cellTipText=cellValue.substring(0,cellValue.indexOf('~'));
								}
								else
									cellTipText=cellValue;
							}
							tip.update(cellTipText);
						}
					}
				}
			}
		});
	},
	setGridColumnWidthBasedOnText:function(grid,columns)
	{
 		// dont removw=e the below line
		//if(columns[0].locked==true || columns[0].locked==false)
			//return;
		var lockCount = 0;
		var noLockCount = 0;
		for(var col in columns)
		{
			var mcol=columns[col];
			var mainColTextEl=Ext.get(mcol.id+'-textEl');
			if(columns[col].locked==true)
			{
				var lockHeadId = grid.lockedGrid.columns[lockCount].id;
				mainColTextEl=Ext.get(lockHeadId+'-textEl');
				mcol = grid.lockedGrid.columns[lockCount];
			}
			else if(columns[col].locked==false)
			{
				var lockHeadId = grid.normalGrid.columns[noLockCount].id;
				mainColTextEl=Ext.get(lockHeadId+'-textEl');
				mcol = grid.normalGrid.columns[noLockCount];
			}
			var mainColWidth = Ext.util.TextMetrics.measure(mainColTextEl.dom, mainColTextEl.dom.innerHTML).width+20;
			var subColumns=mcol.items.items;
			//console.log(subColumns);
			if (subColumns.length>0)
			{
				if(columns[col].locked==true)
				{
					lockCount++;
				}
				else if(columns[col].locked==false)
				{
					noLockCount++;
				}
				var scol,subColTextEl,subColWidth;
				var allSubCloumnSumWidth=0;
				for(var key in subColumns)
				{
					scol=subColumns[key];
					var innerSubColumns=scol.items.items;
					if (innerSubColumns.length>0)
					{
						grid.setGridColumnWidthBasedOnText(grid,innerSubColumns);
					}
					else
					{
						if (subColumns.length==1)
						{
							if (mainColWidth<100)
							{
								mainColWidth=100;
							}
							if(subColumns[key].needModify!=undefined && subColumns[key].needModify=='no')
							{
								continue;
							}
							subColumns[key].width=mainColWidth;
						}
						else
						{
							subColTextEl=Ext.get(scol.id+'-textEl');
							subColWidth = Ext.util.TextMetrics.measure(subColTextEl.dom, subColTextEl.dom.innerHTML).width+20;
							if (subColWidth<100)
							{
								subColWidth=100;
							}
							subColumns[key].width=subColWidth;
							allSubCloumnSumWidth+=subColWidth;

							if (key==subColumns.length-1 && allSubCloumnSumWidth<mainColWidth)
							{
								//console.log('child colum width is less than parent col width so setting main col width');
								subColWidth=mainColWidth/2;
								if (subColWidth<100)
								{
									subColWidth=100;
								}
								for(var sc in subColumns)
								{
									subColumns[sc].width=subColWidth;
								}
							}
						}
					}
				}
			}
			else
			{
				if (mainColWidth<100)
				{
					mainColWidth=100;
				}
				if(columns[col].locked==true)
				{
					if(columns[col].needModify!=undefined && columns[col].needModify=='no')
					{
						lockCount++;
						continue;
					}
					grid.lockedGrid.columns[lockCount].width=mainColWidth+15;
					lockCount++;
				}
				else if(columns[col].locked==false)
				{
					grid.normalGrid.columns[noLockCount].width=mainColWidth+15;
					noLockCount++;
				}
				else
				{
					columns[col].width=mainColWidth+15;
				}
			}
		}
 	},
	getDecimalAlignFormat:function(value,isAnchor)
	{
		//if(!isNaN(value) && !isNaN(parseFloat(value))||value == '-')
		// revert work start
		if(isAnchor)
		{
			value = '<span class="anchorLink">'+value+'</span>';
		}
		else if(value!=undefined && value=='-')
		{
			value = '<div style="text-align:center;">'+value+'</div>'
		}
		return value;
		//end
		
		/*
		var anchorCls = '';
		if(isAnchor)
			anchorCls = 'class="anchorLink"';
		if(!isNaN(value) && !isNaN(parseFloat(value)))
		{
			value = value.toString();
			if(value!=null && value.indexOf(".")>-1)
			{
				strDecimal = value.substring(value.indexOf("."));
				str = value.substring(0,value.indexOf("."));
				value='<span class="decimal-align"><span '+anchorCls+'>'+str+'</span></span><span class="decimal-align2"><span '+anchorCls+'>'+strDecimal+'</span></span>';
			}
			else
			{
				value='<span class="decimal-align"><span '+anchorCls+'>'+value+'</span></span>';
			}
		}
		else if(value!=undefined && value=='-')
		{
			value = '<div style="text-align:center;">'+value+'</div>'
		}
		return value;
		*/
	}
});