var searchId = '';
Ext.define("utilities.CustomGridWithSearch", {
    extend: "Ext.panel.Panel",
    alias: "widget.customgridwithsearch",
	requires:['utilities.CustomGrid','Ext.ux.RowExpander'],
	storeVal:[],
	columnVal:[],
	forceFit:false,
	needtoFixColumn:false,
	gridScroll:true,
	border:false,
	gridAutoScroll:true,
	gridTitle:'&nbsp;',
	gridData:null,
	jsonType:'array',
	recordsPerPageData:[],
	hideRecordPerPage:false,
	pageLimit:10,
	sortIndex:0,
	sortOrder:'ASC',
	gridPlugins:null,
	initComponent: function () {
		var thisPanel = this;
		var storeObj=Ext.create('Ext.data.Store', {
			fields: thisPanel.fieldsToStore,
			proxy : 
			{
				type : 'pagingmemory',
				reader : {
					type : thisPanel.jsonType
				}
			},
			pageSize:thisPanel.pageLimit,
			autoLoad : true,
			data : thisPanel.gridData,
			sorters: { property: thisPanel.fieldsToStore[thisPanel.sortIndex], direction : thisPanel.sortOrder},

		});
		this.items=[{
				xtype:'customgrid',
				ui:'newGridPanel',
				store:storeObj,
				activePage:1,
				dataArray:thisPanel.gridData,
				dummyArray:thisPanel.gridData.slice(),
				columns:thisPanel.columnVal,
				forceFit:thisPanel.forceFit,
				needtoFixColumn:thisPanel.needtoFixColumn,
				border:true,
				scroll:thisPanel.gridScroll,
 				autoScroll:thisPanel.gridAutoScroll,
				dockedItems:[{
					xtype:'pagingtoolbar',
					cls:'newPagination',
					dock: 'bottom',
					displayInfo: true,
					store: storeObj,
					hidden:thisPanel.isPagingHidden,
					displayInfo: true,
					displayMsg: 'Displaying topics {0} - {1} of {2}',
					emptyMsg: "No topics to display",
					listeners: 
					{
						change : function(thisd, params)
						{
							if(!Ext.isEmpty(params))
								thisPanel.activePage = params.currentPage;
							else
								thisPanel.activePage=1;
						}
					}
				}],
				plugins: thisPanel.gridPlugins,
				viewConfig:
				{
					stripeRows: true,
					getRowClass: function (record, rowIndex, rowParams, store)
					{
						if (record.data.app!=undefined && record.data.app.length>0)
						{
							return ;
						}
						else
						{
							return 'hidePlus';
						}
					}
				},
				listeners:
				{
					sortchange:function(ct, column, e, t, eOpts )
					{
						 this.getStore().loadPage(this.activePage);
					},
					render:function(obj)
					{
						Ext.defer(function() 
						{
							if(!Ext.isEmpty(obj.columns[thisPanel.sortIndex]))
							{
								obj.columns[thisPanel.sortIndex].doSort('DESC');
							}
						},100);
					}
				}
			}];
		var hideGridTitle = true;
		if(thisPanel.gridTitle.length>0)
		{
			hideGridTitle = false;
		}
		this.dockedItems=[{
			xtype:'toolbar',
			cls:'toolbar',
			dock:'top',
			height:38,
			border:0,
			padding:'0 0 0 0',
			flex:1,
			items:[
			{
				xtype: 'container',
				margin:'8 8 0 8',
				hidden:hideGridTitle,
				html: '<div>'+thisPanel.gridTitle+'</div>',
			},
			'->',
			{
				xtype: 'scrollcombo',
				width: 200,
				labelWidth:120,
				margin:'0 10 0 0',
				cls: 'dropdown',
				labelSeparator:'',
				hidden:thisPanel.hideRecordPerPage,
				fieldLabel: 'Records per page',
				labelAlign:'left',
				editable: true,
				store: new Ext.data.Store({
					fields: ['displayField', 'valueField'],
					data: []
				}),
				displayField: 'displayField',
				valueField: 'valueField',
				queryMode: 'local',
				listeners: 
				{
					afterrender:function()
					{
						this.parentPanelId = thisPanel.id;
						var pageLimit = thisPanel.pageLimit;
						var recordsPerPageData = Ext.getCmp(this.parentPanelId).recordsPerPageData;
						if(pageLimit==undefined)
						{
							pageLimit = 15;
						}
						if(recordsPerPageData!=undefined && recordsPerPageData.length>0)
						{
							this.getStore().loadRawData(recordsPerPageData);
							this.setValue(pageLimit);
						}
						else
						{
							recordsPerPageData = new Array();
							var selectedVal = 5;
							for(var i=5;i<50;i=i+5)
							{
								var obj = new Object();
								obj['displayField']=i
								obj['valueField']=i
								recordsPerPageData.push(obj);
								if(i == pageLimit)
								{
									selectedVal = pageLimit;
								}
							}
							this.getStore().loadRawData(recordsPerPageData);
							this.setValue(selectedVal);
						}
						
					},
					select:function()
					{
						thisPanel.pageLimit = this.getValue();
						thisPanel.reloadGridPanel();
					}
				}
			},
			{
				xtype:'trigger',
				labelWidth:40,
				fieldLabel:'',
				cls: 'whitedropdown_search',
				emptyText:'Search',
				enableKeyEvents: true,
				margin:'0 0 0 0',
				listeners: 
				{
					change: function(trig,newVal,oldVal,eOpts) 
					{
						searchId = this.id
						thisPanel.searchTask.delay(500);
					},
					afterrender:function()
					{
						this.parentPanelId = thisPanel.id;
					}
				}
			}]
		}],
		this.callParent();
	},
	searchTask: new Ext.util.DelayedTask(function(obj)
	{
		var field = Ext.getCmp(searchId);
		var parentPanel = Ext.getCmp(field.parentPanelId);
		var gridPanel = Ext.getCmp(parentPanel.items.items[0].id);
		
		var dataArray=gridPanel.dataArray;
		var dummyArray=gridPanel.dummyArray;
		gridPanel.getStore().removeAll();
		if(Ext.String.trim(field.value).length > 0 && (Ext.String.trim(field.value) != '' || Ext.String.trim(field.value) != null))
		{
			var regex = RegExp(field.value, 'i');
			dataArray.splice(0, dataArray.length);
			for(var key in dummyArray)
			{
				var match = false;
				var obj=dummyArray[key];
				Ext.Object.each(obj, function (property, value) {
					//if(property=="templateName" || property=="templateTitle" || property=="templateDescription")
						match = match || regex.test(String(value));
				});
				if(match)
					dataArray.push(obj);
			}
			gridPanel.getStore().load();
			//gridPanel.getStore().loadRawData(dataArray);
			//gridPanel.getStore().loadPage(gridPanel.activePage);
		}
		else
		{
			dataArray.splice(0, dataArray.length);
			for(var key in dummyArray)
			{
				var obj=dummyArray[key];
				dataArray.push(obj);
			}
			gridPanel.getStore().loadRawData(dataArray);
			gridPanel.getStore().loadPage(gridPanel.activePage);
		}
		var pagingToolType = Ext.getCmp(gridPanel.dockedItems.items[1].id).getXType();
		if(pagingToolType!=undefined && pagingToolType.toString() == 'pagingtoolbar')
		{
			var pagingToolId = gridPanel.dockedItems.items[1].id;
			if(gridPanel.getStore().totalCount>parentPanel.pageLimit)
			{
				Ext.getCmp(pagingToolId).show();
			}
			else
			{
				Ext.getCmp(pagingToolId).hide();
			}
		}
		field.focus();
	}),
	reloadGridPanel:function()
	{
		var parentPanel = this;
		var gridPanel = Ext.getCmp(parentPanel.items.items[0].id);
		gridPanel.getStore().pageSize = parentPanel.pageLimit;
		gridPanel.getStore().load();
		var pagingToolType = Ext.getCmp(gridPanel.dockedItems.items[1].id).getXType();
		if(pagingToolType!=undefined && pagingToolType.toString() == 'pagingtoolbar')
		{
			var pagingToolId = gridPanel.dockedItems.items[1].id;
			if(gridPanel.getStore().totalCount>parentPanel.pageLimit)
			{
				Ext.getCmp(pagingToolId).show();
			}
			else
			{
				Ext.getCmp(pagingToolId).hide();
			}
		}
	},
	listeners:
	{
		afterrender: function (c)
		{
		}
	}
});