Ext.define("utilities.CustomGrid_builder", {
    extend: "Ext.grid.Panel",
    alias: "widget.customgrid_builder",
	autoDestroy:true,
    border: false,
    frame: false,
    elt: null,
	needtoFixColumn:false,
	ui:'newGridPanel',
    initComponent: function () {

		if (!Ext.isEmpty(this.needtoFixColumn) && this.needtoFixColumn)
		{
			
			if (!Ext.isEmpty(this.forceFitColsCount))
			{
				//console.log('this.forceFitColsCount	'+this.forceFitColsCount);
				//if (Object.keys(this.getStore().getAt(0).data).length<=this.forceFitColsCount)
				if (Object.keys(this.store.data.items[0].raw).length<=this.forceFitColsCount)
				{
					this.forceFit=true;
				}
				else
				{
					this.forceFit=false;
				}
				
			}

			
			this.callParent();
 			this.addListener('afterrender',this.setGridColumnWidthBasedOnText,this,this.columns);
			//console.log('this.popUpData customgrid	'+this.popUpData);
			if (Ext.isEmpty(this.popUpData))
			{
 				this.addListener('viewready',this.showGridCellToolTip,this);
			}
			if (this.rowspan==true)
			{
 				this.getView().on('refresh', this.updateRowSpan, this);
			}
		}
		else
			this.callParent();
	},
    viewConfig: {
        onItemMouseEnter: function (record, item, index, e) {
            if (this.trackOver) {
                return false;
            }
        },
        onItemMouseLeave: function (record, item, index, e) {
            if (this.trackOver) {
                return false;
            }
        }
    },
	updateRowSpan: function() {
		//console.log('updateRowSpan from customgrid');
		var columns = this.columns,
			view = this.getView(),
			store = this.getStore(),
			rowCount = store.getCount(),
			
			column = columns[0],	//this method is meant to apply rowspan in grid for first column only
			dataIndex = column.dataIndex,
			
			spanCell = null,
			spanCount = null;
			spanValue = null;
	
		for (var row = 0; row < rowCount; ++row) 
		{
			 var cell = view.getCellByPosition({ row: row, column: 0 }).dom,
				record = store.getAt(row),
				value = record.get(dataIndex);
		
			if (spanValue != value) 
			{
				if (spanCell !== null) {
					spanCell.rowSpan = spanCount;
				}
				
				Ext.fly(cell).setStyle('display', '');
				spanCell = cell;
				spanCount = 1;
				spanValue = value;
			}
			else 
			{
				spanCount++;
				Ext.fly(cell).setStyle('display', 'none');
			}
		}
		
		if (spanCell !== null) {
			spanCell.rowSpan = spanCount;
		}
    },
	showGridCellToolTip:function(grid)
	{
		var view = grid.view;
		// record the current cellIndex
		grid.mon(view, {
			uievent: function (type, view, cell, recordIndex, cellIndex, e) {
				grid.cellIndex = cellIndex;
				grid.recordIndex = recordIndex;
			}
		});

		grid.tip = Ext.create('Ext.tip.ToolTip', {
			target: view.el,
			delegate: '.x-grid-cell',
			trackMouse: true,
			renderTo: Ext.getBody(),
			listeners: {
				beforeshow: function updateTipBody(tip) {
					if (!Ext.isEmpty(grid.cellIndex) && grid.cellIndex !== -1) {
						header = grid.headerCt.getGridColumns()[grid.cellIndex];
  						var cellValue=grid.getStore().getAt(grid.recordIndex).get(header.dataIndex);
						var cellTipText;
						if (!Ext.isEmpty(cellValue))
						{
							if (cellValue instanceof Object)
							{
								for (var key in cellValue)
								{
									var str=cellValue[key];
									if (str.indexOf('servlet')<0 && str.toLowerCase().indexOf('com.eg')<0)
									{
										cellTipText=str;
									}
								}
							}
							else
							{
								if (cellValue.indexOf('~')>-1)
								{
									cellTipText=cellValue.substring(0,cellValue.indexOf('~'));
								}
								else
									cellTipText=cellValue;
							}
							tip.update(cellTipText);
						}
					}
				}
			}
		});
	},
	setGridColumnWidthBasedOnText:function(grid,columns)
	{
		for(var col in columns)
		{
			var mcol=columns[col];
			var mainColTextEl=Ext.get(mcol.id+'-textEl');
			var mainColWidth = Ext.util.TextMetrics.measure(mainColTextEl.dom, mainColTextEl.dom.innerHTML).width+20;
			var headerText = mcol.text;
			var customWidth = mcol.customWidth;

			var subColumns=mcol.items.items;
			if (subColumns.length>0)
			{
				var scol,subColTextEl,subColWidth;
				var allSubCloumnSumWidth=0;
				for(var key in subColumns)
				{
					scol=subColumns[key];
					var innerSubColumns=scol.items.items;
					if (innerSubColumns.length>0)
					{
						grid.setGridColumnWidthBasedOnText(grid,innerSubColumns);
					}
					else
					{
						if (subColumns.length==1)
						{
							if (mainColWidth<100)
							{
								mainColWidth=98;
							}
							subColumns[key].minWidth=mainColWidth;
						}
						else
						{
							subColTextEl=Ext.get(scol.id+'-textEl');
							subColWidth = Ext.util.TextMetrics.measure(subColTextEl.dom, subColTextEl.dom.innerHTML).width+20;
							customWidth=scol.customWidth;
							if (subColWidth<100)
							{
								subColWidth=98;
							}
							if(customWidth!=undefined && customWidth!=null && customWidth !='')
							{
								subColWidth=customWidth;
							}
							subColumns[key].minWidth=subColWidth;
							allSubCloumnSumWidth+=subColWidth;

						

							if (key==subColumns.length-1 && allSubCloumnSumWidth<mainColWidth)
							{
								//console.log('child colum width is less than parent col width so setting main col width');
								subColWidth=mainColWidth/2;
								if (subColWidth<100)
								{
									subColWidth=98;
								}
								for(var sc in subColumns)
								{
									subColumns[sc].minWidth=subColWidth;
								}
							}
						}
					}
			
				}
			}
			else
			{
				if (mainColWidth<100 && headerText != ' ' &&  headerText != '&#160;')
				{
					mainColWidth=98;
				}
				if(customWidth!=undefined && customWidth!=null && customWidth !='')
				{
					mainColWidth=customWidth;
				}
				columns[col].minWidth=mainColWidth+14;

			}
		}
 	}
});