Ext.define('utilities.CustomTrigger', {
    extend: 'Ext.form.field.Trigger',
    alias: 'widget.customtrigger',
	trigger1Cls: 'x-form-clear-trigger',
	trigger2Cls: 'x-form-search-trigger',
	emptyText: 'Search',
 	cls:'whitedropdown_search',
	width: 205,
	onTrigger1Click: function() {
		this.reset();
 	},
	onTrigger2Click: function() {
 		this.toggleTriggger();
	},
	/*listeners:{
		change:function(obj){
 			obj.toggleTriggger();
		}
	},*/
	toggleTriggger:function(){
		var searchStr = this.getValue();
		var tid= this.getId();
		//console.log('tid	'+tid);
		//console.log('searchStr	'+searchStr);
 		if (searchStr == "" || searchStr .length == 0)
		{
			Ext.get(tid+'Trigger_0').setStyle('display','none');
			Ext.get(tid+'Trigger_1').setStyle('display','table-cell');
			
		}
		else
		{
 			Ext.get(tid+'Trigger_1').setStyle('display','none');
			Ext.get(tid+'Trigger_0').setStyle('display','table-cell');
		}
	},
	getTriggerMarkup: function() {
		//console.log('--------'+this.getId());
 		var me = this,
		tid=this.getId(),
		i = 0,
		hideTrigger = (me.readOnly || me.hideTrigger),
		triggerCls,
		triggerBaseCls = me.triggerBaseCls,
		triggerConfigs = [],
		unselectableCls = Ext.dom.Element.unselectableCls,
		style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
		cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;

		// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
		// single triggerCls config. Should rethink this, perhaps something more structured like a list of
		// trigger config objects that hold cls, handler, etc.
		// triggerCls is a synonym for trigger1Cls, so copy it.
		if (!me.trigger1Cls) {
			me.trigger1Cls = me.triggerCls;
		}

		// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
		for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
			//console.log( tid+'Trigger_'+i);
			if (i == 0)
			{
				
				triggerConfigs.push({
					tag: 'td',
					role: 'presentation',
					valign: 'top',
					cls: cls,
					id : tid+'Trigger_'+i,
					style: style + "display:none;",
					cn: {
						cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
						role: 'presentation'
					}
				});
			}
			else
			{
				triggerConfigs.push({
					tag: 'td',
					role: 'presentation',
					valign: 'top',
					cls: cls,
					id : tid+'Trigger_'+i,
					style: style,
					cn: {
						cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
						role: 'presentation'
					}
				});
			}
		}
		triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
		return Ext.DomHelper.markup(triggerConfigs);
	}
});