function getUserThemeFor(skin)
{
	return getUserThemeFor(skin, false, '');
}
function getUserThemeFor(skin,isCombinationChart,ytitleColors)
{
	if(skin!=null && (skin=='dark' || skin=='Dark')){
		if( isCombinationChart )
			return getCombinationDarkTheme(ytitleColors);
		else
			return getDarkTheme();
	}else
	{
		if( isCombinationChart )
			return getCombinationLightTheme(ytitleColors);
		else
			return getLightTheme();
	}
}
function getLightTheme()
{
	var lightTheme = {
	   chart: {
			plotBorderColor : 'transparent',
			backgroundColor:'transparent',
	   },
	   title: {
			style: {
				color : '#333333',
				fontWeight:'400',
				fontFamily:'Roboto',
				fontSize: '12px',
			}
	   },
		subtitle: {
			style: {
				color:  '#333333',
				fontWeight:'400',
				fontFamily:'Roboto',
				fontSize: '11px',
			}
		},
	   xAxis: {
			gridLineColor: '#dedede',
			labels: {
				style: {
					color : '#969696',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '11px',
				}
			},
			lineColor: '#dedede',
			minorGridLineColor: '#dedede',
			tickColor: '#dedede',
			title: {
				style: {
					color: '#969696',
					fontWeight:'400',
					fontFamily:'Roboto',
					fontSize: '11px',
					}
			}
		},
		yAxis: {
			gridLineColor: '#dedede',
				labels: {
				 style: {
					color : '#969696',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '11px',
				}
			},
			lineColor: '#dedede',
			minorGridLineColor: '#dedede',
			tickColor: '#dedede',
			title: {
			style: {
				color: '#969696',
				fontWeight:'400',
				fontFamily:'Roboto',
				fontSize: '11px',
				}
			}
		},
		tooltip: {
			style: {
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
			}
		},
		legend: {
			itemStyle: {
					color : '#2a292a',
					fontWeight:'500',
					fontFamily: 'Roboto',
					fontSize: '11px',
				},
			},
		labels: {
			style: {
			color: '#2a292a',
			fontWeight:'400',
			fontFamily: 'Roboto',
			fontSize: '10px',
			}
		},
	};
	return lightTheme;
}
function getDarkTheme()
{
	var darkTheme = {
	   chart: {
			plotBorderColor : 'transparent',
			backgroundColor:'transparent',
			plotBackgroundColor: 'transparent',
	   },
	   title: {
	      style: {
			color : '#c0c0c0',
			fontWeight:'400',
			fontFamily:'Roboto',
			fontSize: '12px',
			}
	   },
		subtitle: {
			style: {
				color:  '#c0c0c0',
				fontWeight:'400',
				fontFamily:'Roboto',
				fontSize: '11px',
	      }
	   },
	   xAxis: {
	      gridLineColor: '#525252',
	      labels: {
		 style: {
				color : '#c0c0c0',
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
			}
	      },
	      lineColor: '#525252',
	      minorGridLineColor: '#525252',
	      tickColor: '#525252',
	      title: {
		 style: {
				color: '#c0c0c0',
				fontWeight:'400',
				fontFamily:'Roboto',
				fontSize: '11px',
				}
	      }
	   },
	   yAxis: {
	      gridLineColor: '#525252',
	      labels: {
		 style: {
				color : '#c0c0c0',
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
			}
	      },
	      lineColor: '#525252',
	      minorGridLineColor: '#525252',
	      tickColor: '#525252',
	      title: {
		 style: {
				color: '#c0c0c0',
				fontWeight:'400',
				fontFamily:'Roboto',
				fontSize: '11px',
				}
	      }
	   },
	   tooltip: {
	      backgroundColor: '#161616',
		  borderColor:'#0c0c0c',
	      style: {
				padding: 10,
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
			}
	   },
	   legend: {
	      itemStyle: {
					color : '#c0c0c0',
					fontWeight:'500',
					fontFamily: 'Roboto',
					fontSize: '11px',
				},
			},
	   labels: {
			style: {
				color: '#c0c0c0',
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '10px',
	      }
	   },
	};
	return darkTheme;
}

function getCombinationLightTheme(ytitleColors)
{
	//ytitleColor = ( ytitleColor == "" || ytitleColor == 'null' || ytitleColor == 'undefined' || ytitleColor == undefined )?'#c0c0c0':ytitleColor;
	var lightTheme = {
	   chart: {
			plotBorderColor : 'transparent',
			backgroundColor:'transparent',
	   },
	   title: {
			style: {
				color : '#333333',
				fontWeight:'400',
				fontFamily:'Roboto',
				fontSize: '12px',
			}
	   },
		subtitle: {
			style: {
				color:  '#333333',
				fontWeight:'400',
				fontFamily:'Roboto',
				fontSize: '11px',
			}
		},
	   xAxis: {
			gridLineColor: '#dedede',
			labels: {
				style: {
					color : '#969696',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '11px',
				}
			},
			lineColor: '#dedede',
			minorGridLineColor: '#dedede',
			tickColor: '#dedede',
			title: {
				style: {
					color: '#969696',
					fontWeight:'400',
					fontFamily:'Roboto',
					fontSize: '11px',
					}
			}
		},
		yAxis: [{
			gridLineColor: '#dedede',
				labels: {
				 style: {
					color : '#969696',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '11px',
				}
			},
			lineColor: '#dedede',
			minorGridLineColor: '#dedede',
			tickColor: '#dedede',
			title: {
			style: {
				color: ytitleColors[0],
				fontWeight:'400',
				fontFamily:'Roboto',
				fontSize: '11px',
				}
			}
		},{
			gridLineColor: '#dedede',
				labels: {
				 style: {
					color : '#969696',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '10px',
				}
			},
			lineColor: '#dedede',
			minorGridLineColor: '#dedede',
			tickColor: '#dedede',
			title: {
			style: {
				
				color: ytitleColors[1],
				fontWeight:'400',
				fontFamily:'Roboto',
				fontSize: '11px',
				}
			}
		}],
		tooltip: {
			style: {
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
			}
		},
		legend: {
			itemStyle: {
					color : '#2a292a',
					fontWeight:'500',
					fontFamily: 'Roboto',
					fontSize: '11px',
				},
			},
		labels: {
			style: {
			color: '#2a292a',
			fontWeight:'400',
			fontFamily: 'Roboto',
			fontSize: '10px',
			}
		},
	};
	return lightTheme;
}
function getCombinationDarkTheme(ytitleColors)
{
	var darkTheme = {
	   chart: {
			plotBorderColor : 'transparent',
			backgroundColor:'transparent',
			plotBackgroundColor: 'transparent',
	   },
	   title: {
	      style: {
			color : '#c0c0c0',
			fontWeight:'400',
			fontFamily:'Roboto',
			fontSize: '12px',
			}
	   },
		subtitle: {
			style: {
				color:  '#c0c0c0',
				fontWeight:'400',
				fontFamily:'Roboto',
				fontSize: '11px',
	      }
	   },
	   xAxis: {
	      gridLineColor: '#525252',
	      labels: {
		 style: {
				color : '#c0c0c0',
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
			}
	      },
	      lineColor: '#525252',
	      minorGridLineColor: '#525252',
	      tickColor: '#525252',
	      title: {
		 style: {
				color: '#c0c0c0',
				fontWeight:'400',
				fontFamily:'Roboto',
				fontSize: '11px',
				}
	      }
	   },
	   yAxis: [{
	      gridLineColor: '#525252',
	      labels: {
		 style: {
				color : '#c0c0c0',
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
			}
	      },
	      lineColor: '#525252',
	      minorGridLineColor: '#525252',
	      tickColor: '#525252',
	      title: {
		 style: {
				color: ytitleColors[0],
				fontWeight:'400',
				fontFamily:'Roboto',
				fontSize: '11px',
				}
	      }
	   },{
	      gridLineColor: '#525252',
	      labels: {
		 style: {
				color : '#c0c0c0',
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '10px',
			}
	      },
	      lineColor: '#525252',
	      minorGridLineColor: '#525252',
	      tickColor: '#525252',
	      title: {
		 style: {
				color: ytitleColors[1],
				fontWeight:'400',
				fontFamily:'Roboto',
				fontSize: '11px',
				}
	      }
	   }],
	   tooltip: {
	      backgroundColor: '#161616',
		  borderColor:'#0c0c0c',
	      style: {
				padding: 10,
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
			}
	   },
	   legend: {
	      itemStyle: {
					color : '#c0c0c0',
					fontWeight:'500',
					fontFamily: 'Roboto',
					fontSize: '11px',
				},
			},
	   labels: {
			style: {
				color: '#c0c0c0',
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '10px',
	      }
	   },
	};
	return darkTheme;
}
function getMyDashboardCombinationTheme(strSkin)
{
	var themeObj=null;
	if(strSkin!=null && (strSkin=='dark' || strSkin=='Dark')){
		themeObj = {
		   chart: {
				plotBorderColor : 'transparent',
				backgroundColor:'transparent',
				plotBackgroundColor: 'transparent',
		   },
		   title: {
			  style: {
				color : '#c0c0c0',
				fontFamily:'Roboto',
				fontSize: '12px',
				}
		   },
			subtitle: {
				style: {
					color:  '#c0c0c0',
					fontWeight:'400',
					fontFamily:'Roboto',
					fontSize: '11px',
			  }
		   },
		   xAxis: {
			  gridLineColor: '#525252',
			  labels: {
			 style: {
					color : '#c0c0c0',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '10px',
				}
			  },
			  lineColor: '#525252',
			  minorGridLineColor: '#525252',
			  tickColor: '#525252',
			  title: {
			 style: {
					color: '#c0c0c0',
					fontWeight:'bold',
					fontFamily:'Roboto',
					fontSize: '11px',
					}
			  }
		   },
		   tooltip: {
			  backgroundColor: '#161616',
			  borderColor:'#0c0c0c',
			  style: {
					padding: 10,
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '11px',
				}
		   },
		   legend: {
			  itemStyle: {
						color : '#c0c0c0',
						fontWeight:'400',
						fontFamily: 'Roboto',
						fontSize: '10px',
					},
				},
		   labels: {
				style: {
					color: '#c0c0c0',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '10px',
			  }
		   },
		};
	}
	else
	{
		themeObj = {
		   chart: {
				plotBorderColor : 'transparent',
				backgroundColor:'transparent',
		   },
		   title: {
				style: {
					color : '#333333',
					fontFamily:'Roboto',
					fontSize: '12px',
				}
		   },
			subtitle: {
				style: {
					color:  '#333333',
					fontWeight:'bold',
					fontFamily:'Roboto',
					fontSize: '11px',
				}
			},
		   xAxis: {
				gridLineColor: '#dedede',
				labels: {
					style: {
						color : '#606060',
						fontWeight:'400',
						fontFamily: 'Roboto',
						fontSize: '10px',
					}
				},
				lineColor: '#dedede',
				minorGridLineColor: '#dedede',
				tickColor: '#dedede',
				title: {
					style: {
						color: '#969696',
						fontWeight:'bold',
						fontFamily:'Roboto',
						fontSize: '11px',
						}
				}
			},

			tooltip: {
				style: {
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '11px',
				}
			},
			legend: {
				itemStyle: {
						color : '#2a292a',
						fontWeight:'400',
						fontFamily: 'Roboto',
						fontSize: '10px',
					},
				},
			labels: {
				style: {
				color: '#2a292a',
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '10px',
				}
			},
		};
	}
	return themeObj;
}
