function getUserThemeFor(skin)
{
	return getUserThemeFor(skin, false, '');
}
function getUserThemeForCombinedChart(skin)
{
	if(skin!=null && (skin=='dark' || skin=='Dark'))
	{
		return getCombinationDarkTheme_builder('');
	}
	else
	{
		return getCombinationLightTheme_builder('');
	}	
}
function getCombinationLightTheme_builder(ytitleColors)
{
	var lightTheme = {
	   chart: {
			plotBorderColor : 'transparent',
			backgroundColor:'transparent',
	   },
	   title: {
			style: {
				color : '#2a292a',
				fontFamily:'Roboto',
				fontSize: '14px',
				fontWeight:'400'
			}
	   },
		subtitle: {
			style: {
				color : '#2a292a',
				fontFamily:'Roboto',
				fontSize: '11px',
				fontWeight:'400'
			}
		},
	   xAxis: {
			gridLineColor: '#e1e1e1',
			labels: {
				style: {
					color : '#969696',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '11px',
				}
			},
			lineColor: '#e1e1e1',
			minorGridLineColor: '#e1e1e1',
			tickColor: '#e1e1e1',
			title: {
				style: {
					color : '#969696',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '11px',
					}
			}
		},
		yAxis: [{
			gridLineColor: '#e1e1e1',
				labels: {
				 style: {
					color : '#969696',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '11px',
				}
			},
			lineColor: '#e1e1e1',
			minorGridLineColor: '#e1e1e1',
			tickColor: '#e1e1e1',
			title: {
				style: {
					color : '#969696',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '11px',
					}
			}
		},{
			gridLineColor: '#e1e1e1',
				labels: {
				 style: {
					color : '#969696',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '11px',
				}
			},
			lineColor: '#e1e1e1',
			minorGridLineColor: '#e1e1e1',
			tickColor: '#e1e1e1',
			title: {
				style: {
					color : '#969696',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '11px',
					}
			},
			opposite:true,
		}],
		tooltip: {
			style: {
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
			}
		},
		legend: {
			itemStyle: {
					color : '#707070',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '12px',
				},
			},
		labels: {
			style: {
			color : '#707070',
			fontWeight:'400',
			fontFamily: 'Roboto',
			fontSize: '12px',
			}
		},
	};
	return lightTheme;
}
function getCombinationDarkTheme_builder(ytitleColors)
{
	var darkTheme = {
	   chart: {
			plotBorderColor : 'transparent',
			backgroundColor:'transparent',
			plotBackgroundColor: 'transparent',
	   },
	   title: {
	      style: {
			color : '#c0c0c0',
			fontFamily:'Roboto',
			fontSize: '14px',
			fontWeight:'400'
			}
	   },
		subtitle: {
			style: {
			color : '#c0c0c0',
			fontFamily:'Roboto',
			fontSize: '11px',
			fontWeight:'400'
	      }
	   },
	   xAxis: {
	      gridLineColor: '#666666',
	      labels: {
		 style: {
				color : '#c0c0c0',
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
			}
	      },
	      lineColor: '#666666',
	      minorGridLineColor: '#666666',
	      tickColor: '#666666',
	      title: {
		 style: {
				color : '#c0c0c0',
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
				}
	      }
	   },
	   yAxis: [{
	      gridLineColor: '#666666',
	      labels: {
		 style: {
				color : '#c0c0c0',
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
			}
	      },
	      lineColor: '#666666',
	      minorGridLineColor: '#666666',
	      tickColor: '#666666',
	      title: {
			  style: {
				color : '#c0c0c0',
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
				}
	      }
	   },{
	      gridLineColor: '#666666',
	      labels: {
		 style: {
				color : '#c0c0c0',
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
			}
	      },
	      lineColor: '#666666',
	      minorGridLineColor: '#666666',
	      tickColor: '#666666',
	      title: {
		    style: {
				color : '#c0c0c0',
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
				}
	      },
		  opposite:true,
	   }],
	   tooltip: {
	      backgroundColor: '#161616',
		  borderColor:'#0c0c0c',
	      style: {
				padding: 10,
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
			}
	   },
	   legend: {
	      itemStyle: {
					color : '#707070',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '12px',
				},
			},
	   labels: {
			style: {
				color : '#c0c0c0',
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
	      }
	   },
	};
	return darkTheme;
}
function getUserThemeFor(skin,isCombinationChart,ytitleColors,isBar)
{
	if(skin!=null && (skin=='dark' || skin=='Dark')){
		if( isCombinationChart )
			return getCombinationDarkTheme(ytitleColors);
		else
			return getDarkTheme(isBar);
	}else
	{
		if( isCombinationChart )
			return getCombinationLightTheme(ytitleColors);
		else
			return getLightTheme(isBar);
	}
}
function getLightTheme(isBar)
{
	var spacingtop = 0;
	if(isBar)
		spacingtop = 30;
	else
		spacingtop = 70;
	var lightTheme = {
	   chart: {
			plotBorderColor : 'transparent',
			backgroundColor:'transparent',
			spacingTop:spacingtop,
			spacingLeft:15,
			spacingRight:30,
			spacingBottom:20,
			//marginLeft:'10px',
	   },
	   title: {
			style: {
				color : '#2a292a',
				fontFamily:'Roboto',
				fontSize: '14px',
				fontWeight:'400'
			}
	   },
		subtitle: {
			style: {
				color : '#2a292a',
				fontFamily:'Roboto',
				fontSize: '11px',
				fontWeight:'400'
			}
		},
	   xAxis: {
			gridLineColor: '#e1e1e1',
			labels: {
				style: {
					color : '#969696',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '11px',
				}
			},
			lineColor: '#e1e1e1',
			minorGridLineColor: '#e1e1e1',
			tickColor: '#e1e1e1',
			title: {
				style: {
					color : '#969696',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '11px',
					}
			}
		},
		yAxis: {
			gridLineColor: '#e1e1e1',
				labels: {
				 style: {
					color : '#969696',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '11px',
				}
			},
			lineColor: '#e1e1e1',
			minorGridLineColor: '#e1e1e1',
			tickColor: '#e1e1e1',
			title: {
			style: {
				color : '#969696',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '11px',
				}
			}
		},
		tooltip: {
			borderColor:null,
			style: {
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
			}
		},
		legend: {
			//height:350,
			//width:400,
			margin:15,
			navigation:{
				//style:{top:"-10px"},
				
			},
			align:"center",
			squareSymbol:false,
			borderRadius:1,
			symbolRadius:5,
			//maxHeight:55,
			padding:3,
			symbolWidth:15,
			itemMarginBottom:4,
			itemMarginTop:-1,
			//itemWidth:150,
			lineHeight:17,
			itemHoverStyle:{"color":"#707070"},
			navigation: {
				arrowSize: 8,
				activeColor: '#707070',
				inactiveColor:'#707070',
				style: {
				    fontWeight: 'bold',
				    color: '#707070',
				    fontSize: '9px'
				}
			},
			itemStyle: {
					color : '#707070',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '12px',
					//top:"-40px",
					padding:3
				},
			},
		labels: {
			style: {
				color : '#707070',
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '12px',
			}
		},
	};
	return lightTheme;
}
function getDarkTheme(isBar)
{
	var spacingtop = 0;
	if(isBar)
		spacingtop = 30;
	else
		spacingtop = 70;
	var darkTheme = {
	   chart: {
			plotBorderColor : 'transparent',
			backgroundColor:'transparent',
			plotBackgroundColor: 'transparent',
			spacingTop:spacingtop,
			spacingLeft:15,
			spacingRight:30,
			spacingBottom:20,
	   },
	   title: {
	      style: {
			color : '#c0c0c0',
			fontFamily:'Roboto',
			fontSize: '14px',
			fontWeight:'400'
			}
	   },
		subtitle: {
			style: {
			color : '#c0c0c0',
			fontFamily:'Roboto',
			fontSize: '11px',
			fontWeight:'400'
	      }
	   },
	   xAxis: {
	      gridLineColor: '#666666',
	      labels: {
		 style: {
				color : '#c0c0c0',
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
			}
	      },
	      lineColor: '#666666',
	      minorGridLineColor: '#666666',
	      tickColor: '#666666',
	      title: {
		 style: {
				color : '#c0c0c0',
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
				}
	      }
	   },
	   yAxis: {
	      gridLineColor: '#666666',
	      labels: {
		 style: {
				color : '#c0c0c0',
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
			}
	      },
	      lineColor: '#666666',
	      minorGridLineColor: '#666666',
	      tickColor: '#666666',
	      title: {
			 style: {
					color : '#c0c0c0',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '11px',
					}
	      }
	   },
	   tooltip: {
	      backgroundColor: '#2e2e2e',
		  borderColor:null,
	      style: {
				padding: 10,
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
				color:'#c6c6c6'
			}
	   },
	   legend: {
		   	align:"center",
			squareSymbol:false,
			borderRadius:1,
			symbolRadius:5,
			//maxHeight:55,
			margin:15,
			padding:3,
			symbolWidth:15,
			itemMarginBottom:4,
			itemMarginTop:-1,
			//itemWidth:150,
			lineHeight:17,
			itemHoverStyle:{"color":"#c0c0c0"},
			navigation: {
				arrowSize: 8,
				activeColor: '#c0c0c0',
				inactiveColor:'#c0c0c0',
				style: {
				    fontWeight: 'bold',
				    color: '#c0c0c0',
				    fontSize: '9px'
				}
			},
			itemStyle: {
					color : '#c0c0c0',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '12px',
				},
			},
	   labels: {
			style: {
				color : '#c0c0c0',
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
	      }
	   },
		plotOptions:{
				series:{
				dataLabels:{
					color:'#c0c0c0'	
				}
			}
	   
	   }
	};
	return darkTheme;
}

function getCombinationLightTheme(ytitleColors)
{
	console.log( ytitleColors );
	//ytitleColor = ( ytitleColor == "" || ytitleColor == 'null' || ytitleColor == 'undefined' || ytitleColor == undefined )?'#c0c0c0':ytitleColor;
	var lightTheme = {
	   chart: {
			plotBorderColor : 'transparent',
			backgroundColor:'transparent',
	   },
	   title: {
			style: {
				color : '#2a292a',
				fontFamily:'Roboto',
				fontSize: '14px',
				fontWeight:'400'
			}
	   },
		subtitle: {
			style: {
				color : '#2a292a',
				fontFamily:'Roboto',
				fontSize: '11px',
				fontWeight:'400'
			}
		},
	   xAxis: {
			gridLineColor: '#e1e1e1',
			labels: {
				style: {
					color : '#969696',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '11px',
				}
			},
			lineColor: '#e1e1e1',
			minorGridLineColor: '#e1e1e1',
			tickColor: '#e1e1e1',
			title: {
				style: {
					color : '#969696',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '11px',
					}
			}
		},
		yAxis: [{
			gridLineColor: '#e1e1e1',
				labels: {
				 style: {
					color : '#969696',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '11px',
				}
			},
			lineColor: '#e1e1e1',
			minorGridLineColor: '#e1e1e1',
			tickColor: '#e1e1e1',
			title: {
			style: {
				color: ytitleColors[0],
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '11px',
				}
			}
		},{
			gridLineColor: '#e1e1e1',
				labels: {
				 style: {
					color : '#969696',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '11px',
				}
			},
			lineColor: '#e1e1e1',
			minorGridLineColor: '#e1e1e1',
			tickColor: '#e1e1e1',
			title: {
			style: {
				
				color: ytitleColors[1],
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
				}
			}
		}],
		tooltip: {
			style: {
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
			}
		},
		legend: {
			itemStyle: {
					color : '#707070',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '12px',
				},
			},
		labels: {
			style: {
			color : '#707070',
			fontWeight:'400',
			fontFamily: 'Roboto',
			fontSize: '12px',
			}
		},
	};
	return lightTheme;
}
function getCombinationDarkTheme(ytitleColors)
{
	var darkTheme = {
	   chart: {
			plotBorderColor : 'transparent',
			backgroundColor:'transparent',
			plotBackgroundColor: 'transparent',
	   },
	   title: {
	      style: {
			color : '#c0c0c0',
			fontFamily:'Roboto',
			fontSize: '14px',
			fontWeight:'400'
			}
	   },
		subtitle: {
			style: {
			color : '#c0c0c0',
			fontFamily:'Roboto',
			fontSize: '12px',
			fontWeight:'400',

	      }
	   },
	   xAxis: {
	      gridLineColor: '#666666',
	      labels: {
		 style: {
				color : '#c0c0c0',
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
			}
	      },
	      lineColor: '#666666',
	      minorGridLineColor: '#666666',
	      tickColor: '#666666',
	      title: {
		 style: {
				color : '#c0c0c0',
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
				}
	      }
	   },
	   yAxis: [{
	      gridLineColor: '#666666',
	      labels: {
		 style: {
				color : '#c0c0c0',
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
			}
	      },
	      lineColor: '#666666',
	      minorGridLineColor: '#666666',
	      tickColor: '#666666',
	      title: {
		 style: {
				color: ytitleColors[0],
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
				}
	      }
	   },{
	      gridLineColor: '#666666',
	      labels: {
		 style: {
				color : '#c0c0c0',
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '10px',
			}
	      },
	      lineColor: '#666666',
	      minorGridLineColor: '#666666',
	      tickColor: '#666666',
	      title: {
		 style: {
				color: ytitleColors[1],
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
				}
	      }
	   }],
	   tooltip: {
	      backgroundColor: '#161616',
		  borderColor:'#0c0c0c',
	      style: {
				padding: 10,
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
			}
	   },
	   legend: {
	      itemStyle: {
					color : '#707070',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '12px',
				},
			},
	   labels: {
			style: {
				color: '#c0c0c0',
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '11px',
	      }
	   },
	};
	return darkTheme;
}
function getMyDashboardCombinationTheme(strSkin)
{
	var themeObj=null;
	if(strSkin!=null && (strSkin=='dark' || strSkin=='Dark')){
		themeObj = {
		   chart: {
				plotBorderColor : 'transparent',
				backgroundColor:'transparent',
				plotBackgroundColor: 'transparent',
		   },
		   title: {
			  style: {
				color : '#2a292a',
				fontFamily:'Roboto',
				fontSize: '13px',
				fontWeight:'400',
				}
		   },
			subtitle: {
				style: {
			color : '#2a292a',
			fontFamily:'Roboto',
			fontSize: '12px',
			fontWeight:'400',

			  }
		   },
		   xAxis: {
			  gridLineColor: '#666666',
			  labels: {
			 style: {
					color : '#c0c0c0',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '11px',
				}
			  },
			  lineColor: '#666666',
			  minorGridLineColor: '#666666',
			  tickColor: '#666666',
			  title: {
			 style: {
					color : '#c0c0c0',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '11px',
					}
			  }
		   },
		   tooltip: {
			  backgroundColor: '#161616',
			  borderColor:'#0c0c0c',
			  style: {
					padding: 10,
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '11px',
				}
		   },
		   legend: {
			  itemStyle: {
						color : '#707070',
						fontWeight:'400',
						fontFamily: 'Roboto',
						fontSize: '12px',
					},
				},
		   labels: {
				style: {
					color: '#c0c0c0',
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '11px',
			  }
		   },
		};
	}
	else
	{
		themeObj = {
		   chart: {
				plotBorderColor : 'transparent',
				backgroundColor:'transparent',
		   },
		   title: {
				style: {
					color : '#333333',
					fontFamily:'Roboto',
					fontSize: '12px',
				}
		   },
			subtitle: {
				style: {
					color:  '#333333',
					fontWeight:'400',
					fontFamily:'Roboto',
					fontSize: '11px',
				}
			},
		   xAxis: {
				gridLineColor: '#dedede',
				labels: {
					style: {
						color : '#606060',
						fontWeight:'400',
						fontFamily: 'Roboto',
						fontSize: '10px',
					}
				},
				lineColor: '#dedede',
				minorGridLineColor: '#dedede',
				tickColor: '#dedede',
				title: {
					style: {
						color: '#606060',
						fontWeight:'400',
						fontFamily:'Roboto',
						fontSize: '11px',
						}
				}
			},

			tooltip: {
				style: {
					fontWeight:'400',
					fontFamily: 'Roboto',
					fontSize: '11px',
				}
			},
			legend: {
				itemStyle: {
						color : '#2a292a',
						fontWeight:'400',
						fontFamily: 'Roboto',
						fontSize: '10px',
					},
				},
			labels: {
				style: {
				color: '#2a292a',
				fontWeight:'400',
				fontFamily: 'Roboto',
				fontSize: '10px',
				}
			},
		};
	}
	return themeObj;
}
