//jQuery.getScript("/final/scripts/utilities/EgChartTheme.js");
jQuery.getScript("/final/scripts/utilities/EgCommonChartTheme.js");
function getHighChartForTimeLine(container_Id,jsonData,width,height,maxURL)
{
	var me = this;
	var toolTipFmt = '';
	var setyaxismin = 'False';
	var timezoneOffsetValue='';
	var timeline_out_format = '';
	var ymax = jsonData['maxRange'];
	var commonmax= jsonData['commonmaxRange']
	timezoneOffsetValue = jsonData['timezoneOffsetValue']

	ymin = jsonData['minRange'];
	fontFamily = jsonData['fontName'];
	fontSize = jsonData['fontsize'];
	startTime = jsonData['lowerLimit'];
	yaxisTitle = jsonData['yLabel'];
	if(yaxisTitle==null || yaxisTitle==undefined || yaxisTitle=="")
	{
		yaxisTitle = jsonData['yAxisLabel'];
	}

	LegendPosition = jsonData['LegendPosition'];
	showLegend = jsonData['showlegendFont'];
	xLabel = jsonData['xLabel'];
	if(xLabel==null || xLabel==undefined || xLabel=="")
	{
		xLabel = jsonData['axislabel'];
	}
	LegendFont = jsonData['LegendFont'];
	chartType = jsonData['chartType'];
	var line_width=jsonData['LineWidth'];
	var reportType=jsonData['reportType'];
	var s_time_fout = jsonData['TimeFormatOut'];
	var s_showdisconnectedline = jsonData['showdisconnectedline'];
	var isCumulationReport = jsonData['isCapacityCumulationReport'];

	var enableTitle = false;
	var chartTitle = "";
	enableTitle = jsonData['enableTitle'];
	chartTitle = (enableTitle)?jsonData['title']:'';

	var titleYRange=null;

	var isLegendEnabled = true;
	var tmpEnabled = jsonData['legendEnabled'];
	isLegendEnabled = tmpEnabled;
	isLegendEnabled = (Ext.isEmpty(isLegendEnabled))?true:isLegendEnabled;

	var showdisconnectedline=true;
	if(s_showdisconnectedline != null && s_showdisconnectedline =='No') 
		showdisconnectedline = false;
	yaxisTitle =(yaxisTitle == null || yaxisTitle == '')?'':yaxisTitle;
	YtitleEnable =(yaxisTitle == null || yaxisTitle == '')?false:true;
	commonmax =(commonmax == null || commonmax == 0)?null:commonmax;
	ymax =(ymax == null || ymax == 0)?null:ymax;
	if(yaxisTitle == '%' || yaxisTitle =='(%)')
	{
		if(ymax>90)
			commonmax =(commonmax == null || commonmax == 0)?100:commonmax;
	}
	spacing=[0, 0, 0, 0];
	if(commonmax == null || commonmax == 0)
		commonmax=ymax;
	ymin =(ymin == null )?0:ymin;
	if(ymin ==ymax )
		ymax = ymin+1;
	var mpad = null;
	if(setyaxismin!=null && setyaxismin =='True')
	{
		ymin=null;
		mpad=0;
	}
	if(chartType == 'timeline')
		chartType='line';
	fontFamily='Arial';
	LegendFont='Arial';
	var bgcolor='rgba(255, 255, 255, 0.85)';
	var seriesCounter = 0;
	var XaixLineWidth=1;
	var YaixLineWidth=0;
	var linecount=0;
	if(!(jsonData['DataSet'] == "" || jsonData['DataSet'] == 'null' || jsonData['DataSet'] == 'undefined' || jsonData['DataSet'] == undefined))
	{
		if(jsonData['DataSet'].length>10 && (LegendPosition == undefined || LegendPosition == 'undefined') ){
			LegendPosition = 'right';
		}
		seriesCounter=jsonData['DataSet'].length;
		if(jsonData['DataSet'].length==1)
		{
			bgcolor=jsonData['DataSet'][0]['color'];
		}
		linecount=jsonData['DataSet'].length;
	}
	yaxisTitle =(yaxisTitle == null || yaxisTitle == '')?jsonData['ylabel']:yaxisTitle;
	line_width =(line_width == null || line_width == '')?1:line_width;
	if(yaxisTitle!=null && yaxisTitle.length>0)
	{
		if(yaxisTitle.length>32){
			var strtt1 = yaxisTitle.substring(32);
			if(strtt1.length>3)
				yaxisTitle = yaxisTitle.substring(0,32)+"...";
		}
	}
	
	if(YtitleEnable==false)
	YtitleEnable =(yaxisTitle == null || yaxisTitle == '')?false:true;

	xLabel =(xLabel == null || xLabel == '')?'':xLabel;
	xtitleEnable =(xLabel == null || xLabel == '')?false:true;
	fontFamily =(fontFamily == null || fontFamily == '')?'Arial':fontFamily;
	fontSize =(fontSize == null || fontSize == '')?'10px':fontFamily+"px";
	startTime =(startTime == null || startTime == '')?null:startTime;
	LegendPosition =(LegendPosition == null || LegendPosition == '' || LegendPosition == 'top')?'center':LegendPosition;
	LegendFont =(LegendFont == null || LegendFont == '')?'Arial':LegendFont;
	s_time_fout =(s_time_fout == null || s_time_fout == '')?'HH:mm':s_time_fout;
	timeline_out_format = getTimeLineOutputFormat(s_time_fout);
	legendWidth = (LegendPosition == 'right')?400:400;
	needLegendFormat = (LegendPosition == 'right')?'true':'false';
	maxLegendHeight = (LegendPosition == 'right')?null:37;
	
	maxLegendHeight=45;
	if(((linecount*8)/37)>1)
		maxLegendHeight=37;
	if(linecount<2)
		legendWidth=190;
	valign = (LegendPosition == 'right')?'middle':'top';
	LegendPosition='center';
	if(legendWidth>190 && valign =='top')
		LegendPosition='right';

	var chartFor = jsonData['chartFor'];
	var yAxisLabelYval = jsonData['yAxisLabelYval'];
	var xType = 'datetime';
	var stacked = null;
	var marker_enabled =false;
	var tooltipObj =null;
	over_line_width=line_width-2;
	if(over_line_width == 0)
		over_line_width = line_width
	var yVal = "";
	if(s_time_fout == "HH:mm")
	{
		yVal = 33;
	}
	else
	{
		yVal = 20;
		if(yAxisLabelYval!=null && yAxisLabelYval=='21')
			yVal = 21;
	}		
	if(xtitleEnable)
	{
		if(s_time_fout == "HH:mm")
		{
			yVal = 10;
			if(yAxisLabelYval!=null)
				yVal = 30;
		}else
		if(s_time_fout.indexOf("HH:mm:ss")>-1)
		{
			yVal = 60;
			if(yAxisLabelYval!=null)
				yVal = 21;
		}
		else
		{
			if(isCumulationReport != null &&  isCumulationReport != '' && isCumulationReport!=undefined && isCumulationReport!='undefined')
				yVal = 20;
			else
				yVal = 48;
			if(yAxisLabelYval!=null && yAxisLabelYval=='21')
				yVal = 21;
		}
	}
	if(xtitleEnable && YtitleEnable)
		spacing=[0, 0, 10, 10];
	if(xtitleEnable )
		spacing=[0, 0, 0, 10];
	if(YtitleEnable )
		spacing=[0, 0, 10, 0];

	var showLegends = false;
	var strShowLeg= jsonData['showLegends'];
	if(strShowLeg!=null && strShowLeg == 'true')
		showLegends= true;
	if(chartType!=null && chartType=='stack')
	{
		chartType = 'area',
		stacked ='normal';
	}
	if(chartType!=null && chartType=='scatter')
	{
		xType = null;
		line_width = null;
		marker_enabled = true;
		tooltipObj ={
					//headerFormat: '',
					pointFormat: yaxisTitle+':  {point.x}<br>'+xLabel+':  {point.y}'
				}
	}
	var yRange=-25;
	var marginTopVal=0;
	if (reportType=='TCR')
	{
		spacing=[35, 5, 0, 20];
		yRange=-35;
	}
	var chartTopSpacing=20;
	if(enableTitle && isLegendEnabled)
	{
		titleYRange=-50;
		yRange=-50;
		chartTopSpacing=40;
	}
	else if((!enableTitle) && isLegendEnabled)
	{
		//titleYRange=-30;
		chartTitle="";
		yRange=-35;
		chartTopSpacing=64;
		marginTopVal=80;
	}

	var xRange=0;
	if(width>1000)
	{
		if (jsonData['DataSet']!='undefined' && jsonData['DataSet']!=undefined && jsonData['DataSet']!=null && jsonData['DataSet']!='')
		{
			if (jsonData['DataSet'].length==1)
			{
				xRange = 80;
			}
			else if (jsonData['DataSet'].length==2)
			{
				xRange = 280;
			}
			else if (jsonData['DataSet'].length>=3 && jsonData['DataSet'].length<=4)
			{
				xRange = 300;
			}
			else if (jsonData['DataSet'].length>=5 && jsonData['DataSet'].length<=8)
			{
				xRange = 110;
			}
			else if(jsonData['DataSet'].length>8)
			{
				xRange = -10;
			}
		}
	}
	else if(width<1000)
	{
		if (jsonData['DataSet']!='undefined' && jsonData['DataSet']!=undefined && jsonData['DataSet']!=null && jsonData['DataSet']!='')
		{
			if (jsonData['DataSet'].length==1)
			{
				xRange = 100;
			}
			else if (jsonData['DataSet'].length==2)
			{
				xRange = 110;
			}
			else if (jsonData['DataSet'].length>=3 && jsonData['DataSet'].length<=8)
			{
				xRange = 30;
			}
			else if(jsonData['DataSet'].length>8)
			{
				xRange = 10;
			}
		}
	}
	var spacing_top = jsonData['spacingTop'];
	var spacing_left = jsonData['spacingLeft'];
	var margin_top = jsonData['marginTop'];
	if (spacing_top==null || spacing_top==undefined || spacing_top=='')
	{
		spacing_top=20;
	}
	if (spacing_left==null || spacing_left==undefined || spacing_left=='')
	{
		spacing_left=5;
	}
	if (margin_top==null || margin_top==undefined || margin_top=='')
	{
		margin_top=20;
	}
	var forCumulationExcelGraph=false;
	var vertAlign='top';
	var legval=28;
	var itemWidth=null;
	var chartBottom=null;
	var cumationExcelGraph= jsonData['cumationExcelGraph'];
	var cumationGraphPrintPage= jsonData['forCumulationPrint'];
	if(cumationExcelGraph!=null && cumationExcelGraph == 'true')
		forCumulationExcelGraph=true;
	if(cumationGraphPrintPage!=null && cumationGraphPrintPage == 'yes'){
		itemWidth=290;
		maxLegendHeight=null;
		vertAlign='bottom';
		legval=56;
		chartBottom=150;
		legendWidth=870;
		var len=jsonData['DataSet'].length;
		if(len <= 20){
			var chartBottom=(((len/3)*15)+chartBottom);
			height+=chartBottom;
		}
		yRange=0;
	}
	if(forCumulationExcelGraph){
		itemWidth=300;
		maxLegendHeight=null;
		chartBottom=180;
		var chartBottomVal= jsonData['chartBottomVal'];
		if(chartBottomVal !='undefined' && chartBottomVal !=undefined && chartBottomVal!=null && chartBottomVal!='')
			chartBottom=chartBottomVal;
		legendWidth=900;
		vertAlign='bottom';
		legval=56;
		yRange=0;
	}

   me.chartOptions ={
		chart: {
			plotBorderWidth: 0,
			type : chartType,
			plotBackgroundColor: 'white',
			plotBorderColor : '#e5e5e5',
			backgroundColor:'#ffffff',
			plotShadow: false,
			marginBottom:chartBottom,
			spacingBottom: 1,
			//spacingTop: 1,
			shadow: false,
			padding:0,
			//marginTop:marginTopVal,
			spacing:[chartTopSpacing, 10, 5, 5],
			//height:height-20,
			events: {
					load: function(event) {
						$('.highcharts-legend-item rect').attr('height', '6').attr('y', '7');
						$('.highcharts-legend-item rect').attr('width', '6').attr('x', '10');
					}
				}
		},
		yAxis: {
			min: ymin,
			minPadding :mpad,
			max : commonmax,
			gridLineWidth: YaixLineWidth,
			lineWidth: 1,
			border :0,
			startOnTick: false,
			tickPixelInterval: 50,
			gridLineColor: '#dedede',
			lineColor: '#dedede',
			minorGridLineColor: '#dedede',
			tickColor: '#dedede',
			labels: {
				align: 'right',
				x: -10,
				y: 3,
				formatter: function() {
					var val = Highcharts.numberFormat (this.value,4, '.','');
					val = (parseFloat(val));
					return val;
				},
				style: {
					fontWeight:'normal',
					fontFamily: 'Arial',
					fontSize: '12px',
					textDecoration: 'none',
					whiteSpace: 'normal'
				},
			},
			title: {
				text: yaxisTitle,
				enabled:YtitleEnable,
				style: {
					color: '#606060',
					fontWeight:'500',
					fontFamily:'Arial',
					fontSize: '11px'					
				},
			},
			showLastLabel: true,
		},
		xAxis: {
			border :1,
			lineWidth: 1,
			minPadding:0.02,
			maxPadding:0.02,
			ordinal: false,
			showLastLabel: true,
			endOnTick: true,
			showFirstLabel: true,
			startOnTick: false,
			type : xType,
			gridLineWidth: XaixLineWidth,
			gridLineColor: '#dedede',
			lineColor: '#dedede',
			minorGridLineColor: '#dedede',
			tickColor: '#dedede',
			tickWidth:0,
			labels: {
				rotation:270,
				//x:5,
				y:yVal,
				formatter: function() {
					if(xType == null){
						var val = Highcharts.numberFormat (this.value,4, '.','');
						val = (parseFloat(val));
						return  val;
					}else
					return  Highcharts.dateFormat(timeline_out_format, this.value);
				},
				style: {
					fontWeight:'normal',
					fontFamily: 'Arial',
					fontSize: '12px',
				},
				overflow: 'justify',
				useHTML: false,
			},
			title: {
				text: xLabel,
				enabled:xtitleEnable,
				style: {
					color: '#606060',
					fontWeight:'500',
					fontFamily:'Arial',
					fontSize: '11px'
					},
				},
			dateTimeLabelFormats: {
				minute: timeline_out_format,
				hour: timeline_out_format,
				day:timeline_out_format,
				month:timeline_out_format,
				year:timeline_out_format
			}
		},
		plotOptions: {
			series: {
				connectNulls : showdisconnectedline,
				shadow:false,
				lineWidth : line_width,
				smoothed: true,
				marker: {
					enabled: marker_enabled,
				},
				stacking: stacked,
				states: {
					 hover: {
						enabled: true,
						lineWidth: line_width
					}
				},
			},
			line: {
				shadow: false,
				linewidth :10
			}
		},
		legend: {
			enabled: isLegendEnabled,
			verticalAlign: vertAlign, 
			width:legendWidth+20,
			align:LegendPosition,
			//y:-25,
			y:yRange,
			//x:xRange+40,
			x:xRange,
			//itemMarginBottom: 4,
			//itemDistance:5,
			layout: 'horizontal',
			borderWidth: 0,
			maxHeight :maxLegendHeight,
			//itemWidth:itemWidth,
			itemStyle: {
				textAlign: 'center',
				color : '#2a292a',
				fontWeight:'Normal',
				fontFamily: 'Arial',
				fontSize: '10px',
			},
			labelFormatter: function() {
				var retrunvar = this.name;
				if(retrunvar.length>legval && needLegendFormat == 'true')
				{
					c=0;
					strval=''
					while(c<retrunvar.length)
					{
						strval+=retrunvar.substring(c,c+legval)+'<br>';
						c=c+legval;
					}
					retrunvar= strval;
				}
				return retrunvar;
			},
			/*navigation: {
				arrowSize: 8,
				activeColor: '#707070',
				inactiveColor:'#707070',
				style: {
				    fontWeight: 'bold',
				    color: '#707070',
				    fontSize: '12px'
				}
			},*/
		},
		rangeSelector: {
			enabled: false
		},
		global: {
			useUTC: true,
			timezoneOffset: timezoneOffsetValue
		},
		navigator: {
			enabled: false
		},
		scrollbar: {
			enabled: false
		},
		labels :{
			style: {
			color: '#2a292a',
			fontWeight:'normal',
			fontFamily: 'Arial',
			fontSize: '10px',
			}
		},
		exporting: {
			enabled: false
		},
		credits: {
			enabled: false
		},
		title: {
			align:'left',
			//text: '',
			text:chartTitle,
			//offset: '',
			margin: 0,
			//y: -30,
			y: titleYRange,
			x:-5,
			style: {
				color : '#2a292a',
				fontWeight:'500',
				fontFamily:'Roboto',
				fontSize: '14px',
			}
		},
		subtitle: {
			style: {
				color:  '#333333',
				fontWeight:'500',
				fontFamily:'Roboto',
				fontSize: '11px',
			}
		},
		tooltip: {
			xDateFormat:'%d-%b-%y %H:%M:%S',
			valueDecimals: 4,
			//backgroundColor : bgcolor,
			borderWidth: 1,
			shared: true,
			formatter: function() {
				var items = this.points || splat(this),
				series = items[0].series,s;
				// sort the values
				items.sort(function(a, b){
					return ((a.y > b.y) ? -1 : ((a.y < b.y) ? 1 : 0));
				});
				var s ='';
				/*if(legendSize==1 || (strSkin=='Dark' || strSkin=='dark') )
					s = '<span style="color:white">'+Highcharts.dateFormat ('%d-%b-%y %H:%M:%S',this.x,true)+'</span><br/>';
				else*/
					s = '<span>'+Highcharts.dateFormat ('%d-%b-%y %H:%M:%S',this.x,true)+'</span><br/>'
				jQuery.each(this.points, function(i, point) {
					var val = Highcharts.numberFormat (point.y,4, '.','');
					var val_ar = val.split('.');
					if(val_ar.length>1)
					{
						if(val_ar[1]=='0000')
							val = val_ar[0];
					}
					//if (point.series.name != '' && point.series.name != undefined && isLegendEnabled) {
					if (point.series.name != '' && point.series.name != undefined ) {
						/*if(legendSize==1)
							s += '<b><span style="color:white">'+ point.series.name +' :  '+val+'</span></b><br/>';
						else*/
							s += '<b><span style="color:' + this.series.color + '">'+ point.series.name +'  :  '+val+'</span></b><br/>';
						//s += '<br/>'+ point.series.name +': <b>'+val+'</b>';
					}
					else
					{
						s += '<br/> <b><span style="color:white">'+val+'</span></b><br/>';
					}
				});
				return s;
			}
			
		},
		series: jsonData['DataSet']
	}

	me.chartOptions.chart.forExport=true;
	me.chartOptions.chart.renderTo=container_Id;
	Highcharts.setOptions({
		lang: {
			thousandsSep: ''
		}
	});
	Highcharts.setOptions({
		global: {
			useUTC: true,
			timezoneOffset:timeZoneOffsetVal
		}
	});
	Highcharts.seriesTypes.line.prototype.drawLegendSymbol =  Highcharts.seriesTypes.area.prototype.drawLegendSymbol;
	me.chartOptions = jQuery.extend(true, me.chartOptions, getUserThemeFor(strSkin,'','',false));
	var chart;
	chart = new Highcharts.Chart(me.chartOptions,function(chart) 
	{
		jQuery('.showLegend').click(function () {
			if(!Ext.isEmpty(Ext.getCmp('er_chart_checkbox')) && Ext.getCmp('er_chart_checkbox') != null && Ext.getCmp('er_chart_checkbox') != undefined)
			{
				chart = $('#'+container_Id).highcharts();
				try
				{
					var checkedValues = Ext.getCmp('er_chart_checkbox').getChecked();
				}
				catch (ert)
				{
					var checkedValues = Ext.getCmp('er_chart_checkbox').checked;
				}
				if(checkedValues!=undefined && checkedValues!=null && checkedValues)
				{
					chart.legendShow();
				}
				else
				{
					chart.legendHide();
				}
			}
			else
			{
				chart.legendToggle();
			}
		});
	});		
	return chart;
}

function getHighChartForBar(container_Id,jsonData,chartWidth,chartHeight,maxURL)
{
		var toolTipFmt = '';
		var timezoneOffsetValue='';
		var chartType = 'bar';
	    var setStacking='normal'
		var setMinPointLength=0;
		var setendOnTick=true;
		var enable_Format=jsonData['enable_Format'];
		var enable_values=jsonData['enable_values'];
		var formatForPieChartVal=jsonData['formatForPieChart'];
		var formatForLegendOnlyPercentage=jsonData['formatForLegendOnlyPercentage'];
		var formatForPieChart="";
		var enableNameandValue=jsonData['enableNameandValueinTooltip'];
		if(enable_Format != null && enable_Format != 'undefined')
		{
			enable_Format="";
			formatForPieChart='{point.name}';
		}else{
			formatForPieChart='{point.name}:{point.percentage:.1f} %';
		}

		if(enable_values != null && enable_values != 'undefined')
		{
			enable_Format="";
			formatForPieChart='{point.y}';
		}else{
			formatForPieChart='{point.y}:{point.percentage:.1f} %';
		}
		if(formatForPieChartVal != "" && formatForPieChartVal != 'null' && formatForPieChartVal != 'undefined' && formatForPieChartVal != undefined)
            formatForPieChart='{point.name}'+formatForPieChartVal+'{point.percentage:.1f} %';
		if(formatForLegendOnlyPercentage == true || formatForLegendOnlyPercentage== 'true')
		      formatForPieChart='{point.percentage:.1f} %';
		if(enableNameandValue != null && enableNameandValue != 'undefined')
		{
			formatForPieChart='{point.name} {point.y} %';
		}
		var insidePos= jsonData['inside'];
		fontFamily = jsonData['fontName'];
		fontSize = jsonData['fontsize'];
		yaxisTitle = jsonData['yAxisLabel'];
		LegendPosition = jsonData['LegendPosition'];
		showLegend = jsonData['showlegendFont'];
		xLabel = jsonData['xAxisLabel'];
		var xLabelText = jsonData['xAxisLabelText'];
		var isExecutiveReport = jsonData['isExecutiveReport'];
		LegendFont = jsonData['LegendFont'];
		chartType = jsonData['chartType'];
		if(chartType == 'linePlain')
			chartType = 'line';
		yaxisTitle =(yaxisTitle == null || yaxisTitle == '')?'':yaxisTitle;
		YtitleEnable =(yaxisTitle == null || yaxisTitle == '')?false:true;
		fontFamily='Arial';
		LegendFont='Arial';
		yaxisTitle =(yaxisTitle == null || yaxisTitle == '')?jsonData['yAxisLabel']:yaxisTitle;
		xLabel =(xLabel == null || xLabel == '')?'':xLabel;
		xLabelText =(xLabelText == null || xLabelText == '')?'':xLabelText;
		titleEnable =(xLabelText == null || xLabelText == '')?false:true;
		fontFamily =(fontFamily == null || fontFamily == '')?'Arial':fontFamily;
		fontSize =(fontSize == null || fontSize == '')?'10px':fontFamily+"px";
		LegendPosition =(LegendPosition == null || LegendPosition == '' || LegendPosition == 'top')?'center':LegendPosition;
		LegendFont =(LegendFont == null || LegendFont == '')?'Arial':LegendFont;
		legendWidth = (LegendPosition == 'right')?190:400;
		needLegendFormat = (LegendPosition == 'right')?'true':'false';
		maxLegendHeight = (LegendPosition == 'right')?null:50;
		//valign = (LegendPosition == 'right')?'middle':'top';
		valign=LegendPosition;
		var showLegends =jsonData['legend'];
		if(showLegends == "" || showLegends == 'null' || showLegends == 'undefined' || showLegends == undefined)
			showLegends=false;
		else if(showLegends == 'true')
			showLegends=true;
		else if(showLegends == 'false')
			showLegends=false;
		if(insidePos == "" || insidePos == 'null' || insidePos == 'undefined' || insidePos == undefined)
			insidePos=false;
		else if(insidePos == 'true')
			insidePos=true;

		var enableTitle = false;
		var chartTitle = "";
		enableTitle = jsonData['enableTitle'];
		chartTitle = (enableTitle)?jsonData['title']:'';

		chartTitle =(chartTitle == null || chartTitle == '')?'':chartTitle;
		var spacingTop=0;
		if(chartTitle=="")
			spacingTop=50;
       //var setGroupPadding=-0.1;
		var setGroupPadding=-0.065;
		var setPointPadding=0.1;// default value
		var data=jsonData['DataSet'];
		var rotateDegree=0;
		var dataLabelColor='#FFFFFF';
		var chartSubType=jsonData['chartSubType'];
		var drilDown=jsonData['drildown'];
		var setPointWidth=null;
		var setCursor=null;
		var isUptimeChart=jsonData['uptime'];
		var isReporterHome=jsonData['isReporterHome'];
		var space =[10, 10, 10, 10];
		var yaixlinewidth=0;
		var xtickwidth=0;
		var ticklength=10;
		var xval=-10;
		var ymax=null;
		var ymin=0;
		var xmin=0;
		var yVal=2;
		var isHypervisorResoucesChart=jsonData['isHypervisorChart'];
		var showInLegend = false;
		var legendLocation='top'
		
		if(jsonData['LegendPosition']!= null && jsonData['LegendPosition']!= ''){
			 legendLocation = jsonData['LegendPosition'];
		}
		if(isUptimeChart!=null && isUptimeChart=='uptimechart'){
			if(jsonData['LegendPosition']!= null && jsonData['LegendPosition']!= ''){
				 legendLocation = jsonData['LegendPosition'];
			}
		}

		ymax = jsonData['ymax'];
		if(ymax == "" || ymax == 'null' || ymax == 'undefined' || ymax == undefined)
			ymax=null;
		
		ymin = jsonData['minRange'];
		if(ymin == "" || ymin == 'null' || ymin == 'undefined' || ymin == undefined)
			ymin=0;
		
		xmin = jsonData['minRangexaxis'];
		if(xmin == "" || xmin == 'null' || xmin == 'undefined' || xmin == undefined)
			xmin=0;


		if(yaxisTitle == '%' || yaxisTitle =='(%)')
			ymax = "100";

		if(!showLegends)
		{
			if(chartSubType!=null && chartSubType=='stacked'){
				if(chartType!=null &&chartType=='column')
					if(chartTitle == null || chartTitle == '')
						space=[40, 10, 10, 10];
				if(isExecutiveReport!=null && isExecutiveReport)
					space=[20, 10, 10, 10];
			}
		}
		if(drilDown!=null && (drilDown=='sametab'||drilDown=='newtab'))
		{
			setCursor='pointer';
		}
		if(data!=null && data.length>=1)
		{
			var xx=data[0].data;
			if(xx.length==1)
			{
				setGroupPadding=0.2;
				setPointPadding=0.4;
			}
			else if(xx.length>1 && xx.length<=4)
			{
				setGroupPadding=0.2;
				setPointPadding=0.3;
			}

			if(chartType!=null &&chartType=='column')
			{
				 setPointWidth=27;
					
					if(xx.length>50)
				    {
					setPointWidth=3;
					}
					else if(xx.length>45)
				    {
					setPointWidth=5;
					}
					else if(xx.length>40)
				    {
					setPointWidth=8;
					}
					else if(xx.length>32)
				    {
					setPointWidth=10;
					}
					else if(xx.length>21)
				    {
					setPointWidth=12;
					}
					else if(xx.length>15)
				    {
					setPointWidth=17;
					}
					else if(xx.length>8)
				    {
					setPointWidth=20;
					}
					else if(xx.length<=8)
			        {
					   setGroupPadding=0.2;
					   setPointPadding=0.2;
			        }


					if(isHypervisorResoucesChart==true)
					{
					setPointWidth=12;
					if(yaxisTitle.indexOf('MB')>-1)
							setPointWidth=null;
					var isMonthlyChart=jsonData['isMonthlyChart'];
					if(isMonthlyChart==true)
							setPointWidth=null;
					}
			}

		}
		if(isHypervisorResoucesChart==true)
			xval=2;

		var isDataLabelEnable=jsonData['isDataLabelEnabled'];
		var isCombinationLineChart=jsonData['isCombinationLineChart'];
		var setMarkerEnable=true;
		var isEndOnTick=jsonData['endOnTick'];
		var percentEnableTick=jsonData['percentEnableTick'];
		if(isDataLabelEnable==false)
		{
			 isDataLabelEnable=false;
		}
		else if(isDataLabelEnable == "" || isDataLabelEnable == 'null' || isDataLabelEnable == 'undefined' || isDataLabelEnable == undefined)
		{
             isDataLabelEnable=true;
		}
			
		if(chartType!=null && chartType=='pie')
		{
			strpointFormat='';
			dataLabelColor='#2a292a';
		}else
		{
			strpointFormat='<b>:{point.y}</b>';
		}
		if(chartType!=null && (chartType=='column' ||chartType=='line' || chartType=='combinedChart' || chartType=='area' || chartType=='scatter'))
		{
			rotateDegree=-90;
			yVal=20;
			xval=2;
			if(chartSubType!=null && chartSubType=='stacked')
			{
				xtickwidth=1;
				ticklength=5;
			  strpointFormat= '{series.name}: <b>{point.y}</b><br/>';
			}
			else
			{
			strpointFormat='<b>:{point.y}</b>';
			}
		}
		if(chartType!=null && chartType=='bar')
		{
			yaixlinewidth=1;
			if(chartSubType!=null && chartSubType=='stacked')
			{
				dataLabelColor='#FFFFFF';
				setendOnTick=false;
				if(isUptimeChart!=null && isUptimeChart=='uptimechart')
				{
					setPointWidth=21;
					showLegends=true;
				}
				else
				{
					setPointWidth=20;
				}
			}
			else
			{
				//dataLabelColor='';
				setMinPointLength=10;
				//setPointWidth=21;
				setPointWidth=12;//changed as per citrix template
			}
		}
		if(chartType!=null && chartType=='line')
		{
			setStacking=null;
			strpointFormat= '{series.name}: <b>{point.y}</b><br/>';
	    }
		var fontweight="Normal";
		var fontsize="11px";
		var fontfamily='Arial';
		if(chartType!=null && chartType=='pie'){
			fontsize="11px"
			fontfamily='Arial';
			fontweight="500";
		}
		if(isCombinationLineChart==true)
		{
		setStacking=null;
        setMarkerEnable=false;
	    }
		if(yaxisTitle!=null && (yaxisTitle.indexOf('%')>-1 || yaxisTitle.indexOf('(%)')>-1))
		{
			if(ymax==null)
				setendOnTick=true;
		}
		if(isEndOnTick==false)
		{
			 setendOnTick=false;
		}
		var lablecolor='#2a292a';
		var connColor='#C0C0C0';
		var mychartwidth=chartWidth;
		var mychartheight=chartHeight;
		var marginTop=20;
		var isTopNReport=jsonData['isTopNReport'];

		if(chartType!=null && chartType=='bar')
		{
			if(chartSubType==null || chartSubType!='stacked')
				setendOnTick=true;
		}
		if(chartType!=null && (chartType=='line'))
		{
			setendOnTick=false;
		}

		if(percentEnableTick==true)
		{
			 setendOnTick=false;
		}
			
		var jsonXval=jsonData['xval'];
		if(jsonXval != "" && jsonXval != 'null' && jsonXval != 'undefined' && jsonXval != undefined )
		{
			xval=jsonXval;
		}
		var jsonYval=jsonData['yVal'];
		if(jsonYval != "" && jsonYval != 'null' && jsonYval != 'undefined' && jsonYval != undefined )
		{
			yVal=jsonYval;
		}
		var marginTopVal=jsonData['disablemarginTop'];
		if(marginTopVal != "" && marginTopVal != 'null' && marginTopVal != 'undefined' && marginTopVal != undefined && marginTopVal=="true")
		{
			marginTop=null;
		}
		var jsonXval=jsonData['xval'];
		if(jsonXval != "" && jsonXval != 'null' && jsonXval != 'undefined' && jsonXval != undefined )
		{
			xval=jsonXval;
		}
		var pieSize='80%';
		var pieSizeVal=jsonData['pieSize'];
		if(pieSizeVal != "" && pieSizeVal != 'null' && pieSizeVal != 'undefined' && pieSizeVal != undefined )
		{
			pieSize=pieSizeVal;
		}
		var centerlegendPostion=jsonData['centerlegendPostion'];

		var boldYaxisLabel=jsonData['boldYaxisLabel'];
		if(boldYaxisLabel != "" && boldYaxisLabel != 'null' && boldYaxisLabel != 'undefined' && boldYaxisLabel != undefined && boldYaxisLabel=="true" )
		{
			yaxisTitle="<b>"+yaxisTitle+"</b>";
		}
		var tooltipEnable=true
		var enableToolTip=jsonData['enableToolTip'];
		if(enableToolTip != "" && enableToolTip != 'null' && enableToolTip != 'undefined' && enableToolTip != undefined && enableToolTip=="false" )
		{
			tooltipEnable=false;
		}
		var pointRadius=4;
		var pointRadiusVal=jsonData['pointRadius'];
		if(pointRadiusVal != "" && pointRadiusVal != 'null' && pointRadiusVal != 'undefined' && pointRadiusVal != undefined && pointRadiusVal=="false" )
		{
			pointRadius=pointRadiusVal;
		}
		var tooltipPercent=false;
		var enableTooltpPercent=jsonData['enableTooltpPercent'];
		if(enableTooltpPercent != "" && enableTooltpPercent != 'null' && enableTooltpPercent != 'undefined' && enableTooltpPercent != undefined && enableTooltpPercent=="true" )
		{
			tooltipPercent=true;
		}
		if(isUptimeChart!=null && isUptimeChart=='uptimechart')
		{
			showLegends=true;
		}
		var legYval=-10;
		if(chartType!=null && chartType=='pie' && LegendPosition!=null && LegendPosition=='bottom' )
		{
			legYval=10;
		}
		var pieInnerSize='';
		var piechartTitleVAlign=null;
		var piechartTitleY=10;
		var isDoNut = false;
		if(chartType!=null && chartType=='donut')
		{
			chartType='pie';
			isDoNut = true;
			pieSize=jsonData['pieSize'];
			pieInnerSize=jsonData['innerSize'];

			if(pieSize == "" || pieSize == 'null' || pieSize == 'undefined' || pieSize == undefined)
				pieSize='150%';

			if(pieInnerSize == "" || pieInnerSize == 'null' || pieInnerSize == 'undefined' || pieInnerSize == undefined)
				pieInnerSize='100%';

			showLegends =jsonData['showlegend'];
			if(showLegends == "" || showLegends == 'null' || showLegends == 'undefined' || showLegends == undefined)
				showLegends=false;
			marginTop =jsonData['marginTop'];
			if(marginTop == "" || marginTop == 'null' || marginTop == 'undefined' || marginTop == undefined)
				marginTop='10';

			isDataLabelEnable=false;
			mychartheight = jsonData['chartHeight'];
			if(mychartheight == "" || mychartheight == 'null' || mychartheight == 'undefined' || mychartheight == undefined)
				mychartheight=chartHeight;
			mychartwidth = jsonData['chartWidth'];
			if(mychartwidth == "" || mychartwidth == 'null' || mychartwidth == 'undefined' || mychartwidth == undefined)
				mychartwidth=chartWidth;
			piechartTitleVAlign='middle';
			piechartTitleY=0;
		}

		//alert(setGroupPadding+","+setPointPadding);
		var titlestyle ={
					text: chartTitle,
		            align: 'center',
		            verticalAlign: piechartTitleVAlign,
		            y: piechartTitleY,
					style: {
						color : '#2a292a',
						fontWeight:'500',
						fontFamily:'Roboto',
						fontSize: '16px',
					}
			};
		if(isDoNut)
		{
			titlestyle= {
					   text: '',
						align: 'center',
						verticalAlign: piechartTitleVAlign,
						y: piechartTitleY,
					   useHTML:true,
						floating: true,
						offset: '',
						margin: 0,
						style: {
							color : '#2a292a',
							fontWeight:'500',
							fontFamily:'Roboto',
							fontSize: '16px',
						}
				   }
				}
		var chartOptions = {
			chart:{
				placeValuesInside:0,
				align:'center',
				plotBorderWidth: 0,
				height:chartHeight,
				width:mychartwidth,
				plotBackgroundColor: 'transparent',
				//plotBorderColor : '#e5e5e5',
				backgroundColor:'transparent',
				plotShadow: false,
				shadow: false,
				padding:0,
				//spacing:[spacingTop,0,0,0],
				spacing:[0,0,30,0],
				spacingTop:spacingTop,
				ignoreHiddenSeries:false,
				type : chartType,
				events: {
					load: function(event) {
						$('.highcharts-legend-item rect').attr('height', '6').attr('y', '7');
						$('.highcharts-legend-item rect').attr('width', '6').attr('x', '10');
					}
				}			
			},
			tooltip:{
				enabled:true,
				formatter: function() {
					var s ='';
					var val = Highcharts.numberFormat (this.y,4, '.','');
					var val_ar = val.split('.');
					if(val_ar.length>1)
					{
						if(val_ar[1]=='0000')
							val = val_ar[0];
					}
					//if(isMyDashboardHealthPieChart)
					if(false)
					{
						s += '<span style="color:'+this.point.color+'">'+this.point.name+'</b></span>';
					}
					else
					{
						if(this.hasOwnProperty('points') && !ismytooltip)
						{
							 $.each(this.points,function(i,point){
								if(chartType=='column')
								{
									if(isMyDashboard)
									{
										var color=this.point.color;
										var colorVal=point.series.color;
										
										var name=this.point.name;
										var nameVal=point.series.name;
										
										if(color == "" || color == 'null' || color == 'undefined' || color == undefined)
										{
											color=colorVal;
										}

										if(name == "" || name == 'null' || name == 'undefined' || name == undefined)
										{
											name=nameVal;
										}

										s += '<span style="color: ' +color + '">' +name+ ":" + point.y + "</span><br>";
										
									}else{
									  s+='<span style="color: '+point.series.color+'">'+point.series.name+': '
									  + ''+point.y+'</span><br>'
									}
								}
								else
								{
									var color=this.point.color;
									var colorVal=point.series.color;
									
									var name=this.point.name;
									var nameVal=point.series.name;
									var compnameVal=this.point.compname;

									if(compnameVal!=null && compnameVal!=undefined && compnameVal!="" && name!=null && name!=undefined && name!="")
										name=name+" ("+compnameVal+")";
									
									if(color == "" || color == 'null' || color == 'undefined' || color == undefined)
									{
										color=colorVal;
									}

									if(name == "" || name == 'null' || name == 'undefined' || name == undefined)
									{
										name=nameVal;
										if(compnameVal!=null && compnameVal!=undefined && compnameVal!="")
											name=nameVal+" ("+compnameVal+")";
									}

									//s += '<span style="color: ' +color + '">' +name+ ":" + point.y + "</span><br>";
									s += '<span >' +name+ ":" + point.y + "</span><br>";
								}
							});
						}
						else if( Ext.isEmpty(this.point) )
						{
							if(this.x == "" || this.x == 'null' || this.x == 'undefined' || this.x == undefined)
							{
								s += '<b><span style="color:'+tipColor+'">'+val+'</span></b>';
							}
							else
							{
								s += '<b><span style="color:'+tipColor+'">'+ this.x +'  :  '+val+'</span></b>';
							}
						}
						/*else if(ismytooltip)
						{
								s += '<b><span style="color:'+tipColor+'">'+ this.x +'  :  '+val+'</span></b>';
						}
						else if(isNetflowDashboardPieChart)
						{
							s += (Ext.isEmpty(this.point.legendLabel))?'<span style="color:'+this.point.color+'"><b >'+this.point.y+' ('+this.point.unit+')</b></span> ':'<span style="color:' + this.point.color + '">'+ this.point.legendLabel +'</span>';
						}*/
						else
						{
							s += (Ext.isEmpty(this.point.legendLabel)) ? '<span style="color:' + this.point.color + '">' + this.point.name + "</span> " : '<span style="color:' + this.point.color + '">' + this.point.legendLabel + "</span> " ;		
						}
					}
					return s;
				}			
			},
			title:titlestyle,
			yAxis: {
					//min:0,
					min:ymin,
					max:ymax,
					border :0,
					tickWidth:0,
					tickmarkPlacement: 'on',
					tickLength: 5,
					lineWidth:yaixlinewidth,
					reversedStacks: false,
					gridLineColor: '#e5e5e5',
					lineColor: '#e5e5e5',
					endOnTick:setendOnTick,
					showFirstLabel: true,
					startOnTick: true,
					showLastLabel: setendOnTick,
					labels: {
						 style: {
								fontWeight: 'Normal',
								fontFamily: 'Arial',
								fontSize: '10px',
							},
							formatter: function() {
								var val = Highcharts.numberFormat (this.value,4, '.','');
								val = (parseFloat(val));
								return val;
							}
						},
					title: {
						text: yaxisTitle,
						enabled: YtitleEnable,
						style: {
							color : '#636363',
							fontWeight: '500',
							fontFamily:'Arial',
							fontSize: '11px',
							},
						},
						tickPositioner: function(min,max){
						var act = min,
						ticks = [];
						this.tickAmount=1;
						var flag=false;
						var interval=this.tickInterval;
						var second=0;
						if(min==max)
						{
							if(max>1)
								max=max+1;
							else if(max==0){
								max=max+1;
								second=0
								flag=true;
							}
							else
							{
								max=max+0.1;
							}
						}
						var cc=1
						while(act <= max){
							if(cc==2 && flag)
								ticks.push(second);
							else
								ticks.push(act);
							act+= interval;
							cc++;
						}
						if(!flag)
							ticks.push(act);
					  return ticks;  
					},
				},
				xAxis: {
					min: xmin,
					//min: xmin,
					tickmarkPlacement: 'on',
					tickWidth:xtickwidth,
					tickLength: ticklength,
					categories: xLabel,
					gridLineWidth: 0,
					gridLineColor: '#e5e5e5',
					lineColor: '#e5e5e5',
					lineWidth:1,
					tickPixelInterval:50,
					border :1,
					minPadding:0.02,
					maxPadding:0.02,
					ordinal: false,
					endOnTick: true,
					showFirstLabel: true,
					startOnTick: true,
					labels: {
						rotation:rotateDegree,
						x:xval,
						y:yVal,
						overflow: 'justify',
						useHTML: false,
						 style: {
								fontWeight: 'Normal',
								fontFamily: 'Arial',
								fontSize: '10px',
								whiteSpace: 'nowrap'
							},
							formatter: function() {
								var val=this.value;
								var val2=val.toString();
								if(val!=null && val.length>15)
								{
									var val2=val.substring(15);
									if(val2.length>3)
										val=val.substring(0,15)+'...'
								}
								return val;
							}
						},
					title: {
						enabled: titleEnable,
						text:xLabelText,
						style: {
							color : '#636363',
							fontWeight: '500',
							fontFamily:'Arial',
							fontSize: '11px',
							},
						},
				},
			plotOptions: {
					 pie: {
						shadow: false,
						borderWidth: 0, // border color control
						size: pieSize,
						allowPointSelect: true,
						cursor: setCursor,
						showInLegend: showLegends,
						innerSize:pieInnerSize,
						dataLabels: {
							format:formatForPieChart,
							crop: false,
							overflow: 'none',
							connectorColor: connColor,
							softConnector: false,
							distance:15
						},
					 },
					bar:{
						shadow: false,
						cursor: setCursor,
						borderWidth: 0,
						depth: 0,
						pointWidth:setPointWidth,
						dataLabels:{
							enabled: true,
							crop: false,
							overflow: 'none',
							style:{
								textOutline: false,
								textShadow: false
							}
						},
					 },
					column:{
						shadow: false,
						cursor: setCursor,
						borderWidth: 0,
						depth: 0,
						pointWidth:setPointWidth,
					 },
					line:{
						shadow: false,
						cursor: setCursor,
						marker: {
							   enabled:setMarkerEnable,
								fillColor: '#FFFFFF',
								lineWidth: 0.5,
								lineColor: null ,
								symbol:'circle'
                                },
					 },
					series: {
							shadow: false,
							stacking: setStacking, 
							borderWidth: 0,
							depth: 0,
							groupPadding:setGroupPadding,
							pointPadding:setPointPadding,
							dataLabels: {
								enabled: isDataLabelEnable,
								crop: false,
								inside:insidePos,
								rotation:rotateDegree,
								overflow:'justify',
								x:3,
								y:-3,
								/*formatter: function() {
									var val = Highcharts.numberFormat (this.y,4, '.','');
									val = (parseFloat(val));
									return val;
								},*/
								//color:dataLabelColor,
								style: {
									//color : dataLabelColor,
									fontWeight: 'Regular',
									fontFamily: fontfamily,
									fontSize: fontsize,
									textOutline: false,
									textShadow: false
								}
							},
							states: {
								hover: {
									enabled: false
								}
							},
							minPointLength:setMinPointLength,
							 marker: {
								enabled: true,
								symbol: 'circle',
								radius: pointRadius
							}
						},
				},
			legend: {
					verticalAlign: legendLocation,
					y: legYval,
					itemDistance:5,
					symbolWidth: 14,
					symbolHeight: 6,
					squareSymbol: false,
					symbolRadius: 6,
					enabled: showLegends,
					//width:legendWidth,
					align:'center',
					maxHeight :maxLegendHeight,
					itemMarginBottom: 4,
					itemStyle: {
					   textAlign: 'top',
						fontFamily:'Arial',
					}, 
					labelFormatter: function() {
						var retrunvar = this.name;
						if(retrunvar.length>28 && needLegendFormat == 'true')
						{
							c=0;
							strval=''
							while(c<retrunvar.length)
							{
								strval+=retrunvar.substring(c,c+28)+'<br>';
								c=c+28;
							}
						retrunvar= strval;
						}
						return retrunvar;
					},
				},
						rangeSelector: {
			enabled: false
		},
		global: {
			useUTC: true,
			timezoneOffset: timezoneOffsetValue
		},
		navigator: {
			enabled: false
		},
		scrollbar: {
			enabled: false
		},
		labels :{
			style: {
			color: '#2a292a',
			fontWeight:'normal',
			fontFamily: 'Arial',
			fontSize: '10px',
			}
		},
		exporting: {
			enabled: false
		},
		credits: {
			enabled: false
		},
		subtitle: {
			style: {
				color:  '#333333',
				fontWeight:'500',
				fontFamily:'Arial',
				fontSize: '11px',
			}
		},
		series: jsonData['DataSet']
		}
	chartOptions.chart.renderTo=container_Id;
	chartOptions = jQuery.extend(true, chartOptions, getUserThemeFor(strSkin,'','',true));
	Highcharts.seriesTypes.line.prototype.drawLegendSymbol =  Highcharts.seriesTypes.area.prototype.drawLegendSymbol;
	var chart = new Highcharts.Chart(chartOptions);
	return chart;
}

function getTimeLineOutputFormat(s_time)
{
	var return_s_time_fout ='';
	if(s_time != 'null' && s_time !='')
	{
		s_time = s_time.toLowerCase();
		var symbol = ' ';
		var arrValue = new Array();
		if(s_time.indexOf("-") > -1)
		{
			symbol = '-';
		}else if(s_time.indexOf("/") > -1)
		{
			symbol = '/';
		}else if(s_time.indexOf(".") > -1)
		{
			symbol = '.';
		}
		var aValue = s_time.split(symbol);
		if (aValue !=null && aValue.length >0)
		{
			for (var v = 0; v < aValue.length; v++)
			{
				var value= aValue[v];
				var output = value;
				if(value.lastIndexOf(' ')>-1)
				{
					value = value.substring(0,value.lastIndexOf(' '));					
				}
				if(value!=null && value.indexOf("d")>-1)
				{
					if(value!=null && value == "d")
						output = '%e';
					else if(value!=null && value == "dd")
						output = '%d';
					else if(value!=null && value == "dd,")
						output = '%d,';

				}else if(value!=null && value.indexOf("m")>-1)
				{
					if(value!=null && value=="m")
						output = '%m';
					else if(value!=null && value=="mm")
						output = '%m';
					else if(value!=null && value=="mmm")
						output = '%b';
				}else if (value!=null && value.indexOf("y")>-1)
				{
					if(value!=null && value=="yy")
						output = '%y';
					else if(value!=null && value=="yyyy")
						output = '%Y';
				}
				if (!(value == 'hh:mm' || value == 'hh:mm:ss' ))
				{
					arrValue[v]=output;
				}

			}
		}
		if (arrValue !=null && arrValue.length >1)
		{
			for (var v = 0; v < arrValue.length; v++)
			{
				return_s_time_fout += arrValue[v]+symbol;
			}
			if(return_s_time_fout!=null && endsWith(return_s_time_fout,symbol))
				return_s_time_fout = return_s_time_fout.substring(0,return_s_time_fout.lastIndexOf(symbol));
			return_s_time_fout = return_s_time_fout+", %H:%M";
		}else
			return_s_time_fout='%H:%M';
	}
	return return_s_time_fout;
}
function endsWith(str, suffix) {
    return str.indexOf(suffix, str.length - suffix.length) !== -1;
}

/**
* Highcharts plugin for chart resize
**/
(function (H) {
	H.Chart.prototype.reflow = function () {
		var chart = this,
			renderTo = chart.renderTo;
		Ext.EventManager.onWindowResize(function () {
			var panelWidth = jQuery(renderTo).width();
			var panelHeight = jQuery(renderTo).height();
			var width =  jQuery(renderTo).outerWidth();
			var height = jQuery(renderTo).outerHeight();
			if( width > 80 )
			{
				if( width > 100 )
					width = ( width == panelWidth || (( width - 5 ) <= panelWidth))? (width -50):(width-30);
				else
				{
					if(chart!=null && (chart!="null" && chart!="undefined"))
					{
						if(chart!=null && chart.hasOwnProperty('options'))
						{
							if(chart.options.hasOwnProperty('chart'))
							{
								width = ( Ext.isEmpty(chart.options.chart))?200:chart.options.chart.width;
								height = ( Ext.isEmpty(chart.options.chart))?180:chart.options.chart.height;
							}
						}
					}
				}
				
				if(chart!=null && (chart!="null" && chart!="undefined"))
				{
					
					if(chart!=null && chart.hasOwnProperty('container'))
					{
						if (chart.container) { // It may have been destroyed in the meantime (#1257)
							if(!Ext.isEmpty(width) && !Ext.isEmpty(height))
							{
								chart.setSize(width, height, false);
							}
						}
						chart.containerWidth = width;
						chart.containerHeight = height;
					}
					
				}
			}
			else
			{
				if(chart!=null && (chart!="null" && chart!="undefined"))
				{
					height = chart.chartHeight;
					width = chart.chartWidth;
					if (chart.container) { // It may have been destroyed in the meantime (#1257)
						chart.setSize(width, height, false);
					}
					chart.containerWidth = width;
					chart.containerHeight = height;
				}
			}
		});
	};
}(Highcharts));


/**
* Highcharts plugin for Show Legend function
**/
(function(b,a){
	if(!b){return}
	var c=b.Chart.prototype,d=b.Legend.prototype;
	b.extend(c,{
		legendSetVisibility:function(h){
			//$('.highcharts-legend-item rect').attr('height', '2').attr('y', '7');
			var i=this;
			var k=i.legend,e,g,j;
			var m=i.options.legend,f,l;					
			if(m.enabled==h)
				{return}
				m.enabled=h;
			if(!h){
				d.destroy.call(k);
				e=k.allItems;
				if(e){
					for(g=0,j=e.length;g<j;++g)
						{e[g].legendItem=a}
					}
					k.group={}
				}
				c.render.call(i);
				if(!m.floating){
					f=i.scroller;
					if(f&&f.render){
						l=i.xAxis[0].getExtremes();
						f.render(l.min,l.max)
					}
				}
				jQuery('.highcharts-legend-item rect').attr('height', '6').attr('y', '7');
				jQuery('.highcharts-legend-item rect').attr('width', '6').attr('x', '10');
		},
		legendHide:function(cObj){
			this.legendSetVisibility(false)
		},legendShow:function(cObj){
			this.legendSetVisibility(true)
		},
		legendToggle:function(value){
			//$('.highcharts-legend-item rect').attr('height', '2').attr('y', '7');
				jQuery('.highcharts-legend-item rect').attr('height', '6').attr('y', '7');
				jQuery('.highcharts-legend-item rect').attr('width', '6').attr('x', '10');
			if( Ext.isEmpty(this.options) )
			{
				jQuery('.highcharts-legend').show();
			}
			else
			{
				this.legendSetVisibility(this.options.legend.enabled^true);
			}
		}
	})
	
}(Highcharts));
