var bookletNameAry=[];
var queryStr='';
var queryStrForSch='';
var bookletLdgMask;

Ext.define("utilities.GroupBooklet", {
    extend: 'Ext.button.Button',
    alias: 'widget.groupBooklet',
    id: 'groupBooklet',
    name: 'Test',
    listeners:
	{
		click:function(button,pressed)
		{
			var con=appConstants.appObj.getController(appConstants.appController);
			if (typeof con.bookletScheduleQuery == 'function')
			{
				queryStrForSch = appConstants.appObj.getController(appConstants.appController).bookletScheduleQuery(this);
				if (queryStrForSch == 'undefined' || queryStrForSch == '' || queryStrForSch === undefined)
				{
					return;
				}
				console.log('------',queryStrForSch);
			}
			queryStr = appConstants.appObj.getController(appConstants.appController).bookletQuery(this);
			if(queryStrForSch=='')
			{
				queryStrForSch = queryStr;
			}
			if (queryStr == 'undefined' || queryStr == '' || queryStr === undefined)
			{
				return;
			}
			else
			{
				if(Ext.isEmpty(bookletLdgMask))
				{
					bookletLdgMask = new Ext.LoadMask(Ext.getBody(),{msg : "Loading ..."});
				}
				this.getBookletInfo();
			}
			console.log('------>>>>>>>>>>',queryStr);
		},
		afterrender: function ()
		{
			Ext.create('Ext.tip.ToolTip', {
				target: this.id,
				anchor: 'top',
				cls: 'yellowTip',
				trackMouse: true,
				html: combine_reports
			});
		}
	},
	getBookletInfo:function()
	{
		var thisBooklet = this;
		var url = '/final/reporter/ErGroupBooklet.jsp';
		bookletLdgMask.show();
		Ext.Ajax.request({
			url: url,
			params: '',
			scope: this,
			success: function(response)
			{
				var groupPDFRes = Ext.decode(response.responseText);
				bookletLdgMask.hide();
				thisBooklet.openBookletWindow(groupPDFRes);
			},
			failure: function(err)
			{
				Ext.MessageBox.alert('Error occured in ErGroupPDFBean.jsp page');
			}
		});
	},
	openBookletWindow:function(groupPDFRes)
	{
		var thisBooklet = this;
		var isNew = groupPDFRes.isNew;
		var screenLabels = groupPDFRes.screenLabels;
		var dropDwVal = '';
		var hiddenDrop = false;
		if (isNew == 'true')
		{
			hiddenDrop = true;
		}
		dropDwVal = groupPDFRes.bookletArr;

		Ext.create('Ext.window.Window', {
			title: combine_reports,
			id:'bookletWindow',
			width: 385,
			modal: true,
			closable:true,
			draggable:false,
			resizable:false,
			header:{
				style:{'margin':'0px 10px 0px 10px','padding':'4px 0px 1px 0px'}
			},
			ui:'newPopupWindow withBorderShadow newplainHeader_border',
			//padding:'0 10 10 10',
			padding:0,
			layout: 'fit',
			listeners:
			{
				show: function (win) 
				{
					if (this.modal)
					{
						var el ;
						var dom = Ext.dom.Query.select('.x-mask');
						for (var y = 0; y < dom.length; y++) {
							 el = Ext.fly(dom[y]);

						}
					 el.addCls('windowModal');
					}
				},
				afterrender:function()
				{
					Ext.getCmp('bookletID').setFieldLabel(screenLabels['reporter.common.Add to Booklet']);
					//Ext.getCmp('newBookletID').setFieldLabel(screenLabels['reporter.common.Booklet Name']);
					Ext.getCmp('bookletDesId').setFieldLabel(screenLabels['reporter.common.Descriptions']);
					Ext.getCmp('rNameID').setFieldLabel(screenLabels['reporter.common.Report Name']);
					Ext.getCmp('viewID').setText(screenLabels['reporter.common.Preview']);
					Ext.getCmp('addReportID').setText(screenLabels['reporter.common.Add & Close']);
				}
			},
			items: [
			{
				margin:'0 0 20 10',
				xtype: 'panel',
				layout: 'column',
				defaults:{
					labelSeparator:'',
					labelAlign:'top',
				},
				items: [
				{
					xtype: 'scrollcombo',
					cls: 'dropdown',
					margin:'10 0 10 0',
					columnWidth:.4,
					fieldLabel: 'Add to Booklet',
					id: 'bookletID',
					name: 'bookletID',
					store: new Ext.data.Store({
						fields: ['displayField', 'valueField'],
						data: []
					}),
					displayField: 'displayField',
					valueField: 'valueField',
					queryMode: 'local',
					listeners: {
						'afterrender':function()
						{
							var bookletID = Ext.getCmp('bookletID');
							bookletID.getStore().loadRawData(dropDwVal);
							bookletID.setValue(dropDwVal[0]['valueField']);
							for(var i=0;i<dropDwVal.length;i++)
							{
								bookletNameAry.push(dropDwVal[i]['displayField']);
							}
						},
						'change': function()
						{
							if (Ext.getCmp('bookletID').getValue() == 'NewBooklet')
							{
								Ext.getCmp('newBookletID').show();
								Ext.getCmp('bookletDesId').show();
							}
							else
							{
								Ext.getCmp('newBookletID').hide();
								Ext.getCmp('newBookletID').setValue('');
								Ext.getCmp('bookletDesId').hide();
								Ext.getCmp('bookletDesId').setValue('');
							}
							Ext.getCmp('bookletWindow').doComponentLayout();
							Ext.getCmp('bookletWindow').doLayout();
						},
					}
				},
				{
					xtype: 'textfield',
					name: 'newBookletName',
					id: 'newBookletID',
					emptyText:booklet_Name,
					cls:'textbox',
					allowBlank: false,
					margin:'30 10 10 10',
					hidden: !hiddenDrop,
					columnWidth:.6,
					maxLength:32,
					enforceMaxLength: true
				},
				{
					xtype: 'textfield',
					fieldLabel: 'Description',
					name: 'bookletDesId',
					id: 'bookletDesId',
					cls:'textbox',
					margin:'10 10 10 0',
					hidden: !hiddenDrop,
					columnWidth:1.0,
				},
				{
					xtype:'container',
					layout:'column',
					margin:'10 10 0 0',
					columnWidth:1.0,
					defaults:{
						labelSeparator:'',
						labelAlign:'top',
					},
					items:[
						{
							xtype: 'textfield',
							name: 'rName',
							id: 'rNameID',
							columnWidth:.4,
							margin:0,
							cls:'textbox',
							fieldLabel: 'Report Name',
							allowBlank: false,
							maxLength:32,
							enforceMaxLength: true

						},
						{
							xtype: 'button',
							text: 'Preview',
							ui:'newButtonSmall',
							id  :'viewID',
							columnWidth:.25,
							margin:'20 5 0 10',
							listeners: {
								'click': function() {
									appConstants.appObj.getController(appConstants.appController).bookletPreview(this);
									// location.href = './ErShowBookletPDFList.jsp'
								}
							}
						},
						{
							xtype: 'button',
							text: 'Add & Close',
							id: 'addReportID',
							ui:'newButtonSmall',
							columnWidth:.3,
							margin:'20 0 0 5',
							name: 'addReportName',
							listeners: {
								'click': function()
								{
									thisBooklet.addOrUpdateBooklet();
								}
							}
						},
					]
				}]
			}]
		}).show();
	},
	addOrUpdateBooklet:function()
	{
		var thisBooklet = this;
		var bookletID = Ext.getCmp('bookletID').getValue();
		var newBookletID = Ext.getCmp('newBookletID').getValue();
		var bookletDesId = Ext.getCmp('bookletDesId').getValue();
		var rNameID = Ext.getCmp('rNameID').getValue();
		if(thisBooklet.validateBooklet(newBookletID))
		{
			if(bookletID=='NewBooklet')
			{
				queryStr +=  '&newBookletID=' + newBookletID + '&rNameID=' + rNameID+'&bookletDesId='+bookletDesId;
				queryStrForSch +=  '&newBookletID=' + newBookletID + '&rNameID=' + rNameID+'&bookletDesId='+bookletDesId;
			}
			else
			{
				queryStr += '&bookletID='+ bookletID + '&rNameID=' + rNameID;
				queryStrForSch += '&bookletID='+ bookletID + '&rNameID=' + rNameID;
			}
			bookletLdgMask.show();
			Ext.Ajax.request({
				url: '../servlet/com.eg.ErBookletC',
				//params: queryStr,
				params: queryStrForSch,
				scope: this,
				success: function(response){
					var responseStr = Ext.decode(response.responseText);
					var maxReportID = responseStr.maxReportID
					var maxBookletID = responseStr.maxBookletID
					var errorMsg = responseStr.errorMsg
					if(errorMsg!=undefined && errorMsg!='undefined')
					{
						bookletLdgMask.hide();
						thisBooklet.getMessageBox('Booklets',errorMsg);
					}
					else
						thisBooklet.setSessionData(maxReportID,maxBookletID);
				},
				failure: function(err)
				{
					Ext.MessageBox.alert('Error occured in ErBookletC servlet');
				}
			});
		}
	},
	validateBooklet:function(newBookletID)
	{
		var thisBooklet = this;
		var bookletID = Ext.getCmp('bookletID').getValue();
		var rNameID = Ext.getCmp('rNameID').getValue();
		var bookletDesId = Ext.getCmp('bookletDesId').getValue();
		if(bookletID=='NewBooklet')
		{
			if(newBookletID=="" || newBookletID.length==0)
			{
				thisBooklet.getMessageBox('Booklets','Please enter booklet name');
				return false;
			}
			if(bookletNameAry.length>0 && bookletNameAry.indexOf(newBookletID)>-1)
			{
				thisBooklet.getMessageBox('Booklets','Booklet name is already exists!');
				return false;
			}
			if(!checkspecial(newBookletID,"`~!@#$%^&*()+={}[]|\\:;\"'<>,.?/"))
			{
				this.getMessageBox('Booklets',alertTxtBgrnd);
				return false;
			}
			//prakash for checking description
			if(!checkspecial(bookletDesId,"`~!@#$%^&*()+={}[]|\\:;\"'<>,.?/"))
			{
				this.getMessageBox('Booklets',alertTxtBgrnd);
				return false;
			}
			//
		}
		if(rNameID=="" || rNameID.length==0)
		{
			thisBooklet.getMessageBox('Booklets','Please enter Report name');
			return false;
		}
		if(!checkspecial(rNameID,"`~!@#$%^&*()+={}[]|\\:;\"'<>,.?/"))
		{
			thisBooklet.getMessageBox('Booklets',alertTxtBgrnd);
			return false;
		}
		return true;
	},
	setSessionData:function(maxReportID,maxBookletID)
	{
		var thisBooklet = this;
		 queryStr+='&maxReportID='+maxReportID;
		Ext.Ajax.request(
				{
					url : '/final/reporter/ErHtmlToSavePdfBooklet.jsp',
					params: queryStr,
					method: 'POST',
					scope:this,
					timeout:60000000,
					success: function(response){
						console.log(response.responseText);
						var responseStr = Ext.decode(response.responseText);
						if(responseStr.status=='success')
						{
							thisBooklet.savePdfToLocal(maxReportID,responseStr.drillDnSess,maxBookletID);
						}
					},
					failure:function(){
						//console.log('failre');
					}
				});

	 },

	savePdfToLocal:function(maxReportID,drillDnSess,maxBookletID)
	{
		var thisBooklet = this;
		var param='maxReportID='+maxReportID+'&maxBookletID='+maxBookletID;
		if(drillDnSess!=undefined && drillDnSess!='undefined' && drillDnSess.length>0)
		{
			param+=drillDnSess='&drillDnSess'+drillDnSess;
		}
		Ext.Ajax.request(
		{
			url: '../servlet/com.eg.ErPdfDownloadC',
			params: param,
			scope:this,
			success: function(response)
			{
				bookletLdgMask.hide();
				thisBooklet.getInfoMessageBox('Booklets','Report added to booklet successfully');
				Ext.getCmp('bookletWindow').doClose();
			},
			failure:function()
			{
				alert('Error in ErPdfDownloadC');
			}
		});

	},
	getMessageBox:function(title,msg)
	{
		Ext.MessageBox.show({
			title: title,
			msg: msg,
			cls:'egMsgBox',
			buttons: Ext.MessageBox.OK,
			icon: Ext.MessageBox.WARNING
		});
		return false;
	 },
	getInfoMessageBox:function(title,msg)
	{
		Ext.MessageBox.show({
			title: title,
			msg: msg,
			cls:'egMsgBox',
			buttons: Ext.MessageBox.OK,
			//icon: Ext.MessageBox.INFO
			icon:'iconSuccess'
		});
		return false;
	 }
});