var $activeScroll = false,
	$scrollInterval,
	deferTimeout;

Ext.define('utilities.ReporterGridstackPanel', {
	extend: 'Ext.container.Container',
	alias: 'widget.reportergridstackpanel',
	closeAction: 'destroy',
	autoScroll: true,
	scroll: false,
	padding: '10 5 10 5',
	flex: 1,
	getDragPositions: Ext.emptyFn,
	getResizePositions: Ext.emptyFn,
	config: 
	{
		data: [],
	},
	constructor: function (config) 
	{
		this.initConfig(config);
		this.callParent(arguments);
	},
	disableDrag:false,
	resizeWidget: true,
	gridstackColumns: 12,
	id: 'reportergridstackpanel',
	frame: false,
	widgetConfigObj: {},
	tpl: '<div class="grid-stack  grid-stack-12"><tpl for="."><div class="grid-stack-item {widgetType}"   data-gs-no-resize={noResize}  id= {id}   data-gs-id={id} data-gs-x="{x}" data-gs-y="{y}" data-gs-width="{width}" data-gs-height="{height}"><div class="grid-stack-item-content bord" id= "{id}_inner"></div></div></tpl></div>',
	initComponent: function () 
	{
		var me = this;
		var assignedData = me.data;
		if (me.data.length == 0) {
			me.update('')
		}
		me.on('boxready', function () {
			me.loadgridStackAPI(assignedData)
		}, me);
		me.on('resize', me.windowResize, me);

		me.callParent();
	},
	gridStackData: function (obj) 
	{
		var me = this;
		me.data.push(obj);
	},
	loadgridStackAPI: function (gridstackdata) 
	{
		var me = this,
			gridStackPnlHeight = (Math.round(me.getHeight() / 12) - 10),
			gridStackOptions = {
				verticalMargin: 10,
				width: 12,
				disableDrag:me.disableDrag,
				//cellHeight:gridStackPnlHeight,
				height: 0,
				acceptWidgets: '.grid-stack-item',
				animate: false,
				//float : true,
				resizable: {
					scroll: true,
					//containment: 'reportergridstackpanel'
				},
				draggable: {
					scroll: true,
					handle: '.x-panel-header, .textWidgetDrag'
				}
			};
		gridStackObj = $('.grid-stack').gridstack(gridStackOptions);
		me.loadPanel(gridstackdata);
		me.widgetResize();
		me.widgetDrag();

		//me.widgetChanges();
		me.widgetAdded();
		me.widgetRemoved();
		me.widgetChanges();
		//me.windowResize();
		return gridStackObj;
	},
	setPanelResize: function (event) {
		Ext.defer(function () {
			var cPanlId = event.target.id;
			//console.log("cPanlId",cPanlId);
			if (cPanlId != null && cPanlId.indexOf("_outer") > -
				1) // To avoid ID Conflict without outer gridstack widget & ExtJS Panel
			{
				cPanlId = cPanlId.substring(0, cPanlId.indexOf("_outer"));
			}
			var size = {
				width: $('#' + cPanlId + '_inner').outerWidth(true),
				height: $('#' + cPanlId + '_inner').outerHeight(true)
			}
			Ext.getCmp(cPanlId).setSize(size);
			Ext.getCmp(cPanlId).doComponentLayout();
		}, 500);
	},
	widgetDrag: function () {
		var me = this;
		$('.grid-stack').on('dragstop', function (event, ui) {
			var grid = this;
			var element = event.target;
			me.getDragPositions();
		})
	},

	widgetResize: function () {
		var me = this;
		var heightDiv = 90;
		var $emptyWidget = '<div class="empty" style="height:90px; visibility: hidden">emptyWidget</div>';
		$('.grid-stack').on('resize', function (event, ui) {
			$('iframe').css('pointer-events', 'none');
			me.setPanelResize(event);


			/*--scrollbar bottom fix--*/
			if ((ui.position.top + ui.size.height) > ($('#'+me.id).scrollTop() + $('#'+me.id).height() - 30)) {
				if ($activeScroll === false) {
					
					heightDiv = heightDiv++;
					//console.log(heightDiv);
					$activeScroll = true;
					$scrollInterval = setInterval(function () {

						if (($(ui.element[0]).offset().top + $(ui.element[0]).height()) > ($('#'+me.id).scrollTop() + $('#'+me.id).height())) {
							$('.empty').remove();
							$('#'+me.id).append($emptyWidget);

							$('#'+me.id).stop().animate({
								scrollTop: $('#'+me.id).scrollTop() + (heightDiv++)
							}, 90);
						} else {
							//me.gridStackObjRef().update(event.target.id, node.x, node.y,node.el.css("width"), 500);
						}
					}, 150);
				}
				$('.empty').remove();
				$('#'+me.id).append($emptyWidget);
				$('.empty').width(heightDiv++);
				$('#'+me.id).stop().animate({
					scrollTop: $('#'+me.id).scrollTop() + 40
				}, 100);
				if (deferTimeout) {
					clearTimeout(deferTimeout);
				}
			} else {
				$('#'+me.id).stop();
			}

			/*--scrollbar bottom fix--*/

		}).on('resizeStart', function (event, ui) {
			var cPanlId = event.target.id;
			if (cPanlId != null && cPanlId.indexOf("_outer") > -
				1) // To avoid ID Conflict without outer gridstack widget & ExtJS Panel
			{
				cPanlId = cPanlId.substring(0, cPanlId.indexOf("_outer"));
			}

		}).on('resizestop', function (event, ui) {
			heightDiv = 90;
			/*--scrollbar bottom fix--*/
			$activeScroll = false;
			clearInterval($scrollInterval);
			deferTimeout = Ext.defer(function () {
				$('.empty').remove();
			}, 2000);
			deferTimeout;
			/*--scrollbar bottom fix--*/

			me.setPanelResize(event);
			me.getResizePositions(event);


			$('iframe').css('pointer-events', 'auto');
		});

	},
	loadPortletToolbarItems: function (settingdata) {
		var me = this;
		me.portlettoolbarItems.length = 0;
		switch (settingdata.widgetType) {
			case 'Gauge Meter':
				me.portlettoolbarItems.push({
					xtype: 'button',
					ui: 'xx',
					text: 'x',
					handler: function () {
						this.up('panel').close();

					}
				});
				break;
		}
	},
	portlettoolbarItems: [],
	portlet: function (obj, action, widgetTitle, imgIcon, imgIcon) {

		var me = this;
		if ($('#noData')) {
			$('#noData').remove();
		}
		var portlet, objArray;
		//@ checking wheather its getting obj is array or array object 
		if (Ext.isArray(obj)) {
			objArray = obj;
		} else {
			objArray = [];
			objArray.push(obj);
		}
		_.each(objArray, function (node) {

			var blockID = node.id,
				renderToID = node.id + '_inner',
				width = Ext.get(renderToID).getWidth(),
				height = Ext.get(renderToID).getHeight();
			//Loading portlet toolbar items;
			me.loadPortletToolbarItems(node);
			portlet = Ext.create('Ext.panel.Panel', {
				closeAction: 'destroy',
				title: node.widgetType,
				renderTo: renderToID,
				relationTo: node.id,
				id: blockID,
				width: width,
				height: height,
				layout: {
					type: 'vbox',
					align: 'stretch'
				},
				closable: true,
				tools: [{
						xtype: 'toolbar',
						margin: 0,
						padding: 0,
						//hidden: true,
						id: blockID + '-toolbar',
						ui: 'plain',
						items: me.portlettoolbarItems
					}

				],
				listeners: {

					'beforeclose': function (panel) {
						if (panel.panelClose) {
							panel.panelClose = false;
							return true;
						}

						Ext.Msg.show({
							title: 'Close confirmation',
							msg: 'Really close?',
							buttons: Ext.Msg.YESNO,
							callback: function (btn) {
								if ('yes' === btn) {
									panel.panelClose = true;
									me._removeWidget(portlet.relationTo);
								}
							}
						});
						return false;

					}

				}
			});
		});


		return portlet;



	},
	loadPanel: function (data) {
		var me = this;
		for (var key in data) {
			if (data[key].hasOwnProperty('id')) {
				Ext.suspendLayouts();
				me.portlet(data[key], 'addWidget', '', '', '');
				Ext.resumeLayouts(true);
			} else {
				throw "No id is given in the data";
			}
		}

	},
	gridStackObjRef: function () {
		var me = this,
			gridStackObj = $('.grid-stack').data('gridstack');
		return gridStackObj;
	},

	windowResize: function () {
		var me = this;
		_.map($('.grid-stack > .grid-stack-item:visible'), function (el) {
			//console.log('window',$(el).attr('id'));

			el = $(el);
			var node = el.data('_gridstack_node'),
				widgetID = node.id
			if (widgetID != null && widgetID.indexOf("_outer") > -
				1) // To avoid ID Conflict without outer gridstack widget & ExtJS Panel
			{
				widgetID = widgetID.substring(0, widgetID.indexOf("_outer"));
			}
			var renderToID = $('#' + widgetID + '_inner'),
			//	width = renderToID.outerWidth(true) - 3, removed for extra space issue
			//	height = renderToID.outerHeight(true) - 3,removed for extra space issue
				width = renderToID.outerWidth(true),
				height = renderToID.outerHeight(true),
				size = {
					width: width,
					height: height
				};
			if (!Ext.isEmpty(Ext.getCmp(widgetID))) {
				Ext.getCmp(widgetID).setSize(size);
				Ext.getCmp(widgetID).doComponentLayout();
			}

		}, me);

	},
	defaultConfigWidget: {
		x: 0,
		y: 0,
		width: 2,
		height: 2,
		autoPosition: false,
		minWidth: undefined,
		maxWidth: undefined,
		minHeight: undefined,
		maxHeight: undefined,
		id: Ext.id(),
		noResize: false
	},
	
	_loadData: function (gridstackdata) {
		var me = this;
		me.gridStackObjRef().removeAll();
		var items = GridStackUI.Utils.sort(gridstackdata);
		var ourtID, innerID;
		_.each(items, function (node) {
			var ourtID = node.id;
			var innerID = ourtID + '_inner';
			me.gridStackObjRef().addWidget($('<div class="grid-stack-item ' + node.widgetType +
					'"   data-gs-no-resize="' + node.noResize + '"  id= "' + ourtID +
					'"   data-gs-id="' + ourtID +
					'"  ><div class="grid-stack-item-content bord" id= "' + innerID +
					'"></div></div>'),
				node.x, node.y, node.width, node.height);
		}, this);
		me.gridStackData(gridstackdata);
		me.portlet(gridstackdata, 'addWidget', '', '', '');
	},
	_gridStackSetColumn: function (columns) {
		var me = this,
			gridstackobj = me.gridStackObjRef();
		me.gridstackColumns = columns;
		gridstackobj.setGridWidth(columns, false);
		//gridstackobj.maxWidth(el, columns);
	},
	_updateWidgets: function (gridstackdata, columns) {
		var me = this,
			gridstackobj = me.gridStackObjRef();
		//gridstackobj.setGridWidth(columns, false);
		$('.grid-stack').each(function () {
			var grid = $(this).data('gridstack');
			//console.log('from _updateWidgets',gridstackdata);

			me.moveWidgets(gridstackdata, columns);
		});

		//gridstackobj.maxWidth(el, columns);

	},
	_addWidget: function (obj, action, widgetTitle, imgIcon, imgIcon) {

		var me = this,
			gridstackobj = me.gridStackObjRef(),
			defaults = me.defaultConfigWidget;



		//console.log(me.defaultConfigWidget);
		var _arguments = Ext.applyIf(arguments[0], me.defaultConfigWidget);
		var ourtID = _arguments.id + '_outer';
		var innerID = _arguments.id + '_inner';

		var el = $('<div class="grid-stack-item"><div class="grid-stack-item-content"  id="' + innerID +
			'"></div></div>');
		if (typeof _arguments.x != 'undefined') {
			el.attr('data-gs-x', _arguments.x);
		}
		if (typeof _arguments.y != 'undefined') {
			el.attr('data-gs-y', _arguments.y);
		}
		if (typeof _arguments.width != 'undefined') {
			el.attr('data-gs-width', _arguments.width);
		}
		if (typeof _arguments.height != 'undefined') {
			el.attr('data-gs-height', _arguments.height);
		}
		if (typeof _arguments.autoPosition != 'undefined') {
			el.attr('data-gs-auto-position', _arguments.autoPosition ? 'yes' : null);
		}
		if (typeof _arguments.minWidth != 'undefined') {
			el.attr('data-gs-min-width', _arguments.minWidth);
		}
		if (typeof _arguments.maxWidth != 'undefined') {
			el.attr('data-gs-max-width', _arguments.maxWidth);
		}
		if (typeof _arguments.minHeight != 'undefined') {
			el.attr('data-gs-min-height', _arguments.minHeight);
		}
		if (typeof _arguments.maxHeight != 'undefined') {
			el.attr('data-gs-max-height', _arguments.maxHeight);
		}
		if (_arguments.noResize) {
			el.attr('data-gs-no-resize', _arguments.noResize);
		}
		if (typeof _arguments.id != 'undefined') {
			el.attr('data-gs-id', ourtID);
		}
		if (typeof _arguments.id != 'undefined') {
			el.attr('id', ourtID);
		}
		if (typeof action != 'undefined') {
			el.attr('action', action);
		}
		if (typeof widgetTitle != 'undefined') {
			el.attr('widgetTitle', widgetTitle);
		}
		if (typeof imgIcon != 'undefined') {
			el.attr('imgIcon', imgIcon);
		}
		if (typeof _arguments.internalId != 'undefined') {
			el.attr('internalId', _arguments.internalId);
		}


		//pushing the data
		el.data("internalId", _arguments.internalId);
		me.widgetConfigObj[ourtID] = _arguments;
		gridstackobj.addWidget(el);
		me.gridStackData(_arguments);
		//me.portlet(_arguments,action,widgetTitle,imgIcon,imgIcon);

		//Ext.apply(me.portlet,{widgetDetails:_arguments });
	},
	counter: 0,
	widgetAdded: function () {
		var me = this,
			gridstackobj = me.gridStackObjRef(),
			defaults = me.defaultConfigWidget;
		//console.log(me.defaultConfigWidget);


		$('.grid-stack').on('added', function (event, items) {
			//console.log(me.counter++, me.dataLength);

			//console.log(event,'----------------------------------------------------------------------->',items)

			for (var i = 0; i < items.length; i++) {

				var action = $('#' + items[0].id).attr('action');
				var widgetTitle = $('#' + items[0].id).attr('widgetTitle');
				var imgIcon = $('#' + items[0].id).attr('imgIcon');

				var portletArgs = items[0];

				if (me.widgetConfigObj != null && me.widgetConfigObj.hasOwnProperty(items[0]
						.id)) {
					portletArgs = me.widgetConfigObj[items[0].id];
				}

				items[0].id = items[i].id.replace('_outer', '');
				me.portlet(portletArgs, action, widgetTitle, imgIcon, imgIcon);


			}

		});

	},
	widgetRemoved: function () {
		var me = this;
		me.removedItems = [],
			gridStackObj = me.gridStackObjRef();
		$('.grid-stack').on('removed', function (event, items) {
			for (var i = 0; i < items.length; i++) {
				//console.log('item removed',items[i]);
				//Ext.get(items[0].id).removeAllListeners()
				//Ext.EventManager.removeAll(Ext.get(items[0].id));
				//alert('removedItems')
				Ext.destroy(Ext.getCmp(items[0].id));
				me.removedItems.push(items[0]);
			}
		});
	},
	widgetChanges: function () {
		var me = this;
		$('.grid-stack').on('change', function (event, items) {
			//console.log(items);
			//me.setPanelResize(event);
			Ext.defer(function () {
				me.windowResize();
			}, 500);

		});

	},
	_removeWidget: function (relationId) {
		var me = this,
			gridStackObj = me.gridStackObjRef(),
			to_remove_widget = $('#' + relationId + "_outer"),
			el = Ext.getCmp(relationId).getEl();
		el.ghost('t', {
			duration: 200
		});
		//Ext.defer(function(){
		gridStackObj.removeWidget(to_remove_widget, true);
		//Ext.destroy(Ext.getCmp(relationId));
		//},360);
	},
	_removeAllWidget: function () {
		var me = this,
			gridstackobj = me.gridStackObjRef();

		if(gridstackobj!=undefined)
		{
			// destroy all panel object;
			for (var key in me.data) {
				if (!Ext.isEmpty(Ext.getCmp(me.data[key].id))) {
					Ext.destroy(Ext.getCmp(me.data[key].id));
					// reset the data
					me.data.length = 0;
				}
			}
			gridstackobj.removeAll();
		}
	},
	_serialization: function () {
		var me = this,
			gridstackobj = me.gridStackObjRef();
		me.data = _.map($('.grid-stack > .grid-stack-item:visible'), function (el) {
			el = $(el);
			var node = el.data('_gridstack_node');
			var blkId = el.attr('id');
			if (blkId != null && blkId.indexOf("_outer") >0) 
			{
				blkId = blkId.substring(0, blkId.indexOf("_outer"));
			}
			return {
				dataX: node.x,
				dataY: node.y,
				//x: node.x,
				//y: node.y,
				dataWidth: node.width,
				dataHeight: node.height,
				id: blkId
			};
		}, me);
		//	me.data=GridStackUI.Utils.sort(me.data,1);
		return me.data;
	},
	/*_serialization: function () {
		 me = this,
		gridstackobj = me.gridStackObjRef();
		me.serializedData = _.map($('.grid-stack > .grid-stack-item:visible'), function (el) {
			el = $(el);
			var node = el.data('_gridstack_node');
			return {
				x: node.x,
				y: node.y,
				width: node.width,
				height: node.height,
				id: node.id
			};
		}, this);
		console.log(JSON.stringify(me.serializedData, null, '    '));
		return me.serializedData;
	},*/

	_serializationStr: function () {
		var me = this,
			gridstackobj = me.gridStackObjRef();
			me.data = _.map($('.grid-stack > .grid-stack-item:visible'), function (el) {
			el = $(el);
			var node = el.data('_gridstack_node');
			var gsPnlId = el.attr('id');
			if (gsPnlId != null && gsPnlId.indexOf("_outer") >
				0) // To avoid ID Conflict without outer gridstack widget & ExtJS Panel
			{
				gsPnlId = gsPnlId.substring(0, gsPnlId.indexOf("_outer"));
			}
			var widthVal = 300;
			var heightVal = 180;
			//console.log(el[0].offsetHeight)
			//var posQryStr =  gsPnlId + ":" + node.x + "," + node.y + "," + node.width + "," + node.height + "," + node.el[0].offsetWidth + "," + node.el[0].offsetHeight;
			var posQryStr = gsPnlId + ":" + el[0].dataset['gsX'] + "," + el[0].dataset['gsY'] +
				"," + el[0].dataset['gsWidth'] + "," + el[0].dataset['gsHeight'] + "," + el[0]
				.offsetWidth + "," + el[0].offsetHeight;
				//console.log(posQryStr);
			return posQryStr;
		}, me);
		if (me.data != null && me.data.length > 0) {
			var posDataArr = [];
			posDataArr = me.data;
			var posStr = '';
			for (var dt in posDataArr) {
				var posObjStr = posDataArr[dt];
				posStr += "|" + posObjStr;
			}
		}

		if (posStr != null && posStr.indexOf("|") == 0)
			posStr = posStr.substring(1);

		return posStr;
	},
	_gridstackDestroy: function () {
		gridStackObjRef.destroy();
	}

});