var keyCollection = '';
var currentTime;
var previousTime;
var startIndex = 0;
var lastSearchItem;
var lastKeySelection;
var element;
var api;

//Combo with scrollbar
Ext.define('utilities.ScrollCombo', {
	extend: 'Ext.form.field.ComboBox',
	alias: ['widget.scrollcombo','widget.dropdownlist'],
	cls: 'dropdown',
	hscroll: false,
	scroll_f: true,
	editable: true,
	enableKeyEvents : true,
	fancyScroll : false,
	searchResetDelay : 1000,
	isAdvancedFilterEnabled : true,
	filterMaskRe : 'contains',
	forceSelection: true,
	typeAhead: true,
	selectOnFocus: true,

	initComponent: function () {
		this.addListener('keypress',this.searchRecord,false);
	
		if (this.fancyScroll)
		{
			this.addListener('expand', this.showScroll, false);
		}
		this.callParent();
	},
	onExpand: function() {
		var thisCombo = this;
		var me = this,
			keyNav = me.listKeyNav,
			selectOnTab = me.selectOnTab,
			picker = me.getPicker();
			getParentHeight = picker.getHeight();
            getParentWidth = picker.getWidth();
            fieldID = picker.id;
			//ele = $('#' + fieldID + ' .x-boundlist-outer-ct').jScrollPane();
			//api = ele.data('jsp');
			
		// Handle BoundList navigation from the input field. Insert a tab listener specially to enable selectOnTab.
		if (keyNav) {
			keyNav.enable();
		} else {
			keyNav = me.listKeyNav = new Ext.view.BoundListKeyNav(me.inputEl, {
				boundList: picker,
				forceKeyDown: true,
				tab: function(e) {
					if (selectOnTab) {
						this.selectHighlighted(e);
						me.triggerBlur();
					}
					// Tab key event is allowed to propagate to field
					return true;
				},
				enter: function(e){
					var selModel = picker.getSelectionModel(),
						count = selModel.getCount();

					this.selectHighlighted(e);

					// Handle the case where the highlighted item is already selected
					// In this case, the change event won't fire, so just collapse
					if (!me.multiSelect && count === selModel.getCount()) {
						me.collapse();
					}
				},
				up: function() {
					var me = this,
						boundList = me.boundList,
						allItems = boundList.all,
						oldItem = boundList.highlightedItem,
						oldItemIdx = oldItem ? boundList.indexOf(oldItem) : -1,
						newItemIdx = oldItemIdx > 0 ? oldItemIdx - 1 : allItems.getCount() - 1; //wraps around
						thisCombo.highlightAt(newItemIdx);
				},
				down: function() {
					var me = this,
						boundList = me.boundList,
						allItems = boundList.all,
						oldItem = boundList.highlightedItem,
						oldItemIdx = oldItem ? boundList.indexOf(oldItem) : -1,
						newItemIdx = oldItemIdx < allItems.getCount() - 1 ? oldItemIdx + 1 : 0; //wraps around
						thisCombo.highlightAt(newItemIdx);
				},
				home: function() {
					thisCombo.highlightAt(0);
				},
				end: function() {
					var me = this;
					thisCombo.highlightAt(me.boundList.all.getCount() - 1);
				},
				pageup: function() {
					//TODO
				},
				pagedown: function() {
					//TODO
				}
			});
		}
			
		 
		// While list is expanded, stop tab monitoring from Ext.form.field.Trigger so it doesn't short-circuit selectOnTab
		if (selectOnTab) {
			me.ignoreMonitorTab = true;
		}

		Ext.defer(keyNav.enable, 1, keyNav); //wait a bit so it doesn't react to the down arrow opening the picker
		me.inputEl.focus();
	},
	highlightAt: function(index) {
		var boundList = this.getPicker(),
			item = boundList.all.item(index);
		if (item) {
			item = item.dom;
			boundList.highlightItem(item);
			if (this.fancyScroll)
			{
				var positioinY = this.getOffsetY(boundList,index);
				api.scrollToY(positioinY);
			}
			else
			{
				boundList.getTargetEl().scrollChildIntoView(item, false);
			}
		}
	},

	showScroll: function (field, eOpts) {
		var me = this;
		var getid = field.getPicker().id;
		picker = field.getPicker();
			getParentHeight = picker.getHeight();
            getParentWidth = picker.getWidth();
            fieldID = picker.id;
			
		
		
		boundList = this.getPicker();
		var highlightedItemIdx = 0;
		var selectedData = boundList.getSelectionModel();
		var comboStore = boundList.getStore();
		
		for ( var i = 0;i<comboStore.getCount();i++ )
		{
			if (selectedData.isSelected(comboStore.getAt(i)) )
			{
				highlightedItemIdx = i;
				break;
			}
		}
		if (this.fancyScroll)
		{
			//var positioinY = this.getOffsetY(boundList,highlightedItemIdx);
			//api.scrollToY(positioinY);
		}
	},
	searchRecord : function(obj, e, eOpts)
	{
		var me = this;
		if (me.enableKeyEvents) {
			var keyCode = e.getKey();
			if( (e.hasModifier() && !e.shiftKey) || e.isNavKeyPress() || e.isSpecialKey() ) {
				return;
			}

			boundList = me.getPicker();
			currentTime = new Date().getTime();
			if (previousTime == null || previousTime == undefined || previousTime.length == 0)
			{
				previousTime = new Date().getTime();
			}

			if (((currentTime - previousTime) > me.searchResetDelay) & keyCode != lastKeySelection)
			{
				keyCollection = "";
				previousTime = currentTime;
			}

			//keyArr.push(keyCode);
			//var keyCollection2 = String.fromCharCode.apply(null, keyArr);

			if (keyCode != lastKeySelection)
			{
				keyCollection = keyCollection + String.fromCharCode(keyCode);
			}
			lastKeySelection = keyCode;

			if (lastSearchItem == keyCollection)
			{
				startIndex++;
			}
			else
			{
				startIndex = 0;
			}

			var record = me.getStore().find(me.displayField, keyCollection,startIndex);
			lastSearchItem  = keyCollection;
			if (record >= 0) {
				startIndex = record;
				boundList.highlightItem(boundList.getNode(record));
				if (this.fancyScroll)
				{
					var positioinY = this.getOffsetY(boundList,record);
					
					//api.scrollByY(positioinY);
					api.scrollToY(positioinY);
				}
				else
				{
					if (!Ext.isEmpty(boundList.listEl))
					{
						boundList.listEl.scrollChildIntoView(boundList.getNode(record), false);
					}
				}
			}
			else
			{
				startIndex = 0;
			}
		}
	},
	getOffsetY : function(boundList,rec)
	{
		var node = boundList.getNode(rec),
			el = boundList.el,
			adjustmentY = 0,
			adjustmentX = 0,
			elRegion = boundList.listEl.getRegion(),
			nodeRegion;

		// DOM client dimensions
		elRegion.bottom = elRegion.top + el.dom.clientHeight;
		elRegion.right = elRegion.left + el.dom.clientWidth;
		if (node) {
			nodeRegion = Ext.fly(node).getRegion();
			// node is above
			if (nodeRegion.top < elRegion.top) {
				adjustmentY = nodeRegion.top - elRegion.top;
			// node is below
			} else if (nodeRegion.bottom > elRegion.bottom) {
				adjustmentY = nodeRegion.bottom - elRegion.bottom;
			}
		}
		return adjustmentY;
	},

	listConfig: { //This code is added to remove addCls and removeCls due to performance issue
		onItemMouseEnter: function (record, item, index, e) {
			if (this.trackOver) {
				return false;
				// this.highlightItem(item);
			}
		},
		onItemMouseLeave: function (record, item, index, e) {
			if (this.trackOver) {
				return false;
				//  this.clearHighlight();
			}
		},
		emptyText: '<center>--- No item(s) found ---</center>'
	},
	createPicker: function() {
		var me = this,
		picker,
		pickerCfg = Ext.apply({
			xtype: 'boundlist',
			pickerField: me,
			 renderTpl: [
				//Added extra div to maintain the fancy scrollbar
				'<div id="{id}-outerEl" class="{baseCls}-outer-ct" style="overflow:auto"><div id="{id}-listEl" class="{baseCls}-list-ct" style="overflow:auto"></div></div>',
					'{%',
					'var me=values.$comp, pagingToolbar=me.pagingToolbar;',
					'if (pagingToolbar) {',
					'pagingToolbar.ownerLayout = me.componentLayout;',
					'Ext.DomHelper.generateMarkup(pagingToolbar.getRenderTree(), out);',
					'}',
					'%}', {
					disableFormats: true
				}
			],
			selModel: {
				mode: me.multiSelect ? 'SIMPLE' : 'SINGLE'
			},
			onContainerMouseUp : function()
			{
				Ext.getCmp(me.getId()).focus();
			},
			floating: true,
			hidden: true,
			store: me.store,
			displayField: me.displayField,
			focusOnToFront: false,
			pageSize: me.pageSize,
			tpl: me.tpl
		}, me.listConfig, me.defaultListConfig);

		picker = me.picker = Ext.widget(pickerCfg);
		if (me.pageSize) {
			picker.pagingToolbar.on('beforechange', me.onPageChange, me);
		}

		me.mon(picker, {
			itemclick: me.onItemClick,
			refresh: me.onListRefresh,
			scope: me
		});

		me.mon(picker.getSelectionModel(), {
			beforeselect: me.onBeforeSelect,
			beforedeselect: me.onBeforeDeselect,
			selectionchange: me.onListSelectionChange,
			scope: me
		});

		return picker;
	},

	/**
	 * Executes a query to filter the dropdown list. Fires the {@link #beforequery} event prior to performing the query
	 * allowing the query action to be canceled if needed.
	 *
	 * @param {String} queryString The SQL query to execute
	 * @param {Boolean} [forceAll=false] `true` to force the query to execute even if there are currently fewer characters in
	 * the field than the minimum specified by the `{@link #minChars}` config option. It also clears any filter
	 * previously saved in the current store.
	 * @param {Boolean} [rawQuery=false] Pass as true if the raw typed value is being used as the query string. This causes the
	 * resulting store load to leave the raw value undisturbed.
	 * @return {Boolean} true if the query was permitted to run, false if it was cancelled by a {@link #beforequery}
	 * handler.
	 */
	doQuery: function(queryString, forceAll, rawQuery) {
		queryString = queryString || '';

		// store in object and pass by reference in 'beforequery'
		// so that client code can modify values.
		var me = this,
			qe = {
				query: queryString,
				forceAll: forceAll,
				combo: me,
				cancel: false
			},
			store = me.store,
			isLocalMode = me.queryMode === 'local',
			needsRefresh;

		if (me.fireEvent('beforequery', qe) === false || qe.cancel) {
			return false;
		}

		// get back out possibly modified values
		queryString = qe.query;
		forceAll = qe.forceAll;

		// query permitted to run
		if (forceAll || (queryString.length >= me.minChars)) {
			// expand before starting query so LoadMask can position itself correctly
			me.expand();

			// make sure they aren't querying the same thing
			if (!me.queryCaching || me.lastQuery !== queryString) {
				me.lastQuery = queryString;

				if (isLocalMode) {
					// forceAll means no filtering - show whole dataset.
					store.suspendEvents();
					needsRefresh = me.clearFilter();
					if (queryString || !forceAll) {

						if (me.isAdvancedFilterEnabled)
						{
							if (me.filterMaskRe == "contains")
							{
								me.activeFilter = new Ext.util.Filter({
									root: 'data',
									filterFn: function(item) {
										itemStr = item.get(me.displayField).toLowerCase();
										return itemStr.indexOf(queryString.toLowerCase()) != -1;
									}
								});
							}
							else if (me.filterMaskRe == "endsWith")
							{
								me.activeFilter = new Ext.util.Filter({
									root: 'data',
									filterFn: function(item) {
										itemStr = item.get(me.displayField).toLowerCase();
										return me.endsWith(itemStr,queryString.toLowerCase())
									}
								});
							}
							else if (me.filterMaskRe == "exactMatch")
							{
								me.activeFilter = new Ext.util.Filter({
									root: 'data',
									filterFn: function(item) {
										console.log(item.get(me.displayField) == queryString);
										return (queryString.length == 0?true:item.get(me.displayField) == queryString);
									}
								});
							}
							else if (me.filterMaskRe == "startsWith")
							{
								me.activeFilter = new Ext.util.Filter({
									root: 'data',
									property: me.displayField,
									value: queryString
								});
							}
							else
							{
								me.activeFilter = new Ext.util.Filter({
									root: 'data',
									property: me.displayField,
									value: queryString
								});
							}
						}
						else
						{
							me.activeFilter = new Ext.util.Filter({
								root: 'data',
								property: me.displayField,
								value: queryString
							});
						}
						store.filter(me.activeFilter);
						needsRefresh = true;
					} else {
						delete me.activeFilter;
					}
					store.resumeEvents();
					if (me.rendered && needsRefresh) {
						me.getPicker().refresh();
					}
				} else {
					// Set flag for onLoad handling to know how the Store was loaded
					me.rawQuery = rawQuery;

					// In queryMode: 'remote', we assume Store filters are added by the developer as remote filters,
					// and these are automatically passed as params with every load call, so we do *not* call clearFilter.
					if (me.pageSize) {
						// if we're paging, we've changed the query so start at page 1.
						me.loadPage(1);
					} else {
						store.load({
							params: me.getParams(queryString)
						});
					}
				}
			}

			// Clear current selection if it does not match the current value in the field
			if (me.getRawValue() !== me.getDisplayValue()) {
				me.ignoreSelection++;
				me.picker.getSelectionModel().deselectAll();
				me.ignoreSelection--;
			}

			if (isLocalMode) {
				me.doAutoSelect();
			}
			if (me.typeAhead) {
				me.doTypeAhead();
			}
		}
		return true;
	},
	startsWith : function(s1,s2)
	{
		return s1.indexOf(s2) == 0;
	},
	endsWith : function(s1,s2)
	{
		return Ext.String.trim(s1.substring(s1.lastIndexOf(s2))) == Ext.String.trim(s2);
	}
});



