//Overwritten for Combo, so that the boundlist view is recreated on expand- for scrollbars
Ext.require('Ext.form.field.ComboBox', function() {
	Ext.override(Ext.form.field.ComboBox, {
		element : null,
		htModified:false,
		
		onExpand : function() {
			this.callParent();
			var listId = this.getPicker().id;
			if($('#' + listId + ' .x-boundlist-list-ct')!=null && ($('#' + listId + ' .x-boundlist-list-ct').jScrollPane))
			{
				this.element = $('#' + listId + ' .x-boundlist-list-ct').jScrollPane();
				var api = this.element.data('jsp');
				if(api.getIsScrollableH() && !this.htModified){
					var jspCont=$('#' + listId + ' .x-boundlist-list-ct .jspContainer');
					var ht=jspCont.height();
					ht+=10;
					jspCont.height(ht);
					this.htModified=true;
				}
			}
		},

		onLoad : function() {
			var me = this, value = me.value;
			var expanded=me.isExpanded;
			me.collapse();
			if (!Ext.isEmpty(me.picker)) {
				me.picker.clearListeners();
				me.picker.destroy();
			}
			me.picker = this.createPicker();
			if (me.ignoreSelection > 0) {
				--me.ignoreSelection;
			}
			// If performing a remote query upon the raw value...
		if (me.rawQuery) {
			me.rawQuery = false;
			me.syncSelection();
			if (me.picker && !me.picker.getSelectionModel().hasSelection()) {
				me.doAutoSelect();
			}
		}
		// If store initial load or triggerAction: 'all' trigger click.
		else {
			// Set the value on load
			if (me.value || me.value === 0) {
				me.setValue(me.value);
			} else {
				// There's no value.
				// Highlight the first item in the list if autoSelect: true
				if (me.store.getCount()) {
					me.doAutoSelect();
				} else {
					// assign whatever empty value we have to prevent change
					// from firing
					me.setValue(me.value);
				}
			}
		}
		if(expanded){
			me.expand();
		}
	}

	});

});

//Had to overwrite since store expand event was not getting fired
Ext.require('Ext.data.NodeStore', function() {
	
	Ext.override(Ext.data.NodeStore, {
	    onNodeExpand: function(parent, records, suppressEvent) {
		try{
        var me = this,
            insertIndex = me.indexOf(parent) + 1,
            ln = records ? records.length : 0,
            i, record;

        if (!me.recursive && parent !== me.node) {
            return;
        }

        if (parent !== this.node && !me.isVisible(parent)) {
            return;
        }

        if (!suppressEvent && me.fireEvent('beforeexpand', parent, records, insertIndex) === false) {
            return;
        }
        if (ln) {
            me.insert(insertIndex, records);
            for (i = 0; i < ln; i++) {
                record = records[i];
                if (record.isExpanded()) {
                    if (record.isLoaded()) {
                        // Take a shortcut
                        me.onNodeExpand(record, record.childNodes, true);
                    }
                    else {
                        record.set('expanded', false);
                        record.expand();
                        if (!suppressEvent) {
                            me.fireEvent('expand', parent, records);
                        }
                    }
                }
            }
        }
        if (!suppressEvent) {
            me.fireEvent('expand', parent, records);
        }
    }catch(e){
        if (!suppressEvent) {
            me.fireEvent('expand', parent, records);
        }
    }
	}
	});
});
