Ext.define('utilities.StatefulTreePanel', {
	extend: 'utilities.ScrollableTreePanel',
	xtype: 'statefultreepanel',
	uses: [
	       'Ext.tree.Panel'
	       ],
	       initComponent: function() {
	    	   Ext.apply(this, {
	    		   stateful: true,
	    		   stateEvents: ['itemcollapse','itemexpand']
	    	   });
	    	   this.callParent(this);
	       },
	       getState: function() {
	    	   var nodes = [], state = this.callParent();
	    	   var getPath = function(node, field, separator) {
	    		   field = field || node.idProperty;
	    		   separator = separator || '/';
	    		   var path = [node.get(field)], parent = node.parentNode;
	    		   while (parent) {
	    			   path.unshift(parent.get(field));
	    			   parent = parent.parentNode;
	    		   }
	    		   return separator + path.join(separator);
	    	   };
	    	   this.getRootNode().eachChild(function(child) {
	    		   // function to store state of tree recursively
	    		   var storeTreeState = function(node, expandedNodes) {
	    			   if (node.isExpanded() && node.childNodes.length > 0) {
	    				   expandedNodes.push(getPath(node, 'text'));
	    				   node.eachChild(function(child) {
	    					   storeTreeState(child, expandedNodes);
	    				   });
	    			   }
	    		   };
	    		   storeTreeState(child, nodes);
	    	   });
	    	   Ext.apply(state, {
	    		   expandedNodes: nodes
	    	   });
	    	   return state;
	       },

	       applyState: function(state) {
	    	   var nodes = state.expandedNodes || [],
	    	   len = nodes.length;
	    	   for (var i = 0; i < len; i++) {
	    		   if (typeof nodes[i] != 'undefined') {
	    			   this.expandPath(nodes[i], 'text');
	    		   }
	    	   }
	    	   this.callParent(arguments);
	       }
});  