Ext.define('utilities.Toggleswitch',{
	extend: 'Ext.form.field.Checkbox',
	alias: ['widget.switchfield', 'widget.switchbox'],
	fieldCls:'eg-toggle',
	ui:'eg-toggleswitch',
	fieldStyle:'egtoggle',
	padding:'0 0 5 0',
	boxLabelAlign:'before',
	initComponent:function(){
		var me = this;
        me.callParent();
	},
	getSubTplData: function() {
        var me = this;
        return Ext.apply(me.callParent(), {
            disabled      : me.readOnly || me.disabled,
            boxLabel      : me.boxLabel,
            boxLabelCls   : me.boxLabelCls,
			checked: me.checked,
            boxLabelAlign : me.boxLabelAlign
        });
    },
	setValue: function(checked) {
        var me = this,
            boxes, i, len, box;
        if (Ext.isArray(checked)) {
            boxes = me.getManager().getByName(me.name, me.getFormId()).items;
            len = boxes.length;
            for (i = 0; i < len; ++i) {
                box = boxes[i];
                box.setValue(Ext.Array.contains(checked, box.inputValue));
            }
        } else {
			Ext.defer(function(){
				if(!Ext.isEmpty(me))
				{
					var inpId=me.getInputId( );
					if(!Ext.isEmpty(inpId))
					{ 
						document.getElementById(inpId).checked = checked;
					}
				}
			},100);
            me.callParent(arguments);
        }

        return me;
    },
	
    fieldSubTpl: [
        '<tpl if="boxLabel && boxLabelAlign == \'before\'">',
            '{beforeBoxLabelTpl}',
            '<label id="{cmpId}-boxLabelEl" {boxLabelAttrTpl} class="{boxLabelCls} {boxLabelCls}-{boxLabelAlign}" for="{id}">',
                '{beforeBoxLabelTextTpl}',
                '{boxLabel}',
                '{afterBoxLabelTextTpl}',
            '</label>',
            '{afterBoxLabelTpl}',
			'<label  class="hiddenLabel hidden-{boxLabelAlign}" for="{id}"></label>',
        '</tpl>',
        '<input type="checkbox"    id="{id}" {inputAttrTpl}',
            '<tpl if="tabIdx"> tabIndex="{tabIdx}"</tpl>',
            '<tpl if="disabled"> disabled="disabled"</tpl>',
            '<tpl if="checked">checked = "{checked}"</tpl>',
            '<tpl if="fieldStyle"> style="{fieldStyle}"</tpl>',
            ' class="{fieldCls} {fieldStyle}"  autocomplete="off" hidefocus="true" />',
			'<label  class="hiddenLabel hidden-{boxLabelAlign}" for="{id}"></label>',
			'<tpl if="boxLabel && boxLabelAlign == \'after\'">',
            '{beforeBoxLabelTpl}',
             '<label id="{cmpId}-boxLabelEl" {boxLabelAttrTpl} class="{boxLabelCls} {boxLabelCls}-{boxLabelAlign}" for="{id}">',
                '{beforeBoxLabelTextTpl}',
                '{boxLabel}',
                '{afterBoxLabelTextTpl}',
            '</label>',
            '{afterBoxLabelTpl}',
        '</tpl>',

        {
            disableFormats: true,
            compiled: true
        }
    ]
});