var pagingBar2 = Ext.define('pagingBar2',{
		extend:'Ext.toolbar.Paging',
		alias:'widget.pagingbar2',
		getPagingItems: function() {
		var me = this;
		return [{
			itemId: 'first',
			tooltip: me.firstText,
			overflowText: me.firstText,
			iconCls: Ext.baseCSSPrefix + 'tbar-page-first',
			disabled:true,
			hidden:true,
			handler: me.moveFirst,
			scope: me
		},{
			itemId: 'prev',
			tooltip: me.prevText,
			overflowText: me.prevText,
			overCls:'sss',
			//iconCls: Ext.baseCSSPrefix + 'tbar-page-prev',
			iconCls:'iconWidgetLibLeftArrow',
			disabled:false,
			height:24,
			width:16,
			padding:0,
			hidden:false,
			handler: me.movePrevious,
			scope: me
		},
		{
			xtype: 'numberfield',
			hidden:true,
			itemId: 'inputItem',
			name: 'inputItem',
			cls: Ext.baseCSSPrefix + 'tbar-page-number',
			allowDecimals: false,
			minValue: 1,
			hideTrigger: true,
			enableKeyEvents: true,
			keyNavEnabled: false,
			selectOnFocus: true,
			submitValue: false,
			// mark it as not a field so the form will not catch it when getting fields
			isFormField: false,
			width: me.inputItemWidth,
			margins: '-1 2 3 2',
			listeners: {
				scope: me,
				keydown: me.onPagingKeyDown,
				blur: me.onPagingBlur
			}
		},{
			xtype: 'tbtext',
			hidden:true,
			itemId: 'afterTextItem',
			text: Ext.String.format(me.afterPageText, 1)
		}, {
            itemId: 'next',
            tooltip: me.nextText,
            overflowText: me.nextText,
           //iconCls: Ext.baseCSSPrefix + 'tbar-page-next',
			iconCls:'iconWidgetLibRightArrow',
			overCls:'sss',
            disabled: true,
			hidden:false,
			height:24,
			width:16,
			padding:0,
            handler: me.moveNext,
            scope: me
        },{
			itemId: 'last',
			hidden:true,
			tooltip: me.lastText,
			overflowText: me.lastText,
			iconCls: Ext.baseCSSPrefix + 'tbar-page-last',
			disabled: true,
			handler: me.moveLast,
			scope: me
		},{
			itemId: 'refresh',
			hidden:true,
			tooltip: me.refreshText,
			overflowText: me.refreshText,
			iconCls: Ext.baseCSSPrefix + 'tbar-loading',
			handler: me.doRefresh,
			scope: me
		}];
	}
});




Ext.define('utilities.WidgetLibrary', {
	alias: 'widget.widgetLibrary',
	extend:'Ext.window.Window',
	height:strSkin == "Light"?381:371,
	width:strSkin == "Light"?605:585,
	autoScroll:false,
	scroll:false,
	closeAction:'destroy',
	resizable:false,
	header:{
		height:33,
		padding:'0 10',
		margin:0
	},
	ghost:false,
	cls:'myDashboardwindow',
	frame:false,
	padding:0,
	bodyPadding:0,
	margin:0,
	border:false,
	modal:true,
	title:'WIDGET LIBRARY',
	url:'',
	windowMode:'big',
	loadDynamicStore:function(){
			var me = this;

		me.dynamicStore = Ext.create('Ext.data.Store',{
			fields: [
				{name:'grpName', type:'string'},
				{name:'grpIcon', type:'string' },
				{name:'grpOwner', type:'string' },
				{name:'isSelected', type:'boolean' },
				{name:'subset', type:'array'}
			],
			proxy: {
				type: 'ajax',
				url: me.url, // '/final/monitor/SampleWidgetLibaryJson.jsp?isFromPaging=true',
				reader: {
					type :'json',
					root: 'result',
					totalProperty: 'totalCount'
				}
			},
			pageSize:pageCountSize
		});
	  me.dynamicStore.load();
	},
	initComponent:function(){
		var me = this;


		//var winHeight = me.height;
		//var winInnerContainerHeight = 290;
		//var pageSize =


		var getMode = me.url;
//		var windowMode = '';
//		if(getMode!=null && getMode!='' && getMode.indexOf('?')>0)
//		{
//			var params = getMode.substring(getMode.indexOf('?')+1);
//			params = params.split('&');
//			for(var i=0;i<params.length;i++)
//			{
//				if(params[i].startsWith('windowMode'))
//				{
//					modeVale = params[i].substring(params[i].indexOf("=")+1);
//					console.log("modeVale:",modeVale);
//						windowMode = modeVale;
//						break;
//				}
//			}
//		}
		if (me.windowMode == "big")
		{
			if (strSkin == "Light")
			{
				
				me.height=560;
			}
			else
			{
				me.height=550;
			}
			winInnerContainerHeight=515;
			winInnerSubsetHeight=495;
			winInnerSubsetWidth =350;
			pageCountSize=11;
		}
		else{
			if (strSkin == "Light")
			{
				me.height=381;
			}
			else
			{
				me.height=371;
			}
			winInnerContainerHeight=335;
			winInnerSubsetHeight=334;
			winInnerSubsetWidth =373;
			pageCountSize=7;
		}

		me.loadDynamicStore();
		Ext.apply(me,{
			items:{
				xtype:'container',
				height:winInnerContainerHeight,
				cls:'formOuter',
				style:{'overflow':'hidden'},
				margin:10,
				items:[{
					xtype:'dataview',
					id:'widgetLibraryId2',
					store: me.dynamicStore,
					itemSelector:'.mainX',
					tpl : new Ext.XTemplate(
						'<div style="height:'+winInnerContainerHeight+'px;overflow:hidden;">',
							'<ul>',
								'<tpl for=".">',
										'<li class="mainX">',
										'<div style="width:210px;height:45px;" class="widgetLibraryButton">',
											'<table border="0px" cellpadding="0px" cellspacing="0px" width="100%" height="100%">',
												'<tr>',
													'<td align="center" valign="middle">',
														'<div style="float:left">{grpName}</div>',
														'<div style="float:left;margin-left:10px" class="{grpIcon}"  title="{grpOwner}"></div>',
													'</td>',
												'</tr>',
											'</table>',
										'</div>',
										'<div style="width:'+winInnerSubsetWidth+'px;height:'+winInnerSubsetHeight+'px;float:right;" class="widgetLibraryItems">',
											'<tpl for="subset">',
												'<div style="width:340px;padding:10px" class="x-item">',
													'<table border="0px" cellpadding="0px" cellspacing="0px" width="100%" height="100%">',
														'<tr>',
															'<td align="left" valign="middle" width="50px">',
																'<tpl if="!isDefaultImg">',
																'<div class = "widget_pla ceHolder">',
																'<img src={subsetIcon} width="32px" height="32px" class="png"/>',
																'</div>',
																'</tpl>',
																'<tpl if="isDefaultImg">',
																	'<div style="float:left;" class="{subsetIcon}"></div>',
																'</tpl>',
															'</td>',
															'<td align="left" valign="middle">',
																'<div class="widgetLibraryIconNameFont">{subsetName}</div>',
																'<div class="font_normal11">{shortSummary}</div>',
															'</td>',
															'<td align="center" valign="middle"  width="100px">',
																'<tpl if="add" >',
																	'<button id="{subsetName}_add" widgetintid="{widgetId}" class="widgetAddButton" onClick="javascript:addWidget(\'{widgetInternalId}\',\'{template_name}\',\'{displayType}\',\'{subsetName}\');" style="display:block;">Add</button>',
																	'<button id="{subsetName}_remove" widgetintid="{widgetId}" class="widgetRemoveButton" onClick="javascript:removeWidget(\'{widgetId}\',\'{subsetName}\');" style="display:none;">Remove</button>',
																'<tpl elseif="added" >',
																/*	'<button id="\'{subsetName}\'" class="widgetAddButtonDisabled">Add</button>',
																'<tpl else>',*/
																	'<button id="{subsetName}_add" widgetintid="{widgetId}" class="widgetAddButton" onClick="javascript:addWidget(\'{widgetInternalId}\',\'{template_name}\',\'{displayType}\',\'{subsetName}\');" style="display:none;">Add</button>',
																	'<button id="{subsetName}_remove" widgetintid="{widgetId}" class="widgetRemoveButton" onClick="javascript:removeWidget(\'{widgetId}\',\'{subsetName}\');" style="display:block;">Remove</button>',
																'</tpl>',
															'</td>',
														'</tr>',
													'</table>',
												'</div>',
											'</tpl>',
										'</div>',
										'<div style="clear:both"></div>',
									'</li>',
								'</tpl>',
							'</ul>',
						'</div>'
					),
					listeners: {
						'containerclick':function(){
							return false;
						},
						'refresh':function(){
							this.getSelectionModel().select(0);
						},
						'viewready':function(){
							if(this.getStore().getCount() < this.getStore().pageSize){
								Ext.select('.pagingbarShowHideFunction').hide();
							}
							this.el.on('click',function(evt,target){
								/*var target_id=target.id;
								if(target_id!=null && target_id.lastIndexOf("_")>0)
								{
									target_id=target_id.substring(0,target_id.lastIndexOf("_"));
								}
								var rmvBtnObj=Ext.get(target_id+"_remove");
								var addBtnObj=Ext.get(target_id+"_add");
								if(Ext.get(target).hasCls('widgetRemoveButton')){
									//rmvBtnObj.setVisibilityMode(Ext.Element.HIDDEN);
									//addBtnObj.setVisibilityMode(Ext.Element.DISPLAY);
									rmvBtnObj.hide();
									addBtnObj.show();
									//addBtnObj.show();
									//rmvBtnObj.hide();
								}else{
									//Ext.get(target).update('Add');
									rmvBtnObj.show();
									addBtnObj.hide();
									//rmvBtnObj.setVisibilityMode(Ext.Element.DISPLAY);
									//addBtnObj.setVisibilityMode(Ext.Element.HIDDEN);
									//rmvBtnObj.show();
									//addBtnObj.hide();
								}*/
								/*var btnObj=document.getElementById(target.id);
								if(target.id!=null && target.id.indexOf('_add')>-1)
								{
									Ext.get(target).addCls('widgetRemoveButton');
									btnObj.innerHTML='Remove';
								}
								else if(target.id!=null && target.id.indexOf('_remove')>-1)
								{
									Ext.get(target).addCls('widgetAddButton');
									btnObj.innerHTML='Add';
								}
								btnObj=null;
								delete btnObj;*/
							},null,{delegate:'button'});
						}
					}
				},{
						xtype: 'pagingbar2',
						store: me.dynamicStore, // same store GridPanel is using
						displayInfo: true,
						cls:"pagingbarShowHideFunction",
						width:40,
						padding:0,
						margin:0,
						style:{'position':'absolute','z-index':'20','bottom':'0px','left':'160px'},
						floatable:true,
				}]
			}
		})
		this.callParent();
	},

	tools:[
		{
			xtype : 'button',
			iconCls : 'iconHelp',
			listeners: {
				afterrender: function () {
					Ext.create('Ext.tip.ToolTip', {
						target: this.id,
						anchor: 'top',
						cls: 'yellowTip',
						trackMouse: true,
						html: 'Help'
					});
				}
			},
			style : {
				'background' : 'none',
				'border' : '0px',
				'margin':'0 1 0 0',
			},
			handler : function()
			{
				HelpWin();
			}
		}
	],
	closeAction : 'destroy',
	dashBoardAction : '',
	profileName : '',
	layout:{type:'fit'}
});



