Ext.Loader.setConfig({
	 enabled: true,
	 disableCaching: false
});

Ext.application({
	  name: 'zonesMapError',
	  appFolder:'../monitor/eg_scripts/zonesMap',
      launch: function() {
    		Ext.Ajax.request({
				url : errUrl,
				scope : this,
				success : function(response) {
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					var errorPanel = {
							xtype : 'errorpanel',
							cls : 'error_panel',
							bodyCls:'error_panel bottom-left-radius bottom-right-radius',
							height : '50%',
							width : '100%',
							border : true,
		            		dockedItems : [{
        						xtype : 'toolbar',
							    cls : 'component-list-right-panel-header',
        						items :[{
				            		xtype : 'label',
				            		text : 'ZONE MAP',
				            		cls : 'zone-toolbar-title'
			            		}]
        					}],
							margin : 5,
							errorMsg : '<img src="'
									+ jsonData.imageSrc + '"/><br/><b>' + jsonData.message
									+ '</b>'
					};
					Ext.create('Ext.container.Viewport', {
			            layout: 'fit',
			            cls:'viewport-panel',
	            		border : false,
			            items:[{
			            		xtype : 'panel',
			            		layout : 'fit',
			            		items : errorPanel
			            }]
			        });
			      }
				});
      }
    		
});