/*
 * gridsterPanel is a container that has specific functionality of GridSter.js which is bulit upon the
 * jquery lib.
 * gridsterPanel, by virtue of their inheritance from of Ext.js.
 * For more Info visit http://gridster.net/ 
 * Usually, gridsterPanel that makes building intuitive draggable layouts from elements spanning multiple columns
 *    @example
 *    var gridsterPanel = Ext.create('utilities.gridsterPanel', {
 *	   flex :1,
 *     layoutStyle  : {
 *         "type":"linear",//layout configuration linear,tabular,relative,custom
 *         "min_cols":2,
 *         "max_cols":2,
 *         "widget_base_dimensions" : [135, 130],
 *         "resizeWidget" : true, // All widget resize will enable and disable based on Boolean value
 *         "dragWidget" : true    // All widget drag  will enable and disable based on Boolean value

 *		},
 *		//data SHOULD me same format 
 *			data: [
 *			        {id :"panel1",row:1,col:1,size_x:1,size_y:1,widgetType:"table",widgetIcon:"tableCls"},
 *			        {id :"panel2",row:1,col:1,size_x:1,size_y:1,widgetType:"grid",widgetIcon:"girdCls"}
 *			  ]
 *		});
 * Note that the gridsterPanel above is configured to json MUST contains row,col,size_x,size_y
 *
 * size_x Number  	The number of rows that the widget occupies. Defaults to 1.
 * size_y Number 	The number of columns that the widget occupies. Defaults to 1.
 * col Number 	    The column the widget should start in. 
 * row Number	    The row the widget should start in.
 * For more details you can check the documentation in same folder GridsterPanel.docx
 */

Ext.define('utilities.gridsterPanel',{
	extend:'Ext.container.Container',
	alias: 'widget.gridsterpanel',
	margin:'0 5',
	flex:1,
	count:0,
	closeAction:'destroy',
	items:[],
	layoutStyle:{
		"type":"linear",
		"min_cols":2,
		"max_cols":2,
		"widget_base_dimensions":[135, 150],
		"resizeWidget":true,
		"dragWidget":true
	},//linear,tabular,relative,custom 
	//resizeWidget:true,
	frame:false,
	cls:'gridster',
	tpl: '<tpl for="."><div id="{id}" class="portlet gs-w x-container x-container-default" data-row="{row}" data-col="{col}" data-sizex="{size_x}" data-sizey="{size_y}" data-type="{widgetType}"  data-icon="{widgetIcon}"></div></tpl>',
	data:[],
	initComponent:function(){
		// TODO
		var gridsterPanel = this;
		/* gridsterPanel.data = [
			{id :"panel1",row:1,col:1,size_x:1,size_y:1,widgetType:"table",widgetIcon:"tableCls"},
			{id :"panel2",row:1,col:1,size_x:1,size_y:1,widgetType:"grid",widgetIcon:"girdCls"}
		] */
		gridsterPanel.renderPanel();
		var gridsterItems = gridsterPanel.items;
		var itemsLength = gridsterItems.length;
		if(itemsLength == 0){
			console.log('NO ITEM FOUND')
		}
		else
		{
			gridsterPanel.on('resize', gridsterPanel.loadGridSter, gridsterPanel);
		}
		
		gridsterPanel.callParent();
		
	},
	/*
	* To get hold of the API object, 
	* use the jQuery data method like so
	*/
	getGridsterObj:function(){
		var gridster = $(".gridster").gridster().data('gridster');
		return gridster
	},
	/* 
	* Adding the toolbar dynamically in each widget
	*/
	addToolBarItems:function(items){
		var gridsterPanel = this;
		if(Ext.isArray(items)){
			var toolbar = {
				xtype:'toolbar',
				items:items
			}
			return toolbar;
		}else{
			alert('error in  @param, use as array [{..},{..}]');
		}
		

	},
	/**
	* Loading the gridster.js api
	* Return gridster object
	*/
	loadGridSter:function(){
				var gridsterPanel = this,min_cols,max_cols,widget_base_dimensions,config,result=[];	
				var gridsterObj = $(".gridster").gridster({
							widget_margins: [5, 5],
							//min_cols: gridsterPanel.layoutStyle.min_cols,
							//max_cols:gridsterPanel.layoutStyle.max_cols,
							//widget_base_dimensions:[gridsterPanel.up('panel').body.getWidth()*3,200],
							autogenerate_stylesheet:true,
							widget_base_dimensions:gridsterPanel.layoutStyle.widget_base_dimensions,
							draggable: 
								{
									enabled: true,
									scroll:true,
									start: function(e, ui, $widget) 
									{
									},
									drag: function(e, ui, $widget) 
									{
									},
									stop: function(e, ui, $widget) 
									{
									 
									   var newpos = this.serialize($widget)[0];
									   console.log("New col: " + newpos.col + " New row: " + newpos.row);
									}
							},
							resize: {
							enabled:gridsterPanel.layoutStyle.resizeWidget,
							start:function(e, ui, $widget){
								
							},
							resize:function(e, ui, $widget){
								 Ext.suspendLayouts();
								 Ext.getCmp($widget[0].getAttribute('id')+'_panel').setSize($widget.width(), $widget.height());
								 Ext.resumeLayouts(true);
							},
							stop: function(e, ui, $widget){
								Ext.getCmp($widget[0].getAttribute('id')+'_panel').suspendEvents(true);
								Ext.getCmp($widget[0].getAttribute('id')+'_panel').setSize($widget.width(), $widget.height());
								Ext.getCmp($widget[0].getAttribute('id')+'_panel').resumeEvents( );
								Ext.getCmp($widget[0].getAttribute('id')+'_panel').doComponentLayout();
							}	
						},
						widget_selector: "div.portlet",
						serialize_params: function($w, wgd) {
								return {
									col: wgd.col,
									row: wgd.row,
									size_x: wgd.size_x,
									size_y: wgd.size_y
								};
						}
						
				}).data(gridsterObj);
			// Drag method will be disabled if false
			if(gridsterPanel.layoutStyle.dragWidget == false){
				gridsterObj.gridster.disable();
			}

			gridsterPanel.doComponentLayout();
			return gridsterObj;

	},
	/**
	* Responsive panel when resize window
	*/
	beResponsive:function($widgets){
		var gridsterPanel = this;	
		if($widgets){
			$.each($widgets, $.proxy(function (index,element) {
				$($($widgets[index]).attr('id')).trigger('resize');
			}, $widgets));
		}

	},
	/**
	* Rendering the Ext panel in gridster widget
	* see @ addPanel() method
	*/
	renderPanel:function(){
		var gridsterPanel = this;
		console.log(gridsterPanel.data);
		Ext.each(gridsterPanel.data, function(obj){
				Ext.defer(function(){
					console.log(obj);
					gridsterPanel.addPanel(obj.id,Ext.fly(obj.id).getWidth(),Ext.fly(obj.id).getHeight(),obj.widgetType,obj.widgetIcon);
				},100);
		});
	},
	/**
	* Array of objects with representing the current 
	* position of the widgets who have changed position., 
	* ready to be encoded as a JSON string
	*/
	getGridSterChangedPositions:function(){
		var gridsterPanel = this;
		return gridsterPanel.loadGridSter().gridster.serialize_changed( );
	},
	/**
	* Array of objects with positions of all widgets, 
	* ready to be encoded as a JSON string
	*/
	gridsterSerialize:function(){
		var gridsterPanel = this;
		return gridsterPanel.loadGridSter().gridster.serialize();
	},
	/**
	* Load the data based on @parma {type}
	* Called in @addPanel method
	*/
	loadWidgetData:function(type){
		var gridsterPanel = this;
		var box = {
			xtype:'container',
			closeAction:'destroy',
			layout:{type:'hbox',align:'stretch',pack : 'center'},
			flex:1,
			items:[{
				xtype:'button',
				text:type,
				ui:'plain',
				handler:function(){
					var button = this;
					button.up('panel').removeAll();
				}
				}]
		}
		return box;
	},
	/**
	* Creating the Ext.panel and returning the panel object 
	* This object is render into gridster widget 
	* see @ renderPanel() method
	*/
	addPanel:function(renderto_id,width,height,type,icon){
		var gridsterPanel = this;
		var panel = new Ext.create('Ext.panel.Panel',{
			closeAction:'destroy',
			cls:'datapanel',
			headerEditor:function(cmp){
			headerCmp = cmp.getHeader().titleCmp;
				var el = Ext.get(cmp.getHeader().id+'_hd-'+headerCmp.childEls[0]);
				el.on('click',function(){
				 var editor = new Ext.Editor({
					alignment:"tl",
					updateEl: true,
					field: {
						xtype: 'textfield'
					}
				});
				editor.startEdit(el);
			},cmp.getHeader());
			},
			layout:{type:'vbox',align:'stretch'},
			id:renderto_id+'_panel',
			title:'title',
			items:[
				gridsterPanel.loadWidgetData(type)
			],
			tools:[
				//Adding the toolbar
				gridsterPanel.addToolBarItems([
				{xtype:'button', text: 'color'},
				{xtype:'button',text:'settings'},
				{xtype:'button',
							text:'x',
							handler:function(btn){
								Ext.bind(gridsterPanel.onPortletClose(renderto_id,panel), gridsterPanel);
							}
						}
				])
				
			],
			listeners:{
				'afterrender':function(cmp){
						cmp.headerEditor(cmp);
					},
				'beforeclose':function(panel) {
					if(panel.panelClose) {
						panel.panelClose = false;
						return true;
					}
					Ext.Msg.show({
						 title:'Close confirmation',
						 msg:'Really close?',
						 buttons:Ext.Msg.YESNO,
						 callback:function(btn) {
							if('yes' === btn) {
								panel.panelClose = true;
								// animation 
								panel.el.slideOut('t', {
								easing: 'back-in',
								duration: 100,
								callback: function(){
									// Execute my custom method after the animation
									Ext.destroy(panel);
									gridsterPanel.removeWidget(renderto_id);
								},
								scope: panel
								});
							}
						}
					});
					return false;
				}
			},
			width:width -2,
			height:height,
			renderTo:renderto_id
		});
		return panel;
	},
	/**
    * Adding widget to the layout
	* Getting the ID of the widget and rendering the Ext.panel 
	* See addPanel() method
	* Updating the data
    */
	addWidget:function(){
		var gridsterPanel = this;
		var dyId = 'widget'+gridsterPanel.count++;
		console.log(gridsterPanel.count ++);
		gridsterPanel.suspendEvents();
		//BASED OF LAYOUT type have to change the logic
		if(gridsterPanel.data){
			newData = {"id":dyId,"row":1,"col":1,"size_x":2,"size_y":1,"widgetType":"table","widgetIcon":"tableCls"};
			gridsterPanel.data.push(newData);	
		}

		gridsterPanel.loadGridSter().gridster.add_widget.apply(gridsterPanel.loadGridSter().gridster, 
		['<div id="'+dyId+'" class="portlet gs-w x-container x-container-default" data-type="'+newData.widgetType+'"  data-icon="'+newData.widgetIcon+'"></div>',
		newData.size_x,
		newData.size_y
		]);
		// TODO
		gridsterPanel.addPanel(dyId,Ext.fly(dyId).getWidth(),Ext.fly(dyId).getHeight(),newData.widgetType,newData.widgetIcon);

		//While adding widget be focus
		Ext.fly(dyId).scrollIntoView(Ext.get(gridsterPanel.up('panel').body.id),false,true);
		gridsterPanel.resumeEvents(true);
		gridsterPanel.doComponentLayout();
	},
	/**
	* Firing the event of panel 'beforeclose'
	* panel has inline listeners object 
	* see @ addPanel method
	*/
	onPortletClose: function(portlet,panel) {
		var gridsterPanel = this;
		panel.fireEvent('beforeclose',panel);
    },
	/**
    * Removing widget from the layout
    */
	removeWidget:function(id){
		var gridsterPanel = this;
		gridsterPanel.suspendEvents();
		gridsterPanel.loadGridSter().gridster.remove_widget($('#'+id));
		gridsterPanel.resumeEvents(true);
		gridsterPanel.doComponentLayout();
	},
	/**
    * Removing all widget from the layout
    */
	removeAllWidget:function(){
		var gridsterPanel = this;
		gridsterPanel.loadGridSter().gridster.remove_all_widgets();
	},
	/*
	* default postion to be reset
	* see @ revertWidgetPositions method
	*/
	getGridsterOrginPositions:function(){
		var gridsterPanel = this,data;
		if(gridsterPanel.data){
				data = gridsterPanel.data
		}
		return data;
	},
	/**
	* Reverting the widget position to original positions
	*/
	revertWidgetPositions:function(){
		var gridsterPanel = this;
		for (var i = 0; i < gridsterPanel.data.length; i++) {
					var element = $(".gridster div.portlet[id='"+gridsterPanel.data[i].id.toString()+"']");
					element.attr("data-row",gridsterPanel.data[i].row.toString());
                    element.attr("data-col",gridsterPanel.data[i].col.toString());
                    element.attr("data-sizey",gridsterPanel.data[i].size_x.toString());
                    element.attr("data-sizey",gridsterPanel.data[i].size_y.toString());
        }
        gridsterPanel.destroyGridster();     
	    gridsterPanel.loadGridSter();
        return false;
	},
	/**
	* Destroying the grdister
	*/
	destroyGridster:function(){
		var gridsterPanel = this;
		gridsterPanel.getGridsterObj().destroy();
		var childNodes = document.getElementById(gridsterPanel.id).childNodes;
		for (var i = childNodes.length-1, cmp; i >= 0; i--) {
			cmp = Ext.getCmp(childNodes[i].id);
			if (cmp) {
				cmp.destroy();
			}
		}
	}
	

});
