Ext.define('Tvmode', {
 extend: 'Ext.data.Model',
	fields: [
		{ name:'url', type:'string' },
		{ name:'dashbordName', type:'string' },
		{ name:'module', type:'string' },
		{ name:'title', type:'string' },
        { name:'timeFrequency', type: 'number' },
	]
});
var tvmodetpl = new Ext.XTemplate(
	'<ul  id="content-slider" class="content-slider">',
    '<tpl for=".">',
        '<li dataURI="{url}" pagefrq="{timeFrequency}" class="dashboard-wrap" style="height:100%;">',
		'<h1 class="tvmode_header">{title}</h1>',
		'</li>',
	'</tpl>',
	'</ul>'
);
Ext.define('Tvmode',{
	extend:'Ext.view.View',
	alias:'widget.tvmode',
	flex:1,
	height:'100%',
	width:'100%',
	getTimeFrequency:null,
	//store: Ext.data.StoreManager.lookup('tvmodeStore'),
	initComponent:function(){
		var me = this;
		/*** 
			Depends on autoplay property,
			this will play autoscroll or not in each page
		***/
		me.sliderAction =  me.autoPlay ? 'pause' : 'play';
		me.mon(me,'viewready',me.loadSlider,me);
		me.mon(me,'resize',me.resizedash,me);
		me.callParent();
	},
	tpl: tvmodetpl,
	itemSelector: 'li.dashboard-wrap',
	emptyText: 'No dashboard available',
	transactionSpeed: 400,
	sliderObj:null,
	autoPlay: true,
	overMask:true,
	mode:'fade',
	sliderAction:'play',
	intervalTransactionSpeed:10000, //In ms
	resizedash:function(){
			var me = this;
			me.xpso = Ext.getBody().getViewSize().width - 80;
			me.ypso = Ext.getBody().getViewSize().height;
			if(!Ext.isEmpty(Ext.getCmp('layer'))){
				me.xpso = Ext.getBody().getViewSize().width - 80;
				me.ypso = Ext.getBody().getViewSize().height - Ext.getCmp('layer').getHeight();
				Ext.defer(function(){
					//Ext.getCmp('layer').setPosition(me.xpso, me.ypso);
					//Ext.getCmp('layer').setSize(80, Ext.getCmp('layer').getHeight());
				},100);
			}
		Ext.get(window).on('mousemove',function(event){
						if(event.getX() > me.xpso - 80){
							if(!Ext.isEmpty(Ext.getCmp('layer'))){
							Ext.getCmp('layer').show();
							}
						}else{
							if(!Ext.isEmpty(Ext.getCmp('layer'))){
							Ext.getCmp('layer').hide();
							}
						}
					});
		
	},
	sliderControllers:function(){
		//TODO
		var me = this;
		var layer = Ext.create('Ext.container.Container',{
			flex:1,
			width:80,
			height:me.ypso,
			id:'layer',
			defaults:{
				margin:'1 0',
			},
			
			floating:true,
			x:me.xpso,
			overCls:'lightlayerOver',
			cls:'lightlayer',
			items:[
			{
				xtype:'button',
				width: 85,
				overCls:'btoverCls',
				height: 85,
				iconAlign:'right',
				cls:'btselector',
				iconCls:'btnNext',
				id:'nextBtn',
				listeners:{
					'click':function(){
						me.sliderObj.goToNextSlide(); 
							// if(me.sliderAction == "pause" && Ext.getCmp('playBtn').ifScroll  === false){
							// 	Ext.defer(function(){
							// 		me.sliderObj.play();
									
							// 	},window.playBackFrequency)
							// }
							//me.silderAction = "next";
						}
					}
				
			},
			{
				xtype:'button',
				enableToggle: true,
				cls: 'btncls btselector',
				overCls:'btoverCls',
				pressedCls:'toogleState',
				width: 85,
				height: 85,
				iconAlign:'right',
				iconCls: me.autoPlay ? 'btnclsPause' : 'btnclsPlay',
				id: 'playBtn',
				ifScroll:false,
				pressed: me.autoPlay, // depends on the autoplay config of widget
				handler: function(btn) {
						if (btn.pressed == true) {
							if(btn.ifScroll === false){
								me.sliderObj.play(); 
							}
							btn.setIconCls('btnclsPause');
							me.sliderAction = "pause";
							
						}else {
							if(btn.ifScroll === false){
								me.sliderObj.pause(); 
							}
							btn.setIconCls('btnclsPlay');
							me.sliderAction = "play";
						};
					}
			},
			{
				xtype:'button',
				width: 85,
				overCls:'btoverCls',
				height: 85,
				iconAlign:'right',
				cls:'btselector',
				iconCls:'btnPre',
					id:'preBtn',
				handler:function(){
					me.sliderObj.goToPrevSlide();
						
							// if(me.sliderAction == "pause" && Ext.getCmp('playBtn').ifScroll  === false){
							// 	Ext.defer(function(){
							// 		me.sliderObj.play();
							// 	},window.playBackFrequency)
							// }
						//me.silderAction = "prev";
				}
			}
			],
			layout:{
				pack:'center',
				type:'vbox',
				align:'stretch'
			}
		});
		me.up('panel').add(layer);
		layer.show();
		
	},
	lazyLoad:function(){
		 var me = this;
		 var active = jQuery('#content-slider').find("li.dashboard-wrap"),
						active_index = active.index();
						 if(!Ext.isEmpty(Ext.get('iframe')) || !Ext.isEmpty(Ext.get('mask'))){
							 //$('#iframe').remove();
						  Ext.get('mask').destroy();
								$.when($('#iframe').remove()).then( function(){
									Ext.getCmp('playBtn').ifScroll = false;
								me.intervalTransactionSpeed = null;
								});
						 };
					 active.each(function(i,el){
							var src = $(el).attr('dataURI');
										var timeFrequency = $(el).attr('pagefrq');
							var $iframe = $("<iframe width='100%' height='100%' frameborder='0' id='iframe' src='"+src+"'></iframe");
							if(me.overMask){
								 $iframe = $("<div style='position:absolute;height:100%;width:100%;background-color:rgba(0, 0, 0, 0.0)' id='mask'></div><iframe width='100%' height='100%' frameborder='0' id='iframe' src='"+src+"'></iframe");
							}
							Ext.getCmp('playBtn').ifScroll = true;
												Ext.defer(function(){
													if($(el).hasClass("active") == true){ 
														
														$(el).append($iframe);
														me.getTimeFrequency = timeFrequency;
													}
									},50);
							
						});
									
	},
	loadSlider:function(){
		var me = this;
		me.sliderObj = 	$("#content-slider").lightSlider({
				item:1,
				pause:me.intervalTransactionSpeed,
				speed:me.transactionSpeed,
				auto:me.autoPlay,
				mode:me.mode,
				controls:false,
				gallery:false,
				pager:false,
				loop:true,
				onSliderLoad: function (el) {
					  me.lazyLoad();
				  },
				 onAfterSlide: function (el) {
					  me.lazyLoad();
				 }
			});
			me.sliderControllers();
		
			
			$("#content-slider").height($(window).height() - 10);
			
			
	}

});
	

	   Ext.onReady(function() {
				 Ext.Ajax.request({
						url: url1,
						params: param,
						async: false,
						scope: this,
						success: function (response) {
							var jsonText = response.responseText;
							var jsonData = Ext.decode(jsonText);
							gettingURL=jsonData['AllTvModulecombo'];
							if (Ext.isEmpty(gettingURL)) {
								Ext.create('Ext.window.Window', {
									ui: 'plain',
									id: 'no_widgets',
									header: false,
									border: false,
									html: '<h1 class="tvmode_header" style="text-align: center;"><span style="font-size:20px">No dashboard is configured </span><br><span style="font-size:10px">Press ESC</span></h1>',
									renderTo: Ext.getBody()
								}).show().center();
								//Ext.defer(function(){
								//Ext.getCmp('layer').hide();
								//},1000);
							}
							Ext.create('Ext.container.Viewport', {
													 layout:'fit',
													listeners:{
														resize:function(vp, width, height, oldWidth, oldHeight, eOpts){
															// @ remove and destroy when collapsible mode
															if(!Ext.isEmpty(oldHeight)){
																isTvMode  = false;
																frame = parent.document.getElementById('tvMode');
																frameDoc = frame.contentDocument || frame.contentWindow.document;
																frameDoc.write("<html><head>");
																frameDoc.write("</head><body>");
																frameDoc.write("</body></html>");
																frame.src="about:blank";
																Ext.destroy(Ext.getCmp('carouselAutoScrollTV'));
																
															}
														}
													 },
														items:[
															{
																xtype:'panel',
																 ui: 'eg-panel tvmode',
																flex:1,
																header: false,
																id:'carouselAutoScrollTV',
																layout:{
																	type:'vbox',
																	align:'stretch'
																},
																items:[{
																		xtype:'tvmode',
																		id:'tvmode',
																		store: new Ext.create('Ext.data.Store', {
																				id:'tvmodeStore',
																				model: 'Tvmode',
																				data: gettingURL
																			}),
																		flex:1,
																		//intervalTransactionSpeed:intervalTransactionSpeed1
																	}]
															}
														]
													});
						
						}
					});
   });



