/*
	Worked on 22.08.2017
	Plugin for grid auto resizing based on header and columns.
*/
var lockedColumnsWidth =[];
var extMonitor = '';
var dataGrid = false,isComponentslistpanel=false,isEndUserView =false,isSystemcomponent=false;
Ext.define('Ext.ux.AutoColumnWithLockingPlugin', 
{
    extend: 'Ext.AbstractPlugin',
    alias: 'plugin.autocolumnwithlockingplugin',
	id:'autocolumnwithlockingplugin',
    config: {
        stringWidth: Ext.util.TextMetrics,
        sortCols: function(currentWidth) 
		{
            var longestRow = 0, calculatedLargestRow = [];
            for (var row = 0; row < currentWidth.length; row++)
			{
                if (currentWidth[row].length > longestRow)
                    longestRow = currentWidth[row].length;
            }
            for (var col = 0; col < longestRow; col++)
			{
                var highest = Number.MIN_VALUE;
                for (var row = 0; row < currentWidth.length; row++)
                    if (col < currentWidth[row].length && currentWidth[row][col] > highest)
                        highest = currentWidth[row][col];
						calculatedLargestRow.push(highest);
            }
            // return Array
            return calculatedLargestRow;
        }
    },
    constructor: function(config)
	{
        this.initConfig(this.config);
    },
	
	init: function(grid) 
	{
		var me = this;
		this.grid = grid;

		me.gridView();

		//attached resize event
		Ext.defer(function() {
			if(grid.view != undefined && grid.view != 'undefined')
			{
				grid.mon(grid.view, 'resize', me.gridView, me);
			}
		},2) ;
	},
	gridView:function()
	{
		var me = this;
		var grid = me.grid;

		// In Chrome, the true version is after "Chrome" 
		var nAgt = navigator.userAgent;
		var browserName = '';
		if ((verOffset=nAgt.indexOf("Chrome"))!=-1) 
		{
			browserName = "Chrome";
		}
		// In Firefox, the true version is after "Firefox" 
		else if ((verOffset=nAgt.indexOf("Firefox"))!=-1) 
		{
			browserName = "Firefox";
		}
		// In Microsoft Internet Explorer, the true version is after "Microsoft Internet Explorer" 
		else if ((verOffset=nAgt.indexOf("MSIE"))!=-1) 
		{
			browserName = "Microsoft Internet Explorer";
		}

		if(grid.itemId != 'undefined' && grid.itemId != undefined && grid.itemId != '' )
			extMonitor = grid.itemId;
		try
		{
			var i=0;
			var flag=false;

			while(grid.view.headerCt.items.items[i].locked)
			{
				lockedColumnsWidth.push(grid.view.headerCt.items.items[i].width);
				i++;
				flag=true;
			}
			if(flag)
			{
				return;
			}
		}
		catch (eee)
		{
			return;
		}

		var calculateString = new this.stringWidth,
			currentWidth = [],
			headerTotalWidth =[],
			finalWidth=[],
			showList,
			gridWidth = grid.width ,
			gridStore = grid.store.data.items,
			gridHeaderCt_items = grid.view.headerCt.items.items,
			_arryObject= [],skipColumns=[],gridColumnDataIndex=[],gridPaddingWithoutLockingColumn=55,gridPadding=35,headerPadding=33,lockedColumnsWidthTotal,
			col_string="col",time_string="TIME",progressWidth=[];

		for(var i=0;i<gridHeaderCt_items.length;i++)
		{
			var data_Index = gridHeaderCt_items[i].dataIndex;
			gridColumnDataIndex.push(data_Index);
			if(data_Index == time_string.toLowerCase( )|| data_Index == col_string.toLowerCase( ))
				skipColumns.push(data_Index);
		}
		for (var o = 0; o < gridStore.length; o++)
		{
			if(Ext.typeOf(grid.store.data.items[o].raw) == "object" )
			{
				var sub_arr = [];
				for (var j=0;j<gridColumnDataIndex.length;j++)
				{
					var value=grid.store.data.items[o].raw[gridColumnDataIndex[j]];
					var width=grid.store.data.items[o].raw[gridColumnDataIndex[j]+"Width"];
					var Measureurl=grid.store.data.items[o].raw[gridColumnDataIndex[j]+"Url"];
					var LenWidth=grid.store.data.items[o].raw[gridColumnDataIndex[j]+"LenWidth"];
					var mState=grid.store.data.items[o].raw[gridColumnDataIndex[j]+"State"];
					var progress=grid.store.data.items[o].raw[gridColumnDataIndex[j]+"_progress"];
					
					if(!isNaN(progress))
					{
						progressWidth.push(80);
					}
					else
					{
						progressWidth.push(0);
					}
					if(!isNaN(parseFloat(value)))
					{
						try
						{
							if(value!=null && value.indexOf(".")>-1)
							{
								strDecimal = value.substring(value.indexOf("."));
								str = value.substring(0,value.indexOf("."));
								value='<span class="decimal-align">'+str+'</span><span class="decimal-align2">'+strDecimal+'</span>';
							}
							else
							{
								value='<span class="decimal-align">'+value+'</span>';
							}
						}
						catch(e)
						{
						}
					}
					if(!Ext.isEmpty(width))
					{
						sub_arr.push('<table cellspacing="0" cellpadding="0" border="0" style="table-layout:auto;margin:auto"><col width="80px"><col width="40px">'
						  +'<tr>'
						  +'<td>'
						  +'<table width="80" cellpadding="0" cellspacing="0" border="0"  height="6" class="prog_border">'
								 +'<tr>'
								 +'<td align="left" width="100%" height="6" class="prog_line">'
									+'<a href='+Measureurl+'><table width="'+width+'%" height="6" cellpadding="0" cellspacing="0" border="0">'
									+'<tr>'
									+'<td class ="progress_GOOD" width="100%"></td>'
									+'</tr>'
									+'</table></a>'
								 +'</td>'
								 +'</tr>'
						 +'</table>'
						 +'</td>'
						 +'<td align="right" style="padding-left:5px;"><a href='+Measureurl+'>'+value+'</a></td>'
						 +'</tr>'
						 +'</table>');
					}
					else if(LenWidth!=null&&LenWidth!=undefined && value==0 && mState!=null && mState!=undefined && mState!='null')
					{
						value='<span class="decimal-align" style="width:'+LenWidth+'px">'+value+'</span><span class="decimal-align2" style="width:20px"><img src="/final/images/spacer.gif" style="width: 20px;height:1px;"> </span>';
						sub_arr.push('<table cellspacing="0" cellpadding="0" border="0" style="table-layout:auto;margin:auto;">'
								+'<tr>'
								+'<td align="right" style="padding:5px 0px 2px 0px;text-align:center;"><a href='+Measureurl+' style="font-size: 11px"><div style="margin-top:-4px;float:left;display:table-cell" class="stateTick_'+mState+'"><img  src="/final/images/clear.png" border="0" /></div><div style="padding-top:1px;display:table-cell;float:left;">'+value+'</div></a></td>'			// Prem
								//+'<td align="right" style="padding-left:5px;width:10px"><a href='+Measureurl+'>'+value+'</a></td>'			// Prem
								+'</tr>'
								+'</table>');
						
					}
					else
					{
						if(value==='-')
						{
							value='<span class="decimal-align">'+value+'</span>';
							
								sub_arr.push( '<table cellspacing="0" cellpadding="0" border="0" style="table-layout:auto;"><col width="40px"><col width="20px">'
							+'<tr>'
								+'<td align="right" style="padding-left:5px;>'+value+'</td>'
							+'</tr>'
							+'</table>');
						}
						else
						{
							sub_arr.push(value);			// Prem
						}
					}
				}
				 _arryObject.push(sub_arr);
			}
			else
			{
				showList = gridStore[o].raw.map(function(i, index, arry)
				{
					return calculateString.getSize(i).width;
				});
				 currentWidth.push(showList);
			}
		}

		if(Ext.typeOf(_arryObject) == "array")
		{
			for (var g = 0; g < _arryObject.length;g++) 
			{
				var j=0;
				showList = _arryObject[g].map(function(i, index, arry)
				{
					var progressWidthOrg = 0;
					try
					{
						if(i != null && i != undefined && i != 'null' && i != 'undefined')
						{
							var widthOfValue = calculateString.getSize(i).width;
							if(i.indexOf('http')==0)
								widthOfValue = 200;
							progressWidthOrg = progressWidth[j]+widthOfValue;
						}
						j++;
					}
					catch (e)
					{
						//console.log("e------->>>>",e)
					}
					return progressWidthOrg;
				});
				currentWidth.push(showList);
			}
		}

		var isDDColumn = false;
		var countOfEnumCol = 6;
		var isEnum = false;
		for (var i = 0; i < gridHeaderCt_items.length; i++) 
		{
			if(gridHeaderCt_items[i].text.indexOf("<img")<0 && gridHeaderCt_items[i].text.indexOf("<span class=")<0 && gridHeaderCt_items[i].text.indexOf("iconLineChart")<0)
			{
				headerTotalWidth.push(calculateString.getSize(gridHeaderCt_items[i].text.toUpperCase()).width);
			}
			else if(gridHeaderCt_items[i].text.indexOf("<img")>-1 && gridHeaderCt_items[i].text.indexOf("iconLineChart")>-1)
			{
				//var img_str = gridHeaderCt_items[i].text.substr(0,gridHeaderCt_items[i].text.indexOf("/>"));
				var header_str = gridHeaderCt_items[i].text.substr(gridHeaderCt_items[i].text.indexOf("/>")+2);
				headerTotalWidth.push((calculateString.getSize(header_str.toUpperCase()).width)+30);
			}
			else if(gridHeaderCt_items[i].text.indexOf("<img")>-1 && gridHeaderCt_items[i].text.indexOf("stateSymbol_")>-1)
			{
				//var img_str = gridHeaderCt_items[i].text.substr(0,gridHeaderCt_items[i].text.indexOf("/>"));
				var header_str = gridHeaderCt_items[i].text.substr(gridHeaderCt_items[i].text.indexOf("/>")+2);
				headerTotalWidth.push((calculateString.getSize(header_str.toUpperCase()).width)+30);
			}
			else if(gridHeaderCt_items[i].text.indexOf("<span class=")>-1 && gridHeaderCt_items[i].text.indexOf("iconLineChart")>-1)
			{
				//var img_str = gridHeaderCt_items[i].text.substr(0,gridHeaderCt_items[i].text.indexOf("/>"));
				var header_str = gridHeaderCt_items[i].text.substr(0,gridHeaderCt_items[i].text.indexOf("<span class="));
				headerTotalWidth.push((calculateString.getSize(header_str.toUpperCase()).width)+30);
			}
			else
			{
				var start_index = gridHeaderCt_items[i].text.indexOf("/>");
				var header_str =gridHeaderCt_items[i].text;
				var img_str = gridHeaderCt_items[i].text;
				var isNotHaveHeader = false;
				if(start_index>0)
				{
					
					if(gridHeaderCt_items[i].text.indexOf("<ul") == 0)
					{
						var ar = gridHeaderCt_items[i].text.split("/></li><li>");
						if(ar.length>1)
						{
							var	ar_1 = ar[1].indexOf("</li><li>");
							if(ar_1>0)
							{
								header_str = ar[1].substring(0,ar_1).toUpperCase();
							}
						}
						img_str = ar[0];
					}
					else if(gridHeaderCt_items[i].text.indexOf("<span") == 0)
					{
						var ar = gridHeaderCt_items[i].text.split("/><span>");
						if(ar.length>1)
						{
							var	ar_1 = ar[1].indexOf("</span><span");
							if(ar_1>0)
							{
								header_str = ar[1].substring(0,ar_1).toUpperCase();
							}
						}
						img_str = ar[0];
						if(i==gridHeaderCt_items.length-1 && gridHeaderCt_items[i].text == header_str)
							isDDColumn = true;
					}
					else
					{
						var end_index = gridHeaderCt_items[i].text.length;
						header_str = gridHeaderCt_items[i].text.substring(start_index+2,end_index);
						img_str = gridHeaderCt_items[i].text.substring(0,start_index+2);
						isNotHaveHeader = true;
					}
				}
				if(isNotHaveHeader)
				{
					headerTotalWidth.push(75);
				}
				else
				{
					var imgColWidth = calculateString.getSize(header_str).width;
					if(header_str == 'ENUMERATION AVAILABILITY')
					{
						isEnum = true;
						countOfEnumCol = i;
						var isEnumAva = imgColWidth/2;
						headerTotalWidth.push((isEnumAva+20));
					}
					else
						headerTotalWidth.push((imgColWidth+25));
				}
			}
		}
		var gotHighestCol = new this.sortCols(currentWidth);
			
		for (var k = 0; k < gridHeaderCt_items.length; k++) 
		{
			if(gotHighestCol[k]>headerTotalWidth[k])
			{
				finalWidth.push(gotHighestCol[k]);
			}
			else if(headerTotalWidth[k]>gotHighestCol[k])
			{
				finalWidth.push(headerTotalWidth[k]);
			}
			else if(headerTotalWidth[k]==gotHighestCol[k])
			{
				finalWidth.push(headerTotalWidth[k]);
			}
		}
		var finalTotalWidth=finalWidth.reduce(function(a, b) 
		{
			return a + b;
		});

		if(lockedColumnsWidth.length>0)
		{
			lockedColumnsWidthTotal=lockedColumnsWidth.reduce(function(a, b)
				{
					return a + b;
				});
		}
		if(Ext.isEmpty(gridWidth))
		{
			gridWidth =  Ext.getBody().getViewSize().width;
			var innerPadding = 0;
			try
			{
				innerPadding= Ext.getCmp("endUserView").getWidth();
				if(innerPadding>0)
				{
					isEndUserView = true;
					innerPadding = 5;
					gridWidth = gridWidth-innerPadding;
				}
			}
			catch (e)
			{
				innerPadding= 0;
			}

			var hostPanel= 0;
			try
			{
				hostPanel= Ext.getCmp("hostDetailsId").getWidth();
				if(hostPanel>0)
				{
					gridWidth = gridWidth-hostPanel;
					gridWidth = gridWidth-83;
				}
			}
			catch (e)
			{
				hostPanel= 0;
			}

			
			try
			{
				var componentslistpanel= Ext.getCmp("componentslistpanel").getWidth();
				if(componentslistpanel>0)
					isComponentslistpanel = true;
					
			}
			catch (e)
			{
				isComponentslistpanel = false;
			}
			
			try
			{
				var systemcomponent= Ext.getCmp("systemcomponent").getWidth();
				if(systemcomponent>0)
					isSystemcomponent = true;
					
			}
			catch (e)
			{
				isSystemcomponent = false;
			}

			try
			{
				var dataGridWidth= Ext.getCmp("dataGrid").getWidth();
				if(dataGridWidth>0)
					dataGrid = true;
					
			}
			catch (e)
			{
				dataGrid = false;
			}

			var isLockColumn = false;
			if(lockedColumnsWidthTotal>0)
			{
				gridWidth = gridWidth - lockedColumnsWidthTotal;
				isLockColumn = true;
			}
			
			var isExtMonitor = false;
			if(extMonitor != '' && extMonitor != 'undefined' && extMonitor != undefined && extMonitor == 'ExtTestDashboard')
			{
				isExtMonitor = true;
			}

			if(isExtMonitor && browserName =='Chrome')
			{
				if(isLockColumn)
					gridWidth = gridWidth-gridPadding; //35px of grid
				else
					gridWidth = gridWidth - gridPaddingWithoutLockingColumn;

			}
			else if(isExtMonitor && browserName =='Firefox')
			{
				if(isLockColumn)
					gridWidth = gridWidth-(gridPadding+1); //36px of grid
				else
					gridWidth = gridWidth - gridPaddingWithoutLockingColumn;
			}
			else if(isExtMonitor && browserName =='Microsoft Internet Explorer')
			{
				if(isLockColumn)
					gridWidth = gridWidth-(gridPadding+1); //36px of grid
				else
					gridWidth = gridWidth - gridPaddingWithoutLockingColumn;
			}
			else
			{
				if(isLockColumn)
					gridWidth = gridWidth-headerPadding;//30px of grid
				else
					//gridWidth = gridWidth - gridPaddingWithoutLockingColumn;
					gridWidth = gridWidth - gridPadding;
			}
		}
		//Grid skin padding 
		var space = headerPadding * gridHeaderCt_items.length;
		var gap = gridWidth - finalTotalWidth; 
		var addWidthGrid = finalTotalWidth-gridWidth;
		
		if(finalTotalWidth > gridWidth)
		{
			Ext.suspendLayouts();
			gridWidth = gridWidth + addWidthGrid +space;
			gap = gridWidth - finalTotalWidth; 
			for (var i = 0; i < gridHeaderCt_items.length; i++) 
			{
				gridHeaderCt_items[i].width = "";
				if(!Ext.isEmpty(gotHighestCol[i]))
				{
					if(gap>0)
					{
						if(skipColumns.length>0)
						{
							if(skipColumns.indexOf(gridHeaderCt_items[i].dataIndex)>-1)
								gridHeaderCt_items[i].width = 0;
							else
								gridHeaderCt_items[i].width = finalWidth[i]+Math.round(gap/gridHeaderCt_items.length);
						}
						else if(dashboardNameT != "rumAppFlowComponent" && dashboardNameT != "citrixDashboardForComponent" && (dashboardNameT == "comparisonDashboard" || dashboardNameT.toLowerCase() == "citrixdashboard" || dashboardNameT.toLowerCase() == "rumappflow"))
						{
							if((gridHeaderCt_items.length-1)==i && isDDColumn)
							{
								gridHeaderCt_items[i].maxWidth = 35;
								gridHeaderCt_items[i].minWidth = 35;
								gridHeaderCt_items[i].flex = finalWidth[i]+ Math.round(gap/gridHeaderCt_items.length);
							}
							else if(countOfEnumCol == i && isEnum)
							{
								gridHeaderCt_items[i].maxWidth = 130;
								gridHeaderCt_items[i].flex = finalWidth[i]+ Math.round(gap/gridHeaderCt_items.length);
							}
							else
								gridHeaderCt_items[i].flex = finalWidth[i]+ Math.round(gap/gridHeaderCt_items.length)+.1;
						}
						else
						{
							if(dashboardNameT == "descComparison")
							{
								gridHeaderCt_items[i].minWidth = finalWidth[i]+ Math.round(gap/gridHeaderCt_items.length);
								gridHeaderCt_items[i].flex = finalWidth[i]+ Math.round(gap/gridHeaderCt_items.length);
							}
							else
								gridHeaderCt_items[i].width = finalWidth[i]+Math.round(gap/gridHeaderCt_items.length);				
						}
					}
					else
					{
						if(skipColumns.length>0)
						{
							if(skipColumns.indexOf(gridHeaderCt_items[i].dataIndex)>-1)
								gridHeaderCt_items[i].width = 0;
							else
								gridHeaderCt_items[i].width = finalWidth[i];
						}
						else if(dashboardNameT != "rumAppFlowComponent" && dashboardNameT != "citrixDashboardForComponent" && (dashboardNameT == "comparisonDashboard" || dashboardNameT.toLowerCase() == "citrixdashboard" || dashboardNameT.toLowerCase() == "rumappflow"))
						{
							if((gridHeaderCt_items.length-1)==i && isDDColumn)
							{
								gridHeaderCt_items[i].maxWidth = 35;
								gridHeaderCt_items[i].minWidth = 35;
								gridHeaderCt_items[i].flex = finalWidth[i]+ Math.round(gap/gridHeaderCt_items.length);
							}
							else if(countOfEnumCol == i && isEnum)
							{
								gridHeaderCt_items[i].maxWidth = 130;
								gridHeaderCt_items[i].flex = finalWidth[i]+ Math.round(gap/gridHeaderCt_items.length);
							}
							else
								gridHeaderCt_items[i].flex = finalWidth[i]+ Math.round(gap/gridHeaderCt_items.length)+.1;
						}
						else
							gridHeaderCt_items[i].width = finalWidth[i];
					}
				}
				try
				{
					var tempColumnDataIndex= (Ext.decode(Ext.util.Cookies.get('tempColumnDataIndex')));
					var tempColumnObj= (Ext.decode(Ext.util.Cookies.get('tempColumnObj')));
					if(tempColumnDataIndex != null && tempColumnDataIndex.indexOf(gridHeaderCt_items[i].dataIndex) != -1)
					{
						//var indVal = tempColumnDataIndex.indexOf(gridHeaderCt_items[i].dataIndex);
						var indVal = [];
						for (var c=0; c<tempColumnDataIndex.length; c++) {
							if(tempColumnDataIndex[c] == gridHeaderCt_items[i].dataIndex) 
							{
								indVal.push(c);
							};
						}
						for(var p=0;p<indVal.length;p++)
						{
							if(tempColumnObj[indVal[p]].dashboardName == dashboardNameT && tempColumnObj[indVal[p]].compType == compType)
							{
								if((tempColumnObj[indVal[p]].measureOrgName == gridHeaderCt_items[i].measureOrgName) || Ext.isEmpty(tempColumnObj[indVal[p]].measureOrgName))
								{
									if(tempColumnObj[indVal[p]].dashboardName == "comparisonDashboard" || tempColumnObj[indVal[p]].dashboardName == "descComparison")
										gridHeaderCt_items[i].flex=tempColumnObj[indVal[p]].width;
									else
										gridHeaderCt_items[i].flex=null;
									
									gridHeaderCt_items[i].width=tempColumnObj[indVal[p]].width;
								}
							}
						}
					}
				}
				catch (e4)
				{
				}
			 }
			grid.view.refresh();

			Ext.resumeLayouts(true);
		}
		else
		{
			Ext.suspendLayouts();
			if(gap<space)
			{
				gap=space;
			}
			for (var i = 0; i < gridHeaderCt_items.length; i++)
			{
				//gridHeaderCt_items[i].width = "";
				if(!Ext.isEmpty(gotHighestCol[i]))
				{
					//scroll bar remove in External monitors
					if(isExtMonitor && browserName == 'Chrome' && (gridHeaderCt_items.length-1)==i)
						gridHeaderCt_items[i].width = finalWidth[i]+ (Math.round(gap/gridHeaderCt_items.length)-1);
					//scroll bar remove in comparison dashboard
					else if(dataGrid != '' && dataGrid != 'undefined' && dataGrid != undefined && dataGrid && (gridHeaderCt_items.length-1)==i)
					{
						//gridHeaderCt_items[i].minWidth = finalWidth[i]+ Math.round(gap/(gridHeaderCt_items.length-skipColumns.length));
						gridHeaderCt_items[i].flex=1;
					}
					else if(isComponentslistpanel != '' && isComponentslistpanel != 'undefined' && isComponentslistpanel != undefined && isComponentslistpanel && (gridHeaderCt_items.length-1)==i)
					{
						gridHeaderCt_items[i].minWidth = finalWidth[i]+ Math.round(gap/(gridHeaderCt_items.length-skipColumns.length));
						gridHeaderCt_items[i].flex=1;
					}
					else if(isEndUserView != '' && isEndUserView != 'undefined' && isEndUserView != undefined && isEndUserView && (gridHeaderCt_items.length-1)==i)
					{
						gridHeaderCt_items[i].minWidth = finalWidth[i]+ Math.round(gap/(gridHeaderCt_items.length));
						gridHeaderCt_items[i].flex=1;
					}
					else if(isSystemcomponent != '' && isSystemcomponent != 'undefined' && isSystemcomponent != undefined && isSystemcomponent && (gridHeaderCt_items.length-1)==i)
					{
						gridHeaderCt_items[i].minWidth = finalWidth[i]+ Math.round(gap/(gridHeaderCt_items.length));
						gridHeaderCt_items[i].flex=1;
					}
					else if(skipColumns.length>0)
					{
						
						if(skipColumns.indexOf(gridHeaderCt_items[i].dataIndex)>-1)
						{
							gridHeaderCt_items[i].width = 0;
							if((gridHeaderCt_items.length-1)==i)
							{
								gridHeaderCt_items[i].minWidth = finalWidth[i]+ Math.round(gap/(gridHeaderCt_items.length-skipColumns.length));
								gridHeaderCt_items[i].flex = 1;
							}
						}
						else
						{
							gridHeaderCt_items[i].width = "";
							if((gridHeaderCt_items.length-1)==i)
							{
								gridHeaderCt_items[i].minWidth = finalWidth[i]+ Math.round(gap/(gridHeaderCt_items.length-skipColumns.length));
								gridHeaderCt_items[i].flex = 1;
							}
							else
								gridHeaderCt_items[i].width = finalWidth[i]+ Math.round(gap/(gridHeaderCt_items.length-skipColumns.length));
						}
					}
					else
					{
						try
						{
							if(dashboardNameT == "descComparison")
								gridHeaderCt_items[i].flex = finalWidth[i]+ Math.round(gap/gridHeaderCt_items.length);
							else if(dashboardNameT != "rumAppFlowComponent" && dashboardNameT != "citrixDashboardForComponent" && (dashboardNameT == "comparisonDashboard" || dashboardNameT.toLowerCase() == "citrixdashboard" || dashboardNameT.toLowerCase() == "rumappflow"))
							{
								if((gridHeaderCt_items.length-1)==i && isDDColumn)
								{
									gridHeaderCt_items[i].maxWidth = 35;
									gridHeaderCt_items[i].minWidth = 35;
									gridHeaderCt_items[i].flex = finalWidth[i]+ Math.round(gap/gridHeaderCt_items.length);
								}
								else if(countOfEnumCol == i && isEnum)
								{
									gridHeaderCt_items[i].maxWidth = 130;
									gridHeaderCt_items[i].flex = finalWidth[i]+ Math.round(gap/gridHeaderCt_items.length);
								}
								else
									gridHeaderCt_items[i].flex = finalWidth[i]+ Math.round(gap/gridHeaderCt_items.length)+.1;
							}
							else
							{
								gridHeaderCt_items[i].width = "";
								if((gridHeaderCt_items.length-1)==i)
								{
									gridHeaderCt_items[i].minWidth = finalWidth[i]+  Math.round(gap/gridHeaderCt_items.length);
									gridHeaderCt_items[i].flex = 1;
								}
								else
									gridHeaderCt_items[i].width = finalWidth[i]+  Math.round(gap/gridHeaderCt_items.length);
							}
							//else
							//	gridHeaderCt_items[i].width = finalWidth[i]+ Math.round(gap/gridHeaderCt_items.length);

						}
						catch (er)
						{
							gridHeaderCt_items[i].width = finalWidth[i]+ Math.round(gap/gridHeaderCt_items.length);
						}
					}
				}
				try
				{
					var tempColumnDataIndex= (Ext.decode(Ext.util.Cookies.get('tempColumnDataIndex')));
					var tempColumnObj= (Ext.decode(Ext.util.Cookies.get('tempColumnObj')));
					if(tempColumnDataIndex != null && tempColumnDataIndex.indexOf(gridHeaderCt_items[i].dataIndex) != -1)
					{
						//var indVal = tempColumnDataIndex.indexOf(gridHeaderCt_items[i].dataIndex);
						var indVal = [];
						for (var c=0; c<tempColumnDataIndex.length; c++) 
						{
							if(tempColumnDataIndex[c] == gridHeaderCt_items[i].dataIndex) 
							{
								indVal.push(c);
							}
						}
						for(var p=0;p<indVal.length;p++)
						{
							if(tempColumnObj[indVal[p]].dashboardName == dashboardNameT && tempColumnObj[indVal[p]].compType == compType)
							{
								if((tempColumnObj[indVal[p]].measureOrgName == gridHeaderCt_items[i].measureOrgName) || Ext.isEmpty(tempColumnObj[indVal[p]].measureOrgName))
								{
									if(tempColumnObj[indVal[p]].dashboardName == "comparisonDashboard" || tempColumnObj[indVal[p]].dashboardName == "descComparison")
										gridHeaderCt_items[i].flex=tempColumnObj[indVal[p]].width;
									else
										gridHeaderCt_items[i].flex=null;
									
									gridHeaderCt_items[i].width=tempColumnObj[indVal[p]].width;
								}
							}
						}
					}
				}
				catch (e3)
				{
				}				
			}
			Ext.resumeLayouts(true);
			grid.view.refresh();
		}

		calculateString.destroy();
		lockedColumnsWidth=[];
		delete calculateString ,gotHighestCol,dataGrid,isComponentslistpanel,isEndUserView,isSystemcomponent;

		//this.callParent();
	}, 
    disable: function() 
	{
        this.disabled = true;
    },
    enable: function() 
	{
        this.disabled = false;
    }
});
