/**
 * @class Ext.ux.GMapPanel
 * @extends Ext.Panel
 * @author Shea Frederick
 */
Ext.define('Ext.ux.GMapPanelRv', {
    extend: 'Ext.panel.Panel',
    
    alias: 'widget.gmappanel',
    
    requires: ['Ext.window.MessageBox'],
    
    initComponent : function(){
        Ext.applyIf(this,{
            plain: true,
            gmapType: 'map',
            border: false,
			 cache: {
				marker: [],
				polyline: [],
				infowindow: []
			}
        });
        
        this.callParent();    
		//google.maps.event.addDomListener(window, 'load', this.createMap);
    },
    
    afterFirstLayout : function(){
        var center = this.center;
        this.callParent();       
        
        if (center) {
            if (center.geoCodeAddr) {
                this.lookupCode(center.geoCodeAddr, center.marker);
            } else {
                this.createMap(center);
            }
        } else {
            Ext.Error.raise('center is required');
        }
              
    },
    
    createMap: function(center, marker) {
		
        options = Ext.apply({}, this.mapOptions);
        options = Ext.applyIf(options, {
            zoom: Ext.getCmp('mygooglemap').zoom,
            center: center,
			panControl: true,
            mapTypeId: google.maps.MapTypeId.ROADMAP,
			zoomControl: true,
			zoomControlOptions: {
				style: google.maps.ZoomControlStyle.LARGE
				//position: google.maps.ControlPosition.LEFT_CENTER
			}
        });
        this.gmap = new google.maps.Map(this.body.dom, options);
		
		var latitude = publicJSON['latitude'];
		var longitude = publicJSON['longitude'];
		
		if((latitude!=null && latitude!='null' && latitude!='') && (longitude!=null && longitude!='null' && longitude!=''))
		{
			if (marker) {
				this.addMarker(Ext.applyIf(marker, {
					position: center
				}));
			}
			Ext.each(this.markers, this.addMarker, this);
		}

		google.maps.event.addListener(this.gmap, 'click', function(event) {
			
			forAddingMarker(event.latLng);
			//this.placeMarker(event.latLng);
			/*marker = new google.maps.Marker({
				position: event.latLng,
				map: this.gmap
			});
			alert("listener "+marker+"  "+event.latLng.lat());
			if (marker) {
				 this.addMarker(Ext.applyIf(marker, {
					position: event.latLng
				}));
			}*/
			// Ext.each(this.markers, this.addMarker, this);
			/* var infowindow = new google.maps.InfoWindow({
				content: 'Latitude: ' + event.latLng.lat() + '<br>Longitude: ' + event.latLng.lng()
			  });
			  infowindow.open(this.gmap,marker);*/
		});
		
    },
  
    addMarker: function(marker) {
		
        marker = Ext.apply({
            map: this.gmap
        }, marker);
        
        if (!marker.position) {
            marker.position = new google.maps.LatLng(marker.lat, marker.lng);
        }
        var o =  new google.maps.Marker(marker);
        Ext.Object.each(marker.listeners, function(name, fn){
            google.maps.event.addListener(o, name, fn);    
        });
		this.cache.marker.push(o);
        return o;
    },
    
	 // private
	hideMarkers : function(){
		Ext.each(this.cache.marker, function(mrk){
			mrk.setMap(null);
		});
	},

    lookupCode : function(addr, marker) {
        this.geocoder = new google.maps.Geocoder();
        this.geocoder.geocode({
            address: addr
        }, Ext.Function.bind(this.onLookupComplete, this, [marker], true));
    },
    
    onLookupComplete: function(data, response, marker){
        if (response != 'OK') {
            Ext.MessageBox.alert('Error', 'An error occured: "' + response + '"');
            return;
        }
        this.createMap(data[0].geometry.location, marker);
    },
    
    afterComponentLayout : function(w, h){
        this.callParent(arguments);
        this.redraw();
    },
    
    redraw: function(){
        var map = this.gmap;
        if (map) {
            google.maps.event.trigger(map, 'resize');
        }
    },

	getMap : function(){
		return this.gmap;
	},
	getCenter : function(){
		return this.getMap().getCenter();
	},
	getMarkers : function(){
		return this.markers;
	},
	getDomObject: function(){
		return this.body.dom;
	},
	getMapOptions : function(){
		return this.mapOptions;
	},
	getThisObject : function(){
		return this;
	},
	getZoomLevel : function(marker){
		return this.gmap.getZoom();
	},
	setMapType : function(type){
		if (type == 'hybrid')
			this.gmap.setMapTypeId(google.maps.MapTypeId.HYBRID);
		else if(type == 'terrain')
			this.gmap.setMapTypeId(google.maps.MapTypeId.TERRAIN);
		else if(type == 'satellite')
			this.gmap.setMapTypeId(google.maps.MapTypeId.SATELLITE);
		else
			this.gmap.setMapTypeId(google.maps.MapTypeId.ROADMAP);
	}

 
});