/*
 * Note that this control will most likely remain as an example, and not as a core Ext form
 * control.  However, the API will be changing in a future release and so should not yet be
 * treated as a final, stable API at this time.
 */

/**
 * A control that allows selection of between two Ext.ux.form.MultiSelect controls.
 */
Ext.define('Ext.ux.ItemSelectorRv', {
	extend: 'Ext.ux.form.ItemSelector',
	alias: ['widget.itemselectorrvfield', 'widget.itemselectorrv'],
	alternateClassName: ['Ext.ux.ItemSelectorRv'],
	gap:22,
	createList: function(title){
		var me = this;
		
		var widthOfTrigger = (me.width/2) - me.gap;
		return Ext.create('Ext.ux.form.MultiSelectSI', {
			submitValue: false,
			flex: 1,
			//dragGroup: me.ddGroup,
			//dropGroup: me.ddGroup,
			title: title,
			tbar:[{
					xtype: 'trigger',
					cls:'whitedropdown_search',
					trigger1Cls: 'x-form-clear-trigger',
					trigger2Cls: 'x-form-search-trigger',
					emptyText: 'Search',
					padding:3,
					//flex:1,
					width: widthOfTrigger-6,
					getTriggerMarkup: function() 
					{
						var me = this,
						i = 0,
						hideTrigger = (me.readOnly || me.hideTrigger),
						triggerCls,
						triggerBaseCls = me.triggerBaseCls,
						triggerConfigs = [],
						unselectableCls = Ext.dom.Element.unselectableCls,
						style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
						//style = (hideTrigger ? 'display:none;' : ''),
						cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
						// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
						// single triggerCls config. Should rethink this, perhaps something more structured like a list of
						// trigger config objects that hold cls, handler, etc.
						// triggerCls is a synonym for trigger1Cls, so copy it.

						if (!me.trigger1Cls) {
							me.trigger1Cls = me.triggerCls;
						}
						// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : this.id+'_MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : this.id+'_MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								 });
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					},
					onTrigger1Click : function() 
					{
						this.reset();
					},
					onTrigger2Click : function() 
					{
						var value = this.getValue();
						if (value == "" || value.length == 0)
						{
							Ext.get(this.id+'_MyTrigger_0').setStyle('display','none');
							Ext.get(this.id+'_MyTrigger_1').setStyle('display','block');
						}
						else
						{
							Ext.get(this.id+'_MyTrigger_1').setStyle('display','none');
							Ext.get(this.id+'_MyTrigger_0').setStyle('display','block');
						}

						Ext.get(this.id).setWidth((widthOfTrigger - me.gap)-6);

						if (value == "" || value.length == 0)
						{
							this.up('multiselect').store.clearFilter();
						}
						else
						{
							this.up('multiselect').store.clearFilter();
							var filterLogic = new Ext.util.Filter({
								filterFn: function(item) {
									var testName = item.get('displayField');
									var dispName = testName; //publicJson.displayTestJsonObj[testName];
									if (dispName.toLowerCase().indexOf(value.toLowerCase()) != -1)
									{
										return true
									}
								}
							});
							this.up('multiselect').store.filter(filterLogic);
						}
						this.up('multiselect').doLayout();
					},
					listeners: {
						change : function() 
						{
							var value = this.getValue();
							if (value == "" || value.length == 0)
							{
								Ext.get(this.id+'_MyTrigger_0').setStyle('display','none');
								Ext.get(this.id+'_MyTrigger_1').setStyle('display','block');
							}
							else
							{
								Ext.get(this.id+'_MyTrigger_1').setStyle('display','none');
								Ext.get(this.id+'_MyTrigger_0').setStyle('display','block');
							}

							Ext.get(this.id).setWidth((widthOfTrigger - me.gap)-6);

							if (value == "" || value.length == 0)
							{
								this.up('multiselect').store.clearFilter();
							}
							else
							{
								this.up('multiselect').store.clearFilter();
								var filterLogic = new Ext.util.Filter({
									filterFn: function(item) {
										var testName = item.get('displayField');
										var dispName = testName; //publicJson.displayTestJsonObj[testName];
										if (dispName.toLowerCase().indexOf(value.toLowerCase()) != -1)
										{
											return true
										}
									}
								});
								this.up('multiselect').store.filter(filterLogic);
							}

							this.up('multiselect').doLayout();
						}
						
					}
				}],
			store: {
				model: me.store.model,
				data: []
			},
			displayField: me.displayField,
			listConfig: me.listConfig,
			disabled: me.disabled,
			listeners: {
				boundList: {
					scope: me,
					itemdblclick: me.onItemDblClick,
					drop: me.syncValue
				}
			}
		});
	},

	onTopBtnClick : function() {
		var list = this.toField.boundList,
			store = list.getStore(),
			selected = this.getSelections(list);

		store.suspendEvents();
		store.remove(selected, true);
		store.insert(0, selected);
		store.resumeEvents();
		list.refresh();
		this.syncValue(); 
		list.getSelectionModel().select(selected);
	},

	onBottomBtnClick : function() {
		var list = this.toField.boundList,
			store = list.getStore(),
			selected = this.getSelections(list);

		store.suspendEvents();
		store.remove(selected, true);
		store.add(selected);
		store.resumeEvents();
		list.refresh();
		this.syncValue();
		list.getSelectionModel().select(selected);
	},

	onUpBtnClick : function() {
		var list = this.toField.boundList,
			store = list.getStore(),
			selected = this.getSelections(list),
			rec,
			i = 0,
			len = selected.length,
			index = 0;

		// Move each selection up by one place if possible
		store.suspendEvents();
		for (; i < len; ++i, index++) {
			rec = selected[i];
			index = Math.max(index, store.indexOf(rec) - 1);
			store.remove(rec, true);
			store.insert(index, rec);
		}
		store.resumeEvents();
		list.refresh();
		this.syncValue();
		list.getSelectionModel().select(selected);
	},

	onDownBtnClick : function() {
		var list = this.toField.boundList,
			store = list.getStore(),
			selected = this.getSelections(list),
			rec,
			i = selected.length - 1,
			index = store.getCount() - 1;

		// Move each selection down by one place if possible
		store.suspendEvents();
		for (; i > -1; --i, index--) {
			rec = selected[i];
			index = Math.min(index, store.indexOf(rec) + 1);
			store.remove(rec, true);
			store.insert(index, rec);
		}
		store.resumeEvents();
		list.refresh();
		this.syncValue();
		list.getSelectionModel().select(selected);
	},

	onAddBtnClick : function() {
		var me = this,
			selected = me.getSelections(me.fromField.boundList);

		me.moveRec(true, selected);
		me.toField.boundList.getSelectionModel().select(selected);

		// Service Page
		var serviceSelector = Ext.getCmp('itemselectHostsForService');
		if (serviceSelector != null && serviceSelector != "undefined")
		{
			var isDiplayCheckBox ='';
			var aggValue ='';
			var modifyMode = publicJSON['modify'];
			if(modifyMode=='false')
			{
				isDiplayCheckBox = Ext.getCmp('aggcombo').isVisible();
				aggValue = Ext.getCmp('aggcombo').getValue();
			}
			else if(modifyMode=='true')
			{
				isDiplayCheckBox = publicJSON['displayCheckBox'];
				var isaggSite = publicJSON['isAggregateSite'];
				if(isaggSite=='true')
					aggValue='Yes';
				else
					aggValue='no';
			}
			if(isDiplayCheckBox)
			{
				if(aggValue=='Yes')
				{
					servicePage('hide');
				}
			}
		}
	},
	
	onRemoveBtnClick : function() {
		
		var me = this,
			 selected = me.getSelections(me.toField.boundList);

		 me.moveRec(false, selected);
		 me.fromField.boundList.getSelectionModel().select(selected);
		
		// Service Page
		var serviceSelector = Ext.getCmp('itemselectHostsForService');
		if (serviceSelector != null && serviceSelector != "undefined")
		{
			var isDiplayCheckBox ='';
			var aggValue ='';
			var modifyMode = publicJSON['modify'];
			if(modifyMode=='false')
			{
				isDiplayCheckBox = Ext.getCmp('aggcombo').isVisible();
				aggValue = Ext.getCmp('aggcombo').getValue();
			}
			else if(modifyMode=='true')
			{
				isDiplayCheckBox = publicJSON['displayCheckBox'];
				var isaggSite = publicJSON['isAggregateSite'];
				if(isaggSite=='true')
					aggValue='Yes';
				else
					aggValue='no';
			}
			if(isDiplayCheckBox)
			{
				if(aggValue=='Yes')
				{
					servicePage('show');
				}
			}
		}
	},

	moveRec: function(add, recs) {
		var me = this,
			fromField = me.fromField,
			toField   = me.toField,
			fromStore = add ? fromField.store : toField.store,
			toStore   = add ? toField.store   : fromField.store;

		fromStore.suspendEvents();
		toStore.suspendEvents();
		fromStore.remove(recs);
		toStore.add(recs);
		fromStore.resumeEvents();
		toStore.resumeEvents();

		fromField.boundList.refresh();
		toField.boundList.refresh();
    
		// search box reset code - starts
		if (fromField.boundList.getStore().isFiltered())
		{
			var fromFieldTrigger = this.fromField.down('triggerfield').getValue() ;
			if (!Ext.isEmpty(fromFieldTrigger))
			{
				this.fromField.down('triggerfield').setValue('');
			}
		}

		if (toField.boundList.getStore().isFiltered())
		{
			var toFieldTrigger = this.toField.down('triggerfield').getValue() ;
			if (!Ext.isEmpty(toFieldTrigger))
			{
				this.toField.down('triggerfield').setValue('');
			}
		}
		// search box reset code - ends
		me.syncValue();
	},

	// Synchronizes the submit value with the current state of the toStore
	syncValue: function() {
		var me = this; 
		me.mixins.field.setValue.call(me, me.setupValue(me.toField.store.getRange()));
	},

	onItemDblClick: function(view, rec) {
		var me = this;
		if (view == me.toField.boundList){
			me.onRemoveBtnClick();
		}
		else if (view == me.fromField.boundList) {
			var segmentSelector = Ext.getCmp('itemselectHostsForSegment');
			if (segmentSelector == null || segmentSelector == "undefined")
			{
				me.onAddBtnClick();
			}
		}
		/*var segmentSelector = Ext.getCmp('itemselectHostsForSegment');
		if (segmentSelector == null && segmentSelector == "undefined")
		{
			this.moveRec(view === this.fromField.boundList, rec);
		}*/
	},

	setValue: function(value) {
		var me = this,
			fromField = me.fromField,
			toField = me.toField,
			fromStore = fromField.store,
			toStore = toField.store,
			selected;

		// Wait for from store to be loaded
		if (!me.fromStorePopulated) {
			me.fromField.store.on({
				load: Ext.Function.bind(me.setValue, me, [value]),
				single: true
			});
			return;
		}
		
		value = me.setupValue(value);
		me.mixins.field.setValue.call(me, value);

		selected = me.getRecordsForValue(value);


		// Clear both left and right Stores.
		// Both stores must not fire events during this process.
		fromStore.suspendEvents();
		toStore.suspendEvents();
		fromStore.removeAll();
		toStore.removeAll();

		// Reset fromStore
		me.populateFromStore(me.store);

		// Copy selection across to toStore
		Ext.Array.forEach(selected, function(rec){
			// In the from store, move it over
			if (fromStore.indexOf(rec) > -1) {
				fromStore.remove(rec);
			}
			toStore.add(rec);
		});

		// Stores may now fire events
		fromStore.resumeEvents();
		toStore.resumeEvents();

		// Refresh both sides and then update the app layout
		Ext.suspendLayouts();
		fromField.boundList.refresh();
		toField.boundList.refresh();
		Ext.resumeLayouts(true);        
	}
});

//Service page
function servicePage(value)
{
	var modifyMode = publicJSON['modify'];
	Ext.getCmp('mappingcombo').show(true);
	Ext.getCmp('UpdateBTN').getEl().setStyle({margin:'25px 0px 10px 0px'});
	var s_site="";
	var s_service="";
	if(modifyMode=='true')
		s_site = Ext.getCmp('servicecombo').getValue();
	else if(modifyMode=="false")
		s_site = Ext.getCmp('servicename').getValue();

	var siteValue = Ext.getCmp('sitecombo').getValue();
	if(siteValue=="Yes")
		s_service="false";
	else if(siteValue=="No")
		s_service="true";

	var s_zone = Ext.getCmp('zonecombo').getValue();
	if(s_zone==null || s_zone=='null')
		s_zone='-1';

	var isAggregateSite='false';
	var aggValue = Ext.getCmp('aggcombo').getValue();
	var isDiplayCheckBox = Ext.getCmp('aggcombo').isVisible();
	if(aggValue!=null && isDiplayCheckBox)
	{
		if(aggValue=='Yes')
			isAggregateSite='true';
		else if(aggValue=='No')
			isAggregateSite='false';
	}
	var s_segment = Ext.getCmp('segmentcombo').getValue();

	var unmanagedHostList = Ext.getCmp('itemselectHostsForService').getValue();
	var Arr = new Array();
	for (var i=0;i<Ext.getCmp('itemselectHostsForService').getStore().getCount();i++)
	{
		var allValue = Ext.getCmp('itemselectHostsForService').getStore().getAt(i).get('valueField');
		var isData = false;
		for (var j=0;j<unmanagedHostList.length ;j++ )
		{
			if (allValue == unmanagedHostList[j])
			{
				isData = true;
				break;
			}
		}
		if (!isData)
		{
			Arr[Arr.length]=allValue;
		}
	}
	var tempmanagedHostList = Arr;
	var associatesNew = tempmanagedHostList.toString();

	var hiddenObj = Ext.getCmp('hiddencontainer');
	var temp = {
		xtype: 'hiddenfield',
		name: 'currentRemovedElements',
		value: unmanagedHostList
	};
	hiddenObj.add(temp);

	temp = {
		xtype: 'hiddenfield',
		name: 'service',
		value: s_service
	};
	hiddenObj.add(temp);

	temp = {
		xtype: 'hiddenfield',
		name: 'site',
		value: s_site
	};
	hiddenObj.add(temp);

	temp = {
		xtype: 'hiddenfield',
		name: 'zone',
		value: s_zone
	};
	hiddenObj.add(temp);

	temp = {
		xtype: 'hiddenfield',
		name: 'segment',
		value: s_segment
	};
	hiddenObj.add(temp);

	temp = {
		xtype: 'hiddenfield',
		name: 'aggsiteassHosts',
		value: associatesNew
	};
	hiddenObj.add(temp);

	var hiddenserviceObj = Ext.getCmp('componentservice').getForm();

	hiddenserviceObj.submit({
		url: 'Services/data/EgConfigSitesJson.jsp?modify='+modifyMode+'&isAggregateSite='+isAggregateSite+"&displaySiteMap=true",
		method: 'POST',
		standardSubmit: false,
		success: function( form,action )
		{
			var jsonText = action.response.responseText;
			publicJSON = Ext.decode(jsonText);
			if ( !Ext.isEmpty( jsonText ) && action.response.status == 200 )
			{
				var displaySiteMap = publicJSON['displaySiteMap'];
				if(displaySiteMap=='true')
				{
					Ext.getCmp('mappingcombo').getStore().loadRawData(publicJSON['aggregateSite']);
						Ext.getCmp('mappingcombo').setValue(publicJSON['mappingSiteName']);
						Ext.getCmp('UpdateBTN').getEl().setStyle({margin:'25px 0px 10px 0px'});
				}
				else
				{
					Ext.getCmp('mappingcombo').hide();
					Ext.getCmp('UpdateBTN').getEl().setStyle({margin:'0px 0px 10px 0px'});
				}
			}
			hiddenObj.removeAll();
		},
		failure: function()
		{
			hiddenObj.removeAll();
		}
	});
}



