/*
 * Note that this control will most likely remain as an example, and not as a core Ext form
 * control.  However, the API will be changing in a future release and so should not yet be
 * treated as a final, stable API at this time.
 */

/**
 * A control that allows selection of between two Ext.ux.form.MultiSelect controls.
 */
Ext.define('Ext.ux.ItemSelectorSm', {
	extend: 'Ext.ux.form.ItemSelector',
	alias: ['widget.itemselectorsmfield', 'widget.itemselectorsm'],
	alternateClassName: ['Ext.ux.ItemSelectorSm'],
	gap:22,
	createList: function(title){
		var me = this;
		
		var widthOfTrigger = (me.width/2) - me.gap;
		return Ext.create('Ext.ux.form.MultiSelectSI', {
			submitValue: false,
			flex: 1,
			//dragGroup: me.ddGroup,
			//dropGroup: me.ddGroup,
			title: title,
			tbar:[{
					xtype: 'trigger',
					cls:'whitedropdown_search',
					trigger1Cls: 'x-form-clear-trigger',
					trigger2Cls: 'x-form-search-trigger',
					emptyText: 'Search',
					padding:3,
					//flex:1,
					width: widthOfTrigger-6,
					getTriggerMarkup: function() 
					{
						var me = this,
						i = 0,
						hideTrigger = (me.readOnly || me.hideTrigger),
						triggerCls,
						triggerBaseCls = me.triggerBaseCls,
						triggerConfigs = [],
						unselectableCls = Ext.dom.Element.unselectableCls,
						style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
						//style = (hideTrigger ? 'display:none;' : ''),
						cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
						// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
						// single triggerCls config. Should rethink this, perhaps something more structured like a list of
						// trigger config objects that hold cls, handler, etc.
						// triggerCls is a synonym for trigger1Cls, so copy it.

						if (!me.trigger1Cls) {
							me.trigger1Cls = me.triggerCls;
						}
						// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : this.id+'_MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : this.id+'_MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								 });
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					},
					onTrigger1Click : function() 
					{
						this.reset();
					},
					onTrigger2Click : function() 
					{
						var value = this.getValue();
						if (value == "" || value.length == 0)
						{
							Ext.get(this.id+'_MyTrigger_0').setStyle('display','none');
							Ext.get(this.id+'_MyTrigger_1').setStyle('display','block');
						}
						else
						{
							Ext.get(this.id+'_MyTrigger_1').setStyle('display','none');
							Ext.get(this.id+'_MyTrigger_0').setStyle('display','block');
						}

						Ext.get(this.id).setWidth((widthOfTrigger - me.gap)-6);

						if (value == "" || value.length == 0)
						{
							this.up('multiselect').store.clearFilter();
						}
						else
						{
							this.up('multiselect').store.clearFilter();
							var filterLogic = new Ext.util.Filter({
								filterFn: function(item) {
									var testName = item.get('displayField');
									var dispName = testName; //publicJson.displayTestJsonObj[testName];
									if (dispName.toLowerCase().indexOf(value.toLowerCase()) != -1)
									{
										return true
									}
								}
							});
							this.up('multiselect').store.filter(filterLogic);
						}
						this.up('multiselect').doLayout();
					},
					listeners: {
						change : function() 
						{
							var value = this.getValue();
							if (value == "" || value.length == 0)
							{
								Ext.get(this.id+'_MyTrigger_0').setStyle('display','none');
								Ext.get(this.id+'_MyTrigger_1').setStyle('display','block');
							}
							else
							{
								Ext.get(this.id+'_MyTrigger_1').setStyle('display','none');
								Ext.get(this.id+'_MyTrigger_0').setStyle('display','block');
							}

							Ext.get(this.id).setWidth((widthOfTrigger - me.gap)-6);

							if (value == "" || value.length == 0)
							{
								this.up('multiselect').store.clearFilter();
							}
							else
							{
								this.up('multiselect').store.clearFilter();
								var filterLogic = new Ext.util.Filter({
									filterFn: function(item) {
										var testName = item.get('displayField');
										var dispName = testName; //publicJson.displayTestJsonObj[testName];
										if (dispName.toLowerCase().indexOf(value.toLowerCase()) != -1)
										{
											return true
										}
									}
								});
								this.up('multiselect').store.filter(filterLogic);
							}
							this.up('multiselect').doLayout();
						}
					}
				}],
			store: {
				model: me.store.model,
				data: []
			},
			displayField: me.displayField,
			disabled: me.disabled,
			listeners: {
				boundList: {
					scope: me,
					itemdblclick: me.onItemDblClick,
					drop: me.syncValue
				}
			}
		});
	},

	onTopBtnClick : function() {
		var list = this.toField.boundList,
			store = list.getStore(),
			selected = this.getSelections(list);

		store.suspendEvents();
		store.remove(selected, true);
		store.insert(0, selected);
		store.resumeEvents();
		list.refresh();
		this.syncValue(); 
		list.getSelectionModel().select(selected);
	},

	onBottomBtnClick : function() {
		var list = this.toField.boundList,
			store = list.getStore(),
			selected = this.getSelections(list);

		store.suspendEvents();
		store.remove(selected, true);
		store.add(selected);
		store.resumeEvents();
		list.refresh();
		this.syncValue();
		list.getSelectionModel().select(selected);
	},

	onUpBtnClick : function() {
		var list = this.toField.boundList,
			store = list.getStore(),
			selected = this.getSelections(list),
			rec,
			i = 0,
			len = selected.length,
			index = 0;

		// Move each selection up by one place if possible
		store.suspendEvents();
		for (; i < len; ++i, index++) {
			rec = selected[i];
			index = Math.max(index, store.indexOf(rec) - 1);
			store.remove(rec, true);
			store.insert(index, rec);
		}
		store.resumeEvents();
		list.refresh();
		this.syncValue();
		list.getSelectionModel().select(selected);
	},

	onDownBtnClick : function() {
		var list = this.toField.boundList,
			store = list.getStore(),
			selected = this.getSelections(list),
			rec,
			i = selected.length - 1,
			index = store.getCount() - 1;

		// Move each selection down by one place if possible
		store.suspendEvents();
		for (; i > -1; --i, index--) {
			rec = selected[i];
			index = Math.min(index, store.indexOf(rec) + 1);
			store.remove(rec, true);
			store.insert(index, rec);
		}
		store.resumeEvents();
		list.refresh();
		this.syncValue();
		list.getSelectionModel().select(selected);
	},

	onAddBtnClick : function() {
		var enableDisableTests = Ext.getCmp('itemselectTests');
		var ExternalAgent = Ext.getCmp('itemselectextagent');
		if (enableDisableTests != null && enableDisableTests != "undefined")
		{
			var userTest = publicJSON['usrBasedTests'];
			var userTestStr = userTest.toString();
			var userTestToken = userTestStr.split(",");
			var me = this,
				selected = me.getSelections(me.fromField.boundList);

			var Arr = new Array();

			for (var i=0;i<selected.length;i++ )
			{
				var selectedTestObj = selected[i];
				var selectedTest = selected[i].get('valueField');
				var selectedDisplayTest = selected[i].get('displayField');
				var userNamedTest = '';
				for (var j=0;j<userTestToken.length ;j++)
				{
					if (userTestToken[j] == selectedTest)
					{
						userNamedTest = selectedTest;
						Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['NamedUserAlert']+publicJSON['screenLabels']['NamedUserAlertName']+" "+selectedDisplayTest);
					}
					else
					{
						Arr[Arr.length]=selectedTestObj;
					}
				}
			}
			if (Arr != null && Arr.length >0)
			{
				var selectedTestObjVal = Arr;
				me.moveRec(true,selectedTestObjVal);
				me.toField.boundList.getSelectionModel().select(selectedTestObjVal);
			}
		}
		else if (ExternalAgent != null && ExternalAgent != "undefined")
		{
			var me =this,
				selected = me.getSelections(me.fromField.boundList);
			if (selected.length == 0)
			{
				Ext.Msg.alert(assignExtPageTitle,publicJSON['screenLabels']['admin.external.No external agent hosts selected']);
			}
			else
			{
				var me = this,
					selected = me.getSelections(me.fromField.boundList);
				me.moveRec(true, selected);
				me.toField.boundList.getSelectionModel().select(selected);
			}
		}
		else
		{
			var me = this,
				selected = me.getSelections(me.fromField.boundList);
			me.moveRec(true, selected);
			me.toField.boundList.getSelectionModel().select(selected);
		}
	},
	callMethod: function()
	{
	},
	onRemoveBtnClick : function() {
		var ExternalAgent = Ext.getCmp('itemselectextagent');
		var RemoteAgent = Ext.getCmp('itemselectremoteagent');
		if ((ExternalAgent != null && ExternalAgent != "undefined") || (RemoteAgent != null && RemoteAgent != "undefined"))
		{
			var me =this,
				selected = me.getSelections(me.toField.boundList);
			if (selected.length == 0)
			{
				if (ExternalAgent != null && ExternalAgent != "undefined")
				{
					Ext.Msg.alert(assignExtPageTitle,publicJSON['screenLabels']['admin.external.No managed hosts selected']);
				}
				else
				{
					Ext.Msg.alert(assignRmtPageTitle,publicJSON['screenLabels']['admin.remote.No managed hosts selected']);
				}
			}
			else
			{
				if (RemoteAgent != null && RemoteAgent != "undefined")
				{
					Ext.getCmp('UpdateBTN').enable();
				}
				var me = this,
					selected = me.getSelections(me.toField.boundList);
				me.moveRec(false, selected);
				me.fromField.boundList.getSelectionModel().select(selected);
			}
		}
		else
		{
			var me = this,
				selected = me.getSelections(me.toField.boundList);

			me.moveRec(false, selected);
			me.fromField.boundList.getSelectionModel().select(selected);
		}
	},

	moveRec: function(add, recs, isAllowed) {
		if (isAllowed != null && isAllowed != "undefined")
		{
			if (add && !isAllowed)
			{
				return;
			}
		}
		var me = this,
			fromField = me.fromField,
			toField   = me.toField,
			fromStore = add ? fromField.store : toField.store,
			toStore   = add ? toField.store   : fromField.store;

		fromStore.suspendEvents();
		toStore.suspendEvents();
		fromStore.remove(recs);
		toStore.add(recs);
		fromStore.resumeEvents();
		toStore.resumeEvents();

		fromField.boundList.refresh();
		toField.boundList.refresh();

		// search box reset code - starts
		if (fromField.boundList.getStore().isFiltered())
		{
			var fromFieldTrigger = this.fromField.down('triggerfield').getValue() ;
			if (!Ext.isEmpty(fromFieldTrigger))
			{
				this.fromField.down('triggerfield').setValue('');
			}
		}

		if (toField.boundList.getStore().isFiltered())
		{
			var toFieldTrigger = this.toField.down('triggerfield').getValue() ;
			if (!Ext.isEmpty(toFieldTrigger))
			{
				this.toField.down('triggerfield').setValue('');
			}
		}
		// search box reset code - ends
		me.syncValue();
	},

	onItemDblClick: function(view, rec) {
		var enableDisableTests = Ext.getCmp('itemselectTests');
		var RemoteAgent = Ext.getCmp('itemselectremoteagent');
		if (RemoteAgent != null && RemoteAgent != "undefined")
		{
			var me = this,
				selected = me.getSelections(me.toField.boundList);
			if (selected.length > 0)
			{
				Ext.getCmp('UpdateBTN').enable();
			}
		}
		if (enableDisableTests != null && enableDisableTests != "undefined")
		{
			var userTest = publicJSON['usrBasedTests'];
			var me = this,
				selected = me.getSelections(me.fromField.boundList);
			if (selected.length > 0)
			{
				for (var i=0;i<selected.length;i++ )
				{
					var selectedTest = selected[i].get('valueField');
					var selectedDisplayTest = selected[i].get('displayField');
					if (userTest == selectedTest)
					{
						Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['NamedUserAlert']+publicJSON['screenLabels']['NamedUserAlertName']+" "+selectedDisplayTest);
						return;
					}
					else
					{
						this.moveRec(view === this.fromField.boundList, rec);
					}
				}
			}
			else
			{
				this.moveRec(view === this.fromField.boundList, rec);
			}
		}
		else
		{
			this.moveRec(view === this.fromField.boundList, rec,false);
		}
	},

	setValue: function(value) {
		var me = this,
			fromField = me.fromField,
			toField = me.toField,
			fromStore = fromField.store,
			toStore = toField.store,
			selected;

		// Wait for from store to be loaded
		if (!me.fromStorePopulated) {
			me.fromField.store.on({
				load: Ext.Function.bind(me.setValue, me, [value]),
				single: true
			});
			return;
		}

		value = me.setupValue(value);
		me.mixins.field.setValue.call(me, value);

		selected = me.getRecordsForValue(value);

		// Clear both left and right Stores.
		// Both stores must not fire events during this process.
		fromStore.suspendEvents();
		toStore.suspendEvents();
		fromStore.removeAll();
		toStore.removeAll();

		// Reset fromStore
		me.populateFromStore(me.store);

		// Copy selection across to toStore
		Ext.Array.forEach(selected, function(rec){
			// In the from store, move it over
			if (fromStore.indexOf(rec) > -1) {
				fromStore.remove(rec);
			}
			toStore.add(rec);
		});

		// Stores may now fire events
		fromStore.resumeEvents();
		toStore.resumeEvents();

		// Refresh both sides and then update the app layout
		Ext.suspendLayouts();
		fromField.boundList.refresh();
		toField.boundList.refresh();
		Ext.resumeLayouts(true);        
	}
});



