
/*
 * Note that this control will most likely remain as an example, and not as a core Ext form
 * control.  However, the API will be changing in a future release and so should not yet be
 * treated as a final, stable API at this time.
 */

/**
 * A control that allows selection of between two Ext.ux.form.MultiSelect controls.
 */
Ext.define('Ext.ux.OptGroup.OptGroupItemSelectorSs', {
    extend: 'Ext.ux.OptGroup.OptGroupMultiSelectSs',
    alias: ['widget.optgroupitemselectorfieldSs','widget.optgroupitemselectorSs'],
    alternateClassName: ['Ext.ux.OptGroupItemSelectorSs'],
    requires: [
        'Ext.button.Button',
        'Ext.ux.OptGroup.OptGroupMultiSelectSs'
    ],

    /**
     * @cfg {Boolean} [hideNavIcons=false] True to hide the navigation icons
     */
    hideNavIcons:false,

    /**
     * @cfg {Array} buttons Defines the set of buttons that should be displayed in between the ItemSelector
     * fields. Defaults to <tt>['top', 'up', 'add', 'remove', 'down', 'bottom']</tt>. These names are used
     * to build the button CSS class names, and to look up the button text labels in {@link #buttonsText}.
     * This can be overridden with a custom Array to change which buttons are displayed or their order.
     */
    buttons: ['top', 'up', 'add', 'remove', 'down', 'bottom'],

    /**
     * @cfg {Object} buttonsText The tooltips for the {@link #buttons}.
     * Labels for buttons.
     */
    buttonsText: {
        top: "Move to Top",
        up: "Move Up",
        add: "Add to Selected",
        remove: "Remove from Selected",
        down: "Move Down",
        bottom: "Move to Bottom"
    },

	 /**
     * @cfg {Object} groupBoundList will contain the current object instance.
     */
	groupBoundList : '',

    initComponent: function() {
        var me = this;
		groupBoundList = me;

        me.ddGroup = me.id + '-dd';
		//me.addListener('afterlayout',me.getScrollMultiselect,false);
        me.callParent();

        // bindStore must be called after the fromField has been created because
        // it copies records from our configured Store into the fromField's Store
        me.bindStore(me.store);
    },
	getScrollMultiselect:function(field){
		var ii = this.toField.getStore().getCount();
		getParentHeight = Ext.get(field.id).getHeight();
		getParentWidth = Ext.get(field.id).getWidth();
		fieldID = Ext.getCmp(field.id).getComponent(0).getComponent(0).id;
		var gt = Ext.getCmp(field.id).getComponent(0).id;
		var tt = Ext.getCmp(gt).getHeight() - 28;
		var countCon = Ext.getCmp(field.id).getStore().getCount();
		if(ii == 0 ){
		$('#'+this.toField.id+' .x-boundlist-outer-ct').css({'width':getParentWidth+'px','overflow':'hidden'});
		}
		Ext.get(field.id).select('.x-boundlist-outer-ct').setHeight(tt);
		$('#'+fieldID+' .x-boundlist-outer-ct').css({'width':getParentWidth+'px','overflow':'auto'});
		$('#'+fieldID+' .x-boundlist-list-ct').css({'height':'auto','overflow':'hidden'});

		$('#'+fieldID+' .x-boundlist-outer-ct').jScrollPane();
	},
    createList: function(title){
        var me = this;

        return Ext.create('Ext.ux.OptGroup.OptGroupMultiSelectSs', {
            submitValue: false,
            flex: 1,
            //dragGroup: me.ddGroup,
            //dropGroup: me.ddGroup,
            title: title,
            store: {
                model: me.store.model,
                data: []
            },
            displayField: me.displayField,
			groupField : me.groupField,
            disabled: me.disabled,
            listeners: {
                boundList: {
                    scope: me,
                    itemdblclick: me.onItemDblClick,
                    drop: me.syncValue
                }
            }
        });
    },

    setupItems: function() {
        var me = this;

        me.fromField = me.createList(me.fromTitle);
        me.toField = me.createList(me.toTitle);

        return {
            border: false,
            layout: {
                type: 'hbox',
                align: 'stretch'
            },
            items: [
                me.fromField,
                {
                    xtype: 'container',
                    margins: '0 4',
                    width: 24,
                    layout: {
                        type: 'vbox',
                        pack: 'center'
                    },
                    items: me.createButtons()
                },
                me.toField
            ]
        };
    },

    createButtons: function(){
        var me = this,
            buttons = [];

        if (!me.hideNavIcons) {
            Ext.Array.forEach(me.buttons, function(name) {
                buttons.push({
                    xtype: 'button',
					// This listeners added for common use of button tool tip with yellow color style -- Start
					listeners:{
						'afterrender':function(){
							Ext.create("Ext.tip.ToolTip",{
								target:this.id,
								anchor:"top",
								cls:"yellowTip",
								trackMouse:true,
								html:me.buttonsText[name]});
						}
					},
					// end here
                    //tooltip: me.buttonsText[name],
                    handler: me['on' + Ext.String.capitalize(name) + 'BtnClick'],
                    cls: Ext.baseCSSPrefix + 'form-itemselector-btn',
                    iconCls: Ext.baseCSSPrefix + 'form-itemselector-' + name,
                    navBtn: true,
                    width:16,
					height:16,
					padding:0,
                    scope: me,
                    margin: '6 4 0 4'
                });
            });
        }
        return buttons;
    },

    /**
     * Get the selected records from the specified list.
     *
     * Records will be returned *in store order*, not in order of selection.
     * @param {Ext.view.BoundList} list The list to read selections from.
     * @return {Ext.data.Model[]} The selected records in store order.
     *
     */
    getSelections: function(list) {
        var store = list.getStore();

        return Ext.Array.sort(list.getSelectionModel().getSelection(), function(a, b) {
            a = store.indexOf(a);
            b = store.indexOf(b);

            if (a < b) {
                return -1;
            } else if (a > b) {
                return 1;
            }
            return 0;
        });
    },

    onTopBtnClick : function() {
        var list = this.toField.boundList,
            store = list.getStore(),
            selected = this.getSelections(list);

        store.suspendEvents();
        store.remove(selected, true);
        store.insert(0, selected);
        store.resumeEvents();
        list.refresh();
        this.syncValue();
        list.getSelectionModel().select(selected);
    },

    onBottomBtnClick : function() {
        var list = this.toField.boundList,
            store = list.getStore(),
            selected = this.getSelections(list);

        store.suspendEvents();
        store.remove(selected, true);
        store.add(selected);
        store.resumeEvents();
        list.refresh();
        this.syncValue();
        list.getSelectionModel().select(selected);
    },

    onUpBtnClick : function() {
        var list = this.toField.boundList,
            store = list.getStore(),
            selected = this.getSelections(list),
            rec,
            i = 0,
            len = selected.length,
            index = 0;

        // Move each selection up by one place if possible
        store.suspendEvents();
        for (; i < len; ++i, index++) {
            rec = selected[i];
            index = Math.max(index, store.indexOf(rec) - 1);
            store.remove(rec, true);
            store.insert(index, rec);
        }
        store.resumeEvents();
        list.refresh();
        this.syncValue();
        list.getSelectionModel().select(selected);
    },

	groupFromFieldItems : function()
	{
		var me = this;
		var isGroupFieldItem = '';
		if (isGroupField != 'undefined' && Ext.isArray(isGroupField))
		{
			isGroupFieldItem = isGroupField[0];
		}
		else
		{
			isGroupFieldItem = isGroupField;
		}

		var list = this.fromField.boundList,
		store = list.getStore(),
		selected = this.getSelections(list),
		rec,
		i = 0,
		len = selected.length,
		index = 0;

		store.suspendEvents();
		for(var z = 0;z<store.getCount();z++)
		{
			var tmpVal = store.getAt(z).get(isGroupFieldItem);
			for(var j = z+1;j<store.getCount();j++)
			{
				var tmpVal2 = store.getAt(j).get(isGroupFieldItem);
				if (tmpVal2.toLowerCase() == tmpVal.toLowerCase())
				{
					var tmpObj = store.getAt(j);
					var tmpObj2 = store.getAt(z+1);
					me.fromField.store.insert(z+1,tmpObj);
					me.fromField.store.insert(j,tmpObj2);
					z++;
				}

			}
		}
		store.resumeEvents();
		list.refresh();
		//this.syncValue();
		list.getSelectionModel().select(selected);
	},

	groupToFieldItems : function()
	{
		var me = this;
		var isGroupFieldItem = '';
		if (isGroupField != 'undefined' && Ext.isArray(isGroupField))
		{
			isGroupFieldItem = isGroupField[0];
		}
		else
		{
			isGroupFieldItem = isGroupField;
		}

		var list = this.toField.boundList,
		store = list.getStore(),
		selected = this.getSelections(list),
		rec,
		i = 0,
		len = selected.length,
		index = 0;

		store.suspendEvents();
		for(var z = 0;z<store.getCount();z++)
		{
			var tmpVal = store.getAt(z).get(isGroupFieldItem);
			for(var j = z+1;j<store.getCount();j++)
			{
				var tmpVal2 = store.getAt(j).get(isGroupFieldItem);
				if (tmpVal2.toLowerCase() == tmpVal.toLowerCase())
				{
					try
					{
						var tmpObj = store.getAt(j);
						var tmpObj2 = store.getAt(z+1);
						me.toField.store.insert(z+1,tmpObj);
						me.toField.store.insert(j,tmpObj2);
						z++;
					}
					catch (e)
					{
					}
				}

			}
		}
		store.resumeEvents();
		list.refresh();
		//this.syncValue();
		list.getSelectionModel().select(selected);
	},

    onDownBtnClick : function() {
        var list = this.toField.boundList,
            store = list.getStore(),
            selected = this.getSelections(list),
            rec,
            i = selected.length - 1,
            index = store.getCount() - 1;

        // Move each selection down by one place if possible
        store.suspendEvents();
        for (; i > -1; --i, index--) {
            rec = selected[i];
            index = Math.min(index, store.indexOf(rec) + 1);
            store.remove(rec, true);
            store.insert(index, rec);
        }
        store.resumeEvents();
        list.refresh();
        this.syncValue();
        list.getSelectionModel().select(selected);
    },

    onAddBtnClick : function() {
        var me = this,
            selected = me.getSelections(me.fromField.boundList);

        me.moveRec(true, selected);
        me.toField.boundList.getSelectionModel().select(selected);
		me.groupToFieldItems();
		me.fromField.boundList.refresh();

		var wsdlOperation = Ext.getCmp('wsdlOperation');
		if (!Ext.isEmpty(wsdlOperation) && wsdlOperation != undefined)
		{
			if (selected.length > 0)
			{
				appDesc.disassociate();
			}
		}

    },

    onRemoveBtnClick : function() {
        var me = this,
            selected = me.getSelections(me.toField.boundList);

        me.moveRec(false, selected);
        me.fromField.boundList.getSelectionModel().select(selected);
		me.groupFromFieldItems();
		me.toField.boundList.refresh();

		var wsdlOperation = Ext.getCmp('wsdlOperation');
		if (!Ext.isEmpty(wsdlOperation) && wsdlOperation != undefined)
		{
			if (selected.length > 0)
			{
				appDesc.changeElement();
			}
		}
    },

    moveRec: function(add, recs) {
        var me = this,
            fromField = me.fromField,
            toField   = me.toField,
            fromStore = add ? fromField.store : toField.store,
            toStore   = add ? toField.store   : fromField.store;

        fromStore.suspendEvents();
        toStore.suspendEvents();
        fromStore.remove(recs);
        toStore.add(recs);
        fromStore.resumeEvents();
        toStore.resumeEvents();

        fromField.boundList.refresh();
        toField.boundList.refresh();

        me.syncValue();
    },

    // Synchronizes the submit value with the current state of the toStore
    syncValue: function() {
        var me = this;
        me.mixins.field.setValue.call(me, me.setupValue(me.toField.store.getRange()));
    },

    onItemDblClick: function(view, rec) {

		var wsdlOperation = Ext.getCmp('wsdlOperation');
		var isFromFieldDblClick = false;
		if (!Ext.isEmpty(wsdlOperation) && wsdlOperation != undefined)
		{
			var me = this,
				 getSelected = me.getSelections(me.fromField.boundList);
			if (getSelected.length > 0)
			{
				isFromFieldDblClick = true;
			}

			//getSelected = me.getSelections(me.toField.boundList);
			//if (getSelected.length > 0)
			//{
				//isFromFieldDblClick = false;
			//}
		}
        this.moveRec(view === this.fromField.boundList, rec);
		var wsdlOperation = Ext.getCmp('wsdlOperation');
		if (!Ext.isEmpty(wsdlOperation) && wsdlOperation != undefined)
		{
			if (isFromFieldDblClick)
			{
				appDesc.disassociate();
			}
			else
			{
				appDesc.changeElement();
			}
		}
    },

    setValue: function(value) {
        var me = this,
            fromField = me.fromField,
            toField = me.toField,
            fromStore = fromField.store,
            toStore = toField.store,
            selected;

        // Wait for from store to be loaded
        if (!me.fromStorePopulated) {
            me.fromField.store.on({
                load: Ext.Function.bind(me.setValue, me, [value]),
                single: true
            });
            return;
        }

        value = me.setupValue(value);
        me.mixins.field.setValue.call(me, value);

        selected = me.getRecordsForValue(value);

        // Clear both left and right Stores.
        // Both stores must not fire events during this process.
        fromStore.suspendEvents();
        toStore.suspendEvents();
        fromStore.removeAll();
        toStore.removeAll();

        // Reset fromStore
        me.populateFromStore(me.store);

        // Copy selection across to toStore
        Ext.Array.forEach(selected, function(rec){
            // In the from store, move it over
            if (fromStore.indexOf(rec) > -1) {
                fromStore.remove(rec);
            }
            toStore.add(rec);
        });

        // Stores may now fire events
        fromStore.resumeEvents();
        toStore.resumeEvents();

        // Refresh both sides and then update the app layout
        Ext.suspendLayouts();
        fromField.boundList.refresh();
        toField.boundList.refresh();
        Ext.resumeLayouts(true);
    },

    onBindStore: function(store, initial) {
        var me = this;

        if (me.fromField) {
            me.fromField.store.removeAll()
            me.toField.store.removeAll();

            // Add everything to the from field as soon as the Store is loaded
            if (store.getCount()) {
                me.populateFromStore(store);
            } else {
                me.store.on('load', me.populateFromStore, me);
            }
        }
    },

    populateFromStore: function(store) {
        var fromStore = this.fromField.store;

        // Flag set when the fromStore has been loaded
        this.fromStorePopulated = true;

        fromStore.add(store.getRange());

        // setValue waits for the from Store to be loaded
        fromStore.fireEvent('load', fromStore);
    },

    onEnable: function(){
        var me = this;

        me.callParent();
        me.fromField.enable();
        me.toField.enable();

        Ext.Array.forEach(me.query('[navBtn]'), function(btn){
            btn.enable();
        });
    },

    onDisable: function(){
        var me = this;

        me.callParent();
        me.fromField.disable();
        me.toField.disable();

        Ext.Array.forEach(me.query('[navBtn]'), function(btn){
            btn.disable();
        });
    },

    onDestroy: function(){
        this.bindStore(null);
        this.callParent();
    }
});



