
/**
 * A control that allows selection of multiple items in a list
 */
Ext.define('Ext.ux.OptGroup.OptGroupMultiSelectSs', {
    
    extend: 'Ext.ux.form.MultiSelect',

    alternateClassName: 'Ext.ux.OptGroupMultiSelectSs',
    alias: ['widget.optgroupmultiselectfieldSs', 'widget.optgroupmultiselectSs'],
    
    requires: ['Ext.panel.Panel', 'Ext.ux.OptGroup.BoundListSs', 'Ext.layout.container.Fit'],
    
    uses: ['Ext.view.DragZone', 'Ext.view.DropZone'],
    
    layout: 'fit',
    
    /**
     * @cfg {String} [dragGroup=""] The ddgroup name for the MultiSelect DragZone.
     */

    /**
     * @cfg {String} [dropGroup=""] The ddgroup name for the MultiSelect DropZone.
     */
    
    /**
     * @cfg {String} [title=""] A title for the underlying panel.
     */
    
    /**
     * @cfg {Boolean} [ddReorder=false] Whether the items in the MultiSelect list are drag/drop reorderable.
     */
    ddReorder: false,

    /**
     * @cfg {Object/Array} tbar An optional toolbar to be inserted at the top of the control's selection list.
     * This can be a {@link Ext.toolbar.Toolbar} object, a toolbar config, or an array of buttons/button configs
     * to be added to the toolbar. See {@link Ext.panel.Panel#tbar}.
     */

    /**
     * @cfg {String} [appendOnly=false] True if the list should only allow append drops when drag/drop is enabled.
     * This is useful for lists which are sorted.
     */
    appendOnly: false,

    /**
     * @cfg {String} [displayField="text"] Name of the desired display field in the dataset.
     */
    displayField: 'text',

    /**
     * @cfg {String} [valueField="text"] Name of the desired value field in the dataset.
     */

    /**
     * @cfg {Boolean} [allowBlank=true] False to require at least one item in the list to be selected, true to allow no
     * selection.
     */
    allowBlank: true,

    /**
     * @cfg {Number} [minSelections=0] Minimum number of selections allowed.
     */
    minSelections: 0,

    /**
     * @cfg {Number} [maxSelections=Number.MAX_VALUE] Maximum number of selections allowed.
     */
    maxSelections: Number.MAX_VALUE,

    /**
     * @cfg {String} [blankText="This field is required"] Default text displayed when the control contains no items.
     */
    blankText: 'This field is required',

    /**
     * @cfg {String} [minSelectionsText="Minimum {0}item(s) required"] 
     * Validation message displayed when {@link #minSelections} is not met. 
     * The {0} token will be replaced by the value of {@link #minSelections}.
     */
    minSelectionsText: 'Minimum {0} item(s) required',
    
    /**
     * @cfg {String} [maxSelectionsText="Maximum {0}item(s) allowed"] 
     * Validation message displayed when {@link #maxSelections} is not met
     * The {0} token will be replaced by the value of {@link #maxSelections}.
     */
    maxSelectionsText: 'Minimum {0} item(s) required',

    /**
     * @cfg {String} [delimiter=","] The string used to delimit the selected values when {@link #getSubmitValue submitting}
     * the field as part of a form. If you wish to have the selected values submitted as separate
     * parameters rather than a single delimited parameter, set this to <tt>null</tt>.
     */
    delimiter: ',',

    /**
     * @cfg {Ext.data.Store/Array} store The data source to which this MultiSelect is bound (defaults to <tt>undefined</tt>).
     * Acceptable values for this property are:
     * <div class="mdetail-params"><ul>
     * <li><b>any {@link Ext.data.Store Store} subclass</b></li>
     * <li><b>an Array</b> : Arrays will be converted to a {@link Ext.data.ArrayStore} internally.
     * <div class="mdetail-params"><ul>
     * <li><b>1-dimensional array</b> : (e.g., <tt>['Foo','Bar']</tt>)<div class="sub-desc">
     * A 1-dimensional array will automatically be expanded (each array item will be the combo
     * {@link #valueField value} and {@link #displayField text})</div></li>
     * <li><b>2-dimensional array</b> : (e.g., <tt>[['f','Foo'],['b','Bar']]</tt>)<div class="sub-desc">
     * For a multi-dimensional array, the value in index 0 of each item will be assumed to be the combo
     * {@link #valueField value}, while the value at index 1 is assumed to be the combo {@link #displayField text}.
     * </div></li></ul></div></li></ul></div>
     */
    
    ignoreSelectChange: 0,

	isGroupField : '',
    /**
     * @cfg {Object} listConfig
     * An optional set of configuration properties that will be passed to the {@link Ext.view.BoundList}'s constructor.
     * Any configuration that is valid for BoundList can be included.
     */

    setupItems: function() {
        var me = this;
        isGroupField = me.groupField;
        me.boundList = Ext.create('Ext.ux.OptGroup.BoundListSs', Ext.apply({
            deferInitialRefresh: false,
            border: false,
            multiSelect: true,
            store: me.store,
			//style:{'border':'#BFBDBF 1px solid','-moz-border-radius':'5px','-webkit-border-radius':'5px','border-radius':'5px'},
            displayField: me.displayField,
            disabled: me.disabled,
			groupField : me.groupField,
			renderTpl: [
					'<input id="{id}-inputEl" type="text" role="{role}" {inputAttrTpl} class="x-form-field x-form-text x-form-focus x-field-form-focus x-field-default-form-focus" style="position:absolute;left:-999px;opacity:0;letter-spacing: normal;word-spacing: normal;text-transform: none;text-indent: 0px;text-shadow: none;display: inline-block;text-align: start;height:0px" autocomplete="off"',
					'<tpl if="value"> value="{[Ext.util.Format.htmlEncode(values.value)]}"</tpl>',
					'<tpl if="name"> name="{name}"</tpl>',
					'<tpl if="placeholder"> placeholder="{placeholder}"</tpl>',
					'<tpl if="size"> size="{size}"</tpl>',
					'<tpl if="maxLength !== undefined"> maxlength="{maxLength}"</tpl>',
					'<tpl if="readOnly"> readonly="readonly"</tpl>',
					'<tpl if="disabled"> disabled="disabled"</tpl>',
					'<tpl if="tabIdx"> tabIndex="{tabIdx}"</tpl>',
					'<tpl if="fieldStyle"> style="{fieldStyle}"</tpl>',
					'/>',
					'<div id="{id}-listEl" class="{baseCls}-list-ct" style="overflow:auto"></div>',
					'{%',
					'var me=values.$comp, pagingToolbar=me.pagingToolbar;',
					'if (pagingToolbar) {',
					'pagingToolbar.ownerLayout = me.componentLayout;',
					'Ext.DomHelper.generateMarkup(pagingToolbar.getRenderTree(), out);',
					'}',
					'%}', 
					{
						disableFormats: true
					}
			],
			plugins: [Ext.create('Ext.ux.form.CustomDragSelector', {})]

        }, me.listConfig));
        
        me.boundList.getSelectionModel().on('selectionchange', me.onSelectChange, me);
        return {
            border: true,
            layout: 'fit',
            title: me.title,
            tbar: me.tbar,
            items: me.boundList
        };
    },

    afterRender: function(){
        var me = this;
        
        me.callParent();
        if (me.selectOnRender) {
            ++me.ignoreSelectChange;
            me.boundList.getSelectionModel().select(me.getRecordsForValue(me.value));
            --me.ignoreSelectChange;
            delete me.toSelect;
        }    

        if (me.ddReorder && !me.dragGroup && !me.dropGroup){
            me.dragGroup = me.dropGroup = 'MultiselectDD-' + Ext.id();
        }

        if (me.draggable || me.dragGroup){
            me.dragZone = Ext.create('Ext.view.DragZone', {
                view: me.boundList,
                ddGroup: me.dragGroup,
				onDrag : function(e){
					me.dragZone.hideProxy();
				},
                dragText: '{0} Item{1}'
            });
        }
        if (me.droppable || me.dropGroup){
            me.dropZone = Ext.create('Ext.view.DropZone', {
                view: me.boundList,
                ddGroup: me.dropGroup,
                handleNodeDrop: function(data, dropRecord, position) {
                    var view = this.view,
                        store = view.getStore(),
                        records = data.records,
                        index;

					if (view.id != data.view.id)
					{
						// remove the Models from the source Store
						data.view.store.remove(records);

						index = store.indexOf(dropRecord);
						if (position === 'after') {
							index++;
						}
						store.insert(index, records);
						view.getSelectionModel().select(records);
						me.fireEvent('drop', me, records);

						if (groupBoundList != null && groupBoundList != 'undefined')
						{
							if (groupBoundList.toField.store.getCount() > 0)
							{
								groupBoundList.groupToFieldItems();
							}
							else
							{
								groupBoundList.toField.boundList.refresh()
							}

							if (groupBoundList.fromField.store.getCount() > 0)
							{
								groupBoundList.groupFromFieldItems();
							}
							else
							{
								groupBoundList.fromField.boundList.refresh();
							}
						}
					}
                }
            });
        }
    }
});



