/*
 * Note that this control will most likely remain as an example, and not as a core Ext form
 * control.  However, the API will be changing in a future release and so should not yet be
 * treated as a final, stable API at this time.
 */

/**
 * A control that allows selection of between two Ext.ux.form.MultiSelect controls.
 */
Ext.define('Ext.ux.OptGroupItemSelectorRv', {
	extend: 'Ext.ux.OptGroup.OptGroupItemSelector',
	alias: ['widget.optgroupitemselectorfield','widget.optgroupitemselector'],
	alternateClassName: ['Ext.ux.OptGroupItemSelectorRv'],

	/**
	 * @cfg {Array} buttons Defines the set of buttons that should be displayed in between the ItemSelector
	 * fields. Defaults to <tt>['top', 'up', 'add', 'remove', 'down', 'bottom']</tt>. These names are used
	 * to build the button CSS class names, and to look up the button text labels in {@link #buttonsText}.
	 * This can be overridden with a custom Array to change which buttons are displayed or their order.
	 */
	buttons: ['top', 'up', 'add', 'remove', 'down', 'bottom','addConnects'],

	/**
	 * @cfg {Object} buttonsText The tooltips for the {@link #buttons}.
	 * Labels for buttons.
	 */
	buttonsText: {
		top: "Move to Top",
		up: "Move Up",
		add: "Add to Selected",
		remove: "Remove from Selected",
		down: "Move Down",
		bottom: "Move to Bottom",
		addConnects:"Connects"
	},

	 /**
	 * @cfg {Object} groupBoundList will contain the current object instance.
	 */
	groupBoundList : '',

	initComponent: function() {
		var me = this;
		groupBoundList = me;

		if(me.id!='itemselectHostsForSegment')
		{
			me.ddGroup = me.id + '-dd';
		}
		//me.addListener('afterlayout',me.getScrollMultiselect,false);
		me.callParent();

		// bindStore must be called after the fromField has been created because
		// it copies records from our configured Store into the fromField's Store
		me.bindStore(me.store);
	},

	onAddBtnClick : function() {
		var me = this,
			selected = me.getSelections(me.fromField.boundList);
		if (selected.length <= 0 || selected == null || selected == '')
		{
			Ext.Msg.alert("Segment","Please choose a component");
		}
		me.moveRec(true, selected);
		me.toField.boundList.getSelectionModel().select(selected);
		me.groupToFieldItems();
		me.fromField.boundList.refresh();

		//Segment page
		var segmentSelector = Ext.getCmp('itemselectHostsForSegment');
		if (segmentSelector != null && segmentSelector != "undefined")
		{
			addToManage('L');
		}
	},

	onAddConnectsBtnClick : function() {
		var me = this,
			selected = me.getSelections(me.fromField.boundList);
		if (selected.length <= 0 || selected == null || selected == '')
		{
			Ext.Msg.alert("Segment","Please choose a component");
		}
		me.moveRec(true, selected);
		me.toField.boundList.getSelectionModel().select(selected);

		//Segment page
		var segmentSelector = Ext.getCmp('itemselectHostsForSegment');
		if (segmentSelector != null && segmentSelector != "undefined")
		{
			addToManage('N');
		}
	},

	onRemoveBtnClick : function() {
		var me = this,
			selected = me.getSelections(me.toField.boundList);
		var compNos = me.toField.boundList.getStore().getCount();
		if (selected.length <= 0 || selected == null || selected == '')
		{
			Ext.Msg.alert("Segment","Please choose a component to remove");
		}
		//if(selected.length == compNos || compNos == 1)
		//{
			//Ext.Msg.alert("Segment", minimumOneCompA+". "+minimumOneCompB);
		//}
		//else
		{
			me.moveRec(false, selected);
			me.fromField.boundList.getSelectionModel().select(selected);
			me.groupFromFieldItems();
			me.toField.boundList.refresh();

			// Segment Page
			var segmentSelector = Ext.getCmp('itemselectHostsForSegment');
			if (segmentSelector != null && segmentSelector != "undefined")
			{
				addToManage('remove');
			}
		}
	},

	moveRec: function(add, recs) {
		var me = this,
			fromField = me.fromField,
			toField   = me.toField,
			fromStore = add ? fromField.store : toField.store,
			toStore   = add ? toField.store   : fromField.store;

		fromStore.suspendEvents();
		toStore.suspendEvents();
		fromStore.remove(recs);
		toStore.add(recs);
		fromStore.resumeEvents();
		toStore.resumeEvents();

		fromField.boundList.refresh();
		toField.boundList.refresh();

		me.syncValue();
	},

	// Synchronizes the submit value with the current state of the toStore
	syncValue: function() {
		var me = this; 
		me.mixins.field.setValue.call(me, me.setupValue(me.toField.store.getRange()));
	},

	/* onItemDblClick: function(view, rec) {
		this.moveRec(view === this.fromField.boundList, rec);
	},*/
	onItemDblClick: function(view, rec) {
		var me = this;
		if (view == me.toField.boundList){
			me.onRemoveBtnClick();
		}
		else if (view == me.fromField.boundList) {
			var segmentSelector = Ext.getCmp('itemselectHostsForSegment');
			if (segmentSelector == null || segmentSelector == "undefined")
			{
				me.onAddBtnClick();
			}
		}
		/*var segmentSelector = Ext.getCmp('itemselectHostsForSegment');
		if (segmentSelector == null && segmentSelector == "undefined")
		{
			this.moveRec(view === this.fromField.boundList, rec);
		}*/
	}
});

// Segment Page
function addToManage(str)
{
	var associatedHostList = Ext.getCmp('itemselectHostsForSegment').getValue();
	var imageName = Ext.getCmp('imagecombo').getValue();
	if(str=='L' || str=='N')
	{
		if(associatedHostList=="")
		{
			Ext.Msg.alert("Segment",publicJSON['screenLabels']['admin.common.Please choose a component']);
			return false;
		}
		if(imageName==null || imageName=='-1' || imageName.length==0)
		{
			Ext.Msg.alert(pageTitle,"Please choose an image");
			reloadItemSelector();
			return false;
		}
	}
	var Arr = new Array();
	for (var i=0;i<Ext.getCmp('itemselectHostsForSegment').getStore().getCount();i++)
	{
		var allValue = Ext.getCmp('itemselectHostsForSegment').getStore().getAt(i).get('valueField');
		var isData = false;
		for (var j=0;j<associatedHostList.length ;j++ )
		{
			if (allValue == associatedHostList[j])
			{
				isData = true;
				break;
			}
		}
		if (!isData)
		{
			Arr[Arr.length]=allValue;
		}
	}
	var tempmanagedHostList = Arr;
	var otherHostList = tempmanagedHostList.toString();
	if(str=='remove')
	{
		if(otherHostList=='')
		{
			Ext.Msg.alert("Segment","No component to remove");
			return;
		}
	}

	var compType = Ext.getCmp('compTypeCombo').getValue();
	var compName = Ext.getCmp('componentsList').getValue();
	var segName = '';
	var newsegment='';
	var mode=publicJSON['mode'];
	if(mode=='add')
	{
		segName = Ext.getCmp('segmentName').getValue();
		newsegment='true';
	}
	else if(mode=='modify')
	{
		segName = Ext.getCmp('segmentNameCombo').getValue();
		newsegment='false';
	}

	var zone = '';
	if(Ext.getCmp('assocZoneCombo').getValue() != undefined)
		zone = Ext.getCmp('assocZoneCombo').getValue();
	var showIndOnlyParam = publicJSON['showIndCheck'];
	var zoom="100";

	var hiddenObj = Ext.getCmp('hiddencontainer');
	var temp = {
		xtype: 'hiddenfield',
		name: 'showIndOnlyParam',
		value: showIndOnlyParam
	};
	hiddenObj.add(temp);

	temp = {
		xtype: 'hiddenfield',
		name: 'associatedComps',
		value: associatedHostList
	};
	hiddenObj.add(temp);

	temp = {
		xtype: 'hiddenfield',
		name: 'otherComps',
		value: otherHostList
	};
	hiddenObj.add(temp);

	temp = {
		xtype: 'hiddenfield',
		name: 'returnToMain',
		value: returnToMain
	};
	hiddenObj.add(temp);

	temp = {
		xtype: 'hiddenfield',
		name: 'mainUrl',
		value: mainUrl
	};
	hiddenObj.add(temp);

	var isVisiblesearchCon = Ext.getCmp('searchFieldContainer').isVisible();
	var searchVal = '';
	if(isVisiblesearchCon)
	{
		searchVal = Ext.getCmp('unAssociateCmpSeacrchBox').getValue()
	}

	var jsonUrl = 'Segments/data/EgAdminTopologyJson.jsp?mode='+mode+'&segment='+encodeURIComponent(segName)+'&newsegment='+encodeURIComponent(newsegment)+'&zone='+encodeURIComponent(zone)+'&comptype='+encodeURIComponent(compType)+'&compname='+encodeURIComponent(compName)+'&strSearch='+searchVal+'&searchType=unAssociateCmpSeacrch';

	if(str=='L'|| str=='N')
	{
		jsonUrl = jsonUrl+'&callFrom=fromItemSelector'+'&lornString='+str;
		jsonUrl = jsonUrl+"&imageName="+imageName;
	}
	else if(str=='remove')
	{
		jsonUrl = jsonUrl+'&callFrom=removeItemSelector';
	}

	if(!Ext.getCmp('componentLbl').isVisible())
		Ext.getCmp('assocZoneCombo').disable();
	else
		Ext.getCmp('assocZoneCombo').enable();

	var updateZone= false;
	var hiddencompSegObj = Ext.getCmp('componentsegment').getForm();
		hiddencompSegObj.submit({
		url: jsonUrl+"&validate=true",
		timeout : 120,
		method: 'POST',
		standardSubmit: false,
		success: function( form,action )
		{
			var jsonText = action.response.responseText;
			publicJSON = Ext.decode(jsonText);
			if ( !Ext.isEmpty( jsonText ) && action.response.status == 200 )
			{
				Ext.getCmp('itemselectHostsForSegment').getStore().loadRawData(publicJSON['itemSelectorValue']);
				Ext.getCmp('itemselectHostsForSegment').setValue(publicJSON['associatedComponentsArr']);
				var topologyUrl = publicJSON['topologyUrl'];
				if(str=='remove')
				{
					updateZone =true;
				}
				var associatedHostList_new = Ext.getCmp('itemselectHostsForSegment').getValue();
				var Arrs = new Array();
				for (var i=0;i<Ext.getCmp('itemselectHostsForSegment').getStore().getCount();i++)
				{
					var allValues = Ext.getCmp('itemselectHostsForSegment').getStore().getAt(i).get('valueField');
					var isDatas = false;
					for (var j=0;j<associatedHostList_new.length ;j++)
					{
						if (allValues == associatedHostList_new[j])
						{
							isDatas = true;
							break;
						}
					}
					if (!isDatas)
					{
						Arrs[Arrs.length]=allValues;
					}
				}
				var tempmanagedHostList_new = Arrs;
				var otherHostList_new = tempmanagedHostList_new.toString();

				//var validationUrl = 'ComponentSegments/data/EgAdminTopologyJson.jsp?mode='+mode+'&segment='+segName+'&newsegment='+newsegment+'&zone='+zone+'&showIndOnlyParam='+!showIndOnlyParam+'&comptype='+compType+'&compname='+compName+"&validate=true"+'&associatedComps='+associatedHostList_new+'&otherComps='+otherHostList_new;
				var resultUrl = 'Segments/data/EgadmintopologypJson.jsp?mode='+mode+'&newsegment='+encodeURIComponent(newsegment)+'&comptype='+encodeURIComponent(compType)+'&compname='+encodeURIComponent(compName)+'&segment='+encodeURIComponent(segName)+'&zone='+encodeURIComponent(zone)+'&zoomValue='+zoom+'&updateZone='+encodeURIComponent(updateZone)+'&update=true';
				
				var hiddenProObj = Ext.getCmp('hiddenprocesscontainer');
				var tempPro = {
					xtype: 'hiddenfield',
					name: 'fmanage',
					value: associatedHostList_new
				};
				hiddenProObj.add(tempPro);

				var tempPro = {
					xtype: 'hiddenfield',
					name: 'fumanage',
					value: otherHostList_new
				};
				hiddenProObj.add(tempPro);

				var tempPro = {
					xtype: 'hiddenfield',
					name: 'showIndOnlyParam',
					value: !showIndOnlyParam
				};
				hiddenProObj.add(tempPro);

				var isValidName = publicJSON['screenLabels']['isValid']; 
				if(isValidName=="false")
				{
					Ext.Msg.alert("Segment",publicJSON['screenLabels']['admin.common.ErroInAddingSegment']);
					return;
				}
				else
				{
					var showIndOnly = publicJSON['showIndCheck'];
					
					var oldSegmentName='';
					if(mode!=null && mode=="modify")
					{
						oldSegmentName = publicJSON['oldSegmentName'];
					}
					var hiddencompProSegObj = Ext.getCmp('componentsegment').getForm();
						hiddencompProSegObj.submit({
						url: resultUrl+"&oldSegmentName="+oldSegmentName,
						method: 'POST',
						standardSubmit: false,
						success: function( form,action )
						{
							var jsonText = action.response.responseText;
			
							jsonObj = Ext.decode( jsonText );
							var isError = jsonObj['isError'];
							if(isError=='true')
							{
								var errorMsg = jsonObj['screenLabels']['admin.error.Error'];
								if(errorMsg instanceof Array)
								{
									errorMsg = getErrorMessageTemplate(errorMsg);
									Ext.Msg.show({
										title : "Segment",
										msg : errorMsg,
										icon : 'iconError',
										buttons : Ext.Msg.OK
									});
									//showResultWindow(errorMsg);
								}
								else
								{
									Ext.Msg.show({
										title : "Segment",
										msg : errorMsg+'.',
										icon : 'iconError',
										buttons : Ext.Msg.OK
									});
								}
								reloadItemSelector();
							}
							else if (jsonObj['isEmpty']=='emptyCheck')
							{
								Ext.getCmp("iconSave").setDisabled(true);
								Ext.getCmp("iconReset").setDisabled(true);
								Ext.getCmp("iconMaximize").setDisabled(true);
								reloadItemSelector();
								appCnt.resetPosition();
							}
							else
							{
								Ext.getCmp("iconSave").setDisabled(false);
								Ext.getCmp("iconReset").setDisabled(false);
								Ext.getCmp("iconMaximize").setDisabled(false);
								Ext.getCmp('segmentName').setDisabled(true);
//								Ext.getCmp('assocZoneCombo').setDisabled(true);
								if(!Ext.getCmp('topologyFrame').isVisible() && !Ext.getCmp('topologyPanel').isVisible())
								{
									Ext.getCmp('topologyPanel').setVisible(true);
									Ext.getCmp('topologyFrame').setVisible(true);
								}
								Ext.getCmp('topologyFrame').update('<iframe src="' + topologyUrl+ '" style="width:945px" height="540" scrolling="no" ></iframe>');
								//Ext.getCmp('itemselectHostsForSegment').getStore().loadRawData(publicJSON['itemSelectorValue']);
								//Ext.getCmp('itemselectHostsForSegment').setValue(publicJSON['associatedComponentsArr']);

//								if(!showIndOnly)
//								{
//									Ext.getCmp('association').setValue(true);
//								}
								showAssociationPanel();
								reloadItemSelector();
								/*var isZone = publicJSON['isZone'];
								if(isZone=='true')
								{
									table = '<table width="100%" cellspacing="0" cellpadding="0" border="0" style="font-size:12px">';
									table += '<tr><td align="left"><table border="0" cellspacing="4" cellspacing="0" style="font-size:12px"><tr>';
									var serviceArr = publicJSON['AssociatedServiceList'];
									if(serviceArr!=null && serviceArr!=undefined && serviceArr.length>0)
									{
										table += '<td width="120">Service(s) mapping</td><td width="10">:</td>';
										table += '<td>';
										var fieldValue='';
										for(var s=0;s<serviceArr.length;s++)
										{
											var serviceName = serviceArr[s];
											var serviceUrl = publicJSON['AssociatedServiceUrl'][serviceName];
											table += '<a style="text-decoration:none;color:#000;" href='+serviceUrl+'><b>'+serviceName+'</b></a>'+",";
										}
										table += '</td>';
									}
									var AssociatedZoneForEdit = publicJSON['AssociatedZoneForEdit'];
									var configZoneLink = publicJSON['configZoneLink'];
									var dissociateZonelink = publicJSON['dissociateZonelink'];
									
									table += '</tr>';
									table += '<tr><td width="120" align="left" nowrap>Zone mapping</td><td width="10">:</td>';
									table += '<td align="left"><a style="text-decoration:none;color:#000;" href='+configZoneLink+'><b>'+AssociatedZoneForEdit+'</b></a>';
									//if(publicJSON['disassString']!=null && publicJSON['disassString']!=undefined)
									//{
										table += '(<a style="text-decoration:none;color:#000;" href=# onclick="javascript:disassociateZone();"><b>Disassociate</b>)';
									//}
									table +='</td></tr></table></td></tr>';
									table += '</table>';	

									Ext.getCmp('associationPanel').show();
									Ext.getCmp('associationDiv').show();
									Ext.getCmp('associationDiv').update(
									{
										html:table
									});
								}
								else
								{
									Ext.getCmp('associationPanel').hide();
									Ext.getCmp('associationDiv').hide();
								}*/
							}
							hiddenProObj.removeAll();
						},
						failure: function()
						{
							hiddenProObj.removeAll();
						}
					});
				}
			}
			hiddenObj.removeAll();
		},
		failure: function()
		{
			hiddenObj.removeAll();
		}
	});
}

function openWindow()
{
	var json = jsonObj['errorMsg'];
	var form = document.createElement("form");
	form.setAttribute("method", "post");
	form.setAttribute("action", "/final/admin/Segments/data/EgSegmentErrorJson.jsp?com.eg.CSRF_NONCE="+csrfToken);
	form.setAttribute("target", "_blank");
	var hiddenField = document.createElement("input");
	hiddenField.setAttribute("name", "json");
	hiddenField.setAttribute("value", json);
	form.appendChild(hiddenField);
	document.body.appendChild(form);
	form.submit();
}

function showAssociationPanel()
{
	var mode = publicJSON['mode'];
	var compname = Ext.getCmp('componentsList').getValue();
	var segName = '';
	var newsegment='';
	if(mode=='add')
	{
		segName = Ext.getCmp('segmentName').getValue();
		newsegment='true';
	}
	else if(mode=='modify')
	{
		segName = Ext.getCmp('segmentNameCombo').getValue();
		newsegment='false';
	}
	var zone = '';
	if(Ext.getCmp('assocZoneCombo').getValue() != undefined)
		zone = Ext.getCmp('assocZoneCombo').getValue();
	var showIndOnlyParam = Ext.getCmp('association').getValue();
	var componentType = Ext.getCmp('compTypeCombo').getValue();

	Ext.Ajax.request({
		url: 'Segments/data/EgAdminTopologyJson.jsp?mode='+mode+'&segment='+encodeURIComponent(segName)+'&newsegment='+encodeURIComponent(newsegment)+'&zone='+encodeURIComponent(zone)+'&showIndOnlyParam='+!showIndOnlyParam+'&comptype='+encodeURIComponent(componentType)+'&compname='+encodeURIComponent(compname)+'&validate=true'+'&returnToMain='+returnToMain+'&mainUrl='+mainUrl,
		method: 'POST',
		async: false,
		success: function( response )
		{
			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
			{
				var jsonText = response.responseText;
				var jsonObj = Ext.decode( jsonText );

				publicJSON['mode']='modify';
				Ext.getCmp('segmentNameCombo').getStore().clearFilter(true);
				Ext.getCmp('segmentNameCombo').getStore().removeAll();
				Ext.getCmp('segmentNameCombo').getStore().loadRawData(jsonObj['ExistingSegmentNames']);
				Ext.getCmp('segmentName').hide();
				Ext.getCmp('segmentNameCombo').show();
				Ext.getCmp('segmentNameCombo').setValue(segName);
//				var isZone = jsonObj['isZone'];
//				if(isZone=='true')
//				{
//					table = '<table width="100%" cellspacing="0" cellpadding="0" border="0" style="font-size:12px">';
//					table += '<tr><td align="left"><table border="0" cellspacing="4" cellspacing="0" style="font-size:12px"><tr>';
//					var serviceArr = jsonObj['AssociatedServiceList'];
//					if(serviceArr!=null && serviceArr!=undefined && serviceArr.length>0)
//					{
//						table += '<td width="120"><i>Service(s) mapping</i></td><td width="10">:</td>';
//						table += '<td>';
//						var fieldValue='';
//						for(var s=0;s<serviceArr.length;s++)
//						{
//							var serviceName = serviceArr[s];
//							var serviceUrl = jsonObj['AssociatedServiceUrl'][serviceName];
//							table += '<a style="text-decoration:none;color:#000;" href='+serviceUrl+'>'+serviceName+'</a>';
//							if(s!=(serviceArr.length-1))
//							{
//								table +=", ";
//							}
//						}
//						table += '</td>';
//					}
//					var AssociatedZoneForEdit = jsonObj['AssociatedZoneForEdit'];
//					var configZoneLink = jsonObj['configZoneLink'];
//					var dissociateZonelink = jsonObj['dissociateZonelink'];
//					
//					table += '</tr>';
//					table += '<tr><td width="120" align="left" nowrap><i>Zone mapping</i></td><td width="10">:</td>';
//					table += '<td align="left"><a style="text-decoration:none;color:#000;" href='+configZoneLink+'>'+AssociatedZoneForEdit+'</a>';
//					if(publicJSON['disassString']!=null && publicJSON['disassString']!=undefined)
//					{
//						table += ' (<a style="text-decoration:none;color:#000;" href=# onclick="javascript:disassociateZone();">Disassociate)';
//					}
//					table +='</td></tr></table></td></tr>';
//					table += '</table>';	
//
//					Ext.getCmp('associationPanel').show();
//					Ext.getCmp('associationDiv').show();
//					Ext.getCmp('associationDiv').update(
//					{
//						html:table
//					});
//				}
//				else
//				{
//					Ext.getCmp('associationPanel').hide();
//					Ext.getCmp('associationDiv').hide();
//				}
			}
		}
	});
}
function reloadItemSelector()
{
	var mode = publicJSON['mode'];
	var compname = Ext.getCmp('componentsList').getValue();
	var segName = '';
	var newsegment='';
	if(mode=='add')
	{
		segName = Ext.getCmp('segmentName').getValue();
		newsegment='true';
	}
	else if(mode=='modify')
	{
		segName = Ext.getCmp('segmentNameCombo').getValue();
		newsegment='false';
	}
	var zone = '';
	if(Ext.getCmp('assocZoneCombo').getValue() != undefined)
		zone = Ext.getCmp('assocZoneCombo').getValue();
	var showIndOnlyParam = Ext.getCmp('association').getValue();
	var componentType = Ext.getCmp('compTypeCombo').getValue();
	var isVisiblesearchCon = Ext.getCmp('searchFieldContainer').isVisible();
	var searchVal = '';
	if(isVisiblesearchCon)
	{
		searchVal = Ext.getCmp('unAssociateCmpSeacrchBox').getValue()
		
	}
	
	Ext.Ajax.request({
		url: 'Segments/data/EgAdminTopologyJson.jsp?mode='+mode+'&segment='+encodeURIComponent(segName)+'&newsegment='+encodeURIComponent(newsegment)+'&zone='+encodeURIComponent(zone)+'&showIndOnlyParam='+!showIndOnlyParam+'&comptype='+encodeURIComponent(componentType)+'&compname='+encodeURIComponent(compname)+'&validate=true'+'&strSearch='+searchVal+'&returnToMain='+returnToMain+'&mainUrl='+mainUrl+'&searchType=unAssociateCmpSeacrch',
		method: 'POST',
		async: false,
		success: function( response )
		{
			if ( response.status == 200 && !Ext.isEmpty( response.responseText ) )
			{
				var jsonText = response.responseText;
				var jsonObj = Ext.decode( jsonText );
			
				Ext.getCmp('itemselectHostsForSegment').getStore().loadRawData(jsonObj['itemSelectorValue']);
				Ext.getCmp('itemselectHostsForSegment').setValue(jsonObj['associatedComponentsArr']);
			}
		}
	});

}

function showResultWindow(resultText)
{
	Ext.widget('window', {
		title: 'SEGMENT',
		closeAction: 'destory',
		bodyPadding : 20,
		scroll: true,
		width : 700,
		modal : true,
		autoScroll: true,
		doClose: function() {
			this.destroy();
		},
		html: resultText
	}).show();
}

function getErrorMessageTemplate(tmpObj)
{
	var tmpTable = 'Your selection cannot be associated with this segment.<br>Possible reasons could be:<br>';
	for (var key = 0; key < tmpObj.length; key++)
	{
		if (key == "title") continue ;
		var errorMessage = tmpObj[key];
		tmpTable += '<span style="font-weight:bold">* </span>'+errorMessage;
		if(key != tmpObj.length - 1)
		{
			tmpTable += '<br>';
		}
	}
	return tmpTable;
}



