/*
 * Note that this control will most likely remain as an example, and not as a core Ext form
 * control.  However, the API will be changing in a future release and so should not yet be
 * treated as a final, stable API at this time.
 */

/**
 * A control that allows selection of between two Ext.ux.form.MultiSelect controls.
 */
Ext.define('Ext.ux.OptGroupItemSelectorSm', {
	extend: 'Ext.ux.OptGroup.OptGroupItemSelector',
	alias: ['widget.optgroupitemselectorsmfield','widget.optgroupitemselectorsm'],
	alternateClassName: ['Ext.ux.OptGroupItemSelectorSm'],

	onAddBtnClick : function() {
		var IncludeExcludeCmp = Ext.getCmp('itemselectComp');
		var me = this,
			selected = me.getSelections(me.fromField.boundList);

		if (selected.length == 0 && (IncludeExcludeCmp != null && IncludeExcludeCmp != "undefined"))
		{
			Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.test.Please select the component(s) to exclude']+".");
		}
		else
		{
			me.moveRec(true, selected);
			me.toField.boundList.getSelectionModel().select(selected);
			me.groupToFieldItems();
			me.fromField.boundList.refresh();
		}
	},

	onRemoveBtnClick : function() {
		var IncludeExcludeCmp = Ext.getCmp('itemselectComp');
		var me = this,
			selected = me.getSelections(me.toField.boundList);

		if (selected.length == 0 && (IncludeExcludeCmp != null && IncludeExcludeCmp != "undefined"))
		{
			Ext.Msg.alert(pageTitle,publicJSON['screenLabels']['admin.test.Please select the component(s) to include']+".");
		}
		else
		{
			me.moveRec(false, selected);
			me.fromField.boundList.getSelectionModel().select(selected);
			me.groupFromFieldItems();
			me.toField.boundList.refresh();
		}
	}
});
