
Ext.define('Ext.ux.form.CustomDragSelector', {
	extend: 'Ext.util.Observable',
	requires: ['Ext.util.Region'],
	alias: 'plugin.ux.customdragselector',

	scrollSpeed: 24,
	lastSelectedIndex : 0,
	isMouseDown : false,
	selectedItemIndex : 0,
	isScrollerRunning : false,
	scrollIncreament : 0,
	scrollTopPosition : 0,
	clickedItem : 0,
	shiftIndex : 0,
	breakLoop : false,
	isControllerRunning : false,
	tempX : 0,
	tempY : 0,
	isFancy : false,

	searchResetDelay : 1000,
	nodeHeight : false,
	rowsPerPage : 0,
	keyCollection : null,
	currentTime : null,
	previousTime : null,
	startIndex : 0,
	lastSearchItem : null,
	lastKeySelection : null,
	selectedIndex : 0,

	constructor: function(config)
	{
		var me = this;
		me.addEvents(
			/**
			 * @event beforemousemove Fires when CustomDragSelector starts
			 * @param {Ext.ux.grid.plugin.CustomDragSelector} this
			 * @param {boundlist} record view
			 * @param {Number} last selected record
			 */
			'mousemovestart',
			/**
			 * @event mousemoveend Fires when CustomDragSelector ends
			 * @param {Ext.ux.grid.plugin.CustomDragSelector} this
			 * @param {boundlist} record view
			 * @param {Number} last selected record
			 */
			'mousemoveend'
		);
		me.callParent([config]);
	},

	init: function(boundList)
	{
		var me = this;
		me.view = boundList;
		me.selModel = me.view.getSelectionModel();
		me.view.mon(me.view, 'render', me.onRender, me);
		me.view.mon(me.view, 'itemmouseenter', me.onItemMouseEnter, me);
		me.view.mon(me.view, 'itemmouseleave', me.onItemMouseLeave, me);
		me.view.mon(me.view, 'itemmouseup', me.onItemMouseUp,me);
		me.view.mon(me.view, 'itemmousedown', me.onItemMouseDown, me);
		//me.view.mon(me.view, 'mouseover', me.onItemMouseOver, me);
		me.view.addListener('afterrender', me.registerKeyEvents, me);
		//me.view.store.on('load', me.calcRowsPerPage, me); // for time being commented out.
	},

	onItemMouseOver : function()
	{
	},

	documentMouseUp : function(e)
	{
		var me = this;
		me.isMouseDown = false;
		me.selectedItemIndex = 0;
		me.isScrollerRunning = false;
		Ext.EventManager.removeListener(document,'mouseup',me.documentMouseUp,me);
		Ext.EventManager.removeListener(document,'mousemove',me.documentMouseMove,me);
		
	},

	onItemMouseEnter : function(obj, record, item, index, e, eOpts)
	{
		var me = this;
		if (me.isControllerRunning == true)
		{
			me.breakLoop = true;
		}
		me.isControllerRunning = false;
		me.scrollTopPosition = 0;
		if (me.isMouseDown == true)
		{
			me.doSelectHighlightedItem(obj,record, item, index, e);
		}
		return false;
	},

	doSelectHighlightedItem : function(obj,record, item, index, e)
	{
		var me = this;
		var isActionEnabled = true;
		if (index < me.lastSelectedIndex && index >= me.clickedItem)
		{
			isActionEnabled = false;
			me.selModel.deselect(me.lastSelectedIndex);
			me.lastSelectedIndex = index;
		}
		else if (index > me.lastSelectedIndex && index <= me.clickedItem)
		{
			isActionEnabled = false;
			me.selModel.deselect(me.lastSelectedIndex);
			me.lastSelectedIndex = index;
		}

		if (index != me.clickedItem && isActionEnabled)
		{
			if (me.selModel.isSelected(index))
			{
				me.selModel.deselect(index);
				me.lastSelectedIndex = index;
			}
			else
			{
				me.selModel.select(index, true);
				me.lastSelectedIndex = index;
				//me.view.highlightItem(item);
			}
		}
	},

	onItemMouseLeave : function(obj, record, item, index, e, eOpts)
	{
		this.isControllerRunning = false;
		return false;
	},

	onItemMouseUp : function(obj, record, item, index, e, eOpts)
	{
		var me = this;
		me.isMouseDown = false;
		me.isControllerRunning = false;
		me.breakLoop = true;
		me.scrollTopPosition = 0;
		Ext.EventManager.removeListener(document.body, 'mousemove', this.getMouseXY, me);
		if (e.hasModifier())
		{
			if (e.ctrlKey)
			{
				me.doCTRLSelection(index);
			}
			else if (e.shiftKey)
			{
				me.doSHIFTSelection(index);
			}
		}
	},

	doCTRLSelection : function(index)
	{
		var me = this;
		if (me.selModel.isSelected(index))
		{
			me.selModel.deselect(index);
		}
		else
		{
			me.selModel.select(index, true);
		}
	},

	doSHIFTSelection : function(index)
	{
		var me = this;
		me.selModel.deselectAll();
		if (index > me.shiftIndex)
		{
			for (var i = me.shiftIndex;i<=index;i++)
			{
				me.selModel.select(i, true);
			}
		}
		else
		{
			for (var i = index;i<=me.shiftIndex;i++)
			{
				me.selModel.select(i, true);
			}
		}
	},

	onItemMouseDown : function(obj, record, item, index, e, eOpts)
	{
		var me = this;
		me.selModel.suspendEvents(false);
		if (!e.hasModifier())
		{
			me.shiftIndex = index;
			me.deselectAllItems();
			me.selModel.select(index, true);
			me.isMouseDown = true;
		}

		me.selectedIndex = index;
		me.scrollTopPosition = 0;
		me.isControllerRunning = false;
		me.lastSelectedIndex = index;
		me.clickedItem = index;
		me.breakLoop = false;
		Ext.getBody().addCls('textunselectable');
		me.view.clearHighlight();
		Ext.EventManager.addListener(document, 'mouseup', this.getMouseUP, me);
		Ext.EventManager.addListener(document.body, 'mousemove', this.getMouseXY, me);
	},

	getMouseUP : function()
	{
		var me =this;
		me.isMouseDown = false;
		me.isControllerRunning = false;
		me.breakLoop = true;
		me.scrollTopPosition = 0;
		me.selModel.resumeEvents();
		me.selModel.fireEvent('selectionchange', me.selModel, me.selModel.getSelection());
		me.view.removeManagedListener(me.view.getTargetEl(), 'click', me.view.handleEvent, me.view);
		Ext.EventManager.removeListener(document.body, 'mousemove', this.getMouseXY, me);
		Ext.EventManager.removeListener(document, 'mouseup', this.getMouseUP, me);
	},

	processListElements : function()
	{
		var me = this;
		var count = me.clickedItem;
		while(count <= me.lastSelectedIndex)
		{
			me.selModel.select(count, true);
			count++;
		}
	},

	documentMouseMove : function(e)
	{
		var me = this;
		var xAxis = e.getPageX();
		var yAxis = e.getPageY();
		var boundListRegion = this.view.getRegion();
		if (me.isScrollerRunning)
		{
			return;
		}

		if(yAxis >= boundListRegion.bottom + 5)
		{
			me.isScrollerRunning = true;
			me.scrollOnMouseMove('bottom');
		}

		if(yAxis <= boundListRegion.top - 5)
		{
			me.isScrollerRunning = true;
			me.scrollOnMouseMove('top');
		}
	},

	getNodeHeight : function(itemIndex)
	{
		var me = this;
		return (Ext.fly(me.view.getNode(itemIndex)).getHeight() - 5);
	},

	getMouseXY : function(e)
	{
		var me = this;
		e.preventDefault();
		var target = e.getTarget(); // same as t (the target HTMLElement)

		me.tempX = e.getPageX();
		me.tempY = e.getPageY();
		if (me.isControllerRunning == true)
		{
			return;
		}

		var boudListSelctionObj = me.view.getSelectionModel();
		if (me.tempX < 0){me.tempX = 0}
		if (me.tempY < 0){me.tempY = 0}  

		//var boindListOuterDiv = $('#'+me.view.getId() + "-listEl");
		//var topmargin = boindListOuterDiv.offset().top;
		//var bottommargin = topmargin + boindListOuterDiv.outerHeight(true); //true is necessary to include the margins

		if(me.tempY >= this.view.listEl.getRegion().bottom + 5)
		{
			me.breakLoop = false;
			me.isControllerRunning = true;
			me.isScrollingBottom = true;
			me.scrollTopPosition = 0;
			if (this.isFancy)
			{
				var pane = $("#" + this.view.getId() + "-outerEl");
				var elt = pane.jScrollPane();
				var apii = elt.data('jsp');
				me.smoothFancyScroll(e,'bottom',apii);
			}
			else
			{
				me.scrollOnMouseMove(e,'bottom');
			}
		}

		if(me.tempY <= this.view.listEl.getRegion().top  - 5)
		{
			me.breakLoop = false;
			me.isScrollingBottom = false;
			me.isControllerRunning = true;
			me.scrollTopPosition = 0;
			if (this.isFancy)
			{
				var pane = $("#" + this.view.getId() + "-outerEl");
				var elt = pane.jScrollPane();
				var apii = elt.data('jsp');
				me.lastSelectedIndex = me.lastSelectedIndex + 1;
				me.smoothFancyScroll(e,'top',apii);
			}
			else
			{
				me.lastSelectedIndex = me.lastSelectedIndex + 1;
				me.scrollOnMouseMove(e,'top');
			}
		}
		return true;
	},

	smoothFancyScroll : function(e,scrollPosition,apii)
	{
		var me = this;
		if (scrollPosition == "bottom")
		{
			if (me.breakLoop)
			{
				me.scrollTopPosition = 0;
				return;
			}

			if (me.lastSelectedIndex > me.view.getStore().getCount() -1)
			{
				return;
			}

			var nodeHeight = Ext.fly(me.view.getNode(me.lastSelectedIndex)).getHeight();
			if (me.scrollTopPosition == 0)
			{
				var boindListOuterDiv = $('#'+me.view.getId() + "-outerEl").find(".jspPane");
				var htmlDiv = Ext.get(me.view.getId() + "-outerEl").select('.jspPane');

				var positionY = htmlDiv.first().getStyle('top',true);
				positionY = positionY.substring(0,positionY.indexOf("px"));
				positionY = Ext.String.trim(positionY);
				positionY = parseInt(positionY);
				var posNum = (positionY < 0) ? positionY * -1 : positionY;
				me.scrollTopPosition = posNum;
			}

			me.scrollTopPosition = me.scrollTopPosition + nodeHeight;

			$('#'+me.view.getId() + "-outerEl").animate({scrollTop: me.scrollTopPosition}, me.scrollSpeed, function() {

				if (me.breakLoop)
				{
					me.scrollTopPosition = 0;
					return;
				}
				me.lastSelectedIndex++;
				if (me.lastSelectedIndex>=me.view.getStore().getCount())
				{
					return;
				}

				if (me.lastSelectedIndex != me.clickedItem)
				{
					if (me.selModel.isSelected(me.lastSelectedIndex))
					{
						me.selModel.deselect(me.lastSelectedIndex);
					}
					else
					{
						me.selModel.select(me.lastSelectedIndex, true);
					}
				}
				//var positioinY = me.getOffsetY(me.view,me.lastSelectedIndex);
				apii.scrollToY(me.scrollTopPosition);
				me.smoothFancyScroll(e,'bottom',apii);
			});
		}
		else
		{
			if (me.breakLoop)
			{
				me.scrollTopPosition = 0;
				return;
			}

			if (me.lastSelectedIndex < 0)
			{
				return;
			}

			var nodeHeight = Ext.fly(me.view.getNode(me.lastSelectedIndex)).getHeight();
			if (me.scrollTopPosition == 0)
			{
				var boindListOuterDiv = $('#'+me.view.getId() + "-outerEl").find(".jspPane");
				var htmlDiv = Ext.get(me.view.getId() + "-outerEl").select('.jspPane');

				var positionY = htmlDiv.first().getStyle('top',true);
				positionY = positionY.substring(0,positionY.indexOf("px"));
				positionY = Ext.String.trim(positionY);
				positionY = parseInt(positionY);
				var posNum = (positionY < 0) ? positionY * -1 : positionY;
				me.scrollTopPosition = posNum;
			}
			me.scrollTopPosition = me.scrollTopPosition - nodeHeight;
			$('#'+me.view.getId() + "-outerEl").animate({scrollTop: me.scrollTopPosition}, me.scrollSpeed, function() {

				if (me.breakLoop)
				{
					me.scrollTopPosition = 0;
					return;
				}

				me.lastSelectedIndex--;

				if (me.lastSelectedIndex < 0)
				{
					return;
				}
						
				if (me.lastSelectedIndex != me.clickedItem)
				{
					if (me.selModel.isSelected(me.lastSelectedIndex))
					{
						me.selModel.deselect(me.lastSelectedIndex);
					}
					else
					{
						me.selModel.select(me.lastSelectedIndex, true);
					}
				}
				apii.scrollToY(me.scrollTopPosition);
				me.smoothFancyScroll(e,'top',apii);
			});
		}
	},

	scrollOnMouseMove : function(e,scrollPosition)
	{
		var me = this;
		if (scrollPosition == "bottom")
		{
			if (me.breakLoop)
			{
				me.scrollTopPosition = 0;
				return;
			}

			if (me.lastSelectedIndex > me.view.getStore().getCount() -1)
			{
				return;
			}

			if (me.scrollTopPosition == 0)
			{
				var positionY = parseInt(me.view.listEl.getScroll().top);
				var posNum = (positionY < 0) ? positionY * -1 : positionY;
				me.scrollTopPosition = posNum;
				delete positionY;
				delete posNum;
			}
			if (Ext.isIE)
			{
				me.scrollTopPosition = me.scrollTopPosition + me.getOffsetY(me.view,me.lastSelectedIndex);
			}
			else
			{
				var nodeHeight = Ext.fly(me.view.getNode(me.lastSelectedIndex)).getHeight();
				me.scrollTopPosition = me.scrollTopPosition + nodeHeight ;
			}
			$('#'+me.view.getId() + "-listEl").animate({scrollLeft: 0}, 6 ,function() {

				if (me.breakLoop)
				{
					me.scrollTopPosition = 0;
					return;
				}
				me.lastSelectedIndex++;
				if (me.lastSelectedIndex>=me.view.getStore().getCount())
				{
					return;
				}

				if (me.lastSelectedIndex != me.clickedItem)
				{
					if (me.selModel.isSelected(me.lastSelectedIndex))
					{
						me.selModel.deselect(me.lastSelectedIndex);
					}
					else
					{
						me.selModel.select(me.lastSelectedIndex, true);
					}
				}
				//me.view.listEl.scrollChildIntoView(me.view.getNode(me.lastSelectedIndex), false);
				me.view.getTargetEl().scrollTo("top",me.scrollTopPosition);
				me.scrollOnMouseMove(e,'bottom');
			});
		}
		else
		{
			if (me.breakLoop)
			{
				me.scrollTopPosition = 0;
				return;
			}

			if (me.lastSelectedIndex < 0)
			{
				return;
			}

			if (me.scrollTopPosition == 0)
			{
				var positionY = parseInt(me.view.getTargetEl().getScroll().top);
				var posNum = (positionY < 0) ? positionY * -1 : positionY;
				me.scrollTopPosition = posNum;
				delete positionY;
				delete posNum;
			}
			
			if (Ext.isIE)
			{
				//var position = parseInt(me.getScrollPosition(me.view.getNode(me.lastSelectedIndex),me.view));
				var position = parseInt(me.getOffsetY(me.view,me.lastSelectedIndex));
				position = (position < 0) ? position * -1 : position;
				if (position > 0)
				{
					me.scrollTopPosition = me.scrollTopPosition - position;
					me.scrollTopPosition = me.scrollTopPosition;
				}
			}
			else
			{
				var nodeHeight = Ext.fly(me.view.getNode(me.lastSelectedIndex)).getHeight();
				me.scrollTopPosition = me.scrollTopPosition - nodeHeight ;
			}

			$('#'+me.view.getId() + "-listEl").animate({scrollLeft: 0}, 6, function() {

				if (me.breakLoop)
				{
					me.scrollTopPosition = 0;
					return;
				}

				me.lastSelectedIndex--;

				if (me.lastSelectedIndex < 0)
				{
					return;
				}
						
				if (me.lastSelectedIndex != me.clickedItem)
				{
					if (me.selModel.isSelected(me.lastSelectedIndex))
					{
						me.selModel.deselect(me.lastSelectedIndex);
					}
					else
					{
						me.selModel.select(me.lastSelectedIndex, true);
					}
				}
				me.view.getTargetEl().scrollTo("top",me.scrollTopPosition);
				//me.view.listEl.scrollChildIntoView(me.view.getNode(me.lastSelectedIndex), false);
				me.scrollOnMouseMove(e,'top');
			});
		}
	},

	getScrollPosition : function(container,view)
	{
		container = Ext.getDom(container) || Ext.getBody().dom;
		var el = view.listEl.dom,
			offsets = view.listEl.getOffsetsTo(container),
		// el's box
			left = offsets[0] + container.scrollLeft,
			top = offsets[1] + container.scrollTop,
			bottom = top + el.offsetHeight,
			right = left + el.offsetWidth,
		// ct's box
			ctClientHeight = container.clientHeight,
			ctScrollTop = parseInt(container.scrollTop, 10),
			ctScrollLeft = parseInt(container.scrollLeft, 10),
			ctBottom = ctScrollTop + ctClientHeight,
			ctRight = ctScrollLeft + container.clientWidth,
			newPos;


		if (el.offsetHeight > ctClientHeight || top < ctScrollTop) {
			newPos = top;
		} else if (bottom > ctBottom) {
			newPos = bottom - ctClientHeight;
		}
		return newPos;
	},

	getOffsetY : function(boundList,rec)
	{
		var node = boundList.getNode(rec),
			el = boundList.el,
			adjustmentY = 0,
			adjustmentX = 0,
			elRegion = boundList.listEl.getRegion(),
			nodeRegion;

		// DOM client dimensions
		elRegion.bottom = elRegion.top + el.dom.clientHeight;
		elRegion.right = elRegion.left + el.dom.clientWidth;
		if (node) {
			nodeRegion = Ext.fly(node).getRegion();
			// node is above
			if (nodeRegion.top < elRegion.top) {
				adjustmentY = nodeRegion.top - elRegion.top;
			// node is below
			} else if (nodeRegion.bottom > elRegion.bottom) {
				adjustmentY = nodeRegion.bottom - elRegion.bottom;
			}
		}
		return adjustmentY;
	},

	deselectAllItems : function()
	{
		this.selModel.deselectAll();
	},

	onRender: function()
	{
		this.scrollIncreament = 0;
		this.lastSelectedIndex = 0;
		this.keyCollection = '';
	},

	registerKeyEvents : function()
	{
		var me = this;
		Ext.EventManager.addListener(me.view.id+"-inputEl", 'keypress', this.handleKeyPress,me);
		Ext.EventManager.addListener(me.view.id+"-inputEl", 'keydown', this.handleKeyDown,me);
		Ext.EventManager.addListener(me.view.id+"-listEl", 'click', this.handleContainerClick,me);
	},

	handleKeyDown : function(e,t)
	{
		var me = this;
		var keyCode = e.getKey();
		if (keyCode == Ext.EventObject.UP)
		{
			me.up();
		}
		else if (keyCode == Ext.EventObject.DOWN)
		{
			me.down();
		}
		else if (keyCode == Ext.EventObject.HOME)
		{
			me.home();
		}
		else if (keyCode == Ext.EventObject.END)
		{
			me.end();
		}
		else if (keyCode == Ext.EventObject.PAGE_UP)
		{
			me.selectPrevPage();
		}
		else if (keyCode == Ext.EventObject.PAGE_DOWN)
		{
			me.selectNextPage();
		}
	},

	selectPrevPage : function() 
	{
		if( !this.nodeHeight ) {
			return;
		}
		var index = Math.max(this.selectedIndex-this.rowsPerPage, 0);
		this.highlightAt(index);
		Ext.get(this.view.id+"-inputEl").focus(true);
		this.selectedIndex = index;
	},

	selectNextPage : function() 
	{
		if( !this.nodeHeight ) {
			return;
		}
		var index = Math.min(this.selectedIndex+this.rowsPerPage, this.view.store.getCount() - 1);
		this.highlightAt(index);
		Ext.get(this.view.id+"-inputEl").focus(true);
		this.selectedIndex = index;
	},

	calcRowsPerPage : function() 
	{
		var me = this;
		if( me.view.store.getCount() ) {
			me.nodeHeight = Ext.fly(me.view.getNode(0)).getHeight();
			//me.boundList.listEl.dom.clientHeight;
			me.rowsPerPage = Math.round(me.view.getHeight() / me.nodeHeight);
			me.rowsPerPage = me.rowsPerPage - 1;
		}
		else 
		{
			me.nodeHeight = false;
		}
	},

	up: function() 
	{
		var me = this,
			boundList = me.view,
			allItems = boundList.all,
			oldItem = boundList.highlightedItem,
			oldItemIdx = oldItem ? boundList.indexOf(oldItem) : -1,
			newItemIdx = oldItemIdx > 0 ? oldItemIdx - 1 : allItems.getCount() - 1; //wraps around

		if ((newItemIdx == allItems.getCount() - 1) && me.selectedIndex != 0)
		{
			newItemIdx = me.selectedIndex - 1;
		}
		me.highlightAt(newItemIdx);
		Ext.get(me.view.id+"-inputEl").focus(true);
		me.selectedIndex = newItemIdx;
	},

	down: function() 
	{
		var me = this,
			boundList = me.view,
			allItems = boundList.all,
			oldItem = boundList.highlightedItem,
			oldItemIdx = oldItem ? boundList.indexOf(oldItem) : -1,
			newItemIdx = oldItemIdx < allItems.getCount() - 1 ? oldItemIdx + 1 : 0; //wraps around

		if (newItemIdx == 0 && me.selectedIndex < allItems.getCount()-1)
		{
			newItemIdx = me.selectedIndex + 1;
		}
		me.highlightAt(newItemIdx);
		Ext.get(me.view.id+"-inputEl").focus(true);
		me.selectedIndex = newItemIdx;
	},

	home: function() 
	{
		this.highlightAt(0);
		this.selectedIndex = 0;
	},

	end: function() 
	{
		var me = this;
		me.highlightAt(me.view.all.getCount() - 1);
		me.selectedIndex = me.view.all.getCount() - 1;
	},

	highlightAt: function(index) 
	{
		var boundList = this.view,
			item = boundList.all.item(index);
		if (item) {
			item = item.dom;
			boundList.highlightItem(item);

			if (this.isFancy)
			{
				var positioinY = this.getOffsetY(boundList,index);
				var pane = $("#" + this.view.getId() + "-outerEl");
				var elt = pane.jScrollPane();
				api = elt.data('jsp');
				//api.scrollByY(positioinY);
				api.scrollToY(positioinY);
			}
			else
			{
				boundList.getTargetEl().scrollChildIntoView(item, false);
			}
		}
	},

	handleContainerClick : function()
	{
		var me = this;
		Ext.get(me.view.id+"-inputEl").focus(true);
	},

	handleKeyPress : function (e,t) // e is not a standard event object, it is a Ext.EventObject
	{ 
		
		var me = this;
		e.preventDefault();
		var target = e.getTarget(); // same as t (the target HTMLElement)
		var keyCode = e.getKey();
		if( (e.hasModifier() && !e.shiftKey) || e.isNavKeyPress() || e.isSpecialKey() ) {
			return;
		}

		me.currentTime = new Date().getTime();
		if (me.previousTime == null || me.previousTime == undefined || me.previousTime.length == 0)
		{
			me.previousTime = new Date().getTime();
		}

		if (((me.currentTime - me.previousTime) > me.searchResetDelay) & keyCode != me.lastKeySelection)
		{
			me.keyCollection = "";
			me.previousTime = me.currentTime;
		}

		if (keyCode != me.lastKeySelection)
		{
			me.keyCollection = me.keyCollection + String.fromCharCode(keyCode);
		}

		me.lastKeySelection = keyCode;
		me.keyCollection = me.keyCollection.toLowerCase();
		if (me.lastSearchItem == me.keyCollection)
		{
			me.startIndex++;
		}
		else
		{
			me.startIndex = 0;
		}

		var record = me.view.getStore().find(me.view.displayField, me.keyCollection,me.startIndex);
		me.lastSearchItem  = me.keyCollection;
		if (record >= 0) {
			me.startIndex = record;
			me.selectedIndex = me.startIndex;
			me.view.suspendEvents(true);
			me.view.getSelectionModel().select(record);
			me.view.resumeEvents();
			if (me.isFancy)
			{
				var positioinY = me.getOffsetY(me.view,record);
				var pane = $("#" + this.view.getId() + "-outerEl");
				var elt = pane.jScrollPane();
				api = elt.data('jsp');
				api.scrollToY(positioinY);
			}
			else
			{
				//me.view.listEl.scrollChildIntoView(me.view.getNode(record), false);
				me.view.getTargetEl().scrollChildIntoView(me.view.getNode(record), false);
			}

			me.view.highlightItem(me.view.getNode(record));
		}
		else
		{
			me.startIndex = 0;
			me.selectedIndex = 0;
		}
		return false;
	}
});





