/*
 * Note that this control will most likely remain as an example, and not as a core Ext form
 * control.  However, the API will be changing in a future release and so should not yet be
 * treated as a final, stable API at this time.
 */

/**
 * A control that allows selection of between two Ext.ux.form.MultiSelect controls.
 */

Ext.define('Ext.ux.form.ItemSelector', {
    extend: 'Ext.ux.form.MultiSelect',
    alias: ['widget.itemselectorfield', 'widget.itemselector'],
    alternateClassName: ['Ext.ux.ItemSelector'],
    requires: [
        'Ext.button.Button',
        'Ext.ux.form.MultiSelect'
    ],
	gap:22,
    /**
     * @cfg {Boolean} [hideNavIcons=false] True to hide the navigation icons
     */
    hideNavIcons:false,

    /**
     * @cfg {Array} buttons Defines the set of buttons that should be displayed in between the ItemSelector
     * fields. Defaults to <tt>['top', 'up', 'add', 'remove', 'down', 'bottom']</tt>. These names are used
     * to build the button CSS class names, and to look up the button text labels in {@link #buttonsText}.
     * This can be overridden with a custom Array to change which buttons are displayed or their order.
     */
    buttons: ['top', 'up', 'add', 'remove', 'down', 'bottom'],

    /**
     * @cfg {Object} buttonsText The tooltips for the {@link #buttons}.
     * Labels for buttons.
     */
    buttonsText: {
        top: "Move to Top",
        up: "Move Up",
        add: "Add to Selected",
        remove: "Remove from Selected",
        down: "Move Down",
        bottom: "Move to Bottom"
    },

    initComponent: function() {
        var me = this;

        me.ddGroup = me.id + '-dd';
		//me.addListener('afterlayout',me.getScrollMultiselect,false);
        me.callParent();

        // bindStore must be called after the fromField has been created because
        // it copies records from our configured Store into the fromField's Store
        me.bindStore(me.store);
    },
	getScrollMultiselect:function(field){
		var ii = this.toField.getStore().getCount();
		getParentHeight = Ext.get(field.id).getHeight();
		getParentWidth = Ext.get(field.id).getWidth();
		fieldID = Ext.getCmp(field.id).getComponent(0).getComponent(0).id;
		var gt = Ext.getCmp(field.id).getComponent(0).id;
		var tt = Ext.getCmp(gt).getHeight() - 28;
		var countCon = Ext.getCmp(field.id).getStore().getCount();
		if(ii == 0 ){
		$('#'+this.toField.id+' .x-boundlist-outer-ct').css({'width':getParentWidth+'px','overflow':'hidden'});
		}
		Ext.get(field.id).select('.x-boundlist-outer-ct').setHeight(tt);
		$('#'+fieldID+' .x-boundlist-outer-ct').css({'width':getParentWidth+'px','overflow':'auto'});
		$('#'+fieldID+' .x-boundlist-list-ct').css({'height':'auto','overflow':'hidden'});

		$('#'+fieldID+' .x-boundlist-outer-ct').jScrollPane();
	},
    createList: function(title){
        var me = this;
	var widthOfTrigger = (me.width/2) - me.gap;
        return Ext.create('Ext.ux.form.MultiSelect', {
            submitValue: false,
            flex: 1,
           // dragGroup: me.ddGroup,
           // dropGroup: me.ddGroup,
            title: title,
			tbar:[{
					xtype: 'trigger',
					cls:'whitedropdown_search',
					trigger1Cls: 'x-form-clear-trigger',
					trigger2Cls: 'x-form-search-trigger',
					emptyText: 'Search',
					padding:3,
					//flex:1,
					width: widthOfTrigger-6,
					getTriggerMarkup: function() 
					{
						var me = this,
						i = 0,
						hideTrigger = (me.readOnly || me.hideTrigger),
						triggerCls,
						triggerBaseCls = me.triggerBaseCls,
						triggerConfigs = [],
						unselectableCls = Ext.dom.Element.unselectableCls,
						style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
						//style = (hideTrigger ? 'display:none;' : ''),
						cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
						// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
						// single triggerCls config. Should rethink this, perhaps something more structured like a list of
						// trigger config objects that hold cls, handler, etc.
						// triggerCls is a synonym for trigger1Cls, so copy it.

						if (!me.trigger1Cls) {
							me.trigger1Cls = me.triggerCls;
						}
						// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : this.id+'_MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : this.id+'_MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								 });
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					},
					onTrigger1Click : function() 
					{
						this.reset();
					},
					onTrigger2Click : function() 
					{
						var value = this.getValue();
						if (value == "" || value.length == 0)
						{
							Ext.get(this.id+'_MyTrigger_0').setStyle('display','none');
							Ext.get(this.id+'_MyTrigger_1').setStyle('display','block');
						}
						else
						{
							Ext.get(this.id+'_MyTrigger_1').setStyle('display','none');
							Ext.get(this.id+'_MyTrigger_0').setStyle('display','block');
						}

						Ext.get(this.id).setWidth((widthOfTrigger - me.gap)-6);

						if (value == "" || value.length == 0)
						{
							this.up('multiselect').store.clearFilter();
						}
						else
						{
							this.up('multiselect').store.clearFilter();
							var filterLogic = new Ext.util.Filter({
								filterFn: function(item) {
									var testName = item.get('displayField');
									var dispName = testName; //publicJson.displayTestJsonObj[testName];
									if (dispName.toLowerCase().indexOf(value.toLowerCase()) != -1)
									{
										return true
									}
								}
							});
							this.up('multiselect').store.filter(filterLogic);
						}
						this.up('multiselect').doLayout();
					},
					listeners: {
						change : function() 
						{
							var value = this.getValue();
							if (value == "" || value.length == 0)
							{
								Ext.get(this.id+'_MyTrigger_0').setStyle('display','none');
								Ext.get(this.id+'_MyTrigger_1').setStyle('display','block');
							}
							else
							{
								Ext.get(this.id+'_MyTrigger_1').setStyle('display','none');
								Ext.get(this.id+'_MyTrigger_0').setStyle('display','block');
							}

							Ext.get(this.id).setWidth((widthOfTrigger - me.gap)-6);

							if (value == "" || value.length == 0)
							{
								this.up('multiselect').store.clearFilter();
							}
							else
							{
								this.up('multiselect').store.clearFilter();
								var filterLogic = new Ext.util.Filter({
									filterFn: function(item) {
										var testName = item.get('displayField');
										var dispName = testName; //publicJson.displayTestJsonObj[testName];
										if (dispName.toLowerCase().indexOf(value.toLowerCase()) != -1)
										{
											return true
										}
									}
								});
								this.up('multiselect').store.filter(filterLogic);
							}

							this.up('multiselect').doLayout();
						}
						
					}
				}],
            store: {
                model: me.store.model,
                data: []
            },
            displayField: me.displayField,
            disabled: me.disabled,
            listeners: {
                boundList: {
                    scope: me,
                    itemdblclick: me.onItemDblClick,
                    drop: me.syncValue
                }
            }
        });
    },

    setupItems: function() {
        var me = this;

        me.fromField = me.createList(me.fromTitle);
        me.toField = me.createList(me.toTitle);

        return {
            border: false,
            layout: {
                type: 'hbox',
                align: 'stretch'
            },
            items: [
                me.fromField,
                {
                    xtype: 'container',
                    margins: '0 4',
                    width: 24,
                    layout: {
                        type: 'vbox',
                        pack: 'center'
                    },
                    items: me.createButtons()
                },
                me.toField
            ]
        };
    },

    createButtons: function(){
        var me = this,
            buttons = [];

        if (!me.hideNavIcons) {
            Ext.Array.forEach(me.buttons, function(name) {
                buttons.push({
                    xtype: 'button',
					// This listeners added for common use of button tool tip with yellow color style -- Start
					listeners:{
						'afterrender':function(){
							Ext.create("Ext.tip.ToolTip",{
								target:this.id,
								anchor:"top",
								cls:"yellowTip",
								trackMouse:true,
								html:me.buttonsText[name]
							});
						}
					},
					// end here
                    //tooltip: me.buttonsText[name],
                    handler: me['on' + Ext.String.capitalize(name) + 'BtnClick'],
                    cls: Ext.baseCSSPrefix + 'form-itemselector-btn',
                    iconCls: Ext.baseCSSPrefix + 'form-itemselector-' + name,
                    navBtn: true,
					width:16,
					height:16,
					padding:'1 0 0 3',
					scope: me,
                    margin: '6 4 0 4'
                });
            });
        }
        return buttons;
    },

    /**
     * Get the selected records from the specified list.
     *
     * Records will be returned *in store order*, not in order of selection.
     * @param {Ext.view.BoundList} list The list to read selections from.
     * @return {Ext.data.Model[]} The selected records in store order.
     *
     */
    getSelections: function(list) {
        var store = list.getStore();

        return Ext.Array.sort(list.getSelectionModel().getSelection(), function(a, b) {
            a = store.indexOf(a);
            b = store.indexOf(b);

            if (a < b) {
                return -1;
            } else if (a > b) {
                return 1;
            }
            return 0;
        });
    },

    onTopBtnClick : function() {
		//code for Enabled Links

        var enabledlist = this.toField.boundList,
		enabledstore = enabledlist.getStore(),
		enabledselected = this.getSelections(enabledlist);
		enabledstore.suspendEvents();
        enabledstore.remove(enabledselected, true);
        enabledstore.insert(0, enabledselected);
        enabledstore.resumeEvents();
        enabledlist.refresh();
        this.syncValue();
        enabledlist.getSelectionModel().select(enabledselected);


		//code for Disabled Links
		var disabledlist = this.fromField.boundList,
		disabledstore = disabledlist.getStore(),
		disabledselected = this.getSelections(disabledlist);

        disabledstore.suspendEvents();
        disabledstore.remove(disabledselected, true);
        disabledstore.insert(0, disabledselected);
        disabledstore.resumeEvents();
        disabledlist.refresh();
        this.syncValue();
        disabledlist.getSelectionModel().select(disabledselected);
    },

    onBottomBtnClick : function() {
        var enabledlist = this.toField.boundList,
            enabledstore = enabledlist.getStore(),
            enabledselected = this.getSelections(enabledlist);

        enabledstore.suspendEvents();
        enabledstore.remove(enabledselected, true);
        enabledstore.add(enabledselected);
        enabledstore.resumeEvents();
        enabledlist.refresh();
        this.syncValue();
        enabledlist.getSelectionModel().select(enabledselected);

		// code for disabled Links
		var disabledlist = this.fromField.boundList,
            disabledstore = disabledlist.getStore(),
            disabledselected = this.getSelections(disabledlist);

        disabledstore.suspendEvents();
        disabledstore.remove(disabledselected, true);
        disabledstore.add(disabledselected);
        disabledstore.resumeEvents();
        disabledlist.refresh();
        this.syncValue();
        disabledlist.getSelectionModel().select(disabledselected);
    },

    onUpBtnClick : function() {
		//code for enable Links
        var enabledlist = this.toField.boundList,
            enabledstore = enabledlist.getStore(),
            enabledselected = this.getSelections(enabledlist),
            rec,
            i = 0,
            len = enabledselected.length,
            index = 0;

        // Move each selection up by one place if possible
        enabledstore.suspendEvents();
        for (; i < len; ++i, index++) {
            rec = enabledselected[i];
            index = Math.max(index, enabledstore.indexOf(rec) - 1);
            enabledstore.remove(rec, true);
            enabledstore.insert(index, rec);
        }
        enabledstore.resumeEvents();
        enabledlist.refresh();
        this.syncValue();
        enabledlist.getSelectionModel().select(enabledselected);

		//disabled Links
		var disabledlist = this.fromField.boundList,
            disabledstore = disabledlist.getStore(),
            disabledselected = this.getSelections(disabledlist),
            rec,
            i = 0,
            len = disabledselected.length,
            index = 0;

        // Move each selection up by one place if possible
        disabledstore.suspendEvents();
        for (; i < len; ++i, index++) {
            rec = disabledselected[i];
            index = Math.max(index, disabledstore.indexOf(rec) - 1);
            disabledstore.remove(rec, true);
            disabledstore.insert(index, rec);
        }
        disabledstore.resumeEvents();
        disabledlist.refresh();
        this.syncValue();
        disabledlist.getSelectionModel().select(disabledselected);
    },

    onDownBtnClick : function() {
		//Enable Links
        var enabledlist = this.toField.boundList,
            enabledstore = enabledlist.getStore(),
            enabledselected = this.getSelections(enabledlist),
            rec,
            i = enabledselected.length - 1,
            index = enabledstore.getCount() - 1;

        // Move each selection down by one place if possible
        enabledstore.suspendEvents();
        for (; i > -1; --i, index--) {
            rec = enabledselected[i];
            index = Math.min(index, enabledstore.indexOf(rec) + 1);
            enabledstore.remove(rec, true);
            enabledstore.insert(index, rec);
        }
        enabledstore.resumeEvents();
        enabledlist.refresh();
        this.syncValue();
        enabledlist.getSelectionModel().select(enabledselected);

		//disable Links
		var disabledlist = this.fromField.boundList,
            disabledstore = disabledlist.getStore(),
            disabledselected = this.getSelections(disabledlist),
            rec,
            i = disabledselected.length - 1,
            index = disabledstore.getCount() - 1;

        // Move each selection down by one place if possible
        disabledstore.suspendEvents();
        for (; i > -1; --i, index--) {
            rec = disabledselected[i];
            index = Math.min(index, disabledstore.indexOf(rec) + 1);
            disabledstore.remove(rec, true);
            disabledstore.insert(index, rec);
        }
        disabledstore.resumeEvents();
        disabledlist.refresh();
        this.syncValue();
        disabledlist.getSelectionModel().select(disabledselected);
    },

    onAddBtnClick : function() {
        var me = this,
            selected = me.getSelections(me.fromField.boundList);

        me.moveRec(true, selected);
        me.toField.boundList.getSelectionModel().select(selected);
    },

    onRemoveBtnClick : function() {
        var me = this,
            selected = me.getSelections(me.toField.boundList);

        me.moveRec(false, selected);
        me.fromField.boundList.getSelectionModel().select(selected);
    },

    moveRec: function(add, recs) {
        var me = this,
            fromField = me.fromField,
            toField   = me.toField,
            fromStore = add ? fromField.store : toField.store,
            toStore   = add ? toField.store   : fromField.store;

        fromStore.suspendEvents();
        toStore.suspendEvents();
        fromStore.remove(recs);
        toStore.add(recs);
        fromStore.resumeEvents();
        toStore.resumeEvents();

        fromField.boundList.refresh();
        toField.boundList.refresh();
  
		// search box reset code - starts
		if (fromField.boundList.getStore().isFiltered())
    	{
			var fromFieldTrigger = this.fromField.down('triggerfield').getValue() ;
			if (!Ext.isEmpty(fromFieldTrigger))
			{
				this.fromField.down('triggerfield').setValue('');
			}
		}

		if (toField.boundList.getStore().isFiltered())
		{
			var toFieldTrigger = this.toField.down('triggerfield').getValue() ;
			if (!Ext.isEmpty(toFieldTrigger))
			{
				this.toField.down('triggerfield').setValue('');
			}
		}
		// search box reset code - ends

        me.syncValue();
    },

    // Synchronizes the submit value with the current state of the toStore
    syncValue: function() {
        var me = this;
        me.mixins.field.setValue.call(me, me.setupValue(me.toField.store.getRange()));
    },

    onItemDblClick: function(view, rec) {
        this.moveRec(view === this.fromField.boundList, rec);
    },

    setValue: function(value) {
        var me = this,
            fromField = me.fromField,
            toField = me.toField,
            fromStore = fromField.store,
            toStore = toField.store,
            selected;

        // Wait for from store to be loaded
        if (!me.fromStorePopulated) {
            me.fromField.store.on({
                load: Ext.Function.bind(me.setValue, me, [value]),
                single: true
            });
            return;
        }

        value = me.setupValue(value);
        me.mixins.field.setValue.call(me, value);

        selected = me.getRecordsForValue(value);

        // Clear both left and right Stores.
        // Both stores must not fire events during this process.
        fromStore.suspendEvents();
        toStore.suspendEvents();
        fromStore.removeAll();
        toStore.removeAll();

        // Reset fromStore
        me.populateFromStore(me.store);

        // Copy selection across to toStore
        Ext.Array.forEach(selected, function(rec){
            // In the from store, move it over
            if (fromStore.indexOf(rec) > -1) {
                fromStore.remove(rec);
            }
            toStore.add(rec);
        });

        // Stores may now fire events
        fromStore.resumeEvents();
        toStore.resumeEvents();

        // Refresh both sides and then update the app layout
        Ext.suspendLayouts();
        fromField.boundList.refresh();
        toField.boundList.refresh();
        Ext.resumeLayouts(true);
    },

    onBindStore: function(store, initial) {
        var me = this;

        if (me.fromField) {
            me.fromField.store.removeAll()
            me.toField.store.removeAll();

            // Add everything to the from field as soon as the Store is loaded
            if (store.getCount()) {
                me.populateFromStore(store);
            } else {
                me.store.on('load', me.populateFromStore, me);
            }
        }
    },

    populateFromStore: function(store) {
        var fromStore = this.fromField.store;

        // Flag set when the fromStore has been loaded
        this.fromStorePopulated = true;

        fromStore.add(store.getRange());

        // setValue waits for the from Store to be loaded
        fromStore.fireEvent('load', fromStore);
    },

    onEnable: function(){
        var me = this;

        me.callParent();
        me.fromField.enable();
        me.toField.enable();

        Ext.Array.forEach(me.query('[navBtn]'), function(btn){
            btn.enable();
        });
    },

    onDisable: function(){
        var me = this;

        me.callParent();
        me.fromField.disable();
        me.toField.disable();

        Ext.Array.forEach(me.query('[navBtn]'), function(btn){
            btn.disable();
        });
    },

    onDestroy: function(){
        this.bindStore(null);
        this.callParent();
    }
});
