/*
 * Note that this control will most likely remain as an example, and not as a core Ext form
 * control.  However, the API will be changing in a future release and so should not yet be
 * treated as a final, stable API at this time.
 */

/**
 * A control that allows selection of between two Ext.ux.form.MultiSelect controls.
 */

Ext.define('Ext.ux.form.ItemSelectorForMashreq', {
	extend: 'Ext.ux.form.ItemSelector',
    alias: ['widget.itemselectorformashreq', 'widget.itemselectormashreq'],
	alternateClassName: ['Ext.ux.ItemSelectorSI'],
	gap:22,
	createList: function(title){
		var me = this;
		var widthOfTrigger = (me.width/2) - me.gap;
		return Ext.create('Ext.ux.form.MultiSelectSI', {
			submitValue: false,
			flex: 1,
			//dragGroup: me.ddGroup,
		   // dropGroup: me.ddGroup,
			title: title,
			tbar:[{
					xtype: 'trigger',
					cls:'whitedropdown_search',
					trigger1Cls: 'x-form-clear-trigger',
					trigger2Cls: 'x-form-search-trigger',
					emptyText: 'Search',
					//flex:1,
					width: widthOfTrigger,
					getTriggerMarkup: function() 
					{
						var me = this,
						i = 0,
						hideTrigger = (me.readOnly || me.hideTrigger),
						triggerCls,
						triggerBaseCls = me.triggerBaseCls,
						triggerConfigs = [],
						unselectableCls = Ext.dom.Element.unselectableCls,
						style = 'width:' + me.triggerWidth + 'px;' + (hideTrigger ? 'display:none;' : ''),
						//style = (hideTrigger ? 'display:none;' : ''),
						cls = me.extraTriggerCls + ' ' + Ext.baseCSSPrefix + 'trigger-cell ' + unselectableCls;
						// TODO this trigger<n>Cls API design doesn't feel clean, especially where it butts up against the
						// single triggerCls config. Should rethink this, perhaps something more structured like a list of
						// trigger config objects that hold cls, handler, etc.
						// triggerCls is a synonym for trigger1Cls, so copy it.

						if (!me.trigger1Cls) {
							me.trigger1Cls = me.triggerCls;
						}
						// Create as many trigger elements as we have trigger<n>Cls configs, but always at least one
						for (i = 0; (triggerCls = me['trigger' + (i + 1) + 'Cls']) || i < 1; i++) {
							if (i == 0)
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : this.id+'_MyTrigger_'+i,
									style: style + "display:none;",
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								});
							}
							else
							{
								triggerConfigs.push({
									tag: 'td',
									role: 'presentation',
									valign: 'top',
									cls: cls,
									id : this.id+'_MyTrigger_'+i,
									style: style,
									cn: {
										cls: [Ext.baseCSSPrefix + 'trigger-index-' + i, triggerBaseCls, triggerCls].join(' '),
										role: 'presentation'
									}
								 });
							}
						}
						triggerConfigs[0].cn.cls += ' ' + triggerBaseCls + '-first';
						return Ext.DomHelper.markup(triggerConfigs);
					},
					onTrigger1Click : function() 
					{
						this.reset();
					},
					onTrigger2Click : function() 
					{
						var value = this.getValue();
						if (value == "" || value.length == 0)
						{
							Ext.get(this.id+'_MyTrigger_0').setStyle('display','none');
							Ext.get(this.id+'_MyTrigger_1').setStyle('display','block');
						}
						else
						{
							Ext.get(this.id+'_MyTrigger_1').setStyle('display','none');
							Ext.get(this.id+'_MyTrigger_0').setStyle('display','block');
						}

						Ext.get(this.id).setWidth(widthOfTrigger - me.gap);

						if (value == "" || value.length == 0)
						{
							this.up('multiselect').store.clearFilter();
						}
						else
						{
							this.up('multiselect').store.clearFilter();
							var filterLogic = new Ext.util.Filter({
								filterFn: function(item) {
									var testName = item.get('displayField');
									var dispName = testName; //publicJson.displayTestJsonObj[testName];
									if (dispName.toLowerCase().indexOf(value.toLowerCase()) != -1)
									{
										return true
									}
								}
							});
							this.up('multiselect').store.filter(filterLogic);
						}
						this.up('multiselect').doLayout();
					},
					listeners: {
						change : function() 
						{
							var value = this.getValue();
							if (value == "" || value.length == 0)
							{
								Ext.get(this.id+'_MyTrigger_0').setStyle('display','none');
								Ext.get(this.id+'_MyTrigger_1').setStyle('display','block');
							}
							else
							{
								Ext.get(this.id+'_MyTrigger_1').setStyle('display','none');
								Ext.get(this.id+'_MyTrigger_0').setStyle('display','block');
							}

							Ext.get(this.id).setWidth(widthOfTrigger - me.gap);

							if (value == "" || value.length == 0)
							{
								this.up('multiselect').store.clearFilter();
							}
							else
							{
								this.up('multiselect').store.clearFilter();
								var filterLogic = new Ext.util.Filter({
									filterFn: function(item) {
										var testName = item.get('displayField');
										var dispName = testName; //publicJson.displayTestJsonObj[testName];
										if (dispName.toLowerCase().indexOf(value.toLowerCase()) != -1)
										{
											return true
										}
									}
								});
								this.up('multiselect').store.filter(filterLogic);
							}
							this.up('multiselect').doLayout();
						}
						
					}
				}],
			store: {
				model: me.store.model,
				data: []
			},
			displayField: me.displayField,
			disabled: me.disabled,
			listeners: {
				boundList: {
					scope: me,
					itemdblclick: me.onItemDblClick,
					drop: me.syncValue
				}
			}
		});
	},
	/**
	 * Get the selected records from the specified list.
	 *
	 * Records will be returned *in store order*, not in order of selection.
	 * @param {Ext.view.BoundList} list The list to read selections from.
	 * @return {Ext.data.Model[]} The selected records in store order.
	 *
	 */
	getSelections: function(list) {
		var store = list.getStore();

		return Ext.Array.sort(list.getSelectionModel().getSelection(), function(a, b) {
			a = store.indexOf(a);
			b = store.indexOf(b);

			if (a < b) {
				return -1;
			} else if (a > b) {
				return 1;
			}
			return 0;
		});
	},

	onTopBtnClick : function() {
		var list = this.toField.boundList,
			store = list.getStore(),
			selected = this.getSelections(list);

		store.suspendEvents();
		store.remove(selected, true);
		store.insert(0, selected);
		store.resumeEvents();
		list.refresh();
		this.syncValue();
		list.getSelectionModel().select(selected);
	},

	onBottomBtnClick : function() {
		var list = this.toField.boundList,
			store = list.getStore(),
			selected = this.getSelections(list);

		store.suspendEvents();
		store.remove(selected, true);
		store.add(selected);
		store.resumeEvents();
		list.refresh();
		this.syncValue();
		list.getSelectionModel().select(selected);
	},

	onUpBtnClick : function() {
		var list = this.toField.boundList,
			store = list.getStore(),
			selected = this.getSelections(list),
			rec,
			i = 0,
			len = selected.length,
			index = 0;

		// Move each selection up by one place if possible
		store.suspendEvents();
		for (; i < len; ++i, index++) {
			rec = selected[i];
			index = Math.max(index, store.indexOf(rec) - 1);
			store.remove(rec, true);
			store.insert(index, rec);
		}
		store.resumeEvents();
		list.refresh();
		this.syncValue();
		list.getSelectionModel().select(selected);
	},

	onDownBtnClick : function() {
		var list = this.toField.boundList,
			store = list.getStore(),
			selected = this.getSelections(list),
			rec,
			i = selected.length - 1,
			index = store.getCount() - 1;

		// Move each selection down by one place if possible
		store.suspendEvents();
		for (; i > -1; --i, index--) {
			rec = selected[i];
			index = Math.min(index, store.indexOf(rec) + 1);
			store.remove(rec, true);
			store.insert(index, rec);
		}
		store.resumeEvents();
		list.refresh();
		this.syncValue();
		list.getSelectionModel().select(selected);
	}
});



