Ext.define('widgets.ChartParentPanel', {
	extend: 'Ext.panel.Panel',
	alias: 'widget.chartparentpanel',
	requires:['widgets.ChartPanel'],
	margin:'10 0 0 0',
	defaults:{
		columnWidth: 0.5,
		height: 235
	},
	layout:'column',
	manageOverflow:2,
	data:'',
	id:'',
	config: {
		 data: null
	},
    constructor: function(config) {
         this.initConfig(config);
         this.callParent(arguments);
    },
	initComponent: function() {
         var me = this,item=[];
		// @ render the chart panel
		me.renderChart(me.data)
        me.callParent(arguments);
    },
	chartPanelObj:function(){
		return { xtype:'chartpanel'}
	},
	updateChart: function(objdata) {
		 var me = this;
		 if(!Ext.isEmpty(objdata))
		 {
			for (var i= 0; i <  objdata.length;i++ )
			{
				var jsonDataObj=null;
				try
				{
					jsonDataObj=objdata[i][0];

					if(jsonDataObj == undefined || jsonDataObj == null)
						jsonDataObj=objdata[i];
				}
				catch (ee)
				{
					jsonDataObj=objdata[i];
				}
				
				if(jsonDataObj == undefined || jsonDataObj == null)
					continue;
				var chartObj_id = '';
				try
				{
					chartObj_id = 'chartParent_'+me.id+'_'+jsonDataObj.chartCId+'_'+i;
				}
				catch (et)
				{
					chartObj_id = 'chartParent_'+me.id+'_'+i;
				}
				if(chartObj_id.indexOf("(") != -1)
					chartObj_id = chartObj_id.replace("(","LB")

				if(chartObj_id.indexOf(")") != -1)
					chartObj_id = chartObj_id.replace(")","RB")
				
				var chartTypo = 'Bar';
				if(!Ext.isEmpty(jsonDataObj.chartType))
					chartTypo = jsonDataObj.chartType;

				if(!Ext.isEmpty(Ext.getCmp(chartObj_id)))
				{
					if(!Ext.isEmpty(jsonDataObj) && !Ext.isEmpty(jsonDataObj.showTime))
					{
						labelVal = jsonDataObj.showTime;
						Ext.getCmp(chartObj_id+'_label').setText(labelVal);
					}				
					Ext.getCmp(chartObj_id).updateChart(chartObj_id+'-body',jsonDataObj,chartTypo);
				}
			}
		 }
     },
	renderChart:function(objdata){
		var me = this,chartitemArry=[],margin="";
		try
		{
			if(!Ext.isEmpty(me.ifRes) && me.ifRes)
				me.margin = 0;
			if(!Ext.isEmpty(me.ifBro) && me.ifBro)
				me.margin = 0;
		}
		catch (ert)
		{
		}

		if(!Ext.isEmpty(objdata))
		{
			Ext.suspendLayouts();
			for (var i= 0; i <  objdata.length;i++ )
			{
				var jsonDataObj=null;
				var jsonComboObj=null;
				try
				{
					jsonDataObj=objdata[i][0];

					jsonComboObj=objdata[i][1];
					if(jsonDataObj == undefined || jsonDataObj == null)
					{
						jsonDataObj=objdata[i];
						jsonComboObj=objdata[i];
					}
				}
				catch (ee)
				{
					jsonDataObj=objdata[i];
					jsonComboObj=objdata[i];
				}

				if(jsonDataObj == undefined || jsonDataObj == null)
					continue;
				var isOdd=false;
				if(i%2 == 0)
				{
					margin = '0 10 10 0';
					isOdd=true;
				}
				else
				{
					margin = '0 1 10 0';
					isOdd=false;
				}
				
				var chartObj_id = '';
				try
				{
					chartObj_id = 'chartParent_'+me.id+'_'+jsonDataObj.chartCId+'_'+i;
				}
				catch (et)
				{
					chartObj_id = 'chartParent_'+me.id+'_'+i;
				}

				var defaultheight = 235; 
				if(!Ext.isEmpty(jsonDataObj.showMaxMin) && jsonDataObj.showMaxMin)
				{
					defaultheight = 315;
				}
				var chartTypeObj = '';
				var nameObj = '';
				if(jsonDataObj.chartType != undefined && jsonDataObj.chartType != null){
					chartTypeObj = jsonDataObj.chartType;
				}else{
					chartTypeObj = jsonDataObj.chart;
				}
				try{
					if(jsonDataObj.name != undefined && jsonDataObj.name != null)
						nameObj = jsonDataObj.name;
					else
						nameObj = jsonDataObj.title;

					if(nameObj != undefined && nameObj != null && (nameObj.indexOf("(") != -1 && nameObj.indexOf(")") != -1))
					{
						var tempnameObj = '';
						tempnameObj = nameObj.substring(nameObj.indexOf("("),nameObj.indexOf(")")+1);
						nameObj = nameObj.replace(tempnameObj,"<span class='font_normal12 fontStyleRobotRegular'>"+tempnameObj+"</span>")
					}
				}catch(ert){

				}

				var isAlertsid = false;
				if(me.isAlerts != undefined && me.isAlerts != null && me.isAlerts)
					isAlertsid = true;
				
				if(chartObj_id.indexOf("(") != -1)
					chartObj_id = chartObj_id.replace("(","LB")

				if(chartObj_id.indexOf(")") != -1)
					chartObj_id = chartObj_id.replace(")","RB")
				
				var isUxid = false;
				if(me.ifUx != undefined && me.ifUx != null && me.ifUx)
					isUxid = true;
				var isBroid = false;
				if(me.ifBro != undefined && me.ifBro != null && me.ifBro)
					isBroid = true;
				
				var ifLogOnid = false;
				if(me.ifLogOn != undefined && me.ifLogOn != null && me.ifLogOn)
					ifLogOnid = true;
				var isSAP = false;
				if(me.isSAP != undefined && me.isSAP != null && me.isSAP)
					isSAP = true;
				
				if(isUxid)
				{
					defaultheight = 355;
				}
				if(ifLogOnid)
				{
					defaultheight = 267;
				}
				if(isSAP)
				{
					defaultheight = 205;
				}


				var showComboBar=false;
				var showLabelL=false;
				var labelVal="";
				if(jsonComboObj!=null && jsonComboObj!=undefined && jsonComboObj.Title)
				{
					nameObj=jsonComboObj.Title;
				}
				else if(jsonComboObj!=null && jsonComboObj!=undefined && jsonComboObj.heading)
				{
					nameObj=jsonComboObj.heading
				}

				var comboArrayStore=new Array();
				var selectedComboValue=null;
				if(!Ext.isEmpty(jsonComboObj) && !Ext.isEmpty(jsonComboObj.comboArray))
				{
					showComboBar=true;
					comboArrayStore = jsonComboObj.comboArray;
					selectedComboValue = jsonComboObj.selectedComboItem;
				}
				
				if(!Ext.isEmpty(jsonComboObj) && !Ext.isEmpty(jsonComboObj.showTime))
				{
					showLabelL=true;
					labelVal = jsonComboObj.showTime;
				}
				
				var comBoObjVal = null;
				if(!Ext.isEmpty(jsonDataObj.chartComboBarId)){
					comBoObjVal = jsonDataObj.chartComboBarId;
				}
				if(isSAP)
				{
					chartitemArry.push(Ext.apply(me.chartPanelObj(), {
						"title": nameObj,
						"data":jsonDataObj,
						"id":chartObj_id,
						"height":defaultheight,
						"width":'100%',
						"indexVal":i,
						"historyData":"",
						margin:0,
						"isOdd":isOdd,
						"isAlerts":isAlertsid,
						"ifUx":isUxid,
						"ifBro":isBroid,
						"ifLogOn":ifLogOnid,
						"isSAP":isSAP,
						"chartType": chartTypeObj,
						"legendPosition": ""
					}));
				}else{
					var columnWidth = 0.5
					if(isBroid)
					{
						margin = 0;
						columnWidth = 0.33333;
						if(chartTypeObj == "TopNGrid")
						{
							columnWidth = 0.6666
						}
					}

					chartitemArry.push(Ext.apply(me.chartPanelObj(), {
						"title": nameObj,
						"data":jsonDataObj,
						"id":chartObj_id,
						"height":defaultheight,
						"indexVal":i,
						//"id":objdata[i].chartCId,
						//"historyData":objdata[i].chartMinMax,
						"historyData":"",
						margin:margin,
						"isOdd":isOdd,
						"isAlerts":isAlertsid,
						"ifUx":isUxid,
						"ifBro":isBroid,
						"ifLogOn":ifLogOnid,
						tools:[
							{
								xtype:'label',
								cls:'font_bold9 grayColor',
								hidden:(!showLabelL),
								id:chartObj_id+'_label',
								text:labelVal
							},
							{
								xtype: 'combo',
								fieldLabel:'',
								cls:'dropdown',
								labelSeparator:'',
								width:100,
								//labelWidth:130,
								labelStyle: {'white-space':'nowrap;'},
								//name:'TimeLineId',
								hidden:(!showComboBar),
								//id:chartObj_id+'_combo',
								id:comBoObjVal,
								comboIdVal:chartObj_id+'_combo',
								//comboIdVal:comBoObjVal,
								//id:'TimeLineId',
								//labelAlign:'top',
								margin:"0 0 0 0",
								displayField : 'name',
								valueField : 'value',
								queryMode : 'local',
								store:Ext.create('Ext.data.Store',{
									data : comboArrayStore,
									fields:['name','value']
								}),
								value:selectedComboValue,
								jsonValue:jsonComboObj,
								listeners: {
									change: function(ele, newValue, oldValue) 
									{
										//if (newValue != oldValue && newValue != ele.lastSelectEvent) 
											//doWork();

										var TimeLineObj = Ext.getCmp('TimeLineId');
										var time_line = null;
										if(TimeLineObj!=null && TimeLineObj!=undefined)
										{
											time_line = TimeLineObj.getValue();
										}
										if(time_line==null || time_line==undefined || time_line=="")
											time_line="Current";

										var menuObj = Ext.getCmp('dashmenu_model_id');

										var store_data=menuObj.getStore();
										var selected_view_name="";
										for(var k=0;k<store_data.getCount();k++)
										{
											var caption_value=store_data.getAt(k).data.caption;
											if(requestParams.activeViewIndex==k)
											{
												selected_view_name=store_data.getAt(k).data.name;
												break;
											}
										}

										var filterName="";
										var filter_view_name="";
										var dashboardName ="";
										if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Geo_View") 
										{
											var countryComboIdObj = Ext.getCmp('countryComboId');
											var regionComboIdObj = Ext.getCmp('regionComboId');

											if(countryComboIdObj!=null && countryComboIdObj!=undefined)
											{
												var countryFilterName = countryComboIdObj.getValue();
												if(countryFilterName!=null && countryFilterName!=undefined && countryFilterName!="" && countryFilterName!='World')
												{
													filterName = countryFilterName;
													filter_view_name = "Geo_Country_View";
												}
												else if(countryFilterName!=null && countryFilterName!=undefined && countryFilterName!="" && countryFilterName=='World')
												{
													filterName = countryFilterName;
													filter_view_name = "";
												}
											}

											if(regionComboIdObj!=null && regionComboIdObj!=undefined)
											{
												var regionFilterName = regionComboIdObj.getValue();
												if(regionFilterName!=null && regionFilterName!=undefined && regionFilterName!="" && regionFilterName!='AllRegion' && regionFilterName!='World')
												{
													filterName = regionFilterName;
													filter_view_name = "Geo_Region_View";
												}
												else if(regionFilterName!=null && regionFilterName!=undefined && regionFilterName!="" && regionFilterName!='AllRegion' && regionFilterName=='World')
												{
													filterName = countryFilterName;
													filter_view_name = "";
												}
											}

											if(filterName==null || filterName==undefined || filterName=="")
												filterName="";
										}
										else if(!Ext.isEmpty(selected_view_name) && selected_view_name.trim() == "Overview_View")
										{
											dashboardName = Ext.getCmp('dashListComId').getValue();
											filterName = "World";
											filter_view_name = "";
										}

										var selectedVariableStr=this.jsonValue.selectedVariable;
										var selectedTokenStr=this.jsonValue.selectedToken;
										var selectedComboItemStr=this.jsonValue.selectedComboItem;

										if(selectedVariableStr==null || selectedVariableStr==undefined || selectedVariableStr==" ")
											selectedVariableStr="";

										if(selectedTokenStr==null || selectedTokenStr==undefined || selectedTokenStr==" ")
											selectedTokenStr="";

										if(selectedComboItemStr==null || selectedComboItemStr==undefined || selectedComboItemStr==" ")
											selectedComboItemStr="";

										if(selectedTokenStr != undefined && selectedTokenStr != null && selectedTokenStr != "")
											selectedTokenStr = parent.filterEncode(selectedTokenStr);
										
										if(newValue != undefined && newValue != null && newValue != "")
											newValue = parent.filterEncode(newValue);
											

										var onchangeurl="/final/servlet/com.eg.EgCommonDashboardController?iniName=eg_citrixdashboard&user_name="+encodeURI(user_name)+"&action=loadViewData&subject="+encodeURI(dashboard)+"&time_line="+encodeURI(time_line)+"&isUserBased=true&view_name="+encodeURI(selected_view_name)+"&filterName="+encodeURI(filterName)+"&filterViewName="+encodeURI(filter_view_name)+"&selectedVariable="+encodeURIComponent(selectedVariableStr)+"&selectedToken="+encodeURIComponent(selectedTokenStr)+"&selectedMeasure="+encodeURIComponent(newValue);

										if(dashboard_mapping != undefined && dashboard_mapping != null && dashboard_mapping != "null" && dashboard_mapping != "")
											onchangeurl += "&dashboard_mapping="+encodeURIComponent(dashboard_mapping);

										if(isFromHomePage || isFromHomePage == 'true')
											onchangeurl += "&fromServiceHomePage="+isFromHomePage+"&appliesTo="+userMappingApplisTo;

										Ext.Ajax.request({
											url : onchangeurl,
											method : 'POST',
											scope:this,
											comboIdValue:this.comboIdVal,
											timeout:280000,
											success : function(response, opts)
											{
												var onchangeJsonText = response.responseText;
												if(onchangeJsonText!=null && onchangeJsonText!=undefined)
												{
													var onchangeJsonData = Ext.decode(onchangeJsonText);	
													try
													{
														objdata = onchangeJsonData.loadViewDetails[0].Overview_Block_3_Value;
														if(Ext.isEmpty(objdata) || objdata == undefined || objdata == null)
															objdata = onchangeJsonData.loadViewDetails[0].Geo_Block_4_Value;	
													}
													catch (e)
													{
														objdata = onchangeJsonData.loadViewDetails[0].Geo_Block_4_Value;
													}
													
													objdata = onchangeJsonData.loadViewDetails[0].Overview_Block_3_Value;
													if(Ext.isEmpty(objdata) || objdata == undefined || objdata == null)
														objdata = onchangeJsonData.loadViewDetails[0].Geo_Block_4_Value;
													//var me = this;
													 if(!Ext.isEmpty(objdata))
													 {
														for (var i= 0; i <  objdata.length;i++ )
														{
															var jsonDataObj=null;
															try
															{
																jsonDataObj=objdata[i][0];

																if(jsonDataObj == undefined || jsonDataObj == null)
																	jsonDataObj=objdata[i];
															}
															catch (ee)
															{
																jsonDataObj=objdata[i];
															}

															if(jsonDataObj == undefined || jsonDataObj == null)
																continue;
															//var chartObj_id = 'chartParent_'+me.id+'_'+jsonDataObj.chartCId+'_'+i;
															var temp_chartObj_id_combo = this.comboIdVal;
															if(!Ext.isEmpty(temp_chartObj_id_combo) && temp_chartObj_id_combo.indexOf("_combo") != -1)
																temp_chartObj_id_combo = temp_chartObj_id_combo.substring(0,temp_chartObj_id_combo.indexOf("_combo"));
															
															if(temp_chartObj_id_combo.indexOf("(") != -1)
																temp_chartObj_id_combo = temp_chartObj_id_combo.replace("(","LB")

															if(temp_chartObj_id_combo.indexOf(")") != -1)
																temp_chartObj_id_combo = temp_chartObj_id_combo.replace(")","RB")
															
															if(!Ext.isEmpty(Ext.getCmp(temp_chartObj_id_combo)))
															{
																Ext.getCmp(temp_chartObj_id_combo).updateChart(temp_chartObj_id_combo+'-body',jsonDataObj,'Bar');
															}
														}
													 }
												}
											},
											failure:function()
											{
											}
										});
									},
								}
							}
						],
						"chartType": chartTypeObj,
						"columnWidth":columnWidth,
						"legendPosition": ""
					}));
				}
			}
			me.items = chartitemArry;
			Ext.resumeLayouts(true);
		}
	 }
 })