Ext.define('widgets.SessionsParentPanel',{
	extend: 'Ext.panel.Panel',
	alias: 'widget.sessionsparentpanel',
	requires:['widgets.ChartPanel',"citrixDashboard.view.OverviewPanel", 'citrixDashboard.view.GeoStaticPanel','citrixDashboard.view.SessionsConnected','citrixDashboard.view.EstablishedSessions','citrixDashboard.view.SessionsState','citrixDashboard.view.CommonGrid','citrixDashboard.view.SessionMapDetails'],
	margin:'0 0 0 0',
	defaults:{
		columnWidth: 0.5,
	},
	layout:'column',
	manageOverflow:2,
	height: 1072,
	//items:[],
	config: {
	data: null
	},
	constructor: function(config) {
		this.initConfig(config);
		this.callParent(arguments);
	},
	initComponent: function() {
		var me = this,item=[];
		me.callParent(arguments);
	},	
	updatePanelData:function(Jdata){
		var margin="";
		if(!Ext.isEmpty(Jdata) && Jdata.length == 4){
			this.renderSessions('',margin,Jdata[1].Sessions_Block_1_Value,true);
			this.renderUsersConnected('',margin,Jdata[2].Sessions_Block_2_Value,true);
			this.renderSessionsLogging('',margin,Jdata[3].Sessions_Block_3_Value,true);
		}
	},
	listeners:{
		'afterrender':function(panel){
			var margin="";
			var Jadata = this.data;
			if(!Ext.isEmpty(Jadata) && Jadata.length == 4){
				this.renderSessions(panel,margin,Jadata[1].Sessions_Block_1_Value);
				this.renderUsersConnected(panel,margin,Jadata[2].Sessions_Block_2_Value);
				this.renderSessionsLogging(panel,margin,Jadata[3].Sessions_Block_3_Value);
			}				
		},
	},
	renderSessions:function(panel,margin,SSdata,update){
		if(!Ext.isEmpty(update) && update)
		{
			try
			{
				var sessionsconnec_idObj = Ext.getCmp("renderSessions_sessionsconnected_Id");
				var establishedsess_idObj = Ext.getCmp("renderSessions_establishedsessions_id");
				var sessionsstate_idObj = Ext.getCmp("renderSessions_sessionsstate_Id");
				if(!Ext.isEmpty(SSdata[0].chartType) && SSdata[0].chartType == "StackedArea"){
					if(!Ext.isEmpty(sessionsconnec_idObj))					
						sessionsconnec_idObj.updateData(SSdata[0]);
				}else if(!Ext.isEmpty(SSdata[0][0])){
					var sessionsconnec_header_idObj = Ext.getCmp("renderSessions_sessionsconnected_header_Id");
					if(!Ext.isEmpty(sessionsconnec_header_idObj))		
					sessionsconnec_header_idObj.setTitle('<span style="text-transform:capitalize !important;color:#2a292a;font-size: 15px;line-height:17px;">'+SSdata[0][0].name+'</span>');
					if(!Ext.isEmpty(sessionsconnec_idObj))					
						sessionsconnec_idObj.loadData(SSdata[0][0]);
				}
				if(!Ext.isEmpty(establishedsess_idObj))					
					establishedsess_idObj.updateData(SSdata[1][0]);
				if(!Ext.isEmpty(sessionsstate_idObj))						
					sessionsstate_idObj.updateData(SSdata[2][0]);					
			}
			catch (e1)
			{
			}
		}
		else
		{
			var sessionsPanel = new Ext.Panel (
			{
				columnWidth:1.0,					
				layout: 'column',
				border:false,
				frame:false,
				margin:'0 2 8 0',
				height:300,
				autoScroll:false,
				scroll:false,
				items:[{
					xtype:'container',
					//layout:'hbox',
					padding:0,
					columnWidth:0.75,
					items:[
					{
						xtype:'container',
						ui: 'eg-container',
						layout: 'column',
						columnWidth:1.0,
						padding:0,
						border:false,
						frame:false,
						margin:'0 10 4 0',
						autoScroll:false,
						scroll:false,
						items:[],
						listeners:{
							'afterrender':function(e){
								if(!Ext.isEmpty(SSdata) && SSdata.length == 3){
									var me = this;
									if(!Ext.isEmpty(SSdata[0].chartType) && SSdata[0].chartType == "StackedArea"){
									me.add({
										xtype:'sessionsconnected',
										id:'renderSessions_sessionsconnected_Id',
										ui:'eg-x-panel',
										cls:'removePanelShadow',
										title:SSdata[0].heading,
										data:SSdata[0],
										//style:{'border':'1px solid red !important'},
										//data:areaData,
										height:298,
										columnWidth:0.7,	
									});
									}else if(!Ext.isEmpty(SSdata[0][0])){
										me.add({
											xtype:'container',
											height:298,
											columnWidth:0.7,
											layout:{
												type:'vbox',
												align:'stretch'
											},
											listeners:{
												'afterrender':function(){
												var me = this;
												me.add({
													xtype:'commongrid',
													id:'renderSessions_sessionsconnected_Id',
													ui:'eg-x-panel',
													cls:'removePanelShadow',
													height:275,
													columnWidth:0.7,
													ifSessions:true,
													data:SSdata[0][0],
													margin:'10 10 0 10'
												});
												}	
											}
										});
									}

									me.add({
										xtype:'establishedsessions',
										ifSess:true,
										ui:'eg-x-panel',
										cls:'removePanelShadow',
										id:'renderSessions_establishedsessions_id',
										title:'<center><span>'+SSdata[1][0].heading+'</span></center>',
										height:298,
										columnWidth:0.3,
										data:SSdata[1][0]
									});
								}
							}
						}
					}
					]
				},
				{
					xtype:'container',
					ui: 'eg-container',
					columnWidth:0.25,
					border:false,
					frame:false,
					margin:'0 0 2 0',
					autoScroll:false,
					scroll:false,
					items:[],
					listeners:
					{
						'afterrender':function(e)
						{
							var me = this;
							me.add(
							{
								xtype:'sessionsstate',
								id:'renderSessions_sessionsstate_Id',
								ui:'eg-x-panel',
								layout:'fit',
								padding:'0 10 0 5',
								cls:'removePanelShadow',
								height:298,
								title:SSdata[2][0].heading,
								Jdata:SSdata[2][0],
								data:SSdata[2][0]
							}
							);						
						}
					}
				}
				]
			}
			);

			this.add(sessionsPanel);
		}
	},
	renderUsersConnected:function(panel,margin,USdata,update){
		if(!Ext.isEmpty(update) && update)
		{
			try
			{
				var sessionsusersconnec_idObj = Ext.getCmp("renderUsersConnected_establisheduserConn_id");
				var geo_static_panel_forSessions_idObj = Ext.getCmp("geo_static_panel_forSessions");
				var session_id_mapdetails_idObj = Ext.getCmp("session_id_mapdetails");
				if(!Ext.isEmpty(sessionsusersconnec_idObj))					
				sessionsusersconnec_idObj.updateData(USdata[0][0]);
				if(!Ext.isEmpty(geo_static_panel_forSessions_idObj))					
				geo_static_panel_forSessions_idObj.updateData(USdata[1]);
				if(!Ext.isEmpty(session_id_mapdetails_idObj))						
				session_id_mapdetails_idObj.updateData(USdata[1]);					
			}
			catch (e1)
			{
				console.log("e1=-=->",e1)
			}
		}
		else
		{
		var usersPanel = new Ext.Panel (
		{
			xtype:'panel',
			ui: 'eg-x-panel',
			columnWidth:1.0,					
			layout: 'hbox',
			border:false,
			//style:{'border':'1px solid red'},
			frame:false,
			margin:'0 2 8 0',
			padding:'0 20 5 0',
			//bodyPadding:'30 0 0 0',
			height:380,
			autoScroll:false,
			scroll:false,
			items:[],
			listeners:{
				'afterrender':function(e){
				var me = this;
				try
				{
					me.add({
						xtype:'establishedsessions',
						ifSess:true,
						title:USdata[0][0].heading,
						ui:'eg-x-panel',
						cls:'removePanelShadow',
						id:'renderUsersConnected_establisheduserConn_id',
						height:380,
						bodyPadding:'50 0 0 0',
						flex:0.25,
						data:USdata[0][0]
						//data:donutData
					},{
						//xtype:'geopanel',
						xtype:'geostaticpanel',
						id:'geo_static_panel_forSessions',
						height:380,
						flex:0.55,
						padding:'40 40 30 0',
						jsonData:USdata[1],
						mapStyle:strRumSkin == "Dark"?'dark':'light', //light,dark,default
						mapType:'styled_map',  //'roadmap', 'satellite', 'hybrid', 'terrain', 'styled_map',
						markers :[{lat: 35.682805, lng: 139.756735, title: "Tokyo", url: '-'}],
						center: {
							lat: 35.605568, // Marker latitude
							lng:139.335907 // Marker longitude
						}
					},
					{
						flex:0.2,
						xtype:'sessionmapdetails',
						height:250,
						id:'session_id_mapdetails',
						jsonData:USdata[1],
					});					
				}
				catch (er)
				{
				}											
				}
			}
		}
		);

		this.add(usersPanel);
		}
	},
	renderSessionsLogging:function(panel,margin,slData,update){
		if(!Ext.isEmpty(update) && update)
		{
			try
			{
			var sessionsPanel_headerId_idObj = Ext.getCmp("sessionsPanel_headerId");
			var sesP_history_grid_id1_idObj = Ext.getCmp("sessionsconnected_minmax_history_grid_id1");
			var renderSessionsLogging_Id_idObj = Ext.getCmp("renderSessionsLogging_Id");
			var renderSessionsLoggingGrid_Id_idObj = Ext.getCmp("renderSessionsLoggingGrid_Id");
			var sessionsPanel1_headerId_idObj = Ext.getCmp("sessionsPanel1_headerId");
			var sessionsgrid_grid_id1_idObj = Ext.getCmp("sessionsgrid_minmax_history_grid_id1");
			var sesionCompletedId1_id_idObj = Ext.getCmp("sesionCompletedId1_id");
			if(!Ext.isEmpty(slData[0].chartType) && slData[0].chartType == "StackedArea"){
				if(!Ext.isEmpty(sessionsPanel_headerId_idObj))					
					sessionsPanel_headerId_idObj.setTitle(slData[0].heading);
				if(!Ext.isEmpty(sesP_history_grid_id1_idObj))					
					sesP_history_grid_id1_idObj.store.loadRawData(slData[0].maxmin);
				if(!Ext.isEmpty(renderSessionsLogging_Id_idObj))					
					renderSessionsLogging_Id_idObj.updateData(slData[0]);
			}else if(!Ext.isEmpty(slData[0][0])){
				if(!Ext.isEmpty(sessionsPanel_headerId_idObj))					
					sessionsPanel_headerId_idObj.setTitle(slData[0][0].name);
				if(!Ext.isEmpty(sesP_history_grid_id1_idObj))					
					sesP_history_grid_id1_idObj.store.loadRawData(slData[0][0].maxmin);
				if(!Ext.isEmpty(renderSessionsLoggingGrid_Id_idObj))					
					renderSessionsLoggingGrid_Id_idObj.loadData(slData[0][0]);
			}
			if(!Ext.isEmpty(sessionsPanel1_headerId_idObj))					
				sessionsPanel1_headerId_idObj.setTitle(slData[1][0].name);
			if(!Ext.isEmpty(sessionsgrid_grid_id1_idObj))			
				sessionsgrid_grid_id1_idObj.store.loadRawData(slData[1][0].maxmin);
			if(!Ext.isEmpty(sesionCompletedId1_id_idObj))						
				sesionCompletedId1_id_idObj.loadData(slData[1][0]);					
			}
			catch (e1)
			{
			}			
		}
		else
		{
			var sessionsPanel = new Ext.Panel (
			{
				xtype:'panel',
				columnWidth:1.0,					
				layout: 'column',
				border:false,
				frame:false,
				margin:'0 1 8 0',
				height:420,
				autoScroll:false,
				scroll:false,
				id:'sessionsPanel',
				//style:{'border':'1px solid green'},
				items:[{
					xtype:'panel',
					ui: 'eg-x-panel',
					//cls:'removePanelShadow',
					height:373,
					bodyPadding:'10 20 0 20',
					margin:'0 8 2 0',
					columnWidth:0.5,
					layout:{
						type:'vbox',
						align:'stretch'
					},
					items:[],
					listeners:{
						'afterrender':function(e){
							var me = this;
							if(!Ext.isEmpty(slData[0].chartType) && slData[0].chartType == "StackedArea"){
								me.setTitle(slData[0].heading);
								me.add(
									addChartHistorytemp(slData[0],'sessionsconnected_minmax'),
									{
										xtype:'sessionsconnected',
										height:205,
										id:'renderSessionsLogging_Id',
										ifHeaderNeeded:false,
										data:slData[0],
										margin:'10 0 0 0'
									});								
							}else if(!Ext.isEmpty(slData[0][0])){
								me.setTitle(slData[0][0].name);
								try
								{
									me.add(
										addChartHistorytemp(slData[0][0],'sessionsconnected_minmax'),
										{
											xtype:'commongrid',
											height:190,
											header:true,
											cls:'',
											title:slData[0][0].chartTopNTitle,
											ifSessions:true,
											id:'renderSessionsLoggingGrid_Id',
											data:slData[0][0],
											margin:'20 0 0 0'
										}
									);										
								}
								catch (e1)
								{
								}

							}
						}
					}
				},
				{
					xtype:'panel',
					ui: 'eg-x-panel',
					height:373,
					title:slData[1][0].name,
					bodyPadding:'10 20 10 20',
					margin:'0 2 2 0',
					columnWidth:0.5,
					items:[],
					layout:{
						type:'vbox',
						align:'stretch'
					},
					listeners:{
						'afterrender':function(e){
							var me = this;
							me.add(
							addChartHistorytemp(slData[1][0],'sessionsgrid_minmax'),
							{
								xtype:'commongrid',
								height:190,
								header:true,
								title:slData[1][0].chartTopNTitle,
								ifSessions:true,
								id:'sesionCompletedId1_id',
								data:slData[1][0],
								margin:'20 0 0 0'
							}
							);
						}
					}
				}
				]
			}
			);
			this.add(sessionsPanel);
		}
	}
})

function addChartHistorytemp(tempData,idObj){
	var me = this,historyItems=[];
	var historyTpl1 = '';
	var showSumFlag = false;
	try
	{
		if(!Ext.isEmpty(tempData.maxmin[0].Sum) && tempData.maxmin[0].Sum != undefined && tempData.maxmin[0].Sum != null)
			showSumFlag = true;
	}
	catch (ee)
	{
	}

	if(!showSumFlag)
	{	
		historyTpl1=new Ext.XTemplate(
			'<div class="widgetholders">',
			'<tpl for=".">',
			'<tpl if="xindex % 2 === 0">',
			'<div class="b_box " style="border:0px solid red;width:50%;padding:0 0 0 0 !important;float:left;">',
			'<tpl else>',
			'<div class="b_box " style="border:0px solid red;width:50%;padding:0 25 0 0 !important;float:left;">',
			'</tpl>',
			'<div class="font_normal9 fontStyleRobotRegular grayColor" style="padding:0px 0px 5px 0px"><span>{duration}</ span></div>',
			'<div style="padding-top:14px;height:65px;width:100%" class="chartminmax"><div style="width:48%;float:left;text-align:center">',
			'<div class="font_normal19">{Avg}</div><div class="font_normal11" style="margin-top:3px;">avg</div></div>',
			'<div class="grayBoxDivider" style="height:39px;width:1px;float:left;margin-top:0px;float:left"></div>',
			'<div style="width:48%;float:right;text-align:center"><div class="font_normal19">{Max}</div><div class="font_normal11" style="margin-top:3px;">max</div></div></div>',
			'</div>',
			'</tpl>',
			'</div>'			
		);
	}else{
		historyTpl1=new Ext.XTemplate(
			'<div class="widgetholders">',
			'<tpl for=".">',
			'<tpl if="xindex % 2 === 0">',
			'<div class="b_box " style="border:0px solid red;width:50%;padding:0 125 0 0 !important;float:left;">',
			'<tpl else>',
			'<div class="b_box " style="border:0px solid red;width:50%;padding:0 0 0 125 !important;float:left;">',
			'</tpl>',
			'<div class="font_normal9 fontStyleRobotRegular grayColor" style="padding:0px 0px 5px 0px"><span>{duration}</ span></div>',
			'<div style="padding-top:20px;height:65px;width:70%" class="chartminmax"><div style="width:100%;float:left;text-align:center">',
			//'<div class="font_normal19">{Sum}</div><div class="font_normal11" style="margin-top:3px;">sum</div></div>',
			'<div class="font_normal19">{Sum}</div></div>',
			//'<div style="width:50%;float:right;text-align:center"><div class="font_normal19">{Max}</div><div class="font_normal11" style="margin-top:3px;">max</div></div>',
			'</div>',
			'</div>',
			'</tpl>',
			'</div>'
		);
	}
	if(tempData.maxmin!=null && tempData.maxmin!=undefined)
	{
		var historyContainer1 = {
			xtype:'dataview',
			border:false,
			id:idObj+"_history_grid_id1",
			store: Ext.create('Ext.data.Store', {
				model: 'UxHistoryModel',
				autoLoad:true,
				data:tempData.maxmin
			}),
			tpl:historyTpl1
		};
		return historyContainer1;
	}
};
