Ext.define('widgets.StatusBar', {
	extend: 'Ext.container.Container',
	alias:'widget.statusbar',
	cls:'widgetcon',
	ui:'uniqueSessions',
	autoDestroy:true,
	border:false,
	margin:'0 0 0 10',
	//cls:'currentStatusChartBorder',
	onRender:function(){
		this.callParent(arguments);
	},
	refreshData:function(jsonData){
		if(!Ext.isEmpty(jsonData.chartData) && !Ext.isEmpty(jsonData.statesData)){
			var barJson =  new Array();
			var tpl = new Ext.XTemplate('<div class="current-status" style="margin-left:0px;height:11px;margin-bottom:7px;margin-top:1px">Current Status</div><div id="currentStatusBar" class="currentStatusBorder">',
						'<tpl for=".">',
							'<span style="width:{len};height:23px;" class="{classname}"><b style="visibility:hidden">{len}</b></span>',
						'</tpl>',
					'</div>');
			var htmlTag = '<table width="100%" style="margin:6px 0 0 0px"><tr>';
			//var htmlTag = '<div style="width:100%;border:0px solid green;" id="linearChartContainer"></div><table width="100%" style="margin:10px 0 0 0px"><tr>';
			for(var i=0;i<jsonData.statesData.length;i++){
				var text=jsonData.statesData[i].name;
				var link=jsonData.statesData[i].link;
				var cssClass=jsonData.statesData[i].cssClass;
				var cssClassIcon=jsonData.statesData[i].cssClassIcon;
				var percentage=jsonData.statesData[i].percentage;

				var str_percentage=""+percentage;
				if(str_percentage!=null && str_percentage.indexOf("<")>-1)
				{
					str_percentage = percentage;
					percentage = 0.0;
				}
				else if(percentage!=null && percentage!="")
				{
					percentage = Math.abs(percentage);
				}

				if(!Ext.isEmpty(link))
				{
					if(str_percentage!=null && str_percentage!="" && str_percentage.indexOf("<")>-1)
					{
						htmlTag +='<td ><a href="'+link+'"><span style="float:left;margin-right:4px;" data-qclass="yellowTip" data-qtip="'+text+" - "+str_percentage+'" class="'+cssClassIcon+'"></span><span >'+str_percentage+'</span></a></td>';
					}
					else
					{
						htmlTag +='<td ><a href="'+link+'"><span style="float:left;margin-right:4px;" data-qclass="yellowTip" data-qtip="'+text+" - "+percentage+' %" class="'+cssClassIcon+'"></span><span >'+percentage+' %</span></a></td>';
					}
				}
				else
				{
					if(str_percentage!=null && str_percentage!="" && str_percentage.indexOf("<")>-1)
					{
						htmlTag +='<td><span style="float:left;margin-right:4px" data-qclass="yellowTip" data-qtip="'+text+" - "+str_percentage+'" class="'+cssClassIcon+'"></span><span >'+str_percentage+'</span></td>';
					}
					else
					{
						htmlTag +='<td><span style="float:left;margin-right:4px" data-qclass="yellowTip" data-qtip="'+text+" - "+percentage+' %" class="'+cssClassIcon+'"></span><span >'+percentage+' %</span></td>';
					}
				}
				var p=percentage+'%';
				barJson.push({ len : p , classname : cssClass });
				text = null;
				delete text;

				link = null;
				delete link;

				cssClass = null;
				delete cssClass;

				p = null;
				delete p;

				percentage = null;
				delete percentage;
			}
			htmlTag += '</tr></table>';

			var generatedHtml = tpl.apply(barJson);
			this.update(generatedHtml+''+htmlTag);
				htmlTag = null;
			delete htmlTag;
			var bar = Ext.get('currentStatusBar');
			if(!Ext.isEmpty(bar)){
            bar.setWidth('0%');
            bar.setSize('100%',25, {duration:1000, easing:'bounceOut'});
			}
			linearChart = null;
			delete linearChart;

			jsonData = null;
			Ext.destroy(jsonData);
		}
		else{
			var emptyHtml = '<div style="color:#FFFFFF;align:center;text-align:center;padding-top:15px;">'
			+ '<div style="margin:auto;align:center;width:26px" class="iconTickSmall"></div>'
			+ 'No components have been enabled for monitoring'
			+ '</div>';
			this.update(emptyHtml);

			emptyHtml = null;
			delete emptyHtml;
		}
	}
});