Ext.define('TextWidgetModel', {
    extend: 'Ext.data.Model',
    fields: [
        { name:'state', type:'string' },
        { name:'heading', type:'string' },
        { name:'title', type:'string' },
        { name:'subtitle', type:'string' },
        { name:'value', type:'string' },
		{ name:'unit', type:'string' },
		{ name:'unitText', type:'string' },
		{ name:'footer', type:'string' },
		{ name:'fun', type:'string' },
		{ name:'legend', type:'string' },
		{ name:'graphType', type:'number' },
		{ name:'changeTabView', type:'string' },
		{ name:'linkurl', type:'string' },
		{ name:'test_org', type:'string' },
		{ name:'measure_org', type:'string' },
		{ name:'handSymbol', type:'string' },
		{ name:'spikeClass', type:'string' },
		{ name:'spikeData', type:'string' },
		{ name:'isUserTitle', type:'boolean' },
		{ name:'graphData' }
    ]
});

var textTpl=new Ext.XTemplate(
	'<div class="widgetholders">',
	'<tpl for=".">',
		'<div class="b_box">',
		  '<div class="font_bold12"><img style="vertical-align:sub" src="/final/images/clear.png" class="state_{state}" /> <span>{heading}</ span></div>',
'			<tpl if="graphType !=&quot; &quot;">',
				'<div class="font_normal31 d_m_t20" style="text-align:center">{value}',
				'<tpl if="unit !=&quot; &quot;">',
					'<span class="font_normal26">{unit}</span></div>',
				'</tpl>',
				'<div class="font_normal11 legendLabel" style="text-align:center">{legend}</div>',
				'<div id="graph-traffic" class="appflow_rum_graph" style="width:120px;height:35px;"></div>',
			'<tpl else>',
				'<div class="font_normal31 d_m_t35" style="text-align:center">{value}<span class="font_normal26">{unit}</span></div>',
				'<div class="font_normal11 legendLabel d_m_t20" style="text-align:center">{legend}</div>',
			'</tpl>',
		'</div>',
	'</tpl>',
	'</div>'
	);

 Ext.define('widgets.Text', {
		extend: 'Ext.container.Container',
		alias:'widget.text',
		//cls:'widgetcon',
		ui:'appflowtraffic',
		autoDestroy:true,
		data:'',
		id:'',
		store:null,
		items:[],
		updateData:function(data){
				var me = this;
				me.items.items[0].store.loadRawData(data);
				/*if(data.graphType != undefined && data.graphType != null && data.graphData != undefined && data.graphData != null){
					var jsonData = getHighChartsJSONforText(data,'','');
					$('#graph-traffic'+data.graphType).highcharts(jsonData);					
				}*/
		},
		items:[],
		listeners:{
			'afterrender':function(e){
				textTpl=new Ext.XTemplate(
					'<tpl for=".">',
					'<div class="widgetholders {handSymbol}" style="border:0px solid red">',					
						/*'<div style="1px solid red" class="s_box">',
							 '<div class="font_bold12 div_center trim_text" style="float:left;width:70%"><img style="vertical-align:sub" src="/final/images/clear.png" class="state_{state}" /> <span>{title}</span></div>',
							 '<div style="float:right;width:30%" class="div_center"><div  class="font_bold20" style="text-align:right;float:left">{value}</div><div class="font_normal11 trim_text" style="vertical-align:top;text-align:right;"> {footer}</div></div>',
							 '<div style="clear:both"></div>',
						 '</div>',*/
						'<div class="s_box">',
							'<div class="fontStyleRobotRegular font_bold12 div_center trim_text" style="float:left;width:65%">',
							'<tpl if="state">',
								'<img style="position: absolute;top: 0;bottom: 0;margin: auto;vertical-align:sub" src="/final/images/clear.png" class="stateSymbol_{state}" />',
									'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:20px;padding-top:2px;" data-qtip="{title}">{title}</ span></div>',
							'<tpl else>',
								'<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:0px;padding-top:2px;" data-qtip="{title}">{title}</ span></div>',
							'</tpl>',
							
							 '<div style="float:right;width:35%;text-align:right" class="div_center"><div  class="font_bold20" style="margin-right:3px;text-align:right;display:inline-block;line-height:18px">{value}</div><div class="font_normal10" style="line-height:18px;display:inline-block;text-align:left;vertical-align:top;padding-right:5px">{footer}{unitText}</div></div>',
						'</div>',
						'<div class="b_box" style="border:0px solid red" onclick=\"loadView(\'{changeTabView}\',\'{value}\',\'\',\'{test_org}\',\'{measure_org}\',\'{linkurl}\',\'true\');\">',
						  '<div class="fontStyleRobotRegular font_bold13 title">',
							'<tpl if="state">',	
								'<img style="vertical-align:sub" src="/final/images/clear.png" class="stateSymbol_{state}" />', 
								 '<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:20px;padding-top:2px;" data-qtip="{title}">{title}</ span></div>',
							'<tpl else>',
								  '<span style="display: inline-block; width: inherit;vertical-align: text-bottom;margin-left:0px;padding-top:2px;" data-qtip="{title}">{title}</ span></div>',
							'</tpl>',
							//'<tpl if="graphType !=&quot; &quot;">',
								//'<div class="fontStyleRobotRegular font_normal25 d_m_t35" style="text-align:center"><div style="margin:auto;display:inline-block;margin-top:-1px">{value}</div>',
								//'<tpl if="unitText !=&quot; &quot;">',
									//'<span class="font_normal21">{unitText}</span></div>',
								//'<tpl else>',
									//'</div>',
								//'</tpl>',
								//'<div class="font_normal11 legendLabel" style="text-align:center">{legend}</div>',
								//'<div id="graph-traffic'+this.data.graphType+'" class="appflow_rum_graph" style="width:120px;height:35px;"></div>',
							//'<tpl else>',
								 //subtitle
								/* '<tpl if="title==&quot;VMware VDI Servers&quot;"',
									'<div class="fontStyleRobotRegular font_normal24 d_m_t30" style="text-align:center"><div style="border:0px solid red;margin:auto;display:inline-block;margin-top:0px">',
								 '<tpl elseif="title==&quot;Delivery Groups&quot;"',
									'<div class="fontStyleRobotRegular font_normal24 d_m_t30" style="text-align:center"><div style="border:0px solid red;margin:auto;display:inline-block;margin-top:0px">',
								'<tpl else>',
									 '<div class="fontStyleRobotRegular font_normal24 d_m_t25" style="text-align:center"><div style="border:0px solid red;margin:auto;display:inline-block;margin-top:0px">',
								'</tpl>',*/
								
									 '<tpl  if="isUserTitle != undefined && isUserTitle">',
										'<div class="fontStyleRobotRegular font_normal24 d_m_t25" style="text-align:center"><div style="border:0px solid red;margin:auto;display:inline-block;margin-top:0px">',
											'<img src="/final/images/clear.png" class="iconCtxOverviewUsers" style="float:left;margin-top:1px;margin-right:8px"/><span style="margin-top:0px;float:left">{value}<span class="fontStyleRobotRegular font_normal19">{unitText}</span></span>',
									'<tpl elseif="title==&quot;Active Applications&quot;">', 
										 '<div class="fontStyleRobotRegular font_normal24 d_m_t25" style="text-align:center"><div style="border:0px solid red;margin:auto;display:inline-block;margin-top:0px">',
											'<img src="/final/images/clear.png" class="iconAppLaunch" style="float:left;margin-top:0px;margin-right:8px"/><span style="float:left">{value}<span class="margin-top:-7px;fontStyleRobotRegular font_normal19">{unitText}</span></span>',
									'<tpl elseif="title==&quot;Instances Launched&quot;">', 
										 '<div class="fontStyleRobotRegular font_normal24 d_m_t25" style="text-align:center"><div style="border:0px solid red;margin:auto;display:inline-block;margin-top:0px">',
											'<img src="/final/images/clear.png" class="iconAppLaunch" style="float:left;margin-top:-6px;margin-right:8px"/><span style="float:left">{value}<span class="margin-top:-7px;fontStyleRobotRegular font_normal19">{unitText}</span></span>',
									'<tpl elseif="title==&quot;IOPS&quot;">', 
										 '<div class="fontStyleRobotRegular font_normal24 d_m_t25" style="text-align:center"><div style="border:0px solid red;margin:auto;display:inline-block;margin-top:0px">',
											'<img src="/final/images/clear.png" class="iconCtxIops" style="float:left;margin-top:2px;margin-right:8px"/><span style="margin-top:0px;float:left">{value}<span class="fontStyleRobotRegular font_normal19">{unitText}</span></span>',
									'<tpl elseif="title==&quot;Memory&quot;">', 
										 '<div class="fontStyleRobotRegular font_normal24 d_m_t25" style="text-align:center"><div style="border:0px solid red;margin:auto;display:inline-block;margin-top:0px">',
											'<img src="/final/images/clear.png" class="iconCtxMemory" style="float:left;margin-top:2px;margin-right:8px"/><span style="margin-top:0px;float:left">{value}<span class="fontStyleRobotRegular font_normal19">{unitText}</span></span>',
									'<tpl elseif="title==&quot;CPU&quot;">', 
										 '<div class="fontStyleRobotRegular font_normal24 d_m_t25" style="text-align:center"><div style="border:0px solid red;margin:auto;display:inline-block;margin-top:0px">',
											'<img src="/final/images/clear.png" class="iconCtxCpu" style="float:left;margin-top:2px;margin-right:8px"/><span style="margin-top:0px;float:left">{value}<span class="fontStyleRobotRegular font_normal19">{unitText}</span></span>',
									'<tpl elseif="title==&quot;Instances&quot;">',
										 '<div class="fontStyleRobotRegular font_normal24 d_m_t25" style="text-align:center"><div style="border:0px solid red;margin:auto;display:inline-block;margin-top:0px">',
											'<img src="/final/images/clear.png" class="iconCtxInstances" style="float:left;margin-top:-4px;margin-right:8px"/><span style="float:left">{value}<span class="fontStyleRobotRegular font_normal19">{unitText}</span></span>',
									'<tpl elseif="title==&quot;Launched Recently&quot;">', 
										 '<div class="fontStyleRobotRegular font_normal24 d_m_t25" style="text-align:center"><div style="border:0px solid red;margin:auto;display:inline-block;margin-top:0px">',
											'<img src="/final/images/clear.png" class="iconAppLaunch" style="float:left;margin-top:0px;margin-right:8px"/><span style="margin-top:0px;float:left">{value}<span class="fontStyleRobotRegular font_normal19">{unitText}</span></span>',
									'<tpl elseif="title==&quot;Application Launch&quot;">', 
										 '<div class="fontStyleRobotRegular font_normal24 d_m_t25" style="text-align:center"><div style="border:0px solid red;margin:auto;display:inline-block;margin-top:0px">',
											'<img src="/final/images/clear.png" class="iconCtxAppLaunch" style="float:left;margin-top:3px;margin-right:8px"/><span style="margin-top:0px;float:left">{value}<span class="fontStyleRobotRegular font_normal19">{unitText}</span></span>',
									'<tpl elseif="title==&quot;XenApp Servers&quot;">', 
										 '<div class="fontStyleRobotRegular font_normal24 d_m_t25" style="text-align:center"><div style="border:0px solid red;margin:auto;display:inline-block;margin-top:10px">',
											'<img src="/final/images/clear.png" class="iconCtxXenapp" style="float:left;margin-top:2px;margin-right:8px"/><span style="float:left">{value}<span class="fontStyleRobotRegular font_normal19">{unitText}</span></span>',
									'<tpl elseif="title==&quot;VMware VDI Servers&quot;">', 
										 '<div class="fontStyleRobotRegular font_normal24 d_m_t25" style="text-align:center"><div style="border:0px solid red;margin:auto;display:inline-block;margin-top:10px">',
											'<img src="/final/images/clear.png" class="iconCtxXenapp" style="float:left;margin-top:2px;margin-right:8px"/><span style="float:left">{value}<span class="fontStyleRobotRegular font_normal19">{unitText}</span></span>',
									'<tpl elseif="title==&quot;Delivery Groups&quot;">', 
										 '<div class="fontStyleRobotRegular font_normal24 d_m_t25" style="text-align:center"><div style="border:0px solid red;margin:auto;display:inline-block;margin-top:10px">',
											'<img src="/final/images/clear.png" class="iconCtxDeliveryGroup" style="float:left;margin-top:2px;margin-right:8px"/><span style="float:left">{value}<span class="fontStyleRobotRegular font_normal19">{unitText}</span></span>',
									 '<tpl else>',
										'<span style="float:left">{value}<span class="fontStyleRobotRegular font_normal19">{unitText}</span></span>',
									'</tpl>',
								'</div>',
								'</div>',
								'<div class="crl"></div>',
								'<div class="font_normal11 legendLabel" style="text-align:center;margin-top:-4px">{footer}</div>',
							//'</tpl>',							
						'</div>',
						'<tpl if="spikeClass">',
							'<tpl if="spikeClass != &quot;GOOD&quot;">',
								'<a href="javascript:openAlarmPopup(\'{test_org}\',\'{measure_org}\',\'{spikeClass}\',\'true\',\'{spikeData}\')"><div class="b_box" style="position:absolute;bottom:16px;border:0px solid green !important;float:left;"><div class="outerbox"><div id="triangle-bottomleft"></div><div class="stateBookmark_{spikeClass} boxShadow"><img style="width:16px;height:16px;top: 0;bottom: 0;margin: auto;vertical-align:sub" src="/final/images/component_icons/svg/state_white_{spikeClass}.svg" style="opacity:10" /><span class="fontStyleRobotRegular font_normal12" style="margin-left:5px">{spikeData}</span></div></div></div></a>',
							'<tpl else>',
								'<div class="b_box" style="cursor:default;position:absolute;bottom:16px;border:0px solid green !important;float:left;"><div class="outerbox"><div id="triangle-bottomleft"></div><div class="stateBookmark_{spikeClass} boxShadow"><img style="width:16px;height:16px;top: 0;bottom: 0;margin: auto;vertical-align:sub" src="/final/images/component_icons/svg/state_white_{spikeClass}.svg" style="opacity:10" /><span class="fontStyleRobotRegular font_normal12" style="margin-left:5px">{spikeData}</span></div></div></div>',
							'</tpl>',
						'</tpl>',
					'</div>',
					'</tpl>'
				);
				var g_item = this.getTextItem(this.data,this.num,this.id,this);
				this.add(g_item);
			}
		},
		getTextItem : function(data1,iid,curId,me){
			var item={
				xtype:'dataview',
				emptyText:'No Data found!',
				deferEmptyText:false,
				store: Ext.create('Ext.data.Store', {
					id:this.id+'_store',
					model:'TextWidgetModel',
					autoLoad:true,
					data:data1
				}),
				tpl:textTpl,
				autoDestroy:true,
				trackOver:true,
				listeners:{
					viewready:function(x){
						var me = this;
						/*if(data1.graphType != undefined && data1.graphType != null && data1.graphData != undefined && data1.graphData != null){
							var jsonData = getHighChartsJSONforText(data1,curId);
							$('#graph-traffic'+data1.graphType).highcharts(jsonData); 
						}*/
					}
				}
			}
			return item;
		}		
 });
 /*
 .stateSymbol_HIGH, .stateSymbol_INTERMEDIATE, .stateSymbol_LOW, .stateSymbol_UNKNOWN, .stateSymbol_GOOD, .stateSymbol_GRAY
 */

function getHighChartsJSONforText(Jdata,Cid,iid){
	try
	{
		var lineChart = {};
		if(!Ext.isEmpty(Jdata.graphType) && Jdata.graphType == "Column"){
			lineChart = jQuery.extend(true, {},getSparkGraph(iid,50,150,'','','column'), lineChart);
		}else{
			lineChart = jQuery.extend(true, {},getSparkGraph(iid,50,150,'','','area'), lineChart);
		}
		lineChart.setData(Jdata.graphData,'','','','bottom');
		jsonData = lineChart.highchart;
	}
	catch (er)
	{
		jsonData = null;
	}
	return jsonData;
}

function mover(value)
{
	var grid = Ext.create('Ext.grid.Panel', {
			border: 1,
			id:'user_grid',
			hideHeaders:true,
			scroll:true,
			autoScroll:true,
			style: {
				borderColor: 'transparent',
				borderWidth :'1px',
				borderStyle: 'solid'
			},
			columnLines : true,
			ui:'eg-grid-skin',
			store: new  Ext.create('Ext.data.Store', {
				fields: ["User"],
				data:[{"User":"eguser"},{"User":"xauser1"},{"User":"xauser2"}]
			}),
			viewConfig: {
				emptyText: 'No Data Found',
				deferEmptyText: false,
			},
			columns:[{"dataIndex":"User"}]
		});

	var win = Ext.create('Ext.window.Window', {
			title: 'Users',
			height: 200,
			width: 200,
			//shadow:true,
			scroll:false,
			autoScroll:false,
			modal: true,
			ghost: false,
			id:'windowValue',
			//selectedValue:val,
			closeAction: "destroy",
			constrain: true,
			closable:true,
			layout:'fit',
			items: grid
		}).show();
}
